/*
 *   Handling routines for LED lightening functions
 *
 *  Copyright (c) 2017 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */

#define _8192CD_LED_C_

#include "./8192cd_cfg.h"
#include "./8192cd.h"
#include "./8192cd_headers.h"
#include "./8192cd_debug.h"
//WNC
#include <linux/gpio.h>

#if defined(CONFIG_WLAN_HAL_8198F)
#include <linux/gpio/consumer.h>
struct rtk_gpio_data{
	struct device		*dev;
	struct gpio_desc	*dev_wps_gpio;
	struct gpio_desc	*dev_wifi_gpio;
	struct gpio_desc	*dev_reset_gpio;
#ifdef CONFIG_ARCH_RTL8198F
	struct gpio_desc	*dev_sys_led_gpio;
	struct gpio_desc	*dev_wifi_2G_led_gpio;
#endif
};
extern struct rtk_gpio_data *rtk_gpio;
#endif

#if defined(SUPPORT_UCFGING_LED) 
struct timer_list	LED_TimerCFGING;
unsigned int		LED_CFGING_Interval;
unsigned char		LED_CFGING_Toggle;
unsigned char		LED_CFGING_ToggleStart;
unsigned int 		LED_Configuring=0;
#endif

/* WNC-NMR1610-MIKE-YEH-20160503-The Spider are sending beacon after AP connection lost. */
extern void stopBeaconTx(void);

//API for AERO
#define RTL_LED_R32(addr)		(*(volatile unsigned long *)(addr))
//WNC-JDR230-MRXXXX-Jimmy-20160804, Add to write register correctly
#if 0
#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#else
#define RTL_LED_W32(addr, l)		\
do {						\
	((*(volatile unsigned long*)(addr)) = (l));	\
	int round = 0;	\
	while (1)	\
	{	\
		if (l != (RTL_LED_R32(addr)))	\
			((*(volatile unsigned long*)(addr)) = (l));	\
		else	\
			break;	\
			\
		if (++round > 10000) {	\
					printk("%s[%d] LED while (1) goes too many\n", __FUNCTION__, __LINE__);	\
					break;	\
				}	\
	}	\
} while(0)
#endif


#ifdef __OSK__
#ifdef WIFI_SW_LED  
extern struct rtl8192cd_priv *wifi_root_priv;
void rtl8192cd_LED_SW(u8 on) 
{
	if(wifi_root_priv){
		if(on)
			control_wireless_led(wifi_root_priv,1);
		else
			control_wireless_led(wifi_root_priv,0);
	}
	return;
}

void rtl8192cd_get_LED_control()
{
	if(wifi_root_priv){
		control_wireless_led(wifi_root_priv,0);
	}
}

void rtl8192cd_release_LED_control()
{
	if(wifi_root_priv){
		control_wireless_led(wifi_root_priv,2);
	}
}
#endif
#endif

#if defined(CONFIG_RTL_8197F)
#if defined(CONFIG_OPENWRT_SDK) || defined(__LINUX_2_6__)
#include <bspchip.h>
#elif defined(__ECOS)
#include <cyg/hal/bspchip.h>
#elif !defined(__OSK__)
#include <bsp/bspchip.h>
#endif
#if !defined(__ECOS) && !defined(__OSK__)
#include <linux/gpio.h>
#endif
#endif

//WNC LED control
static int rpt_act_led_state = 0;
static int tv_led_state = 0;
static int led_state = 0;
//WNC-NMR1565-D2R030-Yuan-I-Chou-20160407-Ignore second OFF LED flag in force LED off mode
//WNC-NMR1572-D2R030-Yuan-I-Chou-20160414-Separate 2.4G and 5G LED off flag
static int force_2g_led_off_state = 0;
static int force_5g_led_off_state = 0;
//WNC-NMR1572-D2R030-Yuan-I-Chou-20160414-Separate 2.4G and 5G LED off flag Enc


// for SW LED ----------------------------------------------------
#ifdef RTL8190_SWGPIO_LED
static void set_swGpio_LED(struct rtl8192cd_priv *priv, unsigned int ledNum, int flag)
{
	unsigned int ledItem;	/* parameter to decode GPIO item */

	if (ledNum >= SWLED_GPIORT_CNT)
		return;

	ledItem = SWLED_GPIORT_ITEM(LED_ROUTE, ledNum);

	if (ledItem & SWLED_GPIORT_ENABLEMSK)
	{
		/* get the corresponding information (GPIO number/Active high or low) of LED */
		int gpio;
		int activeMode;	/* !=0 : Active High, ==0 : Active Low */

		gpio = ledItem & SWLED_GPIORT_RTBITMSK;
		activeMode = ledItem & SWLED_GPIORT_HLMSK;

		if (flag) {	/* Turn ON LED */
			if (activeMode)	/* Active High */
				RTL_W8(0x90, RTL_R8(0x90) | BIT(gpio));
			else			/* Active Low */
				RTL_W8(0x90, RTL_R8(0x90) &~ BIT(gpio));
		}
		else {	/* Turn OFF LED */
			if (activeMode)	/* Active High */
				RTL_W8(0x90, RTL_R8(0x90) &~ BIT(gpio));
			else			/* Active Low */
				RTL_W8(0x90, RTL_R8(0x90) | BIT(gpio));
		}
	}
}
#endif // RTL8190_SWGPIO_LED


static void set_sw_LED0(struct rtl8192cd_priv *priv, int flag)
{
#if defined(CONFIG_RTL8672) && defined(CONFIG_LEDPWR_PBC)
	extern unsigned int ledpwr_toggle_flag;
	if(ledpwr_toggle_flag==0 && flag==LED_ON)//led power off
		return;
#endif

#ifdef RTL8190_SWGPIO_LED
    if (LED_ROUTE)
        set_swGpio_LED(priv, 0, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
    if(GET_CHIP_VER(priv) == VERSION_8822B) {
        if(flag) // led off
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF) | BIT8);
        else  //led on
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF));   
    }
    else if (GET_CHIP_VER(priv) == VERSION_8812F) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0)));
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
    else if (GET_CHIP_VER(priv) == VERSION_8814B) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0))); 
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
	else if (GET_CHIP_VER(priv) == VERSION_8814A) {
		if (flag)
			RTL_W8(LEDCFG+1, (RTL_R8(LEDCFG+1) | BIT(3)));
		else
			RTL_W8(LEDCFG+1, RTL_R8(LEDCFG+1) & 0xF7);
	}
#if defined(CONFIG_RTL_8197F) && defined(__OSK__)
	else if(GET_CHIP_VER(priv) == VERSION_8197F) {
        if(flag) /* led off*/
            set_97F_24G_LED(0/*off*/);
        else  /*led on*/
            set_97F_24G_LED(1/*on*/);   
    }
#endif	
    else if (flag)
        RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffffff0) | LED0SV);
    else
        RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffffff0);
#else
    if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)||(GET_CHIP_VER(priv) == VERSION_8192F)) {
        #ifdef RTLWIFINIC_GPIO_CONTROL
        if (flag)
            RTLWIFINIC_GPIO_write_proc(priv, 5, 0);
        else
            RTLWIFINIC_GPIO_write_proc(priv, 5, 1);
        #endif
    }
    else if ((GET_CHIP_VER(priv) == VERSION_8812E)) {
        if (flag)
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
        else
            RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
    }
#if defined(CONFIG_WLAN_HAL_8814AE)
	else if (GET_CHIP_VER(priv) == VERSION_8814A) {
		if (flag)
			RTL_W8(LEDCFG+1, (RTL_R8(LEDCFG+1) | BIT(3)));
		else
			RTL_W8(LEDCFG+1, RTL_R8(LEDCFG+1) & 0xF7);
	}
#endif	
    else if (GET_CHIP_VER(priv) == VERSION_8881A) {
        #ifndef __OSK__
        if (flag)
            writel(readl(IO_TYPE_CAST(0xb800350c)) | BIT(24), IO_TYPE_CAST(0xb800350c));
        else
            writel(readl(IO_TYPE_CAST(0xb800350c)) & ~BIT(24), IO_TYPE_CAST(0xb800350c));
        #else
        setWlan5gLed(flag);/*tony 20150203: we should use gpio api, avoid gpio abnormal behavior.*/
        #endif
    }    
    #if defined(CONFIG_RTL_8197F) && !defined(__ECOS)
    else if(GET_CHIP_VER(priv) == VERSION_8197F) {
        if(flag) /* led off*/
            gpio_set_value(BSP_GPIO_PIN_E1, 1);
        else  /*led on*/
            gpio_set_value(BSP_GPIO_PIN_E1, 0);   
    }
    #endif
    #if defined(CONFIG_WLAN_HAL_8822BE) 
    else if(GET_CHIP_VER(priv) == VERSION_8822B) {
        if(flag) /* led off*/
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF) | BIT8);
        else  /*led on*/
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF));   
    }
    #endif   
	#if defined(CONFIG_WLAN_HAL_8198F) && !defined(__ECOS)
    else if(GET_CHIP_VER(priv) == VERSION_8198F) {
        if(flag) /* led off*/
            gpiod_set_value(rtk_gpio->dev_wifi_2G_led_gpio, 0);
        else  /*led on*/
            gpiod_set_value(rtk_gpio->dev_wifi_2G_led_gpio, 1);
    }
    #endif       
#if defined(CONFIG_WLAN_HAL_8812FE)  
    else if (GET_CHIP_VER(priv) == VERSION_8812F) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0)));
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
#endif      
#if defined(CONFIG_WLAN_HAL_8814BE)  
    else if (GET_CHIP_VER(priv) == VERSION_8814B) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0)));
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
#endif      
    else {
        if (flag)
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffffff0) | LED0SV);
        else
            RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffffff0);
    }
#endif
}


static void set_sw_LED1(struct rtl8192cd_priv *priv, int flag)
{
#if defined(CONFIG_RTL8672) && defined(CONFIG_LEDPWR_PBC)
	extern unsigned int ledpwr_toggle_flag;
	if(ledpwr_toggle_flag==0 && flag==LED_ON)//led power off
		return;
#endif

#ifdef RTL8190_SWGPIO_LED
	if (LED_ROUTE)
		set_swGpio_LED(priv, 1, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
    if ((GET_CHIP_VER(priv) == VERSION_8812F) || (GET_CHIP_VER(priv) == VERSION_8814B)) {
        //do nothing
    }else if (flag)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
	else
		RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
#else
	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)||(GET_CHIP_VER(priv) == VERSION_8192F)) {
#ifdef RTLWIFINIC_GPIO_CONTROL
		if (flag)
			RTLWIFINIC_GPIO_write_proc(priv, 5, 0);
		else
			RTLWIFINIC_GPIO_write_proc(priv, 5, 1);
#endif		
	}
#if defined(CONFIG_RTL_92D_SUPPORT)
	else if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV_92D);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
	}
#endif	
	else if (GET_CHIP_VER(priv) == VERSION_8192C){
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfffff0ff) | LED1SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfffff0ff);
	}
#endif
}


static void set_sw_LED2(struct rtl8192cd_priv *priv, int flag)
{
#if defined(CONFIG_RTL8672) && defined(CONFIG_LEDPWR_PBC)
	extern unsigned int ledpwr_toggle_flag;
	if(ledpwr_toggle_flag==0 && flag==LED_ON)//led power off
		return;
#endif

#ifdef RTL8190_SWGPIO_LED
	if (LED_ROUTE)
		set_swGpio_LED(priv, 2, flag);
#elif defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
	if(GET_CHIP_VER(priv) == VERSION_8822B) {
        if(flag) // led off
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF) | BIT8);
        else  //led on
            RTL_W32(0x60, (RTL_R32(0x60) & 0xFFFFFEFF));   
    }
    else if (GET_CHIP_VER(priv) == VERSION_8812F) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0)));
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
    else if (GET_CHIP_VER(priv) == VERSION_8814B) {
        if(flag) /* led off*/
            RTL_W8(0x62, (RTL_R8(0x62) & (~BIT0)));
        else  /*led on*/
            RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    }
	else if (GET_CHIP_VER(priv) == VERSION_8814A) {
		if (flag)
			RTL_W8(LEDCFG+1, (RTL_R8(LEDCFG+1) | BIT(3)));
		else
			RTL_W8(LEDCFG+1, RTL_R8(LEDCFG+1) & 0xF7);
	}
	else if (flag)
		RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV);
	else
		RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
#else

	if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)||(GET_CHIP_VER(priv) == VERSION_8192F)) {
#ifdef RTLWIFINIC_GPIO_CONTROL
		if (flag)
			RTLWIFINIC_GPIO_write_proc(priv, 5, 0);
		else
			RTLWIFINIC_GPIO_write_proc(priv, 5, 1);
#endif		
	}
#if defined(CONFIG_RTL_92D_SUPPORT)
	else if (GET_CHIP_VER(priv) == VERSION_8192D) {
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV_92D);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
	}
#endif	
	else if (GET_CHIP_VER(priv) == VERSION_8192C){
		if (flag)
			RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & 0xfff0ffff) | LED2SV);
		else
			RTL_W32(LEDCFG, RTL_R32(LEDCFG) & 0xfff0ffff);
	}
#endif
}

//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
#define GN_5G_LED_G 29	//low active
#define GN_2G_LED_G 30	//low active
#define GN_2G_LED_R 56
#define GN_5G_LED_R 57
#define GN_TV_LED_R 23
#define GN_TV_LED_G 28	//low active

#define RTL_GPIOC7 (1<<23)
#define RTL_GPIOD4 (1<<28)
#define RTL_GPIOD5 (1<<29)
#define RTL_GPIOD6 (1<<30)
#define RTL_GPIOH0 (1<<24)
#define RTL_GPIOH1 (1<<25)

#define REG32(reg)      (*(volatile unsigned int *)(reg))
#define PABCD_DAT		0xB800350C
#define PEFGH_DAT		0xB8003528

static void set_sw_LED(struct rtl8192cd_priv *priv, int flag)
{
	//printk("set_sw_LED [%s] [%d]\n", priv->dev->name, flag);

	//ON = 0, OFF = 1
	//if (GET_CHIP_VER(priv) == VERSION_8197F) {
	if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G) {
		//printk("rpt_act_led_state [%d] priv->pshare->cnv_rpt_mode [%d]\n", rpt_act_led_state, priv->pshare->cnv_rpt_mode);
		
		if (priv->pshare->cnv_rpt_mode == 1) {
			//CNV or RPT mode
			if (rpt_act_led_state == 0) {
				//Not connected
				flag = 1;
				//OFF LED
			}
			//WNC-D2R030-NMR1708-YUAN-I-CHOU-20160812, Add new LED judgment
			else {				
				//2.4G or 5G is connected.
				if (IS_DRV_OPEN(GET_VXD_PRIV(GET_ROOT(priv)))) {
					//Only check this in VXD interface
					if ((GET_VXD_PRIV(GET_ROOT(priv))->pmib->dot11OperationEntry.opmode & 
						(WIFI_STATION_STATE | WIFI_ASOC_STATE)) 
						!= (WIFI_STATION_STATE | WIFI_ASOC_STATE)) {
						//2.4G didn't connect to AP.
						if (!IS_DRV_OPEN(GET_ROOT(priv)->pvap_priv[0])) {
							//VAP0 is not enabled.
							//--> We should OFF 2.4G LED.
							//printk("[%s] [%d]\n", __func__, __LINE__);
							flag = 1;
							//OFF LED
						} else {
							//printk("[%s] [%d]\n", __func__, __LINE__);
						}
					}
				}
			}
			//WNC-D2R030-NMR1708-YUAN-I-CHOU-20160812, Add new LED judgment End
		}
		//WNC-NMR1565-D2R030-Yuan-I-Chou-20160407-Ignore second OFF LED flag in force LED off mode
		//Prevent interference between LED control function and this function.
		//WNC-NMR1572-D2R030-Yuan-I-Chou-20160414-Separate 2.4G and 5G LED off flag
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		if ((priv->pshare->LED_force_off == 1) || (priv->pshare->LOS_LED_off == 1)) {
		//if (priv->pshare->LED_force_off == 1) {
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
			if (force_2g_led_off_state == 0) {
				//OFF LED
				flag = 1;
				force_2g_led_off_state = 1;
			} else {
				//Already OFF LED, return here.
				return;
			}
		} else {
			if (force_2g_led_off_state == 1) {
				//Recover flag.
				force_2g_led_off_state = 0;
			}
		}

		//2.4G
		//printk("2G [%d] flag[%d]\n", priv->pshare->rssi_led_flag, flag);
		switch (priv->pshare->rssi_led_flag) {
			case 0: //RT, AP mode, or RootAP is not connected in CNV/RPT mode
			case 3: // High signal strength
				//Green LED only, turn OFF Red LED
				//__gpio_set_value(GN_2G_LED_R, 0);
				//REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(RTL_GPIOH0)));
				RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));//2.4G Red
				if (!flag) { //ON
					//__gpio_set_value(GN_2G_LED_G, 0);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD6))));//2.4G Green
				}
				else { //OFF
					//__gpio_set_value(GN_2G_LED_G, 1);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD6)));//2.4G Green
				}
				break;
			case 2: // Middle signal strength
				if (!flag) { //ON
					//__gpio_set_value(GN_2G_LED_G, 0);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD6))));//2.4G Green
					//__gpio_set_value(GN_2G_LED_R, 1);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) | (RTL_GPIOH0)));//2.4G Red
				}
				else { //OFF
					//__gpio_set_value(GN_2G_LED_G, 1);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD6)));//2.4G Green
					//__gpio_set_value(GN_2G_LED_R, 0);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));//2.4G Red
				}
				break;
			case 1: // Low signal strength
				//Red LED only, turn OFF Green LED
				//__gpio_set_value(GN_2G_LED_G, 1);
				RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD6)));//2.4G Green
				
				if (!flag) { //ON
					//__gpio_set_value(GN_2G_LED_R, 1);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) | (RTL_GPIOH0)));//2.4G Red
				}
				else { //OFF
					//__gpio_set_value(GN_2G_LED_R, 0);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));//2.4G Red
				}
				break;
			default:
				//WTF!!?
				break;
		}
	}
	//if (GET_CHIP_VER(priv) == VERSION_8822B) {
	if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {

		//printk("rpt_act_led_state [%d] priv->pshare->cnv_rpt_mode [%d]\n", rpt_act_led_state, priv->pshare->cnv_rpt_mode);
		
		if (priv->pshare->cnv_rpt_mode == 1) {
			//CNV or RPT mode
			if (rpt_act_led_state == 0) {
				//Not connected
				flag = 1;
				//OFF LED
			}
			//WNC-D2R030-NMR1708-YUAN-I-CHOU-20160812, Add new LED judgment
			else {
				//2.4G or 5G is connected.
				if (IS_DRV_OPEN(GET_VXD_PRIV(GET_ROOT(priv)))) {
					//Only check this in VXD interface
					if ((GET_VXD_PRIV(GET_ROOT(priv))->pmib->dot11OperationEntry.opmode & 
						(WIFI_STATION_STATE | WIFI_ASOC_STATE)) 
						!= (WIFI_STATION_STATE | WIFI_ASOC_STATE)) {
						//5G didn't connect to AP.
						if (!IS_DRV_OPEN(GET_ROOT(priv)->pvap_priv[0])) {
							//VAP0 is not enabled.
							//--> We should OFF 5G LED.
							//printk("[%s] [%d]\n", __func__, __LINE__);
							flag = 1;
							//OFF LED
						} else {
							//printk("[%s] [%d]\n", __func__, __LINE__);
						}
					}
				}
			}
			//WNC-D2R030-NMR1708-YUAN-I-CHOU-20160812, Add new LED judgment End
		}

		//WNC-NMR1565-D2R030-Yuan-I-Chou-20160407-Ignore second OFF LED flag in force LED off mode
		//Prevent interference between LED control function and this function.
		//WNC-NMR1572-D2R030-Yuan-I-Chou-20160414-Separate 2.4G and 5G LED off flag
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		if ((priv->pshare->LED_force_off == 1) || (priv->pshare->LOS_LED_off == 1)) {
		//if (priv->pshare->LED_force_off == 1) {
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
			if (force_5g_led_off_state == 0) {
				//OFF LED
				flag = 1;
				force_5g_led_off_state = 1;
			} else {
				//Already OFF LED, return here.
				return;
			}
		} else {
			if (force_5g_led_off_state == 1) {
				//Recover flag.
				force_5g_led_off_state = 0;
			}
		}

//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior
		if (led_state == 1) {
			//Don't do anything if we are in DFS LED blinking state.
			return;
		}
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior End

		//5G
		//printk("5G [%d]\n", priv->pshare->rssi_led_flag);
		switch (priv->pshare->rssi_led_flag) {
			case 0: //RT, AP mode, or RootAP is not connected in CNV/RPT mode
			case 3: // High signal strength
				//Green LED only, turn OFF Red LED

				//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140807, modify 5G red LED off condition.
				if (led_state == 0) {
				//NOT in DFS red LEDs blink mode
				//If we turn off 5G red LED during DFS red LEDs blink mode, would cause strange LED behavior
					//__gpio_set_value(GN_5G_LED_R, 0);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));//5G Red
				}

				if (!flag) { //ON
					//__gpio_set_value(GN_5G_LED_G, 0);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD5))));//5G Green
				}
				else { //OFF
					//__gpio_set_value(GN_5G_LED_G, 1);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD5)));//5G Green
				}
				break;
			case 2: // Middle signal strength
				if (!flag) { //ON
					//__gpio_set_value(GN_5G_LED_G, 0);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD5))));//5G Green
					//__gpio_set_value(GN_5G_LED_R, 1);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) | (RTL_GPIOH1)));//5G Red
				}
				else { //OFF
					//__gpio_set_value(GN_5G_LED_G, 1);
					RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD5)));//5G Green
					//__gpio_set_value(GN_5G_LED_R, 0);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));//5G Red
				}
				break;
			case 1: // Low signal strength
				//Red LED only, turn OFF Green LED
				//__gpio_set_value(GN_5G_LED_G, 1);
				RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD5)));//5G Green
				if (!flag) { //ON
					//__gpio_set_value(GN_5G_LED_R, 1);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) | (RTL_GPIOH1)));//5G Red
				}
				else { //OFF
					//__gpio_set_value(GN_5G_LED_R, 0);
					RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));//5G Red
				}
				break;
			default:
				//WTF!!?
				break;
		}
	}
}

static void LED_Interval_timeout(unsigned long task_priv)
{
	struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;

	if (!(priv->drv_state & DRV_STATE_OPEN))
		return;
	if (!priv->pshare->set_led_in_progress) {
		set_sw_LED(priv, priv->pshare->LED_Toggle);
	}
//	if (priv->pshare->LED_force_off == 1) {
//		set_sw_LED(priv, 1);
//	}
	if (priv->pshare->LED_Toggle)
		mod_timer(&priv->pshare->LED_Timer, jiffies + RTL_MILISECONDS_TO_JIFFIES(50));
	else
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);

	priv->pshare->LED_Toggle = (priv->pshare->LED_Toggle + 1) % 2;
}

#if 0
static void LED_Interval_timeout(unsigned long task_priv)
{
    struct rtl8192cd_priv *priv = (struct rtl8192cd_priv *)task_priv;
    int led_on_time= LED_ON_TIME;

#ifdef CONFIG_WIFI_LED_SHARED
	if ((!(priv_led && priv_led_o)) || (!(priv_led->drv_state & DRV_STATE_OPEN) && !(priv_led_o->drv_state & DRV_STATE_OPEN)))
	{
		mod_timer(&priv->pshare->LED_Timer, jiffies + LED_NOBLINK_TIME);
		return;
	}
#else
    if (!(priv->drv_state & DRV_STATE_OPEN))
        return;
#endif

#ifdef PCIE_POWER_SAVING
    if ((priv->pwr_state != L1) && (priv->pwr_state != L2))
#elif defined(PCIE_POWER_SAVING_TEST) 
    if ((priv->pwr_state != L1) && (priv->pwr_state != L2))        
#endif
    {
        if (!priv->pshare->set_led_in_progress) {
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
            #ifdef CONFIG_RTL_88E_SUPPORT
            if (GET_CHIP_VER(priv) == VERSION_8188E)
                set_sw_LED2(priv, priv->pshare->LED_Toggle);
            else
            #endif
            #if defined(CONFIG_WLAN_HAL_8192EE) || defined(CONFIG_WLAN_HAL_8192FE)
            if ((GET_CHIP_VER(priv) == VERSION_8192E) || (GET_CHIP_VER(priv) == VERSION_8192F))
                set_sw_LED0(priv, priv->pshare->LED_Toggle);
            else
            #endif
            #if defined(CONFIG_RTL_8812_SUPPORT) || defined(CONFIG_WLAN_HAL_8814AE)
            if (GET_CHIP_VER(priv) == VERSION_8812E || GET_CHIP_VER(priv)==VERSION_8814A)
                set_sw_LED1(priv, priv->pshare->LED_Toggle);
            else
            #endif
#endif // CONFIG_RTL8672 || NOT_RTK_BSP
            if ((LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
                (LED_TYPE == LEDTYPE_SW_LINKTXRXDATA) ||
                (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA) ||
                ((LED_TYPE == LEDTYPE_SW_ADATA_GDATA) && (priv->pshare->curr_band == BAND_5G)) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D) ||
                (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
                (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D))
            {
                if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D) ||
                    (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D))
                    set_sw_LED2(priv, priv->pshare->LED_Toggle);
                else if (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D)
                    set_sw_LED1(priv, priv->pshare->LED_Toggle);
                else
                    set_sw_LED0(priv, priv->pshare->LED_Toggle);
            } else {
                set_sw_LED1(priv, priv->pshare->LED_Toggle);
            }
		}
	}

    if( (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) && 
        (!(OPMODE & WIFI_ASOC_STATE)))  //client not assco  , mark_led
    {		
        led_on_time = LED_NOBLINK_TIME;
    }

    if ( priv->pshare->LED_Toggle == priv->pshare->LED_ToggleStart) {
        mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
    } else {
        if 	(LED_TYPE == LEDTYPE_SW_CUSTOM1)
            mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
        else
            mod_timer(&priv->pshare->LED_Timer, jiffies + led_on_time); 
    }

    priv->pshare->LED_Toggle = (priv->pshare->LED_Toggle + 1) % 2;
}
//WNC wireless LED
#endif

/* WNC-NMR0000-JOE-PENG-20190618-Implement section 4.5.2.6 FW rescue function of Alicia model-start */
#ifdef CONFIG_FW_RESCUE
extern int is_rescue_fw_start(); /* extern from rtl_gpio.c */
#endif /* CONFIG_FW_RESCUE */
/* WNC-NMR0000-JOE-PENG-20190618-Implement section 4.5.2.6 FW rescue function of Alicia model-end */

//WNC wireless LED
void enable_sw_LED(struct rtl8192cd_priv *priv, int init)
{
/* WNC-NMR0000-JOE-PENG-20190618-Implement section 4.5.2.6 FW rescue function of Alicia model-start */
#ifdef CONFIG_FW_RESCUE
	if( is_rescue_fw_start() == 1 ){
		/* DUT will turn on all red LED once rescue firmware is started. */
		/* At this time, DUT does not accept controlling wireless LED. */
		printk("Not accept controlling wireless LED once rescue firmware is started.\n");
		return;
	}
#endif /* CONFIG_FW_RESCUE */
/* WNC-NMR0000-JOE-PENG-20190618-Implement section 4.5.2.6 FW rescue function of Alicia model-end */

	if (timer_pending(&priv->pshare->LED_Timer)) {
		printk("SW LED is already opened\n");
		return;
	}

	printk("%s enable_sw_LED init=[%d]\n", priv->dev->name, init);
	priv->pshare->LED_Interval = RTL_MILISECONDS_TO_JIFFIES(50);
	priv->pshare->LED_Toggle = 0;
	priv->pshare->LED_ToggleStart = LED_OFF;
	priv->pshare->LED_tx_cnt_log = 0;
	priv->pshare->LED_rx_cnt_log = 0;
	priv->pshare->LED_tx_cnt = 0;
	priv->pshare->LED_rx_cnt = 0;

	set_sw_LED(priv, LED_ON);

	priv->pshare->LED_ToggleStart = LED_ON;

	if (init) {
		init_timer(&priv->pshare->LED_Timer);
		priv->pshare->LED_Timer.expires = jiffies + priv->pshare->LED_Interval;
		priv->pshare->LED_Timer.data = (unsigned long) priv;
		priv->pshare->LED_Timer.function = &LED_Interval_timeout;
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	}
}

#if 0
void enable_sw_LED(struct rtl8192cd_priv *priv, int init)
{
#if defined(SUPPORT_UCFGING_LED) 

    if(init){
        if(LED_Configuring ==1)
            return;
    }
#endif	
#if (defined(HW_ANT_SWITCH) || defined(SW_ANT_SWITCH))&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
    int b23 = RTL_R32(LEDCFG) & BIT(23);
#endif

#ifdef CONFIG_WIFI_LED_SHARED
	priv = priv_led;
#endif

    if (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) 
        if (!(OPMODE & WIFI_STATION_STATE)) // if it is not Client mode , then run orignal 12 type
            LED_TYPE = LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA ;  
	     
	// configure mac to use SW LED
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
    #ifdef CONFIG_RTL_88E_SUPPORT
    if (GET_CHIP_VER(priv) == VERSION_8188E)
        RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
    else
    #endif
    #ifdef CONFIG_WLAN_HAL_8192EE
    if (GET_CHIP_VER(priv) == VERSION_8192E) {
        if (LED_TYPE != LEDTYPE_SW_LED_DO_NOTHING) {
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFFFFFF00) | LED0SV);
        } else {
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFFFFFF7F)); 
		}
	} else
    #endif
    #ifdef CONFIG_WLAN_HAL_8192FE
    if (GET_CHIP_VER(priv) == VERSION_8192F) {
        if (LED_TYPE != LEDTYPE_SW_LED_DO_NOTHING) {
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&~(LED0CM_Mask|LED0DIS)) | LED0SV | BIT21 | LED0PL);
        } else {
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&~LED0DIS) | BIT21 | LED0PL); 
		}
	} else
    #endif
#else // !CONFIG_RTL8672 && !NOT_RTK_BSP

	#if defined(CONFIG_RTL_88E_SUPPORT) || defined(CONFIG_WLAN_HAL_8192EE) || defined(CONFIG_WLAN_HAL_8192FE)/*mark_ecos	*/
    if ((GET_CHIP_VER(priv) == VERSION_8188E)||(GET_CHIP_VER(priv) == VERSION_8192E)||(GET_CHIP_VER(priv) == VERSION_8192F))
    {
        #ifdef RTLWIFINIC_GPIO_CONTROL
        RTLWIFINIC_GPIO_config_proc(priv, 5, 0x10);
        #endif
    }
    else 
    #endif
#endif // CONFIG_RTL8672 || NOT_RTK_BSP
    if (GET_CHIP_VER(priv) == VERSION_8812E)
        RTL_W32(LEDCFG, BIT(13) | LED1SV);
    else
    #if defined(CONFIG_WLAN_HAL_8881A)
    if (GET_CHIP_VER(priv) == VERSION_8881A) {
        writel(readl(IO_TYPE_CAST(0xb8000044)) | BIT(15) | BIT(16), IO_TYPE_CAST(0xb8000044));
        writel(readl(IO_TYPE_CAST(0xb8003500)) & ~BIT(24), IO_TYPE_CAST(0xb8003500));
        writel(readl(IO_TYPE_CAST(0xb8003508)) | BIT(24), IO_TYPE_CAST(0xb8003508));
        #ifndef __OSK__
        writel(readl(IO_TYPE_CAST(0xb800350c)) | BIT(24), IO_TYPE_CAST(0xb800350c));
        #else
        setWlan5gLed(LED_OFF);/*tony 20150203: we should use gpio api, avoid gpio abnormal behavior.*/
        #endif
    } else
    #endif
	#ifdef CONFIG_WLAN_HAL_8814AE
	if (GET_CHIP_VER(priv) == VERSION_8814A) {
		RTL_W8(LEDCFG+1, (RTL_R8(LEDCFG+1)&0x70) | BIT(3));
	} else
	#endif
#if defined(CONFIG_RTL_8197F)
    if (GET_CHIP_VER(priv) == VERSION_8197F) {
#if defined(__OSK__)
		enable_97F_24G_LED();
		set_97F_24G_LED(0/*LED_OFF*/);
#elif !defined(__ECOS)
	  int err;
        #if defined(__LINUX_3_10__)
        err = gpio_request_one(BSP_GPIO_PIN_E1, GPIOF_OUT_INIT_HIGH | GPIOF_EXPORT_DIR_FIXED, "2G Wifi");
	  #else
		if((err = gpio_request_one(BSP_GPIO_PIN_E1, GPIOF_OUT_INIT_HIGH, "2G Wifi")) == 0)
			err = gpio_export(BSP_GPIO_PIN_E1, false);
	  #endif
        if(err) {
            printk("gpio request error(%d)\n", err);
        }
#endif
    } else
    #endif
    #if defined(CONFIG_WLAN_HAL_8822BE)  
    if (GET_CHIP_VER(priv) == VERSION_8822B) {
        RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & (~LED2EN)));
        RTL_W32(0x60, (RTL_R32(0x60) | BIT16 | BIT24));
    } else
    #endif    
#if defined(CONFIG_WLAN_HAL_8812FE)  
    if (GET_CHIP_VER(priv) == VERSION_8812F) {
        RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & (~LED2EN)));
        RTL_W8(0x61, (RTL_R8(0x61) & (~BIT0)));
        RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    } else
#endif   
#if defined(CONFIG_WLAN_HAL_8814BE)  
    if (GET_CHIP_VER(priv) == VERSION_8814B) {
        RTL_W32(GPIO_MUXCFG, (RTL_R32(GPIO_MUXCFG) & (~BIT20)));
        RTL_W32(LEDCFG, (RTL_R32(LEDCFG) & (~LED2EN)));
        RTL_W8(0x61, (RTL_R8(0x61) & (~BIT0)));
        RTL_W8(0x62, (RTL_R8(0x62) | BIT0));
    } else
#endif   
	{
        if (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX)
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
        else if (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA)
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | LED2EN | LED2SV);
        #ifdef CONFIG_RTL_92D_SUPPORT
        else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D) ||
                 (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D))
            RTL_W32(LEDCFG,(RTL_R32(LEDCFG)&0xFF00FFFF)| LED2DIS_92D | LED2SV_92D);
        else if (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D)
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFFFF00FF)|LED1DIS_92D | LED1SV_92D); 	
        #endif
        else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
                 (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
                 (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) || 	
                 (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA))
            RTL_W32(LEDCFG, (RTL_R32(LEDCFG)&0xFF00FFFF) | GP8_LED | LED2EN | LED2SV);
        else
            RTL_W32(LEDCFG, LED2SV | LED1SV | LED0SV);
    }

#ifdef CONFIG_WIFI_LED_SHARED
	if (init == 1)
#endif
	{
        priv->pshare->LED_Interval = LED_INTERVAL_TIME;
        priv->pshare->LED_Toggle = 0;
        priv->pshare->LED_ToggleStart = LED_OFF;
        priv->pshare->LED_tx_cnt_log = 0;
        priv->pshare->LED_rx_cnt_log = 0;
        priv->pshare->LED_tx_cnt = 0;
        priv->pshare->LED_rx_cnt = 0;
	}

    if ((LED_TYPE == LEDTYPE_SW_ENABLE_TXRXDATA) ||
        (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA)) {
        if (!priv->pshare->set_led_in_progress) {
            set_sw_LED0(priv, LED_ON);
            set_sw_LED1(priv, LED_OFF);
        }

        if (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA)
			priv->pshare->LED_ToggleStart = LED_ON;
    } else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA) ||
               (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_ENABLETXRXDATA_92D)) {
        set_sw_LED2(priv, LED_ON);
        priv->pshare->LED_ToggleStart = LED_ON;
    } else if (LED_TYPE == LEDTYPE_SW_ADATA_GDATA) {
        priv->pshare->LED_ToggleStart = LED_ON;
        if (priv->pshare->curr_band == BAND_5G) {
            set_sw_LED0(priv, LED_ON);
            set_sw_LED1(priv, LED_OFF);
        }
        else {	// 11G
            set_sw_LED0(priv, LED_OFF);
            set_sw_LED1(priv, LED_ON);
        }
    }
    else if (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA_1) {
        set_sw_LED0(priv, LED_OFF);
        set_sw_LED1(priv, LED_ON);
        priv->pshare->LED_ToggleStart = LED_ON;
    }
    else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
             (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) ) {
        set_sw_LED2(priv, LED_ON);
        priv->pshare->LED_ToggleStart = LED_ON;
    }
    else if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
             (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
             (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA)) {
        set_sw_LED2(priv, LED_OFF);
    }
	else if (LED_TYPE == LEDTYPE_SW_LED_DO_NOTHING) {
		/* do nothing */
	}
    else {
        set_sw_LED0(priv, LED_OFF);
        set_sw_LED1(priv, LED_OFF);
        set_sw_LED2(priv, LED_OFF);
    }

    #if (defined(HW_ANT_SWITCH) || defined(SW_ANT_SWITCH))&&( defined(CONFIG_RTL_92C_SUPPORT) || defined(CONFIG_RTL_92D_SUPPORT))
    RTL_W32(LEDCFG, b23 | RTL_R32(LEDCFG));
    #endif

	if (init == 1) {
        init_timer(&priv->pshare->LED_Timer);
        #if defined(CONFIG_PCI_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_PCIE) {
	        priv->pshare->LED_Timer.data = (unsigned long) priv;
	        priv->pshare->LED_Timer.function = &LED_Interval_timeout;
		}
		#endif
        #if defined(CONFIG_USB_HCI) || defined(CONFIG_SDIO_HCI)
		if (GET_HCI_TYPE(priv) == RTL_HCI_USB || GET_HCI_TYPE(priv) == RTL_HCI_SDIO) {
	        priv->pshare->LED_Timer.data = (unsigned long) &priv->pshare->LED_Timer_event;
	        priv->pshare->LED_Timer.function = timer_event_timer_fn;
	        INIT_TIMER_EVENT_ENTRY(&priv->pshare->LED_Timer_event,
	        LED_Interval_timeout, (unsigned long)priv);
		}
        #endif

        if (LED_TYPE != LEDTYPE_SW_LED_DO_NOTHING)
            mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
    }
}
#endif
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End

#if defined(SUPPORT_UCFGING_LED) 
void LED_Interval_timeout2(unsigned long task_priv)
{

#ifdef RTLWIFINIC_GPIO_CONTROL
		RTLWIFINIC_GPIO_write(5, LED_CFGING_Toggle);
#endif		
	mod_timer(&LED_TimerCFGING, jiffies + LED_UCFGING_TIME); 
	LED_CFGING_Toggle = (LED_CFGING_Toggle + 1) % 2;		
}

void StartCFGINGTimer(void )
{
	
	init_timer(&LED_TimerCFGING);
	LED_TimerCFGING.data = 0;
	LED_TimerCFGING.function = &LED_Interval_timeout2;
	LED_CFGING_Interval = LED_UCFGING_TIME;
	LED_CFGING_Toggle = 0;
	LED_CFGING_ToggleStart = LED_OFF;
	mod_timer(&LED_TimerCFGING, jiffies + LED_CFGING_Interval);
}
#endif

void disable_sw_LED(struct rtl8192cd_priv *priv
#ifdef CONFIG_WIFI_LED_SHARED
    , int deltimer
#endif
){
#ifdef CONFIG_WIFI_LED_SHARED
	if (!deltimer)
	{
		if ((priv_led ? (priv_led->drv_state & DRV_STATE_OPEN):0) || (priv_led_o ? (priv_led_o->drv_state & DRV_STATE_OPEN):0) )
		{
	    	return;
		}
		priv = priv_led;
	}
#endif

    if ((LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ENABLETXRXDATA) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA)) {
#if defined(CONFIG_RTL8672) || defined(NOT_RTK_BSP)
#ifdef CONFIG_WLAN_HAL_8192FE
	if (GET_CHIP_VER(priv) == VERSION_8192F)
		set_sw_LED0(priv, LED_OFF);
#endif
#endif
	set_sw_LED2(priv, LED_OFF);
    } else if (LED_TYPE == LEDTYPE_SW_LED_DO_NOTHING) {
        //do nothing
    } else {
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
	printk("%s disable_sw_LED\n", priv->dev->name);
	set_sw_LED(priv, LED_OFF);
	//set_sw_LED0(priv, LED_OFF);
	//set_sw_LED1(priv, LED_OFF);
	//set_sw_LED2(priv, LED_OFF);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
    }
 
#ifdef CONFIG_WIFI_LED_SHARED
	if (deltimer)
#endif
    if (timer_pending(&priv->pshare->LED_Timer))
        del_timer_sync(&priv->pshare->LED_Timer);
}

//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
void calculate_sw_LED_interval(struct rtl8192cd_priv *priv)
{
	unsigned int delta = 0;
	int i, scale_num=0;

	if (priv->pshare->set_led_in_progress)
		return;

	// calculate counter delta
	delta += UINT32_DIFF(priv->pshare->LED_tx_cnt, priv->pshare->LED_tx_cnt_log);
	delta += UINT32_DIFF(priv->pshare->LED_rx_cnt, priv->pshare->LED_rx_cnt_log);
	priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt;
	priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;

	// update interval according to delta
	if (delta == 0) {
		if (priv->pshare->LED_Interval == LED_NOBLINK_TIME)
			mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
		else
			priv->pshare->LED_Interval = LED_NOBLINK_TIME;

		set_sw_LED(priv, LED_ON);
	} else {
		priv->pshare->LED_Interval = RTL_MILISECONDS_TO_JIFFIES(50);
	}
}

#if 0
void calculate_sw_LED_interval(struct rtl8192cd_priv *priv)
{
    unsigned int delta = 0;
    int i, scale_num=0;

#ifdef CONFIG_WIFI_LED_SHARED
	if (priv != priv_led){
		if (!priv_led || (priv_led->drv_state & DRV_STATE_OPEN)){
		    return;
		}
		priv = priv_led;
	}
#endif

    if (priv->pshare->set_led_in_progress)
        return;

#if defined(SUPPORT_UCFGING_LED) 
    if(LED_Configuring ==1)
        return;
#endif	

    if( (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_ASOCTXRXDATA) && 
         (!(OPMODE & WIFI_ASOC_STATE)))  //client not assco  , mark_led
    {        
        priv->pshare->LED_Interval = LED_NOBLINK_TIME; // force one second
        priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt; // sync tx/rx cnt
        priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;      
        return ;
    }

    // calculate counter delta
#ifdef CONFIG_WIFI_LED_SHARED
	if (priv_led->drv_state & DRV_STATE_OPEN)
	{
		delta += UINT32_DIFF(priv_led->pshare->LED_tx_cnt, priv_led->pshare->LED_tx_cnt_log);
		delta += UINT32_DIFF(priv_led->pshare->LED_rx_cnt, priv_led->pshare->LED_rx_cnt_log);
		priv_led->pshare->LED_tx_cnt_log = priv_led->pshare->LED_tx_cnt;
		priv_led->pshare->LED_rx_cnt_log = priv_led->pshare->LED_rx_cnt;
	}
	
	if (priv_led_o->drv_state & DRV_STATE_OPEN)
	{
		delta += UINT32_DIFF(priv_led_o->pshare->LED_tx_cnt, priv_led_o->pshare->LED_tx_cnt_log);
		delta += UINT32_DIFF(priv_led_o->pshare->LED_rx_cnt, priv_led_o->pshare->LED_rx_cnt_log);
		priv_led_o->pshare->LED_tx_cnt_log = priv_led_o->pshare->LED_tx_cnt;
		priv_led_o->pshare->LED_rx_cnt_log = priv_led_o->pshare->LED_rx_cnt;		
	}
#else
    delta += UINT32_DIFF(priv->pshare->LED_tx_cnt, priv->pshare->LED_tx_cnt_log);
    delta += UINT32_DIFF(priv->pshare->LED_rx_cnt, priv->pshare->LED_rx_cnt_log);
    priv->pshare->LED_tx_cnt_log = priv->pshare->LED_tx_cnt;
    priv->pshare->LED_rx_cnt_log = priv->pshare->LED_rx_cnt;
#endif

    // update interval according to delta
    if (delta == 0) {
        if (LED_TYPE == LEDTYPE_SW_CUSTOM1) {
            if (priv->pshare->LED_Interval != RTL_SECONDS_TO_JIFFIES(1)) {
                priv->pshare->LED_Interval = RTL_SECONDS_TO_JIFFIES(1);
                mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
            }
        } else {
            if (priv->pshare->LED_Interval == LED_NOBLINK_TIME)
                mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
            else {
                priv->pshare->LED_Interval = LED_NOBLINK_TIME;
                if (LED_TYPE == LEDTYPE_SW_ENABLETXRXDATA)
                    priv->pshare->LED_Toggle = LED_ON;
            }
        }
    } else {
        if ((priv->pmib->dot11BssType.net_work_type & WIRELESS_11G) ||
            (priv->pmib->dot11BssType.net_work_type & WIRELESS_11A))
            scale_num = LED_MAX_PACKET_CNT_AG / LED_MAX_SCALE;
        else
            scale_num = LED_MAX_PACKET_CNT_B / LED_MAX_SCALE;

        if ((LED_TYPE == LEDTYPE_SW_LINK_TXRX) ||
            (LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
            (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
            (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
            (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
            (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
            (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D) ||
            (LED_TYPE == LEDTYPE_SW_CUSTOM1))
            scale_num = scale_num*2;

        for (i=1; i<=LED_MAX_SCALE; i++) {
            if (delta < i*scale_num)
                break;
        }

        if (priv->pshare->rf_ft_var.ledBlinkingFreq > 1) {
            i = i*priv->pshare->rf_ft_var.ledBlinkingFreq;
            if (i > LED_MAX_SCALE)
                i = LED_MAX_SCALE;
        }

        priv->pshare->LED_Interval = ((LED_MAX_SCALE-i+1)*LED_INTERVAL_TIME)/LED_MAX_SCALE;

        if (priv->pshare->LED_Interval < LED_ON_TIME)
            priv->pshare->LED_Interval = LED_ON_TIME;
    }

    if ((LED_TYPE == LEDTYPE_SW_LINKTXRX) ||
        (LED_TYPE == LEDTYPE_SW_LINKTXRXDATA) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRX) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO8_LINKTXRXDATA) ||
        (LED_TYPE == LEDTYPE_SW_LED1_GPIO9_LINKTXRX_92D) ||
        (LED_TYPE == LEDTYPE_SW_LED2_GPIO10_LINKTXRX_92D)) {

#ifdef CONFIG_WIFI_LED_SHARED
		if (priv_led->link_status || priv_led_o->link_status)
#else
        if (priv->link_status)
#endif
            priv->pshare->LED_ToggleStart = LED_ON;
        else
            priv->pshare->LED_ToggleStart = LED_OFF;
    } else {
        if (priv->pshare->set_led_in_progress)
            return;

        if ((LED_TYPE == LEDTYPE_SW_LINK_TXRX) ||
            (LED_TYPE == LEDTYPE_SW_LINK_TXRXDATA)) {
            if (priv->link_status)
                set_sw_LED0(priv, LED_ON);
            else
                set_sw_LED0(priv, LED_OFF);
        } else if (LED_TYPE == LEDTYPE_SW_ADATA_GDATA) {
            if (priv->pshare->curr_band == BAND_5G) {
                set_sw_LED0(priv, LED_ON);
                set_sw_LED1(priv, LED_OFF);
            } else {	// 11A
                set_sw_LED0(priv, LED_OFF);
                set_sw_LED1(priv, LED_ON);
            }
        }
    }
}
#endif
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End

#if 0

void set_wireless_LED_steady_on(int led_num, struct net_device *dev)
{
	struct rtl8192cd_priv *priv;

	if (led_num != LED_0 && led_num != LED_1 && led_num != LED_2)
		return;

#ifdef NETDEV_NO_PRIV
	if (dev == NULL || netdev_priv(dev) == NULL)
		return;

	priv = ((struct rtl8192cd_priv *)netdev_priv(dev))->wlan_priv;
#else
	if (dev == NULL || dev->priv == NULL)
		return;

	priv = (struct rtl8192cd_priv *)dev->priv;
#endif

#ifdef CONFIG_WIFI_LED_SHARED
	priv = priv_led;
#endif

	if (priv->pshare == NULL)
		return;

	priv->pshare->set_led_in_progress = 1;

	if ((LED_TYPE >= LEDTYPE_HW_TX_RX) && (LED_TYPE <= LEDTYPE_HW_LINKACT_INFRA)) {
		enable_sw_LED(priv, 0);
	}
	else if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
#ifndef CONFIG_WIFI_LED_SHARED
		if (timer_pending(&priv->pshare->LED_Timer))
			del_timer_sync(&priv->pshare->LED_Timer);
#endif
	}

	if (led_num == LED_0)
		set_sw_LED0(priv, LED_ON);
	else if (led_num == LED_1)
		set_sw_LED1(priv, LED_ON);
	else
		set_sw_LED2(priv, LED_ON);
}


void recover_wireless_LED(struct net_device *dev)
{
	struct rtl8192cd_priv *priv;

#ifdef NETDEV_NO_PRIV
	if (dev == NULL || netdev_priv(dev) == NULL)
		return;
	
	priv = ((struct rtl8192cd_priv *)netdev_priv(dev))->wlan_priv;
#else
	if (dev == NULL || dev->priv == NULL)
		return;

	priv = (struct rtl8192cd_priv *)dev->priv;
#endif

#ifdef CONFIG_WIFI_LED_SHARED
	priv = priv_led;
#endif

	if (!priv->pshare->set_led_in_progress)
		return;

	// for HW/SW LED
	if ((LED_TYPE >= LEDTYPE_HW_TX_RX) && (LED_TYPE <= LEDTYPE_HW_LINKACT_INFRA)) {
		set_sw_LED0(priv, LED_OFF);
		set_sw_LED1(priv, LED_OFF);
		set_sw_LED2(priv, LED_OFF);
		enable_hw_LED(priv, LED_TYPE);
	}
	else if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
		enable_sw_LED(priv, 0);
		mod_timer(&priv->pshare->LED_Timer, jiffies + priv->pshare->LED_Interval);
	}

	priv->pshare->set_led_in_progress = 0;
}
#endif


void control_wireless_led(struct rtl8192cd_priv *priv, int enable)
{
#ifdef CONFIG_WIFI_LED_SHARED
	priv = priv_led;
#endif
	if (enable == 0) {
		priv->pshare->set_led_in_progress = 1;
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, LED_OFF);
		//set_sw_LED1(priv, LED_OFF);
		//set_sw_LED2(priv, LED_OFF);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
//WNC-NMR1905-D2R030-YUAN-I-CHOU-20161110, OFF DFD LEDs while 5G interface bring down only
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support
		if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
			dfsoff_5g_redled(priv);
			//printk("%s %d\n",  __FUNCTION__, __LINE__);
		}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support End
//WNC-NMR1905-D2R030-YUAN-I-CHOU-20161110, OFF DFD LEDs while 5G interface bring down only End
	}
	else if (enable == 1) {
		priv->pshare->set_led_in_progress = 1;
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, LED_ON);
		//set_sw_LED1(priv, LED_ON);
		//set_sw_LED2(priv, LED_ON);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
	}
	else if (enable == 2) {
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED
		//set_sw_LED0(priv, priv->pshare->LED_ToggleStart);
		//set_sw_LED1(priv, priv->pshare->LED_ToggleStart);
		//set_sw_LED2(priv, priv->pshare->LED_ToggleStart);
//WNC-JDR230-NMRXXXX-YUAN-I-CHOU-20140522, Add wireless LED End
		priv->pshare->set_led_in_progress = 0;
	}
#if defined(__ECOS) && (defined(CONFIG_CUTE_MAHJONG) || defined(CONFIG_RTL_ULINKER))
	else if (enable == 3) {
		unsigned int saved_led_in_progress=priv->pshare->set_led_in_progress;
		priv->pshare->set_led_in_progress = 1;
		
		writel(readl(IO_TYPE_CAST(0xb8000044)) & (~(BIT(15) | BIT(16))), IO_TYPE_CAST(0xb8000044));
	
		//switch to hw led
		priv->pshare->set_led_in_progress = saved_led_in_progress;		
	}
	else if (enable == 4) {
		unsigned int saved_led_in_progress=priv->pshare->set_led_in_progress; 
		priv->pshare->set_led_in_progress = 1;
		writel(readl(IO_TYPE_CAST(0xb8000044)) | BIT(15) | BIT(16), IO_TYPE_CAST(0xb8000044));
		writel(readl(IO_TYPE_CAST(0xb8003500)) & (~BIT(24)), IO_TYPE_CAST(0xb8003500));	
 		writel(readl(IO_TYPE_CAST(0xb8003508)) | BIT(24), IO_TYPE_CAST(0xb8003508)); 
		//switch to sw led
		priv->pshare->set_led_in_progress = saved_led_in_progress;
	}			
#endif
}


#ifdef CONFIG_RTL_ULINKER
static struct rtl8192cd_priv *root_priv = NULL;

void enable_sys_LED(struct rtl8192cd_priv *priv)
{
#ifdef RTLWIFINIC_GPIO_CONTROL
	RTLWIFINIC_GPIO_config(4, 0x10);
#endif
	root_priv = priv;
}


void renable_sw_LED(void)
{
	struct rtl8192cd_priv *priv = root_priv;

	if ((LED_TYPE >= LEDTYPE_SW_LINK_TXRX) && (LED_TYPE < LEDTYPE_SW_MAX)) {
		priv->pshare->set_led_in_progress = 1;
#ifdef CONFIG_WIFI_LED_SHARED
		disable_sw_LED(priv, 0);
#else
		disable_sw_LED(priv);
#endif
		priv->pshare->set_led_in_progress = 0;
#ifdef CONFIG_WIFI_LED_SHARED
		enable_sw_LED(priv, 0);
#else
		enable_sw_LED(priv, 1);
#endif
	}
}

#endif /* #ifdef CONFIG_RTL_ULINKER */

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140210, move to 8192cd_led.c
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support
//static int led_state = 0;

#define REG32(reg)      (*(volatile unsigned int *)(reg))
#define PABCD_DIR 0xB8003508
#define PEFGH_DIR 0xB8003524

void dfsblink_5g_redled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	//WNC-NMR410-JDR230-YUAN-I-CHOU-20130429, LED blinks while CAC_enable
	if ((led_state == 0) && priv->pmib->dot11DFSEntry.CAC_enable) {

		//Disable 5G Green / TV Green LED by setting DIR
		//REG32(PABCD_DIR) = (REG32(PABCD_DIR) & (~(1<<23)));
		//REG32(PEFGH_DIR) = (REG32(PEFGH_DIR) & (~(1<<0)));
		//gpio_direction_input(GN_5G_LED_G);
		//gpio_direction_input(GN_TV_LED_G);
		//REG32(PABCD_DIR) = (REG32(PABCD_DIR) & (~((RTL_GPIOD4 | RTL_GPIOD5))));
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior
		//RTL_LED_W32(PABCD_DIR, (RTL_LED_R32(PABCD_DIR) & (~(RTL_GPIOD4 | RTL_GPIOD5))));

/*
		//Switch 5G Green LED to INPUT mode
		RTL_LED_W32(PABCD_DIR, (RTL_LED_R32(PABCD_DIR) & (~RTL_GPIOD5)));

		//Turn OFF TV Green
		led.gpio = 12;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
*/
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior End

		printk("Blink 5G Red LED. \n");
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior
		//Cancel 5G red and TV red LED control first
		led.gpio = 6;
		led.on = 0;
		led.off = 0;
		led.blinks = 0;
		led.rests = 0;
		led.times = 0;
		rl_gpio_led_set(led);
		led.gpio = 13;
		led.on = 0;
		led.off = 0;
		led.blinks = 0;
		led.rests = 0;
		led.times = 0;
		rl_gpio_led_set(led);
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior End
		led.gpio = 16;
		led.on = 5;
		led.off = 5;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		led_state = 1;
	}
}

//WNC-NMR893-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period
//Move from below
#define RTL_GPIOE0 (1<<0)

void dfsoff_5g_redled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (led_state == 1) {

		//Enable 5G Green / TV Green LED by setting DIR
		//REG32(PABCD_DIR) = (REG32(PABCD_DIR) | (1<<23));
		//REG32(PEFGH_DIR) = (REG32(PEFGH_DIR) | (1<<0));
		//REG32(PABCD_DIR) = (REG32(PABCD_DIR) & (RTL_GPIOD4 | RTL_GPIOD5));
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior
		//RTL_LED_W32(PABCD_DIR, (RTL_LED_R32(PABCD_DIR) | (RTL_GPIOD4 | RTL_GPIOD5)));

		//Switch 5G Green LED to OUTPUT mode
		//RTL_LED_W32(PABCD_DIR, (RTL_LED_R32(PABCD_DIR) | (RTL_GPIOD5)));
//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior End
		//gpio_direction_output(GN_5G_LED_G, 0);
		//gpio_direction_output(GN_TV_LED_G, 0);

		printk("OFF 5G RED LED\n");
		//Cancel combination control
		led.gpio = 16;
		led.on = 0;
		led.off = 0;
		led.blinks = 0;
		led.rests = 0;
		led.times = 0;
		rl_gpio_led_set(led);
		led.gpio = 6;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		led.gpio = 13;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
		led.gpio = 12;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);

//WNC-NMR893-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		if ((priv->pshare->LED_force_off == 0) && (priv->pshare->LOS_LED_off == 0)) {
		//if (priv->pshare->LED_force_off == 0) {
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
			if (tv_led_state > 0) {
				//TV LED should be ON
				//__gpio_set_value(GN_TV_LED_G, 0);
				//REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(RTL_GPIOD4)));
	//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior
				//RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD4))));
				//Turn ON TV LED
				led.gpio = 12;
				led.on = 4000;
				led.off = 0;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
	//WNC-NMR2015-D2R030-YUAN-I-CHOU-20161110, Fine tune DFS 5G red LED blinking behavior End
			}
		}
//WNC-NMR893-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period End

		led_state = 0;
	}
}

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130323, add DFS LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130712, add WISP LED support
static int act_led_state = 0;

void wispblink_act_greenled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (act_led_state == 0) {
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL
#ifdef CONFIG_WNC_MODEL
		//printk("CONFIG_WNC_MODEL [%s] \n", CONFIG_WNC_MODEL);
		if (memcmp(CONFIG_WNC_MODEL, "rnrk-n3-cl", 11) == 0) {
			printk("Blink ACT ORANGE LED. \n");
			led.gpio = 10;
		} else {
			printk("Blink ACT GREEN LED. \n");
			led.gpio = 1;
		}
#else
		printk("Blink ACT GREEN LED. \n");
		led.gpio = 1;
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL End
		led.on = 2;
		led.off = 2;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		act_led_state = 1;
	}
}

void wispoff_act_greenled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (act_led_state == 1) {
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL
#ifdef CONFIG_WNC_MODEL
		//printk("CONFIG_WNC_MODEL [%s] \n", CONFIG_WNC_MODEL);
		if (memcmp(CONFIG_WNC_MODEL, "rnrk-n3-cl", 11) == 0) {
			printk("OFF ACT ORANGE LED\n");
			led.gpio = 10;
		} else {
			printk("OFF ACT GREEN LED\n");
			led.gpio = 1;		
		}
#else
		printk("OFF ACT GREEN LED\n");
		led.gpio = 1;
#endif
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131106, Modify LED behavior for Pocket 2 CL End
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		act_led_state = 0;
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130712, add WISP LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131217, add Repeater LED support

//WNC, Linear doesn't have this Spec.
#if 0

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Blink orange ACT while Auth, turn on while get IP.
void rptblink_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

	if (rpt_act_led_state == 0) {
		printk("%s BLINK ACT ORANGE LED\n", __func__);
		led.gpio = 10;
		led.on = 2;
		led.off = 2;
		led.blinks = 4000;
		led.rests = 0;
		led.times = 4000;
		//rl_gpio_led_set(led);
		rpt_act_led_state = 1;
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Blink orange ACT while Auth, turn on while get IP End
#endif

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140609, turn ON ACT Green while connect to AP.
void rpton_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

//WNC-NMR676-JDR230-YUAN-I-CHOU-20140618, Don't turn on Repeater connected LED while forced DHCP server mode
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
	if ((priv->pshare->LED_force_off == 1) || (priv->pshare->LOS_LED_off == 1)) {
	//if (priv->pshare->LED_force_off == 1) {
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
		//Don't trigger ACT LED while forced DHCP server mode.
//WNC-NMR2035-D2R030-YUAN-I-CHOU-20161110, Restore ACT / TV LED if STA reconnects to AP in force led OFF mode
		if (rpt_act_led_state == 0)
			rpt_act_led_state = 1;
//WNC-NMR2035-D2R030-YUAN-I-CHOU-20161110, Restore ACT / TV LED if STA reconnects to AP in force led OFF mode End
		return;
	}
//WNC-NMR676-JDR230-YUAN-I-CHOU-20140618, Don't turn on Repeater connected LED while forced DHCP server mode End
//WNC-NMR1433-D2R030-YUAN-I-CHOU-20160309, Spider Spec. 2G link -> Green ACT, 5G link -> Orange ACT
	if (rpt_act_led_state == 0) {
		//if (GET_CHIP_VER(priv) == VERSION_8197F) {
		if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G) {
			printk("TURN ON ACT GREEN LED\n");
			led.gpio = 1;
			led.on = 4000;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
		}
		//if (GET_CHIP_VER(priv) == VERSION_8822B) {
		if (priv->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
			printk("TURN ON ACT ORANGE LED\n");
			led.gpio = 1;
			led.on = 4000;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 0;
			led.on = 4000;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
		}
		rpt_act_led_state = 1;
	}
}

void rptoff_act_orangeled (struct rtl8192cd_priv *priv){
	rl_gpio_led_info led;

//WNC-NMR1433-D2R030-YUAN-I-CHOU-20160309, Spider Spec. 2G link -> Green ACT, 5G link -> Orange ACT
	if (rpt_act_led_state == 1) {


/* WNC-NMR1610-MIKE-YEH-20160503-The Spider are sending beacon after AP connection lost. */
		stopBeaconTx();


//WNC-NMR1608-D2R030-YUAN-I-CHOU-20160503, Turn OFF Orange ACT LED no matter 2G or 5G.
#if 0
		if (GET_CHIP_VER(priv) == VERSION_8197F) {
			printk("TURN OFF ACT GREEN LED\n");
			led.gpio = 1;
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
		}
		if (GET_CHIP_VER(priv) == VERSION_8822B) {
#endif
			printk("TURN OFF ACT LED\n");
			led.gpio = 1;
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 0;
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
//		}//WNC-NMR1608-D2R030-YUAN-I-CHOU-20160503, Turn OFF Orange ACT LED no matter 2G or 5G.
		rpt_act_led_state = 0;

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20141120, Turn OFF 2G 5G LED when ACT turn OFF.
		//Besides set flag to LED OFF, Turn OFF LEDs in here, too!
		//__gpio_set_value(GN_2G_LED_G, 1);
		//__gpio_set_value(GN_2G_LED_R, 0);
		//__gpio_set_value(GN_5G_LED_G, 1);
		//__gpio_set_value(GN_5G_LED_R, 0);
		RTL_LED_W32(PEFGH_DAT, (RTL_LED_R32(PEFGH_DAT) & (~(RTL_GPIOH0 | RTL_GPIOH1))));
		//REG32(PEFGH_DAT) = (REG32(PEFGH_DAT) & (~(RTL_GPIOH0 | RTL_GPIOH1)));
		RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD6 | RTL_GPIOD5)));
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20141120, Turn OFF 2G 5G LED when ACT turn OFF End.
	}
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140609, turn ON ACT Green while connect to AP End.
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131217, add Repeater LED support End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140210, move to 8192cd_led.c End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140618, TV LED
//WNC-NMR893-JDR230-YUAN-I-CHOU-20150113, restore TV LED behavior after CAC period

//flag : 0 = TV mode enable / disable
//flag : 1 = TV mode auto-enable / auto-disable
//flag : 2 = ECMv2 STA connected in 5G or not, STA general flag
//flag : 100 = Force OFF TV LED when interface off

void tv_led_ongreen (struct rtl8192cd_priv *priv, int flag){
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED.
	rl_gpio_led_info led;
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED End.

//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
//WNC-NMR2170, 2190-D2R030-YUAN-I-CHOU-20161209, Don't turn ON TV LED in CAC enabled state
	if ((priv->pshare->LED_force_off == 1) || (priv->pshare->LOS_LED_off == 1) || (led_state == 1)) {
	//if ((priv->pshare->LED_force_off == 1) || (priv->pshare->LOS_LED_off == 1)) {
//WNC-NMR2170, 2190 -D2R030-YUAN-I-CHOU-20161209, Don't turn ON TV LED in CAC enabled state End
	//if (priv->pshare->LED_force_off == 1) {
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
		//Don't trigger TV LED while forced DHCP server mode.
		//tv_led_state should be updated !
		//tv_led_state = 0;
		tv_led_state |= (1<<flag);
		return;
	}

	//printk("ON flag [%d] tv_led_state [%d]\n", flag, tv_led_state);
	if (tv_led_state == 0) {
		// LED is OFF state
		//printk("tv_led_ongreen [%s]\n", priv->dev->name);
		//__gpio_set_value(GN_TV_LED_G, 0);
		//REG32(PABCD_DAT) = (REG32(PABCD_DAT) & (~(RTL_GPIOD4)));
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED.
		//RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) & (~(RTL_GPIOD4))));//Turn ON TV LED
		led.gpio = 12;
		led.on = 4000;
		led.off = 0;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED End.
	}
	tv_led_state |= (1<<flag);
	//printk("ON tv_led_state [%d]\n", tv_led_state);
	//Add flag into state

	return;
}

void tv_led_offgreen (struct rtl8192cd_priv *priv, int flag){
	int i = 0;
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED.
	rl_gpio_led_info led;
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED End.

	//printk("[%s] OFF flag [%d] tv_led_state [%d]\n", priv->dev->name, flag, tv_led_state);

	//WNC-NMR1716-D2R030-YUAN-I-CHOU-20160719, Turn OFF TV LED if all wireless interfaces are OFF
	if (flag == 100) {
		for (i = 0; i < 2 ; i++) {
			if (wlan_device[i].priv && (wlan_device[i].priv != GET_ROOT(priv))) {
				//Other radio's root interface
				//printk("[%s %d] %s\n", __func__, __LINE__, wlan_device[i].priv->dev->name);
				if (!(wlan_device[i].priv->drv_state & DRV_STATE_OPEN)) {
					//printk("[%s %d]\n", __func__, __LINE__);
					//Other radio's root interface doesn't OPEN, and we receive flag 100.
					//Turn OFF TV LED.
					tv_led_state = 0;
					//__gpio_set_value(GN_TV_LED_G, 1);
					//REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (RTL_GPIOD4));
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED.
					//RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD4)));//Turn OFF TV LED.
					led.gpio = 12;
					led.on = 0;
					led.off = 4000;
					led.blinks = 1;
					led.rests = 0;
					led.times = 4000;
					rl_gpio_led_set(led);
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED End.
					return;
				}
			}
		}
	}
	//WNC-NMR1716-D2R030-YUAN-I-CHOU-20160719, Turn OFF TV LED if all wireless interfaces are OFF End

	if ((tv_led_state & (1<<0))) {
		//TV mode is enabled in any radio, ignore TV mode disable LED
			return;
	}

	if (tv_led_state && ((tv_led_state & (~(1<<flag)))== 0)) {
		//(LED is ON state) and (state will be 0 if remove flag from state)
		//printk("tv_led_offgreen [%s]\n", priv->dev->name);
		//__gpio_set_value(GN_TV_LED_G, 1);
		//REG32(PABCD_DAT) = (REG32(PABCD_DAT) | (RTL_GPIOD4));
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED.
		//RTL_LED_W32(PABCD_DAT, (RTL_LED_R32(PABCD_DAT) | (RTL_GPIOD4)));//Turn OFF TV LED.
		led.gpio = 12;
		led.on = 0;
		led.off = 4000;
		led.blinks = 1;
		led.rests = 0;
		led.times = 4000;
		rl_gpio_led_set(led);
//WNC-NMR1809-D2R030-YUAN-I-CHOU-20160920, Use LED control function to control TV LED End.
	}
	tv_led_state &= (~(1<<flag));
	//printk("OFF tv_led_state [%d]\n", tv_led_state);
	//Remove flag from state
	return;
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140618, TV LED End

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
// For rtl_gpio.c use
void rtl8192_led_force_off (int wlan_index, int state) {
	struct rtl8192cd_priv *priv;
	rl_gpio_led_info led;

	if (wlan_index >= 2)
		return;

	priv = wlan_device[wlan_index].priv;

	if (NULL == priv)
		return;

	if (state == 0) {// OFF LED
		//control_wireless_led(priv, 0);
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		//priv->pshare->LED_force_off = 1;
		priv->pshare->LOS_LED_off = 1;
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
	} else if (state == 2) {// ON LED
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		//priv->pshare->LED_force_off = 0;
		priv->pshare->LOS_LED_off = 0;
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
//WNC-NMR2035-D2R030-YUAN-I-CHOU-20161110, Restore ACT / TV LED if STA reconnects to AP in force led OFF mode
		if (priv->pshare->cnv_rpt_mode == 1) {
			if (rpt_act_led_state == 1) {
				if (IS_DRV_OPEN(GET_VXD_PRIV(GET_ROOT(priv)))) {
				//Only check this in VXD interface
					if ((GET_VXD_PRIV(GET_ROOT(priv))->pmib->dot11OperationEntry.opmode & 
						(WIFI_STATION_STATE | WIFI_ASOC_STATE)) 
						== (WIFI_STATION_STATE | WIFI_ASOC_STATE)) {
						if (GET_ROOT(priv)->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_5G) {
							printk("back from force off - TURN ON ACT ORANGE LED\n");
							led.gpio = 1;
							led.on = 4000;
							led.off = 0;
							led.blinks = 1;
							led.rests = 0;
							led.times = 4000;
							rl_gpio_led_set(led);
							led.gpio = 0;
							led.on = 4000;
							led.off = 0;
							led.blinks = 1;
							led.rests = 0;
							led.times = 4000;
							rl_gpio_led_set(led);
						} else if (GET_ROOT(priv)->pmib->dot11RFEntry.phyBandSelect == PHY_BAND_2G) {
							printk("back from force off - TURN ON ACT GREEN LED\n");
							led.gpio = 1;
							led.on = 4000;
							led.off = 0;
							led.blinks = 1;
							led.rests = 0;
							led.times = 4000;
							rl_gpio_led_set(led);
						}
					}
				}
			}	
		}
//WNC-NMR2061-D2R030-YUAN-I-CHOU-20161117, Do not turn ON TV LED while DFS LED are blinking.
//TV LED would be turned ON after DFS LED blinking by other function.
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag
		if ((led_state == 0) && (priv->pshare->LED_force_off == 0)) {
		//NOT in DFS red LEDs blink mode AND not in force DHCP server mode 
		//if (led_state == 0) {
		//NOT in DFS red LEDs blink mode
//WNC-NMR2168-D2R030-YUAN-I-CHOU-20161209, Separate force DHCP server and LOS LED OFF flag End
			if (tv_led_state > 0) {
				//TV LED should be ON
				//Turn ON TV LED
				printk("back from force off - TURN ON TV LED\n");
				led.gpio = 12;
				led.on = 4000;
				led.off = 0;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
			}
		}
//WNC-NMR2035-D2R030-YUAN-I-CHOU-20161110, Restore ACT / TV LED if STA reconnects to AP in force led OFF mode End
	}

	return;
}
EXPORT_SYMBOL(rtl8192_led_force_off);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support

