/******************************************************************************
 *
 * Copyright(c) 2016 - 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#include "halmac_pwr_seq_8814b.h"

#if HALMAC_8814B_SUPPORT

static struct halmac_wlan_pwr_cfg TRANS_CARDDIS_TO_CARDEMU_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x004A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), 0},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_ACT_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0xFF0A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0xFF1A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x101A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x1A},
	{0x1020,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x1029,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x1090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x1094,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(0), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_ACT_TO_CARDEMU_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x001F,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00EF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00EE,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00ED,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00DC,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x00DD,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0xFF1A,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x30},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(1), 0},
	{0x002B,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0x3, 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_CARDDIS_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

/* Card Enable Array */
struct halmac_wlan_pwr_cfg *card_en_flow_8814b[] = {
	TRANS_CARDDIS_TO_CARDEMU_8814B,
	TRANS_CARDEMU_TO_ACT_8814B,
	NULL
};

/* Card Disable Array */
struct halmac_wlan_pwr_cfg *card_dis_flow_8814b[] = {
	TRANS_ACT_TO_CARDEMU_8814B,
	TRANS_CARDEMU_TO_CARDDIS_8814B,
	NULL
};

#if HALMAC_PLATFORM_TESTPROGRAM

static struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_SUS_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4) | BIT(3), (BIT(4) | BIT(3))},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK | HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3)},
	{0x0007,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), BIT(3) | BIT(4)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_SUS_TO_CARDEMU_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(7), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3) | BIT(4), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_CARDEMU_TO_PDN_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0007,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK | HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0006,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_PDN_TO_CARDEMU_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0005,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_ACT_TO_LPS_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0068,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x0198,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0199,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x019B,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x113C,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x1138,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0) | BIT(1), BIT(0) | BIT(1)},
	{0x0194,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xd6},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x40},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x93},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x60},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x02},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x40},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x05F8,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_US},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x3F},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), BIT(7)},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_ACT_TO_DEEP_LPS_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0068,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(6), BIT(6)},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), BIT(2)},
	{0x0198,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0199,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(3), BIT(3)},
	{0x019B,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x113C,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x1138,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0) | BIT(1), BIT(0) | BIT(1)},
	{0x0194,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xd4},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x91},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0093,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x00},
	{0x0092,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x20},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0301,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF},
	{0x05F8,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05F9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FA,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x05FB,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, 0xFF, 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_US},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x3F},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), BIT(4)},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), BIT(7)},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(0), BIT(0)},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

static struct halmac_wlan_pwr_cfg TRANS_LPS_TO_ACT_8814B[] = {
	/* { offset, cut_msk, fab_msk|interface_msk, base|cmd, msk, value } */
	{0x0080,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0 },
	{0xFE58,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0x03D9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), 0},
	{0x0080,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_SDIO_MSK,
	 HALMAC_PWR_ADDR_SDIO,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0xFE58,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_USB_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x03D9,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_PCI_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(7), BIT(7)},
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_DELAY, 0, HALMAC_PWR_DELAY_MS},
	{0x0008,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(4), 0},
	{0x0109,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_POLLING, BIT(7), 0},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), BIT(1)},
	{0x0100,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0xFF },
	{0x0002,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1) | BIT(0), BIT(1) | BIT(0)},
	{0x0522,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0},
	{0x1138,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, 0xFF, 0x03},
	{0x0090,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(1), 0},
	{0x0101,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 HALMAC_PWR_ADDR_MAC,
	 HALMAC_PWR_CMD_WRITE, BIT(2), 0},
	{0xFFFF,
	 HALMAC_PWR_CUT_ALL_MSK,
	 HALMAC_PWR_INTF_ALL_MSK,
	 0,
	 HALMAC_PWR_CMD_END, 0, 0},
};

/* Suspend Array */
struct halmac_wlan_pwr_cfg *suspend_flow_8814b[] = {
	TRANS_ACT_TO_CARDEMU_8814B,
	TRANS_CARDEMU_TO_SUS_8814B,
	NULL
};

/* Resume Array */
struct halmac_wlan_pwr_cfg *resume_flow_8814b[] = {
	TRANS_SUS_TO_CARDEMU_8814B,
	TRANS_CARDEMU_TO_ACT_8814B,
	NULL
};

/* HWPDN Array - HW behavior */
struct halmac_wlan_pwr_cfg *hwpdn_flow_8814b[] = {
	NULL
};

/* Enter LPS - FW behavior */
struct halmac_wlan_pwr_cfg *enter_lps_flow_8814b[] = {
	TRANS_ACT_TO_LPS_8814B,
	NULL
};

/* Enter Deep LPS - FW behavior */
struct halmac_wlan_pwr_cfg *enter_dlps_flow_8814b[] = {
	TRANS_ACT_TO_DEEP_LPS_8814B,
	NULL
};

/* Leave LPS -FW behavior */
struct halmac_wlan_pwr_cfg *leave_lps_flow_8814b[] = {
	TRANS_LPS_TO_ACT_8814B,
	NULL
};

#endif

#endif /* HALMAC_8814B_SUPPORT */
