/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#if (RTL8195B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8195b_radioa[] = {
		0x0EE, 0x00000010,
		0x033, 0x00000005,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x096, 0x0000A263,
		0x090, 0x000FEFE0,
		0x093, 0x0000C080,
		0x0DF, 0x00019F6F,
		0x0A9, 0x000F0355,
		0x0AB, 0x00013813,
		0x0B3, 0x00000410,
		0x0B4, 0x00000010,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00039C20,
		0x033, 0x00000001,
		0x03F, 0x00039C20,
		0x033, 0x00000002,
		0x03F, 0x00039C20,
		0x033, 0x00000003,
		0x03F, 0x00039C20,
		0x033, 0x00000004,
		0x03F, 0x00039C20,
		0x033, 0x00000005,
		0x03F, 0x00039C20,
		0x033, 0x00000006,
		0x03F, 0x00039C20,
		0x033, 0x00000007,
		0x03F, 0x00009C21,
		0x0EF, 0x00000000,
		0x018, 0x00010524,
		0x08F, 0x000A8018,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000003,
		0x033, 0x00000004,
		0x03F, 0x00000003,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x0FF, 0x00008000,
	0xA0000000,	0x00000000,
		0x0FF, 0x0004C000,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000080,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000080,
	0xB0000000,	0x00000000,
		0x033, 0x00000000,
		0x03E, 0x000000FF,
		0x03F, 0x0004F004,
		0x033, 0x00000001,
		0x03E, 0x000000B8,
		0x03F, 0x0001F004,
		0x033, 0x00000002,
		0x03E, 0x0000003D,
		0x03F, 0x0000F004,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x0001F004,
		0x033, 0x00000004,
		0x03E, 0x000000BF,
		0x03F, 0x0002F004,
		0x033, 0x00000005,
		0x03E, 0x00000078,
		0x03F, 0x0000F224,
		0x033, 0x00000006,
		0x03E, 0x00000003,
		0x03F, 0x0000F004,
		0x033, 0x00000007,
		0x03E, 0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000F447,
	0xA0000000,	0x00000000,
		0x03F, 0x0000FFF7,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x000000FF,
		0x03F, 0x0004F004,
		0x033, 0x00000009,
		0x03E, 0x000000B8,
		0x03F, 0x0001F004,
		0x033, 0x0000000A,
		0x03E, 0x0000003D,
		0x03F, 0x0000F004,
		0x033, 0x0000000B,
		0x03E, 0x00000000,
		0x03F, 0x0001F004,
		0x033, 0x0000000C,
		0x03E, 0x000000BF,
		0x03F, 0x0002F004,
		0x033, 0x0000000D,
		0x03E, 0x00000078,
		0x03F, 0x0000F224,
		0x033, 0x0000000E,
		0x03E, 0x00000003,
		0x03F, 0x0000F004,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000F447,
	0xA0000000,	0x00000000,
		0x03F, 0x0000FFF7,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x000000FF,
		0x03F, 0x0004F004,
		0x033, 0x00000011,
		0x03E, 0x000000B8,
		0x03F, 0x0001F004,
		0x033, 0x00000012,
		0x03E, 0x0000003D,
		0x03F, 0x0000F004,
		0x033, 0x00000013,
		0x03E, 0x00000000,
		0x03F, 0x0001F004,
		0x033, 0x00000014,
		0x03E, 0x000000BF,
		0x03F, 0x0002F004,
		0x033, 0x00000015,
		0x03E, 0x00000078,
		0x03F, 0x0000F224,
		0x033, 0x00000016,
		0x03E, 0x00000003,
		0x03F, 0x0000F004,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0000F887,
		0x0EE, 0x00000000,
		0x0EE, 0x00000080,
		0x033, 0x00000018,
		0x03E, 0x000000FF,
		0x03F, 0x0004F001,
		0x033, 0x00000019,
		0x03E, 0x000000B8,
		0x03F, 0x0001F001,
		0x033, 0x0000001A,
		0x03E, 0x0000003D,
		0x03F, 0x0000F001,
		0x033, 0x0000001B,
		0x03E, 0x00000000,
		0x03F, 0x0001F001,
		0x033, 0x0000001C,
		0x03E, 0x000000BF,
		0x03F, 0x0002F001,
		0x033, 0x0000001D,
		0x03E, 0x00000078,
		0x03F, 0x0000F221,
		0x033, 0x0000001E,
		0x03E, 0x00000003,
		0x03F, 0x0000F001,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0000FFF1,
		0x033, 0x00000020,
		0x03E, 0x000000FF,
		0x03F, 0x0004F001,
		0x033, 0x00000021,
		0x03E, 0x000000B8,
		0x03F, 0x0001F001,
		0x033, 0x00000022,
		0x03E, 0x0000003D,
		0x03F, 0x0000F001,
		0x033, 0x00000023,
		0x03E, 0x00000000,
		0x03F, 0x0001F001,
		0x033, 0x00000024,
		0x03E, 0x000000BF,
		0x03F, 0x0002F001,
		0x033, 0x00000025,
		0x03E, 0x00000078,
		0x03F, 0x0000F221,
		0x033, 0x00000026,
		0x03E, 0x00000003,
		0x03F, 0x0000F001,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0000FFF1,
		0x033, 0x00000028,
		0x03E, 0x000000FF,
		0x03F, 0x0004F001,
		0x033, 0x00000029,
		0x03E, 0x000000B8,
		0x03F, 0x0001F001,
		0x033, 0x0000002A,
		0x03E, 0x0000003D,
		0x03F, 0x0000F001,
		0x033, 0x0000002B,
		0x03E, 0x00000000,
		0x03F, 0x0001F001,
		0x033, 0x0000002C,
		0x03E, 0x000000BF,
		0x03F, 0x0002F001,
		0x033, 0x0000002D,
		0x03E, 0x00000078,
		0x03F, 0x0000F221,
		0x033, 0x0000002E,
		0x03E, 0x00000003,
		0x03F, 0x0000F001,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0000FFF1,
		0x0EE, 0x00000000,
		0x0EE, 0x00000040,
		0x033, 0x00000000,
		0x03F, 0x0000000A,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000020,
		0x033, 0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000072,
	0xA0000000,	0x00000000,
		0x03F, 0x00000011,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03F, 0x00000042,
		0x033, 0x00000002,
		0x03F, 0x00000042,
		0x033, 0x00000004,
		0x03F, 0x00000011,
		0x033, 0x00000005,
		0x03F, 0x00000011,
		0x033, 0x00000006,
		0x03F, 0x00000011,
		0x033, 0x00000008,
		0x03F, 0x00000042,
		0x033, 0x00000009,
		0x03F, 0x00000042,
		0x033, 0x0000000A,
		0x03F, 0x00000042,
		0x033, 0x0000000B,
		0x03F, 0x00000042,
		0x033, 0x0000000C,
		0x03F, 0x00000011,
		0x0EE, 0x00000000,
		0x018, 0x00000401,
		0x087, 0x000B1031,
		0x088, 0x00011500,
		0x0EE, 0x00000200,
		0x033, 0x0000000F,
		0x03F, 0x00003007,
		0x033, 0x0000000E,
		0x03F, 0x00003003,
		0x033, 0x0000000D,
		0x03F, 0x00002003,
		0x033, 0x0000000C,
		0x03F, 0x0000201B,
		0x033, 0x0000000B,
		0x03F, 0x00000C0B,
		0x033, 0x0000000A,
		0x03F, 0x00000C23,
		0x033, 0x00000009,
		0x03F, 0x00000C2B,
		0x033, 0x00000008,
		0x03F, 0x00000C3B,
		0x033, 0x00000007,
		0x03F, 0x00003007,
		0x033, 0x00000006,
		0x03F, 0x00003003,
		0x033, 0x00000005,
		0x03F, 0x00002003,
		0x033, 0x00000004,
		0x03F, 0x0000201B,
		0x033, 0x00000003,
		0x03F, 0x00000C0B,
		0x033, 0x00000002,
		0x03F, 0x00000C23,
		0x033, 0x00000001,
		0x03F, 0x00000823,
		0x033, 0x00000000,
		0x03F, 0x00000833,
		0x033, 0x00000017,
		0x03F, 0x00003007,
		0x033, 0x00000016,
		0x03F, 0x00003003,
		0x033, 0x00000015,
		0x03F, 0x00002003,
		0x033, 0x00000014,
		0x03F, 0x0000201B,
		0x033, 0x00000013,
		0x03F, 0x00000C0B,
		0x033, 0x00000012,
		0x03F, 0x00000C23,
		0x033, 0x00000011,
		0x03F, 0x00000823,
		0x033, 0x00000010,
		0x03F, 0x00000833,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x0000001F,
		0x03F, 0x00003007,
		0x033, 0x0000001E,
		0x03F, 0x00003003,
		0x033, 0x0000001D,
		0x03F, 0x00002003,
		0x033, 0x0000001C,
		0x03F, 0x0000201B,
		0x033, 0x0000001B,
		0x03F, 0x00000C0B,
		0x033, 0x0000001A,
		0x03F, 0x00000C23,
		0x033, 0x00000019,
		0x03F, 0x00000823,
		0x033, 0x00000018,
		0x03F, 0x00000833,
		0x033, 0x00000027,
		0x03F, 0x00003007,
		0x033, 0x00000026,
		0x03F, 0x00003003,
		0x033, 0x00000025,
		0x03F, 0x00002003,
		0x033, 0x00000024,
		0x03F, 0x0000201B,
		0x033, 0x00000023,
		0x03F, 0x00000C0B,
		0x033, 0x00000022,
		0x03F, 0x00000C23,
		0x033, 0x00000021,
		0x03F, 0x00000823,
		0x033, 0x00000020,
		0x03F, 0x00000833,
		0x033, 0x0000002F,
		0x03F, 0x00003007,
		0x033, 0x0000002E,
		0x03F, 0x00003003,
		0x033, 0x0000002D,
		0x03F, 0x00002003,
		0x033, 0x0000002C,
		0x03F, 0x0000201B,
		0x033, 0x0000002B,
		0x03F, 0x00000C0B,
		0x033, 0x0000002A,
		0x03F, 0x00000C23,
		0x033, 0x00000029,
		0x03F, 0x00000823,
		0x033, 0x00000028,
		0x03F, 0x00000833,
		0x0EE, 0x00000000,
		0x0EE, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000050,
		0x033, 0x00000001,
		0x03F, 0x000030A0,
		0x033, 0x00000002,
		0x03F, 0x000000A0,
		0x033, 0x00000004,
		0x03F, 0x00000050,
		0x033, 0x00000005,
		0x03F, 0x00000050,
		0x033, 0x00000006,
		0x03F, 0x00000050,
		0x033, 0x00000008,
		0x03F, 0x000000A0,
		0x033, 0x00000009,
		0x03F, 0x000000A0,
		0x033, 0x0000000A,
		0x03F, 0x000000A0,
		0x033, 0x0000000B,
		0x03F, 0x000000A0,
		0x033, 0x0000000C,
		0x03F, 0x000000A0,
		0x0EE, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000000,
		0x03F, 0x00000459,
		0x033, 0x00000001,
		0x03F, 0x00000859,
		0x033, 0x00000002,
		0x03F, 0x00000859,
		0x033, 0x00000004,
		0x03F, 0x00000459,
		0x033, 0x00000005,
		0x03F, 0x00000459,
		0x033, 0x00000006,
		0x03F, 0x00000459,
		0x0EF, 0x00000000,
		0x01B, 0x00003A40,
		0x0EE, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00000023,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x033, 0x00000002,
		0x03F, 0x00000023,
		0x033, 0x00000003,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x00000023,
		0x033, 0x00000005,
		0x03F, 0x00000023,
		0x033, 0x00000006,
		0x03F, 0x00000023,
		0x033, 0x00000007,
		0x03F, 0x00000004,
		0x033, 0x00000008,
		0x03F, 0x00000023,
		0x033, 0x00000009,
		0x03F, 0x00000023,
		0x033, 0x0000000A,
		0x03F, 0x00000023,
		0x033, 0x0000000B,
		0x03F, 0x00000000,
		0x033, 0x0000000C,
		0x03F, 0x00000023,
		0x0EE, 0x00000000,
		0x063, 0x0004326A,
		0x0EE, 0x00000400,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000256,
	0xA0000000,	0x00000000,
		0x03F, 0x00000236,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002A5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000002F4,
	0xA0000000,	0x00000000,
		0x03F, 0x00000235,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000136,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000DD5,
	0xA0000000,	0x00000000,
		0x03F, 0x00000DDF,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000673,
	0xA0000000,	0x00000000,
		0x03F, 0x0000096F,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000120,
	0xA0000000,	0x00000000,
		0x03F, 0x0000050F,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x0000050F,
		0x033, 0x00000004,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03F, 0x00000000,
		0x033, 0x00000006,
		0x03F, 0x00000000,
		0x033, 0x00000007,
		0x03F, 0x00000FFF,
		0x0EE, 0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000100,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000727,
	0xB0000000,	0x00000000,
		0x033, 0x00000101,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F26,
	0xB0000000,	0x00000000,
		0x033, 0x00000102,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F29,
	0xB0000000,	0x00000000,
		0x033, 0x00000103,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F66,
	0xB0000000,	0x00000000,
		0x033, 0x00000104,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F69,
	0xB0000000,	0x00000000,
		0x033, 0x00000140,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000727,
	0xB0000000,	0x00000000,
		0x033, 0x00000141,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F26,
	0xB0000000,	0x00000000,
		0x033, 0x00000142,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F29,
	0xB0000000,	0x00000000,
		0x033, 0x00000143,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F66,
	0xB0000000,	0x00000000,
		0x033, 0x00000144,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F69,
	0xB0000000,	0x00000000,
		0x033, 0x00000145,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FE6,
	0xB0000000,	0x00000000,
		0x033, 0x00000146,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FE9,
	0xB0000000,	0x00000000,
		0x033, 0x00000147,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FEC,
	0xB0000000,	0x00000000,
		0x033, 0x00000148,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FEF,
	0xB0000000,	0x00000000,
		0x033, 0x00000149,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FF2,
	0xB0000000,	0x00000000,
		0x033, 0x0000014A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FF5,
	0xB0000000,	0x00000000,
		0x033, 0x00000180,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000727,
	0xB0000000,	0x00000000,
		0x033, 0x00000181,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F26,
	0xB0000000,	0x00000000,
		0x033, 0x00000182,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F29,
	0xB0000000,	0x00000000,
		0x033, 0x00000183,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F66,
	0xB0000000,	0x00000000,
		0x033, 0x00000184,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000F69,
	0xB0000000,	0x00000000,
		0x033, 0x00000185,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FE6,
	0xB0000000,	0x00000000,
		0x033, 0x00000186,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FE9,
	0xB0000000,	0x00000000,
		0x033, 0x00000187,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FEC,
	0xB0000000,	0x00000000,
		0x033, 0x00000188,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FEF,
	0xB0000000,	0x00000000,
		0x033, 0x00000189,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FF2,
	0xB0000000,	0x00000000,
		0x033, 0x0000018A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00000FF5,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x051, 0x00049839,
		0x056, 0x00092FF4,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x000623A4,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0004B7F9,
	0xA0000000,	0x00000000,
		0x03F, 0x0005A3B7,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00020000,
		0x033, 0x00000011,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001A7A6,
	0xA0000000,	0x00000000,
		0x03F, 0x00022394,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001A3A6,
	0xA0000000,	0x00000000,
		0x03F, 0x0001A3C4,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000226A5,
	0xA0000000,	0x00000000,
		0x03F, 0x000223B4,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000222A5,
	0xA0000000,	0x00000000,
		0x03F, 0x000223D4,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x000222A5,
	0xA0000000,	0x00000000,
		0x03F, 0x000223A4,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00010000,
		0x033, 0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x0001260E,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E0C,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E29,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E2C,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E69,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E6C,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012EAB,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012EEB,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012EEE,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012EF1,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012EF4,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x0001260B,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E09,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E0C,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E0F,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E2C,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E69,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E6C,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E6F,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E90,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E93,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00000000,
	0xA0000000,	0x00000000,
		0x03F, 0x00012E96,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x099, 0x000FC004,
		0x09A, 0x00042000,
		0x09C, 0x00000198,
		0x09D, 0x0008B000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x09E, 0x000333BC,
	0xA0000000,	0x00000000,
		0x09E, 0x000333B0,
	0xB0000000,	0x00000000,
		0x0A8, 0x0002FC17,
		0x0FE, 0x00000000,
		0x09B, 0x00001000,
		0x09B, 0x00001008,
		0x09B, 0x0000100C,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0A8, 0x0000FC00,
		0x0A0, 0x000FF004,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x0A3, 0x000001EB,
	0xA0000000,	0x00000000,
		0x0A3, 0x000000AB,
	0xB0000000,	0x00000000,
		0x0A8, 0x0008FC17,
		0x0FE, 0x00000000,
		0x0A2, 0x00004C00,
		0x0A2, 0x00004C08,
		0x0A2, 0x00004C0C,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0A8, 0x0000FC00,
		0x09C, 0x000001D8,
		0x09B, 0x0000121C,
		0x0A3, 0x0000006B,
		0x0A4, 0x00033B00,
		0x0AF, 0x00010100,
		0x0C0, 0x00009324,
		0x0A8, 0x000BFE17,
		0x0FE, 0x00000000,
		0x018, 0x00002C01,
		0x0FE, 0x00000000,
		0x018, 0x0000AC01,
		0xFFE, 0x00000000,
		0x0A8, 0x0000FE00,
		0x018, 0x00010D24,
		0x000, 0x00010000,
		0x000, 0x00030000,
		0x0C0, 0x00009324,
		0x0C0, 0x00089324,
		0x0C1, 0x00002018,

};

void
odm_read_and_config_mp_8195b_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8195b_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8195b_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8195b(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8195b_radioa(void)
{
		return 46;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8195B
const s8 delta_swingidx_mp_5ga_n_txpwrtrk_8195b[][D_S_SIZE] = {
	{0, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 7,
	 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12, 13, 13},
	{0, 0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 4, 5,
	 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12},
	{0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 5, 6,
	 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12},
};

const s8 delta_swingidx_mp_5ga_p_txpwrtrk_8195b[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13},
	{0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8,
	 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14},
	{0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12},
};

const s8 delta_swingidx_mp_2ga_n_txpwrtrk_8195b[]    = {
	0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 5, 5, 5, 6,
	 6, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12};
const s8 delta_swingidx_mp_2ga_p_txpwrtrk_8195b[]    = {
	0, 1, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8,
	 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 13};
const s8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8195b[] = {
	0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12};
const s8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8195b[] = {
	0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7,
	 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 12};
#endif

void
odm_read_and_config_mp_8195b_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8195B

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8195b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8195b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_pkg1.TXT
 ******************************************************************************/

#ifdef CONFIG_8195B_PKG1
const s8 delta_swingidx_mp_5ga_n_txpwrtrk_pkg1_8195b[][D_S_SIZE] = {
	{1, 1, 1, 2, 2, 3, 4, 4, 4, 4, 5, 5, 5, 7, 7, 7,
	 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8},
	{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5,
	 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6},
	{1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 4, 4,
	 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5},
};

const s8 delta_swingidx_mp_5ga_p_txpwrtrk_pkg1_8195b[][D_S_SIZE] = {
	{-1, 0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 5, 5, 5,
	 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7,
	 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 12},
	{-1, 0, 0, 1, 2, 2, 2, 3, 3, 3, 3, 3, 5, 5, 5, 5,
	 6, 7, 7, 8, 8, 8, 8, 8, 9, 9, 10, 10, 10, 10},
};

const s8 delta_swingidx_mp_2ga_n_txpwrtrk_pkg1_8195b[]    = {
	1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4,
	 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
const s8 delta_swingidx_mp_2ga_p_txpwrtrk_pkg1_8195b[]    = {
	-1, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 6, 6, 7,
	 8, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10};
const s8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_pkg1_8195b[] = {
	1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6,
	 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
const s8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_pkg1_8195b[] = {
	-1, -1, 0, 0, 0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 4,
	 5, 5, 6, 6, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8};
#endif

void
odm_read_and_config_mp_8195b_txpowertrack_pkg1(struct dm_struct *dm)
{
#ifdef CONFIG_8195B_PKG1

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8195b\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_pkg1_8195b,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8195B
_WEAK const u8 array_mp_8195b_txpwr_lmt[] = {
	/* regulation, band, bandwidth, rateSection, rfPath, chnl, value */
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	24,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_CCK,	PW_LMT_PH_1T,	14,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	16,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	32,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	12,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	34,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	1,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	2,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	3,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	4,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	5,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	6,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	7,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	8,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	26,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	9,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	10,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	20,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	11,	30,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	12,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	13,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_2_4G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	14,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	36,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	40,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	44,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	48,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	52,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	56,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	60,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	64,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	100,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	104,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	108,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	112,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	116,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	120,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	124,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	128,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	132,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	136,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	140,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_OFDM,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	36,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	40,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	44,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	48,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	52,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	56,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	60,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	64,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	100,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	104,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	108,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	112,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	116,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	120,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	124,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	128,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	132,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	136,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	140,	33,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	144,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	149,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	153,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	157,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	161,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_20M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	165,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	38,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	24,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	46,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	54,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	23,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	62,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	21,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	102,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	110,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	118,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	126,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	134,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	142,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	151,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_40M,	PW_LMT_RS_HT,	PW_LMT_PH_1T,	159,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	42,	19,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	42,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	42,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	58,	22,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	58,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	58,	28,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	106,	18,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	106,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	106,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	122,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	122,	32,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	122,	32,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	138,	27,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	138,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	138,	63,
	PW_LMT_REGU_FCC,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	155,	28,
	PW_LMT_REGU_ETSI,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	155,	63,
	PW_LMT_REGU_MKK,	PW_LMT_BAND_5G,	PW_LMT_BW_80M,	PW_LMT_RS_VHT,	PW_LMT_PH_1T,	155,	63
};
#endif

void
odm_read_and_config_mp_8195b_txpwr_lmt(struct dm_struct *dm)
{
#ifdef CONFIG_8195B

	u32	i = 0;
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
	u32	array_len =
			sizeof(array_mp_8195b_txpwr_lmt) / sizeof(u8);
	u8	*array = (u8 *)array_mp_8195b_txpwr_lmt;
#else
	u32	array_len =
			sizeof(array_mp_8195b_txpwr_lmt) / sizeof(u8 *);
	u8	**array = (u8 **)array_mp_8195b_txpwr_lmt;
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrLmt, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrLmt = array_len / 7;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	for (i = 0; i < array_len; i += 7) {
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
		u8	regulation = array[i];
		u8	band = array[i + 1];
		u8	bandwidth = array[i + 2];
		u8	rate = array[i + 3];
		u8	rf_path = array[i + 4];
		u8	chnl = array[i + 5];
		u8	val = array[i + 6];
#else
		u8	*regulation = array[i];
		u8	*band = array[i + 1];
		u8	*bandwidth = array[i + 2];
		u8	*rate = array[i + 3];
		u8	*rf_path = array[i + 4];
		u8	*chnl = array[i + 5];
		u8	*val = array[i + 6];
#endif

		odm_config_bb_txpwr_lmt_8195b(dm, regulation, band, bandwidth,
					      rate, rf_path, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)hal_data->BufOfLinesPwrLmt[i / 7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			 regulation, band, bandwidth, rate, rf_path, chnl, val);
#endif
	}

#endif
}

/******************************************************************************
 *                           txxtaltrack.TXT
 ******************************************************************************/

const s8 delta_swing_xtal_mp_n_txxtaltrack_8195b[]    = {
	-2, -4, -5, -5, -6, -6, -7, -7, -7, -7, -7, -7, -7, -7, -6, -5, -2, 1, 1, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const s8 delta_swing_xtal_mp_p_txxtaltrack_8195b[]    = {
	-3, -1, 0, 0, 1, 2, 3, 4, 4, 4, 5, 5, 5, 4, 0, -1, -4, -5, -5, -8, -11, -14, -18, -19, -20,
	 -21, -22, -23, -24, -25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void
odm_read_and_config_mp_8195b_txxtaltrack(struct dm_struct *dm)
{
	struct dm_rf_calibration_struct	*cali_info = &dm->rf_calibrate_info;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8195b\n");

	odm_move_memory(dm, cali_info->delta_swing_table_xtal_p,
			(void *)delta_swing_xtal_mp_p_txxtaltrack_8195b,
			DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_xtal_n,
			(void *)delta_swing_xtal_mp_n_txxtaltrack_8195b,
			DELTA_SWINGIDX_SIZE);
}

/******************************************************************************
 *                           txxtaltrack_pkg1.TXT
 ******************************************************************************/

const s8 delta_swing_xtal_mp_n_txxtaltrack_pkg1_8195b[]    = {
	-2, -4, -5, -4, -5, -6, -6, -6, -5, -5, -4, -3, -3, 0, 0, 0, 4, 1, -2, -2, -2, -2, -2, -2,
	 -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
const s8 delta_swing_xtal_mp_p_txxtaltrack_pkg1_8195b[]    = {
	-2, -3, 0, 1, 1, 2, 4, 5, 5, 7, 8, 8, 8, 8, 7, 8, 6, 6, 7, 5, 1, -1, -6, -4, -8, -10,
	 -10, -10, -10, -10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void
odm_read_and_config_mp_8195b_txxtaltrack_pkg1(struct dm_struct *dm)
{
	struct dm_rf_calibration_struct	*cali_info = &dm->rf_calibrate_info;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8195b\n");

	odm_move_memory(dm, cali_info->delta_swing_table_xtal_p,
			(void *)delta_swing_xtal_mp_p_txxtaltrack_pkg1_8195b,
			DELTA_SWINGIDX_SIZE);
	odm_move_memory(dm, cali_info->delta_swing_table_xtal_n,
			(void *)delta_swing_xtal_mp_n_txxtaltrack_pkg1_8195b,
			DELTA_SWINGIDX_SIZE);
}

#endif /* end of HWIMG_SUPPORT*/

