/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.3*/
#include "mp_precomp.h"

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#if (RTL8197F_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}

/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8197f_radioa[] = {
		0x000, 0x00030000,
		0x018, 0x00000C07,
		0x0CA, 0x00002000,
		0x081, 0x0000FC00,
		0x082, 0x000003C0,
		0x084, 0x00000005,
		0x086, 0x000933A5,
		0x087, 0x00000000,
		0x088, 0x0007B030,
		0x08E, 0x00064540,
		0x08F, 0x000A8000,
		0x0DF, 0x00000E00,
		0x051, 0x00000C1C,
		0x052, 0x0009A007,
		0x053, 0x00018C47,
		0x054, 0x00090034,
		0x055, 0x00082000,
		0x056, 0x0000880F,
		0x057, 0x0007F000,
		0x058, 0x000603F0,
		0x05A, 0x00050000,
		0x05B, 0x00000006,
		0x05C, 0x00000015,
		0x065, 0x00020000,
		0x06E, 0x00038319,
		0x0DF, 0x00000602,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030026,
		0x033, 0x00038026,
		0x033, 0x00070026,
		0x033, 0x00078026,
		0x033, 0x000D8022,
		0x0EF, 0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0C9, 0x00000600,
		0x0B0, 0x000FFBC3,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B87,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B87,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B87,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B87,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0B1, 0x00033B8F,
	0xA0000000,	0x00000000,
		0x0B1, 0x00033B87,
	0xB0000000,	0x00000000,
		0x0B2, 0x00033762,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000140F0,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000140F0,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000140F0,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000140F0,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0B4, 0x000141F0,
	0xA0000000,	0x00000000,
		0x0B4, 0x000140F0,
	0xB0000000,	0x00000000,
		0x0B5, 0x00014000,
		0x0B6, 0x00012425,
		0x0B7, 0x00010E8C,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00030FFF,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00030FFF,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00030FFF,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00030FFF,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00070FFF,
	0xA0000000,	0x00000000,
		0x0B8, 0x00030FFF,
	0xB0000000,	0x00000000,
		0x0B9, 0x000C0008,
		0x0BA, 0x00040005,
		0x0C2, 0x00002C01,
		0x0C3, 0x0000000B,
		0x0C4, 0x00081E2F,
		0x0C5, 0x0005C28F,
		0x0C6, 0x000000A0,
		0x0C9, 0x00000600,
		0x0CA, 0x00002000,
		0x0EF, 0x00080000,
		0x030, 0x00020000,
		0x031, 0x0000005F,
		0x032, 0x00001FF7,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x030, 0x00030000,
		0x031, 0x0000005F,
		0x032, 0x000F1DF3,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x030, 0x00038000,
		0x031, 0x0000005F,
		0x032, 0x000F1FF2,
		0x0EF, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00008C07,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x000, 0x00035DF5,

};

void
odm_read_and_config_mp_8197f_radioa(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197f_radioa) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197f_radioa;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_a_8197f(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197f_radioa(void)
{
		return 69;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8197f_radiob[] = {
		0x000, 0x00030000,
		0x081, 0x0000FC00,
		0x082, 0x000003C0,
		0x084, 0x00000005,
		0x086, 0x000933A5,
		0x087, 0x00000000,
		0x088, 0x0007B030,
		0x08E, 0x00064540,
		0x08F, 0x000A8000,
		0x0DF, 0x00000E00,
		0x051, 0x00000C18,
		0x052, 0x0009A007,
		0x053, 0x00018C4B,
		0x054, 0x00090030,
		0x055, 0x00082000,
		0x056, 0x0000880F,
		0x057, 0x0007F000,
		0x058, 0x000603F0,
		0x05A, 0x00050000,
		0x05B, 0x00000006,
		0x05C, 0x00000015,
		0x065, 0x00020000,
		0x06E, 0x00038319,
		0x0DF, 0x00000602,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000121,
		0x033, 0x00004123,
		0x033, 0x00008126,
		0x033, 0x0000C129,
		0x033, 0x0001012C,
		0x033, 0x0001412F,
		0x033, 0x0001816C,
		0x033, 0x0001C16F,
		0x033, 0x000201AE,
		0x033, 0x000245AB,
		0x033, 0x00028DAA,
		0x0EF, 0x00000000,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x000000A5,
		0x033, 0x000040A8,
		0x033, 0x000080E8,
		0x033, 0x0000C4E6,
		0x033, 0x00010DE5,
		0x033, 0x00014DE8,
		0x033, 0x00018DEB,
		0x033, 0x0001CDEE,
		0x033, 0x00020DF1,
		0x033, 0x00024DF4,
		0x033, 0x00028DF7,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x0006000D,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00030021,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x030, 0x00020000,
		0x031, 0x0000005F,
		0x032, 0x00001FF7,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x030, 0x00030000,
		0x031, 0x0000005F,
		0x032, 0x000F1DF3,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x030, 0x00038000,
		0x031, 0x0000005F,
		0x032, 0x000F1FF2,
		0x0EF, 0x00000000,
		0x000, 0x00035DF5,

};

void
odm_read_and_config_mp_8197f_radiob(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197f_radiob) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197f_radiob;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_rf_radio_b_8197f(dm, v1, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197f_radiob(void)
{
		return 69;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8197F

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE0
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type0_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type0_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type0_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type0_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type0_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type0_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type0_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type0_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE0

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type0_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE1
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type1_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type1_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type1_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type1_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type1_8197f[]    = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type1_8197f[]    = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type1_8197f[]    = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type1_8197f[]    = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8197f[] = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8197f[] = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8197f[] = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8197f[] = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE1

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type1_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE2
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type2_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type2_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type2_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type2_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type2_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type2_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type2_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type2_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE2

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type2_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE3
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type3_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type3_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type3_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type3_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type3_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type3_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type3_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type3_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE3

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type3_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE4
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type4_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type4_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type4_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type4_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type4_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type4_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type4_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type4_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE4

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type4_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE5
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type5_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type5_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type5_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type5_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type5_8197f[]    = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type5_8197f[]    = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type5_8197f[]    = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type5_8197f[]    = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8197f[] = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8197f[] = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8197f[] = {
	0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8,
	 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8197f[] = {
	0, 0, 1, 1, 2, 3, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8,
	 8, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE5

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type5_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE6
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type6_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type6_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type6_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type6_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type6_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type6_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type6_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type6_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE6

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type6_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertrack_type7.TXT
 ******************************************************************************/

#ifdef CONFIG_8197F_TYPE7
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_type7_8197f[][D_S_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10,
	 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_type7_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 16, 17, 17, 18, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_type7_8197f[][D_S_SIZE] = {
	{0, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10,
	 11, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11,
	 12, 13, 14, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_type7_8197f[][D_S_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 21},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_type7_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_type7_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_type7_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_type7_8197f[]    = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type7_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type7_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type7_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type7_8197f[] = {
	0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4,
	 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8};
#endif

void
odm_read_and_config_mp_8197f_txpowertrack_type7(struct dm_struct *dm)
{
#ifdef CONFIG_8197F_TYPE7

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8197f\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_type7_8197f,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

#endif /* end of HWIMG_SUPPORT*/

