// SPDX-License-Identifier: GPL-2.0
/* Copyright(c) 2018  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/

#include "mp_precomp.h"
#if (DM_ODM_SUPPORT_TYPE == ODM_IOT)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

const u32 array_mp_8721d_cal_init[] = {
	0xb00, 0x0005f018,
	0xb04, 0xf76d9f84,
	0xb28, 0x000855aa,/*LMS step size*/
	0xb68, 0x11120200,
	/*pwsf boudnary*/
	0xb30, 0x0007bdef,
	/*LUT SRAM block*/
	0xe28, 0x40000000,
	0xbc0, 0x0000a9bf,
	0xe28, 0x00000000,
	/*tx_ramp*/
	0xb08, 0x41382e21,
	0xb0c, 0x5b554f48,
	0xb10, 0x6f6b6661,
	0xb14, 0x817d7874,
	0xb18, 0x908c8884,
	0xb1c, 0x9d9a9793,
	0xb20, 0xaaa7a4a1,
	0xb24, 0xb6b3b0ad,
	/*tx_inverse*/
	0xe28, 0x40000000,
	0xb00, 0x02ce03e8,
	0xb04, 0x01fd024c,
	0xb08, 0x01a101c9,
	0xb0C, 0x016a0183,
	0xb10, 0x01430153,
	0xb14, 0x01280134,
	0xb18, 0x0112011c,
	0xb1C, 0x01000107,
	0xb20, 0x00f200f9,
	0xb24, 0x00e500eb,
	0xb28, 0x00da00e0,
	0xb2c, 0x00d200d6,
	0xb30, 0x00c900cd,
	0xb34, 0x00c200c5,
	0xb38, 0x00bb00be,
	0xb3c, 0x00b500b8,
	0xe28, 0x00000000,
	/*pwsf table*/
	0xb38, 0x4c20fcff,
	0xb2c, 0x40000304,
	0xb2c, 0x41000203,
	0xb2c, 0x42000102,
	0xb2c, 0x43000101,
	0xb2c, 0x44000101,
	0xb2c, 0x45000101,
	0xb2c, 0x46000101,
	0xb2c, 0x47000101,
	0xb2c, 0x4800caff,
	0xb2c, 0x490080a1,
	0xb2c, 0x4A005165,
	0xb2c, 0x4B003340,
	0xb2c, 0x4C002028,
	0xb2c, 0x4D001419,
	0xb2c, 0x4E000810,
	0xb2c, 0x4F000506,
	0xb2c, 0x00000000,
	0xe28, 0x00000000,
	/*LUT Write*/
	//0xb38, 0x0c000000,
	//even
	0xb2c, 0x00500000,
	0xb2c, 0x01500000,
	0xb2c, 0x02500000,
	0xb2c, 0x03500000,
	0xb2c, 0x04500000,
	0xb2c, 0x05500000,
	0xb2c, 0x06500000,
	0xb2c, 0x07500000,
	0xb2c, 0x08500000,
	0xb2c, 0x09500000,
	0xb2c, 0x0A500000,
	0xb2c, 0x0B500000,
	0xb2c, 0x0C500000,
	0xb2c, 0x0D500000,
	0xb2c, 0x0E500000,
	0xb2c, 0x0F500000,
	//odd
	0xb2c, 0x00900000,
	0xb2c, 0x01900000,
	0xb2c, 0x02900000,
	0xb2c, 0x03900000,
	0xb2c, 0x04900000,
	0xb2c, 0x05900000,
	0xb2c, 0x06900000,
	0xb2c, 0x07900000,
	0xb2c, 0x08900000,
	0xb2c, 0x09900000,
	0xb2c, 0x0A900000,
	0xb2c, 0x0B900000,
	0xb2c, 0x0C900000,
	0xb2c, 0x0D900000,
	0xb2c, 0x0E900000,
	0xb2c, 0x0F900000,
	0xb2c, 0x00000000,
	/*IQK setting*/
	0xe20, 0xc0000000,
	0xe28, 0x40000000,
	0xb40, 0x00040100,
	0xe28, 0x00000000,
	0xe30, 0x1000cc1b,
	0xe34, 0x1000cc1b,
	0xe38, 0x821403ff,
	0xe3c, 0x00160000,
	0xe40, 0x01007c00,
	0xe44, 0x01004800,
	0xe48, 0xf8000800,
	0xe4c, 0x00002911,
};

void odm_read_and_config_mp_8721d_cal_init(void *dm_void)
{
	struct dm_struct *dm = (struct dm_struct *)dm_void;
	struct dm_dpk_info *dpk_info = &dm->dpk_info;

	u32	i = 0;
	u32	array_len = sizeof(array_mp_8721d_cal_init) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8721d_cal_init;
	u32	v1 = 0, v2 = 0;

	if (dm->cut_version < ODM_CUT_C)
		return;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);
	RF_DBG(dm, DBG_RF_DPK, "[DPK]!!! read_and_config_mp_8721d !!!\n");
	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		odm_config_bb_phy_8721d(dm, v1, MASKDWORD, v2);
		i = i + 2;
	}
	_dpk_result_reset_8721d(dm);
	dpk_info->is_dpk_by_channel = 1;
}
