/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.6*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8192F_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8192f_agc_tab[] = {
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20001F,
		0xC78, 0x0F10011F,
		0xC78, 0x0F00021F,
		0xC78, 0x0EF0031F,
		0xC78, 0x0EE0041F,
		0xC78, 0x0ED0051F,
		0xC78, 0x0EC0061F,
		0xC78, 0x0EB0071F,
		0xC78, 0x0EA0081F,
		0xC78, 0x0E90091F,
		0xC78, 0x0E800A1F,
		0xC78, 0x0E700B1F,
		0xC78, 0x0E600C1F,
		0xC78, 0x0E500D1F,
		0xC78, 0x0C900E1F,
		0xC78, 0x0C800F1F,
		0xC78, 0x0C70101F,
		0xC78, 0x0C60111F,
		0xC78, 0x0C50121F,
		0xC78, 0x0C40131F,
		0xC78, 0x0A70141F,
		0xC78, 0x0A60151F,
		0xC78, 0x0A50161F,
		0xC78, 0x0A40171F,
		0xC78, 0x0880181F,
		0xC78, 0x0870191F,
		0xC78, 0x08601A1F,
		0xC78, 0x08501B1F,
		0xC78, 0x08401C1F,
		0xC78, 0x06701D1F,
		0xC78, 0x06601E1F,
		0xC78, 0x06501F1F,
		0xC78, 0x0640201F,
		0xC78, 0x04B0211F,
		0xC78, 0x04A0221F,
		0xC78, 0x0490231F,
		0xC78, 0x0480241F,
		0xC78, 0x0470251F,
		0xC78, 0x0460261F,
		0xC78, 0x02A0271F,
		0xC78, 0x0290281F,
		0xC78, 0x0280291F,
		0xC78, 0x02702A1F,
		0xC78, 0x02602B1F,
		0xC78, 0x00A02C1F,
		0xC78, 0x00902D1F,
		0xC78, 0x00802E1F,
		0xC78, 0x00702F1F,
		0xC78, 0x0060301F,
		0xC78, 0x0050311F,
		0xC78, 0x0040321F,
		0xC78, 0x0030331F,
		0xC78, 0x0030341F,
		0xC78, 0x0030351F,
		0xC78, 0x0030361F,
		0xC78, 0x0030371F,
		0xC78, 0x0030381F,
		0xC78, 0x0030391F,
		0xC78, 0x00303A1F,
		0xC78, 0x00303B1F,
		0xC78, 0x00303C1F,
		0xC78, 0x00303D1F,
		0xC78, 0x00303E1F,
		0xC78, 0x00303F1F,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60001F,
		0xC78, 0x0F50011F,
		0xC78, 0x0F40021F,
		0xC78, 0x0F30031F,
		0xC78, 0x0F20041F,
		0xC78, 0x0F10051F,
		0xC78, 0x0F00061F,
		0xC78, 0x0EF0071F,
		0xC78, 0x0EE0081F,
		0xC78, 0x0ED0091F,
		0xC78, 0x0EC00A1F,
		0xC78, 0x0EB00B1F,
		0xC78, 0x0EA00C1F,
		0xC78, 0x0E900D1F,
		0xC78, 0x0E800E1F,
		0xC78, 0x0E700F1F,
		0xC78, 0x0E60101F,
		0xC78, 0x0E50111F,
		0xC78, 0x0C90121F,
		0xC78, 0x0C80131F,
		0xC78, 0x0C70141F,
		0xC78, 0x0C60151F,
		0xC78, 0x0C50161F,
		0xC78, 0x0C40171F,
		0xC78, 0x0A70181F,
		0xC78, 0x0A60191F,
		0xC78, 0x0A501A1F,
		0xC78, 0x0A401B1F,
		0xC78, 0x08801C1F,
		0xC78, 0x08701D1F,
		0xC78, 0x08601E1F,
		0xC78, 0x08501F1F,
		0xC78, 0x0840201F,
		0xC78, 0x0670211F,
		0xC78, 0x0660221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x04B0251F,
		0xC78, 0x04A0261F,
		0xC78, 0x0490271F,
		0xC78, 0x0480281F,
		0xC78, 0x0470291F,
		0xC78, 0x04602A1F,
		0xC78, 0x02A02B1F,
		0xC78, 0x02902C1F,
		0xC78, 0x02802D1F,
		0xC78, 0x02702E1F,
		0xC78, 0x02602F1F,
		0xC78, 0x00A0301F,
		0xC78, 0x0090311F,
		0xC78, 0x0080321F,
		0xC78, 0x0070331F,
		0xC78, 0x0060341F,
		0xC78, 0x0050351F,
		0xC78, 0x0040361F,
		0xC78, 0x0030371F,
		0xC78, 0x0030381F,
		0xC78, 0x0030391F,
		0xC78, 0x00303A1F,
		0xC78, 0x00303B1F,
		0xC78, 0x00303C1F,
		0xC78, 0x00303D1F,
		0xC78, 0x00303E1F,
		0xC78, 0x00303F1F,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0xA0000000,	0x00000000,
		0xC78, 0x0FA0001F,
		0xC78, 0x0FA0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0FA0051F,
		0xC78, 0x0F90061F,
		0xC78, 0x0F80071F,
		0xC78, 0x0F70081F,
		0xC78, 0x0F60091F,
		0xC78, 0x0F500A1F,
		0xC78, 0x0F400B1F,
		0xC78, 0x0F300C1F,
		0xC78, 0x0F200D1F,
		0xC78, 0x0F100E1F,
		0xC78, 0x0F000F1F,
		0xC78, 0x0EF0101F,
		0xC78, 0x0EE0111F,
		0xC78, 0x0ED0121F,
		0xC78, 0x0EC0131F,
		0xC78, 0x0EB0141F,
		0xC78, 0x0EA0151F,
		0xC78, 0x0E90161F,
		0xC78, 0x0E80171F,
		0xC78, 0x0E70181F,
		0xC78, 0x0E60191F,
		0xC78, 0x0E501A1F,
		0xC78, 0x0E401B1F,
		0xC78, 0x0E301C1F,
		0xC78, 0x0C701D1F,
		0xC78, 0x0C601E1F,
		0xC78, 0x0C501F1F,
		0xC78, 0x0C40201F,
		0xC78, 0x0C30211F,
		0xC78, 0x0A60221F,
		0xC78, 0x0A50231F,
		0xC78, 0x0A40241F,
		0xC78, 0x0A30251F,
		0xC78, 0x0860261F,
		0xC78, 0x0850271F,
		0xC78, 0x0840281F,
		0xC78, 0x0830291F,
		0xC78, 0x06702A1F,
		0xC78, 0x06602B1F,
		0xC78, 0x06502C1F,
		0xC78, 0x06402D1F,
		0xC78, 0x06302E1F,
		0xC78, 0x04602F1F,
		0xC78, 0x0450301F,
		0xC78, 0x0440311F,
		0xC78, 0x0430321F,
		0xC78, 0x0260331F,
		0xC78, 0x0250341F,
		0xC78, 0x0240351F,
		0xC78, 0x0230361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0xB0000000,	0x00000000,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0FA0441F,
		0xC78, 0x0FA0451F,
		0xC78, 0x0FA0461F,
		0xC78, 0x0F90471F,
		0xC78, 0x0F80481F,
		0xC78, 0x0F70491F,
		0xC78, 0x0F604A1F,
		0xC78, 0x0F504B1F,
		0xC78, 0x0F404C1F,
		0xC78, 0x0F304D1F,
		0xC78, 0x0F204E1F,
		0xC78, 0x0F104F1F,
		0xC78, 0x0F00501F,
		0xC78, 0x0EF0511F,
		0xC78, 0x0EE0521F,
		0xC78, 0x0ED0531F,
		0xC78, 0x0EC0541F,
		0xC78, 0x0EB0551F,
		0xC78, 0x0EA0561F,
		0xC78, 0x0E90571F,
		0xC78, 0x0E80581F,
		0xC78, 0x0E70591F,
		0xC78, 0x0E605A1F,
		0xC78, 0x0E505B1F,
		0xC78, 0x0E405C1F,
		0xC78, 0x0E305D1F,
		0xC78, 0x08605E1F,
		0xC78, 0x08505F1F,
		0xC78, 0x0840601F,
		0xC78, 0x0830611F,
		0xC78, 0x0660621F,
		0xC78, 0x0650631F,
		0xC78, 0x0640641F,
		0xC78, 0x0630651F,
		0xC78, 0x0470661F,
		0xC78, 0x0460671F,
		0xC78, 0x0450681F,
		0xC78, 0x0440691F,
		0xC78, 0x04306A1F,
		0xC78, 0x26806B1F,
		0xC78, 0x26706C1F,
		0xC78, 0x26606D1F,
		0xC78, 0x26506E1F,
		0xC78, 0x26406F1F,
		0xC78, 0x2630701F,
		0xC78, 0x2470711F,
		0xC78, 0x2460721F,
		0xC78, 0x2450731F,
		0xC78, 0x2440741F,
		0xC78, 0x2430751F,
		0xC78, 0x2260761F,
		0xC78, 0x2250771F,
		0xC78, 0x2240781F,
		0xC78, 0x2230791F,
		0xC78, 0x22207A1F,
		0xC78, 0x22107B1F,
		0xC78, 0x22007C1F,
		0xC78, 0x20007D1F,
		0xC78, 0x20007E1F,
		0xC78, 0x20007F1F,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20401F,
		0xC78, 0x0F10411F,
		0xC78, 0x0F00421F,
		0xC78, 0x0EF0431F,
		0xC78, 0x0EE0441F,
		0xC78, 0x0ED0451F,
		0xC78, 0x0EC0461F,
		0xC78, 0x0EB0471F,
		0xC78, 0x0EA0481F,
		0xC78, 0x0E90491F,
		0xC78, 0x0E804A1F,
		0xC78, 0x0E704B1F,
		0xC78, 0x0E604C1F,
		0xC78, 0x0E504D1F,
		0xC78, 0x0C904E1F,
		0xC78, 0x0C804F1F,
		0xC78, 0x0C70501F,
		0xC78, 0x0C60511F,
		0xC78, 0x0C50521F,
		0xC78, 0x0C40531F,
		0xC78, 0x0A70541F,
		0xC78, 0x0A60551F,
		0xC78, 0x0A50561F,
		0xC78, 0x0A40571F,
		0xC78, 0x0880581F,
		0xC78, 0x0870591F,
		0xC78, 0x08605A1F,
		0xC78, 0x08505B1F,
		0xC78, 0x08405C1F,
		0xC78, 0x06705D1F,
		0xC78, 0x06605E1F,
		0xC78, 0x06505F1F,
		0xC78, 0x0640601F,
		0xC78, 0x04B0611F,
		0xC78, 0x04A0621F,
		0xC78, 0x0490631F,
		0xC78, 0x0480641F,
		0xC78, 0x0470651F,
		0xC78, 0x0460661F,
		0xC78, 0x02A0671F,
		0xC78, 0x0290681F,
		0xC78, 0x0280691F,
		0xC78, 0x02706A1F,
		0xC78, 0x02606B1F,
		0xC78, 0x00A06C1F,
		0xC78, 0x00906D1F,
		0xC78, 0x00806E1F,
		0xC78, 0x00706F1F,
		0xC78, 0x0060701F,
		0xC78, 0x0050711F,
		0xC78, 0x0040721F,
		0xC78, 0x0030731F,
		0xC78, 0x0030741F,
		0xC78, 0x0030751F,
		0xC78, 0x0030761F,
		0xC78, 0x0030771F,
		0xC78, 0x0030781F,
		0xC78, 0x0030791F,
		0xC78, 0x00307A1F,
		0xC78, 0x00307B1F,
		0xC78, 0x00307C1F,
		0xC78, 0x00307D1F,
		0xC78, 0x00307E1F,
		0xC78, 0x00307F1F,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60401F,
		0xC78, 0x0F50411F,
		0xC78, 0x0F40421F,
		0xC78, 0x0F30431F,
		0xC78, 0x0F20441F,
		0xC78, 0x0F10451F,
		0xC78, 0x0F00461F,
		0xC78, 0x0EF0471F,
		0xC78, 0x0EE0481F,
		0xC78, 0x0ED0491F,
		0xC78, 0x0EC04A1F,
		0xC78, 0x0EB04B1F,
		0xC78, 0x0EA04C1F,
		0xC78, 0x0E904D1F,
		0xC78, 0x0E804E1F,
		0xC78, 0x0E704F1F,
		0xC78, 0x0E60501F,
		0xC78, 0x0E50511F,
		0xC78, 0x0C90521F,
		0xC78, 0x0C80531F,
		0xC78, 0x0C70541F,
		0xC78, 0x0C60551F,
		0xC78, 0x0C50561F,
		0xC78, 0x0C40571F,
		0xC78, 0x0A70581F,
		0xC78, 0x0A60591F,
		0xC78, 0x0A505A1F,
		0xC78, 0x0A405B1F,
		0xC78, 0x08805C1F,
		0xC78, 0x08705D1F,
		0xC78, 0x08605E1F,
		0xC78, 0x08505F1F,
		0xC78, 0x0840601F,
		0xC78, 0x0670611F,
		0xC78, 0x0660621F,
		0xC78, 0x0650631F,
		0xC78, 0x0640641F,
		0xC78, 0x0630651F,
		0xC78, 0x04C0661F,
		0xC78, 0x04B0671F,
		0xC78, 0x04A0681F,
		0xC78, 0x0490691F,
		0xC78, 0x04806A1F,
		0xC78, 0x02A06B1F,
		0xC78, 0x02906C1F,
		0xC78, 0x02806D1F,
		0xC78, 0x02706E1F,
		0xC78, 0x02606F1F,
		0xC78, 0x00A0701F,
		0xC78, 0x0090711F,
		0xC78, 0x0080721F,
		0xC78, 0x0070731F,
		0xC78, 0x0060741F,
		0xC78, 0x0050751F,
		0xC78, 0x0040761F,
		0xC78, 0x0030771F,
		0xC78, 0x0030781F,
		0xC78, 0x0030791F,
		0xC78, 0x00307A1F,
		0xC78, 0x00307B1F,
		0xC78, 0x00307C1F,
		0xC78, 0x00307D1F,
		0xC78, 0x00307E1F,
		0xC78, 0x00307F1F,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0xA0000000,	0x00000000,
		0xC78, 0x0FA0401F,
		0xC78, 0x0FA0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0FA0431F,
		0xC78, 0x0F90441F,
		0xC78, 0x0F80451F,
		0xC78, 0x0F70461F,
		0xC78, 0x0F60471F,
		0xC78, 0x0F50481F,
		0xC78, 0x0F40491F,
		0xC78, 0x0F304A1F,
		0xC78, 0x0F204B1F,
		0xC78, 0x0F104C1F,
		0xC78, 0x0F004D1F,
		0xC78, 0x0EF04E1F,
		0xC78, 0x0EE04F1F,
		0xC78, 0x0ED0501F,
		0xC78, 0x0EC0511F,
		0xC78, 0x0EB0521F,
		0xC78, 0x0EA0531F,
		0xC78, 0x0E90541F,
		0xC78, 0x0E80551F,
		0xC78, 0x0E70561F,
		0xC78, 0x0E60571F,
		0xC78, 0x0E50581F,
		0xC78, 0x0E40591F,
		0xC78, 0x0E305A1F,
		0xC78, 0x0E205B1F,
		0xC78, 0x0E105C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0C20601F,
		0xC78, 0x0C10611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0A20641F,
		0xC78, 0x0A10651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0820681F,
		0xC78, 0x0810691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x06306C1F,
		0xC78, 0x06206D1F,
		0xC78, 0x06106E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0420711F,
		0xC78, 0x0410721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0xB0000000,	0x00000000,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0FA0861F,
		0xC78, 0x0F90871F,
		0xC78, 0x0F80881F,
		0xC78, 0x0F70891F,
		0xC78, 0x0F608A1F,
		0xC78, 0x0F508B1F,
		0xC78, 0x0F408C1F,
		0xC78, 0x0F308D1F,
		0xC78, 0x0F208E1F,
		0xC78, 0x0F108F1F,
		0xC78, 0x0F00901F,
		0xC78, 0x0EF0911F,
		0xC78, 0x0EE0921F,
		0xC78, 0x0ED0931F,
		0xC78, 0x0EC0941F,
		0xC78, 0x0EB0951F,
		0xC78, 0x0EA0961F,
		0xC78, 0x0E90971F,
		0xC78, 0x0E80981F,
		0xC78, 0x0E70991F,
		0xC78, 0x0E609A1F,
		0xC78, 0x0E509B1F,
		0xC78, 0x0E409C1F,
		0xC78, 0x0E309D1F,
		0xC78, 0x08609E1F,
		0xC78, 0x08509F1F,
		0xC78, 0x0840A01F,
		0xC78, 0x0830A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0470A61F,
		0xC78, 0x0460A71F,
		0xC78, 0x0450A81F,
		0xC78, 0x0440A91F,
		0xC78, 0x0430AA1F,
		0xC78, 0x2680AB1F,
		0xC78, 0x2670AC1F,
		0xC78, 0x2660AD1F,
		0xC78, 0x2650AE1F,
		0xC78, 0x2640AF1F,
		0xC78, 0x2630B01F,
		0xC78, 0x2470B11F,
		0xC78, 0x2460B21F,
		0xC78, 0x2450B31F,
		0xC78, 0x2440B41F,
		0xC78, 0x2430B51F,
		0xC78, 0x2260B61F,
		0xC78, 0x2250B71F,
		0xC78, 0x2240B81F,
		0xC78, 0x2230B91F,
		0xC78, 0x2220BA1F,
		0xC78, 0x2210BB1F,
		0xC78, 0x2200BC1F,
		0xC78, 0x2000BD1F,
		0xC78, 0x2000BE1F,
		0xC78, 0x2000BF1F,
		0xC50, 0x00E48224,
		0xC50, 0x00E48220,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20801F,
		0xC78, 0x0F10811F,
		0xC78, 0x0F00821F,
		0xC78, 0x0EF0831F,
		0xC78, 0x0EE0841F,
		0xC78, 0x0ED0851F,
		0xC78, 0x0EC0861F,
		0xC78, 0x0EB0871F,
		0xC78, 0x0EA0881F,
		0xC78, 0x0E90891F,
		0xC78, 0x0E808A1F,
		0xC78, 0x0E708B1F,
		0xC78, 0x0E608C1F,
		0xC78, 0x0E508D1F,
		0xC78, 0x0C908E1F,
		0xC78, 0x0C808F1F,
		0xC78, 0x0C70901F,
		0xC78, 0x0C60911F,
		0xC78, 0x0C50921F,
		0xC78, 0x0C40931F,
		0xC78, 0x0A70941F,
		0xC78, 0x0A60951F,
		0xC78, 0x0A50961F,
		0xC78, 0x0A40971F,
		0xC78, 0x0880981F,
		0xC78, 0x0870991F,
		0xC78, 0x08609A1F,
		0xC78, 0x08509B1F,
		0xC78, 0x08409C1F,
		0xC78, 0x06709D1F,
		0xC78, 0x06609E1F,
		0xC78, 0x06509F1F,
		0xC78, 0x0640A01F,
		0xC78, 0x04B0A11F,
		0xC78, 0x04A0A21F,
		0xC78, 0x0490A31F,
		0xC78, 0x0480A41F,
		0xC78, 0x0470A51F,
		0xC78, 0x0460A61F,
		0xC78, 0x02A0A71F,
		0xC78, 0x0290A81F,
		0xC78, 0x0280A91F,
		0xC78, 0x0270AA1F,
		0xC78, 0x0260AB1F,
		0xC78, 0x00A0AC1F,
		0xC78, 0x0090AD1F,
		0xC78, 0x0080AE1F,
		0xC78, 0x0070AF1F,
		0xC78, 0x0060B01F,
		0xC78, 0x0050B11F,
		0xC78, 0x0040B21F,
		0xC78, 0x0030B31F,
		0xC78, 0x0030B41F,
		0xC78, 0x0030B51F,
		0xC78, 0x0030B61F,
		0xC78, 0x0030B71F,
		0xC78, 0x0030B81F,
		0xC78, 0x0030B91F,
		0xC78, 0x0030BA1F,
		0xC78, 0x0030BB1F,
		0xC78, 0x0030BC1F,
		0xC78, 0x0030BD1F,
		0xC78, 0x0030BE1F,
		0xC78, 0x0030BF1F,
		0xC50, 0x00E48224,
		0xC50, 0x00E48220,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48224,
		0xC50, 0x00E48220,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60801F,
		0xC78, 0x0F50811F,
		0xC78, 0x0F40821F,
		0xC78, 0x0F30831F,
		0xC78, 0x0F20841F,
		0xC78, 0x0F10851F,
		0xC78, 0x0F00861F,
		0xC78, 0x0EF0871F,
		0xC78, 0x0EE0881F,
		0xC78, 0x0ED0891F,
		0xC78, 0x0EC08A1F,
		0xC78, 0x0EB08B1F,
		0xC78, 0x0EA08C1F,
		0xC78, 0x0E908D1F,
		0xC78, 0x0E808E1F,
		0xC78, 0x0E708F1F,
		0xC78, 0x0E60901F,
		0xC78, 0x0E50911F,
		0xC78, 0x0C90921F,
		0xC78, 0x0C80931F,
		0xC78, 0x0C70941F,
		0xC78, 0x0C60951F,
		0xC78, 0x0C50961F,
		0xC78, 0x0C40971F,
		0xC78, 0x0A70981F,
		0xC78, 0x0A60991F,
		0xC78, 0x0A509A1F,
		0xC78, 0x0A409B1F,
		0xC78, 0x08809C1F,
		0xC78, 0x08709D1F,
		0xC78, 0x08609E1F,
		0xC78, 0x08509F1F,
		0xC78, 0x0840A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x04B0A51F,
		0xC78, 0x04A0A61F,
		0xC78, 0x0490A71F,
		0xC78, 0x0480A81F,
		0xC78, 0x0470A91F,
		0xC78, 0x0460AA1F,
		0xC78, 0x02A0AB1F,
		0xC78, 0x0290AC1F,
		0xC78, 0x0280AD1F,
		0xC78, 0x0270AE1F,
		0xC78, 0x0260AF1F,
		0xC78, 0x00A0B01F,
		0xC78, 0x0090B11F,
		0xC78, 0x0080B21F,
		0xC78, 0x0070B31F,
		0xC78, 0x0060B41F,
		0xC78, 0x0050B51F,
		0xC78, 0x0040B61F,
		0xC78, 0x0030B71F,
		0xC78, 0x0030B81F,
		0xC78, 0x0030B91F,
		0xC78, 0x0030BA1F,
		0xC78, 0x0030BB1F,
		0xC78, 0x0030BC1F,
		0xC78, 0x0030BD1F,
		0xC78, 0x0030BE1F,
		0xC78, 0x0030BF1F,
		0xC50, 0x00E48224,
		0xC50, 0x00E48220,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0xA0000000,	0x00000000,
		0xC78, 0x0FA0801F,
		0xC78, 0x0FA0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0FA0851F,
		0xC78, 0x0F90861F,
		0xC78, 0x0F80871F,
		0xC78, 0x0F70881F,
		0xC78, 0x0F60891F,
		0xC78, 0x0F508A1F,
		0xC78, 0x0F408B1F,
		0xC78, 0x0F308C1F,
		0xC78, 0x0F208D1F,
		0xC78, 0x0F108E1F,
		0xC78, 0x0B908F1F,
		0xC78, 0x0B80901F,
		0xC78, 0x0B70911F,
		0xC78, 0x0B60921F,
		0xC78, 0x0B50931F,
		0xC78, 0x0B40941F,
		0xC78, 0x0B30951F,
		0xC78, 0x0B20961F,
		0xC78, 0x0B10971F,
		0xC78, 0x0B00981F,
		0xC78, 0x0AF0991F,
		0xC78, 0x0AE09A1F,
		0xC78, 0x0AD09B1F,
		0xC78, 0x0AC09C1F,
		0xC78, 0x0AB09D1F,
		0xC78, 0x0AA09E1F,
		0xC78, 0x0A909F1F,
		0xC78, 0x0A80A01F,
		0xC78, 0x0A70A11F,
		0xC78, 0x0A60A21F,
		0xC78, 0x0A50A31F,
		0xC78, 0x0A40A41F,
		0xC78, 0x0A30A51F,
		0xC78, 0x0A20A61F,
		0xC78, 0x0A10A71F,
		0xC78, 0x0A00A81F,
		0xC78, 0x0830A91F,
		0xC78, 0x0820AA1F,
		0xC78, 0x0810AB1F,
		0xC78, 0x0800AC1F,
		0xC78, 0x0640AD1F,
		0xC78, 0x0630AE1F,
		0xC78, 0x0620AF1F,
		0xC78, 0x0610B01F,
		0xC78, 0x0600B11F,
		0xC78, 0x0430B21F,
		0xC78, 0x0420B31F,
		0xC78, 0x0410B41F,
		0xC78, 0x0400B51F,
		0xC78, 0x0230B61F,
		0xC78, 0x0220B71F,
		0xC78, 0x0210B81F,
		0xC78, 0x0200B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00E48024,
		0xC50, 0x00E48020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8192f_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8192f_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8192f_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8192f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8192f_agc_tab(void)
{
		return 51;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8192f_phy_reg[] = {
		0x800, 0x80006C00,
		0x804, 0x00004001,
		0x808, 0x0000FC00,
		0x80C, 0x00000000,
		0x810, 0x20200322,
		0x814, 0x020C3910,
		0x818, 0x00000385,
		0x81C, 0x07000000,
		0x820, 0x01000100,
		0x824, 0x00390204,
		0x828, 0x01000100,
		0x82C, 0x00390204,
		0x830, 0x25252525,
		0x834, 0x25252525,
		0x838, 0x25252525,
		0x83C, 0x25252525,
		0x840, 0x00010000,
		0x844, 0x00010000,
		0x848, 0x25252525,
		0x84C, 0x25252525,
		0x850, 0x00031FE0,
		0x854, 0x00000000,
		0x858, 0x569A569A,
		0x85C, 0x00400040,
		0x860, 0x66F60000,
		0x864, 0x061F0000,
		0x868, 0x25252525,
		0x86C, 0x25252525,
		0x870, 0x00000300,
		0x874, 0x04003400,
		0x878, 0x08080808,
		0x87C, 0x004F0201,
		0x880, 0xD8001402,
		0x884, 0xC0000120,
		0x888, 0x00000000,
		0x88C, 0xCC0000C0,
		0x890, 0x00000000,
		0x894, 0xFFFFFFFE,
		0x898, 0x40302010,
		0x89C, 0x00706050,
		0x900, 0x00000000,
		0x904, 0x00000023,
		0x908, 0x00000F00,
		0x90C, 0x81121313,
		0x910, 0x024C0000,
		0x914, 0x00000000,
		0x918, 0x00000000,
		0x91C, 0x00000000,
		0x920, 0x00000000,
		0x924, 0x00000000,
		0x928, 0x00000000,
		0x92C, 0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
		0x948, 0x000001A3,
		0x94C, 0x20200008,
		0x950, 0x00338A98,
		0x954, 0x00000000,
		0x958, 0xCBCAD87A,
		0x95C, 0x06EB5735,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000003,
		0x970, 0x00000000,
		0x974, 0x00000000,
		0x978, 0x00000000,
		0x97C, 0x10030000,
		0x980, 0x00000000,
		0x984, 0x02800280,
		0x988, 0x020A5704,
		0x98C, 0x1461C826,
		0x990, 0x0001469E,
		0x994, 0x008858D1,
		0x998, 0x400086C9,
		0x99C, 0x44444242,
		0x9A0, 0x00000000,
		0x9A4, 0x00000000,
		0x9A8, 0x00000000,
		0x9AC, 0xC0000000,
		0xA00, 0x00D047C8,
		0xA04, 0xC1FF0008,
		0xA08, 0x88838300,
		0xA0C, 0x2E20100F,
		0xA10, 0x9500BB78,
		0xA14, 0x11144028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0001,
		0xA24, 0x64B80C1C,
		0xA28, 0x00158810,
		0xA2C, 0x10BB8000,
		0xA70, 0x00008000,
		0xA74, 0x80800100,
		0xA78, 0x000089F0,
		0xA7C, 0x225B0606,
		0xA80, 0x20803210,
		0xA84, 0x00200200,
		0xA88, 0x00000000,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00460000,
		0xAA0, 0x00000000,
		0xAA4, 0x00020014,
		0xAA8, 0xBA0A0008,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x0016B2D6,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x0016B2D6,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x0016B2D6,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xAB4, 0x00201402,
	0xA0000000,	0x00000000,
		0xAB4, 0x00201402,
	0xB0000000,	0x00000000,
		0xAB8, 0x0000001C,
		0xABC, 0x0000F7FF,
		0xAC0, 0xD4C0A742,
		0xAC4, 0x00000000,
		0xAC8, 0x00000F08,
		0xACC, 0x00000F07,
		0xAD0, 0xA1052A10,
		0xAD4, 0x0D9D8452,
		0xAD8, 0x9E024024,
		0xADC, 0x0023C001,
		0xAE0, 0x00000391,
		0xB2C, 0x00000000,
		0xC00, 0x00000080,
		0xC04, 0x6F005433,
		0xC08, 0x000004E4,
		0xC0C, 0x6C6C6C6C,
		0xC10, 0x22000000,
		0xC14, 0x40000100,
		0xC18, 0x22000000,
		0xC1C, 0x40000100,
		0xC20, 0x00000000,
		0xC24, 0x40000100,
		0xC28, 0x00000000,
		0xC2C, 0x40000100,
		0xC30, 0x0401E809,
		0xC34, 0x30000020,
		0xC38, 0x23808080,
		0xC3C, 0x00002F44,
		0xC40, 0x1CF8403F,
		0xC44, 0x000100C7,
		0xC48, 0xEC060106,
		0xC4C, 0x007F037F,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48220,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48220,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48220,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48220,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00E48020,
	0xA0000000,	0x00000000,
		0xC50, 0x00E48020,
	0xB0000000,	0x00000000,
		0xC54, 0x04008017,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0xA0000000,	0x00000000,
		0xC58, 0x00000020,
	0xB0000000,	0x00000000,
		0xC5C, 0x00708492,
		0xC60, 0x09280200,
		0xC64, 0x5014838B,
		0xC68, 0x47C006C7,
		0xC6C, 0x00000035,
		0xC70, 0x00001007,
		0xC74, 0x02815269,
		0xC78, 0x0FE07F1F,
		0xC7C, 0x00B91612,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x2D4000B5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x2D4000B5,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x2D4000B5,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0xA0000000,	0x00000000,
		0xC80, 0x40000100,
	0xB0000000,	0x00000000,
		0xC84, 0x32000000,
	0x8f000003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000001,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x91000007,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x2D4000B5,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x2D4000B5,
	0x91000009,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x9100000a,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x9100000b,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x9100000c,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x2D4000B5,
	0x9100000d,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x9100000e,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0xA0000000,	0x00000000,
		0xC88, 0x40000100,
	0xB0000000,	0x00000000,
		0xC8C, 0xA0240000,
		0xC90, 0x400E161E,
		0xC94, 0x00000F00,
		0xC98, 0x400E161E,
		0xC9C, 0x0000BDC8,
		0xCA0, 0x00000000,
		0xCA4, 0x098300A0,
		0xCA8, 0x00006B00,
		0xCAC, 0x87F45B1A,
		0xCB0, 0x0000002D,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x28100200,
		0xCC0, 0x0010A3D0,
		0xCC4, 0x00000F7D,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x593659AD,
		0xCD4, 0xB7545121,
		0xCD8, 0x64B22427,
		0xCDC, 0x00766932,
		0xCE0, 0x40201000,
		0xCE4, 0x00000000,
		0xCE8, 0x40E04407,
		0xCEC, 0x2E572000,
		0xD00, 0x000D8780,
		0xD04, 0x40020403,
		0xD08, 0x0002907F,
		0xD0C, 0x20010201,
		0xD10, 0x06288888,
		0xD14, 0x8888367B,
		0xD18, 0x7D806DB3,
		0xD1C, 0x0000007F,
		0xD20, 0x567600B8,
		0xD24, 0x0000018B,
		0xD28, 0xD513FF7D,
		0xD2C, 0xCC979975,
		0xD30, 0x04928000,
		0xD34, 0x40608000,
		0xD38, 0x88DDA000,
		0xD3C, 0x00026EE2,
		0xD50, 0x67270001,
		0xD54, 0x20500000,
		0xD58, 0x16161616,
		0xD5C, 0x71F20064,
		0xD60, 0x4653DA60,
		0xD64, 0x3E718A3C,
		0xD68, 0x00000183,
		0xD7C, 0x00000000,
		0xD80, 0x50000000,
		0xD84, 0x31310400,
		0xD88, 0xF5B50000,
		0xD8C, 0x00000000,
		0xD90, 0x00000000,
		0xD94, 0x44BBBB44,
		0xD98, 0x44BB44FF,
		0xD9C, 0x06033688,
		0xE00, 0x25252525,
		0xE04, 0x25252525,
		0xE08, 0x25252525,
		0xE10, 0x25252525,
		0xE14, 0x25252525,
		0xE18, 0x25252525,
		0xE1C, 0x25252525,
		0xE20, 0x00000000,
		0xE24, 0x00200000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x01007C00,
		0xE34, 0x01004800,
		0xE38, 0x10008C0F,
		0xE3C, 0x3C008C0F,
		0xE40, 0x01007C00,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x01007C00,
		0xE54, 0x01004800,
		0xE58, 0x10008C0F,
		0xE5C, 0x3C008C0F,
		0xE60, 0x02100000,
		0xE64, 0xBBBBBBBB,
		0xE68, 0x40404040,
		0xE6C, 0x80408040,
		0xE70, 0x80408040,
		0xE74, 0x40404040,
		0xE78, 0x00400040,
		0xE7C, 0x40404040,
		0xE80, 0x00FF0000,
		0xE84, 0x80408040,
		0xE88, 0x40404040,
		0xE8C, 0x80408040,
		0xED0, 0x80408040,
		0xED4, 0x80408040,
		0xED8, 0x80408040,
		0xEDC, 0xC040C040,
		0xEE0, 0xC040C040,
		0xEE4, 0x00400040,
		0xEE8, 0xD8001402,
		0xEEC, 0xC0000120,
		0xEF0, 0x02000B09,
		0xEF4, 0x00000001,
		0xEF8, 0x00000000,
		0xF00, 0x00000300,
		0xF04, 0x00000002,
		0xF08, 0x00007D0C,
		0xF0C, 0x0000A907,
		0xF10, 0x00005807,
		0xF14, 0x00000003,
		0xF18, 0x07D003E8,
		0xF1C, 0x8000001F,
		0xF20, 0x00000000,
		0xF24, 0x00000000,
		0xF28, 0x00000000,
		0xF2C, 0x00000000,
		0xF30, 0x00000000,
		0xF34, 0x00000000,
		0xF38, 0x00030055,
		0xF3C, 0x0000003A,
		0xF40, 0x00000002,
		0xF44, 0x00000000,
		0xF48, 0x00000000,
		0xF4C, 0x0B000000,
		0xF50, 0x00000000,

};

void
odm_read_and_config_mp_8192f_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8192f_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8192f_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8192f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8192f_phy_reg(void)
{
		return 51;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F
const u32 array_mp_8192f_phy_reg_pg[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8192F

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE0
const u32 array_mp_8192f_phy_reg_pg_type0[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE0

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type0) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type0;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE1
const u32 array_mp_8192f_phy_reg_pg_type1[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE1

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type1) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type1;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type10.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE10
const u32 array_mp_8192f_phy_reg_pg_type10[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type10(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE10

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type10) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type10;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type11.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE11
const u32 array_mp_8192f_phy_reg_pg_type11[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type11(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE11

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type11) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type11;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type12.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE12
const u32 array_mp_8192f_phy_reg_pg_type12[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x40424242,
	0, 1, 0, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 0, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 1, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 0, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x00000868, 0xffffffff, 0x40424242
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type12(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE12

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type12) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type12;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type13.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE13
const u32 array_mp_8192f_phy_reg_pg_type13[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type13(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE13

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type13) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type13;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type14.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE14
const u32 array_mp_8192f_phy_reg_pg_type14[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type14(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE14

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type14) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type14;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type15.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE15
const u32 array_mp_8192f_phy_reg_pg_type15[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type15(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE15

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type15) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type15;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type16.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE16
const u32 array_mp_8192f_phy_reg_pg_type16[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type16(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE16

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type16) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type16;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type17.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE17
const u32 array_mp_8192f_phy_reg_pg_type17[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type17(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE17

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type17) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type17;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type18.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE18
const u32 array_mp_8192f_phy_reg_pg_type18[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type18(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE18

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type18) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type18;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type19.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE19
const u32 array_mp_8192f_phy_reg_pg_type19[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type19(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE19

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type19) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type19;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type2.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE2
const u32 array_mp_8192f_phy_reg_pg_type2[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type2(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE2

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type2) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type2;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type20.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE20
const u32 array_mp_8192f_phy_reg_pg_type20[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type20(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE20

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type20) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type20;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type21.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE21
const u32 array_mp_8192f_phy_reg_pg_type21[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type21(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE21

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type21) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type21;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type22.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE22
const u32 array_mp_8192f_phy_reg_pg_type22[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type22(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE22

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type22) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type22;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type23.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE23
const u32 array_mp_8192f_phy_reg_pg_type23[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type23(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE23

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type23) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type23;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type24.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE24
const u32 array_mp_8192f_phy_reg_pg_type24[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type24(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE24

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type24) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type24;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type25.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE25
const u32 array_mp_8192f_phy_reg_pg_type25[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type25(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE25

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type25) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type25;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type26.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE26
const u32 array_mp_8192f_phy_reg_pg_type26[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type26(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE26

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type26) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type26;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type27.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE27
const u32 array_mp_8192f_phy_reg_pg_type27[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type27(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE27

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type27) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type27;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type28.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE28
const u32 array_mp_8192f_phy_reg_pg_type28[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type28(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE28

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type28) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type28;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type29.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE29
const u32 array_mp_8192f_phy_reg_pg_type29[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type29(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE29

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type29) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type29;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type3.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE3
const u32 array_mp_8192f_phy_reg_pg_type3[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x44464646,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x40424244,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x40424244,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x44464646,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x40424244,
	0, 1, 0, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 0, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000834, 0xffffffff, 0x42444446,
	0, 1, 1, 0x00000834, 0xffffffff, 0x42444446,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x44464646,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x44464646,
	0, 1, 0, 0x00000848, 0xffffffff, 0x40424244,
	0, 1, 1, 0x00000848, 0xffffffff, 0x40424244,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x44464646,
	0, 1, 1, 0x00000868, 0xffffffff, 0x40424244
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type3(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE3

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type3) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type3;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type30.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE30
const u32 array_mp_8192f_phy_reg_pg_type30[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type30(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE30

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type30) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type30;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type31.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE31
const u32 array_mp_8192f_phy_reg_pg_type31[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004000,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003800,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x40404000,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x38383800,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x30323234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x40404000,
	0, 1, 1, 0x00000838, 0xffffff00, 0x38383800,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000040,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000038,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x36383838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x30323234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type31(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE31

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type31) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type31;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type4.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE4
const u32 array_mp_8192f_phy_reg_pg_type4[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x30343638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323434,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x28323436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000834, 0xffffffff, 0x30343638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323434,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000848, 0xffffffff, 0x28323436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type4(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE4

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type4) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type4;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type5.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE5
const u32 array_mp_8192f_phy_reg_pg_type5[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x36363600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x36384040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363838,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x32343436,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x30323234,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303032,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x34363638,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303032,
	0, 1, 0, 0x00000838, 0xffffff00, 0x36363600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000036,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x36384040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363838,
	0, 1, 0, 0x00000834, 0xffffffff, 0x32343436,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323234,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000848, 0xffffffff, 0x30323234,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303032,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x34363638,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303032
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type5(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE5

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type5) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type5;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type6.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE6
const u32 array_mp_8192f_phy_reg_pg_type6[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00003400,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x34343400,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x38404040,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x30343638,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x30323434,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x28323436,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x28303234,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x36383840,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x28303234,
	0, 1, 0, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 1, 0x00000838, 0xffffff00, 0x34343400,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000034,
	0, 1, 0, 0x00000830, 0xffffffff, 0x38404040,
	0, 1, 1, 0x00000830, 0xffffffff, 0x34363638,
	0, 1, 0, 0x00000834, 0xffffffff, 0x30343638,
	0, 1, 1, 0x00000834, 0xffffffff, 0x30323434,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x34363840,
	0, 1, 0, 0x00000848, 0xffffffff, 0x28323436,
	0, 1, 1, 0x00000848, 0xffffffff, 0x28303234,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x36383840,
	0, 1, 1, 0x00000868, 0xffffffff, 0x28303234
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type6(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE6

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type6) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type6;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type7.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE7
const u32 array_mp_8192f_phy_reg_pg_type7[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x40424242,
	0, 1, 0, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 0, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 1, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 0, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x00000868, 0xffffffff, 0x40424242
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type7(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE7

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type7) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type7;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type8.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE8
const u32 array_mp_8192f_phy_reg_pg_type8[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x42444444,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x44444444,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x40424242,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x44444444,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x40424242,
	0, 1, 0, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 0, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 1, 0x00000834, 0xffffffff, 0x42444444,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x44444444,
	0, 1, 0, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x00000848, 0xffffffff, 0x40424242,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x44444444,
	0, 1, 1, 0x00000868, 0xffffffff, 0x40424242
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type8(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE8

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type8) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type8;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type9.TXT
 ******************************************************************************/

#ifdef CONFIG_8192F_TYPE9
const u32 array_mp_8192f_phy_reg_pg_type9[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 1, 0x00000e08, 0x0000ff00, 0x00004600,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 1, 0x0000086c, 0xffffff00, 0x46464600,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 1, 0x00000e00, 0xffffffff, 0x46464646,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x42444446,
	0, 0, 1, 0x00000e04, 0xffffffff, 0x42444446,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x44464646,
	0, 0, 1, 0x00000e10, 0xffffffff, 0x44464646,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x40424244,
	0, 0, 1, 0x00000e14, 0xffffffff, 0x40424244,
	0, 0, 1, 0x00000e18, 0xffffffff, 0x44464646,
	0, 0, 1, 0x00000e1c, 0xffffffff, 0x40424244,
	0, 1, 0, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 1, 0x00000838, 0xffffff00, 0x46464600,
	0, 1, 0, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 1, 0x0000086c, 0x000000ff, 0x00000046,
	0, 1, 0, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 1, 0x00000830, 0xffffffff, 0x46464646,
	0, 1, 0, 0x00000834, 0xffffffff, 0x42444446,
	0, 1, 1, 0x00000834, 0xffffffff, 0x42444446,
	0, 1, 0, 0x0000083c, 0xffffffff, 0x44464646,
	0, 1, 1, 0x0000083c, 0xffffffff, 0x44464646,
	0, 1, 0, 0x00000848, 0xffffffff, 0x40424244,
	0, 1, 1, 0x00000848, 0xffffffff, 0x40424244,
	0, 1, 1, 0x0000084c, 0xffffffff, 0x44464646,
	0, 1, 1, 0x00000868, 0xffffffff, 0x40424244
};

#endif

void
odm_read_and_config_mp_8192f_phy_reg_pg_type9(struct dm_struct *dm)
{
#ifdef CONFIG_8192F_TYPE9

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8192f_phy_reg_pg_type9) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8192f_phy_reg_pg_type9;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8192f(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

