/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8197F_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8197f_agc_tab[] = {
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0001F,
		0xC78, 0x0DA0011F,
		0xC78, 0x0D90021F,
		0xC78, 0x0D80031F,
		0xC78, 0x0D70041F,
		0xC78, 0x0D60051F,
		0xC78, 0x0D50061F,
		0xC78, 0x0D40071F,
		0xC78, 0x0D30081F,
		0xC78, 0x0D20091F,
		0xC78, 0x0D100A1F,
		0xC78, 0x0D000B1F,
		0xC78, 0x0CF00C1F,
		0xC78, 0x0CE00D1F,
		0xC78, 0x0CD00E1F,
		0xC78, 0x0CC00F1F,
		0xC78, 0x0CB0101F,
		0xC78, 0x0CA0111F,
		0xC78, 0x0C90121F,
		0xC78, 0x0C80131F,
		0xC78, 0x0C70141F,
		0xC78, 0x0C60151F,
		0xC78, 0x0C50161F,
		0xC78, 0x0C40171F,
		0xC78, 0x0C30181F,
		0xC78, 0x0C20191F,
		0xC78, 0x0C101A1F,
		0xC78, 0x0A501B1F,
		0xC78, 0x0A401C1F,
		0xC78, 0x0A301D1F,
		0xC78, 0x0A201E1F,
		0xC78, 0x0A101F1F,
		0xC78, 0x0A00201F,
		0xC78, 0x0820211F,
		0xC78, 0x0810221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x0630251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x04002B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x00602E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40001F,
		0xC78, 0x0F30011F,
		0xC78, 0x0F20021F,
		0xC78, 0x0F10031F,
		0xC78, 0x0F00041F,
		0xC78, 0x0EF0051F,
		0xC78, 0x0EE0061F,
		0xC78, 0x0ED0071F,
		0xC78, 0x0EC0081F,
		0xC78, 0x0EB0091F,
		0xC78, 0x0EA00A1F,
		0xC78, 0x0E900B1F,
		0xC78, 0x0CD00C1F,
		0xC78, 0x0CC00D1F,
		0xC78, 0x0CB00E1F,
		0xC78, 0x0CA00F1F,
		0xC78, 0x0E40101F,
		0xC78, 0x0E30111F,
		0xC78, 0x0AB0121F,
		0xC78, 0x0AA0131F,
		0xC78, 0x0A90141F,
		0xC78, 0x0A80151F,
		0xC78, 0x0A70161F,
		0xC78, 0x0A60171F,
		0xC78, 0x0A50181F,
		0xC78, 0x0A40191F,
		0xC78, 0x0A301A1F,
		0xC78, 0x0A201B1F,
		0xC78, 0x0A101C1F,
		0xC78, 0x08401D1F,
		0xC78, 0x08301E1F,
		0xC78, 0x08201F1F,
		0xC78, 0x0810201F,
		0xC78, 0x0640211F,
		0xC78, 0x0630221F,
		0xC78, 0x0620231F,
		0xC78, 0x0610241F,
		0xC78, 0x0450251F,
		0xC78, 0x0440261F,
		0xC78, 0x0430271F,
		0xC78, 0x0420281F,
		0xC78, 0x0410291F,
		0xC78, 0x02402A1F,
		0xC78, 0x02302B1F,
		0xC78, 0x02202C1F,
		0xC78, 0x02102D1F,
		0xC78, 0x00502E1F,
		0xC78, 0x00402F1F,
		0xC78, 0x0030301F,
		0xC78, 0x0020311F,
		0xC78, 0x0010321F,
		0xC78, 0x0000331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0BF0001F,
		0xC78, 0x0BF0011F,
		0xC78, 0x0BE0021F,
		0xC78, 0x0BD0031F,
		0xC78, 0x0BC0041F,
		0xC78, 0x0BB0051F,
		0xC78, 0x0BA0061F,
		0xC78, 0x0B90071F,
		0xC78, 0x0B80081F,
		0xC78, 0x0B70091F,
		0xC78, 0x0B600A1F,
		0xC78, 0x0B500B1F,
		0xC78, 0x0B400C1F,
		0xC78, 0x0B300D1F,
		0xC78, 0x0B200E1F,
		0xC78, 0x0B100F1F,
		0xC78, 0x0B00101F,
		0xC78, 0x0AF0111F,
		0xC78, 0x0AE0121F,
		0xC78, 0x0AD0131F,
		0xC78, 0x0AC0141F,
		0xC78, 0x0AB0151F,
		0xC78, 0x0AA0161F,
		0xC78, 0x0A90171F,
		0xC78, 0x0A80181F,
		0xC78, 0x0A70191F,
		0xC78, 0x0A601A1F,
		0xC78, 0x0A501B1F,
		0xC78, 0x0A401C1F,
		0xC78, 0x0A301D1F,
		0xC78, 0x0A201E1F,
		0xC78, 0x0A101F1F,
		0xC78, 0x0A00201F,
		0xC78, 0x0820211F,
		0xC78, 0x0810221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x0630251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x04002B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x00602E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00001F,
		0xC78, 0x0EF0011F,
		0xC78, 0x0EE0021F,
		0xC78, 0x0ED0031F,
		0xC78, 0x0EC0041F,
		0xC78, 0x0EB0051F,
		0xC78, 0x0EA0061F,
		0xC78, 0x0E90071F,
		0xC78, 0x0E80081F,
		0xC78, 0x0E70091F,
		0xC78, 0x0AF00A1F,
		0xC78, 0x0AE00B1F,
		0xC78, 0x0AD00C1F,
		0xC78, 0x0AC00D1F,
		0xC78, 0x0AB00E1F,
		0xC78, 0x0AA00F1F,
		0xC78, 0x0A90101F,
		0xC78, 0x0A80111F,
		0xC78, 0x0A70121F,
		0xC78, 0x0A60131F,
		0xC78, 0x0890141F,
		0xC78, 0x0880151F,
		0xC78, 0x0870161F,
		0xC78, 0x0860171F,
		0xC78, 0x0850181F,
		0xC78, 0x0840191F,
		0xC78, 0x08301A1F,
		0xC78, 0x08201B1F,
		0xC78, 0x08101C1F,
		0xC78, 0x06501D1F,
		0xC78, 0x06401E1F,
		0xC78, 0x06301F1F,
		0xC78, 0x0620201F,
		0xC78, 0x0610211F,
		0xC78, 0x0470221F,
		0xC78, 0x0460231F,
		0xC78, 0x0450241F,
		0xC78, 0x0440251F,
		0xC78, 0x0430261F,
		0xC78, 0x0420271F,
		0xC78, 0x0410281F,
		0xC78, 0x0240291F,
		0xC78, 0x02302A1F,
		0xC78, 0x02202B1F,
		0xC78, 0x02102C1F,
		0xC78, 0x00502D1F,
		0xC78, 0x00402E1F,
		0xC78, 0x00302F1F,
		0xC78, 0x0020301F,
		0xC78, 0x0010311F,
		0xC78, 0x0000321F,
		0xC78, 0x0000331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40001F,
		0xC78, 0x0F30011F,
		0xC78, 0x0F20021F,
		0xC78, 0x0F10031F,
		0xC78, 0x0F00041F,
		0xC78, 0x0D40051F,
		0xC78, 0x0D30061F,
		0xC78, 0x0D20071F,
		0xC78, 0x0D10081F,
		0xC78, 0x0D00091F,
		0xC78, 0x0CF00A1F,
		0xC78, 0x0CE00B1F,
		0xC78, 0x0CD00C1F,
		0xC78, 0x0CC00D1F,
		0xC78, 0x0AF00E1F,
		0xC78, 0x0AE00F1F,
		0xC78, 0x0AD0101F,
		0xC78, 0x0AC0111F,
		0xC78, 0x0AB0121F,
		0xC78, 0x0AA0131F,
		0xC78, 0x0A90141F,
		0xC78, 0x0A80151F,
		0xC78, 0x0A70161F,
		0xC78, 0x0A60171F,
		0xC78, 0x0A50181F,
		0xC78, 0x0A40191F,
		0xC78, 0x0A301A1F,
		0xC78, 0x08501B1F,
		0xC78, 0x08401C1F,
		0xC78, 0x08301D1F,
		0xC78, 0x06701E1F,
		0xC78, 0x06601F1F,
		0xC78, 0x0650201F,
		0xC78, 0x0640211F,
		0xC78, 0x0630221F,
		0xC78, 0x0620231F,
		0xC78, 0x0470241F,
		0xC78, 0x0460251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0270291F,
		0xC78, 0x02602A1F,
		0xC78, 0x02502B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x02202E1F,
		0xC78, 0x02102F1F,
		0xC78, 0x0050301F,
		0xC78, 0x0040311F,
		0xC78, 0x0030321F,
		0xC78, 0x0020331F,
		0xC78, 0x0010341F,
		0xC78, 0x0010351F,
		0xC78, 0x0010361F,
		0xC78, 0x0010371F,
		0xC78, 0x0010381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0BF0001F,
		0xC78, 0x0BF0011F,
		0xC78, 0x0BE0021F,
		0xC78, 0x0BD0031F,
		0xC78, 0x0BC0041F,
		0xC78, 0x0BB0051F,
		0xC78, 0x0BA0061F,
		0xC78, 0x0B90071F,
		0xC78, 0x0B80081F,
		0xC78, 0x0B70091F,
		0xC78, 0x0B600A1F,
		0xC78, 0x0B500B1F,
		0xC78, 0x0B400C1F,
		0xC78, 0x0B300D1F,
		0xC78, 0x0B200E1F,
		0xC78, 0x0B100F1F,
		0xC78, 0x0B00101F,
		0xC78, 0x0AF0111F,
		0xC78, 0x0AE0121F,
		0xC78, 0x0AD0131F,
		0xC78, 0x0AC0141F,
		0xC78, 0x0AB0151F,
		0xC78, 0x0AA0161F,
		0xC78, 0x0A90171F,
		0xC78, 0x0A80181F,
		0xC78, 0x0A70191F,
		0xC78, 0x0A601A1F,
		0xC78, 0x0A501B1F,
		0xC78, 0x0A401C1F,
		0xC78, 0x0A301D1F,
		0xC78, 0x0A201E1F,
		0xC78, 0x0A101F1F,
		0xC78, 0x0A00201F,
		0xC78, 0x0820211F,
		0xC78, 0x0810221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x0630251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x04002B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x00602E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D50001F,
		0xC78, 0x0D40011F,
		0xC78, 0x0D30021F,
		0xC78, 0x0D20031F,
		0xC78, 0x0D10041F,
		0xC78, 0x0D00051F,
		0xC78, 0x0CF0061F,
		0xC78, 0x0CE0071F,
		0xC78, 0x0CD0081F,
		0xC78, 0x0CC0091F,
		0xC78, 0x0CB00A1F,
		0xC78, 0x0CA00B1F,
		0xC78, 0x0C900C1F,
		0xC78, 0x0C800D1F,
		0xC78, 0x0C700E1F,
		0xC78, 0x0C600F1F,
		0xC78, 0x0C50101F,
		0xC78, 0x0C40111F,
		0xC78, 0x0C30121F,
		0xC78, 0x0A80131F,
		0xC78, 0x0A70141F,
		0xC78, 0x0A60151F,
		0xC78, 0x0A50161F,
		0xC78, 0x0A40171F,
		0xC78, 0x0A30181F,
		0xC78, 0x0860191F,
		0xC78, 0x08501A1F,
		0xC78, 0x08401B1F,
		0xC78, 0x08301C1F,
		0xC78, 0x06701D1F,
		0xC78, 0x06601E1F,
		0xC78, 0x06501F1F,
		0xC78, 0x0640201F,
		0xC78, 0x0630211F,
		0xC78, 0x0490221F,
		0xC78, 0x0480231F,
		0xC78, 0x0470241F,
		0xC78, 0x0460251F,
		0xC78, 0x0450261F,
		0xC78, 0x0290271F,
		0xC78, 0x0280281F,
		0xC78, 0x0270291F,
		0xC78, 0x02602A1F,
		0xC78, 0x02502B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x02202E1F,
		0xC78, 0x02102F1F,
		0xC78, 0x0200301F,
		0xC78, 0x0040311F,
		0xC78, 0x0030321F,
		0xC78, 0x0020331F,
		0xC78, 0x0010341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60001F,
		0xC78, 0x0F50011F,
		0xC78, 0x0F40021F,
		0xC78, 0x0F30031F,
		0xC78, 0x0F20041F,
		0xC78, 0x0F10051F,
		0xC78, 0x0F00061F,
		0xC78, 0x0EF0071F,
		0xC78, 0x0EE0081F,
		0xC78, 0x0ED0091F,
		0xC78, 0x0EC00A1F,
		0xC78, 0x0EB00B1F,
		0xC78, 0x0EA00C1F,
		0xC78, 0x0E900D1F,
		0xC78, 0x0E800E1F,
		0xC78, 0x0E700F1F,
		0xC78, 0x0E60101F,
		0xC78, 0x0E50111F,
		0xC78, 0x0E40121F,
		0xC78, 0x0E30131F,
		0xC78, 0x0C70141F,
		0xC78, 0x0C60151F,
		0xC78, 0x0C50161F,
		0xC78, 0x0C40171F,
		0xC78, 0x0C30181F,
		0xC78, 0x0C20191F,
		0xC78, 0x0C101A1F,
		0xC78, 0x0A401B1F,
		0xC78, 0x0A301C1F,
		0xC78, 0x0A201D1F,
		0xC78, 0x0A101E1F,
		0xC78, 0x06801F1F,
		0xC78, 0x0670201F,
		0xC78, 0x0660211F,
		0xC78, 0x0650221F,
		0xC78, 0x0640231F,
		0xC78, 0x0630241F,
		0xC78, 0x0620251F,
		0xC78, 0x0610261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x02502B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x02202E1F,
		0xC78, 0x02102F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20001F,
		0xC78, 0x0F10011F,
		0xC78, 0x0F00021F,
		0xC78, 0x0EF0031F,
		0xC78, 0x0EE0041F,
		0xC78, 0x0ED0051F,
		0xC78, 0x0EC0061F,
		0xC78, 0x0EB0071F,
		0xC78, 0x0EA0081F,
		0xC78, 0x0E90091F,
		0xC78, 0x0E800A1F,
		0xC78, 0x0E700B1F,
		0xC78, 0x0E600C1F,
		0xC78, 0x0E500D1F,
		0xC78, 0x0E400E1F,
		0xC78, 0x0C700F1F,
		0xC78, 0x0C60101F,
		0xC78, 0x0C50111F,
		0xC78, 0x0C40121F,
		0xC78, 0x0C30131F,
		0xC78, 0x0A80141F,
		0xC78, 0x0A70151F,
		0xC78, 0x0A60161F,
		0xC78, 0x0A50171F,
		0xC78, 0x0A40181F,
		0xC78, 0x0A30191F,
		0xC78, 0x08601A1F,
		0xC78, 0x08501B1F,
		0xC78, 0x08401C1F,
		0xC78, 0x08301D1F,
		0xC78, 0x06701E1F,
		0xC78, 0x06601F1F,
		0xC78, 0x0650201F,
		0xC78, 0x0640211F,
		0xC78, 0x0630221F,
		0xC78, 0x0490231F,
		0xC78, 0x0480241F,
		0xC78, 0x0470251F,
		0xC78, 0x0460261F,
		0xC78, 0x0450271F,
		0xC78, 0x0290281F,
		0xC78, 0x0280291F,
		0xC78, 0x02702A1F,
		0xC78, 0x02602B1F,
		0xC78, 0x02502C1F,
		0xC78, 0x02402D1F,
		0xC78, 0x02302E1F,
		0xC78, 0x02202F1F,
		0xC78, 0x0210301F,
		0xC78, 0x0200311F,
		0xC78, 0x0040321F,
		0xC78, 0x0030331F,
		0xC78, 0x0020341F,
		0xC78, 0x0010351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F30001F,
		0xC78, 0x0F30011F,
		0xC78, 0x0F20021F,
		0xC78, 0x0F10031F,
		0xC78, 0x0F00041F,
		0xC78, 0x0EF0051F,
		0xC78, 0x0EE0061F,
		0xC78, 0x0ED0071F,
		0xC78, 0x0EC0081F,
		0xC78, 0x0EB0091F,
		0xC78, 0x0EA00A1F,
		0xC78, 0x0E900B1F,
		0xC78, 0x0E800C1F,
		0xC78, 0x0E700D1F,
		0xC78, 0x0E600E1F,
		0xC78, 0x0E500F1F,
		0xC78, 0x0E30101F,
		0xC78, 0x0E20111F,
		0xC78, 0x0C60121F,
		0xC78, 0x0C50131F,
		0xC78, 0x0C40141F,
		0xC78, 0x0C30151F,
		0xC78, 0x0C20161F,
		0xC78, 0x0C10171F,
		0xC78, 0x0A40181F,
		0xC78, 0x0A30191F,
		0xC78, 0x0A201A1F,
		0xC78, 0x0A101B1F,
		0xC78, 0x08401C1F,
		0xC78, 0x08301D1F,
		0xC78, 0x06701E1F,
		0xC78, 0x06601F1F,
		0xC78, 0x0650201F,
		0xC78, 0x0640211F,
		0xC78, 0x0630221F,
		0xC78, 0x0620231F,
		0xC78, 0x0610241F,
		0xC78, 0x0450251F,
		0xC78, 0x0440261F,
		0xC78, 0x0430271F,
		0xC78, 0x0420281F,
		0xC78, 0x0260291F,
		0xC78, 0x02502A1F,
		0xC78, 0x02402B1F,
		0xC78, 0x02302C1F,
		0xC78, 0x02202D1F,
		0xC78, 0x02102E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0010341F,
		0xC78, 0x0010351F,
		0xC78, 0x0010361F,
		0xC78, 0x0010371F,
		0xC78, 0x0010381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00001F,
		0xC78, 0x0EF0011F,
		0xC78, 0x0EE0021F,
		0xC78, 0x0ED0031F,
		0xC78, 0x0EC0041F,
		0xC78, 0x0EB0051F,
		0xC78, 0x0EA0061F,
		0xC78, 0x0E90071F,
		0xC78, 0x0E80081F,
		0xC78, 0x0B00091F,
		0xC78, 0x0AF00A1F,
		0xC78, 0x0AE00B1F,
		0xC78, 0x0AD00C1F,
		0xC78, 0x0AC00D1F,
		0xC78, 0x0AB00E1F,
		0xC78, 0x0AA00F1F,
		0xC78, 0x0A90101F,
		0xC78, 0x0A80111F,
		0xC78, 0x0A70121F,
		0xC78, 0x0A60131F,
		0xC78, 0x0A50141F,
		0xC78, 0x0A40151F,
		0xC78, 0x0870161F,
		0xC78, 0x0860171F,
		0xC78, 0x0850181F,
		0xC78, 0x0840191F,
		0xC78, 0x08301A1F,
		0xC78, 0x08201B1F,
		0xC78, 0x08101C1F,
		0xC78, 0x08001D1F,
		0xC78, 0x06301E1F,
		0xC78, 0x06201F1F,
		0xC78, 0x0610201F,
		0xC78, 0x0600211F,
		0xC78, 0x0460221F,
		0xC78, 0x0450231F,
		0xC78, 0x0440241F,
		0xC78, 0x0430251F,
		0xC78, 0x0420261F,
		0xC78, 0x0410271F,
		0xC78, 0x0400281F,
		0xC78, 0x0240291F,
		0xC78, 0x02302A1F,
		0xC78, 0x02202B1F,
		0xC78, 0x02102C1F,
		0xC78, 0x02002D1F,
		0xC78, 0x00402E1F,
		0xC78, 0x00302F1F,
		0xC78, 0x0020301F,
		0xC78, 0x0010311F,
		0xC78, 0x0000321F,
		0xC78, 0x0000331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60001F,
		0xC78, 0x0D50011F,
		0xC78, 0x0D40021F,
		0xC78, 0x0D30031F,
		0xC78, 0x0D20041F,
		0xC78, 0x0D10051F,
		0xC78, 0x0D00061F,
		0xC78, 0x0CF0071F,
		0xC78, 0x0CE0081F,
		0xC78, 0x0CD0091F,
		0xC78, 0x0CC00A1F,
		0xC78, 0x0CB00B1F,
		0xC78, 0x0CA00C1F,
		0xC78, 0x0C900D1F,
		0xC78, 0x0C800E1F,
		0xC78, 0x0C700F1F,
		0xC78, 0x0C60101F,
		0xC78, 0x0AA0111F,
		0xC78, 0x0A90121F,
		0xC78, 0x0A80131F,
		0xC78, 0x0A70141F,
		0xC78, 0x0A60151F,
		0xC78, 0x0880161F,
		0xC78, 0x0870171F,
		0xC78, 0x0860181F,
		0xC78, 0x0850191F,
		0xC78, 0x08401A1F,
		0xC78, 0x08301B1F,
		0xC78, 0x08201C1F,
		0xC78, 0x08101D1F,
		0xC78, 0x04A01E1F,
		0xC78, 0x04901F1F,
		0xC78, 0x0480201F,
		0xC78, 0x0470211F,
		0xC78, 0x0460221F,
		0xC78, 0x0450231F,
		0xC78, 0x0440241F,
		0xC78, 0x0430251F,
		0xC78, 0x0420261F,
		0xC78, 0x0410271F,
		0xC78, 0x0240281F,
		0xC78, 0x0230291F,
		0xC78, 0x02202A1F,
		0xC78, 0x02102B1F,
		0xC78, 0x00502C1F,
		0xC78, 0x00402D1F,
		0xC78, 0x00302E1F,
		0xC78, 0x00202F1F,
		0xC78, 0x0010301F,
		0xC78, 0x0000311F,
		0xC78, 0x0000321F,
		0xC78, 0x0000331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60001F,
		0xC78, 0x0D50011F,
		0xC78, 0x0D40021F,
		0xC78, 0x0D30031F,
		0xC78, 0x0D20041F,
		0xC78, 0x0D10051F,
		0xC78, 0x0D00061F,
		0xC78, 0x0CF0071F,
		0xC78, 0x0CE0081F,
		0xC78, 0x0CD0091F,
		0xC78, 0x0CC00A1F,
		0xC78, 0x0CB00B1F,
		0xC78, 0x0CA00C1F,
		0xC78, 0x0C900D1F,
		0xC78, 0x0C800E1F,
		0xC78, 0x0C700F1F,
		0xC78, 0x0C60101F,
		0xC78, 0x0AA0111F,
		0xC78, 0x0A90121F,
		0xC78, 0x0A80131F,
		0xC78, 0x0A70141F,
		0xC78, 0x0A60151F,
		0xC78, 0x0880161F,
		0xC78, 0x0870171F,
		0xC78, 0x0860181F,
		0xC78, 0x0850191F,
		0xC78, 0x08401A1F,
		0xC78, 0x08301B1F,
		0xC78, 0x08201C1F,
		0xC78, 0x08101D1F,
		0xC78, 0x04A01E1F,
		0xC78, 0x04901F1F,
		0xC78, 0x0480201F,
		0xC78, 0x0470211F,
		0xC78, 0x0460221F,
		0xC78, 0x0450231F,
		0xC78, 0x0440241F,
		0xC78, 0x0430251F,
		0xC78, 0x0420261F,
		0xC78, 0x0410271F,
		0xC78, 0x0240281F,
		0xC78, 0x0230291F,
		0xC78, 0x02202A1F,
		0xC78, 0x02102B1F,
		0xC78, 0x00502C1F,
		0xC78, 0x00402D1F,
		0xC78, 0x00302E1F,
		0xC78, 0x00202F1F,
		0xC78, 0x0010301F,
		0xC78, 0x0000311F,
		0xC78, 0x0000321F,
		0xC78, 0x0000331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0001F,
		0xC78, 0x0FB0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0F90031F,
		0xC78, 0x0F80041F,
		0xC78, 0x0F70051F,
		0xC78, 0x0F60061F,
		0xC78, 0x0F50071F,
		0xC78, 0x0F40081F,
		0xC78, 0x0F30091F,
		0xC78, 0x0F200A1F,
		0xC78, 0x0F100B1F,
		0xC78, 0x0F000C1F,
		0xC78, 0x0EF00D1F,
		0xC78, 0x0EE00E1F,
		0xC78, 0x0ED00F1F,
		0xC78, 0x0EC0101F,
		0xC78, 0x0EB0111F,
		0xC78, 0x0EA0121F,
		0xC78, 0x0E90131F,
		0xC78, 0x0E80141F,
		0xC78, 0x0E70151F,
		0xC78, 0x0E60161F,
		0xC78, 0x0E50171F,
		0xC78, 0x0E40181F,
		0xC78, 0x0E30191F,
		0xC78, 0x0C801A1F,
		0xC78, 0x0C701B1F,
		0xC78, 0x0C601C1F,
		0xC78, 0x0C501D1F,
		0xC78, 0x0C401E1F,
		0xC78, 0x0C301F1F,
		0xC78, 0x0A60201F,
		0xC78, 0x0A50211F,
		0xC78, 0x0A40221F,
		0xC78, 0x0A30231F,
		0xC78, 0x0860241F,
		0xC78, 0x0850251F,
		0xC78, 0x0840261F,
		0xC78, 0x0830271F,
		0xC78, 0x0660281F,
		0xC78, 0x0650291F,
		0xC78, 0x04902A1F,
		0xC78, 0x04802B1F,
		0xC78, 0x04702C1F,
		0xC78, 0x04602D1F,
		0xC78, 0x04502E1F,
		0xC78, 0x02802F1F,
		0xC78, 0x0270301F,
		0xC78, 0x0260311F,
		0xC78, 0x0250321F,
		0xC78, 0x0240331F,
		0xC78, 0x0230341F,
		0xC78, 0x0220351F,
		0xC78, 0x0210361F,
		0xC78, 0x0200371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0001F,
		0xC78, 0x0FB0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0F90031F,
		0xC78, 0x0F80041F,
		0xC78, 0x0F70051F,
		0xC78, 0x0F60061F,
		0xC78, 0x0F50071F,
		0xC78, 0x0F40081F,
		0xC78, 0x0F30091F,
		0xC78, 0x0F200A1F,
		0xC78, 0x0F100B1F,
		0xC78, 0x0F000C1F,
		0xC78, 0x0EF00D1F,
		0xC78, 0x0EE00E1F,
		0xC78, 0x0ED00F1F,
		0xC78, 0x0EC0101F,
		0xC78, 0x0EB0111F,
		0xC78, 0x0EA0121F,
		0xC78, 0x0E90131F,
		0xC78, 0x0E80141F,
		0xC78, 0x0CC0151F,
		0xC78, 0x0CB0161F,
		0xC78, 0x0CA0171F,
		0xC78, 0x0C90181F,
		0xC78, 0x0C80191F,
		0xC78, 0x0C701A1F,
		0xC78, 0x0C601B1F,
		0xC78, 0x0C501C1F,
		0xC78, 0x0C401D1F,
		0xC78, 0x0A701E1F,
		0xC78, 0x0A601F1F,
		0xC78, 0x0A50201F,
		0xC78, 0x0A40211F,
		0xC78, 0x0870221F,
		0xC78, 0x0860231F,
		0xC78, 0x0850241F,
		0xC78, 0x0840251F,
		0xC78, 0x0660261F,
		0xC78, 0x0650271F,
		0xC78, 0x0640281F,
		0xC78, 0x0630291F,
		0xC78, 0x06202A1F,
		0xC78, 0x06102B1F,
		0xC78, 0x04702C1F,
		0xC78, 0x04602D1F,
		0xC78, 0x04502E1F,
		0xC78, 0x04402F1F,
		0xC78, 0x0430301F,
		0xC78, 0x0270311F,
		0xC78, 0x0260321F,
		0xC78, 0x0250331F,
		0xC78, 0x0240341F,
		0xC78, 0x0230351F,
		0xC78, 0x0060361F,
		0xC78, 0x0050371F,
		0xC78, 0x0040381F,
		0xC78, 0x0030391F,
		0xC78, 0x00203A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0001F,
		0xC78, 0x0FB0011F,
		0xC78, 0x0FA0021F,
		0xC78, 0x0F90031F,
		0xC78, 0x0F80041F,
		0xC78, 0x0F70051F,
		0xC78, 0x0F60061F,
		0xC78, 0x0F50071F,
		0xC78, 0x0F40081F,
		0xC78, 0x0F30091F,
		0xC78, 0x0F200A1F,
		0xC78, 0x0F100B1F,
		0xC78, 0x0F000C1F,
		0xC78, 0x0EF00D1F,
		0xC78, 0x0EE00E1F,
		0xC78, 0x0ED00F1F,
		0xC78, 0x0EC0101F,
		0xC78, 0x0EB0111F,
		0xC78, 0x0EA0121F,
		0xC78, 0x0E90131F,
		0xC78, 0x0E80141F,
		0xC78, 0x0E70151F,
		0xC78, 0x0E60161F,
		0xC78, 0x0E50171F,
		0xC78, 0x0E40181F,
		0xC78, 0x0E30191F,
		0xC78, 0x0E201A1F,
		0xC78, 0x0E101B1F,
		0xC78, 0x0C401C1F,
		0xC78, 0x0C301D1F,
		0xC78, 0x0C201E1F,
		0xC78, 0x0C101F1F,
		0xC78, 0x0A40201F,
		0xC78, 0x0A30211F,
		0xC78, 0x0A20221F,
		0xC78, 0x0A10231F,
		0xC78, 0x0840241F,
		0xC78, 0x0830251F,
		0xC78, 0x0820261F,
		0xC78, 0x0650271F,
		0xC78, 0x0640281F,
		0xC78, 0x0630291F,
		0xC78, 0x06202A1F,
		0xC78, 0x06102B1F,
		0xC78, 0x04502C1F,
		0xC78, 0x04402D1F,
		0xC78, 0x04302E1F,
		0xC78, 0x04202F1F,
		0xC78, 0x0260301F,
		0xC78, 0x0250311F,
		0xC78, 0x0240321F,
		0xC78, 0x0230331F,
		0xC78, 0x0220341F,
		0xC78, 0x0210351F,
		0xC78, 0x0040361F,
		0xC78, 0x0030371F,
		0xC78, 0x0020381F,
		0xC78, 0x0010391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0001F,
		0xC78, 0x0FC0011F,
		0xC78, 0x0FB0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0F90041F,
		0xC78, 0x0F80051F,
		0xC78, 0x0F70061F,
		0xC78, 0x0F60071F,
		0xC78, 0x0F50081F,
		0xC78, 0x0F40091F,
		0xC78, 0x0F300A1F,
		0xC78, 0x0F200B1F,
		0xC78, 0x0F100C1F,
		0xC78, 0x0F000D1F,
		0xC78, 0x0EF00E1F,
		0xC78, 0x0EE00F1F,
		0xC78, 0x0ED0101F,
		0xC78, 0x0EC0111F,
		0xC78, 0x0EB0121F,
		0xC78, 0x0EA0131F,
		0xC78, 0x0E90141F,
		0xC78, 0x0E80151F,
		0xC78, 0x0E70161F,
		0xC78, 0x0CB0171F,
		0xC78, 0x0CA0181F,
		0xC78, 0x0C90191F,
		0xC78, 0x0C801A1F,
		0xC78, 0x0C701B1F,
		0xC78, 0x0C601C1F,
		0xC78, 0x0C501D1F,
		0xC78, 0x0C401E1F,
		0xC78, 0x0C301F1F,
		0xC78, 0x0C20201F,
		0xC78, 0x0C10211F,
		0xC78, 0x0C00221F,
		0xC78, 0x0A40231F,
		0xC78, 0x0A30241F,
		0xC78, 0x0A20251F,
		0xC78, 0x0840261F,
		0xC78, 0x0830271F,
		0xC78, 0x0820281F,
		0xC78, 0x0810291F,
		0xC78, 0x08002A1F,
		0xC78, 0x06402B1F,
		0xC78, 0x06302C1F,
		0xC78, 0x06202D1F,
		0xC78, 0x04502E1F,
		0xC78, 0x04402F1F,
		0xC78, 0x0430301F,
		0xC78, 0x0420311F,
		0xC78, 0x0410321F,
		0xC78, 0x0400331F,
		0xC78, 0x0070341F,
		0xC78, 0x0060351F,
		0xC78, 0x0050361F,
		0xC78, 0x0040371F,
		0xC78, 0x0030381F,
		0xC78, 0x0020391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0001F,
		0xC78, 0x0FC0011F,
		0xC78, 0x0FB0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0F90041F,
		0xC78, 0x0F80051F,
		0xC78, 0x0F70061F,
		0xC78, 0x0F60071F,
		0xC78, 0x0F50081F,
		0xC78, 0x0F40091F,
		0xC78, 0x0F300A1F,
		0xC78, 0x0F200B1F,
		0xC78, 0x0F100C1F,
		0xC78, 0x0F000D1F,
		0xC78, 0x0EF00E1F,
		0xC78, 0x0EE00F1F,
		0xC78, 0x0ED0101F,
		0xC78, 0x0EC0111F,
		0xC78, 0x0EB0121F,
		0xC78, 0x0EA0131F,
		0xC78, 0x0E90141F,
		0xC78, 0x0E80151F,
		0xC78, 0x0E70161F,
		0xC78, 0x0CB0171F,
		0xC78, 0x0CA0181F,
		0xC78, 0x0C90191F,
		0xC78, 0x0C801A1F,
		0xC78, 0x0C701B1F,
		0xC78, 0x0C601C1F,
		0xC78, 0x0C501D1F,
		0xC78, 0x0C401E1F,
		0xC78, 0x0C301F1F,
		0xC78, 0x0C20201F,
		0xC78, 0x0C10211F,
		0xC78, 0x0C00221F,
		0xC78, 0x0A40231F,
		0xC78, 0x0A30241F,
		0xC78, 0x0A20251F,
		0xC78, 0x0840261F,
		0xC78, 0x0830271F,
		0xC78, 0x0820281F,
		0xC78, 0x0810291F,
		0xC78, 0x08002A1F,
		0xC78, 0x06402B1F,
		0xC78, 0x06302C1F,
		0xC78, 0x06202D1F,
		0xC78, 0x04502E1F,
		0xC78, 0x04402F1F,
		0xC78, 0x0430301F,
		0xC78, 0x0420311F,
		0xC78, 0x0410321F,
		0xC78, 0x0400331F,
		0xC78, 0x0070341F,
		0xC78, 0x0060351F,
		0xC78, 0x0050361F,
		0xC78, 0x0040371F,
		0xC78, 0x0030381F,
		0xC78, 0x0020391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0001F,
		0xC78, 0x0FC0011F,
		0xC78, 0x0FB0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0F90041F,
		0xC78, 0x0F80051F,
		0xC78, 0x0F70061F,
		0xC78, 0x0F60071F,
		0xC78, 0x0F50081F,
		0xC78, 0x0F40091F,
		0xC78, 0x0F300A1F,
		0xC78, 0x0F200B1F,
		0xC78, 0x0F100C1F,
		0xC78, 0x0F000D1F,
		0xC78, 0x0EF00E1F,
		0xC78, 0x0EE00F1F,
		0xC78, 0x0ED0101F,
		0xC78, 0x0EC0111F,
		0xC78, 0x0EB0121F,
		0xC78, 0x0EA0131F,
		0xC78, 0x0E90141F,
		0xC78, 0x0E80151F,
		0xC78, 0x0E70161F,
		0xC78, 0x0E60171F,
		0xC78, 0x0E50181F,
		0xC78, 0x0E40191F,
		0xC78, 0x0C701A1F,
		0xC78, 0x0C601B1F,
		0xC78, 0x0C501C1F,
		0xC78, 0x0C401D1F,
		0xC78, 0x0C301E1F,
		0xC78, 0x0C201F1F,
		0xC78, 0x0C10201F,
		0xC78, 0x0C00211F,
		0xC78, 0x0A40221F,
		0xC78, 0x0A30231F,
		0xC78, 0x0A20241F,
		0xC78, 0x0840251F,
		0xC78, 0x0830261F,
		0xC78, 0x0820271F,
		0xC78, 0x0810281F,
		0xC78, 0x0800291F,
		0xC78, 0x06402A1F,
		0xC78, 0x06302B1F,
		0xC78, 0x06202C1F,
		0xC78, 0x04502D1F,
		0xC78, 0x04402E1F,
		0xC78, 0x04302F1F,
		0xC78, 0x0420301F,
		0xC78, 0x0250311F,
		0xC78, 0x0240321F,
		0xC78, 0x0230331F,
		0xC78, 0x0040341F,
		0xC78, 0x0030351F,
		0xC78, 0x0020361F,
		0xC78, 0x0010371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0001F,
		0xC78, 0x0FC0011F,
		0xC78, 0x0FB0021F,
		0xC78, 0x0FA0031F,
		0xC78, 0x0F90041F,
		0xC78, 0x0F80051F,
		0xC78, 0x0F70061F,
		0xC78, 0x0F60071F,
		0xC78, 0x0F50081F,
		0xC78, 0x0F40091F,
		0xC78, 0x0F300A1F,
		0xC78, 0x0F200B1F,
		0xC78, 0x0F100C1F,
		0xC78, 0x0F000D1F,
		0xC78, 0x0EF00E1F,
		0xC78, 0x0EE00F1F,
		0xC78, 0x0ED0101F,
		0xC78, 0x0EC0111F,
		0xC78, 0x0EB0121F,
		0xC78, 0x0EA0131F,
		0xC78, 0x0E90141F,
		0xC78, 0x0E80151F,
		0xC78, 0x0E70161F,
		0xC78, 0x0CB0171F,
		0xC78, 0x0CA0181F,
		0xC78, 0x0C90191F,
		0xC78, 0x0C801A1F,
		0xC78, 0x0C701B1F,
		0xC78, 0x0C601C1F,
		0xC78, 0x0C501D1F,
		0xC78, 0x0C401E1F,
		0xC78, 0x0C301F1F,
		0xC78, 0x0C20201F,
		0xC78, 0x0C10211F,
		0xC78, 0x0C00221F,
		0xC78, 0x0A40231F,
		0xC78, 0x0A30241F,
		0xC78, 0x0A20251F,
		0xC78, 0x0840261F,
		0xC78, 0x0830271F,
		0xC78, 0x0820281F,
		0xC78, 0x0810291F,
		0xC78, 0x08002A1F,
		0xC78, 0x06402B1F,
		0xC78, 0x06302C1F,
		0xC78, 0x06202D1F,
		0xC78, 0x04402E1F,
		0xC78, 0x04302F1F,
		0xC78, 0x0420301F,
		0xC78, 0x0410311F,
		0xC78, 0x0400321F,
		0xC78, 0x0050331F,
		0xC78, 0x0040341F,
		0xC78, 0x0030351F,
		0xC78, 0x0020361F,
		0xC78, 0x0010371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40001F,
		0xC78, 0x0F30011F,
		0xC78, 0x0F20021F,
		0xC78, 0x0F10031F,
		0xC78, 0x0F00041F,
		0xC78, 0x0D40051F,
		0xC78, 0x0D30061F,
		0xC78, 0x0D20071F,
		0xC78, 0x0D10081F,
		0xC78, 0x0D00091F,
		0xC78, 0x0CF00A1F,
		0xC78, 0x0CE00B1F,
		0xC78, 0x0CD00C1F,
		0xC78, 0x0CC00D1F,
		0xC78, 0x0AF00E1F,
		0xC78, 0x0AE00F1F,
		0xC78, 0x0AD0101F,
		0xC78, 0x0AC0111F,
		0xC78, 0x0AB0121F,
		0xC78, 0x0AA0131F,
		0xC78, 0x0A90141F,
		0xC78, 0x0A80151F,
		0xC78, 0x0A70161F,
		0xC78, 0x0A60171F,
		0xC78, 0x0A50181F,
		0xC78, 0x0A40191F,
		0xC78, 0x0A301A1F,
		0xC78, 0x08601B1F,
		0xC78, 0x08501C1F,
		0xC78, 0x08401D1F,
		0xC78, 0x08301E1F,
		0xC78, 0x08201F1F,
		0xC78, 0x0660201F,
		0xC78, 0x0650211F,
		0xC78, 0x0640221F,
		0xC78, 0x0630231F,
		0xC78, 0x0470241F,
		0xC78, 0x0460251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0260291F,
		0xC78, 0x02502A1F,
		0xC78, 0x02402B1F,
		0xC78, 0x02302C1F,
		0xC78, 0x02202D1F,
		0xC78, 0x02102E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0010341F,
		0xC78, 0x0010351F,
		0xC78, 0x0010361F,
		0xC78, 0x0010371F,
		0xC78, 0x0010381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40001F,
		0xC78, 0x0F30011F,
		0xC78, 0x0F20021F,
		0xC78, 0x0F10031F,
		0xC78, 0x0F00041F,
		0xC78, 0x0D40051F,
		0xC78, 0x0D30061F,
		0xC78, 0x0D20071F,
		0xC78, 0x0D10081F,
		0xC78, 0x0D00091F,
		0xC78, 0x0CF00A1F,
		0xC78, 0x0CE00B1F,
		0xC78, 0x0CD00C1F,
		0xC78, 0x0CC00D1F,
		0xC78, 0x0AF00E1F,
		0xC78, 0x0AE00F1F,
		0xC78, 0x0AD0101F,
		0xC78, 0x0AC0111F,
		0xC78, 0x0AB0121F,
		0xC78, 0x0AA0131F,
		0xC78, 0x0A90141F,
		0xC78, 0x0A80151F,
		0xC78, 0x0A70161F,
		0xC78, 0x0A60171F,
		0xC78, 0x0A50181F,
		0xC78, 0x0A40191F,
		0xC78, 0x0A301A1F,
		0xC78, 0x08601B1F,
		0xC78, 0x08501C1F,
		0xC78, 0x08401D1F,
		0xC78, 0x08301E1F,
		0xC78, 0x08201F1F,
		0xC78, 0x0660201F,
		0xC78, 0x0650211F,
		0xC78, 0x0640221F,
		0xC78, 0x0630231F,
		0xC78, 0x0470241F,
		0xC78, 0x0460251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0260291F,
		0xC78, 0x02502A1F,
		0xC78, 0x02402B1F,
		0xC78, 0x02302C1F,
		0xC78, 0x02202D1F,
		0xC78, 0x02102E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0010341F,
		0xC78, 0x0010351F,
		0xC78, 0x0010361F,
		0xC78, 0x0010371F,
		0xC78, 0x0010381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0001F,
		0xC78, 0x0DA0011F,
		0xC78, 0x0D90021F,
		0xC78, 0x0D80031F,
		0xC78, 0x0D70041F,
		0xC78, 0x0D60051F,
		0xC78, 0x0D50061F,
		0xC78, 0x0D40071F,
		0xC78, 0x0D30081F,
		0xC78, 0x0D20091F,
		0xC78, 0x0D100A1F,
		0xC78, 0x0D000B1F,
		0xC78, 0x0CF00C1F,
		0xC78, 0x0CE00D1F,
		0xC78, 0x0CD00E1F,
		0xC78, 0x0CC00F1F,
		0xC78, 0x0CB0101F,
		0xC78, 0x0CA0111F,
		0xC78, 0x0C90121F,
		0xC78, 0x0C80131F,
		0xC78, 0x0C70141F,
		0xC78, 0x0C60151F,
		0xC78, 0x0C50161F,
		0xC78, 0x0C40171F,
		0xC78, 0x0C30181F,
		0xC78, 0x0C20191F,
		0xC78, 0x0C101A1F,
		0xC78, 0x0A501B1F,
		0xC78, 0x0A401C1F,
		0xC78, 0x0A301D1F,
		0xC78, 0x0A201E1F,
		0xC78, 0x0A101F1F,
		0xC78, 0x0A00201F,
		0xC78, 0x0820211F,
		0xC78, 0x0810221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x0630251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x04002B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x00602E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0001F,
		0xC78, 0x0DA0011F,
		0xC78, 0x0D90021F,
		0xC78, 0x0D80031F,
		0xC78, 0x0D70041F,
		0xC78, 0x0D60051F,
		0xC78, 0x0D50061F,
		0xC78, 0x0D40071F,
		0xC78, 0x0D30081F,
		0xC78, 0x0D20091F,
		0xC78, 0x0D100A1F,
		0xC78, 0x0D000B1F,
		0xC78, 0x0CF00C1F,
		0xC78, 0x0CE00D1F,
		0xC78, 0x0CD00E1F,
		0xC78, 0x0CC00F1F,
		0xC78, 0x0CB0101F,
		0xC78, 0x0CA0111F,
		0xC78, 0x0C90121F,
		0xC78, 0x0C80131F,
		0xC78, 0x0C70141F,
		0xC78, 0x0C60151F,
		0xC78, 0x0C50161F,
		0xC78, 0x0C40171F,
		0xC78, 0x0C30181F,
		0xC78, 0x0C20191F,
		0xC78, 0x0C101A1F,
		0xC78, 0x0A501B1F,
		0xC78, 0x0A401C1F,
		0xC78, 0x0A301D1F,
		0xC78, 0x0A201E1F,
		0xC78, 0x0A101F1F,
		0xC78, 0x0A00201F,
		0xC78, 0x0820211F,
		0xC78, 0x0810221F,
		0xC78, 0x0650231F,
		0xC78, 0x0640241F,
		0xC78, 0x0630251F,
		0xC78, 0x0450261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x04002B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x00602E1F,
		0xC78, 0x00502F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0000341F,
		0xC78, 0x0000351F,
		0xC78, 0x0000361F,
		0xC78, 0x0000371F,
		0xC78, 0x0000381F,
		0xC78, 0x0000391F,
		0xC78, 0x00003A1F,
		0xC78, 0x00003B1F,
		0xC78, 0x00003C1F,
		0xC78, 0x00003D1F,
		0xC78, 0x00003E1F,
		0xC78, 0x00003F1F,
	0xA0000000,	0x00000000,
		0xC78, 0x0FE0001F,
		0xC78, 0x0FD0011F,
		0xC78, 0x0FC0021F,
		0xC78, 0x0FB0031F,
		0xC78, 0x0FA0041F,
		0xC78, 0x0F90051F,
		0xC78, 0x0F80061F,
		0xC78, 0x0F70071F,
		0xC78, 0x0F60081F,
		0xC78, 0x0F50091F,
		0xC78, 0x0F400A1F,
		0xC78, 0x0F300B1F,
		0xC78, 0x0F200C1F,
		0xC78, 0x0F100D1F,
		0xC78, 0x0F000E1F,
		0xC78, 0x0EF00F1F,
		0xC78, 0x0EE0101F,
		0xC78, 0x0ED0111F,
		0xC78, 0x0EC0121F,
		0xC78, 0x0EB0131F,
		0xC78, 0x0EA0141F,
		0xC78, 0x0E90151F,
		0xC78, 0x0E80161F,
		0xC78, 0x0CB0171F,
		0xC78, 0x0CA0181F,
		0xC78, 0x0C90191F,
		0xC78, 0x0C801A1F,
		0xC78, 0x0C701B1F,
		0xC78, 0x0C601C1F,
		0xC78, 0x0C501D1F,
		0xC78, 0x0C401E1F,
		0xC78, 0x0A801F1F,
		0xC78, 0x0A70201F,
		0xC78, 0x0A60211F,
		0xC78, 0x0A50221F,
		0xC78, 0x0A40231F,
		0xC78, 0x0A30241F,
		0xC78, 0x0860251F,
		0xC78, 0x0850261F,
		0xC78, 0x0840271F,
		0xC78, 0x0670281F,
		0xC78, 0x0660291F,
		0xC78, 0x06502A1F,
		0xC78, 0x06402B1F,
		0xC78, 0x04702C1F,
		0xC78, 0x04602D1F,
		0xC78, 0x04502E1F,
		0xC78, 0x02902F1F,
		0xC78, 0x0280301F,
		0xC78, 0x0270311F,
		0xC78, 0x0260321F,
		0xC78, 0x0250331F,
		0xC78, 0x0060341F,
		0xC78, 0x0050351F,
		0xC78, 0x0040361F,
		0xC78, 0x0030371F,
		0xC78, 0x0020381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
	0xB0000000,	0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DC0401F,
		0xC78, 0x0DB0411F,
		0xC78, 0x0DA0421F,
		0xC78, 0x0D90431F,
		0xC78, 0x0D80441F,
		0xC78, 0x0D70451F,
		0xC78, 0x0D60461F,
		0xC78, 0x0D50471F,
		0xC78, 0x0D40481F,
		0xC78, 0x0D30491F,
		0xC78, 0x0D204A1F,
		0xC78, 0x0D104B1F,
		0xC78, 0x0D004C1F,
		0xC78, 0x0CF04D1F,
		0xC78, 0x0CE04E1F,
		0xC78, 0x0CD04F1F,
		0xC78, 0x0B20501F,
		0xC78, 0x0930511F,
		0xC78, 0x0920521F,
		0xC78, 0x0910531F,
		0xC78, 0x0900541F,
		0xC78, 0x08F0551F,
		0xC78, 0x08E0561F,
		0xC78, 0x08D0571F,
		0xC78, 0x08C0581F,
		0xC78, 0x08B0591F,
		0xC78, 0x08A05A1F,
		0xC78, 0x08905B1F,
		0xC78, 0x08805C1F,
		0xC78, 0x08705D1F,
		0xC78, 0x08605E1F,
		0xC78, 0x08505F1F,
		0xC78, 0x0840601F,
		0xC78, 0x0830611F,
		0xC78, 0x0820621F,
		0xC78, 0x0810631F,
		0xC78, 0x0650641F,
		0xC78, 0x0640651F,
		0xC78, 0x0630661F,
		0xC78, 0x0450671F,
		0xC78, 0x0440681F,
		0xC78, 0x0430691F,
		0xC78, 0x04206A1F,
		0xC78, 0x04106B1F,
		0xC78, 0x04006C1F,
		0xC78, 0x02406D1F,
		0xC78, 0x02306E1F,
		0xC78, 0x00606F1F,
		0xC78, 0x0050701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40401F,
		0xC78, 0x0F30411F,
		0xC78, 0x0F20421F,
		0xC78, 0x0F10431F,
		0xC78, 0x0F00441F,
		0xC78, 0x0EF0451F,
		0xC78, 0x0EE0461F,
		0xC78, 0x0ED0471F,
		0xC78, 0x0EC0481F,
		0xC78, 0x0EB0491F,
		0xC78, 0x0EA04A1F,
		0xC78, 0x0E904B1F,
		0xC78, 0x0CD04C1F,
		0xC78, 0x0CC04D1F,
		0xC78, 0x0CB04E1F,
		0xC78, 0x0CA04F1F,
		0xC78, 0x0E40501F,
		0xC78, 0x0E30511F,
		0xC78, 0x0AB0521F,
		0xC78, 0x0AA0531F,
		0xC78, 0x0A90541F,
		0xC78, 0x0A80551F,
		0xC78, 0x0A70561F,
		0xC78, 0x0A60571F,
		0xC78, 0x0A50581F,
		0xC78, 0x0A40591F,
		0xC78, 0x0A305A1F,
		0xC78, 0x0A205B1F,
		0xC78, 0x0A105C1F,
		0xC78, 0x08405D1F,
		0xC78, 0x08305E1F,
		0xC78, 0x08205F1F,
		0xC78, 0x0810601F,
		0xC78, 0x0640611F,
		0xC78, 0x0630621F,
		0xC78, 0x0620631F,
		0xC78, 0x0610641F,
		0xC78, 0x0450651F,
		0xC78, 0x0440661F,
		0xC78, 0x0430671F,
		0xC78, 0x0420681F,
		0xC78, 0x0410691F,
		0xC78, 0x02406A1F,
		0xC78, 0x02306B1F,
		0xC78, 0x02206C1F,
		0xC78, 0x02106D1F,
		0xC78, 0x00506E1F,
		0xC78, 0x00406F1F,
		0xC78, 0x0030701F,
		0xC78, 0x0020711F,
		0xC78, 0x0010721F,
		0xC78, 0x0000731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0BF0401F,
		0xC78, 0x0BF0411F,
		0xC78, 0x0BE0421F,
		0xC78, 0x0BD0431F,
		0xC78, 0x0BC0441F,
		0xC78, 0x0BB0451F,
		0xC78, 0x0BA0461F,
		0xC78, 0x0B90471F,
		0xC78, 0x0B80481F,
		0xC78, 0x0B70491F,
		0xC78, 0x0B604A1F,
		0xC78, 0x0B504B1F,
		0xC78, 0x0B404C1F,
		0xC78, 0x0B304D1F,
		0xC78, 0x0B204E1F,
		0xC78, 0x0B104F1F,
		0xC78, 0x0B00501F,
		0xC78, 0x0AF0511F,
		0xC78, 0x0AE0521F,
		0xC78, 0x0AD0531F,
		0xC78, 0x0AC0541F,
		0xC78, 0x0AB0551F,
		0xC78, 0x0AA0561F,
		0xC78, 0x0A90571F,
		0xC78, 0x0A80581F,
		0xC78, 0x0A70591F,
		0xC78, 0x0A605A1F,
		0xC78, 0x0A505B1F,
		0xC78, 0x0A405C1F,
		0xC78, 0x0A305D1F,
		0xC78, 0x0A205E1F,
		0xC78, 0x0A105F1F,
		0xC78, 0x0A00601F,
		0xC78, 0x0820611F,
		0xC78, 0x0810621F,
		0xC78, 0x0650631F,
		0xC78, 0x0640641F,
		0xC78, 0x0630651F,
		0xC78, 0x0450661F,
		0xC78, 0x0440671F,
		0xC78, 0x0430681F,
		0xC78, 0x0420691F,
		0xC78, 0x04106A1F,
		0xC78, 0x04006B1F,
		0xC78, 0x02406C1F,
		0xC78, 0x02306D1F,
		0xC78, 0x00606E1F,
		0xC78, 0x00506F1F,
		0xC78, 0x0040701F,
		0xC78, 0x0030711F,
		0xC78, 0x0020721F,
		0xC78, 0x0010731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00401F,
		0xC78, 0x0EF0411F,
		0xC78, 0x0EE0421F,
		0xC78, 0x0ED0431F,
		0xC78, 0x0EC0441F,
		0xC78, 0x0EB0451F,
		0xC78, 0x0EA0461F,
		0xC78, 0x0E90471F,
		0xC78, 0x0E80481F,
		0xC78, 0x0E70491F,
		0xC78, 0x0AF04A1F,
		0xC78, 0x0AE04B1F,
		0xC78, 0x0AD04C1F,
		0xC78, 0x0AC04D1F,
		0xC78, 0x0AB04E1F,
		0xC78, 0x0AA04F1F,
		0xC78, 0x0A90501F,
		0xC78, 0x0A80511F,
		0xC78, 0x0A70521F,
		0xC78, 0x0A60531F,
		0xC78, 0x0890541F,
		0xC78, 0x0880551F,
		0xC78, 0x0870561F,
		0xC78, 0x0860571F,
		0xC78, 0x0850581F,
		0xC78, 0x0840591F,
		0xC78, 0x08305A1F,
		0xC78, 0x08205B1F,
		0xC78, 0x08105C1F,
		0xC78, 0x06505D1F,
		0xC78, 0x06405E1F,
		0xC78, 0x06305F1F,
		0xC78, 0x0620601F,
		0xC78, 0x0610611F,
		0xC78, 0x0470621F,
		0xC78, 0x0460631F,
		0xC78, 0x0450641F,
		0xC78, 0x0440651F,
		0xC78, 0x0430661F,
		0xC78, 0x0420671F,
		0xC78, 0x0410681F,
		0xC78, 0x0240691F,
		0xC78, 0x02306A1F,
		0xC78, 0x02206B1F,
		0xC78, 0x02106C1F,
		0xC78, 0x00506D1F,
		0xC78, 0x00406E1F,
		0xC78, 0x00306F1F,
		0xC78, 0x0020701F,
		0xC78, 0x0010711F,
		0xC78, 0x0000721F,
		0xC78, 0x0000731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40401F,
		0xC78, 0x0F30411F,
		0xC78, 0x0F20421F,
		0xC78, 0x0F10431F,
		0xC78, 0x0F00441F,
		0xC78, 0x0D40451F,
		0xC78, 0x0D30461F,
		0xC78, 0x0D20471F,
		0xC78, 0x0D10481F,
		0xC78, 0x0D00491F,
		0xC78, 0x0CF04A1F,
		0xC78, 0x0CE04B1F,
		0xC78, 0x0CD04C1F,
		0xC78, 0x0CC04D1F,
		0xC78, 0x0AF04E1F,
		0xC78, 0x0AE04F1F,
		0xC78, 0x0AD0501F,
		0xC78, 0x0AC0511F,
		0xC78, 0x0AB0521F,
		0xC78, 0x0AA0531F,
		0xC78, 0x0A90541F,
		0xC78, 0x0A80551F,
		0xC78, 0x0A70561F,
		0xC78, 0x0A60571F,
		0xC78, 0x0A50581F,
		0xC78, 0x0A40591F,
		0xC78, 0x0A305A1F,
		0xC78, 0x08505B1F,
		0xC78, 0x08405C1F,
		0xC78, 0x08305D1F,
		0xC78, 0x06705E1F,
		0xC78, 0x06605F1F,
		0xC78, 0x0650601F,
		0xC78, 0x0640611F,
		0xC78, 0x0630621F,
		0xC78, 0x0620631F,
		0xC78, 0x0470641F,
		0xC78, 0x0460651F,
		0xC78, 0x0450661F,
		0xC78, 0x0440671F,
		0xC78, 0x0430681F,
		0xC78, 0x0270691F,
		0xC78, 0x02606A1F,
		0xC78, 0x02506B1F,
		0xC78, 0x02406C1F,
		0xC78, 0x02306D1F,
		0xC78, 0x02206E1F,
		0xC78, 0x02106F1F,
		0xC78, 0x0050701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0010751F,
		0xC78, 0x0010761F,
		0xC78, 0x0010771F,
		0xC78, 0x0010781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0BF0401F,
		0xC78, 0x0BF0411F,
		0xC78, 0x0BE0421F,
		0xC78, 0x0BD0431F,
		0xC78, 0x0BC0441F,
		0xC78, 0x0BB0451F,
		0xC78, 0x0BA0461F,
		0xC78, 0x0B90471F,
		0xC78, 0x0B80481F,
		0xC78, 0x0B70491F,
		0xC78, 0x0B604A1F,
		0xC78, 0x0B504B1F,
		0xC78, 0x0B404C1F,
		0xC78, 0x0B304D1F,
		0xC78, 0x0B204E1F,
		0xC78, 0x0B104F1F,
		0xC78, 0x0B00501F,
		0xC78, 0x0AF0511F,
		0xC78, 0x0AE0521F,
		0xC78, 0x0AD0531F,
		0xC78, 0x0AC0541F,
		0xC78, 0x0AB0551F,
		0xC78, 0x0AA0561F,
		0xC78, 0x0A90571F,
		0xC78, 0x0A80581F,
		0xC78, 0x0A70591F,
		0xC78, 0x0A605A1F,
		0xC78, 0x0A505B1F,
		0xC78, 0x0A405C1F,
		0xC78, 0x0A305D1F,
		0xC78, 0x0A205E1F,
		0xC78, 0x0A105F1F,
		0xC78, 0x0A00601F,
		0xC78, 0x0820611F,
		0xC78, 0x0810621F,
		0xC78, 0x0650631F,
		0xC78, 0x0640641F,
		0xC78, 0x0630651F,
		0xC78, 0x0450661F,
		0xC78, 0x0440671F,
		0xC78, 0x0430681F,
		0xC78, 0x0420691F,
		0xC78, 0x04106A1F,
		0xC78, 0x04006B1F,
		0xC78, 0x02406C1F,
		0xC78, 0x02306D1F,
		0xC78, 0x00606E1F,
		0xC78, 0x00506F1F,
		0xC78, 0x0040701F,
		0xC78, 0x0030711F,
		0xC78, 0x0020721F,
		0xC78, 0x0010731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F10401F,
		0xC78, 0x0F00411F,
		0xC78, 0x0EF0421F,
		0xC78, 0x0EE0431F,
		0xC78, 0x0ED0441F,
		0xC78, 0x0EC0451F,
		0xC78, 0x0EB0461F,
		0xC78, 0x0EA0471F,
		0xC78, 0x0E90481F,
		0xC78, 0x0E80491F,
		0xC78, 0x0E704A1F,
		0xC78, 0x0E604B1F,
		0xC78, 0x0E504C1F,
		0xC78, 0x0E404D1F,
		0xC78, 0x0C704E1F,
		0xC78, 0x0C604F1F,
		0xC78, 0x0C50501F,
		0xC78, 0x0C40511F,
		0xC78, 0x0C30521F,
		0xC78, 0x0A80531F,
		0xC78, 0x0A70541F,
		0xC78, 0x0A60551F,
		0xC78, 0x0A50561F,
		0xC78, 0x0A40571F,
		0xC78, 0x0A30581F,
		0xC78, 0x0860591F,
		0xC78, 0x08505A1F,
		0xC78, 0x08405B1F,
		0xC78, 0x08305C1F,
		0xC78, 0x06705D1F,
		0xC78, 0x06605E1F,
		0xC78, 0x06505F1F,
		0xC78, 0x0640601F,
		0xC78, 0x0630611F,
		0xC78, 0x0490621F,
		0xC78, 0x0480631F,
		0xC78, 0x0470641F,
		0xC78, 0x0460651F,
		0xC78, 0x0450661F,
		0xC78, 0x0290671F,
		0xC78, 0x0280681F,
		0xC78, 0x0270691F,
		0xC78, 0x02606A1F,
		0xC78, 0x02506B1F,
		0xC78, 0x02406C1F,
		0xC78, 0x02306D1F,
		0xC78, 0x02206E1F,
		0xC78, 0x02106F1F,
		0xC78, 0x0200701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60401F,
		0xC78, 0x0F60411F,
		0xC78, 0x0F50421F,
		0xC78, 0x0F40431F,
		0xC78, 0x0F30441F,
		0xC78, 0x0F20451F,
		0xC78, 0x0F10461F,
		0xC78, 0x0F00471F,
		0xC78, 0x0EF0481F,
		0xC78, 0x0EE0491F,
		0xC78, 0x0ED04A1F,
		0xC78, 0x0EC04B1F,
		0xC78, 0x0EB04C1F,
		0xC78, 0x0EA04D1F,
		0xC78, 0x0E904E1F,
		0xC78, 0x0E804F1F,
		0xC78, 0x0E70501F,
		0xC78, 0x0E60511F,
		0xC78, 0x0E50521F,
		0xC78, 0x0E40531F,
		0xC78, 0x0E30541F,
		0xC78, 0x0C70551F,
		0xC78, 0x0C60561F,
		0xC78, 0x0C50571F,
		0xC78, 0x0C40581F,
		0xC78, 0x0C30591F,
		0xC78, 0x0C205A1F,
		0xC78, 0x0C105B1F,
		0xC78, 0x0A405C1F,
		0xC78, 0x0A305D1F,
		0xC78, 0x0A205E1F,
		0xC78, 0x0A105F1F,
		0xC78, 0x0670601F,
		0xC78, 0x0660611F,
		0xC78, 0x0650621F,
		0xC78, 0x0640631F,
		0xC78, 0x0630641F,
		0xC78, 0x0620651F,
		0xC78, 0x0610661F,
		0xC78, 0x0450671F,
		0xC78, 0x0440681F,
		0xC78, 0x0430691F,
		0xC78, 0x04206A1F,
		0xC78, 0x04106B1F,
		0xC78, 0x02506C1F,
		0xC78, 0x02406D1F,
		0xC78, 0x02306E1F,
		0xC78, 0x02206F1F,
		0xC78, 0x0210701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0010751F,
		0xC78, 0x0010761F,
		0xC78, 0x0010771F,
		0xC78, 0x0010781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20401F,
		0xC78, 0x0F10411F,
		0xC78, 0x0F00421F,
		0xC78, 0x0EF0431F,
		0xC78, 0x0EE0441F,
		0xC78, 0x0ED0451F,
		0xC78, 0x0EC0461F,
		0xC78, 0x0EB0471F,
		0xC78, 0x0EA0481F,
		0xC78, 0x0E90491F,
		0xC78, 0x0E804A1F,
		0xC78, 0x0E704B1F,
		0xC78, 0x0E604C1F,
		0xC78, 0x0E504D1F,
		0xC78, 0x0E404E1F,
		0xC78, 0x0C704F1F,
		0xC78, 0x0C60501F,
		0xC78, 0x0C50511F,
		0xC78, 0x0C40521F,
		0xC78, 0x0C30531F,
		0xC78, 0x0A80541F,
		0xC78, 0x0A70551F,
		0xC78, 0x0A60561F,
		0xC78, 0x0A50571F,
		0xC78, 0x0A40581F,
		0xC78, 0x0A30591F,
		0xC78, 0x08605A1F,
		0xC78, 0x08505B1F,
		0xC78, 0x08405C1F,
		0xC78, 0x08305D1F,
		0xC78, 0x06705E1F,
		0xC78, 0x06605F1F,
		0xC78, 0x0650601F,
		0xC78, 0x0640611F,
		0xC78, 0x0630621F,
		0xC78, 0x0490631F,
		0xC78, 0x0480641F,
		0xC78, 0x0470651F,
		0xC78, 0x0460661F,
		0xC78, 0x0450671F,
		0xC78, 0x0290681F,
		0xC78, 0x0280691F,
		0xC78, 0x02706A1F,
		0xC78, 0x02606B1F,
		0xC78, 0x02506C1F,
		0xC78, 0x02406D1F,
		0xC78, 0x02306E1F,
		0xC78, 0x02206F1F,
		0xC78, 0x0210701F,
		0xC78, 0x0200711F,
		0xC78, 0x0040721F,
		0xC78, 0x0030731F,
		0xC78, 0x0020741F,
		0xC78, 0x0010751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F30401F,
		0xC78, 0x0F30411F,
		0xC78, 0x0F20421F,
		0xC78, 0x0F10431F,
		0xC78, 0x0F00441F,
		0xC78, 0x0EF0451F,
		0xC78, 0x0EE0461F,
		0xC78, 0x0ED0471F,
		0xC78, 0x0EC0481F,
		0xC78, 0x0EB0491F,
		0xC78, 0x0EA04A1F,
		0xC78, 0x0E904B1F,
		0xC78, 0x0E804C1F,
		0xC78, 0x0E704D1F,
		0xC78, 0x0E604E1F,
		0xC78, 0x0E504F1F,
		0xC78, 0x0E30501F,
		0xC78, 0x0E20511F,
		0xC78, 0x0C60521F,
		0xC78, 0x0C50531F,
		0xC78, 0x0C40541F,
		0xC78, 0x0C30551F,
		0xC78, 0x0C20561F,
		0xC78, 0x0C10571F,
		0xC78, 0x0A40581F,
		0xC78, 0x0A30591F,
		0xC78, 0x0A205A1F,
		0xC78, 0x0A105B1F,
		0xC78, 0x08405C1F,
		0xC78, 0x08305D1F,
		0xC78, 0x06705E1F,
		0xC78, 0x06605F1F,
		0xC78, 0x0650601F,
		0xC78, 0x0640611F,
		0xC78, 0x0630621F,
		0xC78, 0x0620631F,
		0xC78, 0x0610641F,
		0xC78, 0x0450651F,
		0xC78, 0x0440661F,
		0xC78, 0x0430671F,
		0xC78, 0x0420681F,
		0xC78, 0x0260691F,
		0xC78, 0x02506A1F,
		0xC78, 0x02406B1F,
		0xC78, 0x02306C1F,
		0xC78, 0x02206D1F,
		0xC78, 0x02106E1F,
		0xC78, 0x00506F1F,
		0xC78, 0x0040701F,
		0xC78, 0x0030711F,
		0xC78, 0x0020721F,
		0xC78, 0x0010731F,
		0xC78, 0x0010741F,
		0xC78, 0x0010751F,
		0xC78, 0x0010761F,
		0xC78, 0x0010771F,
		0xC78, 0x0010781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00401F,
		0xC78, 0x0EF0411F,
		0xC78, 0x0EE0421F,
		0xC78, 0x0ED0431F,
		0xC78, 0x0EC0441F,
		0xC78, 0x0EB0451F,
		0xC78, 0x0EA0461F,
		0xC78, 0x0E90471F,
		0xC78, 0x0E80481F,
		0xC78, 0x0B00491F,
		0xC78, 0x0AF04A1F,
		0xC78, 0x0AE04B1F,
		0xC78, 0x0AD04C1F,
		0xC78, 0x0AC04D1F,
		0xC78, 0x0AB04E1F,
		0xC78, 0x0AA04F1F,
		0xC78, 0x0A90501F,
		0xC78, 0x0A80511F,
		0xC78, 0x0A70521F,
		0xC78, 0x0A60531F,
		0xC78, 0x0A50541F,
		0xC78, 0x0A40551F,
		0xC78, 0x0870561F,
		0xC78, 0x0860571F,
		0xC78, 0x0850581F,
		0xC78, 0x0840591F,
		0xC78, 0x08305A1F,
		0xC78, 0x08205B1F,
		0xC78, 0x08105C1F,
		0xC78, 0x08005D1F,
		0xC78, 0x06305E1F,
		0xC78, 0x06205F1F,
		0xC78, 0x0610601F,
		0xC78, 0x0600611F,
		0xC78, 0x0460621F,
		0xC78, 0x0450631F,
		0xC78, 0x0440641F,
		0xC78, 0x0430651F,
		0xC78, 0x0420661F,
		0xC78, 0x0410671F,
		0xC78, 0x0400681F,
		0xC78, 0x0240691F,
		0xC78, 0x02306A1F,
		0xC78, 0x02206B1F,
		0xC78, 0x02106C1F,
		0xC78, 0x02006D1F,
		0xC78, 0x00406E1F,
		0xC78, 0x00306F1F,
		0xC78, 0x0020701F,
		0xC78, 0x0010711F,
		0xC78, 0x0000721F,
		0xC78, 0x0000731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60401F,
		0xC78, 0x0D50411F,
		0xC78, 0x0D40421F,
		0xC78, 0x0D30431F,
		0xC78, 0x0D20441F,
		0xC78, 0x0D10451F,
		0xC78, 0x0D00461F,
		0xC78, 0x0CF0471F,
		0xC78, 0x0CE0481F,
		0xC78, 0x0CD0491F,
		0xC78, 0x0CC04A1F,
		0xC78, 0x0CB04B1F,
		0xC78, 0x0CA04C1F,
		0xC78, 0x0C904D1F,
		0xC78, 0x0C804E1F,
		0xC78, 0x0C704F1F,
		0xC78, 0x0C60501F,
		0xC78, 0x0AA0511F,
		0xC78, 0x0A90521F,
		0xC78, 0x0A80531F,
		0xC78, 0x0A70541F,
		0xC78, 0x0A60551F,
		0xC78, 0x0880561F,
		0xC78, 0x0870571F,
		0xC78, 0x0860581F,
		0xC78, 0x0850591F,
		0xC78, 0x08405A1F,
		0xC78, 0x08305B1F,
		0xC78, 0x08205C1F,
		0xC78, 0x08105D1F,
		0xC78, 0x04A05E1F,
		0xC78, 0x04905F1F,
		0xC78, 0x0480601F,
		0xC78, 0x0470611F,
		0xC78, 0x0460621F,
		0xC78, 0x0450631F,
		0xC78, 0x0440641F,
		0xC78, 0x0430651F,
		0xC78, 0x0420661F,
		0xC78, 0x0410671F,
		0xC78, 0x0240681F,
		0xC78, 0x0230691F,
		0xC78, 0x02206A1F,
		0xC78, 0x02106B1F,
		0xC78, 0x00506C1F,
		0xC78, 0x00406D1F,
		0xC78, 0x00306E1F,
		0xC78, 0x00206F1F,
		0xC78, 0x0010701F,
		0xC78, 0x0000711F,
		0xC78, 0x0000721F,
		0xC78, 0x0000731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60401F,
		0xC78, 0x0D50411F,
		0xC78, 0x0D40421F,
		0xC78, 0x0D30431F,
		0xC78, 0x0D20441F,
		0xC78, 0x0D10451F,
		0xC78, 0x0D00461F,
		0xC78, 0x0CF0471F,
		0xC78, 0x0CE0481F,
		0xC78, 0x0CD0491F,
		0xC78, 0x0CC04A1F,
		0xC78, 0x0CB04B1F,
		0xC78, 0x0CA04C1F,
		0xC78, 0x0C904D1F,
		0xC78, 0x0C804E1F,
		0xC78, 0x0C704F1F,
		0xC78, 0x0C60501F,
		0xC78, 0x0AA0511F,
		0xC78, 0x0A90521F,
		0xC78, 0x0A80531F,
		0xC78, 0x0A70541F,
		0xC78, 0x0A60551F,
		0xC78, 0x0880561F,
		0xC78, 0x0870571F,
		0xC78, 0x0860581F,
		0xC78, 0x0850591F,
		0xC78, 0x08405A1F,
		0xC78, 0x08305B1F,
		0xC78, 0x08205C1F,
		0xC78, 0x08105D1F,
		0xC78, 0x04A05E1F,
		0xC78, 0x04905F1F,
		0xC78, 0x0480601F,
		0xC78, 0x0470611F,
		0xC78, 0x0460621F,
		0xC78, 0x0450631F,
		0xC78, 0x0440641F,
		0xC78, 0x0430651F,
		0xC78, 0x0420661F,
		0xC78, 0x0410671F,
		0xC78, 0x0240681F,
		0xC78, 0x0230691F,
		0xC78, 0x02206A1F,
		0xC78, 0x02106B1F,
		0xC78, 0x00506C1F,
		0xC78, 0x00406D1F,
		0xC78, 0x00306E1F,
		0xC78, 0x00206F1F,
		0xC78, 0x0010701F,
		0xC78, 0x0000711F,
		0xC78, 0x0000721F,
		0xC78, 0x0000731F,
		0xC78, 0x0000741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0401F,
		0xC78, 0x0FB0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0F90431F,
		0xC78, 0x0F80441F,
		0xC78, 0x0F70451F,
		0xC78, 0x0F60461F,
		0xC78, 0x0F50471F,
		0xC78, 0x0F40481F,
		0xC78, 0x0F30491F,
		0xC78, 0x0F204A1F,
		0xC78, 0x0F104B1F,
		0xC78, 0x0F004C1F,
		0xC78, 0x0EF04D1F,
		0xC78, 0x0EE04E1F,
		0xC78, 0x0ED04F1F,
		0xC78, 0x0EC0501F,
		0xC78, 0x0EB0511F,
		0xC78, 0x0EA0521F,
		0xC78, 0x0E90531F,
		0xC78, 0x0E80541F,
		0xC78, 0x0E70551F,
		0xC78, 0x0E60561F,
		0xC78, 0x0E50571F,
		0xC78, 0x0E40581F,
		0xC78, 0x0E30591F,
		0xC78, 0x0C805A1F,
		0xC78, 0x0C705B1F,
		0xC78, 0x0C605C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0C305F1F,
		0xC78, 0x0A60601F,
		0xC78, 0x0A50611F,
		0xC78, 0x0A40621F,
		0xC78, 0x0A30631F,
		0xC78, 0x0860641F,
		0xC78, 0x0850651F,
		0xC78, 0x0840661F,
		0xC78, 0x0830671F,
		0xC78, 0x0660681F,
		0xC78, 0x0650691F,
		0xC78, 0x04906A1F,
		0xC78, 0x04806B1F,
		0xC78, 0x04706C1F,
		0xC78, 0x04606D1F,
		0xC78, 0x04506E1F,
		0xC78, 0x02806F1F,
		0xC78, 0x0270701F,
		0xC78, 0x0260711F,
		0xC78, 0x0250721F,
		0xC78, 0x0240731F,
		0xC78, 0x0230741F,
		0xC78, 0x0220751F,
		0xC78, 0x0210761F,
		0xC78, 0x0200771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0401F,
		0xC78, 0x0FB0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0F90431F,
		0xC78, 0x0F80441F,
		0xC78, 0x0F70451F,
		0xC78, 0x0F60461F,
		0xC78, 0x0F50471F,
		0xC78, 0x0F40481F,
		0xC78, 0x0F30491F,
		0xC78, 0x0F204A1F,
		0xC78, 0x0F104B1F,
		0xC78, 0x0F004C1F,
		0xC78, 0x0EF04D1F,
		0xC78, 0x0EE04E1F,
		0xC78, 0x0ED04F1F,
		0xC78, 0x0EC0501F,
		0xC78, 0x0EB0511F,
		0xC78, 0x0EA0521F,
		0xC78, 0x0E90531F,
		0xC78, 0x0E80541F,
		0xC78, 0x0CC0551F,
		0xC78, 0x0CB0561F,
		0xC78, 0x0CA0571F,
		0xC78, 0x0C90581F,
		0xC78, 0x0C80591F,
		0xC78, 0x0C705A1F,
		0xC78, 0x0C605B1F,
		0xC78, 0x0C505C1F,
		0xC78, 0x0C405D1F,
		0xC78, 0x0A705E1F,
		0xC78, 0x0A605F1F,
		0xC78, 0x0A50601F,
		0xC78, 0x0A40611F,
		0xC78, 0x0870621F,
		0xC78, 0x0860631F,
		0xC78, 0x0850641F,
		0xC78, 0x0840651F,
		0xC78, 0x0660661F,
		0xC78, 0x0650671F,
		0xC78, 0x0640681F,
		0xC78, 0x0630691F,
		0xC78, 0x06206A1F,
		0xC78, 0x06106B1F,
		0xC78, 0x04706C1F,
		0xC78, 0x04606D1F,
		0xC78, 0x04506E1F,
		0xC78, 0x04406F1F,
		0xC78, 0x0430701F,
		0xC78, 0x0270711F,
		0xC78, 0x0260721F,
		0xC78, 0x0250731F,
		0xC78, 0x0240741F,
		0xC78, 0x0230751F,
		0xC78, 0x0060761F,
		0xC78, 0x0050771F,
		0xC78, 0x0040781F,
		0xC78, 0x0030791F,
		0xC78, 0x00207A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0401F,
		0xC78, 0x0FB0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0F90431F,
		0xC78, 0x0F80441F,
		0xC78, 0x0F70451F,
		0xC78, 0x0F60461F,
		0xC78, 0x0F50471F,
		0xC78, 0x0F40481F,
		0xC78, 0x0F30491F,
		0xC78, 0x0F204A1F,
		0xC78, 0x0F104B1F,
		0xC78, 0x0F004C1F,
		0xC78, 0x0EF04D1F,
		0xC78, 0x0EE04E1F,
		0xC78, 0x0ED04F1F,
		0xC78, 0x0EC0501F,
		0xC78, 0x0EB0511F,
		0xC78, 0x0EA0521F,
		0xC78, 0x0E90531F,
		0xC78, 0x0E80541F,
		0xC78, 0x0E70551F,
		0xC78, 0x0E60561F,
		0xC78, 0x0E50571F,
		0xC78, 0x0E40581F,
		0xC78, 0x0E30591F,
		0xC78, 0x0E205A1F,
		0xC78, 0x0E105B1F,
		0xC78, 0x0C405C1F,
		0xC78, 0x0C305D1F,
		0xC78, 0x0C205E1F,
		0xC78, 0x0C105F1F,
		0xC78, 0x0A40601F,
		0xC78, 0x0A30611F,
		0xC78, 0x0A20621F,
		0xC78, 0x0A10631F,
		0xC78, 0x0840641F,
		0xC78, 0x0830651F,
		0xC78, 0x0820661F,
		0xC78, 0x0650671F,
		0xC78, 0x0640681F,
		0xC78, 0x0630691F,
		0xC78, 0x06206A1F,
		0xC78, 0x06106B1F,
		0xC78, 0x04506C1F,
		0xC78, 0x04406D1F,
		0xC78, 0x04306E1F,
		0xC78, 0x04206F1F,
		0xC78, 0x0260701F,
		0xC78, 0x0250711F,
		0xC78, 0x0240721F,
		0xC78, 0x0230731F,
		0xC78, 0x0220741F,
		0xC78, 0x0210751F,
		0xC78, 0x0040761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0401F,
		0xC78, 0x0FB0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0F90431F,
		0xC78, 0x0F80441F,
		0xC78, 0x0F70451F,
		0xC78, 0x0F60461F,
		0xC78, 0x0F50471F,
		0xC78, 0x0F40481F,
		0xC78, 0x0F30491F,
		0xC78, 0x0F204A1F,
		0xC78, 0x0F104B1F,
		0xC78, 0x0F004C1F,
		0xC78, 0x0EF04D1F,
		0xC78, 0x0EE04E1F,
		0xC78, 0x0ED04F1F,
		0xC78, 0x0EC0501F,
		0xC78, 0x0EB0511F,
		0xC78, 0x0EA0521F,
		0xC78, 0x0E90531F,
		0xC78, 0x0E80541F,
		0xC78, 0x0E70551F,
		0xC78, 0x0CA0561F,
		0xC78, 0x0C90571F,
		0xC78, 0x0C80581F,
		0xC78, 0x0C70591F,
		0xC78, 0x0C605A1F,
		0xC78, 0x0C505B1F,
		0xC78, 0x0C405C1F,
		0xC78, 0x0C305D1F,
		0xC78, 0x0C205E1F,
		0xC78, 0x0C105F1F,
		0xC78, 0x0C00601F,
		0xC78, 0x0A30611F,
		0xC78, 0x0A20621F,
		0xC78, 0x0A10631F,
		0xC78, 0x0840641F,
		0xC78, 0x0830651F,
		0xC78, 0x0820661F,
		0xC78, 0x0810671F,
		0xC78, 0x0800681F,
		0xC78, 0x0630691F,
		0xC78, 0x06206A1F,
		0xC78, 0x06106B1F,
		0xC78, 0x04506C1F,
		0xC78, 0x04406D1F,
		0xC78, 0x04306E1F,
		0xC78, 0x04206F1F,
		0xC78, 0x0410701F,
		0xC78, 0x0400711F,
		0xC78, 0x0080721F,
		0xC78, 0x0070731F,
		0xC78, 0x0060741F,
		0xC78, 0x0050751F,
		0xC78, 0x0040761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0401F,
		0xC78, 0x0FB0411F,
		0xC78, 0x0FA0421F,
		0xC78, 0x0F90431F,
		0xC78, 0x0F80441F,
		0xC78, 0x0F70451F,
		0xC78, 0x0F60461F,
		0xC78, 0x0F50471F,
		0xC78, 0x0F40481F,
		0xC78, 0x0F30491F,
		0xC78, 0x0F204A1F,
		0xC78, 0x0F104B1F,
		0xC78, 0x0F004C1F,
		0xC78, 0x0EF04D1F,
		0xC78, 0x0EE04E1F,
		0xC78, 0x0ED04F1F,
		0xC78, 0x0EC0501F,
		0xC78, 0x0EB0511F,
		0xC78, 0x0EA0521F,
		0xC78, 0x0E90531F,
		0xC78, 0x0E80541F,
		0xC78, 0x0E70551F,
		0xC78, 0x0CA0561F,
		0xC78, 0x0C90571F,
		0xC78, 0x0C80581F,
		0xC78, 0x0C70591F,
		0xC78, 0x0C605A1F,
		0xC78, 0x0C505B1F,
		0xC78, 0x0C405C1F,
		0xC78, 0x0C305D1F,
		0xC78, 0x0C205E1F,
		0xC78, 0x0C105F1F,
		0xC78, 0x0C00601F,
		0xC78, 0x0A30611F,
		0xC78, 0x0A20621F,
		0xC78, 0x0A10631F,
		0xC78, 0x0840641F,
		0xC78, 0x0830651F,
		0xC78, 0x0820661F,
		0xC78, 0x0810671F,
		0xC78, 0x0800681F,
		0xC78, 0x0630691F,
		0xC78, 0x06206A1F,
		0xC78, 0x06106B1F,
		0xC78, 0x04506C1F,
		0xC78, 0x04406D1F,
		0xC78, 0x04306E1F,
		0xC78, 0x04206F1F,
		0xC78, 0x0410701F,
		0xC78, 0x0400711F,
		0xC78, 0x0080721F,
		0xC78, 0x0070731F,
		0xC78, 0x0060741F,
		0xC78, 0x0050751F,
		0xC78, 0x0040761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FF0401F,
		0xC78, 0x0FE0411F,
		0xC78, 0x0FD0421F,
		0xC78, 0x0FC0431F,
		0xC78, 0x0FB0441F,
		0xC78, 0x0FA0451F,
		0xC78, 0x0F90461F,
		0xC78, 0x0F80471F,
		0xC78, 0x0F70481F,
		0xC78, 0x0F60491F,
		0xC78, 0x0F504A1F,
		0xC78, 0x0F404B1F,
		0xC78, 0x0F304C1F,
		0xC78, 0x0F204D1F,
		0xC78, 0x0F104E1F,
		0xC78, 0x0F004F1F,
		0xC78, 0x0EF0501F,
		0xC78, 0x0EE0511F,
		0xC78, 0x0B70521F,
		0xC78, 0x0B60531F,
		0xC78, 0x0B50541F,
		0xC78, 0x0B40551F,
		0xC78, 0x0B30561F,
		0xC78, 0x0B20571F,
		0xC78, 0x0B10581F,
		0xC78, 0x0B00591F,
		0xC78, 0x0AF05A1F,
		0xC78, 0x0AE05B1F,
		0xC78, 0x0AD05C1F,
		0xC78, 0x0AC05D1F,
		0xC78, 0x0AB05E1F,
		0xC78, 0x0AA05F1F,
		0xC78, 0x0A90601F,
		0xC78, 0x0A80611F,
		0xC78, 0x0A70621F,
		0xC78, 0x0A60631F,
		0xC78, 0x0A50641F,
		0xC78, 0x0A40651F,
		0xC78, 0x0A30661F,
		0xC78, 0x0A20671F,
		0xC78, 0x0A10681F,
		0xC78, 0x0A00691F,
		0xC78, 0x08206A1F,
		0xC78, 0x08106B1F,
		0xC78, 0x08006C1F,
		0xC78, 0x06406D1F,
		0xC78, 0x06306E1F,
		0xC78, 0x06206F1F,
		0xC78, 0x0610701F,
		0xC78, 0x0600711F,
		0xC78, 0x0420721F,
		0xC78, 0x0410731F,
		0xC78, 0x0400741F,
		0xC78, 0x0060751F,
		0xC78, 0x0050761F,
		0xC78, 0x0040771F,
		0xC78, 0x0030781F,
		0xC78, 0x0020791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FF0401F,
		0xC78, 0x0FE0411F,
		0xC78, 0x0FD0421F,
		0xC78, 0x0FC0431F,
		0xC78, 0x0FB0441F,
		0xC78, 0x0FA0451F,
		0xC78, 0x0F90461F,
		0xC78, 0x0F80471F,
		0xC78, 0x0F70481F,
		0xC78, 0x0F60491F,
		0xC78, 0x0F504A1F,
		0xC78, 0x0F404B1F,
		0xC78, 0x0F304C1F,
		0xC78, 0x0F204D1F,
		0xC78, 0x0F104E1F,
		0xC78, 0x0F004F1F,
		0xC78, 0x0EF0501F,
		0xC78, 0x0EE0511F,
		0xC78, 0x0B70521F,
		0xC78, 0x0B60531F,
		0xC78, 0x0B50541F,
		0xC78, 0x0B40551F,
		0xC78, 0x0B30561F,
		0xC78, 0x0B20571F,
		0xC78, 0x0B10581F,
		0xC78, 0x0B00591F,
		0xC78, 0x0AF05A1F,
		0xC78, 0x0AE05B1F,
		0xC78, 0x0AD05C1F,
		0xC78, 0x0AC05D1F,
		0xC78, 0x0AB05E1F,
		0xC78, 0x0AA05F1F,
		0xC78, 0x0A90601F,
		0xC78, 0x0A80611F,
		0xC78, 0x0A70621F,
		0xC78, 0x0A60631F,
		0xC78, 0x0A50641F,
		0xC78, 0x0A40651F,
		0xC78, 0x0A30661F,
		0xC78, 0x0A20671F,
		0xC78, 0x0A10681F,
		0xC78, 0x0A00691F,
		0xC78, 0x08206A1F,
		0xC78, 0x08106B1F,
		0xC78, 0x08006C1F,
		0xC78, 0x06406D1F,
		0xC78, 0x06306E1F,
		0xC78, 0x06206F1F,
		0xC78, 0x0610701F,
		0xC78, 0x0600711F,
		0xC78, 0x0420721F,
		0xC78, 0x0410731F,
		0xC78, 0x0400741F,
		0xC78, 0x0060751F,
		0xC78, 0x0050761F,
		0xC78, 0x0040771F,
		0xC78, 0x0030781F,
		0xC78, 0x0020791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40401F,
		0xC78, 0x0F30411F,
		0xC78, 0x0F20421F,
		0xC78, 0x0F10431F,
		0xC78, 0x0F00441F,
		0xC78, 0x0D40451F,
		0xC78, 0x0D30461F,
		0xC78, 0x0D20471F,
		0xC78, 0x0D10481F,
		0xC78, 0x0D00491F,
		0xC78, 0x0CF04A1F,
		0xC78, 0x0CE04B1F,
		0xC78, 0x0CD04C1F,
		0xC78, 0x0CC04D1F,
		0xC78, 0x0AF04E1F,
		0xC78, 0x0AE04F1F,
		0xC78, 0x0AD0501F,
		0xC78, 0x0AC0511F,
		0xC78, 0x0AB0521F,
		0xC78, 0x0AA0531F,
		0xC78, 0x0A90541F,
		0xC78, 0x0A80551F,
		0xC78, 0x0A70561F,
		0xC78, 0x0A60571F,
		0xC78, 0x0A50581F,
		0xC78, 0x0A40591F,
		0xC78, 0x0A305A1F,
		0xC78, 0x08605B1F,
		0xC78, 0x08505C1F,
		0xC78, 0x08405D1F,
		0xC78, 0x08305E1F,
		0xC78, 0x08205F1F,
		0xC78, 0x0660601F,
		0xC78, 0x0650611F,
		0xC78, 0x0640621F,
		0xC78, 0x0630631F,
		0xC78, 0x0470641F,
		0xC78, 0x0460651F,
		0xC78, 0x0450661F,
		0xC78, 0x0440671F,
		0xC78, 0x0430681F,
		0xC78, 0x0260691F,
		0xC78, 0x02506A1F,
		0xC78, 0x02406B1F,
		0xC78, 0x02306C1F,
		0xC78, 0x02206D1F,
		0xC78, 0x02106E1F,
		0xC78, 0x00506F1F,
		0xC78, 0x0040701F,
		0xC78, 0x0030711F,
		0xC78, 0x0020721F,
		0xC78, 0x0010731F,
		0xC78, 0x0010741F,
		0xC78, 0x0010751F,
		0xC78, 0x0010761F,
		0xC78, 0x0010771F,
		0xC78, 0x0010781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40401F,
		0xC78, 0x0F30411F,
		0xC78, 0x0F20421F,
		0xC78, 0x0F10431F,
		0xC78, 0x0F00441F,
		0xC78, 0x0D40451F,
		0xC78, 0x0D30461F,
		0xC78, 0x0D20471F,
		0xC78, 0x0D10481F,
		0xC78, 0x0D00491F,
		0xC78, 0x0CF04A1F,
		0xC78, 0x0CE04B1F,
		0xC78, 0x0CD04C1F,
		0xC78, 0x0CC04D1F,
		0xC78, 0x0AF04E1F,
		0xC78, 0x0AE04F1F,
		0xC78, 0x0AD0501F,
		0xC78, 0x0AC0511F,
		0xC78, 0x0AB0521F,
		0xC78, 0x0AA0531F,
		0xC78, 0x0A90541F,
		0xC78, 0x0A80551F,
		0xC78, 0x0A70561F,
		0xC78, 0x0A60571F,
		0xC78, 0x0A50581F,
		0xC78, 0x0A40591F,
		0xC78, 0x0A305A1F,
		0xC78, 0x08605B1F,
		0xC78, 0x08505C1F,
		0xC78, 0x08405D1F,
		0xC78, 0x08305E1F,
		0xC78, 0x08205F1F,
		0xC78, 0x0660601F,
		0xC78, 0x0650611F,
		0xC78, 0x0640621F,
		0xC78, 0x0630631F,
		0xC78, 0x0470641F,
		0xC78, 0x0460651F,
		0xC78, 0x0450661F,
		0xC78, 0x0440671F,
		0xC78, 0x0430681F,
		0xC78, 0x0260691F,
		0xC78, 0x02506A1F,
		0xC78, 0x02406B1F,
		0xC78, 0x02306C1F,
		0xC78, 0x02206D1F,
		0xC78, 0x02106E1F,
		0xC78, 0x00506F1F,
		0xC78, 0x0040701F,
		0xC78, 0x0030711F,
		0xC78, 0x0020721F,
		0xC78, 0x0010731F,
		0xC78, 0x0010741F,
		0xC78, 0x0010751F,
		0xC78, 0x0010761F,
		0xC78, 0x0010771F,
		0xC78, 0x0010781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DC0401F,
		0xC78, 0x0DB0411F,
		0xC78, 0x0DA0421F,
		0xC78, 0x0D90431F,
		0xC78, 0x0D80441F,
		0xC78, 0x0D70451F,
		0xC78, 0x0D60461F,
		0xC78, 0x0D50471F,
		0xC78, 0x0D40481F,
		0xC78, 0x0D30491F,
		0xC78, 0x0D204A1F,
		0xC78, 0x0D104B1F,
		0xC78, 0x0D004C1F,
		0xC78, 0x0CF04D1F,
		0xC78, 0x0CE04E1F,
		0xC78, 0x0CD04F1F,
		0xC78, 0x0B20501F,
		0xC78, 0x0930511F,
		0xC78, 0x0920521F,
		0xC78, 0x0910531F,
		0xC78, 0x0900541F,
		0xC78, 0x08F0551F,
		0xC78, 0x08E0561F,
		0xC78, 0x08D0571F,
		0xC78, 0x08C0581F,
		0xC78, 0x08B0591F,
		0xC78, 0x08A05A1F,
		0xC78, 0x08905B1F,
		0xC78, 0x08805C1F,
		0xC78, 0x08705D1F,
		0xC78, 0x08605E1F,
		0xC78, 0x08505F1F,
		0xC78, 0x0840601F,
		0xC78, 0x0830611F,
		0xC78, 0x0820621F,
		0xC78, 0x0810631F,
		0xC78, 0x0650641F,
		0xC78, 0x0640651F,
		0xC78, 0x0630661F,
		0xC78, 0x0450671F,
		0xC78, 0x0440681F,
		0xC78, 0x0430691F,
		0xC78, 0x04206A1F,
		0xC78, 0x04106B1F,
		0xC78, 0x04006C1F,
		0xC78, 0x02406D1F,
		0xC78, 0x02306E1F,
		0xC78, 0x00606F1F,
		0xC78, 0x0050701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DC0401F,
		0xC78, 0x0DB0411F,
		0xC78, 0x0DA0421F,
		0xC78, 0x0D90431F,
		0xC78, 0x0D80441F,
		0xC78, 0x0D70451F,
		0xC78, 0x0D60461F,
		0xC78, 0x0D50471F,
		0xC78, 0x0D40481F,
		0xC78, 0x0D30491F,
		0xC78, 0x0D204A1F,
		0xC78, 0x0D104B1F,
		0xC78, 0x0D004C1F,
		0xC78, 0x0CF04D1F,
		0xC78, 0x0CE04E1F,
		0xC78, 0x0CD04F1F,
		0xC78, 0x0B20501F,
		0xC78, 0x0930511F,
		0xC78, 0x0920521F,
		0xC78, 0x0910531F,
		0xC78, 0x0900541F,
		0xC78, 0x08F0551F,
		0xC78, 0x08E0561F,
		0xC78, 0x08D0571F,
		0xC78, 0x08C0581F,
		0xC78, 0x08B0591F,
		0xC78, 0x08A05A1F,
		0xC78, 0x08905B1F,
		0xC78, 0x08805C1F,
		0xC78, 0x08705D1F,
		0xC78, 0x08605E1F,
		0xC78, 0x08505F1F,
		0xC78, 0x0840601F,
		0xC78, 0x0830611F,
		0xC78, 0x0820621F,
		0xC78, 0x0810631F,
		0xC78, 0x0650641F,
		0xC78, 0x0640651F,
		0xC78, 0x0630661F,
		0xC78, 0x0450671F,
		0xC78, 0x0440681F,
		0xC78, 0x0430691F,
		0xC78, 0x04206A1F,
		0xC78, 0x04106B1F,
		0xC78, 0x04006C1F,
		0xC78, 0x02406D1F,
		0xC78, 0x02306E1F,
		0xC78, 0x00606F1F,
		0xC78, 0x0050701F,
		0xC78, 0x0040711F,
		0xC78, 0x0030721F,
		0xC78, 0x0020731F,
		0xC78, 0x0010741F,
		0xC78, 0x0000751F,
		0xC78, 0x0000761F,
		0xC78, 0x0000771F,
		0xC78, 0x0000781F,
		0xC78, 0x0000791F,
		0xC78, 0x00007A1F,
		0xC78, 0x00007B1F,
		0xC78, 0x00007C1F,
		0xC78, 0x00007D1F,
		0xC78, 0x00007E1F,
		0xC78, 0x00007F1F,
	0xA0000000,	0x00000000,
		0xC78, 0x0FE0401F,
		0xC78, 0x0FD0411F,
		0xC78, 0x0FC0421F,
		0xC78, 0x0FB0431F,
		0xC78, 0x0FA0441F,
		0xC78, 0x0F90451F,
		0xC78, 0x0F80461F,
		0xC78, 0x0F70471F,
		0xC78, 0x0F60481F,
		0xC78, 0x0F50491F,
		0xC78, 0x0F404A1F,
		0xC78, 0x0F304B1F,
		0xC78, 0x0F204C1F,
		0xC78, 0x0F104D1F,
		0xC78, 0x0F004E1F,
		0xC78, 0x0EF04F1F,
		0xC78, 0x0EE0501F,
		0xC78, 0x0ED0511F,
		0xC78, 0x0EC0521F,
		0xC78, 0x0EB0531F,
		0xC78, 0x0EA0541F,
		0xC78, 0x0E90551F,
		0xC78, 0x0E80561F,
		0xC78, 0x0CB0571F,
		0xC78, 0x0CA0581F,
		0xC78, 0x0C90591F,
		0xC78, 0x0C805A1F,
		0xC78, 0x0C705B1F,
		0xC78, 0x0C605C1F,
		0xC78, 0x0C505D1F,
		0xC78, 0x0C405E1F,
		0xC78, 0x0A805F1F,
		0xC78, 0x0A70601F,
		0xC78, 0x0A60611F,
		0xC78, 0x0A50621F,
		0xC78, 0x0A40631F,
		0xC78, 0x0A30641F,
		0xC78, 0x0860651F,
		0xC78, 0x0850661F,
		0xC78, 0x0840671F,
		0xC78, 0x0670681F,
		0xC78, 0x0660691F,
		0xC78, 0x06506A1F,
		0xC78, 0x06406B1F,
		0xC78, 0x04706C1F,
		0xC78, 0x04606D1F,
		0xC78, 0x04506E1F,
		0xC78, 0x02906F1F,
		0xC78, 0x0280701F,
		0xC78, 0x0270711F,
		0xC78, 0x0260721F,
		0xC78, 0x0250731F,
		0xC78, 0x0060741F,
		0xC78, 0x0050751F,
		0xC78, 0x0040761F,
		0xC78, 0x0030771F,
		0xC78, 0x0020781F,
		0xC78, 0x0010791F,
		0xC78, 0x00107A1F,
		0xC78, 0x00107B1F,
		0xC78, 0x00107C1F,
		0xC78, 0x00107D1F,
		0xC78, 0x00107E1F,
		0xC78, 0x00107F1F,
	0xB0000000,	0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0801F,
		0xC78, 0x0DA0811F,
		0xC78, 0x0D90821F,
		0xC78, 0x0D80831F,
		0xC78, 0x0D70841F,
		0xC78, 0x0D60851F,
		0xC78, 0x0D50861F,
		0xC78, 0x0D40871F,
		0xC78, 0x0D30881F,
		0xC78, 0x0B70891F,
		0xC78, 0x0B608A1F,
		0xC78, 0x0B508B1F,
		0xC78, 0x09708C1F,
		0xC78, 0x09608D1F,
		0xC78, 0x09508E1F,
		0xC78, 0x09408F1F,
		0xC78, 0x0930901F,
		0xC78, 0x0920911F,
		0xC78, 0x0910921F,
		0xC78, 0x0900931F,
		0xC78, 0x08F0941F,
		0xC78, 0x08E0951F,
		0xC78, 0x08D0961F,
		0xC78, 0x08C0971F,
		0xC78, 0x08B0981F,
		0xC78, 0x08A0991F,
		0xC78, 0x08909A1F,
		0xC78, 0x08809B1F,
		0xC78, 0x06C09C1F,
		0xC78, 0x06B09D1F,
		0xC78, 0x06A09E1F,
		0xC78, 0x06909F1F,
		0xC78, 0x0680A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0420A91F,
		0xC78, 0x0410AA1F,
		0xC78, 0x0400AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0060AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40801F,
		0xC78, 0x0F30811F,
		0xC78, 0x0F20821F,
		0xC78, 0x0F10831F,
		0xC78, 0x0F00841F,
		0xC78, 0x0EF0851F,
		0xC78, 0x0EE0861F,
		0xC78, 0x0ED0871F,
		0xC78, 0x0EC0881F,
		0xC78, 0x0EB0891F,
		0xC78, 0x0EA08A1F,
		0xC78, 0x0E908B1F,
		0xC78, 0x0CD08C1F,
		0xC78, 0x0CC08D1F,
		0xC78, 0x0CB08E1F,
		0xC78, 0x0CA08F1F,
		0xC78, 0x0E40901F,
		0xC78, 0x0E30911F,
		0xC78, 0x0AB0921F,
		0xC78, 0x0AA0931F,
		0xC78, 0x0A90941F,
		0xC78, 0x0A80951F,
		0xC78, 0x0A70961F,
		0xC78, 0x0A60971F,
		0xC78, 0x0A50981F,
		0xC78, 0x0A40991F,
		0xC78, 0x0A309A1F,
		0xC78, 0x0A209B1F,
		0xC78, 0x0A109C1F,
		0xC78, 0x08409D1F,
		0xC78, 0x08309E1F,
		0xC78, 0x08209F1F,
		0xC78, 0x0810A01F,
		0xC78, 0x0640A11F,
		0xC78, 0x0630A21F,
		0xC78, 0x0620A31F,
		0xC78, 0x0610A41F,
		0xC78, 0x0450A51F,
		0xC78, 0x0440A61F,
		0xC78, 0x0430A71F,
		0xC78, 0x0420A81F,
		0xC78, 0x0410A91F,
		0xC78, 0x0240AA1F,
		0xC78, 0x0230AB1F,
		0xC78, 0x0220AC1F,
		0xC78, 0x0210AD1F,
		0xC78, 0x0050AE1F,
		0xC78, 0x0040AF1F,
		0xC78, 0x0030B01F,
		0xC78, 0x0020B11F,
		0xC78, 0x0010B21F,
		0xC78, 0x0000B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0801F,
		0xC78, 0x0DA0811F,
		0xC78, 0x0D90821F,
		0xC78, 0x0D80831F,
		0xC78, 0x0D70841F,
		0xC78, 0x0D60851F,
		0xC78, 0x0D50861F,
		0xC78, 0x0D40871F,
		0xC78, 0x0D30881F,
		0xC78, 0x0B70891F,
		0xC78, 0x0B608A1F,
		0xC78, 0x0B508B1F,
		0xC78, 0x09708C1F,
		0xC78, 0x09608D1F,
		0xC78, 0x09508E1F,
		0xC78, 0x09408F1F,
		0xC78, 0x0930901F,
		0xC78, 0x0920911F,
		0xC78, 0x0910921F,
		0xC78, 0x0900931F,
		0xC78, 0x08F0941F,
		0xC78, 0x08E0951F,
		0xC78, 0x08D0961F,
		0xC78, 0x08C0971F,
		0xC78, 0x08B0981F,
		0xC78, 0x08A0991F,
		0xC78, 0x08909A1F,
		0xC78, 0x08809B1F,
		0xC78, 0x06C09C1F,
		0xC78, 0x06B09D1F,
		0xC78, 0x06A09E1F,
		0xC78, 0x06909F1F,
		0xC78, 0x0680A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0420A91F,
		0xC78, 0x0410AA1F,
		0xC78, 0x0400AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0060AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00801F,
		0xC78, 0x0EF0811F,
		0xC78, 0x0EE0821F,
		0xC78, 0x0ED0831F,
		0xC78, 0x0EC0841F,
		0xC78, 0x0980851F,
		0xC78, 0x0970861F,
		0xC78, 0x0960871F,
		0xC78, 0x0950881F,
		0xC78, 0x0940891F,
		0xC78, 0x07808A1F,
		0xC78, 0x07708B1F,
		0xC78, 0x07608C1F,
		0xC78, 0x07508D1F,
		0xC78, 0x07408E1F,
		0xC78, 0x07308F1F,
		0xC78, 0x0720901F,
		0xC78, 0x0580911F,
		0xC78, 0x0570921F,
		0xC78, 0x0560931F,
		0xC78, 0x0550941F,
		0xC78, 0x0540951F,
		0xC78, 0x0530961F,
		0xC78, 0x0520971F,
		0xC78, 0x0510981F,
		0xC78, 0x0500991F,
		0xC78, 0x04F09A1F,
		0xC78, 0x04E09B1F,
		0xC78, 0x04D09C1F,
		0xC78, 0x04C09D1F,
		0xC78, 0x04B09E1F,
		0xC78, 0x04A09F1F,
		0xC78, 0x0490A01F,
		0xC78, 0x0480A11F,
		0xC78, 0x0470A21F,
		0xC78, 0x0460A31F,
		0xC78, 0x0450A41F,
		0xC78, 0x0440A51F,
		0xC78, 0x0430A61F,
		0xC78, 0x0420A71F,
		0xC78, 0x0410A81F,
		0xC78, 0x0240A91F,
		0xC78, 0x0230AA1F,
		0xC78, 0x0220AB1F,
		0xC78, 0x0210AC1F,
		0xC78, 0x0050AD1F,
		0xC78, 0x0040AE1F,
		0xC78, 0x0030AF1F,
		0xC78, 0x0020B01F,
		0xC78, 0x0010B11F,
		0xC78, 0x0000B21F,
		0xC78, 0x0000B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40801F,
		0xC78, 0x0F30811F,
		0xC78, 0x0F20821F,
		0xC78, 0x0F10831F,
		0xC78, 0x0F00841F,
		0xC78, 0x0D40851F,
		0xC78, 0x0D30861F,
		0xC78, 0x0D20871F,
		0xC78, 0x0980881F,
		0xC78, 0x0970891F,
		0xC78, 0x09608A1F,
		0xC78, 0x09508B1F,
		0xC78, 0x09408C1F,
		0xC78, 0x07808D1F,
		0xC78, 0x07708E1F,
		0xC78, 0x07608F1F,
		0xC78, 0x0750901F,
		0xC78, 0x0740911F,
		0xC78, 0x0730921F,
		0xC78, 0x0580931F,
		0xC78, 0x0570941F,
		0xC78, 0x0560951F,
		0xC78, 0x0550961F,
		0xC78, 0x0540971F,
		0xC78, 0x0530981F,
		0xC78, 0x0520991F,
		0xC78, 0x05109A1F,
		0xC78, 0x05009B1F,
		0xC78, 0x04F09C1F,
		0xC78, 0x04E09D1F,
		0xC78, 0x04D09E1F,
		0xC78, 0x04C09F1F,
		0xC78, 0x04B0A01F,
		0xC78, 0x04A0A11F,
		0xC78, 0x0490A21F,
		0xC78, 0x0480A31F,
		0xC78, 0x0470A41F,
		0xC78, 0x0460A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0270A91F,
		0xC78, 0x0260AA1F,
		0xC78, 0x0250AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0220AE1F,
		0xC78, 0x0210AF1F,
		0xC78, 0x0050B01F,
		0xC78, 0x0040B11F,
		0xC78, 0x0030B21F,
		0xC78, 0x0020B31F,
		0xC78, 0x0010B41F,
		0xC78, 0x0010B51F,
		0xC78, 0x0010B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0010B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0010BA1F,
		0xC78, 0x0010BB1F,
		0xC78, 0x0010BC1F,
		0xC78, 0x0010BD1F,
		0xC78, 0x0010BE1F,
		0xC78, 0x0010BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0801F,
		0xC78, 0x0DA0811F,
		0xC78, 0x0D90821F,
		0xC78, 0x0D80831F,
		0xC78, 0x0D70841F,
		0xC78, 0x0D60851F,
		0xC78, 0x0D50861F,
		0xC78, 0x0D40871F,
		0xC78, 0x0D30881F,
		0xC78, 0x0B70891F,
		0xC78, 0x0B608A1F,
		0xC78, 0x0B508B1F,
		0xC78, 0x09708C1F,
		0xC78, 0x09608D1F,
		0xC78, 0x09508E1F,
		0xC78, 0x09408F1F,
		0xC78, 0x0930901F,
		0xC78, 0x0920911F,
		0xC78, 0x0910921F,
		0xC78, 0x0900931F,
		0xC78, 0x08F0941F,
		0xC78, 0x08E0951F,
		0xC78, 0x08D0961F,
		0xC78, 0x08C0971F,
		0xC78, 0x08B0981F,
		0xC78, 0x08A0991F,
		0xC78, 0x08909A1F,
		0xC78, 0x08809B1F,
		0xC78, 0x06C09C1F,
		0xC78, 0x06B09D1F,
		0xC78, 0x06A09E1F,
		0xC78, 0x06909F1F,
		0xC78, 0x0680A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0420A91F,
		0xC78, 0x0410AA1F,
		0xC78, 0x0400AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0060AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D50801F,
		0xC78, 0x0D40811F,
		0xC78, 0x0D30821F,
		0xC78, 0x0D20831F,
		0xC78, 0x0D10841F,
		0xC78, 0x0D00851F,
		0xC78, 0x0CF0861F,
		0xC78, 0x0CE0871F,
		0xC78, 0x0B70881F,
		0xC78, 0x0B60891F,
		0xC78, 0x0B508A1F,
		0xC78, 0x0B408B1F,
		0xC78, 0x0B308C1F,
		0xC78, 0x0B208D1F,
		0xC78, 0x0B108E1F,
		0xC78, 0x0B008F1F,
		0xC78, 0x0AF0901F,
		0xC78, 0x0730911F,
		0xC78, 0x0720921F,
		0xC78, 0x0710931F,
		0xC78, 0x0700941F,
		0xC78, 0x06F0951F,
		0xC78, 0x06E0961F,
		0xC78, 0x06D0971F,
		0xC78, 0x06C0981F,
		0xC78, 0x0520991F,
		0xC78, 0x05109A1F,
		0xC78, 0x05009B1F,
		0xC78, 0x04F09C1F,
		0xC78, 0x04E09D1F,
		0xC78, 0x04D09E1F,
		0xC78, 0x04C09F1F,
		0xC78, 0x04B0A01F,
		0xC78, 0x04A0A11F,
		0xC78, 0x0490A21F,
		0xC78, 0x0480A31F,
		0xC78, 0x0470A41F,
		0xC78, 0x0460A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0290A71F,
		0xC78, 0x0280A81F,
		0xC78, 0x0270A91F,
		0xC78, 0x0260AA1F,
		0xC78, 0x0250AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0220AE1F,
		0xC78, 0x0210AF1F,
		0xC78, 0x0200B01F,
		0xC78, 0x0040B11F,
		0xC78, 0x0030B21F,
		0xC78, 0x0020B31F,
		0xC78, 0x0010B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F60001F,
		0xC78, 0x0F50011F,
		0xC78, 0x0F40021F,
		0xC78, 0x0F30031F,
		0xC78, 0x0D70041F,
		0xC78, 0x0D60051F,
		0xC78, 0x0D50061F,
		0xC78, 0x0D40071F,
		0xC78, 0x0B70081F,
		0xC78, 0x0B60091F,
		0xC78, 0x0B500A1F,
		0xC78, 0x09700B1F,
		0xC78, 0x09600C1F,
		0xC78, 0x09500D1F,
		0xC78, 0x09400E1F,
		0xC78, 0x09300F1F,
		0xC78, 0x0920101F,
		0xC78, 0x0910111F,
		0xC78, 0x0900121F,
		0xC78, 0x08F0131F,
		0xC78, 0x08E0141F,
		0xC78, 0x08D0151F,
		0xC78, 0x08C0161F,
		0xC78, 0x08B0171F,
		0xC78, 0x08A0181F,
		0xC78, 0x0890191F,
		0xC78, 0x06D01A1F,
		0xC78, 0x06C01B1F,
		0xC78, 0x06B01C1F,
		0xC78, 0x06A01D1F,
		0xC78, 0x06901E1F,
		0xC78, 0x06801F1F,
		0xC78, 0x0670201F,
		0xC78, 0x0660211F,
		0xC78, 0x0650221F,
		0xC78, 0x0640231F,
		0xC78, 0x0630241F,
		0xC78, 0x0620251F,
		0xC78, 0x0610261F,
		0xC78, 0x0440271F,
		0xC78, 0x0430281F,
		0xC78, 0x0420291F,
		0xC78, 0x04102A1F,
		0xC78, 0x02502B1F,
		0xC78, 0x02402C1F,
		0xC78, 0x02302D1F,
		0xC78, 0x02202E1F,
		0xC78, 0x02102F1F,
		0xC78, 0x0040301F,
		0xC78, 0x0030311F,
		0xC78, 0x0020321F,
		0xC78, 0x0010331F,
		0xC78, 0x0010341F,
		0xC78, 0x0010351F,
		0xC78, 0x0010361F,
		0xC78, 0x0010371F,
		0xC78, 0x0010381F,
		0xC78, 0x0010391F,
		0xC78, 0x00103A1F,
		0xC78, 0x00103B1F,
		0xC78, 0x00103C1F,
		0xC78, 0x00103D1F,
		0xC78, 0x00103E1F,
		0xC78, 0x00103F1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F20801F,
		0xC78, 0x0F10811F,
		0xC78, 0x0F00821F,
		0xC78, 0x0EF0831F,
		0xC78, 0x0EE0841F,
		0xC78, 0x0ED0851F,
		0xC78, 0x0EC0861F,
		0xC78, 0x0EB0871F,
		0xC78, 0x0EA0881F,
		0xC78, 0x0970891F,
		0xC78, 0x09608A1F,
		0xC78, 0x09508B1F,
		0xC78, 0x09408C1F,
		0xC78, 0x09308D1F,
		0xC78, 0x07708E1F,
		0xC78, 0x07608F1F,
		0xC78, 0x0750901F,
		0xC78, 0x0740911F,
		0xC78, 0x0730921F,
		0xC78, 0x0720931F,
		0xC78, 0x0710941F,
		0xC78, 0x0700951F,
		0xC78, 0x06F0961F,
		0xC78, 0x06E0971F,
		0xC78, 0x0540981F,
		0xC78, 0x0530991F,
		0xC78, 0x05209A1F,
		0xC78, 0x05109B1F,
		0xC78, 0x05009C1F,
		0xC78, 0x04F09D1F,
		0xC78, 0x04E09E1F,
		0xC78, 0x04D09F1F,
		0xC78, 0x04C0A01F,
		0xC78, 0x04B0A11F,
		0xC78, 0x04A0A21F,
		0xC78, 0x0490A31F,
		0xC78, 0x0480A41F,
		0xC78, 0x0470A51F,
		0xC78, 0x0460A61F,
		0xC78, 0x0450A71F,
		0xC78, 0x0290A81F,
		0xC78, 0x0280A91F,
		0xC78, 0x0270AA1F,
		0xC78, 0x0260AB1F,
		0xC78, 0x0250AC1F,
		0xC78, 0x0240AD1F,
		0xC78, 0x0230AE1F,
		0xC78, 0x0220AF1F,
		0xC78, 0x0210B01F,
		0xC78, 0x0200B11F,
		0xC78, 0x0040B21F,
		0xC78, 0x0030B31F,
		0xC78, 0x0020B41F,
		0xC78, 0x0010B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40801F,
		0xC78, 0x0F30811F,
		0xC78, 0x0F20821F,
		0xC78, 0x0F10831F,
		0xC78, 0x0F00841F,
		0xC78, 0x0EF0851F,
		0xC78, 0x0EE0861F,
		0xC78, 0x0ED0871F,
		0xC78, 0x0EC0881F,
		0xC78, 0x0EB0891F,
		0xC78, 0x0EA08A1F,
		0xC78, 0x0E908B1F,
		0xC78, 0x0E808C1F,
		0xC78, 0x0E708D1F,
		0xC78, 0x0E608E1F,
		0xC78, 0x0E508F1F,
		0xC78, 0x0E30901F,
		0xC78, 0x0E20911F,
		0xC78, 0x0C60921F,
		0xC78, 0x0C50931F,
		0xC78, 0x0C40941F,
		0xC78, 0x0C30951F,
		0xC78, 0x0C20961F,
		0xC78, 0x0C10971F,
		0xC78, 0x0A40981F,
		0xC78, 0x0A30991F,
		0xC78, 0x0A209A1F,
		0xC78, 0x0A109B1F,
		0xC78, 0x08409C1F,
		0xC78, 0x08309D1F,
		0xC78, 0x06709E1F,
		0xC78, 0x06609F1F,
		0xC78, 0x0650A01F,
		0xC78, 0x0640A11F,
		0xC78, 0x0630A21F,
		0xC78, 0x0620A31F,
		0xC78, 0x0610A41F,
		0xC78, 0x0450A51F,
		0xC78, 0x0440A61F,
		0xC78, 0x0430A71F,
		0xC78, 0x0420A81F,
		0xC78, 0x0260A91F,
		0xC78, 0x0250AA1F,
		0xC78, 0x0240AB1F,
		0xC78, 0x0230AC1F,
		0xC78, 0x0220AD1F,
		0xC78, 0x0210AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0010B41F,
		0xC78, 0x0010B51F,
		0xC78, 0x0010B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0010B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0010BA1F,
		0xC78, 0x0010BB1F,
		0xC78, 0x0010BC1F,
		0xC78, 0x0010BD1F,
		0xC78, 0x0010BE1F,
		0xC78, 0x0010BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F00801F,
		0xC78, 0x0EF0811F,
		0xC78, 0x0EE0821F,
		0xC78, 0x0ED0831F,
		0xC78, 0x0EC0841F,
		0xC78, 0x0EB0851F,
		0xC78, 0x0970861F,
		0xC78, 0x0960871F,
		0xC78, 0x0950881F,
		0xC78, 0x0940891F,
		0xC78, 0x07708A1F,
		0xC78, 0x07608B1F,
		0xC78, 0x07508C1F,
		0xC78, 0x07408D1F,
		0xC78, 0x07308E1F,
		0xC78, 0x07208F1F,
		0xC78, 0x0710901F,
		0xC78, 0x0570911F,
		0xC78, 0x0560921F,
		0xC78, 0x0550931F,
		0xC78, 0x0540941F,
		0xC78, 0x0530951F,
		0xC78, 0x0520961F,
		0xC78, 0x0510971F,
		0xC78, 0x0500981F,
		0xC78, 0x04F0991F,
		0xC78, 0x04E09A1F,
		0xC78, 0x04D09B1F,
		0xC78, 0x04C09C1F,
		0xC78, 0x04B09D1F,
		0xC78, 0x04A09E1F,
		0xC78, 0x04909F1F,
		0xC78, 0x0480A01F,
		0xC78, 0x0470A11F,
		0xC78, 0x0460A21F,
		0xC78, 0x0450A31F,
		0xC78, 0x0440A41F,
		0xC78, 0x0430A51F,
		0xC78, 0x0420A61F,
		0xC78, 0x0410A71F,
		0xC78, 0x0400A81F,
		0xC78, 0x0240A91F,
		0xC78, 0x0230AA1F,
		0xC78, 0x0220AB1F,
		0xC78, 0x0210AC1F,
		0xC78, 0x0200AD1F,
		0xC78, 0x0040AE1F,
		0xC78, 0x0030AF1F,
		0xC78, 0x0020B01F,
		0xC78, 0x0010B11F,
		0xC78, 0x0000B21F,
		0xC78, 0x0000B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60801F,
		0xC78, 0x0D50811F,
		0xC78, 0x0D40821F,
		0xC78, 0x0D30831F,
		0xC78, 0x0D20841F,
		0xC78, 0x0D10851F,
		0xC78, 0x0980861F,
		0xC78, 0x0970871F,
		0xC78, 0x0960881F,
		0xC78, 0x0950891F,
		0xC78, 0x09408A1F,
		0xC78, 0x09308B1F,
		0xC78, 0x09208C1F,
		0xC78, 0x09108D1F,
		0xC78, 0x09008E1F,
		0xC78, 0x08F08F1F,
		0xC78, 0x0580901F,
		0xC78, 0x0570911F,
		0xC78, 0x0560921F,
		0xC78, 0x0550931F,
		0xC78, 0x0540941F,
		0xC78, 0x0530951F,
		0xC78, 0x0520961F,
		0xC78, 0x0510971F,
		0xC78, 0x0500981F,
		0xC78, 0x04F0991F,
		0xC78, 0x04E09A1F,
		0xC78, 0x04D09B1F,
		0xC78, 0x04C09C1F,
		0xC78, 0x04B09D1F,
		0xC78, 0x04A09E1F,
		0xC78, 0x04909F1F,
		0xC78, 0x0480A01F,
		0xC78, 0x0470A11F,
		0xC78, 0x0460A21F,
		0xC78, 0x0450A31F,
		0xC78, 0x0440A41F,
		0xC78, 0x0430A51F,
		0xC78, 0x0420A61F,
		0xC78, 0x0410A71F,
		0xC78, 0x0240A81F,
		0xC78, 0x0230A91F,
		0xC78, 0x0220AA1F,
		0xC78, 0x0210AB1F,
		0xC78, 0x0050AC1F,
		0xC78, 0x0040AD1F,
		0xC78, 0x0030AE1F,
		0xC78, 0x0020AF1F,
		0xC78, 0x0010B01F,
		0xC78, 0x0000B11F,
		0xC78, 0x0000B21F,
		0xC78, 0x0000B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0D60801F,
		0xC78, 0x0D50811F,
		0xC78, 0x0D40821F,
		0xC78, 0x0D30831F,
		0xC78, 0x0D20841F,
		0xC78, 0x0D10851F,
		0xC78, 0x0980861F,
		0xC78, 0x0970871F,
		0xC78, 0x0960881F,
		0xC78, 0x0950891F,
		0xC78, 0x09408A1F,
		0xC78, 0x09308B1F,
		0xC78, 0x09208C1F,
		0xC78, 0x09108D1F,
		0xC78, 0x09008E1F,
		0xC78, 0x08F08F1F,
		0xC78, 0x0580901F,
		0xC78, 0x0570911F,
		0xC78, 0x0560921F,
		0xC78, 0x0550931F,
		0xC78, 0x0540941F,
		0xC78, 0x0530951F,
		0xC78, 0x0520961F,
		0xC78, 0x0510971F,
		0xC78, 0x0500981F,
		0xC78, 0x04F0991F,
		0xC78, 0x04E09A1F,
		0xC78, 0x04D09B1F,
		0xC78, 0x04C09C1F,
		0xC78, 0x04B09D1F,
		0xC78, 0x04A09E1F,
		0xC78, 0x04909F1F,
		0xC78, 0x0480A01F,
		0xC78, 0x0470A11F,
		0xC78, 0x0460A21F,
		0xC78, 0x0450A31F,
		0xC78, 0x0440A41F,
		0xC78, 0x0430A51F,
		0xC78, 0x0420A61F,
		0xC78, 0x0410A71F,
		0xC78, 0x0240A81F,
		0xC78, 0x0230A91F,
		0xC78, 0x0220AA1F,
		0xC78, 0x0210AB1F,
		0xC78, 0x0050AC1F,
		0xC78, 0x0040AD1F,
		0xC78, 0x0030AE1F,
		0xC78, 0x0020AF1F,
		0xC78, 0x0010B01F,
		0xC78, 0x0000B11F,
		0xC78, 0x0000B21F,
		0xC78, 0x0000B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0801F,
		0xC78, 0x0FB0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0F90831F,
		0xC78, 0x0F80841F,
		0xC78, 0x0F70851F,
		0xC78, 0x0F60861F,
		0xC78, 0x0F50871F,
		0xC78, 0x0F40881F,
		0xC78, 0x0F30891F,
		0xC78, 0x0F208A1F,
		0xC78, 0x0F108B1F,
		0xC78, 0x0F008C1F,
		0xC78, 0x0EF08D1F,
		0xC78, 0x0EE08E1F,
		0xC78, 0x0ED08F1F,
		0xC78, 0x0EC0901F,
		0xC78, 0x0EB0911F,
		0xC78, 0x0EA0921F,
		0xC78, 0x0E90931F,
		0xC78, 0x0E80941F,
		0xC78, 0x0E70951F,
		0xC78, 0x0E60961F,
		0xC78, 0x0E50971F,
		0xC78, 0x0E40981F,
		0xC78, 0x0E30991F,
		0xC78, 0x0C809A1F,
		0xC78, 0x0C709B1F,
		0xC78, 0x0C609C1F,
		0xC78, 0x0C509D1F,
		0xC78, 0x0C409E1F,
		0xC78, 0x0C309F1F,
		0xC78, 0x0A60A01F,
		0xC78, 0x0A50A11F,
		0xC78, 0x0A40A21F,
		0xC78, 0x0A30A31F,
		0xC78, 0x0860A41F,
		0xC78, 0x0850A51F,
		0xC78, 0x0840A61F,
		0xC78, 0x0830A71F,
		0xC78, 0x0660A81F,
		0xC78, 0x0650A91F,
		0xC78, 0x0490AA1F,
		0xC78, 0x0480AB1F,
		0xC78, 0x0470AC1F,
		0xC78, 0x0460AD1F,
		0xC78, 0x0450AE1F,
		0xC78, 0x0280AF1F,
		0xC78, 0x0270B01F,
		0xC78, 0x0260B11F,
		0xC78, 0x0250B21F,
		0xC78, 0x0240B31F,
		0xC78, 0x0230B41F,
		0xC78, 0x0220B51F,
		0xC78, 0x0210B61F,
		0xC78, 0x0200B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0801F,
		0xC78, 0x0FB0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0F90831F,
		0xC78, 0x0F80841F,
		0xC78, 0x0F70851F,
		0xC78, 0x0F60861F,
		0xC78, 0x0F50871F,
		0xC78, 0x0F40881F,
		0xC78, 0x0D80891F,
		0xC78, 0x0D708A1F,
		0xC78, 0x0D608B1F,
		0xC78, 0x0D508C1F,
		0xC78, 0x0B808D1F,
		0xC78, 0x0B708E1F,
		0xC78, 0x0B608F1F,
		0xC78, 0x0B50901F,
		0xC78, 0x0980911F,
		0xC78, 0x0970921F,
		0xC78, 0x0960931F,
		0xC78, 0x0950941F,
		0xC78, 0x0940951F,
		0xC78, 0x0930961F,
		0xC78, 0x0920971F,
		0xC78, 0x0910981F,
		0xC78, 0x0900991F,
		0xC78, 0x08F09A1F,
		0xC78, 0x08E09B1F,
		0xC78, 0x08D09C1F,
		0xC78, 0x08C09D1F,
		0xC78, 0x08B09E1F,
		0xC78, 0x08A09F1F,
		0xC78, 0x0890A01F,
		0xC78, 0x0880A11F,
		0xC78, 0x0870A21F,
		0xC78, 0x0860A31F,
		0xC78, 0x0850A41F,
		0xC78, 0x0840A51F,
		0xC78, 0x0660A61F,
		0xC78, 0x0650A71F,
		0xC78, 0x0640A81F,
		0xC78, 0x0630A91F,
		0xC78, 0x0620AA1F,
		0xC78, 0x0610AB1F,
		0xC78, 0x0470AC1F,
		0xC78, 0x0460AD1F,
		0xC78, 0x0450AE1F,
		0xC78, 0x0440AF1F,
		0xC78, 0x0430B01F,
		0xC78, 0x0270B11F,
		0xC78, 0x0260B21F,
		0xC78, 0x0250B31F,
		0xC78, 0x0240B41F,
		0xC78, 0x0230B51F,
		0xC78, 0x0060B61F,
		0xC78, 0x0050B71F,
		0xC78, 0x0040B81F,
		0xC78, 0x0030B91F,
		0xC78, 0x0020BA1F,
		0xC78, 0x0010BB1F,
		0xC78, 0x0010BC1F,
		0xC78, 0x0010BD1F,
		0xC78, 0x0010BE1F,
		0xC78, 0x0010BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FC0801F,
		0xC78, 0x0FB0811F,
		0xC78, 0x0FA0821F,
		0xC78, 0x0F90831F,
		0xC78, 0x0F80841F,
		0xC78, 0x0F70851F,
		0xC78, 0x0F60861F,
		0xC78, 0x0F50871F,
		0xC78, 0x0F40881F,
		0xC78, 0x0F30891F,
		0xC78, 0x0F208A1F,
		0xC78, 0x0F108B1F,
		0xC78, 0x0F008C1F,
		0xC78, 0x0EF08D1F,
		0xC78, 0x0EE08E1F,
		0xC78, 0x0ED08F1F,
		0xC78, 0x0EC0901F,
		0xC78, 0x0EB0911F,
		0xC78, 0x0EA0921F,
		0xC78, 0x0E90931F,
		0xC78, 0x0E80941F,
		0xC78, 0x0E70951F,
		0xC78, 0x0E60961F,
		0xC78, 0x0E50971F,
		0xC78, 0x0E40981F,
		0xC78, 0x0E30991F,
		0xC78, 0x0E209A1F,
		0xC78, 0x0E109B1F,
		0xC78, 0x0C409C1F,
		0xC78, 0x0C309D1F,
		0xC78, 0x0C209E1F,
		0xC78, 0x0C109F1F,
		0xC78, 0x0A40A01F,
		0xC78, 0x0A30A11F,
		0xC78, 0x0A20A21F,
		0xC78, 0x0A10A31F,
		0xC78, 0x0840A41F,
		0xC78, 0x0830A51F,
		0xC78, 0x0820A61F,
		0xC78, 0x0650A71F,
		0xC78, 0x0640A81F,
		0xC78, 0x0630A91F,
		0xC78, 0x0620AA1F,
		0xC78, 0x0610AB1F,
		0xC78, 0x0450AC1F,
		0xC78, 0x0440AD1F,
		0xC78, 0x0430AE1F,
		0xC78, 0x0420AF1F,
		0xC78, 0x0260B01F,
		0xC78, 0x0250B11F,
		0xC78, 0x0240B21F,
		0xC78, 0x0230B31F,
		0xC78, 0x0220B41F,
		0xC78, 0x0210B51F,
		0xC78, 0x0040B61F,
		0xC78, 0x0030B71F,
		0xC78, 0x0020B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0801F,
		0xC78, 0x0FC0811F,
		0xC78, 0x0FB0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0F90841F,
		0xC78, 0x0F80851F,
		0xC78, 0x0F70861F,
		0xC78, 0x0F60871F,
		0xC78, 0x0F50881F,
		0xC78, 0x0F40891F,
		0xC78, 0x0F308A1F,
		0xC78, 0x0F208B1F,
		0xC78, 0x0F108C1F,
		0xC78, 0x0F008D1F,
		0xC78, 0x0EF08E1F,
		0xC78, 0x0EE08F1F,
		0xC78, 0x0ED0901F,
		0xC78, 0x0EC0911F,
		0xC78, 0x0EB0921F,
		0xC78, 0x0EA0931F,
		0xC78, 0x0E90941F,
		0xC78, 0x0E80951F,
		0xC78, 0x0E70961F,
		0xC78, 0x0CB0971F,
		0xC78, 0x0CA0981F,
		0xC78, 0x0C90991F,
		0xC78, 0x0C809A1F,
		0xC78, 0x0C709B1F,
		0xC78, 0x0C609C1F,
		0xC78, 0x0C509D1F,
		0xC78, 0x0C409E1F,
		0xC78, 0x0C309F1F,
		0xC78, 0x0C20A01F,
		0xC78, 0x0C10A11F,
		0xC78, 0x0C00A21F,
		0xC78, 0x0A40A31F,
		0xC78, 0x0A30A41F,
		0xC78, 0x0A20A51F,
		0xC78, 0x0840A61F,
		0xC78, 0x0830A71F,
		0xC78, 0x0820A81F,
		0xC78, 0x0810A91F,
		0xC78, 0x0800AA1F,
		0xC78, 0x0640AB1F,
		0xC78, 0x0630AC1F,
		0xC78, 0x0620AD1F,
		0xC78, 0x0440AE1F,
		0xC78, 0x0430AF1F,
		0xC78, 0x0420B01F,
		0xC78, 0x0410B11F,
		0xC78, 0x0400B21F,
		0xC78, 0x0050B31F,
		0xC78, 0x0040B41F,
		0xC78, 0x0030B51F,
		0xC78, 0x0020B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340022,
		0xC50, 0x00340020,
		0xC58, 0x00000022,
		0xC58, 0x00000020,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0801F,
		0xC78, 0x0FC0811F,
		0xC78, 0x0FB0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0F90841F,
		0xC78, 0x0F80851F,
		0xC78, 0x0F70861F,
		0xC78, 0x0F60871F,
		0xC78, 0x0F50881F,
		0xC78, 0x0F40891F,
		0xC78, 0x0F308A1F,
		0xC78, 0x0B708B1F,
		0xC78, 0x0B608C1F,
		0xC78, 0x0B508D1F,
		0xC78, 0x0B408E1F,
		0xC78, 0x0B308F1F,
		0xC78, 0x0B20901F,
		0xC78, 0x0B10911F,
		0xC78, 0x0B00921F,
		0xC78, 0x0CF0931F,
		0xC78, 0x0CE0941F,
		0xC78, 0x0CD0951F,
		0xC78, 0x0CC0961F,
		0xC78, 0x0CB0971F,
		0xC78, 0x0CA0981F,
		0xC78, 0x0C90991F,
		0xC78, 0x0AD09A1F,
		0xC78, 0x0AC09B1F,
		0xC78, 0x0AB09C1F,
		0xC78, 0x0AA09D1F,
		0xC78, 0x0A909E1F,
		0xC78, 0x0A809F1F,
		0xC78, 0x0A70A01F,
		0xC78, 0x0890A11F,
		0xC78, 0x0880A21F,
		0xC78, 0x0870A31F,
		0xC78, 0x0860A41F,
		0xC78, 0x0850A51F,
		0xC78, 0x0840A61F,
		0xC78, 0x0830A71F,
		0xC78, 0x0820A81F,
		0xC78, 0x0810A91F,
		0xC78, 0x0800AA1F,
		0xC78, 0x0640AB1F,
		0xC78, 0x0630AC1F,
		0xC78, 0x0620AD1F,
		0xC78, 0x0440AE1F,
		0xC78, 0x0430AF1F,
		0xC78, 0x0420B01F,
		0xC78, 0x0410B11F,
		0xC78, 0x0400B21F,
		0xC78, 0x0050B31F,
		0xC78, 0x0040B41F,
		0xC78, 0x0030B51F,
		0xC78, 0x0020B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340022,
		0xC50, 0x00340020,
		0xC58, 0x00000022,
		0xC58, 0x00000020,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0801F,
		0xC78, 0x0FC0811F,
		0xC78, 0x0FB0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0F90841F,
		0xC78, 0x0F80851F,
		0xC78, 0x0F70861F,
		0xC78, 0x0F60871F,
		0xC78, 0x0F50881F,
		0xC78, 0x0F40891F,
		0xC78, 0x0D708A1F,
		0xC78, 0x0D608B1F,
		0xC78, 0x0D508C1F,
		0xC78, 0x0D408D1F,
		0xC78, 0x0D308E1F,
		0xC78, 0x0B708F1F,
		0xC78, 0x0B60901F,
		0xC78, 0x0B50911F,
		0xC78, 0x0B40921F,
		0xC78, 0x0B30931F,
		0xC78, 0x0B20941F,
		0xC78, 0x0B10951F,
		0xC78, 0x0B00961F,
		0xC78, 0x0AF0971F,
		0xC78, 0x0AE0981F,
		0xC78, 0x0AD0991F,
		0xC78, 0x0AC09A1F,
		0xC78, 0x0AB09B1F,
		0xC78, 0x0AA09C1F,
		0xC78, 0x0A909D1F,
		0xC78, 0x0A809E1F,
		0xC78, 0x0A709F1F,
		0xC78, 0x0A60A01F,
		0xC78, 0x0A50A11F,
		0xC78, 0x0A40A21F,
		0xC78, 0x0A30A31F,
		0xC78, 0x0A20A41F,
		0xC78, 0x0840A51F,
		0xC78, 0x0830A61F,
		0xC78, 0x0820A71F,
		0xC78, 0x0810A81F,
		0xC78, 0x0800A91F,
		0xC78, 0x0640AA1F,
		0xC78, 0x0630AB1F,
		0xC78, 0x0620AC1F,
		0xC78, 0x0450AD1F,
		0xC78, 0x0440AE1F,
		0xC78, 0x0430AF1F,
		0xC78, 0x0420B01F,
		0xC78, 0x0250B11F,
		0xC78, 0x0240B21F,
		0xC78, 0x0230B31F,
		0xC78, 0x0040B41F,
		0xC78, 0x0030B51F,
		0xC78, 0x0020B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340022,
		0xC50, 0x00340020,
		0xC58, 0x00000022,
		0xC58, 0x00000020,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0FD0801F,
		0xC78, 0x0FC0811F,
		0xC78, 0x0FB0821F,
		0xC78, 0x0FA0831F,
		0xC78, 0x0F90841F,
		0xC78, 0x0F80851F,
		0xC78, 0x0F70861F,
		0xC78, 0x0F60871F,
		0xC78, 0x0F50881F,
		0xC78, 0x0F40891F,
		0xC78, 0x0F308A1F,
		0xC78, 0x0F208B1F,
		0xC78, 0x0F108C1F,
		0xC78, 0x0F008D1F,
		0xC78, 0x0EF08E1F,
		0xC78, 0x0EE08F1F,
		0xC78, 0x0ED0901F,
		0xC78, 0x0EC0911F,
		0xC78, 0x0EB0921F,
		0xC78, 0x0EA0931F,
		0xC78, 0x0E90941F,
		0xC78, 0x0E80951F,
		0xC78, 0x0E70961F,
		0xC78, 0x0CB0971F,
		0xC78, 0x0CA0981F,
		0xC78, 0x0C90991F,
		0xC78, 0x0C809A1F,
		0xC78, 0x0C709B1F,
		0xC78, 0x0C609C1F,
		0xC78, 0x0C509D1F,
		0xC78, 0x0C409E1F,
		0xC78, 0x0C309F1F,
		0xC78, 0x0C20A01F,
		0xC78, 0x0C10A11F,
		0xC78, 0x0C00A21F,
		0xC78, 0x0A40A31F,
		0xC78, 0x0A30A41F,
		0xC78, 0x0A20A51F,
		0xC78, 0x0840A61F,
		0xC78, 0x0830A71F,
		0xC78, 0x0820A81F,
		0xC78, 0x0810A91F,
		0xC78, 0x0800AA1F,
		0xC78, 0x0640AB1F,
		0xC78, 0x0630AC1F,
		0xC78, 0x0620AD1F,
		0xC78, 0x0440AE1F,
		0xC78, 0x0430AF1F,
		0xC78, 0x0420B01F,
		0xC78, 0x0410B11F,
		0xC78, 0x0400B21F,
		0xC78, 0x0050B31F,
		0xC78, 0x0040B41F,
		0xC78, 0x0030B51F,
		0xC78, 0x0020B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340022,
		0xC50, 0x00340020,
		0xC58, 0x00000022,
		0xC58, 0x00000020,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40801F,
		0xC78, 0x0F30811F,
		0xC78, 0x0F20821F,
		0xC78, 0x0F10831F,
		0xC78, 0x0F00841F,
		0xC78, 0x0D40851F,
		0xC78, 0x0D30861F,
		0xC78, 0x0D20871F,
		0xC78, 0x0980881F,
		0xC78, 0x0970891F,
		0xC78, 0x09608A1F,
		0xC78, 0x09508B1F,
		0xC78, 0x09408C1F,
		0xC78, 0x07808D1F,
		0xC78, 0x07708E1F,
		0xC78, 0x07608F1F,
		0xC78, 0x0750901F,
		0xC78, 0x0740911F,
		0xC78, 0x0730921F,
		0xC78, 0x0580931F,
		0xC78, 0x0570941F,
		0xC78, 0x0560951F,
		0xC78, 0x0550961F,
		0xC78, 0x0540971F,
		0xC78, 0x0530981F,
		0xC78, 0x0520991F,
		0xC78, 0x05109A1F,
		0xC78, 0x05009B1F,
		0xC78, 0x04F09C1F,
		0xC78, 0x04E09D1F,
		0xC78, 0x04D09E1F,
		0xC78, 0x04C09F1F,
		0xC78, 0x04B0A01F,
		0xC78, 0x04A0A11F,
		0xC78, 0x0490A21F,
		0xC78, 0x0480A31F,
		0xC78, 0x0470A41F,
		0xC78, 0x0460A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0270A91F,
		0xC78, 0x0260AA1F,
		0xC78, 0x0250AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0220AE1F,
		0xC78, 0x0210AF1F,
		0xC78, 0x0050B01F,
		0xC78, 0x0040B11F,
		0xC78, 0x0030B21F,
		0xC78, 0x0020B31F,
		0xC78, 0x0010B41F,
		0xC78, 0x0010B51F,
		0xC78, 0x0010B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0010B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0010BA1F,
		0xC78, 0x0010BB1F,
		0xC78, 0x0010BC1F,
		0xC78, 0x0010BD1F,
		0xC78, 0x0010BE1F,
		0xC78, 0x0010BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0F40801F,
		0xC78, 0x0F30811F,
		0xC78, 0x0F20821F,
		0xC78, 0x0F10831F,
		0xC78, 0x0F00841F,
		0xC78, 0x0D40851F,
		0xC78, 0x0D30861F,
		0xC78, 0x0D20871F,
		0xC78, 0x0980881F,
		0xC78, 0x0970891F,
		0xC78, 0x09608A1F,
		0xC78, 0x09508B1F,
		0xC78, 0x09408C1F,
		0xC78, 0x07808D1F,
		0xC78, 0x07708E1F,
		0xC78, 0x07608F1F,
		0xC78, 0x0750901F,
		0xC78, 0x0740911F,
		0xC78, 0x0730921F,
		0xC78, 0x0580931F,
		0xC78, 0x0570941F,
		0xC78, 0x0560951F,
		0xC78, 0x0550961F,
		0xC78, 0x0540971F,
		0xC78, 0x0530981F,
		0xC78, 0x0520991F,
		0xC78, 0x05109A1F,
		0xC78, 0x05009B1F,
		0xC78, 0x04F09C1F,
		0xC78, 0x04E09D1F,
		0xC78, 0x04D09E1F,
		0xC78, 0x04C09F1F,
		0xC78, 0x04B0A01F,
		0xC78, 0x04A0A11F,
		0xC78, 0x0490A21F,
		0xC78, 0x0480A31F,
		0xC78, 0x0470A41F,
		0xC78, 0x0460A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0270A91F,
		0xC78, 0x0260AA1F,
		0xC78, 0x0250AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0220AE1F,
		0xC78, 0x0210AF1F,
		0xC78, 0x0050B01F,
		0xC78, 0x0040B11F,
		0xC78, 0x0030B21F,
		0xC78, 0x0020B31F,
		0xC78, 0x0010B41F,
		0xC78, 0x0010B51F,
		0xC78, 0x0010B61F,
		0xC78, 0x0010B71F,
		0xC78, 0x0010B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0010BA1F,
		0xC78, 0x0010BB1F,
		0xC78, 0x0010BC1F,
		0xC78, 0x0010BD1F,
		0xC78, 0x0010BE1F,
		0xC78, 0x0010BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0801F,
		0xC78, 0x0DA0811F,
		0xC78, 0x0D90821F,
		0xC78, 0x0D80831F,
		0xC78, 0x0D70841F,
		0xC78, 0x0D60851F,
		0xC78, 0x0D50861F,
		0xC78, 0x0D40871F,
		0xC78, 0x0D30881F,
		0xC78, 0x0B70891F,
		0xC78, 0x0B608A1F,
		0xC78, 0x0B508B1F,
		0xC78, 0x09708C1F,
		0xC78, 0x09608D1F,
		0xC78, 0x09508E1F,
		0xC78, 0x09408F1F,
		0xC78, 0x0930901F,
		0xC78, 0x0920911F,
		0xC78, 0x0910921F,
		0xC78, 0x0900931F,
		0xC78, 0x08F0941F,
		0xC78, 0x08E0951F,
		0xC78, 0x08D0961F,
		0xC78, 0x08C0971F,
		0xC78, 0x08B0981F,
		0xC78, 0x08A0991F,
		0xC78, 0x08909A1F,
		0xC78, 0x08809B1F,
		0xC78, 0x06C09C1F,
		0xC78, 0x06B09D1F,
		0xC78, 0x06A09E1F,
		0xC78, 0x06909F1F,
		0xC78, 0x0680A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0420A91F,
		0xC78, 0x0410AA1F,
		0xC78, 0x0400AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0060AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC78, 0x0DB0801F,
		0xC78, 0x0DA0811F,
		0xC78, 0x0D90821F,
		0xC78, 0x0D80831F,
		0xC78, 0x0D70841F,
		0xC78, 0x0D60851F,
		0xC78, 0x0D50861F,
		0xC78, 0x0D40871F,
		0xC78, 0x0D30881F,
		0xC78, 0x0B70891F,
		0xC78, 0x0B608A1F,
		0xC78, 0x0B508B1F,
		0xC78, 0x09708C1F,
		0xC78, 0x09608D1F,
		0xC78, 0x09508E1F,
		0xC78, 0x09408F1F,
		0xC78, 0x0930901F,
		0xC78, 0x0920911F,
		0xC78, 0x0910921F,
		0xC78, 0x0900931F,
		0xC78, 0x08F0941F,
		0xC78, 0x08E0951F,
		0xC78, 0x08D0961F,
		0xC78, 0x08C0971F,
		0xC78, 0x08B0981F,
		0xC78, 0x08A0991F,
		0xC78, 0x08909A1F,
		0xC78, 0x08809B1F,
		0xC78, 0x06C09C1F,
		0xC78, 0x06B09D1F,
		0xC78, 0x06A09E1F,
		0xC78, 0x06909F1F,
		0xC78, 0x0680A01F,
		0xC78, 0x0670A11F,
		0xC78, 0x0660A21F,
		0xC78, 0x0650A31F,
		0xC78, 0x0640A41F,
		0xC78, 0x0630A51F,
		0xC78, 0x0450A61F,
		0xC78, 0x0440A71F,
		0xC78, 0x0430A81F,
		0xC78, 0x0420A91F,
		0xC78, 0x0410AA1F,
		0xC78, 0x0400AB1F,
		0xC78, 0x0240AC1F,
		0xC78, 0x0230AD1F,
		0xC78, 0x0060AE1F,
		0xC78, 0x0050AF1F,
		0xC78, 0x0040B01F,
		0xC78, 0x0030B11F,
		0xC78, 0x0020B21F,
		0xC78, 0x0010B31F,
		0xC78, 0x0000B41F,
		0xC78, 0x0000B51F,
		0xC78, 0x0000B61F,
		0xC78, 0x0000B71F,
		0xC78, 0x0000B81F,
		0xC78, 0x0000B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340222,
		0xC50, 0x00340220,
		0xC58, 0x00000222,
		0xC58, 0x00000220,
	0xA0000000,	0x00000000,
		0xC78, 0x0FE0801F,
		0xC78, 0x0FD0811F,
		0xC78, 0x0FC0821F,
		0xC78, 0x0FB0831F,
		0xC78, 0x0FA0841F,
		0xC78, 0x0F90851F,
		0xC78, 0x0F80861F,
		0xC78, 0x0F70871F,
		0xC78, 0x0F60881F,
		0xC78, 0x0F50891F,
		0xC78, 0x0F408A1F,
		0xC78, 0x0D708B1F,
		0xC78, 0x0D608C1F,
		0xC78, 0x0D508D1F,
		0xC78, 0x0D408E1F,
		0xC78, 0x0D308F1F,
		0xC78, 0x0B70901F,
		0xC78, 0x0B60911F,
		0xC78, 0x0B50921F,
		0xC78, 0x0B40931F,
		0xC78, 0x0B30941F,
		0xC78, 0x0B20951F,
		0xC78, 0x0B10961F,
		0xC78, 0x0B00971F,
		0xC78, 0x0AF0981F,
		0xC78, 0x0AE0991F,
		0xC78, 0x0AD09A1F,
		0xC78, 0x0AC09B1F,
		0xC78, 0x0AB09C1F,
		0xC78, 0x0AA09D1F,
		0xC78, 0x0A909E1F,
		0xC78, 0x0A809F1F,
		0xC78, 0x0A70A01F,
		0xC78, 0x0A60A11F,
		0xC78, 0x0A50A21F,
		0xC78, 0x0A40A31F,
		0xC78, 0x0A30A41F,
		0xC78, 0x0860A51F,
		0xC78, 0x0850A61F,
		0xC78, 0x0840A71F,
		0xC78, 0x0670A81F,
		0xC78, 0x0660A91F,
		0xC78, 0x0650AA1F,
		0xC78, 0x0640AB1F,
		0xC78, 0x0470AC1F,
		0xC78, 0x0460AD1F,
		0xC78, 0x0450AE1F,
		0xC78, 0x0290AF1F,
		0xC78, 0x0280B01F,
		0xC78, 0x0270B11F,
		0xC78, 0x0260B21F,
		0xC78, 0x0250B31F,
		0xC78, 0x0060B41F,
		0xC78, 0x0050B51F,
		0xC78, 0x0040B61F,
		0xC78, 0x0030B71F,
		0xC78, 0x0020B81F,
		0xC78, 0x0010B91F,
		0xC78, 0x0000BA1F,
		0xC78, 0x0000BB1F,
		0xC78, 0x0000BC1F,
		0xC78, 0x0000BD1F,
		0xC78, 0x0000BE1F,
		0xC78, 0x0000BF1F,
		0xC50, 0x00340022,
		0xC50, 0x00340020,
		0xC58, 0x00000022,
		0xC58, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8197f_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197f_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197f_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8197f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197f_agc_tab(void)
{
		return 72;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8197f_phy_reg[] = {
		0x800, 0x80005308,
		0x804, 0x00004001,
		0x808, 0x0000FC00,
		0x80C, 0x00000000,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0x810, 0x20200322,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x810, 0x20200322,
	0xA0000000,	0x00000000,
		0x810, 0x22000322,
	0xB0000000,	0x00000000,
		0x814, 0x020C3D10,
		0x818, 0x00000385,
		0x81C, 0x07000000,
		0x820, 0x01000100,
		0x824, 0x00390204,
		0x828, 0x01000100,
		0x82C, 0x00390204,
		0x830, 0x00000000,
		0x834, 0x00690200,
		0x838, 0x00000004,
		0x83C, 0x00690200,
		0x840, 0x00010000,
		0x844, 0x00010000,
		0x848, 0x00000000,
		0x84C, 0x00000000,
		0x850, 0x00031FE0,
		0x854, 0x00000000,
		0x858, 0x569A569A,
		0x85C, 0x00400040,
		0x860, 0x66F60000,
		0x864, 0x061F0000,
		0x868, 0x0F7F0130,
		0x86C, 0x0F7F0130,
		0x870, 0x00000300,
		0x874, 0x04003400,
		0x878, 0x08080808,
		0x87C, 0x004F0201,
		0x880, 0xD8001402,
		0x884, 0xC0000120,
		0x888, 0x00000000,
		0x88C, 0xCC0000C0,
		0x890, 0x00000000,
		0x894, 0xFFFFFFFE,
		0x898, 0x40302010,
		0x89C, 0x00706050,
		0x8A0, 0x00000000,
		0x8A4, 0x00000000,
		0x8A8, 0x00000109,
		0x8AC, 0x00000000,
		0x8B0, 0x00000000,
		0x8B4, 0x00000000,
		0x8B8, 0x00000000,
		0x8BC, 0x00000000,
		0x8C0, 0x03910C40,
		0x8C4, 0x00000000,
		0x8C8, 0x00000000,
		0x8CC, 0x00000000,
		0x8D0, 0x00000000,
		0x8D4, 0x00000000,
		0x8D8, 0x00000000,
		0x8DC, 0x00000000,
		0x8E0, 0x02000200,
		0x8E4, 0x00000000,
		0x8E8, 0xD8080000,
		0x8EC, 0x00000000,
		0x900, 0x00000000,
		0x904, 0x00000023,
		0x908, 0x00000F00,
		0x90C, 0x81121313,
		0x910, 0x024C0000,
		0x914, 0x00000000,
		0x918, 0x00000000,
		0x91C, 0x00000000,
		0x920, 0x00000000,
		0x924, 0x00000000,
		0x928, 0x00000000,
		0x92C, 0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFFFFFF,
		0x934, 0xFFFFF2F5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF5F2F,
		0x940, 0xFF44FFFF,
		0x944, 0x3F3F0F00,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFFFFFF,
		0x934, 0xFFFFF2F5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF5F2F,
		0x940, 0xFF44FFFF,
		0x944, 0x3F3F0F00,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0x930, 0xFFFF02FF,
		0x934, 0xFFFFFFF5,
		0x938, 0xFFFFFFFF,
		0x93C, 0xFFFF502F,
		0x940, 0xFF54FF0F,
		0x944, 0x3F3F0F0C,
	0xA0000000,	0x00000000,
		0x930, 0x88000000,
		0x934, 0x00000245,
		0x938, 0x00024588,
		0x93C, 0x00000000,
		0x940, 0x000007FF,
		0x944, 0x3F3F0000,
	0xB0000000,	0x00000000,
		0x948, 0x000001A3,
		0x94C, 0x20200008,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338397,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338897,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338797,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0x00338497,
	0xA0000000,	0x00000000,
		0x950, 0x00338797,
	0xB0000000,	0x00000000,
		0x954, 0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC6D87A,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC8D87A,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC8D87A,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0x958, 0x4BC5D87A,
	0xA0000000,	0x00000000,
		0x958, 0x4BC7D87A,
	0xB0000000,	0x00000000,
		0x95C, 0x06EB9B79,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000003,
		0x970, 0x00000000,
		0x974, 0x00000000,
		0x978, 0x00000000,
		0x97C, 0x10030000,
		0x980, 0x00000000,
		0x984, 0x00050050,
		0x988, 0x020A5704,
		0x98C, 0x1461C826,
		0x990, 0x0001469E,
		0x994, 0x008858D1,
		0x998, 0x70049489,
		0x99C, 0x77777777,
		0x9A0, 0x00000000,
		0x9A4, 0x00000000,
		0x9A8, 0x00000000,
		0x9AC, 0x00020000,
		0x9B0, 0x00000000,
		0x9B4, 0x00000000,
		0x9B8, 0x00000000,
		0x9BC, 0x00000000,
		0x9C0, 0x00000011,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x00000000,
		0x9E8, 0x00000000,
		0x9EC, 0x00000000,
		0x9F0, 0x80000000,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0xA00, 0x00D046C8,
		0xA04, 0x80FF800C,
		0xA08, 0x9C838300,
		0xA0C, 0x297E000F,
		0xA10, 0x9500BB78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0001,
		0xA24, 0x64B80C1C,
		0xA28, 0x00008810,
		0xA2C, 0x00920000,
		0xA70, 0x101FBF00,
		0xA74, 0x00000107,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xA78, 0x00008900,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xA78, 0x00008900,
	0xA0000000,	0x00000000,
		0xA78, 0x00000900,
	0xB0000000,	0x00000000,
		0xA7C, 0x225B0606,
		0xA80, 0x21807532,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xA84, 0x00160000,
		0xA88, 0x040C0000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xA84, 0x00160000,
		0xA88, 0x040C0000,
	0xA0000000,	0x00000000,
		0xA84, 0x00110000,
		0xA88, 0x048C0000,
	0xB0000000,	0x00000000,
		0xA8C, 0x12345678,
		0xA90, 0xABCDEF00,
		0xA94, 0x001B1B89,
		0xA98, 0x00000000,
		0xA9C, 0x3F000000,
		0xAA0, 0x00000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xAA4, 0x00010010,
	0xA0000000,	0x00000000,
		0xAA4, 0x00010010,
	0xB0000000,	0x00000000,
		0xAA8, 0xEAEF0004,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
		0xAB4, 0x00201402,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0D2E2EA,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0D2E2EA,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0D2E2EA,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACC0D2E0,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACC0D2E0,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0D2E2EA,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C6D8E6,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACC0D2E0,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C6D8E6,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C8DAE2,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C8DAE2,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C8DAE2,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xC0C8DAE2,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xD0E2F0F8,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xD0E2F0F8,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xCCDCEEF8,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xCCDCEEF8,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xCCDCEEF8,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xCEE0F0F8,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xCEE0F0F8,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACCCDAE4,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACCCDAE4,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACCCDAE4,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xABC, 0xACCCDAE4,
	0xA0000000,	0x00000000,
		0xABC, 0xD2E2F2FA,
	0xB0000000,	0x00000000,
		0xB00, 0x00000000,
		0xB04, 0x00000000,
		0xB08, 0x00000000,
		0xB0C, 0x00000000,
		0xB10, 0x00000000,
		0xB14, 0x00000000,
		0xB18, 0x00000000,
		0xB1C, 0x00000000,
		0xB20, 0x00000000,
		0xB24, 0x00000000,
		0xB28, 0x00000000,
		0xB2C, 0x00000000,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xB30, 0x00000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xB30, 0x00000000,
	0xA0000000,	0x00000000,
		0xB30, 0x20000000,
	0xB0000000,	0x00000000,
		0xB34, 0x00000000,
		0xB38, 0x00000000,
		0xB3C, 0x00000000,
		0xB40, 0x00000000,
		0xB44, 0x00000000,
		0xB48, 0x00000000,
		0xB4C, 0x00000000,
		0xB50, 0x00000000,
		0xB54, 0x00000000,
		0xB58, 0x00000000,
		0xB5C, 0x00000000,
		0xB60, 0x00000000,
		0xB64, 0x00000000,
		0xB68, 0x80000000,
		0xB6C, 0x80000000,
		0xB70, 0x00000000,
		0xB74, 0x00000000,
		0xB78, 0x00000000,
		0xB7C, 0x00000000,
		0xB80, 0x00000000,
		0xB84, 0x00000000,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xB90, 0x00000000,
		0xB94, 0x00000000,
		0xB98, 0x00000000,
		0xB9C, 0x00000000,
		0xBA0, 0x00000000,
		0xBA4, 0x00000000,
		0xBA8, 0x00000000,
		0xBAC, 0x00000000,
		0xBB0, 0x00440000,
		0xBB4, 0x00000000,
		0xBB8, 0x00000000,
		0xBBC, 0x00000000,
		0xBD0, 0x00000000,
		0xBD4, 0x00000000,
		0xBDC, 0x02000000,
		0xBE0, 0x02000000,
		0xBE4, 0x02000000,
		0xBE8, 0x02000000,
		0xBEC, 0x02000000,
		0xBF0, 0x02000000,
		0xBF4, 0x02000000,
		0xBF8, 0x02000000,
		0xC00, 0x00000080,
		0xC04, 0x6F005433,
		0xC08, 0x000004E4,
		0xC0C, 0x6C6C6C6C,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xC10, 0x20000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC10, 0x20000000,
	0xA0000000,	0x00000000,
		0xC10, 0x22000000,
	0xB0000000,	0x00000000,
		0xC14, 0x40000100,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xC18, 0x20000000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC18, 0x20000000,
	0xA0000000,	0x00000000,
		0xC18, 0x22000000,
	0xB0000000,	0x00000000,
		0xC1C, 0x40000100,
		0xC20, 0x00000000,
		0xC24, 0x40000100,
		0xC28, 0x00000000,
		0xC2C, 0x40000100,
		0xC30, 0x0401A807,
		0xC34, 0x30000020,
		0xC38, 0x23808080,
		0xC3C, 0x00002FD4,
		0xC40, 0x1CF8403F,
		0xC44, 0x000100C7,
		0xC48, 0xEC060106,
		0xC4C, 0x007F037F,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340020,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340020,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340020,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340020,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00340220,
	0xA0000000,	0x00000000,
		0xC50, 0x00340020,
	0xB0000000,	0x00000000,
		0xC54, 0x04008017,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000020,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC58, 0x00000220,
	0xA0000000,	0x00000000,
		0xC58, 0x00000020,
	0xB0000000,	0x00000000,
		0xC5C, 0x00708492,
		0xC60, 0x002E0200,
		0xC64, 0x5012838B,
		0xC68, 0x47C006C7,
		0xC6C, 0x00000035,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020155A7,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020155A7,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00001007,
		0xC74, 0x020251E9,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00001007,
		0xC74, 0x020251E9,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020151A9,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020155A9,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020155A9,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00001007,
		0xC74, 0x020251A9,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00001007,
		0xC74, 0x020251A9,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC70, 0x00000007,
		0xC74, 0x020251A7,
	0xA0000000,	0x00000000,
		0xC70, 0x00001007,
		0xC74, 0x020251A9,
	0xB0000000,	0x00000000,
		0xC78, 0x0FE07F1F,
		0xC7C, 0x00B91612,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x24000090,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC80, 0x40000100,
	0xA0000000,	0x00000000,
		0xC80, 0x40000100,
	0xB0000000,	0x00000000,
		0xC84, 0x32000000,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x24000090,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xC88, 0x40000100,
	0xA0000000,	0x00000000,
		0xC88, 0x40000100,
	0xB0000000,	0x00000000,
		0xC8C, 0xA0240000,
		0xC90, 0x40000100,
		0xC94, 0x00000000,
		0xC98, 0x40000100,
		0xC9C, 0x0000BDC8,
		0xCA0, 0x00000000,
		0xCA4, 0x098300A0,
		0xCA8, 0x00000000,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xCAC, 0x00F57B1A,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xCAC, 0x00F57B1A,
	0xA0000000,	0x00000000,
		0xCAC, 0x00F5FB1A,
	0xB0000000,	0x00000000,
		0xCB0, 0x00000000,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x28100200,
		0xCC0, 0x0010A3D0,
		0xCC4, 0x00000F7D,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x64B22427,
		0xCDC, 0x00766932,
	0x80001001,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001008,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002001,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002005,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002008,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x9000f001,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x9000f005,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x9000f004,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001004,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002004,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001006,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002006,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001002,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201002,
	0x90002002,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201002,
	0x9000f003,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002000,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001007,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002007,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90001009,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0x90002009,	0x00000000,	0x40000000,	0x00000000,
		0xCE0, 0x40201001,
	0xA0000000,	0x00000000,
		0xCE0, 0x40201001,
	0xB0000000,	0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x40E04407,
		0xCEC, 0x2E572000,
		0xCF0, 0x00000000,
		0xCF4, 0x00000000,
		0xCF8, 0x00000000,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xD00, 0x000B0680,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xD00, 0x000B0680,
	0xA0000000,	0x00000000,
		0xD00, 0x000B0780,
	0xB0000000,	0x00000000,
		0xD04, 0xC0020403,
		0xD08, 0x0000907F,
		0xD0C, 0x20010201,
		0xD10, 0x06288888,
		0xD14, 0x8888366B,
		0xD18, 0x7D806DB3,
		0xD1C, 0x0000007F,
		0xD20, 0x167401B8,
		0xD24, 0x0000018B,
		0xD28, 0xD513FF7D,
		0xD2C, 0xCC979975,
		0xD30, 0x00008000,
		0xD34, 0x40608000,
		0xD38, 0xA8000000,
		0xD3C, 0x00026EE2,
		0xD40, 0x00000000,
		0xD44, 0x00000000,
		0xD48, 0x00000000,
		0xD4C, 0x00000000,
		0xD50, 0x6437140A,
		0xD54, 0x20500000,
		0xD58, 0x16161616,
		0xD5C, 0x70320064,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xD60, 0x4653DE60,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xD60, 0x4653DE60,
	0xA0000000,	0x00000000,
		0xD60, 0x4653DA60,
	0xB0000000,	0x00000000,
		0xD64, 0x7E718A3C,
		0xD68, 0x00000103,
		0xD6C, 0x00000000,
		0xD70, 0x00000000,
		0xD74, 0x00000000,
		0xD78, 0x00000000,
		0xD7C, 0x00000000,
		0xD80, 0x00000000,
		0xD84, 0x31310000,
	0x80001003,	0x00000000,	0x40000000,	0x00000000,
		0xD88, 0xF0B50000,
	0x90002003,	0x00000000,	0x40000000,	0x00000000,
		0xD88, 0xF0B50000,
	0xA0000000,	0x00000000,
		0xD88, 0xF5B50000,
	0xB0000000,	0x00000000,
		0xD8C, 0x00000000,
		0xD90, 0x00000000,
		0xD94, 0x44BBBB44,
		0xD98, 0x44BB44FF,
		0xD9C, 0x06033688,
		0xDA0, 0x00000002,
		0xDA4, 0x00000000,
		0xDA8, 0x00000000,
		0xDAC, 0x00000000,
		0xDB0, 0x00000000,
		0xDB4, 0x00000000,
		0xDB8, 0x00000000,
		0xDBC, 0x00000000,
		0xDC0, 0x00000000,
		0xDC4, 0x00210000,
		0xDC8, 0x00000200,
		0xDCC, 0x0000000F,
		0xDD0, 0x00000020,
		0xDD4, 0x00007F7F,
		0xDD8, 0xE5AF1854,
		0xDDC, 0x000040AB,
		0xDE0, 0x00000000,
		0xDE4, 0x00000000,
		0xDE8, 0x0002030B,
		0xDEC, 0x0000A987,
		0xDF0, 0x00005807,
		0xDF4, 0x00000000,
		0xDF8, 0x00000005,
		0xE00, 0x00000000,
		0xE04, 0x00000000,
		0xE08, 0x00000000,
		0xE0C, 0x000000FF,
		0xE10, 0x00000000,
		0xE14, 0x00000000,
		0xE18, 0x00000000,
		0xE1C, 0x00000000,
		0xE20, 0x00000000,
		0xE24, 0x00200000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x01007C00,
		0xE34, 0x01004800,
		0xE38, 0x10008C0F,
		0xE3C, 0x3C008C0F,
		0xE40, 0x01007C00,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x01007C00,
		0xE54, 0x01004800,
		0xE58, 0x10008C0F,
		0xE5C, 0x3C008C0F,
		0xE60, 0x02100000,
		0xE64, 0xBBBBBBBB,
		0xE68, 0x40404040,
		0xE6C, 0x80408040,
		0xE70, 0x80408040,
		0xE74, 0x40404040,
		0xE78, 0x00400040,
		0xE7C, 0x40404040,
		0xE80, 0x00FF0000,
		0xE84, 0x80408040,
		0xE88, 0x40404040,
		0xE8C, 0x80408040,
		0xE90, 0x00000000,
		0xE94, 0x01000000,
		0xE98, 0x00000000,
		0xE9C, 0x00000000,
		0xEA0, 0x00000000,
		0xEA4, 0x01000000,
		0xEA8, 0x00000000,
		0xEAC, 0x00000000,
		0xEB0, 0x00000000,
		0xEB4, 0x01000000,
		0xEB8, 0x00000000,
		0xEBC, 0x00000000,
		0xEC0, 0x00000000,
		0xEC4, 0x01000000,
		0xEC8, 0x00000000,
		0xECC, 0x00000000,
		0xED0, 0x80408040,
		0xED4, 0x80408040,
		0xED8, 0x80408040,
		0xEDC, 0xC040C040,
		0xEE0, 0xC040C040,
		0xEE4, 0x00400040,
		0xEE8, 0xD8001402,
		0xEEC, 0xC0000120,
		0xEF0, 0x02000B09,
		0xEF4, 0x00000001,
		0xEF8, 0x00000000,
		0xF00, 0x00000300,
		0xF04, 0x00000000,
		0xF08, 0x0002030B,
		0xF0C, 0x0000A987,
		0xF10, 0x00005807,
		0xF14, 0x00000003,
		0xF18, 0x00020002,
		0xF1C, 0x8000001F,
		0xF20, 0x00000000,
		0xF24, 0x00000000,
		0xF28, 0x00000000,
		0xF2C, 0x00000000,
		0xF30, 0x00000000,
		0xF34, 0x00000000,
		0xF38, 0x00030155,
		0xF3C, 0x0000003A,
		0xF40, 0x00000000,
		0xF44, 0x00000000,
		0xF48, 0x00030000,
		0xF4C, 0x13000000,
		0xF50, 0x00000010,
		0xF54, 0x00000000,
		0xF58, 0x00000000,
		0xF5C, 0x00000000,
		0xF60, 0x00000000,
		0xF64, 0x00000000,
		0xF68, 0x00000000,
		0xF6C, 0x00000000,
		0xF70, 0x00000000,
		0xF74, 0x00000000,
		0xF78, 0x00000000,
		0xF7C, 0x00000000,
		0xF80, 0x00000000,
		0xF84, 0x00000000,
		0xF88, 0x00000000,
		0xF8C, 0x00000000,
		0xF90, 0x00000002,
		0xF94, 0x00000000,
		0xF98, 0x00000000,
		0xF9C, 0x00000000,
		0xFA0, 0x00000000,
		0xFA4, 0x0002030B,
		0xFA8, 0x0000A987,
		0xFAC, 0x00005807,
		0xFB0, 0x00000000,
		0xFB4, 0x00000000,
		0xFB8, 0x00000000,
		0xFBC, 0x00000000,
		0xFC0, 0x00C02001,
		0xFC4, 0x90063000,
		0xFC8, 0x00000018,
		0xFCC, 0x10003005,
		0xFD0, 0x0000E5AF,
		0xFD4, 0x00000000,
		0xFD8, 0x00000000,
		0xFDC, 0x00000000,
		0xFE0, 0x00000000,
		0xFE4, 0x00000000,
		0xFE8, 0x00000000,
		0xFEC, 0x00000000,
		0xFF0, 0x00000000,
		0xFF4, 0x00000000,
		0xFF8, 0x00000000,

};

void
odm_read_and_config_mp_8197f_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8197f_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8197f_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8197f(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8197f_phy_reg(void)
{
		return 72;
}

#endif /* end of HWIMG_SUPPORT*/

