/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.7*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8721D_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8721d_agc_tab[] = {
		0xC78, 0xFF000001,
		0xC78, 0xFE010001,
		0xC78, 0xFD020001,
		0xC78, 0xFC030001,
		0xC78, 0xFB040001,
		0xC78, 0xFA050001,
		0xC78, 0xF9060001,
		0xC78, 0xF8070001,
		0xC78, 0xF7080001,
		0xC78, 0xF6090001,
		0xC78, 0xF50A0001,
		0xC78, 0xF40B0001,
		0xC78, 0xF30C0001,
		0xC78, 0xF20D0001,
		0xC78, 0xF10E0001,
		0xC78, 0xF00F0001,
		0xC78, 0xEF100001,
		0xC78, 0xEE110001,
		0xC78, 0xED120001,
		0xC78, 0xEC130001,
		0xC78, 0xEB140001,
		0xC78, 0xEA150001,
		0xC78, 0xE9160001,
		0xC78, 0xE8170001,
		0xC78, 0xE7180001,
		0xC78, 0xE6190001,
		0xC78, 0xE51A0001,
		0xC78, 0xE41B0001,
		0xC78, 0xE31C0001,
		0xC78, 0xE21D0001,
		0xC78, 0xE11E0001,
		0xC78, 0xC31F0001,
		0xC78, 0xC2200001,
		0xC78, 0xC1210001,
		0xC78, 0x88220001,
		0xC78, 0x87230001,
		0xC78, 0x86240001,
		0xC78, 0x85250001,
		0xC78, 0x84260001,
		0xC78, 0x83270001,
		0xC78, 0x65280001,
		0xC78, 0x64290001,
		0xC78, 0x482A0001,
		0xC78, 0x472B0001,
		0xC78, 0x462C0001,
		0xC78, 0x452D0001,
		0xC78, 0x442E0001,
		0xC78, 0x432F0001,
		0xC78, 0x42300001,
		0xC78, 0x41310001,
		0xC78, 0x09320001,
		0xC78, 0x08330001,
		0xC78, 0x07340001,
		0xC78, 0x06350001,
		0xC78, 0x05360001,
		0xC78, 0x04370001,
		0xC78, 0x03380001,
		0xC78, 0x02390001,
		0xC78, 0x013A0001,
		0xC78, 0x003B0001,
		0xC78, 0x003C0001,
		0xC78, 0x003D0001,
		0xC78, 0x003E0001,
		0xC78, 0x003F0001,
		0xC78, 0xFF400001,
		0xC78, 0xFF410001,
		0xC78, 0xFF420001,
		0xC78, 0xFE430001,
		0xC78, 0xFD440001,
		0xC78, 0xFC450001,
		0xC78, 0xFB460001,
		0xC78, 0xFA470001,
		0xC78, 0xF9480001,
		0xC78, 0xF8490001,
		0xC78, 0xF74A0001,
		0xC78, 0xF64B0001,
		0xC78, 0xF54C0001,
		0xC78, 0xF44D0001,
		0xC78, 0xF34E0001,
		0xC78, 0xF24F0001,
		0xC78, 0xF1500001,
		0xC78, 0xF0510001,
		0xC78, 0xEF520001,
		0xC78, 0xEE530001,
		0xC78, 0xED540001,
		0xC78, 0xEC550001,
		0xC78, 0xEB560001,
		0xC78, 0xEA570001,
		0xC78, 0xE9580001,
		0xC78, 0xE8590001,
		0xC78, 0xE75A0001,
		0xC78, 0xE65B0001,
		0xC78, 0xE55C0001,
		0xC78, 0xE45D0001,
		0xC78, 0xE35E0001,
		0xC78, 0xE25F0001,
		0xC78, 0xE1600001,
		0xC78, 0xC4610001,
		0xC78, 0xC3620001,
		0xC78, 0xC2630001,
		0xC78, 0xC1640001,
		0xC78, 0x87650001,
		0xC78, 0x86660001,
		0xC78, 0x85670001,
		0xC78, 0x84680001,
		0xC78, 0x83690001,
		0xC78, 0x826A0001,
		0xC78, 0x816B0001,
		0xC78, 0x486C0001,
		0xC78, 0x476D0001,
		0xC78, 0x466E0001,
		0xC78, 0x456F0001,
		0xC78, 0x44700001,
		0xC78, 0x43710001,
		0xC78, 0x07720001,
		0xC78, 0x06730001,
		0xC78, 0x05740001,
		0xC78, 0x04750001,
		0xC78, 0x03760001,
		0xC78, 0x02770001,
		0xC78, 0x01780001,
		0xC78, 0x00790001,
		0xC78, 0x007A0001,
		0xC78, 0x007B0001,
		0xC78, 0x007C0001,
		0xC78, 0x007D0001,
		0xC78, 0x007E0001,
		0xC78, 0x007F0001,
		0xC78, 0xFF001001,
		0xC78, 0xFF011001,
		0xC78, 0xFF021001,
		0xC78, 0xFE031001,
		0xC78, 0xFD041001,
		0xC78, 0xFC051001,
		0xC78, 0xFB061001,
		0xC78, 0xFA071001,
		0xC78, 0xF9081001,
		0xC78, 0xF8091001,
		0xC78, 0xF70A1001,
		0xC78, 0xF60B1001,
		0xC78, 0xF50C1001,
		0xC78, 0xF40D1001,
		0xC78, 0xF30E1001,
		0xC78, 0xF20F1001,
		0xC78, 0xF1101001,
		0xC78, 0xF0111001,
		0xC78, 0xEF121001,
		0xC78, 0xEE131001,
		0xC78, 0xED141001,
		0xC78, 0xEC151001,
		0xC78, 0xEB161001,
		0xC78, 0xEA171001,
		0xC78, 0xE9181001,
		0xC78, 0xE8191001,
		0xC78, 0xE71A1001,
		0xC78, 0xE61B1001,
		0xC78, 0xE51C1001,
		0xC78, 0xE41D1001,
		0xC78, 0xE31E1001,
		0xC78, 0xE21F1001,
		0xC78, 0xE1201001,
		0xC78, 0xA7211001,
		0xC78, 0xA6221001,
		0xC78, 0xA5231001,
		0xC78, 0xA4241001,
		0xC78, 0xA3251001,
		0xC78, 0xA2261001,
		0xC78, 0xA1271001,
		0xC78, 0x68281001,
		0xC78, 0x67291001,
		0xC78, 0x662A1001,
		0xC78, 0x652B1001,
		0xC78, 0x642C1001,
		0xC78, 0x632D1001,
		0xC78, 0x282E1001,
		0xC78, 0x272F1001,
		0xC78, 0x26301001,
		0xC78, 0x25311001,
		0xC78, 0x24321001,
		0xC78, 0x23331001,
		0xC78, 0x22341001,
		0xC78, 0x05351001,
		0xC78, 0x04361001,
		0xC78, 0x03371001,
		0xC78, 0x02381001,
		0xC78, 0x01391001,
		0xC78, 0x003A1001,
		0xC78, 0x003B1001,
		0xC78, 0x003C1001,
		0xC78, 0x003D1001,
		0xC78, 0x003E1001,
		0xC78, 0x003F1001,
		0xC78, 0xFF401001,
		0xC78, 0xFE411001,
		0xC78, 0xFD421001,
		0xC78, 0xFC431001,
		0xC78, 0xFB441001,
		0xC78, 0xFA451001,
		0xC78, 0xF9461001,
		0xC78, 0xF8471001,
		0xC78, 0xF7481001,
		0xC78, 0xF6491001,
		0xC78, 0xF54A1001,
		0xC78, 0xF44B1001,
		0xC78, 0xF34C1001,
		0xC78, 0xF24D1001,
		0xC78, 0xF14E1001,
		0xC78, 0xF04F1001,
		0xC78, 0xEF501001,
		0xC78, 0xEE511001,
		0xC78, 0xED521001,
		0xC78, 0xEC531001,
		0xC78, 0xEB541001,
		0xC78, 0xEA551001,
		0xC78, 0xE9561001,
		0xC78, 0xE8571001,
		0xC78, 0xE7581001,
		0xC78, 0xE6591001,
		0xC78, 0xE55A1001,
		0xC78, 0xE45B1001,
		0xC78, 0xE35C1001,
		0xC78, 0xE25D1001,
		0xC78, 0xE15E1001,
		0xC78, 0xA85F1001,
		0xC78, 0xA7601001,
		0xC78, 0xA6611001,
		0xC78, 0xA5621001,
		0xC78, 0xA4631001,
		0xC78, 0xA3641001,
		0xC78, 0xA2651001,
		0xC78, 0xA1661001,
		0xC78, 0x68671001,
		0xC78, 0x67681001,
		0xC78, 0x66691001,
		0xC78, 0x656A1001,
		0xC78, 0x646B1001,
		0xC78, 0x636C1001,
		0xC78, 0x626D1001,
		0xC78, 0x616E1001,
		0xC78, 0x276F1001,
		0xC78, 0x26701001,
		0xC78, 0x25711001,
		0xC78, 0x24721001,
		0xC78, 0x23731001,
		0xC78, 0x22741001,
		0xC78, 0x05751001,
		0xC78, 0x04761001,
		0xC78, 0x03771001,
		0xC78, 0x02781001,
		0xC78, 0x01791001,
		0xC78, 0x007A1001,
		0xC78, 0x007B1001,
		0xC78, 0x007C1001,
		0xC78, 0x007D1001,
		0xC78, 0x007E1001,
		0xC78, 0x007F1001,
		0xC78, 0xFF004001,
		0xC78, 0xFE014001,
		0xC78, 0xFD024001,
		0xC78, 0xFC034001,
		0xC78, 0xFB044001,
		0xC78, 0xFA054001,
		0xC78, 0xF9064001,
		0xC78, 0xF8074001,
		0xC78, 0xF7084001,
		0xC78, 0xF6094001,
		0xC78, 0xF50A4001,
		0xC78, 0xF40B4001,
		0xC78, 0xF30C4001,
		0xC78, 0xF20D4001,
		0xC78, 0xF10E4001,
		0xC78, 0xB90F4001,
		0xC78, 0xB8104001,
		0xC78, 0xB7114001,
		0xC78, 0xB6124001,
		0xC78, 0xB5134001,
		0xC78, 0xB4144001,
		0xC78, 0xB3154001,
		0xC78, 0xB2164001,
		0xC78, 0xB1174001,
		0xC78, 0xB0184001,
		0xC78, 0xAF194001,
		0xC78, 0xAE1A4001,
		0xC78, 0xAD1B4001,
		0xC78, 0xAC1C4001,
		0xC78, 0xAB1D4001,
		0xC78, 0xAA1E4001,
		0xC78, 0xA91F4001,
		0xC78, 0xA8204001,
		0xC78, 0xA7214001,
		0xC78, 0xA6224001,
		0xC78, 0xA5234001,
		0xC78, 0x69244001,
		0xC78, 0x68254001,
		0xC78, 0x67264001,
		0xC78, 0x66274001,
		0xC78, 0x65284001,
		0xC78, 0x64294001,
		0xC78, 0x632A4001,
		0xC78, 0x622B4001,
		0xC78, 0x612C4001,
		0xC78, 0x602D4001,
		0xC78, 0x442E4001,
		0xC78, 0x432F4001,
		0xC78, 0x42304001,
		0xC78, 0x41314001,
		0xC78, 0x40324001,
		0xC78, 0x08334001,
		0xC78, 0x07344001,
		0xC78, 0x06354001,
		0xC78, 0x05364001,
		0xC78, 0x04374001,
		0xC78, 0x03384001,
		0xC78, 0x02394001,
		0xC78, 0x013A4001,
		0xC78, 0x003B4001,
		0xC78, 0x003C4001,
		0xC78, 0x003D4001,
		0xC78, 0x003E4001,
		0xC78, 0x003F4001,
		0xC50, 0x69553422,
		0xC50, 0x69553420,

};

void
odm_read_and_config_mp_8721d_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8721d_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8721d_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8721d(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8721d_agc_tab(void)
{
		return 2;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8721d_phy_reg[] = {
		0x800, 0x80044D00,
		0x804, 0x00000001,
		0x808, 0x00FC8000,
		0x80C, 0x0000000A,
		0x810, 0x10001331,
		0x814, 0x020C3D10,
		0x818, 0x00240385,
		0x81C, 0x00000000,
		0x820, 0x01000100,
		0x824, 0x00390204,
		0x828, 0x00000000,
		0x82C, 0x00000000,
		0x830, 0x00000000,
		0x834, 0x00000000,
		0x838, 0x00000000,
		0x83C, 0x00000000,
		0x840, 0x00010000,
		0x844, 0x00000000,
		0x848, 0x00000000,
		0x84C, 0x00000000,
		0x850, 0x00030000,
		0x854, 0x00000000,
		0x858, 0x7E5D569A,
		0x85C, 0x569A569A,
		0x860, 0x00000130,
		0x864, 0x20000000,
		0x868, 0x00000000,
		0x86C, 0x4E4E4E00,
		0x870, 0x00050000,
		0x874, 0x25005000,
		0x878, 0x00000808,
		0x87C, 0x004F0201,
		0x880, 0xE2003612,
		0x884, 0x2E4005E0,
		0x888, 0x00000003,
		0x88C, 0xCCC400C0,
		0x890, 0x00000800,
		0x894, 0xFFFFFFFE,
		0x898, 0x40302010,
		0x89C, 0x00706050,
		0x900, 0x00000000,
		0x904, 0x00000023,
		0x908, 0x00000000,
		0x90C, 0x81121111,
		0x910, 0x00000402,
		0x914, 0x00000201,
		0x920, 0x18C6318C,
		0x924, 0x0000018C,
		0x948, 0x99000000,
		0x94C, 0x00000010,
		0x950, 0x00003000,
		0x954, 0x5A880000,
		0x958, 0x4BC5A87A,
		0x95C, 0x04EB9B79,
		0x96C, 0x00000003,
		0x970, 0x00000000,
		0x974, 0x00000000,
		0x978, 0x00000000,
		0x97C, 0x13000000,
		0x980, 0x00000000,
		0xA00, 0x00D047C8,
		0xA04, 0xC0FF0008,
		0xA08, 0x88838300,
		0xA0C, 0x2E20100F,
		0xA10, 0x8D00BB78,
		0xA14, 0x11144028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0001,
		0xA24, 0x64B80C1C,
		0xA28, 0x00158810,
		0xA2C, 0x10998000,
		0xA70, 0x00008000,
		0xA74, 0x80800100,
		0xA78, 0x000089F0,
		0xA7C, 0x225B0606,
		0xA80, 0x20807530,
		0xA84, 0x00200200,
		0xA88, 0x00CC0080,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00560000,
		0xAA0, 0x00000000,
		0xAA4, 0x00020014,
		0xAA8, 0xBA0A0008,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
		0xAB4, 0x00201402,
		0xAB8, 0x0000001C,
		0xABC, 0x0000F7FF,
		0xAC0, 0xD4C0A742,
		0xAC4, 0x00000000,
		0xAC8, 0x00000F08,
		0xACC, 0x00000F08,
		0xAD0, 0xA1052A10,
		0xAD4, 0x4C9D8452,
		0xAD8, 0x86024024,
		0xADC, 0x00224001,
		0xAE0, 0x170003D1,
		0xAE8, 0x00000805,
		0xB2C, 0x00000000,
		0xC00, 0x48071D40,
		0xC04, 0x03A05611,
		0xC08, 0x000000E4,
		0xC0C, 0x6C6C6C6C,
		0xC10, 0x18800000,
		0xC14, 0x40000100,
		0xC18, 0x08800000,
		0xC1C, 0x40000100,
		0xC20, 0x00000000,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x69E9CC48,
		0xC34, 0x31000040,
		0xC38, 0x21A88080,
		0xC3C, 0x000016CC,
		0xC40, 0x1F78403F,
		0xC44, 0x00010036,
		0xC48, 0xEC020107,
		0xC4C, 0x007F037F,
		0xC50, 0x69553420,
		0xC54, 0x43BC0094,
		0xC58, 0x00013169,
		0xC5C, 0x00250492,
		0xC60, 0x00280A00,
		0xC64, 0x7112848B,
		0xC68, 0x47C074FF,
		0xC6C, 0x00000036,
		0xC70, 0x2C7F000D,
		0xC74, 0x020600DB,
		0xC78, 0x0000001F,
		0xC7C, 0x00BB1612,
		0xC80, 0x390000E4,
		0xC84, 0x31F60000,
		0xC88, 0x1051B75F,
		0xC8C, 0x20200109,
		0xC90, 0x00122A42,
		0xC94, 0x00000000,
		0xC98, 0x00121820,
		0xC9C, 0x00007F7F,
		0xCA0, 0x00FD8000,
		0xCA4, 0x800000A0,
		0xCA8, 0x04E6C606,
		0xCAC, 0x27C44F60,
		0xCB0, 0x00000000,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x28000000,
		0xCC0, 0x1051B75F,
		0xCC4, 0x00000109,
		0xCC8, 0x000442D6,
		0xCCC, 0x00000000,
		0xCD0, 0x000001C8,
		0xCD4, 0x001C8000,
		0xCD8, 0x00000100,
		0xCDC, 0x40100000,
		0xCE0, 0x00222220,
		0xCE4, 0x20000000,
		0xCE8, 0x37644302,
		0xCEC, 0x2F97D40C,
		0xD00, 0x04030740,
		0xD04, 0xC0020401,
		0xD08, 0x0000907F,
		0xD0C, 0x20010201,
		0xD10, 0xA0633333,
		0xD14, 0x3333BC77,
		0xD18, 0x7A8F5B6F,
		0xD2C, 0xDB979975,
		0xD30, 0x00000000,
		0xD34, 0x40608000,
		0xD38, 0xE9F5A000,
		0xD3C, 0x40127353,
		0xD40, 0x00000000,
		0xD44, 0x00000000,
		0xD48, 0x00000000,
		0xD4C, 0x00000000,
		0xD50, 0x04BC6028,
		0xD54, 0x00000000,
		0xD58, 0x00000282,
		0xD5C, 0x30032064,
		0xD60, 0x4653DE68,
		0xD64, 0x04518A3C,
		0xD68, 0x00002101,
		0xD7C, 0x00600000,
		0xD80, 0x5002EAAE,
		0xE00, 0x5A5A5A5A,
		0xE04, 0x5A5A5A5A,
		0xE08, 0x03904E5A,
		0xE10, 0x5A5A5A5A,
		0xE14, 0x5A5A5A5A,
		0xE18, 0x5A5A5A5A,
		0xE1C, 0x5A5A5A5A,
		0xE28, 0x00000000,
		0xE30, 0x1000DC1F,
		0xE34, 0x10008C1F,
		0xE38, 0x02140102,
		0xE3C, 0x681604C2,
		0xE40, 0x01007C00,
		0xE44, 0x01004800,
		0xE48, 0xFB000000,
		0xE4C, 0x000028D1,
		0xE50, 0x1000DC1F,
		0xE54, 0x10008C1F,
		0xE58, 0x02140102,
		0xE5C, 0x28160D05,
		0xE60, 0x0000C008,
		0xE68, 0x001B25A4,
		0xE64, 0x281600A0,
		0xE6C, 0x01C00010,
		0xE70, 0x01C00016,
		0xE74, 0x02000010,
		0xE78, 0x02000010,
		0xE7C, 0x02000010,
		0xE80, 0x02000010,
		0xE84, 0x01C00010,
		0xE88, 0x02000010,
		0xE8C, 0x01C00010,
		0xED0, 0x01C00010,
		0xED4, 0x01C00010,
		0xED8, 0x01C00010,
		0xEDC, 0x00000010,
		0xEE0, 0x00000010,
		0xEEC, 0x03C00010,
		0xF14, 0x00000003,
		0xF00, 0x00100300,
		0xF08, 0x0000800B,
		0xF0C, 0x0000F007,
		0xF10, 0x0000A487,
		0xF1C, 0x80000064,
		0xF38, 0x00030155,
		0xF3C, 0x0000003A,
		0xF4C, 0x13000000,
		0xF50, 0x00000000,
		0xF18, 0x00000000,

};

void
odm_read_and_config_mp_8721d_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8721d_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8721d_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8721d(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8721d_phy_reg(void)
{
		return 2;
}

/******************************************************************************
 *                           phy_reg_pg_type0.TXT
 ******************************************************************************/

#ifdef CONFIG_8721D_TYPE0
_WEAK const u32 array_mp_8721d_phy_reg_pg_type0[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003200,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x32323200,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x30343434,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x26262830
};

#endif

void
odm_read_and_config_mp_8721d_phy_reg_pg_type0(struct dm_struct *dm)
{
#ifdef CONFIG_8721D_TYPE0

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8721d_phy_reg_pg_type0) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8721d_phy_reg_pg_type0;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8721d(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8721D_TYPE1
_WEAK const u32 array_mp_8721d_phy_reg_pg_type1[] = {
	0, 0, 0, 0x00000e08, 0x0000ff00, 0x00003200,
	0, 0, 0, 0x0000086c, 0xffffff00, 0x32323200,
	0, 0, 0, 0x00000e00, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000e04, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000e10, 0xffffffff, 0x30343434,
	0, 0, 0, 0x00000e14, 0xffffffff, 0x26262830
};

#endif

void
odm_read_and_config_mp_8721d_phy_reg_pg_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8721D_TYPE1

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8721d_phy_reg_pg_type1) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8721d_phy_reg_pg_type1;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8721d(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

