/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8814B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8814b_agc_tab[] = {
	0x81000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000FC,
		0x1D90, 0x300100FB,
		0x1D90, 0x300200FA,
		0x1D90, 0x300300F9,
		0x1D90, 0x300400F8,
		0x1D90, 0x300500F7,
		0x1D90, 0x300600F6,
		0x1D90, 0x300700F5,
		0x1D90, 0x300800F4,
		0x1D90, 0x300900F3,
		0x1D90, 0x300A00F2,
		0x1D90, 0x300B00F1,
		0x1D90, 0x300C00F0,
		0x1D90, 0x300D00EF,
		0x1D90, 0x300E00EE,
		0x1D90, 0x300F00ED,
		0x1D90, 0x301000EC,
		0x1D90, 0x301100EB,
		0x1D90, 0x301200EA,
		0x1D90, 0x301300E9,
		0x1D90, 0x301400E8,
		0x1D90, 0x301500E7,
		0x1D90, 0x301600C8,
		0x1D90, 0x301700C7,
		0x1D90, 0x301800AA,
		0x1D90, 0x301900A9,
		0x1D90, 0x301A00A8,
		0x1D90, 0x301B00A7,
		0x1D90, 0x301C00A6,
		0x1D90, 0x301D00A5,
		0x1D90, 0x301E00A4,
		0x1D90, 0x301F00A3,
		0x1D90, 0x302000A2,
		0x1D90, 0x302100A1,
		0x1D90, 0x30220069,
		0x1D90, 0x30230068,
		0x1D90, 0x30240067,
		0x1D90, 0x30250066,
		0x1D90, 0x30260065,
		0x1D90, 0x30270064,
		0x1D90, 0x30280063,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B000A,
		0x1D90, 0x302C0009,
		0x1D90, 0x302D0008,
		0x1D90, 0x302E0007,
		0x1D90, 0x302F0006,
		0x1D90, 0x30300005,
		0x1D90, 0x30310004,
		0x1D90, 0x30320003,
		0x1D90, 0x30330002,
		0x1D90, 0x30340001,
		0x1D90, 0x30350000,
		0x1D90, 0x30360000,
		0x1D90, 0x30370000,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x300000FC,
		0x1D90, 0x300100FB,
		0x1D90, 0x300200FA,
		0x1D90, 0x300300F9,
		0x1D90, 0x300400F8,
		0x1D90, 0x300500F7,
		0x1D90, 0x300600F6,
		0x1D90, 0x300700F5,
		0x1D90, 0x300800F4,
		0x1D90, 0x300900F3,
		0x1D90, 0x300A00F2,
		0x1D90, 0x300B00F1,
		0x1D90, 0x300C00F0,
		0x1D90, 0x300D00EF,
		0x1D90, 0x300E00EE,
		0x1D90, 0x300F00ED,
		0x1D90, 0x301000EC,
		0x1D90, 0x301100EB,
		0x1D90, 0x301200EA,
		0x1D90, 0x301300E9,
		0x1D90, 0x301400E8,
		0x1D90, 0x301500E7,
		0x1D90, 0x301600C8,
		0x1D90, 0x301700C7,
		0x1D90, 0x301800AA,
		0x1D90, 0x301900A9,
		0x1D90, 0x301A00A8,
		0x1D90, 0x301B00A7,
		0x1D90, 0x301C00A6,
		0x1D90, 0x301D00A5,
		0x1D90, 0x301E00A4,
		0x1D90, 0x301F00A3,
		0x1D90, 0x302000A2,
		0x1D90, 0x302100A1,
		0x1D90, 0x30220069,
		0x1D90, 0x30230068,
		0x1D90, 0x30240067,
		0x1D90, 0x30250066,
		0x1D90, 0x30260065,
		0x1D90, 0x30270064,
		0x1D90, 0x30280063,
		0x1D90, 0x30290062,
		0x1D90, 0x302A0061,
		0x1D90, 0x302B000A,
		0x1D90, 0x302C0009,
		0x1D90, 0x302D0008,
		0x1D90, 0x302E0007,
		0x1D90, 0x302F0006,
		0x1D90, 0x30300005,
		0x1D90, 0x30310004,
		0x1D90, 0x30320003,
		0x1D90, 0x30330002,
		0x1D90, 0x30340001,
		0x1D90, 0x30350000,
		0x1D90, 0x30360000,
		0x1D90, 0x30370000,
		0x1D90, 0x30380000,
		0x1D90, 0x30390000,
		0x1D90, 0x303A0000,
		0x1D90, 0x303B0000,
		0x1D90, 0x303C0000,
		0x1D90, 0x303D0000,
		0x1D90, 0x303E0000,
		0x1D90, 0x303F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x300000FF,
		0x1D90, 0x300100FF,
		0x1D90, 0x300200FF,
		0x1D90, 0x300300FE,
		0x1D90, 0x300400FD,
		0x1D90, 0x300500FC,
		0x1D90, 0x300600FB,
		0x1D90, 0x300700FA,
		0x1D90, 0x300800F9,
		0x1D90, 0x300900F8,
		0x1D90, 0x300A00F7,
		0x1D90, 0x300B00F6,
		0x1D90, 0x300C00F5,
		0x1D90, 0x300D00F4,
		0x1D90, 0x300E00F3,
		0x1D90, 0x300F00F2,
		0x1D90, 0x301000F1,
		0x1D90, 0x301100F0,
		0x1D90, 0x301200EF,
		0x1D90, 0x301300EE,
		0x1D90, 0x301400ED,
		0x1D90, 0x301500EC,
		0x1D90, 0x301600EB,
		0x1D90, 0x301700EA,
		0x1D90, 0x301800E9,
		0x1D90, 0x301900E8,
		0x1D90, 0x301A00E7,
		0x1D90, 0x301B00E6,
		0x1D90, 0x301C00E5,
		0x1D90, 0x301D00C6,
		0x1D90, 0x301E00C5,
		0x1D90, 0x301F00C4,
		0x1D90, 0x302000C3,
		0x1D90, 0x302100C2,
		0x1D90, 0x302200C1,
		0x1D90, 0x302300A5,
		0x1D90, 0x302400A4,
		0x1D90, 0x302500A3,
		0x1D90, 0x302600A2,
		0x1D90, 0x302700A1,
		0x1D90, 0x30280086,
		0x1D90, 0x30290085,
		0x1D90, 0x302A0084,
		0x1D90, 0x302B0083,
		0x1D90, 0x302C0082,
		0x1D90, 0x302D0065,
		0x1D90, 0x302E0064,
		0x1D90, 0x302F0063,
		0x1D90, 0x30300062,
		0x1D90, 0x30310061,
		0x1D90, 0x30320060,
		0x1D90, 0x30330043,
		0x1D90, 0x30340042,
		0x1D90, 0x30350026,
		0x1D90, 0x30360025,
		0x1D90, 0x30370024,
		0x1D90, 0x30380023,
		0x1D90, 0x30390006,
		0x1D90, 0x303A0005,
		0x1D90, 0x303B0004,
		0x1D90, 0x303C0003,
		0x1D90, 0x303D0002,
		0x1D90, 0x303E0001,
		0x1D90, 0x303F0000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300CA,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600AB,
		0x1D90, 0x305700AA,
		0x1D90, 0x305800A9,
		0x1D90, 0x305900A8,
		0x1D90, 0x305A00A7,
		0x1D90, 0x305B00A6,
		0x1D90, 0x305C00A5,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F0065,
		0x1D90, 0x30600064,
		0x1D90, 0x30610063,
		0x1D90, 0x30620062,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680044,
		0x1D90, 0x30690026,
		0x1D90, 0x306A0025,
		0x1D90, 0x306B0024,
		0x1D90, 0x306C0023,
		0x1D90, 0x306D0022,
		0x1D90, 0x306E0021,
		0x1D90, 0x306F0247,
		0x1D90, 0x30700246,
		0x1D90, 0x30710245,
		0x1D90, 0x30720244,
		0x1D90, 0x30730226,
		0x1D90, 0x30740225,
		0x1D90, 0x30750224,
		0x1D90, 0x30760223,
		0x1D90, 0x30770222,
		0x1D90, 0x30780221,
		0x1D90, 0x30790207,
		0x1D90, 0x307A0206,
		0x1D90, 0x307B0205,
		0x1D90, 0x307C0204,
		0x1D90, 0x307D0203,
		0x1D90, 0x307E0202,
		0x1D90, 0x307F0201,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FE,
		0x1D90, 0x304200FD,
		0x1D90, 0x304300FC,
		0x1D90, 0x304400FB,
		0x1D90, 0x304500FA,
		0x1D90, 0x304600F9,
		0x1D90, 0x304700F8,
		0x1D90, 0x304800F7,
		0x1D90, 0x304900F6,
		0x1D90, 0x304A00F5,
		0x1D90, 0x304B00F4,
		0x1D90, 0x304C00F3,
		0x1D90, 0x304D00F2,
		0x1D90, 0x304E00F1,
		0x1D90, 0x304F00F0,
		0x1D90, 0x305000EF,
		0x1D90, 0x305100EE,
		0x1D90, 0x305200ED,
		0x1D90, 0x305300EC,
		0x1D90, 0x305400EB,
		0x1D90, 0x305500EA,
		0x1D90, 0x305600E9,
		0x1D90, 0x305700E8,
		0x1D90, 0x305800E7,
		0x1D90, 0x305900E6,
		0x1D90, 0x305A00E5,
		0x1D90, 0x305B00E4,
		0x1D90, 0x305C00E3,
		0x1D90, 0x305D00E2,
		0x1D90, 0x305E00E1,
		0x1D90, 0x305F00C4,
		0x1D90, 0x306000C3,
		0x1D90, 0x306100C2,
		0x1D90, 0x306200C1,
		0x1D90, 0x306300A4,
		0x1D90, 0x306400A3,
		0x1D90, 0x306500A2,
		0x1D90, 0x306600A1,
		0x1D90, 0x30670082,
		0x1D90, 0x30680064,
		0x1D90, 0x30690063,
		0x1D90, 0x306A0062,
		0x1D90, 0x306B0061,
		0x1D90, 0x306C0045,
		0x1D90, 0x306D0044,
		0x1D90, 0x306E0043,
		0x1D90, 0x306F0042,
		0x1D90, 0x30700024,
		0x1D90, 0x30710023,
		0x1D90, 0x30720022,
		0x1D90, 0x30730021,
		0x1D90, 0x30740005,
		0x1D90, 0x30750004,
		0x1D90, 0x30760003,
		0x1D90, 0x30770002,
		0x1D90, 0x30780001,
		0x1D90, 0x30790000,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000C4,
		0x1D90, 0x306100C3,
		0x1D90, 0x306200C2,
		0x1D90, 0x306300C1,
		0x1D90, 0x30640086,
		0x1D90, 0x30650085,
		0x1D90, 0x30660084,
		0x1D90, 0x30670083,
		0x1D90, 0x30680082,
		0x1D90, 0x30690064,
		0x1D90, 0x306A0063,
		0x1D90, 0x306B0062,
		0x1D90, 0x306C0061,
		0x1D90, 0x306D0045,
		0x1D90, 0x306E0044,
		0x1D90, 0x306F0043,
		0x1D90, 0x30700042,
		0x1D90, 0x30710025,
		0x1D90, 0x30720024,
		0x1D90, 0x30730023,
		0x1D90, 0x30740022,
		0x1D90, 0x30750005,
		0x1D90, 0x30760004,
		0x1D90, 0x30770003,
		0x1D90, 0x30780002,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300CA,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600C7,
		0x1D90, 0x305700A9,
		0x1D90, 0x305800A8,
		0x1D90, 0x305900A7,
		0x1D90, 0x305A00A6,
		0x1D90, 0x305B00A5,
		0x1D90, 0x305C00A4,
		0x1D90, 0x305D00A3,
		0x1D90, 0x305E00A2,
		0x1D90, 0x305F00A1,
		0x1D90, 0x30600065,
		0x1D90, 0x30610064,
		0x1D90, 0x30620063,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680026,
		0x1D90, 0x30690025,
		0x1D90, 0x306A0024,
		0x1D90, 0x306B0023,
		0x1D90, 0x306C000A,
		0x1D90, 0x306D0009,
		0x1D90, 0x306E0008,
		0x1D90, 0x306F0007,
		0x1D90, 0x30700006,
		0x1D90, 0x30710005,
		0x1D90, 0x30720004,
		0x1D90, 0x30730003,
		0x1D90, 0x30740002,
		0x1D90, 0x30750001,
		0x1D90, 0x30760001,
		0x1D90, 0x30770001,
		0x1D90, 0x30780001,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0001,
		0x1D90, 0x307B0001,
		0x1D90, 0x307C0001,
		0x1D90, 0x307D0001,
		0x1D90, 0x307E0001,
		0x1D90, 0x307F0001,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DB,
		0x1D90, 0x304100DA,
		0x1D90, 0x304200D9,
		0x1D90, 0x304300D8,
		0x1D90, 0x304400D7,
		0x1D90, 0x304500D6,
		0x1D90, 0x304600D5,
		0x1D90, 0x304700D4,
		0x1D90, 0x304800D3,
		0x1D90, 0x304900D2,
		0x1D90, 0x304A00D1,
		0x1D90, 0x304B00D0,
		0x1D90, 0x304C00CF,
		0x1D90, 0x304D00CE,
		0x1D90, 0x304E00CD,
		0x1D90, 0x304F00CC,
		0x1D90, 0x305000CB,
		0x1D90, 0x305100C9,
		0x1D90, 0x305200C9,
		0x1D90, 0x305300C8,
		0x1D90, 0x305400C7,
		0x1D90, 0x305500C6,
		0x1D90, 0x305600C5,
		0x1D90, 0x305700C4,
		0x1D90, 0x30580069,
		0x1D90, 0x30590068,
		0x1D90, 0x305A0067,
		0x1D90, 0x305B0066,
		0x1D90, 0x305C0065,
		0x1D90, 0x305D0064,
		0x1D90, 0x305E0063,
		0x1D90, 0x305F0062,
		0x1D90, 0x30600061,
		0x1D90, 0x30610048,
		0x1D90, 0x30620047,
		0x1D90, 0x30630046,
		0x1D90, 0x30640045,
		0x1D90, 0x30650027,
		0x1D90, 0x30660026,
		0x1D90, 0x30670025,
		0x1D90, 0x30680024,
		0x1D90, 0x30690023,
		0x1D90, 0x306A0022,
		0x1D90, 0x306B0021,
		0x1D90, 0x306C0049,
		0x1D90, 0x306D0248,
		0x1D90, 0x306E0247,
		0x1D90, 0x306F0246,
		0x1D90, 0x30700245,
		0x1D90, 0x30710227,
		0x1D90, 0x30720226,
		0x1D90, 0x30730225,
		0x1D90, 0x30740224,
		0x1D90, 0x30750223,
		0x1D90, 0x30760222,
		0x1D90, 0x30770221,
		0x1D90, 0x30780220,
		0x1D90, 0x30790208,
		0x1D90, 0x307A0207,
		0x1D90, 0x307B0206,
		0x1D90, 0x307C0205,
		0x1D90, 0x307D0204,
		0x1D90, 0x307E0203,
		0x1D90, 0x307F0202,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300CA,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600AB,
		0x1D90, 0x305700AA,
		0x1D90, 0x305800A9,
		0x1D90, 0x305900A8,
		0x1D90, 0x305A00A7,
		0x1D90, 0x305B00A6,
		0x1D90, 0x305C00A5,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F0065,
		0x1D90, 0x30600064,
		0x1D90, 0x30610063,
		0x1D90, 0x30620062,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680044,
		0x1D90, 0x30690026,
		0x1D90, 0x306A0025,
		0x1D90, 0x306B0024,
		0x1D90, 0x306C0023,
		0x1D90, 0x306D0022,
		0x1D90, 0x306E0021,
		0x1D90, 0x306F0247,
		0x1D90, 0x30700246,
		0x1D90, 0x30710245,
		0x1D90, 0x30720244,
		0x1D90, 0x30730226,
		0x1D90, 0x30740225,
		0x1D90, 0x30750224,
		0x1D90, 0x30760223,
		0x1D90, 0x30770222,
		0x1D90, 0x30780221,
		0x1D90, 0x30790207,
		0x1D90, 0x307A0206,
		0x1D90, 0x307B0205,
		0x1D90, 0x307C0204,
		0x1D90, 0x307D0203,
		0x1D90, 0x307E0202,
		0x1D90, 0x307F0201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000C4,
		0x1D90, 0x306100C3,
		0x1D90, 0x306200C2,
		0x1D90, 0x306300C1,
		0x1D90, 0x30640086,
		0x1D90, 0x30650085,
		0x1D90, 0x30660084,
		0x1D90, 0x30670083,
		0x1D90, 0x30680082,
		0x1D90, 0x30690064,
		0x1D90, 0x306A0063,
		0x1D90, 0x306B0062,
		0x1D90, 0x306C0061,
		0x1D90, 0x306D0045,
		0x1D90, 0x306E0044,
		0x1D90, 0x306F0043,
		0x1D90, 0x30700042,
		0x1D90, 0x30710025,
		0x1D90, 0x30720024,
		0x1D90, 0x30730023,
		0x1D90, 0x30740022,
		0x1D90, 0x30750005,
		0x1D90, 0x30760004,
		0x1D90, 0x30770003,
		0x1D90, 0x30780002,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FF,
		0x1D90, 0x304300FE,
		0x1D90, 0x304400FD,
		0x1D90, 0x304500FC,
		0x1D90, 0x304600FB,
		0x1D90, 0x304700FB,
		0x1D90, 0x304800F9,
		0x1D90, 0x304900F8,
		0x1D90, 0x304A00F7,
		0x1D90, 0x304B00F6,
		0x1D90, 0x304C00F5,
		0x1D90, 0x304D00F4,
		0x1D90, 0x304E00F3,
		0x1D90, 0x304F00F2,
		0x1D90, 0x305000F1,
		0x1D90, 0x305100F0,
		0x1D90, 0x305200EF,
		0x1D90, 0x305300EE,
		0x1D90, 0x305400ED,
		0x1D90, 0x305500EC,
		0x1D90, 0x305600EB,
		0x1D90, 0x305700EB,
		0x1D90, 0x305800E9,
		0x1D90, 0x305900E8,
		0x1D90, 0x305A00E7,
		0x1D90, 0x305B00E6,
		0x1D90, 0x305C00E5,
		0x1D90, 0x305D00E4,
		0x1D90, 0x305E00E3,
		0x1D90, 0x305F00E2,
		0x1D90, 0x306000C6,
		0x1D90, 0x306100C5,
		0x1D90, 0x306200C4,
		0x1D90, 0x306300C3,
		0x1D90, 0x306400C2,
		0x1D90, 0x306500A4,
		0x1D90, 0x306600A3,
		0x1D90, 0x30670084,
		0x1D90, 0x30680083,
		0x1D90, 0x30690082,
		0x1D90, 0x306A0064,
		0x1D90, 0x306B0063,
		0x1D90, 0x306C0062,
		0x1D90, 0x306D0061,
		0x1D90, 0x306E0046,
		0x1D90, 0x306F0045,
		0x1D90, 0x30700044,
		0x1D90, 0x30710026,
		0x1D90, 0x30720025,
		0x1D90, 0x30730024,
		0x1D90, 0x30740023,
		0x1D90, 0x30750006,
		0x1D90, 0x30760005,
		0x1D90, 0x30770004,
		0x1D90, 0x30780003,
		0x1D90, 0x30790002,
		0x1D90, 0x307A0001,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300C9,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600C7,
		0x1D90, 0x305700C6,
		0x1D90, 0x305800A9,
		0x1D90, 0x305900A8,
		0x1D90, 0x305A00A7,
		0x1D90, 0x305B00A6,
		0x1D90, 0x305C00A5,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F0065,
		0x1D90, 0x30600064,
		0x1D90, 0x30610063,
		0x1D90, 0x30620062,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680044,
		0x1D90, 0x30690026,
		0x1D90, 0x306A0025,
		0x1D90, 0x306B0024,
		0x1D90, 0x306C0023,
		0x1D90, 0x306D0022,
		0x1D90, 0x306E0021,
		0x1D90, 0x306F0247,
		0x1D90, 0x30700246,
		0x1D90, 0x30710245,
		0x1D90, 0x30720244,
		0x1D90, 0x30730226,
		0x1D90, 0x30740225,
		0x1D90, 0x30750224,
		0x1D90, 0x30760223,
		0x1D90, 0x30770222,
		0x1D90, 0x30780221,
		0x1D90, 0x30790207,
		0x1D90, 0x307A0206,
		0x1D90, 0x307B0205,
		0x1D90, 0x307C0204,
		0x1D90, 0x307D0203,
		0x1D90, 0x307E0202,
		0x1D90, 0x307F0201,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FF,
		0x1D90, 0x304300FE,
		0x1D90, 0x304400FD,
		0x1D90, 0x304500FC,
		0x1D90, 0x304600FB,
		0x1D90, 0x304700FB,
		0x1D90, 0x304800F9,
		0x1D90, 0x304900F8,
		0x1D90, 0x304A00F7,
		0x1D90, 0x304B00F6,
		0x1D90, 0x304C00F5,
		0x1D90, 0x304D00F4,
		0x1D90, 0x304E00F3,
		0x1D90, 0x304F00F2,
		0x1D90, 0x305000F1,
		0x1D90, 0x305100F0,
		0x1D90, 0x305200EF,
		0x1D90, 0x305300EE,
		0x1D90, 0x305400ED,
		0x1D90, 0x305500EC,
		0x1D90, 0x305600EB,
		0x1D90, 0x305700EB,
		0x1D90, 0x305800E9,
		0x1D90, 0x305900E8,
		0x1D90, 0x305A00E7,
		0x1D90, 0x305B00E6,
		0x1D90, 0x305C00E5,
		0x1D90, 0x305D00E4,
		0x1D90, 0x305E00E3,
		0x1D90, 0x305F00E2,
		0x1D90, 0x306000C6,
		0x1D90, 0x306100C5,
		0x1D90, 0x306200C4,
		0x1D90, 0x306300C3,
		0x1D90, 0x306400C2,
		0x1D90, 0x306500A4,
		0x1D90, 0x306600A3,
		0x1D90, 0x30670084,
		0x1D90, 0x30680083,
		0x1D90, 0x30690082,
		0x1D90, 0x306A0064,
		0x1D90, 0x306B0063,
		0x1D90, 0x306C0062,
		0x1D90, 0x306D0061,
		0x1D90, 0x306E0046,
		0x1D90, 0x306F0045,
		0x1D90, 0x30700044,
		0x1D90, 0x30710026,
		0x1D90, 0x30720025,
		0x1D90, 0x30730024,
		0x1D90, 0x30740023,
		0x1D90, 0x30750006,
		0x1D90, 0x30760005,
		0x1D90, 0x30770004,
		0x1D90, 0x30780003,
		0x1D90, 0x30790002,
		0x1D90, 0x307A0001,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300C9,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600C7,
		0x1D90, 0x305700A9,
		0x1D90, 0x305800A8,
		0x1D90, 0x305900A7,
		0x1D90, 0x305A00A6,
		0x1D90, 0x305B00A5,
		0x1D90, 0x305C00A4,
		0x1D90, 0x305D00A3,
		0x1D90, 0x305E00A2,
		0x1D90, 0x305F00A1,
		0x1D90, 0x30600065,
		0x1D90, 0x30610064,
		0x1D90, 0x30620063,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680026,
		0x1D90, 0x30690025,
		0x1D90, 0x306A0024,
		0x1D90, 0x306B0023,
		0x1D90, 0x306C000A,
		0x1D90, 0x306D0009,
		0x1D90, 0x306E0008,
		0x1D90, 0x306F0007,
		0x1D90, 0x30700006,
		0x1D90, 0x30710005,
		0x1D90, 0x30720004,
		0x1D90, 0x30730003,
		0x1D90, 0x30740002,
		0x1D90, 0x30750001,
		0x1D90, 0x30760001,
		0x1D90, 0x30770001,
		0x1D90, 0x30780001,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0001,
		0x1D90, 0x307B0001,
		0x1D90, 0x307C0001,
		0x1D90, 0x307D0001,
		0x1D90, 0x307E0001,
		0x1D90, 0x307F0001,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DB,
		0x1D90, 0x304100DA,
		0x1D90, 0x304200D9,
		0x1D90, 0x304300D8,
		0x1D90, 0x304400D7,
		0x1D90, 0x304500D6,
		0x1D90, 0x304600D5,
		0x1D90, 0x304700D4,
		0x1D90, 0x304800D3,
		0x1D90, 0x304900D2,
		0x1D90, 0x304A00D1,
		0x1D90, 0x304B00D0,
		0x1D90, 0x304C00CF,
		0x1D90, 0x304D00CE,
		0x1D90, 0x304E00CD,
		0x1D90, 0x304F00CC,
		0x1D90, 0x305000CB,
		0x1D90, 0x305100C9,
		0x1D90, 0x305200C9,
		0x1D90, 0x305300C8,
		0x1D90, 0x305400C7,
		0x1D90, 0x305500C6,
		0x1D90, 0x305600C5,
		0x1D90, 0x305700C4,
		0x1D90, 0x30580069,
		0x1D90, 0x30590068,
		0x1D90, 0x305A0067,
		0x1D90, 0x305B0066,
		0x1D90, 0x305C0065,
		0x1D90, 0x305D0064,
		0x1D90, 0x305E0063,
		0x1D90, 0x305F0062,
		0x1D90, 0x30600061,
		0x1D90, 0x30610048,
		0x1D90, 0x30620047,
		0x1D90, 0x30630046,
		0x1D90, 0x30640045,
		0x1D90, 0x30650027,
		0x1D90, 0x30660026,
		0x1D90, 0x30670025,
		0x1D90, 0x30680024,
		0x1D90, 0x30690023,
		0x1D90, 0x306A0022,
		0x1D90, 0x306B0021,
		0x1D90, 0x306C0049,
		0x1D90, 0x306D0248,
		0x1D90, 0x306E0247,
		0x1D90, 0x306F0246,
		0x1D90, 0x30700245,
		0x1D90, 0x30710227,
		0x1D90, 0x30720226,
		0x1D90, 0x30730225,
		0x1D90, 0x30740224,
		0x1D90, 0x30750223,
		0x1D90, 0x30760222,
		0x1D90, 0x30770221,
		0x1D90, 0x30780220,
		0x1D90, 0x30790208,
		0x1D90, 0x307A0207,
		0x1D90, 0x307B0206,
		0x1D90, 0x307C0205,
		0x1D90, 0x307D0204,
		0x1D90, 0x307E0203,
		0x1D90, 0x307F0202,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000DD,
		0x1D90, 0x304100DC,
		0x1D90, 0x304200DB,
		0x1D90, 0x304300DA,
		0x1D90, 0x304400D9,
		0x1D90, 0x304500D8,
		0x1D90, 0x304600D7,
		0x1D90, 0x304700D6,
		0x1D90, 0x304800D5,
		0x1D90, 0x304900D4,
		0x1D90, 0x304A00D3,
		0x1D90, 0x304B00D2,
		0x1D90, 0x304C00D1,
		0x1D90, 0x304D00D0,
		0x1D90, 0x304E00CF,
		0x1D90, 0x304F00CE,
		0x1D90, 0x305000CD,
		0x1D90, 0x305100CC,
		0x1D90, 0x305200CB,
		0x1D90, 0x305300C9,
		0x1D90, 0x305400C9,
		0x1D90, 0x305500C8,
		0x1D90, 0x305600C7,
		0x1D90, 0x305700C6,
		0x1D90, 0x305800A9,
		0x1D90, 0x305900A8,
		0x1D90, 0x305A00A7,
		0x1D90, 0x305B00A6,
		0x1D90, 0x305C00A5,
		0x1D90, 0x305D00A4,
		0x1D90, 0x305E00A3,
		0x1D90, 0x305F0065,
		0x1D90, 0x30600064,
		0x1D90, 0x30610063,
		0x1D90, 0x30620062,
		0x1D90, 0x30630049,
		0x1D90, 0x30640048,
		0x1D90, 0x30650047,
		0x1D90, 0x30660046,
		0x1D90, 0x30670045,
		0x1D90, 0x30680044,
		0x1D90, 0x30690026,
		0x1D90, 0x306A0025,
		0x1D90, 0x306B0024,
		0x1D90, 0x306C0023,
		0x1D90, 0x306D0022,
		0x1D90, 0x306E0021,
		0x1D90, 0x306F0247,
		0x1D90, 0x30700246,
		0x1D90, 0x30710245,
		0x1D90, 0x30720244,
		0x1D90, 0x30730226,
		0x1D90, 0x30740225,
		0x1D90, 0x30750224,
		0x1D90, 0x30760223,
		0x1D90, 0x30770222,
		0x1D90, 0x30780221,
		0x1D90, 0x30790207,
		0x1D90, 0x307A0206,
		0x1D90, 0x307B0205,
		0x1D90, 0x307C0204,
		0x1D90, 0x307D0203,
		0x1D90, 0x307E0202,
		0x1D90, 0x307F0201,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FF,
		0x1D90, 0x304300FE,
		0x1D90, 0x304400FD,
		0x1D90, 0x304500FC,
		0x1D90, 0x304600FB,
		0x1D90, 0x304700FB,
		0x1D90, 0x304800F9,
		0x1D90, 0x304900F8,
		0x1D90, 0x304A00F7,
		0x1D90, 0x304B00F6,
		0x1D90, 0x304C00F5,
		0x1D90, 0x304D00F4,
		0x1D90, 0x304E00F3,
		0x1D90, 0x304F00F2,
		0x1D90, 0x305000F1,
		0x1D90, 0x305100F0,
		0x1D90, 0x305200EF,
		0x1D90, 0x305300EE,
		0x1D90, 0x305400ED,
		0x1D90, 0x305500EC,
		0x1D90, 0x305600EB,
		0x1D90, 0x305700EB,
		0x1D90, 0x305800E9,
		0x1D90, 0x305900E8,
		0x1D90, 0x305A00E7,
		0x1D90, 0x305B00E6,
		0x1D90, 0x305C00E5,
		0x1D90, 0x305D00E4,
		0x1D90, 0x305E00E3,
		0x1D90, 0x305F00E2,
		0x1D90, 0x306000C5,
		0x1D90, 0x306100C4,
		0x1D90, 0x306200C3,
		0x1D90, 0x306300C2,
		0x1D90, 0x306400A4,
		0x1D90, 0x306500A3,
		0x1D90, 0x306600A2,
		0x1D90, 0x306700A1,
		0x1D90, 0x30680066,
		0x1D90, 0x30690065,
		0x1D90, 0x306A0064,
		0x1D90, 0x306B0063,
		0x1D90, 0x306C0062,
		0x1D90, 0x306D0047,
		0x1D90, 0x306E0046,
		0x1D90, 0x306F0045,
		0x1D90, 0x30700044,
		0x1D90, 0x30710025,
		0x1D90, 0x30720024,
		0x1D90, 0x30730023,
		0x1D90, 0x30740022,
		0x1D90, 0x30750006,
		0x1D90, 0x30760005,
		0x1D90, 0x30770004,
		0x1D90, 0x30780003,
		0x1D90, 0x30790002,
		0x1D90, 0x307A0001,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x304000FF,
		0x1D90, 0x304100FF,
		0x1D90, 0x304200FE,
		0x1D90, 0x304300FD,
		0x1D90, 0x304400FC,
		0x1D90, 0x304500FB,
		0x1D90, 0x304600FA,
		0x1D90, 0x304700F9,
		0x1D90, 0x304800F8,
		0x1D90, 0x304900F7,
		0x1D90, 0x304A00F6,
		0x1D90, 0x304B00F5,
		0x1D90, 0x304C00F4,
		0x1D90, 0x304D00F3,
		0x1D90, 0x304E00F2,
		0x1D90, 0x304F00F1,
		0x1D90, 0x305000F0,
		0x1D90, 0x305100EF,
		0x1D90, 0x305200EE,
		0x1D90, 0x305300ED,
		0x1D90, 0x305400EC,
		0x1D90, 0x305500EB,
		0x1D90, 0x305600EA,
		0x1D90, 0x305700E9,
		0x1D90, 0x305800E8,
		0x1D90, 0x305900E7,
		0x1D90, 0x305A00E6,
		0x1D90, 0x305B00E5,
		0x1D90, 0x305C00E4,
		0x1D90, 0x305D00E3,
		0x1D90, 0x305E00E2,
		0x1D90, 0x305F00E1,
		0x1D90, 0x306000C4,
		0x1D90, 0x306100C3,
		0x1D90, 0x306200C2,
		0x1D90, 0x306300C1,
		0x1D90, 0x30640086,
		0x1D90, 0x30650085,
		0x1D90, 0x30660084,
		0x1D90, 0x30670083,
		0x1D90, 0x30680082,
		0x1D90, 0x30690064,
		0x1D90, 0x306A0063,
		0x1D90, 0x306B0062,
		0x1D90, 0x306C0061,
		0x1D90, 0x306D0045,
		0x1D90, 0x306E0044,
		0x1D90, 0x306F0043,
		0x1D90, 0x30700042,
		0x1D90, 0x30710025,
		0x1D90, 0x30720024,
		0x1D90, 0x30730023,
		0x1D90, 0x30740022,
		0x1D90, 0x30750005,
		0x1D90, 0x30760004,
		0x1D90, 0x30770003,
		0x1D90, 0x30780002,
		0x1D90, 0x30790001,
		0x1D90, 0x307A0000,
		0x1D90, 0x307B0000,
		0x1D90, 0x307C0000,
		0x1D90, 0x307D0000,
		0x1D90, 0x307E0000,
		0x1D90, 0x307F0000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DC,
		0x1D90, 0x308100DB,
		0x1D90, 0x308200DA,
		0x1D90, 0x308300D9,
		0x1D90, 0x308400D8,
		0x1D90, 0x308500D7,
		0x1D90, 0x308600D6,
		0x1D90, 0x308700D5,
		0x1D90, 0x308800D4,
		0x1D90, 0x308900D3,
		0x1D90, 0x308A00D2,
		0x1D90, 0x308B00D1,
		0x1D90, 0x308C00D0,
		0x1D90, 0x308D00CF,
		0x1D90, 0x308E00CE,
		0x1D90, 0x308F00CD,
		0x1D90, 0x309000CC,
		0x1D90, 0x309100CB,
		0x1D90, 0x309200CA,
		0x1D90, 0x309300C9,
		0x1D90, 0x309400C8,
		0x1D90, 0x309500C7,
		0x1D90, 0x309600AA,
		0x1D90, 0x309700A9,
		0x1D90, 0x309800A8,
		0x1D90, 0x309900A7,
		0x1D90, 0x309A00A6,
		0x1D90, 0x309B00A5,
		0x1D90, 0x309C00A4,
		0x1D90, 0x309D0067,
		0x1D90, 0x309E0066,
		0x1D90, 0x309F0065,
		0x1D90, 0x30A00064,
		0x1D90, 0x30A10063,
		0x1D90, 0x30A20062,
		0x1D90, 0x30A30061,
		0x1D90, 0x30A40047,
		0x1D90, 0x30A50046,
		0x1D90, 0x30A60045,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80026,
		0x1D90, 0x30A90025,
		0x1D90, 0x30AA0024,
		0x1D90, 0x30AB0023,
		0x1D90, 0x30AC0022,
		0x1D90, 0x30AD0021,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10244,
		0x1D90, 0x30B20226,
		0x1D90, 0x30B30225,
		0x1D90, 0x30B40224,
		0x1D90, 0x30B50223,
		0x1D90, 0x30B60222,
		0x1D90, 0x30B70221,
		0x1D90, 0x30B80209,
		0x1D90, 0x30B90208,
		0x1D90, 0x30BA0207,
		0x1D90, 0x30BB0206,
		0x1D90, 0x30BC0205,
		0x1D90, 0x30BD0204,
		0x1D90, 0x30BE0203,
		0x1D90, 0x30BF0202,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FE,
		0x1D90, 0x308100FD,
		0x1D90, 0x308200FC,
		0x1D90, 0x308300FB,
		0x1D90, 0x308400FA,
		0x1D90, 0x308500F9,
		0x1D90, 0x308600F8,
		0x1D90, 0x308700F7,
		0x1D90, 0x308800F6,
		0x1D90, 0x308900F5,
		0x1D90, 0x308A00F4,
		0x1D90, 0x308B00F3,
		0x1D90, 0x308C00F2,
		0x1D90, 0x308D00F1,
		0x1D90, 0x308E00F0,
		0x1D90, 0x308F00EF,
		0x1D90, 0x309000EE,
		0x1D90, 0x309100ED,
		0x1D90, 0x309200EC,
		0x1D90, 0x309300EB,
		0x1D90, 0x309400EA,
		0x1D90, 0x309500E9,
		0x1D90, 0x309600E8,
		0x1D90, 0x309700E7,
		0x1D90, 0x309800E6,
		0x1D90, 0x309900E5,
		0x1D90, 0x309A00E4,
		0x1D90, 0x309B00E3,
		0x1D90, 0x309C00E2,
		0x1D90, 0x309D00E1,
		0x1D90, 0x309E00C4,
		0x1D90, 0x309F00C3,
		0x1D90, 0x30A000C2,
		0x1D90, 0x30A100A5,
		0x1D90, 0x30A200A4,
		0x1D90, 0x30A300A3,
		0x1D90, 0x30A400A2,
		0x1D90, 0x30A500A1,
		0x1D90, 0x30A60082,
		0x1D90, 0x30A70081,
		0x1D90, 0x30A80064,
		0x1D90, 0x30A90063,
		0x1D90, 0x30AA0062,
		0x1D90, 0x30AB0061,
		0x1D90, 0x30AC0044,
		0x1D90, 0x30AD0043,
		0x1D90, 0x30AE0042,
		0x1D90, 0x30AF0024,
		0x1D90, 0x30B00023,
		0x1D90, 0x30B10022,
		0x1D90, 0x30B20021,
		0x1D90, 0x30B30005,
		0x1D90, 0x30B40004,
		0x1D90, 0x30B50003,
		0x1D90, 0x30B60002,
		0x1D90, 0x30B70001,
		0x1D90, 0x30B80000,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FE,
		0x1D90, 0x308200FD,
		0x1D90, 0x308300FC,
		0x1D90, 0x308400FB,
		0x1D90, 0x308500FA,
		0x1D90, 0x308600F9,
		0x1D90, 0x308700F8,
		0x1D90, 0x308800F7,
		0x1D90, 0x308900F6,
		0x1D90, 0x308A00F5,
		0x1D90, 0x308B00F4,
		0x1D90, 0x308C00F3,
		0x1D90, 0x308D00F2,
		0x1D90, 0x308E00F1,
		0x1D90, 0x308F00F0,
		0x1D90, 0x309000EF,
		0x1D90, 0x309100EE,
		0x1D90, 0x309200ED,
		0x1D90, 0x309300EC,
		0x1D90, 0x309400EB,
		0x1D90, 0x309500EA,
		0x1D90, 0x309600E9,
		0x1D90, 0x309700E8,
		0x1D90, 0x309800E7,
		0x1D90, 0x309900E6,
		0x1D90, 0x309A00E5,
		0x1D90, 0x309B00E4,
		0x1D90, 0x309C00E3,
		0x1D90, 0x309D00E2,
		0x1D90, 0x309E00E1,
		0x1D90, 0x309F00C4,
		0x1D90, 0x30A000C3,
		0x1D90, 0x30A100C2,
		0x1D90, 0x30A200C1,
		0x1D90, 0x30A300A3,
		0x1D90, 0x30A400A2,
		0x1D90, 0x30A500A1,
		0x1D90, 0x30A60083,
		0x1D90, 0x30A70082,
		0x1D90, 0x30A80081,
		0x1D90, 0x30A90063,
		0x1D90, 0x30AA0062,
		0x1D90, 0x30AB0061,
		0x1D90, 0x30AC0045,
		0x1D90, 0x30AD0044,
		0x1D90, 0x30AE0043,
		0x1D90, 0x30AF0042,
		0x1D90, 0x30B00025,
		0x1D90, 0x30B10024,
		0x1D90, 0x30B20023,
		0x1D90, 0x30B30022,
		0x1D90, 0x30B40021,
		0x1D90, 0x30B50004,
		0x1D90, 0x30B60003,
		0x1D90, 0x30B70002,
		0x1D90, 0x30B80001,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DD,
		0x1D90, 0x308100DC,
		0x1D90, 0x308200DB,
		0x1D90, 0x308300DA,
		0x1D90, 0x308400D9,
		0x1D90, 0x308500D8,
		0x1D90, 0x308600D7,
		0x1D90, 0x308700D6,
		0x1D90, 0x308800D5,
		0x1D90, 0x308900D4,
		0x1D90, 0x308A00D3,
		0x1D90, 0x308B00D2,
		0x1D90, 0x308C00D1,
		0x1D90, 0x308D00D0,
		0x1D90, 0x308E00CF,
		0x1D90, 0x308F00CE,
		0x1D90, 0x309000CD,
		0x1D90, 0x309100CC,
		0x1D90, 0x309200CB,
		0x1D90, 0x309300CA,
		0x1D90, 0x309400C9,
		0x1D90, 0x309500C8,
		0x1D90, 0x309600C7,
		0x1D90, 0x309700C6,
		0x1D90, 0x309800C5,
		0x1D90, 0x309900C4,
		0x1D90, 0x309A00C3,
		0x1D90, 0x309B0087,
		0x1D90, 0x309C0086,
		0x1D90, 0x309D0085,
		0x1D90, 0x309E0084,
		0x1D90, 0x309F0083,
		0x1D90, 0x30A00066,
		0x1D90, 0x30A10065,
		0x1D90, 0x30A20064,
		0x1D90, 0x30A30047,
		0x1D90, 0x30A40046,
		0x1D90, 0x30A50045,
		0x1D90, 0x30A60044,
		0x1D90, 0x30A70026,
		0x1D90, 0x30A80025,
		0x1D90, 0x30A90024,
		0x1D90, 0x30AA0023,
		0x1D90, 0x30AB0022,
		0x1D90, 0x30AC000A,
		0x1D90, 0x30AD0009,
		0x1D90, 0x30AE0008,
		0x1D90, 0x30AF0007,
		0x1D90, 0x30B00006,
		0x1D90, 0x30B10005,
		0x1D90, 0x30B20004,
		0x1D90, 0x30B30003,
		0x1D90, 0x30B40002,
		0x1D90, 0x30B50001,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70001,
		0x1D90, 0x30B80001,
		0x1D90, 0x30B90001,
		0x1D90, 0x30BA0001,
		0x1D90, 0x30BB0001,
		0x1D90, 0x30BC0001,
		0x1D90, 0x30BD0001,
		0x1D90, 0x30BE0001,
		0x1D90, 0x30BF0001,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DA,
		0x1D90, 0x308100D9,
		0x1D90, 0x308200D8,
		0x1D90, 0x308300D7,
		0x1D90, 0x308400D6,
		0x1D90, 0x308500D5,
		0x1D90, 0x308600D4,
		0x1D90, 0x308700D3,
		0x1D90, 0x308800D2,
		0x1D90, 0x308900D1,
		0x1D90, 0x308A00D0,
		0x1D90, 0x308B00CF,
		0x1D90, 0x308C00CE,
		0x1D90, 0x308D00CD,
		0x1D90, 0x308E00CC,
		0x1D90, 0x308F00CB,
		0x1D90, 0x309000C9,
		0x1D90, 0x309100C9,
		0x1D90, 0x309200C8,
		0x1D90, 0x309300C7,
		0x1D90, 0x309400C6,
		0x1D90, 0x309500C5,
		0x1D90, 0x309600C4,
		0x1D90, 0x309700C3,
		0x1D90, 0x309800A7,
		0x1D90, 0x309900A6,
		0x1D90, 0x309A00A5,
		0x1D90, 0x309B00A4,
		0x1D90, 0x309C00A3,
		0x1D90, 0x309D0066,
		0x1D90, 0x309E0065,
		0x1D90, 0x309F0064,
		0x1D90, 0x30A00063,
		0x1D90, 0x30A10062,
		0x1D90, 0x30A20048,
		0x1D90, 0x30A30047,
		0x1D90, 0x30A40046,
		0x1D90, 0x30A50045,
		0x1D90, 0x30A60027,
		0x1D90, 0x30A70026,
		0x1D90, 0x30A80025,
		0x1D90, 0x30A90024,
		0x1D90, 0x30AA0023,
		0x1D90, 0x30AB0022,
		0x1D90, 0x30AC0021,
		0x1D90, 0x30AD0248,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10228,
		0x1D90, 0x30B20227,
		0x1D90, 0x30B30226,
		0x1D90, 0x30B40225,
		0x1D90, 0x30B50224,
		0x1D90, 0x30B60223,
		0x1D90, 0x30B70222,
		0x1D90, 0x30B80221,
		0x1D90, 0x30B90209,
		0x1D90, 0x30BA0208,
		0x1D90, 0x30BB0207,
		0x1D90, 0x30BC0206,
		0x1D90, 0x30BD0205,
		0x1D90, 0x30BE0204,
		0x1D90, 0x30BF0203,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DC,
		0x1D90, 0x308100DB,
		0x1D90, 0x308200DA,
		0x1D90, 0x308300D9,
		0x1D90, 0x308400D8,
		0x1D90, 0x308500D7,
		0x1D90, 0x308600D6,
		0x1D90, 0x308700D5,
		0x1D90, 0x308800D4,
		0x1D90, 0x308900D3,
		0x1D90, 0x308A00D2,
		0x1D90, 0x308B00D1,
		0x1D90, 0x308C00D0,
		0x1D90, 0x308D00CF,
		0x1D90, 0x308E00CE,
		0x1D90, 0x308F00CD,
		0x1D90, 0x309000CC,
		0x1D90, 0x309100CB,
		0x1D90, 0x309200CA,
		0x1D90, 0x309300C9,
		0x1D90, 0x309400C8,
		0x1D90, 0x309500C7,
		0x1D90, 0x309600AA,
		0x1D90, 0x309700A9,
		0x1D90, 0x309800A8,
		0x1D90, 0x309900A7,
		0x1D90, 0x309A00A6,
		0x1D90, 0x309B00A5,
		0x1D90, 0x309C00A4,
		0x1D90, 0x309D0067,
		0x1D90, 0x309E0066,
		0x1D90, 0x309F0065,
		0x1D90, 0x30A00064,
		0x1D90, 0x30A10063,
		0x1D90, 0x30A20062,
		0x1D90, 0x30A30061,
		0x1D90, 0x30A40047,
		0x1D90, 0x30A50046,
		0x1D90, 0x30A60045,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80026,
		0x1D90, 0x30A90025,
		0x1D90, 0x30AA0024,
		0x1D90, 0x30AB0023,
		0x1D90, 0x30AC0022,
		0x1D90, 0x30AD0021,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10244,
		0x1D90, 0x30B20226,
		0x1D90, 0x30B30225,
		0x1D90, 0x30B40224,
		0x1D90, 0x30B50223,
		0x1D90, 0x30B60222,
		0x1D90, 0x30B70221,
		0x1D90, 0x30B80209,
		0x1D90, 0x30B90208,
		0x1D90, 0x30BA0207,
		0x1D90, 0x30BB0206,
		0x1D90, 0x30BC0205,
		0x1D90, 0x30BD0204,
		0x1D90, 0x30BE0203,
		0x1D90, 0x30BF0202,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FE,
		0x1D90, 0x308200FD,
		0x1D90, 0x308300FC,
		0x1D90, 0x308400FB,
		0x1D90, 0x308500FA,
		0x1D90, 0x308600F9,
		0x1D90, 0x308700F8,
		0x1D90, 0x308800F7,
		0x1D90, 0x308900F6,
		0x1D90, 0x308A00F5,
		0x1D90, 0x308B00F4,
		0x1D90, 0x308C00F3,
		0x1D90, 0x308D00F2,
		0x1D90, 0x308E00F1,
		0x1D90, 0x308F00F0,
		0x1D90, 0x309000EF,
		0x1D90, 0x309100EE,
		0x1D90, 0x309200ED,
		0x1D90, 0x309300EC,
		0x1D90, 0x309400EB,
		0x1D90, 0x309500EA,
		0x1D90, 0x309600E9,
		0x1D90, 0x309700E8,
		0x1D90, 0x309800E7,
		0x1D90, 0x309900E6,
		0x1D90, 0x309A00E5,
		0x1D90, 0x309B00E4,
		0x1D90, 0x309C00E3,
		0x1D90, 0x309D00E2,
		0x1D90, 0x309E00E1,
		0x1D90, 0x309F00C4,
		0x1D90, 0x30A000C3,
		0x1D90, 0x30A100C2,
		0x1D90, 0x30A200C1,
		0x1D90, 0x30A300A3,
		0x1D90, 0x30A400A2,
		0x1D90, 0x30A500A1,
		0x1D90, 0x30A60083,
		0x1D90, 0x30A70082,
		0x1D90, 0x30A80081,
		0x1D90, 0x30A90063,
		0x1D90, 0x30AA0062,
		0x1D90, 0x30AB0061,
		0x1D90, 0x30AC0045,
		0x1D90, 0x30AD0044,
		0x1D90, 0x30AE0043,
		0x1D90, 0x30AF0042,
		0x1D90, 0x30B00025,
		0x1D90, 0x30B10024,
		0x1D90, 0x30B20023,
		0x1D90, 0x30B30022,
		0x1D90, 0x30B40021,
		0x1D90, 0x30B50004,
		0x1D90, 0x30B60003,
		0x1D90, 0x30B70002,
		0x1D90, 0x30B80001,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FE,
		0x1D90, 0x308400FD,
		0x1D90, 0x308500FC,
		0x1D90, 0x308600FB,
		0x1D90, 0x308700FB,
		0x1D90, 0x308800F9,
		0x1D90, 0x308900F8,
		0x1D90, 0x308A00F7,
		0x1D90, 0x308B00F6,
		0x1D90, 0x308C00F5,
		0x1D90, 0x308D00F4,
		0x1D90, 0x308E00F3,
		0x1D90, 0x308F00F2,
		0x1D90, 0x309000F1,
		0x1D90, 0x309100F0,
		0x1D90, 0x309200EF,
		0x1D90, 0x309300EE,
		0x1D90, 0x309400ED,
		0x1D90, 0x309500EC,
		0x1D90, 0x309600EB,
		0x1D90, 0x309700EB,
		0x1D90, 0x309800E9,
		0x1D90, 0x309900E8,
		0x1D90, 0x309A00E7,
		0x1D90, 0x309B00E6,
		0x1D90, 0x309C00E5,
		0x1D90, 0x309D00E4,
		0x1D90, 0x309E00E3,
		0x1D90, 0x309F00E2,
		0x1D90, 0x30A000C5,
		0x1D90, 0x30A100C4,
		0x1D90, 0x30A200C3,
		0x1D90, 0x30A300C2,
		0x1D90, 0x30A400C1,
		0x1D90, 0x30A500A4,
		0x1D90, 0x30A600A3,
		0x1D90, 0x30A70084,
		0x1D90, 0x30A80083,
		0x1D90, 0x30A90082,
		0x1D90, 0x30AA0065,
		0x1D90, 0x30AB0064,
		0x1D90, 0x30AC0063,
		0x1D90, 0x30AD0062,
		0x1D90, 0x30AE0046,
		0x1D90, 0x30AF0045,
		0x1D90, 0x30B00044,
		0x1D90, 0x30B10025,
		0x1D90, 0x30B20024,
		0x1D90, 0x30B30023,
		0x1D90, 0x30B40007,
		0x1D90, 0x30B50006,
		0x1D90, 0x30B60005,
		0x1D90, 0x30B70004,
		0x1D90, 0x30B80003,
		0x1D90, 0x30B90002,
		0x1D90, 0x30BA0001,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DC,
		0x1D90, 0x308100DB,
		0x1D90, 0x308200DA,
		0x1D90, 0x308300D9,
		0x1D90, 0x308400D8,
		0x1D90, 0x308500D7,
		0x1D90, 0x308600D6,
		0x1D90, 0x308700D5,
		0x1D90, 0x308800D4,
		0x1D90, 0x308900D3,
		0x1D90, 0x308A00D2,
		0x1D90, 0x308B00D1,
		0x1D90, 0x308C00D0,
		0x1D90, 0x308D00CF,
		0x1D90, 0x308E00CE,
		0x1D90, 0x308F00CD,
		0x1D90, 0x309000CC,
		0x1D90, 0x309100CB,
		0x1D90, 0x309200C9,
		0x1D90, 0x309300C9,
		0x1D90, 0x309400C8,
		0x1D90, 0x309500C7,
		0x1D90, 0x309600C6,
		0x1D90, 0x309700A9,
		0x1D90, 0x309800A8,
		0x1D90, 0x309900A7,
		0x1D90, 0x309A00A6,
		0x1D90, 0x309B00A5,
		0x1D90, 0x309C00A4,
		0x1D90, 0x309D0067,
		0x1D90, 0x309E0066,
		0x1D90, 0x309F0065,
		0x1D90, 0x30A00064,
		0x1D90, 0x30A10063,
		0x1D90, 0x30A20062,
		0x1D90, 0x30A30061,
		0x1D90, 0x30A40047,
		0x1D90, 0x30A50046,
		0x1D90, 0x30A60045,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80026,
		0x1D90, 0x30A90025,
		0x1D90, 0x30AA0024,
		0x1D90, 0x30AB0023,
		0x1D90, 0x30AC0022,
		0x1D90, 0x30AD0021,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10244,
		0x1D90, 0x30B20226,
		0x1D90, 0x30B30225,
		0x1D90, 0x30B40224,
		0x1D90, 0x30B50223,
		0x1D90, 0x30B60222,
		0x1D90, 0x30B70221,
		0x1D90, 0x30B80209,
		0x1D90, 0x30B90208,
		0x1D90, 0x30BA0207,
		0x1D90, 0x30BB0206,
		0x1D90, 0x30BC0205,
		0x1D90, 0x30BD0204,
		0x1D90, 0x30BE0203,
		0x1D90, 0x30BF0202,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FE,
		0x1D90, 0x308400FD,
		0x1D90, 0x308500FC,
		0x1D90, 0x308600FB,
		0x1D90, 0x308700FB,
		0x1D90, 0x308800F9,
		0x1D90, 0x308900F8,
		0x1D90, 0x308A00F7,
		0x1D90, 0x308B00F6,
		0x1D90, 0x308C00F5,
		0x1D90, 0x308D00F4,
		0x1D90, 0x308E00F3,
		0x1D90, 0x308F00F2,
		0x1D90, 0x309000F1,
		0x1D90, 0x309100F0,
		0x1D90, 0x309200EF,
		0x1D90, 0x309300EE,
		0x1D90, 0x309400ED,
		0x1D90, 0x309500EC,
		0x1D90, 0x309600EB,
		0x1D90, 0x309700EB,
		0x1D90, 0x309800E9,
		0x1D90, 0x309900E8,
		0x1D90, 0x309A00E7,
		0x1D90, 0x309B00E6,
		0x1D90, 0x309C00E5,
		0x1D90, 0x309D00E4,
		0x1D90, 0x309E00E3,
		0x1D90, 0x309F00E2,
		0x1D90, 0x30A000C5,
		0x1D90, 0x30A100C4,
		0x1D90, 0x30A200C3,
		0x1D90, 0x30A300C2,
		0x1D90, 0x30A400C1,
		0x1D90, 0x30A500A4,
		0x1D90, 0x30A600A3,
		0x1D90, 0x30A70084,
		0x1D90, 0x30A80083,
		0x1D90, 0x30A90082,
		0x1D90, 0x30AA0065,
		0x1D90, 0x30AB0064,
		0x1D90, 0x30AC0063,
		0x1D90, 0x30AD0062,
		0x1D90, 0x30AE0046,
		0x1D90, 0x30AF0045,
		0x1D90, 0x30B00044,
		0x1D90, 0x30B10025,
		0x1D90, 0x30B20024,
		0x1D90, 0x30B30023,
		0x1D90, 0x30B40007,
		0x1D90, 0x30B50006,
		0x1D90, 0x30B60005,
		0x1D90, 0x30B70004,
		0x1D90, 0x30B80003,
		0x1D90, 0x30B90002,
		0x1D90, 0x30BA0001,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DD,
		0x1D90, 0x308100DC,
		0x1D90, 0x308200DB,
		0x1D90, 0x308300DA,
		0x1D90, 0x308400D9,
		0x1D90, 0x308500D8,
		0x1D90, 0x308600D7,
		0x1D90, 0x308700D6,
		0x1D90, 0x308800D5,
		0x1D90, 0x308900D4,
		0x1D90, 0x308A00D3,
		0x1D90, 0x308B00D2,
		0x1D90, 0x308C00D1,
		0x1D90, 0x308D00D0,
		0x1D90, 0x308E00CF,
		0x1D90, 0x308F00CE,
		0x1D90, 0x309000CD,
		0x1D90, 0x309100CC,
		0x1D90, 0x309200CB,
		0x1D90, 0x309300C9,
		0x1D90, 0x309400C9,
		0x1D90, 0x309500C8,
		0x1D90, 0x309600C7,
		0x1D90, 0x309700C6,
		0x1D90, 0x309800C5,
		0x1D90, 0x309900C4,
		0x1D90, 0x309A00C3,
		0x1D90, 0x309B0087,
		0x1D90, 0x309C0086,
		0x1D90, 0x309D0085,
		0x1D90, 0x309E0084,
		0x1D90, 0x309F0083,
		0x1D90, 0x30A00066,
		0x1D90, 0x30A10065,
		0x1D90, 0x30A20064,
		0x1D90, 0x30A30047,
		0x1D90, 0x30A40046,
		0x1D90, 0x30A50045,
		0x1D90, 0x30A60044,
		0x1D90, 0x30A70026,
		0x1D90, 0x30A80025,
		0x1D90, 0x30A90024,
		0x1D90, 0x30AA0023,
		0x1D90, 0x30AB0022,
		0x1D90, 0x30AC000A,
		0x1D90, 0x30AD0009,
		0x1D90, 0x30AE0008,
		0x1D90, 0x30AF0007,
		0x1D90, 0x30B00006,
		0x1D90, 0x30B10005,
		0x1D90, 0x30B20004,
		0x1D90, 0x30B30003,
		0x1D90, 0x30B40002,
		0x1D90, 0x30B50001,
		0x1D90, 0x30B60001,
		0x1D90, 0x30B70001,
		0x1D90, 0x30B80001,
		0x1D90, 0x30B90001,
		0x1D90, 0x30BA0001,
		0x1D90, 0x30BB0001,
		0x1D90, 0x30BC0001,
		0x1D90, 0x30BD0001,
		0x1D90, 0x30BE0001,
		0x1D90, 0x30BF0001,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DA,
		0x1D90, 0x308100D9,
		0x1D90, 0x308200D8,
		0x1D90, 0x308300D7,
		0x1D90, 0x308400D6,
		0x1D90, 0x308500D5,
		0x1D90, 0x308600D4,
		0x1D90, 0x308700D3,
		0x1D90, 0x308800D2,
		0x1D90, 0x308900D1,
		0x1D90, 0x308A00D0,
		0x1D90, 0x308B00CF,
		0x1D90, 0x308C00CE,
		0x1D90, 0x308D00CD,
		0x1D90, 0x308E00CC,
		0x1D90, 0x308F00CB,
		0x1D90, 0x309000C9,
		0x1D90, 0x309100C9,
		0x1D90, 0x309200C8,
		0x1D90, 0x309300C7,
		0x1D90, 0x309400C6,
		0x1D90, 0x309500C5,
		0x1D90, 0x309600C4,
		0x1D90, 0x309700C3,
		0x1D90, 0x309800A7,
		0x1D90, 0x309900A6,
		0x1D90, 0x309A00A5,
		0x1D90, 0x309B00A4,
		0x1D90, 0x309C00A3,
		0x1D90, 0x309D0066,
		0x1D90, 0x309E0065,
		0x1D90, 0x309F0064,
		0x1D90, 0x30A00063,
		0x1D90, 0x30A10062,
		0x1D90, 0x30A20048,
		0x1D90, 0x30A30047,
		0x1D90, 0x30A40046,
		0x1D90, 0x30A50045,
		0x1D90, 0x30A60027,
		0x1D90, 0x30A70026,
		0x1D90, 0x30A80025,
		0x1D90, 0x30A90024,
		0x1D90, 0x30AA0023,
		0x1D90, 0x30AB0022,
		0x1D90, 0x30AC0021,
		0x1D90, 0x30AD0248,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10228,
		0x1D90, 0x30B20227,
		0x1D90, 0x30B30226,
		0x1D90, 0x30B40225,
		0x1D90, 0x30B50224,
		0x1D90, 0x30B60223,
		0x1D90, 0x30B70222,
		0x1D90, 0x30B80221,
		0x1D90, 0x30B90209,
		0x1D90, 0x30BA0208,
		0x1D90, 0x30BB0207,
		0x1D90, 0x30BC0206,
		0x1D90, 0x30BD0205,
		0x1D90, 0x30BE0204,
		0x1D90, 0x30BF0203,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000DC,
		0x1D90, 0x308100DB,
		0x1D90, 0x308200DA,
		0x1D90, 0x308300D9,
		0x1D90, 0x308400D8,
		0x1D90, 0x308500D7,
		0x1D90, 0x308600D6,
		0x1D90, 0x308700D5,
		0x1D90, 0x308800D4,
		0x1D90, 0x308900D3,
		0x1D90, 0x308A00D2,
		0x1D90, 0x308B00D1,
		0x1D90, 0x308C00D0,
		0x1D90, 0x308D00CF,
		0x1D90, 0x308E00CE,
		0x1D90, 0x308F00CD,
		0x1D90, 0x309000CC,
		0x1D90, 0x309100CB,
		0x1D90, 0x309200C9,
		0x1D90, 0x309300C9,
		0x1D90, 0x309400C8,
		0x1D90, 0x309500C7,
		0x1D90, 0x309600C6,
		0x1D90, 0x309700A9,
		0x1D90, 0x309800A8,
		0x1D90, 0x309900A7,
		0x1D90, 0x309A00A6,
		0x1D90, 0x309B00A5,
		0x1D90, 0x309C00A4,
		0x1D90, 0x309D0067,
		0x1D90, 0x309E0066,
		0x1D90, 0x309F0065,
		0x1D90, 0x30A00064,
		0x1D90, 0x30A10063,
		0x1D90, 0x30A20062,
		0x1D90, 0x30A30061,
		0x1D90, 0x30A40047,
		0x1D90, 0x30A50046,
		0x1D90, 0x30A60045,
		0x1D90, 0x30A70044,
		0x1D90, 0x30A80026,
		0x1D90, 0x30A90025,
		0x1D90, 0x30AA0024,
		0x1D90, 0x30AB0023,
		0x1D90, 0x30AC0022,
		0x1D90, 0x30AD0021,
		0x1D90, 0x30AE0247,
		0x1D90, 0x30AF0246,
		0x1D90, 0x30B00245,
		0x1D90, 0x30B10244,
		0x1D90, 0x30B20226,
		0x1D90, 0x30B30225,
		0x1D90, 0x30B40224,
		0x1D90, 0x30B50223,
		0x1D90, 0x30B60222,
		0x1D90, 0x30B70221,
		0x1D90, 0x30B80209,
		0x1D90, 0x30B90208,
		0x1D90, 0x30BA0207,
		0x1D90, 0x30BB0206,
		0x1D90, 0x30BC0205,
		0x1D90, 0x30BD0204,
		0x1D90, 0x30BE0203,
		0x1D90, 0x30BF0202,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FF,
		0x1D90, 0x308200FF,
		0x1D90, 0x308300FE,
		0x1D90, 0x308400FD,
		0x1D90, 0x308500FC,
		0x1D90, 0x308600FB,
		0x1D90, 0x308700FB,
		0x1D90, 0x308800F9,
		0x1D90, 0x308900F8,
		0x1D90, 0x308A00F7,
		0x1D90, 0x308B00F6,
		0x1D90, 0x308C00F5,
		0x1D90, 0x308D00F4,
		0x1D90, 0x308E00F3,
		0x1D90, 0x308F00F2,
		0x1D90, 0x309000F1,
		0x1D90, 0x309100F0,
		0x1D90, 0x309200EF,
		0x1D90, 0x309300EE,
		0x1D90, 0x309400ED,
		0x1D90, 0x309500EC,
		0x1D90, 0x309600EB,
		0x1D90, 0x309700EB,
		0x1D90, 0x309800E9,
		0x1D90, 0x309900E8,
		0x1D90, 0x309A00E7,
		0x1D90, 0x309B00E6,
		0x1D90, 0x309C00E5,
		0x1D90, 0x309D00E4,
		0x1D90, 0x309E00E3,
		0x1D90, 0x309F00E2,
		0x1D90, 0x30A000E1,
		0x1D90, 0x30A100C4,
		0x1D90, 0x30A200C3,
		0x1D90, 0x30A300C2,
		0x1D90, 0x30A400A5,
		0x1D90, 0x30A500A4,
		0x1D90, 0x30A600A3,
		0x1D90, 0x30A70084,
		0x1D90, 0x30A80083,
		0x1D90, 0x30A90082,
		0x1D90, 0x30AA0081,
		0x1D90, 0x30AB0063,
		0x1D90, 0x30AC0062,
		0x1D90, 0x30AD0061,
		0x1D90, 0x30AE0045,
		0x1D90, 0x30AF0044,
		0x1D90, 0x30B00043,
		0x1D90, 0x30B10042,
		0x1D90, 0x30B20023,
		0x1D90, 0x30B30022,
		0x1D90, 0x30B40021,
		0x1D90, 0x30B50005,
		0x1D90, 0x30B60004,
		0x1D90, 0x30B70003,
		0x1D90, 0x30B80002,
		0x1D90, 0x30B90001,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x308000FF,
		0x1D90, 0x308100FE,
		0x1D90, 0x308200FD,
		0x1D90, 0x308300FC,
		0x1D90, 0x308400FB,
		0x1D90, 0x308500FA,
		0x1D90, 0x308600F9,
		0x1D90, 0x308700F8,
		0x1D90, 0x308800F7,
		0x1D90, 0x308900F6,
		0x1D90, 0x308A00F5,
		0x1D90, 0x308B00F4,
		0x1D90, 0x308C00F3,
		0x1D90, 0x308D00F2,
		0x1D90, 0x308E00F1,
		0x1D90, 0x308F00F0,
		0x1D90, 0x309000EF,
		0x1D90, 0x309100EE,
		0x1D90, 0x309200ED,
		0x1D90, 0x309300EC,
		0x1D90, 0x309400EB,
		0x1D90, 0x309500EA,
		0x1D90, 0x309600E9,
		0x1D90, 0x309700E8,
		0x1D90, 0x309800E7,
		0x1D90, 0x309900E6,
		0x1D90, 0x309A00E5,
		0x1D90, 0x309B00E4,
		0x1D90, 0x309C00E3,
		0x1D90, 0x309D00E2,
		0x1D90, 0x309E00E1,
		0x1D90, 0x309F00C4,
		0x1D90, 0x30A000C3,
		0x1D90, 0x30A100C2,
		0x1D90, 0x30A200C1,
		0x1D90, 0x30A300A3,
		0x1D90, 0x30A400A2,
		0x1D90, 0x30A500A1,
		0x1D90, 0x30A60083,
		0x1D90, 0x30A70082,
		0x1D90, 0x30A80081,
		0x1D90, 0x30A90063,
		0x1D90, 0x30AA0062,
		0x1D90, 0x30AB0061,
		0x1D90, 0x30AC0045,
		0x1D90, 0x30AD0044,
		0x1D90, 0x30AE0043,
		0x1D90, 0x30AF0042,
		0x1D90, 0x30B00025,
		0x1D90, 0x30B10024,
		0x1D90, 0x30B20023,
		0x1D90, 0x30B30022,
		0x1D90, 0x30B40021,
		0x1D90, 0x30B50004,
		0x1D90, 0x30B60003,
		0x1D90, 0x30B70002,
		0x1D90, 0x30B80001,
		0x1D90, 0x30B90000,
		0x1D90, 0x30BA0000,
		0x1D90, 0x30BB0000,
		0x1D90, 0x30BC0000,
		0x1D90, 0x30BD0000,
		0x1D90, 0x30BE0000,
		0x1D90, 0x30BF0000,
	0xB0000000,	0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200CA,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600A9,
		0x1D90, 0x30D700A8,
		0x1D90, 0x30D800A7,
		0x1D90, 0x30D900A6,
		0x1D90, 0x30DA00A5,
		0x1D90, 0x30DB00A4,
		0x1D90, 0x30DC0068,
		0x1D90, 0x30DD0067,
		0x1D90, 0x30DE0066,
		0x1D90, 0x30DF0065,
		0x1D90, 0x30E00064,
		0x1D90, 0x30E10063,
		0x1D90, 0x30E20062,
		0x1D90, 0x30E30061,
		0x1D90, 0x30E40047,
		0x1D90, 0x30E50046,
		0x1D90, 0x30E60045,
		0x1D90, 0x30E70044,
		0x1D90, 0x30E80043,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FE,
		0x1D90, 0x30C200FD,
		0x1D90, 0x30C300FC,
		0x1D90, 0x30C400FB,
		0x1D90, 0x30C500FA,
		0x1D90, 0x30C600F9,
		0x1D90, 0x30C700F8,
		0x1D90, 0x30C800F7,
		0x1D90, 0x30C900F6,
		0x1D90, 0x30CA00F5,
		0x1D90, 0x30CB00F4,
		0x1D90, 0x30CC00F3,
		0x1D90, 0x30CD00F2,
		0x1D90, 0x30CE00F1,
		0x1D90, 0x30CF00F0,
		0x1D90, 0x30D000EF,
		0x1D90, 0x30D100EE,
		0x1D90, 0x30D200ED,
		0x1D90, 0x30D300EC,
		0x1D90, 0x30D400EB,
		0x1D90, 0x30D500EA,
		0x1D90, 0x30D600E9,
		0x1D90, 0x30D700E8,
		0x1D90, 0x30D800E7,
		0x1D90, 0x30D900E6,
		0x1D90, 0x30DA00E5,
		0x1D90, 0x30DB00E4,
		0x1D90, 0x30DC00E3,
		0x1D90, 0x30DD00E2,
		0x1D90, 0x30DE00E1,
		0x1D90, 0x30DF00C4,
		0x1D90, 0x30E000C3,
		0x1D90, 0x30E100C2,
		0x1D90, 0x30E200C1,
		0x1D90, 0x30E300A4,
		0x1D90, 0x30E400A3,
		0x1D90, 0x30E500A2,
		0x1D90, 0x30E600A1,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80081,
		0x1D90, 0x30E90063,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0044,
		0x1D90, 0x30ED0043,
		0x1D90, 0x30EE0042,
		0x1D90, 0x30EF0024,
		0x1D90, 0x30F00023,
		0x1D90, 0x30F10022,
		0x1D90, 0x30F20021,
		0x1D90, 0x30F30005,
		0x1D90, 0x30F40004,
		0x1D90, 0x30F50003,
		0x1D90, 0x30F60002,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FE,
		0x1D90, 0x30C300FD,
		0x1D90, 0x30C400FC,
		0x1D90, 0x30C500FB,
		0x1D90, 0x30C600FA,
		0x1D90, 0x30C700F9,
		0x1D90, 0x30C800F8,
		0x1D90, 0x30C900F7,
		0x1D90, 0x30CA00F6,
		0x1D90, 0x30CB00F5,
		0x1D90, 0x30CC00F4,
		0x1D90, 0x30CD00F3,
		0x1D90, 0x30CE00F2,
		0x1D90, 0x30CF00F1,
		0x1D90, 0x30D000F0,
		0x1D90, 0x30D100EF,
		0x1D90, 0x30D200EE,
		0x1D90, 0x30D300ED,
		0x1D90, 0x30D400EC,
		0x1D90, 0x30D500EB,
		0x1D90, 0x30D600EA,
		0x1D90, 0x30D700E9,
		0x1D90, 0x30D800E8,
		0x1D90, 0x30D900E7,
		0x1D90, 0x30DA00E6,
		0x1D90, 0x30DB00E5,
		0x1D90, 0x30DC00E4,
		0x1D90, 0x30DD00E3,
		0x1D90, 0x30DE00E2,
		0x1D90, 0x30DF00C4,
		0x1D90, 0x30E000C3,
		0x1D90, 0x30E100C2,
		0x1D90, 0x30E200A5,
		0x1D90, 0x30E300A4,
		0x1D90, 0x30E400A3,
		0x1D90, 0x30E500A2,
		0x1D90, 0x30E60083,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80064,
		0x1D90, 0x30E90063,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0045,
		0x1D90, 0x30ED0044,
		0x1D90, 0x30EE0043,
		0x1D90, 0x30EF0025,
		0x1D90, 0x30F00024,
		0x1D90, 0x30F10023,
		0x1D90, 0x30F20022,
		0x1D90, 0x30F30021,
		0x1D90, 0x30F40004,
		0x1D90, 0x30F50003,
		0x1D90, 0x30F60002,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200CA,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600C6,
		0x1D90, 0x30D700C5,
		0x1D90, 0x30D800C4,
		0x1D90, 0x30D900C3,
		0x1D90, 0x30DA00C2,
		0x1D90, 0x30DB00C1,
		0x1D90, 0x30DC0086,
		0x1D90, 0x30DD0085,
		0x1D90, 0x30DE0084,
		0x1D90, 0x30DF0066,
		0x1D90, 0x30E00065,
		0x1D90, 0x30E10064,
		0x1D90, 0x30E20063,
		0x1D90, 0x30E30047,
		0x1D90, 0x30E40046,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70043,
		0x1D90, 0x30E80026,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC000B,
		0x1D90, 0x30ED000A,
		0x1D90, 0x30EE0009,
		0x1D90, 0x30EF0008,
		0x1D90, 0x30F00007,
		0x1D90, 0x30F10006,
		0x1D90, 0x30F20005,
		0x1D90, 0x30F30004,
		0x1D90, 0x30F40003,
		0x1D90, 0x30F50002,
		0x1D90, 0x30F60001,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90001,
		0x1D90, 0x30FA0001,
		0x1D90, 0x30FB0001,
		0x1D90, 0x30FC0001,
		0x1D90, 0x30FD0001,
		0x1D90, 0x30FE0001,
		0x1D90, 0x30FF0001,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DB,
		0x1D90, 0x30C100DA,
		0x1D90, 0x30C200D9,
		0x1D90, 0x30C300D8,
		0x1D90, 0x30C400D7,
		0x1D90, 0x30C500D6,
		0x1D90, 0x30C600D5,
		0x1D90, 0x30C700D4,
		0x1D90, 0x30C800D3,
		0x1D90, 0x30C900D2,
		0x1D90, 0x30CA00D1,
		0x1D90, 0x30CB00D0,
		0x1D90, 0x30CC00CF,
		0x1D90, 0x30CD00CE,
		0x1D90, 0x30CE00CD,
		0x1D90, 0x30CF00CC,
		0x1D90, 0x30D000CB,
		0x1D90, 0x30D100C9,
		0x1D90, 0x30D200C9,
		0x1D90, 0x30D300C8,
		0x1D90, 0x30D400C7,
		0x1D90, 0x30D500C6,
		0x1D90, 0x30D600C5,
		0x1D90, 0x30D700C4,
		0x1D90, 0x30D800C3,
		0x1D90, 0x30D900C2,
		0x1D90, 0x30DA0069,
		0x1D90, 0x30DB0068,
		0x1D90, 0x30DC0067,
		0x1D90, 0x30DD0066,
		0x1D90, 0x30DE0065,
		0x1D90, 0x30DF0064,
		0x1D90, 0x30E00063,
		0x1D90, 0x30E10062,
		0x1D90, 0x30E20048,
		0x1D90, 0x30E30047,
		0x1D90, 0x30E40046,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70025,
		0x1D90, 0x30E80024,
		0x1D90, 0x30E90023,
		0x1D90, 0x30EA0022,
		0x1D90, 0x30EB0021,
		0x1D90, 0x30EC0249,
		0x1D90, 0x30ED0248,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200CA,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600A9,
		0x1D90, 0x30D700A8,
		0x1D90, 0x30D800A7,
		0x1D90, 0x30D900A6,
		0x1D90, 0x30DA00A5,
		0x1D90, 0x30DB00A4,
		0x1D90, 0x30DC0068,
		0x1D90, 0x30DD0067,
		0x1D90, 0x30DE0066,
		0x1D90, 0x30DF0065,
		0x1D90, 0x30E00064,
		0x1D90, 0x30E10063,
		0x1D90, 0x30E20062,
		0x1D90, 0x30E30061,
		0x1D90, 0x30E40047,
		0x1D90, 0x30E50046,
		0x1D90, 0x30E60045,
		0x1D90, 0x30E70044,
		0x1D90, 0x30E80043,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FE,
		0x1D90, 0x30C300FD,
		0x1D90, 0x30C400FC,
		0x1D90, 0x30C500FB,
		0x1D90, 0x30C600FA,
		0x1D90, 0x30C700F9,
		0x1D90, 0x30C800F8,
		0x1D90, 0x30C900F7,
		0x1D90, 0x30CA00F6,
		0x1D90, 0x30CB00F5,
		0x1D90, 0x30CC00F4,
		0x1D90, 0x30CD00F3,
		0x1D90, 0x30CE00F2,
		0x1D90, 0x30CF00F1,
		0x1D90, 0x30D000F0,
		0x1D90, 0x30D100EF,
		0x1D90, 0x30D200EE,
		0x1D90, 0x30D300ED,
		0x1D90, 0x30D400EC,
		0x1D90, 0x30D500EB,
		0x1D90, 0x30D600EA,
		0x1D90, 0x30D700E9,
		0x1D90, 0x30D800E8,
		0x1D90, 0x30D900E7,
		0x1D90, 0x30DA00E6,
		0x1D90, 0x30DB00E5,
		0x1D90, 0x30DC00E4,
		0x1D90, 0x30DD00E3,
		0x1D90, 0x30DE00E2,
		0x1D90, 0x30DF00C4,
		0x1D90, 0x30E000C3,
		0x1D90, 0x30E100C2,
		0x1D90, 0x30E200A5,
		0x1D90, 0x30E300A4,
		0x1D90, 0x30E400A3,
		0x1D90, 0x30E500A2,
		0x1D90, 0x30E60083,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80064,
		0x1D90, 0x30E90063,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0045,
		0x1D90, 0x30ED0044,
		0x1D90, 0x30EE0043,
		0x1D90, 0x30EF0025,
		0x1D90, 0x30F00024,
		0x1D90, 0x30F10023,
		0x1D90, 0x30F20022,
		0x1D90, 0x30F30021,
		0x1D90, 0x30F40004,
		0x1D90, 0x30F50003,
		0x1D90, 0x30F60002,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FF,
		0x1D90, 0x30C500FE,
		0x1D90, 0x30C600FD,
		0x1D90, 0x30C700FC,
		0x1D90, 0x30C800FB,
		0x1D90, 0x30C900FB,
		0x1D90, 0x30CA00F9,
		0x1D90, 0x30CB00F8,
		0x1D90, 0x30CC00F7,
		0x1D90, 0x30CD00F6,
		0x1D90, 0x30CE00F5,
		0x1D90, 0x30CF00F4,
		0x1D90, 0x30D000F3,
		0x1D90, 0x30D100F2,
		0x1D90, 0x30D200F1,
		0x1D90, 0x30D300F0,
		0x1D90, 0x30D400EF,
		0x1D90, 0x30D500EE,
		0x1D90, 0x30D600ED,
		0x1D90, 0x30D700EC,
		0x1D90, 0x30D800EB,
		0x1D90, 0x30D900EB,
		0x1D90, 0x30DA00E9,
		0x1D90, 0x30DB00E8,
		0x1D90, 0x30DC00E7,
		0x1D90, 0x30DD00E6,
		0x1D90, 0x30DE00E5,
		0x1D90, 0x30DF00E4,
		0x1D90, 0x30E000E3,
		0x1D90, 0x30E100E2,
		0x1D90, 0x30E200C5,
		0x1D90, 0x30E300C4,
		0x1D90, 0x30E400C3,
		0x1D90, 0x30E500C2,
		0x1D90, 0x30E600A4,
		0x1D90, 0x30E700A3,
		0x1D90, 0x30E800A2,
		0x1D90, 0x30E90083,
		0x1D90, 0x30EA0082,
		0x1D90, 0x30EB0064,
		0x1D90, 0x30EC0063,
		0x1D90, 0x30ED0062,
		0x1D90, 0x30EE0061,
		0x1D90, 0x30EF0046,
		0x1D90, 0x30F00045,
		0x1D90, 0x30F10026,
		0x1D90, 0x30F20025,
		0x1D90, 0x30F30024,
		0x1D90, 0x30F40023,
		0x1D90, 0x30F50006,
		0x1D90, 0x30F60005,
		0x1D90, 0x30F70004,
		0x1D90, 0x30F80003,
		0x1D90, 0x30F90002,
		0x1D90, 0x30FA0001,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200C9,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600A9,
		0x1D90, 0x30D700A8,
		0x1D90, 0x30D800A7,
		0x1D90, 0x30D900A6,
		0x1D90, 0x30DA00A5,
		0x1D90, 0x30DB00A4,
		0x1D90, 0x30DC0068,
		0x1D90, 0x30DD0067,
		0x1D90, 0x30DE0066,
		0x1D90, 0x30DF0065,
		0x1D90, 0x30E00064,
		0x1D90, 0x30E10063,
		0x1D90, 0x30E20062,
		0x1D90, 0x30E30061,
		0x1D90, 0x30E40047,
		0x1D90, 0x30E50046,
		0x1D90, 0x30E60045,
		0x1D90, 0x30E70044,
		0x1D90, 0x30E80043,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FF,
		0x1D90, 0x30C500FE,
		0x1D90, 0x30C600FD,
		0x1D90, 0x30C700FC,
		0x1D90, 0x30C800FB,
		0x1D90, 0x30C900FB,
		0x1D90, 0x30CA00F9,
		0x1D90, 0x30CB00F8,
		0x1D90, 0x30CC00F7,
		0x1D90, 0x30CD00F6,
		0x1D90, 0x30CE00F5,
		0x1D90, 0x30CF00F4,
		0x1D90, 0x30D000F3,
		0x1D90, 0x30D100F2,
		0x1D90, 0x30D200F1,
		0x1D90, 0x30D300F0,
		0x1D90, 0x30D400EF,
		0x1D90, 0x30D500EE,
		0x1D90, 0x30D600ED,
		0x1D90, 0x30D700EC,
		0x1D90, 0x30D800EB,
		0x1D90, 0x30D900EB,
		0x1D90, 0x30DA00E9,
		0x1D90, 0x30DB00E8,
		0x1D90, 0x30DC00E7,
		0x1D90, 0x30DD00E6,
		0x1D90, 0x30DE00E5,
		0x1D90, 0x30DF00E4,
		0x1D90, 0x30E000E3,
		0x1D90, 0x30E100E2,
		0x1D90, 0x30E200C5,
		0x1D90, 0x30E300C4,
		0x1D90, 0x30E400C3,
		0x1D90, 0x30E500C2,
		0x1D90, 0x30E600A4,
		0x1D90, 0x30E700A3,
		0x1D90, 0x30E800A2,
		0x1D90, 0x30E90083,
		0x1D90, 0x30EA0082,
		0x1D90, 0x30EB0064,
		0x1D90, 0x30EC0063,
		0x1D90, 0x30ED0062,
		0x1D90, 0x30EE0061,
		0x1D90, 0x30EF0046,
		0x1D90, 0x30F00045,
		0x1D90, 0x30F10026,
		0x1D90, 0x30F20025,
		0x1D90, 0x30F30024,
		0x1D90, 0x30F40023,
		0x1D90, 0x30F50006,
		0x1D90, 0x30F60005,
		0x1D90, 0x30F70004,
		0x1D90, 0x30F80003,
		0x1D90, 0x30F90002,
		0x1D90, 0x30FA0001,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200C9,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600C6,
		0x1D90, 0x30D700C5,
		0x1D90, 0x30D800C4,
		0x1D90, 0x30D900C3,
		0x1D90, 0x30DA00C2,
		0x1D90, 0x30DB00C1,
		0x1D90, 0x30DC0086,
		0x1D90, 0x30DD0085,
		0x1D90, 0x30DE0084,
		0x1D90, 0x30DF0066,
		0x1D90, 0x30E00065,
		0x1D90, 0x30E10064,
		0x1D90, 0x30E20063,
		0x1D90, 0x30E30047,
		0x1D90, 0x30E40046,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70043,
		0x1D90, 0x30E80026,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC000B,
		0x1D90, 0x30ED000A,
		0x1D90, 0x30EE0009,
		0x1D90, 0x30EF0008,
		0x1D90, 0x30F00007,
		0x1D90, 0x30F10006,
		0x1D90, 0x30F20005,
		0x1D90, 0x30F30004,
		0x1D90, 0x30F40003,
		0x1D90, 0x30F50002,
		0x1D90, 0x30F60001,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80001,
		0x1D90, 0x30F90001,
		0x1D90, 0x30FA0001,
		0x1D90, 0x30FB0001,
		0x1D90, 0x30FC0001,
		0x1D90, 0x30FD0001,
		0x1D90, 0x30FE0001,
		0x1D90, 0x30FF0001,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DB,
		0x1D90, 0x30C100DA,
		0x1D90, 0x30C200D9,
		0x1D90, 0x30C300D8,
		0x1D90, 0x30C400D7,
		0x1D90, 0x30C500D6,
		0x1D90, 0x30C600D5,
		0x1D90, 0x30C700D4,
		0x1D90, 0x30C800D3,
		0x1D90, 0x30C900D2,
		0x1D90, 0x30CA00D1,
		0x1D90, 0x30CB00D0,
		0x1D90, 0x30CC00CF,
		0x1D90, 0x30CD00CE,
		0x1D90, 0x30CE00CD,
		0x1D90, 0x30CF00CC,
		0x1D90, 0x30D000CB,
		0x1D90, 0x30D100C9,
		0x1D90, 0x30D200C9,
		0x1D90, 0x30D300C8,
		0x1D90, 0x30D400C7,
		0x1D90, 0x30D500C6,
		0x1D90, 0x30D600C5,
		0x1D90, 0x30D700C4,
		0x1D90, 0x30D800C3,
		0x1D90, 0x30D900C2,
		0x1D90, 0x30DA0069,
		0x1D90, 0x30DB0068,
		0x1D90, 0x30DC0067,
		0x1D90, 0x30DD0066,
		0x1D90, 0x30DE0065,
		0x1D90, 0x30DF0064,
		0x1D90, 0x30E00063,
		0x1D90, 0x30E10062,
		0x1D90, 0x30E20048,
		0x1D90, 0x30E30047,
		0x1D90, 0x30E40046,
		0x1D90, 0x30E50045,
		0x1D90, 0x30E60044,
		0x1D90, 0x30E70025,
		0x1D90, 0x30E80024,
		0x1D90, 0x30E90023,
		0x1D90, 0x30EA0022,
		0x1D90, 0x30EB0021,
		0x1D90, 0x30EC0249,
		0x1D90, 0x30ED0248,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000DC,
		0x1D90, 0x30C100DB,
		0x1D90, 0x30C200DA,
		0x1D90, 0x30C300D9,
		0x1D90, 0x30C400D8,
		0x1D90, 0x30C500D7,
		0x1D90, 0x30C600D6,
		0x1D90, 0x30C700D5,
		0x1D90, 0x30C800D4,
		0x1D90, 0x30C900D3,
		0x1D90, 0x30CA00D2,
		0x1D90, 0x30CB00D1,
		0x1D90, 0x30CC00D0,
		0x1D90, 0x30CD00CF,
		0x1D90, 0x30CE00CE,
		0x1D90, 0x30CF00CD,
		0x1D90, 0x30D000CC,
		0x1D90, 0x30D100CB,
		0x1D90, 0x30D200C9,
		0x1D90, 0x30D300C9,
		0x1D90, 0x30D400C8,
		0x1D90, 0x30D500C7,
		0x1D90, 0x30D600A9,
		0x1D90, 0x30D700A8,
		0x1D90, 0x30D800A7,
		0x1D90, 0x30D900A6,
		0x1D90, 0x30DA00A5,
		0x1D90, 0x30DB00A4,
		0x1D90, 0x30DC0068,
		0x1D90, 0x30DD0067,
		0x1D90, 0x30DE0066,
		0x1D90, 0x30DF0065,
		0x1D90, 0x30E00064,
		0x1D90, 0x30E10063,
		0x1D90, 0x30E20062,
		0x1D90, 0x30E30061,
		0x1D90, 0x30E40047,
		0x1D90, 0x30E50046,
		0x1D90, 0x30E60045,
		0x1D90, 0x30E70044,
		0x1D90, 0x30E80043,
		0x1D90, 0x30E90025,
		0x1D90, 0x30EA0024,
		0x1D90, 0x30EB0023,
		0x1D90, 0x30EC0022,
		0x1D90, 0x30ED0021,
		0x1D90, 0x30EE0247,
		0x1D90, 0x30EF0246,
		0x1D90, 0x30F00245,
		0x1D90, 0x30F10244,
		0x1D90, 0x30F20243,
		0x1D90, 0x30F30225,
		0x1D90, 0x30F40224,
		0x1D90, 0x30F50223,
		0x1D90, 0x30F60222,
		0x1D90, 0x30F70221,
		0x1D90, 0x30F80208,
		0x1D90, 0x30F90207,
		0x1D90, 0x30FA0206,
		0x1D90, 0x30FB0205,
		0x1D90, 0x30FC0204,
		0x1D90, 0x30FD0203,
		0x1D90, 0x30FE0202,
		0x1D90, 0x30FF0201,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FF,
		0x1D90, 0x30C300FF,
		0x1D90, 0x30C400FE,
		0x1D90, 0x30C500FD,
		0x1D90, 0x30C600FC,
		0x1D90, 0x30C700FB,
		0x1D90, 0x30C800FB,
		0x1D90, 0x30C900F9,
		0x1D90, 0x30CA00F8,
		0x1D90, 0x30CB00F7,
		0x1D90, 0x30CC00F6,
		0x1D90, 0x30CD00F5,
		0x1D90, 0x30CE00F4,
		0x1D90, 0x30CF00F3,
		0x1D90, 0x30D000F2,
		0x1D90, 0x30D100F1,
		0x1D90, 0x30D200F0,
		0x1D90, 0x30D300EF,
		0x1D90, 0x30D400EE,
		0x1D90, 0x30D500ED,
		0x1D90, 0x30D600EC,
		0x1D90, 0x30D700EB,
		0x1D90, 0x30D800EB,
		0x1D90, 0x30D900E9,
		0x1D90, 0x30DA00E8,
		0x1D90, 0x30DB00E7,
		0x1D90, 0x30DC00E6,
		0x1D90, 0x30DD00E5,
		0x1D90, 0x30DE00E4,
		0x1D90, 0x30DF00E3,
		0x1D90, 0x30E000E2,
		0x1D90, 0x30E100E1,
		0x1D90, 0x30E200C4,
		0x1D90, 0x30E300C3,
		0x1D90, 0x30E400C2,
		0x1D90, 0x30E500C1,
		0x1D90, 0x30E600A3,
		0x1D90, 0x30E700A2,
		0x1D90, 0x30E80083,
		0x1D90, 0x30E90082,
		0x1D90, 0x30EA0081,
		0x1D90, 0x30EB0063,
		0x1D90, 0x30EC0062,
		0x1D90, 0x30ED0061,
		0x1D90, 0x30EE0046,
		0x1D90, 0x30EF0045,
		0x1D90, 0x30F00044,
		0x1D90, 0x30F10024,
		0x1D90, 0x30F20023,
		0x1D90, 0x30F30022,
		0x1D90, 0x30F40006,
		0x1D90, 0x30F50005,
		0x1D90, 0x30F60004,
		0x1D90, 0x30F70003,
		0x1D90, 0x30F80002,
		0x1D90, 0x30F90001,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x30C000FF,
		0x1D90, 0x30C100FF,
		0x1D90, 0x30C200FE,
		0x1D90, 0x30C300FD,
		0x1D90, 0x30C400FC,
		0x1D90, 0x30C500FB,
		0x1D90, 0x30C600FA,
		0x1D90, 0x30C700F9,
		0x1D90, 0x30C800F8,
		0x1D90, 0x30C900F7,
		0x1D90, 0x30CA00F6,
		0x1D90, 0x30CB00F5,
		0x1D90, 0x30CC00F4,
		0x1D90, 0x30CD00F3,
		0x1D90, 0x30CE00F2,
		0x1D90, 0x30CF00F1,
		0x1D90, 0x30D000F0,
		0x1D90, 0x30D100EF,
		0x1D90, 0x30D200EE,
		0x1D90, 0x30D300ED,
		0x1D90, 0x30D400EC,
		0x1D90, 0x30D500EB,
		0x1D90, 0x30D600EA,
		0x1D90, 0x30D700E9,
		0x1D90, 0x30D800E8,
		0x1D90, 0x30D900E7,
		0x1D90, 0x30DA00E6,
		0x1D90, 0x30DB00E5,
		0x1D90, 0x30DC00E4,
		0x1D90, 0x30DD00E3,
		0x1D90, 0x30DE00E2,
		0x1D90, 0x30DF00C4,
		0x1D90, 0x30E000C3,
		0x1D90, 0x30E100C2,
		0x1D90, 0x30E200A5,
		0x1D90, 0x30E300A4,
		0x1D90, 0x30E400A3,
		0x1D90, 0x30E500A2,
		0x1D90, 0x30E60083,
		0x1D90, 0x30E70082,
		0x1D90, 0x30E80064,
		0x1D90, 0x30E90063,
		0x1D90, 0x30EA0062,
		0x1D90, 0x30EB0061,
		0x1D90, 0x30EC0045,
		0x1D90, 0x30ED0044,
		0x1D90, 0x30EE0043,
		0x1D90, 0x30EF0025,
		0x1D90, 0x30F00024,
		0x1D90, 0x30F10023,
		0x1D90, 0x30F20022,
		0x1D90, 0x30F30021,
		0x1D90, 0x30F40004,
		0x1D90, 0x30F50003,
		0x1D90, 0x30F60002,
		0x1D90, 0x30F70001,
		0x1D90, 0x30F80000,
		0x1D90, 0x30F90000,
		0x1D90, 0x30FA0000,
		0x1D90, 0x30FB0000,
		0x1D90, 0x30FC0000,
		0x1D90, 0x30FD0000,
		0x1D90, 0x30FE0000,
		0x1D90, 0x30FF0000,
	0xB0000000,	0x00000000,
	0x81000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x310000FF,
		0x1D90, 0x310100FF,
		0x1D90, 0x310200FF,
		0x1D90, 0x310300FF,
		0x1D90, 0x310400FE,
		0x1D90, 0x310500FD,
		0x1D90, 0x310600FC,
		0x1D90, 0x310700FB,
		0x1D90, 0x310800FA,
		0x1D90, 0x310900F9,
		0x1D90, 0x310A00F8,
		0x1D90, 0x310B00F7,
		0x1D90, 0x310C00F6,
		0x1D90, 0x310D00F5,
		0x1D90, 0x310E00F4,
		0x1D90, 0x310F00F3,
		0x1D90, 0x311000F2,
		0x1D90, 0x311100F1,
		0x1D90, 0x311200F0,
		0x1D90, 0x311300EF,
		0x1D90, 0x311400EE,
		0x1D90, 0x311500ED,
		0x1D90, 0x311600EC,
		0x1D90, 0x311700EB,
		0x1D90, 0x311800EA,
		0x1D90, 0x311900E9,
		0x1D90, 0x311A00E8,
		0x1D90, 0x311B00E7,
		0x1D90, 0x311C00C8,
		0x1D90, 0x311D00C7,
		0x1D90, 0x311E00AA,
		0x1D90, 0x311F00A9,
		0x1D90, 0x312000A8,
		0x1D90, 0x312100A7,
		0x1D90, 0x312200A6,
		0x1D90, 0x312300A5,
		0x1D90, 0x312400A4,
		0x1D90, 0x312500A3,
		0x1D90, 0x312600A2,
		0x1D90, 0x312700A1,
		0x1D90, 0x31280069,
		0x1D90, 0x31290068,
		0x1D90, 0x312A0067,
		0x1D90, 0x312B0066,
		0x1D90, 0x312C0065,
		0x1D90, 0x312D0064,
		0x1D90, 0x312E0063,
		0x1D90, 0x312F0062,
		0x1D90, 0x31300061,
		0x1D90, 0x3131000A,
		0x1D90, 0x31320009,
		0x1D90, 0x31330008,
		0x1D90, 0x31340007,
		0x1D90, 0x31350006,
		0x1D90, 0x31360005,
		0x1D90, 0x31370004,
		0x1D90, 0x31380003,
		0x1D90, 0x31390002,
		0x1D90, 0x313A0001,
		0x1D90, 0x313B0000,
		0x1D90, 0x313C0000,
		0x1D90, 0x313D0000,
		0x1D90, 0x313E0000,
		0x1D90, 0x313F0000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1D90, 0x310000FF,
		0x1D90, 0x310100FF,
		0x1D90, 0x310200FF,
		0x1D90, 0x310300FF,
		0x1D90, 0x310400FE,
		0x1D90, 0x310500FD,
		0x1D90, 0x310600FC,
		0x1D90, 0x310700FB,
		0x1D90, 0x310800FA,
		0x1D90, 0x310900F9,
		0x1D90, 0x310A00F8,
		0x1D90, 0x310B00F7,
		0x1D90, 0x310C00F6,
		0x1D90, 0x310D00F5,
		0x1D90, 0x310E00F4,
		0x1D90, 0x310F00F3,
		0x1D90, 0x311000F2,
		0x1D90, 0x311100F1,
		0x1D90, 0x311200F0,
		0x1D90, 0x311300EF,
		0x1D90, 0x311400EE,
		0x1D90, 0x311500ED,
		0x1D90, 0x311600EC,
		0x1D90, 0x311700EB,
		0x1D90, 0x311800EA,
		0x1D90, 0x311900E9,
		0x1D90, 0x311A00E8,
		0x1D90, 0x311B00E7,
		0x1D90, 0x311C00C8,
		0x1D90, 0x311D00C7,
		0x1D90, 0x311E00AA,
		0x1D90, 0x311F00A9,
		0x1D90, 0x312000A8,
		0x1D90, 0x312100A7,
		0x1D90, 0x312200A6,
		0x1D90, 0x312300A5,
		0x1D90, 0x312400A4,
		0x1D90, 0x312500A3,
		0x1D90, 0x312600A2,
		0x1D90, 0x312700A1,
		0x1D90, 0x31280069,
		0x1D90, 0x31290068,
		0x1D90, 0x312A0067,
		0x1D90, 0x312B0066,
		0x1D90, 0x312C0065,
		0x1D90, 0x312D0064,
		0x1D90, 0x312E0063,
		0x1D90, 0x312F0062,
		0x1D90, 0x31300061,
		0x1D90, 0x3131000A,
		0x1D90, 0x31320009,
		0x1D90, 0x31330008,
		0x1D90, 0x31340007,
		0x1D90, 0x31350006,
		0x1D90, 0x31360005,
		0x1D90, 0x31370004,
		0x1D90, 0x31380003,
		0x1D90, 0x31390002,
		0x1D90, 0x313A0001,
		0x1D90, 0x313B0000,
		0x1D90, 0x313C0000,
		0x1D90, 0x313D0000,
		0x1D90, 0x313E0000,
		0x1D90, 0x313F0000,
	0xA0000000,	0x00000000,
		0x1D90, 0x310000FF,
		0x1D90, 0x310100FF,
		0x1D90, 0x310200FF,
		0x1D90, 0x310300FF,
		0x1D90, 0x310400FF,
		0x1D90, 0x310500FF,
		0x1D90, 0x310600FF,
		0x1D90, 0x310700FF,
		0x1D90, 0x310800FF,
		0x1D90, 0x310900FE,
		0x1D90, 0x310A00FD,
		0x1D90, 0x310B00FC,
		0x1D90, 0x310C00FB,
		0x1D90, 0x310D00FA,
		0x1D90, 0x310E00F9,
		0x1D90, 0x310F00F8,
		0x1D90, 0x311000F7,
		0x1D90, 0x311100F6,
		0x1D90, 0x311200F5,
		0x1D90, 0x311300F4,
		0x1D90, 0x311400F3,
		0x1D90, 0x311500F2,
		0x1D90, 0x311600F1,
		0x1D90, 0x311700F0,
		0x1D90, 0x311800EF,
		0x1D90, 0x311900EE,
		0x1D90, 0x311A00ED,
		0x1D90, 0x311B00EC,
		0x1D90, 0x311C00EB,
		0x1D90, 0x311D00EA,
		0x1D90, 0x311E00E9,
		0x1D90, 0x311F00E8,
		0x1D90, 0x312000E7,
		0x1D90, 0x312100E6,
		0x1D90, 0x312200E5,
		0x1D90, 0x312300C6,
		0x1D90, 0x312400C5,
		0x1D90, 0x312500C4,
		0x1D90, 0x312600C3,
		0x1D90, 0x312700C2,
		0x1D90, 0x312800C1,
		0x1D90, 0x312900A5,
		0x1D90, 0x312A00A4,
		0x1D90, 0x312B00A3,
		0x1D90, 0x312C00A2,
		0x1D90, 0x312D00A1,
		0x1D90, 0x312E0086,
		0x1D90, 0x312F0085,
		0x1D90, 0x31300084,
		0x1D90, 0x31310083,
		0x1D90, 0x31320082,
		0x1D90, 0x31330065,
		0x1D90, 0x31340064,
		0x1D90, 0x31350063,
		0x1D90, 0x31360062,
		0x1D90, 0x31370061,
		0x1D90, 0x31380060,
		0x1D90, 0x31390043,
		0x1D90, 0x313A0042,
		0x1D90, 0x313B0026,
		0x1D90, 0x313C0025,
		0x1D90, 0x313D0024,
		0x1D90, 0x313E0023,
		0x1D90, 0x313F0006,
	0xB0000000,	0x00000000,
		0x1D70, 0x22222222,
		0x1D70, 0x20202020,

};

void
odm_read_and_config_mp_8814b_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8814b(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_agc_tab(void)
{
		return 46;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8814b_phy_reg[] = {
		0x1D0C, 0x00010000,
		0x800, 0x00000000,
		0x804, 0xD6300000,
		0x808, 0x61016001,
		0x80C, 0x0CA70200,
		0x810, 0x11B019B0,
		0x814, 0x00904080,
		0x818, 0x030006F1,
		0x81C, 0x00040155,
		0x820, 0x11111111,
		0x824, 0xCFC1CCC4,
		0x828, 0x3003186C,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A557,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x82C, 0x1A55A555,
	0xA0000000,	0x00000000,
		0x82C, 0x1A55A555,
	0xB0000000,	0x00000000,
		0x830, 0x17511459,
		0x834, 0x776995D7,
		0x838, 0x74777A7D,
		0x83C, 0xF9AA9982,
		0x840, 0x89AA9ABB,
		0x844, 0x0DEEDDC1,
		0x848, 0xCDEEDEFF,
		0x84C, 0xFFFF5555,
		0x850, 0x6F7A727D,
		0x854, 0x6C776F7A,
		0x858, 0x6F7A6C77,
		0x85C, 0x69746974,
		0x860, 0x6F7A6C77,
		0x864, 0x6C776C77,
		0x868, 0x727D6F7A,
		0x86C, 0x69D7B197,
		0x870, 0x2085A75E,
		0x874, 0x5582391D,
		0x878, 0x00C025BD,
		0x87C, 0x4140557D,
		0x880, 0x7A1D9D47,
		0x884, 0x1D675C6F,
		0x888, 0x2857A857,
		0x88C, 0x520E8A44,
		0x890, 0x8F628C44,
		0x894, 0x72745F43,
		0x898, 0x03F02F0D,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6884F,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0xA0000000,	0x00000000,
		0x89C, 0x5DB6886F,
	0xB0000000,	0x00000000,
		0x8A0, 0x07D4309F,
		0x8A4, 0x0040D28A,
		0x8A8, 0x00000000,
		0x8AC, 0x00000000,
		0x8B0, 0x00000000,
		0x8B4, 0x00000000,
		0x8B8, 0x00000000,
		0x8BC, 0x00000000,
		0x8C0, 0x00400003,
		0x8C4, 0x00400000,
		0x8C8, 0x00000000,
		0x8CC, 0x00000000,
		0x8D0, 0x00000000,
		0x8D4, 0x00000000,
		0x8D8, 0x00000000,
		0x8DC, 0x00000000,
		0x8E0, 0x00000000,
		0x8E4, 0x00000000,
		0x8E8, 0x00000000,
		0x8EC, 0x00000000,
		0x8F0, 0x00000000,
		0x8F4, 0x00000000,
		0x8F8, 0x00000000,
		0x8FC, 0x00000000,
		0x900, 0x00000000,
		0x904, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x2E0203CE,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x4E0203CE,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x6E0203CE,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x8E0203CE,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xAE0203CE,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xCE0203CE,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xEE0203CE,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x0E0203CE,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x2E0203CE,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x4E0203CE,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x6E0203CE,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x8E0203CE,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xAE0203CE,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xCE0203CE,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0xEE0203CE,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x0E0203CE,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x908, 0x2E0203CE,
	0xA0000000,	0x00000000,
		0x908, 0x0E0203CE,
	0xB0000000,	0x00000000,
		0x90C, 0x00000000,
		0x910, 0x00000000,
		0x914, 0x20000000,
		0x918, 0x20000000,
		0x91C, 0x20000000,
		0x920, 0x20000000,
		0x924, 0x00000000,
		0x928, 0x0000003A,
		0x92C, 0x0000003A,
		0x930, 0x0000003A,
		0x934, 0x0000003A,
		0x938, 0x0000000F,
		0x93C, 0x00000000,
		0x940, 0x4E1F3E81,
		0x944, 0x4E1F3E81,
		0x948, 0x4E1F3E81,
		0x94C, 0x4E1F3E81,
		0x950, 0x03020100,
		0x954, 0x07060504,
		0x958, 0x0B0A0908,
		0x95C, 0x0F0E0D0C,
		0x960, 0x13121110,
		0x964, 0x17161514,
		0x968, 0x03020100,
		0x96C, 0x07060504,
		0x970, 0x0B0A0908,
		0x974, 0x0F0E0D0C,
		0x978, 0x13121110,
		0x97C, 0x17161514,
		0x980, 0x03020100,
		0x984, 0x07060504,
		0x988, 0x0B0A0908,
		0x98C, 0x0F0E0D0C,
		0x990, 0x13121110,
		0x994, 0x17161514,
		0x998, 0x03020100,
		0x99C, 0x07060504,
		0x9A0, 0x0B0A0908,
		0x9A4, 0x0F0E0D0C,
		0x9A8, 0x13121110,
		0x9AC, 0x17161514,
		0x9B0, 0x00002200,
		0x9B4, 0xDB6DB600,
		0x9B8, 0x00400064,
		0x9BC, 0x00000000,
		0x9C0, 0x00000000,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000064,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000018,
		0x9E4, 0x00000018,
		0x9E8, 0x00000018,
		0x9EC, 0x00000018,
		0x9F0, 0x000000FF,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0x9FC, 0x00000000,
		0xA00, 0x02001208,
		0xA04, 0x00000000,
		0xA08, 0x00000000,
		0xA0C, 0x00000000,
		0xA10, 0x00000000,
		0xA14, 0x00000000,
		0xA18, 0x00000000,
		0xA1C, 0x00000000,
		0xA20, 0xEB31B333,
		0xA24, 0x00275485,
		0xA28, 0x00166366,
		0xA2C, 0x00275485,
		0xA30, 0x00166366,
		0xA34, 0x00275485,
		0xA38, 0x00200400,
		0xA3C, 0x00200400,
		0xA40, 0xB359C5BD,
		0xA44, 0x3033BEBD,
		0xA48, 0x2A521254,
		0xA4C, 0xA2733345,
		0xA50, 0x617BE003,
		0xA54, 0x500089E8,
		0xA58, 0x00038000,
		0xA5C, 0x01000000,
		0xA60, 0x02000000,
		0xA64, 0x03000000,
		0xA68, 0x00020000,
		0xA6C, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x000003FF,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x000003FF,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x000003FF,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x000003FF,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0xFFFFFFFF,
		0xA78, 0xFFFFFFFF,
		0xA7C, 0xFFFFFFFF,
	0xA0000000,	0x00000000,
		0xA70, 0x00000000,
		0xA74, 0x00000000,
		0xA78, 0x00000000,
		0xA7C, 0x00000000,
	0xB0000000,	0x00000000,
		0xA80, 0x00000000,
		0xA84, 0x00000000,
		0xA88, 0x00000000,
		0xA8C, 0x00000000,
		0xA90, 0x00000000,
		0xA94, 0x00000000,
		0xA98, 0x00000000,
		0xA9C, 0x00000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00000000,
		0xAA8, 0x00000000,
		0xAAC, 0x00000000,
		0xAB0, 0x00000000,
		0xAB4, 0x00000000,
		0xAB8, 0x00000000,
		0xABC, 0x00000000,
		0xAC0, 0x00000000,
		0xAC4, 0x00000000,
		0xAC8, 0x00000000,
		0xACC, 0x00000000,
		0xAD0, 0x00000000,
		0xAD4, 0x00000000,
		0xAD8, 0x00000000,
		0xADC, 0x00000000,
		0xAE0, 0x00000000,
		0xAE4, 0x00000000,
		0xAE8, 0x00000000,
		0xAEC, 0x00000000,
		0xAF0, 0x00000000,
		0xAF4, 0x00000000,
		0xAF8, 0x00000000,
		0xAFC, 0x00000000,
		0xB00, 0x03900403,
		0xB04, 0x0AF99BFC,
		0xB08, 0x000CFE49,
		0xB0C, 0x0C30C30C,
		0xB10, 0x0C30C30C,
		0xB14, 0x0C30C30C,
		0xB18, 0x0C30C30C,
		0xB1C, 0x0000030C,
		0xB20, 0x000013A7,
		0xB24, 0x00000000,
		0xB28, 0x00000000,
		0xB2C, 0x00000000,
		0xB30, 0x00000000,
		0xB34, 0x00000000,
		0xB38, 0x00000000,
		0xB3C, 0x00000000,
		0xB40, 0x00000000,
		0xB44, 0x00000000,
		0xB48, 0x00000000,
		0xB4C, 0x00000000,
		0xB50, 0x00000000,
		0xB54, 0x00000000,
		0xB58, 0x00000000,
		0xB5C, 0x00000000,
		0xB60, 0x00000000,
		0xB64, 0x00000000,
		0xB68, 0x00000000,
		0xB6C, 0x00000000,
		0xB70, 0x00000000,
		0xB74, 0x00000000,
		0xB78, 0x00000000,
		0xB7C, 0x00000000,
		0xB80, 0x00000000,
		0xB84, 0x00000000,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xB90, 0x00000000,
		0xB94, 0x00000000,
		0xB98, 0x00000000,
		0xB9C, 0x00000000,
		0xBA0, 0x00000000,
		0xBA4, 0x00000000,
		0xBA8, 0x00000000,
		0xBAC, 0x00000000,
		0xBB0, 0x00000000,
		0xBB4, 0x00000000,
		0xBB8, 0x00000000,
		0xBBC, 0x00000000,
		0xBC0, 0x00000000,
		0xBC4, 0x00000000,
		0xBC8, 0x00000000,
		0xBCC, 0x00000000,
		0xBD0, 0x00000000,
		0xBD4, 0x00000000,
		0xBD8, 0x00000000,
		0xBDC, 0x00000000,
		0xBE0, 0x00000000,
		0xBE4, 0x00000000,
		0xBE8, 0x00000000,
		0xBEC, 0x00000000,
		0xBF0, 0x00000000,
		0xBF4, 0x00000000,
		0xBF8, 0x00000000,
		0xBFC, 0x00000000,
		0xC00, 0x008BA0D6,
		0xC04, 0x00000001,
		0xC08, 0x00000000,
		0xC0C, 0x02F1E8B7,
		0xC10, 0x000000B0,
		0xC14, 0x0000D890,
		0xC18, 0x00087672,
		0xC1C, 0x15260000,
		0xC20, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x40600000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0xC24, 0x406000FF,
	0xA0000000,	0x00000000,
		0xC24, 0x40600000,
	0xB0000000,	0x00000000,
		0xC28, 0x06500F76,
		0xC2C, 0xC30020E1,
		0xC30, 0x140C9494,
		0xC34, 0x00A04926,
		0xC38, 0x011D4820,
		0xC3C, 0x168DB61B,
		0xC40, 0x009C50F8,
		0xC44, 0x2003BAD1,
		0xC48, 0xFFFFF7CC,
		0xC4C, 0xA000FFFF,
		0xC50, 0x20D0F800,
		0xC54, 0x941A0200,
		0xC58, 0x18380111,
		0xC5C, 0x006E01B8,
		0xC60, 0x2CA5555B,
		0xC64, 0x0A53005F,
		0xC68, 0x039A5300,
		0xC6C, 0x0265C2BA,
		0xC70, 0x000CEB21,
		0xC74, 0x0E149CA1,
		0xC78, 0x1AB4956B,
		0xC7C, 0x0000003F,
		0xC80, 0x00000000,
		0xC84, 0x06C636C6,
		0xC88, 0x000000BA,
		0xC8C, 0x00000021,
		0xC90, 0x000000A1,
		0xC94, 0x0000006B,
		0xC98, 0x00000000,
		0xC9C, 0x00000000,
		0xCA0, 0x00000000,
		0xCA4, 0x00000000,
		0xCA8, 0x00000000,
		0xCAC, 0x00000000,
		0xCB0, 0x00000000,
		0xCB4, 0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x00000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x00000000,
		0xCDC, 0x00000000,
		0xCE0, 0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x00000000,
		0xCEC, 0x00000000,
		0xCF0, 0x00000000,
		0xCF4, 0x00000000,
		0xCF8, 0x00000000,
		0xCFC, 0x00000000,
		0xD00, 0x1083A10A,
		0xD04, 0x0EC42948,
		0xD08, 0x10852108,
		0xD0C, 0x0CC41D08,
		0xD10, 0x108620EC,
		0xD14, 0x0CA42108,
		0xD18, 0x107620E8,
		0xD1C, 0x0E742108,
		0xD20, 0x0E8618C8,
		0xD24, 0x00000108,
		0xD28, 0x288C230C,
		0xD2C, 0x11C6320C,
		0xD30, 0x30CEBD98,
		0xD34, 0x10C31908,
		0xD38, 0x310A318C,
		0xD3C, 0x18C41D08,
		0xD40, 0x28CC4190,
		0xD44, 0x19062108,
		0xD48, 0x294A5A17,
		0xD4C, 0x00000108,
		0xD50, 0x10A3A908,
		0xD54, 0x10842148,
		0xD58, 0x14C5314A,
		0xD5C, 0x1086258C,
		0xD60, 0x10A42948,
		0xD64, 0x10842108,
		0xD68, 0x08C42108,
		0xD6C, 0x10842148,
		0xD70, 0x08822084,
		0xD74, 0x10841D04,
		0xD78, 0x08421088,
		0xD7C, 0x1083A104,
		0xD80, 0x10842108,
		0xD84, 0x1085294A,
		0xD88, 0x08822104,
		0xD8C, 0x10852948,
		0xD90, 0x08421084,
		0xD94, 0x10852104,
		0xD98, 0x08421084,
		0xD9C, 0x10863184,
		0xDA0, 0x1083B10A,
		0xDA4, 0x10842148,
		0xDA8, 0x1984718C,
		0xDAC, 0x108C33AF,
		0xDB0, 0x00000000,
		0xDB4, 0x00000000,
		0xDB8, 0x00000000,
		0xDBC, 0x00000000,
		0xDC0, 0x00000000,
		0xDC4, 0x00000000,
		0xDC8, 0x00000000,
		0xDCC, 0x00000000,
		0xDD0, 0x00000000,
		0xDD4, 0x00000000,
		0xDD8, 0x00000000,
		0xDDC, 0x00000000,
		0xDE0, 0x00000000,
		0xDE4, 0x00000000,
		0xDE8, 0x00000000,
		0xDEC, 0x00000000,
		0xDF0, 0x00000000,
		0xDF4, 0x00000000,
		0xDF8, 0x00000000,
		0xDFC, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x80033312,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x80033312,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x80033312,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x80033312,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1800, 0x00033312,
	0xA0000000,	0x00000000,
		0x1800, 0x00033312,
	0xB0000000,	0x00000000,
		0x1804, 0x00033312,
		0x180C, 0x10048248,
		0x1810, 0x6005C304,
		0x1814, 0x506AA234,
		0x1818, 0x000004FF,
		0x181C, 0x00000000,
		0x1820, 0x000CC30C,
		0x1824, 0x106AA234,
		0x1828, 0x000004FD,
		0x182C, 0x00000000,
		0x1834, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004C00,
		0x183C, 0x00000000,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004C00,
		0x183C, 0x00000000,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x01004E00,
		0x183C, 0x00000004,
		0x1840, 0x77777420,
		0x1844, 0x77777777,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0xA0000000,	0x00000000,
		0x1838, 0x00000000,
		0x183C, 0x00000000,
		0x1840, 0x77027770,
		0x1844, 0x00000000,
	0xB0000000,	0x00000000,
		0x1848, 0x00000000,
		0x184C, 0x00000000,
		0x1850, 0x00000000,
		0x1854, 0x00000000,
		0x1858, 0x00000000,
		0x185C, 0x00000000,
		0x1860, 0x0C040000,
		0x1864, 0x00000000,
		0x1868, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x25010000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x25010002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x25010000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x25010002,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x24000002,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x186C, 0x00000000,
	0xA0000000,	0x00000000,
		0x186C, 0x00000000,
	0xB0000000,	0x00000000,
		0x1870, 0x00000000,
		0x1874, 0x00000000,
		0x1878, 0x00000000,
		0x187C, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1880, 0x80000000,
	0xA0000000,	0x00000000,
		0x1880, 0x00000000,
	0xB0000000,	0x00000000,
		0x1884, 0x00000000,
		0x1888, 0x00000000,
		0x188C, 0x00000000,
		0x1890, 0x00000000,
		0x1894, 0x00000000,
		0x1898, 0x00000000,
		0x18A0, 0x00510005,
		0x18A4, 0x08041F7F,
		0x18A8, 0x00004126,
		0x18AC, 0x00004200,
		0x18B0, 0x03000F09,
		0x18B4, 0x00000000,
		0x18B8, 0x00000000,
		0x18BC, 0xC100FFC0,
		0x18C0, 0x000001FF,
		0x18C4, 0x00000004,
		0x18C8, 0x001DFFE0,
		0x18CC, 0x03000F09,
		0x18D0, 0x00000000,
		0x18D4, 0x00000000,
		0x18D8, 0xC100FFC0,
		0x18DC, 0x000001FF,
		0x18E0, 0x00000004,
		0x18E4, 0x001DFFE0,
		0x18E8, 0x00013E00,
		0x18EC, 0x1E008000,
		0x18F0, 0x00000000,
		0x18F4, 0x00000000,
		0x18F8, 0x00000000,
		0x18FC, 0x00000000,
		0x1900, 0x85857474,
		0x1904, 0xB7B7C8C8,
		0x1908, 0x00888888,
		0x190C, 0x77776666,
		0x1910, 0x00033333,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875B,
		0x1918, 0x2AA2A864,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0xA0000000,	0x00000000,
		0x1914, 0xAAAC875A,
		0x1918, 0x2AA2A862,
	0xB0000000,	0x00000000,
		0x191C, 0x2AAAA8A2,
		0x1920, 0x00878766,
		0x1924, 0x002E4924,
		0x1928, 0x566DB6C0,
		0x192C, 0x00407090,
		0x1930, 0xB85C0492,
		0x1934, 0x00B4A298,
		0x1938, 0x00030151,
		0x193C, 0x0058C618,
		0x1940, 0x41000000,
		0x1944, 0x00000BD9,
		0x1948, 0xAAAAAAAA,
		0x194C, 0x00000000,
		0x1950, 0x00000000,
		0x1954, 0x00000000,
		0x1958, 0x00000000,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x00000000,
		0x1988, 0x00000000,
		0x198C, 0x00000000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000000,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x00000000,
		0x19AC, 0x00000000,
		0x19B0, 0x00000000,
		0x19B4, 0x00000000,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x00000000,
		0x19D8, 0x00000000,
		0x19DC, 0x00000000,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x00000000,
		0x19FC, 0x00000000,
		0x1C00, 0x00000000,
		0x1C04, 0x00000000,
		0x1C08, 0x00000000,
		0x1C0C, 0x00000000,
		0x1C10, 0x00000000,
		0x1C14, 0x00000000,
		0x1C18, 0x00000000,
		0x1C1C, 0x00000000,
		0x1C20, 0x00003F20,
		0x1C24, 0x00010002,
		0x1C28, 0x00000000,
		0x1C2C, 0x45300000,
		0x1C30, 0x00000000,
		0x1C34, 0xE4E40000,
		0x1C38, 0xFFA1005E,
		0x1C3C, 0x00000000,
		0x1C40, 0x9F588837,
		0x1C44, 0x04400700,
		0x1C48, 0x00000000,
		0x1C4C, 0x00000200,
		0x1C50, 0x8E588837,
		0x1C54, 0x04400337,
		0x1C58, 0x00000000,
		0x1C5C, 0xFFFFFFFF,
		0x1C60, 0x0F030032,
		0x1C64, 0x00000008,
		0x1C68, 0x107F0000,
		0x1C6C, 0x00011E95,
		0x1C70, 0x00031E95,
		0x1C74, 0x00000000,
		0x1C78, 0x00020000,
		0x1C7C, 0x00310000,
		0x1C80, 0x0E38E500,
		0x1C84, 0x03D140CE,
		0x1C88, 0x88404483,
		0x1C8C, 0x08305A20,
		0x1C90, 0x00E49708,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x05FA0000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x05FA0000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0xFFFFFFFF,
		0x1C98, 0x3F2A1500,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0xA0000000,	0x00000000,
		0x1C94, 0x00000000,
		0x1C98, 0x00FA50E4,
	0xB0000000,	0x00000000,
		0x1C9C, 0x00000000,
		0x1CA0, 0x00000000,
		0x1CA4, 0x20000000,
		0x1CA8, 0x00000000,
		0x1CAC, 0xE424A2CC,
		0x1CB0, 0x00000000,
		0x1CB4, 0x00000000,
		0x1CB8, 0x24800000,
		0x1CBC, 0x60004800,
		0x1CC0, 0x24800000,
		0x1CC4, 0x60004800,
		0x1CC8, 0x00000000,
		0x1CCC, 0x00000000,
		0x1CD0, 0x70000000,
		0x1CD4, 0x02024B00,
		0x1CD8, 0x04000000,
		0x1CDC, 0x10000000,
		0x1CE0, 0x00000000,
		0x1CE4, 0x00000000,
		0x1CE8, 0x00000000,
		0x1CEC, 0x00000000,
		0x1CF0, 0x00000000,
		0x1CF4, 0x00000000,
		0x1CF8, 0x00000000,
		0x1CFC, 0x00000000,
		0x1D00, 0x00000000,
		0x1D04, 0x00000000,
		0x1D08, 0xA0000000,
		0x1D10, 0x0001BBBB,
		0x1D14, 0x77777777,
		0x1D18, 0x99999999,
		0x1D1C, 0x99999999,
		0x1D20, 0x000001E0,
		0x1D24, 0x00000000,
		0x1D28, 0x00000000,
		0x1D2C, 0xC0000000,
		0x1D30, 0x50609F00,
		0x1D34, 0x00000000,
		0x1D38, 0x00000000,
		0x1D3C, 0xF8000000,
		0x1D40, 0x00000000,
		0x1D44, 0x74740000,
		0x1D48, 0x14147474,
		0x1D4C, 0x00FFFF14,
		0x1D50, 0x00000000,
		0x1D54, 0x01A00000,
		0x1D58, 0x80800000,
		0x1D5C, 0x00000000,
		0x1D60, 0x00000000,
		0x1D64, 0x88000000,
		0x1D68, 0x00000000,
		0x1D6C, 0x666D8001,
		0x1D70, 0x20202020,
		0x1D74, 0x20202020,
		0x1D78, 0x18189818,
		0x1D7C, 0x0005A000,
		0x1D80, 0x00080000,
		0x1D84, 0x00080000,
		0x1D88, 0x000000EF,
		0x1D8C, 0x0C0C0C0C,
		0x1D90, 0x103F003F,
		0x1D94, 0x00000000,
		0x1D98, 0x00000000,
		0x1D9C, 0x00000000,
		0x1DA0, 0x00000000,
		0x1DA4, 0x00000000,
		0x1DA8, 0x00000000,
		0x1DAC, 0x00000000,
		0x1DB0, 0x00000000,
		0x1DB4, 0x00000000,
		0x1DB8, 0x00000000,
		0x1DBC, 0x00000000,
		0x1DC0, 0x00000000,
		0x1DC4, 0x00000000,
		0x1DC8, 0x00000000,
		0x1DCC, 0x00000000,
		0x1DD0, 0x00000000,
		0x1DD4, 0x00000000,
		0x1DD8, 0x00000000,
		0x1DDC, 0x0F9F0000,
		0x1DE0, 0x01010000,
		0x1DE4, 0x05210123,
		0x1DE8, 0x7FFF4848,
		0x1DEC, 0x00000000,
		0x1DF0, 0x00000000,
		0x1DF4, 0x00000002,
		0x1DF8, 0x00000000,
		0x1DFC, 0x00000000,
		0x1E00, 0x00000000,
		0x1E04, 0x00000000,
		0x1E08, 0x00000000,
		0x1E0C, 0x00000000,
		0x1E10, 0x00000000,
		0x1E14, 0x00000000,
		0x1E18, 0x00000000,
		0x1E1C, 0x00000000,
		0x1E20, 0x00000000,
		0x1E24, 0x80003000,
		0x1E28, 0x000CCCC3,
		0x1E2C, 0xE4E4E4E4,
		0x1E30, 0xE4E4E4E4,
		0x1E34, 0xF30011AC,
		0x1E38, 0x00000000,
		0x1E3C, 0x00000000,
		0x1E40, 0x00000000,
		0x1E44, 0x00000000,
		0x1E48, 0x00000000,
		0x1E4C, 0x00000000,
		0x1E50, 0x00000000,
		0x1E54, 0x00000000,
		0x1E58, 0x00000000,
		0x1E5C, 0xC1000000,
		0x1E60, 0x00000000,
		0x1E64, 0xF3A00001,
		0x1E68, 0x0028846E,
		0x1E6C, 0x40274906,
		0x1E70, 0x00001000,
		0x1E74, 0x00030000,
		0x1E78, 0x00030000,
		0x1E7C, 0x00000000,
		0x1E80, 0x00000000,
		0x1E84, 0x00000000,
		0x1E84, 0x40000000,
		0x1E84, 0x41000000,
		0x1E84, 0x42000000,
		0x1E84, 0x43000000,
		0x1E84, 0x44000000,
		0x1E84, 0x45000000,
		0x1E84, 0x46000000,
		0x1E84, 0x47000000,
		0x1E84, 0x48000000,
		0x1E84, 0x49000000,
		0x1E84, 0x4A000000,
		0x1E84, 0x4B000000,
		0x1E84, 0x4C000000,
		0x1E84, 0x4D000000,
		0x1E84, 0x4E000000,
		0x1E84, 0x4F000000,
		0x1E84, 0x50000000,
		0x1E84, 0x51000000,
		0x1E84, 0x52000000,
		0x1E84, 0x53000000,
		0x1E84, 0x54000000,
		0x1E84, 0x55000000,
		0x1E84, 0x56000000,
		0x1E84, 0x57000000,
		0x1E84, 0x58000000,
		0x1E84, 0x59000000,
		0x1E84, 0x5A000000,
		0x1E84, 0x5B000000,
		0x1E84, 0x5C000000,
		0x1E84, 0x5D000000,
		0x1E84, 0x5E000000,
		0x1E84, 0x5F000000,
		0x1E84, 0x60000000,
		0x1E84, 0x61000000,
		0x1E84, 0x62000000,
		0x1E84, 0x63000000,
		0x1E84, 0x64000000,
		0x1E84, 0x65000000,
		0x1E84, 0x66000000,
		0x1E84, 0x67000000,
		0x1E84, 0x68000000,
		0x1E84, 0x69000000,
		0x1E84, 0x6A000000,
		0x1E84, 0x6B000000,
		0x1E84, 0x6C000000,
		0x1E84, 0x6D000000,
		0x1E84, 0x6E000000,
		0x1E84, 0x6F000000,
		0x1E84, 0x70000000,
		0x1E84, 0x71000000,
		0x1E84, 0x72000000,
		0x1E84, 0x73000000,
		0x1E84, 0x74000000,
		0x1E84, 0x75000000,
		0x1E84, 0x76000000,
		0x1E84, 0x77000000,
		0x1E84, 0x78000000,
		0x1E84, 0x79000000,
		0x1E84, 0x7A000000,
		0x1E84, 0x7B000000,
		0x1E84, 0x7C000000,
		0x1E84, 0x7D000000,
		0x1E84, 0x7E000000,
		0x1E84, 0x7F000000,
		0x1E88, 0x00003C1C,
		0x1E8C, 0x00000000,
		0x1E90, 0x00000000,
		0x1E94, 0x00000000,
		0x1E98, 0x00000000,
		0x1E9C, 0x00000000,
		0x1EA0, 0x00000000,
		0x1EA4, 0x00000000,
		0x1EA8, 0xAA464646,
		0x1EAC, 0x01800030,
		0x1EB0, 0x00003000,
		0x1EB4, 0x31000002,
		0x1EB8, 0x00000000,
		0x1EBC, 0x00000000,
		0x1EC0, 0x00000000,
		0x1EC4, 0x00000000,
		0x1EC8, 0x00000000,
		0x1ECC, 0x00000000,
		0x1ED0, 0x00000000,
		0x1ED4, 0x8000000A,
		0x1ED8, 0x800B03E8,
		0x1EDC, 0x83E90FFF,
		0x1EE0, 0x8000FFFF,
		0x1EE4, 0x00000000,
		0x1EE8, 0x00000000,
		0x1EEC, 0x00001049,
		0x1EF0, 0x00000B00,
		0x1EF4, 0x00001049,
		0x1EF8, 0x01000100,
		0x1EFC, 0x00001049,
		0x3A00, 0x00000000,
		0x3A04, 0x00000000,
		0x3A08, 0x00000000,
		0x3A0C, 0x00000000,
		0x3A10, 0x00000000,
		0x3A14, 0x00000000,
		0x3A18, 0x00000000,
		0x3A1C, 0x00000000,
		0x3A20, 0x00000000,
		0x3A24, 0x00000000,
		0x3A28, 0x00000000,
		0x3A2C, 0x00000000,
		0x3A30, 0x00000000,
		0x3A34, 0x00000000,
		0x3A38, 0x00000000,
		0x3A3C, 0x00000000,
		0x3A40, 0x00000000,
		0x3A44, 0x00000000,
		0x3A48, 0x00000000,
		0x3A4C, 0x00000000,
		0x3A50, 0x00000000,
		0x4000, 0x85857575,
		0x4004, 0xB7B7B7B7,
		0x4008, 0x00777788,
		0x400C, 0x77776666,
		0x4010, 0x00033333,
		0x4014, 0xAAAC875A,
		0x4018, 0x2AA2A8A2,
		0x401C, 0x2AAAA8A2,
		0x4020, 0x00878766,
		0x4024, 0x002E4924,
		0x4028, 0x566DB6C0,
		0x402C, 0x00407090,
		0x4030, 0xB85C0492,
		0x4034, 0x00B4A298,
		0x4038, 0x00030151,
		0x403C, 0x0058C618,
		0x4040, 0x41000000,
		0x4044, 0x00000BD9,
		0x4048, 0xAAAAAAAA,
		0x404C, 0x00000000,
		0x4050, 0x00000000,
		0x4054, 0x00000000,
		0x4058, 0x00000000,
		0x405C, 0x00000000,
		0x4060, 0x00000000,
		0x4064, 0x00000000,
		0x4068, 0x00000000,
		0x406C, 0x00000000,
		0x4070, 0x00000000,
		0x4074, 0x00000000,
		0x4078, 0x00000000,
		0x407C, 0x00000000,
		0x4080, 0x00000000,
		0x4084, 0x00000000,
		0x4088, 0x00000000,
		0x408C, 0x00000000,
		0x4090, 0x00000000,
		0x4094, 0x00000000,
		0x4098, 0x00000000,
		0x409C, 0x00000000,
		0x40A0, 0x00000000,
		0x40A4, 0x00000000,
		0x40A8, 0x00000000,
		0x40AC, 0x00000000,
		0x40B0, 0x00000000,
		0x40B4, 0x00000000,
		0x40B8, 0x00000000,
		0x40BC, 0x00000000,
		0x40C0, 0x00000000,
		0x40C4, 0x00000000,
		0x40C8, 0x00000000,
		0x40CC, 0x00000000,
		0x40D0, 0x00000000,
		0x40D4, 0x00000000,
		0x40D8, 0x00000000,
		0x40DC, 0x00000000,
		0x40E0, 0x00000000,
		0x40E4, 0x00000000,
		0x40E8, 0x00000000,
		0x40EC, 0x00000000,
		0x40F0, 0x00000000,
		0x40F4, 0x00000000,
		0x40F8, 0x00000000,
		0x40FC, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x80033312,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x80033312,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x80033312,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x80033312,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x4100, 0x00033312,
	0xA0000000,	0x00000000,
		0x4100, 0x00033312,
	0xB0000000,	0x00000000,
		0x4104, 0x00033312,
		0x410C, 0x10048248,
		0x4110, 0x6005C304,
		0x4114, 0x506AA234,
		0x4118, 0x000004FF,
		0x411C, 0x00000000,
		0x4120, 0x000CC30C,
		0x4124, 0x106AA234,
		0x4128, 0x000004FD,
		0x412C, 0x00000000,
		0x4134, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004C00,
		0x413C, 0x00000000,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004C00,
		0x413C, 0x00000000,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x01004E00,
		0x413C, 0x00000040,
		0x4140, 0x74207777,
		0x4144, 0x77777777,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0xA0000000,	0x00000000,
		0x4138, 0x00000000,
		0x413C, 0x00000000,
		0x4140, 0x02777707,
		0x4144, 0x00000000,
	0xB0000000,	0x00000000,
		0x4148, 0x00000000,
		0x414C, 0x00000000,
		0x4150, 0x00000000,
		0x4154, 0x00000000,
		0x4158, 0x00000000,
		0x415C, 0x00000000,
		0x4160, 0x0C040000,
		0x4164, 0x00000000,
		0x4168, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x25010000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x25010002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x25010000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x25010002,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x24000002,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x416C, 0x00000000,
	0xA0000000,	0x00000000,
		0x416C, 0x00000000,
	0xB0000000,	0x00000000,
		0x4170, 0x00000000,
		0x4174, 0x00000000,
		0x4178, 0x00000000,
		0x417C, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x80000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x80000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x80000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x80000000,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x80000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x4180, 0x00000000,
	0xA0000000,	0x00000000,
		0x4180, 0x00000000,
	0xB0000000,	0x00000000,
		0x4184, 0x00000000,
		0x4188, 0x00000000,
		0x418C, 0x00000000,
		0x4190, 0x00000000,
		0x4194, 0x00000000,
		0x4198, 0x00000000,
		0x41A0, 0x00510005,
		0x41A4, 0x08041F7F,
		0x41A8, 0x0000499A,
		0x41AC, 0x00004200,
		0x41B0, 0x03000F09,
		0x41B4, 0x00000000,
		0x41B8, 0x00000000,
		0x41BC, 0xC100FFC0,
		0x41C0, 0x000001FF,
		0x41C4, 0x00000004,
		0x41C8, 0x001DFFE0,
		0x41CC, 0x03000F09,
		0x41D0, 0x00000000,
		0x41D4, 0x00000000,
		0x41D8, 0xC100FFC0,
		0x41DC, 0x000001FF,
		0x41E0, 0x00000004,
		0x41E4, 0x001DFFE0,
		0x41E8, 0x00013E00,
		0x41EC, 0x1E008000,
		0x41F0, 0x00000000,
		0x41F4, 0x00000000,
		0x41F8, 0x00000000,
		0x41FC, 0x00000000,
		0x5000, 0x63636363,
		0x5004, 0xB7B7B7B7,
		0x5008, 0x00888788,
		0x500C, 0x88887777,
		0x5010, 0x00033333,
		0x5014, 0xAEBC875B,
		0x5018, 0x2BA6B924,
		0x501C, 0x2BAAB924,
		0x5020, 0x00878766,
		0x5024, 0x002E4924,
		0x5028, 0x566DB6C0,
		0x502C, 0x00407090,
		0x5030, 0xB85C0492,
		0x5034, 0x00B4A298,
		0x5038, 0x00030151,
		0x503C, 0x0058C618,
		0x5040, 0x41000000,
		0x5044, 0x00000BD9,
		0x5048, 0xAAAAAAAA,
		0x504C, 0x00000000,
		0x5050, 0x00000000,
		0x5054, 0x00000000,
		0x5058, 0x00000000,
		0x505C, 0x00000000,
		0x5060, 0x00000000,
		0x5064, 0x00000000,
		0x5068, 0x00000000,
		0x506C, 0x00000000,
		0x5070, 0x00000000,
		0x5074, 0x00000000,
		0x5078, 0x00000000,
		0x507C, 0x00000000,
		0x5080, 0x00000000,
		0x5084, 0x00000000,
		0x5088, 0x00000000,
		0x508C, 0x00000000,
		0x5090, 0x00000000,
		0x5094, 0x00000000,
		0x5098, 0x00000000,
		0x509C, 0x00000000,
		0x50A0, 0x00000000,
		0x50A4, 0x00000000,
		0x50A8, 0x00000000,
		0x50AC, 0x00000000,
		0x50B0, 0x00000000,
		0x50B4, 0x00000000,
		0x50B8, 0x00000000,
		0x50BC, 0x00000000,
		0x50C0, 0x00000000,
		0x50C4, 0x00000000,
		0x50C8, 0x00000000,
		0x50CC, 0x00000000,
		0x50D0, 0x00000000,
		0x50D4, 0x00000000,
		0x50D8, 0x00000000,
		0x50DC, 0x00000000,
		0x50E0, 0x00000000,
		0x50E4, 0x00000000,
		0x50E8, 0x00000000,
		0x50EC, 0x00000000,
		0x50F0, 0x00000000,
		0x50F4, 0x00000000,
		0x50F8, 0x00000000,
		0x50FC, 0x00000000,
		0x5100, 0x42424242,
		0x5104, 0xB7B76363,
		0x5108, 0x77888888,
		0x510C, 0x88887777,
		0x5110, 0x00033333,
		0x5114, 0xAEBC865B,
		0x5118, 0x2BA6B8A4,
		0x511C, 0x2BAAB924,
		0x5120, 0x00868655,
		0x5124, 0x002E4924,
		0x5128, 0x566DB6C0,
		0x512C, 0x00407090,
		0x5130, 0xB85C0492,
		0x5134, 0x00B4A298,
		0x5138, 0x00030151,
		0x513C, 0x0058C618,
		0x5140, 0x41000000,
		0x5144, 0x00000BD9,
		0x5148, 0xAAAAAAAA,
		0x514C, 0x00000000,
		0x5150, 0x00000000,
		0x5154, 0x00000000,
		0x5158, 0x00000000,
		0x515C, 0x00000000,
		0x5160, 0x00000000,
		0x5164, 0x00000000,
		0x5168, 0x00000000,
		0x516C, 0x00000000,
		0x5170, 0x00000000,
		0x5174, 0x00000000,
		0x5178, 0x00000000,
		0x517C, 0x00000000,
		0x5180, 0x00000000,
		0x5184, 0x00000000,
		0x5188, 0x00000000,
		0x518C, 0x00000000,
		0x5190, 0x00000000,
		0x5194, 0x00000000,
		0x5198, 0x00000000,
		0x519C, 0x00000000,
		0x51A0, 0x00000000,
		0x51A4, 0x00000000,
		0x51A8, 0x00000000,
		0x51AC, 0x00000000,
		0x51B0, 0x00000000,
		0x51B4, 0x00000000,
		0x51B8, 0x00000000,
		0x51BC, 0x00000000,
		0x51C0, 0x00000000,
		0x51C4, 0x00000000,
		0x51C8, 0x00000000,
		0x51CC, 0x00000000,
		0x51D0, 0x00000000,
		0x51D4, 0x00000000,
		0x51D8, 0x00000000,
		0x51DC, 0x00000000,
		0x51E0, 0x00000000,
		0x51E4, 0x00000000,
		0x51E8, 0x00000000,
		0x51EC, 0x00000000,
		0x51F0, 0x00000000,
		0x51F4, 0x00000000,
		0x51F8, 0x00000000,
		0x51FC, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x80033312,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x80033312,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x80033312,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x80033312,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5200, 0x00033312,
	0xA0000000,	0x00000000,
		0x5200, 0x00033312,
	0xB0000000,	0x00000000,
		0x5204, 0x00033312,
		0x520C, 0x10048248,
		0x5210, 0x6005C304,
		0x5214, 0x506AA234,
		0x5218, 0x000004FF,
		0x521C, 0x00000000,
		0x5220, 0x000CC30C,
		0x5224, 0x106AA234,
		0x5228, 0x000004FD,
		0x522C, 0x00000000,
		0x5234, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004C00,
		0x523C, 0x00000000,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004C00,
		0x523C, 0x00000000,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x01004E00,
		0x523C, 0x00000400,
		0x5240, 0x77777777,
		0x5244, 0x77777420,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0xA0000000,	0x00000000,
		0x5238, 0x00000000,
		0x523C, 0x00000000,
		0x5240, 0x77777702,
		0x5244, 0x02777707,
	0xB0000000,	0x00000000,
		0x5248, 0x00000000,
		0x524C, 0x00000000,
		0x5250, 0x00000000,
		0x5254, 0x00000000,
		0x5258, 0x00000000,
		0x525C, 0x00000000,
		0x5260, 0x0C040000,
		0x5264, 0x00000000,
		0x5268, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x25010000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x25010002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x25010000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x25010002,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x24000002,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x526C, 0x00000000,
	0xA0000000,	0x00000000,
		0x526C, 0x00000000,
	0xB0000000,	0x00000000,
		0x5270, 0x00000000,
		0x5274, 0x00000000,
		0x5278, 0x00000000,
		0x527C, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x80000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x80000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x80000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x80000000,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x80000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5280, 0x00000000,
	0xA0000000,	0x00000000,
		0x5280, 0x00000000,
	0xB0000000,	0x00000000,
		0x5284, 0x00000000,
		0x5288, 0x00000000,
		0x528C, 0x00000000,
		0x5290, 0x00000000,
		0x5294, 0x00000000,
		0x5298, 0x00000000,
		0x52A0, 0x00510005,
		0x52A4, 0x08041F7F,
		0x52A8, 0x0000499A,
		0x52AC, 0x00004200,
		0x52B0, 0x03000F09,
		0x52B4, 0x00000000,
		0x52B8, 0x00000000,
		0x52BC, 0xC100FFC0,
		0x52C0, 0x000001FF,
		0x52C4, 0x00000004,
		0x52C8, 0x001DFFE0,
		0x52CC, 0x03000F09,
		0x52D0, 0x00000000,
		0x52D4, 0x00000000,
		0x52D8, 0xC100FFC0,
		0x52DC, 0x000001FF,
		0x52E0, 0x00000004,
		0x52E4, 0x001DFFE0,
		0x52E8, 0x00013E00,
		0x52EC, 0x1E008000,
		0x52F0, 0x00000000,
		0x52F4, 0x00000000,
		0x52F8, 0x00000000,
		0x52FC, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x80033312,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x80033312,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x80033312,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x80033312,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5300, 0x00033312,
	0xA0000000,	0x00000000,
		0x5300, 0x00033312,
	0xB0000000,	0x00000000,
		0x5304, 0x00033312,
		0x530C, 0x10048248,
		0x5310, 0x6005C304,
		0x5314, 0x506AA234,
		0x5318, 0x000004FF,
		0x531C, 0x00000000,
		0x5320, 0x000CC30C,
		0x5324, 0x106AA234,
		0x5328, 0x000004FD,
		0x532C, 0x00000000,
		0x5334, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004C00,
		0x533C, 0x00000000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004C00,
		0x533C, 0x00000000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x01004E00,
		0x533C, 0x00004000,
		0x5340, 0x77777777,
		0x5344, 0x74207777,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0xA0000000,	0x00000000,
		0x5338, 0x00000000,
		0x533C, 0x00000000,
		0x5340, 0x77777702,
		0x5344, 0x02777707,
	0xB0000000,	0x00000000,
		0x5348, 0x00000000,
		0x534C, 0x00000000,
		0x5350, 0x00000000,
		0x5354, 0x00000000,
		0x5358, 0x00000000,
		0x535C, 0x00000000,
		0x5360, 0x0C040000,
		0x5364, 0x00000000,
		0x5368, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x25010000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x25010002,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x25010000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x25010002,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x24000002,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x536C, 0x00000000,
	0xA0000000,	0x00000000,
		0x536C, 0x00000000,
	0xB0000000,	0x00000000,
		0x5370, 0x00000000,
		0x5374, 0x00000000,
		0x5378, 0x00000000,
		0x537C, 0x00000000,
	0x81000001,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000002,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000003,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000004,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000005,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000006,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x91000008,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x92000000,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x80000000,
	0x92000001,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x80000000,
	0x92000002,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x92000003,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x80000000,
	0x92000004,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x92000005,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x92000006,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x80000000,
	0x92000007,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x80000000,
	0x92000008,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0x92000009,	0x00000000,	0x40000000,	0x00000000,
		0x5380, 0x00000000,
	0xA0000000,	0x00000000,
		0x5380, 0x00000000,
	0xB0000000,	0x00000000,
		0x5384, 0x00000000,
		0x5388, 0x00000000,
		0x538C, 0x00000000,
		0x5390, 0x00000000,
		0x5394, 0x00000000,
		0x5398, 0x00000000,
		0x53A0, 0x00510005,
		0x53A4, 0x08041F7F,
		0x53A8, 0x0000499A,
		0x53AC, 0x00004200,
		0x53B0, 0x03000F09,
		0x53B4, 0x00000000,
		0x53B8, 0x00000000,
		0x53BC, 0xC100FFC0,
		0x53C0, 0x000001FF,
		0x53C4, 0x00000004,
		0x53C8, 0x001DFFE0,
		0x53CC, 0x03000F09,
		0x53D0, 0x00000000,
		0x53D4, 0x00000000,
		0x53D8, 0xC100FFC0,
		0x53DC, 0x000001FF,
		0x53E0, 0x00000004,
		0x53E4, 0x001DFFE0,
		0x53E8, 0x00013E00,
		0x53EC, 0x1E008000,
		0x53F0, 0x00000000,
		0x53F4, 0x00000000,
		0x53F8, 0x00000000,
		0x53FC, 0x00000000,
		0x1830, 0x700B8001,
		0x1830, 0x700B8001,
		0x1830, 0x70144001,
		0x1830, 0x70244001,
		0x1830, 0x70344001,
		0x1830, 0x70444001,
		0x1830, 0x705B8001,
		0x1830, 0x70644001,
		0x1830, 0x707B8001,
		0x1830, 0x708B8001,
		0x1830, 0x709B8001,
		0x1830, 0x70AB8001,
		0x1830, 0x70BB8001,
		0x1830, 0x70CB8001,
		0x1830, 0x70DB8001,
		0x1830, 0x70EB8001,
		0x1830, 0x70FB8001,
		0x1830, 0x70FB8001,
		0x4130, 0x700B8001,
		0x4130, 0x700B8001,
		0x4130, 0x70144001,
		0x4130, 0x70244001,
		0x4130, 0x70344001,
		0x4130, 0x70444001,
		0x4130, 0x705B8001,
		0x4130, 0x70644001,
		0x4130, 0x707B8001,
		0x4130, 0x708B8001,
		0x4130, 0x709B8001,
		0x4130, 0x70AB8001,
		0x4130, 0x70BB8001,
		0x4130, 0x70CB8001,
		0x4130, 0x70DB8001,
		0x4130, 0x70EB8001,
		0x4130, 0x70FB8001,
		0x4130, 0x70FB8001,
		0x5230, 0x700B8001,
		0x5230, 0x700B8001,
		0x5230, 0x70144001,
		0x5230, 0x70244001,
		0x5230, 0x70344001,
		0x5230, 0x70444001,
		0x5230, 0x705B8001,
		0x5230, 0x70644001,
		0x5230, 0x707B8001,
		0x5230, 0x708B8001,
		0x5230, 0x709B8001,
		0x5230, 0x70AB8001,
		0x5230, 0x70BB8001,
		0x5230, 0x70CB8001,
		0x5230, 0x70DB8001,
		0x5230, 0x70EB8001,
		0x5230, 0x70FB8001,
		0x5230, 0x70FB8001,
		0x5330, 0x700B8001,
		0x5330, 0x700B8001,
		0x5330, 0x70144001,
		0x5330, 0x70244001,
		0x5330, 0x70344001,
		0x5330, 0x70444001,
		0x5330, 0x705B8001,
		0x5330, 0x70644001,
		0x5330, 0x707B8001,
		0x5330, 0x708B8001,
		0x5330, 0x709B8001,
		0x5330, 0x70AB8001,
		0x5330, 0x70BB8001,
		0x5330, 0x70CB8001,
		0x5330, 0x70DB8001,
		0x5330, 0x70EB8001,
		0x5330, 0x70FB8001,
		0x5330, 0x70FB8001,
		0x1A00, 0x00D047D8,
		0x1A04, 0xC0FF0008,
		0x1A08, 0x88838300,
		0x1A0C, 0x2E20200F,
		0x1A10, 0x8D00BB78,
		0x1A14, 0x111440A8,
		0x1A18, 0x00981117,
		0x1A1C, 0x89140F00,
		0x1A20, 0xE82C0000,
		0x1A24, 0x64B80C1C,
		0x1A28, 0x00158810,
		0x1A2C, 0x10998000,
		0x1A70, 0x03008000,
		0x1A74, 0x00000000,
		0x1A78, 0x000089F0,
		0x1A7C, 0x00450606,
		0x1A80, 0x20803210,
		0x1A84, 0x80200200,
		0x1A88, 0xC48C0000,
		0x1A8C, 0x00000000,
		0x1A90, 0x00000000,
		0x1A94, 0x00000000,
		0x1A98, 0x0000C040,
		0x1A9C, 0x00460000,
		0x1AA0, 0x00000000,
		0x1AA4, 0x00020007,
		0x1AA8, 0xBA0F0044,
		0x1AAC, 0x01235667,
		0x1AB0, 0x00000000,
		0x1AB4, 0x0F201402,
		0x1AB8, 0x00000000,
		0x1ABC, 0xC2030000,
		0x1AC0, 0x541CA742,
		0x1AC4, 0x0002C688,
		0x1AC8, 0x20090F06,
		0x1ACC, 0x120F0F07,
		0x1AD0, 0x21063A10,
		0x1AD4, 0x0D9DA464,
		0x1AD8, 0x8C924924,
		0x1ADC, 0x1463C389,
		0x1AE0, 0x17600391,
		0x1AE4, 0x08000001,
		0x1D0C, 0x00000000,
		0x1D0C, 0x00010000,
		0x1D0C, 0x00410000,
		0x1EE8, 0x00000003,
		0xC0C, 0x02F1E8BF,
		0x1D94, 0x40000000,
		0x1D94, 0x40010000,
		0x1D94, 0x40020000,
		0x1D94, 0x40030000,
		0x1D94, 0x40040000,
		0x1D94, 0x40050000,
		0x1D94, 0x40060000,
		0x1D94, 0x40070000,
		0x1D94, 0x40080000,
		0x1D94, 0x40090000,
		0x1D94, 0x400A0000,
		0x1D94, 0x400B0000,
		0x1D94, 0x400C0000,
		0x1D94, 0x400D0000,
		0x1D94, 0x400E0000,
		0x1D94, 0x400F0000,
		0x1D94, 0x40100000,
		0x1D94, 0x40110000,
		0x1D94, 0x40120000,
		0x1D94, 0x40130000,
		0x1D94, 0x40140000,
		0x1D94, 0x40150000,
		0x1D94, 0x40160000,
		0x1D94, 0x40170000,
		0x1D94, 0x40180000,
		0x1D94, 0x40190000,
		0x1D94, 0x401A0000,
		0x1D94, 0x401B0000,
		0x1D94, 0x401C0000,
		0x1D94, 0x401D0000,
		0x1D94, 0x401E0000,
		0x1D94, 0x401F0000,
		0x1D94, 0x40200000,
		0x1D94, 0x40210000,
		0x1D94, 0x40220000,
		0x1D94, 0x40230000,
		0x1D94, 0x40240000,
		0x1D94, 0x40250000,
		0x1D94, 0x40260000,
		0x1D94, 0x40270000,
		0x1D94, 0x40280000,
		0x1D94, 0x40290000,
		0x1D94, 0x402A0000,
		0x1D94, 0x402B0000,
		0x1D94, 0x402C0000,
		0x1D94, 0x402D0000,
		0x1D94, 0x402E0000,
		0x1D94, 0x402F0000,
		0x1D94, 0x40300000,
		0x1D94, 0x40310000,
		0x1D94, 0x40320000,
		0x1D94, 0x40330000,
		0x1D94, 0x40340000,
		0x1D94, 0x40350000,
		0x1D94, 0x40360000,
		0x1D94, 0x40370000,
		0x1D94, 0x40380000,
		0x1D94, 0x40390000,
		0x1D94, 0x403A0000,
		0x1D94, 0x403B0000,
		0x1D94, 0x403C0000,
		0x1D94, 0x403D0000,
		0x1D94, 0x403E0000,
		0x1D94, 0x403F0000,
		0x1D94, 0x40400000,
		0x1D94, 0x40410000,
		0x1D94, 0x40420000,
		0x1D94, 0x40430000,
		0x1D94, 0x40440000,
		0x1D94, 0x40450000,
		0x1D94, 0x40460000,
		0x1D94, 0x40470000,
		0x1D94, 0x40480000,
		0x1D94, 0x40490000,
		0x1D94, 0x404A0000,
		0x1D94, 0x404B0000,
		0x1D94, 0x404C0000,
		0x1D94, 0x404D0000,
		0x1D94, 0x404E0000,
		0x1D94, 0x404F0000,
		0x1D94, 0x40500000,
		0x1D94, 0x40510000,
		0x1D94, 0x40520000,
		0x1D94, 0x40530000,
		0x1D94, 0x40540000,
		0x1D94, 0x40550000,
		0x1D94, 0x40560000,
		0x1D94, 0x40570000,
		0x1D94, 0x40580000,
		0x1D94, 0x40590000,
		0x1D94, 0x405A0000,
		0x1D94, 0x405B0000,
		0x1D94, 0x405C0000,
		0x1D94, 0x405D0000,
		0x1D94, 0x405E0000,
		0x1D94, 0x405F0000,
		0x1D94, 0x40600000,
		0x1D94, 0x40610000,
		0x1D94, 0x40620000,
		0x1D94, 0x40630000,
		0x1D94, 0x40640000,
		0x1D94, 0x40650000,
		0x1D94, 0x40660000,
		0x1D94, 0x40670000,
		0x1D94, 0x40680000,
		0x1D94, 0x40690000,
		0x1D94, 0x406A0000,
		0x1D94, 0x406B0000,
		0x1D94, 0x406C0000,
		0x1D94, 0x406D0000,
		0x1D94, 0x406E0000,
		0x1D94, 0x406F0000,
		0x1D94, 0x40700000,
		0x1D94, 0x40710000,
		0x1D94, 0x40720000,
		0x1D94, 0x40730000,
		0x1D94, 0x40740000,
		0x1D94, 0x40750000,
		0x1D94, 0x40760000,
		0x1D94, 0x40770000,
		0x1D94, 0x40780000,
		0x1D94, 0x40790000,
		0x1D94, 0x407A0000,
		0x1D94, 0x407B0000,
		0x1D94, 0x407C0000,
		0x1D94, 0x407D0000,
		0x1D94, 0x407E0000,
		0x1D94, 0x407F0000,
		0x1D94, 0x40800000,
		0x1D94, 0x40810000,
		0x1D94, 0x40820000,
		0x1D94, 0x40830000,
		0x1D94, 0x40840000,
		0x1D94, 0x40850000,
		0x1D94, 0x40860000,
		0x1D94, 0x40870000,
		0x1D94, 0x40880000,
		0x1D94, 0x40890000,
		0x1D94, 0x408A0000,
		0x1D94, 0x408B0000,
		0x1D94, 0x408C0000,
		0x1D94, 0x408D0000,
		0x1D94, 0x408E0000,
		0x1D94, 0x408F0000,
		0x1D94, 0x40900000,
		0x1D94, 0x40910000,
		0x1D94, 0x40920000,
		0x1D94, 0x40930000,
		0x1D94, 0x40940000,
		0x1D94, 0x40950000,
		0x1D94, 0x40960000,
		0x1D94, 0x40970000,
		0x1D94, 0x40980000,
		0x1D94, 0x40990000,
		0x1D94, 0x409A0000,
		0x1D94, 0x409B0000,
		0x1D94, 0x409C0000,
		0x1D94, 0x409D0000,
		0x1D94, 0x409E0000,
		0x1D94, 0x409F0000,
		0x1D94, 0x40A00000,
		0x1D94, 0x40A10000,
		0x1D94, 0x40A20000,
		0x1D94, 0x40A30000,
		0x1D94, 0x40A40000,
		0x1D94, 0x40A50000,
		0x1D94, 0x40A60000,
		0x1D94, 0x40A70000,
		0x1D94, 0x40A80000,
		0x1D94, 0x40A90000,
		0x1D94, 0x40AA0000,
		0x1D94, 0x40AB0000,
		0x1D94, 0x40AC0000,
		0x1D94, 0x40AD0000,
		0x1D94, 0x40AE0000,
		0x1D94, 0x40AF0000,
		0x1D94, 0x40B00000,
		0x1D94, 0x40B10000,
		0x1D94, 0x40B20000,
		0x1D94, 0x40B30000,
		0x1D94, 0x40B40000,
		0x1D94, 0x40B50000,
		0x1D94, 0x40B60000,
		0x1D94, 0x40B70000,
		0x1D94, 0x40B80000,
		0x1D94, 0x40B90000,
		0x1D94, 0x40BA0000,
		0x1D94, 0x40BB0000,
		0x1D94, 0x40BC0000,
		0x1D94, 0x40BD0000,
		0x1D94, 0x40BE0000,
		0x1D94, 0x40BF0000,
		0x1D94, 0x40C00000,
		0x1D94, 0x40C10000,
		0x1D94, 0x40C20000,
		0x1D94, 0x40C30000,
		0x1D94, 0x40C40000,
		0x1D94, 0x40C50000,
		0x1D94, 0x40C60000,
		0x1D94, 0x40C70000,
		0x1D94, 0x40C80000,
		0x1D94, 0x40C90000,
		0x1D94, 0x40CA0000,
		0x1D94, 0x40CB0000,
		0x1D94, 0x40CC0000,
		0x1D94, 0x40CD0000,
		0x1D94, 0x40CE0000,
		0x1D94, 0x40CF0000,
		0x1D94, 0x40D00000,
		0x1D94, 0x40D10000,
		0x1D94, 0x40D20000,
		0x1D94, 0x40D30000,
		0x1D94, 0x40D40000,
		0x1D94, 0x40D50000,
		0x1D94, 0x40D60000,
		0x1D94, 0x40D70000,
		0x1D94, 0x40D80000,
		0x1D94, 0x40D90000,
		0x1D94, 0x40DA0000,
		0x1D94, 0x40DB0000,
		0x1D94, 0x40DC0000,
		0x1D94, 0x40DD0000,
		0x1D94, 0x40DE0000,
		0x1D94, 0x40DF0000,
		0x1D94, 0x40E00000,
		0x1D94, 0x40E10000,
		0x1D94, 0x40E20000,
		0x1D94, 0x40E30000,
		0x1D94, 0x40E40000,
		0x1D94, 0x40E50000,
		0x1D94, 0x40E60000,
		0x1D94, 0x40E70000,
		0x1D94, 0x40E80000,
		0x1D94, 0x40E90000,
		0x1D94, 0x40EA0000,
		0x1D94, 0x40EB0000,
		0x1D94, 0x40EC0000,
		0x1D94, 0x40ED0000,
		0x1D94, 0x40EE0000,
		0x1D94, 0x40EF0000,
		0x1D94, 0x40F00000,
		0x1D94, 0x40F10000,
		0x1D94, 0x40F20000,
		0x1D94, 0x40F30000,
		0x1D94, 0x40F40000,
		0x1D94, 0x40F50000,
		0x1D94, 0x40F60000,
		0x1D94, 0x40F70000,
		0x1D94, 0x40F80000,
		0x1D94, 0x40F90000,
		0x1D94, 0x40FA0000,
		0x1D94, 0x40FB0000,
		0x1D94, 0x40FC0000,
		0x1D94, 0x40FD0000,
		0x1D94, 0x40FE0000,
		0x1D94, 0x40FF0000,
		0xC0C, 0x02F1E8B7,
		0x1EE8, 0x00000000,
		0x1C38, 0x00000000,
		0x1C38, 0xF7D5005E,

};

void
odm_read_and_config_mp_8814b_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8814b_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8814b_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8814b(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8814b_phy_reg(void)
{
		return 46;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B
const u32 array_mp_8814b_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x88888888,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x68727680,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x68727680,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x80808080,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x64687276,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x80808080,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x64687276,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x76808080,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x60646872,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x68727680,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x80806064,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x76808080,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x60646872,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x80808080,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x64687276,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x80805660,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x56606468,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x88888888,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x68727680,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x68727680,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x80808080,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x64687276,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x80808080,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x64687276,
	0, 1, 3, 0x00003a24, 0xffffffff, 0x76808080,
	0, 1, 3, 0x00003a28, 0xffffffff, 0x60646872,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x68727680,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x80806064,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x76808080,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x60646872,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x80808080,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x64687276,
	0, 1, 2, 0x00003a48, 0xffffffff, 0x80805660,
	0, 1, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	0, 1, 3, 0x00003a50, 0xffffffff, 0x56606468,
	0, 2, 0, 0x00001820, 0xffffffff, 0x88888888,
	0, 2, 0, 0x00001824, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001828, 0xffffffff, 0x68727680,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001830, 0xffffffff, 0x68727680,
	0, 2, 1, 0x00001834, 0xffffffff, 0x80808080,
	0, 2, 1, 0x00001838, 0xffffffff, 0x64687276,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x80808080,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x64687276,
	0, 2, 3, 0x00003a24, 0xffffffff, 0x76808080,
	0, 2, 3, 0x00003a28, 0xffffffff, 0x60646872,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001840, 0xffffffff, 0x68727680,
	0, 2, 0, 0x00001844, 0xffffffff, 0x80806064,
	0, 2, 1, 0x00001848, 0xffffffff, 0x76808080,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x60646872,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x80808080,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x64687276,
	0, 2, 2, 0x00003a48, 0xffffffff, 0x80805660,
	0, 2, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	0, 2, 3, 0x00003a50, 0xffffffff, 0x56606468,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x88888888,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x68727680,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x68727680,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x80808080,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x64687276,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x80808080,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x64687276,
	0, 3, 3, 0x00003a24, 0xffffffff, 0x76808080,
	0, 3, 3, 0x00003a28, 0xffffffff, 0x60646872,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x68727680,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x80806064,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x76808080,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x60646872,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x80808080,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x64687276,
	0, 3, 2, 0x00003a48, 0xffffffff, 0x80805660,
	0, 3, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	0, 3, 3, 0x00003a50, 0xffffffff, 0x56606468,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x80808080,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x64687276,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x80808080,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x64687276,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x80808080,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x64687276,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x76808080,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x60646872,
	1, 0, 3, 0x00003a24, 0xffffffff, 0x76808080,
	1, 0, 3, 0x00003a28, 0xffffffff, 0x60646872,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x80808080,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x64687276,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x80805660,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x72768080,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x56606468,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x80808080,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x64687276,
	1, 0, 2, 0x00003a48, 0xffffffff, 0x80805660,
	1, 0, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	1, 0, 3, 0x00003a50, 0xffffffff, 0x56606468,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x80808080,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x64687276,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x80808080,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x64687276,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x80808080,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x64687276,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x76808080,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x60646872,
	1, 1, 3, 0x00003a24, 0xffffffff, 0x76808080,
	1, 1, 3, 0x00003a28, 0xffffffff, 0x60646872,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x80808080,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x64687276,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x80805660,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x72768080,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x56606468,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x80808080,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x64687276,
	1, 1, 2, 0x00003a48, 0xffffffff, 0x80805660,
	1, 1, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	1, 1, 3, 0x00003a50, 0xffffffff, 0x56606468,
	1, 2, 0, 0x00001824, 0xffffffff, 0x80808080,
	1, 2, 0, 0x00001828, 0xffffffff, 0x64687276,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x80808080,
	1, 2, 0, 0x00001830, 0xffffffff, 0x64687276,
	1, 2, 1, 0x00001834, 0xffffffff, 0x80808080,
	1, 2, 1, 0x00001838, 0xffffffff, 0x64687276,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x76808080,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x60646872,
	1, 2, 3, 0x00003a24, 0xffffffff, 0x76808080,
	1, 2, 3, 0x00003a28, 0xffffffff, 0x60646872,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x80808080,
	1, 2, 0, 0x00001840, 0xffffffff, 0x64687276,
	1, 2, 0, 0x00001844, 0xffffffff, 0x80805660,
	1, 2, 1, 0x00001848, 0xffffffff, 0x72768080,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x56606468,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x80808080,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x64687276,
	1, 2, 2, 0x00003a48, 0xffffffff, 0x80805660,
	1, 2, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	1, 2, 3, 0x00003a50, 0xffffffff, 0x56606468,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x80808080,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x64687276,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x80808080,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x64687276,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x80808080,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x64687276,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x76808080,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x60646872,
	1, 3, 3, 0x00003a24, 0xffffffff, 0x76808080,
	1, 3, 3, 0x00003a28, 0xffffffff, 0x60646872,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x80808080,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x64687276,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x80805660,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x72768080,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x56606468,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x80808080,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x64687276,
	1, 3, 2, 0x00003a48, 0xffffffff, 0x80805660,
	1, 3, 3, 0x00003a4c, 0xffffffff, 0x72768080,
	1, 3, 3, 0x00003a50, 0xffffffff, 0x56606468
};

#endif

void
odm_read_and_config_mp_8814b_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8814B

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8814b_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8814b_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8814b(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type1.TXT
 ******************************************************************************/

#ifdef CONFIG_8814B_TYPE1
const u32 array_mp_8814b_phy_reg_pg_type1[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x76808488,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x68727680,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x64687276,
	0, 0, 1, 0x00000c34, 0xffffffff, 0x76808080,
	0, 0, 1, 0x00000c38, 0xffffffff, 0x60646872,
	0, 0, 2, 0x00000cd8, 0xffffffff, 0x72768080,
	0, 0, 2, 0x00000cdc, 0xffffffff, 0x56606468,
	0, 0, 3, 0x00003a24, 0xffffffff, 0x68727680,
	0, 0, 3, 0x00003a28, 0xffffffff, 0x52566064,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x80808080,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x64687276,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x80805660,
	0, 0, 1, 0x00000c48, 0xffffffff, 0x68727680,
	0, 0, 1, 0x00000c4c, 0xffffffff, 0x52566064,
	0, 0, 2, 0x00000ce0, 0xffffffff, 0x72768080,
	0, 0, 2, 0x00000ce4, 0xffffffff, 0x56606468,
	0, 0, 2, 0x00003a48, 0xffffffff, 0x76804852,
	0, 0, 3, 0x00003a4c, 0xffffffff, 0x60646872,
	0, 0, 3, 0x00003a50, 0xffffffff, 0x44485256,
	0, 1, 0, 0x00000e20, 0xffffffff, 0x76808488,
	0, 1, 0, 0x00000e24, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e28, 0xffffffff, 0x68727680,
	0, 1, 0, 0x00000e2c, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e30, 0xffffffff, 0x64687276,
	0, 1, 1, 0x00000e34, 0xffffffff, 0x76808080,
	0, 1, 1, 0x00000e38, 0xffffffff, 0x60646872,
	0, 1, 2, 0x00000ed8, 0xffffffff, 0x72768080,
	0, 1, 2, 0x00000edc, 0xffffffff, 0x56606468,
	0, 1, 3, 0x00003a24, 0xffffffff, 0x68727680,
	0, 1, 3, 0x00003a28, 0xffffffff, 0x52566064,
	0, 1, 0, 0x00000e3c, 0xffffffff, 0x80808080,
	0, 1, 0, 0x00000e40, 0xffffffff, 0x64687276,
	0, 1, 0, 0x00000e44, 0xffffffff, 0x80805660,
	0, 1, 1, 0x00000e48, 0xffffffff, 0x68727680,
	0, 1, 1, 0x00000e4c, 0xffffffff, 0x52566064,
	0, 1, 2, 0x00000ee0, 0xffffffff, 0x72768080,
	0, 1, 2, 0x00000ee4, 0xffffffff, 0x56606468,
	0, 1, 2, 0x00003a48, 0xffffffff, 0x76804852,
	0, 1, 3, 0x00003a4c, 0xffffffff, 0x60646872,
	0, 1, 3, 0x00003a50, 0xffffffff, 0x44485256,
	0, 2, 0, 0x00001820, 0xffffffff, 0x76808488,
	0, 2, 0, 0x00001824, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001828, 0xffffffff, 0x68727680,
	0, 2, 0, 0x0000182c, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001830, 0xffffffff, 0x64687276,
	0, 2, 1, 0x00001834, 0xffffffff, 0x76808080,
	0, 2, 1, 0x00001838, 0xffffffff, 0x60646872,
	0, 2, 2, 0x000018d8, 0xffffffff, 0x72768080,
	0, 2, 2, 0x000018dc, 0xffffffff, 0x56606468,
	0, 2, 3, 0x00003a24, 0xffffffff, 0x68727680,
	0, 2, 3, 0x00003a28, 0xffffffff, 0x52566064,
	0, 2, 0, 0x0000183c, 0xffffffff, 0x80808080,
	0, 2, 0, 0x00001840, 0xffffffff, 0x64687276,
	0, 2, 0, 0x00001844, 0xffffffff, 0x80805660,
	0, 2, 1, 0x00001848, 0xffffffff, 0x68727680,
	0, 2, 1, 0x0000184c, 0xffffffff, 0x52566064,
	0, 2, 2, 0x000018e0, 0xffffffff, 0x72768080,
	0, 2, 2, 0x000018e4, 0xffffffff, 0x56606468,
	0, 2, 2, 0x00003a48, 0xffffffff, 0x76804852,
	0, 2, 3, 0x00003a4c, 0xffffffff, 0x60646872,
	0, 2, 3, 0x00003a50, 0xffffffff, 0x44485256,
	0, 3, 0, 0x00001a20, 0xffffffff, 0x76808488,
	0, 3, 0, 0x00001a24, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a28, 0xffffffff, 0x68727680,
	0, 3, 0, 0x00001a2c, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a30, 0xffffffff, 0x64687276,
	0, 3, 1, 0x00001a34, 0xffffffff, 0x76808080,
	0, 3, 1, 0x00001a38, 0xffffffff, 0x60646872,
	0, 3, 2, 0x00001ad8, 0xffffffff, 0x72768080,
	0, 3, 2, 0x00001adc, 0xffffffff, 0x56606468,
	0, 3, 3, 0x00003a24, 0xffffffff, 0x68727680,
	0, 3, 3, 0x00003a28, 0xffffffff, 0x52566064,
	0, 3, 0, 0x00001a3c, 0xffffffff, 0x80808080,
	0, 3, 0, 0x00001a40, 0xffffffff, 0x64687276,
	0, 3, 0, 0x00001a44, 0xffffffff, 0x80805660,
	0, 3, 1, 0x00001a48, 0xffffffff, 0x68727680,
	0, 3, 1, 0x00001a4c, 0xffffffff, 0x52566064,
	0, 3, 2, 0x00001ae0, 0xffffffff, 0x72768080,
	0, 3, 2, 0x00001ae4, 0xffffffff, 0x56606468,
	0, 3, 2, 0x00003a48, 0xffffffff, 0x76804852,
	0, 3, 3, 0x00003a4c, 0xffffffff, 0x60646872,
	0, 3, 3, 0x00003a50, 0xffffffff, 0x44485256,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x96969696,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x80848892,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x96969696,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x80848892,
	1, 0, 1, 0x00000c34, 0xffffffff, 0x96969696,
	1, 0, 1, 0x00000c38, 0xffffffff, 0x80848892,
	1, 0, 2, 0x00000cd8, 0xffffffff, 0x92969696,
	1, 0, 2, 0x00000cdc, 0xffffffff, 0x76808488,
	1, 0, 3, 0x00003a24, 0xffffffff, 0x92969696,
	1, 0, 3, 0x00003a28, 0xffffffff, 0x76808488,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x96969696,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x80848892,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x96967276,
	1, 0, 1, 0x00000c48, 0xffffffff, 0x88929696,
	1, 0, 1, 0x00000c4c, 0xffffffff, 0x72768084,
	1, 0, 2, 0x00000ce0, 0xffffffff, 0x96969696,
	1, 0, 2, 0x00000ce4, 0xffffffff, 0x80848892,
	1, 0, 2, 0x00003a48, 0xffffffff, 0x96967276,
	1, 0, 3, 0x00003a4c, 0xffffffff, 0x88929696,
	1, 0, 3, 0x00003a50, 0xffffffff, 0x72768084,
	1, 1, 0, 0x00000e24, 0xffffffff, 0x96969696,
	1, 1, 0, 0x00000e28, 0xffffffff, 0x80848892,
	1, 1, 0, 0x00000e2c, 0xffffffff, 0x96969696,
	1, 1, 0, 0x00000e30, 0xffffffff, 0x80848892,
	1, 1, 1, 0x00000e34, 0xffffffff, 0x96969696,
	1, 1, 1, 0x00000e38, 0xffffffff, 0x80848892,
	1, 1, 2, 0x00000ed8, 0xffffffff, 0x92969696,
	1, 1, 2, 0x00000edc, 0xffffffff, 0x76808488,
	1, 1, 3, 0x00003a24, 0xffffffff, 0x92969696,
	1, 1, 3, 0x00003a28, 0xffffffff, 0x76808488,
	1, 1, 0, 0x00000e3c, 0xffffffff, 0x96969696,
	1, 1, 0, 0x00000e40, 0xffffffff, 0x80848892,
	1, 1, 0, 0x00000e44, 0xffffffff, 0x96967276,
	1, 1, 1, 0x00000e48, 0xffffffff, 0x88929696,
	1, 1, 1, 0x00000e4c, 0xffffffff, 0x72768084,
	1, 1, 2, 0x00000ee0, 0xffffffff, 0x96969696,
	1, 1, 2, 0x00000ee4, 0xffffffff, 0x80848892,
	1, 1, 2, 0x00003a48, 0xffffffff, 0x96967276,
	1, 1, 3, 0x00003a4c, 0xffffffff, 0x88929696,
	1, 1, 3, 0x00003a50, 0xffffffff, 0x72768084,
	1, 2, 0, 0x00001824, 0xffffffff, 0x96969696,
	1, 2, 0, 0x00001828, 0xffffffff, 0x80848892,
	1, 2, 0, 0x0000182c, 0xffffffff, 0x96969696,
	1, 2, 0, 0x00001830, 0xffffffff, 0x80848892,
	1, 2, 1, 0x00001834, 0xffffffff, 0x96969696,
	1, 2, 1, 0x00001838, 0xffffffff, 0x80848892,
	1, 2, 2, 0x000018d8, 0xffffffff, 0x92969696,
	1, 2, 2, 0x000018dc, 0xffffffff, 0x76808488,
	1, 2, 3, 0x00003a24, 0xffffffff, 0x92969696,
	1, 2, 3, 0x00003a28, 0xffffffff, 0x76808488,
	1, 2, 0, 0x0000183c, 0xffffffff, 0x96969696,
	1, 2, 0, 0x00001840, 0xffffffff, 0x80848892,
	1, 2, 0, 0x00001844, 0xffffffff, 0x96967276,
	1, 2, 1, 0x00001848, 0xffffffff, 0x88929696,
	1, 2, 1, 0x0000184c, 0xffffffff, 0x72768084,
	1, 2, 2, 0x000018e0, 0xffffffff, 0x96969696,
	1, 2, 2, 0x000018e4, 0xffffffff, 0x80848892,
	1, 2, 2, 0x00003a48, 0xffffffff, 0x96967276,
	1, 2, 3, 0x00003a4c, 0xffffffff, 0x88929696,
	1, 2, 3, 0x00003a50, 0xffffffff, 0x72768084,
	1, 3, 0, 0x00001a24, 0xffffffff, 0x96969696,
	1, 3, 0, 0x00001a28, 0xffffffff, 0x80848892,
	1, 3, 0, 0x00001a2c, 0xffffffff, 0x96969696,
	1, 3, 0, 0x00001a30, 0xffffffff, 0x80848892,
	1, 3, 1, 0x00001a34, 0xffffffff, 0x96969696,
	1, 3, 1, 0x00001a38, 0xffffffff, 0x80848892,
	1, 3, 2, 0x00001ad8, 0xffffffff, 0x92969696,
	1, 3, 2, 0x00001adc, 0xffffffff, 0x76808488,
	1, 3, 3, 0x00003a24, 0xffffffff, 0x92969696,
	1, 3, 3, 0x00003a28, 0xffffffff, 0x76808488,
	1, 3, 0, 0x00001a3c, 0xffffffff, 0x96969696,
	1, 3, 0, 0x00001a40, 0xffffffff, 0x80848892,
	1, 3, 0, 0x00001a44, 0xffffffff, 0x96967276,
	1, 3, 1, 0x00001a48, 0xffffffff, 0x88929696,
	1, 3, 1, 0x00001a4c, 0xffffffff, 0x72768084,
	1, 3, 2, 0x00001ae0, 0xffffffff, 0x96969696,
	1, 3, 2, 0x00001ae4, 0xffffffff, 0x80848892,
	1, 3, 2, 0x00003a48, 0xffffffff, 0x96967276,
	1, 3, 3, 0x00003a4c, 0xffffffff, 0x88929696,
	1, 3, 3, 0x00003a50, 0xffffffff, 0x72768084
};

#endif

void
odm_read_and_config_mp_8814b_phy_reg_pg_type1(struct dm_struct *dm)
{
#ifdef CONFIG_8814B_TYPE1

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8814b_phy_reg_pg_type1) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8814b_phy_reg_pg_type1;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8814b(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

