/*
*  ## Please DO NOT edit this file!! ##
*  This file is auto-generated from the register source files.
*  Any modifications to this file will be LOST when it is re-generated.
*
*  ----------------------------------------------------------------
*  (c) Realtek Semiconductor Corp. 2008
*
*  This file is property of Realtek Semiconductor Corp.
*  All rights reserved.
*
*  Abstract: chip register definition and API of RTL8316D
*
*  ---------------------------------------------------------------- */

#include <rtk_types.h>
#include "rtl8316d_general_reg.h"
#include "rtl8316d_reg_struct.h"
#include "rtl8316d_table_struct.h"
#include "rtl8316d_tableField_list.h"

#define INCR         INDIRECT_CONTROL_FOR_CPU
#define INCR_EXE     EXECUTE_CPU
#define INCR_RW      ACCMD_CPU
#define INCR_TYPE    ACCTBTP_CPU
#define INCR_ADDR    ACCADDR_CPU
#define INDR_BASE    INDIRECT_DATA0_FOR_CPU

#ifndef rtlglue_printf
#ifdef __KERNEL__ 
	#ifdef CONFIG_PRINTK
		#define rtlglue_printf	printk
	#else
		#define rtlglue_printf	panic_printk
	#endif			
#else
    #define rtlglue_printf printf 
#endif
#endif

int32 table_read(uint32 unit, rtk_table_list_t table, uint32 addr, uint32 *data)
{
    uint32 reg_data = 0;
    uint32 busy = 0;
    uint32 i;

    if ((table >= TABLE_LIST_END) || (addr >= rtl8316d_table_list[table].size))
        return -1;

    reg_field_set(unit, INCR, INCR_EXE, 1, &reg_data);    /* 1 = EXECUTE */
    reg_field_set(unit, INCR, INCR_RW, 1, &reg_data);     /* 1 = READ */
    reg_field_set(unit, INCR, INCR_TYPE, rtl8316d_table_list[table].type, &reg_data);
    reg_field_set(unit, INCR, INCR_ADDR, addr, &reg_data);
    reg_write(unit, INCR, reg_data);

    do {
        reg_field_read(unit, INCR, INCR_EXE, &busy);
    } while (busy);
#ifdef RTL8316D_VERA  
#if 0
            rtlglue_printf("repeat (200) @ (posedge CLOCK);\n");
#endif
#endif  /*RTL8316D_VERA*/


    for (i=0; i<rtl8316d_table_list[table].datareg_num; i++)
    {
        reg_read(unit, INDR_BASE+i, data+i);
    }

    return SUCCESS;
}

int32 table_write(uint32 unit, rtk_table_list_t table, uint32 addr, uint32 *data)
{
    uint32 reg_data = 0;
    uint32 busy = 0;
    uint32 i;

    if ((table >= TABLE_LIST_END) || (addr >= rtl8316d_table_list[table].size))
        return -1;

#ifdef RTL8316D_TOEEPROM
    rtlglue_printf("Start writing table:\n");
    rtlglue_printf("LutType: 0x%x, ", table);
    rtlglue_printf("LutAddr: 0x%04x, ", addr);
    rtlglue_printf("Data Length: %d\n", rtl8316d_table_list[table].datareg_num);
#endif

    for (i=0; i<rtl8316d_table_list[table].datareg_num; i++)
    {    
#ifdef RTL8316D_TOEEPROM
        rtlglue_printf("data[%d]:0x%08x ", i, *(data+i));
#endif
        //rtlglue_printf("rtl8316d_setSWReg(0x%x, 0x%x);\n", REG_ADDR(1, INDR_BASE+i), *(data+i));
        reg_write(unit, INDR_BASE+i, *(data+i));
 //       rtlglue_printf("addr 0x%x, data 0x%x\n", INDR_BASE+i, *(data+i));
    }
#ifdef RTL8316D_TOEEPROM
            rtlglue_printf("\n");
#endif

    reg_field_set(unit, INCR, INCR_EXE, 1, &reg_data);    /* 1 = EXECUTE */
    reg_field_set(unit, INCR, INCR_RW, 0, &reg_data);     /* 0 = WRITE */
    //reg_field_set(unit, INCR, CPU_OCCUPY_TABLE, 1, &reg_data); /* 1 = CPU_OCCUPY */
    reg_field_set(unit, INCR, INCR_TYPE, rtl8316d_table_list[table].type, &reg_data);
    reg_field_set(unit, INCR, INCR_ADDR, addr, &reg_data);
    reg_write(unit, INCR, reg_data);


    //rtlglue_printf("rtl8316d_setSWReg(0x%x, 0x%x);\n", REG_ADDR(1, INCR), reg_data);
//    rtlglue_printf("addr 0x%x, data 0x%x\n", INCR, *(data+i));
    

    do {
        reg_field_read(unit, INCR, INCR_EXE, &busy);
       // rtlglue_printf("busy %d\n", busy);
    } while (busy);

#ifdef RTL8316D_TOEEPROM        
        rtlglue_printf("Table write success!\n\n");
#endif

#ifdef RTL8316D_FOR_TCL
    /*some delay unit is ms*/
    rtlglue_printf("\nafter 200\n");
#endif
    
#ifdef RTL8316D_VERA
        rtlglue_printf("repeat (1000) @ (posedge CLOCK);\n");
#endif  /*RTL8316D_VERA*/

    return SUCCESS;
}

rtk_table_t rtl8316d_table_list[] =
{
    {   /* table name               VLAN */
        /* access table type */     0,
        /* table size */            512,
        /* total data registers */  2,
        /* total field numbers */   7,
      //  /* table fields */          RTL8316D_VLAN_FIELDS
    },
    {   /* table name               VLAN_CAM */
        /* access table type */     1,
        /* table size */            16,
        /* total data registers */  3,
        /* total field numbers */   7,
      //  /* table fields */          RTL8316D_VLAN_CAM_FIELDS
    },
    {   /* table name               L2_TABLE */
        /* access table type */     2,
        /* table size */            8192,
        /* total data registers */  2,
        /* total field numbers */   9,
      //  /* table fields */          RTL8316D_L2_TABLE_FIELDS
    },
    {   /* table name               FORWARDING */
        /* access table type */     3,
        /* table size */            256,
        /* total data registers */  1,
        /* total field numbers */   3,
      //  /* table fields */          RTL8316D_FORWARDING_FIELDS
    },
    {   /* table name               ACTION_TABLE */
        /* access table type */     4,
        /* table size */            128,
        /* total data registers */  4,
        /* total field numbers */   13,
      //  /* table fields */          RTL8316D_ACTION_TABLE_FIELDS
    },
    {   /* table name               ACL_COUNTER */
        /* access table type */     5,
        /* table size */            128,
        /* total data registers */  2,
        /* total field numbers */   3,
      //  /* table fields */          RTL8316D_ACL_COUNTER_FIELDS
    },
    {   /* table name               POLICER */
        /* access table type */     6,
        /* table size */            128,
        /* total data registers */  2,
        /* total field numbers */   4,
      //  /* table fields */          RTL8316D_POLICER_FIELDS
    },
    {   /* table name               PIE_TABLE */
        /* access table type */     7,
        /* table size */            128,
        /* total data registers */  10,
        /* total field numbers */   19,
       // /* table fields */          RTL8316D_PIE_TABLE_FIELDS
    },
};
