/*
 * Copyright (C) 2010 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 8252 $
 * $Date: 2010-01-29 14:04:02 +0800 (??? 29 一??2010) $
 *
 * Purpose : RTK switch high-level API for RTL8367/RTL8367B
 * Feature : Here is a list of all functions and variables in this module.
 *
 */
#include <linux/config.h>
#include <rtl8367b_asicdrv_acl.h>
#include <rtl8367b_asicdrv.h>
#include <rtl8367b_asicdrv_dot1x.h>
#include <rtl8367b_asicdrv_qos.h>
#include <rtl8367b_asicdrv_scheduling.h>
#include <rtl8367b_asicdrv_fc.h>
#include <rtl8367b_asicdrv_port.h>
#include <rtl8367b_asicdrv_phy.h>
#include <rtl8367b_asicdrv_igmp.h>
#include <rtl8367b_asicdrv_unknownMulticast.h>
#include <rtl8367b_asicdrv_rma.h>
#include <rtl8367b_asicdrv_vlan.h>
#include <rtl8367b_asicdrv_lut.h>
#include <rtl8367b_asicdrv_led.h>
#include <rtl8367b_asicdrv_svlan.h>
#include <rtl8367b_asicdrv_meter.h>
#include <rtl8367b_asicdrv_inbwctrl.h>
#include <rtl8367b_asicdrv_storm.h>
#include <rtl8367b_asicdrv_misc.h>
#include <rtl8367b_asicdrv_portIsolation.h>
#include <rtl8367b_asicdrv_cputag.h>
#include <rtl8367b_asicdrv_trunking.h>
#include <rtl8367b_asicdrv_mirror.h>
#include <rtl8367b_asicdrv_mib.h>
#include <rtl8367b_asicdrv_interrupt.h>
#include <rtl8367b_asicdrv_green.h>
#include <rtl8367b_asicdrv_eee.h>
#include <rtl8367b_asicdrv_eav.h>
#include <rtl8367b_asicdrv_hsb.h>

#include <rtk_api.h>
#include <rtk_lan_wan_isolation.h>

#include <rtk_api_ext.h>
#include <rtk_error.h>
#include <string.h>

//#include <asm/rtl8198.h>

#ifdef CONFIG_RTL_ESW_CTRL_MDC_MDIO
	#define MDC_MDIO_OPERATION		1
#endif

#define REG1301_8367R_VB				0x1010
#define REG1301_8367RB					0x1000

#define DELAY_800MS_FOR_CHIP_STATABLE() {  }

rtk_uint16      (*init_para)[2];
rtk_uint16      init_size;
extern unsigned int smi_write(unsigned int mAddrs, unsigned int rData);
#define EEE_OCP_PHY_ADDR    (0xA5D0)

#if defined(CHIP_RTL8363SB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData00[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x2017, 0xA11F}, {0x2077, 0xA11F}, {0x2097, 0xA11F}
 };
/*End of ChipData00[][2]*/

rtk_uint16 ChipData01[][2]= {
/*Code of Func*/
{0x1303, 0x0778}, {0x1304, 0x7777}, {0x13E2, 0x01FE}, {0x1310, 0x1075},
{0x1305, 0x0003}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000},
{0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096},
{0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002},
{0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000},
{0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000},
{0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000},
{0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86},
{0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, {0x2000, 0x1940},
{0x2060, 0x1940}, {0x2080, 0x1940}, {0x2017, 0xA100}, {0x2077, 0xA100},
{0x2097, 0xA100}, };
/*End of ChipData01[][2]*/
#endif

#if defined(CHIP_RTL8365MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CHIP_AUTO_DETECT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData10[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x2097, 0xA11F}
 };
/*End of ChipData10[][2]*/

rtk_uint16 ChipData11[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x2080, 0x1940}, {0x2097, 0xA100},
};
/*End of ChipData11[][2]*/

rtk_uint16 ChipData12[][2]= {
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};/*End of ChipData12[][2]*/

#endif

#if defined(CHIP_RTL8367_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData20[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000},
{0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000},
{0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002},
{0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000},
{0x2057, 0x0000}, {0x205F, 0x0000}, {0x1200, 0x7FC4}, {0x0301, 0x0028},
{0x1700, 0x010E}, {0x1701, 0x0018}, {0x13EB, 0x11BB}, {0x12A4, 0x110A},
{0x12A6, 0x150A}, {0x13F1, 0x0013}, {0x13F4, 0x0010}, {0x13F5, 0x0000},
{0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00},
{0x0098, 0x0F00}, {0x12B6, 0x0C02}, {0x12B7, 0x030F}, {0x12B8, 0x11FF},
{0x12BC, 0x0004}, {0x1362, 0x0115}, {0x1363, 0x0002}, {0x1363, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0007}, {0x221E, 0x002D},
{0x2218, 0xF030}, {0x221F, 0x0007}, {0x221E, 0x0023}, {0x2216, 0x0005},
{0x2215, 0x00B9}, {0x2219, 0x0044}, {0x2215, 0x00BA}, {0x2219, 0x0020},
{0x2215, 0x00BB}, {0x2219, 0x00C1}, {0x2215, 0x0148}, {0x2219, 0x0096},
{0x2215, 0x016E}, {0x2219, 0x0026}, {0x2216, 0x0000}, {0x2216, 0x0000},
{0x221E, 0x002D}, {0x2218, 0xF010}, {0x221F, 0x0007}, {0x221E, 0x0020},
{0x2215, 0x0D00}, {0x221F, 0x0000}, {0x221F, 0x0000}, {0x2217, 0x2160},
{0x221F, 0x0001}, {0x2210, 0xF25E}, {0x221F, 0x0007}, {0x221E, 0x0042},
{0x2215, 0x0F00}, {0x2215, 0x0F00}, {0x2216, 0x7408}, {0x2215, 0x0E00},
{0x2215, 0x0F00}, {0x2215, 0x0F01}, {0x2216, 0x4000}, {0x2215, 0x0E01},
{0x2215, 0x0F01}, {0x2215, 0x0F02}, {0x2216, 0x9400}, {0x2215, 0x0E02},
{0x2215, 0x0F02}, {0x2215, 0x0F03}, {0x2216, 0x7408}, {0x2215, 0x0E03},
{0x2215, 0x0F03}, {0x2215, 0x0F04}, {0x2216, 0x4008}, {0x2215, 0x0E04},
{0x2215, 0x0F04}, {0x2215, 0x0F05}, {0x2216, 0x9400}, {0x2215, 0x0E05},
{0x2215, 0x0F05}, {0x2215, 0x0F06}, {0x2216, 0x0803}, {0x2215, 0x0E06},
{0x2215, 0x0F06}, {0x2215, 0x0D00}, {0x2215, 0x0100}, {0x221F, 0x0001},
{0x2210, 0xF05E}, {0x221F, 0x0000}, {0x2217, 0x2100}, {0x221F, 0x0000},
{0x220D, 0x0003}, {0x220E, 0x0015}, {0x220D, 0x4003}, {0x220E, 0x0006},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133F, 0x0010}, {0x12A0, 0x0058},
{0x12A1, 0x0058}, {0x133E, 0x000E}, {0x133F, 0x0030}, {0x221F, 0x0000},
{0x2210, 0x0166}, {0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0xFFF6},
{0x2206, 0x0080}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x28F7}, {0x2206, 0x00E0},
{0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602},
{0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x80B9},
{0x2206, 0xE08B}, {0x2206, 0x8CE1}, {0x2206, 0x8B8D}, {0x2206, 0x1E01},
{0x2206, 0xE18B}, {0x2206, 0x8E1E}, {0x2206, 0x01A0}, {0x2206, 0x00E7},
{0x2206, 0xAEDB}, {0x2206, 0xEEE0}, {0x2206, 0x120E}, {0x2206, 0xEEE0},
{0x2206, 0x1300}, {0x2206, 0xEEE0}, {0x2206, 0x2001}, {0x2206, 0xEEE0},
{0x2206, 0x2166}, {0x2206, 0xEEE0}, {0x2206, 0xC463}, {0x2206, 0xEEE0},
{0x2206, 0xC5E8}, {0x2206, 0xEEE0}, {0x2206, 0xC699}, {0x2206, 0xEEE0},
{0x2206, 0xC7C2}, {0x2206, 0xEEE0}, {0x2206, 0xC801}, {0x2206, 0xEEE0},
{0x2206, 0xC913}, {0x2206, 0xEEE0}, {0x2206, 0xCA30}, {0x2206, 0xEEE0},
{0x2206, 0xCB3E}, {0x2206, 0xEEE0}, {0x2206, 0xDCE1}, {0x2206, 0xEEE0},
{0x2206, 0xDD00}, {0x2206, 0xEEE2}, {0x2206, 0x0001}, {0x2206, 0xEEE2},
{0x2206, 0x0100}, {0x2206, 0xEEE4}, {0x2206, 0x8860}, {0x2206, 0xEEE4},
{0x2206, 0x8902}, {0x2206, 0xEEE4}, {0x2206, 0x8C00}, {0x2206, 0xEEE4},
{0x2206, 0x8D30}, {0x2206, 0xEEEA}, {0x2206, 0x1480}, {0x2206, 0xEEEA},
{0x2206, 0x1503}, {0x2206, 0xEEEA}, {0x2206, 0xC600}, {0x2206, 0xEEEA},
{0x2206, 0xC706}, {0x2206, 0xEE85}, {0x2206, 0xEE00}, {0x2206, 0xEE85},
{0x2206, 0xEF00}, {0x2206, 0xEE8B}, {0x2206, 0x6750}, {0x2206, 0xEE8B},
{0x2206, 0x6632}, {0x2206, 0xEE8A}, {0x2206, 0xD448}, {0x2206, 0xEE8A},
{0x2206, 0xD548}, {0x2206, 0xEE8A}, {0x2206, 0xD649}, {0x2206, 0xEE8A},
{0x2206, 0xD7F8}, {0x2206, 0xEE8B}, {0x2206, 0x85E2}, {0x2206, 0xEE8B},
{0x2206, 0x8700}, {0x2206, 0xEEFF}, {0x2206, 0xF600}, {0x2206, 0xEEFF},
{0x2206, 0xF7FC}, {0x2206, 0x04F8}, {0x2206, 0xE08B}, {0x2206, 0x8EAD},
{0x2206, 0x2023}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x8E02},
{0x2206, 0x2877}, {0x2206, 0x0225}, {0x2206, 0xC702}, {0x2206, 0x26A1},
{0x2206, 0x0281}, {0x2206, 0xB302}, {0x2206, 0x8496}, {0x2206, 0x0202},
{0x2206, 0xA102}, {0x2206, 0x27F1}, {0x2206, 0x0228}, {0x2206, 0xF902},
{0x2206, 0x2AA0}, {0x2206, 0x0282}, {0x2206, 0xB8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD21}, {0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E},
{0x2206, 0x0202}, {0x2206, 0x80E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22},
{0x2206, 0x05F6}, {0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B},
{0x2206, 0x8EE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6},
{0x2206, 0x24E4}, {0x2206, 0x8B8E}, {0x2206, 0x0227}, {0x2206, 0x6AE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B},
{0x2206, 0xF626}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x830D},
{0x2206, 0x021D}, {0x2206, 0x6BE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27},
{0x2206, 0x05F6}, {0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0281},
{0x2206, 0x4402}, {0x2206, 0x045C}, {0x2206, 0xFC04}, {0x2206, 0xF8E0},
{0x2206, 0x8B83}, {0x2206, 0xAD23}, {0x2206, 0x30E0}, {0x2206, 0xE022},
{0x2206, 0xE1E0}, {0x2206, 0x2359}, {0x2206, 0x02E0}, {0x2206, 0x85EF},
{0x2206, 0xE585}, {0x2206, 0xEFAC}, {0x2206, 0x2907}, {0x2206, 0x1F01},
{0x2206, 0x9E51}, {0x2206, 0xAD29}, {0x2206, 0x20E0}, {0x2206, 0x8B83},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD28},
{0x2206, 0x42E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD29}, {0x2206, 0x36BF}, {0x2206, 0x34BF},
{0x2206, 0x022C}, {0x2206, 0x31AE}, {0x2206, 0x2EE0}, {0x2206, 0x8B83},
{0x2206, 0xAD21}, {0x2206, 0x10E0}, {0x2206, 0x8B84}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8ADA}, {0x2206, 0x00EE},
{0x2206, 0x8ADB}, {0x2206, 0x00E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21},
{0x2206, 0x0CE0}, {0x2206, 0x8B84}, {0x2206, 0xF621}, {0x2206, 0xE48B},
{0x2206, 0x84EE}, {0x2206, 0x8B72}, {0x2206, 0xFFBF}, {0x2206, 0x34C2},
{0x2206, 0x022C}, {0x2206, 0x31FC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF},
{0x2206, 0x69E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x42E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2358}, {0x2206, 0xC059},
{0x2206, 0x021E}, {0x2206, 0x01E1}, {0x2206, 0x8B72}, {0x2206, 0x1F10},
{0x2206, 0x9E2F}, {0x2206, 0xE48B}, {0x2206, 0x72AD}, {0x2206, 0x2123},
{0x2206, 0xE18B}, {0x2206, 0x84F7}, {0x2206, 0x29E5}, {0x2206, 0x8B84},
{0x2206, 0xAC27}, {0x2206, 0x10AC}, {0x2206, 0x2605}, {0x2206, 0x0205},
{0x2206, 0x23AE}, {0x2206, 0x1602}, {0x2206, 0x0535}, {0x2206, 0x0282},
{0x2206, 0x30AE}, {0x2206, 0x0E02}, {0x2206, 0x056A}, {0x2206, 0x0282},
{0x2206, 0x75AE}, {0x2206, 0x0602}, {0x2206, 0x04DC}, {0x2206, 0x0282},
{0x2206, 0x04EF}, {0x2206, 0x96FE}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x2321}, {0x2206, 0xE0EA},
{0x2206, 0x14E1}, {0x2206, 0xEA15}, {0x2206, 0xAD26}, {0x2206, 0x18F6},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F6},
{0x2206, 0x26E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x233A}, {0x2206, 0xAD22}, {0x2206, 0x37E0}, {0x2206, 0xE020},
{0x2206, 0xE1E0}, {0x2206, 0x21AC}, {0x2206, 0x212E}, {0x2206, 0xE0EA},
{0x2206, 0x14E1}, {0x2206, 0xEA15}, {0x2206, 0xF627}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xE2EA}, {0x2206, 0x12E3},
{0x2206, 0xEA13}, {0x2206, 0x5A8F}, {0x2206, 0x6A20}, {0x2206, 0xE6EA},
{0x2206, 0x12E7}, {0x2206, 0xEA13}, {0x2206, 0xF726}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xF727}, {0x2206, 0xE4EA},
{0x2206, 0x14E5}, {0x2206, 0xEA15}, {0x2206, 0xFDFC}, {0x2206, 0x04F8},
{0x2206, 0xF9E0}, {0x2206, 0x8B87}, {0x2206, 0xAD23}, {0x2206, 0x38AD},
{0x2206, 0x2135}, {0x2206, 0xE0E0}, {0x2206, 0x20E1}, {0x2206, 0xE021},
{0x2206, 0xAC21}, {0x2206, 0x2CE0}, {0x2206, 0xEA14}, {0x2206, 0xE1EA},
{0x2206, 0x15F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA},
{0x2206, 0x15E2}, {0x2206, 0xEA12}, {0x2206, 0xE3EA}, {0x2206, 0x135A},
{0x2206, 0x8FE6}, {0x2206, 0xEA12}, {0x2206, 0xE7EA}, {0x2206, 0x13F7},
{0x2206, 0x26E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B},
{0x2206, 0x86AD}, {0x2206, 0x2146}, {0x2206, 0xE0E0}, {0x2206, 0x22E1},
{0x2206, 0xE023}, {0x2206, 0x58C0}, {0x2206, 0x5902}, {0x2206, 0x1E01},
{0x2206, 0xE18B}, {0x2206, 0x651F}, {0x2206, 0x109E}, {0x2206, 0x33E4},
{0x2206, 0x8B65}, {0x2206, 0xAD21}, {0x2206, 0x22AD}, {0x2206, 0x272A},
{0x2206, 0xD400}, {0x2206, 0x01BF}, {0x2206, 0x34F2}, {0x2206, 0x022C},
{0x2206, 0xA2BF}, {0x2206, 0x34F5}, {0x2206, 0x022C}, {0x2206, 0xE0E0},
{0x2206, 0x8B67}, {0x2206, 0x1B10}, {0x2206, 0xAA14}, {0x2206, 0xE18B},
{0x2206, 0x660D}, {0x2206, 0x1459}, {0x2206, 0x0FAE}, {0x2206, 0x05E1},
{0x2206, 0x8B66}, {0x2206, 0x590F}, {0x2206, 0xBF85}, {0x2206, 0x6102},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xF9FA}, {0x2206, 0xFBEF}, {0x2206, 0x79E2}, {0x2206, 0x8AD2},
{0x2206, 0xAC19}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37EF}, {0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x019E},
{0x2206, 0x1F7A}, {0x2206, 0x0159}, {0x2206, 0x019F}, {0x2206, 0x0ABF},
{0x2206, 0x348E}, {0x2206, 0x022C}, {0x2206, 0x31F6}, {0x2206, 0x06AE},
{0x2206, 0x0FF6}, {0x2206, 0x0302}, {0x2206, 0x0470}, {0x2206, 0xF703},
{0x2206, 0xF706}, {0x2206, 0xBF34}, {0x2206, 0x9302}, {0x2206, 0x2C31},
{0x2206, 0xAC1A}, {0x2206, 0x25E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x23EF}, {0x2206, 0x300D}, {0x2206, 0x311F}, {0x2206, 0x325B},
{0x2206, 0x029E}, {0x2206, 0x157A}, {0x2206, 0x0258}, {0x2206, 0xC4A0},
{0x2206, 0x0408}, {0x2206, 0xBF34}, {0x2206, 0x9E02}, {0x2206, 0x2C31},
{0x2206, 0xAE06}, {0x2206, 0xBF34}, {0x2206, 0x9C02}, {0x2206, 0x2C31},
{0x2206, 0xAC1B}, {0x2206, 0x4AE0}, {0x2206, 0xE012}, {0x2206, 0xE1E0},
{0x2206, 0x13EF}, {0x2206, 0x300D}, {0x2206, 0x331F}, {0x2206, 0x325B},
{0x2206, 0x1C9E}, {0x2206, 0x3AEF}, {0x2206, 0x325B}, {0x2206, 0x1C9F},
{0x2206, 0x09BF}, {0x2206, 0x3498}, {0x2206, 0x022C}, {0x2206, 0x3102},
{0x2206, 0x83C5}, {0x2206, 0x5A03}, {0x2206, 0x0D03}, {0x2206, 0x581C},
{0x2206, 0x1E20}, {0x2206, 0x0207}, {0x2206, 0xA0A0}, {0x2206, 0x000E},
{0x2206, 0x0284}, {0x2206, 0x17AD}, {0x2206, 0x1817}, {0x2206, 0xBF34},
{0x2206, 0x9A02}, {0x2206, 0x2C31}, {0x2206, 0xAE0F}, {0x2206, 0xBF34},
{0x2206, 0xC802}, {0x2206, 0x2C31}, {0x2206, 0xBF34}, {0x2206, 0xC502},
{0x2206, 0x2C31}, {0x2206, 0x0284}, {0x2206, 0x52E6}, {0x2206, 0x8AD2},
{0x2206, 0xEF97}, {0x2206, 0xFFFE}, {0x2206, 0xFDFC}, {0x2206, 0x04F8},
{0x2206, 0xBF34}, {0x2206, 0xDA02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xD3BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xE00C},
{0x2206, 0x1159}, {0x2206, 0x02E0}, {0x2206, 0x8AD3}, {0x2206, 0x1E01},
{0x2206, 0xE48A}, {0x2206, 0xD3D1}, {0x2206, 0x00BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2D1}, {0x2206, 0x01BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34CB}, {0x2206, 0x022C},
{0x2206, 0xE0E5}, {0x2206, 0x8ACE}, {0x2206, 0xBF85}, {0x2206, 0x6702},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xCFBF}, {0x2206, 0x8564},
{0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8AD0}, {0x2206, 0xBF85},
{0x2206, 0x6A02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD1FC},
{0x2206, 0x04F8}, {0x2206, 0xE18A}, {0x2206, 0xD1BF}, {0x2206, 0x856A},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD0}, {0x2206, 0xBF85},
{0x2206, 0x6402}, {0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xCFBF},
{0x2206, 0x8567}, {0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8ACE},
{0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xE18A},
{0x2206, 0xD3BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD3}, {0x2206, 0x0D11}, {0x2206, 0xBF34}, {0x2206, 0xD402},
{0x2206, 0x2CA2}, {0x2206, 0xFC04}, {0x2206, 0xF9A0}, {0x2206, 0x0405},
{0x2206, 0xE38A}, {0x2206, 0xD4AE}, {0x2206, 0x13A0}, {0x2206, 0x0805},
{0x2206, 0xE38A}, {0x2206, 0xD5AE}, {0x2206, 0x0BA0}, {0x2206, 0x0C05},
{0x2206, 0xE38A}, {0x2206, 0xD6AE}, {0x2206, 0x03E3}, {0x2206, 0x8AD7},
{0x2206, 0xEF13}, {0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D11}, {0x2206, 0xBF85}, {0x2206, 0x6702},
{0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D14}, {0x2206, 0xBF85},
{0x2206, 0x6402}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D17},
{0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CA2}, {0x2206, 0xFD04},
{0x2206, 0xF8E0}, {0x2206, 0x8B85}, {0x2206, 0xAD27}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37E1}, {0x2206, 0x8B73},
{0x2206, 0x1F10}, {0x2206, 0x9E20}, {0x2206, 0xE48B}, {0x2206, 0x73AC},
{0x2206, 0x200B}, {0x2206, 0xAC21}, {0x2206, 0x0DAC}, {0x2206, 0x250F},
{0x2206, 0xAC27}, {0x2206, 0x0EAE}, {0x2206, 0x0F02}, {0x2206, 0x84CC},
{0x2206, 0xAE0A}, {0x2206, 0x0284}, {0x2206, 0xD1AE}, {0x2206, 0x05AE},
{0x2206, 0x0302}, {0x2206, 0x84D8}, {0x2206, 0xFC04}, {0x2206, 0xEE8B},
{0x2206, 0x6800}, {0x2206, 0x0402}, {0x2206, 0x84E5}, {0x2206, 0x0285},
{0x2206, 0x2804}, {0x2206, 0x0285}, {0x2206, 0x4904}, {0x2206, 0xEE8B},
{0x2206, 0x6800}, {0x2206, 0xEE8B}, {0x2206, 0x6902}, {0x2206, 0x04F8},
{0x2206, 0xF9E0}, {0x2206, 0x8B85}, {0x2206, 0xAD26}, {0x2206, 0x38D0},
{0x2206, 0x0B02}, {0x2206, 0x2B4D}, {0x2206, 0x5882}, {0x2206, 0x7882},
{0x2206, 0x9F2D}, {0x2206, 0xE08B}, {0x2206, 0x68E1}, {0x2206, 0x8B69},
{0x2206, 0x1F10}, {0x2206, 0x9EC8}, {0x2206, 0x10E4}, {0x2206, 0x8B68},
{0x2206, 0xE0E0}, {0x2206, 0x00E1}, {0x2206, 0xE001}, {0x2206, 0xF727},
{0x2206, 0xE4E0}, {0x2206, 0x00E5}, {0x2206, 0xE001}, {0x2206, 0xE2E0},
{0x2206, 0x20E3}, {0x2206, 0xE021}, {0x2206, 0xAD30}, {0x2206, 0xF7F6},
{0x2206, 0x27E4}, {0x2206, 0xE000}, {0x2206, 0xE5E0}, {0x2206, 0x01FD},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B},
{0x2206, 0x86AD}, {0x2206, 0x2212}, {0x2206, 0xE0E0}, {0x2206, 0x14E1},
{0x2206, 0xE015}, {0x2206, 0xAD26}, {0x2206, 0x9CE1}, {0x2206, 0x85E0},
{0x2206, 0xBF85}, {0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0},
{0x2206, 0x8B86}, {0x2206, 0xAD22}, {0x2206, 0x09E1}, {0x2206, 0x85E1},
{0x2206, 0xBF85}, {0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x0464}, {0x2206, 0xE48C}, {0x2206, 0xFDE4},
{0x2206, 0x80CA}, {0x2206, 0xE480}, {0x2206, 0x66E0}, {0x2206, 0x8E70},
{0x2206, 0xE076}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}
};
/*End of ChipData20[][2]*/

rtk_uint16 ChipData21[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x0201, 0x0064}, {0x0202, 0x0064}, {0x0203, 0x0096}, {0x0204, 0x0096},
{0x0205, 0x0096}, {0x0206, 0x0096}, {0x0207, 0x0096}, {0x1B03, 0x0876},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x1200, 0x7FC4},
{0x13EB, 0x11BB}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData21[][2]*/

#endif

#if defined(CHIP_RTL8367RB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData30[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x13E0, 0x0010}
};
/*End of ChipData30[][2]*/
#endif

#if defined(CONFIG_SW_8367R) || defined(CHIP_RTL8367RB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367R_SUPPORT)
rtk_uint16 ChipData31[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13E0, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData21[][2]*/

rtk_uint16 ChipData32[][2]= {
/*Code of Func*/
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};/*End of ChipData32[][2]*/
#endif

#if defined(CHIP_RTL8367R_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData40[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}
};
/*End of ChipData40[][2]*/
#endif

#if defined(CONFIG_SW_8367R) || defined(CHIP_RTL8367R_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367R_SUPPORT)
rtk_uint16 ChipData41[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22},
{0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340},
{0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData41[][2]*/

#endif

#if defined(CONFIG_RTL_8367MB_SUPPORT) || defined(CHIP_RTL8367MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST) || defined(CONFIG_RTL_8367MB_SUPPORT)
rtk_uint16 ChipData50[][2]= { };

rtk_uint16 ChipData51[][2]= {
/*Code of Func*/
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86},
{0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x1B03, 0x0876}, {0x1200, 0x7FC4},
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00},
{0x0098, 0x0F00}, {0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000},
{0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000},
{0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002},
{0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000},
{0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000},
{0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0xFFF6},
{0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x2BF7},
{0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE},
{0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602},
{0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0}, {0x2206, 0x8B8C},
{0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1}, {0x2206, 0x8B8E},
{0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE}, {0x2206, 0xD8EE},
{0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00EE},
{0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD}, {0x2206, 0x73EE},
{0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7}, {0x2206, 0xFC04},
{0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20}, {0x2206, 0x0302},
{0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B},
{0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A}, {0x2206, 0xE4E1},
{0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E}, {0x2206, 0x35EE},
{0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5}, {0x2206, 0x00E0},
{0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2}, {0x2206, 0x85C0},
{0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC}, {0x2206, 0xAD20},
{0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE}, {0x2206, 0x8AE5},
{0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685}, {0x2206, 0xC0E7},
{0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85}, {0x2206, 0xC000},
{0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC}, {0x2206, 0x0400},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData51[][2]*/
#endif

#if defined(CHIP_RTL8367M_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData60[][2]= {
/*Code of Func*/
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026},
{0x1722, 0x0E14}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080},
{0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B},
{0x2206, 0x8CE1}, {0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B},
{0x2206, 0x8E1E}, {0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB},
{0x2206, 0xEEE0}, {0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300},
{0x2206, 0xEEE0}, {0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166},
{0x2206, 0xEEE0}, {0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8},
{0x2206, 0xEEE0}, {0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2},
{0x2206, 0xEEE0}, {0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913},
{0x2206, 0xEEE0}, {0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E},
{0x2206, 0xEEE0}, {0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00},
{0x2206, 0xEEE2}, {0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100},
{0x2206, 0xEEE4}, {0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902},
{0x2206, 0xEEE4}, {0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30},
{0x2206, 0xEEEA}, {0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503},
{0x2206, 0xEEEA}, {0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706},
{0x2206, 0xEE85}, {0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00},
{0x2206, 0xEE8B}, {0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632},
{0x2206, 0xEE8A}, {0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548},
{0x2206, 0xEE8A}, {0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8},
{0x2206, 0xEE8B}, {0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700},
{0x2206, 0xEEFF}, {0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC},
{0x2206, 0x04F8}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023},
{0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877},
{0x2206, 0x0225}, {0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281},
{0x2206, 0xB302}, {0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102},
{0x2206, 0x27F1}, {0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0},
{0x2206, 0x0282}, {0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21},
{0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202},
{0x2206, 0x80E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6},
{0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD},
{0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4},
{0x2206, 0x8B8E}, {0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D},
{0x2206, 0x6BE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6},
{0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402},
{0x2206, 0x045C}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83},
{0x2206, 0xAD23}, {0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2359}, {0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585},
{0x2206, 0xEFAC}, {0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51},
{0x2206, 0xAD29}, {0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21},
{0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84},
{0x2206, 0xAD29}, {0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C},
{0x2206, 0x31AE}, {0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21},
{0x2206, 0x10E0}, {0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B},
{0x2206, 0x84EE}, {0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB},
{0x2206, 0x00E0}, {0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0},
{0x2206, 0x8B84}, {0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8B72}, {0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C},
{0x2206, 0x31FC}, {0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022},
{0x2206, 0xE1E0}, {0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E},
{0x2206, 0x01E1}, {0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F},
{0x2206, 0xE48B}, {0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B},
{0x2206, 0x84F7}, {0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27},
{0x2206, 0x10AC}, {0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE},
{0x2206, 0x1602}, {0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE},
{0x2206, 0x0E02}, {0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE},
{0x2206, 0x0602}, {0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF},
{0x2206, 0x96FE}, {0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B},
{0x2206, 0x87AD}, {0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1},
{0x2206, 0xEA15}, {0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A},
{0x2206, 0xAD22}, {0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0},
{0x2206, 0x21AC}, {0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1},
{0x2206, 0xEA15}, {0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13},
{0x2206, 0x5A8F}, {0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7},
{0x2206, 0xEA13}, {0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5},
{0x2206, 0xEA15}, {0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0},
{0x2206, 0x8B87}, {0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135},
{0x2206, 0xE0E0}, {0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21},
{0x2206, 0x2CE0}, {0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6},
{0x2206, 0x27E4}, {0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2},
{0x2206, 0xEA12}, {0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6},
{0x2206, 0xEA12}, {0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04},
{0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD},
{0x2206, 0x2146}, {0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023},
{0x2206, 0x58C0}, {0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B},
{0x2206, 0x651F}, {0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65},
{0x2206, 0xAD21}, {0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400},
{0x2206, 0x01BF}, {0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34F5}, {0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67},
{0x2206, 0x1B10}, {0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D},
{0x2206, 0x1459}, {0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66},
{0x2206, 0x590F}, {0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2},
{0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA},
{0x2206, 0xFBEF}, {0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19},
{0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A},
{0x2206, 0x0159}, {0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E},
{0x2206, 0x022C}, {0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6},
{0x2206, 0x0302}, {0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706},
{0x2206, 0xBF34}, {0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A},
{0x2206, 0x25E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF},
{0x2206, 0x300D}, {0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E},
{0x2206, 0x157A}, {0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408},
{0x2206, 0xBF34}, {0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06},
{0x2206, 0xBF34}, {0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B},
{0x2206, 0x4AE0}, {0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF},
{0x2206, 0x300D}, {0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E},
{0x2206, 0x3AEF}, {0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF},
{0x2206, 0x3498}, {0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5},
{0x2206, 0x5A03}, {0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20},
{0x2206, 0x0207}, {0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284},
{0x2206, 0x17AD}, {0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02},
{0x2206, 0x2C31}, {0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802},
{0x2206, 0x2C31}, {0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31},
{0x2206, 0x0284}, {0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97},
{0x2206, 0xFFFE}, {0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34},
{0x2206, 0xDA02}, {0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF},
{0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159},
{0x2206, 0x02E0}, {0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A},
{0x2206, 0xD3D1}, {0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C},
{0x2206, 0xA2D1}, {0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C},
{0x2206, 0xA2BF}, {0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8ACE}, {0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C},
{0x2206, 0xE0E5}, {0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8},
{0x2206, 0xE18A}, {0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF},
{0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3},
{0x2206, 0x0D11}, {0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2},
{0x2206, 0xFC04}, {0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A},
{0x2206, 0xD4AE}, {0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A},
{0x2206, 0xD5AE}, {0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A},
{0x2206, 0xD6AE}, {0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13},
{0x2206, 0xBF34}, {0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D11}, {0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402},
{0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85},
{0x2206, 0x6A02}, {0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0},
{0x2206, 0x8B85}, {0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036},
{0x2206, 0xE1E0}, {0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10},
{0x2206, 0x9E20}, {0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B},
{0x2206, 0xAC21}, {0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27},
{0x2206, 0x0EAE}, {0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A},
{0x2206, 0x0284}, {0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302},
{0x2206, 0x84D8}, {0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800},
{0x2206, 0x0402}, {0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804},
{0x2206, 0x0285}, {0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800},
{0x2206, 0xEE8B}, {0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0},
{0x2206, 0x8B85}, {0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02},
{0x2206, 0x2B4D}, {0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D},
{0x2206, 0xE08B}, {0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10},
{0x2206, 0x9EC8}, {0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0},
{0x2206, 0x00E1}, {0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0},
{0x2206, 0x00E5}, {0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3},
{0x2206, 0xE021}, {0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4},
{0x2206, 0xE000}, {0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04},
{0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD},
{0x2206, 0x2212}, {0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015},
{0x2206, 0xAD26}, {0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85},
{0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86},
{0x2206, 0xAD22}, {0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85},
{0x2206, 0x6D02}, {0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x0464}, {0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA},
{0x2206, 0xE480}, {0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}
};
/*End of ChipData60[][2]*/

rtk_uint16 ChipData61[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0018, 0x0F00},
{0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData61[][2]*/

#endif

#if defined(CHIP_RTL8368MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData70[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}
};
/*End of ChipData70[][2]*/

rtk_uint16 ChipData71[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, };
/*End of ChipData71[][2]*/

#endif

#if defined(CHIP_RTL8305MB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT) || defined(CHIP_AUTO_DETECT) || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData80[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2209, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x2097, 0xA11F}
};
/*End of ChipData80[][2]*/

rtk_uint16 ChipData81[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x800E},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200}, {0x6107, 0xE58B},
{0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000}, {0x220F, 0x0100},
{0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201}, {0x2206, 0x7CE0},
{0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E}, {0x2206, 0x01E1},
{0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000}, {0x2206, 0xE4AE},
{0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE}, {0x2206, 0x85C1},
{0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE}, {0x2206, 0x8AFD},
{0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20},
{0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100}, {0x2206, 0xFDFC},
{0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140},
{0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000}, {0x133E, 0x000E},
{0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0000},
{0x2209, 0x0C00}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x2200, 0x1340}, {0x133F, 0x0010}, {0x13EB, 0x11BB},
{0x207F, 0x0002}, {0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x2080, 0x1940}, {0x2097, 0xA100}, };
/*End of ChipData81[][2]*/
#endif

#if defined(CHIP_RTL8307M_VB) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData90[][2]= {
/*Code of Func*/
};
/*End of ChipData90[][2]*/

rtk_uint16 ChipData91[][2]= {
/*Code of Func*/
{0x1305, 0xC000}, {0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064},
{0x1237, 0x0096}, {0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030},
{0x1B00, 0x14F1}, {0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x0018, 0x0F00},
{0x0038, 0x0F00}, {0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005},
{0x2205, 0x8B86}, {0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010},
{0x12A3, 0x2200}, {0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x201F, 0x0000}, {0x2009, 0x0C00},
{0x201F, 0x0000}, {0x203F, 0x0000}, {0x2029, 0x0C00}, {0x203F, 0x0000},
{0x205F, 0x0000}, {0x2049, 0x0C00}, {0x205F, 0x0000}, {0x207F, 0x0000},
{0x2069, 0x0C00}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, };
/*End of ChipData91[][2]*/

#endif

#if defined(CHIP_RTL8367N) || defined(RTK_X86_ASICDRV) || defined(RTK_ASICDRV_INIT)  || defined(CONFIG_RTL8367B_ASICDRV_TEST)
rtk_uint16 ChipData100[][2]= {
/*Code of Func*/
};
/*End of ChipData100[][2]*/

rtk_uint16 ChipData101[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC4}, {0x1305, 0xC000}, {0x121E, 0x03CA},
{0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096}, {0x1238, 0x0078},
{0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002}, {0x2059, 0x1A00},
{0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000}, {0x2078, 0x0000},
{0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000}, {0x207F, 0x0000},
{0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000}, {0x2055, 0x0000},
{0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002C}, {0x2219, 0x0504}, {0x221F, 0x0000},
{0x133F, 0x0010}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1940}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x221F, 0x0007},
{0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007}, {0x221E, 0x0023},
{0x2216, 0x0005}, {0x2215, 0x0095}, {0x2219, 0x001A}, {0x2215, 0x009A},
{0x2219, 0x0017}, {0x2215, 0x009D}, {0x2219, 0x000E}, {0x2215, 0x009F},
{0x2219, 0x0003}, {0x2215, 0x00A2}, {0x2219, 0x0050}, {0x2215, 0x00A3},
{0x2219, 0x0081}, {0x2215, 0x00A4}, {0x2219, 0x00BC}, {0x2215, 0x00A5},
{0x2219, 0x001B}, {0x2215, 0x00A6}, {0x2219, 0x00EE}, {0x2215, 0x00A7},
{0x2219, 0x00A4}, {0x2215, 0x00A8}, {0x2219, 0x002B}, {0x2215, 0x00A9},
{0x2219, 0x00EB}, {0x2215, 0x00AA}, {0x2219, 0x00C7}, {0x2215, 0x00AB},
{0x2219, 0x0050}, {0x2215, 0x00AC}, {0x2219, 0x0080}, {0x2215, 0x00AD},
{0x2219, 0x00E0}, {0x2215, 0x00AE}, {0x2219, 0x0094}, {0x2215, 0x00AF},
{0x2219, 0x00E0}, {0x2215, 0x00B0}, {0x2219, 0x0000}, {0x2215, 0x00B1},
{0x2219, 0x0044}, {0x2215, 0x00B2}, {0x2219, 0x0021}, {0x2215, 0x00B3},
{0x2219, 0x0044}, {0x2215, 0x00B4}, {0x2219, 0x0020}, {0x2215, 0x00B5},
{0x2219, 0x0094}, {0x2215, 0x00B6}, {0x2219, 0x00FF}, {0x2215, 0x00B7},
{0x2219, 0x004A}, {0x2215, 0x00B8}, {0x2219, 0x0001}, {0x2215, 0x00B9},
{0x2219, 0x002A}, {0x2215, 0x00BA}, {0x2219, 0x0094}, {0x2215, 0x00BB},
{0x2219, 0x007F}, {0x2215, 0x0171}, {0x2219, 0x004B}, {0x2215, 0x0172},
{0x2219, 0x0019}, {0x2215, 0x0174}, {0x2219, 0x0041}, {0x2215, 0x0175},
{0x2219, 0x0039}, {0x2215, 0x0178}, {0x2219, 0x0079}, {0x2215, 0x017E},
{0x2219, 0x009C}, {0x2215, 0x018F}, {0x2219, 0x0071}, {0x2215, 0x0192},
{0x2219, 0x0079}, {0x2215, 0x0197}, {0x2219, 0x0079}, {0x2215, 0x01AD},
{0x2219, 0x009D}, {0x2215, 0x01B4}, {0x2219, 0x009C}, {0x2215, 0x01C0},
{0x2219, 0x0042}, {0x2215, 0x01C1}, {0x2219, 0x0037}, {0x2215, 0x01C2},
{0x2219, 0x00E1}, {0x2215, 0x01C3}, {0x2219, 0x00D7}, {0x2215, 0x01C4},
{0x2219, 0x00E1}, {0x2215, 0x01C5}, {0x2219, 0x00D7}, {0x2215, 0x01C6},
{0x2219, 0x00E1}, {0x2215, 0x01C7}, {0x2219, 0x00D7}, {0x2215, 0x01C8},
{0x2219, 0x00E1}, {0x2215, 0x01C9}, {0x2219, 0x00D7}, {0x2215, 0x01CA},
{0x2219, 0x00E1}, {0x2215, 0x01CB}, {0x2219, 0x00D7}, {0x2215, 0x01CC},
{0x2219, 0x00E1}, {0x2215, 0x01CD}, {0x2219, 0x00D7}, {0x2215, 0x01CE},
{0x2219, 0x00E1}, {0x2215, 0x01CF}, {0x2219, 0x00D7}, {0x2215, 0x01D0},
{0x2219, 0x00E1}, {0x2215, 0x01D1}, {0x2219, 0x00D7}, {0x2215, 0x01D2},
{0x2219, 0x00E1}, {0x2215, 0x01D3}, {0x2219, 0x00D7}, {0x2215, 0x01D4},
{0x2219, 0x00E1}, {0x2215, 0x01D5}, {0x2219, 0x00D7}, {0x2215, 0x01D6},
{0x2219, 0x00C1}, {0x2215, 0x01D7}, {0x2219, 0x009D}, {0x2215, 0x01D8},
{0x2219, 0x0095}, {0x2215, 0x01D9}, {0x2219, 0x009E}, {0x2215, 0x01DA},
{0x2219, 0x009A}, {0x2215, 0x01DB}, {0x2219, 0x0089}, {0x2215, 0x01DC},
{0x2219, 0x007B}, {0x2215, 0x01DD}, {0x2219, 0x00A4}, {0x2215, 0x01DE},
{0x2219, 0x002B}, {0x2215, 0x01DF}, {0x2219, 0x00F8}, {0x2215, 0x01E0},
{0x2219, 0x00A2}, {0x2215, 0x01E1}, {0x2219, 0x001C}, {0x2215, 0x01E2},
{0x2219, 0x0009}, {0x2215, 0x01E3}, {0x2219, 0x00E0}, {0x2215, 0x01E4},
{0x2219, 0x0081}, {0x2215, 0x01E5}, {0x2219, 0x00E0}, {0x2215, 0x01E6},
{0x2219, 0x0081}, {0x2215, 0x01E7}, {0x2219, 0x00E0}, {0x2215, 0x01E8},
{0x2219, 0x0081}, {0x2215, 0x01E9}, {0x2219, 0x00E0}, {0x2215, 0x01EA},
{0x2219, 0x0081}, {0x2215, 0x01F3}, {0x2219, 0x00D7}, {0x2216, 0x0000},
{0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0004}, {0x221F, 0x0000},
{0x2217, 0x2160}, {0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0874},
{0x2219, 0x8C00}, {0x2218, 0x08A4}, {0x2219, 0x4000}, {0x2218, 0x08B4},
{0x2219, 0x0400}, {0x2218, 0x08C4}, {0x2219, 0xFF00}, {0x2218, 0x08D4},
{0x2219, 0x0500}, {0x2218, 0x08E4}, {0x2219, 0x8500}, {0x2218, 0x08F4},
{0x2219, 0x8C00}, {0x2218, 0x0904}, {0x2219, 0xFA00}, {0x2218, 0x0914},
{0x2219, 0xE000}, {0x2218, 0x0924}, {0x2219, 0x0000}, {0x2218, 0x0934},
{0x2219, 0x4000}, {0x2218, 0x0944}, {0x2219, 0x4400}, {0x2218, 0x0954},
{0x2219, 0x5400}, {0x2218, 0x0964}, {0x2219, 0xFF00}, {0x2218, 0x0994},
{0x2219, 0x1400}, {0x2218, 0x0A84}, {0x2219, 0x1400}, {0x2218, 0x0B84},
{0x2219, 0x1400}, {0x2218, 0x1944}, {0x2219, 0x8C00}, {0x2218, 0x1974},
{0x2219, 0x4000}, {0x2218, 0x1984}, {0x2219, 0x0400}, {0x2218, 0x1994},
{0x2219, 0xFF00}, {0x2218, 0x19A4}, {0x2219, 0x0500}, {0x2218, 0x19B4},
{0x2219, 0x8500}, {0x2218, 0x19C4}, {0x2219, 0x8C00}, {0x2218, 0x19D4},
{0x2219, 0xFA00}, {0x2218, 0x19E4}, {0x2219, 0xE000}, {0x2218, 0x19F4},
{0x2219, 0x0000}, {0x2218, 0x1A04}, {0x2219, 0x4000}, {0x2218, 0x1A14},
{0x2219, 0x4400}, {0x2218, 0x1A24}, {0x2219, 0x5400}, {0x2218, 0x1A34},
{0x2219, 0xFF00}, {0x2218, 0x1A64}, {0x2219, 0x1400}, {0x2218, 0x1B54},
{0x2219, 0x1400}, {0x2218, 0x1C54}, {0x2219, 0x1400}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0007}, {0x221E, 0x0040}, {0x2218, 0x0000},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x221F, 0x0000},
{0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E}, {0x221F, 0x0007},
{0x221E, 0x0042}, {0x2215, 0x0F02}, {0x2216, 0x9406}, {0x2215, 0x0E02},
{0x2215, 0x0F02}, {0x2215, 0x0F06}, {0x2216, 0x950A}, {0x2215, 0x0E06},
{0x2215, 0x0F06}, {0x2215, 0x0F07}, {0x2216, 0x7408}, {0x2215, 0x0E07},
{0x2215, 0x0F07}, {0x2215, 0x0F08}, {0x2216, 0x5808}, {0x2215, 0x0E08},
{0x2215, 0x0F08}, {0x2215, 0x0F09}, {0x2216, 0x080C}, {0x2215, 0x0E09},
{0x2215, 0x0F09}, {0x2215, 0x0F0A}, {0x2216, 0x7408}, {0x2215, 0x0E0A},
{0x2215, 0x0F0A}, {0x2215, 0x0F0B}, {0x2216, 0x5800}, {0x2215, 0x0E0B},
{0x2215, 0x0F0B}, {0x2215, 0x0F0C}, {0x2216, 0x9400}, {0x2215, 0x0E0C},
{0x2215, 0x0F0C}, {0x2215, 0x0F0D}, {0x2216, 0x0803}, {0x2215, 0x0E0D},
{0x2215, 0x0F0D}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0007},
{0x221E, 0x0042}, {0x2215, 0x0D00}, {0x2215, 0x0100}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0005}, {0x2205, 0x8000}, {0x2206, 0x0280}, {0x2206, 0x28F7},
{0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080}, {0x2206, 0x02AE},
{0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201}, {0x2206, 0x6602},
{0x2206, 0x8074}, {0x2206, 0xE08B}, {0x2206, 0x8CE1}, {0x2206, 0x8B8D},
{0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E}, {0x2206, 0x01A0},
{0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEE85}, {0x2206, 0xDE00},
{0x2206, 0xEE85}, {0x2206, 0xDF00}, {0x2206, 0xEE8A}, {0x2206, 0xFC07},
{0x2206, 0xEE8A}, {0x2206, 0xFD73}, {0x2206, 0xD483}, {0x2206, 0x83E4},
{0x2206, 0x8B92}, {0x2206, 0xE58B}, {0x2206, 0x93D4}, {0x2206, 0x837A},
{0x2206, 0xE48B}, {0x2206, 0x94E5}, {0x2206, 0x8B95}, {0x2206, 0xD483},
{0x2206, 0x71E4}, {0x2206, 0x8B96}, {0x2206, 0xE58B}, {0x2206, 0x97EE},
{0x2206, 0xE144}, {0x2206, 0x77EE}, {0x2206, 0xE145}, {0x2206, 0x85EE},
{0x2206, 0xE150}, {0x2206, 0xFFEE}, {0x2206, 0xE151}, {0x2206, 0xFEEE},
{0x2206, 0x8B82}, {0x2206, 0x85EE}, {0x2206, 0x8B87}, {0x2206, 0x80EE},
{0x2206, 0xFFF6}, {0x2206, 0x00EE}, {0x2206, 0xFFF7}, {0x2206, 0xFE04},
{0x2206, 0xF8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD20}, {0x2206, 0x26F6},
{0x2206, 0x20E4}, {0x2206, 0x8B8E}, {0x2206, 0x0229}, {0x2206, 0x2102},
{0x2206, 0x2671}, {0x2206, 0x0227}, {0x2206, 0x4B02}, {0x2206, 0x8155},
{0x2206, 0x0282}, {0x2206, 0x3302}, {0x2206, 0x02B0}, {0x2206, 0x0228},
{0x2206, 0x9B02}, {0x2206, 0x8102}, {0x2206, 0x0229}, {0x2206, 0xFB02},
{0x2206, 0x2BA2}, {0x2206, 0x0229}, {0x2206, 0x91E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD21}, {0x2206, 0x08F6}, {0x2206, 0x21E4}, {0x2206, 0x8B8E},
{0x2206, 0x0202}, {0x2206, 0x8FE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD22},
{0x2206, 0x05F6}, {0x2206, 0x22E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x2305}, {0x2206, 0xF623}, {0x2206, 0xE48B},
{0x2206, 0x8EE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD24}, {0x2206, 0x08F6},
{0x2206, 0x24E4}, {0x2206, 0x8B8E}, {0x2206, 0x0228}, {0x2206, 0x14E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD25}, {0x2206, 0x05F6}, {0x2206, 0x25E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x260B},
{0x2206, 0xF626}, {0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x069E},
{0x2206, 0x021E}, {0x2206, 0x15E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD27},
{0x2206, 0x05F6}, {0x2206, 0x27E4}, {0x2206, 0x8B8E}, {0x2206, 0x0204},
{0x2206, 0x1902}, {0x2206, 0x0488}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548}, {0x2206, 0xE08A},
{0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00}, {0x2206, 0x009E},
{0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE}, {0x2206, 0x8AE5},
{0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A}, {0x2206, 0xFDE2},
{0x2206, 0x85DE}, {0x2206, 0xE385}, {0x2206, 0xDF02}, {0x2206, 0x2DAC},
{0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4}, {0x2206, 0x03EE},
{0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85DE}, {0x2206, 0x00EE},
{0x2206, 0x85DF}, {0x2206, 0x00AE}, {0x2206, 0x1115}, {0x2206, 0xE685},
{0x2206, 0xDEE7}, {0x2206, 0x85DF}, {0x2206, 0xAE08}, {0x2206, 0xEE85},
{0x2206, 0xDE00}, {0x2206, 0xEE85}, {0x2206, 0xDF00}, {0x2206, 0xFDFC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x3FE0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2C}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2120}, {0x2206, 0xE18B}, {0x2206, 0x70F7},
{0x2206, 0x29E5}, {0x2206, 0x8B70}, {0x2206, 0xAC27}, {0x2206, 0x0DAC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x58AE}, {0x2206, 0x1302},
{0x2206, 0x056A}, {0x2206, 0xAE0E}, {0x2206, 0x0281}, {0x2206, 0xA302},
{0x2206, 0x8300}, {0x2206, 0xAE06}, {0x2206, 0x0205}, {0x2206, 0x0E02},
{0x2206, 0x8346}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04D1},
{0x2206, 0x02BF}, {0x2206, 0x351E}, {0x2206, 0x022E}, {0x2206, 0x88BF},
{0x2206, 0x2A58}, {0x2206, 0x022E}, {0x2206, 0xC6AC}, {0x2206, 0x280B},
{0x2206, 0x0281}, {0x2206, 0xEED1}, {0x2206, 0x01BF}, {0x2206, 0x3533},
{0x2206, 0x022E}, {0x2206, 0x88D0}, {0x2206, 0x1102}, {0x2206, 0x2D33},
{0x2206, 0x5903}, {0x2206, 0xEF01}, {0x2206, 0xD100}, {0x2206, 0xA000},
{0x2206, 0x02D1}, {0x2206, 0x01BF}, {0x2206, 0x3521}, {0x2206, 0x022E},
{0x2206, 0x88D1}, {0x2206, 0x11AD}, {0x2206, 0x2002}, {0x2206, 0x0C11},
{0x2206, 0xAD21}, {0x2206, 0x020C}, {0x2206, 0x12BF}, {0x2206, 0x3524},
{0x2206, 0x022E}, {0x2206, 0x8802}, {0x2206, 0x2AB0}, {0x2206, 0x0206},
{0x2206, 0x5B04}, {0x2206, 0xF8E0}, {0x2206, 0x8B80}, {0x2206, 0xAD27},
{0x2206, 0x3CEE}, {0x2206, 0xE232}, {0x2206, 0x00EE}, {0x2206, 0xE233},
{0x2206, 0x07EE}, {0x2206, 0xE230}, {0x2206, 0x00EE}, {0x2206, 0xE231},
{0x2206, 0xBDE0}, {0x2206, 0xEACA}, {0x2206, 0xE1EA}, {0x2206, 0xCBAD},
{0x2206, 0x2A13}, {0x2206, 0xE0EA}, {0x2206, 0xCCE1}, {0x2206, 0xEACD},
{0x2206, 0xAD2A}, {0x2206, 0x0AEE}, {0x2206, 0xE238}, {0x2206, 0x00EE},
{0x2206, 0xE239}, {0x2206, 0x3BAE}, {0x2206, 0x08EE}, {0x2206, 0xE238},
{0x2206, 0x00EE}, {0x2206, 0xE239}, {0x2206, 0x0CEE}, {0x2206, 0xE232},
{0x2206, 0x00EE}, {0x2206, 0xE233}, {0x2206, 0x00FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2730}, {0x2206, 0xE0E0},
{0x2206, 0x36E1}, {0x2206, 0xE037}, {0x2206, 0xE18B}, {0x2206, 0x731F},
{0x2206, 0x109E}, {0x2206, 0x23E4}, {0x2206, 0x8B73}, {0x2206, 0xAC20},
{0x2206, 0x0BAC}, {0x2206, 0x210D}, {0x2206, 0xAC25}, {0x2206, 0x0FAC},
{0x2206, 0x2711}, {0x2206, 0xAE12}, {0x2206, 0x022C}, {0x2206, 0x88AE},
{0x2206, 0x0D02}, {0x2206, 0x826C}, {0x2206, 0xAE08}, {0x2206, 0x0282},
{0x2206, 0x73AE}, {0x2206, 0x0302}, {0x2206, 0x2CA7}, {0x2206, 0xFC04},
{0x2206, 0x0282}, {0x2206, 0xBD02}, {0x2206, 0x2CF7}, {0x2206, 0x04F8},
{0x2206, 0xF901}, {0x2206, 0x11E0}, {0x2206, 0x8B87}, {0x2206, 0xAD26},
{0x2206, 0x08D1}, {0x2206, 0x01BF}, {0x2206, 0x2D30}, {0x2206, 0x022E},
{0x2206, 0x88FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x2726}, {0x2206, 0xD00B},
{0x2206, 0x022D}, {0x2206, 0x33AC}, {0x2206, 0x2A05}, {0x2206, 0xBF83},
{0x2206, 0xF2AE}, {0x2206, 0x03BF}, {0x2206, 0x83F5}, {0x2206, 0x022E},
{0x2206, 0xC6AC}, {0x2206, 0x2810}, {0x2206, 0xD101}, {0x2206, 0xBF83},
{0x2206, 0xF802}, {0x2206, 0x2E88}, {0x2206, 0xD100}, {0x2206, 0xBF83},
{0x2206, 0xF802}, {0x2206, 0x2E88}, {0x2206, 0xEF96}, {0x2206, 0xFEFC},
{0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85}, {0x2206, 0xAD26},
{0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2D33}, {0x2206, 0x5882},
{0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B}, {0x2206, 0x68E1},
{0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9E23}, {0x2206, 0x10E4},
{0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1}, {0x2206, 0xE001},
{0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5}, {0x2206, 0xE001},
{0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021}, {0x2206, 0xAD30},
{0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000}, {0x2206, 0xE5E0},
{0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69},
{0x2206, 0xE08B}, {0x2206, 0x82AD}, {0x2206, 0x2737}, {0x2206, 0xBF83},
{0x2206, 0xEC02}, {0x2206, 0x2EC6}, {0x2206, 0xAC28}, {0x2206, 0x2ED1},
{0x2206, 0x01BF}, {0x2206, 0x83EF}, {0x2206, 0x022E}, {0x2206, 0x88BF},
{0x2206, 0x83E9}, {0x2206, 0x022E}, {0x2206, 0xC6E5}, {0x2206, 0x85DD},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0xAC2E},
{0x2206, 0x04D1}, {0x2206, 0x01AE}, {0x2206, 0x02D1}, {0x2206, 0x00BF},
{0x2206, 0x83E9}, {0x2206, 0x022E}, {0x2206, 0x88D1}, {0x2206, 0x01BF},
{0x2206, 0x83EC}, {0x2206, 0x022E}, {0x2206, 0x88EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8FA}, {0x2206, 0xEF69}, {0x2206, 0xBF83},
{0x2206, 0xEF02}, {0x2206, 0x2EC6}, {0x2206, 0xAD28}, {0x2206, 0x19D1},
{0x2206, 0x00BF}, {0x2206, 0x83EC}, {0x2206, 0x022E}, {0x2206, 0x88E1},
{0x2206, 0x85DD}, {0x2206, 0xBF83}, {0x2206, 0xE902}, {0x2206, 0x2E88},
{0x2206, 0xD100}, {0x2206, 0xBF83}, {0x2206, 0xEF02}, {0x2206, 0x2E88},
{0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04EE}, {0x2206, 0xE08E},
{0x2206, 0x32EE}, {0x2206, 0xE08F}, {0x2206, 0x2105}, {0x2206, 0xEEE0},
{0x2206, 0x8E32}, {0x2206, 0xEEE0}, {0x2206, 0x8F20}, {0x2206, 0x05F8},
{0x2206, 0xE0E0}, {0x2206, 0x38E1}, {0x2206, 0xE039}, {0x2206, 0xAD2F},
{0x2206, 0x10E0}, {0x2206, 0xE034}, {0x2206, 0xE1E0}, {0x2206, 0x35F7},
{0x2206, 0x26E4}, {0x2206, 0xE034}, {0x2206, 0xE5E0}, {0x2206, 0x35AE},
{0x2206, 0x0EE0}, {0x2206, 0xE2D6}, {0x2206, 0xE1E2}, {0x2206, 0xD7F7},
{0x2206, 0x28E4}, {0x2206, 0xE2D6}, {0x2206, 0xE5E2}, {0x2206, 0xD7E0},
{0x2206, 0xE232}, {0x2206, 0xE1E2}, {0x2206, 0x33F7}, {0x2206, 0x2DE4},
{0x2206, 0xE232}, {0x2206, 0xE5E2}, {0x2206, 0x33D0}, {0x2206, 0x7DB0},
{0x2206, 0xFEE0}, {0x2206, 0xE232}, {0x2206, 0xE1E2}, {0x2206, 0x33F6},
{0x2206, 0x2DE4}, {0x2206, 0xE232}, {0x2206, 0xE5E2}, {0x2206, 0x33E0},
{0x2206, 0xE034}, {0x2206, 0xE1E0}, {0x2206, 0x35F6}, {0x2206, 0x26E4},
{0x2206, 0xE034}, {0x2206, 0xE5E0}, {0x2206, 0x35E0}, {0x2206, 0xE2D6},
{0x2206, 0xE1E2}, {0x2206, 0xD7F6}, {0x2206, 0x28E4}, {0x2206, 0xE2D6},
{0x2206, 0xE5E2}, {0x2206, 0xD7FC}, {0x2206, 0x0555}, {0x2206, 0xE020},
{0x2206, 0x55E2}, {0x2206, 0xD600}, {0x2206, 0xE24A}, {0x2206, 0x65E0},
{0x2206, 0x0887}, {0x2206, 0xE008}, {0x2206, 0x44E0}, {0x2206, 0x2800},
{0x2205, 0xE142}, {0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405},
{0x220F, 0x0000}, {0x221F, 0x0007}, {0x221E, 0x0041}, {0x2216, 0x1345},
{0x221F, 0x0000}, {0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86}, {0x2206, 0x808E},
{0x221F, 0x0003}, {0x2218, 0x8001}, {0x2205, 0x8B80}, {0x2206, 0x4890},
{0x221F, 0x0000}, {0x133F, 0x0010}, {0x2000, 0x1340}, {0x2020, 0x1340},
{0x2040, 0x1340}, {0x2060, 0x1340}, {0x2080, 0x1340}
};
/*End of ChipData101[][2]*/

rtk_uint16 ChipData102[][2]= {
{0x1d32, 0x0002}, {0x0018, 0x0F00}, {0x0038, 0x0F00}, {0x0058, 0x0F00},
{0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x1200, 0x7FCB}
};
/*End of ChipData102[][2]*/

#endif

static rtk_api_ret_t _rtk_filter_igrAcl_writeDataField(rtl8367b_aclrule *aclRule, rtk_filter_field_t *fieldPtr);
static rtk_api_ret_t _rtk_switch_init_setreg(rtk_uint32 reg, rtk_uint32 data);

rtk_api_ret_t rtk_cpu_tagPort_set(rtk_port_t port, rtk_cpu_insert_t mode)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_INPUT;

    if (mode >= CPU_INSERT_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicCputagPortmask(1<<port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagTrapPort(port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagInsertMode(mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

ret_t rtl8367b_setAsicLedGroupEnable(rtk_uint32 group, rtk_uint32 portmask)
{
    ret_t retVal;
    rtk_uint32 regAddr;
    rtk_uint32 regDataMask;

    if ( group >= RTL8367B_LEDGROUPNO )
        return RT_ERR_INPUT;

    if ( portmask > 0x1F )
        return RT_ERR_INPUT;

    regAddr = RTL8367B_REG_PARA_LED_IO_EN1 + group/2;

    regDataMask = 0xFF << ((group%2)*8);

    if ((retVal = rtl8367b_setAsicRegBits(regAddr, regDataMask, portmask))!=RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rtk_api_ret_t rtk_cpu_enable_set(rtk_enable_t enable)
{
    rtk_api_ret_t retVal;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicCputagEnable(enable)) != RT_ERR_OK)
        return retVal;

    if (DISABLED == enable)
    {
        if ((retVal = rtl8367b_setAsicCputagPortmask(0)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

rtk_api_ret_t rtk_led_enable_set(rtk_led_group_t group, rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;

    if (group >= LED_GROUP_END)
        return RT_ERR_INPUT;

    if (portmask.bits[0] >= (1 << (RTK_PHY_ID_MAX + 1)))
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicLedGroupEnable(group, portmask.bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rtk_api_ret_t rtk_port_rgmiiDelayExt_set(rtk_ext_port_t port, rtk_data_t txDelay, rtk_data_t rxDelay)
{
    rtk_api_ret_t retVal;
    rtk_uint32 regAddr, regData;

    if ((txDelay > 1) || (rxDelay > 7))
        return RT_ERR_INPUT;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

#if 0//<Coverity: DEADCODE>
    if(port == EXT_PORT_0)
        regAddr = RTL8367B_REG_EXT0_RGMXF;
    else if(port == EXT_PORT_1)
        regAddr = RTL8367B_REG_EXT1_RGMXF;
    else if(port == EXT_PORT_2)
        regAddr = RTL8367B_REG_EXT2_RGMXF;
    else
        return RT_ERR_INPUT;
#else
	switch (port) {
	case EXT_PORT_0:
		regAddr = RTL8367B_REG_EXT0_RGMXF;
		break;
	case EXT_PORT_1:
		regAddr = RTL8367B_REG_EXT1_RGMXF;
		break;
	case EXT_PORT_2:
		regAddr = RTL8367B_REG_EXT2_RGMXF;
		break;
	default:
		return RT_ERR_INPUT;
	}
#endif

    if ((retVal = rtl8367b_getAsicReg(regAddr, &regData)) != RT_ERR_OK)
        return retVal;

    regData = (regData & 0xFFF0) | ((txDelay << 3) & 0x0008) | (rxDelay & 0x0007);

    if ((retVal = rtl8367b_setAsicReg(regAddr, regData)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rtk_api_ret_t rtk_port_macForceLinkExt_set(rtk_ext_port_t port, rtk_mode_ext_t mode, rtk_port_mac_ability_t *pPortability)
{
    rtk_api_ret_t retVal;
    rtl8367b_port_ability_t ability;
    rtk_uint32  reg, mask;

    if (port >= EXT_PORT_END)
        return RT_ERR_INPUT;

    if (mode >=MODE_EXT_END)
        return RT_ERR_INPUT;

    if ((mode == MODE_EXT_RGMII_33V) || (mode == MODE_EXT_RMII_PHY))
        return RT_ERR_INPUT;

    if (pPortability->forcemode > 1 || pPortability->speed > 2 || pPortability->duplex > 1 ||
       pPortability->link > 1 || pPortability->nway > 1 || pPortability->txpause > 1 || pPortability->rxpause > 1)
        return RT_ERR_INPUT;

#if 0//<Coverity: DEADCODE>
    if(port == EXT_PORT_0)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_0_MASK;
    }
    else if(port == EXT_PORT_1)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
        mask = RTL8367B_SELECT_GMII_1_MASK;
    }
    else if(port == EXT_PORT_2)
    {
        reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT_1;
        mask = RTL8367B_SELECT_RGMII_2_MASK;
    }
    else
        return RT_ERR_INPUT;
#else
	switch (port) {
	case EXT_PORT_0:
		reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
		mask = RTL8367B_SELECT_GMII_0_MASK;
		break;
	case EXT_PORT_1:
		reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT;
		mask = RTL8367B_SELECT_GMII_1_MASK;
		break;
	case EXT_PORT_2:
		reg = RTL8367B_REG_DIGITAL_INTERFACE_SELECT_1;
		mask = RTL8367B_SELECT_RGMII_2_MASK;
		break;
	default:
		return RT_ERR_INPUT;
	}
#endif

    if(mode == MODE_EXT_DISABLE)
    {
        memset(&ability, 0x00, sizeof(rtl8367b_port_ability_t));
        if ((retVal = rtl8367b_setAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicPortExtMode(port, mode)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if ((retVal = rtl8367b_setAsicPortExtMode(port, mode)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_getAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;

        ability.forcemode = pPortability->forcemode;
        ability.speed     = pPortability->speed;
        ability.duplex    = pPortability->duplex;
        ability.link      = pPortability->link;
        ability.nway      = pPortability->nway;
        ability.txpause   = pPortability->txpause;
        ability.rxpause   = pPortability->rxpause;

        if ((retVal = rtl8367b_setAsicPortForceLinkExt( (rtk_uint32)port, &ability)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

static rtk_api_ret_t _rtk_switch_init_setreg(rtk_uint32 reg, rtk_uint32 data)
{
#ifndef MDC_MDIO_OPERATION
    rtk_uint32      busyFlag, cnt;
#endif
    rtk_api_ret_t   retVal;

#ifdef MDC_MDIO_OPERATION
    if((retVal = rtl8367b_setAsicReg(reg, data) != RT_ERR_OK))
            return retVal;
#else
    if ((reg & 0xF000) == 0x2000)
    {
        cnt = 0;
        busyFlag = 1;
        while (busyFlag&&cnt<5)
        {
            cnt++;
            if ((retVal = rtl8367b_getAsicRegBit(RTK_INDRECT_ACCESS_STATUS, RTK_PHY_BUSY_OFFSET,&busyFlag)) !=  RT_ERR_OK)
                return retVal;
        }
        if (5 == cnt)
            return RT_ERR_BUSYWAIT_TIMEOUT;

        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_WRITE_DATA, data)) !=  RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_ADDRESS, reg)) !=  RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicReg(RTK_INDRECT_ACCESS_CRTL, RTK_CMD_MASK | RTK_RW_MASK)) !=  RT_ERR_OK)
            return retVal;
    }
    else
    {
        if((retVal = rtl8367b_setAsicReg(reg, data)) != RT_ERR_OK)
            return retVal;
    }
#endif

    return RT_ERR_OK;
}

ret_t rtl8367b_setAsicMaxLengthInRx(rtk_uint32 maxLength)
{	
	return rtl8367b_setAsicRegBits(RTL8367B_REG_MAX_LENGTH_LIMINT_IPG, RTL8367B_MAX_LENTH_CTRL_MASK, maxLength);
}

/* Function Name:
 *      rtk_switch_maxPktLen_set
 * Description:
 *      Set the max packet length of the specific unit
 * Input:
 *      len - max packet length
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_INPUT 		- Invalid input parameters.
 * Note:
 *      The API can set max packet length of the specific unit to
 *      - MAXPKTLEN_1522B,
 *      - MAXPKTLEN_1536B,
 *      - MAXPKTLEN_1552B,
 *      - MAXPKTLEN_16000B.
 */
rtk_api_ret_t rtk_switch_maxPktLen_set(rtk_switch_maxPktLen_t len)
{
    rtk_api_ret_t retVal;

    if (len>=MAXPKTLEN_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicMaxLengthInRx(len)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rtk_api_ret_t rtk_switch_init(void)
{
    rtk_uint16      i;
    rtk_uint32      data, data2, regData;
    rtk_api_ret_t   retVal;
    rtk_uint32      phy;
#if defined(CHIP_AUTO_DETECT)
    rtk_uint32      polling_time;
    rtk_uint32      chip_idx = 0;
#endif

    if((retVal = rtl8367b_setAsicReg(0x13C2, 0x0249)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1301, &data)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_getAsicReg(0x1300, &data2)) != RT_ERR_OK)
        return retVal;

#if defined(CHIP_AUTO_DETECT)
    if((retVal = rtl8367b_setAsicReg(0x1371, 0x000F)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicReg(0x1370, 0x0002)) != RT_ERR_OK)
        return retVal;

    polling_time = 0;
    while(polling_time < 10000)
    {
        if((retVal = rtl8367b_getAsicReg(0x1370, &data)) != RT_ERR_OK)
            return retVal;

        if((data & 0x0004) == 0)
            break;

        polling_time++;
    }

    if(polling_time >= 10000)
        return RT_ERR_BUSYWAIT_TIMEOUT;

    if((retVal = rtl8367b_getAsicReg(0x1373, &data)) != RT_ERR_OK)
        return retVal;

    chip_idx |= ((data & 0x000F) << 4);

    if((retVal = rtl8367b_setAsicReg(0x1371, 0x000D)) != RT_ERR_OK)
        return retVal;

    if((retVal = rtl8367b_setAsicReg(0x1370, 0x0002)) != RT_ERR_OK)
        return retVal;

    polling_time = 0;
    while(polling_time < 10000)
    {
        if((retVal = rtl8367b_getAsicReg(0x1370, &data)) != RT_ERR_OK)
            return retVal;

        if((data & 0x0004) == 0)
            break;

        polling_time++;
    }

    if(polling_time >= 10000)
        return RT_ERR_BUSYWAIT_TIMEOUT;

    if((retVal = rtl8367b_getAsicReg(0x1373, &data)) != RT_ERR_OK)
        return retVal;

    chip_idx |= (data & 0x000F);


    if((chip_idx & 0x00F0) == 0x0000)
    {
        /* RTL8365MB & RTL8305MB */
        if((chip_idx & 0x000F) >> 3)
        {
            /* RTL8305MB */
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else if((chip_idx & 0x000F) >> 2)
        {
            /* RTL8365MB */
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else if((chip_idx & 0x000F) >> 1)
        {
            /* RTL8305MB */
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else if(chip_idx & 0x000F)
        {
            /* RTL8365MB */
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else
            return RT_ERR_CHIP_NOT_SUPPORTED;
    }
    else
        return RT_ERR_CHIP_NOT_SUPPORTED;

#elif defined(RTK_X86_ASICDRV)
    if(init_para == ChipData00)
    {
        if(data & 0xF000)
        {
            init_para = ChipData01;
            init_size = (sizeof(ChipData01) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData00) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData10)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData12;
            init_size = (sizeof(ChipData12) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData11;
                init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData10) / ((sizeof(rtk_uint16))*2));
        }
    }
    else if(init_para == ChipData20)
    {
        if(data & 0xF000)
        {
            init_para = ChipData21;
            init_size = (sizeof(ChipData21) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData20) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData30)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData32;
            init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData31;
                init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData30) / ((sizeof(rtk_uint16))*2));
        }
    }
    else if(init_para == ChipData40)
    {
        if(data & 0xF000)
        {
            init_para = ChipData41;
            init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData40) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData50)
    {
        if(data & 0xF000)
        {
            init_para = ChipData51;
            init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData60)
    {
        if(data & 0xF000)
        {
            init_para = ChipData61;
            init_size = (sizeof(ChipData61) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData60) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData70)
    {
        if(data & 0xF000)
        {
            init_para = ChipData71;
            init_size = (sizeof(ChipData71) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData70) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData80)
    {
        if(data & 0xF000)
        {
            init_para = ChipData81;
            init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData80) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData90)
    {
        if(data & 0xF000)
        {
            init_para = ChipData91;
            init_size = (sizeof(ChipData91) / ((sizeof(rtk_uint16))*2));
        }
        else
            init_size = (sizeof(ChipData90) / ((sizeof(rtk_uint16))*2));
    }
    else if(init_para == ChipData100)
    {
        if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
        {
            init_para = ChipData102;
            init_size = (sizeof(ChipData102) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            if(data & 0xF000)
            {
                init_para = ChipData101;
                init_size = (sizeof(ChipData101) / ((sizeof(rtk_uint16))*2));
            }
            else
                init_size = (sizeof(ChipData100) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8363SB)
    if(data & 0xF000)
    {
        init_para = ChipData01;
        init_size = (sizeof(ChipData01) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData00;
        init_size = (sizeof(ChipData00) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8365MB)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData12;
        init_size = (sizeof(ChipData12) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData11;
            init_size = (sizeof(ChipData11) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData10;
            init_size = (sizeof(ChipData10) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8367_VB)
    if(data & 0xF000)
    {
        init_para = ChipData21;
        init_size = (sizeof(ChipData21) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData20;
        init_size = (sizeof(ChipData20) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367RB)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData32;
        init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData31;
            init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData30;
            init_size = (sizeof(ChipData30) / ((sizeof(rtk_uint16))*2));
        }
    }

#elif defined(CHIP_RTL8367R_VB)
    if(data & 0xF000)
    {
        init_para = ChipData41;
        init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData40;
        init_size = (sizeof(ChipData40) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367MB)
    if(data & 0xF000)
    {
        init_para = ChipData51;
        init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData50;
        init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8367M_VB)
    if(data & 0xF000)
    {
        init_para = ChipData61;
        init_size = (sizeof(ChipData61) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData60;
        init_size = (sizeof(ChipData60) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8368MB)
    if(data & 0xF000)
    {
        init_para = ChipData71;
        init_size = (sizeof(ChipData71) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData70;
        init_size = (sizeof(ChipData70) / ((sizeof(rtk_uint16))*2));
    }

#elif defined(CHIP_RTL8305MB)
    if(data & 0xF000)
    {
        init_para = ChipData81;
        init_size = (sizeof(ChipData81) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData80;
        init_size = (sizeof(ChipData80) / ((sizeof(rtk_uint16))*2));
    }
#elif defined(CHIP_RTL8307M_VB)
    if(data & 0xF000)
    {
        init_para = ChipData91;
        init_size = (sizeof(ChipData91) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData90;
        init_size = (sizeof(ChipData90) / ((sizeof(rtk_uint16))*2));
    }
#elif defined(CHIP_RTL8367N)
    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))
    {
        init_para = ChipData102;
        init_size = (sizeof(ChipData102) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        if(data & 0xF000)
        {
            init_para = ChipData101;
            init_size = (sizeof(ChipData101) / ((sizeof(rtk_uint16))*2));
        }
        else
        {
            init_para = ChipData100;
            init_size = (sizeof(ChipData100) / ((sizeof(rtk_uint16))*2));
        }
    }
#else
    /* Not define CHIP, Error */
    init_para = NULL;
#endif

#if defined(CONFIG_RTL_8367MB_SUPPORT)
    if(data & 0xF000)
    {
        init_para = ChipData51;
        init_size = (sizeof(ChipData51) / ((sizeof(rtk_uint16))*2));
    }
    else
    {
        init_para = ChipData50;
        init_size = (sizeof(ChipData50) / ((sizeof(rtk_uint16))*2));
    }
	
#elif defined(CONFIG_SW_8367R)
	if ((data & 0x00F0) == 0x0010) {  // RTL8367R_VB
		init_para = ChipData41;
		init_size = (sizeof(ChipData41) / ((sizeof(rtk_uint16))*2));
	}	
	else  
	{	// RTL8367RB or RTL8367RB-VB
		if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367))	// RTL8367RB-VB
		{
			init_para = ChipData32;
			init_size = (sizeof(ChipData32) / ((sizeof(rtk_uint16))*2));
		}
		else	// RTL8367RB
		{
			init_para = ChipData31;
			init_size = (sizeof(ChipData31) / ((sizeof(rtk_uint16))*2));
		}	
	}
#else //should not happen
    if(init_para == NULL)
        return RT_ERR_CHIP_NOT_SUPPORTED;
#endif

    if( (data2 == 0x0276) || (data2 == 0x0597) || (data2 == 0x6367) )
    {
        for(phy = 0; phy <= RTK_PHY_ID_MAX; phy++)
        {
            if((retVal = rtl8367b_getAsicPHYOCPReg(phy, 0xA428, &regData)) != RT_ERR_OK)
                return retVal;

            regData &= ~(0x0200);
            if((retVal = rtl8367b_setAsicPHYOCPReg(phy, 0xA428, regData)) != RT_ERR_OK)
                return retVal;
        }

        if((retVal = rtl8367b_setAsicReg(RTL8367B_REG_UTP_FIB_DET, 0x15BB)) != RT_ERR_OK)
            return retVal;
    }

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        /* Analog parameter update. ID:0001 */
        for(phy = 0; phy <= RTK_PHY_ID_MAX; phy++)
        {
            if((retVal = rtl8367b_setAsicPHYReg(phy, 31, 0x7)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 30, 0x2c)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 25, 0x0504)) != RT_ERR_OK)
                return retVal;

            if((retVal = rtl8367b_setAsicPHYReg(phy, 31, 0x0)) != RT_ERR_OK)
                return retVal;
        }
    }

    for(i = 0; i < init_size; i++)
    {
        if((retVal = _rtk_switch_init_setreg((rtk_uint32)init_para[i][0], (rtk_uint32)init_para[i][1])) != RT_ERR_OK)
            return retVal;
    }

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        /* Analog parameter update. ID:0002 */
        if((retVal = rtl8367b_setAsicPHYReg(1, 31, 0x2)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_getAsicPHYReg(1, 17, &data)) != RT_ERR_OK)
            return retVal;

        data |= 0x01E0;

        if((retVal = rtl8367b_setAsicPHYReg(1, 17, data)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicPHYReg(1, 31, 0x0)) != RT_ERR_OK)
            return retVal;

        /* Analog parameter update. ID:0003 */
        for(phy = 0; phy <= 4; phy++)
        {
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1F, 0x0007)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1E, 0x002C)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x18, 0x008B)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x19, 0x0504)) != RT_ERR_OK)
                return retVal;
            if ((retVal = rtl8367b_setAsicPHYReg(phy, 0x1F, 0)) != RT_ERR_OK)
                return retVal;
        }

    }

    if((retVal = rtl8367b_setAsicRegBit(0x18e0, 0, 0)) != RT_ERR_OK)
        return retVal;

    if( (data2 != 0x0276) && (data2 != 0x0597) && (data2 != 0x6367) )
    {
        if((retVal = rtl8367b_setAsicReg(0x1303, 0x0778)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1304, 0x7777)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13E2, 0x01FE)) != RT_ERR_OK)
            return retVal;
    }
    else
    {
        if((retVal = rtl8367b_setAsicReg(0x1303, 0x06D6)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1304, 0x0700)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13E2, 0x003F)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x13F9, 0x0090)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicReg(0x121e, 0x03CA)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1233, 0x0352)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1237, 0x00a0)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x123a, 0x0030)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x1239, 0x0084)) != RT_ERR_OK)
            return retVal;
        if((retVal = rtl8367b_setAsicReg(0x0301, 0x1000)) != RT_ERR_OK)
            return retVal;

        if((retVal = rtl8367b_setAsicReg(0x09DA, 0x0017)) != RT_ERR_OK)
            return retVal;

    }

    return RT_ERR_OK;
}

#if defined(CONFIG_SW_8367R)
#include <rtl8367b_asicdrv_portIsolation.h>
#include <rtl8196x/asicregs.h>
#include <asm/delay.h>


/* Function Name:
 *      rtl8367b_setAsicPortIsolationPermittedPortmask
 * Description:
 *      Set permitted port isolation portmask
 * Input:
 *      port 			- Physical port number (0~7)
 *      permitPortmask 	- port mask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK 			- Success
 *      RT_ERR_SMI  		- SMI access error
 *      RT_ERR_PORT_ID  	- Invalid port number
 *      RT_ERR_PORT_MASK  	- Invalid portmask
 * Note:
 *      None
 */

ret_t rtl8367b_setAsicPortIsolationPermittedPortmask(rtk_uint32 port, rtk_uint32 permitPortmask)
{
    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;

    if( permitPortmask > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;
    
    return rtl8367b_setAsicReg(RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port), permitPortmask);
}
/* Function Name:
 *      rtl8367b_getAsicPortIsolationPermittedPortmask
 * Description:
 *      Get permitted port isolation portmask
 * Input:
 *      port 				- Physical port number (0~7)
 *      pPermitPortmask 	- port mask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK 			- Success
 *      RT_ERR_SMI  		- SMI access error
 *      RT_ERR_PORT_ID  	- Invalid port number
 * Note:
 *      None
 */
ret_t rtl8367b_getAsicPortIsolationPermittedPortmask(rtk_uint32 port, rtk_uint32 *pPermitPortmask)
{
    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;
    
    return rtl8367b_getAsicReg(RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port), pPermitPortmask);
}

/* Function Name:
 *      rtk_port_isolation_set
 * Description:
 *      Set permitted port isolation portmask
 * Input:
 *      port        - port id.
 *      portmask    - Permit port mask
 * Output:
 *      None
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 *      RT_ERR_PORT_MASK    - Invalid portmask.
 * Note:
 *      This API set the port mask that a port can trasmit packet to of each port
 *      A port can only transmit packet to ports included in permitted portmask
 */
rtk_api_ret_t rtk_port_isolation_set(rtk_port_t port, rtk_portmask_t portmask)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ( portmask.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if ((retVal = rtl8367b_setAsicPortIsolationPermittedPortmask(port, portmask.bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

/* Function Name:
 *      rtk_port_isolation_get
 * Description:
 *      Get permitted port isolation portmask
 * Input:
 *      port - Port id.
 * Output:
 *      pPortmask - Permit port mask
 * Return:
 *      RT_ERR_OK           - OK
 *      RT_ERR_FAILED       - Failed
 *      RT_ERR_SMI          - SMI access error
 *      RT_ERR_PORT_ID      - Invalid port number.
 * Note:
 *      This API get the port mask that a port can trasmit packet to of each port
 *      A port can only transmit packet to ports included in permitted portmask
 */
rtk_api_ret_t rtk_port_isolation_get(rtk_port_t port, rtk_portmask_t *pPortmask)
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortIsolationPermittedPortmask(port, &pPortmask->bits[0])) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}
#endif

#ifdef CONFIG_RTL_ESW_RG2_FOR_HOST
#define EXT_PORT_FOR_HOST			EXT_PORT_2
#define EXT_MAC_FOR_HOST			RTK_EXT_2_MAC
#else
#define EXT_PORT_FOR_HOST			EXT_PORT_1
#define EXT_MAC_FOR_HOST			RTK_EXT_1_MAC
#endif

int RTL8367R_init(void)
{
    rtk_portmask_t portmask;
    unsigned int ret, regData;
 
    /* Set external interface 0 to RGMII with Force mode, 1000M, Full-duple, enable TX&RX pause*/
    rtk_port_mac_ability_t mac_cfg;
    rtk_mode_ext_t mode ;
 
    /* Initial Chip */
    ret = rtk_switch_init();

    /* Enable LED Group 0&1 from P0 to P4 */
    portmask.bits[0]=0x1F;
    rtk_led_enable_set(LED_GROUP_0, portmask);
    rtk_led_enable_set(LED_GROUP_1, portmask);
 
    mode = MODE_EXT_RGMII ;
    mac_cfg.forcemode = MAC_FORCE;
    mac_cfg.speed = SPD_1000M;
    mac_cfg.duplex = FULL_DUPLEX;
    mac_cfg.link = PORT_LINKUP;
    mac_cfg.nway = DISABLED;
    mac_cfg.txpause = ENABLED;
    mac_cfg.rxpause = ENABLED;
    rtk_port_macForceLinkExt_set(EXT_PORT_FOR_HOST,mode,&mac_cfg);
 
    /* Set RGMII Interface 0 TX delay to 2ns and RX to step 4 */
    // set the tx/rx delay in 8197D site
    //rtk_port_rgmiiDelayExt_set(EXT_PORT_FOR_HOST, 1, 4);
    rtk_port_rgmiiDelayExt_set(EXT_PORT_FOR_HOST, 0, 2);
 
    /* set port 5 as CPU port */
    rtk_cpu_enable_set(ENABLE);
    rtk_cpu_tagPort_set(EXT_MAC_FOR_HOST, CPU_INSERT_TO_NONE);

    rtl8367b_setAsicReg(RTL8367B_REG_UNDA_FLOODING_PMSK, 0xff);
    rtl8367b_setAsicReg(RTL8367B_REG_UNMCAST_FLOADING_PMSK, 0xff);
    rtl8367b_setAsicReg(RTL8367B_REG_BCAST_FLOADING_PMSK, 0xff);

#if defined(CONFIG_SW_8367R)
    {
	    rtk_portmask_t pm;

	    pm.bits[0] = (0xff & ~(1<<4));
	    rtk_port_isolation_set(0, pm);
	    rtk_port_isolation_set(1, pm);
	    rtk_port_isolation_set(2, pm);
	    rtk_port_isolation_set(3, pm);
	    pm.bits[0] = 0xf0;
	    rtk_port_isolation_set(4, pm);
    }
#endif

	rtk_switch_maxPktLen_set(MAXPKTLEN_16000B);
	rtl8367b_setAsicReg(0x1B03, 0x0936);

    return ret; 
}

int init_rtl8367r(void)
{	
	int i, ret = 0;
	
#if defined(CONFIG_SW_8367R)&&defined(CONFIG_LAN_WAN_ISOLATION)
	#define REG_IOCFG_GPIO		0x00000018
	
	/* define GPIO port */
	enum GPIO_PORT
	{
	GPIO_PORT_A = 0,
	GPIO_PORT_B,
	GPIO_PORT_C,
	GPIO_PORT_D,
	GPIO_PORT_E,
	GPIO_PORT_F,
	GPIO_PORT_G,
	GPIO_PORT_H,
	GPIO_PORT_I,
	GPIO_PORT_MAX,
	};

	extern unsigned long loops_per_jiffy;
	#define __mdelay(x) { int i=x; while(i--) __udelay(1000, loops_per_jiffy * 100); }

	REG32(PIN_MUX_SEL2) |=  (3<<12); // reg_iocfg_fcs1, set to GPIO mode
	REG32(PABCDCNR) &= (~(0x00004000)); //set GPIO pin, A1
	REG32(PABCDDIR) |= (0x00004000); //output pin

	for (i=0; i<3; i++) 
	{

		// for 8367r h/w reset pin
		{
		REG32(PABCDDAT) &= (~(0x00004000)); 
		__mdelay(1000);
		REG32(PABCDDAT) |= (0x00004000); 
		__mdelay(1000);
		}
		// set to GPIO mode
		REG32(PIN_MUX_SEL) |= ((REG32(PIN_MUX_SEL)&(~(7<<2))|0x3<<2));

		// MDC: F5, MDIO: F6
		WRITE_MEM32(PEFGHCNR, READ_MEM32(PEFGHCNR) & (~(0x00006000)));	//set GPIO pin, F5 and F6
		WRITE_MEM32(PEFGHDIR, READ_MEM32(PEFGHDIR) | ((0x00006000))); //output pin

		//smi_init(GPIO_PORT_A, 3, 2);
		smi_init(GPIO_PORT_F, 5, 6);
		__mdelay(1000);
		ret = RTL8367R_init();
		if (ret == 0) 
			break;
	}
#endif
	return ret;
}

