



/*
 * from rp-pppoe/src/common.c
 * rp-pppoe is under GPL
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


int	IsSetID	= 0;

static uid_t saved_uid = -2;
static uid_t saved_gid = -2;


/**********************************************************************
*%FUNCTION: switchToRealID
*%ARGUMENTS:
* None
*%RETURNS:
* Nothing
*%DESCRIPTION:
* Sets effective user-ID and group-ID to real ones.  Aborts on failure
***********************************************************************/
void
switchToRealID (void) {
    if (IsSetID) {
	if (saved_uid < 0) saved_uid = geteuid();
	if (saved_gid < 0) saved_gid = getegid();
	if (setegid(getgid()) < 0) {
	    printf("setgid failed");
	    exit(EXIT_FAILURE);
	}
	if (seteuid(getuid()) < 0) {
	    printf("seteuid failed");
	    exit(EXIT_FAILURE);
	}
    }
}

/**********************************************************************
*%FUNCTION: switchToEffectiveID
*%ARGUMENTS:
* None
*%RETURNS:
* Nothing
*%DESCRIPTION:
* Sets effective user-ID and group-ID back to saved gid/uid
***********************************************************************/
void
switchToEffectiveID (void) {
    if (IsSetID) {
	if (setegid(saved_gid) < 0) {
	    printf("setgid failed");
	    exit(EXIT_FAILURE);
	}
	if (seteuid(saved_uid) < 0) {
	    printf("seteuid failed");
	    exit(EXIT_FAILURE);
	}
    }
}
