#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <net/vext_netlog.h>

static void
vext_netlog_arg_free(struct vext_netlog_arg *args)
{
	int i;

	if (args == NULL)
		return;

	for (i = 0; i < VEXT_NETLOG_ARG_MAX; i++) {
		if (args->argv[i] != NULL)
			kfree(args->argv[i]);
	}
	kfree(args);
}

static void
vext_netlog_arg_cleanup(struct subprocess_info *sub_info)
{
	vext_netlog_arg_free(sub_info->data);
}

int
vext_netlog_output(int argc, ...)
{
	static char *envp[] = {
		"HOME=/",
		"PATH=/sbin:/bin:/usr/sbin:/usr/bin", NULL };
	va_list args;
	struct subprocess_info *sub_info;
	struct vext_netlog_arg *vsargp;
	int i;

	if (argc == 0 || argc > VEXT_NETLOG_ARG_MAX)
		return -EINVAL;

	vsargp = kmalloc(sizeof(*vsargp), GFP_ATOMIC | __GFP_ZERO);
	if (vsargp == NULL) {
		pr_err("%s:%d kmalloc", __func__, __LINE__);
		return -ENOMEM;
	}

	va_start(args, argc);
	for (i = 0; i < argc; i++) {
		vsargp->argv[i] = kstrdup(va_arg(args, char *), GFP_ATOMIC);
		if (vsargp->argv[i] == NULL) {
			va_end(args);
			goto err;
		}
	}
	va_end(args);

	sub_info = call_usermodehelper_setup(vsargp->argv[0], vsargp->argv, envp, GFP_ATOMIC, NULL, vext_netlog_arg_cleanup, vsargp);
	if (sub_info == NULL)
		goto err;

	return call_usermodehelper_exec(sub_info, UMH_NO_WAIT);

err:
	vext_netlog_arg_free(vsargp);
	return -ENOMEM;
}
EXPORT_SYMBOL(vext_netlog_output);
