#
# @Author Ralf Habacker
# 
# extracts version information from autoconf config file
# and set related cmake variables
# 
# returns  
#   ${prefix}_VERSION
#   ${prefix}_VERSION_STRING
#   ${prefix}_MAJOR_VERSION
#   ${prefix}_MINOR_VERSION
#   ${prefix}_MICRO_VERSION
# 
macro(autoversion config prefix)
	file (READ ${config} _configure_ac)
	string(TOUPPER ${prefix} prefix_upper)
	string (REGEX REPLACE ".*${prefix}_major_version], .([0-9]+).*" "\\1" ${prefix_upper}_MAJOR_VERSION ${_configure_ac})
	string (REGEX REPLACE ".*${prefix}_minor_version], .([0-9]+).*" "\\1" ${prefix_upper}_MINOR_VERSION ${_configure_ac})
	string (REGEX REPLACE ".*${prefix}_micro_version], .([0-9]+).*" "\\1" ${prefix_upper}_MICRO_VERSION ${_configure_ac})
	set (${prefix_upper}_VERSION ${${prefix_upper}_MAJOR_VERSION}.${${prefix_upper}_MINOR_VERSION}.${${prefix_upper}_MICRO_VERSION})
	set (${prefix_upper}_VERSION_STRING "${${prefix_upper}_VERSION}")

endmacro()

#
# Defines package related variables (PACKAGE_..., PACKAGE and VERSION)
# as done by autotools.
#
# Additional it defines a cmake variable named PACKAGE_CONFIG_H_TEMPLATE
# which could be placed in config.h templates to have those variables
# defined at code level like shown below:
#
# config.h.template
#   ...
#   @AUTOPACKAGE_CONFIG_H_TEMPLATE@
#   ...
#
macro(autopackage name version url support_url)
    # Define to the full name of this package.
    set(PACKAGE_NAME ${name})

    # Define to the version of this package.
    set(PACKAGE_VERSION ${version})

    # Define to the home page for this package.
    set(PACKAGE_URL ${url})

    # Define to the address where bug reports for this package should be sent.
    set(PACKAGE_BUGREPORT ${support_url})

    # Define to the full name and version of this package.
    set(PACKAGE_STRING "${PACKAGE_NAME} ${PACKAGE_VERSION}")

    # Define to the one symbol short name of this package.
    set(PACKAGE_TARNAME ${PACKAGE_NAME})

    set(PACKAGE ${name})
    set(VERSION ${DBUS_VERSION_STRING})

    set(AUTOPACKAGE_CONFIG_H_TEMPLATE "/* generated by cmake macro autopackage */\n
/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT \"@PACKAGE_BUGREPORT@\"

/* Define to the full name of this package. */
#define PACKAGE_NAME \"@PACKAGE_NAME@\"

/* Define to the full name and version of this package. */
#define PACKAGE_STRING \"@PACKAGE_STRING@\"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME \"@PACKAGE_TARNAME@\"

/* Define to the home page for this package. */
#define PACKAGE_URL \"@PACKAGE_URL@\"

/* Define to the version of this package. */
#define PACKAGE_VERSION \"@PACKAGE_VERSION@\"

/* defined by autotools package */
#define PACKAGE \"@PACKAGE@\"
#define VERSION \"@VERSION@\"
")
endmacro(autopackage)

#
# parses config.h template and create cmake equivalent 
# not implemented yet
# 
macro(autoconfig template output)
	file(READ ${template} contents)
	# Convert file contents into a CMake list (where each element in the list
	# is one line of the file)
	STRING(REGEX REPLACE ";" "\\\\;" contents "${contents}")
	STRING(REGEX REPLACE "\n" ";" contents "${contents}")
	foreach(line contents)
		message(STATUS ${line})
		# find #undef lines
		# append to config.h #define <variable-name> <variable-content>
	endforeach()
endmacro()
