/*
 * Copyright (c) 2015, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <asm/mach/map.h>
#include <asm/mach/arch.h>
#include <linux/gpio.h>
#include "board-dt.h"

static const char *mdm9607_dt_match[] __initconst = {
	"qcom,mdm9607",
	NULL
};

static void __init mdm9607_init(void)
{
	board_dt_populate(NULL);
}

#if defined(CONFIG_PLATFORM_NEC)
static const struct gpio nec_board_gpios[] __initdata = {
	{24, GPIOF_OUT_INIT_LOW | GPIOF_EXPORT,	 "PMIC_RESET"},
	{34, GPIOF_IN | GPIOF_EXPORT,			 "UIM1_DETECT"},
	{55, GPIOF_IN | GPIOF_EXPORT,            "BT_TEST"},
};

static void __init nec_boards_gpios_init(void)
{
	int rc;

	rc = gpio_request_array(nec_board_gpios, ARRAY_SIZE(nec_board_gpios));
	if (rc) {
		pr_err("%s gpio_request_array board failed %d\n", __func__, rc);
	}
}

device_initcall(nec_boards_gpios_init);
#endif /* CONFIG_PLATFORM_NEC */

DT_MACHINE_START(MDM9607_DT,
	"Qualcomm Technologies, Inc. MDM 9607 (Flattened Device Tree)")
	.init_machine	= mdm9607_init,
	.dt_compat	= mdm9607_dt_match,
MACHINE_END
