#if !defined(_LEDVAR_H_)
#define _LEDVAR_H_

#define LED_DEVNAME "/dev/led0"

typedef enum {
	LEDST_NONE = 0,
	LEDST_OFF,
	LEDST_GREEN,
	LEDST_RED,
	LEDST_ORANGE,
	LEDST_BLINK_GREEN,
	LEDST_BLINK_RED,
	LEDST_BLINK_ORANGE,
	LEDST_BLUE,
	LEDST_LIGHTBLUE,
	LEDST_PINK,
	LEDST_WHITE,
	LEDST_BLINK_BLUE,
	LEDST_BLINK_LIGHTBLUE,
	LEDST_BLINK_PINK,
	LEDST_BLINK_WHITE,
	LEDST_MAX
} ledact_status_t;

typedef enum {
	LEDBS_OFF = 0,
	LEDBS_ON,
	LEDBS_LOW,
	LEDBS_HIGH,
	LEDBS_NONE,
	LEDBS_MAX
} ledact_blinkspeed_t;

typedef enum {
	LEDBM_NORMAL = 0,
	LEDBM_IGNORE_ECO,
	LEDBM_MAX
} ledact_blinkmode_t;

typedef enum {
	LEDNM_ALL = 0,
	LEDNM_EXCEPT_POWER,
	LEDNM_OFF,
	LEDNM_RECOVER,
	LEDNM_ONESHOT_OFF,
	LEDNM_TEMP_OFF,
	LEDNM_ONESHOT_OFF_END,
	LEDNM_TEMP_OFF_END,
	LEDNM_MAX
} lednm_act_t;

#ifdef __KERNEL__
#include "ledprofile.h"

typedef struct {
	ledact_bitmap_t action;
	int on;
	unsigned count;
	ledact_bitmap_t exec_action;
	ledact_bitmap_t current_action;
} ledact_t;

int act_oneshot(ledact_t *act);
int act_oneshot_red(ledact_t *act);
int act_oneshot_orange(ledact_t *act);
int act_1sec_orange(ledact_t *act);
int act_2sec_green(ledact_t *act);
int act_blink_normal1(ledact_t *act);
int act_flush(ledact_t *act);
int act_flush_green(ledact_t *act);
int act_flush2_red(ledact_t *act);
int act_flush3_lightblue(ledact_t *act);
int act_flush4(ledact_t *act);
int act_on(ledact_t *act);
int act_off(ledact_t *act);
int act_blink1(ledact_t *act);
int act_blink2(ledact_t *act);
int act_blink3(ledact_t *act);
int act_blink4(ledact_t *act);
int act_blink5(ledact_t *act);
int act_blink6(ledact_t *act);
int act_blink7(ledact_t *act);
int act_blink8(ledact_t *act);
int act_blink9(ledact_t *act);
int act_blink10(ledact_t *act);
int act_blink11(ledact_t *act);
int act_blink12(ledact_t *act);
int act_blink13(ledact_t *act);
int act_blink14(ledact_t *act);
int act_blink15(ledact_t *act);
int act_blink16(ledact_t *act);
int act_blink17(ledact_t *act);

typedef enum {
	LEDFUNC_ACT_ONESHOT = 0,
	LEDFUNC_ACT_ONESHOT_RED,
	LEDFUNC_ACT_ONESHOT_ORANGE,
	LEDFUNC_ACT_1SEC_ORANGE,
	LEDFUNC_ACT_2SEC_GREEN,
	LEDFUNC_ACT_BLINK_NORMAL1,
	LEDFUNC_ACT_FLUSH,
	LEDFUNC_ACT_FLUSH_GREEN,
	LEDFUNC_ACT_FLUSH2_RED,
	LEDFUNC_ACT_FLUSH3_LIGHTBLUE,
	LEDFUNC_ACT_ON,
	LEDFUNC_ACT_OFF,
	LEDFUNC_ACT_BLINK1,
	LEDFUNC_ACT_BLINK2,
	LEDFUNC_ACT_BLINK3,
	LEDFUNC_ACT_BLINK4,
	LEDFUNC_ACT_BLINK5,
	LEDFUNC_ACT_BLINK6,
	LEDFUNC_ACT_BLINK7,
	LEDFUNC_ACT_BLINK8,
	LEDFUNC_ACT_BLINK9,
	LEDFUNC_ACT_BLINK10,
	LEDFUNC_ACT_MAX
} ledfunc_t;

typedef struct {
	ledact_status_t status;
	ledact_bitmap_t action;
	int (*func)(ledact_t *act);
	int on_color;
	int off_color;
	int color_3rd;
	int sync;
} action_list_t;

typedef struct {
	ledact_blinkspeed_t blinkspeed;
	ledact_bitmap_t action;
} blinkspeed_list_t;

typedef struct {
	const char *name;
	ledtype_t type;
} type_name_list_t;

typedef struct {
	const char *name;
	ledact_type_t act;
} act_name_list_t;

typedef struct {
	const char *name;
	ledact_status_t status;
} status_name_list_t;

typedef struct {
	const char *name;
	ledact_blinkmode_t mode;
} blinkmode_name_list_t;

typedef struct {
	const char *name;
	lednm_act_t nm_act;
} nm_act_name_list_t;

typedef struct {
	uint32_t stat;
	uint32_t temp_stat;
	uint32_t count;
} led_nightmode_t;

typedef enum {
	LEDCOLOR_NONE,
	LEDCOLOR_GREEN,
	LEDCOLOR_RED,
	LEDCOLOR_ORANGE,
	LEDCOLOR_BLUE,
	LEDCOLOR_LIGHTBLUE,
	LEDCOLOR_PINK,
	LEDCOLOR_WHITE,
	LEDCOLOR_MAX,
} ledcolor_t;

struct led_bitmap {
	u_int32_t color[LEDCOLOR_MAX];
	u_int32_t mask;
};

struct led_softc {
	struct {
		struct timer_list chnd;
		unsigned count;
		ledact_t action[LEDT_MAX];
	} led;

	const ledtype_t *type_alias;
	const ledact_type_t *act_alias;
	const action_list_t *action_list;
	const blinkspeed_list_t *blinkspeed_list;
	const type_name_list_t *type_name_list;
	const act_name_list_t *act_name_list;
	const struct led_bitmap *bitmap;
	void (*ledwrite)(void *, uint32_t, int);
	void *ledarg;
	led_nightmode_t nightmode;
};

extern struct led_softc *led_sc;

static inline int
ledwrite(ledtype_t type, ledact_type_t action, int enable)
{
	struct led_softc *sc = led_sc;
	ledact_t *act;
	ledact_bitmap_t actbit;
	ledtype_t type_alias;
	ledact_type_t act_alias;

	if ((type >= LEDT_MAX) || (type == 0) || 
	    (action >= LEDACT_MAX) || action == 0) {
		return 0;
	}
	if (((type_alias = sc->type_alias[type]) <= 0) ||
	    ((act_alias = sc->act_alias[action]) <= 0)) {
		return 0;
	}
	act = &sc->led.action[type_alias];
	actbit = (ledact_bitmap_t) 1 << (act_alias - 1);
	if (enable) {
		if ((act->action & actbit) == 0) {
			act->action |= actbit;
			act->count = 0;
		}
	} else {
		if ((act->action & actbit) != 0) {
			act->action &= ~actbit;
			act->count = 0;
		}
	}
	return 0;
}

int ledactive(ledtype_t type);
ledact_status_t ledstatus(ledtype_t type);
ledact_status_t ledstatus_inactive(ledtype_t type);
ledact_blinkspeed_t ledstatus_blink(ledact_blinkmode_t mode, ledtype_t type);
int ledwrite_nightmode(lednm_act_t action);
void led_nm_status(u_int32_t *stat);

void led_attach_common(void *);
void led_detach_common(void *);

#else
#include "ledprofile.h"

typedef unsigned int	u_int32_t;
typedef unsigned int	uint32_t;

int ledwrite(ledtype_t type, ledact_type_t action, int enable);
int ledactive(ledtype_t type);
ledact_status_t ledstatus(ledtype_t type);
ledact_status_t ledstatus_inactive(ledtype_t type);
ledact_blinkspeed_t ledstatus_blink(ledact_blinkmode_t mode, ledtype_t type);
int ledwrite_nightmode(lednm_act_t action);
int led_nm_status(uint32_t *stat);

#define ledstatus_blinkspeed(type) ledstatus_blink(LEDBM_NORMAL, type)

#endif

#define LED_MAX_NAME_SIZE 32
#define LED_IDX_MATCHNAME -1
#define LED_IDX_MATCHSTATUS -2

struct led_write_info {
	ledtype_t type;
	ledact_type_t action;
	int enable;
};

struct led_scan_info {
	ledtype_t type;
	int active;
};

struct led_status_info {
	ledtype_t type;
	ledact_status_t status;
};

struct led_blinkspeed_info {
	ledtype_t type;
	ledact_blinkspeed_t blinkspeed;
	ledact_blinkmode_t mode;
};

struct led_type_name_info {
	int idx;
	ledtype_t type;
	char name[LED_MAX_NAME_SIZE];
};

struct led_act_name_info {
	int idx;
	ledact_type_t act;
	char name[LED_MAX_NAME_SIZE];
};

struct led_status_name_info {
	int idx;
	ledact_status_t status;
	char name[LED_MAX_NAME_SIZE];
};

struct led_blinkmode_name_info {
	int idx;
	ledact_blinkmode_t mode;
	char name[LED_MAX_NAME_SIZE];
};

struct led_nm_act_info {
	lednm_act_t action;
};

struct led_nm_status_info {
	u_int32_t stat;
};

struct led_nm_act_name_info {
	int idx;
	lednm_act_t nm_act;
	char name[LED_MAX_NAME_SIZE];
};

#define LED_IOC_WRITE _IOW('L', 1, struct led_write_info)
#define LED_IOC_SCAN _IOWR('L', 2, struct led_scan_info)
#define LED_IOC_STATUS _IOWR('L', 3, struct led_status_info)
#define LED_IOC_STATUS_INACTIVE _IOWR('L', 4, struct led_status_info)
#define LED_IOC_TYPENAME _IOWR('L', 5, struct led_type_name_info)
#define LED_IOC_ACTNAME _IOWR('L', 6, struct led_act_name_info)
#define LED_IOC_STATUSNAME _IOWR('L', 7, struct led_status_name_info)
#define LED_IOC_STATUS_BLINKSPEED _IOWR('L', 8, struct led_blinkspeed_info)
#define LED_IOC_BLINKMODENAME _IOWR('L', 9, struct led_blinkmode_name_info)
#define LED_IOC_NM_ACTION _IOW('L', 10, struct led_nm_act_info)
#define LED_IOC_NM_STATUS _IOWR('L', 11, struct led_nm_status_info)
#define LED_IOC_NM_ACTNAME _IOWR('L', 12, struct led_nm_act_name_info)

#define LEDWRITE_WS_STATUS(action, enable) \
		ledwrite(LEDT_ALL, action, enable);

#endif
