#if !defined(_LEDPROFILE_H_)
#define _LEDPROFILE_H_

typedef enum {
	LEDT_ALL = 1,
	LEDT_STAT,
	LEDT_WAN,
	LEDT_LAN,
#if 1
	LEDT_WIFI,
	LEDT_ZWAVE,
	LEDT_BLE,
	LEDT_POWER,
	LEDT_BATTERY,
	LEDT_ANT1,
	LEDT_ANT2,
	LEDT_ANT3,
#endif
	LEDT_RSSI,
	LEDT_REAL_MAX,

	LEDT_PPP,
	LEDT_VOIP,
	LEDT_AIR,
	LEDT_AIR2,
	LEDT_UPDATE,
	LEDT_TV_MODE,
	LEDT_CLIENT,
	LEDT_LOGO,

	LEDT_REBOOT,
	LEDT_INIT,
	LEDT_FW_UPDATE,
	LEDT_EMRG,
	LEDT_MQTT,
	LEDT_LTE,
	LEDT_WAN_WIFI,
	LEDT_WAN_ETH,
	LEDT_WPS,
	LEDT_ALIAS_ACTIVE,
	LEDT_ALIAS_DA,
	LEDT_WZC_PROGRESS,
	LEDT_WZC_ERROR,
	LEDT_AUTO_SUBNET_ERR,
	LEDT_IP_ASSIGN,
	LEDT_IP_CONFLICT,
	LEDT_WS_STATUS1,
	LEDT_WS_STATUS2,
	LEDT_WS_STATUS3,
	LEDT_INIT_ASSIGN,
	LEDT_VPN,
	LEDT_ALIAS_VPN,
	LEDT_LINE,
	LEDT_ALARM,
	LEDT_CONFIG,
	LEDT_LTE_STATUS,
	LEDT_INIT_STATUS,
	LEDT_SIM_STATUS,
	LEDT_MAX
} ledtype_t;

typedef enum {
	LEDACT_NONE,
	LEDACT_ONESHOT,
	LEDACT_NORMAL,
	LEDACT_NORMAL_RED,
	LEDACT_NORMAL_ORANGE,
	LEDACT_BLINK1,
	LEDACT_BLINK2,
	LEDACT_BLINK3,
	LEDACT_BLINK1_ORANGE,
	LEDACT_BLINK1_GREEN_ORANGE,
	LEDACT_BLINK1_RED,
	LEDACT_BLINK3_RED,
	LEDACT_BLINK1_ORANGE3,
	LEDACT_FLUSH,
	LEDACT_FLUSH_GREEN,
	LEDACT_ONESHOT_ORANGE,
	LEDACT_NORMAL_RED2,
	LEDACT_BLINK1_ORANGE2,
	LEDACT_BLINK1_GREEN_ORANGE2,
	LEDACT_BLINK2_RED,
	LEDACT_BLINK5_ORANGE,
	LEDACT_BLINK5,
	LEDACT_NORMAL_ORANGE2,
	LEDACT_BLINK7_ORANGE_GREEN,
	LEDACT_BLINK8_RED,
	LEDACT_BLINK1_RED2,
	LEDACT_BLINK9_RED_GREEN_ORANGE,
	LEDACT_BLINK3_RED_GREEN,
	LEDACT_1SEC_ORANGE,
	LEDACT_INACTIVATE,
	LEDACT_CLEAR,
	LEDACT_ALLCLEAR,
	LEDACT_NORMAL2,
	LEDACT_BLINK1_2,
	LEDACT_BLINK1_3,
	LEDACT_BLINK1_4,
	LEDACT_BLINK10_RED,
	LEDACT_BLINK11_ORANGE,
	LEDACT_BLINK12,
	LEDACT_BLINK12_RED,
	LEDACT_BLINK12_ORANGE,
	LEDACT_BLINK13,
	LEDACT_BLINK13_RED,
	LEDACT_BLINK13_ORANGE,
	LEDACT_BLINK13_BLUE,
	LEDACT_NORMAL_BLUE,
	LEDACT_NORMAL_ORANGE3,
	LEDACT_INACTIVATE2,
	LEDACT_REAL_MAX,

	LEDACT_VOIP_AVAILABLE,
	LEDACT_VOIP_UNAVAILABLE,
	LEDACT_VOIP_IP_ACT,
	LEDACT_VOIP_IP_PSTN_ACT1,
	LEDACT_VOIP_IP_PSTN_ACT2,
	LEDACT_VOIP_PSTN_ACT,
	LEDACT_VOIP_STOP,
	LEDACT_VOIP_INIT,
	LEDACT_PPP_IDLE,
	LEDACT_LCP_STARTING,
	LEDACT_AUTH_STARTING,
	LEDACT_AUTH_SUCCESSED,
	LEDACT_IPCP_STARTING,
	LEDACT_IPCP_OPENED,
	LEDACT_IPCP_OPENED_MULTI,
	LEDACT_IPV6CP_STARTING,
	LEDACT_IPV6CP_OPENED,
	LEDACT_IPV6CP_OPENED_MULTI,
	LEDACT_DA_CONNECTING,
	LEDACT_DA_CONFIG_WRITING,
	LEDACT_DA_DMS_CONNECT_WAIT_RECORDED,
	LEDACT_DA_DMS_CONNECT_WAIT_NO_RECORD,
	LEDACT_ALIAS_DMS_CONNECT_WAIT,
	LEDACT_DA_DMS_CONNECT_WAIT,
	LEDACT_DA_SLEEPING,
	LEDACT_ALIAS_NO_CONFIG,
	LEDACT_VUP_FIRMWARE_UPDATE,
	LEDACT_VUP_EMERGENCY_COPY,
	LEDACT_VUP_ALARM,
	LEDACT_VUP_FW_DOWNLOAD,
	LEDACT_VUP_HAVE_NEWFW,
	LEDACT_ADSL_LINKUP,
	LEDACT_ADSL_TRAINING,
	LEDACT_ADSL_ACTIVATING,
	LEDACT_WZC_SEARCHING_STA,
	LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_CARD,
	LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_ETHERBOX,
	LEDACT_WZC_COMPLETE,
	LEDACT_WZC_FAIL,
	LEDACT_WPS_COMPLETE,
	LEDACT_WPS_START,
	LEDACT_WPS_FAIL,
	LEDACT_WPS_SETTING,
	LEDACT_WPS_SESSION_OVERLAP,
	LEDACT_AUTO_SUBNET_ERR,
	LEDACT_IP_ASSIGN,
	LEDACT_ALIAS_CONFLICT_ADDR,
	LEDACT_IP_CONFLICT,
	LEDACT_WS_NONE,
	LEDACT_WS_START,
	LEDACT_WS_PPPOE,
	LEDACT_WS_FAIL,
	LEDACT_INIT_ASSIGN,
	LEDACT_ACF_SUCCESS,
	LEDACT_ACF_SETTING,
	LEDACT_ACF_AUTH_FAIL,
	LEDACT_ACF_OTHER_FAIL,
	DHCP4C_LEDACT_AUTH_FAIL,
	DHCP4C_LEDACT_OTHER_FAIL,
	DHCP4C_LEDACT_CONF_START,
	DHCP4C_LEDACT_CONF_SUCCESS,
	DHCP4C_LEDACT_NOTHING,
	DHCP6C_LEDACT_AUTH_FAIL,
	DHCP6C_LEDACT_OTHER_FAIL,
	DHCP6C_LEDACT_CONF_START,
	DHCP6C_LEDACT_CONF_SUCCESS,
	DHCP6C_LEDACT_NOTHING,
	LEDACT_USB_MEMORY_WRITING,
	LEDACT_ECO,
	LEDACT_REBOOT,
	LEDACT_INIT1,
	LEDACT_INIT2,
	LEDACT_EMERG,
	LEDACT_WAN_CONNECTING,
	LEDACT_WAN_NOT_CONNECTED,
	LEDACT_WAN_CONNECTED,
	LEDACT_WAN_WAITING,
	LEDACT_LTE_POWER_HIGH,
	LEDACT_LTE_POWER_MID,
	LEDACT_LTE_POWER_LOW,
	LEDACT_WIFI_STOPPED,
	LEDACT_DFS_RUNNING,
	LEDACT_WIFI_5G_AVAILABLE,
	LEDACT_WIFI_2G_AVAILABLE,
	LEDACT_MQTT_CONNECT,
	LEDACT_MQTT_NOT_CONNECTED,
	LEDACT_MQTT_COMM,
	LEDACT_ZWAVE_STOPPED,
	LEDACT_ZWAVE_FAILED,
	LEDACT_ZWAVE_PAIR_FAILED,
	LEDACT_ZWAVE_PAIR_OK,
	LEDACT_ZWAVE_INCLUSION,
	LEDACT_ZWAVE_EXCLUSION,
	LEDACT_ZWAVE_AVAIL,
	LEDACT_BLE_STOPPED,
	LEDACT_BLE_PAIR_FAILED,
	LEDACT_BLE_PAIR_OK,
	LEDACT_BLE_PAIRING,
	LEDACT_BLE_AVAIL,

	LEDACT_CONFIG,
	LEDACT_INIT_STATUS,
	LEDACT_SIM_UNDETECTED,
	LEDACT_PINLOCK,
	LEDACT_PUKLOCK,
	LEDACT_PIN_UNAPPROVAL,

	LEDACT_BLINK1_BLUE,
	LEDACT_LTE_POWER_OUT,

	LEDACT_INIT_PREPARATION,
	LEDACT_SYS_WAIT,

	LEDACT_MAX

} ledact_type_t;

#define LEDACT_DUMMY 0
#define LEDACT_FLUSH_1 LEDACT_ONESHOT
#define LEDACT_FLUSH_2 LEDACT_ONESHOT_ORANGE
#define LEDACT_FLUSH_3 LEDACT_1SEC_ORANGE
#define LEDACT_FLUSH_6 LEDACT_FLUSH

#define LEDACT_WEC_COMPLETE LEDACT_WPS_COMPLETE
#define LEDACT_WEC_START LEDACT_WPS_START
#define LEDACT_WEC_FAIL LEDACT_WPS_FAIL
#define LEDACT_WEC_SETTING LEDACT_WPS_SETTING
#define LEDACT_WEC_SESSION_OVERLAP LEDACT_WPS_SESSION_OVERLAP

#if defined(__KERNEL__)
typedef uint64_t ledact_bitmap_t;

struct multi_type_list {
	ledtype_t type;
	ledact_type_t action;
	const ledact_type_t *acts;
};

#if defined(LED_NIGHTMODE)
static const struct multi_type_list nm_all_list[] = {
	{LEDT_POWER, LEDACT_INACTIVATE2, NULL},
	{LEDT_RSSI, LEDACT_INACTIVATE2, NULL},
	{LEDT_WIFI, LEDACT_INACTIVATE2, NULL},
	{LEDT_MAX, LEDACT_MAX, NULL}
};
#endif

#else

int ledwrite_eco(int);

typedef enum {
	LED_ROUTER_OFF_MODE_1 = 0,
	LED_ROUTER_OFF_MODE_2,
	LED_ROUTER_OFF_MODE_MAX
} led_router_off_mode_t;

int ledwrite_router_off(led_router_off_mode_t, int);

#if defined(LIBLED_MULTIACT_LIST)

#define HAVE_ECO_LIST

struct eco_list {
	ledtype_t type;
	ledact_type_t action;
	const ledact_type_t *acts;
};

int ledwrite_multi_type(const struct eco_list *, int);

#ifdef IMPORT_ECO_LIST
static struct eco_list eco_list[] = {
	{LEDT_POWER, LEDACT_INACTIVATE, NULL},
	{LEDT_BATTERY, LEDACT_INACTIVATE, NULL},
	{LEDT_LAN, LEDACT_INACTIVATE, NULL},
	{LEDT_WAN, LEDACT_INACTIVATE, NULL},
	{LEDT_ANT1, LEDACT_INACTIVATE, NULL},
	{LEDT_ANT2, LEDACT_INACTIVATE, NULL},
	{LEDT_ANT3, LEDACT_INACTIVATE, NULL},
	{LEDT_MAX, LEDACT_MAX, NULL}
};
#endif

#endif
#endif

#endif
