#ifndef _BTNUVAR_H
#define _BTNUVAR_H

#define BTNU_DEVNAME "/dev/btnu0"
#define BTNU0_DEVNAME "/dev/btnu0"
#define BTNU1_DEVNAME "/dev/btnu1"

#if defined(__KERNEL__)

#ifdef LIST_HEAD
#undef LIST_HEAD
#endif

#include "queue.h"

struct btnu_event_info {
	struct task_struct *p;

	wait_queue_head_t sc_rsel;
#define BTNU_MAX_EVENTS 10
	unsigned sc_event_in, sc_event_out;
	struct {
		int type;
		unsigned press_msec;
	} sc_event[BTNU_MAX_EVENTS];

	LIST_ENTRY(btnu_event_info) event_links;
};

struct btnucom {
	struct cdev cdev;
	dev_t dev;
	void *parent;
	int (*io_read)(void *);
	struct timer_list tick_callout;
	int open_count;

	int sc_current;
	int sc_detect;
	unsigned sc_threshold;
	unsigned sc_timeout;
	unsigned sc_count;
	unsigned sc_detect_count;
	unsigned sc_longtime;

	int io_dummy;

	LIST_HEAD(event_list, btnu_event_info) event_list;
};

int btnucom_attach(struct btnucom *, int, void *);
void btnucom_detach(struct btnucom *);

#endif

struct btnu_read_event_info {
#define BTNU_EVENT_NONE 0
#define BTNU_EVENT_ON 1
#define BTNU_EVENT_PUSH 2
#define BTNU_EVENT_TIMEOUT 3
#define BTNU_EVENT_OFF 4
#define BTNU_EVENT_LONGPRESS 5
	int event;
#define HAVE_BTNU_PRESS_TIME 1
	unsigned press_msec;
};

#ifndef lint
static inline const char *
btnu_event_name(int event)
{
	switch (event) {
	case BTNU_EVENT_ON:		return "on";
	case BTNU_EVENT_PUSH:		return "pushed";
	case BTNU_EVENT_TIMEOUT:	return "timeout";
	case BTNU_EVENT_OFF:		return "off";
	case BTNU_EVENT_LONGPRESS:	return "long press";
	default:			return "unknown";
	}
}
#endif

struct btnu_read_info {
	int on;
};

struct btnu_read_info_ext {
	int on;
	unsigned detect_time_ms;
};

#define BTNU_IOC_READ _IOR('B', 1, struct btnu_read_info)
#define BTNU_IOC_EVENT _IOR('B', 2, struct btnu_read_event_info)
#define BTNU_IOC_CLOSE _IO('B', 3)
#define BTNU_IOC_READ_EXT _IOR('B', 4, struct btnu_read_info_ext)

#endif
