/* Copyright (c) 2013-2014, The Linux Foundation. All rights reserved.
 * Copyright (c) 2014-2015, NEC Platforms, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <asm/mach/map.h>
#include <asm/mach/arch.h>
#include <mach/board.h>
#include <mach/msm_iomap.h>
#include <linux/gpio.h>
#include "board-dt.h"
#include "board-9640-touch.h"
#include "msm-pdm-leds.h"

#if defined(CONFIG_PLATFORM_NEC)
static struct gpio nec_board_gpios[] __initdata = {
	{ 81, GPIOF_IN | GPIOF_EXPORT, "SIM1_DETECT"  },
	{ 82, GPIOF_IN | GPIOF_EXPORT, "SIM2_DETECT"  },
	{ 89, GPIOF_OUT_INIT_LOW | GPIOF_EXPORT, "PMIC_RESET"  },
	{ 90, GPIOF_IN | GPIOF_EXPORT, "BT_TEST"  },
	{ 97, GPIOF_IN | GPIOF_EXPORT, "PKG ID1"  },
	{ 98, GPIOF_IN | GPIOF_EXPORT, "PKG ID2"  },
	{ 99, GPIOF_IN | GPIOF_EXPORT, "PKG ID3"  },
};
#endif /* defined(CONFIG_PLATFORM_NEC) */

/*
 * Used to satisfy dependencies for devices that need to be
 * run early or in a particular order. Most likely your device doesn't fall
 * into this category, and thus the driver should not be added here. The
 * EPROBE_DEFER can satisfy most dependency problems.
 */
void __init mdm9640_add_drivers(void)
{
	cyttsp3_touch_init();
	msm_pdm_leds_init();
}

static void __init mdm9640_map_io(void)
{
	msm_map_mdm9640_io();
}

static const char *mdm9640_dt_match[] __initconst = {
	"qcom,mdm9640",
	NULL
};

static void __init mdm9640_init(void)
{
	int rc;

	board_dt_populate(NULL);
#if defined(CONFIG_PLATFORM_NEC)
	rc = gpio_request_array(nec_board_gpios, ARRAY_SIZE(nec_board_gpios));
	if (rc) {
		pr_err("%s gpio_request_array board failed %d\n",
		    __func__, rc);
	}
#endif /* defined(CONFIG_PLATFORM_NEC) */

	mdm9640_add_drivers();
}

DT_MACHINE_START(MDM9640_DT,
		 "Qualcomm Technologies, Inc. MSM 9640 (Flattened Device Tree)")
	.init_machine		= mdm9640_init,
	.dt_compat		= mdm9640_dt_match,
	.map_io			= mdm9640_map_io,
MACHINE_END
