/* Copyright (c) 2013-2014, The Linux Foundation. All rights reserved.
 * Copyright (c) 2014-2015 NEC Platforms, Ltd., All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <linux/err.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>
#include <linux/io.h>
#include <linux/gpio.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/of_platform.h>
#include <asm/mach/arch.h>
#include <mach/board.h>
#include <mach/gpiomux.h>

#include <linux/leds.h>

#include "msm-pdm-leds.h"

#define PERPH_WEB_BLOCK_ADDR (0x00068000)
#define SIZE_16B (0x10)

static struct resource resources_led[] = {
	{
		.start  = PERPH_WEB_BLOCK_ADDR,
		.end    = PERPH_WEB_BLOCK_ADDR + (SIZE_16B) - 1,
		.name   = "led-msm-pdm",
		.flags  = IORESOURCE_MEM,
	},
};

static struct led_info msm_pdm_led_pdata = {
	.name = "lcd-backlight",
};

struct platform_device led_pdev = {
	.name   = "leds-msm-pdm",
	/* use pdev id to represent pdm id */
	.id     = 0,
	.num_resources  = ARRAY_SIZE(resources_led),
	.resource       = resources_led,
	.dev    = {
		.platform_data  = &msm_pdm_led_pdata,
	},
};

/*****************************************************************************/
#ifdef CONFIG_LEDS_MSM_PDM
void __init msm_pdm_leds_init(void)
{
	platform_device_register(&led_pdev);
}
#else
void __init msm_pdm_leds_init(void)
{
}
#endif /* CONFIG_LEDS_MSM_PDM */
