/* Copyright (c) NEC Platforms,Ltd. 2015 All rights reserved. */

#include <linux/kernel.h>
#include <linux/err.h>
#include <linux/io.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/clk.h>
#include <linux/cpu.h>
#include <linux/sched.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <mach/board.h>

#define MSM_TMON_INFO_START	(0x08600000+0xac0)

struct msm_tmon_into {
	uint64_t monthly_lte3g;
	uint64_t monthly_roaming;
	uint64_t monthly_wifi;
	uint64_t daily_lte3g;
	uint64_t daily_roaming;
};

static struct msm_tmon_into *tmon_info=NULL;

struct msm_tmon_into *
msm_tmon_info_get(void)
{
	if (tmon_info)
		return tmon_info;
	tmon_info = ioremap(MSM_TMON_INFO_START, sizeof(*tmon_info));
	if (tmon_info == NULL)
		panic("%s\n", __func__);
	return tmon_info;
}

static int tmon_info_set(const char *str, struct kernel_param *kp)
{
	int offset = (int)kp->arg;
	u64 val;

	sscanf(str, "%llu", &val);

	writeq_relaxed(val, (void __iomem *)((u32)msm_tmon_info_get() + offset));

	return 0;
}

static int tmon_info_get(char *buffer, const struct kernel_param *kp)
{
	int offset = (int)kp->arg;
	int ret;

	ret = sprintf(buffer, "%llu", readq_relaxed((void __iomem *)((u32)msm_tmon_info_get() + offset)));

	return ret;
}

module_param_call(tmon_info_monthly_lte3g   , tmon_info_set , tmon_info_get , (void *)0  , 0644);
module_param_call(tmon_info_monthly_roaming , tmon_info_set , tmon_info_get , (void *)8  , 0644);
module_param_call(tmon_info_monthly_wifi    , tmon_info_set , tmon_info_get , (void *)16 , 0644);
module_param_call(tmon_info_daily_lte3g     , tmon_info_set , tmon_info_get , (void *)24 , 0644);
module_param_call(tmon_info_daily_roaming   , tmon_info_set , tmon_info_get , (void *)32 , 0644);
