/* Copyright (c) 2015, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __EP_PCIE_PHY_H
#define __EP_PCIE_PHY_H

#define QSERDES_COM_SYS_CLK_CTRL                      0x0
#define QSERDES_COM_PLL_VCOTAIL_EN                    0x4
#define QSERDES_COM_CMN_MODE                          0x8
#define QSERDES_COM_IE_TRIM                           0xC
#define QSERDES_COM_IP_TRIM                           0x10
#define QSERDES_COM_PLL_CNTRL                         0x14
#define QSERDES_COM_PLL_PHSEL_CONTROL                 0x18
#define QSERDES_COM_IPTAT_TRIM_VCCA_TX_SEL            0x1C
#define QSERDES_COM_PLL_PHSEL_DC                      0x20
#define QSERDES_COM_PLL_IP_SETI                       0x24
#define QSERDES_COM_CORE_CLK_IN_SYNC_SEL              0x28
#define QSERDES_COM_PLL_BKG_KVCO_CAL_EN               0x2C
#define QSERDES_COM_BIAS_EN_CLKBUFLR_EN               0x30
#define QSERDES_COM_PLL_CP_SETI                       0x34
#define QSERDES_COM_PLL_IP_SETP                       0x38
#define QSERDES_COM_PLL_CP_SETP                       0x3C
#define QSERDES_COM_ATB_SEL1                          0x40
#define QSERDES_COM_ATB_SEL2                          0x44
#define QSERDES_COM_SYSCLK_EN_SEL_TXBAND              0x48
#define QSERDES_COM_RESETSM_CNTRL                     0x4C
#define QSERDES_COM_RESETSM_CNTRL2                    0x50
#define QSERDES_COM_RESETSM_CNTRL3                    0x54
#define QSERDES_COM_DIV_REF1                          0x58
#define QSERDES_COM_DIV_REF2                          0x5C
#define QSERDES_COM_KVCO_COUNT1                       0x60
#define QSERDES_COM_KVCO_COUNT2                       0x64
#define QSERDES_COM_KVCO_CAL_CNTRL                    0x68
#define QSERDES_COM_KVCO_CODE                         0x6C
#define QSERDES_COM_VREF_CFG1                         0x70
#define QSERDES_COM_VREF_CFG2                         0x74
#define QSERDES_COM_VREF_CFG3                         0x78
#define QSERDES_COM_VREF_CFG4                         0x7C
#define QSERDES_COM_VREF_CFG5                         0x80
#define QSERDES_COM_VREF_CFG6                         0x84
#define QSERDES_COM_PLLLOCK_CMP1                      0x88
#define QSERDES_COM_PLLLOCK_CMP2                      0x8C
#define QSERDES_COM_PLLLOCK_CMP3                      0x90
#define QSERDES_COM_PLLLOCK_CMP_EN                    0x94
#define QSERDES_COM_BGTC                              0x98
#define QSERDES_COM_PLL_TEST_UPDN                     0x9C
#define QSERDES_COM_PLL_VCO_TUNE                      0xA0
#define QSERDES_COM_DEC_START1                        0xA4
#define QSERDES_COM_PLL_AMP_OS                        0xA8
#define QSERDES_COM_SSC_EN_CENTER                     0xAC
#define QSERDES_COM_SSC_ADJ_PER1                      0xB0
#define QSERDES_COM_SSC_ADJ_PER2                      0xB4
#define QSERDES_COM_SSC_PER1                          0xB8
#define QSERDES_COM_SSC_PER2                          0xBC
#define QSERDES_COM_SSC_STEP_SIZE1                    0xC0
#define QSERDES_COM_SSC_STEP_SIZE2                    0xC4
#define QSERDES_COM_RES_CODE_UP                       0xC8
#define QSERDES_COM_RES_CODE_DN                       0xCC
#define QSERDES_COM_RES_CODE_UP_OFFSET                0xD0
#define QSERDES_COM_RES_CODE_DN_OFFSET                0xD4
#define QSERDES_COM_RES_CODE_START_SEG1               0xD8
#define QSERDES_COM_RES_CODE_START_SEG2               0xDC
#define QSERDES_COM_RES_CODE_CAL_CSR                  0xE0
#define QSERDES_COM_RES_CODE                          0xE4
#define QSERDES_COM_RES_TRIM_CONTROL                  0xE8
#define QSERDES_COM_RES_TRIM_CONTROL2                 0xEC
#define QSERDES_COM_RES_TRIM_EN_VCOCALDONE            0xF0
#define QSERDES_COM_FAUX_EN                           0xF4
#define QSERDES_COM_DIV_FRAC_START1                   0xF8
#define QSERDES_COM_DIV_FRAC_START2                   0xFC
#define QSERDES_COM_DIV_FRAC_START3                   0x100
#define QSERDES_COM_DEC_START2                        0x104
#define QSERDES_COM_PLL_RXTXEPCLK_EN                  0x108
#define QSERDES_COM_PLL_CRCTRL                        0x10C
#define QSERDES_COM_PLL_CLKEPDIV                      0x110
#define QSERDES_COM_PLL_FREQUPDATE                    0x114
#define QSERDES_COM_PLL_BKGCAL_TRIM_UP                0x118
#define QSERDES_COM_PLL_BKGCAL_TRIM_DN                0x11C
#define QSERDES_COM_PLL_BKGCAL_TRIM_MUX               0x120
#define QSERDES_COM_PLL_BKGCAL_VREF_CFG               0x124
#define QSERDES_COM_PLL_BKGCAL_DIV_REF1               0x128
#define QSERDES_COM_PLL_BKGCAL_DIV_REF2               0x12C
#define QSERDES_COM_MUXADDR                           0x130
#define QSERDES_COM_LOW_POWER_RO_CONTROL              0x134
#define QSERDES_COM_POST_DIVIDER_CONTROL              0x138
#define QSERDES_COM_HR_OCLK2_DIVIDER                  0x13C
#define QSERDES_COM_HR_OCLK3_DIVIDER                  0x140
#define QSERDES_COM_PLL_VCO_HIGH                      0x144
#define QSERDES_COM_RESET_SM                          0x148
#define QSERDES_COM_MUXVAL                            0x14C
#define QSERDES_TX_BIST_MODE_LANENO                   0x200
#define QSERDES_TX_CLKBUF_ENABLE                      0x204
#define QSERDES_TX_TX_EMP_POST1_LVL                   0x208
#define QSERDES_TX_TX_DRV_LVL                         0x20C
#define QSERDES_TX_RESET_TSYNC_EN                     0x210
#define QSERDES_TX_LPB_EN                             0x214
#define QSERDES_TX_RES_CODE_UP                        0x218
#define QSERDES_TX_RES_CODE_DN                        0x21C
#define QSERDES_TX_PERL_LENGTH1                       0x220
#define QSERDES_TX_PERL_LENGTH2                       0x224
#define QSERDES_TX_SERDES_BYP_EN_OUT                  0x228
#define QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_DRVR_EN   0x22C
#define QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN         0x230
#define QSERDES_TX_BIST_PATTERN1                      0x234
#define QSERDES_TX_BIST_PATTERN2                      0x238
#define QSERDES_TX_BIST_PATTERN3                      0x23C
#define QSERDES_TX_BIST_PATTERN4                      0x240
#define QSERDES_TX_BIST_PATTERN5                      0x244
#define QSERDES_TX_BIST_PATTERN6                      0x248
#define QSERDES_TX_BIST_PATTERN7                      0x24C
#define QSERDES_TX_BIST_PATTERN8                      0x250
#define QSERDES_TX_LANE_MODE                          0x254
#define QSERDES_TX_IDAC_CAL_LANE_MODE                 0x258
#define QSERDES_TX_IDAC_CAL_LANE_MODE_CONFIGURATION   0x25C
#define QSERDES_TX_ATB_SEL1                           0x260
#define QSERDES_TX_ATB_SEL2                           0x264
#define QSERDES_TX_RCV_DETECT_LVL                     0x268
#define QSERDES_TX_PRBS_SEED1                         0x26C
#define QSERDES_TX_PRBS_SEED2                         0x270
#define QSERDES_TX_PRBS_SEED3                         0x274
#define QSERDES_TX_PRBS_SEED4                         0x278
#define QSERDES_TX_RESET_GEN                          0x27C
#define QSERDES_TX_TRAN_DRVR_EMP_EN                   0x280
#define QSERDES_TX_TX_INTERFACE_MODE                  0x284
#define QSERDES_TX_PWM_CTRL                           0x288
#define QSERDES_TX_PWM_DATA                           0x28C
#define QSERDES_TX_PWM_ENC_DIV_CTRL                   0x290
#define QSERDES_TX_VMODE_CTRL1                        0x294
#define QSERDES_TX_VMODE_CTRL2                        0x298
#define QSERDES_TX_VMODE_CTRL3                        0x29C
#define QSERDES_TX_VMODE_CTRL4                        0x2A0
#define QSERDES_TX_VMODE_CTRL5                        0x2A4
#define QSERDES_TX_VMODE_CTRL6                        0x2A8
#define QSERDES_TX_VMODE_CTRL7                        0x2AC
#define QSERDES_TX_TX_ALOG_INTF_OBSV_CNTL             0x2B0
#define QSERDES_TX_BIST_STATUS                        0x2B4
#define QSERDES_TX_BIST_ERROR_COUNT1                  0x2B8
#define QSERDES_TX_BIST_ERROR_COUNT2                  0x2BC
#define QSERDES_TX_TX_ALOG_INTF_OBSV                  0x2C0
#define QSERDES_TX_PWM_DEC_STATUS                     0x2C4
#define QSERDES_RX_CDR_CONTROL1                       0x400
#define QSERDES_RX_CDR_CONTROL2                       0x404
#define QSERDES_RX_CDR_CONTROL_HALF                   0x408
#define QSERDES_RX_CDR_CONTROL_QUARTER                0x40C
#define QSERDES_RX_CDR_CONTROL_EIGHTH                 0x410
#define QSERDES_RX_UCDR_FO_GAIN                       0x414
#define QSERDES_RX_UCDR_SO_GAIN                       0x418
#define QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE      0x41C
#define QSERDES_RX_UCDR_FO_TO_SO_DELAY                0x420
#define QSERDES_RX_AUX_CONTROL                        0x424
#define QSERDES_RX_AUX_DATA_TCOARSE                   0x428
#define QSERDES_RX_AUX_DATA_TFINE_LSB                 0x42C
#define QSERDES_RX_AUX_DATA_TFINE_MSB                 0x430
#define QSERDES_RX_RCLK_AUXDATA_SEL                   0x434
#define QSERDES_RX_AC_JTAG_ENABLE                     0x438
#define QSERDES_RX_AC_JTAG_INITP                      0x43C
#define QSERDES_RX_AC_JTAG_INITN                      0x440
#define QSERDES_RX_AC_JTAG_LVL                        0x444
#define QSERDES_RX_AC_JTAG_MODE                       0x448
#define QSERDES_RX_AC_JTAG_RESET                      0x44C
#define QSERDES_RX_RX_RCVR_IQ_EN                      0x450
#define QSERDES_RX_RX_IDAC_I_DC_OFFSETS               0x454
#define QSERDES_RX_RX_IDAC_Q_DC_OFFSETS               0x458
#define QSERDES_RX_RX_IDAC_A_DC_OFFSETS               0x45C
#define QSERDES_RX_RX_IDAC_EN                         0x460
#define QSERDES_RX_RX_IDAC_CTRL0                      0x464
#define QSERDES_RX_RX_IDAC_CTRL1                      0x468
#define QSERDES_RX_RX_EOM_EN                          0x46C
#define QSERDES_RX_RX_EOM_CTRL0                       0x470
#define QSERDES_RX_RX_EOM_CTRL1                       0x474
#define QSERDES_RX_RX_EOM_CTRL2                       0x478
#define QSERDES_RX_RX_EOM_CTRL3                       0x47C
#define QSERDES_RX_RX_EOM_CTRL4                       0x480
#define QSERDES_RX_RX_EOM_CTRL5                       0x484
#define QSERDES_RX_RX_EOM_CTRL6                       0x488
#define QSERDES_RX_RX_EOM_CTRL7                       0x48C
#define QSERDES_RX_RX_EOM_CTRL8                       0x490
#define QSERDES_RX_RX_EOM_CTRL9                       0x494
#define QSERDES_RX_RX_EOM_CTRL10                      0x498
#define QSERDES_RX_RX_EOM_CTRL11                      0x49C
#define QSERDES_RX_RX_HIGHZ_HIGHRATE                  0x4A0
#define QSERDES_RX_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET 0x4A4
#define QSERDES_RX_RX_EQ_GAIN1_LSB                    0x4A8
#define QSERDES_RX_RX_EQ_GAIN1_MSB                    0x4AC
#define QSERDES_RX_RX_EQ_GAIN2_LSB                    0x4B0
#define QSERDES_RX_RX_EQ_GAIN2_MSB                    0x4B4
#define QSERDES_RX_RX_EQU_ADAPTOR_CNTRL1              0x4B8
#define QSERDES_RX_RX_EQU_ADAPTOR_CNTRL2              0x4BC
#define QSERDES_RX_RX_EQU_ADAPTOR_CNTRL3              0x4C0
#define QSERDES_RX_RX_EQU_ADAPTOR_CNTRL4              0x4C4
#define QSERDES_RX_RX_IDAC_CAL_CONFIGURATION          0x4C8
#define QSERDES_RX_RX_IDAC_CAL_CONFIGURATION_2        0x4CC
#define QSERDES_RX_RX_IDAC_TSETTLE_LOW                0x4D0
#define QSERDES_RX_RX_IDAC_TSETTLE_HIGH               0x4D4
#define QSERDES_RX_RX_IDAC_ENDSAMP_LOW                0x4D8
#define QSERDES_RX_RX_IDAC_ENDSAMP_HIGH               0x4DC
#define QSERDES_RX_RX_IDAC_MIDPOINT_LOW               0x4E0
#define QSERDES_RX_RX_IDAC_MIDPOINT_HIGH              0x4E4
#define QSERDES_RX_RX_EQ_OFFSET_LSB                   0x4E8
#define QSERDES_RX_RX_EQ_OFFSET_MSB                   0x4EC
#define QSERDES_RX_RX_EQ_OFFSET_ADAPTOR_CNTRL1        0x4F0
#define QSERDES_RX_RX_OFFSET_ADAPTOR_CNTRL2           0x4F4
#define QSERDES_RX_SIGDET_ENABLES                     0x4F8
#define QSERDES_RX_SIGDET_ENABLES_2                   0x4FC
#define QSERDES_RX_SIGDET_CNTRL                       0x500
#define QSERDES_RX_SIGDET_DEGLITCH_CNTRL              0x504
#define QSERDES_RX_SIGDET_TIMER_LIMIT                 0x508
#define QSERDES_RX_RX_BAND                            0x50C
#define QSERDES_RX_CDR_FREEZE_UP_DN                   0x510
#define QSERDES_RX_RX_INTERFACE_MODE                  0x514
#define QSERDES_RX_JITTER_GEN_MODE                    0x518
#define QSERDES_RX_BUJ_AMP                            0x51C
#define QSERDES_RX_SJ_AMP1                            0x520
#define QSERDES_RX_SJ_AMP2                            0x524
#define QSERDES_RX_SJ_PER1                            0x528
#define QSERDES_RX_SJ_PER2                            0x52C
#define QSERDES_RX_BUJ_STEP_FREQ1                     0x530
#define QSERDES_RX_BUJ_STEP_FREQ2                     0x534
#define QSERDES_RX_PPM_OFFSET1                        0x538
#define QSERDES_RX_PPM_OFFSET2                        0x53C
#define QSERDES_RX_SIGN_PPM_PERIOD1                   0x540
#define QSERDES_RX_SIGN_PPM_PERIOD2                   0x544
#define QSERDES_RX_SSC_CTRL                           0x548
#define QSERDES_RX_SSC_COUNT1                         0x54C
#define QSERDES_RX_SSC_COUNT2                         0x550
#define QSERDES_RX_RX_ALOG_INTF_OBSV_CNTL             0x554
#define QSERDES_RX_PI_CTRL1                           0x558
#define QSERDES_RX_PI_CTRL2                           0x55C
#define QSERDES_RX_PI_QUAD                            0x560
#define QSERDES_RX_IDATA1                             0x564
#define QSERDES_RX_IDATA2                             0x568
#define QSERDES_RX_AUX_DATA1                          0x56C
#define QSERDES_RX_AUX_DATA2                          0x570
#define QSERDES_RX_AC_JTAG_OUTP                       0x574
#define QSERDES_RX_AC_JTAG_OUTN                       0x578
#define QSERDES_RX_RX_SIGDET                          0x57C
#define QSERDES_RX_RX_VDCOFF                          0x580
#define QSERDES_RX_IDAC_CAL_ON                        0x584
#define QSERDES_RX_IDAC_STATUS_I                      0x588
#define QSERDES_RX_IDAC_STATUS_Q                      0x58C
#define QSERDES_RX_IDAC_STATUS_A                      0x590
#define QSERDES_RX_CALST_STATUS_I                     0x594
#define QSERDES_RX_CALST_STATUS_Q                     0x598
#define QSERDES_RX_CALST_STATUS_A                     0x59C
#define QSERDES_RX_EOM_STATUS0                        0x5A0
#define QSERDES_RX_EOM_STATUS1                        0x5A4
#define QSERDES_RX_EOM_STATUS2                        0x5A8
#define QSERDES_RX_EOM_STATUS3                        0x5AC
#define QSERDES_RX_EOM_STATUS4                        0x5B0
#define QSERDES_RX_EOM_STATUS5                        0x5B4
#define QSERDES_RX_EOM_STATUS6                        0x5B8
#define QSERDES_RX_EOM_STATUS7                        0x5BC
#define QSERDES_RX_EOM_STATUS8                        0x5C0
#define QSERDES_RX_EOM_STATUS9                        0x5C4
#define QSERDES_RX_RX_ALOG_INTF_OBSV                  0x5C8
#define QSERDES_RX_READ_EQCODE                        0x5CC
#define QSERDES_RX_READ_OFFSETCODE                    0x5D0
#define PCIE_PHY_SW_RESET                             0x600
#define PCIE_PHY_POWER_DOWN_CONTROL                   0x604
#define PCIE_PHY_START                                0x608
#define PCIE_PHY_TXMGN_V1_V0                          0x60C
#define PCIE_PHY_TXMGN_V3_V2                          0x610
#define PCIE_PHY_TXMGN_LS_V4                          0x614
#define PCIE_PHY_TXDEEMPH_M6DB_V0                     0x618
#define PCIE_PHY_TXDEEMPH_M3P5DB_V0                   0x61C
#define PCIE_PHY_TXDEEMPH_M6DB_V1                     0x620
#define PCIE_PHY_TXDEEMPH_M3P5DB_V1                   0x624
#define PCIE_PHY_TXDEEMPH_M6DB_V2                     0x628
#define PCIE_PHY_TXDEEMPH_M3P5DB_V2                   0x62C
#define PCIE_PHY_TXDEEMPH_M6DB_V3                     0x630
#define PCIE_PHY_TXDEEMPH_M3P5DB_V3                   0x634
#define PCIE_PHY_TXDEEMPH_M6DB_V4                     0x638
#define PCIE_PHY_TXDEEMPH_M3P5DB_V4                   0x63C
#define PCIE_PHY_TXDEEMPH_M6DB_LS                     0x640
#define PCIE_PHY_TXDEEMPH_M3P5DB_LS                   0x644
#define PCIE_PHY_ENDPOINT_REFCLK_DRIVE                0x648
#define PCIE_PHY_RX_IDLE_DTCT_CNTRL                   0x64C
#define PCIE_PHY_POWER_STATE_CONFIG1                  0x650
#define PCIE_PHY_POWER_STATE_CONFIG2                  0x654
#define PCIE_PHY_POWER_STATE_CONFIG3                  0x658
#define PCIE_PHY_RCVR_DTCT_DLY_P1U2_L                 0x65C
#define PCIE_PHY_RCVR_DTCT_DLY_P1U2_H                 0x660
#define PCIE_PHY_RCVR_DTCT_DLY_U3_L                   0x664
#define PCIE_PHY_RCVR_DTCT_DLY_U3_H                   0x668
#define PCIE_PHY_LOCK_DETECT_CONFIG1                  0x66C
#define PCIE_PHY_LOCK_DETECT_CONFIG2                  0x670
#define PCIE_PHY_LOCK_DETECT_CONFIG3                  0x674
#define PCIE_PHY_TSYNC_RSYNC_TIME                     0x678
#define PCIE_PHY_SIGDET_LOW_2_IDLE_TIME               0x67C
#define PCIE_PHY_BEACON_2_IDLE_TIME_L                 0x680
#define PCIE_PHY_BEACON_2_IDLE_TIME_H                 0x684
#define PCIE_PHY_PWRUP_RESET_DLY_TIME_SYSCLK          0x688
#define PCIE_PHY_PWRUP_RESET_DLY_TIME_AUXCLK          0x68C
#define PCIE_PHY_LFPS_DET_HIGH_COUNT_VAL              0x690
#define PCIE_PHY_LFPS_TX_ECSTART_EQTLOCK              0x694
#define PCIE_PHY_LFPS_TX_END_CNT_P2U3_START           0x698
#define PCIE_PHY_RXEQTRAINING_WAIT_TIME               0x69C
#define PCIE_PHY_RXEQTRAINING_RUN_TIME                0x6A0
#define PCIE_PHY_TXONESZEROS_RUN_LENGTH               0x6A4
#define PCIE_PHY_FLL_CNTRL1                           0x6A8
#define PCIE_PHY_FLL_CNTRL2                           0x6AC
#define PCIE_PHY_FLL_CNT_VAL_L                        0x6B0
#define PCIE_PHY_FLL_CNT_VAL_H_TOL                    0x6B4
#define PCIE_PHY_FLL_MAN_CODE                         0x6B8
#define PCIE_PHY_AUTONOMOUS_MODE_CTRL                 0x6BC
#define PCIE_PHY_LFPS_RXTERM_IRQ_CLEAR                0x6C0
#define PCIE_PHY_ARCVR_DTCT_EN_PERIOD                 0x6C4
#define PCIE_PHY_ARCVR_DTCT_CM_DLY                    0x6C8
#define PCIE_PHY_ALFPS_DEGLITCH_VAL                   0x6CC
#define PCIE_PHY_INSIG_SW_CTRL1                       0x6D0
#define PCIE_PHY_INSIG_SW_CTRL2                       0x6D4
#define PCIE_PHY_INSIG_SW_CTRL3                       0x6D8
#define PCIE_PHY_INSIG_MX_CTRL1                       0x6DC
#define PCIE_PHY_INSIG_MX_CTRL2                       0x6E0
#define PCIE_PHY_INSIG_MX_CTRL3                       0x6E4
#define PCIE_PHY_TEST_CONTROL                         0x6E8
#define PCIE_PHY_BIST_CTRL                            0x6EC
#define PCIE_PHY_PRBS_POLY0                           0x6F0
#define PCIE_PHY_PRBS_POLY1                           0x6F4
#define PCIE_PHY_PRBS_SEED0                           0x6F8
#define PCIE_PHY_PRBS_SEED1                           0x6FC
#define PCIE_PHY_FIXED_PAT_CTRL                       0x700
#define PCIE_PHY_FIXED_PAT0                           0x704
#define PCIE_PHY_FIXED_PAT1                           0x708
#define PCIE_PHY_FIXED_PAT2                           0x70C
#define PCIE_PHY_FIXED_PAT3                           0x710
#define PCIE_PHY_SPARE1                               0x714
#define PCIE_PHY_BIST_CHK_ERR_CNT_L                   0x718
#define PCIE_PHY_BIST_CHK_ERR_CNT_H                   0x71C
#define PCIE_PHY_BIST_CHK_STATUS                      0x720
#define PCIE_PHY_LFPS_RXTERM_IRQ_SOURCE               0x724
#define PCIE_PHY_PCS_STATUS                           0x728
#define PCIE_PHY_PCS_STATUS2                          0x72C
#define PCIE_PHY_REVISION_ID0                         0x730
#define PCIE_PHY_REVISION_ID1                         0x734
#define PCIE_PHY_REVISION_ID2                         0x738
#define PCIE_PHY_REVISION_ID3                         0x73C
#define PCIE_PHY_DEBUG_BUS_0_STATUS                   0x740
#define PCIE_PHY_DEBUG_BUS_1_STATUS                   0x744
#define PCIE_PHY_DEBUG_BUS_2_STATUS                   0x748
#define PCIE_PHY_DEBUG_BUS_3_STATUS                   0x74C
#endif
