LDFLAGS+= -lbsd-compat

CFLAGS+=-I$(LIBBSD-COMPATDIR)
CFLAGS+=-Wall -Werror

OBJDIR?=objdir/$(PROG)

OBJS := $(addprefix $(OBJDIR)/,$(SRCS:.c=.o))
OBJS := $(OBJS:.y=.o)
OBJS := $(OBJS:.l=.o)

DEPS := $(OBJS:.o=.d)

$(OBJDIR)/%.o : %.c $(GENSRCS)
	$(LIBTOOL) --tag=CC --mode=compile $(CC) -c $(CFLAGS) $(CPPFLAGS) -MD $< -o $@

$(OBJS): | $(OBJDIR)
$(OBJS): | $(GENSRCS)
$(OBJDIR):
	mkdir -p $(OBJDIR)

-include $(DEPS)

.DEFAULT_GOAL := all
all:$(PROG)

$(PROG):$(OBJS)
	$(LIBTOOL) --tag=CC --mode=link $(CC) $(CPPFLAGS) $(CFLAGS) -o $@ $(OBJS) $(LDFLAGS)

clean:
	rm -rf $(PROG) $(OBJDIR)

install:
	install -d $(DESTDIR)/usr/sbin
	$(LIBTOOL) --mode=install install -m 0555 $(PROG) $(DESTDIR)/usr/sbin
