#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <fcntl.h>

#include <lib_local_comm.h>
#include <libselect.h>
#include <libmbtutl.h>

static void
bluez_agent_dbg_rcv(void *arg, int sock, struct local_comm_hdr *hdr,
		    void *dbuf, uint32_t dlen)
{
	struct bluez_agent_confirm_req *req =
		(struct bluez_agent_confirm_req *)dbuf;
	struct bluez_agent_confirm_resp resp;
	int resp_type, resp_status = 0;
	char yes_or_no[4];
	int ret;

	memset(&resp, 0, sizeof(resp));
	memset(yes_or_no, 0, sizeof(yes_or_no));

	if (hdr->type == BLUEZ_AGENT_MSG_CONFIRM_REQ) {
		printf("name=%s bdaddr=%02x:%02x:%02x:%02x:%02x:%02x "
		       "passkey=%u Confirm passkey (yes/no):",
		       req->name,
		       req->bdaddr[0], req->bdaddr[1], req->bdaddr[2],
		       req->bdaddr[3], req->bdaddr[4], req->bdaddr[5],
		       req->passkey);
	} else if (hdr->type == BLUEZ_AGENT_MSG_AUTHORIZE_REQ) {
		printf("name=%s bdaddr=%02x:%02x:%02x:%02x:%02x:%02x "
		       "Authorize (yes/no):",
		       req->name,
		       req->bdaddr[0], req->bdaddr[1], req->bdaddr[2],
		       req->bdaddr[3], req->bdaddr[4], req->bdaddr[5]);
	} else {
		printf("%s: recv unknown message type=%d",
		       __func__, hdr->type);
		resp_status = -1;
		goto send_resp;
	}

	ret = scanf("%3s", yes_or_no);
	if (strncmp(yes_or_no, "yes", sizeof("yes")) == 0) {
		resp.confirmed = 1;
	}

 send_resp:
	resp_type = hdr->type + 1;

	ret = lib_local_comm_send(sock, resp_type, resp_status,
				  resp_status ? NULL : &resp,
				  resp_status ? 0 :
				  sizeof(resp));
	if (ret)
		printf("%s: lib_local_comm_send error", __func__);

	lib_local_comm_client_close(sock);
}

/*
 * bluez-agent_dbg
 */
int
main(int argc, char **argv)
{
	void *handle;
	int ret, opt;
	char *e;

	unlink(BLUEZ_AGENT_SOCK_PATH);
	handle = lib_local_comm_server_open(BLUEZ_AGENT_SOCK_PATH,
					    bluez_agent_dbg_rcv,
					    NULL);
	if (handle == NULL) {
		printf("%s: lib_local_comm_server_open(%s) error",
		       __func__, BLUEZ_AGENT_SOCK_PATH);
		return -1;
	}

	select_event_loop();

	return 0;
}
