#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>

#include <bluez5.h>

static void append_variant(DBusMessageIter *iter,
				int type, void *value)
{
	char sig[2];
	DBusMessageIter valueiter;

	sig[0] = type;
	sig[1] = 0;

	dbus_message_iter_open_container(iter, DBUS_TYPE_VARIANT,
						sig, &valueiter);

	dbus_message_iter_append_basic(&valueiter, type, value);

	dbus_message_iter_close_container(iter, &valueiter);
}

static void dict_append_entry(DBusMessageIter *dict,
			const char *key, int type, void *val)
{
	DBusMessageIter entry;

	if (type == DBUS_TYPE_STRING) {
		const char *str = *((const char **) val);
		if (str == NULL)
			return;
	}

	dbus_message_iter_open_container(dict, DBUS_TYPE_DICT_ENTRY,
							NULL, &entry);

	dbus_message_iter_append_basic(&entry, DBUS_TYPE_STRING, &key);

	append_variant(&entry, type, val);

	dbus_message_iter_close_container(dict, &entry);
}

static int
register_hfp(DBusConnection *conn)
{
	DBusMessage *message, *reply;
	DBusError error;
	DBusMessageIter args, dict;
	char *path = "/bluez/test/hfp";
	char *uuid = "hfp-hf";
	int version, features;

	message = dbus_message_new_method_call("org.bluez",
					       "/org/bluez",
					       "org.bluez.ProfileManager1",
					       "RegisterProfile");

	if (message == NULL) {
		fprintf(stderr,
			"Can't allocate method(ProfileManager1#Register)\n");
		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_OBJECT_PATH,
				       &path);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &uuid);

	dbus_message_iter_open_container(&args, DBUS_TYPE_ARRAY,
			DBUS_DICT_ENTRY_BEGIN_CHAR_AS_STRING
			DBUS_TYPE_STRING_AS_STRING
			DBUS_TYPE_VARIANT_AS_STRING
			DBUS_DICT_ENTRY_END_CHAR_AS_STRING, &dict);

	/* Version */
	version = 0x0106;
	dict_append_entry(&dict, "Version", DBUS_TYPE_UINT16, &version);

	/* Features */
#define HF_3WAY			0x0002
#define HF_CLI			0x0004
#define HF_VOICE_RECOGNITION	0x0008
#define HF_REMOTE_VOL		0x0010
#define HF_ENHANCED_STATUS	0x0020
#define HF_ENHANCED_CONTROL	0x0040
#define HF_CODEC_NEGOTIATION	0x0080
	features = (HF_3WAY | HF_CLI | HF_VOICE_RECOGNITION |
		    HF_REMOTE_VOL | HF_ENHANCED_STATUS |
		    HF_ENHANCED_CONTROL | HF_CODEC_NEGOTIATION);
	dict_append_entry(&dict, "Features", DBUS_TYPE_UINT16, &features);

	dbus_message_iter_close_container(&args, &dict);

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: ProfileManager1#Register\n");
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_unref(reply);
	return 0;
}

int main(int argc, char *argv[])
{
	DBusConnection *conn;

	conn = dbus_bus_get(DBUS_BUS_SYSTEM, NULL);
	if (!conn) {
		fprintf(stderr, "Error: Can't get on dbus system bus");
		exit(1);
	}

	register_hfp(conn);

	if (daemon(1, 0)) {
		fprintf(stderr, "daemon fail\n");
		dbus_connection_flush(conn);
		exit(EXIT_FAILURE);
	}

	while(1)
		sleep(1000);

	dbus_connection_flush(conn);
	return 0;
}
