#include <string.h>
#include <bluez5.h>

int
nb5_adapter1_get_string_property(DBusConnection *conn,
				 const char *object_path,
				 const char *property_name,
				 char *prop_value, size_t limit)
{
	DBusMessage *message, *reply;
	DBusMessageIter reply_iter, reply_iter_entry, args;
	DBusError error;
	int reply_type;
	const char *value;
	const char *interface_name = "org.bluez.Adapter1";

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.freedesktop.DBus.Properties",
					       "Get");
	if (message == NULL) {
		fprintf(stderr,
			"Failed org.freedesktop.DBus.Properties#Get(%s)\n",
			property_name);
		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_error_init(&error);

	reply = dbus_connection_send_with_reply_and_block(conn, message, -1, &error);

	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Getting property '%s'(%s)\n",
			property_name, object_path);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_iter_init(reply, &reply_iter);

	reply_type = dbus_message_iter_get_arg_type(&reply_iter);
	if (reply_type != DBUS_TYPE_VARIANT) {
		fprintf(stderr, "[%s] iterator is not VALIANT(%c)\n",
			__func__, reply_type);
		return -1;
	}

	dbus_message_iter_recurse(&reply_iter, &reply_iter_entry);
	dbus_message_iter_get_basic(&reply_iter_entry, &value);

	strncpy(prop_value, value, limit);
	dbus_message_unref(reply);
	return 0;
}
