#include <string.h>
#include <bluez5.h>

int
nb5_device1_get_uint32_property(DBusConnection *conn, const char *object_path,
				const char *property_name,
				uint32_t *prop_value)
{
	DBusMessage *message, *reply;
	DBusMessageIter reply_iter, reply_iter_entry, args;
	DBusError error;
	int reply_type;
	uint32_t value; 
	const char *interface_name = "org.bluez.Device1";

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.freedesktop.DBus.Properties",
					       "Get");
	if (message == NULL) {
		fprintf(stderr,
			"Failed org.freedesktop.DBus.Properties#Get(%s)\n",
			property_name);
		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_error_init(&error);

	reply = dbus_connection_send_with_reply_and_block(conn, message, -1, &error);

	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Getting property '%s'(%s)\n",
			property_name, object_path);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_iter_init(reply, &reply_iter);

	reply_type = dbus_message_iter_get_arg_type(&reply_iter);
	if (reply_type != DBUS_TYPE_VARIANT) {
		fprintf(stderr, "[%s] iterator is not VALIANT(%c)\n",
			__func__, reply_type);
		return -1;
	}

	dbus_message_iter_recurse(&reply_iter, &reply_iter_entry);
	dbus_message_iter_get_basic(&reply_iter_entry, &value);

	*prop_value = value;
	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_get_boolean_property(DBusConnection *conn,
				 const char *object_path,
				 const char *property_name,
				 gboolean *prop_value)
{
	DBusMessage *message, *reply;
	DBusMessageIter reply_iter, reply_iter_entry, args;
	DBusError error;
	int reply_type;
	gboolean value; 
	const char *interface_name = "org.bluez.Device1";

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.freedesktop.DBus.Properties",
					       "Get");
	if (message == NULL) {
		fprintf(stderr,
			"Failed org.freedesktop.DBus.Properties#Get(%s)\n",
			property_name);
		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_error_init(&error);

	reply = dbus_connection_send_with_reply_and_block(conn, message, -1, &error);

	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Getting property '%s'(%s)\n",
			property_name, object_path);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_iter_init(reply, &reply_iter);

	reply_type = dbus_message_iter_get_arg_type(&reply_iter);
	if (reply_type != DBUS_TYPE_VARIANT) {
		fprintf(stderr, "[%s] iterator is not VALIANT(%c)\n",
			__func__, reply_type);
		return -1;
	}

	dbus_message_iter_recurse(&reply_iter, &reply_iter_entry);
	dbus_message_iter_get_basic(&reply_iter_entry, &value);

	*prop_value = value;
	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_get_string_property(DBusConnection *conn, const char *object_path,
				const char *property_name,
				char *prop_value, size_t limit)
{
	DBusMessage *message, *reply;
	DBusMessageIter reply_iter, reply_iter_entry, args;
	DBusError error;
	int reply_type;
	const char *value;
	const char *interface_name = "org.bluez.Device1";

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.freedesktop.DBus.Properties",
					       "Get");
	if (message == NULL) {
		fprintf(stderr,
			"Failed org.freedesktop.DBus.Properties#Get(%s)\n",
			property_name);
		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_error_init(&error);

	reply = dbus_connection_send_with_reply_and_block(conn, message, -1, &error);

	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Getting property '%s'(%s)\n",
			property_name, object_path);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_iter_init(reply, &reply_iter);

	reply_type = dbus_message_iter_get_arg_type(&reply_iter);
	if (reply_type != DBUS_TYPE_VARIANT) {
		fprintf(stderr, "[%s] iterator is not VALIANT(%c)\n",
			__func__, reply_type);
		return -1;
	}

	dbus_message_iter_recurse(&reply_iter, &reply_iter_entry);
	dbus_message_iter_get_basic(&reply_iter_entry, &value);

	strncpy(prop_value, value, limit);
	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_set_boolean_property(DBusConnection *conn,
				 const char *object_path,
				 const char *property_name,
				 const gboolean new_prop_value)
{
	DBusMessage *message, *reply;
	DBusMessageIter args, sub;
	DBusError error;
	const char *interface_name = "org.bluez.Device1";
	char type_sig[2] = { DBUS_TYPE_BOOLEAN, '\0' };

	message = dbus_message_new_method_call("org.bluez", object_path,
					       "org.freedesktop.DBus.Properties",
					       "Set");
	if (message == NULL) {
		fprintf(stderr, "Can't allocate new method call(Device#SetProperty)\n");
 		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_message_iter_open_container(&args, DBUS_TYPE_VARIANT,
					 type_sig, &sub);
	dbus_message_iter_append_basic(&sub, DBUS_TYPE_BOOLEAN,
				       &new_prop_value);
	dbus_message_iter_close_container(&args, &sub);

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr,
			"Failed: 'org.freedesktop.DBus.Properties#Set'\n");
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	return 0;
}

int
nb5_device1_set_string_property(DBusConnection *conn, const char *object_path,
				const char *property_name,
				const char *new_prop_value)
{
	DBusMessage *message, *reply;
	DBusMessageIter args, sub;
	DBusError error;
	const char *interface_name = "org.bluez.Device1";
	char type_sig[2] = { DBUS_TYPE_STRING, '\0' };

	message = dbus_message_new_method_call("org.bluez", object_path,
					       "org.freedesktop.DBus.Properties",
					       "Set");
	if (message == NULL) {
		fprintf(stderr, "Can't allocate new method call(Device#SetProperty)\n");
 		return -1;
	}

	/* Set argument */
	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &interface_name);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &property_name);
	dbus_message_iter_open_container(&args, DBUS_TYPE_VARIANT,
					 type_sig, &sub);
	dbus_message_iter_append_basic(&sub, DBUS_TYPE_STRING,
				       &new_prop_value);
	dbus_message_iter_close_container(&args, &sub);

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr,
			"Failed: 'org.freedesktop.DBus.Properties#Set'\n");
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	return 0;
}

int
nb5_device1_connect(DBusConnection *conn, const char *object_path)
{
	DBusMessage *message, *reply;
	DBusError error;

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.bluez.Device1",
					       "Connect");
	if (message == NULL) {
		fprintf(stderr, "Failed alloc Device1#Connect\n");
		return -1;
	}

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Device1#Connect\n");
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_connect_profile(DBusConnection *conn, const char *object_path,
			    const char *profile_uuid)
{
	DBusMessage *message, *reply;
	DBusMessageIter args;
	DBusError error;

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.bluez.Device1",
					       "ConnectProfile");
	if (message == NULL) {
		fprintf(stderr, "Failed alloc Device1#ConnectProfile\n");
		return -1;
	}

	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &profile_uuid);

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Device1#ConnectProfile(%s)\n",
			profile_uuid);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_disconnect(DBusConnection *conn, const char *object_path)
{
	DBusMessage *message, *reply;
	DBusError error;

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.bluez.Device1",
					       "Disconnect");
	if (message == NULL) {
		fprintf(stderr, "Failed alloc Device1#Disconnect\n");
		return -1;
	}

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Device1#Disconnect(%s)\n",
			object_path);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_unref(reply);
	return 0;
}

int
nb5_device1_disconnect_profile(DBusConnection *conn, const char *object_path,
			       const char *profile_uuid)
{
	DBusMessage *message, *reply;
	DBusMessageIter args;
	DBusError error;

	message = dbus_message_new_method_call("org.bluez",
					       object_path,
					       "org.bluez.Device1",
					       "DisconnectProfile");
	if (message == NULL) {
		fprintf(stderr, "Failed alloc Device1#DisconnectProfile\n");
		return -1;
	}

	dbus_message_iter_init_append(message, &args);
	dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING,
				       &profile_uuid);

	dbus_error_init(&error);
	reply = dbus_connection_send_with_reply_and_block(conn, message,
							  -1, &error);
	dbus_message_unref(message);

	if (reply == NULL) {
		fprintf(stderr, "Failed: Device1#DisconnectProfile(%s)\n",
			profile_uuid);
		if (dbus_error_is_set(&error)) {
			fprintf(stderr, "%s\n", error.message);
			dbus_error_free(&error);
		}
		return -1;
	}

	dbus_message_unref(reply);
	return 0;
}
