#ifndef _NECPF_BLUEZ5_H_
#define _NECPF_BLUEZ5_H_

#include <stdint.h>

#include <glib.h>
#include <glib/gprintf.h>
#include <dbus/dbus.h>

/* 'Device1' interfaces */
extern int nb5_device1_get_uint32_property(DBusConnection *conn,
					   const char *object_path,
					   const char *property_name,
					   uint32_t *prop_value);

extern int nb5_device1_get_boolean_property(DBusConnection *conn,
					    const char *object_path,
					    const char *property_name,
					    gboolean *prop_value);

extern int nb5_device1_get_string_property(DBusConnection *conn,
					   const char *object_path,
					   const char *property_name,
					   char *prop_value,
					   size_t limit);

extern int nb5_device1_set_boolean_property(DBusConnection *conn,
					   const char *object_path,
					   const char *property_name,
					   const gboolean new_prop_value);

extern int nb5_device1_set_string_property(DBusConnection *conn,
					   const char *object_path,
					   const char *property_name,
					   const char *new_prop_value);

extern int nb5_device1_connect(DBusConnection *conn,
			       const char *object_path);
extern int nb5_device1_connect_profile(DBusConnection *conn,
				       const char *object_path,
				       const char *profile_uuid);
extern int nb5_device1_disconnect(DBusConnection *conn,
				  const char *object_path);
extern int nb5_device1_disconnect_profile(DBusConnection *conn,
					  const char *object_path,
					  const char *profile_uuid);

/* 'Adapter1' interfaces */
extern int nb5_adapter1_get_string_property(DBusConnection *conn,
					    const char *object_path,
					    const char *property_name,
					    char *prop_value, size_t limit);

extern int nb5_find_device(DBusConnection *conn, const char *address,
			   char *object_path);

extern int nb5_find_adapter_path(DBusConnection *conn, char *adapter_path,
				 const char *pattern);

#endif /* _NECPF_BLUEZ5_H_ */
