#include <stdio.h>
#include <string.h>
#include <stddef.h>

const char *nb5_uuid_to_name(int uuid)
{
	static char sdp_name[32];

	switch (uuid) {
	case 0x0001:
		strcpy(sdp_name, "SDP");
		break;
	case 0x0002:
		strcpy(sdp_name, "UDP");
		break;
	case 0x0003:
		strcpy(sdp_name, "RFCOMM");
		break;
	case 0x0004:
		strcpy(sdp_name, "TCP");
		break;
	case 0x0005:
		strcpy(sdp_name, "TCS-BIN");
		break;
	case 0x0006:
		strcpy(sdp_name, "TCS-AT");
		break;
	case 0x0008:
		strcpy(sdp_name, "OBEX");
		break;
	case 0x0009:
		strcpy(sdp_name, "IP");
		break;
	case 0x000A:
		strcpy(sdp_name, "FTP");
		break;
	case 0x000C:
		strcpy(sdp_name, "HTTP");
		break;
	case 0x000E:
		strcpy(sdp_name, "WSP");
		break;
	case 0x000F:
		strcpy(sdp_name, "BNEP");
		break;
	case 0x0011:
		strcpy(sdp_name, "HID");
		break;
	case 0x0012:
		strcpy(sdp_name, "HCRP");
		break;
	case 0x0014:
		strcpy(sdp_name, "HCRPrint");
		break;
	case 0x0016:
		strcpy(sdp_name, "HCRScan");
		break;
	case 0x0017:
		strcpy(sdp_name, "AVCTP");
		break;
	case 0x0019:
		strcpy(sdp_name, "AVDTP");
		break;
	case 0x001B:
		strcpy(sdp_name, "CIP");
		break;
	case 0x001D:
		strcpy(sdp_name, "UDI");
		break;
	case 0x0100:
		strcpy(sdp_name, "L2CAP");
		break;
	case 0x1000:
		strcpy(sdp_name, "SDServer");
		break;
	case 0x1001:
		strcpy(sdp_name, "BrwsGrpDesc");
		break;
	case 0x1002:
		strcpy(sdp_name, "PubBrwsGrp");
		break;
	case 0x1101:
		strcpy(sdp_name, "SP");
		break;
	case 0x1102:
		strcpy(sdp_name, "LAN");
		break;
	case 0x1103:
		strcpy(sdp_name, "DUN");
		break;
	case 0x1104:
		strcpy(sdp_name, "IRMCSync");
		break;
	case 0x1105:
		strcpy(sdp_name, "OBEXObjPush");
		break;
	case 0x1106:
		strcpy(sdp_name, "OBEXObjTrnsf");
		break;
	case 0x1107:
		strcpy(sdp_name, "IRMCSyncCmd");
		break;
	case 0x1108:
		strcpy(sdp_name, "Headset");
		break;
	case 0x1109:
		strcpy(sdp_name, "CordlessTel");
		break;
	case 0x110a:
		strcpy(sdp_name, "AudioSource");
		break;
	case 0x110b:
		strcpy(sdp_name, "AudioSink");
		break;
	case 0x110c:
		strcpy(sdp_name, "AVRemTarget");
		break;
	case 0x110d:
		strcpy(sdp_name, "AdvAudio");
		break;
	case 0x110e:
		strcpy(sdp_name, "AVRemote");
		break;
	case 0x110f:
		strcpy(sdp_name, "VideoDist");
		break;
	case 0x1110:
		strcpy(sdp_name, "Intercom");
		break;
	case 0x1111:
		strcpy(sdp_name, "Fax");
		break;
	case 0x1112:
		strcpy(sdp_name, "Headset AG");
		break;
	case 0x1113:
		strcpy(sdp_name, "WAP");
		break;
	case 0x1114:
		strcpy(sdp_name, "WAP Client");
		break;
	case 0x1115:
		strcpy(sdp_name, "PANU");
		break;
	case 0x1116:
		strcpy(sdp_name, "NAP");
		break;
	case 0x1117:
		strcpy(sdp_name, "GN");
		break;
	case 0x1118:
		strcpy(sdp_name, "DirectPrint");
		break;
	case 0x1119:
		strcpy(sdp_name, "RefPrint");
		break;
	case 0x111a:
		strcpy(sdp_name, "Imaging");
		break;
	case 0x111b:
		strcpy(sdp_name, "ImagingResp");
		break;
	/* 0x111c, 0x111d are not named */
	case 0x111e:
		strcpy(sdp_name, "Handsfree");
		break;
	case 0x111f:
		strcpy(sdp_name, "Handsfree AG");
		break;
	case 0x1120:
		strcpy(sdp_name, "RefObjsPrint");
		break;
	case 0x1121:
		strcpy(sdp_name, "ReflectedUI");
		break;
	case 0x1122:
		strcpy(sdp_name, "BasicPrint");
		break;
	case 0x1123:
		strcpy(sdp_name, "PrintStatus");
		break;
	case 0x1124:
		strcpy(sdp_name, "HID");
		break;
	case 0x1125:
		strcpy(sdp_name, "HCRP");
		break;
	case 0x1126:
		strcpy(sdp_name, "HCRPrint");
		break;
	case 0x1127:
		strcpy(sdp_name, "HCPScan");
		break;
	case 0x1128:
		strcpy(sdp_name, "CIP");
		break;
	case 0x1129:
		strcpy(sdp_name, "VideoConf GW");
		break;
	case 0x112a:
		strcpy(sdp_name, "UDI MT");
		break;
	case 0x112b:
		strcpy(sdp_name, "UDI TA");
		break;
	case 0x112c:
		strcpy(sdp_name, "AudioVideo");
		break;
	case 0x112d:
		strcpy(sdp_name, "SAP");
		break;
	case 0x112e:
		strcpy(sdp_name, "PBAP PCE");
		break;
	case 0x112f:
		strcpy(sdp_name, "PBAP PSE");
		break;
	case 0x1130:
		strcpy(sdp_name, "PBAP");
		break;
	case 0x1200:
		strcpy(sdp_name, "PNPInfo");
		break;
	case 0x1201:
		strcpy(sdp_name, "Networking");
		break;
	case 0x1202:
		strcpy(sdp_name, "FileTrnsf");
		break;
	case 0x1203:
		strcpy(sdp_name, "Audio");
		break;
	case 0x1204:
		strcpy(sdp_name, "Telephony");
		break;
	case 0x1205:
		strcpy(sdp_name, "UPNP");
		break;
	case 0x1206:
		strcpy(sdp_name, "UPNP IP");
		break;
	case 0x1300:
		strcpy(sdp_name, "UPNP PAN");
		break;
	case 0x1301:
		strcpy(sdp_name, "UPNP LAP");
		break;
	case 0x1302:
		strcpy(sdp_name, "UPNP L2CAP");
		break;
	case 0x1303:
		strcpy(sdp_name, "VideoSource");
		break;
	case 0x1304:
		strcpy(sdp_name, "VideoSink");
		break;
	case 0x1305:
		strcpy(sdp_name, "VideoDist");
		break;
	case 0x2112:
		strcpy(sdp_name, "AppleAgent");
		break;
	default:
		sprintf(sdp_name, "0x%x", uuid);
		break;
	}

	return sdp_name;
}
