/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Yuesheng Wang <yuesheng.wang@mediatek.com>
 */

/* global PQ param for kernel space */
static struct mtk_color_param g_color_param[COLOR_NUM] = {
#ifdef CONFIG_MTK_DISPLAY_FULL_TUNING_COLOR
{
u4SatGain:0x80,
u4PartialY:0x80,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:0x80,
u4HueCd0:0x80808080,
u4HueCd1:0x80808080,
u4HueCd2:0x80808080,
u4HueCd3:0x80808080,
u4HueCd4:0x80808080,
u4Brightness:0x400,
},
{
u4SatGain:0x80,
u4PartialY:0x80,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:0x80,
u4HueCd0:0x80808080,
u4HueCd1:0x80808080,
u4HueCd2:0x80808080,
u4HueCd3:0x80808080,
u4HueCd4:0x80808080,
u4Brightness:0x400,
},
{
u4SatGain:0x80,
u4PartialY:0x80,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:0x80,
u4HueCd0:0x80808080,
u4HueCd1:0x80808080,
u4HueCd2:0x80808080,
u4HueCd3:0x80808080,
u4HueCd4:0x80808080,
u4Brightness:0x400,
}
#else
{
u4SatGain:4,
u4PartialY:0,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:4,
u4Brightness:4,
},
{
u4SatGain:4,
u4PartialY:0,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:4,
u4Brightness:4,

},
{
u4SatGain:4,
u4PartialY:0,
u4HueAdj:{9, 9, 9, 9},
u4SatAdj:{0, 0, 0, 0},
u4Contrast:4,
u4Brightness:4,
}
#endif
};

/* initialize index (because system default is 0, need fill with 0x80) */
#ifndef CONFIG_MTK_DISPLAY_FULL_TUNING_COLOR
static struct mtk_color_idx g_color_index = {
GLOBAL_SAT:
	{0x80, 0x80, 0x80, 0x80, 0x80,
	 0x80, 0x80, 0x80, 0x80, 0x80},/* 0~9 */

CONTRAST :
	{0x80, 0x80, 0x80, 0x80, 0x80,
	 0x80, 0x80, 0x80, 0x80, 0x80},/* 0~9 */

BRIGHTNESS :
	{0x400, 0x400, 0x400, 0x400, 0x400,
	 0x400, 0x400, 0x400, 0x400, 0x400},/* 0~9 */

PARTIAL_Y :
	{
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
		 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
	},

PURP_TONE_S :
	{/* hue 0~10 */
		{/* 0 disable */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 1 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 2 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},
		{/* 3 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 4 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 5 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 6 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 7 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 8 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 9 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 10 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 11 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 12 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 13 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 14 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 15 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 16 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 17 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 18 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		}
	},
SKIN_TONE_S :
	{
		{/* 0 disable */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 1 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 2 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 3 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 4 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 5 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 6 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 7 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 8 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 9 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 10 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 11 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 12 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 13 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 14 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 15 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 16 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 17 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 18 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		}
	},
GRASS_TONE_S :
	{
		{/* 0 disable */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 1 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 2 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 3 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 4 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 5 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 6 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 7 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 8 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 9 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 10 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 11 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 12 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 13 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 14 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 15 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}

		},

		{/* 16 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 17 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		},

		{/* 18 */
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
		}
	},
SKY_TONE_S :
	{
		{/* 0 disable */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},
		{/* 1 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},
		{/* 2 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},

		{/* 3 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},
		{/* 4 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},

		{/* 5 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 6 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 7 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 8 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 9 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},
		{/* 10 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},
		{/* 11 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},

		{/* 12 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},
		{/* 13 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}

		},

		{/* 14 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 15 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 16 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 17 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		},

		{/* 18 */
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80},
			{0x80, 0x80, 0x80}
		}
	},

PURP_TONE_H :
	{
		/* hue 0~2 */
		{0x80, 0x80, 0x80},	/* 3 */
		{0x80, 0x80, 0x80},	/* 4 */
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},	/* 3 */
		{0x80, 0x80, 0x80},	/* 4 */
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},	/* 4 */
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},	/* 3 */
		{0x80, 0x80, 0x80},	/* 4 */
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80}
	},

SKIN_TONE_H :
	{
		/* hue 3~16 */
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
	},

GRASS_TONE_H :
	{
		/* hue 17~24 */
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80, 0x80, 0x80, 0x80}
	},

SKY_TONE_H :
	{
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80},
		{0x80, 0x80, 0x80}
	},
};
#endif
