/*************************************************************************/ /*!
@File
@Title          PVR Common Bridge Init/Deinit Module (kernel side)
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@Description    Implements common PVR Bridge init/deinit code
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

#include "pvrsrv_bridge_init.h"
#include "srvcore.h"

/* These will go when full bridge gen comes in */
#if defined(PDUMP)
PVRSRV_ERROR InitPDUMPCTRLBridge(void);
PVRSRV_ERROR DeinitPDUMPCTRLBridge(void);
PVRSRV_ERROR InitPDUMPBridge(void);
PVRSRV_ERROR DeinitPDUMPBridge(void);
PVRSRV_ERROR InitRGXPDUMPBridge(void);
PVRSRV_ERROR DeinitRGXPDUMPBridge(void);
#endif
#if defined(SUPPORT_DISPLAY_CLASS)
PVRSRV_ERROR InitDCBridge(void);
PVRSRV_ERROR DeinitDCBridge(void);
#endif
PVRSRV_ERROR InitMMBridge(void);
PVRSRV_ERROR DeinitMMBridge(void);
#if !defined(EXCLUDE_CMM_BRIDGE)
PVRSRV_ERROR InitCMMBridge(void);
PVRSRV_ERROR DeinitCMMBridge(void);
#endif
PVRSRV_ERROR InitPDUMPMMBridge(void);
PVRSRV_ERROR DeinitPDUMPMMBridge(void);
PVRSRV_ERROR InitSRVCOREBridge(void);
PVRSRV_ERROR DeinitSRVCOREBridge(void);
PVRSRV_ERROR InitSYNCBridge(void);
PVRSRV_ERROR DeinitSYNCBridge(void);

#if defined(SUPPORT_SERVER_SYNC)
#if defined(SUPPORT_INSECURE_EXPORT)
PVRSRV_ERROR InitSYNCEXPORTBridge(void);
PVRSRV_ERROR DeinitSYNCEXPORTBridge(void);
#endif
#if defined(SUPPORT_SECURE_EXPORT)
PVRSRV_ERROR InitSYNCSEXPORTBridge(void);
PVRSRV_ERROR DeinitSYNCSEXPORTBridge(void);
#endif
#endif /* defined(SUPPORT_SERVER_SYNC) */

#if defined (SUPPORT_RGX)
PVRSRV_ERROR InitRGXTA3DBridge(void);
PVRSRV_ERROR DeinitRGXTA3DBridge(void);
PVRSRV_ERROR InitRGXTQBridge(void);
PVRSRV_ERROR DeinitRGXTQBridge(void);
PVRSRV_ERROR InitRGXTQ2Bridge(void);
PVRSRV_ERROR DeinitRGXTQ2Bridge(void);
PVRSRV_ERROR InitRGXCMPBridge(void);
PVRSRV_ERROR DeinitRGXCMPBridge(void);
#if !defined(EXCLUDE_BREAKPOINT_BRIDGE)
PVRSRV_ERROR InitBREAKPOINTBridge(void);
PVRSRV_ERROR DeinitBREAKPOINTBridge(void);
#endif
PVRSRV_ERROR InitDEBUGMISCBridge(void);
PVRSRV_ERROR DeinitDEBUGMISCBridge(void);
PVRSRV_ERROR InitRGXHWPERFBridge(void);
PVRSRV_ERROR DeinitRGXHWPERFBridge(void);
PVRSRV_ERROR InitRGXRAYBridge(void);
PVRSRV_ERROR DeinitRGXRAYBridge(void);
#if !defined(EXCLUDE_REGCONFIG_BRIDGE)
PVRSRV_ERROR InitREGCONFIGBridge(void);
PVRSRV_ERROR DeinitREGCONFIGBridge(void);
#endif
PVRSRV_ERROR InitTIMERQUERYBridge(void);
PVRSRV_ERROR DeinitTIMERQUERYBridge(void);
PVRSRV_ERROR InitRGXKICKSYNCBridge(void);
PVRSRV_ERROR DeinitRGXKICKSYNCBridge(void);
#if defined(SUPPORT_SIGNAL_FILTER)
PVRSRV_ERROR InitRGXSIGNALSBridge(void);
PVRSRV_ERROR DeinitRGXSIGNALSBridge(void);
#endif
#endif /* SUPPORT_RGX */
PVRSRV_ERROR InitCACHEBridge(void);
PVRSRV_ERROR DeinitCACHEBridge(void);
#if defined(SUPPORT_SECURE_EXPORT)
PVRSRV_ERROR InitSMMBridge(void);
PVRSRV_ERROR DeinitSMMBridge(void);
#endif
#if !defined(EXCLUDE_HTBUFFER_BRIDGE)
PVRSRV_ERROR InitHTBUFFERBridge(void);
PVRSRV_ERROR DeinitHTBUFFERBridge(void);
#endif
PVRSRV_ERROR InitPVRTLBridge(void);
PVRSRV_ERROR DeinitPVRTLBridge(void);
#if defined(PVR_RI_DEBUG)
PVRSRV_ERROR InitRIBridge(void);
PVRSRV_ERROR DeinitRIBridge(void);
#endif
#if defined(SUPPORT_PAGE_FAULT_DEBUG)
PVRSRV_ERROR InitDEVICEMEMHISTORYBridge(void);
PVRSRV_ERROR DeinitDEVICEMEMHISTORYBridge(void);
#endif
#if defined(SUPPORT_VALIDATION_BRIDGE)
PVRSRV_ERROR InitVALIDATIONBridge(void);
PVRSRV_ERROR DeinitVALIDATIONBridge(void);
#endif
#if defined(PVR_TESTING_UTILS)
PVRSRV_ERROR InitTUTILSBridge(void);
PVRSRV_ERROR DeinitTUTILSBridge(void);
#endif
#if defined(PVRSRV_ENABLE_FULL_SYNC_TRACKING)
PVRSRV_ERROR InitSYNCTRACKINGBridge(void);
PVRSRV_ERROR DeinitSYNCTRACKINGBridge(void);
#endif
#if defined(SUPPORT_WRAP_EXTMEM)
PVRSRV_ERROR InitMMEXTMEMBridge(void);
PVRSRV_ERROR DeinitMMEXTMEMBridge(void);
#endif
#if defined(SUPPORT_FALLBACK_FENCE_SYNC)
PVRSRV_ERROR InitSYNCFALLBACKBridge(void);
PVRSRV_ERROR DeinitSYNCFALLBACKBridge(void);
#endif


PVRSRV_ERROR
CommonBridgeInit(void)
{
	PVRSRV_ERROR eError;

	BridgeDispatchTableStartOffsetsInit();

	eError = InitSRVCOREBridge();
	PVR_LOG_IF_ERROR(eError, "InitSRVCOREBridge");

	eError = InitSYNCBridge();
	PVR_LOG_IF_ERROR(eError, "InitSYNCBridge");

#if defined(SUPPORT_SERVER_SYNC)
#if defined(SUPPORT_INSECURE_EXPORT)
	eError = InitSYNCEXPORTBridge();
	PVR_LOG_IF_ERROR(eError, "InitSYNCEXPORTBridge");
#endif
#if defined(SUPPORT_SECURE_EXPORT)
	eError = InitSYNCSEXPORTBridge();
	PVR_LOG_IF_ERROR(eError, "InitSYNCSEXPORTBridge");
#endif
#endif /* defined(SUPPORT_SERVER_SYNC) */

#if defined(PDUMP)
	eError = InitPDUMPCTRLBridge();
	PVR_LOG_IF_ERROR(eError, "InitPDUMPCTRLBridge");
#endif

	eError = InitMMBridge();
	PVR_LOG_IF_ERROR(eError, "InitMMBridge");

#if !defined(EXCLUDE_CMM_BRIDGE)
	eError = InitCMMBridge();
	PVR_LOG_IF_ERROR(eError, "InitCMMBridge");
#endif

#if defined(PDUMP)
	eError = InitPDUMPMMBridge();
	PVR_LOG_IF_ERROR(eError, "InitPDUMPMMBridge");

	eError = InitPDUMPBridge();
	PVR_LOG_IF_ERROR(eError, "InitPDUMPBridge");
#endif

#if defined(SUPPORT_DISPLAY_CLASS)
	eError = InitDCBridge();
	PVR_LOG_IF_ERROR(eError, "InitDCBridge");
#endif

	eError = InitCACHEBridge();
	PVR_LOG_IF_ERROR(eError, "InitCACHEBridge");

#if defined(SUPPORT_SECURE_EXPORT)
	eError = InitSMMBridge();
	PVR_LOG_IF_ERROR(eError, "InitSMMBridge");
#endif

#if !defined(EXCLUDE_HTBUFFER_BRIDGE)
	eError = InitHTBUFFERBridge();
	PVR_LOG_IF_ERROR(eError, "InitHTBUFFERBridge");
#endif

	eError = InitPVRTLBridge();
	PVR_LOG_IF_ERROR(eError, "InitPVRTLBridge");

#if defined(PVR_RI_DEBUG)
	eError = InitRIBridge();
	PVR_LOG_IF_ERROR(eError, "InitRIBridge");
#endif

#if defined(SUPPORT_VALIDATION_BRIDGE)
	eError = InitVALIDATIONBridge();
	PVR_LOG_IF_ERROR(eError, "InitVALIDATIONBridge");
#endif

#if defined(PVR_TESTING_UTILS)
	eError = InitTUTILSBridge();
	PVR_LOG_IF_ERROR(eError, "InitTUTILSBridge");
#endif

#if defined(SUPPORT_PAGE_FAULT_DEBUG)
	eError = InitDEVICEMEMHISTORYBridge();
	PVR_LOG_IF_ERROR(eError, "InitDEVICEMEMHISTORYBridge");
#endif


#if defined(PVRSRV_ENABLE_FULL_SYNC_TRACKING)
	eError = InitSYNCTRACKINGBridge();
	PVR_LOG_IF_ERROR(eError, "InitSYNCTRACKINGBridge");
#endif

#if defined (SUPPORT_RGX)

	eError = InitRGXTQBridge();
	PVR_LOG_IF_ERROR(eError, "InitRGXTQBridge");

	eError = InitRGXTA3DBridge();
	PVR_LOG_IF_ERROR(eError, "InitRGXTA3DBridge");

	#if !defined(EXCLUDE_BREAKPOINT_BRIDGE)
	eError = InitBREAKPOINTBridge();
	PVR_LOG_IF_ERROR(eError, "InitBREAKPOINTBridge");
#endif

	eError = InitDEBUGMISCBridge();
	PVR_LOG_IF_ERROR(eError, "InitDEBUGMISCBridge");

#if defined(PDUMP)
	eError = InitRGXPDUMPBridge();
	PVR_LOG_IF_ERROR(eError, "InitRGXPDUMPBridge");
#endif

	eError = InitRGXHWPERFBridge();
	PVR_LOG_IF_ERROR(eError, "InitRGXHWPERFBridge");

#if !defined(EXCLUDE_REGCONFIG_BRIDGE)
	eError = InitREGCONFIGBridge();
	PVR_LOG_IF_ERROR(eError, "InitREGCONFIGBridge");
#endif

	eError = InitTIMERQUERYBridge();
	PVR_LOG_IF_ERROR(eError, "InitTIMERQUERYBridge");

	eError = InitRGXKICKSYNCBridge();
	PVR_LOG_IF_ERROR(eError, "InitRGXKICKSYNCBridge");

#endif /* SUPPORT_RGX */

#if defined(SUPPORT_WRAP_EXTMEM)
	eError = InitMMEXTMEMBridge();
	PVR_LOG_IF_ERROR(eError, "InitMMEXTMEMBridge");
#endif

#if defined(SUPPORT_FALLBACK_FENCE_SYNC)
	eError = InitSYNCFALLBACKBridge();
	PVR_LOG_IF_ERROR(eError, "InitSYNCFALLBACKBridge");
#endif

	eError = OSPlatformBridgeInit();
	PVR_LOG_IF_ERROR(eError, "OSPlatformBridgeInit");

	return eError;
}

PVRSRV_ERROR
CommonBridgeDeInit(void)
{
	PVRSRV_ERROR eError;

	eError = OSPlatformBridgeDeInit();
	PVR_LOG_IF_ERROR(eError, "OSPlatformBridgeDeInit");

#if defined(SUPPORT_FALLBACK_FENCE_SYNC)
	eError = DeinitSYNCFALLBACKBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSYNCFALLBACKBridge");
#endif

#if defined(SUPPORT_WRAP_EXTMEM)
	eError = DeinitMMEXTMEMBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitMMEXTMEMBridge");
#endif

	eError = DeinitSRVCOREBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSRVCOREBridge");

	eError = DeinitSYNCBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSYNCBridge");

#if defined(SUPPORT_SERVER_SYNC)
#if defined(SUPPORT_INSECURE_EXPORT)
	eError = DeinitSYNCEXPORTBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSYNCEXPORTBridge");
#endif

#if defined(SUPPORT_SECURE_EXPORT)
	eError = DeinitSYNCSEXPORTBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSYNCSEXPORTBridge");
#endif
#endif /* defined(SUPPORT_SERVER_SYNC) */

#if defined(PDUMP)
	eError = DeinitPDUMPCTRLBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitPDUMPCTRLBridge");
#endif

	eError = DeinitMMBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitMMBridge");

#if !defined(EXCLUDE_CMM_BRIDGE)
	eError = DeinitCMMBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitCMMBridge");
#endif

#if defined(PDUMP)
	eError = DeinitPDUMPMMBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitPDUMPMMBridge");

	eError = DeinitPDUMPBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitPDUMPBridge");
#endif

#if defined(PVR_TESTING_UTILS)
	eError = DeinitTUTILSBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitTUTILSBridge");
#endif

#if defined(SUPPORT_DISPLAY_CLASS)
	eError = DeinitDCBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitDCBridge");
#endif

	eError = DeinitCACHEBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitCACHEBridge");

#if defined(SUPPORT_SECURE_EXPORT)
	eError = DeinitSMMBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSMMBridge");
#endif

#if !defined(EXCLUDE_HTBUFFER_BRIDGE)
	eError = DeinitHTBUFFERBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitHTBUFFERBridge");
#endif

	eError = DeinitPVRTLBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitPVRTLBridge");

#if defined(SUPPORT_VALIDATION_BRIDGE)
	eError = DeinitVALIDATIONBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitVALIDATIONBridge");
#endif

#if defined(PVR_RI_DEBUG)
	eError = DeinitRIBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRIBridge");
#endif

#if defined(SUPPORT_PAGE_FAULT_DEBUG)
	eError = DeinitDEVICEMEMHISTORYBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitDEVICEMEMHISTORYBridge");
#endif


#if defined(PVRSRV_ENABLE_FULL_SYNC_TRACKING)
	eError = DeinitSYNCTRACKINGBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitSYNCTRACKINGBridge");
#endif

#if defined (SUPPORT_RGX)

	eError = DeinitRGXTQBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRGXTQBridge");

	eError = DeinitRGXTA3DBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRGXTA3DBridge");

#if !defined(EXCLUDE_BREAKPOINT_BRIDGE)
	eError = DeinitBREAKPOINTBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitBREAKPOINTBridge");
#endif

	eError = DeinitDEBUGMISCBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitDEBUGMISCBridge");

#if defined(PDUMP)
	eError = DeinitRGXPDUMPBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRGXPDUMPBridge");
#endif

	eError = DeinitRGXHWPERFBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRGXHWPERFBridge");

#if !defined(EXCLUDE_REGCONFIG_BRIDGE)
	eError = DeinitREGCONFIGBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitREGCONFIGBridge");
#endif

	eError = DeinitTIMERQUERYBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitTIMERQUERYBridge");

	eError = DeinitRGXKICKSYNCBridge();
	PVR_LOGR_IF_ERROR(eError, "DeinitRGXKICKSYNCBridge");

#endif /* SUPPORT_RGX */

	return eError;
}

#if defined(SUPPORT_RGX)
PVRSRV_ERROR
DeviceDepBridgeInit(IMG_UINT64 ui64Features)
{
	PVRSRV_ERROR eError;

	if(ui64Features & RGX_FEATURE_COMPUTE_BIT_MASK)
	{
		eError = InitRGXCMPBridge();
		PVR_LOGR_IF_ERROR(eError, "InitRGXCMPBridge");
	}

#if defined(SUPPORT_SIGNAL_FILTER)
	if(ui64Features & RGX_FEATURE_SIGNAL_SNOOPING_BIT_MASK)
	{
		eError = InitRGXSIGNALSBridge();
		PVR_LOGR_IF_ERROR(eError, "InitRGXCMPBridge");
	}
#endif

#if defined(RGX_FEATURE_RAY_TRACING)
	if(ui64Features & RGX_FEATURE_RAY_TRACING_DEPRECATED_BIT_MASK)
	{
		eError = InitRGXRAYBridge();
		PVR_LOGR_IF_ERROR(eError, "InitRGXRAYBridge");
	}
#endif

	if(ui64Features & RGX_FEATURE_FASTRENDER_DM_BIT_MASK)
	{
		eError = InitRGXTQ2Bridge();
		PVR_LOGR_IF_ERROR(eError, "InitRGXTQ2Bridge");
	}

	return PVRSRV_OK;
}

PVRSRV_ERROR
DeviceDepBridgeDeInit(IMG_UINT64 ui64Features)
{
	PVRSRV_ERROR eError;

	if(ui64Features & RGX_FEATURE_COMPUTE_BIT_MASK)
	{
		eError = DeinitRGXCMPBridge();
		PVR_LOGR_IF_ERROR(eError, "DeinitRGXCMPBridge");
	}

#if defined(SUPPORT_SIGNAL_FILTER)
	if(ui64Features & RGX_FEATURE_SIGNAL_SNOOPING_BIT_MASK)
	{
		eError = DeinitRGXSIGNALSBridge();
		PVR_LOGR_IF_ERROR(eError, "DeinitRGXSIGNALSBridge");
	}
#endif

#if defined(RGX_FEATURE_RAY_TRACING)
	if(ui64Features & RGX_FEATURE_RAY_TRACING_DEPRECATED_BIT_MASK)
	{
		eError = DeinitRGXRAYBridge();
		PVR_LOGR_IF_ERROR(eError, "DeinitRGXRAYBridge");
	}
#endif

	if(ui64Features & RGX_FEATURE_FASTRENDER_DM_BIT_MASK)
	{
		eError = DeinitRGXTQ2Bridge();
		PVR_LOGR_IF_ERROR(eError, "DeinitRGXTQ2Bridge");
	}

	return PVRSRV_OK;
}
#endif /* SUPPORT_RGX */


