// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Ming-Fan Chen <ming-fan.chen@mediatek.com>
 */

#include <dt-bindings/interconnect/mtk,mmqos.h>
#include <dt-bindings/interconnect/mtk,mt6779-emi.h>
#include <dt-bindings/memory/mt6779-larb-port.h>
#include <linux/module.h>
#include <linux/of_platform.h>

#include "mmqos-mtk.h"


static const struct mtk_node_desc node_descs_mt6779[] = {
	DEFINE_MNODE(common0,
		SLAVE_COMMON(0), 0, MMQOS_NO_LINK),
	DEFINE_MNODE(common0_port0,
		MASTER_COMMON_PORT(0, 0), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port1,
		MASTER_COMMON_PORT(0, 1), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port2,
		MASTER_COMMON_PORT(0, 2), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port3,
		MASTER_COMMON_PORT(0, 3), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port4,
		MASTER_COMMON_PORT(0, 4), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port5,
		MASTER_COMMON_PORT(0, 5), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port6,
		MASTER_COMMON_PORT(0, 6), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port7,
		MASTER_COMMON_PORT(0, 7), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(common0_port8,
		MASTER_COMMON_PORT(0, 8), 0, SLAVE_COMMON(0)),
	DEFINE_MNODE(larb0, SLAVE_LARB(0), 0, MASTER_COMMON_PORT(0, 0)),
	DEFINE_MNODE(larb1, SLAVE_LARB(1), 0, MASTER_COMMON_PORT(0, 1)),
	DEFINE_MNODE(larb2, SLAVE_LARB(2), 0, MASTER_COMMON_PORT(0, 2)),
	DEFINE_MNODE(larb3, SLAVE_LARB(3), 0, MASTER_COMMON_PORT(0, 3)),
	DEFINE_MNODE(larb5, SLAVE_LARB(5), 0, MASTER_COMMON_PORT(0, 4)),
	DEFINE_MNODE(larb8, SLAVE_LARB(8), 0, MASTER_COMMON_PORT(0, 5)),
	DEFINE_MNODE(larb9, SLAVE_LARB(9), 0, MASTER_COMMON_PORT(0, 7)),
	DEFINE_MNODE(larb10, SLAVE_LARB(10), 0, MASTER_COMMON_PORT(0, 6)),
	DEFINE_MNODE(larb12, SLAVE_LARB(12), 0, MASTER_COMMON_PORT(0, 8)),
	DEFINE_MNODE(larb13, SLAVE_LARB(13), 0, MASTER_COMMON_PORT(0, 6)),
	DEFINE_MNODE(disp_postmask0,
		MASTER_LARB_PORT(M4U_PORT_DISP_POSTMASK0), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_ovl0_hdr,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL0_HDR), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_ovl1_hdr,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL1_HDR), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_ovl0,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL0), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_ovl1,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL1), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_pvric0,
		MASTER_LARB_PORT(M4U_PORT_DISP_PVRIC0), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_rdma0,
		MASTER_LARB_PORT(M4U_PORT_DISP_RDMA0), 7, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_wdma0,
		MASTER_LARB_PORT(M4U_PORT_DISP_WDMA0), 8, SLAVE_LARB(0)),
	DEFINE_MNODE(disp_fake0,
		MASTER_LARB_PORT(M4U_PORT_DISP_FAKE0), 7, SLAVE_LARB(0)),

	DEFINE_MNODE(disp_ovl0_2l_hdr,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL0_2L_HDR), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(disp_ovl1_2l_hdr,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL1_2L_HDR), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(disp_ovl0_2l,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL0_2L), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(disp_ovl1_2l,
		MASTER_LARB_PORT(M4U_PORT_DISP_OVL1_2L), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(disp_rdma1,
		MASTER_LARB_PORT(M4U_PORT_DISP_RDMA1), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_pvric0,
		MASTER_LARB_PORT(M4U_PORT_MDP_PVRIC0), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_pvric1,
		MASTER_LARB_PORT(M4U_PORT_MDP_PVRIC1), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_rdma0,
		MASTER_LARB_PORT(M4U_PORT_MDP_RDMA0), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_rdma1,
		MASTER_LARB_PORT(M4U_PORT_MDP_RDMA1), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_wrot0_r,
		MASTER_LARB_PORT(M4U_PORT_MDP_WROT0_R), 8, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_wrot0_w,
		MASTER_LARB_PORT(M4U_PORT_MDP_WROT0_W), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_wrot1_r,
		MASTER_LARB_PORT(M4U_PORT_MDP_WROT1_R), 8, SLAVE_LARB(1)),
	DEFINE_MNODE(mdp_wrot1_w,
		MASTER_LARB_PORT(M4U_PORT_MDP_WROT1_W), 7, SLAVE_LARB(1)),
	DEFINE_MNODE(disp_fake1,
		MASTER_LARB_PORT(M4U_PORT_DISP_FAKE1), 7, SLAVE_LARB(1)),

	DEFINE_MNODE(vdec_mc_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_MC_EXT), 7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_ufo_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_UFO_EXT), 7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_pp_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_PP_EXT), 8, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_pred_rd_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_PRED_RD_EXT),
		7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_pred_wr_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_PRED_WR_EXT),
		7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_ppwrap_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_PPWRAP_EXT),
		7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_tile_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_TILE_EXT), 7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_vld_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_VLD_EXT), 7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_vld2_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_VLD2_EXT), 7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_avc_mv_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_AVC_MV_EXT),
		7, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_ufo_enc_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_UFO_ENC_EXT),
		8, SLAVE_LARB(2)),
	DEFINE_MNODE(vdec_rg_ctrl_dma_ext,
		MASTER_LARB_PORT(M4U_PORT_HW_VDEC_RG_CTRL_DMA_EXT),
		7, SLAVE_LARB(2)),

	DEFINE_MNODE(venc_rcpu,
		MASTER_LARB_PORT(M4U_PORT_VENC_RCPU), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_rec,
		MASTER_LARB_PORT(M4U_PORT_VENC_REC), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_bsdma,
		MASTER_LARB_PORT(M4U_PORT_VENC_BSDMA), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_sv_comv,
		MASTER_LARB_PORT(M4U_PORT_VENC_SV_COMV), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_rd_comv,
		MASTER_LARB_PORT(M4U_PORT_VENC_RD_COMV), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_nbm_rdma,
		MASTER_LARB_PORT(M4U_PORT_VENC_NBM_RDMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_nbm_rdma_lite,
		MASTER_LARB_PORT(M4U_PORT_VENC_NBM_RDMA_LITE),
		7, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgenc_y_rdma,
		MASTER_LARB_PORT(M4U_PORT_JPGENC_Y_RDMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgenc_c_rdma,
		MASTER_LARB_PORT(M4U_PORT_JPGENC_C_RDMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgenc_q_table,
		MASTER_LARB_PORT(M4U_PORT_JPGENC_Q_TABLE), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgenc_bsdma,
		MASTER_LARB_PORT(M4U_PORT_JPGENC_BSDMA), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgedc_wdma,
		MASTER_LARB_PORT(M4U_PORT_JPGDEC_WDMA), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(jpgedc_bsdma,
		MASTER_LARB_PORT(M4U_PORT_JPGDEC_BSDMA), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_nbm_wdma,
		MASTER_LARB_PORT(M4U_PORT_VENC_NBM_WDMA), 8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_nbm_wdma_lite,
		MASTER_LARB_PORT(M4U_PORT_VENC_NBM_WDMA_LITE),
		8, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_cur_luma,
		MASTER_LARB_PORT(M4U_PORT_VENC_CUR_LUMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_cur_chroma,
		MASTER_LARB_PORT(M4U_PORT_VENC_CUR_CHROMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_ref_luma,
		MASTER_LARB_PORT(M4U_PORT_VENC_REF_LUMA), 7, SLAVE_LARB(3)),
	DEFINE_MNODE(venc_ref_chroma,
		MASTER_LARB_PORT(M4U_PORT_VENC_REF_CHROMA), 7, SLAVE_LARB(3)),

	DEFINE_MNODE(img_imgi_d1,
		MASTER_LARB_PORT(M4U_PORT_IMGI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_imgbi_d1,
		MASTER_LARB_PORT(M4U_PORT_IMGBI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_dmgi_d1,
		MASTER_LARB_PORT(M4U_PORT_DMGI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_depi_d1,
		MASTER_LARB_PORT(M4U_PORT_DEPI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_lcei_d1,
		MASTER_LARB_PORT(M4U_PORT_LCEI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_smti_d1,
		MASTER_LARB_PORT(M4U_PORT_SMTI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_smto_d2,
		MASTER_LARB_PORT(M4U_PORT_SMTO_D2), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_smto_d1,
		MASTER_LARB_PORT(M4U_PORT_SMTO_D1), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_crzo_d1,
		MASTER_LARB_PORT(M4U_PORT_CRZO_D1), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_img3o_d1,
		MASTER_LARB_PORT(M4U_PORT_IMG3O_D1), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_vipi_d1,
		MASTER_LARB_PORT(M4U_PORT_VIPI_D1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_wpe_rdma1,
		MASTER_LARB_PORT(M4U_PORT_WPE_RDMA1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_wpe_rdma0,
		MASTER_LARB_PORT(M4U_PORT_WPE_RDMA0), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_wpe_wdma,
		MASTER_LARB_PORT(M4U_PORT_WPE_WDMA), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_timgo_d1,
		MASTER_LARB_PORT(M4U_PORT_TIMGO_D1), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_mfb_rdma0,
		MASTER_LARB_PORT(M4U_PORT_MFB_RDMA0), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_mfb_rdma1,
		MASTER_LARB_PORT(M4U_PORT_MFB_RDMA1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_mfb_rdma2,
		MASTER_LARB_PORT(M4U_PORT_MFB_RDMA2), 6, SLAVE_LARB(5)),
	DEFINE_MNODE(img_mfb_rdma3,
		MASTER_LARB_PORT(M4U_PORT_MFB_RDMA3), 6, SLAVE_LARB(5)),
	DEFINE_MNODE(img_mfb_wdma,
		MASTER_LARB_PORT(M4U_PORT_MFB_WDMA), 8, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve1,
		MASTER_LARB_PORT(M4U_PORT_RESERVE1), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve2,
		MASTER_LARB_PORT(M4U_PORT_RESERVE2), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve3,
		MASTER_LARB_PORT(M4U_PORT_RESERVE3), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve4,
		MASTER_LARB_PORT(M4U_PORT_RESERVE4), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve5,
		MASTER_LARB_PORT(M4U_PORT_RESERVE5), 7, SLAVE_LARB(5)),
	DEFINE_MNODE(img_reserve6,
		MASTER_LARB_PORT(M4U_PORT_RESERVE6), 7, SLAVE_LARB(5)),

	DEFINE_MNODE(ipe_fdvt_rda,
		MASTER_LARB_PORT(M4U_PORT_FDVT_RDA), 7, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fdvt_rdb,
		MASTER_LARB_PORT(M4U_PORT_FDVT_RDB), 7, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fdvt_wra,
		MASTER_LARB_PORT(M4U_PORT_FDVT_WRA), 8, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fdvt_wrb,
		MASTER_LARB_PORT(M4U_PORT_FDVT_WRB), 8, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fe_rd0,
		MASTER_LARB_PORT(M4U_PORT_FE_RD0), 7, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fe_rd1,
		MASTER_LARB_PORT(M4U_PORT_FE_RD1), 7, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fe_wr0,
		MASTER_LARB_PORT(M4U_PORT_FE_WR0), 8, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_fe_wr1,
		MASTER_LARB_PORT(M4U_PORT_FE_WR1), 8, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_rsc_rdma0,
		MASTER_LARB_PORT(M4U_PORT_RSC_RDMA0), 6, SLAVE_LARB(8)),
	DEFINE_MNODE(ipe_rsc_wdma,
		MASTER_LARB_PORT(M4U_PORT_RSC_WDMA), 7, SLAVE_LARB(8)),

	DEFINE_MNODE(cam_imgo_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_IMGO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_rrzo_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_RRZO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_lsci__r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_LSCI_R1_C), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_bpci_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_BPCI_R1_C), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_yuvo_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_YUVO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_ufdi_r2_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_UFDI_R2_C), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_rawi_r2_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R2_C), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_rawi_r5_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R5_C), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_1,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_1), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_2,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_2), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_3,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_3), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_4,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_4), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_5,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_5), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_camsv_6,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_6), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_aao_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_AAO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_afo_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_AFO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_flko_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_FLKO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_lceso_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_LCESO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_crzo_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_CRZO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_ltmso_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_LTMSO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_rsso_r1_c,
		MASTER_LARB_PORT(M4U_PORT_CAM_RSSO_R1_C), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_ccui,
		MASTER_LARB_PORT(M4U_PORT_CAM_CCUI), 7, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_ccuo,
		MASTER_LARB_PORT(M4U_PORT_CAM_CCUO), 8, SLAVE_LARB(9)),
	DEFINE_MNODE(cam_fake,
		MASTER_LARB_PORT(M4U_PORT_CAM_FAKE), 8, SLAVE_LARB(9)),

	DEFINE_MNODE(cam_imgo_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_IMGO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rrzo_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_RRZO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_lsci_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_LSCI_R1_A), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_bpci_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_BPCI_R1_A), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_yuvo_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_YUVO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_ufdi_r2_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_UFDI_R2_A), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rawi_r2_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R2_A), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rawi_r5_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R5_A), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_imgo_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_IMGO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rrzo_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_RRZO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_lsci_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_LSCI_R1_B), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_bpci_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_BPCI_R1_B), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_yuvo_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_YUVO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_ufdi_r2_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_UFDI_R2_B), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rawi_r2_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R2_B), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rawi_r5_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_RAWI_R5_B), 7, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_camsv_0,
		MASTER_LARB_PORT(M4U_PORT_CAM_CAMSV_0), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_aao_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_AAO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_afo_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_AFO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_flko_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_FLKO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_lceso_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_LCESO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_crzo_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_CRZO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_aao_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_AAO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_afo_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_AFO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_flko_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_FLKO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_lceso_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_LCESO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_crzo_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_CRZO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_ltmso_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_LTMSO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rsso_r1_a,
		MASTER_LARB_PORT(M4U_PORT_CAM_RSSO_R1_A), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_ltmso_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_LTMSO_R1_B), 8, SLAVE_LARB(10)),
	DEFINE_MNODE(cam_rsso_r1_b,
		MASTER_LARB_PORT(M4U_PORT_CAM_RSSO_R1_B), 8, SLAVE_LARB(10)),
};

static const char * const comm_muxes_mt6779[] = { "mm" };

static const char * const comm_icc_path_names_mt6779[] = { "mmsys_path" };

static const struct mtk_mmqos_desc mmqos_desc_mt6779 = {
	.nodes = node_descs_mt6779,
	.num_nodes = ARRAY_SIZE(node_descs_mt6779),
	.comm_muxes = comm_muxes_mt6779,
	.comm_icc_path_names = comm_icc_path_names_mt6779,
	.max_ratio = 40,
	.hrt = {
		.hrt_bw = {1600, 0, 0},
		.hrt_total_bw = 7466, /* Todo: Use DRAMC API */
	}
};


static const struct of_device_id mtk_mmqos_mt6779_of_ids[] = {
	{
		.compatible = "mediatek,mt6779-mmqos",
		.data = &mmqos_desc_mt6779,
	},
	{}
};
MODULE_DEVICE_TABLE(of, mtk_mmqos_mt6779_of_ids);

static struct platform_driver mtk_mmqos_mt6779_driver = {
	.probe = mtk_mmqos_probe,
	.remove = mtk_mmqos_remove,
	.driver = {
		.name = "mtk-mt6779-mmqos",
		.of_match_table = mtk_mmqos_mt6779_of_ids,
	},
};
module_platform_driver(mtk_mmqos_mt6779_driver);

MODULE_LICENSE("GPL v2");
