/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2016 MediaTek Inc.
 */

/* Lafite_TPPA_FY_0817 */

/**********************************************
 * unified_power_data.h
 * This header file includes:
 * 1. Macros of SRAM related address
 * 2. Raw datas of unified power tables for each bank
 **********************************************/

#ifndef UNIFIED_POWER_DATA_H
#define UNIFIED_POWER_DATA_H

/* remember to sync to sspm upower */
#define UPOWER_CSRAM_BASE 0x0012a000
#define UPOWER_CSRAM_SIZE 0x3000 /* 12K bytes */
#define UPOWER_DVFS_OFF_BOTTOM 0x8 /* ignore the last 8 bytes */
/* limit should be at 0x12CFF4 */
#define UPOWER_TBL_LIMIT \
	((UPOWER_CSRAM_BASE)+(UPOWER_CSRAM_SIZE)-(UPOWER_DVFS_OFF_BOTTOM))

struct upower_tbl upower_tbl_l_FY = {
	.row = {
		{.cap = 236, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 254, .volt = 66250, .dyn_pwr = 31711,
			.lkg_pwr = {41438, 41438, 41438, 41438, 41438, 41438} },
		{.cap = 269, .volt = 68125, .dyn_pwr = 36490,
			.lkg_pwr = {42941, 42941, 42941, 42941, 42941, 42941} },
		{.cap = 286, .volt = 70000, .dyn_pwr = 41608,
			.lkg_pwr = {44444, 44444, 44444, 44444, 44444, 44444} },
		{.cap = 308, .volt = 71875, .dyn_pwr = 47204,
			.lkg_pwr = {46096, 46096, 46096, 46096, 46096, 46096} },
		{.cap = 333, .volt = 75000, .dyn_pwr = 56180,
			.lkg_pwr = {48850, 48850, 48850, 48850, 48850, 48850} },
		{.cap = 358, .volt = 77500, .dyn_pwr = 65093,
			.lkg_pwr = {51053, 51053, 51053, 51053, 51053, 51053} },
		{.cap = 383, .volt = 80000, .dyn_pwr = 74800,
			.lkg_pwr = {53256, 53256, 53256, 53256, 53256, 53256} },
		{.cap = 407, .volt = 82500, .dyn_pwr = 85333,
			.lkg_pwr = {55867, 55867, 55867, 55867, 55867, 55867} },
		{.cap = 422, .volt = 84375, .dyn_pwr = 93674,
			.lkg_pwr = {57825, 57825, 57825, 57825, 57825, 57825} },
		{.cap = 452, .volt = 88750, .dyn_pwr = 111540,
			.lkg_pwr = {62394, 62394, 62394, 62394, 62394, 62394} },
		{.cap = 467, .volt = 91250, .dyn_pwr = 122654,
			.lkg_pwr = {65200, 65200, 65200, 65200, 65200, 65200} },
		{.cap = 480, .volt = 93125, .dyn_pwr = 132686,
			.lkg_pwr = {67450, 67450, 67450, 67450, 67450, 67450} },
		{.cap = 497, .volt = 95625, .dyn_pwr = 145035,
			.lkg_pwr = {70450, 70450, 70450, 70450, 70450, 70450} },
		{.cap = 511, .volt = 98125, .dyn_pwr = 158201,
			.lkg_pwr = {73450, 73450, 73450, 73450, 73450, 73450} },
		{.cap = 525, .volt = 100000, .dyn_pwr = 170000,
			.lkg_pwr = {75700, 75700, 75700, 75700, 75700, 75700} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
	},
};

struct upower_tbl upower_tbl_cluster_l_FY = {
	.row = {
		{.cap = 236, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 254, .volt = 66250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 269, .volt = 68125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 286, .volt = 70000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 308, .volt = 71875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 333, .volt = 75000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 358, .volt = 77500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 383, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 407, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 422, .volt = 84375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 452, .volt = 88750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 467, .volt = 91250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 480, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 497, .volt = 95625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 511, .volt = 98125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 525, .volt = 100000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_b_FY = {
	.row = {
		{.cap = 468, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 495, .volt = 69375, .dyn_pwr = 126315,
		.lkg_pwr = {117470, 117470, 117470, 117470, 117470, 117470} },
		{.cap = 539, .volt = 71250, .dyn_pwr = 145374,
		.lkg_pwr = {122042, 122042, 122042, 122042, 122042, 122042} },
		{.cap = 581, .volt = 73125, .dyn_pwr = 165742,
		.lkg_pwr = {126841, 126841, 126841, 126841, 126841, 126841} },
		{.cap = 620, .volt = 75625, .dyn_pwr = 190579,
		.lkg_pwr = {133239, 133239, 133239, 133239, 133239, 133239} },
		{.cap = 673, .volt = 78125, .dyn_pwr = 222078,
		.lkg_pwr = {139638, 139638, 139638, 139638, 139638, 139638} },
		{.cap = 729, .volt = 80000, .dyn_pwr = 252100,
		.lkg_pwr = {144437, 144437, 144437, 144437, 144437, 144437} },
		{.cap = 764, .volt = 83125, .dyn_pwr = 287453,
		.lkg_pwr = {152925, 152925, 152925, 152925, 152925, 152925} },
		{.cap = 818, .volt = 86875, .dyn_pwr = 341184,
		.lkg_pwr = {163111, 163111, 163111, 163111, 163111, 163111} },
		{.cap = 875, .volt = 90000, .dyn_pwr = 394851,
		.lkg_pwr = {171600, 171600, 171600, 171600, 171600, 171600} },
		{.cap = 901, .volt = 93125, .dyn_pwr = 436101,
		.lkg_pwr = {181520, 181520, 181520, 181520, 181520, 181520} },
		{.cap = 927, .volt = 95625, .dyn_pwr = 473960,
		.lkg_pwr = {189456, 189456, 189456, 189456, 189456, 189456} },
		{.cap = 952, .volt = 98750, .dyn_pwr = 520337,
		.lkg_pwr = {199375, 199375, 199375, 199375, 199375, 199375} },
		{.cap = 976, .volt = 101250, .dyn_pwr = 562258,
		.lkg_pwr = {208050, 208050, 208050, 208050, 208050, 208050} },
		{.cap = 1020, .volt = 104375, .dyn_pwr = 613748,
		.lkg_pwr = {219818, 219818, 219818, 219818, 219818, 219818} },
		{.cap = 1024, .volt = 106875, .dyn_pwr = 660330,
		.lkg_pwr = {229231, 229231, 229231, 229231, 229231, 229231} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
	},
};

struct upower_tbl upower_tbl_cluster_b_FY = {
	.row = {
		{.cap = 468, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 495, .volt = 69375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 539, .volt = 71250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 581, .volt = 73125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 620, .volt = 75625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 673, .volt = 78125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 729, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 764, .volt = 83125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 818, .volt = 86875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 875, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 901, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 927, .volt = 95625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 952, .volt = 98750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 976, .volt = 101250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1020, .volt = 104375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1024, .volt = 106875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_cci_FY = {
	.row = {
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 65625, .dyn_pwr = 8380,
			.lkg_pwr = {45950, 45950, 45950, 45950, 45950, 45950} },
		{.cap = 0, .volt = 67500, .dyn_pwr = 10201,
			.lkg_pwr = {47637, 47637, 47637, 47637, 47637, 47637} },
		{.cap = 0, .volt = 69375, .dyn_pwr = 12186,
			.lkg_pwr = {49324, 49324, 49324, 49324, 49324, 49324} },
		{.cap = 0, .volt = 71875, .dyn_pwr = 15113,
			.lkg_pwr = {51741, 51741, 51741, 51741, 51741, 51741} },
		{.cap = 0, .volt = 73750, .dyn_pwr = 17529,
			.lkg_pwr = {53595, 53595, 53595, 53595, 53595, 53595} },
		{.cap = 0, .volt = 76250, .dyn_pwr = 21026,
			.lkg_pwr = {56068, 56068, 56068, 56068, 56068, 56068} },
		{.cap = 0, .volt = 78750, .dyn_pwr = 24868,
			.lkg_pwr = {58540, 58540, 58540, 58540, 58540, 58540} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 27538,
			.lkg_pwr = {59777, 59777, 59777, 59777, 59777, 59777} },
		{.cap = 0, .volt = 84375, .dyn_pwr = 34867,
			.lkg_pwr = {64906, 64906, 64906, 64906, 64906, 64906} },
		{.cap = 0, .volt = 86875, .dyn_pwr = 38118,
			.lkg_pwr = {67836, 67836, 67836, 67836, 67836, 67836} },
		{.cap = 0, .volt = 88750, .dyn_pwr = 40987,
			.lkg_pwr = {70035, 70035, 70035, 70035, 70035, 70035} },
		{.cap = 0, .volt = 92500, .dyn_pwr = 47143,
			.lkg_pwr = {74867, 74867, 74867, 74867, 74867, 74867} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 51541,
			.lkg_pwr = {78234, 78234, 78234, 78234, 78234, 78234} },
		{.cap = 0, .volt = 97500, .dyn_pwr = 56243,
			.lkg_pwr = {81602, 81602, 81602, 81602, 81602, 81602} },
		{.cap = 0, .volt = 100000, .dyn_pwr = 61220,
			.lkg_pwr = {84969, 84969, 84969, 84969, 84969, 84969} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
	},
};

struct upower_tbl upower_tbl_l_SB = {
	.row = {
		{.cap = 221, .volt = 60000, .dyn_pwr = 23684,
			.lkg_pwr = {36429, 36429, 36429, 36429, 36429, 36429} },
		{.cap = 239, .volt = 61250, .dyn_pwr = 27105,
			.lkg_pwr = {37431, 37431, 37431, 37431, 37431, 37431} },
		{.cap = 257, .volt = 63125, .dyn_pwr = 31330,
			.lkg_pwr = {38934, 38934, 38934, 38934, 38934, 38934} },
		{.cap = 274, .volt = 65000, .dyn_pwr = 35877,
			.lkg_pwr = {40437, 40437, 40437, 40437, 40437, 40437} },
		{.cap = 292, .volt = 66875, .dyn_pwr = 40865,
			.lkg_pwr = {41939, 41939, 41939, 41939, 41939, 41939} },
		{.cap = 315, .volt = 69375, .dyn_pwr = 48069,
			.lkg_pwr = {43943, 43943, 43943, 43943, 43943, 43943} },
		{.cap = 339, .volt = 71875, .dyn_pwr = 55987,
			.lkg_pwr = {46096, 46096, 46096, 46096, 46096, 46096} },
		{.cap = 361, .volt = 74375, .dyn_pwr = 64651,
			.lkg_pwr = {48299, 48299, 48299, 48299, 48299, 48299} },
		{.cap = 381, .volt = 76875, .dyn_pwr = 74094,
			.lkg_pwr = {50502, 50502, 50502, 50502, 50502, 50502} },
		{.cap = 395, .volt = 80000, .dyn_pwr = 84211,
			.lkg_pwr = {53256, 53256, 53256, 53256, 53256, 53256} },
		{.cap = 422, .volt = 82500, .dyn_pwr = 96383,
			.lkg_pwr = {55867, 55867, 55867, 55867, 55867, 55867} },
		{.cap = 437, .volt = 85000, .dyn_pwr = 106428,
			.lkg_pwr = {58478, 58478, 58478, 58478, 58478, 58478} },
		{.cap = 451, .volt = 87500, .dyn_pwr = 117141,
			.lkg_pwr = {61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 464, .volt = 90000, .dyn_pwr = 128474,
			.lkg_pwr = {63700, 63700, 63700, 63700, 63700, 63700} },
		{.cap = 478, .volt = 92500, .dyn_pwr = 140583,
			.lkg_pwr = {66700, 66700, 66700, 66700, 66700, 66700} },
		{.cap = 491, .volt = 95000, .dyn_pwr = 153425,
			.lkg_pwr = {69700, 69700, 69700, 69700, 69700, 69700} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
	},
};

struct upower_tbl upower_tbl_cluster_l_SB = {
	.row = {
		{.cap = 221, .volt = 60000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 239, .volt = 61250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 257, .volt = 63125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 274, .volt = 65000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 292, .volt = 66875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 315, .volt = 69375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 339, .volt = 71875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 361, .volt = 74375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 381, .volt = 76875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 395, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 422, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 437, .volt = 85000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 451, .volt = 87500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 464, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 478, .volt = 92500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 491, .volt = 95000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_b_SB = {
	.row = {
		{.cap = 431, .volt = 60000, .dyn_pwr = 80576,
		.lkg_pwr = {96883, 96883, 96883, 96883, 96883, 96883} },
		{.cap = 475, .volt = 61875, .dyn_pwr = 94380,
		.lkg_pwr = {101001, 101001, 101001, 101001, 101001, 101001} },
		{.cap = 530, .volt = 64375, .dyn_pwr = 114052,
		.lkg_pwr = {106490, 106490, 106490, 106490, 106490, 106490} },
		{.cap = 582, .volt = 66875, .dyn_pwr = 135793,
		.lkg_pwr = {111980, 111980, 111980, 111980, 111980, 111980} },
		{.cap = 645, .volt = 70000, .dyn_pwr = 165860,
		.lkg_pwr = {118842, 118842, 118842, 118842, 118842, 118842} },
		{.cap = 696, .volt = 73125, .dyn_pwr = 199081,
		.lkg_pwr = {126841, 126841, 126841, 126841, 126841, 126841} },
		{.cap = 749, .volt = 76250, .dyn_pwr = 235655,
		.lkg_pwr = {134839, 134839, 134839, 134839, 134839, 134839} },
		{.cap = 820, .volt = 80000, .dyn_pwr = 284272,
		.lkg_pwr = {144437, 144437, 144437, 144437, 144437, 144437} },
		{.cap = 846, .volt = 82500, .dyn_pwr = 311866,
		.lkg_pwr = {151227, 151227, 151227, 151227, 151227, 151227} },
		{.cap = 872, .volt = 85000, .dyn_pwr = 341226,
		.lkg_pwr = {158018, 158018, 158018, 158018, 158018, 158018} },
		{.cap = 897, .volt = 87500, .dyn_pwr = 372248,
		.lkg_pwr = {164809, 164809, 164809, 164809, 164809, 164809} },
		{.cap = 919, .volt = 90000, .dyn_pwr = 404796,
		.lkg_pwr = {171600, 171600, 171600, 171600, 171600, 171600} },
		{.cap = 946, .volt = 93125, .dyn_pwr = 448148,
		.lkg_pwr = {181520, 181520, 181520, 181520, 181520, 181520} },
		{.cap = 972, .volt = 96250, .dyn_pwr = 493429,
		.lkg_pwr = {191440, 191440, 191440, 191440, 191440, 191440} },
		{.cap = 998, .volt = 99375, .dyn_pwr = 540646,
		.lkg_pwr = {201359, 201359, 201359, 201359, 201359, 201359} },
		{.cap = 1024, .volt = 102500, .dyn_pwr = 591028,
		.lkg_pwr = {212757, 212757, 212757, 212757, 212757, 212757} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
	},
};

struct upower_tbl upower_tbl_cluster_b_SB = {
	.row = {
		{.cap = 431, .volt = 60000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 475, .volt = 61875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 530, .volt = 64375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 582, .volt = 66875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 645, .volt = 70000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 696, .volt = 73125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 749, .volt = 76250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 820, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 846, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 872, .volt = 85000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 897, .volt = 87500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 919, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 946, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 972, .volt = 96250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 998, .volt = 99375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1024, .volt = 102500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_cci_SB = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 6297,
			.lkg_pwr = {40890, 40890, 40890, 40890, 40890, 40890} },
		{.cap = 0, .volt = 61250, .dyn_pwr = 7300,
			.lkg_pwr = {42015, 42015, 42015, 42015, 42015, 42015} },
		{.cap = 0, .volt = 63125, .dyn_pwr = 8921,
			.lkg_pwr = {43701, 43701, 43701, 43701, 43701, 43701} },
		{.cap = 0, .volt = 65000, .dyn_pwr = 10697,
			.lkg_pwr = {45388, 45388, 45388, 45388, 45388, 45388} },
		{.cap = 0, .volt = 67500, .dyn_pwr = 13329,
			.lkg_pwr = {47637, 47637, 47637, 47637, 47637, 47637} },
		{.cap = 0, .volt = 69375, .dyn_pwr = 15511,
			.lkg_pwr = {49324, 49324, 49324, 49324, 49324, 49324} },
		{.cap = 0, .volt = 71875, .dyn_pwr = 18682,
			.lkg_pwr = {51741, 51741, 51741, 51741, 51741, 51741} },
		{.cap = 0, .volt = 74375, .dyn_pwr = 22181,
			.lkg_pwr = {54213, 54213, 54213, 54213, 54213, 54213} },
		{.cap = 0, .volt = 76875, .dyn_pwr = 26023,
			.lkg_pwr = {56686, 56686, 56686, 56686, 56686, 56686} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 31345,
			.lkg_pwr = {59777, 59777, 59777, 59777, 59777, 59777} },
		{.cap = 0, .volt = 81875, .dyn_pwr = 33857,
			.lkg_pwr = {61975, 61975, 61975, 61975, 61975, 61975} },
		{.cap = 0, .volt = 83750, .dyn_pwr = 36499,
			.lkg_pwr = {64173, 64173, 64173, 64173, 64173, 64173} },
		{.cap = 0, .volt = 87500, .dyn_pwr = 42184,
			.lkg_pwr = {68569, 68569, 68569, 68569, 68569, 68569} },
		{.cap = 0, .volt = 90000, .dyn_pwr = 46259,
			.lkg_pwr = {71500, 71500, 71500, 71500, 71500, 71500} },
		{.cap = 0, .volt = 92500, .dyn_pwr = 50623,
			.lkg_pwr = {74867, 74867, 74867, 74867, 74867, 74867} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 55251,
			.lkg_pwr = {78234, 78234, 78234, 78234, 78234, 78234} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
	},
};

struct upower_tbl upower_tbl_l_PRO = {
	.row = {
		{.cap = 217, .volt = 60000, .dyn_pwr = 23684,
			.lkg_pwr = {36429, 36429, 36429, 36429, 36429, 36429} },
		{.cap = 234, .volt = 61250, .dyn_pwr = 27105,
			.lkg_pwr = {37431, 37431, 37431, 37431, 37431, 37431} },
		{.cap = 251, .volt = 63125, .dyn_pwr = 31330,
			.lkg_pwr = {38934, 38934, 38934, 38934, 38934, 38934} },
		{.cap = 269, .volt = 65000, .dyn_pwr = 35877,
			.lkg_pwr = {40437, 40437, 40437, 40437, 40437, 40437} },
		{.cap = 286, .volt = 66875, .dyn_pwr = 40865,
			.lkg_pwr = {41939, 41939, 41939, 41939, 41939, 41939} },
		{.cap = 309, .volt = 69375, .dyn_pwr = 48069,
			.lkg_pwr = {43943, 43943, 43943, 43943, 43943, 43943} },
		{.cap = 332, .volt = 71875, .dyn_pwr = 55987,
			.lkg_pwr = {46096, 46096, 46096, 46096, 46096, 46096} },
		{.cap = 354, .volt = 74375, .dyn_pwr = 64651,
			.lkg_pwr = {48299, 48299, 48299, 48299, 48299, 48299} },
		{.cap = 373, .volt = 76875, .dyn_pwr = 74094,
			.lkg_pwr = {50502, 50502, 50502, 50502, 50502, 50502} },
		{.cap = 387, .volt = 80000, .dyn_pwr = 84211,
			.lkg_pwr = {53256, 53256, 53256, 53256, 53256, 53256} },
		{.cap = 412, .volt = 82500, .dyn_pwr = 96094,
			.lkg_pwr = {55867, 55867, 55867, 55867, 55867, 55867} },
		{.cap = 426, .volt = 85000, .dyn_pwr = 124487,
			.lkg_pwr = {58478, 58478, 58478, 58478, 58478, 58478} },
		{.cap = 439, .volt = 87500, .dyn_pwr = 136664,
			.lkg_pwr = {61089, 61089, 61089, 61089, 61089, 61089} },
		{.cap = 451, .volt = 90000, .dyn_pwr = 149526,
			.lkg_pwr = {63700, 63700, 63700, 63700, 63700, 63700} },
		{.cap = 463, .volt = 92500, .dyn_pwr = 163253,
			.lkg_pwr = {66700, 66700, 66700, 66700, 66700, 66700} },
		{.cap = 475, .volt = 95000, .dyn_pwr = 177793,
			.lkg_pwr = {69700, 69700, 69700, 69700, 69700, 69700} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
		{{0}, {36429} },
	},
};

struct upower_tbl upower_tbl_cluster_l_PRO = {
	.row = {
		{.cap = 217, .volt = 60000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 234, .volt = 61250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 251, .volt = 63125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 269, .volt = 65000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 286, .volt = 66875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 309, .volt = 69375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 332, .volt = 71875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 354, .volt = 74375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 373, .volt = 76875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 387, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 412, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 426, .volt = 85000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 439, .volt = 87500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 451, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 463, .volt = 92500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 475, .volt = 95000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_b_PRO = {
	.row = {
		{.cap = 422, .volt = 60000, .dyn_pwr = 80576,
		.lkg_pwr = {96883, 96883, 96883, 96883, 96883, 96883} },
		{.cap = 465, .volt = 61875, .dyn_pwr = 94380,
		.lkg_pwr = {101001, 101001, 101001, 101001, 101001, 101001} },
		{.cap = 520, .volt = 64375, .dyn_pwr = 114052,
		.lkg_pwr = {106490, 106490, 106490, 106490, 106490, 106490} },
		{.cap = 571, .volt = 66875, .dyn_pwr = 135793,
		.lkg_pwr = {111980, 111980, 111980, 111980, 111980, 111980} },
		{.cap = 632, .volt = 70000, .dyn_pwr = 165860,
		.lkg_pwr = {118842, 118842, 118842, 118842, 118842, 118842} },
		{.cap = 682, .volt = 73125, .dyn_pwr = 199081,
		.lkg_pwr = {126841, 126841, 126841, 126841, 126841, 126841} },
		{.cap = 734, .volt = 76250, .dyn_pwr = 235655,
		.lkg_pwr = {134839, 134839, 134839, 134839, 134839, 134839} },
		{.cap = 803, .volt = 80000, .dyn_pwr = 284272,
		.lkg_pwr = {144437, 144437, 144437, 144437, 144437, 144437} },
		{.cap = 828, .volt = 82500, .dyn_pwr = 311578,
		.lkg_pwr = {151227, 151227, 151227, 151227, 151227, 151227} },
		{.cap = 852, .volt = 85000, .dyn_pwr = 340471,
		.lkg_pwr = {158018, 158018, 158018, 158018, 158018, 158018} },
		{.cap = 876, .volt = 87500, .dyn_pwr = 370982,
		.lkg_pwr = {164809, 164809, 164809, 164809, 164809, 164809} },
		{.cap = 897, .volt = 90000, .dyn_pwr = 403142,
		.lkg_pwr = {171600, 171600, 171600, 171600, 171600, 171600} },
		{.cap = 923, .volt = 93125, .dyn_pwr = 445705,
		.lkg_pwr = {181520, 181520, 181520, 181520, 181520, 181520} },
		{.cap = 951, .volt = 96250, .dyn_pwr = 492320,
		.lkg_pwr = {191440, 191440, 191440, 191440, 191440, 191440} },
		{.cap = 989, .volt = 99375, .dyn_pwr = 546083,
		.lkg_pwr = {201359, 201359, 201359, 201359, 201359, 201359} },
		{.cap = 1024, .volt = 102500, .dyn_pwr = 601340,
		.lkg_pwr = {212757, 212757, 212757, 212757, 212757, 212757} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
		{{0}, {96883} },
	},
};

struct upower_tbl upower_tbl_cluster_b_PRO = {
	.row = {
		{.cap = 422, .volt = 60000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 465, .volt = 61875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 520, .volt = 64375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 571, .volt = 66875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 632, .volt = 70000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 682, .volt = 73125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 734, .volt = 76250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 803, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 828, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 852, .volt = 85000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 876, .volt = 87500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 897, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 923, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 951, .volt = 96250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 989, .volt = 99375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1024, .volt = 102500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_cci_PRO = {
	.row = {
		{.cap = 0, .volt = 60000, .dyn_pwr = 6297,
			.lkg_pwr = {40890, 40890, 40890, 40890, 40890, 40890} },
		{.cap = 0, .volt = 61250, .dyn_pwr = 7300,
			.lkg_pwr = {42015, 42015, 42015, 42015, 42015, 42015} },
		{.cap = 0, .volt = 63750, .dyn_pwr = 9490,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 65625, .dyn_pwr = 11337,
			.lkg_pwr = {45950, 45950, 45950, 45950, 45950, 45950} },
		{.cap = 0, .volt = 67500, .dyn_pwr = 13329,
			.lkg_pwr = {47637, 47637, 47637, 47637, 47637, 47637} },
		{.cap = 0, .volt = 69375, .dyn_pwr = 15511,
			.lkg_pwr = {49324, 49324, 49324, 49324, 49324, 49324} },
		{.cap = 0, .volt = 71875, .dyn_pwr = 18682,
			.lkg_pwr = {51741, 51741, 51741, 51741, 51741, 51741} },
		{.cap = 0, .volt = 74375, .dyn_pwr = 22181,
			.lkg_pwr = {54213, 54213, 54213, 54213, 54213, 54213} },
		{.cap = 0, .volt = 76875, .dyn_pwr = 26023,
			.lkg_pwr = {56686, 56686, 56686, 56686, 56686, 56686} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 31345,
			.lkg_pwr = {59777, 59777, 59777, 59777, 59777, 59777} },
		{.cap = 0, .volt = 81875, .dyn_pwr = 33857,
			.lkg_pwr = {61975, 61975, 61975, 61975, 61975, 61975} },
		{.cap = 0, .volt = 83750, .dyn_pwr = 36499,
			.lkg_pwr = {64173, 64173, 64173, 64173, 64173, 64173} },
		{.cap = 0, .volt = 87500, .dyn_pwr = 42184,
			.lkg_pwr = {68569, 68569, 68569, 68569, 68569, 68569} },
		{.cap = 0, .volt = 90000, .dyn_pwr = 46259,
			.lkg_pwr = {71500, 71500, 71500, 71500, 71500, 71500} },
		{.cap = 0, .volt = 92500, .dyn_pwr = 50623,
			.lkg_pwr = {74867, 74867, 74867, 74867, 74867, 74867} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 55251,
			.lkg_pwr = {78234, 78234, 78234, 78234, 78234, 78234} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
		{{0}, {40890} },
	},
};

struct upower_tbl upower_tbl_l_LITE = {
	.row = {
		{.cap = 254, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 273, .volt = 66250, .dyn_pwr = 31711,
			.lkg_pwr = {41438, 41438, 41438, 41438, 41438, 41438} },
		{.cap = 290, .volt = 68125, .dyn_pwr = 36490,
			.lkg_pwr = {42941, 42941, 42941, 42941, 42941, 42941} },
		{.cap = 308, .volt = 70000, .dyn_pwr = 41608,
			.lkg_pwr = {44444, 44444, 44444, 44444, 44444, 44444} },
		{.cap = 331, .volt = 71875, .dyn_pwr = 47204,
			.lkg_pwr = {46096, 46096, 46096, 46096, 46096, 46096} },
		{.cap = 358, .volt = 75000, .dyn_pwr = 56180,
			.lkg_pwr = {48850, 48850, 48850, 48850, 48850, 48850} },
		{.cap = 385, .volt = 77500, .dyn_pwr = 65093,
			.lkg_pwr = {51053, 51053, 51053, 51053, 51053, 51053} },
		{.cap = 412, .volt = 80000, .dyn_pwr = 74800,
			.lkg_pwr = {53256, 53256, 53256, 53256, 53256, 53256} },
		{.cap = 437, .volt = 82500, .dyn_pwr = 85333,
			.lkg_pwr = {55867, 55867, 55867, 55867, 55867, 55867} },
		{.cap = 454, .volt = 84375, .dyn_pwr = 93674,
			.lkg_pwr = {57825, 57825, 57825, 57825, 57825, 57825} },
		{.cap = 487, .volt = 88750, .dyn_pwr = 111540,
			.lkg_pwr = {62394, 62394, 62394, 62394, 62394, 62394} },
		{.cap = 503, .volt = 91250, .dyn_pwr = 122654,
			.lkg_pwr = {65200, 65200, 65200, 65200, 65200, 65200} },
		{.cap = 516, .volt = 93125, .dyn_pwr = 132686,
			.lkg_pwr = {67450, 67450, 67450, 67450, 67450, 67450} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
	},
};

struct upower_tbl upower_tbl_cluster_l_LITE = {
	.row = {
		{.cap = 254, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 254, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 273, .volt = 66250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 290, .volt = 68125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 308, .volt = 70000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 331, .volt = 71875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 358, .volt = 75000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 385, .volt = 77500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 412, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 437, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 454, .volt = 84375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 487, .volt = 88750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 503, .volt = 91250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 516, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_b_LITE = {
	.row = {
		{.cap = 504, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 532, .volt = 69375, .dyn_pwr = 126315,
		.lkg_pwr = {117470, 117470, 117470, 117470, 117470, 117470} },
		{.cap = 580, .volt = 71250, .dyn_pwr = 145374,
		.lkg_pwr = {122042, 122042, 122042, 122042, 122042, 122042} },
		{.cap = 625, .volt = 73125, .dyn_pwr = 165742,
		.lkg_pwr = {126841, 126841, 126841, 126841, 126841, 126841} },
		{.cap = 667, .volt = 75625, .dyn_pwr = 190579,
		.lkg_pwr = {133239, 133239, 133239, 133239, 133239, 133239} },
		{.cap = 725, .volt = 78125, .dyn_pwr = 222078,
		.lkg_pwr = {139638, 139638, 139638, 139638, 139638, 139638} },
		{.cap = 784, .volt = 80000, .dyn_pwr = 252100,
		.lkg_pwr = {144437, 144437, 144437, 144437, 144437, 144437} },
		{.cap = 821, .volt = 83125, .dyn_pwr = 287453,
		.lkg_pwr = {152925, 152925, 152925, 152925, 152925, 152925} },
		{.cap = 881, .volt = 86875, .dyn_pwr = 341184,
		.lkg_pwr = {163111, 163111, 163111, 163111, 163111, 163111} },
		{.cap = 941, .volt = 90000, .dyn_pwr = 394851,
		.lkg_pwr = {171600, 171600, 171600, 171600, 171600, 171600} },
		{.cap = 969, .volt = 93125, .dyn_pwr = 436101,
		.lkg_pwr = {181520, 181520, 181520, 181520, 181520, 181520} },
		{.cap = 998, .volt = 95625, .dyn_pwr = 473960,
		.lkg_pwr = {189456, 189456, 189456, 189456, 189456, 189456} },
		{.cap = 1024, .volt = 98750, .dyn_pwr = 520337,
		.lkg_pwr = {199375, 199375, 199375, 199375, 199375, 199375} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
	},
};

struct upower_tbl upower_tbl_cluster_b_LITE = {
	.row = {
		{.cap = 504, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 504, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 532, .volt = 69375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 580, .volt = 71250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 625, .volt = 73125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 667, .volt = 75625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 725, .volt = 78125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 784, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 821, .volt = 83125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 881, .volt = 86875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 941, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 969, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 998, .volt = 95625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1024, .volt = 98750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_cci_LITE = {
	.row = {
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 65625, .dyn_pwr = 8380,
			.lkg_pwr = {45950, 45950, 45950, 45950, 45950, 45950} },
		{.cap = 0, .volt = 67500, .dyn_pwr = 10201,
			.lkg_pwr = {47637, 47637, 47637, 47637, 47637, 47637} },
		{.cap = 0, .volt = 69375, .dyn_pwr = 12186,
			.lkg_pwr = {49324, 49324, 49324, 49324, 49324, 49324} },
		{.cap = 0, .volt = 71875, .dyn_pwr = 15113,
			.lkg_pwr = {51741, 51741, 51741, 51741, 51741, 51741} },
		{.cap = 0, .volt = 73750, .dyn_pwr = 17529,
			.lkg_pwr = {53595, 53595, 53595, 53595, 53595, 53595} },
		{.cap = 0, .volt = 76250, .dyn_pwr = 21026,
			.lkg_pwr = {56068, 56068, 56068, 56068, 56068, 56068} },
		{.cap = 0, .volt = 78750, .dyn_pwr = 24868,
			.lkg_pwr = {58540, 58540, 58540, 58540, 58540, 58540} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 27538,
			.lkg_pwr = {59777, 59777, 59777, 59777, 59777, 59777} },
		{.cap = 0, .volt = 84375, .dyn_pwr = 34867,
			.lkg_pwr = {64906, 64906, 64906, 64906, 64906, 64906} },
		{.cap = 0, .volt = 86875, .dyn_pwr = 38118,
			.lkg_pwr = {67836, 67836, 67836, 67836, 67836, 67836} },
		{.cap = 0, .volt = 88750, .dyn_pwr = 40987,
			.lkg_pwr = {70035, 70035, 70035, 70035, 70035, 70035} },
		{.cap = 0, .volt = 92500, .dyn_pwr = 47143,
			.lkg_pwr = {74867, 74867, 74867, 74867, 74867, 74867} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
	},
};

struct upower_tbl upower_tbl_l_P95 = {
	.row = {
		{.cap = 229, .volt = 63750, .dyn_pwr = 26737,
			.lkg_pwr = {39435, 39435, 39435, 39435, 39435, 39435} },
		{.cap = 247, .volt = 66250, .dyn_pwr = 31711,
			.lkg_pwr = {41438, 41438, 41438, 41438, 41438, 41438} },
		{.cap = 261, .volt = 68125, .dyn_pwr = 36490,
			.lkg_pwr = {42941, 42941, 42941, 42941, 42941, 42941} },
		{.cap = 278, .volt = 70000, .dyn_pwr = 41608,
			.lkg_pwr = {44444, 44444, 44444, 44444, 44444, 44444} },
		{.cap = 299, .volt = 71875, .dyn_pwr = 47204,
			.lkg_pwr = {46096, 46096, 46096, 46096, 46096, 46096} },
		{.cap = 323, .volt = 75000, .dyn_pwr = 56180,
			.lkg_pwr = {48850, 48850, 48850, 48850, 48850, 48850} },
		{.cap = 348, .volt = 77500, .dyn_pwr = 65093,
			.lkg_pwr = {51053, 51053, 51053, 51053, 51053, 51053} },
		{.cap = 372, .volt = 80000, .dyn_pwr = 74800,
			.lkg_pwr = {53256, 53256, 53256, 53256, 53256, 53256} },
		{.cap = 395, .volt = 82500, .dyn_pwr = 85333,
			.lkg_pwr = {55867, 55867, 55867, 55867, 55867, 55867} },
		{.cap = 410, .volt = 84375, .dyn_pwr = 93674,
			.lkg_pwr = {57825, 57825, 57825, 57825, 57825, 57825} },
		{.cap = 439, .volt = 88750, .dyn_pwr = 111540,
			.lkg_pwr = {62394, 62394, 62394, 62394, 62394, 62394} },
		{.cap = 454, .volt = 91250, .dyn_pwr = 122654,
			.lkg_pwr = {65200, 65200, 65200, 65200, 65200, 65200} },
		{.cap = 466, .volt = 93125, .dyn_pwr = 132686,
			.lkg_pwr = {67450, 67450, 67450, 67450, 67450, 67450} },
		{.cap = 482, .volt = 95625, .dyn_pwr = 145035,
			.lkg_pwr = {70450, 70450, 70450, 70450, 70450, 70450} },
		{.cap = 496, .volt = 98125, .dyn_pwr = 158201,
			.lkg_pwr = {73450, 73450, 73450, 73450, 73450, 73450} },
		{.cap = 510, .volt = 100000, .dyn_pwr = 170000,
			.lkg_pwr = {75700, 75700, 75700, 75700, 75700, 75700} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
		{{0}, {42440} },
	},
};

struct upower_tbl upower_tbl_cluster_l_P95 = {
	.row = {
		{.cap = 229, .volt = 63750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 247, .volt = 66250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 261, .volt = 68125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 278, .volt = 70000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 299, .volt = 71875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 323, .volt = 75000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 348, .volt = 77500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 372, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 395, .volt = 82500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 410, .volt = 84375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 439, .volt = 88750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 454, .volt = 91250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 466, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 482, .volt = 95625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 496, .volt = 98125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 510, .volt = 100000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_b_P95 = {
	.row = {
		{.cap = 455, .volt = 67500, .dyn_pwr = 111920,
		.lkg_pwr = {113353, 113353, 113353, 113353, 113353, 113353} },
		{.cap = 481, .volt = 69375, .dyn_pwr = 126315,
		.lkg_pwr = {117470, 117470, 117470, 117470, 117470, 117470} },
		{.cap = 523, .volt = 71250, .dyn_pwr = 145374,
		.lkg_pwr = {122042, 122042, 122042, 122042, 122042, 122042} },
		{.cap = 564, .volt = 73125, .dyn_pwr = 165742,
		.lkg_pwr = {126841, 126841, 126841, 126841, 126841, 126841} },
		{.cap = 602, .volt = 75625, .dyn_pwr = 190579,
		.lkg_pwr = {133239, 133239, 133239, 133239, 133239, 133239} },
		{.cap = 654, .volt = 78125, .dyn_pwr = 222078,
		.lkg_pwr = {139638, 139638, 139638, 139638, 139638, 139638} },
		{.cap = 708, .volt = 80000, .dyn_pwr = 252100,
		.lkg_pwr = {144437, 144437, 144437, 144437, 144437, 144437} },
		{.cap = 741, .volt = 83125, .dyn_pwr = 287453,
		.lkg_pwr = {152925, 152925, 152925, 152925, 152925, 152925} },
		{.cap = 795, .volt = 86875, .dyn_pwr = 341184,
		.lkg_pwr = {163111, 163111, 163111, 163111, 163111, 163111} },
		{.cap = 850, .volt = 90000, .dyn_pwr = 394851,
		.lkg_pwr = {171600, 171600, 171600, 171600, 171600, 171600} },
		{.cap = 875, .volt = 93125, .dyn_pwr = 436101,
		.lkg_pwr = {181520, 181520, 181520, 181520, 181520, 181520} },
		{.cap = 901, .volt = 95625, .dyn_pwr = 473960,
		.lkg_pwr = {189456, 189456, 189456, 189456, 189456, 189456} },
		{.cap = 924, .volt = 98750, .dyn_pwr = 520337,
		.lkg_pwr = {199375, 199375, 199375, 199375, 199375, 199375} },
		{.cap = 948, .volt = 101250, .dyn_pwr = 562258,
		.lkg_pwr = {208050, 208050, 208050, 208050, 208050, 208050} },
		{.cap = 990, .volt = 104375, .dyn_pwr = 613748,
		.lkg_pwr = {219818, 219818, 219818, 219818, 219818, 219818} },
		{.cap = 1024, .volt = 111875, .dyn_pwr = 756276,
		.lkg_pwr = {250591, 250591, 250591, 250591, 250591, 250591} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
		{{0}, {113353} },
	},
};

struct upower_tbl upower_tbl_cluster_b_P95 = {
	.row = {
		{.cap = 455, .volt = 67500, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 481, .volt = 69375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 523, .volt = 71250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 564, .volt = 73125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 602, .volt = 75625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 654, .volt = 78125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 708, .volt = 80000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 741, .volt = 83125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 795, .volt = 86875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 850, .volt = 90000, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 875, .volt = 93125, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 901, .volt = 95625, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 924, .volt = 98750, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 948, .volt = 101250, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 990, .volt = 104375, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
		{.cap = 1024, .volt = 111875, .dyn_pwr = 0,
			.lkg_pwr = {0, 0, 0, 0, 0, 0} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
		{{0}, {0} },
	},
};

struct upower_tbl upower_tbl_cci_P95 = {
	.row = {
		{.cap = 0, .volt = 63750, .dyn_pwr = 7109,
			.lkg_pwr = {44264, 44264, 44264, 44264, 44264, 44264} },
		{.cap = 0, .volt = 65625, .dyn_pwr = 8380,
			.lkg_pwr = {45950, 45950, 45950, 45950, 45950, 45950} },
		{.cap = 0, .volt = 67500, .dyn_pwr = 10201,
			.lkg_pwr = {47637, 47637, 47637, 47637, 47637, 47637} },
		{.cap = 0, .volt = 69375, .dyn_pwr = 12186,
			.lkg_pwr = {49324, 49324, 49324, 49324, 49324, 49324} },
		{.cap = 0, .volt = 71875, .dyn_pwr = 15113,
			.lkg_pwr = {51741, 51741, 51741, 51741, 51741, 51741} },
		{.cap = 0, .volt = 73750, .dyn_pwr = 17529,
			.lkg_pwr = {53595, 53595, 53595, 53595, 53595, 53595} },
		{.cap = 0, .volt = 76250, .dyn_pwr = 21026,
			.lkg_pwr = {56068, 56068, 56068, 56068, 56068, 56068} },
		{.cap = 0, .volt = 78750, .dyn_pwr = 24868,
			.lkg_pwr = {58540, 58540, 58540, 58540, 58540, 58540} },
		{.cap = 0, .volt = 80000, .dyn_pwr = 27538,
			.lkg_pwr = {59777, 59777, 59777, 59777, 59777, 59777} },
		{.cap = 0, .volt = 84375, .dyn_pwr = 34867,
			.lkg_pwr = {64906, 64906, 64906, 64906, 64906, 64906} },
		{.cap = 0, .volt = 86875, .dyn_pwr = 38118,
			.lkg_pwr = {67836, 67836, 67836, 67836, 67836, 67836} },
		{.cap = 0, .volt = 88750, .dyn_pwr = 40987,
			.lkg_pwr = {70035, 70035, 70035, 70035, 70035, 70035} },
		{.cap = 0, .volt = 92500, .dyn_pwr = 47143,
			.lkg_pwr = {74867, 74867, 74867, 74867, 74867, 74867} },
		{.cap = 0, .volt = 95000, .dyn_pwr = 51541,
			.lkg_pwr = {78234, 78234, 78234, 78234, 78234, 78234} },
		{.cap = 0, .volt = 97500, .dyn_pwr = 56243,
			.lkg_pwr = {81602, 81602, 81602, 81602, 81602, 81602} },
		{.cap = 0, .volt = 100000, .dyn_pwr = 61220,
			.lkg_pwr = {84969, 84969, 84969, 84969, 84969, 84969} },
	},
	.lkg_idx = DEFAULT_LKG_IDX,
	.row_num = UPOWER_OPP_NUM,
	.nr_idle_states = NR_UPOWER_CSTATES,
	.idle_states = {
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
		{{0}, {47637} },
	},
};
#endif /* UNIFIED_POWER_DATA_H */



