// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2019 MediaTek Inc.
 */

#include <linux/device.h>
#include <linux/fs.h>
#include <linux/module.h>
#include <linux/of_device.h>
#include <linux/spinlock.h>
#include <linux/of.h>
#include <linux/of_irq.h>
#include <linux/of_address.h>
#include <linux/io.h>

#include <mtk_dbg_common_v1.h>
#include <mtk_lpm_module.h>
#include <mtk_idle_sysfs.h>
#include <mtk_suspend_sysfs.h>
#include <mtk_spm_sysfs.h>

#include <mtk_pwr_ctrl.h>
#include <mtk_dbg_fs_common.h>
#include <mtk_cond.h>
#include <mtk_spm_comm.h>
#include <mtk_spm_reg.h>

/* Determine for node route */
#define MT_LP_RQ_NODE	"/sys/kernel/debug/spm/spm_resource_req"

#define DEFINE_ATTR_RO(_name)			\
	static struct kobj_attribute _name##_attr = {	\
		.attr	= {				\
			.name = #_name,			\
			.mode = 0444,			\
		},					\
		.show	= _name##_show,			\
	}
#define DEFINE_ATTR_RW(_name)			\
	static struct kobj_attribute _name##_attr = {	\
		.attr	= {				\
			.name = #_name,			\
			.mode = 0644,			\
		},					\
		.show	= _name##_show,			\
		.store	= _name##_store,		\
	}
#define __ATTR_OF(_name)	(&_name##_attr.attr)



#undef mtk_dbg_spm_log
#define mtk_dbg_spm_log(fmt, args...) \
	do { \
		int l = scnprintf(p, sz, fmt, ##args); \
		p += l; \
		sz -= l; \
	} while (0)

void __iomem *mtk_spm_wdt_latch_base;

/* code gen by convert_SPM_FS.py, need struct pwr_ctrl */
static char *mtk_pwr_ctrl_str[PW_MAX_COUNT] = {
	[PW_PCM_FLAGS] =
	"pcm_flags",
	[PW_PCM_FLAGS_CUST] =
	"pcm_flags_cust",
	[PW_PCM_FLAGS_CUST_SET] =
	"pcm_flags_cust_set",
	[PW_PCM_FLAGS_CUST_CLR] =
	"pcm_flags_cust_clr",
	[PW_PCM_FLAGS1] =
	"pcm_flags1",
	[PW_PCM_FLAGS1_CUST] =
	"pcm_flags1_cust",
	[PW_PCM_FLAGS1_CUST_SET] =
	"pcm_flags1_cust_set",
	[PW_PCM_FLAGS1_CUST_CLR] =
	"pcm_flags1_cust_clr",
	[PW_TIMER_VAL] =
	"timer_val",
	[PW_TIMER_VAL_CUST] =
	"timer_val_cust",
	[PW_TIMER_VAL_RAMP_EN] =
	"timer_val_ramp_en",
	[PW_TIMER_VAL_RAMP_EN_SEC] =
	"timer_val_ramp_en_sec",
	[PW_WAKE_SRC] =
	"wake_src",
	[PW_WAKE_SRC_CUST] =
	"wake_src_cust",
	[PW_WAKELOCK_TIMER_VAL] =
	"wakelock_timer_val",
	[PW_WDT_DISABLE] =
	"wdt_disable",

	/* SPM_AP_STANDBY_CON */
	[PW_REG_WFI_OP] =
	"reg_wfi_op",
	[PW_REG_WFI_TYPE] =
	"reg_wfi_type",
	[PW_REG_MP0_CPUTOP_IDLE_MASK] =
	"reg_mp0_cputop_idle_mask",
	[PW_REG_MP1_CPUTOP_IDLE_MASK] =
	"reg_mp1_cputop_idle_mask",
	[PW_REG_MCUSYS_IDLE_MASK] =
	"reg_mcusys_idle_mask",
	[PW_REG_MD_APSRC_1_SEL] =
	"reg_md_apsrc_1_sel",
	[PW_REG_MD_APSRC_0_SEL] =
	"reg_md_apsrc_0_sel",
	[PW_REG_CONN_APSRC_SEL] =
	"reg_conn_apsrc_sel",

	/* SPM_SRC6_MASK */
	[PW_REG_DPMAIF_SRCCLKENA_MASK_B] =
	"reg_dpmaif_srcclkena_mask_b",
	[PW_REG_DPMAIF_INFRA_REQ_MASK_B] =
	"reg_dpmaif_infra_req_mask_b",
	[PW_REG_DPMAIF_APSRC_REQ_MASK_B] =
	"reg_dpmaif_apsrc_req_mask_b",
	[PW_REG_DPMAIF_VRF18_REQ_MASK_B] =
	"reg_dpmaif_vrf18_req_mask_b",
	[PW_REG_DPMAIF_DDR_EN_MASK_B] =
	"reg_dpmaif_ddr_en_mask_b",
	[PW_REG_PCIE1_ACTIVE_SRCCLKENA_MASK_B] =
	"reg_pcie1_active_srcclkena_mask_b",
	[PW_REG_PCIE1_ACTIVE_INFRA_REQ_MASK_B] =
	"reg_pcie1_active_infra_req_mask_b",
	[PW_REG_PCIE1_ACTIVE_APSRC_REQ_MASK_B] =
	"reg_pcie1_active_apsrc_req_mask_b",
	[PW_REG_PCIE1_ACTIVE_VRF18_REQ_MASK_B] =
	"reg_pcie1_active_vrf18_req_mask_b",
	[PW_REG_PCIE1_ACTIVE_DDR_EN_MASK_B] =
	"reg_pcie1_active_ddr_en_mask_b",
	[PW_REG_PCIE2_ACTIVE_SRCCLKENA_MASK_B] =
	"reg_pcie2_active_srcclkena_mask_b",
	[PW_REG_PCIE2_ACTIVE_INFRA_REQ_MASK_B] =
	"reg_pcie2_active_infra_req_mask_b",
	[PW_REG_PCIE2_ACTIVE_APSRC_REQ_MASK_B] =
	"reg_pcie2_active_apsrc_req_mask_b",
	[PW_REG_PCIE2_ACTIVE_VRF18_REQ_MASK_B] =
	"reg_pcie2_active_vrf18_req_mask_b",
	[PW_REG_PCIE2_ACTIVE_DDR_EN_MASK_B] =
	"reg_pcie2_active_ddr_en_mask_b",
	[PW_REG_PCIE3_ACTIVE_SRCCLKENA_MASK_B] =
	"reg_pcie3_active_srcclkena_mask_b",
	[PW_REG_PCIE3_ACTIVE_INFRA_REQ_MASK_B] =
	"reg_pcie3_active_infra_req_mask_b",
	[PW_REG_PCIE3_ACTIVE_APSRC_REQ_MASK_B] =
	"reg_pcie3_active_apsrc_req_mask_b",
	[PW_REG_PCIE3_ACTIVE_VRF18_REQ_MASK_B] =
	"reg_pcie3_active_vrf18_req_mask_b",
	[PW_REG_PCIE3_ACTIVE_DDR_EN_MASK_B] =
	"reg_pcie3_active_ddr_en_mask_b",
	[PW_REG_PCIE1_SRCCLKENA_MASK_B] =
	"reg_pcie1_srcclkena_mask_b",
	[PW_REG_PCIE1_INFRA_REQ_MASK_B] =
	"reg_pcie1_infra_req_mask_b",
	[PW_REG_PCIE1_APSRC_REQ_MASK_B] =
	"reg_pcie1_apsrc_req_mask_b",
	[PW_REG_PCIE1_VRF18_REQ_MASK_B] =
	"reg_pcie1_vrf18_req_mask_b",
	[PW_REG_PCIE1_DDR_EN_MASK_B] =
	"reg_pcie1_ddr_en_mask_b",
	[PW_REG_PCIE2_SRCCLKENA_MASK_B] =
	"reg_pcie2_srcclkena_mask_b",
	[PW_REG_PCIE2_INFRA_REQ_MASK_B] =
	"reg_pcie2_infra_req_mask_b",
	[PW_REG_PCIE2_APSRC_REQ_MASK_B] =
	"reg_pcie2_apsrc_req_mask_b",
	[PW_REG_PCIE2_VRF18_REQ_MASK_B] =
	"reg_pcie2_vrf18_req_mask_b",
	[PW_REG_PCIE2_DDR_EN_MASK_B] =
	"reg_pcie2_ddr_en_mask_b",
	[PW_REG_PCIE3_SRCCLKENA_MASK_B] =
	"reg_pcie3_srcclkena_mask_b",
	[PW_REG_PCIE3_INFRA_REQ_MASK_B] =
	"reg_pcie3_infra_req_mask_b",

	/* SPM_SRC_REQ */
	[PW_REG_SPM_APSRC_REQ] =
	"reg_spm_apsrc_req",
	[PW_REG_SPM_F26M_REQ] =
	"reg_spm_f26m_req",
	[PW_REG_SPM_INFRA_REQ] =
	"reg_spm_infra_req",
	[PW_REG_SPM_VRF18_REQ] =
	"reg_spm_vrf18_req",
	[PW_REG_SPM_DDR_EN_REQ] =
	"reg_spm_ddr_en_req",
	[PW_REG_SPM_DVFS_REQ] =
	"reg_spm_dvfs_req",
	[PW_REG_SPM_SW_MAILBOX_REQ] =
	"reg_spm_sw_mailbox_req",
	[PW_REG_SPM_SSPM_MAILBOX_REQ] =
	"reg_spm_sspm_mailbox_req",
	[PW_REG_SPM_ADSP_MAILBOX_REQ] =
	"reg_spm_adsp_mailbox_req",
	[PW_REG_SPM_SCP_MAILBOX_REQ] =
	"reg_spm_scp_mailbox_req",

	/* SPM_SRC_MASK */
	[PW_REG_MD_SRCCLKENA_0_MASK_B] =
	"reg_md_srcclkena_0_mask_b",
	[PW_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B] =
	"reg_md_srcclkena2infra_req_0_mask_b",
	[PW_REG_MD_APSRC2INFRA_REQ_0_MASK_B] =
	"reg_md_apsrc2infra_req_0_mask_b",
	[PW_REG_MD_APSRC_REQ_0_MASK_B] =
	"reg_md_apsrc_req_0_mask_b",
	[PW_REG_MD_VRF18_REQ_0_MASK_B] =
	"reg_md_vrf18_req_0_mask_b",
	[PW_REG_MD_DDR_EN_0_MASK_B] =
	"reg_md_ddr_en_0_mask_b",
	[PW_REG_MD_SRCCLKENA_1_MASK_B] =
	"reg_md_srcclkena_1_mask_b",
	[PW_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B] =
	"reg_md_srcclkena2infra_req_1_mask_b",
	[PW_REG_MD_APSRC2INFRA_REQ_1_MASK_B] =
	"reg_md_apsrc2infra_req_1_mask_b",
	[PW_REG_MD_APSRC_REQ_1_MASK_B] =
	"reg_md_apsrc_req_1_mask_b",
	[PW_REG_MD_VRF18_REQ_1_MASK_B] =
	"reg_md_vrf18_req_1_mask_b",
	[PW_REG_MD_DDR_EN_1_MASK_B] =
	"reg_md_ddr_en_1_mask_b",
	[PW_REG_CONN_SRCCLKENA_MASK_B] =
	"reg_conn_srcclkena_mask_b",
	[PW_REG_CONN_SRCCLKENB_MASK_B] =
	"reg_conn_srcclkenb_mask_b",
	[PW_REG_CONN_INFRA_REQ_MASK_B] =
	"reg_conn_infra_req_mask_b",
	[PW_REG_CONN_APSRC_REQ_MASK_B] =
	"reg_conn_apsrc_req_mask_b",
	[PW_REG_CONN_VRF18_REQ_MASK_B] =
	"reg_conn_vrf18_req_mask_b",
	[PW_REG_CONN_DDR_EN_MASK_B] =
	"reg_conn_ddr_en_mask_b",
	[PW_REG_CONN_VFE28_MASK_B] =
	"reg_conn_vfe28_mask_b",
	[PW_REG_SRCCLKENI0_SRCCLKENA_MASK_B] =
	"reg_srcclkeni0_srcclkena_mask_b",
	[PW_REG_SRCCLKENI0_INFRA_REQ_MASK_B] =
	"reg_srcclkeni0_infra_req_mask_b",
	[PW_REG_SRCCLKENI1_SRCCLKENA_MASK_B] =
	"reg_srcclkeni1_srcclkena_mask_b",
	[PW_REG_SRCCLKENI1_INFRA_REQ_MASK_B] =
	"reg_srcclkeni1_infra_req_mask_b",
	[PW_REG_SRCCLKENI2_SRCCLKENA_MASK_B] =
	"reg_srcclkeni2_srcclkena_mask_b",
	[PW_REG_SRCCLKENI2_INFRA_REQ_MASK_B] =
	"reg_srcclkeni2_infra_req_mask_b",
	[PW_REG_INFRASYS_APSRC_REQ_MASK_B] =
	"reg_infrasys_apsrc_req_mask_b",
	[PW_REG_INFRASYS_DDR_EN_MASK_B] =
	"reg_infrasys_ddr_en_mask_b",
	[PW_REG_MD32_SRCCLKENA_MASK_B] =
	"reg_md32_srcclkena_mask_b",
	[PW_REG_MD32_INFRA_REQ_MASK_B] =
	"reg_md32_infra_req_mask_b",
	[PW_REG_MD32_APSRC_REQ_MASK_B] =
	"reg_md32_apsrc_req_mask_b",
	[PW_REG_MD32_VRF18_REQ_MASK_B] =
	"reg_md32_vrf18_req_mask_b",
	[PW_REG_MD32_DDR_EN_MASK_B] =
	"reg_md32_ddr_en_mask_b",

	/* SPM_SRC2_MASK */
	[PW_REG_SCP_SRCCLKENA_MASK_B] =
	"reg_scp_srcclkena_mask_b",
	[PW_REG_SCP_INFRA_REQ_MASK_B] =
	"reg_scp_infra_req_mask_b",
	[PW_REG_SCP_APSRC_REQ_MASK_B] =
	"reg_scp_apsrc_req_mask_b",
	[PW_REG_SCP_VRF18_REQ_MASK_B] =
	"reg_scp_vrf18_req_mask_b",
	[PW_REG_SCP_DDR_EN_MASK_B] =
	"reg_scp_ddr_en_mask_b",
	[PW_REG_NETSYS_SRCCLKENA_MASK_B] =
	"reg_netsys_srcclkena_mask_b",
	[PW_REG_NETSYS_INFRA_REQ_MASK_B] =
	"reg_netsys_infra_req_mask_b",
	[PW_REG_NETSYS_APSRC_REQ_MASK_B] =
	"reg_netsys_apsrc_req_mask_b",
	[PW_REG_NETSYS_VRF18_REQ_MASK_B] =
	"reg_netsys_vrf18_req_mask_b",
	[PW_REG_NETSYS_DDR_EN_MASK_B] =
	"reg_netsys_ddr_en_mask_b",
	[PW_REG_UFS_SRCCLKENA_MASK_B] =
	"reg_ufs_srcclkena_mask_b",
	[PW_REG_UFS_INFRA_REQ_MASK_B] =
	"reg_ufs_infra_req_mask_b",
	[PW_REG_UFS_APSRC_REQ_MASK_B] =
	"reg_ufs_apsrc_req_mask_b",
	[PW_REG_UFS_VRF18_REQ_MASK_B] =
	"reg_ufs_vrf18_req_mask_b",
	[PW_REG_UFS_DDR_EN_MASK_B] =
	"reg_ufs_ddr_en_mask_b",
	[PW_REG_DISP0_APSRC_REQ_MASK_B] =
	"reg_disp0_apsrc_req_mask_b",
	[PW_REG_DISP0_DDR_EN_MASK_B] =
	"reg_disp0_ddr_en_mask_b",
	[PW_REG_DISP1_APSRC_REQ_MASK_B] =
	"reg_disp1_apsrc_req_mask_b",
	[PW_REG_DISP1_DDR_EN_MASK_B] =
	"reg_disp1_ddr_en_mask_b",
	[PW_REG_GCE_INFRA_REQ_MASK_B] =
	"reg_gce_infra_req_mask_b",
	[PW_REG_GCE_APSRC_REQ_MASK_B] =
	"reg_gce_apsrc_req_mask_b",
	[PW_REG_GCE_VRF18_REQ_MASK_B] =
	"reg_gce_vrf18_req_mask_b",
	[PW_REG_GCE_DDR_EN_MASK_B] =
	"reg_gce_ddr_en_mask_b",
	[PW_REG_USB_SRCCLKENA_MASK_B] =
	"reg_usb_srcclkena_mask_b",
	[PW_REG_USB_INFRA_REQ_MASK_B] =
	"reg_usb_infra_req_mask_b",
	[PW_REG_USB_APSRC_REQ_MASK_B] =
	"reg_usb_apsrc_req_mask_b",
	[PW_REG_USB_VRF18_REQ_MASK_B] =
	"reg_usb_vrf18_req_mask_b",
	[PW_REG_USB_DDR_EN_MASK_B] =
	"reg_usb_ddr_en_mask_b",
	[PW_REG_CG_CHECK_SRCCLKENA_MASK_B] =
	"reg_cg_check_srcclkena_mask_b",
	[PW_REG_CG_CHECK_APSRC_REQ_MASK_B] =
	"reg_cg_check_apsrc_req_mask_b",
	[PW_REG_CG_CHECK_VRF18_REQ_MASK_B] =
	"reg_cg_check_vrf18_req_mask_b",
	[PW_REG_CG_CHECK_DDR_EN_MASK_B] =
	"reg_cg_check_ddr_en_mask_b",

	/* SPM_SRC3_MASK */
	[PW_REG_DVFSRC_EVENT_TRIGGER_MASK_B] =
	"reg_dvfsrc_event_trigger_mask_b",
	[PW_REG_SW2SPM_INT0_MASK_B] =
	"reg_sw2spm_int0_mask_b",
	[PW_REG_SW2SPM_INT1_MASK_B] =
	"reg_sw2spm_int1_mask_b",
	[PW_REG_SW2SPM_INT2_MASK_B] =
	"reg_sw2spm_int2_mask_b",
	[PW_REG_SW2SPM_INT3_MASK_B] =
	"reg_sw2spm_int3_mask_b",
	[PW_REG_SC_ADSP2SPM_WAKEUP_MASK_B] =
	"reg_sc_adsp2spm_wakeup_mask_b",
	[PW_REG_SC_SSPM2SPM_WAKEUP_MASK_B] =
	"reg_sc_sspm2spm_wakeup_mask_b",
	[PW_REG_SC_SCP2SPM_WAKEUP_MASK_B] =
	"reg_sc_scp2spm_wakeup_mask_b",
	[PW_REG_CSYSPWRREQ_MASK] =
	"reg_csyspwrreq_mask",
	[PW_REG_SPM_SRCCLKENA_RESERVED_MASK_B] =
	"reg_spm_srcclkena_reserved_mask_b",
	[PW_REG_SPM_INFRA_REQ_RESERVED_MASK_B] =
	"reg_spm_infra_req_reserved_mask_b",
	[PW_REG_SPM_APSRC_REQ_RESERVED_MASK_B] =
	"reg_spm_apsrc_req_reserved_mask_b",
	[PW_REG_SPM_VRF18_REQ_RESERVED_MASK_B] =
	"reg_spm_vrf18_req_reserved_mask_b",
	[PW_REG_SPM_DDR_EN_RESERVED_MASK_B] =
	"reg_spm_ddr_en_reserved_mask_b",
	[PW_REG_MCUPM_SRCCLKENA_MASK_B] =
	"reg_mcupm_srcclkena_mask_b",
	[PW_REG_MCUPM_INFRA_REQ_MASK_B] =
	"reg_mcupm_infra_req_mask_b",
	[PW_REG_MCUPM_APSRC_REQ_MASK_B] =
	"reg_mcupm_apsrc_req_mask_b",
	[PW_REG_MCUPM_VRF18_REQ_MASK_B] =
	"reg_mcupm_vrf18_req_mask_b",
	[PW_REG_MCUPM_DDR_EN_MASK_B] =
	"reg_mcupm_ddr_en_mask_b",
	[PW_REG_MSDC0_SRCCLKENA_MASK_B] =
	"reg_msdc0_srcclkena_mask_b",
	[PW_REG_MSDC0_INFRA_REQ_MASK_B] =
	"reg_msdc0_infra_req_mask_b",
	[PW_REG_MSDC0_APSRC_REQ_MASK_B] =
	"reg_msdc0_apsrc_req_mask_b",
	[PW_REG_MSDC0_VRF18_REQ_MASK_B] =
	"reg_msdc0_vrf18_req_mask_b",
	[PW_REG_MSDC0_DDR_EN_MASK_B] =
	"reg_msdc0_ddr_en_mask_b",
	[PW_REG_MSDC1_SRCCLKENA_MASK_B] =
	"reg_msdc1_srcclkena_mask_b",
	[PW_REG_MSDC1_INFRA_REQ_MASK_B] =
	"reg_msdc1_infra_req_mask_b",
	[PW_REG_MSDC1_APSRC_REQ_MASK_B] =
	"reg_msdc1_apsrc_req_mask_b",
	[PW_REG_MSDC1_VRF18_REQ_MASK_B] =
	"reg_msdc1_vrf18_req_mask_b",
	[PW_REG_MSDC1_DDR_EN_MASK_B] =
	"reg_msdc1_ddr_en_mask_b",

	/* SPM_SRC4_MASK */
	[PW_CCIF_EVENT_MASK_B] =
	"ccif_event_mask_b",
	[PW_REG_AUDIO_SRCCLKENA_MASK_B] =
	"reg_audio_srcclkena_mask_b",
	[PW_REG_AUDIO_INFRA_REQ_MASK_B] =
	"reg_audio_infra_req_mask_b",
	[PW_REG_AUDIO_APSRC_REQ_MASK_B] =
	"reg_audio_apsrc_req_mask_b",
	[PW_REG_AUDIO_VRF18_REQ_MASK_B] =
	"reg_audio_vrf18_req_mask_b",
	[PW_REG_AUDIO_DDR_EN_MASK_B] =
	"reg_audio_ddr_en_mask_b",
	[PW_REG_DRAMC0_MD32_INFRA_REQ_MASK_B] =
	"reg_dramc0_md32_infra_req_mask_b",
	[PW_REG_DRAMC0_MD32_VRF18_REQ_MASK_B] =
	"reg_dramc0_md32_vrf18_req_mask_b",
	[PW_REG_DRAMC1_MD32_INFRA_REQ_MASK_B] =
	"reg_dramc1_md32_infra_req_mask_b",
	[PW_REG_DRAMC1_MD32_VRF18_REQ_MASK_B] =
	"reg_dramc1_md32_vrf18_req_mask_b",
	[PW_REG_CONN_SRCCLKENB2PWRAP_MASK_B] =
	"reg_conn_srcclkenb2pwrap_mask_b",
	[PW_REG_DRAMC0_MD32_WAKEUP_MASK] =
	"reg_dramc0_md32_wakeup_mask",
	[PW_REG_DRAMC1_MD32_WAKEUP_MASK] =
	"reg_dramc1_md32_wakeup_mask",
	[PW_REG_CLDMA_SRCCLKENA_MASK_B] =
	"reg_cldma_srcclkena_mask_b",
	[PW_REG_CLDMA_INFRA_REQ_MASK_B] =
	"reg_cldma_infra_req_mask_b",
	[PW_REG_CLDMA_APSRC_REQ_MASK_B] =
	"reg_cldma_apsrc_req_mask_b",
	[PW_REG_CLDMA_VRF18_REQ_MASK_B] =
	"reg_cldma_vrf18_req_mask_b",

	/* SPM_SRC5_MASK */
	[PW_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B] =
	"reg_mcusys_merge_apsrc_req_mask_b",
	[PW_REG_MCUSYS_MERGE_DDR_EN_MASK_B] =
	"reg_mcusys_merge_ddr_en_mask_b",
	[PW_REG_PCIE_ACTIVE_SRCCLKENA_MASK_B] =
	"reg_pcie_active_srcclkena_mask_b",
	[PW_REG_PCIE_ACTIVE_INFRA_REQ_MASK_B] =
	"reg_pcie_active_infra_req_mask_b",
	[PW_REG_PCIE_ACTIVE_APSRC_REQ_MASK_B] =
	"reg_pcie_active_apsrc_req_mask_b",
	[PW_REG_PCIE_ACTIVE_VRF18_REQ_MASK_B] =
	"reg_pcie_active_vrf18_req_mask_b",
	[PW_REG_PCIE_ACTIVE_DDR_EN_MASK_B] =
	"reg_pcie_active_ddr_en_mask_b",
	[PW_REG_PCIE_SRCCLKENA_MASK_B] =
	"reg_pcie_srcclkena_mask_b",
	[PW_REG_PCIE_INFRA_REQ_MASK_B] =
	"reg_pcie_infra_req_mask_b",
	[PW_REG_PCIE_APSRC_REQ_MASK_B] =
	"reg_pcie_apsrc_req_mask_b",
	[PW_REG_PCIE_VRF18_REQ_MASK_B] =
	"reg_pcie_vrf18_req_mask_b",
	[PW_REG_PCIE_DDR_EN_MASK_B] =
	"reg_pcie_ddr_en_mask_b",
	[PW_REG_PCIE3_DDR_EN_MASK_B] =
	"reg_pcie3_ddr_en_mask_b",
	[PW_REG_PCIE3_APSRC_REQ_MASK_B] =
	"reg_pcie3_apsrc_req_mask_b",
	[PW_REG_PCIE3_VRF18_REQ_MASK_B] =
	"reg_pcie3_vrf18_req_mask_b",

	/* SPM_WAKEUP_EVENT_MASK */
	[PW_REG_WAKEUP_EVENT_MASK] =
	"reg_wakeup_event_mask",

	/* SPM_WAKEUP_EVENT_EXT_MASK */
	[PW_REG_EXT_WAKEUP_EVENT_MASK] =
	"reg_ext_wakeup_event_mask",
};

/**************************************
 * xxx_ctrl_show Function
 **************************************/
/* code gen by convert_SPM_FS.py, need struct pwr_ctrl */
static ssize_t mtk_show_pwr_ctrl(int id, char *buf, size_t buf_sz)
{
	char *p = buf;
	size_t mSize = 0;

	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags_cust = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS_CUST, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags_cust_set = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS_CUST_SET, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags_cust_clr = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS_CUST_CLR, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags1 = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS1, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags1_cust = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS1_CUST, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags1_cust_set = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS1_CUST_SET, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"pcm_flags1_cust_clr = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_PCM_FLAGS1_CUST_CLR, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"timer_val = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_TIMER_VAL, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"timer_val_cust = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_TIMER_VAL_CUST, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"timer_val_ramp_en = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_TIMER_VAL_RAMP_EN, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"timer_val_ramp_en_sec = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_TIMER_VAL_RAMP_EN_SEC, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"wake_src = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_WAKE_SRC, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"wake_src_cust = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_WAKE_SRC_CUST, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"wakelock_timer_val = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_WAKELOCK_TIMER_VAL, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"wdt_disable = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_WDT_DISABLE, 0));

	/* SPM_AP_STANDBY_CON */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_wfi_op = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_WFI_OP, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_wfi_type = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_WFI_TYPE, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mp0_cputop_idle_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MP0_CPUTOP_IDLE_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mp1_cputop_idle_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MP1_CPUTOP_IDLE_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcusys_idle_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUSYS_IDLE_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc_1_sel = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC_1_SEL, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc_0_sel = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC_0_SEL, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_apsrc_sel = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_APSRC_SEL, 0));

	/* SPM_SRC6_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dpmaif_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DPMAIF_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dpmaif_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DPMAIF_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dpmaif_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DPMAIF_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dpmaif_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DPMAIF_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dpmaif_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DPMAIF_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_active_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_ACTIVE_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_active_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_ACTIVE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_active_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_ACTIVE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_active_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_ACTIVE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_active_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_ACTIVE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_active_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_ACTIVE_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_active_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_ACTIVE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_active_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_ACTIVE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_active_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_ACTIVE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_active_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_ACTIVE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_active_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_ACTIVE_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_active_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_ACTIVE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_active_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_ACTIVE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_active_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_ACTIVE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_active_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_ACTIVE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie1_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE1_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie2_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE2_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_INFRA_REQ_MASK_B, 0));

	/* SPM_SRC_REQ */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_apsrc_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_APSRC_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_f26m_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_F26M_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_infra_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_INFRA_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_vrf18_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_VRF18_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_ddr_en_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_DDR_EN_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_dvfs_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_DVFS_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_sw_mailbox_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_SW_MAILBOX_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_sspm_mailbox_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_SSPM_MAILBOX_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_adsp_mailbox_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_ADSP_MAILBOX_REQ, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_scp_mailbox_req = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_SCP_MAILBOX_REQ, 0));

	/* SPM_SRC_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_srcclkena_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_SRCCLKENA_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_srcclkena2infra_req_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc2infra_req_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC2INFRA_REQ_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc_req_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC_REQ_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_vrf18_req_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_VRF18_REQ_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_ddr_en_0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_DDR_EN_0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_srcclkena_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_SRCCLKENA_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_srcclkena2infra_req_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc2infra_req_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC2INFRA_REQ_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_apsrc_req_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_APSRC_REQ_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_vrf18_req_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_VRF18_REQ_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md_ddr_en_1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD_DDR_EN_1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_srcclkenb_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_SRCCLKENB_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_vfe28_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_VFE28_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni0_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI0_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni0_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI0_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni1_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI1_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni1_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI1_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni2_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI2_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_srcclkeni2_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SRCCLKENI2_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_infrasys_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_INFRASYS_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_infrasys_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_INFRASYS_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md32_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD32_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md32_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD32_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md32_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD32_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md32_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD32_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_md32_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MD32_DDR_EN_MASK_B, 0));

	/* SPM_SRC2_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_scp_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SCP_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_scp_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SCP_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_scp_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SCP_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_scp_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SCP_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_scp_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SCP_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_netsys_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_NETSYS_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_netsys_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_NETSYS_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_netsys_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_NETSYS_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_netsys_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_NETSYS_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_netsys_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_NETSYS_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ufs_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_UFS_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ufs_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_UFS_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ufs_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_UFS_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ufs_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_UFS_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ufs_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_UFS_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_disp0_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DISP0_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_disp0_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DISP0_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_disp1_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DISP1_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_disp1_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DISP1_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_gce_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_GCE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_gce_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_GCE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_gce_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_GCE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_gce_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_GCE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_usb_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_USB_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_usb_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_USB_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_usb_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_USB_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_usb_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_USB_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_usb_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_USB_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cg_check_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CG_CHECK_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cg_check_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CG_CHECK_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cg_check_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CG_CHECK_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cg_check_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CG_CHECK_DDR_EN_MASK_B, 0));

	/* SPM_SRC3_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dvfsrc_event_trigger_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DVFSRC_EVENT_TRIGGER_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sw2spm_int0_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SW2SPM_INT0_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sw2spm_int1_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SW2SPM_INT1_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sw2spm_int2_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SW2SPM_INT2_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sw2spm_int3_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SW2SPM_INT3_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sc_adsp2spm_wakeup_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SC_ADSP2SPM_WAKEUP_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sc_sspm2spm_wakeup_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SC_SSPM2SPM_WAKEUP_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_sc_scp2spm_wakeup_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SC_SCP2SPM_WAKEUP_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_csyspwrreq_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CSYSPWRREQ_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_srcclkena_reserved_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_SRCCLKENA_RESERVED_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_infra_req_reserved_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_INFRA_REQ_RESERVED_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_apsrc_req_reserved_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_APSRC_REQ_RESERVED_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_vrf18_req_reserved_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_VRF18_REQ_RESERVED_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_spm_ddr_en_reserved_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_SPM_DDR_EN_RESERVED_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcupm_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUPM_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcupm_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUPM_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcupm_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUPM_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcupm_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUPM_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcupm_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUPM_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc0_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC0_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc0_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC0_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc0_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC0_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc0_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC0_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc0_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC0_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc1_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC1_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc1_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC1_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc1_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC1_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc1_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC1_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_msdc1_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MSDC1_DDR_EN_MASK_B, 0));

	/* SPM_SRC4_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"ccif_event_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_CCIF_EVENT_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_audio_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_AUDIO_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_audio_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_AUDIO_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_audio_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_AUDIO_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_audio_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_AUDIO_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_audio_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_AUDIO_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc0_md32_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC0_MD32_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc0_md32_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC0_MD32_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc1_md32_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC1_MD32_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc1_md32_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC1_MD32_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_conn_srcclkenb2pwrap_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CONN_SRCCLKENB2PWRAP_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc0_md32_wakeup_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC0_MD32_WAKEUP_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_dramc1_md32_wakeup_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_DRAMC1_MD32_WAKEUP_MASK, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cldma_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CLDMA_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cldma_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CLDMA_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cldma_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CLDMA_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_cldma_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_CLDMA_VRF18_REQ_MASK_B, 0));

	/* SPM_SRC5_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcusys_merge_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_mcusys_merge_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_MCUSYS_MERGE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_active_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_ACTIVE_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_active_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_ACTIVE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_active_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_ACTIVE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_active_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_ACTIVE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_active_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_ACTIVE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_srcclkena_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_SRCCLKENA_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_infra_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_INFRA_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_VRF18_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_ddr_en_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_DDR_EN_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_apsrc_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_APSRC_REQ_MASK_B, 0));
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_pcie3_vrf18_req_mask_b = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_PCIE3_VRF18_REQ_MASK_B, 0));

	/* SPM_WAKEUP_EVENT_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_wakeup_event_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_WAKEUP_EVENT_MASK, 0));

	/* SPM_WAKEUP_EVENT_EXT_MASK */
	mSize += scnprintf(p + mSize, buf_sz - mSize,
		"reg_ext_wakeup_event_mask = 0x%zx\n",
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_GET,
		PW_REG_EXT_WAKEUP_EVENT_MASK, 0));

	WARN_ON(buf_sz - mSize <= 0);

	return mSize;
}

/**************************************
 * xxx_ctrl_store Function
 **************************************/
/* code gen by convert_SPM_FS.py, need struct pwr_ctrl */
static ssize_t mtk_store_pwr_ctrl(int id,	const char *buf, size_t count)
{
	u32 val;
	char cmd[64];

	if (sscanf(buf, "%63s %x", cmd, &val) != 2)
		return -EPERM;
	pr_info("[SPM] pwr_ctrl: cmd = %s, val = 0x%x\n", cmd, val);

	if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS_CUST])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS_CUST, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS_CUST_SET])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS_CUST_SET, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS_CUST_CLR])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS_CUST_CLR, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS1])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS1, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS1_CUST])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS1_CUST, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS1_CUST_SET])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS1_CUST_SET, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_PCM_FLAGS1_CUST_CLR])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_PCM_FLAGS1_CUST_CLR, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_TIMER_VAL])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_TIMER_VAL, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_TIMER_VAL_CUST])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_TIMER_VAL_CUST, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_TIMER_VAL_RAMP_EN])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_TIMER_VAL_RAMP_EN, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_TIMER_VAL_RAMP_EN_SEC])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_TIMER_VAL_RAMP_EN_SEC, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_WAKE_SRC])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_WAKE_SRC, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_WAKE_SRC_CUST])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_WAKE_SRC_CUST, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_WAKELOCK_TIMER_VAL])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_WAKELOCK_TIMER_VAL, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_WDT_DISABLE])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_WDT_DISABLE, val);

	/* SPM_AP_STANDBY_CON */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_WFI_OP])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_WFI_OP, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_WFI_TYPE])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_WFI_TYPE, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MP0_CPUTOP_IDLE_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MP0_CPUTOP_IDLE_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MP1_CPUTOP_IDLE_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MP1_CPUTOP_IDLE_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUSYS_IDLE_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUSYS_IDLE_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC_1_SEL])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC_1_SEL, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC_0_SEL])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC_0_SEL, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_APSRC_SEL])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_APSRC_SEL, val);

	/* SPM_SRC6_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DPMAIF_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DPMAIF_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DPMAIF_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DPMAIF_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DPMAIF_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DPMAIF_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DPMAIF_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DPMAIF_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DPMAIF_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DPMAIF_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_ACTIVE_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_ACTIVE_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_ACTIVE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_ACTIVE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_ACTIVE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_ACTIVE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_ACTIVE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_ACTIVE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_ACTIVE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_ACTIVE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_ACTIVE_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_ACTIVE_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_ACTIVE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_ACTIVE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_ACTIVE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_ACTIVE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_ACTIVE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_ACTIVE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_ACTIVE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_ACTIVE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_ACTIVE_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_ACTIVE_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_ACTIVE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_ACTIVE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_ACTIVE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_ACTIVE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_ACTIVE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_ACTIVE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_ACTIVE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_ACTIVE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE1_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE1_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE2_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE2_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_INFRA_REQ_MASK_B, val);

	/* SPM_SRC_REQ */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_APSRC_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_APSRC_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_F26M_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_F26M_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_INFRA_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_INFRA_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_VRF18_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_VRF18_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_DDR_EN_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_DDR_EN_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_DVFS_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_DVFS_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_SW_MAILBOX_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_SW_MAILBOX_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_SSPM_MAILBOX_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_SSPM_MAILBOX_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_ADSP_MAILBOX_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_ADSP_MAILBOX_REQ, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_SCP_MAILBOX_REQ])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_SCP_MAILBOX_REQ, val);

	/* SPM_SRC_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_SRCCLKENA_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_SRCCLKENA_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_SRCCLKENA2INFRA_REQ_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC2INFRA_REQ_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC2INFRA_REQ_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC_REQ_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC_REQ_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_VRF18_REQ_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_VRF18_REQ_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_DDR_EN_0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_DDR_EN_0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_SRCCLKENA_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_SRCCLKENA_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_SRCCLKENA2INFRA_REQ_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC2INFRA_REQ_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC2INFRA_REQ_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_APSRC_REQ_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_APSRC_REQ_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_VRF18_REQ_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_VRF18_REQ_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD_DDR_EN_1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD_DDR_EN_1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_SRCCLKENB_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_SRCCLKENB_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_VFE28_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_VFE28_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI0_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI0_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI0_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI0_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI1_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI1_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI1_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI1_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI2_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI2_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SRCCLKENI2_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SRCCLKENI2_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_INFRASYS_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_INFRASYS_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_INFRASYS_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_INFRASYS_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD32_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD32_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD32_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD32_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD32_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD32_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD32_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD32_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MD32_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MD32_DDR_EN_MASK_B, val);

	/* SPM_SRC2_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SCP_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SCP_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SCP_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SCP_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SCP_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SCP_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SCP_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SCP_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SCP_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SCP_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_NETSYS_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_NETSYS_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_NETSYS_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_NETSYS_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_NETSYS_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_NETSYS_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_NETSYS_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_NETSYS_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_NETSYS_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_NETSYS_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_UFS_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_UFS_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_UFS_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_UFS_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_UFS_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_UFS_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_UFS_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_UFS_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_UFS_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_UFS_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DISP0_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DISP0_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DISP0_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DISP0_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DISP1_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DISP1_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DISP1_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DISP1_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_GCE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_GCE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_GCE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_GCE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_GCE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_GCE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_GCE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_GCE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_USB_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_USB_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_USB_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_USB_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_USB_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_USB_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_USB_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_USB_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_USB_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_USB_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CG_CHECK_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CG_CHECK_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CG_CHECK_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CG_CHECK_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CG_CHECK_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CG_CHECK_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CG_CHECK_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CG_CHECK_DDR_EN_MASK_B, val);

	/* SPM_SRC3_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DVFSRC_EVENT_TRIGGER_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DVFSRC_EVENT_TRIGGER_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SW2SPM_INT0_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SW2SPM_INT0_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SW2SPM_INT1_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SW2SPM_INT1_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SW2SPM_INT2_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SW2SPM_INT2_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SW2SPM_INT3_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SW2SPM_INT3_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SC_ADSP2SPM_WAKEUP_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SC_ADSP2SPM_WAKEUP_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SC_SSPM2SPM_WAKEUP_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SC_SSPM2SPM_WAKEUP_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SC_SCP2SPM_WAKEUP_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SC_SCP2SPM_WAKEUP_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CSYSPWRREQ_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CSYSPWRREQ_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_SRCCLKENA_RESERVED_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_SRCCLKENA_RESERVED_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_INFRA_REQ_RESERVED_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_INFRA_REQ_RESERVED_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_APSRC_REQ_RESERVED_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_APSRC_REQ_RESERVED_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_VRF18_REQ_RESERVED_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_VRF18_REQ_RESERVED_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_SPM_DDR_EN_RESERVED_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_SPM_DDR_EN_RESERVED_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUPM_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUPM_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUPM_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUPM_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUPM_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUPM_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUPM_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUPM_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUPM_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUPM_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC0_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC0_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC0_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC0_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC0_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC0_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC0_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC0_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC0_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC0_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC1_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC1_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC1_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC1_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC1_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC1_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC1_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC1_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MSDC1_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MSDC1_DDR_EN_MASK_B, val);

	/* SPM_SRC4_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_CCIF_EVENT_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_CCIF_EVENT_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_AUDIO_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_AUDIO_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_AUDIO_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_AUDIO_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_AUDIO_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_AUDIO_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_AUDIO_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_AUDIO_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_AUDIO_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_AUDIO_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC0_MD32_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC0_MD32_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC0_MD32_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC0_MD32_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC1_MD32_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC1_MD32_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC1_MD32_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC1_MD32_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CONN_SRCCLKENB2PWRAP_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CONN_SRCCLKENB2PWRAP_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC0_MD32_WAKEUP_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC0_MD32_WAKEUP_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_DRAMC1_MD32_WAKEUP_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_DRAMC1_MD32_WAKEUP_MASK, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CLDMA_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CLDMA_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CLDMA_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CLDMA_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CLDMA_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CLDMA_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_CLDMA_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_CLDMA_VRF18_REQ_MASK_B, val);

	/* SPM_SRC5_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUSYS_MERGE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_MCUSYS_MERGE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_MCUSYS_MERGE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_ACTIVE_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_ACTIVE_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_ACTIVE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_ACTIVE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_ACTIVE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_ACTIVE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_ACTIVE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_ACTIVE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_ACTIVE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_ACTIVE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_SRCCLKENA_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_SRCCLKENA_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_INFRA_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_INFRA_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_VRF18_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_DDR_EN_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_DDR_EN_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_APSRC_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_APSRC_REQ_MASK_B, val);
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_PCIE3_VRF18_REQ_MASK_B])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_PCIE3_VRF18_REQ_MASK_B, val);

	/* SPM_WAKEUP_EVENT_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_WAKEUP_EVENT_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_WAKEUP_EVENT_MASK, val);

	/* SPM_WAKEUP_EVENT_EXT_MASK */
	} else if (!strcmp(cmd,
		mtk_pwr_ctrl_str[PW_REG_EXT_WAKEUP_EVENT_MASK])) {
		mtk_lpm_smc_spm_dbg(id, MT_LPM_SMC_ACT_SET,
		PW_REG_EXT_WAKEUP_EVENT_MASK, val);
	}

	return count;
}

static ssize_t suspend_ctrl_show(struct kobject *kobj,
	struct kobj_attribute *attr, char *buf)
{
	return mtk_show_pwr_ctrl(MT_SPM_DBG_SMC_UID_SUSPEND_PWR_CTRL,
			     buf, get_mtk_lp_kernfs_bufsz_max());
}
static ssize_t idle_ctrl_show(struct kobject *kobj,
	struct kobj_attribute *attr, char *buf)
{
	return mtk_show_pwr_ctrl(MT_SPM_DBG_SMC_UID_IDLE_PWR_CTRL,
			     buf, get_mtk_lp_kernfs_bufsz_max());
}
static ssize_t suspend_ctrl_store(struct kobject *kobj,
	struct kobj_attribute *attr,
				  const char *buf, size_t count)
{
	return mtk_store_pwr_ctrl(MT_SPM_DBG_SMC_UID_SUSPEND_PWR_CTRL,
				     buf, count);
}
static ssize_t idle_ctrl_store(struct kobject *kobj,
	struct kobj_attribute *attr,
				const char *buf, size_t count)
{
	return mtk_store_pwr_ctrl(MT_SPM_DBG_SMC_UID_IDLE_PWR_CTRL,
				     buf, count);
}

/**************************************
 * Init Function
 **************************************/
DEFINE_ATTR_RW(suspend_ctrl);
DEFINE_ATTR_RW(idle_ctrl);

static struct attribute *pwrctrl_attrs[] = {
	/* for spm_lp_scen.pwrctrl */
	__ATTR_OF(suspend_ctrl),
	__ATTR_OF(idle_ctrl),
	/* must */
	NULL,
};
static struct attribute_group pwrctrl_attr_group = {
	.name = "spm",
	.attrs = pwrctrl_attrs,
};

static char *mtk_spm_resource_str[MT_SPM_RES_MAX] = {
	[MT_SPM_RES_XO_FPM] = "XO_FPM",
	[MT_SPM_RES_CK_26M] = "CK_26M",
	[MT_SPM_RES_INFRA] = "INFRA",
	[MT_SPM_RES_SYSPLL] = "SYSPLL",
	[MT_SPM_RES_DRAM_S0] = "DRAM_S0",
	[MT_SPM_RES_DRAM_S1] = "DRAM_S1",
};

static ssize_t mtk_spm_res_rq_read(char *ToUserBuf, size_t sz, void *priv)
{
	char *p = ToUserBuf;
	int i, s, u;
	unsigned int unum, uvalid, uname_i, uname_t;
	unsigned int rnum, rusage, per_usage;
	char uname[MT_LP_RQ_USER_NAME_LEN+1];

	mtk_dbg_spm_log("resource_num=%d, user_num=%d, user_valid=0x%x\n",
	    rnum = mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_NUM,
				       MT_LPM_SMC_ACT_GET, 0, 0),
	    unum = mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USER_NUM,
				       MT_LPM_SMC_ACT_GET, 0, 0),
	    uvalid = mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USER_VALID,
					 MT_LPM_SMC_ACT_GET, 0, 0));
	rusage = mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USAGE,
				     MT_LPM_SMC_ACT_GET,
				     MT_LP_RQ_ID_ALL_USAGE, 0);
	mtk_dbg_spm_log("\n");
	mtk_dbg_spm_log("user [bit][valid]:\n");
	for (i = 0; i < unum; i++) {
		uname_i = mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USER_NAME,
					    MT_LPM_SMC_ACT_GET, i, 0);
		for (s = 0, u = 0; s < MT_LP_RQ_USER_NAME_LEN;
		     s++, u += MT_LP_RQ_USER_CHAR_U) {
			uname_t = ((uname_i >> u) & MT_LP_RQ_USER_CHAR_MASK);
			uname[s] = (uname_t) ? (char)uname_t : ' ';
		}
		uname[s] = '\0';
		mtk_dbg_spm_log("%4s [%3d][%3s]\n", uname, i,
		    ((1<<i) & uvalid) ? "yes" : "no");
	}
	mtk_dbg_spm_log("\n");

	if (rnum != MT_SPM_RES_MAX) {
		mtk_dbg_spm_log("Platform resource amount mismatch\n");
		rnum = (rnum > MT_SPM_RES_MAX) ? MT_SPM_RES_MAX : rnum;
	}

	mtk_dbg_spm_log("resource [bit][user_usage][blocking]:\n");
	for (i = 0; i < rnum; i++) {
		mtk_dbg_spm_log("%8s [%3d][0x%08x][%3s]\n",
			mtk_spm_resource_str[i], i,
			(per_usage =
			mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USAGE,
					    MT_LPM_SMC_ACT_GET, i, 0)),
			((1<<i) & rusage) ? "yes" : "no"
		   );
	}
	mtk_dbg_spm_log("\n");
	mtk_dbg_spm_log("resource request command help:\n");
	mtk_dbg_spm_log("echo enable ${user_bit} > %s\n", MT_LP_RQ_NODE);
	mtk_dbg_spm_log("echo bypass ${user_bit} > %s\n", MT_LP_RQ_NODE);
	mtk_dbg_spm_log("echo request ${resource_bit} > %s\n", MT_LP_RQ_NODE);
	mtk_dbg_spm_log("echo release > %s\n", MT_LP_RQ_NODE);

	return p - ToUserBuf;
}

static ssize_t mtk_spm_res_rq_write(char *FromUserBuf, size_t sz, void *priv)
{
	char cmd[128];
	int parm;

	if (sscanf(FromUserBuf, "%127s %x", cmd, &parm) == 2) {
		if (!strcmp(cmd, "bypass"))
			mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USER_VALID,
					    MT_LPM_SMC_ACT_SET,
					    parm, 0);
		else if (!strcmp(cmd, "enable"))
			mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_USER_VALID,
					    MT_LPM_SMC_ACT_SET,
					    parm, 1);
		else if (!strcmp(cmd, "request"))
			mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_REQ,
					    MT_LPM_SMC_ACT_SET,
					    0, parm);
		return sz;
	} else if (sscanf(FromUserBuf, "%127s", cmd) == 1) {
		if (!strcmp(cmd, "release"))
			mtk_lpm_smc_spm_dbg(MT_SPM_DBG_SMC_UID_RES_REQ,
					    MT_LPM_SMC_ACT_CLR,
					    0, 0);
		return sz;
	} else if ((!kstrtoint(FromUserBuf, 10, &parm)) == 1) {
		return sz;
	}

	return -EINVAL;
}

#define plat_mmio_read(offset)	__raw_readl(mtk_spm_wdt_latch_base + offset)

static ssize_t mtk_spm_wdt_latch_read(char *ToUserBuf, size_t sz, void *priv)
{
	char *p = ToUserBuf;
	unsigned int i;

	for (i = PCM_WDT_LATCH_0; i <= DRAMC_GATING_ERR_LATCH_SPARE_0; i += 4)
		mtk_dbg_spm_log("SPM(0x%x) = 0x%x\n", i, plat_mmio_read(i));

	return p - ToUserBuf;
}

static const struct mtk_lp_sysfs_op mtk_spm_res_rq_fops = {
	.fs_read = mtk_spm_res_rq_read,
	.fs_write = mtk_spm_res_rq_write,
};

static const struct mtk_lp_sysfs_op mtk_spm_wdt_latch_fops = {
	.fs_read = mtk_spm_wdt_latch_read,
	.fs_write = NULL,
};

int mtk_dbg_spm_fs_init(void)
{
	int r;
	struct device_node *node = NULL;

	mtk_spm_sysfs_root_entry_create();
	mtk_spm_sysfs_entry_node_add("spm_resource_req", 0444
			, &mtk_spm_res_rq_fops, NULL);

	/* create /sys/power/spm/xxx */
	r = mtk_spm_sysfs_power_create_group(&pwrctrl_attr_group);
	if (r)
		pr_info("[SPM] FAILED TO CREATE /sys/power/spm (%d)\n", r);

	node = of_find_compatible_node(NULL, NULL, "mediatek,sleep");

	if (node) {
		mtk_spm_wdt_latch_base = of_iomap(node, 0);
		of_node_put(node);
	}

	if (mtk_spm_wdt_latch_base)
		mtk_spm_sysfs_entry_node_add("spm_wdt_latch", 0444
			, &mtk_spm_wdt_latch_fops, NULL);

	return r;
}

int mtk_dbg_spm_fs_deinit(void)
{
	return 0;
}

