/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 */

#ifndef __MFD_MT6358_REGISTERS_H__
#define __MFD_MT6358_REGISTERS_H__

/* PMIC Registers */
#define MT6358_TOP0_ID                        0x0
#define MT6358_TOP0_REV0                      0x2
#define MT6358_TOP0_DSN_DBI                   0x4
#define MT6358_TOP0_DSN_DXI                   0x6
#define MT6358_HWCID                          0x8
#define MT6358_SWCID                          0xa
#define MT6358_PONSTS                         0xc
#define MT6358_POFFSTS                        0xe
#define MT6358_PSTSCTL                        0x10
#define MT6358_PG_DEB_STS0                    0x12
#define MT6358_PG_DEB_STS1                    0x14
#define MT6358_PG_SDN_STS0                    0x16
#define MT6358_PG_SDN_STS1                    0x18
#define MT6358_OC_SDN_STS0                    0x1a
#define MT6358_THERMALSTATUS                  0x1c
#define MT6358_TOP_CON                        0x1e
#define MT6358_TEST_OUT                       0x20
#define MT6358_TEST_CON0                      0x22
#define MT6358_TEST_CON1                      0x24
#define MT6358_TESTMODE_SW                    0x26
#define MT6358_TOPSTATUS                      0x28
#define MT6358_TDSEL_CON                      0x2a
#define MT6358_RDSEL_CON                      0x2c
#define MT6358_SMT_CON0                       0x2e
#define MT6358_SMT_CON1                       0x30
#define MT6358_TOP_RSV0                       0x32
#define MT6358_TOP_RSV1                       0x34
#define MT6358_DRV_CON0                       0x36
#define MT6358_DRV_CON1                       0x38
#define MT6358_DRV_CON2                       0x3a
#define MT6358_DRV_CON3                       0x3c
#define MT6358_DRV_CON4                       0x3e
#define MT6358_FILTER_CON0                    0x40
#define MT6358_FILTER_CON1                    0x42
#define MT6358_FILTER_CON2                    0x44
#define MT6358_FILTER_CON3                    0x46
#define MT6358_TOP_STATUS                     0x48
#define MT6358_TOP_STATUS_SET                 0x4a
#define MT6358_TOP_STATUS_CLR                 0x4c
#define MT6358_TOP_TRAP                       0x4e
#define MT6358_TOP1_ID                        0x80
#define MT6358_TOP1_REV0                      0x82
#define MT6358_TOP1_DSN_DBI                   0x84
#define MT6358_TOP1_DSN_DXI                   0x86
#define MT6358_GPIO_DIR0                      0x88
#define MT6358_GPIO_DIR0_SET                  0x8a
#define MT6358_GPIO_DIR0_CLR                  0x8c
#define MT6358_GPIO_DIR1                      0x8e
#define MT6358_GPIO_DIR1_SET                  0x90
#define MT6358_GPIO_DIR1_CLR                  0x92
#define MT6358_GPIO_PULLEN0                   0x94
#define MT6358_GPIO_PULLEN0_SET               0x96
#define MT6358_GPIO_PULLEN0_CLR               0x98
#define MT6358_GPIO_PULLEN1                   0x9a
#define MT6358_GPIO_PULLEN1_SET               0x9c
#define MT6358_GPIO_PULLEN1_CLR               0x9e
#define MT6358_GPIO_PULLSEL0                  0xa0
#define MT6358_GPIO_PULLSEL0_SET              0xa2
#define MT6358_GPIO_PULLSEL0_CLR              0xa4
#define MT6358_GPIO_PULLSEL1                  0xa6
#define MT6358_GPIO_PULLSEL1_SET              0xa8
#define MT6358_GPIO_PULLSEL1_CLR              0xaa
#define MT6358_GPIO_DINV0                     0xac
#define MT6358_GPIO_DINV0_SET                 0xae
#define MT6358_GPIO_DINV0_CLR                 0xb0
#define MT6358_GPIO_DINV1                     0xb2
#define MT6358_GPIO_DINV1_SET                 0xb4
#define MT6358_GPIO_DINV1_CLR                 0xb6
#define MT6358_GPIO_DOUT0                     0xb8
#define MT6358_GPIO_DOUT0_SET                 0xba
#define MT6358_GPIO_DOUT0_CLR                 0xbc
#define MT6358_GPIO_DOUT1                     0xbe
#define MT6358_GPIO_DOUT1_SET                 0xc0
#define MT6358_GPIO_DOUT1_CLR                 0xc2
#define MT6358_GPIO_PI0                       0xc4
#define MT6358_GPIO_PI1                       0xc6
#define MT6358_GPIO_POE0                      0xc8
#define MT6358_GPIO_POE1                      0xca
#define MT6358_GPIO_MODE0                     0xcc
#define MT6358_GPIO_MODE0_SET                 0xce
#define MT6358_GPIO_MODE0_CLR                 0xd0
#define MT6358_GPIO_MODE1                     0xd2
#define MT6358_GPIO_MODE1_SET                 0xd4
#define MT6358_GPIO_MODE1_CLR                 0xd6
#define MT6358_GPIO_MODE2                     0xd8
#define MT6358_GPIO_MODE2_SET                 0xda
#define MT6358_GPIO_MODE2_CLR                 0xdc
#define MT6358_GPIO_MODE3                     0xde
#define MT6358_GPIO_MODE3_SET                 0xe0
#define MT6358_GPIO_MODE3_CLR                 0xe2
#define MT6358_GPIO_MODE4                     0xe4
#define MT6358_GPIO_MODE4_SET                 0xe6
#define MT6358_GPIO_MODE4_CLR                 0xe8
#define MT6358_GPIO_RSV                       0xea
#define MT6358_TOP2_ID                        0x100
#define MT6358_TOP2_REV0                      0x102
#define MT6358_TOP2_DSN_DBI                   0x104
#define MT6358_TOP2_DSN_DXI                   0x106
#define MT6358_TOP_PAM0                       0x108
#define MT6358_TOP_PAM1                       0x10a
#define MT6358_TOP_CKPDN_CON0                 0x10c
#define MT6358_TOP_CKPDN_CON0_SET             0x10e
#define MT6358_TOP_CKPDN_CON0_CLR             0x110
#define MT6358_TOP_CKPDN_CON1                 0x112
#define MT6358_TOP_CKPDN_CON1_SET             0x114
#define MT6358_TOP_CKPDN_CON1_CLR             0x116
#define MT6358_TOP_CKSEL_CON0                 0x118
#define MT6358_TOP_CKSEL_CON0_SET             0x11a
#define MT6358_TOP_CKSEL_CON0_CLR             0x11c
#define MT6358_TOP_CKSEL_CON1                 0x11e
#define MT6358_TOP_CKSEL_CON1_SET             0x120
#define MT6358_TOP_CKSEL_CON1_CLR             0x122
#define MT6358_TOP_CKDIVSEL_CON0              0x124
#define MT6358_TOP_CKDIVSEL_CON0_SET          0x126
#define MT6358_TOP_CKDIVSEL_CON0_CLR          0x128
#define MT6358_TOP_CKHWEN_CON0                0x12a
#define MT6358_TOP_CKHWEN_CON0_SET            0x12c
#define MT6358_TOP_CKHWEN_CON0_CLR            0x12e
#define MT6358_TOP_CKTST_CON0                 0x130
#define MT6358_TOP_CKTST_CON1                 0x132
#define MT6358_TOP_CLK_CON0                   0x134
#define MT6358_TOP_CLK_CON0_SET               0x136
#define MT6358_TOP_CLK_CON0_CLR               0x138
#define MT6358_TOP_DCM_CON0                   0x13a
#define MT6358_TOP_HANDOVER_DEBUG0            0x13c
#define MT6358_TOP_RST_CON0                   0x13e
#define MT6358_TOP_RST_CON0_SET               0x140
#define MT6358_TOP_RST_CON0_CLR               0x142
#define MT6358_TOP_RST_CON1                   0x144
#define MT6358_TOP_RST_CON1_SET               0x146
#define MT6358_TOP_RST_CON1_CLR               0x148
#define MT6358_TOP_RST_CON2                   0x14a
#define MT6358_TOP_RST_MISC                   0x14c
#define MT6358_TOP_RST_MISC_SET               0x14e
#define MT6358_TOP_RST_MISC_CLR               0x150
#define MT6358_TOP_RST_STATUS                 0x152
#define MT6358_TOP_RST_STATUS_SET             0x154
#define MT6358_TOP_RST_STATUS_CLR             0x156
#define MT6358_TOP2_ELR_NUM                   0x158
#define MT6358_TOP2_ELR0                      0x15a
#define MT6358_TOP2_ELR1                      0x15c
#define MT6358_TOP3_ID                        0x180
#define MT6358_TOP3_REV0                      0x182
#define MT6358_TOP3_DSN_DBI                   0x184
#define MT6358_TOP3_DSN_DXI                   0x186
#define MT6358_MISC_TOP_INT_CON0              0x188
#define MT6358_MISC_TOP_INT_CON0_SET          0x18a
#define MT6358_MISC_TOP_INT_CON0_CLR          0x18c
#define MT6358_MISC_TOP_INT_MASK_CON0         0x18e
#define MT6358_MISC_TOP_INT_MASK_CON0_SET     0x190
#define MT6358_MISC_TOP_INT_MASK_CON0_CLR     0x192
#define MT6358_MISC_TOP_INT_STATUS0           0x194
#define MT6358_MISC_TOP_INT_RAW_STATUS0       0x196
#define MT6358_TOP_INT_MASK_CON0              0x198
#define MT6358_TOP_INT_MASK_CON0_SET          0x19a
#define MT6358_TOP_INT_MASK_CON0_CLR          0x19c
#define MT6358_TOP_INT_STATUS0                0x19e
#define MT6358_TOP_INT_RAW_STATUS0            0x1a0
#define MT6358_TOP_INT_CON0                   0x1a2
#define MT6358_PLT0_ID                        0x380
#define MT6358_PLT0_REV0                      0x382
#define MT6358_PLT0_REV1                      0x384
#define MT6358_PLT0_DSN_DXI                   0x386
#define MT6358_TOP_CLK_TRIM                   0x388
#define MT6358_OTP_CON0                       0x38a
#define MT6358_OTP_CON1                       0x38c
#define MT6358_OTP_CON2                       0x38e
#define MT6358_OTP_CON3                       0x390
#define MT6358_OTP_CON4                       0x392
#define MT6358_OTP_CON5                       0x394
#define MT6358_OTP_CON6                       0x396
#define MT6358_OTP_CON7                       0x398
#define MT6358_OTP_CON8                       0x39a
#define MT6358_OTP_CON9                       0x39c
#define MT6358_OTP_CON10                      0x39e
#define MT6358_OTP_CON11                      0x3a0
#define MT6358_OTP_CON12                      0x3a2
#define MT6358_OTP_CON13                      0x3a4
#define MT6358_OTP_CON14                      0x3a6
#define MT6358_TOP_TMA_KEY                    0x3a8
#define MT6358_TOP_MDB_CONF0                  0x3aa
#define MT6358_TOP_MDB_CONF1                  0x3ac
#define MT6358_TOP_MDB_CONF2                  0x3ae
#define MT6358_PLT0_ELR_NUM                   0x3b0
#define MT6358_PLT0_ELR0                      0x3b2
#define MT6358_PLT0_ELR1                      0x3b4
#define MT6358_SPISLV_ID                      0x400
#define MT6358_SPISLV_REV0                    0x402
#define MT6358_SPISLV_REV1                    0x404
#define MT6358_SPISLV_DSN_DXI                 0x406
#define MT6358_RG_SPI_CON0                    0x408
#define MT6358_RG_SPI_RECORD0                 0x40a
#define MT6358_DEW_DIO_EN                     0x40c
#define MT6358_DEW_READ_TEST                  0x40e
#define MT6358_DEW_WRITE_TEST                 0x410
#define MT6358_DEW_CRC_SWRST                  0x412
#define MT6358_DEW_CRC_EN                     0x414
#define MT6358_DEW_CRC_VAL                    0x416
#define MT6358_DEW_DBG_MON_SEL                0x418
#define MT6358_DEW_CIPHER_KEY_SEL             0x41a
#define MT6358_DEW_CIPHER_IV_SEL              0x41c
#define MT6358_DEW_CIPHER_EN                  0x41e
#define MT6358_DEW_CIPHER_RDY                 0x420
#define MT6358_DEW_CIPHER_MODE                0x422
#define MT6358_DEW_CIPHER_SWRST               0x424
#define MT6358_DEW_RDDMY_NO                   0x426
#define MT6358_INT_TYPE_CON0                  0x428
#define MT6358_INT_TYPE_CON0_SET              0x42a
#define MT6358_INT_TYPE_CON0_CLR              0x42c
#define MT6358_INT_STA                        0x42e
#define MT6358_RG_SPI_CON1                    0x430
#define MT6358_RG_SPI_CON2                    0x432
#define MT6358_RG_SPI_CON3                    0x434
#define MT6358_RG_SPI_CON4                    0x436
#define MT6358_RG_SPI_CON5                    0x438
#define MT6358_RG_SPI_CON6                    0x43a
#define MT6358_RG_SPI_CON7                    0x43c
#define MT6358_RG_SPI_CON8                    0x43e
#define MT6358_RG_SPI_CON9                    0x440
#define MT6358_RG_SPI_CON10                   0x442
#define MT6358_RG_SPI_CON11                   0x444
#define MT6358_RG_SPI_CON12                   0x446
#define MT6358_RG_SPI_CON13                   0x448
#define MT6358_SPISLV_KEY                     0x44a
#define MT6358_TOP_SPI_CON0                   0x44c
#define MT6358_TOP_SPI_CON1                   0x44e
#define MT6358_SCK_TOP_DSN_ID                 0x500
#define MT6358_SCK_TOP_DSN_REV0               0x502
#define MT6358_SCK_TOP_DBI                    0x504
#define MT6358_SCK_TOP_DXI                    0x506
#define MT6358_SCK_TOP_TPM0                   0x508
#define MT6358_SCK_TOP_TPM1                   0x50a
#define MT6358_SCK_TOP_CON0                   0x50c
#define MT6358_SCK_TOP_CON1                   0x50e
#define MT6358_SCK_TOP_TEST_OUT               0x510
#define MT6358_SCK_TOP_TEST_CON0              0x512
#define MT6358_FQMTR_CON0                     0x514
#define MT6358_FQMTR_CON1                     0x516
#define MT6358_FQMTR_CON2                     0x518
#define MT6358_SCK_TOP_CKPDN_CON0             0x51a
#define MT6358_SCK_TOP_CKPDN_CON0_SET         0x51c
#define MT6358_SCK_TOP_CKPDN_CON0_CLR         0x51e
#define MT6358_SCK_TOP_CKHWEN_CON0            0x520
#define MT6358_SCK_TOP_CKHWEN_CON0_SET        0x522
#define MT6358_SCK_TOP_CKHWEN_CON0_CLR        0x524
#define MT6358_SCK_TOP_CKTST_CON              0x526
#define MT6358_SCK_TOP_RST_CON0               0x528
#define MT6358_SCK_TOP_RST_CON0_SET           0x52a
#define MT6358_SCK_TOP_RST_CON0_CLR           0x52c
#define MT6358_SCK_TOP_INT_CON0               0x52e
#define MT6358_SCK_TOP_INT_CON0_SET           0x530
#define MT6358_SCK_TOP_INT_CON0_CLR           0x532
#define MT6358_SCK_TOP_INT_MASK_CON0          0x534
#define MT6358_SCK_TOP_INT_MASK_CON0_SET      0x536
#define MT6358_SCK_TOP_INT_MASK_CON0_CLR      0x538
#define MT6358_SCK_TOP_INT_STATUS0            0x53a
#define MT6358_SCK_TOP_INT_RAW_STATUS0        0x53c
#define MT6358_SCK_TOP_INT_MISC_CON           0x53e
#define MT6358_EOSC_CALI_CON0                 0x540
#define MT6358_EOSC_CALI_CON1                 0x542
#define MT6358_RTC_MIX_CON0                   0x544
#define MT6358_RTC_MIX_CON1                   0x546
#define MT6358_RTC_MIX_CON2                   0x548
#define MT6358_RTC_DSN_ID                     0x580
#define MT6358_RTC_DSN_REV0                   0x582
#define MT6358_RTC_DBI                        0x584
#define MT6358_RTC_DXI                        0x586
#define MT6358_RTC_BBPU                       0x588
#define MT6358_RTC_IRQ_STA                    0x58a
#define MT6358_RTC_IRQ_EN                     0x58c
#define MT6358_RTC_CII_EN                     0x58e
#define MT6358_RTC_AL_MASK                    0x590
#define MT6358_RTC_TC_SEC                     0x592
#define MT6358_RTC_TC_MIN                     0x594
#define MT6358_RTC_TC_HOU                     0x596
#define MT6358_RTC_TC_DOM                     0x598
#define MT6358_RTC_TC_DOW                     0x59a
#define MT6358_RTC_TC_MTH                     0x59c
#define MT6358_RTC_TC_YEA                     0x59e
#define MT6358_RTC_AL_SEC                     0x5a0
#define MT6358_RTC_AL_MIN                     0x5a2
#define MT6358_RTC_AL_HOU                     0x5a4
#define MT6358_RTC_AL_DOM                     0x5a6
#define MT6358_RTC_AL_DOW                     0x5a8
#define MT6358_RTC_AL_MTH                     0x5aa
#define MT6358_RTC_AL_YEA                     0x5ac
#define MT6358_RTC_OSC32CON                   0x5ae
#define MT6358_RTC_POWERKEY1                  0x5b0
#define MT6358_RTC_POWERKEY2                  0x5b2
#define MT6358_RTC_PDN1                       0x5b4
#define MT6358_RTC_PDN2                       0x5b6
#define MT6358_RTC_SPAR0                      0x5b8
#define MT6358_RTC_SPAR1                      0x5ba
#define MT6358_RTC_PROT                       0x5bc
#define MT6358_RTC_DIFF                       0x5be
#define MT6358_RTC_CALI                       0x5c0
#define MT6358_RTC_WRTGR                      0x5c2
#define MT6358_RTC_CON                        0x5c4
#define MT6358_RTC_SEC_CTRL                   0x5c6
#define MT6358_RTC_INT_CNT                    0x5c8
#define MT6358_RTC_SEC_DAT0                   0x5ca
#define MT6358_RTC_SEC_DAT1                   0x5cc
#define MT6358_RTC_SEC_DAT2                   0x5ce
#define MT6358_RTC_SEC_DSN_ID                 0x600
#define MT6358_RTC_SEC_DSN_REV0               0x602
#define MT6358_RTC_SEC_DBI                    0x604
#define MT6358_RTC_SEC_DXI                    0x606
#define MT6358_RTC_TC_SEC_SEC                 0x608
#define MT6358_RTC_TC_MIN_SEC                 0x60a
#define MT6358_RTC_TC_HOU_SEC                 0x60c
#define MT6358_RTC_TC_DOM_SEC                 0x60e
#define MT6358_RTC_TC_DOW_SEC                 0x610
#define MT6358_RTC_TC_MTH_SEC                 0x612
#define MT6358_RTC_TC_YEA_SEC                 0x614
#define MT6358_RTC_SEC_CK_PDN                 0x616
#define MT6358_RTC_SEC_WRTGR                  0x618
#define MT6358_DCXO_DSN_ID                    0x780
#define MT6358_DCXO_DSN_REV0                  0x782
#define MT6358_DCXO_DSN_DBI                   0x784
#define MT6358_DCXO_DSN_DXI                   0x786
#define MT6358_DCXO_CW00                      0x788
#define MT6358_DCXO_CW00_SET                  0x78a
#define MT6358_DCXO_CW00_CLR                  0x78c
#define MT6358_DCXO_CW01                      0x78e
#define MT6358_DCXO_CW02                      0x790
#define MT6358_DCXO_CW03                      0x792
#define MT6358_DCXO_CW04                      0x794
#define MT6358_DCXO_CW05                      0x796
#define MT6358_DCXO_CW06                      0x798
#define MT6358_DCXO_CW07                      0x79a
#define MT6358_DCXO_CW08                      0x79c
#define MT6358_DCXO_CW09                      0x79e
#define MT6358_DCXO_CW10                      0x7a0
#define MT6358_DCXO_CW11                      0x7a2
#define MT6358_DCXO_CW11_SET                  0x7a4
#define MT6358_DCXO_CW11_CLR                  0x7a6
#define MT6358_DCXO_CW12                      0x7a8
#define MT6358_DCXO_CW13                      0x7aa
#define MT6358_DCXO_CW14                      0x7ac
#define MT6358_DCXO_CW15                      0x7ae
#define MT6358_DCXO_CW16                      0x7b0
#define MT6358_DCXO_CW17                      0x7b2
#define MT6358_DCXO_CW18                      0x7b4
#define MT6358_DCXO_CW19                      0x7b6
#define MT6358_DCXO_CW20                      0x7b8
#define MT6358_DCXO_CW21                      0x7ba
#define MT6358_DCXO_CW22                      0x7bc
#define MT6358_DCXO_CW23                      0x7be
#define MT6358_DCXO_CW24                      0x7c0
#define MT6358_DCXO_ELR_NUM                   0x7c2
#define MT6358_DCXO_ELR0                      0x7c4
#define MT6358_PSC_TOP_ID                     0x900
#define MT6358_PSC_TOP_REV0                   0x902
#define MT6358_PSC_TOP_DBI                    0x904
#define MT6358_PSC_TOP_DXI                    0x906
#define MT6358_PSC_TPM0                       0x908
#define MT6358_PSC_TPM1                       0x90a
#define MT6358_PSC_TOP_CLKCTL_0               0x90c
#define MT6358_PSC_TOP_RSTCTL_0               0x90e
#define MT6358_PSC_TOP_INT_CON0               0x910
#define MT6358_PSC_TOP_INT_CON0_SET           0x912
#define MT6358_PSC_TOP_INT_CON0_CLR           0x914
#define MT6358_PSC_TOP_INT_MASK_CON0          0x916
#define MT6358_PSC_TOP_INT_MASK_CON0_SET      0x918
#define MT6358_PSC_TOP_INT_MASK_CON0_CLR      0x91a
#define MT6358_PSC_TOP_INT_STATUS0            0x91c
#define MT6358_PSC_TOP_INT_RAW_STATUS0        0x91e
#define MT6358_PSC_TOP_INT_MISC_CON           0x920
#define MT6358_PSC_TOP_INT_MISC_CON_SET       0x922
#define MT6358_PSC_TOP_INT_MISC_CON_CLR       0x924
#define MT6358_PSC_TOP_MON_CTL                0x926
#define MT6358_STRUP_ID                       0x980
#define MT6358_STRUP_REV0                     0x982
#define MT6358_STRUP_DBI                      0x984
#define MT6358_STRUP_DSN_FPI                  0x986
#define MT6358_STRUP_ANA_CON0                 0x988
#define MT6358_STRUP_ANA_CON1                 0x98a
#define MT6358_STRUP_ELR_NUM                  0x98c
#define MT6358_STRUP_ELR_0                    0x98e
#define MT6358_STRUP_ELR_1                    0x990
#define MT6358_PSEQ_ID                        0xa00
#define MT6358_PSEQ_REV0                      0xa02
#define MT6358_PSEQ_DBI                       0xa04
#define MT6358_PSEQ_DXI                       0xa06
#define MT6358_PPCCTL0                        0xa08
#define MT6358_PPCCTL1                        0xa0a
#define MT6358_PPCCTL2                        0xa0c
#define MT6358_PPCCFG0                        0xa0e
#define MT6358_PPCTST0                        0xa10
#define MT6358_PORFLAG                        0xa12
#define MT6358_STRUP_CON0                     0xa14
#define MT6358_STRUP_CON1                     0xa16
#define MT6358_STRUP_CON2                     0xa18
#define MT6358_STRUP_CON3                     0xa1a
#define MT6358_STRUP_CON4                     0xa1c
#define MT6358_STRUP_CON5                     0xa1e
#define MT6358_STRUP_CON6                     0xa20
#define MT6358_STRUP_CON7                     0xa22
#define MT6358_CPSCFG0                        0xa24
#define MT6358_CPSDSA0                        0xa26
#define MT6358_CPSDSA1                        0xa28
#define MT6358_CPSDSA2                        0xa2a
#define MT6358_CPSDSA3                        0xa2c
#define MT6358_CPSDSA4                        0xa2e
#define MT6358_CPSDSA5                        0xa30
#define MT6358_CPSDSA6                        0xa32
#define MT6358_CPSDSA7                        0xa34
#define MT6358_STRUP_CON9                     0xa36
#define MT6358_STRUP_CON10                    0xa38
#define MT6358_STRUP_CON11                    0xa3a
#define MT6358_STRUP_CON12                    0xa3c
#define MT6358_STRUP_CON13                    0xa3e
#define MT6358_PWRKEY_PRESS_STS               0xa40
#define MT6358_STRUP_CON19                    0xa42
#define MT6358_STRUP_CON14                    0xa44
#define MT6358_STRUP_CON15                    0xa46
#define MT6358_STRUP_CON16                    0xa48
#define MT6358_STRUP_CON17                    0xa4a
#define MT6358_STRUP_CON18                    0xa4c
#define MT6358_PSEQ_ELR_NUM                   0xa4e
#define MT6358_PSEQ_ELR0                      0xa50
#define MT6358_PSEQ_ELR1                      0xa52
#define MT6358_PSEQ_ELR2                      0xa54
#define MT6358_PSEQ_ELR3                      0xa56
#define MT6358_PSEQ_ELR4                      0xa58
#define MT6358_PSEQ_ELR5                      0xa5a
#define MT6358_PSEQ_ELR6                      0xa5c
#define MT6358_PSEQ_ELR7                      0xa5e
#define MT6358_PSEQ_ELR10                     0xa60
#define MT6358_PSEQ_ELR11                     0xa62
#define MT6358_CHRDET_ID                      0xa80
#define MT6358_CHRDET_REV0                    0xa82
#define MT6358_CHRDET_DBI                     0xa84
#define MT6358_CHRDET_DXI                     0xa86
#define MT6358_CHR_CON0                       0xa88
#define MT6358_CHR_CON1                       0xa8a
#define MT6358_CHR_CON2                       0xa8c
#define MT6358_CHR_CON3                       0xa8e
#define MT6358_CHR_CON4                       0xa90
#define MT6358_PCHR_VREF_ANA_DA0              0xa92
#define MT6358_PCHR_VREF_ANA_CON0             0xa94
#define MT6358_PCHR_VREF_ANA_CON1             0xa96
#define MT6358_PCHR_VREF_ANA_CON2             0xa98
#define MT6358_PCHR_VREF_ANA_CON3             0xa9a
#define MT6358_PCHR_VREF_ELR_NUM              0xa9c
#define MT6358_PCHR_VREF_ELR_0                0xa9e
#define MT6358_PCHR_VREF_ELR_1                0xaa0
#define MT6358_BM_TOP_DSN_ID                  0xc00
#define MT6358_BM_TOP_DSN_REV0                0xc02
#define MT6358_BM_TOP_DBI                     0xc04
#define MT6358_BM_TOP_DXI                     0xc06
#define MT6358_BM_TPM0                        0xc08
#define MT6358_BM_TPM1                        0xc0a
#define MT6358_BM_TOP_CKPDN_CON0              0xc0c
#define MT6358_BM_TOP_CKPDN_CON0_SET          0xc0e
#define MT6358_BM_TOP_CKPDN_CON0_CLR          0xc10
#define MT6358_BM_TOP_CKSEL_CON0              0xc12
#define MT6358_BM_TOP_CKSEL_CON0_SET          0xc14
#define MT6358_BM_TOP_CKSEL_CON0_CLR          0xc16
#define MT6358_BM_TOP_CKDIVSEL_CON0           0xc18
#define MT6358_BM_TOP_CKDIVSEL_CON0_SET       0xc1a
#define MT6358_BM_TOP_CKDIVSEL_CON0_CLR       0xc1c
#define MT6358_BM_TOP_CKHWEN_CON0             0xc1e
#define MT6358_BM_TOP_CKHWEN_CON0_SET         0xc20
#define MT6358_BM_TOP_CKHWEN_CON0_CLR         0xc22
#define MT6358_BM_TOP_CKTST_CON0              0xc24
#define MT6358_BM_TOP_RST_CON0                0xc26
#define MT6358_BM_TOP_RST_CON0_SET            0xc28
#define MT6358_BM_TOP_RST_CON0_CLR            0xc2a
#define MT6358_BM_TOP_RST_CON1                0xc2c
#define MT6358_BM_TOP_RST_CON1_SET            0xc2e
#define MT6358_BM_TOP_RST_CON1_CLR            0xc30
#define MT6358_BM_TOP_INT_CON0                0xc32
#define MT6358_BM_TOP_INT_CON0_SET            0xc34
#define MT6358_BM_TOP_INT_CON0_CLR            0xc36
#define MT6358_BM_TOP_INT_CON1                0xc38
#define MT6358_BM_TOP_INT_CON1_SET            0xc3a
#define MT6358_BM_TOP_INT_CON1_CLR            0xc3c
#define MT6358_BM_TOP_INT_MASK_CON0           0xc3e
#define MT6358_BM_TOP_INT_MASK_CON0_SET       0xc40
#define MT6358_BM_TOP_INT_MASK_CON0_CLR       0xc42
#define MT6358_BM_TOP_INT_MASK_CON1           0xc44
#define MT6358_BM_TOP_INT_MASK_CON1_SET       0xc46
#define MT6358_BM_TOP_INT_MASK_CON1_CLR       0xc48
#define MT6358_BM_TOP_INT_STATUS0             0xc4a
#define MT6358_BM_TOP_INT_STATUS1             0xc4c
#define MT6358_BM_TOP_INT_RAW_STATUS0         0xc4e
#define MT6358_BM_TOP_INT_RAW_STATUS1         0xc50
#define MT6358_BM_TOP_INT_MISC_CON            0xc52
#define MT6358_BM_TOP_DBG_CON                 0xc54
#define MT6358_BM_TOP_RSV0                    0xc56
#define MT6358_FGADC_ANA_DSN_ID               0xc80
#define MT6358_FGADC_ANA_DSN_REV0             0xc82
#define MT6358_FGADC_ANA_DSN_DBI              0xc84
#define MT6358_FGADC_ANA_DSN_DXI              0xc86
#define MT6358_FGADC_ANA_CON0                 0xc88
#define MT6358_FGADC_ANA_TEST_CON0            0xc8a
#define MT6358_FGADC_ANA_ELR_NUM              0xc8c
#define MT6358_FGADC_ANA_ELR0                 0xc8e
#define MT6358_FGADC_ANA_ELR1                 0xc90
#define MT6358_FGADC0_DSN_ID                  0xd00
#define MT6358_FGADC0_DSN_REV0                0xd02
#define MT6358_FGADC0_DSN_DBI                 0xd04
#define MT6358_FGADC0_DSN_DXI                 0xd06
#define MT6358_FGADC_CON0                     0xd08
#define MT6358_FGADC_CON1                     0xd0a
#define MT6358_FGADC_CON2                     0xd0c
#define MT6358_FGADC_CON3                     0xd0e
#define MT6358_FGADC_CON4                     0xd10
#define MT6358_FGADC_RST_CON0                 0xd12
#define MT6358_FGADC_CAR_CON0                 0xd14
#define MT6358_FGADC_CAR_CON1                 0xd16
#define MT6358_FGADC_CARTH_CON0               0xd18
#define MT6358_FGADC_CARTH_CON1               0xd1a
#define MT6358_FGADC_CARTH_CON2               0xd1c
#define MT6358_FGADC_CARTH_CON3               0xd1e
#define MT6358_FGADC_CARTH_CON4               0xd20
#define MT6358_FGADC_CARTH_CON5               0xd22
#define MT6358_FGADC_CARTH_CON6               0xd24
#define MT6358_FGADC_CARTH_CON7               0xd26
#define MT6358_FGADC_NCAR_CON0                0xd28
#define MT6358_FGADC_NCAR_CON1                0xd2a
#define MT6358_FGADC_NCAR_CON2                0xd2c
#define MT6358_FGADC_NCAR_CON3                0xd2e
#define MT6358_FGADC_IAVG_CON0                0xd30
#define MT6358_FGADC_IAVG_CON1                0xd32
#define MT6358_FGADC_IAVG_CON2                0xd34
#define MT6358_FGADC_IAVG_CON3                0xd36
#define MT6358_FGADC_IAVG_CON4                0xd38
#define MT6358_FGADC_IAVG_CON5                0xd3a
#define MT6358_FGADC_NTER_CON0                0xd3c
#define MT6358_FGADC_NTER_CON1                0xd3e
#define MT6358_FGADC_NTERTH_CON0              0xd40
#define MT6358_FGADC_NTERTH_CON1              0xd42
#define MT6358_FGADC_SON_CON0                 0xd44
#define MT6358_FGADC_SON_CON1                 0xd46
#define MT6358_FGADC_SON_CON2                 0xd48
#define MT6358_FGADC_SON_CON3                 0xd4a
#define MT6358_FGADC_SOFF_CON0                0xd4c
#define MT6358_FGADC_SOFF_CON1                0xd4e
#define MT6358_FGADC_SOFF_CON2                0xd50
#define MT6358_FGADC_SOFF_CON3                0xd52
#define MT6358_FGADC_SOFF_CON4                0xd54
#define MT6358_FGADC_PWR_CON0                 0xd56
#define MT6358_FGADC_PWR_CON1                 0xd58
#define MT6358_FGADC_ZCV_CON0                 0xd5a
#define MT6358_FGADC_ZCV_CON1                 0xd5c
#define MT6358_FGADC_ZCV_CON2                 0xd5e
#define MT6358_FGADC_ZCV_CON3                 0xd60
#define MT6358_FGADC_ZCVTH_CON0               0xd62
#define MT6358_FGADC_ZCVTH_CON1               0xd64
#define MT6358_FGADC1_DSN_ID                  0xd80
#define MT6358_FGADC1_DSN_REV0                0xd82
#define MT6358_FGADC1_DSN_DBI                 0xd84
#define MT6358_FGADC1_DSN_DXI                 0xd86
#define MT6358_FGADC_R_CON0                   0xd88
#define MT6358_FGADC_CUR_CON0                 0xd8a
#define MT6358_FGADC_CUR_CON1                 0xd8c
#define MT6358_FGADC_CUR_CON2                 0xd8e
#define MT6358_FGADC_CUR_CON3                 0xd90
#define MT6358_FGADC_OFFSET_CON0              0xd92
#define MT6358_FGADC_OFFSET_CON1              0xd94
#define MT6358_FGADC_GAIN_CON0                0xd96
#define MT6358_FGADC_TEST_CON0                0xd98
#define MT6358_SYSTEM_INFO_CON0               0xd9a
#define MT6358_BATON_ANA_DSN_ID               0xe00
#define MT6358_BATON_ANA_DSN_REV0             0xe02
#define MT6358_BATON_ANA_DSN_DBI              0xe04
#define MT6358_BATON_ANA_DSN_DXI              0xe06
#define MT6358_BATON_ANA_CON0                 0xe08
#define MT6358_BATON_ANA_MON0                 0xe0a
#define MT6358_BIF_ANA_MON0                   0xe0c
#define MT6358_BATON_ANA_ELR_NUM              0xe0e
#define MT6358_BATON_ANA_ELR0                 0xe10
#define MT6358_BATON_DSN_ID                   0xe80
#define MT6358_BATON_DSN_REV0                 0xe82
#define MT6358_BATON_DSN_DBI                  0xe84
#define MT6358_BATON_DSN_DXI                  0xe86
#define MT6358_BATON_CON0                     0xe88
#define MT6358_BATON_CON1                     0xe8a
#define MT6358_BATON_CON2                     0xe8c
#define MT6358_BATON_CON3                     0xe8e
#define MT6358_BATON_ELR_NUM                  0xe90
#define MT6358_BATON_ELR0                     0xe92
#define MT6358_BIF_DSN_ID                     0xf00
#define MT6358_BIF_DSN_REV0                   0xf02
#define MT6358_BIF_DSN_DBI                    0xf04
#define MT6358_BIF_DSN_DXI                    0xf06
#define MT6358_BIF_CON0                       0xf08
#define MT6358_BIF_CON1                       0xf0a
#define MT6358_BIF_CON2                       0xf0c
#define MT6358_BIF_CON3                       0xf0e
#define MT6358_BIF_CON4                       0xf10
#define MT6358_BIF_CON5                       0xf12
#define MT6358_BIF_CON6                       0xf14
#define MT6358_BIF_CON7                       0xf16
#define MT6358_BIF_CON8                       0xf18
#define MT6358_BIF_CON9                       0xf1a
#define MT6358_BIF_CON10                      0xf1c
#define MT6358_BIF_CON11                      0xf1e
#define MT6358_BIF_CON12                      0xf20
#define MT6358_BIF_CON13                      0xf22
#define MT6358_BIF_CON14                      0xf24
#define MT6358_BIF_CON15                      0xf26
#define MT6358_BIF_CON16                      0xf28
#define MT6358_BIF_CON17                      0xf2a
#define MT6358_BIF_CON18                      0xf2c
#define MT6358_BIF_CON19                      0xf2e
#define MT6358_BIF_CON20                      0xf30
#define MT6358_BIF_CON21                      0xf32
#define MT6358_BIF_CON22                      0xf34
#define MT6358_BIF_CON23                      0xf36
#define MT6358_BIF_CON24                      0xf38
#define MT6358_BIF_CON25                      0xf3a
#define MT6358_BIF_CON26                      0xf3c
#define MT6358_BIF_CON27                      0xf3e
#define MT6358_BIF_CON28                      0xf40
#define MT6358_BIF_CON29                      0xf42
#define MT6358_BIF_CON30                      0xf44
#define MT6358_BIF_CON31                      0xf46
#define MT6358_BIF_CON32                      0xf48
#define MT6358_BIF_CON33                      0xf4a
#define MT6358_BIF_CON34                      0xf4c
#define MT6358_BIF_CON35                      0xf4e
#define MT6358_BIF_CON36                      0xf50
#define MT6358_BIF_CON37                      0xf52
#define MT6358_BIF_CON38                      0xf54
#define MT6358_BIF_CON39                      0xf56
#define MT6358_HK_TOP_ID                      0xf80
#define MT6358_HK_TOP_REV0                    0xf82
#define MT6358_HK_TOP_DBI                     0xf84
#define MT6358_HK_TOP_DXI                     0xf86
#define MT6358_HK_TPM0                        0xf88
#define MT6358_HK_TPM1                        0xf8a
#define MT6358_HK_TOP_CLK_CON0                0xf8c
#define MT6358_HK_TOP_CLK_CON1                0xf8e
#define MT6358_HK_TOP_RST_CON0                0xf90
#define MT6358_HK_TOP_INT_CON0                0xf92
#define MT6358_HK_TOP_INT_CON0_SET            0xf94
#define MT6358_HK_TOP_INT_CON0_CLR            0xf96
#define MT6358_HK_TOP_INT_MASK_CON0           0xf98
#define MT6358_HK_TOP_INT_MASK_CON0_SET       0xf9a
#define MT6358_HK_TOP_INT_MASK_CON0_CLR       0xf9c
#define MT6358_HK_TOP_INT_STATUS0             0xf9e
#define MT6358_HK_TOP_INT_RAW_STATUS0         0xfa0
#define MT6358_HK_TOP_MON_CON0                0xfa2
#define MT6358_HK_TOP_MON_CON1                0xfa4
#define MT6358_HK_TOP_MON_CON2                0xfa6
#define MT6358_HK_TOP_CHR_CON                 0xfa8
#define MT6358_HK_TOP_AUXADC_ANA              0xfaa
#define MT6358_AUXADC_DSN_ID                  0x1000
#define MT6358_AUXADC_DSN_REV0                0x1002
#define MT6358_AUXADC_DSN_DBI                 0x1004
#define MT6358_AUXADC_DSN_FPI                 0x1006
#define MT6358_AUXADC_ANA_CON0                0x1008
#define MT6358_AUXADC_DIG_1_DSN_ID            0x1080
#define MT6358_AUXADC_DIG_1_DSN_REV0          0x1082
#define MT6358_AUXADC_DIG_1_DSN_DBI           0x1084
#define MT6358_AUXADC_DIG_1_DSN_DXI           0x1086
#define MT6358_AUXADC_ADC0                    0x1088
#define MT6358_AUXADC_ADC1                    0x108a
#define MT6358_AUXADC_ADC2                    0x108c
#define MT6358_AUXADC_ADC3                    0x108e
#define MT6358_AUXADC_ADC4                    0x1090
#define MT6358_AUXADC_ADC5                    0x1092
#define MT6358_AUXADC_ADC6                    0x1094
#define MT6358_AUXADC_ADC7                    0x1096
#define MT6358_AUXADC_ADC8                    0x1098
#define MT6358_AUXADC_ADC9                    0x109a
#define MT6358_AUXADC_ADC10                   0x109c
#define MT6358_AUXADC_ADC11                   0x109e
#define MT6358_AUXADC_ADC12                   0x10a0
#define MT6358_AUXADC_ADC13                   0x10a2
#define MT6358_AUXADC_ADC14                   0x10a4
#define MT6358_AUXADC_ADC15                   0x10a6
#define MT6358_AUXADC_ADC16                   0x10a8
#define MT6358_AUXADC_ADC17                   0x10aa
#define MT6358_AUXADC_ADC18                   0x10ac
#define MT6358_AUXADC_ADC19                   0x10ae
#define MT6358_AUXADC_ADC20                   0x10b0
#define MT6358_AUXADC_ADC21                   0x10b2
#define MT6358_AUXADC_ADC22                   0x10b4
#define MT6358_AUXADC_ADC23                   0x10b6
#define MT6358_AUXADC_ADC24                   0x10b8
#define MT6358_AUXADC_ADC25                   0x10ba
#define MT6358_AUXADC_ADC26                   0x10bc
#define MT6358_AUXADC_ADC27                   0x10be
#define MT6358_AUXADC_ADC28                   0x10c0
#define MT6358_AUXADC_ADC29                   0x10c2
#define MT6358_AUXADC_ADC30                   0x10c4
#define MT6358_AUXADC_ADC31                   0x10c6
#define MT6358_AUXADC_ADC32                   0x10c8
#define MT6358_AUXADC_ADC33                   0x10ca
#define MT6358_AUXADC_ADC34                   0x10cc
#define MT6358_AUXADC_ADC35                   0x10ce
#define MT6358_AUXADC_ADC36                   0x10d0
#define MT6358_AUXADC_ADC37                   0x10d2
#define MT6358_AUXADC_ADC38                   0x10d4
#define MT6358_AUXADC_ADC39                   0x10d6
#define MT6358_AUXADC_ADC40                   0x10d8
#define MT6358_AUXADC_STA0                    0x10da
#define MT6358_AUXADC_STA1                    0x10dc
#define MT6358_AUXADC_STA2                    0x10de
#define MT6358_AUXADC_DIG_2_DSN_ID            0x1100
#define MT6358_AUXADC_DIG_2_DSN_REV0          0x1102
#define MT6358_AUXADC_DIG_2_DSN_DBI           0x1104
#define MT6358_AUXADC_DIG_2_DSN_DXI           0x1106
#define MT6358_AUXADC_RQST0                   0x1108
#define MT6358_AUXADC_RQST1                   0x110a
#define MT6358_AUXADC_DIG_3_DSN_ID            0x1180
#define MT6358_AUXADC_DIG_3_DSN_REV0          0x1182
#define MT6358_AUXADC_DIG_3_DSN_DBI           0x1184
#define MT6358_AUXADC_DIG_3_DSN_DXI           0x1186
#define MT6358_AUXADC_CON0                    0x1188
#define MT6358_AUXADC_CON0_SET                0x118a
#define MT6358_AUXADC_CON0_CLR                0x118c
#define MT6358_AUXADC_CON1                    0x118e
#define MT6358_AUXADC_CON2                    0x1190
#define MT6358_AUXADC_CON3                    0x1192
#define MT6358_AUXADC_CON4                    0x1194
#define MT6358_AUXADC_CON5                    0x1196
#define MT6358_AUXADC_CON6                    0x1198
#define MT6358_AUXADC_CON7                    0x119a
#define MT6358_AUXADC_CON8                    0x119c
#define MT6358_AUXADC_CON9                    0x119e
#define MT6358_AUXADC_CON10                   0x11a0
#define MT6358_AUXADC_CON11                   0x11a2
#define MT6358_AUXADC_CON12                   0x11a4
#define MT6358_AUXADC_CON13                   0x11a6
#define MT6358_AUXADC_CON14                   0x11a8
#define MT6358_AUXADC_CON15                   0x11aa
#define MT6358_AUXADC_CON16                   0x11ac
#define MT6358_AUXADC_CON17                   0x11ae
#define MT6358_AUXADC_CON18                   0x11b0
#define MT6358_AUXADC_CON19                   0x11b2
#define MT6358_AUXADC_CON20                   0x11b4
#define MT6358_AUXADC_AUTORPT0                0x11b6
#define MT6358_AUXADC_ACCDET                  0x11b8
#define MT6358_AUXADC_DBG0                    0x11ba
#define MT6358_AUXADC_DIG_3_ELR_NUM           0x11bc
#define MT6358_AUXADC_DIG_3_ELR0              0x11be
#define MT6358_AUXADC_DIG_3_ELR1              0x11c0
#define MT6358_AUXADC_DIG_3_ELR2              0x11c2
#define MT6358_AUXADC_DIG_3_ELR3              0x11c4
#define MT6358_AUXADC_DIG_3_ELR4              0x11c6
#define MT6358_AUXADC_DIG_3_ELR5              0x11c8
#define MT6358_AUXADC_DIG_3_ELR6              0x11ca
#define MT6358_AUXADC_DIG_3_ELR7              0x11cc
#define MT6358_AUXADC_DIG_3_ELR8              0x11ce
#define MT6358_AUXADC_DIG_3_ELR9              0x11d0
#define MT6358_AUXADC_DIG_3_ELR10             0x11d2
#define MT6358_AUXADC_DIG_3_ELR11             0x11d4
#define MT6358_AUXADC_DIG_3_ELR12             0x11d6
#define MT6358_AUXADC_DIG_3_ELR13             0x11d8
#define MT6358_AUXADC_DIG_4_DSN_ID            0x1200
#define MT6358_AUXADC_DIG_4_DSN_REV0          0x1202
#define MT6358_AUXADC_DIG_4_DSN_DBI           0x1204
#define MT6358_AUXADC_DIG_4_DSN_DXI           0x1206
#define MT6358_AUXADC_IMP0                    0x1208
#define MT6358_AUXADC_IMP1                    0x120a
#define MT6358_AUXADC_IMP2                    0x120c
#define MT6358_AUXADC_LBAT0                   0x120e
#define MT6358_AUXADC_LBAT1                   0x1210
#define MT6358_AUXADC_LBAT2                   0x1212
#define MT6358_AUXADC_LBAT3                   0x1214
#define MT6358_AUXADC_LBAT4                   0x1216
#define MT6358_AUXADC_LBAT5                   0x1218
#define MT6358_AUXADC_LBAT6                   0x121a
#define MT6358_AUXADC_BAT_TEMP_0              0x121c
#define MT6358_AUXADC_BAT_TEMP_1              0x121e
#define MT6358_AUXADC_BAT_TEMP_2              0x1220
#define MT6358_AUXADC_BAT_TEMP_3              0x1222
#define MT6358_AUXADC_BAT_TEMP_4              0x1224
#define MT6358_AUXADC_BAT_TEMP_5              0x1226
#define MT6358_AUXADC_BAT_TEMP_6              0x1228
#define MT6358_AUXADC_BAT_TEMP_7              0x122a
#define MT6358_AUXADC_LBAT2_1                 0x122c
#define MT6358_AUXADC_LBAT2_2                 0x122e
#define MT6358_AUXADC_LBAT2_3                 0x1230
#define MT6358_AUXADC_LBAT2_4                 0x1232
#define MT6358_AUXADC_LBAT2_5                 0x1234
#define MT6358_AUXADC_LBAT2_6                 0x1236
#define MT6358_AUXADC_LBAT2_7                 0x1238
#define MT6358_AUXADC_MDRT_0                  0x123a
#define MT6358_AUXADC_MDRT_1                  0x123c
#define MT6358_AUXADC_MDRT_2                  0x123e
#define MT6358_AUXADC_MDRT_3                  0x1240
#define MT6358_AUXADC_MDRT_4                  0x1242
#define MT6358_AUXADC_DCXO_MDRT_1             0x1244
#define MT6358_AUXADC_DCXO_MDRT_2             0x1246
#define MT6358_AUXADC_NAG_0                   0x1248
#define MT6358_AUXADC_NAG_1                   0x124a
#define MT6358_AUXADC_NAG_2                   0x124c
#define MT6358_AUXADC_NAG_3                   0x124e
#define MT6358_AUXADC_NAG_4                   0x1250
#define MT6358_AUXADC_NAG_5                   0x1252
#define MT6358_AUXADC_NAG_6                   0x1254
#define MT6358_AUXADC_NAG_7                   0x1256
#define MT6358_AUXADC_NAG_8                   0x1258
#define MT6358_AUXADC_NAG_9                   0x125a
#define MT6358_AUXADC_RSV_1                   0x125c
#define MT6358_AUXADC_PRI_NEW                 0x125e
#define MT6358_AUXADC_DCM_CON                 0x1260
#define MT6358_AUXADC_SPL_LIST_0              0x1262
#define MT6358_AUXADC_SPL_LIST_1              0x1264
#define MT6358_AUXADC_SPL_LIST_2              0x1266
#define MT6358_BUCK_TOP_DSN_ID                0x1300
#define MT6358_BUCK_TOP_DSN_REV0              0x1302
#define MT6358_BUCK_TOP_DBI                   0x1304
#define MT6358_BUCK_TOP_DXI                   0x1306
#define MT6358_BUCK_TOP_PAM0                  0x1308
#define MT6358_BUCK_TOP_PAM1                  0x130a
#define MT6358_BUCK_TOP_CLK_CON0              0x130c
#define MT6358_BUCK_TOP_CLK_CON0_SET          0x130e
#define MT6358_BUCK_TOP_CLK_CON0_CLR          0x1310
#define MT6358_BUCK_TOP_CLK_HWEN_CON0         0x1312
#define MT6358_BUCK_TOP_CLK_HWEN_CON0_SET     0x1314
#define MT6358_BUCK_TOP_CLK_HWEN_CON0_CLR     0x1316
#define MT6358_BUCK_TOP_INT_CON0              0x1318
#define MT6358_BUCK_TOP_INT_CON0_SET          0x131a
#define MT6358_BUCK_TOP_INT_CON0_CLR          0x131c
#define MT6358_BUCK_TOP_INT_MASK_CON0         0x131e
#define MT6358_BUCK_TOP_INT_MASK_CON0_SET     0x1320
#define MT6358_BUCK_TOP_INT_MASK_CON0_CLR     0x1322
#define MT6358_BUCK_TOP_INT_STATUS0           0x1324
#define MT6358_BUCK_TOP_INT_RAW_STATUS0       0x1326
#define MT6358_BUCK_TOP_STB_CON               0x1328
#define MT6358_BUCK_TOP_SLP_CON0              0x132a
#define MT6358_BUCK_TOP_SLP_CON1              0x132c
#define MT6358_BUCK_TOP_SLP_CON2              0x132e
#define MT6358_BUCK_TOP_MINFREQ_CON           0x1330
#define MT6358_BUCK_TOP_OC_CON0               0x1332
#define MT6358_BUCK_TOP_K_CON0                0x1334
#define MT6358_BUCK_TOP_K_CON1                0x1336
#define MT6358_BUCK_TOP_K_CON2                0x1338
#define MT6358_BUCK_TOP_WDTDBG0               0x133a
#define MT6358_BUCK_TOP_WDTDBG1               0x133c
#define MT6358_BUCK_TOP_WDTDBG2               0x133e
#define MT6358_BUCK_TOP_WDTDBG3               0x1340
#define MT6358_BUCK_TOP_WDTDBG4               0x1342
#define MT6358_BUCK_TOP_ELR_NUM               0x1344
#define MT6358_BUCK_TOP_ELR0                  0x1346
#define MT6358_BUCK_TOP_ELR1                  0x1348
#define MT6358_BUCK_TOP_ELR2                  0x134a
#define MT6358_BUCK_TOP_ELR3                  0x134c
#define MT6358_BUCK_VPROC11_DSN_ID            0x1380
#define MT6358_BUCK_VPROC11_DSN_REV0          0x1382
#define MT6358_BUCK_VPROC11_DSN_DBI           0x1384
#define MT6358_BUCK_VPROC11_DSN_DXI           0x1386
#define MT6358_BUCK_VPROC11_CON0              0x1388
#define MT6358_BUCK_VPROC11_CON1              0x138a
#define MT6358_BUCK_VPROC11_CFG0              0x138c
#define MT6358_BUCK_VPROC11_CFG1              0x138e
#define MT6358_BUCK_VPROC11_OP_EN             0x1390
#define MT6358_BUCK_VPROC11_OP_EN_SET         0x1392
#define MT6358_BUCK_VPROC11_OP_EN_CLR         0x1394
#define MT6358_BUCK_VPROC11_OP_CFG            0x1396
#define MT6358_BUCK_VPROC11_OP_CFG_SET        0x1398
#define MT6358_BUCK_VPROC11_OP_CFG_CLR        0x139a
#define MT6358_BUCK_VPROC11_OC_CFG            0x139c
#define MT6358_BUCK_VPROC11_DBG0              0x139e
#define MT6358_BUCK_VPROC11_DBG1              0x13a0
#define MT6358_BUCK_VPROC11_DBG2              0x13a2
#define MT6358_BUCK_VPROC11_ELR_NUM           0x13a4
#define MT6358_BUCK_VPROC11_ELR0              0x13a6
#define MT6358_BUCK_VPROC12_DSN_ID            0x1400
#define MT6358_BUCK_VPROC12_DSN_REV0          0x1402
#define MT6358_BUCK_VPROC12_DSN_DBI           0x1404
#define MT6358_BUCK_VPROC12_DSN_DXI           0x1406
#define MT6358_BUCK_VPROC12_CON0              0x1408
#define MT6358_BUCK_VPROC12_CON1              0x140a
#define MT6358_BUCK_VPROC12_CFG0              0x140c
#define MT6358_BUCK_VPROC12_CFG1              0x140e
#define MT6358_BUCK_VPROC12_OP_EN             0x1410
#define MT6358_BUCK_VPROC12_OP_EN_SET         0x1412
#define MT6358_BUCK_VPROC12_OP_EN_CLR         0x1414
#define MT6358_BUCK_VPROC12_OP_CFG            0x1416
#define MT6358_BUCK_VPROC12_OP_CFG_SET        0x1418
#define MT6358_BUCK_VPROC12_OP_CFG_CLR        0x141a
#define MT6358_BUCK_VPROC12_OC_CFG            0x141c
#define MT6358_BUCK_VPROC12_DBG0              0x141e
#define MT6358_BUCK_VPROC12_DBG1              0x1420
#define MT6358_BUCK_VPROC12_DBG2              0x1422
#define MT6358_BUCK_VPROC12_ELR_NUM           0x1424
#define MT6358_BUCK_VPROC12_ELR0              0x1426
#define MT6358_BUCK_VCORE_DSN_ID              0x1480
#define MT6358_BUCK_VCORE_DSN_REV0            0x1482
#define MT6358_BUCK_VCORE_DSN_DBI             0x1484
#define MT6358_BUCK_VCORE_DSN_DXI             0x1486
#define MT6358_BUCK_VCORE_CON0                0x1488
#define MT6358_BUCK_VCORE_CON1                0x148a
#define MT6358_BUCK_VCORE_CFG0                0x148c
#define MT6358_BUCK_VCORE_CFG1                0x148e
#define MT6358_BUCK_VCORE_OP_EN               0x1490
#define MT6358_BUCK_VCORE_OP_EN_SET           0x1492
#define MT6358_BUCK_VCORE_OP_EN_CLR           0x1494
#define MT6358_BUCK_VCORE_OP_CFG              0x1496
#define MT6358_BUCK_VCORE_OP_CFG_SET          0x1498
#define MT6358_BUCK_VCORE_OP_CFG_CLR          0x149a
#define MT6358_BUCK_VCORE_OC_CFG              0x149c
#define MT6358_BUCK_VCORE_DBG0                0x149e
#define MT6358_BUCK_VCORE_DBG1                0x14a0
#define MT6358_BUCK_VCORE_DBG2                0x14a2
#define MT6358_BUCK_VCORE_SSHUB_CON0          0x14a4
#define MT6358_BUCK_VCORE_SSHUB_CON1          0x14a6
#define MT6358_BUCK_VCORE_ELR_NUM             0x14a8
#define MT6358_BUCK_VCORE_ELR0                0x14aa
#define MT6358_BUCK_VGPU_DSN_ID               0x1500
#define MT6358_BUCK_VGPU_DSN_REV0             0x1502
#define MT6358_BUCK_VGPU_DSN_DBI              0x1504
#define MT6358_BUCK_VGPU_DSN_DXI              0x1506
#define MT6358_BUCK_VGPU_CON0                 0x1508
#define MT6358_BUCK_VGPU_CON1                 0x150a
#define MT6358_BUCK_VGPU_CFG0                 0x150c
#define MT6358_BUCK_VGPU_CFG1                 0x150e
#define MT6358_BUCK_VGPU_OP_EN                0x1510
#define MT6358_BUCK_VGPU_OP_EN_SET            0x1512
#define MT6358_BUCK_VGPU_OP_EN_CLR            0x1514
#define MT6358_BUCK_VGPU_OP_CFG               0x1516
#define MT6358_BUCK_VGPU_OP_CFG_SET           0x1518
#define MT6358_BUCK_VGPU_OP_CFG_CLR           0x151a
#define MT6358_BUCK_VGPU_OC_CFG               0x151c
#define MT6358_BUCK_VGPU_DBG0                 0x151e
#define MT6358_BUCK_VGPU_DBG1                 0x1520
#define MT6358_BUCK_VGPU_DBG2                 0x1522
#define MT6358_BUCK_VGPU_ELR_NUM              0x1524
#define MT6358_BUCK_VGPU_ELR0                 0x1526
#define MT6358_BUCK_VMODEM_DSN_ID             0x1580
#define MT6358_BUCK_VMODEM_DSN_REV0           0x1582
#define MT6358_BUCK_VMODEM_DSN_DBI            0x1584
#define MT6358_BUCK_VMODEM_DSN_DXI            0x1586
#define MT6358_BUCK_VMODEM_CON0               0x1588
#define MT6358_BUCK_VMODEM_CON1               0x158a
#define MT6358_BUCK_VMODEM_CFG0               0x158c
#define MT6358_BUCK_VMODEM_CFG1               0x158e
#define MT6358_BUCK_VMODEM_OP_EN              0x1590
#define MT6358_BUCK_VMODEM_OP_EN_SET          0x1592
#define MT6358_BUCK_VMODEM_OP_EN_CLR          0x1594
#define MT6358_BUCK_VMODEM_OP_CFG             0x1596
#define MT6358_BUCK_VMODEM_OP_CFG_SET         0x1598
#define MT6358_BUCK_VMODEM_OP_CFG_CLR         0x159a
#define MT6358_BUCK_VMODEM_OC_CFG             0x159c
#define MT6358_BUCK_VMODEM_DBG0               0x159e
#define MT6358_BUCK_VMODEM_DBG1               0x15a0
#define MT6358_BUCK_VMODEM_DBG2               0x15a2
#define MT6358_BUCK_VMODEM_ELR_NUM            0x15a4
#define MT6358_BUCK_VMODEM_ELR0               0x15a6
#define MT6358_BUCK_VDRAM1_DSN_ID             0x1600
#define MT6358_BUCK_VDRAM1_DSN_REV0           0x1602
#define MT6358_BUCK_VDRAM1_DSN_DBI            0x1604
#define MT6358_BUCK_VDRAM1_DSN_DXI            0x1606
#define MT6358_BUCK_VDRAM1_CON0               0x1608
#define MT6358_BUCK_VDRAM1_CON1               0x160a
#define MT6358_BUCK_VDRAM1_CFG0               0x160c
#define MT6358_BUCK_VDRAM1_CFG1               0x160e
#define MT6358_BUCK_VDRAM1_OP_EN              0x1610
#define MT6358_BUCK_VDRAM1_OP_EN_SET          0x1612
#define MT6358_BUCK_VDRAM1_OP_EN_CLR          0x1614
#define MT6358_BUCK_VDRAM1_OP_CFG             0x1616
#define MT6358_BUCK_VDRAM1_OP_CFG_SET         0x1618
#define MT6358_BUCK_VDRAM1_OP_CFG_CLR         0x161a
#define MT6358_BUCK_VDRAM1_OC_CFG             0x161c
#define MT6358_BUCK_VDRAM1_DBG0               0x161e
#define MT6358_BUCK_VDRAM1_DBG1               0x1620
#define MT6358_BUCK_VDRAM1_DBG2               0x1622
#define MT6358_BUCK_VDRAM1_ELR_NUM            0x1624
#define MT6358_BUCK_VDRAM1_ELR0               0x1626
#define MT6358_BUCK_VS1_DSN_ID                0x1680
#define MT6358_BUCK_VS1_DSN_REV0              0x1682
#define MT6358_BUCK_VS1_DSN_DBI               0x1684
#define MT6358_BUCK_VS1_DSN_DXI               0x1686
#define MT6358_BUCK_VS1_CON0                  0x1688
#define MT6358_BUCK_VS1_CON1                  0x168a
#define MT6358_BUCK_VS1_CFG0                  0x168c
#define MT6358_BUCK_VS1_CFG1                  0x168e
#define MT6358_BUCK_VS1_OP_EN                 0x1690
#define MT6358_BUCK_VS1_OP_EN_SET             0x1692
#define MT6358_BUCK_VS1_OP_EN_CLR             0x1694
#define MT6358_BUCK_VS1_OP_CFG                0x1696
#define MT6358_BUCK_VS1_OP_CFG_SET            0x1698
#define MT6358_BUCK_VS1_OP_CFG_CLR            0x169a
#define MT6358_BUCK_VS1_OC_CFG                0x169c
#define MT6358_BUCK_VS1_DBG0                  0x169e
#define MT6358_BUCK_VS1_DBG1                  0x16a0
#define MT6358_BUCK_VS1_DBG2                  0x16a2
#define MT6358_BUCK_VS1_VOTER                 0x16a4
#define MT6358_BUCK_VS1_VOTER_SET             0x16a6
#define MT6358_BUCK_VS1_VOTER_CLR             0x16a8
#define MT6358_BUCK_VS1_VOTER_CFG             0x16aa
#define MT6358_BUCK_VS1_ELR_NUM               0x16ac
#define MT6358_BUCK_VS1_ELR0                  0x16ae
#define MT6358_BUCK_VS2_DSN_ID                0x1700
#define MT6358_BUCK_VS2_DSN_REV0              0x1702
#define MT6358_BUCK_VS2_DSN_DBI               0x1704
#define MT6358_BUCK_VS2_DSN_DXI               0x1706
#define MT6358_BUCK_VS2_CON0                  0x1708
#define MT6358_BUCK_VS2_CON1                  0x170a
#define MT6358_BUCK_VS2_CFG0                  0x170c
#define MT6358_BUCK_VS2_CFG1                  0x170e
#define MT6358_BUCK_VS2_OP_EN                 0x1710
#define MT6358_BUCK_VS2_OP_EN_SET             0x1712
#define MT6358_BUCK_VS2_OP_EN_CLR             0x1714
#define MT6358_BUCK_VS2_OP_CFG                0x1716
#define MT6358_BUCK_VS2_OP_CFG_SET            0x1718
#define MT6358_BUCK_VS2_OP_CFG_CLR            0x171a
#define MT6358_BUCK_VS2_OC_CFG                0x171c
#define MT6358_BUCK_VS2_DBG0                  0x171e
#define MT6358_BUCK_VS2_DBG1                  0x1720
#define MT6358_BUCK_VS2_DBG2                  0x1722
#define MT6358_BUCK_VS2_VOTER                 0x1724
#define MT6358_BUCK_VS2_VOTER_SET             0x1726
#define MT6358_BUCK_VS2_VOTER_CLR             0x1728
#define MT6358_BUCK_VS2_VOTER_CFG             0x172a
#define MT6358_BUCK_VS2_ELR_NUM               0x172c
#define MT6358_BUCK_VS2_ELR0                  0x172e
#define MT6358_BUCK_VPA_DSN_ID                0x1780
#define MT6358_BUCK_VPA_DSN_REV0              0x1782
#define MT6358_BUCK_VPA_DSN_DBI               0x1784
#define MT6358_BUCK_VPA_DSN_DXI               0x1786
#define MT6358_BUCK_VPA_CON0                  0x1788
#define MT6358_BUCK_VPA_CON1                  0x178a
#define MT6358_BUCK_VPA_ELR0                  MT6358_BUCK_VPA_CON1
#define MT6358_BUCK_VPA_CFG0                  0x178c
#define MT6358_BUCK_VPA_CFG1                  0x178e
#define MT6358_BUCK_VPA_OC_CFG                0x1790
#define MT6358_BUCK_VPA_DBG0                  0x1792
#define MT6358_BUCK_VPA_DBG1                  0x1794
#define MT6358_BUCK_VPA_DBG2                  0x1796
#define MT6358_BUCK_VPA_DLC_CON0              0x1798
#define MT6358_BUCK_VPA_DLC_CON1              0x179a
#define MT6358_BUCK_VPA_DLC_CON2              0x179c
#define MT6358_BUCK_VPA_MSFG_CON0             0x179e
#define MT6358_BUCK_VPA_MSFG_CON1             0x17a0
#define MT6358_BUCK_VPA_MSFG_RRATE0           0x17a2
#define MT6358_BUCK_VPA_MSFG_RRATE1           0x17a4
#define MT6358_BUCK_VPA_MSFG_RRATE2           0x17a6
#define MT6358_BUCK_VPA_MSFG_RTHD0            0x17a8
#define MT6358_BUCK_VPA_MSFG_RTHD1            0x17aa
#define MT6358_BUCK_VPA_MSFG_RTHD2            0x17ac
#define MT6358_BUCK_VPA_MSFG_FRATE0           0x17ae
#define MT6358_BUCK_VPA_MSFG_FRATE1           0x17b0
#define MT6358_BUCK_VPA_MSFG_FRATE2           0x17b2
#define MT6358_BUCK_VPA_MSFG_FTHD0            0x17b4
#define MT6358_BUCK_VPA_MSFG_FTHD1            0x17b6
#define MT6358_BUCK_VPA_MSFG_FTHD2            0x17b8
#define MT6358_BUCK_ANA0_DSN_ID               0x1800
#define MT6358_BUCK_ANA0_DSN_REV0             0x1802
#define MT6358_BUCK_ANA0_DSN_DBI              0x1804
#define MT6358_BUCK_ANA0_DSN_FPI              0x1806
#define MT6358_SMPS_ANA_CON0                  0x1808
#define MT6358_SMPS_ANA_CON1                  0x180a
#define MT6358_VPROC_ANA_CON0                 0x180c
#define MT6358_VPROC_ANA_CON1                 0x180e
#define MT6358_VPROC_ANA_CON2                 0x1810
#define MT6358_VPROC_ANA_CON3                 0x1812
#define MT6358_VPROC_ANA_CON4                 0x1814
#define MT6358_VPROC_ANA_CON5                 0x1816
#define MT6358_VPROC_ANA_CON6                 0x1818
#define MT6358_VPROC_ANA_CON7                 0x181a
#define MT6358_VPROC_ANA_CON8                 0x181c
#define MT6358_VPROC_ANA_CON9                 0x181e
#define MT6358_VPROC_ANA_CON10                0x1820
#define MT6358_VPROC_ANA_CON11                0x1822
#define MT6358_VPROC_ANA_CON12                0x1824
#define MT6358_VPROC_ANA_CON13                0x1826
#define MT6358_VCORE_VGPU_ANA_CON0            0x1828
#define MT6358_VCORE_VGPU_ANA_CON1            0x182a
#define MT6358_VCORE_VGPU_ANA_CON2            0x182c
#define MT6358_VCORE_VGPU_ANA_CON3            0x182e
#define MT6358_VCORE_VGPU_ANA_CON4            0x1830
#define MT6358_VCORE_VGPU_ANA_CON5            0x1832
#define MT6358_VCORE_VGPU_ANA_CON6            0x1834
#define MT6358_VCORE_VGPU_ANA_CON7            0x1836
#define MT6358_VCORE_VGPU_ANA_CON8            0x1838
#define MT6358_VCORE_VGPU_ANA_CON9            0x183a
#define MT6358_VCORE_VGPU_ANA_CON10           0x183c
#define MT6358_VCORE_VGPU_ANA_CON11           0x183e
#define MT6358_VCORE_VGPU_ANA_CON12           0x1840
#define MT6358_VCORE_VGPU_ANA_CON13           0x1842
#define MT6358_BUCK_ANA0_ELR_NUM              0x1844
#define MT6358_SMPS_ELR_0                     0x1846
#define MT6358_SMPS_ELR_1                     0x1848
#define MT6358_SMPS_ELR_2                     0x184a
#define MT6358_SMPS_ELR_3                     0x184c
#define MT6358_SMPS_ELR_4                     0x184e
#define MT6358_SMPS_ELR_5                     0x1850
#define MT6358_VPROC_ELR_0                    0x1852
#define MT6358_VPROC_ELR_1                    0x1854
#define MT6358_VPROC_ELR_2                    0x1856
#define MT6358_VPROC_ELR_3                    0x1858
#define MT6358_VCORE_VGPU_ELR_0               0x185a
#define MT6358_VCORE_VGPU_ELR_1               0x185c
#define MT6358_VCORE_VGPU_ELR_2               0x185e
#define MT6358_VCORE_VGPU_ELR_3               0x1860
#define MT6358_BUCK_ANA1_DSN_ID               0x1880
#define MT6358_BUCK_ANA1_DSN_REV0             0x1882
#define MT6358_BUCK_ANA1_DSN_DBI              0x1884
#define MT6358_BUCK_ANA1_DSN_FPI              0x1886
#define MT6358_VMODEM_ANA_CON0                0x1888
#define MT6358_VMODEM_ANA_CON1                0x188a
#define MT6358_VMODEM_ANA_CON2                0x188c
#define MT6358_VMODEM_ANA_CON3                0x188e
#define MT6358_VMODEM_ANA_CON4                0x1890
#define MT6358_VMODEM_ANA_CON5                0x1892
#define MT6358_VMODEM_ANA_CON6                0x1894
#define MT6358_VDRAM1_ANA_CON0                0x1896
#define MT6358_VDRAM1_ANA_CON1                0x1898
#define MT6358_VDRAM1_ANA_CON2                0x189a
#define MT6358_VDRAM1_ANA_CON3                0x189c
#define MT6358_VDRAM1_ANA_CON4                0x189e
#define MT6358_VDRAM1_ANA_CON5                0x18a0
#define MT6358_VS1_ANA_CON0                   0x18a2
#define MT6358_VS1_ANA_CON1                   0x18a4
#define MT6358_VS1_ANA_CON2                   0x18a6
#define MT6358_VS1_ANA_CON3                   0x18a8
#define MT6358_VS1_ANA_CON4                   0x18aa
#define MT6358_VS1_ANA_CON5                   0x18ac
#define MT6358_VS2_ANA_CON0                   0x18ae
#define MT6358_VS2_ANA_CON1                   0x18b0
#define MT6358_VS2_ANA_CON2                   0x18b2
#define MT6358_VS2_ANA_CON3                   0x18b4
#define MT6358_VS2_ANA_CON4                   0x18b6
#define MT6358_VS2_ANA_CON5                   0x18b8
#define MT6358_VPA_ANA_CON0                   0x18ba
#define MT6358_VPA_ANA_CON1                   0x18bc
#define MT6358_VPA_ANA_CON2                   0x18be
#define MT6358_VPA_ANA_CON3                   0x18c0
#define MT6358_VPA_ANA_CON4                   0x18c2
#define MT6358_VPA_ANA_CON5                   0x18c4
#define MT6358_BUCK_ANA1_ELR_NUM              0x18c6
#define MT6358_VMODEM_ELR_0                   0x18c8
#define MT6358_VMODEM_ELR_1                   0x18ca
#define MT6358_VDRAM1_ELR_0                   0x18cc
#define MT6358_VDRAM1_ELR_1                   0x18ce
#define MT6358_VS1_ELR_0                      0x18d0
#define MT6358_VS1_ELR_1                      0x18d2
#define MT6358_VS2_ELR_0                      0x18d4
#define MT6358_VS2_ELR_1                      0x18d6
#define MT6358_VPA_ELR_0                      0x18d8
#define MT6358_LDO_TOP_ID                     0x1a00
#define MT6358_LDO_TOP_REV0                   0x1a02
#define MT6358_LDO_TOP_DBI                    0x1a04
#define MT6358_LDO_TOP_DXI                    0x1a06
#define MT6358_LDO_TPM0                       0x1a08
#define MT6358_LDO_TPM1                       0x1a0a
#define MT6358_LDO_TOP_CKPDN_CON0             0x1a0c
#define MT6358_TOP_TOP_CKHWEN_CON0            0x1a0e
#define MT6358_LDO_TOP_CLK_DCM_CON0           0x1a10
#define MT6358_LDO_TOP_CLK_VFE28_CON0         0x1a12
#define MT6358_LDO_TOP_CLK_VXO22_CON0         0x1a14
#define MT6358_LDO_TOP_CLK_VRF18_CON0         0x1a16
#define MT6358_LDO_TOP_CLK_VRF12_CON0         0x1a18
#define MT6358_LDO_TOP_CLK_VEFUSE_CON0        0x1a1a
#define MT6358_LDO_TOP_CLK_VCN33_CON0         0x1a1c
#define MT6358_LDO_TOP_CLK_VCN28_CON0         0x1a1e
#define MT6358_LDO_TOP_CLK_VCN18_CON0         0x1a20
#define MT6358_LDO_TOP_CLK_VCAMA1_CON0        0x1a22
#define MT6358_LDO_TOP_CLK_VCAMA2_CON0        0x1a24
#define MT6358_LDO_TOP_CLK_VCAMD_CON0         0x1a26
#define MT6358_LDO_TOP_CLK_VCAMIO_CON0        0x1a28
#define MT6358_LDO_TOP_CLK_VLDO28_CON0        0x1a2a
#define MT6358_LDO_TOP_CLK_VA12_CON0          0x1a2c
#define MT6358_LDO_TOP_CLK_VAUX18_CON0        0x1a2e
#define MT6358_LDO_TOP_CLK_VAUD28_CON0        0x1a30
#define MT6358_LDO_TOP_CLK_VIO28_CON0         0x1a32
#define MT6358_LDO_TOP_CLK_VIO18_CON0         0x1a34
#define MT6358_LDO_TOP_CLK_VSRAM_PROC11_CON0  0x1a36
#define MT6358_LDO_TOP_CLK_VSRAM_PROC12_CON0  0x1a38
#define MT6358_LDO_TOP_CLK_VSRAM_OTHERS_CON0  0x1a3a
#define MT6358_LDO_TOP_CLK_VSRAM_GPU_CON0     0x1a3c
#define MT6358_LDO_TOP_CLK_VDRAM2_CON0        0x1a3e
#define MT6358_LDO_TOP_CLK_VMC_CON0           0x1a40
#define MT6358_LDO_TOP_CLK_VMCH_CON0          0x1a42
#define MT6358_LDO_TOP_CLK_VEMC_CON0          0x1a44
#define MT6358_LDO_TOP_CLK_VSIM1_CON0         0x1a46
#define MT6358_LDO_TOP_CLK_VSIM2_CON0         0x1a48
#define MT6358_LDO_TOP_CLK_VIBR_CON0          0x1a4a
#define MT6358_LDO_TOP_CLK_VUSB_CON0          0x1a4c
#define MT6358_LDO_TOP_CLK_VBIF28_CON0        0x1a4e
#define MT6358_LDO_TOP_INT_CON0               0x1a50
#define MT6358_LDO_TOP_INT_CON0_SET           0x1a52
#define MT6358_LDO_TOP_INT_CON0_CLR           0x1a54
#define MT6358_LDO_TOP_INT_CON1               0x1a56
#define MT6358_LDO_TOP_INT_CON1_SET           0x1a58
#define MT6358_LDO_TOP_INT_CON1_CLR           0x1a5a
#define MT6358_LDO_TOP_INT_MASK_CON0          0x1a5c
#define MT6358_LDO_TOP_INT_MASK_CON0_SET      0x1a5e
#define MT6358_LDO_TOP_INT_MASK_CON0_CLR      0x1a60
#define MT6358_LDO_TOP_INT_MASK_CON1          0x1a62
#define MT6358_LDO_TOP_INT_MASK_CON1_SET      0x1a64
#define MT6358_LDO_TOP_INT_MASK_CON1_CLR      0x1a66
#define MT6358_LDO_TOP_INT_STATUS0            0x1a68
#define MT6358_LDO_TOP_INT_STATUS1            0x1a6a
#define MT6358_LDO_TOP_INT_RAW_STATUS0        0x1a6c
#define MT6358_LDO_TOP_INT_RAW_STATUS1        0x1a6e
#define MT6358_LDO_TEST_CON0                  0x1a70
#define MT6358_LDO_TOP_WDT_CON0               0x1a72
#define MT6358_LDO_TOP_RSV_CON0               0x1a74
#define MT6358_LDO_TOP_RSV_CON1               0x1a76
#define MT6358_LDO_OCFB0                      0x1a78
#define MT6358_LDO_LP_PROTECTION              0x1a7a
#define MT6358_LDO_DUMMY_LOAD_GATED           0x1a7c
#define MT6358_LDO_GON0_DSN_ID                0x1a80
#define MT6358_LDO_GON0_DSN_REV0              0x1a82
#define MT6358_LDO_GON0_DSN_DBI               0x1a84
#define MT6358_LDO_GON0_DSN_DXI               0x1a86
#define MT6358_LDO_VXO22_CON0                 0x1a88
#define MT6358_LDO_VXO22_OP_EN                0x1a8a
#define MT6358_LDO_VXO22_OP_EN_SET            0x1a8c
#define MT6358_LDO_VXO22_OP_EN_CLR            0x1a8e
#define MT6358_LDO_VXO22_OP_CFG               0x1a90
#define MT6358_LDO_VXO22_OP_CFG_SET           0x1a92
#define MT6358_LDO_VXO22_OP_CFG_CLR           0x1a94
#define MT6358_LDO_VXO22_CON1                 0x1a96
#define MT6358_LDO_VXO22_CON2                 0x1a98
#define MT6358_LDO_VXO22_CON3                 0x1a9a
#define MT6358_LDO_VA12_CON0                  0x1a9c
#define MT6358_LDO_VA12_OP_EN                 0x1a9e
#define MT6358_LDO_VA12_OP_EN_SET             0x1aa0
#define MT6358_LDO_VA12_OP_EN_CLR             0x1aa2
#define MT6358_LDO_VA12_OP_CFG                0x1aa4
#define MT6358_LDO_VA12_OP_CFG_SET            0x1aa6
#define MT6358_LDO_VA12_OP_CFG_CLR            0x1aa8
#define MT6358_LDO_VA12_CON1                  0x1aaa
#define MT6358_LDO_VA12_CON2                  0x1aac
#define MT6358_LDO_VA12_CON3                  0x1aae
#define MT6358_LDO_VAUX18_CON0                0x1ab0
#define MT6358_LDO_VAUX18_OP_EN               0x1ab2
#define MT6358_LDO_VAUX18_OP_EN_SET           0x1ab4
#define MT6358_LDO_VAUX18_OP_EN_CLR           0x1ab6
#define MT6358_LDO_VAUX18_OP_CFG              0x1ab8
#define MT6358_LDO_VAUX18_OP_CFG_SET          0x1aba
#define MT6358_LDO_VAUX18_OP_CFG_CLR          0x1abc
#define MT6358_LDO_VAUX18_CON1                0x1abe
#define MT6358_LDO_VAUX18_CON2                0x1ac0
#define MT6358_LDO_VAUX18_CON3                0x1ac2
#define MT6358_LDO_VAUD28_CON0                0x1ac4
#define MT6358_LDO_VAUD28_OP_EN               0x1ac6
#define MT6358_LDO_VAUD28_OP_EN_SET           0x1ac8
#define MT6358_LDO_VAUD28_OP_EN_CLR           0x1aca
#define MT6358_LDO_VAUD28_OP_CFG              0x1acc
#define MT6358_LDO_VAUD28_OP_CFG_SET          0x1ace
#define MT6358_LDO_VAUD28_OP_CFG_CLR          0x1ad0
#define MT6358_LDO_VAUD28_CON1                0x1ad2
#define MT6358_LDO_VAUD28_CON2                0x1ad4
#define MT6358_LDO_VAUD28_CON3                0x1ad6
#define MT6358_LDO_VIO28_CON0                 0x1ad8
#define MT6358_LDO_VIO28_OP_EN                0x1ada
#define MT6358_LDO_VIO28_OP_EN_SET            0x1adc
#define MT6358_LDO_VIO28_OP_EN_CLR            0x1ade
#define MT6358_LDO_VIO28_OP_CFG               0x1ae0
#define MT6358_LDO_VIO28_OP_CFG_SET           0x1ae2
#define MT6358_LDO_VIO28_OP_CFG_CLR           0x1ae4
#define MT6358_LDO_VIO28_CON1                 0x1ae6
#define MT6358_LDO_VIO28_CON2                 0x1ae8
#define MT6358_LDO_VIO28_CON3                 0x1aea
#define MT6358_LDO_VIO18_CON0                 0x1aec
#define MT6358_LDO_VIO18_OP_EN                0x1aee
#define MT6358_LDO_VIO18_OP_EN_SET            0x1af0
#define MT6358_LDO_VIO18_OP_EN_CLR            0x1af2
#define MT6358_LDO_VIO18_OP_CFG               0x1af4
#define MT6358_LDO_VIO18_OP_CFG_SET           0x1af6
#define MT6358_LDO_VIO18_OP_CFG_CLR           0x1af8
#define MT6358_LDO_VIO18_CON1                 0x1afa
#define MT6358_LDO_VIO18_CON2                 0x1afc
#define MT6358_LDO_VIO18_CON3                 0x1afe
#define MT6358_LDO_GON1_DSN_ID                0x1b00
#define MT6358_LDO_GON1_DSN_REV0              0x1b02
#define MT6358_LDO_GON1_DSN_DBI               0x1b04
#define MT6358_LDO_GON1_DSN_DXI               0x1b06
#define MT6358_LDO_VDRAM2_CON0                0x1b08
#define MT6358_LDO_VDRAM2_OP_EN               0x1b0a
#define MT6358_LDO_VDRAM2_OP_EN_SET           0x1b0c
#define MT6358_LDO_VDRAM2_OP_EN_CLR           0x1b0e
#define MT6358_LDO_VDRAM2_OP_CFG              0x1b10
#define MT6358_LDO_VDRAM2_OP_CFG_SET          0x1b12
#define MT6358_LDO_VDRAM2_OP_CFG_CLR          0x1b14
#define MT6358_LDO_VDRAM2_CON1                0x1b16
#define MT6358_LDO_VDRAM2_CON2                0x1b18
#define MT6358_LDO_VDRAM2_CON3                0x1b1a
#define MT6358_LDO_VEMC_CON0                  0x1b1c
#define MT6358_LDO_VEMC_OP_EN                 0x1b1e
#define MT6358_LDO_VEMC_OP_EN_SET             0x1b20
#define MT6358_LDO_VEMC_OP_EN_CLR             0x1b22
#define MT6358_LDO_VEMC_OP_CFG                0x1b24
#define MT6358_LDO_VEMC_OP_CFG_SET            0x1b26
#define MT6358_LDO_VEMC_OP_CFG_CLR            0x1b28
#define MT6358_LDO_VEMC_CON1                  0x1b2a
#define MT6358_LDO_VEMC_CON2                  0x1b2c
#define MT6358_LDO_VEMC_CON3                  0x1b2e
#define MT6358_LDO_VUSB_CON0_0                0x1b30
#define MT6358_LDO_VUSB_OP_EN                 0x1b32
#define MT6358_LDO_VUSB_OP_EN_SET             0x1b34
#define MT6358_LDO_VUSB_OP_EN_CLR             0x1b36
#define MT6358_LDO_VUSB_OP_CFG                0x1b38
#define MT6358_LDO_VUSB_OP_CFG_SET            0x1b3a
#define MT6358_LDO_VUSB_OP_CFG_CLR            0x1b3c
#define MT6358_LDO_VUSB_CON0_1                0x1b3e
#define MT6358_LDO_VUSB_CON1                  0x1b40
#define MT6358_LDO_VUSB_CON2                  0x1b42
#define MT6358_LDO_VUSB_CON3                  0x1b44
#define MT6358_LDO_VSRAM_PROC11_CON0          0x1b46
#define MT6358_LDO_VSRAM_PROC11_CON2          0x1b48
#define MT6358_LDO_VSRAM_PROC11_CFG0          0x1b4a
#define MT6358_LDO_VSRAM_PROC11_CFG1          0x1b4c
#define MT6358_LDO_VSRAM_PROC11_OP_EN         0x1b4e
#define MT6358_LDO_VSRAM_PROC11_OP_EN_SET     0x1b50
#define MT6358_LDO_VSRAM_PROC11_OP_EN_CLR     0x1b52
#define MT6358_LDO_VSRAM_PROC11_OP_CFG        0x1b54
#define MT6358_LDO_VSRAM_PROC11_OP_CFG_SET    0x1b56
#define MT6358_LDO_VSRAM_PROC11_OP_CFG_CLR    0x1b58
#define MT6358_LDO_VSRAM_PROC11_CON3          0x1b5a
#define MT6358_LDO_VSRAM_PROC11_CON4          0x1b5c
#define MT6358_LDO_VSRAM_PROC11_CON5          0x1b5e
#define MT6358_LDO_VSRAM_PROC11_DBG0          0x1b60
#define MT6358_LDO_VSRAM_PROC11_DBG1          0x1b62
#define MT6358_LDO_VSRAM_PROC11_TRACKING_CON0 0x1b64
#define MT6358_LDO_VSRAM_PROC11_TRACKING_CON1 0x1b66
#define MT6358_LDO_VSRAM_PROC11_TRACKING_CON2 0x1b68
#define MT6358_LDO_VSRAM_PROC11_TRACKING_CON3 0x1b6a
#define MT6358_LDO_VSRAM_PROC12_TRACKING_CON0 0x1b6c
#define MT6358_LDO_VSRAM_PROC12_TRACKING_CON1 0x1b6e
#define MT6358_LDO_VSRAM_PROC12_TRACKING_CON2 0x1b70
#define MT6358_LDO_VSRAM_PROC12_TRACKING_CON3 0x1b72
#define MT6358_LDO_VSRAM_WAKEUP_CON0          0x1b74
#define MT6358_LDO_GON1_ELR_NUM               0x1b76
#define MT6358_LDO_VDRAM2_ELR0                0x1b78
#define MT6358_LDO_VDRAM2_ELR1                0x1b7a
#define MT6358_LDO_STRUP_ELR0                 0x1b7c
#define MT6358_LDO_GON2_DSN_ID                0x1b80
#define MT6358_LDO_GON2_DSN_REV0              0x1b82
#define MT6358_LDO_GON2_DSN_DBI               0x1b84
#define MT6358_LDO_GON2_DSN_DXI               0x1b86
#define MT6358_LDO_VSRAM_PROC12_CON0          0x1b88
#define MT6358_LDO_VSRAM_PROC12_CON2          0x1b8a
#define MT6358_LDO_VSRAM_PROC12_CFG0          0x1b8c
#define MT6358_LDO_VSRAM_PROC12_CFG1          0x1b8e
#define MT6358_LDO_VSRAM_PROC12_OP_EN         0x1b90
#define MT6358_LDO_VSRAM_PROC12_OP_EN_SET     0x1b92
#define MT6358_LDO_VSRAM_PROC12_OP_EN_CLR     0x1b94
#define MT6358_LDO_VSRAM_PROC12_OP_CFG        0x1b96
#define MT6358_LDO_VSRAM_PROC12_OP_CFG_SET    0x1b98
#define MT6358_LDO_VSRAM_PROC12_OP_CFG_CLR    0x1b9a
#define MT6358_LDO_VSRAM_PROC12_CON3          0x1b9c
#define MT6358_LDO_VSRAM_PROC12_CON4          0x1b9e
#define MT6358_LDO_VSRAM_PROC12_CON5          0x1ba0
#define MT6358_LDO_VSRAM_PROC12_DBG0          0x1ba2
#define MT6358_LDO_VSRAM_PROC12_DBG1          0x1ba4
#define MT6358_LDO_VSRAM_OTHERS_CON0          0x1ba6
#define MT6358_LDO_VSRAM_OTHERS_CON2          0x1ba8
#define MT6358_LDO_VSRAM_OTHERS_CFG0          0x1baa
#define MT6358_LDO_VSRAM_OTHERS_CFG1          0x1bac
#define MT6358_LDO_VSRAM_OTHERS_OP_EN         0x1bae
#define MT6358_LDO_VSRAM_OTHERS_OP_EN_SET     0x1bb0
#define MT6358_LDO_VSRAM_OTHERS_OP_EN_CLR     0x1bb2
#define MT6358_LDO_VSRAM_OTHERS_OP_CFG        0x1bb4
#define MT6358_LDO_VSRAM_OTHERS_OP_CFG_SET    0x1bb6
#define MT6358_LDO_VSRAM_OTHERS_OP_CFG_CLR    0x1bb8
#define MT6358_LDO_VSRAM_OTHERS_CON3          0x1bba
#define MT6358_LDO_VSRAM_OTHERS_CON4          0x1bbc
#define MT6358_LDO_VSRAM_OTHERS_CON5          0x1bbe
#define MT6358_LDO_VSRAM_OTHERS_DBG0          0x1bc0
#define MT6358_LDO_VSRAM_OTHERS_DBG1          0x1bc2
#define MT6358_LDO_VSRAM_OTHERS_SSHUB_CON0    0x1bc4
#define MT6358_LDO_VSRAM_OTHERS_SSHUB_CON1    0x1bc6
#define MT6358_LDO_VSRAM_GPU_CON0             0x1bc8
#define MT6358_LDO_VSRAM_GPU_CON2             0x1bca
#define MT6358_LDO_VSRAM_GPU_CFG0             0x1bcc
#define MT6358_LDO_VSRAM_GPU_CFG1             0x1bce
#define MT6358_LDO_VSRAM_GPU_OP_EN            0x1bd0
#define MT6358_LDO_VSRAM_GPU_OP_EN_SET        0x1bd2
#define MT6358_LDO_VSRAM_GPU_OP_EN_CLR        0x1bd4
#define MT6358_LDO_VSRAM_GPU_OP_CFG           0x1bd6
#define MT6358_LDO_VSRAM_GPU_OP_CFG_SET       0x1bd8
#define MT6358_LDO_VSRAM_GPU_OP_CFG_CLR       0x1bda
#define MT6358_LDO_VSRAM_GPU_CON3             0x1bdc
#define MT6358_LDO_VSRAM_GPU_CON4             0x1bde
#define MT6358_LDO_VSRAM_GPU_CON5             0x1be0
#define MT6358_LDO_VSRAM_GPU_DBG0             0x1be2
#define MT6358_LDO_VSRAM_GPU_DBG1             0x1be4
#define MT6358_LDO_VSRAM_R2R_PDN_DIS          0x1be6
#define MT6358_LDO_VSRAM_WDT_DBG0             0x1be8
#define MT6358_LDO_VSRAM_WDT_DBG1             0x1bea
#define MT6358_LDO_GON2_ELR_NUM               0x1bec
#define MT6358_LDO_VSRAM_CON0                 0x1bee
#define MT6358_LDO_VSRAM_CON1                 0x1bf0
#define MT6358_LDO_VSRAM_CON2                 0x1bf2
#define MT6358_LDO_VSRAM_CON3                 0x1bf4
#define MT6358_LDO_VSRAM_CON4                 0x1bf6
#define MT6358_LDO_GOFF0_DSN_ID               0x1c00
#define MT6358_LDO_GOFF0_DSN_REV0             0x1c02
#define MT6358_LDO_GOFF0_DSN_DBI              0x1c04
#define MT6358_LDO_GOFF0_DSN_DXI              0x1c06
#define MT6358_LDO_VFE28_CON0                 0x1c08
#define MT6358_LDO_VFE28_OP_EN                0x1c0a
#define MT6358_LDO_VFE28_OP_EN_SET            0x1c0c
#define MT6358_LDO_VFE28_OP_EN_CLR            0x1c0e
#define MT6358_LDO_VFE28_OP_CFG               0x1c10
#define MT6358_LDO_VFE28_OP_CFG_SET           0x1c12
#define MT6358_LDO_VFE28_OP_CFG_CLR           0x1c14
#define MT6358_LDO_VFE28_CON1                 0x1c16
#define MT6358_LDO_VFE28_CON2                 0x1c18
#define MT6358_LDO_VFE28_CON3                 0x1c1a
#define MT6358_LDO_VRF18_CON0                 0x1c1c
#define MT6358_LDO_VRF18_OP_EN                0x1c1e
#define MT6358_LDO_VRF18_OP_EN_SET            0x1c20
#define MT6358_LDO_VRF18_OP_EN_CLR            0x1c22
#define MT6358_LDO_VRF18_OP_CFG               0x1c24
#define MT6358_LDO_VRF18_OP_CFG_SET           0x1c26
#define MT6358_LDO_VRF18_OP_CFG_CLR           0x1c28
#define MT6358_LDO_VRF18_CON1                 0x1c2a
#define MT6358_LDO_VRF18_CON2                 0x1c2c
#define MT6358_LDO_VRF18_CON3                 0x1c2e
#define MT6358_LDO_VRF12_CON0                 0x1c30
#define MT6358_LDO_VRF12_OP_EN                0x1c32
#define MT6358_LDO_VRF12_OP_EN_SET            0x1c34
#define MT6358_LDO_VRF12_OP_EN_CLR            0x1c36
#define MT6358_LDO_VRF12_OP_CFG               0x1c38
#define MT6358_LDO_VRF12_OP_CFG_SET           0x1c3a
#define MT6358_LDO_VRF12_OP_CFG_CLR           0x1c3c
#define MT6358_LDO_VRF12_CON1                 0x1c3e
#define MT6358_LDO_VRF12_CON2                 0x1c40
#define MT6358_LDO_VRF12_CON3                 0x1c42
#define MT6358_LDO_VEFUSE_CON0                0x1c44
#define MT6358_LDO_VEFUSE_OP_EN               0x1c46
#define MT6358_LDO_VEFUSE_OP_EN_SET           0x1c48
#define MT6358_LDO_VEFUSE_OP_EN_CLR           0x1c4a
#define MT6358_LDO_VEFUSE_OP_CFG              0x1c4c
#define MT6358_LDO_VEFUSE_OP_CFG_SET          0x1c4e
#define MT6358_LDO_VEFUSE_OP_CFG_CLR          0x1c50
#define MT6358_LDO_VEFUSE_CON1                0x1c52
#define MT6358_LDO_VEFUSE_CON2                0x1c54
#define MT6358_LDO_VEFUSE_CON3                0x1c56
#define MT6358_LDO_VCN18_CON0                 0x1c58
#define MT6358_LDO_VCN18_OP_EN                0x1c5a
#define MT6358_LDO_VCN18_OP_EN_SET            0x1c5c
#define MT6358_LDO_VCN18_OP_EN_CLR            0x1c5e
#define MT6358_LDO_VCN18_OP_CFG               0x1c60
#define MT6358_LDO_VCN18_OP_CFG_SET           0x1c62
#define MT6358_LDO_VCN18_OP_CFG_CLR           0x1c64
#define MT6358_LDO_VCN18_CON1                 0x1c66
#define MT6358_LDO_VCN18_CON2                 0x1c68
#define MT6358_LDO_VCN18_CON3                 0x1c6a
#define MT6358_LDO_VCAMA1_CON0                0x1c6c
#define MT6358_LDO_VCAMA1_OP_EN               0x1c6e
#define MT6358_LDO_VCAMA1_OP_EN_SET           0x1c70
#define MT6358_LDO_VCAMA1_OP_EN_CLR           0x1c72
#define MT6358_LDO_VCAMA1_OP_CFG              0x1c74
#define MT6358_LDO_VCAMA1_OP_CFG_SET          0x1c76
#define MT6358_LDO_VCAMA1_OP_CFG_CLR          0x1c78
#define MT6358_LDO_VCAMA1_CON1                0x1c7a
#define MT6358_LDO_VCAMA1_CON2                0x1c7c
#define MT6358_LDO_VCAMA1_CON3                0x1c7e
#define MT6358_LDO_GOFF1_DSN_ID               0x1c80
#define MT6358_LDO_GOFF1_DSN_REV0             0x1c82
#define MT6358_LDO_GOFF1_DSN_DBI              0x1c84
#define MT6358_LDO_GOFF1_DSN_DXI              0x1c86
#define MT6358_LDO_VCAMA2_CON0                0x1c88
#define MT6358_LDO_VCAMA2_OP_EN               0x1c8a
#define MT6358_LDO_VCAMA2_OP_EN_SET           0x1c8c
#define MT6358_LDO_VCAMA2_OP_EN_CLR           0x1c8e
#define MT6358_LDO_VCAMA2_OP_CFG              0x1c90
#define MT6358_LDO_VCAMA2_OP_CFG_SET          0x1c92
#define MT6358_LDO_VCAMA2_OP_CFG_CLR          0x1c94
#define MT6358_LDO_VCAMA2_CON1                0x1c96
#define MT6358_LDO_VCAMA2_CON2                0x1c98
#define MT6358_LDO_VCAMA2_CON3                0x1c9a
#define MT6358_LDO_VCAMD_CON0                 0x1c9c
#define MT6358_LDO_VCAMD_OP_EN                0x1c9e
#define MT6358_LDO_VCAMD_OP_EN_SET            0x1ca0
#define MT6358_LDO_VCAMD_OP_EN_CLR            0x1ca2
#define MT6358_LDO_VCAMD_OP_CFG               0x1ca4
#define MT6358_LDO_VCAMD_OP_CFG_SET           0x1ca6
#define MT6358_LDO_VCAMD_OP_CFG_CLR           0x1ca8
#define MT6358_LDO_VCAMD_CON1                 0x1caa
#define MT6358_LDO_VCAMD_CON2                 0x1cac
#define MT6358_LDO_VCAMD_CON3                 0x1cae
#define MT6358_LDO_VCAMIO_CON0                0x1cb0
#define MT6358_LDO_VCAMIO_OP_EN               0x1cb2
#define MT6358_LDO_VCAMIO_OP_EN_SET           0x1cb4
#define MT6358_LDO_VCAMIO_OP_EN_CLR           0x1cb6
#define MT6358_LDO_VCAMIO_OP_CFG              0x1cb8
#define MT6358_LDO_VCAMIO_OP_CFG_SET          0x1cba
#define MT6358_LDO_VCAMIO_OP_CFG_CLR          0x1cbc
#define MT6358_LDO_VCAMIO_CON1                0x1cbe
#define MT6358_LDO_VCAMIO_CON2                0x1cc0
#define MT6358_LDO_VCAMIO_CON3                0x1cc2
#define MT6358_LDO_VMC_CON0                   0x1cc4
#define MT6358_LDO_VMC_OP_EN                  0x1cc6
#define MT6358_LDO_VMC_OP_EN_SET              0x1cc8
#define MT6358_LDO_VMC_OP_EN_CLR              0x1cca
#define MT6358_LDO_VMC_OP_CFG                 0x1ccc
#define MT6358_LDO_VMC_OP_CFG_SET             0x1cce
#define MT6358_LDO_VMC_OP_CFG_CLR             0x1cd0
#define MT6358_LDO_VMC_CON1                   0x1cd2
#define MT6358_LDO_VMC_CON2                   0x1cd4
#define MT6358_LDO_VMC_CON3                   0x1cd6
#define MT6358_LDO_VMCH_CON0                  0x1cd8
#define MT6358_LDO_VMCH_OP_EN                 0x1cda
#define MT6358_LDO_VMCH_OP_EN_SET             0x1cdc
#define MT6358_LDO_VMCH_OP_EN_CLR             0x1cde
#define MT6358_LDO_VMCH_OP_CFG                0x1ce0
#define MT6358_LDO_VMCH_OP_CFG_SET            0x1ce2
#define MT6358_LDO_VMCH_OP_CFG_CLR            0x1ce4
#define MT6358_LDO_VMCH_CON1                  0x1ce6
#define MT6358_LDO_VMCH_CON2                  0x1ce8
#define MT6358_LDO_VMCH_CON3                  0x1cea
#define MT6358_LDO_GOFF2_DSN_ID               0x1d00
#define MT6358_LDO_GOFF2_DSN_REV0             0x1d02
#define MT6358_LDO_GOFF2_DSN_DBI              0x1d04
#define MT6358_LDO_GOFF2_DSN_DXI              0x1d06
#define MT6358_LDO_VIBR_CON0                  0x1d08
#define MT6358_LDO_VIBR_OP_EN                 0x1d0a
#define MT6358_LDO_VIBR_OP_EN_SET             0x1d0c
#define MT6358_LDO_VIBR_OP_EN_CLR             0x1d0e
#define MT6358_LDO_VIBR_OP_CFG                0x1d10
#define MT6358_LDO_VIBR_OP_CFG_SET            0x1d12
#define MT6358_LDO_VIBR_OP_CFG_CLR            0x1d14
#define MT6358_LDO_VIBR_CON1                  0x1d16
#define MT6358_LDO_VIBR_CON2                  0x1d18
#define MT6358_LDO_VIBR_CON3                  0x1d1a
#define MT6358_LDO_VCN33_CON0_0               0x1d1c
#define MT6358_LDO_VCN33_OP_EN                0x1d1e
#define MT6358_LDO_VCN33_OP_EN_SET            0x1d20
#define MT6358_LDO_VCN33_OP_EN_CLR            0x1d22
#define MT6358_LDO_VCN33_OP_CFG               0x1d24
#define MT6358_LDO_VCN33_OP_CFG_SET           0x1d26
#define MT6358_LDO_VCN33_OP_CFG_CLR           0x1d28
#define MT6358_LDO_VCN33_CON0_1               0x1d2a
#define MT6358_LDO_VCN33_CON1                 0x1d2c
#define MT6358_LDO_VCN33_BT_CON1              MT6358_LDO_VCN33_CON1
#define MT6358_LDO_VCN33_WIFI_CON1            MT6358_LDO_VCN33_CON1
#define MT6358_LDO_VCN33_CON2                 0x1d2e
#define MT6358_LDO_VCN33_CON3                 0x1d30
#define MT6358_LDO_VLDO28_CON0_0              0x1d32
#define MT6358_LDO_VLDO28_OP_EN               0x1d34
#define MT6358_LDO_VLDO28_OP_EN_SET           0x1d36
#define MT6358_LDO_VLDO28_OP_EN_CLR           0x1d38
#define MT6358_LDO_VLDO28_OP_CFG              0x1d3a
#define MT6358_LDO_VLDO28_OP_CFG_SET          0x1d3c
#define MT6358_LDO_VLDO28_OP_CFG_CLR          0x1d3e
#define MT6358_LDO_VLDO28_CON0_1              0x1d40
#define MT6358_LDO_VLDO28_CON1                0x1d42
#define MT6358_LDO_VLDO28_CON2                0x1d44
#define MT6358_LDO_VLDO28_CON3                0x1d46
#define MT6358_LDO_VSIM1_CON0                 0x1d48
#define MT6358_LDO_VSIM1_OP_EN                0x1d4a
#define MT6358_LDO_VSIM1_OP_EN_SET            0x1d4c
#define MT6358_LDO_VSIM1_OP_EN_CLR            0x1d4e
#define MT6358_LDO_VSIM1_OP_CFG               0x1d50
#define MT6358_LDO_VSIM1_OP_CFG_SET           0x1d52
#define MT6358_LDO_VSIM1_OP_CFG_CLR           0x1d54
#define MT6358_LDO_VSIM1_CON1                 0x1d56
#define MT6358_LDO_VSIM1_CON2                 0x1d58
#define MT6358_LDO_VSIM1_CON3                 0x1d5a
#define MT6358_LDO_VSIM2_CON0                 0x1d5c
#define MT6358_LDO_VSIM2_OP_EN                0x1d5e
#define MT6358_LDO_VSIM2_OP_EN_SET            0x1d60
#define MT6358_LDO_VSIM2_OP_EN_CLR            0x1d62
#define MT6358_LDO_VSIM2_OP_CFG               0x1d64
#define MT6358_LDO_VSIM2_OP_CFG_SET           0x1d66
#define MT6358_LDO_VSIM2_OP_CFG_CLR           0x1d68
#define MT6358_LDO_VSIM2_CON1                 0x1d6a
#define MT6358_LDO_VSIM2_CON2                 0x1d6c
#define MT6358_LDO_VSIM2_CON3                 0x1d6e
#define MT6358_LDO_VMCH_EINT_SD_CFG           0x1d70
#define MT6358_LDO_VSIM1_EINT_SD_CFG          0x1d72
#define MT6358_LDO_VSIM2_EINT_SD_CFG          0x1d74
#define MT6358_LDO_GOFF2_RSV_CON0             0x1d76
#define MT6358_LDO_GOFF2_RSV_CON1             0x1d78
#define MT6358_LDO_GOFF3_DSN_ID               0x1d80
#define MT6358_LDO_GOFF3_DSN_REV0             0x1d82
#define MT6358_LDO_GOFF3_DSN_DBI              0x1d84
#define MT6358_LDO_GOFF3_DSN_DXI              0x1d86
#define MT6358_LDO_VCN28_CON0                 0x1d88
#define MT6358_LDO_VCN28_OP_EN                0x1d8a
#define MT6358_LDO_VCN28_OP_EN_SET            0x1d8c
#define MT6358_LDO_VCN28_OP_EN_CLR            0x1d8e
#define MT6358_LDO_VCN28_OP_CFG               0x1d90
#define MT6358_LDO_VCN28_OP_CFG_SET           0x1d92
#define MT6358_LDO_VCN28_OP_CFG_CLR           0x1d94
#define MT6358_LDO_VCN28_CON1                 0x1d96
#define MT6358_LDO_VCN28_CON2                 0x1d98
#define MT6358_LDO_VCN28_CON3                 0x1d9a
#define MT6358_VRTC28_CON0                    0x1d9c
#define MT6358_LDO_VBIF28_CON0                0x1d9e
#define MT6358_LDO_VBIF28_OP_EN               0x1da0
#define MT6358_LDO_VBIF28_OP_EN_SET           0x1da2
#define MT6358_LDO_VBIF28_OP_EN_CLR           0x1da4
#define MT6358_LDO_VBIF28_OP_CFG              0x1da6
#define MT6358_LDO_VBIF28_OP_CFG_SET          0x1da8
#define MT6358_LDO_VBIF28_OP_CFG_CLR          0x1daa
#define MT6358_LDO_VBIF28_CON1                0x1dac
#define MT6358_LDO_VBIF28_CON2                0x1dae
#define MT6358_LDO_VBIF28_CON3                0x1db0
#define MT6358_LDO_GOFF3_RSV_CON0             0x1db2
#define MT6358_LDO_GOFF3_RSV_CON1             0x1db4
#define MT6358_LDO_ANA0_DSN_ID                0x1e00
#define MT6358_LDO_ANA0_DSN_REV0              0x1e02
#define MT6358_LDO_ANA0_DSN_DBI               0x1e04
#define MT6358_LDO_ANA0_DSN_FPI               0x1e06
#define MT6358_VCAMA1_ANA_CON0                0x1e08
#define MT6358_VCAMA1_ANA_CON1                0x1e0a
#define MT6358_VCAMA2_ANA_CON0                0x1e0c
#define MT6358_VCAMA2_ANA_CON1                0x1e0e
#define MT6358_VFE28_ANA_CON0                 0x1e10
#define MT6358_VFE28_ANA_CON1                 0x1e12
#define MT6358_VCN28_ANA_CON0                 0x1e14
#define MT6358_VCN28_ANA_CON1                 0x1e16
#define MT6358_VBIF28_ANA_CON0                0x1e18
#define MT6358_VBIF28_ANA_CON1                0x1e1a
#define MT6358_VAUD28_ANA_CON0                0x1e1c
#define MT6358_VAUD28_ANA_CON1                0x1e1e
#define MT6358_VAUX18_ANA_CON0                0x1e20
#define MT6358_VAUX18_ANA_CON1                0x1e22
#define MT6358_VXO22_ANA_CON0                 0x1e24
#define MT6358_VXO22_ANA_CON1                 0x1e26
#define MT6358_VCN33_ANA_CON0                 0x1e28
#define MT6358_VCN33_ANA_CON1                 0x1e2a
#define MT6358_VSIM1_ANA_CON0                 0x1e2c
#define MT6358_VSIM1_ANA_CON1                 0x1e2e
#define MT6358_VSIM2_ANA_CON0                 0x1e30
#define MT6358_VSIM2_ANA_CON1                 0x1e32
#define MT6358_VUSB_ANA_CON0                  0x1e34
#define MT6358_VUSB_ANA_CON1                  0x1e36
#define MT6358_VEMC_ANA_CON0                  0x1e38
#define MT6358_VEMC_ANA_CON1                  0x1e3a
#define MT6358_VLDO28_ANA_CON0                0x1e3c
#define MT6358_VLDO28_ANA_CON1                0x1e3e
#define MT6358_VIO28_ANA_CON0                 0x1e40
#define MT6358_VIO28_ANA_CON1                 0x1e42
#define MT6358_VIBR_ANA_CON0                  0x1e44
#define MT6358_VIBR_ANA_CON1                  0x1e46
#define MT6358_VMCH_ANA_CON0                  0x1e48
#define MT6358_VMCH_ANA_CON1                  0x1e4a
#define MT6358_VMC_ANA_CON0                   0x1e4c
#define MT6358_VMC_ANA_CON1                   0x1e4e
#define MT6358_LDO_ANA0_ELR_NUM               0x1e50
#define MT6358_VCAMA1_ELR_0                   0x1e52
#define MT6358_VCAMA2_ELR_0                   0x1e54
#define MT6358_VFE28_ELR_0                    0x1e56
#define MT6358_VCN28_ELR_0                    0x1e58
#define MT6358_VBIF28_ELR_0                   0x1e5a
#define MT6358_VAUD28_ELR_0                   0x1e5c
#define MT6358_VAUX18_ELR_0                   0x1e5e
#define MT6358_VXO22_ELR_0                    0x1e60
#define MT6358_VCN33_ELR_0                    0x1e62
#define MT6358_VSIM1_ELR_0                    0x1e64
#define MT6358_VSIM2_ELR_0                    0x1e66
#define MT6358_VUSB_ELR_0                     0x1e68
#define MT6358_VEMC_ELR_0                     0x1e6a
#define MT6358_VLDO28_ELR_0                   0x1e6c
#define MT6358_VIO28_ELR_0                    0x1e6e
#define MT6358_VIBR_ELR_0                     0x1e70
#define MT6358_VMCH_ELR_0                     0x1e72
#define MT6358_VMC_ELR_0                      0x1e74
#define MT6358_LDO_ANA1_DSN_ID                0x1e80
#define MT6358_LDO_ANA1_DSN_REV0              0x1e82
#define MT6358_LDO_ANA1_DSN_DBI               0x1e84
#define MT6358_LDO_ANA1_DSN_FPI               0x1e86
#define MT6358_VRF18_ANA_CON0                 0x1e88
#define MT6358_VRF18_ANA_CON1                 0x1e8a
#define MT6358_VCN18_ANA_CON0                 0x1e8c
#define MT6358_VCN18_ANA_CON1                 0x1e8e
#define MT6358_VCAMIO_ANA_CON0                0x1e90
#define MT6358_VCAMIO_ANA_CON1                0x1e92
#define MT6358_VIO18_ANA_CON0                 0x1e94
#define MT6358_VIO18_ANA_CON1                 0x1e96
#define MT6358_VEFUSE_ANA_CON0                0x1e98
#define MT6358_VEFUSE_ANA_CON1                0x1e9a
#define MT6358_VRF12_ANA_CON0                 0x1e9c
#define MT6358_VRF12_ANA_CON1                 0x1e9e
#define MT6358_VSRAM_PROC11_ANA_CON0          0x1ea0
#define MT6358_VSRAM_PROC11_ANA_CON1          0x1ea2
#define MT6358_VSRAM_PROC12_ANA_CON0          0x1ea4
#define MT6358_VSRAM_OTHERS_ANA_CON0          0x1ea6
#define MT6358_VSRAM_GPU_ANA_CON0             0x1ea8
#define MT6358_VDRAM2_ANA_CON0                0x1eaa
#define MT6358_VDRAM2_ANA_CON1                0x1eac
#define MT6358_VCAMD_ANA_CON0                 0x1eae
#define MT6358_VCAMD_ANA_CON1                 0x1eb0
#define MT6358_VA12_ANA_CON0                  0x1eb2
#define MT6358_VA12_ANA_CON1                  0x1eb4
#define MT6358_LDO_ANA1_ELR_NUM               0x1eb6
#define MT6358_VRF18_ELR_0                    0x1eb8
#define MT6358_VCN18_ELR_0                    0x1eba
#define MT6358_VCAMIO_ELR_0                   0x1ebc
#define MT6358_VIO18_ELR_0                    0x1ebe
#define MT6358_VEFUSE_ELR_0                   0x1ec0
#define MT6358_VRF12_ELR_0                    0x1ec2
#define MT6358_VDRAM2_ELR_0                   0x1ec4
#define MT6358_VCAMD_ELR_0                    0x1ec6
#define MT6358_VA12_ELR_0                     0x1ec8
#define MT6358_VRTC28_ELR_0                   0x1eca
#define MT6358_DUMMYLOAD_DSN_ID               0x1f00
#define MT6358_DUMMYLOAD_DSN_REV0             0x1f02
#define MT6358_DUMMYLOAD_DSN_DBI              0x1f04
#define MT6358_DUMMYLOAD_DSN_FPI              0x1f06
#define MT6358_DUMMYLOAD_ANA_CON0             0x1f08
#define MT6358_ISINK0_CON1                    0x1f0a
#define MT6358_ISINK1_CON1                    0x1f0c
#define MT6358_ISINK_ANA1_SMPL                0x1f0e
#define MT6358_ISINK_EN_CTRL_SMPL             0x1f10
#define MT6358_DUMMYLOAD_ELR_NUM              0x1f12
#define MT6358_DUMMYLOAD_ELR_0                0x1f14
#define MT6358_AUD_TOP_ID                     0x2200
#define MT6358_AUD_TOP_REV0                   0x2202
#define MT6358_AUD_TOP_DBI                    0x2204
#define MT6358_AUD_TOP_DXI                    0x2206
#define MT6358_AUD_TOP_CKPDN_TPM0             0x2208
#define MT6358_AUD_TOP_CKPDN_TPM1             0x220a
#define MT6358_AUD_TOP_CKPDN_CON0             0x220c
#define MT6358_AUD_TOP_CKPDN_CON0_SET         0x220e
#define MT6358_AUD_TOP_CKPDN_CON0_CLR         0x2210
#define MT6358_AUD_TOP_CKSEL_CON0             0x2212
#define MT6358_AUD_TOP_CKSEL_CON0_SET         0x2214
#define MT6358_AUD_TOP_CKSEL_CON0_CLR         0x2216
#define MT6358_AUD_TOP_CKTST_CON0             0x2218
#define MT6358_AUD_TOP_CLK_HWEN_CON0          0x221a
#define MT6358_AUD_TOP_CLK_HWEN_CON0_SET      0x221c
#define MT6358_AUD_TOP_CLK_HWEN_CON0_CLR      0x221e
#define MT6358_AUD_TOP_RST_CON0               0x2220
#define MT6358_AUD_TOP_RST_CON0_SET           0x2222
#define MT6358_AUD_TOP_RST_CON0_CLR           0x2224
#define MT6358_AUD_TOP_RST_BANK_CON0          0x2226
#define MT6358_AUD_TOP_INT_CON0               0x2228
#define MT6358_AUD_TOP_INT_CON0_SET           0x222a
#define MT6358_AUD_TOP_INT_CON0_CLR           0x222c
#define MT6358_AUD_TOP_INT_MASK_CON0          0x222e
#define MT6358_AUD_TOP_INT_MASK_CON0_SET      0x2230
#define MT6358_AUD_TOP_INT_MASK_CON0_CLR      0x2232
#define MT6358_AUD_TOP_INT_STATUS0            0x2234
#define MT6358_AUD_TOP_INT_RAW_STATUS0        0x2236
#define MT6358_AUD_TOP_INT_MISC_CON0          0x2238
#define MT6358_AUDNCP_CLKDIV_CON0             0x223a
#define MT6358_AUDNCP_CLKDIV_CON1             0x223c
#define MT6358_AUDNCP_CLKDIV_CON2             0x223e
#define MT6358_AUDNCP_CLKDIV_CON3             0x2240
#define MT6358_AUDNCP_CLKDIV_CON4             0x2242
#define MT6358_AUD_TOP_MON_CON0               0x2244
#define MT6358_AUDIO_DIG_DSN_ID               0x2280
#define MT6358_AUDIO_DIG_DSN_REV0             0x2282
#define MT6358_AUDIO_DIG_DSN_DBI              0x2284
#define MT6358_AUDIO_DIG_DSN_DXI              0x2286
#define MT6358_AFE_UL_DL_CON0                 0x2288
#define MT6358_AFE_DL_SRC2_CON0_L             0x228a
#define MT6358_AFE_UL_SRC_CON0_H              0x228c
#define MT6358_AFE_UL_SRC_CON0_L              0x228e
#define MT6358_AFE_TOP_CON0                   0x2290
#define MT6358_AUDIO_TOP_CON0                 0x2292
#define MT6358_AFE_MON_DEBUG0                 0x2294
#define MT6358_AFUNC_AUD_CON0                 0x2296
#define MT6358_AFUNC_AUD_CON1                 0x2298
#define MT6358_AFUNC_AUD_CON2                 0x229a
#define MT6358_AFUNC_AUD_CON3                 0x229c
#define MT6358_AFUNC_AUD_CON4                 0x229e
#define MT6358_AFUNC_AUD_CON5                 0x22a0
#define MT6358_AFUNC_AUD_CON6                 0x22a2
#define MT6358_AFUNC_AUD_MON0                 0x22a4
#define MT6358_AUDRC_TUNE_MON0                0x22a6
#define MT6358_AFE_ADDA_MTKAIF_FIFO_CFG0      0x22a8
#define MT6358_AFE_ADDA_MTKAIF_FIFO_LOG_MON1  0x22aa
#define MT6358_AFE_ADDA_MTKAIF_MON0           0x22ac
#define MT6358_AFE_ADDA_MTKAIF_MON1           0x22ae
#define MT6358_AFE_ADDA_MTKAIF_MON2           0x22b0
#define MT6358_AFE_ADDA_MTKAIF_MON3           0x22b2
#define MT6358_AFE_ADDA_MTKAIF_CFG0           0x22b4
#define MT6358_AFE_ADDA_MTKAIF_RX_CFG0        0x22b6
#define MT6358_AFE_ADDA_MTKAIF_RX_CFG1        0x22b8
#define MT6358_AFE_ADDA_MTKAIF_RX_CFG2        0x22ba
#define MT6358_AFE_ADDA_MTKAIF_RX_CFG3        0x22bc
#define MT6358_AFE_ADDA_MTKAIF_TX_CFG1        0x22be
#define MT6358_AFE_SGEN_CFG0                  0x22c0
#define MT6358_AFE_SGEN_CFG1                  0x22c2
#define MT6358_AFE_ADC_ASYNC_FIFO_CFG         0x22c4
#define MT6358_AFE_DCCLK_CFG0                 0x22c6
#define MT6358_AFE_DCCLK_CFG1                 0x22c8
#define MT6358_AUDIO_DIG_CFG                  0x22ca
#define MT6358_AFE_AUD_PAD_TOP                0x22cc
#define MT6358_AFE_AUD_PAD_TOP_MON            0x22ce
#define MT6358_AFE_AUD_PAD_TOP_MON1           0x22d0
#define MT6358_AFE_DL_NLE_CFG                 0x22d2
#define MT6358_AFE_DL_NLE_MON                 0x22d4
#define MT6358_AFE_CG_EN_MON                  0x22d6
#define MT6358_AUDIO_DIG_2ND_DSN_ID           0x2300
#define MT6358_AUDIO_DIG_2ND_DSN_REV0         0x2302
#define MT6358_AUDIO_DIG_2ND_DSN_DBI          0x2304
#define MT6358_AUDIO_DIG_2ND_DSN_DXI          0x2306
#define MT6358_AFE_PMIC_NEWIF_CFG3            0x2308
#define MT6358_AFE_VOW_TOP                    0x230a
#define MT6358_AFE_VOW_CFG0                   0x230c
#define MT6358_AFE_VOW_CFG1                   0x230e
#define MT6358_AFE_VOW_CFG2                   0x2310
#define MT6358_AFE_VOW_CFG3                   0x2312
#define MT6358_AFE_VOW_CFG4                   0x2314
#define MT6358_AFE_VOW_CFG5                   0x2316
#define MT6358_AFE_VOW_CFG6                   0x2318
#define MT6358_AFE_VOW_MON0                   0x231a
#define MT6358_AFE_VOW_MON1                   0x231c
#define MT6358_AFE_VOW_MON2                   0x231e
#define MT6358_AFE_VOW_MON3                   0x2320
#define MT6358_AFE_VOW_MON4                   0x2322
#define MT6358_AFE_VOW_MON5                   0x2324
#define MT6358_AFE_VOW_SN_INI_CFG             0x2326
#define MT6358_AFE_VOW_TGEN_CFG0              0x2328
#define MT6358_AFE_VOW_POSDIV_CFG0            0x232a
#define MT6358_AFE_VOW_HPF_CFG0               0x232c
#define MT6358_AFE_VOW_PERIODIC_CFG0          0x232e
#define MT6358_AFE_VOW_PERIODIC_CFG1          0x2330
#define MT6358_AFE_VOW_PERIODIC_CFG2          0x2332
#define MT6358_AFE_VOW_PERIODIC_CFG3          0x2334
#define MT6358_AFE_VOW_PERIODIC_CFG4          0x2336
#define MT6358_AFE_VOW_PERIODIC_CFG5          0x2338
#define MT6358_AFE_VOW_PERIODIC_CFG6          0x233a
#define MT6358_AFE_VOW_PERIODIC_CFG7          0x233c
#define MT6358_AFE_VOW_PERIODIC_CFG8          0x233e
#define MT6358_AFE_VOW_PERIODIC_CFG9          0x2340
#define MT6358_AFE_VOW_PERIODIC_CFG10         0x2342
#define MT6358_AFE_VOW_PERIODIC_CFG11         0x2344
#define MT6358_AFE_VOW_PERIODIC_CFG12         0x2346
#define MT6358_AFE_VOW_PERIODIC_CFG13         0x2348
#define MT6358_AFE_VOW_PERIODIC_CFG14         0x234a
#define MT6358_AFE_VOW_PERIODIC_CFG15         0x234c
#define MT6358_AFE_VOW_PERIODIC_CFG16         0x234e
#define MT6358_AFE_VOW_PERIODIC_CFG17         0x2350
#define MT6358_AFE_VOW_PERIODIC_CFG18         0x2352
#define MT6358_AFE_VOW_PERIODIC_CFG19         0x2354
#define MT6358_AFE_VOW_PERIODIC_CFG20         0x2356
#define MT6358_AFE_VOW_PERIODIC_CFG21         0x2358
#define MT6358_AFE_VOW_PERIODIC_CFG22         0x235a
#define MT6358_AFE_VOW_PERIODIC_CFG23         0x235c
#define MT6358_AFE_VOW_PERIODIC_MON0          0x235e
#define MT6358_AFE_VOW_PERIODIC_MON1          0x2360
#define MT6358_AUDENC_DSN_ID                  0x2380
#define MT6358_AUDENC_DSN_REV0                0x2382
#define MT6358_AUDENC_DSN_DBI                 0x2384
#define MT6358_AUDENC_DSN_FPI                 0x2386
#define MT6358_AUDENC_ANA_CON0                0x2388
#define MT6358_AUDENC_ANA_CON1                0x238a
#define MT6358_AUDENC_ANA_CON2                0x238c
#define MT6358_AUDENC_ANA_CON3                0x238e
#define MT6358_AUDENC_ANA_CON4                0x2390
#define MT6358_AUDENC_ANA_CON5                0x2392
#define MT6358_AUDENC_ANA_CON6                0x2394
#define MT6358_AUDENC_ANA_CON7                0x2396
#define MT6358_AUDENC_ANA_CON8                0x2398
#define MT6358_AUDENC_ANA_CON9                0x239a
#define MT6358_AUDENC_ANA_CON10               0x239c
#define MT6358_AUDENC_ANA_CON11               0x239e
#define MT6358_AUDENC_ANA_CON12               0x23a0
#define MT6358_AUDDEC_DSN_ID                  0x2400
#define MT6358_AUDDEC_DSN_REV0                0x2402
#define MT6358_AUDDEC_DSN_DBI                 0x2404
#define MT6358_AUDDEC_DSN_FPI                 0x2406
#define MT6358_AUDDEC_ANA_CON0                0x2408
#define MT6358_AUDDEC_ANA_CON1                0x240a
#define MT6358_AUDDEC_ANA_CON2                0x240c
#define MT6358_AUDDEC_ANA_CON3                0x240e
#define MT6358_AUDDEC_ANA_CON4                0x2410
#define MT6358_AUDDEC_ANA_CON5                0x2412
#define MT6358_AUDDEC_ANA_CON6                0x2414
#define MT6358_AUDDEC_ANA_CON7                0x2416
#define MT6358_AUDDEC_ANA_CON8                0x2418
#define MT6358_AUDDEC_ANA_CON9                0x241a
#define MT6358_AUDDEC_ANA_CON10               0x241c
#define MT6358_AUDDEC_ANA_CON11               0x241e
#define MT6358_AUDDEC_ANA_CON12               0x2420
#define MT6358_AUDDEC_ANA_CON13               0x2422
#define MT6358_AUDDEC_ANA_CON14               0x2424
#define MT6358_AUDDEC_ANA_CON15               0x2426
#define MT6358_AUDDEC_ELR_NUM                 0x2428
#define MT6358_AUDDEC_ELR_0                   0x242a
#define MT6358_AUDZCD_DSN_ID                  0x2480
#define MT6358_AUDZCD_DSN_REV0                0x2482
#define MT6358_AUDZCD_DSN_DBI                 0x2484
#define MT6358_AUDZCD_DSN_FPI                 0x2486
#define MT6358_ZCD_CON0                       0x2488
#define MT6358_ZCD_CON1                       0x248a
#define MT6358_ZCD_CON2                       0x248c
#define MT6358_ZCD_CON3                       0x248e
#define MT6358_ZCD_CON4                       0x2490
#define MT6358_ZCD_CON5                       0x2492
#define MT6358_ACCDET_DSN_DIG_ID              0x2500
#define MT6358_ACCDET_DSN_DIG_REV0            0x2502
#define MT6358_ACCDET_DSN_DBI                 0x2504
#define MT6358_ACCDET_DSN_FPI                 0x2506
#define MT6358_ACCDET_CON0                    0x2508
#define MT6358_ACCDET_CON1                    0x250a
#define MT6358_ACCDET_CON2                    0x250c
#define MT6358_ACCDET_CON3                    0x250e
#define MT6358_ACCDET_CON4                    0x2510
#define MT6358_ACCDET_CON5                    0x2512
#define MT6358_ACCDET_CON6                    0x2514
#define MT6358_ACCDET_CON7                    0x2516
#define MT6358_ACCDET_CON8                    0x2518
#define MT6358_ACCDET_CON9                    0x251a
#define MT6358_ACCDET_CON10                   0x251c
#define MT6358_ACCDET_CON11                   0x251e
#define MT6358_ACCDET_CON12                   0x2520
#define MT6358_ACCDET_CON13                   0x2522
#define MT6358_ACCDET_CON14                   0x2524
#define MT6358_ACCDET_CON15                   0x2526
#define MT6358_ACCDET_CON16                   0x2528
#define MT6358_ACCDET_CON17                   0x252a
#define MT6358_ACCDET_CON18                   0x252c
#define MT6358_ACCDET_CON19                   0x252e
#define MT6358_ACCDET_CON20                   0x2530
#define MT6358_ACCDET_CON21                   0x2532
#define MT6358_ACCDET_CON22                   0x2534
#define MT6358_ACCDET_CON23                   0x2536
#define MT6358_ACCDET_CON24                   0x2538
#define MT6358_ACCDET_CON25                   0x253a
#define MT6358_ACCDET_CON26                   0x253c
#define MT6358_ACCDET_CON27                   0x253e
#define MT6358_ACCDET_CON28                   0x2540

#endif /* __MFD_MT6358_REGISTERS_H__ */
