# L2 Cache Share SRAM contains:
# 4 KB GFH              : 0x0020_0000 ~ 0x0020_1000
# 252 KB Preloader      : 0x0020_1000 ~ 0x0023_FFFF
PL_START_ADDR=0x00201000
PL_END_ADDR=0x0023FFFF

# 64 KB BSS             : 0x0010_9000 ~ 0x0011_9000
PL_MAX_BSS_SIZE=65536

# Due to code size limitation on share sram 256KB,
# we divide dramc_* into loader_ext.img 40KB
PL_MAX_DRAM_EXT_SIZE=40960

# Keep ROM size smaller than 252 KB
# Keep ROM size smaller than 0x0023_FFFF - 0x0020_1000 - Signature
SIG_SIZE=$(cat "${PRELOADER_OUT}/bin/sig_size.txt")
if [ -z "$SIG_SIZE" ]
then
	SIG_SIZE=292
fi
PL_MAX_ROM_SIZE=$((PL_END_ADDR - PL_START_ADDR - SIG_SIZE))

ROM_RPT_SIZE=500
RAM_RPT_SIZE=500

# check image rom size
PL_ROM_SIZE=$(stat -c%s "${PL_IMAGE}")

if [ $PL_ROM_SIZE -gt $PL_MAX_ROM_SIZE ]; then
    echo "===================== Building Fail ==========================="
    echo " IMG ROM Size: ${PL_ROM_SIZE} bytes > ${PL_MAX_ROM_SIZE} bytes!! "
    echo " WARNING: Reduce your code size first then compile again!! "
    echo "==============================================================="
    echo "                    ROM SIZE REPORT (>${ROM_RPT_SIZE} bytes)   "
    echo "---------------------------------------------------------------"
    cat ${PRELOADER_OUT}/report-codesize.txt | awk -F' ' '{if ($3=="FUNC" && $2>sz) print $0}' sz=${ROM_RPT_SIZE}
    echo "---------------------------------------------------------------"
    rm -f ${PL_IMAGE}
    echo "BUILD FAIL."
    exit 1;
fi

# check image bss size
PL_BSS_SIZE=$(mawk '{if($3=="_bss_start") {BSS_START=("0x" $1)+0} ;
             if($3=="_bss_end") {BSS_END=("0x" $1)+0}}
             END{printf("%d\n",BSS_END-BSS_START)}' ${PL_FUN_MAP})
if [ $PL_BSS_SIZE -gt $PL_MAX_BSS_SIZE ]; then
    echo "===================== Building Fail ==========================="
    echo " IMG BSS Size: ${PL_BSS_SIZE} bytes > ${PL_MAX_BSS_SIZE} bytes!!"
    echo " WARNING: Reduce your code size first then compile again!! "
    echo "==============================================================="
    echo "                    BSS SIZE REPORT (>${RAM_RPT_SIZE} bytes)   "
    echo "---------------------------------------------------------------"
    cat ${PRELOADER_OUT}/report-codesize.txt | awk -F' ' '{if ($3=="OBJECT" && $2>sz) print $0}' sz=${RAM_RPT_SIZE}
    echo "---------------------------------------------------------------"
    rm -f ${PL_IMAGE}
    echo "BUILD FAIL."
    exit 1;
fi

# check image dram size
PL_DRAM_SIZE=$(mawk '{if($3=="_dram_start") {DRAM_START=("0x" $1)+0} ;
             if($3=="_dram_end") {DRAM_END=("0x" $1)+0}}
             END{printf("%d\n",DRAM_END-DRAM_START)}' ${PL_FUN_MAP})
if [ $PL_DRAM_SIZE -gt $PL_MAX_DRAM_EXT_SIZE ]; then
    echo "===================== Building Fail ==========================="
    echo " LOADER_EXT_DRAM Size: ${PL_DRAM_SIZE} bytes > ${PL_MAX_DRAM_EXT_SIZE} bytes!!"
    echo " WARNING: Reduce your LOADER_EXT_DRAM size first then compile again!! "
    echo "==============================================================="
    echo "                    ROM SIZE REPORT (>${ROM_RPT_SIZE} bytes)   "
    echo "---------------------------------------------------------------"
    cat ${PRELOADER_OUT}/report-codesize.txt | awk -F' ' '{if ($3=="FUNC" && $2>sz) print $0}' sz=${ROM_RPT_SIZE}
    echo "---------------------------------------------------------------"
    rm -f ${PL_IMAGE}
    echo "BUILD FAIL."
    exit 1;
fi

PL_SIZE=`expr $PL_BSS_SIZE + $PL_ROM_SIZE`
echo "===================== Building Success ==========================="
echo " PL MAX ROM size : ${PL_MAX_ROM_SIZE} bytes"
echo " PL ROM size     : ${PL_ROM_SIZE} bytes"
echo " PL BSS size     : ${PL_BSS_SIZE} bytes (Max ${PL_MAX_BSS_SIZE})"
echo " PL DRAM size    : ${PL_DRAM_SIZE} bytes (Max ${PL_MAX_DRAM_EXT_SIZE})"
echo " PL ROM+BSS size : ${PL_SIZE} bytes"
echo "=================================================================="
