#include <sys/types.h>
#include <debug.h>

extern void mtk_timer_init (void);
extern int32_t gpt4_get_current_tick (void);
extern int32_t gpt4_tick2time_us (uint32_t tick);
extern void gpt_busy_wait_ms (uint32_t timeout_ms);

void dev_timer_init()
{
	mtk_timer_init();
}
uint64_t dev_timer_get_time_us()
{
	uint32_t tick ,time;
	
	tick = gpt4_get_current_tick();
	
	time = gpt4_tick2time_us(tick);
	
	return time;

}

void dev_timer_mdelay(unsigned int msec)
{
	gpt_busy_wait_ms(msec);
}


