###################################################################
# Include Files Directery
###################################################################

#include $(D_ROOT)/mtk_cust.mak

###################################################################
# Using GCC
###################################################################

#CROSS_COMPILE = arm-linux-androideabi-
#CROSS_COMPILE = arm-eabi-

AS	= $(CROSS_COMPILE)as
LD	= $(CROSS_COMPILE)ld
CC	= $(CROSS_COMPILE)gcc
CPP	= $(CC)-E
AR	= $(CROSS_COMPILE)ar
NM	= $(CROSS_COMPILE)nm
STRIP	= $(CROSS_COMPILE)strip
OBJCOPY = $(CROSS_COMPILE)objcopy
OBJDUMP = $(CROSS_COMPILE)objdump
RANLIB	= $(CROSS_COMPILE)RANLIB
THUMB_MODE = TRUE


###################################################################
# Initialize GCC Compile Parameter
###################################################################
#VPF_FLAGS :=  -march=armv7-a  -mfpu=neon  -mfloat-abi=hard 
VPF_FLAGS :=  -march=armv7-a  -mfpu=neon-vfpv4  -mfloat-abi=softfp 
#-march=armv7-a -mfpu=neon-vfpv4  -mfloat-abi=hard -march=armv7-a 
#-mfloat-abi=softfp -mfpu=vfpv4 -mcpu=cortex-a53

C_OPTION += -Os -g
C_OPTION += -mthumb -mthumb-interwork -mno-unaligned-access
C_OPTION +=  $(VPF_FLAGS)
C_OPTION += -c -Wall -ffunction-sections -fdata-sections
  
LDFLAGS += --gc-sections 
LDFLAGS += --relax
LDFLAGS += --verbose

ASFLAGS += -mthumb-interwork $(VPF_FLAGS) -g


#PL_CODE==1 --> BUILDING PL CODE
ifneq ($(strip $(PL_CODE)),)
###################################################################
INCLUDE_FILE := $(PL_INCLUDE_FILE)
#priority: da mode > pl project config > pl cust > pl default
include $(MTK_PATH_PLATFORM)/default.mak
include ${MTK_ROOT_CUSTOM}/${TARGET}/cust_bldr.mak
PROJECT_CONFIGS := $(MTK_ROOT_CUSTOM)/$(MTK_PROJECT)/$(MTK_PROJECT).mk
include $(PROJECT_CONFIGS)
#this must after -- include $(PROJECT_CONFIGS)
include $(MTK_PATH_PLATFORM)/flash/make_script/pl_feature_mask.mak
include $(MTK_PATH_PLATFORM)/feature.mak
C_OPTION += -D_FLASH_MODE_DA_

#LD_GCC_LIBS += $(MTK_PATH_PLATFORM)/lib/libcrypto.a
#LD_GCC_LIBS += $(MTK_PATH_PLATFORM)/lib/libdevinfo.a
#LD_GCC_LIBS += $(MTK_PATH_PLATFORM)/lib/libdevinfo_debug.a
#LD_GCC_LIBS += $(MTK_PATH_PLATFORM)/lib/libsec.a
#LD_GCC_LIBS += $(MTK_PATH_PLATFORM)/lib/libsecplat.a

###################################################################

else

INCLUDE_FILE     := -I$(MTK_ROOT_PLATFORM)/flashc
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/lib
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/include
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/include/lib
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/arch/arm/include
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/driver
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/flashc/driver/ufs
INCLUDE_FILE     += -I$(MTK_ROOT_PLATFORM)/common/storage/nand/include/internal

INCLUDE_FILE     += -I$(MTK_PATH_PLATFORM)/flash
INCLUDE_FILE     += -I$(MTK_PATH_PLATFORM)/flash/custom
INCLUDE_FILE     += -I$(MTK_PATH_PLATFORM)/flash/inc
INCLUDE_FILE     += -I$(MTK_PATH_PLATFORM)/flash/dev/ufs

include $(MTK_ROOT_CUSTOM)/$(MTK_PROJECT)/$(MTK_PROJECT).mk
include $(MTK_PATH_PLATFORM)/flash/make_script/feature.mak

endif

C_OPTION += -c $(INCLUDE_FILE) 
C_OPTION += -DDA_BUILD_STAGE=$(DA_BUILD_STAGE)
   
ifdef DA_MODE
include $(MTK_PATH_PLATFORM)/flash/make_script/mode/$(DA_MODE).mak
endif

 
DA_1ST_SEC_LIB          := $(MTK_PATH_PLATFORM)/flash/sec_lib/libsec_1st.a 
DA_2ND_SEC_LIB          := $(MTK_PATH_PLATFORM)/flash/sec_lib/libsec_2nd.a 
DA_DEVINFO_LIB          := $(MTK_PATH_PLATFORM)/lib/libdevinfo.a

LDSCRIPT_STAGE1	:= $(MTK_PATH_PLATFORM)/flash/make_script/link_script_1st.ld
LDSCRIPT_STAGE2	:= $(MTK_PATH_PLATFORM)/flash/make_script/link_script_2nd.ld

###################################################################
CONTACT_OWNER:=Jungo.Lin
FLASH_XML_VERSION:=1.0

export All_OBJS
