/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein
* is confidential and proprietary to MediaTek Inc. and/or its licensors.
* Without the prior written permission of MediaTek inc. and/or its licensors,
* any reproduction, modification, use or disclosure of MediaTek Software,
* and information contained herein, in whole or in part, shall be strictly prohibited.
*
* MediaTek Inc. (C) 2020. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
* AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
* NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
* SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
* SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
* THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
* THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
* CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
* SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
* CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
* AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
* OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
* MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek Software")
* have been modified by MediaTek Inc. All revisions are subject to any receiver\'s
* applicable license agreements with MediaTek Inc.
*/

/* Security policy wrapper for DRAM DA. */

#include "stdint.h"
#include "boot/transfer.h"
#include "error_code.h"
#include "assert.h"
#include <boot/error_message.h>
#include <boot/hal.h>
/////////////////////////EXTERNAL FUNCTION START////////////////////////////////
extern unsigned int is_all_partition_writable(unsigned int *write_all_perm);
extern unsigned int get_policy_entry_idx(unsigned char *part_name);
extern unsigned int get_hash_binding_policy(unsigned int policy_entry_idx);
extern unsigned int get_vfy_policy(unsigned int policy_entry_idx);
extern unsigned int get_dl_policy(unsigned int policy_entry_idx);
extern unsigned char *get_binding_hash(unsigned int policy_entry_idx);
extern void get_image_policy(unsigned char *partition_name,
                             struct transfer_control *op_ctrl);

extern int cust_pubk_init(void);
extern unsigned int is_security_enabled(unsigned int *enable);
extern unsigned int cust_init(void) __attribute__((weak));


/////////////////////////EXTERNAL FUNCTION END////////////////////////////////

unsigned int is_security_enabled(unsigned int *enable) {
  unsigned int ret = 0;
#if (DA_ENABLE_SECURITY)
    *enable = 1;
    #if (DA_ENABLE_ANTI_ROLLBACK)
        /* default enable */
    #else
        bypass_ver_check();
    #endif
#else
    *enable = 0;
#endif
  return ret;
}

unsigned int is_write_all_allowed(unsigned int *perm) {
  unsigned int ret = 0;
  ret = is_all_partition_writable(perm);
  return ret;
}

/* although security is not related to transfer control */
/* DA owner chose to put security control into transfer control, so be it */
void get_part_sec_policy(uint8_t *partition_name,
                         struct transfer_control *op_ctrl) {
  unsigned int sec_policy_entry_idx = 0;

  sec_policy_entry_idx = get_policy_entry_idx(partition_name);

  op_ctrl->hash_binding = get_hash_binding_policy(sec_policy_entry_idx);
  op_ctrl->img_auth_required = get_vfy_policy(sec_policy_entry_idx);
  op_ctrl->dl_forbidden = get_dl_policy(sec_policy_entry_idx);
  op_ctrl->hash = get_binding_hash(sec_policy_entry_idx);
  op_ctrl->subimg_auth_bypass_list =
      get_image_auth_bypass_list(sec_policy_entry_idx);
  LOGD("==========security policy==========\n");
  LOGD("policy of partition: %s\n", partition_name);
  LOGD("hash_binding = %d\n", op_ctrl->hash_binding);
  if (op_ctrl->hash_binding) {
    unsigned int i;
    /* hash is sha256, so its size is 32 bytes */
    LOGD("hash = ");
    for (i = 0; i < 32; i++) {
      LOGD("0x%x ", *(op_ctrl->hash + i));
      if (0 == ((i + 1) % 16))
        LOGD("\n");
    }
  }
  LOGD("img_auth_required = %d\n", op_ctrl->img_auth_required);
  LOGD("dl_forbidden = %d\n", op_ctrl->dl_forbidden);
  LOGD("===================================\n");

  return;
}

status_t security_check()
{
  status_t status = da_version_check();
  if (status) {
      LOGE("DA version is invalid.\n");
	  ASSERT(0);
  }
  return status;
}

status_t setup_security_env()
{
  unsigned int security_enable = 0;

  if (is_security_enabled(&security_enable)) {
    /* use safe setting is error occurs */
    security_enable = 1;
  }

  status_t status = STATUS_OK;
  if (security_enable) {    
    status = update_rom_info();
    if (status != STATUS_OK)
      LOGE("ROM INFO NOT FOUND...\n");
    else {
      status = sec_sej_key_init();
      if (status != STATUS_OK)
        LOGE("HACC init...fail\n");
    }

    if (cust_init) {
      status = cust_init();
      if (status != STATUS_OK)
        LOGE("custom init fail. 0x%x\n", status);
    }

    status = cust_pubk_init();
    if (status != STATUS_OK)
      LOGE("custom public key init fail.\n");
	status = security_check();
    LOGI("\n security pass.\n");
  } else {
    LOGI("\n skip security.\n");
  }
  
  return status;
}

char *sec_get_verified_image_name(char *name) {
  if (name == 0)
    return name;

  static char verified_name[512];
  char ext[8];
  verified_name[0] = 0;
  int pos = -1;

  int i = 0;
  size_t sz = strlen(name);
  for (i = sz; i > 0; --i) {
    if (name[i] == '.') {
      // file ext length must less than 8
      if (sz - i > 7)
        return name;
      pos = i;
      memcpy(ext, name + pos, sz - pos);
      ext[sz - pos] = 0;
      break;
    }
  }

  if (pos == -1)
    return name;

  memcpy(verified_name, name, pos);
  memcpy(verified_name + pos, "-verified", 9);
  memcpy(verified_name + pos + 9, ext, 8);

  return verified_name;
}

