OUTPUT_ARCH(arm)
ENTRY(_start)
romBase = 0x00201000;
bssBase = 0x00109000;
stackBase = 0x00200000;
dramBase = 0x00120000;
pgtblBase = 0x00104000;

/* log_sram_buf + bss1 should be less than 40 KB.*/
MEMORY {
    bss : ORIGIN = 0x00109000, LENGTH = 0x10000
    rom : ORIGIN = 0x00201000, LENGTH = 0x3F000
    stack : ORIGIN = 0x00200000, LENGTH = 0xC00
    dram  : ORIGIN = 0x00120000, LENGTH = 0xA000
    pgtbl : ORIGIN = 0x00104000, LENGTH = 0x5000
}
SECTIONS {
    /* rom region */
    . = romBase;
    .start ALIGN(4) : {
        *(.text.start)
    }
    . = romBase + 0x022C;
    .rom_info ALIGN(4) : {
        *(.data.rom_info)
    }
    .text ALIGN(4) : {
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .text)
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .text.*)
    }
    .rodata ALIGN(4) : {
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .rodata)
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .rodata.*)
    }
    .data ALIGN(4) : {
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .data)
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .data.*)
    }
    .got ALIGN(4) : {
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .got)
        *(EXCLUDE_FILE(*dramc_pi_basic_api.o *dramc_dv_freq_related.o *dramc_pi_ddr_reserve.o *dramc_actiming.o *dramc_debug.o *dramc_utility.o *dramc_unit_test.o *loader_ext.o) .got.*)
    }
    __boot_end = .;
    /* dram region */
    . = dramBase;
    .loader_ext_dram ALIGN(4) : AT(ADDR(.got) + SIZEOF(.got)) {
        _dram_start = .;
        *dramc_pi_basic_api.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_dv_freq_related.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_pi_ddr_reserve.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_actiming.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_debug.o  (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_utility.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *dramc_unit_test.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        *loader_ext.o (.text .text.* .rodata .rodata.* .data .data.* .got .got.*)
        _dram_end = .;
    }
    /* stack region */
    . = stackBase;
    .stack ALIGN(4) : {
        _stack_start = .;
        *(.stack)
        _stack_end = .;
    }
    /* bss region */
    . = bssBase;
    .bss ALIGN(16) : {
        _bss_start = .;
        *print.o (.log_sram_buf)
        *efi.o (.gpt_sram_buf)
        *efi.o (.gpt_sram_crc32_table)
        *efi.o (.gpt_sram_part_info)
        *efi.o (.gpt_sram_part_meta_info)
        *(.bss)
        *(.bss.*)
        *(COMMON)
        /* make _bss_end as 4 bytes alignment */
        . = ALIGN(4);
        _bss_end = .;
    }

    /* pgtbl region */
    . = pgtblBase;
    .pgtbl ALIGN(128) : {
        _pgtbl_start = .;
        /* reserve 16KB for the 1st level page table */
        . = . + 16 * 1024;
        *mmu.o (.coarse_page_tbl)
        /* make _pgtable_end as 4b aligned */
        . = ALIGN(128);
        _pgtbl_end = .;
    }
}

