#include <typedefs.h>

#define LASTBUS_INFRA		0x10023000
#define LASTBUS_PERI		0x1002b000
#define LASTBUS_PERI_2		0x1002e000
#define LASTBUS_SUBINFRA	0x10025000

#define SYSTRACKER_CTRL		0x100012fc

void lastbus_init(void)
{
	/* mt6885 has 1 dummy check point which caused timeout */
	/* let's mask it first */
	DRV_WriteReg32(LASTBUS_INFRA + 0x14, 0x200);
	/* ok, do the normal init with max timeout */
	DRV_WriteReg32(LASTBUS_INFRA, 0xffff0008);
	DRV_WriteReg32(LASTBUS_INFRA, 0xffff000c);

	/* other monitors can use normal enable flow */
	DRV_WriteReg32(LASTBUS_PERI, 0xffff0008);
	DRV_WriteReg32(LASTBUS_PERI, 0xffff000c);
	DRV_WriteReg32(LASTBUS_PERI_2, 0xffff0008);
	DRV_WriteReg32(LASTBUS_PERI_2, 0xffff000c);
	DRV_WriteReg32(LASTBUS_SUBINFRA, 0xffff0008);
	DRV_WriteReg32(LASTBUS_SUBINFRA, 0xffff000c);
}

void systracker_init(void)
{
	DRV_WriteReg32(SYSTRACKER_CTRL, 0x00006007);
}
