
//#include "svdpi.h"
//#include "vc_hdrs.h"
#include "dramc_common.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
//#include "./dramc_actiming.h"
#include "dramc_dv_init.h"


#if 0
    #include "./drivers/DRAMC_SUBSYS_config.c"
    #include "./drivers/ANA_init_config.c"
    #include "./drivers/DIG_NONSHUF_config.c"
    #include "./drivers/DRAM_config_collctioin.c"
    #include "./drivers/LP4_dram_init.c"
    #include "./drivers/LP5_dram_init.c"
    #include "./drivers/DIG_SHUF_config.c"
#endif

#if 0
void CInit_ConfigFromTBA(void)
{
    TbaConfig.dramc_dram_ratio  = 4;
    TbaConfig.channel           = 0;
    TbaConfig.dram_type         = 4;
    TbaConfig.shu_type          = 0;
    TbaConfig.dram_cbt_mode_RK0 = 1;
    TbaConfig.dram_cbt_mode_RK1 = 1;
    TbaConfig.DBI_R_onoff_FSP0  = 0;
    TbaConfig.DBI_R_onoff_FSP1  = 0;
    TbaConfig.frequency         = 1600;
    TbaConfig.voltage_state     = 3;
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: dramc_dram_ratio  = %1d\n", TbaConfig.dramc_dram_ratio));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: channel           = %1d\n", TbaConfig.channel));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: dram_type         = %1d\n", TbaConfig.dram_type));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: shu_type          = %1d\n", TbaConfig.shu_type));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: dram_cbt_mode_RK0 = %1d\n", TbaConfig.dram_cbt_mode_RK0));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: dram_cbt_mode_RK1 = %1d\n", TbaConfig.dram_cbt_mode_RK1));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: DBI_R_onoff_FSP0  = %1d\n", TbaConfig.DBI_R_onoff_FSP0));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: DBI_R_onoff_FSP1  = %1d\n", TbaConfig.DBI_R_onoff_FSP1));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: frequency         = %1d\n", TbaConfig.frequency));
    mcSHOW_DBG_MSG(("[TBA_CTX_T] Global: voltage_state     = %1d\n", TbaConfig.voltage_state));


    TbaEnvConfig.TMRRI_way             = 1;
    TbaEnvConfig.RUNTIMEMRR_way        = 1;
    TbaEnvConfig.PICG_MODE             = 1;
    TbaEnvConfig.LP_NEW8X_SEQ_MODE     = 0;
    TbaEnvConfig.DDR400_OPEN_LOOP_MODE = 0;
    TbaEnvConfig.RXTRACK_PBYTE_OPT     = 0;
    TbaEnvConfig.RG_SPM_MODE           = 0;
    TbaEnvConfig.TX_OE_EXT_OPT         = 0;
    TbaEnvConfig.PLL_MODE_OPTION       = 1;
    TbaEnvConfig.TREFBWIG_IGNORE       = 1;
    TbaEnvConfig.SHUFFLE_LVL_MODE      = 1;
    TbaEnvConfig.SELPH_MODE            = 1;
    TbaEnvConfig.TRACK_UP_MODE         = 1;
    TbaEnvConfig.VALID_LAT_VALUE       = 0;
    TbaEnvConfig.NEW_RANK_MODE         = 1;
    TbaEnvConfig.WPST1P5T_OPT          = 1;
    TbaEnvConfig.TXP_WORKAROUND_OPT    = 0;
    TbaEnvConfig.DLL_IDLE_MODE         = 1;
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: TMRRI_way             = %1d\n", TbaEnvConfig.TMRRI_way));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: RUNTIMEMRR_way        = %1d\n", TbaEnvConfig.RUNTIMEMRR_way));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: PICG_MODE             = %1d\n", TbaEnvConfig.PICG_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: LP_NEW8X_SEQ_MODE     = %1d\n", TbaEnvConfig.LP_NEW8X_SEQ_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: DDR400_OPEN_LOOP_MODE = %1d\n", TbaEnvConfig.DDR400_OPEN_LOOP_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: RXTRACK_PBYTE_OPT     = %1d\n", TbaEnvConfig.RXTRACK_PBYTE_OPT));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: RG_SPM_MODE           = %1d\n", TbaEnvConfig.RG_SPM_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: TX_OE_EXT_OPT         = %1d\n", TbaEnvConfig.TX_OE_EXT_OPT));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: PLL_MODE_OPTION       = %1d\n", TbaEnvConfig.PLL_MODE_OPTION));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: TREFBWIG_IGNORE       = %1d\n", TbaEnvConfig.TREFBWIG_IGNORE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: SHUFFLE_LVL_MODE      = %1d\n", TbaEnvConfig.SHUFFLE_LVL_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: SELPH_MODE            = %1d\n", TbaEnvConfig.SELPH_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: TRACK_UP_MODE         = %1d\n", TbaEnvConfig.TRACK_UP_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: VALID_LAT_VALUE       = %1d\n", TbaEnvConfig.VALID_LAT_VALUE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: NEW_RANK_MODE         = %1d\n", TbaEnvConfig.NEW_RANK_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: WPST1P5T_OPT          = %1d\n", TbaEnvConfig.WPST1P5T_OPT));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: TXP_WORKAROUND_OPT    = %1d\n", TbaEnvConfig.TXP_WORKAROUND_OPT));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_config_T] Global: DLL_IDLE_MODE         = %1d\n", TbaEnvConfig.DLL_IDLE_MODE));

    TBA_Build_Def.DQSG_TRACK_on = 1;
    mcSHOW_DBG_MSG(("[TBA_build_def_T] Global: DQSG_TRACK_on = %1d\n", TBA_Build_Def.DQSG_TRACK_on));


    TbaEnvDVFSCfg.group_num             = 2;
    TbaEnvDVFSCfg.LP5BGOTF              = 0;
    TbaEnvDVFSCfg.LP5BGEN               = 0;
    TbaEnvDVFSCfg.CAS_MODE              = 3;
    TbaEnvDVFSCfg.LP5_RDQS_SE_EN        = 0;
    TbaEnvDVFSCfg.DQSIEN_MODE           = 1;
    TbaEnvDVFSCfg.freq_group_map_0      = 2;
    TbaEnvDVFSCfg.freq_group_map_1      = 6;
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: group_num        = %1d\n", TbaEnvDVFSCfg.group_num));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: LP5BGOTF         = %1d\n", TbaEnvDVFSCfg.LP5BGOTF));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: LP5BGEN          = %1d\n", TbaEnvDVFSCfg.LP5BGEN));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: CAS_MODE         = %1d\n", TbaEnvDVFSCfg.CAS_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: LP5_RDQS_SE_EN   = %1d\n", TbaEnvDVFSCfg.LP5_RDQS_SE_EN));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: DQSIEN_MODE      = %1d\n", TbaEnvDVFSCfg.DQSIEN_MODE));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: freq_group_map_0 = %1d\n", TbaEnvDVFSCfg.freq_group_map_0));
    mcSHOW_DBG_MSG(("[TBA_dramc_env_dvfs_config_T] Global: freq_group_map_1 = %1d\n", TbaEnvDVFSCfg.freq_group_map_1));


    TbaEnvHwFuncCfg.HW_MR4_OPTION_RANDOM             = 1;
    TbaEnvHwFuncCfg.HW_DMYRD_OPTION_RANDOM           = 1;
    TbaEnvHwFuncCfg.HW_DQSOSC_OPTION_RANDOM          = 1;
    TbaEnvHwFuncCfg.HW_ZQ_OPTION_RANDOM              = 1;
    TbaEnvHwFuncCfg.RX_INPUT_TRACK_OPTION_RANDOM     = 1;
    TbaEnvHwFuncCfg.DQSG_RUNTIME_DEBUG_OPTION_RANDOM = 1;
    TbaEnvHwFuncCfg.HW_MR4_EN                        = 1;
    TbaEnvHwFuncCfg.HW_DMYRD_EN                      = 1;
    TbaEnvHwFuncCfg.HW_DQSOSC_EN                     = 1;
    TbaEnvHwFuncCfg.HW_ZQ_EN                         = 1;
    TbaEnvHwFuncCfg.DQSG_RETRY_EN                    = 0;
    TbaEnvHwFuncCfg.RX_INPUT_TRACK_EN                = 1;
    TbaEnvHwFuncCfg.DQSG_RUNTIME_DEBUG_EN            = 1;
    TbaEnvHwFuncCfg.RDSEL_TRACK_EN                   = 0;
    TbaEnvHwFuncCfg.DQSG_TRACK_EN                    = 0;
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_MR4_OPTION_RANDOM             = %1d\n", TbaEnvHwFuncCfg.HW_MR4_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_DMYRD_OPTION_RANDOM           = %1d\n", TbaEnvHwFuncCfg.HW_DMYRD_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_DQSOSC_OPTION_RANDOM          = %1d\n", TbaEnvHwFuncCfg.HW_DQSOSC_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_ZQ_OPTION_RANDOM              = %1d\n", TbaEnvHwFuncCfg.HW_ZQ_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: RX_INPUT_TRACK_OPTION_RANDOM     = %1d\n", TbaEnvHwFuncCfg.RX_INPUT_TRACK_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: DQSG_RUNTIME_DEBUG_OPTION_RANDOM = %1d\n", TbaEnvHwFuncCfg.DQSG_RUNTIME_DEBUG_OPTION_RANDOM));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_MR4_EN                        = %1d\n", TbaEnvHwFuncCfg.HW_MR4_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_DMYRD_EN                      = %1d\n", TbaEnvHwFuncCfg.HW_DMYRD_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_DQSOSC_EN                     = %1d\n", TbaEnvHwFuncCfg.HW_DQSOSC_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: HW_ZQ_EN                         = %1d\n", TbaEnvHwFuncCfg.HW_ZQ_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: DQSG_RETRY_EN                    = %1d\n", TbaEnvHwFuncCfg.DQSG_RETRY_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: RX_INPUT_TRACK_EN                = %1d\n", TbaEnvHwFuncCfg.RX_INPUT_TRACK_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: DQSG_RUNTIME_DEBUG_EN            = %1d\n", TbaEnvHwFuncCfg.DQSG_RUNTIME_DEBUG_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: RDSEL_TRACK_EN                   = %1d\n", TbaEnvHwFuncCfg.RDSEL_TRACK_EN));
    mcSHOW_DBG_MSG(("[dramc_env_hw_func_config_T] Global: DQSG_TRACK_EN                    = %1d\n", TbaEnvHwFuncCfg.DQSG_TRACK_EN));


    TbaTestListDef.RandDefaultData_on      = 1;
    TbaTestListDef.DQS2DQ_TRACK_on         = 1;
    TbaTestListDef.LPDDR4_EN               = 1;
    TbaTestListDef.ESL_LOG_GEN             = 1;
    TbaTestListDef.LP4_X8_on               = 0;
    TbaTestListDef.LP4_X8_mix_on           = 0; //Jeremy
    TbaTestListDef.INCLUDE_LP45_COMBO_APHY = 1;
    TbaTestListDef.LP45_COMBO_APHY_EN      = 1;
    TbaTestListDef.LPDDR5_EN               = 0;
    TbaTestListDef.LP3_4_PINMUX_EN         = 0;
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: RandDefaultData_on      = %1d\n", TbaTestListDef.RandDefaultData_on));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: DQS2DQ_TRACK_on         = %1d\n", TbaTestListDef.DQS2DQ_TRACK_on));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: LPDDR4_EN               = %1d\n", TbaTestListDef.LPDDR4_EN));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: ESL_LOG_GEN             = %1d\n", TbaTestListDef.ESL_LOG_GEN));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: LP4_X8_on               = %1d\n", TbaTestListDef.LP4_X8_on));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: INCLUDE_LP45_COMBO_APHY = %1d\n", TbaTestListDef.INCLUDE_LP45_COMBO_APHY));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: LP45_COMBO_APHY_EN      = %1d\n", TbaTestListDef.LP45_COMBO_APHY_EN));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: LPDDR5_EN               = %1d\n", TbaTestListDef.LPDDR5_EN));
    mcSHOW_DBG_MSG(("[TBA_TestList_Def_T] Global: LP3_4_PINMUX_EN         = %1d\n", TbaTestListDef.LP3_4_PINMUX_EN));



    TbaDramcBenchConfig.rank_swap                = 0;
    TbaDramcBenchConfig.new_uP_spm_mode          = 0;
    TbaDramcBenchConfig.LP_MTCMOS_CONTROL_SEL    = 0;
    // CHA, BYTE 0
    TbaDramcBenchConfig.cha_pinmux_anti_order_0  = 0;
    TbaDramcBenchConfig.cha_pinmux_anti_order_1  = 1;
    TbaDramcBenchConfig.cha_pinmux_anti_order_2  = 2;
    TbaDramcBenchConfig.cha_pinmux_anti_order_3  = 3;
    TbaDramcBenchConfig.cha_pinmux_anti_order_4  = 4;
    TbaDramcBenchConfig.cha_pinmux_anti_order_5  = 5;
    TbaDramcBenchConfig.cha_pinmux_anti_order_6  = 6;
    TbaDramcBenchConfig.cha_pinmux_anti_order_7  = 7;
    // CHA, BYTE 1
    TbaDramcBenchConfig.cha_pinmux_anti_order_8  = 8;
    TbaDramcBenchConfig.cha_pinmux_anti_order_9  = 9;
    TbaDramcBenchConfig.cha_pinmux_anti_order_10 = 10;
    TbaDramcBenchConfig.cha_pinmux_anti_order_11 = 11;
    TbaDramcBenchConfig.cha_pinmux_anti_order_12 = 12;
    TbaDramcBenchConfig.cha_pinmux_anti_order_13 = 13;
    TbaDramcBenchConfig.cha_pinmux_anti_order_14 = 14;
    TbaDramcBenchConfig.cha_pinmux_anti_order_15 = 15;
    // CHB, BYTE 0
    TbaDramcBenchConfig.chb_pinmux_anti_order_0  = 0;
    TbaDramcBenchConfig.chb_pinmux_anti_order_1  = 1;
    TbaDramcBenchConfig.chb_pinmux_anti_order_2  = 2;
    TbaDramcBenchConfig.chb_pinmux_anti_order_3  = 3;
    TbaDramcBenchConfig.chb_pinmux_anti_order_4  = 4;
    TbaDramcBenchConfig.chb_pinmux_anti_order_5  = 5;
    TbaDramcBenchConfig.chb_pinmux_anti_order_6  = 6;
    TbaDramcBenchConfig.chb_pinmux_anti_order_7  = 7;
    // CHB, BYTE 1
    TbaDramcBenchConfig.chb_pinmux_anti_order_8  = 8;
    TbaDramcBenchConfig.chb_pinmux_anti_order_9  = 9;
    TbaDramcBenchConfig.chb_pinmux_anti_order_10 = 10;
    TbaDramcBenchConfig.chb_pinmux_anti_order_11 = 11;
    TbaDramcBenchConfig.chb_pinmux_anti_order_12 = 12;
    TbaDramcBenchConfig.chb_pinmux_anti_order_13 = 13;
    TbaDramcBenchConfig.chb_pinmux_anti_order_14 = 14;
    TbaDramcBenchConfig.chb_pinmux_anti_order_15 = 15;

    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: rank_swap                = %1d\n", TbaDramcBenchConfig.rank_swap));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: new_uP_spm_mode          = %1d\n", TbaDramcBenchConfig.new_uP_spm_mode));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: LP_MTCMOS_CONTROL_SEL    = %1d\n", TbaDramcBenchConfig.LP_MTCMOS_CONTROL_SEL));
    // CHA, BYTE 0
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_0  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_0));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_1  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_1));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_2  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_2));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_3  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_3));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_4  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_4));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_5  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_5));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_6  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_6));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_7  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_7));
    // CHA BYTE 1
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_8  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_8));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_9  = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_9));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_10 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_10));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_11 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_11));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_12 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_12));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_13 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_13));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_14 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_14));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: cha_pinmux_anti_order_15 = %1d\n", TbaDramcBenchConfig.cha_pinmux_anti_order_15));
    // CHB, BYTE 0
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_0  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_0));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_1  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_1));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_2  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_2));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_3  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_3));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_4  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_4));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_5  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_5));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_6  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_6));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_7  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_7));
    // CHB, BYTE 1
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_8  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_8));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_9  = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_9));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_10 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_10));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_11 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_11));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_12 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_12));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_13 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_13));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_14 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_14));
    mcSHOW_DBG_MSG(("[TBA_dramc_bench_T] Global: chb_pinmux_anti_order_15 = %1d\n", TbaDramcBenchConfig.chb_pinmux_anti_order_15));

}
#endif

#if BYPASS_CALIBRATION
#if (FOR_DV_SIMULATION_USED==0)
void Apply_LP4_1600_Calibraton_Result(DRAMC_CTX_T *p)
{
    U8 u1RankIdx=0;
    U8 backup_rank=0;

    backup_rank = p->rank;

    ShiftDQUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQ_OENUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQSWCK_UI(p, -1, ALL_BYTES);

    for(u1RankIdx=0; u1RankIdx<p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);
        //CBT
		DramcCmdUIDelaySetting(p, 0);

        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0),
    		P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) |
    		P_Fld(0, SHU_R0_CA_CMD0_RG_ARPI_CLK));
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0), 0, SHU_R0_CA_CMD0_RG_ARPI_CS);

        //WL
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_DQ0), 0x20, SHU_R0_B0_DQ0_ARPI_PBYTE_B0);  //rank0, byte0, DQS delay
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_DQ0), 0x20, SHU_R0_B1_DQ0_ARPI_PBYTE_B1);  //rank0, byte1, DQS delay

        //Gating
        if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
        {
            // normal mode
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        		P_Fld(11,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
        		P_Fld(15,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        		P_Fld(11,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
        		P_Fld(15,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));

            #if GATING_RODT_LATANCY_EN
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
            #endif
        }
        else
        {
            //mix mode
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        		P_Fld(15,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        		P_Fld(1,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
        		P_Fld(3,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        		P_Fld(15,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        		P_Fld(1,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
        		P_Fld(3,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));
            
            #if GATING_RODT_LATANCY_EN
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        		P_Fld(4,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
        		P_Fld(4,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        		P_Fld(4,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
        		P_Fld(4,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
            #endif
        }
        
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY),
        	8,
        	SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY),
        	8,
        	SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);

    	DramPhyReset(p);

    	// set dqs delay, (dqm delay)
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY5),
                P_Fld((U32)0, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY4),
                P_Fld((U32)0x46, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY5),
                P_Fld((U32)0, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY4),
                P_Fld((U32)0x46, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1));

        // set dq delay
        U8 u1BitIdx;
        for (u1BitIdx = 0; u1BitIdx < DQS_BIT_NUMBER; u1BitIdx += 2)
        {
             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY0 + u1BitIdx * 2),
                                            P_Fld(((U32)0x46), SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
                                            P_Fld(((U32)0x46), SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));

             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY0 + u1BitIdx * 2),
                                            P_Fld((U32)0x46, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
                                            P_Fld((U32)0x46, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));

            //mcSHOW_DBG_MSG(("u1BitId %d  Addr 0x%2x = %2d %2d %2d %2d \n", u1BitIdx, DDRPHY_RXDQ1+u1BitIdx*2,
            //                FinalWinPerBit[u1BitIdx].best_dqdly, FinalWinPerBit[u1BitIdx+1].best_dqdly,  FinalWinPerBit[u1BitIdx+8].best_dqdly, FinalWinPerBit[u1BitIdx+9].best_dqdly));
        }

        {
            U8 u1TXMCK[4] = {2,2,2,2};
            U8 u1TXOENMCK[4] = {1,1,1,1};
            U8 u1TXUI[4] = {1,1,1,1};
            U8 u1TXOENUI[4] = {5,5,5,5};
            U8 u1TXPI[4] = {30,30,30,30};

            if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
            {
                u1TXPI[0] = u1TXPI[1]= u1TXPI[2] = u1TXPI[3] =41;
            }
            else
            {
                u1TXPI[0] = u1TXPI[1]= u1TXPI[2] = u1TXPI[3] =30;
            }
            
            TXSetDelayReg_DQ(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, u1TXPI);
            TXSetDelayReg_DQM(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, u1TXPI);

            //Tx Perbits delay
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY1), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY1), 0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY3), 0x0, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY3), 0x0, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1);


            #if ENABLE_TX_TRACKING
            TXUpdateTXTracking(p, TX_DQ_DQS_MOVE_DQ_ONLY, u1TXPI, u1TXPI);
            #endif
        }

        dle_factor_handler(p, 9);
    }

    vSetRank(p, backup_rank);
}

void Apply_LP4_4266_Calibraton_Result(DRAMC_CTX_T *p)
{
    U8 u1RankIdx=0;
    // WL
    U8 u1WLB0_Dly=0, u1WLB1_Dly=0;
    // Gating
    U8 u1GatingMCKB0_Dly=0, u1GatingMCKB1_Dly=0;
    U8 u1GatingUIB0_Dly=0, u1GatingUIB1_Dly=0;
    U8 u1GatingPIB0_Dly=0, u1GatingPIB1_Dly=0;
    U8 u1B0RodtMCK=0, u1B1RodtMCK=0;
    U8 u1B0RodtUI=0, u1B1RodtUI=0;
    // Rx
    U8 u1RxDQS0=0, u1RxDQS1=0;
    U8 u1RxDQM0=0, u1RxDQM1=0;
    U8 u1RxRK0B0DQ[8] = {153,147,155,133,149,147,147,143};
    U8 u1RxRK0B1DQ[8] = {163,157,149,143,147,159,151,155};
    U8 u1RxRK1B0DQ[8] = {151,147,149,131,151,147,143,139};
    U8 u1RxRK1B1DQ[8] = {167,159,149,143,151,157,149,157};
    U8 *pRxB0DQ, *pRxB1DQ;
    U8 *pTxDQPi;
    U8 backup_rank=0;

    backup_rank = p->rank;

    ShiftDQUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQ_OENUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQSWCK_UI(p, -1, ALL_BYTES);

    for(u1RankIdx=0; u1RankIdx<p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);

#if 0
        //CBT
        DramcCmdUIDelaySetting(p, 0);
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0),
                                P_Fld(32, SHU_R0_CA_CMD0_RG_ARPI_CMD) |
                                P_Fld(0, SHU_R0_CA_CMD0_RG_ARPI_CLK));
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0), 0, SHU_R0_CA_CMD0_RG_ARPI_CS);
#endif

    #if 1
        //WL
        if (p->rank == RANK_0)
        {
            u1WLB0_Dly = 29;
            u1WLB1_Dly = 28;
        }
        else
        {
            u1WLB0_Dly = 31;
            u1WLB1_Dly = 24;
        }
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_DQ0), u1WLB0_Dly, SHU_R0_B0_DQ0_ARPI_PBYTE_B0);  //rank0, byte0, DQS delay
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_DQ0), u1WLB1_Dly, SHU_R0_B1_DQ0_ARPI_PBYTE_B1);  //rank0, byte1, DQS delay

        //Gating MCK/UI
        if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
        {
            //if (p->rank == RANK_0)
            {
                u1GatingMCKB0_Dly=0; u1GatingMCKB1_Dly=0;
                u1GatingUIB0_Dly=14; u1GatingUIB1_Dly=14;
                u1GatingPIB0_Dly=8; u1GatingPIB1_Dly=10;
                u1B0RodtMCK=0; u1B1RodtMCK=0;
                u1B0RodtUI=3; u1B1RodtUI=3;
            }
            //else
            {
            //    u1GatingMCKB0_Dly=0; u1GatingMCKB1_Dly=0;
            //    u1GatingUIB0_Dly=14; u1GatingUIB1_Dly=14;
            //    u1GatingPIB0_Dly=4; u1GatingPIB1_Dly=10;
            //    u1B0RodtMCK=0; u1B1RodtMCK=0;
            //    u1B0RodtUI=3; u1B1RodtUI=3;
            }
            
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
                P_Fld(u1GatingMCKB0_Dly,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
                P_Fld(u1GatingUIB0_Dly,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
                P_Fld(u1GatingMCKB0_Dly+1,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
                P_Fld(u1GatingUIB0_Dly+4-16,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));
            
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
                P_Fld(u1GatingMCKB1_Dly,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
                P_Fld(u1GatingUIB1_Dly,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
                P_Fld(u1GatingMCKB1_Dly+1,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
                P_Fld(u1GatingUIB1_Dly+4-16,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));
        }
        else
        {
            if (p->rank == RANK_0)
            {
                u1GatingMCKB0_Dly=1; u1GatingMCKB1_Dly=1;
                u1GatingUIB0_Dly=6; u1GatingUIB1_Dly=6;
                u1GatingPIB0_Dly=0; u1GatingPIB1_Dly=4;
                u1B0RodtMCK=1; u1B1RodtMCK=1;
                u1B0RodtUI=3; u1B1RodtUI=3;
            }
            else
            {
                u1GatingMCKB0_Dly=1; u1GatingMCKB1_Dly=1;
                u1GatingUIB0_Dly=5; u1GatingUIB1_Dly=6;
                u1GatingPIB0_Dly=28; u1GatingPIB1_Dly=0;
                u1B0RodtMCK=1; u1B1RodtMCK=1;
                u1B0RodtUI=2; u1B1RodtUI=3;
            }
            
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
                P_Fld(u1GatingMCKB0_Dly,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
                P_Fld(u1GatingUIB0_Dly,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
                P_Fld(u1GatingMCKB0_Dly,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
                P_Fld(u1GatingUIB0_Dly+4,
                SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));
            
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
                P_Fld(u1GatingMCKB1_Dly,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
                P_Fld(u1GatingUIB1_Dly,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
                P_Fld(u1GatingMCKB1_Dly,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
                P_Fld(u1GatingUIB1_Dly+4,
                SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));
        }

#if GATING_RODT_LATANCY_EN
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
                            P_Fld(u1B0RodtMCK,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
                            P_Fld(u1B0RodtUI,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
                            P_Fld(u1B0RodtMCK,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
                            P_Fld(u1B0RodtUI,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
                            P_Fld(u1B1RodtMCK,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
                            P_Fld(u1B1RodtUI,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
                            P_Fld(u1B1RodtMCK,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
                            P_Fld(u1B1RodtUI,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
#endif

        //Gating PI
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY),
                u1GatingPIB0_Dly,
                SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY),
                u1GatingPIB1_Dly,
                SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1); 

        DramPhyReset(p);

    #if RDSEL_TRACKING_EN
        //Byte 0
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_INI_UIPI),
        (u1GatingMCKB0_Dly << 3) | (u1GatingUIB0_Dly),
        SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0);//UI
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_INI_UIPI), u1GatingPIB0_Dly,
        SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0); //PI
        //Byte 1
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_INI_UIPI),
        (u1GatingMCKB1_Dly << 3) | (u1GatingUIB1_Dly),
        DDRPHY_REG_SHU_R0_B1_INI_UIPI);//UI
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_INI_UIPI),
        u1GatingPIB1_Dly, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1); //PI
    #endif

        if (p->rank == RANK_0)
        {
            u1RxDQS0=0; u1RxDQS1=0;
            u1RxDQM0=146; u1RxDQM1=153;
            pRxB0DQ = u1RxRK0B0DQ;
            pRxB1DQ = u1RxRK0B1DQ;
        }
        else
        {
            u1RxDQS0=0; u1RxDQS1=0;
            u1RxDQM0=144; u1RxDQM1=154;
            pRxB0DQ = u1RxRK1B0DQ;
            pRxB1DQ = u1RxRK1B1DQ;
        }

                // set Rx dqs delay, (dqm delay)
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY5),
                P_Fld((U32)u1RxDQS0, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY4),
                P_Fld((U32)u1RxDQM0, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
                P_Fld((U32)0, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY5),
                P_Fld((U32)u1RxDQS1, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY4),
                P_Fld((U32)u1RxDQM1, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
                P_Fld((U32)0, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));

        // set Rx dq delay
        U8 u1BitIdx;
        for (u1BitIdx = 0; u1BitIdx < DQS_BIT_NUMBER; u1BitIdx += 2)
        {
              vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY0 + u1BitIdx * 2),
                                            P_Fld(((U32)pRxB0DQ[u1BitIdx]), SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
                                            P_Fld(((U32)pRxB0DQ[u1BitIdx+1]), SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));

             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY0 + u1BitIdx * 2),
                                            P_Fld((U32)pRxB1DQ[u1BitIdx], SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
                                            P_Fld((U32)pRxB1DQ[u1BitIdx+1], SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));

            //mcSHOW_DBG_MSG(("u1BitId %d  Addr 0x%2x = %2d %2d %2d %2d \n", u1BitIdx, DDRPHY_RXDQ1+u1BitIdx*2,
            //                FinalWinPerBit[u1BitIdx].best_dqdly, FinalWinPerBit[u1BitIdx+1].best_dqdly,  FinalWinPerBit[u1BitIdx+8].best_dqdly, FinalWinPerBit[u1BitIdx+9].best_dqdly));
        }

        {
            U8 u1TXMCK[4] = {4,4,4,4};
            U8 u1TXOENMCK[4] = {4,4,4,4};
            U8 u1TXUI[4] = {6,6,6,6};
            U8 u1TXOENUI[4] = {2,2,2,2};
            U8 u1TXRK0PI[4] = {31,34,31,34};
            U8 u1TXRK1PI[4] = {33,28,33,28};

            if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
            {
                u1TXRK0PI[0] = u1TXRK0PI[1]= u1TXRK0PI[2] = u1TXRK0PI[3] =53;
                u1TXRK1PI[0] = 45;
                u1TXRK1PI[1]= u1TXRK1PI[2] = u1TXRK1PI[3] =53;
            }

            if (p->rank == RANK_0)
                pTxDQPi = u1TXRK0PI;
            else
                pTxDQPi = u1TXRK1PI;
            
            TXSetDelayReg_DQ(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, pTxDQPi);
            TXSetDelayReg_DQM(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, pTxDQPi);

            //Tx Perbits delay
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY1), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY1), 0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY3), 0x0, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY3), 0x0, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1);

            #if ENABLE_TX_TRACKING
            TXUpdateTXTracking(p, TX_DQ_DQS_MOVE_DQ_ONLY, pTxDQPi, pTxDQPi);
            #endif
        }

    if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
        dle_factor_handler(p, 16);
    else
        dle_factor_handler(p, 17);
    #endif
    }

    vSetRank(p, backup_rank);
}
#else
void Apply_LP4_1600_Calibraton_Result(DRAMC_CTX_T *p)//simulation
{
    U8 u1RankIdx=0;
    U8 backup_rank=0;

    backup_rank = p->rank;

    ShiftDQUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQ_OENUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQSWCK_UI(p, -1, ALL_BYTES);

    for(u1RankIdx=0; u1RankIdx<p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);
        //CBT
		DramcCmdUIDelaySetting(p, 0);

        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0),
    		P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) |
    		P_Fld(0, SHU_R0_CA_CMD0_RG_ARPI_CLK));
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0), 0, SHU_R0_CA_CMD0_RG_ARPI_CS);

        //WL
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_DQ0), 0x20, SHU_R0_B0_DQ0_ARPI_PBYTE_B0);  //rank0, byte0, DQS delay
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_DQ0), 0x20, SHU_R0_B1_DQ0_ARPI_PBYTE_B1);  //rank0, byte1, DQS delay

        //Gating
        if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
        {
	    if(p->rank==RANK_0)
	    {
            // normal mode
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        		P_Fld(9,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
        		P_Fld(13,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        		P_Fld(9,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
        		P_Fld(13,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));

            #if GATING_RODT_LATANCY_EN
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
            #endif
	    }
	    else
	    {
            // normal mode
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        		P_Fld(12,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        		P_Fld(1,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        		P_Fld(12,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        		P_Fld(1,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));

            #if GATING_RODT_LATANCY_EN
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        		P_Fld(1,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
        		P_Fld(1,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        		P_Fld(1,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
        		P_Fld(1,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
            #endif
	    }
        }
        else
        {
            //mix mode
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        		P_Fld(15,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        		P_Fld(1,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
        		P_Fld(3,
        		SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        		P_Fld(15,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        		P_Fld(1,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
        		P_Fld(3,
        		SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));
            
            #if GATING_RODT_LATANCY_EN
        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        		P_Fld(4,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        		P_Fld(0,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
        		P_Fld(4,
        		SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

        	vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        		P_Fld(4,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        		P_Fld(0,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
        		P_Fld(4,
        		SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
            #endif
        }
        
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY),
        	16,
        	SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY),
        	16,
        	SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);

    	DramPhyReset(p);

    	// set dqs delay, (dqm delay)
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY5),
                P_Fld((U32)0x45, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY4),
                P_Fld((U32)0x0, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY5),
                P_Fld((U32)0x45, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY4),
                P_Fld((U32)0x0, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1));

        // set dq delay
        U8 u1BitIdx;
        for (u1BitIdx = 0; u1BitIdx < DQS_BIT_NUMBER; u1BitIdx += 2)
        {
             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY0 + u1BitIdx * 2),
                                            P_Fld(((U32)0x0), SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
                                            P_Fld(((U32)0x0), SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));

             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY0 + u1BitIdx * 2),
                                            P_Fld((U32)0x0, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
                                            P_Fld((U32)0x0, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));

            //mcSHOW_DBG_MSG(("u1BitId %d  Addr 0x%2x = %2d %2d %2d %2d \n", u1BitIdx, DDRPHY_RXDQ1+u1BitIdx*2,
            //                FinalWinPerBit[u1BitIdx].best_dqdly, FinalWinPerBit[u1BitIdx+1].best_dqdly,  FinalWinPerBit[u1BitIdx+8].best_dqdly, FinalWinPerBit[u1BitIdx+9].best_dqdly));
        }

        {
            U8 u1TXMCK[4] = {2,2,2,2};
            U8 u1TXOENMCK[4] = {1,1,1,1};
            U8 u1TXUI[4] = {1,1,1,1};
            U8 u1TXOENUI[4] = {5,5,5,5};
            U8 u1TXPI[4] = {30,30,30,30};

            if((p->dram_cbt_mode[RANK_0] == CBT_NORMAL_MODE) && (p->dram_cbt_mode[RANK_1] == CBT_NORMAL_MODE))
            {
                u1TXPI[0] = u1TXPI[1]= u1TXPI[2] = u1TXPI[3] =30;
            }
            else
            {
                u1TXPI[0] = u1TXPI[1]= u1TXPI[2] = u1TXPI[3] =30;
            }

            if(p->rank==RANK_1)
            {
                u1TXPI[0] = u1TXPI[1]= u1TXPI[2] = u1TXPI[3] =50;
            }
            
            TXSetDelayReg_DQ(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, u1TXPI);
            TXSetDelayReg_DQM(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, u1TXPI);

            //Tx Perbits delay
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY1), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY1), 0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY3), 0x0, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY3), 0x0, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1);


            #if ENABLE_TX_TRACKING
            TXUpdateTXTracking(p, TX_DQ_DQS_MOVE_DQ_ONLY, u1TXPI, u1TXPI);
            #endif
        }

        dle_factor_handler(p, 8);
    }

    vSetRank(p, backup_rank);
}

void Apply_LP4_4266_Calibraton_Result(DRAMC_CTX_T *p)//simulation 
{
    U8 u1RankIdx=0;
    // WL
    U8 u1WLB0_Dly=0, u1WLB1_Dly=0;
    // Gating
    U8 u1GatingMCKB0_Dly=0, u1GatingMCKB1_Dly=0;
    U8 u1GatingUIB0_Dly=0, u1GatingUIB1_Dly=0;
    U8 u1GatingPIB0_Dly=0, u1GatingPIB1_Dly=0;
    U8 u1B0RodtMCK=0, u1B1RodtMCK=0;
    U8 u1B0RodtUI=0, u1B1RodtUI=0;
    // Rx
    U8 u1RxDQS0=0, u1RxDQS1=0;
    U8 u1RxDQM0=0, u1RxDQM1=0;
    U8 u1RxRK0B0DQ[8] = {70,70,70,70,70,70,70,70};
    U8 u1RxRK0B1DQ[8] = {70,70,70,70,70,70,70,70};
    U8 u1RxRK1B0DQ[8] = {70,70,70,70,70,70,70,70};
    U8 u1RxRK1B1DQ[8] = {70,70,70,70,70,70,70,70};
    U8 *pRxB0DQ, *pRxB1DQ;
    U8 *pTxDQPi;
    U8 backup_rank=0;

    backup_rank = p->rank;

    ShiftDQUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQ_OENUI_AllRK(p, -1, ALL_BYTES);
    ShiftDQSWCK_UI(p, -1, ALL_BYTES);

    for(u1RankIdx=0; u1RankIdx<p->support_rank_num; u1RankIdx++)
    {
        vSetRank(p, u1RankIdx);

#if 1
        //CBT
        //DramcCmdUIDelaySetting(p, 0);
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0),
                                P_Fld(40, SHU_R0_CA_CMD0_RG_ARPI_CMD) |
                                P_Fld(0, SHU_R0_CA_CMD0_RG_ARPI_CLK));
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_CA_CMD0), 0, SHU_R0_CA_CMD0_RG_ARPI_CS);
#endif

    #if 1
        //WL
        if (p->rank == RANK_0)
        {
            u1WLB0_Dly = 34;
            u1WLB1_Dly = 38;
        }
        else
        {
            u1WLB0_Dly = 37;
            u1WLB1_Dly = 32;
        }
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_DQ0), u1WLB0_Dly, SHU_R0_B0_DQ0_ARPI_PBYTE_B0);  //rank0, byte0, DQS delay
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_DQ0), u1WLB1_Dly, SHU_R0_B1_DQ0_ARPI_PBYTE_B1);  //rank0, byte1, DQS delay

        //Gating MCK/UI
        if (p->rank == RANK_0)
        {
            u1GatingMCKB0_Dly=0; u1GatingMCKB1_Dly=0;
            u1GatingUIB0_Dly=9; u1GatingUIB1_Dly=9;
            u1GatingPIB0_Dly=16; u1GatingPIB1_Dly=16;
            u1B0RodtMCK=0; u1B1RodtMCK=0;
            u1B0RodtUI=0; u1B1RodtUI=0;
        }
        else
        {
            u1GatingMCKB0_Dly=1; u1GatingMCKB1_Dly=1;
            u1GatingUIB0_Dly=2; u1GatingUIB1_Dly=2;
            u1GatingPIB0_Dly=0; u1GatingPIB1_Dly=0;
            u1B0RodtMCK=1; u1B1RodtMCK=1;
            u1B0RodtUI=3; u1B1RodtUI=3;
        }
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY),
            P_Fld(u1GatingMCKB0_Dly,
            SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(u1GatingUIB0_Dly,
            SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(((u1GatingMCKB0_Dly<<4)+u1GatingUIB0_Dly+4)>>4,
            SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0) |
            P_Fld(((u1GatingMCKB0_Dly<<4)+u1GatingUIB0_Dly+4)%16,
            SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0));
        
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY),
            P_Fld(u1GatingMCKB1_Dly,
            SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(u1GatingUIB1_Dly,
            SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(((u1GatingMCKB1_Dly<<4)+u1GatingUIB1_Dly+4)>>4,
            SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1) |
            P_Fld(((u1GatingMCKB1_Dly<<4)+u1GatingUIB1_Dly+4)%16,
            SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1));

#if GATING_RODT_LATANCY_EN
            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY),
                            P_Fld(u1B0RodtMCK,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
                            P_Fld(u1B0RodtUI,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
                            P_Fld(u1B0RodtMCK,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0) |
                            P_Fld(u1B0RodtUI,
                            SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0));

            vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY),
                            P_Fld(u1B1RodtMCK,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
                            P_Fld(u1B1RodtUI,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
                            P_Fld(u1B1RodtMCK,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1) |
                            P_Fld(u1B1RodtUI,
                            SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1));
#endif

        //Gating PI
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY),
                u1GatingPIB0_Dly,
                SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
        vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY),
                u1GatingPIB1_Dly,
                SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1); 

        DramPhyReset(p);


        if (p->rank == RANK_0)
        {
            u1RxDQS0=0; u1RxDQS1=0;
            u1RxDQM0=70; u1RxDQM1=70;
            pRxB0DQ = u1RxRK0B0DQ;
            pRxB1DQ = u1RxRK0B1DQ;
        }
        else
        {
            u1RxDQS0=0; u1RxDQS1=0;
            u1RxDQM0=70; u1RxDQM1=70;
            pRxB0DQ = u1RxRK1B0DQ;
            pRxB1DQ = u1RxRK1B1DQ;
        }

                // set Rx dqs delay, (dqm delay)
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY5),
                P_Fld((U32)u1RxDQS0, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY4),
                P_Fld((U32)u1RxDQM0, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
                P_Fld((U32)0, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY5),
                P_Fld((U32)u1RxDQS1, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1));
        vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY4),
                P_Fld((U32)u1RxDQM1, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
                P_Fld((U32)0, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));

        // set Rx dq delay
        U8 u1BitIdx;
        for (u1BitIdx = 0; u1BitIdx < DQS_BIT_NUMBER; u1BitIdx += 2)
        {
              vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_RXDLY0 + u1BitIdx * 2),
                                            P_Fld(((U32)pRxB0DQ[u1BitIdx]), SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
                                            P_Fld(((U32)pRxB0DQ[u1BitIdx+1]), SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));

             vIO32WriteFldMulti(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_RXDLY0 + u1BitIdx * 2),
                                            P_Fld((U32)pRxB1DQ[u1BitIdx], SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
                                            P_Fld((U32)pRxB1DQ[u1BitIdx+1], SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));

            //mcSHOW_DBG_MSG(("u1BitId %d  Addr 0x%2x = %2d %2d %2d %2d \n", u1BitIdx, DDRPHY_RXDQ1+u1BitIdx*2,
            //                FinalWinPerBit[u1BitIdx].best_dqdly, FinalWinPerBit[u1BitIdx+1].best_dqdly,  FinalWinPerBit[u1BitIdx+8].best_dqdly, FinalWinPerBit[u1BitIdx+9].best_dqdly));
        }

        {
            U8 u1TXMCK[4] = {4,4,4,4};
            U8 u1TXOENMCK[4] = {4,4,4,4};
            U8 u1TXUI[4] = {6,6,6,6 };
            U8 u1TXOENUI[4] = {2,2,2,2};
            U8 u1TXRK0PI[4] = {28,28,28,28};
                        

            U8 u1TXMCK_RK1[4] = {4,4,4,4};
            U8 u1TXOENMCK_RK1[4] = {4,4,4,4};
            U8 u1TXUI_RK1[4] = {7,7,7,7};
            U8 u1TXOENUI_RK1[4] = {3,3,3,3};
            U8 u1TXRK1PI[4] = {46,46,46,46};

            if (p->rank == RANK_0)
            {
                pTxDQPi = u1TXRK0PI;
                
                TXSetDelayReg_DQ(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, pTxDQPi);
                TXSetDelayReg_DQM(p, 1, u1TXMCK, u1TXOENMCK, u1TXUI, u1TXOENUI, pTxDQPi);
            }
            else
            {
                pTxDQPi = u1TXRK1PI;
                TXSetDelayReg_DQ(p, 1, u1TXMCK_RK1, u1TXOENMCK_RK1, u1TXUI_RK1, u1TXOENUI_RK1, pTxDQPi);
                TXSetDelayReg_DQM(p, 1, u1TXMCK_RK1, u1TXOENMCK_RK1, u1TXUI_RK1, u1TXOENUI_RK1, pTxDQPi);
            }
            
            //Tx Perbits delay
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY1), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY0), 0);
            vIO32Write4B(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY1), 0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B0_TXDLY3), 0x0, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0);
            vIO32WriteFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_SHU_R0_B1_TXDLY3), 0x0, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1);
        }

        dle_factor_handler(p, 14);
    #endif
    }

    vSetRank(p, backup_rank);
}

#endif
#endif

void sv_algorithm_assistance_LP4_1600(DRAMC_CTX_T *p){
//    Enter body
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Enter:
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_MISC_RDSEL_TRACK_0                         ral_reg_DDRPHY_blk_SHU_MISC_RDSEL_TRACK_0                  -     @13206                                                     
  DMDATLAT_i                                   uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[4:0]=5'h09 (Mirror: 5'h00)      
  RDSEL_HWSAVE_MSK                             uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[6:6]=1'h1 (Mirror: 1'h0)        
  RDSEL_TRACK_EN                               uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[7:7]=1'h0                       
  SHU_GW_THRD_NEG                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[19:8]=12'hfeb (Mirror: 12'h000) 
  SHU_GW_THRD_POS                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[31:20]=12'h015 (Mirror: 12'h000)
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, P_Fld(0x09, SHU_MISC_RDSEL_TRACK_DMDATLAT_I) |
        P_Fld(0x1, SHU_MISC_RDSEL_TRACK_RDSEL_HWSAVE_MSK) | P_Fld(0x0, SHU_MISC_RDSEL_TRACK_RDSEL_TRACK_EN) |
        P_Fld(0xfeb, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_NEG) | P_Fld(0x015, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_POS));
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RDAT_0                                ral_reg_DDRPHY_blk_MISC_SHU_RDAT_0                         -     @13076                                                     
  DATLAT                                       uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[4:0]=5'h09 (Mirror: 5'h00)             
  DATLAT_DSEL                                  uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[12:8]=5'h09 (Mirror: 5'h00)            
  DATLAT_DSEL_PHY                              uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[20:16]=5'h09 (Mirror: 5'h00)           
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RDAT, P_Fld(0x09, MISC_SHU_RDAT_DATLAT) |
        P_Fld(0x09, MISC_SHU_RDAT_DATLAT_DSEL) | P_Fld(0x09, MISC_SHU_RDAT_DATLAT_DSEL_PHY));
#endif
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_PHY_RX_CTRL_0                         ral_reg_DDRPHY_blk_MISC_SHU_PHY_RX_CTRL_0                  -     @13012                                                     
  RANK_RXDLY_UPDLAT_EN                         uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[8:8]=1'h1 (Mirror: 1'h0)        
  RANK_RXDLY_UPD_OFFSET                        uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[11:9]=3'h2 (Mirror: 3'h0)       
  RX_IN_GATE_EN_PRE_OFFSET                     uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[15:14]=2'h2 (Mirror: 2'h0)      
  RX_IN_GATE_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[18:16]=3'h0                     
  RX_IN_GATE_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[22:20]=3'h1 (Mirror: 3'h0)      
  RX_IN_BUFF_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[26:24]=3'h0                     
  RX_IN_BUFF_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[30:28]=3'h0                     
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL, P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPDLAT_EN) |
        P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPD_OFFSET) | P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET) |
        P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD) | P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
        P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) | P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_TAIL));
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RANKCTL_0                             ral_reg_DDRPHY_blk_MISC_SHU_RANKCTL_0                      -     @13002                                                     
  RANKINCTL_RXDLY                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[3:0]=4'h0                           
  RANK_RXDLY_OPT                               uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[4:4]=1'h1                           
  RANKSEL_SELPH_FRUN                           uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[15:15]=1'h1 (Mirror: 1'h0)          
  RANKINCTL_STB                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[19:16]=4'h1 (Mirror: 4'h0)          
  RANKINCTL                                    uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[23:20]=4'h0                         
  RANKINCTL_ROOT1                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[27:24]=4'h0                         
  RANKINCTL_PHY                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[31:28]=4'h3 (Mirror: 4'h0)          
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x0, MISC_SHU_RANKCTL_RANKINCTL_RXDLY) |
        P_Fld(0x1, MISC_SHU_RANKCTL_RANK_RXDLY_OPT) | P_Fld(0x1, MISC_SHU_RANKCTL_RANKSEL_SELPH_FRUN) |
        P_Fld(0x1, MISC_SHU_RANKCTL_RANKINCTL_STB));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x0, MISC_SHU_RANKCTL_RANKINCTL) |
        P_Fld(0x0, MISC_SHU_RANKCTL_RANKINCTL_ROOT1) | P_Fld(0x3, MISC_SHU_RANKCTL_RANKINCTL_PHY));

#endif
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RANK_SEL_LAT_0                        ral_reg_DDRPHY_blk_MISC_SHU_RANK_SEL_LAT_0                 -     @13229                                                     
  RANK_SEL_LAT_B0                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[3:0]=4'h2 (Mirror: 4'h0)       
  RANK_SEL_LAT_B1                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[7:4]=4'h2 (Mirror: 4'h0)       
  RANK_SEL_LAT_CA                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[11:8]=4'h2 (Mirror: 4'h0)      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANK_SEL_LAT, P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B0) |
        P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B1) | P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_CA));

#if !CODE_SIZE_REDUCE
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RK_DQSCTL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_0                  -     @12823                                                     
  DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_0[3:0]=4'h2 (Mirror: 4'h0)        
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL, 0x2, MISC_SHU_RK_DQSCTL_DQSINCTL);
/*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                      
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RK_DQSCTL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_1                  -     @12827                                                     
  DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_1[3:0]=4'h2 (Mirror: 4'h0)        
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL+(1*DDRPHY_AO_RANK_OFFSET), 0x2, MISC_SHU_RK_DQSCTL_DQSINCTL);
/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                       
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0         -     @8022                                                       
  DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h9 (Mirror: 4'h0)
  DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'hd (Mirror: 4'h0)
  DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h0             
  DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h0             
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY, P_Fld(0x9, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        P_Fld(0xd, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                       
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_0             -     @8036                                                       
  DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_0[6:0]=7'h0b (Mirror: 7'h00)  
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY, 0x0b, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1         -     @8029                                                         
  DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'hc (Mirror: 4'h0)  
  DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'h0                 
  DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h0               
  DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
        P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
        P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_1             -     @8040                                                         
  DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_1[6:0]=7'h11 (Mirror: 7'h00)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x11, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0         -     @9429                                                         
  DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h9 (Mirror: 4'h0)  
  DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'hd (Mirror: 4'h0)  
  DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h0               
  DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h0               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY, P_Fld(0x9, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        P_Fld(0xd, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_0             -     @9443                                                         
  DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_0[6:0]=7'h0b (Mirror: 7'h00)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY, 0x0b, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1         -     @9436                                                         
  DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'hc (Mirror: 4'h0)  
  DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'h0                 
  DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h0               
  DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
        P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
        P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_1             -     @9447                                                         
  DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_1[6:0]=7'h11 (Mirror: 7'h00)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x11, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_ODTCTRL_0                             ral_reg_DDRPHY_blk_MISC_SHU_ODTCTRL_0                      -     @13022                                                        
  RODTEN                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[0:0]=1'h1 (Mirror: 1'h0)               
  RODTENSTB_SELPH_CG_IG                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[1:1]=1'h0                              
  RODT_LAT                                     uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[7:4]=4'h1 (Mirror: 4'h0)               
  RODTEN_SELPH_FRUN                            uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[15:15]=1'h0                            
  RODTDLY_LAT_OPT                              uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[25:24]=2'h0                            
  FIXRODT                                      uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[27:27]=1'h0                            
  RODTEN_OPT                                   uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[29:29]=1'h1                            
  RODTE2                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[30:30]=1'h1 (Mirror: 1'h0)             
  RODTE                                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[31:31]=1'h1 (Mirror: 1'h0)             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_ODTCTRL, P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN) |
        P_Fld(0x0, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG) |
        P_Fld(0x0, MISC_SHU_ODTCTRL_RODTEN_SELPH_FRUN) | P_Fld(0x0, MISC_SHU_ODTCTRL_RODTDLY_LAT_OPT) |
        P_Fld(0x0, MISC_SHU_ODTCTRL_FIXRODT) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN_OPT) |
        P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE2) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE));

#if !CODE_SIZE_REDUCE
vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, 0x1, MISC_SHU_ODTCTRL_RODT_LAT);
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B0_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ7_0                            -     @8206                                                         
  R_DMRANKRXDVS_B0                             uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[3:0]=4'h0                                    
  R_DMDQMDBI_EYE_SHU_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[6:6]=1'h0                                    
  R_DMDQMDBI_SHU_B0                            uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[7:7]=1'h0                                    
  R_DMRXDVS_DQM_FLAGSEL_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[11:8]=4'h0                                   
  R_DMRXDVS_PBYTE_FLAG_OPT_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[12:12]=1'h0                                  
  R_DMRXDVS_PBYTE_DQM_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[13:13]=1'h0                                  
  R_DMRXTRACK_DQM_EN_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[14:14]=1'h0                                  
  R_DMRODTEN_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
  R_DMARPI_CG_FB2DLL_DCM_EN_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[16:16]=1'h0                                  
  R_DMTX_ARPI_CG_DQ_NEW_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[17:17]=1'h0                                  
  R_DMTX_ARPI_CG_DQS_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[18:18]=1'h0                                  
  R_DMTX_ARPI_CG_DQM_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[19:19]=1'h0                                  
  R_LP4Y_SDN_MODE_DQS0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[20:20]=1'h0                                  
  R_DMRXRANK_DQ_EN_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
  R_DMRXRANK_DQ_LAT_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                   
  R_DMRXRANK_DQS_EN_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
  R_DMRXRANK_DQS_LAT_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[31:29]=3'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRANKRXDVS_B0) |
        P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_EYE_SHU_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_SHU_B0) |
        P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0) |
        P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXTRACK_DQM_EN_B0) |
        P_Fld(0x1, SHU_B0_DQ7_R_DMRODTEN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B0) |
        P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0) |
        P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_LP4Y_SDN_MODE_DQS0) |
        P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_EN_B0) | P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_LAT_B0) |
        P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQS_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXRANK_DQS_LAT_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B1_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ7_0                            -     @9613                                                         
  R_DMRANKRXDVS_B1                             uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[3:0]=4'h0                                    
  R_DMDQMDBI_EYE_SHU_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[6:6]=1'h0                                    
  R_DMDQMDBI_SHU_B1                            uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[7:7]=1'h0                                    
  R_DMRXDVS_DQM_FLAGSEL_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[11:8]=4'h0                                   
  R_DMRXDVS_PBYTE_FLAG_OPT_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[12:12]=1'h0                                  
  R_DMRXDVS_PBYTE_DQM_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[13:13]=1'h0                                  
  R_DMRXTRACK_DQM_EN_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[14:14]=1'h0                                  
  R_DMRODTEN_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
  R_DMARPI_CG_FB2DLL_DCM_EN_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[16:16]=1'h0                                  
  R_DMTX_ARPI_CG_DQ_NEW_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[17:17]=1'h0                                  
  R_DMTX_ARPI_CG_DQS_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[18:18]=1'h0                                  
  R_DMTX_ARPI_CG_DQM_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[19:19]=1'h0                                  
  R_LP4Y_SDN_MODE_DQS1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[20:20]=1'h0                                  
  R_DMRXRANK_DQ_EN_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
  R_DMRXRANK_DQ_LAT_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                   
  R_DMRXRANK_DQS_EN_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
  R_DMRXRANK_DQS_LAT_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[31:29]=3'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRANKRXDVS_B1) |
        P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_EYE_SHU_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_SHU_B1) |
        P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1) |
        P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXTRACK_DQM_EN_B1) |
        P_Fld(0x1, SHU_B1_DQ7_R_DMRODTEN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B1) |
        P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1) |
        P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_LP4Y_SDN_MODE_DQS1) |
        P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_EN_B1) | P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_LAT_B1) |
        P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQS_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXRANK_DQS_LAT_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_MISC_RX_PIPE_CTRL_0                        ral_reg_DDRPHY_blk_SHU_MISC_RX_PIPE_CTRL_0                 -     @13176                                                        
  RX_PIPE_BYPASS_EN                            uvm_reg_field                                              ...    RW SHU_MISC_RX_PIPE_CTRL_0[0:0]=1'h1 (Mirror: 1'h0)          
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RX_PIPE_CTRL, 0x1, SHU_MISC_RX_PIPE_CTRL_RX_PIPE_BYPASS_EN);
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0         -     @8044                                                         
  RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h4 (Mirror: 3'h0)  
  RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h4 (Mirror: 3'h0)  
  RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
  RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY, P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1         -     @8051                                                         
  RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h7 (Mirror: 3'h0)  
  RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h7 (Mirror: 3'h0)  
  RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h0               
  RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
        P_Fld(0x7, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
        P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0         -     @9451                                                         
  RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h4 (Mirror: 3'h0)  
  RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h4 (Mirror: 3'h0)  
  RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
  RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY, P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1         -     @9458                                                         
  RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h7 (Mirror: 3'h0)  
  RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h7 (Mirror: 3'h0)  
  RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h0               
  RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
        P_Fld(0x7, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
        P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_RX_CG_SET0_0                               ral_reg_DRAMC_blk_SHU_RX_CG_SET0_0                         -     @5628                                                         
  DLE_LAST_EXTEND3                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[0:0]=1'h0                                
  READ_START_EXTEND3                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[1:1]=1'h0                                
  DLE_LAST_EXTEND2                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[2:2]=1'h0                                
  READ_START_EXTEND2                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[3:3]=1'h0                                
  DLE_LAST_EXTEND1                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[4:4]=1'h1 (Mirror: 1'h0)                 
  READ_START_EXTEND1                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[5:5]=1'h1 (Mirror: 1'h0)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DRAMC_REG_SHU_RX_CG_SET0, P_Fld(0x0, SHU_RX_CG_SET0_DLE_LAST_EXTEND3) |
        P_Fld(0x0, SHU_RX_CG_SET0_READ_START_EXTEND3) | P_Fld(0x0, SHU_RX_CG_SET0_DLE_LAST_EXTEND2) |
        P_Fld(0x0, SHU_RX_CG_SET0_READ_START_EXTEND2) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND1) |
        P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND1));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_MISC_RANK_SEL_STB_0                        ral_reg_DDRPHY_blk_SHU_MISC_RANK_SEL_STB_0                 -     @13192                                                        
  RANK_SEL_STB_EN                              uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[0:0]=1'h1 (Mirror: 1'h0)          
  RANK_SEL_STB_EN_B23                          uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[1:1]=1'h0                         
  RANK_SEL_STB_SERMODE                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[3:2]=2'h0                         
  RANK_SEL_STB_TRACK                           uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[4:4]=1'h1 (Mirror: 1'h0)          
  RANK_SEL_RXDLY_TRACK                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[5:5]=1'h0                         
  RANK_SEL_STB_PHASE_EN                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[7:7]=1'h0                         
  RANK_SEL_PHSINCTL                            uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[11:8]=4'h1 (Mirror: 4'h0)         
  RANK_SEL_STB_UI_PLUS                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[19:16]=4'h0                       
  RANK_SEL_STB_MCK_PLUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[23:20]=4'h0                       
  RANK_SEL_STB_UI_MINUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[27:24]=4'h0                       
  RANK_SEL_STB_MCK_MINUS                       uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[31:28]=4'h0                       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN) |
        P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN_B23) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_SERMODE) |
        P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_TRACK) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_RXDLY_TRACK) |
        P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_PHASE_EN) | P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_PHSINCTL) |
        P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_PLUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_PLUS) |
        P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_MINUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_MINUS));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RK_DQSCAL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_0                  -     @12841                                                        
  DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[6:0]=7'h60 (Mirror: 7'h00)         
  DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[7:7]=1'h1 (Mirror: 1'h0)           
  DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[14:8]=7'h3f (Mirror: 7'h00)        
  DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[15:15]=1'h1 (Mirror: 1'h0)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL, P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
        P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
        P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MISC_SHU_RK_DQSCAL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_1                  -     @12848                                                        
  DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[6:0]=7'h60 (Mirror: 7'h00)         
  DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[7:7]=1'h1 (Mirror: 1'h0)           
  DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[14:8]=7'h3f (Mirror: 7'h00)        
  DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[15:15]=1'h1 (Mirror: 1'h0)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
        P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
        P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_0                  -     @8000                                                         
  CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)         
  CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[15:8]=8'h09 (Mirror: 8'h00)        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI, P_Fld(0x0b, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
        P_Fld(0x09, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_0                  -     @9407                                                         
  CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)         
  CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[15:8]=8'h09 (Mirror: 8'h00)        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI, P_Fld(0x0b, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
        P_Fld(0x09, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_1                  -     @8005                                                         
  CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[6:0]=7'h11 (Mirror: 7'h00)         
  CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[15:8]=8'h0c (Mirror: 8'h00)        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x11, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
        P_Fld(0x0c, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_1                  -     @9412                                                         
  CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[6:0]=7'h11 (Mirror: 7'h00)         
  CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[15:8]=8'h0c (Mirror: 8'h00)        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x11, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
        P_Fld(0x0c, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_0             -     @8010                                                         
  NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)    
  NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[15:8]=8'h09 (Mirror: 8'h00)   
  NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[31:24]=8'h0d (Mirror: 8'h00)  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI, P_Fld(0x0b, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
        P_Fld(0x09, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x0d, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_0             -     @9417                                                         
  NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)    
  NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[15:8]=8'h09 (Mirror: 8'h00)   
  NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[31:24]=8'h0d (Mirror: 8'h00)  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI, P_Fld(0x0b, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
        P_Fld(0x09, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x0d, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_1             -     @8016                                                         
  NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[6:0]=7'h11 (Mirror: 7'h00)    
  NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[15:8]=8'h0c (Mirror: 8'h00)   
  NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[31:24]=8'h10 (Mirror: 8'h00)  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x11, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
        P_Fld(0x0c, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x10, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_1             -     @9423                                                         
  NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[6:0]=7'h11 (Mirror: 7'h00)    
  NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[15:8]=8'h0c (Mirror: 8'h00)   
  NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[31:24]=8'h10 (Mirror: 8'h00)  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x11, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
        P_Fld(0x0c, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x10, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Exit:
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Enter:
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_CA_CMD0_0_0                             ral_reg_DDRPHY_blk_SHU_R0_CA_CMD0_0_0                      -     @10832                                                        
  RG_RX_ARCLK_R_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[2:0]=3'h0                              
  RG_RX_ARCLK_F_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[6:4]=3'h0                              
  RG_ARPI_CS                                   uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[13:8]=6'h00                            
  RG_ARPI_CMD                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[21:16]=6'h20 (Mirror: 6'h00)           
  RG_ARPI_CLK                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[29:24]=6'h00                           
  DA_ARPI_DDR400_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[30:30]=1'h0                            
  DA_RX_ARDQSIEN_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[31:31]=1'h0                            
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0, P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_CA_CMD0_DA_ARPI_DDR400_0D5UI_RK0_CA) | P_Fld(0x0, SHU_R0_CA_CMD0_DA_RX_ARDQSIEN_0D5UI_RK0_CA));
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0, P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CS) |
        P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) | P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CLK));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_0                       -     @7980                                                         
  RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[2:0]=3'h0                               
  RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[6:4]=3'h0                               
  SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[13:8]=6'h19 (Mirror: 6'h00)             
  SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[21:16]=6'h19 (Mirror: 6'h00)            
  ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[29:24]=6'h00                            
  DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[30:30]=1'h0                             
  DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[31:31]=1'h0                             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x19, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
        P_Fld(0x19, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_0                       -     @9387                                                         
  RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[2:0]=3'h0                               
  RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[6:4]=3'h0                               
  SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[13:8]=6'h1f (Mirror: 6'h00)             
  SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[21:16]=6'h1f (Mirror: 6'h00)            
  ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[29:24]=6'h00                            
  DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[30:30]=1'h0                             
  DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[31:31]=1'h0                             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x1f, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
        P_Fld(0x1f, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_CA_CMD0_0_1                             ral_reg_DDRPHY_blk_SHU_R0_CA_CMD0_0_1                      -     @10842                                                        
  RG_RX_ARCLK_R_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[2:0]=3'h0                              
  RG_RX_ARCLK_F_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[6:4]=3'h0                              
  RG_ARPI_CS                                   uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[13:8]=6'h00                            
  RG_ARPI_CMD                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[21:16]=6'h20 (Mirror: 6'h00)           
  RG_ARPI_CLK                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[29:24]=6'h00                           
  DA_ARPI_DDR400_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[30:30]=1'h0                            
  DA_RX_ARDQSIEN_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[31:31]=1'h0                            
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_CA_CMD0_DA_ARPI_DDR400_0D5UI_RK0_CA) | P_Fld(0x0, SHU_R0_CA_CMD0_DA_RX_ARDQSIEN_0D5UI_RK0_CA));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CS) |
        P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) | P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CLK));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_1                       -     @7990                                                         
  RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[2:0]=3'h0                               
  RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[6:4]=3'h0                               
  SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[13:8]=6'h13 (Mirror: 6'h00)             
  SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[21:16]=6'h13 (Mirror: 6'h00)            
  ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[29:24]=6'h00                            
  DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[30:30]=1'h0                             
  DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[31:31]=1'h0                             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x13, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
        P_Fld(0x13, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_1                       -     @9397                                                         
  RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[2:0]=3'h0                               
  RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[6:4]=3'h0                               
  SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[13:8]=6'h12 (Mirror: 6'h00)             
  SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[21:16]=6'h12 (Mirror: 6'h00)            
  ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[29:24]=6'h00                            
  DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[30:30]=1'h0                             
  DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[31:31]=1'h0                             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
        P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x12, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
        P_Fld(0x12, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_DCM_CTRL0_0                                ral_reg_DRAMC_blk_SHU_DCM_CTRL0_0                          -     @5331                                                         
  DDRPHY_CLK_EN_OPT                            uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[7:7]=1'h1 (Mirror: 1'h0)                  
  DPHY_CMD_CLKEN_EXTCNT                        uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[10:8]=3'h3                                
  DDRPHY_CLK_DYN_GATING_SEL                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[15:12]=4'h5 (Mirror: 4'h0)                
  APHYPI_CKCGL_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[19:16]=4'h2                               
  APHYPI_CKCGH_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[23:20]=4'h4                               
  FASTWAKE2                                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[29:29]=1'h0                               
  FASTWAKE                                     uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[31:31]=1'h1                               
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_DCM_CTRL0, P_Fld(0x1, SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT) |
        P_Fld(0x3, SHU_DCM_CTRL0_DPHY_CMD_CLKEN_EXTCNT) | P_Fld(0x5, SHU_DCM_CTRL0_DDRPHY_CLK_DYN_GATING_SEL) |
        P_Fld(0x2, SHU_DCM_CTRL0_APHYPI_CKCGL_CNT) | P_Fld(0x4, SHU_DCM_CTRL0_APHYPI_CKCGH_CNT) |
        P_Fld(0x0, SHU_DCM_CTRL0_FASTWAKE2) | P_Fld(0x1, SHU_DCM_CTRL0_FASTWAKE));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_APHY_TX_PICG_CTRL_0                        ral_reg_DRAMC_blk_SHU_APHY_TX_PICG_CTRL_0                  -     @5683                                                         
  DDRPHY_CLK_EN_COMB_TX_PICG_CNT               uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[3:0]=4'h3 (Mirror: 4'h0)          
  DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[6:4]=3'h1 (Mirror: 3'h0)          
  DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[10:8]=3'h0                        
  DPHY_TX_DCM_EXTCNT                           uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[15:12]=4'h2                       
  DDRPHY_CLK_EN_COMB_TX_OPT                    uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[31:31]=1'h1 (Mirror: 1'h0)        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_APHY_TX_PICG_CTRL, P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT) |
        P_Fld(0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1) | P_Fld(0x0, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0) |
        P_Fld(0x2, SHU_APHY_TX_PICG_CTRL_DPHY_TX_DCM_EXTCNT) | P_Fld(0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_APHY_TX_PICG_CTRL_0_0                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_0              -     @5221                                                         
  DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[2:0]=3'h1 (Mirror: 3'h0)      
  DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[6:4]=3'h0                     
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL, P_Fld(0x1, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
        P_Fld(0x0, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_APHY_TX_PICG_CTRL_0_1                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_1              -     @5226                                                         
  DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[2:0]=3'h1 (Mirror: 3'h0)      
  DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[6:4]=3'h1 (Mirror: 3'h0)      
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x1, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
        P_Fld(0x1, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_NEW_XRW2W_CTRL_0                           ral_reg_DRAMC_blk_SHU_NEW_XRW2W_CTRL_0                     -     @5677                                                         
  TX_PI_UPDCTL_B0                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[18:16]=3'h0                          
  TX_PI_UPDCTL_B1                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[26:24]=3'h0                          
  TXPI_UPD_MODE                                uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[31:31]=1'h0 (Mirror: 1'h1)           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_NEW_XRW2W_CTRL, P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B0) |
        P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B1) | P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TXPI_UPD_MODE));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_SELPH_DQS0_0                               ral_reg_DRAMC_blk_SHU_SELPH_DQS0_0                         -     @5576                                                         
  TXDLY_DQS0                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[2:0]=3'h2 (Mirror: 3'h1)                 
  TXDLY_DQS1                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[6:4]=3'h2 (Mirror: 3'h1)                 
  TXDLY_DQS2                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[10:8]=3'h1                               
  TXDLY_DQS3                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[14:12]=3'h1                              
  TXDLY_OEN_DQS0                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[18:16]=3'h1                              
  TXDLY_OEN_DQS1                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[22:20]=3'h1                              
  TXDLY_OEN_DQS2                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[26:24]=3'h1                              
  TXDLY_OEN_DQS3                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[30:28]=3'h1                              
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS2) |
        P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS3) | P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS2) |
        P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS3));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x2, SHU_SELPH_DQS0_TXDLY_DQS0) |
        P_Fld(0x2, SHU_SELPH_DQS0_TXDLY_DQS1) | P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS0) |
        P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS1));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_SELPH_DQS1_0                               ral_reg_DRAMC_blk_SHU_SELPH_DQS1_0                         -     @5587                                                         
  dly_DQS0                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[3:0]=4'h1                                
  dly_DQS1                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[7:4]=4'h1                                
  dly_DQS2                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[11:8]=4'h1                               
  dly_DQS3                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[15:12]=4'h1                              
  dly_oen_DQS0                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[19:16]=4'h6 (Mirror: 4'h1)               
  dly_oen_DQS1                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[23:20]=4'h6 (Mirror: 4'h1)               
  dly_oen_DQS2                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[27:24]=4'h1                              
  dly_oen_DQS3                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[31:28]=4'h1                              
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS1, P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS2) |
        P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS3) | P_Fld(0x1, SHU_SELPH_DQS1_DLY_OEN_DQS2) |
        P_Fld(0x1, SHU_SELPH_DQS1_DLY_OEN_DQS3));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS1, P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS0) |
        P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS1) | P_Fld(0x6, SHU_SELPH_DQS1_DLY_OEN_DQS0) |
        P_Fld(0x6, SHU_SELPH_DQS1_DLY_OEN_DQS1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ0_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_0                      -     @5041                                                         
  TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[2:0]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[6:4]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[10:8]=3'h1                            
  TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[14:12]=3'h1                           
  TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[18:16]=3'h1                           
  TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[22:20]=3'h1                           
  TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[26:24]=3'h1                           
  TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[30:28]=3'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0, P_Fld(0x2, SHURK_SELPH_DQ0_TXDLY_DQ0) |
        P_Fld(0x2, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ1_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_0                      -     @5063                                                         
  TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[2:0]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[6:4]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[10:8]=3'h1                            
  TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[14:12]=3'h1                           
  TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[18:16]=3'h1                           
  TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[22:20]=3'h1                           
  TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[26:24]=3'h1                           
  TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[30:28]=3'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1, P_Fld(0x2, SHURK_SELPH_DQ1_TXDLY_DQM0) |
        P_Fld(0x2, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ2_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_0                      -     @5085                                                         
  dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[3:0]=4'h1                             
  dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[7:4]=4'h1                             
  dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[11:8]=4'h1                            
  dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[15:12]=4'h1                           
  dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[19:16]=4'h6 (Mirror: 4'h1)            
  dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[23:20]=4'h6 (Mirror: 4'h1)            
  dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[27:24]=4'h1                           
  dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[31:28]=4'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2, P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ0) |
        P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x6, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
        P_Fld(0x6, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ3_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_0                      -     @5107                                                         
  dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[3:0]=4'h1                             
  dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[7:4]=4'h1                             
  dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[11:8]=4'h1                            
  dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[15:12]=4'h1                           
  dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[19:16]=4'h6 (Mirror: 4'h1)            
  dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[23:20]=4'h6 (Mirror: 4'h1)            
  dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[27:24]=4'h1                           
  dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[31:28]=4'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3, P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM0) |
        P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x6, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
        P_Fld(0x6, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ0_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_1                      -     @5052                                                         
  TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[2:0]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[6:4]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[10:8]=3'h1                            
  TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[14:12]=3'h1                           
  TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[18:16]=3'h1                           
  TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[22:20]=3'h1                           
  TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[26:24]=3'h1                           
  TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[30:28]=3'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x2, SHURK_SELPH_DQ0_TXDLY_DQ0) |
        P_Fld(0x2, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ1_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_1                      -     @5074                                                         
  TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[2:0]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[6:4]=3'h2 (Mirror: 3'h1)              
  TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[10:8]=3'h1                            
  TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[14:12]=3'h1                           
  TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[18:16]=3'h1                           
  TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[22:20]=3'h1                           
  TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[26:24]=3'h1                           
  TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[30:28]=3'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x2, SHURK_SELPH_DQ1_TXDLY_DQM0) |
        P_Fld(0x2, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ2_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_1                      -     @5096                                                         
  dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[3:0]=4'h2 (Mirror: 4'h1)              
  dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[7:4]=4'h2 (Mirror: 4'h1)              
  dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[11:8]=4'h1                            
  dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[15:12]=4'h1                           
  dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[19:16]=4'h7 (Mirror: 4'h1)            
  dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[23:20]=4'h7 (Mirror: 4'h1)            
  dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[27:24]=4'h1                           
  dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[31:28]=4'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x2, SHURK_SELPH_DQ2_DLY_DQ0) |
        P_Fld(0x2, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x7, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
        P_Fld(0x7, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
        P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_SELPH_DQ3_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_1                      -     @5118                                                         
  dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[3:0]=4'h2 (Mirror: 4'h1)              
  dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[7:4]=4'h2 (Mirror: 4'h1)              
  dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[11:8]=4'h1                            
  dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[15:12]=4'h1                           
  dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[19:16]=4'h7 (Mirror: 4'h1)            
  dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[23:20]=4'h7 (Mirror: 4'h1)            
  dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[27:24]=4'h1                           
  dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[31:28]=4'h1                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x2, SHURK_SELPH_DQ3_DLY_DQM0) |
        P_Fld(0x2, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x7, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
        P_Fld(0x7, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
        P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL1_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_0                    -     @5129                                                         
  BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[10:0]=11'h019 (Mirror: 11'h000)     
  BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[26:16]=11'h01f (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1, P_Fld(0x019, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
        P_Fld(0x01f, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL2_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_0                    -     @5139                                                         
  BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[10:0]=11'h019 (Mirror: 11'h000)     
  BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[26:16]=11'h01f (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2, P_Fld(0x019, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
        P_Fld(0x01f, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL5_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_0                    -     @5177                                                         
  BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[10:0]=11'h019 (Mirror: 11'h000)     
  BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[26:16]=11'h01f (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5, P_Fld(0x019, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
        P_Fld(0x01f, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL1_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_1                    -     @5134                                                         
  BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[10:0]=11'h013 (Mirror: 11'h000)     
  BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[26:16]=11'h012 (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x013, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
        P_Fld(0x012, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL2_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_1                    -     @5144                                                         
  BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[10:0]=11'h013 (Mirror: 11'h000)     
  BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[26:16]=11'h012 (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x013, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
        P_Fld(0x012, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_DQS2DQ_CAL5_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_1                    -     @5182                                                         
  BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[10:0]=11'h013 (Mirror: 11'h000)     
  BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[26:16]=11'h012 (Mirror: 11'h000)    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x013, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
        P_Fld(0x012, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_PI_0_0                                   ral_reg_DRAMC_blk_SHURK_PI_0_0                             -     @5187                                                         
  RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[5:0]=6'h1f (Mirror: 6'h00)                   
  RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[13:8]=6'h19 (Mirror: 6'h00)                  
  RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[21:16]=6'h1f (Mirror: 6'h00)                 
  RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[29:24]=6'h19 (Mirror: 6'h00)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_PI, P_Fld(0x1f, SHURK_PI_RK0_ARPI_DQ_B1) |
        P_Fld(0x19, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x1f, SHURK_PI_RK0_ARPI_DQM_B1) |
        P_Fld(0x19, SHURK_PI_RK0_ARPI_DQM_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHURK_PI_0_1                                   ral_reg_DRAMC_blk_SHURK_PI_0_1                             -     @5194                                                         
  RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[5:0]=6'h12 (Mirror: 6'h00)                   
  RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[13:8]=6'h13 (Mirror: 6'h00)                  
  RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[21:16]=6'h12 (Mirror: 6'h00)                 
  RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[29:24]=6'h13 (Mirror: 6'h00)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHURK_PI+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x12, SHURK_PI_RK0_ARPI_DQ_B1) |
        P_Fld(0x13, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x12, SHURK_PI_RK0_ARPI_DQM_B1) |
        P_Fld(0x13, SHURK_PI_RK0_ARPI_DQM_B0));

#if !CODE_SIZE_REDUCE
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_TXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY0_0_0                    -     @7826
  TX_ARDQ0_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[7:0]=8'h3c (Mirror: 8'h00)
  TX_ARDQ1_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[15:8]=8'h3c (Mirror: 8'h00)
  TX_ARDQ2_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[23:16]=8'h3c (Mirror: 8'h00)
  TX_ARDQ3_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[31:24]=8'h3c (Mirror: 8'h00)
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY0, P_Fld(0x3c, SHU_R0_B0_TXDLY0_TX_ARDQ0_DLY_B0) |
        P_Fld(0x3c, SHU_R0_B0_TXDLY0_TX_ARDQ1_DLY_B0) | P_Fld(0x3c, SHU_R0_B0_TXDLY0_TX_ARDQ2_DLY_B0) |
        P_Fld(0x3c, SHU_R0_B0_TXDLY0_TX_ARDQ3_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_TXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY1_0_0                    -     @7840                                                         
  TX_ARDQ4_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[7:0]=8'h3c (Mirror: 8'h00)           
  TX_ARDQ5_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[15:8]=8'h3c (Mirror: 8'h00)          
  TX_ARDQ6_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[23:16]=8'h3c (Mirror: 8'h00)         
  TX_ARDQ7_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[31:24]=8'h3c (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY1, P_Fld(0x3c, SHU_R0_B0_TXDLY1_TX_ARDQ4_DLY_B0) |
        P_Fld(0x3c, SHU_R0_B0_TXDLY1_TX_ARDQ5_DLY_B0) | P_Fld(0x3c, SHU_R0_B0_TXDLY1_TX_ARDQ6_DLY_B0) |
        P_Fld(0x3c, SHU_R0_B0_TXDLY1_TX_ARDQ7_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_TXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY3_0_0                    -     @7868                                                         
  TX_ARDQM0_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[7:0]=8'h3c (Mirror: 8'h00)           
  TX_ARWCK_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[23:16]=8'h00                         
  TX_ARWCKB_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[31:24]=8'h00                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY3, P_Fld(0x3c, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0) |
        P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCK_DLY_B0) | P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCKB_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_TXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY0_0_1                    -     @9240                                                         
  TX_ARDQ0_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[7:0]=8'h08 (Mirror: 8'h00)           
  TX_ARDQ1_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[15:8]=8'h08 (Mirror: 8'h00)          
  TX_ARDQ2_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[23:16]=8'h08 (Mirror: 8'h00)         
  TX_ARDQ3_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[31:24]=8'h08 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ0_DLY_B1) |
        P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ1_DLY_B1) | P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ2_DLY_B1) |
        P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ3_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_TXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY1_0_1                    -     @9254                                                         
  TX_ARDQ4_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[7:0]=8'h08 (Mirror: 8'h00)           
  TX_ARDQ5_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[15:8]=8'h08 (Mirror: 8'h00)          
  TX_ARDQ6_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[23:16]=8'h08 (Mirror: 8'h00)         
  TX_ARDQ7_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[31:24]=8'h08 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ4_DLY_B1) |
        P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ5_DLY_B1) | P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ6_DLY_B1) |
        P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ7_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_TXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY3_0_1                    -     @9281                                                         
  TX_ARDQM0_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[7:0]=8'h08 (Mirror: 8'h00)           
  TX_ARWCK_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[23:16]=8'h00                         
  TX_ARWCKB_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[31:24]=8'h00                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1) |
        P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCK_DLY_B1) | P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCKB_DLY_B1));
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Exit:
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Enter:
#endif

# if !(CODE_SIZE_REDUCE && AC_TIMING_DERATE_ENABLE)
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_AC_DERATING0_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING0_0                       -     @5538                                                         
  ACDERATEEN                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[0:0]=1'h0                              
  TRRD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[18:16]=3'h1 (Mirror: 3'h0)             
  TRCD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[27:24]=4'h4 (Mirror: 4'h0)             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING0, P_Fld(0x0, SHU_AC_DERATING0_ACDERATEEN) |
        P_Fld(0x1, SHU_AC_DERATING0_TRRD_DERATE) | P_Fld(0x4, SHU_AC_DERATING0_TRCD_DERATE));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_AC_DERATING1_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING1_0                       -     @5544                                                         
  TRPAB_DERATE                                 uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[3:0]=4'h3 (Mirror: 4'h0)               
  TRP_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[11:8]=4'h2 (Mirror: 4'h0)              
  TRAS_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[21:16]=6'h00                           
  TRC_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[28:24]=5'h00                           
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING1, P_Fld(0x3, SHU_AC_DERATING1_TRPAB_DERATE) |
        P_Fld(0x2, SHU_AC_DERATING1_TRP_DERATE) | P_Fld(0x00, SHU_AC_DERATING1_TRAS_DERATE) |
        P_Fld(0x00, SHU_AC_DERATING1_TRC_DERATE));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_AC_DERATING_05T_0                          ral_reg_DRAMC_blk_SHU_AC_DERATING_05T_0                    -     @5551                                                         
  TRC_05T_DERATE                               uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[0:0]=1'h0                           
  TRCD_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[6:6]=1'h0                           
  TRP_05T_DERATE                               uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[7:7]=1'h1 (Mirror: 1'h0)            
  TRPAB_05T_DERATE                             uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[8:8]=1'h1 (Mirror: 1'h0)            
  TRAS_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[9:9]=1'h1 (Mirror: 1'h0)            
  TRRD_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[12:12]=1'h0                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING_05T, P_Fld(0x0, SHU_AC_DERATING_05T_TRC_05T_DERATE) |
        P_Fld(0x0, SHU_AC_DERATING_05T_TRCD_05T_DERATE) | P_Fld(0x1, SHU_AC_DERATING_05T_TRP_05T_DERATE) |
        P_Fld(0x1, SHU_AC_DERATING_05T_TRPAB_05T_DERATE) | P_Fld(0x1, SHU_AC_DERATING_05T_TRAS_05T_DERATE) |
        P_Fld(0x0, SHU_AC_DERATING_05T_TRRD_05T_DERATE));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_SREF_CTRL_0                                ral_reg_DRAMC_blk_SHU_SREF_CTRL_0                          -     @5322                                                         
  CKEHCMD                                      uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[5:4]=2'h3                                 
  SREF_CK_DLY                                  uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[29:28]=2'h3 (Mirror: 2'h0)                
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_SREF_CTRL, P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD) |
        P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_HMR4_DVFS_CTRL0_0                          ral_reg_DRAMC_blk_SHU_HMR4_DVFS_CTRL0_0                    -     @5341                                                         
  FSPCHG_PRDCNT                                uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[15:8]=8'h32 (Mirror: 8'h00)         
  REFRCNT                                      uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[27:16]=12'h000                      
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_HMR4_DVFS_CTRL0, P_Fld(0x32, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT) |
        P_Fld(0x000, SHU_HMR4_DVFS_CTRL0_REFRCNT));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_AC_TIME_05T_0                              ral_reg_DRAMC_blk_SHU_AC_TIME_05T_0                        -     @5504                                                         
  TRC_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[0:0]=1'h0                               
  TRFCPB_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[1:1]=1'h0                               
  TRFC_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[2:2]=1'h0                               
  TPBR2PBR_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[3:3]=1'h0                               
  TXP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[4:4]=1'h0                               
  TRTP_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[5:5]=1'h1 (Mirror: 1'h0)                
  TRCD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[6:6]=1'h0                               
  TRP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[7:7]=1'h1 (Mirror: 1'h0)                
  TRPAB_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[8:8]=1'h0                               
  TRAS_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[9:9]=1'h0                               
  TWR_M05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[10:10]=1'h1 (Mirror: 1'h0)              
  TRRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[12:12]=1'h0                             
  TFAW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[13:13]=1'h0                             
  TCKEPRD_05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[14:14]=1'h0                             
  TR2PD_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[15:15]=1'h0                             
  TWTPD_M05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[16:16]=1'h1 (Mirror: 1'h0)              
  TMRRI_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[17:17]=1'h1 (Mirror: 1'h0)              
  TMRWCKEL_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[18:18]=1'h0                             
  BGTRRD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[19:19]=1'h0                             
  BGTCCD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[20:20]=1'h0                             
  BGTWTR_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[21:21]=1'h0                             
  TR2W_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[22:22]=1'h0                             
  TWTR_M05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[23:23]=1'h1 (Mirror: 1'h0)              
  XRTR2W_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[24:24]=1'h0                             
  TMRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[25:25]=1'h1 (Mirror: 1'h0)              
  TMRW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[26:26]=1'h1 (Mirror: 1'h0)              
  TMRR2MRW_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[27:27]=1'h1 (Mirror: 1'h0)              
  TW2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[28:28]=1'h1 (Mirror: 1'h0)              
  TR2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[29:29]=1'h0                             
  TPBR2ACT_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[30:30]=1'h1 (Mirror: 1'h0)              
  XRTW2R_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[31:31]=1'h0                             
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T,
        P_Fld(0x0, SHU_AC_TIME_05T_TCKEPRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_BGTRRD_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_BGTCCD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_BGTWTR_M05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_XRTR2W_05T) | P_Fld(0x0, SHU_AC_TIME_05T_XRTW2R_M05T));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T, P_Fld(0x0, SHU_AC_TIME_05T_TRC_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TRFCPB_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRFC_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TPBR2PBR_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TXP_05T) |
        P_Fld(0x1, SHU_AC_TIME_05T_TRTP_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRCD_05T) |
        P_Fld(0x1, SHU_AC_TIME_05T_TRP_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRPAB_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TRAS_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWR_M05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TRRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TFAW_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TR2PD_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWTPD_M05T) |
        P_Fld(0x1, SHU_AC_TIME_05T_TMRRI_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRWCKEL_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TR2W_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWTR_M05T) |
        P_Fld(0x1, SHU_AC_TIME_05T_TMRD_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TMRW_05T) |
        P_Fld(0x1, SHU_AC_TIME_05T_TMRR2MRW_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TW2MRW_05T) |
        P_Fld(0x0, SHU_AC_TIME_05T_TR2MRW_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TPBR2ACT_05T));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM_XRT_0                                ral_reg_DRAMC_blk_SHU_ACTIM_XRT_0                          -     @5497                                                         
  XRTR2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[4:0]=5'h03 (Mirror: 5'h01)                
  XRTR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[13:8]=6'h03 (Mirror: 6'h01)               
  XRTW2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[19:16]=4'h3 (Mirror: 4'h1)                
  XRTW2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[28:24]=5'h04 (Mirror: 5'h01)              
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM_XRT, P_Fld(0x03, SHU_ACTIM_XRT_XRTR2R) |
        P_Fld(0x03, SHU_ACTIM_XRT_XRTR2W) | P_Fld(0x3, SHU_ACTIM_XRT_XRTW2R) |
        P_Fld(0x04, SHU_ACTIM_XRT_XRTW2W));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM0_0                                   ral_reg_DRAMC_blk_SHU_ACTIM0_0                             -     @5443                                                         
  TWTR                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[5:0]=6'h04 (Mirror: 6'h01)                   
  TWR                                          uvm_reg_field                                              ...    RW SHU_ACTIM0_0[15:8]=8'h07 (Mirror: 8'h06)                  
  TRRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[18:16]=3'h1 (Mirror: 3'h0)                   
  TRCD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[27:24]=4'h4 (Mirror: 4'h2)                   
  CKELCKCNT                                    uvm_reg_field                                              ...    RW SHU_ACTIM0_0[31:28]=4'h2 (Mirror: 4'h0)                   
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM0, P_Fld(0x04, SHU_ACTIM0_TWTR) |
        P_Fld(0x07, SHU_ACTIM0_TWR) | P_Fld(0x1, SHU_ACTIM0_TRRD) |
        P_Fld(0x4, SHU_ACTIM0_TRCD) | P_Fld(0x2, SHU_ACTIM0_CKELCKCNT));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM1_0                                   ral_reg_DRAMC_blk_SHU_ACTIM1_0                             -     @5451                                                         
  TRPAB                                        uvm_reg_field                                              ...    RW SHU_ACTIM1_0[3:0]=4'h3 (Mirror: 4'ha)                     
  TMRWCKEL                                     uvm_reg_field                                              ...    RW SHU_ACTIM1_0[7:4]=4'h4 (Mirror: 4'h8)                     
  TRP                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[11:8]=4'h2                                   
  TRAS                                         uvm_reg_field                                              ...    RW SHU_ACTIM1_0[21:16]=6'h00 (Mirror: 6'h04)                 
  TRC                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[28:24]=5'h00 (Mirror: 5'h05)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM1, P_Fld(0x3, SHU_ACTIM1_TRPAB) |
        P_Fld(0x4, SHU_ACTIM1_TMRWCKEL) | P_Fld(0x2, SHU_ACTIM1_TRP) |
        P_Fld(0x00, SHU_ACTIM1_TRAS) | P_Fld(0x00, SHU_ACTIM1_TRC));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM2_0                                   ral_reg_DRAMC_blk_SHU_ACTIM2_0                             -     @5459                                                         
  TXP                                          uvm_reg_field                                              ...    RW SHU_ACTIM2_0[3:0]=4'h0                                    
  TMRRI                                        uvm_reg_field                                              ...    RW SHU_ACTIM2_0[8:4]=5'h05 (Mirror: 5'h0e)                   
  TRTP                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[14:12]=3'h0                                  
  TR2W                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[21:16]=6'h03 (Mirror: 6'h00)                 
  TFAW                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[28:24]=5'h00 (Mirror: 5'h05)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM2, P_Fld(0x0, SHU_ACTIM2_TXP) |
        P_Fld(0x05, SHU_ACTIM2_TMRRI) | P_Fld(0x0, SHU_ACTIM2_TRTP) |
        P_Fld(0x03, SHU_ACTIM2_TR2W) | P_Fld(0x00, SHU_ACTIM2_TFAW));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM3_0                                   ral_reg_DRAMC_blk_SHU_ACTIM3_0                             -     @5467                                                         
  TRFCPB                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[7:0]=8'h1a (Mirror: 8'h00)                   
  MANTMRR                                      uvm_reg_field                                              ...    RW SHU_ACTIM3_0[11:8]=4'h4 (Mirror: 4'h0)                    
  TR2MRR                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[15:12]=4'h4 (Mirror: 4'h0)                   
  TRFC                                         uvm_reg_field                                              ...    RW SHU_ACTIM3_0[23:16]=8'h40 (Mirror: 8'h00)                 
  TWTR_L                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[29:24]=6'h00                                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x1a, SHU_ACTIM3_TRFCPB) | 
        P_Fld(0x4, SHU_ACTIM3_TR2MRR) | P_Fld(0x40, SHU_ACTIM3_TRFC));
#endif
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x4, SHU_ACTIM3_MANTMRR) |
        P_Fld(0x00, SHU_ACTIM3_TWTR_L));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM4_0                                   ral_reg_DRAMC_blk_SHU_ACTIM4_0                             -     @5475                                                         
  TXREFCNT                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[9:0]=10'h04e (Mirror: 10'h028)               
  TMRR2MRW                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[15:10]=6'h07 (Mirror: 6'h00)                 
  TMRR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM4_0[21:16]=6'h05 (Mirror: 6'h00)                 
  TZQCS                                        uvm_reg_field                                              ...    RW SHU_ACTIM4_0[31:24]=8'h10 (Mirror: 8'h00)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM4, P_Fld(0x04e, SHU_ACTIM4_TXREFCNT) |
        P_Fld(0x07, SHU_ACTIM4_TMRR2MRW) | P_Fld(0x05, SHU_ACTIM4_TMRR2W) |
        P_Fld(0x10, SHU_ACTIM4_TZQCS));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM5_0                                   ral_reg_DRAMC_blk_SHU_ACTIM5_0                             -     @5482                                                         
  TR2PD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[6:0]=7'h08 (Mirror: 7'h00)                   
  TWTPD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[14:8]=7'h09 (Mirror: 7'h00)                  
  TPBR2PBR                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[23:16]=8'h0b (Mirror: 8'h00)                 
  TPBR2ACT                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[29:28]=2'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM5, P_Fld(0x08, SHU_ACTIM5_TR2PD) |
        P_Fld(0x09, SHU_ACTIM5_TWTPD) | P_Fld(0x0b, SHU_ACTIM5_TPBR2PBR) |
        P_Fld(0x0, SHU_ACTIM5_TPBR2ACT));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_ACTIM6_0                                   ral_reg_DRAMC_blk_SHU_ACTIM6_0                             -     @5489                                                         
  TZQLAT2                                      uvm_reg_field                                              ...    RW SHU_ACTIM6_0[4:0]=5'h06 (Mirror: 5'h1f)                   
  TMRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[11:8]=4'h3 (Mirror: 4'h0)                    
  TMRW                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[15:12]=4'h2 (Mirror: 4'h0)                   
  TW2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[25:20]=6'h06 (Mirror: 6'h00)                 
  TR2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[31:26]=6'h09 (Mirror: 6'h13)                 
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM6, P_Fld(0x06, SHU_ACTIM6_TZQLAT2) |
        P_Fld(0x3, SHU_ACTIM6_TMRD) | P_Fld(0x2, SHU_ACTIM6_TMRW) |
        P_Fld(0x06, SHU_ACTIM6_TW2MRW) | P_Fld(0x09, SHU_ACTIM6_TR2MRW));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_CKECTRL_0                                  ral_reg_DRAMC_blk_SHU_CKECTRL_0                            -     @5567                                                         
  TPDE_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[0:0]=1'h1 (Mirror: 1'h0)                    
  TPDX_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[1:1]=1'h0                                   
  TPDE                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[14:12]=3'h1                                 
  TPDX                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[18:16]=3'h1                                 
  TCKEPRD                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[22:20]=3'h1 (Mirror: 3'h2)                  
  TCKESRX                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[25:24]=2'h3 (Mirror: 2'h0)                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_CKECTRL, P_Fld(0x1, SHU_CKECTRL_TPDE_05T) |
        P_Fld(0x0, SHU_CKECTRL_TPDX_05T) | P_Fld(0x1, SHU_CKECTRL_TPDE) |
        P_Fld(0x1, SHU_CKECTRL_TPDX) | P_Fld(0x1, SHU_CKECTRL_TCKEPRD));
#endif

vIO32WriteFldAlign(DRAMC_REG_SHU_CKECTRL, 0x3, SHU_CKECTRL_TCKESRX);
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_MISC_0                                     ral_reg_DRAMC_blk_SHU_MISC_0                               -     @5671                                                         
  REQQUE_MAXCNT                                uvm_reg_field                                              ...    RW SHU_MISC_0[3:0]=4'h2                                      
  DCMDLYREF                                    uvm_reg_field                                              ...    RW SHU_MISC_0[18:16]=3'h7 (Mirror: 3'h4)                     
  DAREFEN                                      uvm_reg_field                                              ...    RW SHU_MISC_0[30:30]=1'h0                                    
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DRAMC_REG_SHU_MISC, P_Fld(0x7, SHU_MISC_DCMDLYREF) |
        P_Fld(0x0, SHU_MISC_DAREFEN));

#if !CODE_SIZE_REDUCE
vIO32WriteFldAlign(DRAMC_REG_SHU_MISC, 0x2, SHU_MISC_REQQUE_MAXCNT);

//    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Exit
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Enter.
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Exit.
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B0_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ8_0                            -     @8226                                                         
  R_DMRXDVS_UPD_FORCE_CYC_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[14:0]=15'h0063 (Mirror: 15'h0000)            
  R_DMRXDVS_UPD_FORCE_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[15:15]=1'h0                                  
  R_DMRANK_RXDLY_PIPE_CG_IG_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[19:19]=1'h0                                  
  R_RMRODTEN_CG_IG_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[20:20]=1'h0                                  
  R_RMRX_TOPHY_CG_IG_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                   
  R_DMRXDVS_RDSEL_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[22:22]=1'h0                                  
  R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0            uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[23:23]=1'h0                                  
  R_DMRXDLY_CG_IG_B0                           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                   
  R_DMDQSIEN_FLAG_SYNC_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[26:26]=1'h0                                  
  R_DMDQSIEN_FLAG_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[27:27]=1'h0                                  
  R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0               uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[28:28]=1'h0                                  
  R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[29:29]=1'h0                                  
  R_DMRANK_PIPE_CG_IG_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[30:30]=1'h0                                  
  R_DMRANK_CHG_PIPE_CG_IG_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[31:31]=1'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) | P_Fld(0x1, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
        P_Fld(0x1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0));
#endif
vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0063, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B0) |
        P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_EN_B0));

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B1_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ8_0                            -     @9633                                                         
  R_DMRXDVS_UPD_FORCE_CYC_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[14:0]=15'h0063 (Mirror: 15'h0000)            
  R_DMRXDVS_UPD_FORCE_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[15:15]=1'h0                                  
  R_DMRANK_RXDLY_PIPE_CG_IG_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[19:19]=1'h0                                  
  R_RMRODTEN_CG_IG_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[20:20]=1'h0                                  
  R_RMRX_TOPHY_CG_IG_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                   
  R_DMRXDVS_RDSEL_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[22:22]=1'h0                                  
  R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1            uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[23:23]=1'h0                                  
  R_DMRXDLY_CG_IG_B1                           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                   
  R_DMDQSIEN_FLAG_SYNC_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[26:26]=1'h0                                  
  R_DMDQSIEN_FLAG_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[27:27]=1'h0                                  
  R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1               uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[28:28]=1'h0                                  
  R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[29:29]=1'h0                                  
  R_DMRANK_PIPE_CG_IG_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[30:30]=1'h0                                  
  R_DMRANK_CHG_PIPE_CG_IG_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[31:31]=1'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) | P_Fld(0x1, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1) |
        P_Fld(0x1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1));
#endif

vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0063, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B1) |
        P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_EN_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B0_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ5_0                            -     @8126                                                         
  RG_RX_ARDQ_VREF_SEL_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[5:0]=6'h0e                                   
  RG_RX_ARDQ_VREF_BYPASS_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[6:6]=1'h0                                    
  RG_ARPI_FB_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[13:8]=6'h00                                  
  RG_RX_ARDQS0_DQSIEN_DLY_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[18:16]=3'h0                                  
  RG_RX_ARDQS_DQSIEN_RB_DLY_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[19:19]=1'h0                                  
  RG_RX_ARDQS0_DVS_DLY_B0                      uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[23:20]=4'h5 (Mirror: 4'h0)                   
  RG_RX_ARDQ_FIFO_DQSI_DLY_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[31:29]=3'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ5, P_Fld(0x0e, SHU_B0_DQ5_RG_RX_ARDQ_VREF_SEL_B0) |
        P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_VREF_BYPASS_B0) | P_Fld(0x00, SHU_B0_DQ5_RG_ARPI_FB_B0) |
        P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B0) |
        P_Fld(0x5, SHU_B0_DQ5_RG_RX_ARDQS0_DVS_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_B1_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ5_0                            -     @9533                                                         
  RG_RX_ARDQ_VREF_SEL_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[5:0]=6'h0e                                   
  RG_RX_ARDQ_VREF_BYPASS_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[6:6]=1'h0                                    
  RG_ARPI_FB_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[13:8]=6'h00                                  
  RG_RX_ARDQS0_DQSIEN_DLY_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[18:16]=3'h0                                  
  RG_RX_ARDQS_DQSIEN_RB_DLY_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[19:19]=1'h0                                  
  RG_RX_ARDQS0_DVS_DLY_B1                      uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[23:20]=4'h5 (Mirror: 4'h0)                   
  RG_RX_ARDQ_FIFO_DQSI_DLY_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[31:29]=3'h0                                  
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ5, P_Fld(0x0e, SHU_B1_DQ5_RG_RX_ARDQ_VREF_SEL_B1) |
        P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_VREF_BYPASS_B1) | P_Fld(0x00, SHU_B1_DQ5_RG_ARPI_FB_B1) |
        P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B1) |
        P_Fld(0x5, SHU_B1_DQ5_RG_RX_ARDQS0_DVS_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_0                    -     @7888                                                         
  RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x64, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) | 
        P_Fld(0x64, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x64, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
#endif

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_0                    -     @7902                                                         
  RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1, P_Fld(0x64, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x64, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_0                    -     @7916                                                         
  RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2, P_Fld(0x64, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x64, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_0                    -     @7930                                                         
  RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3, P_Fld(0x64, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x64, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_0                    -     @7944                                                         
  RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[15:8]=8'h64 (Mirror: 8'h00)          
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4, P_Fld(0x64, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
        P_Fld(0x64, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_0                    -     @7954                                                         
  RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[8:0]=9'h0da (Mirror: 9'h000)         
  RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[24:16]=9'h0da (Mirror: 9'h000)       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5, P_Fld(0x0da, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
        P_Fld(0x0da, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_1                    -     @7895                                                         
  RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) | 
        P_Fld(0x63, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
#endif

/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_1                    -     @7909                                                         
  RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x63, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_1                    -     @7923                                                         
  RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x63, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_1                    -     @7937                                                         
  RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x63, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_1                    -     @7949                                                         
  RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[15:8]=8'h63 (Mirror: 8'h00)          
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
        P_Fld(0x63, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B0_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_1                    -     @7959                                                         
  RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[8:0]=9'h0d9 (Mirror: 9'h000)         
  RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[24:16]=9'h0d9 (Mirror: 9'h000)       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0d9, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
        P_Fld(0x0d9, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_0                    -     @9295                                                         
  RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x64, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) | P_Fld(0x64, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_0                    -     @9309                                                         
  RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1, P_Fld(0x64, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x64, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_0                    -     @9323                                                         
  RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2, P_Fld(0x64, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x64, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_0                    -     @9337                                                         
  RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[15:8]=8'h64 (Mirror: 8'h00)          
  RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[23:16]=8'h64 (Mirror: 8'h00)         
  RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[31:24]=8'h64 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3, P_Fld(0x64, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x64, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_0                    -     @9351                                                         
  RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[7:0]=8'h64 (Mirror: 8'h00)           
  RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[15:8]=8'h64 (Mirror: 8'h00)          
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
#if !CODE_SIZE_REDUCE
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4, P_Fld(0x64, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
        P_Fld(0x64, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
#endif
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_0                    -     @9361                                                         
  RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[8:0]=9'h0da (Mirror: 9'h000)         
  RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[24:16]=9'h0da (Mirror: 9'h000)       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5, P_Fld(0x0da, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
        P_Fld(0x0da, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_1                    -     @9302                                                         
  RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) | P_Fld(0x63, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_1                    -     @9316                                                         
  RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x63, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_1                    -     @9330                                                         
  RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x63, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_1                    -     @9344                                                         
  RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[15:8]=8'h63 (Mirror: 8'h00)          
  RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[23:16]=8'h63 (Mirror: 8'h00)         
  RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[31:24]=8'h63 (Mirror: 8'h00)         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x63, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_1                    -     @9356                                                         
  RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[7:0]=8'h63 (Mirror: 8'h00)           
  RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[15:8]=8'h63 (Mirror: 8'h00)          
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x63, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
        P_Fld(0x63, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
SHU_R0_B1_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_1                    -     @9366                                                         
  RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[8:0]=9'h0d9 (Mirror: 9'h000)         
  RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[24:16]=9'h0d9 (Mirror: 9'h000)       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0d9, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
        P_Fld(0x0d9, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B0_DQ9                                         ral_reg_DDRPHY_blk_B0_DQ9                                  -     @7782                                                         
  RG_RX_ARDQ_STBEN_RESETB_B0                   uvm_reg_field                                              ...    RW B0_DQ9[0:0]=1'h1 (Mirror: 1'h0)                           
  RG_RX_ARDQS0_STBEN_RESETB_B0                 uvm_reg_field                                              ...    RW B0_DQ9[4:4]=1'h0                                          
  RG_RX_ARDQS0_DQSIENMODE_B0                   uvm_reg_field                                              ...    RW B0_DQ9[5:5]=1'h0                                          
  R_DMRXDVS_R_F_DLY_RK_OPT_B0                  uvm_reg_field                                              ...    RW B0_DQ9[6:6]=1'h1                                          
  R_DMRXFIFO_STBENCMP_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ9[7:7]=1'h0                                          
  R_IN_GATE_EN_LOW_OPT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[15:8]=8'h00                                        
  R_DMDQSIEN_VALID_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[18:16]=3'h0                                        
  R_DMDQSIEN_RDSEL_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[22:20]=3'h0                                        
  R_DMRXDVS_VALID_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[26:24]=3'h0                                        
  R_DMRXDVS_RDSEL_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[30:28]=3'h0                                        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B0_DQ9, P_Fld(0x1, B0_DQ9_RG_RX_ARDQ_STBEN_RESETB_B0) |
        P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_DQSIENMODE_B0) |
        P_Fld(0x1, B0_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXFIFO_STBENCMP_EN_B0) |
        P_Fld(0x00, B0_DQ9_R_IN_GATE_EN_LOW_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMDQSIEN_VALID_LAT_B0) |
        P_Fld(0x0, B0_DQ9_R_DMDQSIEN_RDSEL_LAT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXDVS_VALID_LAT_B0) |
        P_Fld(0x0, B0_DQ9_R_DMRXDVS_RDSEL_LAT_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B1_DQ9                                         ral_reg_DDRPHY_blk_B1_DQ9                                  -     @9189                                                         
  RG_RX_ARDQ_STBEN_RESETB_B1                   uvm_reg_field                                              ...    RW B1_DQ9[0:0]=1'h1 (Mirror: 1'h0)                           
  RG_RX_ARDQS0_STBEN_RESETB_B1                 uvm_reg_field                                              ...    RW B1_DQ9[4:4]=1'h0                                          
  RG_RX_ARDQS0_DQSIENMODE_B1                   uvm_reg_field                                              ...    RW B1_DQ9[5:5]=1'h0                                          
  R_DMRXDVS_R_F_DLY_RK_OPT_B1                  uvm_reg_field                                              ...    RW B1_DQ9[6:6]=1'h1                                          
  R_DMRXFIFO_STBENCMP_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ9[7:7]=1'h0                                          
  R_IN_GATE_EN_LOW_OPT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[15:8]=8'h00                                        
  R_DMDQSIEN_VALID_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[18:16]=3'h0                                        
  R_DMDQSIEN_RDSEL_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[22:20]=3'h0                                        
  R_DMRXDVS_VALID_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[26:24]=3'h0                                        
  R_DMRXDVS_RDSEL_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[30:28]=3'h0                                        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B1_DQ9, P_Fld(0x1, B1_DQ9_RG_RX_ARDQ_STBEN_RESETB_B1) |
        P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_DQSIENMODE_B1) |
        P_Fld(0x1, B1_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXFIFO_STBENCMP_EN_B1) |
        P_Fld(0x00, B1_DQ9_R_IN_GATE_EN_LOW_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMDQSIEN_VALID_LAT_B1) |
        P_Fld(0x0, B1_DQ9_R_DMDQSIEN_RDSEL_LAT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXDVS_VALID_LAT_B1) |
        P_Fld(0x0, B1_DQ9_R_DMRXDVS_RDSEL_LAT_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B0_DQ4                                         ral_reg_DDRPHY_blk_B0_DQ4                                  -     @7711                                                         
  RG_RX_ARDQS_EYE_R_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[6:0]=7'h6e (Mirror: 7'h00)                         
  RG_RX_ARDQS_EYE_F_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[14:8]=7'h6e (Mirror: 7'h00)                        
  RG_RX_ARDQ_EYE_R_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[21:16]=6'h24 (Mirror: 6'h00)                       
  RG_RX_ARDQ_EYE_F_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[29:24]=6'h24 (Mirror: 6'h00)                       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B0_DQ4, P_Fld(0x6e, B0_DQ4_RG_RX_ARDQS_EYE_R_DLY_B0) |
        P_Fld(0x6e, B0_DQ4_RG_RX_ARDQS_EYE_F_DLY_B0) | P_Fld(0x24, B0_DQ4_RG_RX_ARDQ_EYE_R_DLY_B0) |
        P_Fld(0x24, B0_DQ4_RG_RX_ARDQ_EYE_F_DLY_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B1_DQ4                                         ral_reg_DDRPHY_blk_B1_DQ4                                  -     @9118                                                         
  RG_RX_ARDQS_EYE_R_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[6:0]=7'h6e (Mirror: 7'h00)                         
  RG_RX_ARDQS_EYE_F_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[14:8]=7'h6e (Mirror: 7'h00)                        
  RG_RX_ARDQ_EYE_R_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[21:16]=6'h24 (Mirror: 6'h00)                       
  RG_RX_ARDQ_EYE_F_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[29:24]=6'h24 (Mirror: 6'h00)                       
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B1_DQ4, P_Fld(0x6e, B1_DQ4_RG_RX_ARDQS_EYE_R_DLY_B1) |
        P_Fld(0x6e, B1_DQ4_RG_RX_ARDQS_EYE_F_DLY_B1) | P_Fld(0x24, B1_DQ4_RG_RX_ARDQ_EYE_R_DLY_B1) |
        P_Fld(0x24, B1_DQ4_RG_RX_ARDQ_EYE_F_DLY_B1));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B0_DQ5                                         ral_reg_DDRPHY_blk_B0_DQ5                                  -     @7718                                                         
  RG_RX_ARDQ_EYE_VREF_SEL_B0                   uvm_reg_field                                              ...    RW B0_DQ5[13:8]=6'h0e                                        
  RG_RX_ARDQ_VREF_EN_B0                        uvm_reg_field                                              ...    RW B0_DQ5[16:16]=1'h0                                        
  RG_RX_ARDQ_EYE_VREF_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ5[17:17]=1'h0                                        
  RG_RX_ARDQ_EYE_SEL_B0                        uvm_reg_field                                              ...    RW B0_DQ5[23:20]=4'h0                                        
  RG_RX_ARDQ_EYE_EN_B0                         uvm_reg_field                                              ...    RW B0_DQ5[24:24]=1'h0                                        
  RG_RX_ARDQ_EYE_STBEN_RESETB_B0               uvm_reg_field                                              ...    RW B0_DQ5[25:25]=1'h1 (Mirror: 1'h0)                         
  RG_RX_ARDQS0_DVS_EN_B0                       uvm_reg_field                                              ...    RW B0_DQ5[31:31]=1'h0                                        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B0_DQ5, P_Fld(0x0e, B0_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B0) |
        P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B0) |
        P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_SEL_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_EN_B0) |
        P_Fld(0x1, B0_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQS0_DVS_EN_B0));
/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value                                                         
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B1_DQ5                                         ral_reg_DDRPHY_blk_B1_DQ5                                  -     @9125                                                         
  RG_RX_ARDQ_EYE_VREF_SEL_B1                   uvm_reg_field                                              ...    RW B1_DQ5[13:8]=6'h0e                                        
  RG_RX_ARDQ_VREF_EN_B1                        uvm_reg_field                                              ...    RW B1_DQ5[16:16]=1'h0                                        
  RG_RX_ARDQ_EYE_VREF_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ5[17:17]=1'h0                                        
  RG_RX_ARDQ_EYE_SEL_B1                        uvm_reg_field                                              ...    RW B1_DQ5[23:20]=4'h0                                        
  RG_RX_ARDQ_EYE_EN_B1                         uvm_reg_field                                              ...    RW B1_DQ5[24:24]=1'h0                                        
  RG_RX_ARDQ_EYE_STBEN_RESETB_B1               uvm_reg_field                                              ...    RW B1_DQ5[25:25]=1'h1 (Mirror: 1'h0)                         
  RG_RX_ARDQS0_DVS_EN_B1                       uvm_reg_field                                              ...    RW B1_DQ5[31:31]=1'h0                                        
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B1_DQ5, P_Fld(0x0e, B1_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B1) |
        P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B1) |
        P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_SEL_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_EN_B1) |
        P_Fld(0x1, B1_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQS0_DVS_EN_B1));
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set EXIT
//    Exit body
}

void sv_algorithm_assistance_LP4_400(DRAMC_CTX_T *p)
{
    //    Enter body
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Enter:
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING0_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING0_0                       -     @5271
      ACDERATEEN                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[0:0]=1'h0
      TRRD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[18:16]=3'h1 (Mirror: 3'h0)
      TRCD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[27:24]=4'h2 (Mirror: 4'h0)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !(CODE_SIZE_REDUCE && AC_TIMING_DERATE_ENABLE)
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING0, P_Fld(0x0, SHU_AC_DERATING0_ACDERATEEN) |
            P_Fld(0x1, SHU_AC_DERATING0_TRRD_DERATE) | P_Fld(0x2, SHU_AC_DERATING0_TRCD_DERATE));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING1_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING1_0                       -     @5277
      TRPAB_DERATE                                 uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[3:0]=4'h1 (Mirror: 4'h0)
      TRP_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[11:8]=4'h0
      TRAS_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[21:16]=6'h00
      TRC_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[28:24]=5'h00
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING1, P_Fld(0x1, SHU_AC_DERATING1_TRPAB_DERATE) |
            P_Fld(0x0, SHU_AC_DERATING1_TRP_DERATE) | P_Fld(0x00, SHU_AC_DERATING1_TRAS_DERATE) |
            P_Fld(0x00, SHU_AC_DERATING1_TRC_DERATE));
	#endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SREF_CTRL_0                                ral_reg_DRAMC_blk_SHU_SREF_CTRL_0                          -     @5055
      CKEHCMD                                      uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[5:4]=2'h3
      SREF_CK_DLY                                  uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[29:28]=2'h3 (Mirror: 2'h0)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SREF_CTRL, P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD) |
            P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_HMR4_DVFS_CTRL0_0                          ral_reg_DRAMC_blk_SHU_HMR4_DVFS_CTRL0_0                    -     @5074
      FSPCHG_PRDCNT                                uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[15:8]=8'h1e (Mirror: 8'h00)
      REFRCNT                                      uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[27:16]=12'h000
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_HMR4_DVFS_CTRL0, P_Fld(0x1e, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT) |
            P_Fld(0x000, SHU_HMR4_DVFS_CTRL0_REFRCNT));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_TIME_05T_0                              ral_reg_DRAMC_blk_SHU_AC_TIME_05T_0                        -     @5237
      TRC_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[0:0]=1'h0
      TRFCPB_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[1:1]=1'h0
      TRFC_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[2:2]=1'h0
      TPBR2PBR_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[3:3]=1'h0
      TXP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[4:4]=1'h0
      TRTP_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[5:5]=1'h0
      TRCD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[6:6]=1'h0
      TRP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[7:7]=1'h0
      TRPAB_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[8:8]=1'h0
      TRAS_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[9:9]=1'h0
      TWR_M05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[10:10]=1'h0
      TRRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[12:12]=1'h0
      TFAW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[13:13]=1'h0
      TCKEPRD_05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[14:14]=1'h0
      TR2PD_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[15:15]=1'h0
      TWTPD_M05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[16:16]=1'h0
      TMRRI_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[17:17]=1'h0
      TMRWCKEL_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[18:18]=1'h0
      BGTRRD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[19:19]=1'h0
      BGTCCD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[20:20]=1'h0
      BGTWTR_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[21:21]=1'h1 (Mirror: 1'h0)
      TR2W_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[22:22]=1'h0
      TWTR_M05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[23:23]=1'h0
      XRTR2W_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[24:24]=1'h0
      TMRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[25:25]=1'h0
      TMRW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[26:26]=1'h0
      TMRR2MRW_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[27:27]=1'h0
      TW2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[28:28]=1'h0
      TR2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[29:29]=1'h0
      TPBR2ACT_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[30:30]=1'h0
      XRTW2R_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[31:31]=1'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T,
            P_Fld(0x0, SHU_AC_TIME_05T_TCKEPRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_BGTRRD_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_BGTCCD_05T) | P_Fld(0x1, SHU_AC_TIME_05T_BGTWTR_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_XRTR2W_05T) | P_Fld(0x0, SHU_AC_TIME_05T_XRTW2R_M05T));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T, P_Fld(0x0, SHU_AC_TIME_05T_TRC_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRFCPB_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRFC_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TPBR2PBR_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TXP_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRTP_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRCD_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRP_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TRPAB_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRAS_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TWR_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TFAW_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2PD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TWTPD_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TMRRI_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRWCKEL_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2W_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TWTR_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TMRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRW_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TMRR2MRW_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TW2MRW_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2MRW_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TPBR2ACT_05T));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM_XRT_0                                ral_reg_DRAMC_blk_SHU_ACTIM_XRT_0                          -     @5230
      XRTR2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[4:0]=5'h05 (Mirror: 5'h01)
      XRTR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[13:8]=6'h0a (Mirror: 6'h01)
      XRTW2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[19:16]=4'h7 (Mirror: 4'h1)
      XRTW2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[28:24]=5'h0a (Mirror: 5'h01)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM_XRT, P_Fld(0x05, SHU_ACTIM_XRT_XRTR2R) |
            P_Fld(0x0a, SHU_ACTIM_XRT_XRTR2W) | P_Fld(0x7, SHU_ACTIM_XRT_XRTW2R) |
            P_Fld(0x0a, SHU_ACTIM_XRT_XRTW2W));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM0_0                                   ral_reg_DRAMC_blk_SHU_ACTIM0_0                             -     @5176
      TWTR                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[5:0]=6'h0a (Mirror: 6'h01)
      TWR                                          uvm_reg_field                                              ...    RW SHU_ACTIM0_0[15:8]=8'h0b (Mirror: 8'h06)
      TRRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[18:16]=3'h1 (Mirror: 3'h0)
      TRCD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[27:24]=4'h2
      CKELCKCNT                                    uvm_reg_field                                              ...    RW SHU_ACTIM0_0[31:28]=4'h3 (Mirror: 4'h0)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM0, P_Fld(0x0a, SHU_ACTIM0_TWTR) |
            P_Fld(0x0b, SHU_ACTIM0_TWR) | P_Fld(0x1, SHU_ACTIM0_TRRD) |
            P_Fld(0x2, SHU_ACTIM0_TRCD));
    #endif
    vIO32WriteFldAlign(DRAMC_REG_SHU_ACTIM0, 0x3, SHU_ACTIM0_CKELCKCNT);
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM1_0                                   ral_reg_DRAMC_blk_SHU_ACTIM1_0                             -     @5184
      TRPAB                                        uvm_reg_field                                              ...    RW SHU_ACTIM1_0[3:0]=4'h1 (Mirror: 4'ha)
      TMRWCKEL                                     uvm_reg_field                                              ...    RW SHU_ACTIM1_0[7:4]=4'h7 (Mirror: 4'h8)
      TRP                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[11:8]=4'h0 (Mirror: 4'h2)
      TRAS                                         uvm_reg_field                                              ...    RW SHU_ACTIM1_0[21:16]=6'h00 (Mirror: 6'h04)
      TRC                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[28:24]=5'h00 (Mirror: 5'h05)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM1, P_Fld(0x1, SHU_ACTIM1_TRPAB) |
            P_Fld(0x7, SHU_ACTIM1_TMRWCKEL) | P_Fld(0x0, SHU_ACTIM1_TRP) |
            P_Fld(0x00, SHU_ACTIM1_TRAS) | P_Fld(0x00, SHU_ACTIM1_TRC));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM2_0                                   ral_reg_DRAMC_blk_SHU_ACTIM2_0                             -     @5192
      TXP                                          uvm_reg_field                                              ...    RW SHU_ACTIM2_0[3:0]=4'h0
      TMRRI                                        uvm_reg_field                                              ...    RW SHU_ACTIM2_0[8:4]=5'h05 (Mirror: 5'h0e)
      TRTP                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[14:12]=3'h3 (Mirror: 3'h0)
      TR2W                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[21:16]=6'h09 (Mirror: 6'h00)
      TFAW                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[28:24]=5'h00 (Mirror: 5'h05)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM2, P_Fld(0x0, SHU_ACTIM2_TXP) |
            P_Fld(0x05, SHU_ACTIM2_TMRRI) | P_Fld(0x3, SHU_ACTIM2_TRTP) |
            P_Fld(0x09, SHU_ACTIM2_TR2W) | P_Fld(0x00, SHU_ACTIM2_TFAW));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM3_0                                   ral_reg_DRAMC_blk_SHU_ACTIM3_0                             -     @5200
      TRFCPB                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[7:0]=8'h07 (Mirror: 8'h00)
      MANTMRR                                      uvm_reg_field                                              ...    RW SHU_ACTIM3_0[11:8]=4'h8 (Mirror: 4'h0)
      TR2MRR                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[15:12]=4'h8 (Mirror: 4'h0)
      TRFC                                         uvm_reg_field                                              ...    RW SHU_ACTIM3_0[23:16]=8'h1a (Mirror: 8'h00)
      TWTR_L                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[29:24]=6'h05 (Mirror: 6'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x07, SHU_ACTIM3_TRFCPB) |
            P_Fld(0x8, SHU_ACTIM3_TR2MRR) | P_Fld(0x1a, SHU_ACTIM3_TRFC));
    #endif

    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x8, SHU_ACTIM3_MANTMRR) |
            P_Fld(0x05, SHU_ACTIM3_TWTR_L));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM4_0                                   ral_reg_DRAMC_blk_SHU_ACTIM4_0                             -     @5208
      TXREFCNT                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[9:0]=10'h027 (Mirror: 10'h028)
      TMRR2MRW                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[15:10]=6'h0e (Mirror: 6'h00)
      TMRR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM4_0[21:16]=6'h0c (Mirror: 6'h00)
      TZQCS                                        uvm_reg_field                                              ...    RW SHU_ACTIM4_0[31:24]=8'h07 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM4, P_Fld(0x027, SHU_ACTIM4_TXREFCNT) |
            P_Fld(0x0e, SHU_ACTIM4_TMRR2MRW) | P_Fld(0x0c, SHU_ACTIM4_TMRR2W) |
            P_Fld(0x07, SHU_ACTIM4_TZQCS));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM5_0                                   ral_reg_DRAMC_blk_SHU_ACTIM5_0                             -     @5215
      TR2PD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[6:0]=7'h10 (Mirror: 7'h00)
      TWTPD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[14:8]=7'h0f (Mirror: 7'h00)
      TPBR2PBR                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[23:16]=8'h0b (Mirror: 8'h00)
      TPBR2ACT                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[29:28]=2'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM5, P_Fld(0x10, SHU_ACTIM5_TR2PD) |
            P_Fld(0x0f, SHU_ACTIM5_TWTPD) | P_Fld(0x0b, SHU_ACTIM5_TPBR2PBR) |
            P_Fld(0x0, SHU_ACTIM5_TPBR2ACT));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM6_0                                   ral_reg_DRAMC_blk_SHU_ACTIM6_0                             -     @5222
      TZQLAT2                                      uvm_reg_field                                              ...    RW SHU_ACTIM6_0[4:0]=5'h04 (Mirror: 5'h1f)
      TMRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[11:8]=4'h6 (Mirror: 4'h0)
      TMRW                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[15:12]=4'h5 (Mirror: 4'h0)
      TW2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[25:20]=6'h0d (Mirror: 6'h00)
      TR2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[31:26]=6'h11 (Mirror: 6'h13)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM6, P_Fld(0x04, SHU_ACTIM6_TZQLAT2) |
            P_Fld(0x6, SHU_ACTIM6_TMRD) | P_Fld(0x5, SHU_ACTIM6_TMRW) |
            P_Fld(0x0d, SHU_ACTIM6_TW2MRW) | P_Fld(0x11, SHU_ACTIM6_TR2MRW));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_CKECTRL_0                                  ral_reg_DRAMC_blk_SHU_CKECTRL_0                            -     @5300
      TPDE_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[0:0]=1'h0
      TPDX_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[1:1]=1'h0
      TPDE                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[14:12]=3'h3 (Mirror: 3'h1)
      TPDX                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[18:16]=3'h3 (Mirror: 3'h1)
      TCKEPRD                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[22:20]=3'h2
      TCKESRX                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[25:24]=2'h3 (Mirror: 2'h0)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_CKECTRL, P_Fld(0x0, SHU_CKECTRL_TPDE_05T) |
            P_Fld(0x0, SHU_CKECTRL_TPDX_05T) | P_Fld(0x3, SHU_CKECTRL_TPDE) |
            P_Fld(0x3, SHU_CKECTRL_TPDX) | P_Fld(0x2, SHU_CKECTRL_TCKEPRD));
    #endif
    vIO32WriteFldAlign(DRAMC_REG_SHU_CKECTRL, 0x3, SHU_CKECTRL_TCKESRX);
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_0                                     ral_reg_DRAMC_blk_SHU_MISC_0                               -     @5404
      REQQUE_MAXCNT                                uvm_reg_field                                              ...    RW SHU_MISC_0[3:0]=4'h2
      DCMDLYREF                                    uvm_reg_field                                              ...    RW SHU_MISC_0[18:16]=3'h7 (Mirror: 3'h4)
      DAREFEN                                      uvm_reg_field                                              ...    RW SHU_MISC_0[30:30]=1'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_MISC,
            P_Fld(0x7, SHU_MISC_DCMDLYREF) | P_Fld(0x0, SHU_MISC_DAREFEN));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldAlign(DRAMC_REG_SHU_MISC, 0x2, SHU_MISC_REQQUE_MAXCNT);
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Exit
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Enter.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Exit.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ8_0                            -     @8224
      R_DMRXDVS_UPD_FORCE_CYC_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[14:0]=15'h0018 (Mirror: 15'h0000)
      R_DMRXDVS_UPD_FORCE_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[15:15]=1'h0
      R_DMRANK_RXDLY_PIPE_CG_IG_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[19:19]=1'h0
      R_RMRODTEN_CG_IG_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[20:20]=1'h0
      R_RMRX_TOPHY_CG_IG_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[22:22]=1'h0
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0            uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[23:23]=1'h0
      R_DMRXDLY_CG_IG_B0                           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[26:26]=1'h0
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[27:27]=1'h0
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0               uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[28:28]=1'h0
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[29:29]=1'h0
      R_DMRANK_PIPE_CG_IG_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[30:30]=1'h0
      R_DMRANK_CHG_PIPE_CG_IG_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[31:31]=1'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) | P_Fld(0x1, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
            P_Fld(0x1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0));
    #endif

    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0018, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_EN_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ8_0                            -     @9647
      R_DMRXDVS_UPD_FORCE_CYC_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[14:0]=15'h0018 (Mirror: 15'h0000)
      R_DMRXDVS_UPD_FORCE_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[15:15]=1'h0
      R_DMRANK_RXDLY_PIPE_CG_IG_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[19:19]=1'h0
      R_RMRODTEN_CG_IG_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[20:20]=1'h0
      R_RMRX_TOPHY_CG_IG_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[22:22]=1'h0
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1            uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[23:23]=1'h0
      R_DMRXDLY_CG_IG_B1                           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[26:26]=1'h0
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[27:27]=1'h0
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1               uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[28:28]=1'h0
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[29:29]=1'h0
      R_DMRANK_PIPE_CG_IG_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[30:30]=1'h0
      R_DMRANK_CHG_PIPE_CG_IG_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[31:31]=1'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0018, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_EN_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) | P_Fld(0x1, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1) |
            P_Fld(0x1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ5_0                            -     @8124
      RG_RX_ARDQ_VREF_SEL_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[5:0]=6'h0e
      RG_RX_ARDQ_VREF_BYPASS_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[6:6]=1'h0
      RG_ARPI_FB_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[13:8]=6'h00
      RG_RX_ARDQS0_DQSIEN_DLY_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[18:16]=3'h0
      RG_RX_ARDQS_DQSIEN_RB_DLY_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[19:19]=1'h0
      RG_RX_ARDQS0_DVS_DLY_B0                      uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[23:20]=4'h7 (Mirror: 4'h0)
      RG_RX_ARDQ_FIFO_DQSI_DLY_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[31:29]=3'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ5, P_Fld(0x0e, SHU_B0_DQ5_RG_RX_ARDQ_VREF_SEL_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_VREF_BYPASS_B0) | P_Fld(0x00, SHU_B0_DQ5_RG_ARPI_FB_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B0) |
            P_Fld(0x7, SHU_B0_DQ5_RG_RX_ARDQS0_DVS_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ5_0                            -     @9547
      RG_RX_ARDQ_VREF_SEL_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[5:0]=6'h0e
      RG_RX_ARDQ_VREF_BYPASS_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[6:6]=1'h0
      RG_ARPI_FB_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[13:8]=6'h00
      RG_RX_ARDQS0_DQSIEN_DLY_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[18:16]=3'h0
      RG_RX_ARDQS_DQSIEN_RB_DLY_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[19:19]=1'h0
      RG_RX_ARDQS0_DVS_DLY_B1                      uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[23:20]=4'h7 (Mirror: 4'h0)
      RG_RX_ARDQ_FIFO_DQSI_DLY_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[31:29]=3'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ5, P_Fld(0x0e, SHU_B1_DQ5_RG_RX_ARDQ_VREF_SEL_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_VREF_BYPASS_B1) | P_Fld(0x00, SHU_B1_DQ5_RG_ARPI_FB_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B1) |
            P_Fld(0x7, SHU_B1_DQ5_RG_RX_ARDQS0_DVS_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_0                    -     @7878
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[7:0]=8'h68 (Mirror: 8'h00)
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[15:8]=8'h68 (Mirror: 8'h00)
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[23:16]=8'h68 (Mirror: 8'h00)
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[31:24]=8'h68 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x68, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x68, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_0                    -     @7892
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[7:0]=8'h68 (Mirror: 8'h00)
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[15:8]=8'h68 (Mirror: 8'h00)
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[23:16]=8'h68 (Mirror: 8'h00)
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[31:24]=8'h68 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1, P_Fld(0x68, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x68, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_0                    -     @7906
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[7:0]=8'h68 (Mirror: 8'h00)
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[15:8]=8'h68 (Mirror: 8'h00)
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[23:16]=8'h68 (Mirror: 8'h00)
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[31:24]=8'h68 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2, P_Fld(0x68, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x68, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_0                    -     @7920
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[7:0]=8'h68 (Mirror: 8'h00)
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[15:8]=8'h68 (Mirror: 8'h00)
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[23:16]=8'h68 (Mirror: 8'h00)
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[31:24]=8'h68 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3, P_Fld(0x68, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x68, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_0                    -     @7934
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[7:0]=8'h68 (Mirror: 8'h00)
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[15:8]=8'h68 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4, P_Fld(0x68, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0x68, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_0                    -     @7944
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[8:0]=9'h14a (Mirror: 9'h000)
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[24:16]=9'h14a (Mirror: 9'h000)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5, P_Fld(0x14a, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x14a, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_1                    -     @7885
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[7:0]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[15:8]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[23:16]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[31:24]=8'hc6 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_1                    -     @7899
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[7:0]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[15:8]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[23:16]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[31:24]=8'hc6 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0xc6, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_1                    -     @7913
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[7:0]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[15:8]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[23:16]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[31:24]=8'hc6 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0xc6, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_1                    -     @7927
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[7:0]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[15:8]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[23:16]=8'hc6 (Mirror: 8'h00)
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[31:24]=8'hc6 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0xc6, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_1                    -     @7939
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[7:0]=8'hc6 (Mirror: 8'h00)
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[15:8]=8'hc6 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0xc6, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0xc6, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_1                    -     @7949
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[8:0]=9'h1a1 (Mirror: 9'h000)
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[24:16]=9'h1a1 (Mirror: 9'h000)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1a1, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x1a1, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_0                    -     @9301
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[7:0]=8'h06 (Mirror: 8'h00)
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[15:8]=8'h06 (Mirror: 8'h00)
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[23:16]=8'h06 (Mirror: 8'h00)
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[31:24]=8'h06 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x06, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x06, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_0                    -     @9315
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[7:0]=8'h06 (Mirror: 8'h00)
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[15:8]=8'h06 (Mirror: 8'h00)
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[23:16]=8'h06 (Mirror: 8'h00)
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[31:24]=8'h06 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1, P_Fld(0x06, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x06, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_0                    -     @9329
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[7:0]=8'h06 (Mirror: 8'h00)
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[15:8]=8'h06 (Mirror: 8'h00)
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[23:16]=8'h06 (Mirror: 8'h00)
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[31:24]=8'h06 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2, P_Fld(0x06, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x06, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_0                    -     @9343
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[7:0]=8'h06 (Mirror: 8'h00)
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[15:8]=8'h06 (Mirror: 8'h00)
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[23:16]=8'h06 (Mirror: 8'h00)
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[31:24]=8'h06 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3, P_Fld(0x06, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x06, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_0                    -     @9357
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[7:0]=8'h06 (Mirror: 8'h00)
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[15:8]=8'h06 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4, P_Fld(0x06, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x06, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_0                    -     @9367
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[8:0]=9'h0e5 (Mirror: 9'h000)
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[24:16]=9'h0e5 (Mirror: 9'h000)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5, P_Fld(0x0e5, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x0e5, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_1                    -     @9308
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[7:0]=8'h65 (Mirror: 8'h00)
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[15:8]=8'h65 (Mirror: 8'h00)
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[23:16]=8'h65 (Mirror: 8'h00)
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[31:24]=8'h65 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_1                    -     @9322
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[7:0]=8'h65 (Mirror: 8'h00)
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[15:8]=8'h65 (Mirror: 8'h00)
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[23:16]=8'h65 (Mirror: 8'h00)
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[31:24]=8'h65 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x65, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_1                    -     @9336
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[7:0]=8'h65 (Mirror: 8'h00)
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[15:8]=8'h65 (Mirror: 8'h00)
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[23:16]=8'h65 (Mirror: 8'h00)
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[31:24]=8'h65 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x65, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_1                    -     @9350
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[7:0]=8'h65 (Mirror: 8'h00)
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[15:8]=8'h65 (Mirror: 8'h00)
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[23:16]=8'h65 (Mirror: 8'h00)
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[31:24]=8'h65 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x65, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_1                    -     @9362
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[7:0]=8'h65 (Mirror: 8'h00)
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[15:8]=8'h65 (Mirror: 8'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x65, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x65, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_1                    -     @9372
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[8:0]=9'h141 (Mirror: 9'h000)
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[24:16]=9'h141 (Mirror: 9'h000)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x141, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x141, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ9                                         ral_reg_DDRPHY_blk_B0_DQ9                                  -     @7772
      RG_RX_ARDQ_STBEN_RESETB_B0                   uvm_reg_field                                              ...    RW B0_DQ9[0:0]=1'h1 (Mirror: 1'h0)
      RG_RX_ARDQS0_STBEN_RESETB_B0                 uvm_reg_field                                              ...    RW B0_DQ9[4:4]=1'h0
      RG_RX_ARDQS0_DQSIENMODE_B0                   uvm_reg_field                                              ...    RW B0_DQ9[5:5]=1'h0
      R_DMRXDVS_R_F_DLY_RK_OPT_B0                  uvm_reg_field                                              ...    RW B0_DQ9[6:6]=1'h1
      R_DMRXFIFO_STBENCMP_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ9[7:7]=1'h0
      R_IN_GATE_EN_LOW_OPT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[15:8]=8'h00
      R_DMDQSIEN_VALID_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[18:16]=3'h0
      R_DMDQSIEN_RDSEL_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[22:20]=3'h0
      R_DMRXDVS_VALID_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[26:24]=3'h0
      R_DMRXDVS_RDSEL_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[30:28]=3'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ9, P_Fld(0x1, B0_DQ9_RG_RX_ARDQ_STBEN_RESETB_B0) |
            P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_DQSIENMODE_B0) |
            P_Fld(0x1, B0_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXFIFO_STBENCMP_EN_B0) |
            P_Fld(0x00, B0_DQ9_R_IN_GATE_EN_LOW_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMDQSIEN_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMDQSIEN_RDSEL_LAT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXDVS_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMRXDVS_RDSEL_LAT_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ9                                         ral_reg_DDRPHY_blk_B1_DQ9                                  -     @9195
      RG_RX_ARDQ_STBEN_RESETB_B1                   uvm_reg_field                                              ...    RW B1_DQ9[0:0]=1'h1 (Mirror: 1'h0)
      RG_RX_ARDQS0_STBEN_RESETB_B1                 uvm_reg_field                                              ...    RW B1_DQ9[4:4]=1'h0
      RG_RX_ARDQS0_DQSIENMODE_B1                   uvm_reg_field                                              ...    RW B1_DQ9[5:5]=1'h0
      R_DMRXDVS_R_F_DLY_RK_OPT_B1                  uvm_reg_field                                              ...    RW B1_DQ9[6:6]=1'h1
      R_DMRXFIFO_STBENCMP_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ9[7:7]=1'h0
      R_IN_GATE_EN_LOW_OPT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[15:8]=8'h00
      R_DMDQSIEN_VALID_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[18:16]=3'h0
      R_DMDQSIEN_RDSEL_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[22:20]=3'h0
      R_DMRXDVS_VALID_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[26:24]=3'h0
      R_DMRXDVS_RDSEL_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[30:28]=3'h0
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ9, P_Fld(0x1, B1_DQ9_RG_RX_ARDQ_STBEN_RESETB_B1) |
            P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_DQSIENMODE_B1) |
            P_Fld(0x1, B1_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXFIFO_STBENCMP_EN_B1) |
            P_Fld(0x00, B1_DQ9_R_IN_GATE_EN_LOW_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMDQSIEN_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMDQSIEN_RDSEL_LAT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXDVS_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMRXDVS_RDSEL_LAT_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ4                                         ral_reg_DDRPHY_blk_B0_DQ4                                  -     @7701
      RG_RX_ARDQS_EYE_R_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[6:0]=7'h76 (Mirror: 7'h00)
      RG_RX_ARDQS_EYE_F_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[14:8]=7'h76 (Mirror: 7'h00)
      RG_RX_ARDQ_EYE_R_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[21:16]=6'h28 (Mirror: 6'h00)
      RG_RX_ARDQ_EYE_F_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[29:24]=6'h28 (Mirror: 6'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ4, P_Fld(0x76, B0_DQ4_RG_RX_ARDQS_EYE_R_DLY_B0) |
            P_Fld(0x76, B0_DQ4_RG_RX_ARDQS_EYE_F_DLY_B0) | P_Fld(0x28, B0_DQ4_RG_RX_ARDQ_EYE_R_DLY_B0) |
            P_Fld(0x28, B0_DQ4_RG_RX_ARDQ_EYE_F_DLY_B0));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ4                                         ral_reg_DDRPHY_blk_B1_DQ4                                  -     @9124
      RG_RX_ARDQS_EYE_R_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[6:0]=7'h14 (Mirror: 7'h00)
      RG_RX_ARDQS_EYE_F_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[14:8]=7'h14 (Mirror: 7'h00)
      RG_RX_ARDQ_EYE_R_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[21:16]=6'h06 (Mirror: 6'h00)
      RG_RX_ARDQ_EYE_F_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[29:24]=6'h06 (Mirror: 6'h00)
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ4, P_Fld(0x14, B1_DQ4_RG_RX_ARDQS_EYE_R_DLY_B1) |
            P_Fld(0x14, B1_DQ4_RG_RX_ARDQS_EYE_F_DLY_B1) | P_Fld(0x06, B1_DQ4_RG_RX_ARDQ_EYE_R_DLY_B1) |
            P_Fld(0x06, B1_DQ4_RG_RX_ARDQ_EYE_F_DLY_B1));
    /*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value
    --------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ5                                         ral_reg_DDRPHY_blk_B0_DQ5                                  -     @7708
      RG_RX_ARDQ_EYE_VREF_SEL_B0                   uvm_reg_field                                              ...    RW B0_DQ5[13:8]=6'h0e
      RG_RX_ARDQ_VREF_EN_B0                        uvm_reg_field                                              ...    RW B0_DQ5[16:16]=1'h0
      RG_RX_ARDQ_EYE_VREF_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ5[17:17]=1'h0
      RG_RX_ARDQ_EYE_SEL_B0                        uvm_reg_field                                              ...    RW B0_DQ5[23:20]=4'h0
      RG_RX_ARDQ_EYE_EN_B0                         uvm_reg_field                                              ...    RW B0_DQ5[24:24]=1'h0
  RG_RX_ARDQ_EYE_STBEN_RESETB_B0               uvm_reg_field                                              ...    RW B0_DQ5[25:25]=1'h1 (Mirror: 1'h0)
  RG_RX_ARDQS0_DVS_EN_B0                       uvm_reg_field                                              ...    RW B0_DQ5[31:31]=1'h0
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B0_DQ5, P_Fld(0x0e, B0_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B0) |
        P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B0) |
        P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_SEL_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_EN_B0) |
        P_Fld(0x1, B0_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQS0_DVS_EN_B0));
/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name                                           Type                                                       Size  Value
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
B1_DQ5                                         ral_reg_DDRPHY_blk_B1_DQ5                                  -     @9131
  RG_RX_ARDQ_EYE_VREF_SEL_B1                   uvm_reg_field                                              ...    RW B1_DQ5[13:8]=6'h0e
  RG_RX_ARDQ_VREF_EN_B1                        uvm_reg_field                                              ...    RW B1_DQ5[16:16]=1'h0
  RG_RX_ARDQ_EYE_VREF_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ5[17:17]=1'h0
  RG_RX_ARDQ_EYE_SEL_B1                        uvm_reg_field                                              ...    RW B1_DQ5[23:20]=4'h0
  RG_RX_ARDQ_EYE_EN_B1                         uvm_reg_field                                              ...    RW B1_DQ5[24:24]=1'h0
  RG_RX_ARDQ_EYE_STBEN_RESETB_B1               uvm_reg_field                                              ...    RW B1_DQ5[25:25]=1'h1 (Mirror: 1'h0)
  RG_RX_ARDQS0_DVS_EN_B1                       uvm_reg_field                                              ...    RW B1_DQ5[31:31]=1'h0
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
*/
vIO32WriteFldMulti(DDRPHY_REG_B1_DQ5, P_Fld(0x0e, B1_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B1) |
        P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B1) |
        P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_SEL_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_EN_B1) |
        P_Fld(0x1, B1_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQS0_DVS_EN_B1));
//    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set EXIT
//    Exit body
}

void sv_algorithm_assistance_LP4_800(DRAMC_CTX_T *p)
{
    //    Enter body
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Enter:
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RDSEL_TRACK_0                         ral_reg_DDRPHY_blk_SHU_MISC_RDSEL_TRACK_0                  -     @13206                                                     
      DMDATLAT_i                                   uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[4:0]=5'h0e (Mirror: 5'h00)      
      RDSEL_HWSAVE_MSK                             uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[6:6]=1'h1 (Mirror: 1'h0)        
      RDSEL_TRACK_EN                               uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[7:7]=1'h0                       
      SHU_GW_THRD_NEG                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[19:8]=12'hff5 (Mirror: 12'h000) 
      SHU_GW_THRD_POS                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[31:20]=12'h00b (Mirror: 12'h000)
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, P_Fld(0x0e, SHU_MISC_RDSEL_TRACK_DMDATLAT_I) |
            P_Fld(0x1, SHU_MISC_RDSEL_TRACK_RDSEL_HWSAVE_MSK) | P_Fld(0x0, SHU_MISC_RDSEL_TRACK_RDSEL_TRACK_EN) |
            P_Fld(0xff5, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_NEG) | P_Fld(0x00b, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_POS));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RDAT_0                                ral_reg_DDRPHY_blk_MISC_SHU_RDAT_0                         -     @13076                                                     
      DATLAT                                       uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[4:0]=5'h0e (Mirror: 5'h00)             
      DATLAT_DSEL                                  uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[12:8]=5'h0e (Mirror: 5'h00)            
      DATLAT_DSEL_PHY                              uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[20:16]=5'h0e (Mirror: 5'h00)           
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RDAT, P_Fld(0x0e, MISC_SHU_RDAT_DATLAT) |
            P_Fld(0x0e, MISC_SHU_RDAT_DATLAT_DSEL) | P_Fld(0x0e, MISC_SHU_RDAT_DATLAT_DSEL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_PHY_RX_CTRL_0                         ral_reg_DDRPHY_blk_MISC_SHU_PHY_RX_CTRL_0                  -     @13012                                                     
      RANK_RXDLY_UPDLAT_EN                         uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[8:8]=1'h1 (Mirror: 1'h0)        
      RANK_RXDLY_UPD_OFFSET                        uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[11:9]=3'h2 (Mirror: 3'h0)       
      RX_IN_GATE_EN_PRE_OFFSET                     uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[15:14]=2'h1 (Mirror: 2'h0)      
      RX_IN_GATE_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[18:16]=3'h0                     
      RX_IN_GATE_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[22:20]=3'h1 (Mirror: 3'h0)      
      RX_IN_BUFF_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[26:24]=3'h0                     
      RX_IN_BUFF_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[30:28]=3'h0                     
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL, P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPDLAT_EN) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPD_OFFSET) | P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET) |
            P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD) | P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
            P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) | P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_TAIL));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANKCTL_0                             ral_reg_DDRPHY_blk_MISC_SHU_RANKCTL_0                      -     @13002                                                     
      RANKINCTL_RXDLY                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[3:0]=4'h3 (Mirror: 4'h0)            
      RANK_RXDLY_OPT                               uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[4:4]=1'h1                           
      RANKSEL_SELPH_FRUN                           uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[15:15]=1'h1 (Mirror: 1'h0)          
      RANKINCTL_STB                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[19:16]=4'h4 (Mirror: 4'h0)          
      RANKINCTL                                    uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[23:20]=4'h4 (Mirror: 4'h0)          
      RANKINCTL_ROOT1                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[27:24]=4'h4 (Mirror: 4'h0)          
      RANKINCTL_PHY                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[31:28]=4'h6 (Mirror: 4'h0)          
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x3, MISC_SHU_RANKCTL_RANKINCTL_RXDLY) |
            P_Fld(0x1, MISC_SHU_RANKCTL_RANK_RXDLY_OPT) | P_Fld(0x1, MISC_SHU_RANKCTL_RANKSEL_SELPH_FRUN) |
            P_Fld(0x4, MISC_SHU_RANKCTL_RANKINCTL_STB));
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x4, MISC_SHU_RANKCTL_RANKINCTL) |
            P_Fld(0x4, MISC_SHU_RANKCTL_RANKINCTL_ROOT1) | P_Fld(0x6, MISC_SHU_RANKCTL_RANKINCTL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANK_SEL_LAT_0                        ral_reg_DDRPHY_blk_MISC_SHU_RANK_SEL_LAT_0                 -     @13229                                                     
      RANK_SEL_LAT_B0                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[3:0]=4'h4 (Mirror: 4'h0)       
      RANK_SEL_LAT_B1                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[7:4]=4'h4 (Mirror: 4'h0)       
      RANK_SEL_LAT_CA                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[11:8]=4'h4 (Mirror: 4'h0)      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANK_SEL_LAT, P_Fld(0x4, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B0) |
            P_Fld(0x4, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B1) | P_Fld(0x4, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_CA));

    #if !CODE_SIZE_REDUCE
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_0                  -     @12823                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_0[3:0]=4'h6 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL, 0x6, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_1                  -     @12827                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_1[3:0]=4'h6 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL+(1*DDRPHY_AO_RANK_OFFSET), 0x6, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0         -     @8022                                                       
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h6 (Mirror: 4'h0)
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h8 (Mirror: 4'h0)
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h0             
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY, P_Fld(0x6, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0x8, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_0             -     @8036                                                       
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_0[6:0]=7'h0b (Mirror: 7'h00)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY, 0x0b, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1         -     @8029                                                       
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h7 (Mirror: 4'h0)
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'h9 (Mirror: 4'h0)
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h0             
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0x9, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_1             -     @8040                                                       
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_1[6:0]=7'h1f (Mirror: 7'h00)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x1f, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0         -     @9429                                                       
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h6 (Mirror: 4'h0)
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h8 (Mirror: 4'h0)
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h0             
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY, P_Fld(0x6, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0x8, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_0             -     @9443                                                       
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_0[6:0]=7'h0b (Mirror: 7'h00)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY, 0x0b, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1         -     @9436                                                       
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h7 (Mirror: 4'h0)
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'h9 (Mirror: 4'h0)
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h0             
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0x9, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_1             -     @9447                                                       
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_1[6:0]=7'h1f (Mirror: 7'h00)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x1f, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_ODTCTRL_0                             ral_reg_DDRPHY_blk_MISC_SHU_ODTCTRL_0                      -     @13022                                                      
      RODTEN                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[0:0]=1'h1 (Mirror: 1'h0)             
      RODTENSTB_SELPH_CG_IG                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[1:1]=1'h0                            
      RODT_LAT                                     uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[7:4]=4'h4 (Mirror: 4'h0)             
      RODTEN_SELPH_FRUN                            uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[15:15]=1'h0                          
      RODTDLY_LAT_OPT                              uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[25:24]=2'h0                          
      FIXRODT                                      uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[27:27]=1'h0                          
      RODTEN_OPT                                   uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[29:29]=1'h1                          
      RODTE2                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[30:30]=1'h1 (Mirror: 1'h0)           
      RODTE                                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[31:31]=1'h1 (Mirror: 1'h0)           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_ODTCTRL, P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTEN_SELPH_FRUN) | P_Fld(0x0, MISC_SHU_ODTCTRL_RODTDLY_LAT_OPT) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_FIXRODT) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN_OPT) |
            P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE2) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, 0x4, MISC_SHU_ODTCTRL_RODT_LAT);
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ7_0                            -     @8206                                                       
      R_DMRANKRXDVS_B0                             uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[3:0]=4'h0                                  
      R_DMDQMDBI_EYE_SHU_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[6:6]=1'h0                                  
      R_DMDQMDBI_SHU_B0                            uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[7:7]=1'h0                                  
      R_DMRXDVS_DQM_FLAGSEL_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[11:8]=4'h0                                 
      R_DMRXDVS_PBYTE_FLAG_OPT_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[12:12]=1'h0                                
      R_DMRXDVS_PBYTE_DQM_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[13:13]=1'h0                                
      R_DMRXTRACK_DQM_EN_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[14:14]=1'h0                                
      R_DMRODTEN_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                 
      R_DMARPI_CG_FB2DLL_DCM_EN_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[16:16]=1'h0                                
      R_DMTX_ARPI_CG_DQ_NEW_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[17:17]=1'h0                                
      R_DMTX_ARPI_CG_DQS_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[18:18]=1'h0                                
      R_DMTX_ARPI_CG_DQM_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[19:19]=1'h0                                
      R_LP4Y_SDN_MODE_DQS0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[20:20]=1'h0                                
      R_DMRXRANK_DQ_EN_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                 
      R_DMRXRANK_DQ_LAT_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                 
      R_DMRXRANK_DQS_EN_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                 
      R_DMRXRANK_DQS_LAT_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[31:29]=3'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRANKRXDVS_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_EYE_SHU_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_SHU_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXTRACK_DQM_EN_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRODTEN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_LP4Y_SDN_MODE_DQS0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_EN_B0) | P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_LAT_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQS_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXRANK_DQS_LAT_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ7_0                            -     @9613                                                       
      R_DMRANKRXDVS_B1                             uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[3:0]=4'h0                                  
      R_DMDQMDBI_EYE_SHU_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[6:6]=1'h0                                  
      R_DMDQMDBI_SHU_B1                            uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[7:7]=1'h0                                  
      R_DMRXDVS_DQM_FLAGSEL_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[11:8]=4'h0                                 
      R_DMRXDVS_PBYTE_FLAG_OPT_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[12:12]=1'h0                                
      R_DMRXDVS_PBYTE_DQM_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[13:13]=1'h0                                
      R_DMRXTRACK_DQM_EN_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[14:14]=1'h0                                
      R_DMRODTEN_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                 
      R_DMARPI_CG_FB2DLL_DCM_EN_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[16:16]=1'h0                                
      R_DMTX_ARPI_CG_DQ_NEW_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[17:17]=1'h0                                
      R_DMTX_ARPI_CG_DQS_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[18:18]=1'h0                                
      R_DMTX_ARPI_CG_DQM_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[19:19]=1'h0                                
      R_LP4Y_SDN_MODE_DQS1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[20:20]=1'h0                                
      R_DMRXRANK_DQ_EN_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                 
      R_DMRXRANK_DQ_LAT_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                 
      R_DMRXRANK_DQS_EN_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                 
      R_DMRXRANK_DQS_LAT_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[31:29]=3'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRANKRXDVS_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_EYE_SHU_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_SHU_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXTRACK_DQM_EN_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRODTEN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_LP4Y_SDN_MODE_DQS1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_EN_B1) | P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_LAT_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQS_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXRANK_DQS_LAT_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RX_PIPE_CTRL_0                        ral_reg_DDRPHY_blk_SHU_MISC_RX_PIPE_CTRL_0                 -     @13176                                                      
      RX_PIPE_BYPASS_EN                            uvm_reg_field                                              ...    RW SHU_MISC_RX_PIPE_CTRL_0[0:0]=1'h1 (Mirror: 1'h0)        
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RX_PIPE_CTRL, 0x1, SHU_MISC_RX_PIPE_CTRL_RX_PIPE_BYPASS_EN);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0         -     @8044                                                       
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h1 (Mirror: 3'h0)
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0             
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY, P_Fld(0x1, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x1, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1         -     @8051                                                       
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h2 (Mirror: 3'h0)
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h2 (Mirror: 3'h0)
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h0             
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x2, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0         -     @9451                                                       
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h1 (Mirror: 3'h0)
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0             
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY, P_Fld(0x1, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x1, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1         -     @9458                                                       
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h2 (Mirror: 3'h0)
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h2 (Mirror: 3'h0)
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h0             
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x2, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RX_CG_SET0_0                               ral_reg_DRAMC_blk_SHU_RX_CG_SET0_0                         -     @5628                                                       
      DLE_LAST_EXTEND3                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[0:0]=1'h0                              
      READ_START_EXTEND3                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[1:1]=1'h0                              
      DLE_LAST_EXTEND2                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[2:2]=1'h1 (Mirror: 1'h0)               
      READ_START_EXTEND2                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[3:3]=1'h1 (Mirror: 1'h0)               
      DLE_LAST_EXTEND1                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[4:4]=1'h1 (Mirror: 1'h0)               
      READ_START_EXTEND1                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[5:5]=1'h1 (Mirror: 1'h0)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_RX_CG_SET0, P_Fld(0x0, SHU_RX_CG_SET0_DLE_LAST_EXTEND3) |
            P_Fld(0x0, SHU_RX_CG_SET0_READ_START_EXTEND3) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND2) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND2) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND1) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RANK_SEL_STB_0                        ral_reg_DDRPHY_blk_SHU_MISC_RANK_SEL_STB_0                 -     @13192                                                      
      RANK_SEL_STB_EN                              uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[0:0]=1'h1 (Mirror: 1'h0)        
      RANK_SEL_STB_EN_B23                          uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[1:1]=1'h0                       
      RANK_SEL_STB_SERMODE                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[3:2]=2'h0                       
      RANK_SEL_STB_TRACK                           uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[4:4]=1'h1 (Mirror: 1'h0)        
      RANK_SEL_RXDLY_TRACK                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[5:5]=1'h0                       
      RANK_SEL_STB_PHASE_EN                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[7:7]=1'h0                       
      RANK_SEL_PHSINCTL                            uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[11:8]=4'h5 (Mirror: 4'h0)       
      RANK_SEL_STB_UI_PLUS                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[19:16]=4'h0                     
      RANK_SEL_STB_MCK_PLUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[23:20]=4'h0                     
      RANK_SEL_STB_UI_MINUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[27:24]=4'h0                     
      RANK_SEL_STB_MCK_MINUS                       uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[31:28]=4'h1 (Mirror: 4'h0)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN_B23) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_SERMODE) |
            P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_TRACK) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_RXDLY_TRACK) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_PHASE_EN) | P_Fld(0x5, SHU_MISC_RANK_SEL_STB_RANK_SEL_PHSINCTL) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_PLUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_PLUS) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_MINUS) | P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_MINUS));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_0                  -     @12841                                                      
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[6:0]=7'h60 (Mirror: 7'h00)       
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[7:7]=1'h1 (Mirror: 1'h0)         
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[14:8]=7'h3f (Mirror: 7'h00)      
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[15:15]=1'h1 (Mirror: 1'h0)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL, P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_1                  -     @12848                                                      
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[6:0]=7'h60 (Mirror: 7'h00)       
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[7:7]=1'h1 (Mirror: 1'h0)         
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[14:8]=7'h3f (Mirror: 7'h00)      
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[15:15]=1'h1 (Mirror: 1'h0)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_0                  -     @8000                                                       
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)       
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[15:8]=8'h06 (Mirror: 8'h00)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI, P_Fld(0x0b, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x06, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_0                  -     @9407                                                       
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)       
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[15:8]=8'h06 (Mirror: 8'h00)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI, P_Fld(0x0b, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x06, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_1                  -     @8005                                                       
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[6:0]=7'h1f (Mirror: 7'h00)       
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[15:8]=8'h07 (Mirror: 8'h00)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1f, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x07, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_1                  -     @9412                                                       
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[6:0]=7'h1f (Mirror: 7'h00)       
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[15:8]=8'h07 (Mirror: 8'h00)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1f, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x07, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_0             -     @8010                                                       
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)  
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[15:8]=8'h06 (Mirror: 8'h00) 
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[31:24]=8'h08 (Mirror: 8'h00)
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI, P_Fld(0x0b, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x06, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x08, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_0             -     @9417                                                       
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[6:0]=7'h0b (Mirror: 7'h00)  
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[15:8]=8'h06 (Mirror: 8'h00) 
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[31:24]=8'h08 (Mirror: 8'h00)
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI, P_Fld(0x0b, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x06, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x08, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_1             -     @8016                                                       
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[6:0]=7'h1f (Mirror: 7'h00)  
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[15:8]=8'h07 (Mirror: 8'h00) 
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[31:24]=8'h09 (Mirror: 8'h00)
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1f, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x07, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x09, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_1             -     @9423                                                       
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[6:0]=7'h1f (Mirror: 7'h00)  
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[15:8]=8'h07 (Mirror: 8'h00) 
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[31:24]=8'h09 (Mirror: 8'h00)
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1f, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x07, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x09, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Exit:
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Enter:
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_0                       -     @7980                                                       
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[2:0]=3'h0                             
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[6:4]=3'h0                             
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[13:8]=6'h18 (Mirror: 6'h00)           
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[21:16]=6'h18 (Mirror: 6'h00)          
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[29:24]=6'h00                          
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[30:30]=1'h0                           
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[31:31]=1'h0                           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x18, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x18, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_0                       -     @9387                                                       
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[2:0]=3'h0                             
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[6:4]=3'h0                             
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[13:8]=6'h18 (Mirror: 6'h00)           
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[21:16]=6'h18 (Mirror: 6'h00)          
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[29:24]=6'h00                          
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[30:30]=1'h0                           
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[31:31]=1'h0                           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x18, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x18, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_1                       -     @7990                                                       
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[2:0]=3'h0                             
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[6:4]=3'h0                             
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[13:8]=6'h18 (Mirror: 6'h00)           
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[21:16]=6'h18 (Mirror: 6'h00)          
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[29:24]=6'h00                          
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[30:30]=1'h0                           
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[31:31]=1'h0                           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x18, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x18, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_1                       -     @9397                                                       
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[2:0]=3'h0                             
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[6:4]=3'h0                             
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[13:8]=6'h18 (Mirror: 6'h00)           
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[21:16]=6'h18 (Mirror: 6'h00)          
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[29:24]=6'h00                          
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[30:30]=1'h0                           
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[31:31]=1'h0                           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x18, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x18, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_DCM_CTRL0_0                                ral_reg_DRAMC_blk_SHU_DCM_CTRL0_0                          -     @5331                                                       
      DDRPHY_CLK_EN_OPT                            uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[7:7]=1'h1 (Mirror: 1'h0)                
      DPHY_CMD_CLKEN_EXTCNT                        uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[10:8]=3'h3                              
      DDRPHY_CLK_DYN_GATING_SEL                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[15:12]=4'h6 (Mirror: 4'h0)              
      APHYPI_CKCGL_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[19:16]=4'h2                             
      APHYPI_CKCGH_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[23:20]=4'h4                             
      FASTWAKE2                                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[29:29]=1'h0                             
      FASTWAKE                                     uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[31:31]=1'h1                             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_DCM_CTRL0, P_Fld(0x1, SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT) |
            P_Fld(0x3, SHU_DCM_CTRL0_DPHY_CMD_CLKEN_EXTCNT) | P_Fld(0x6, SHU_DCM_CTRL0_DDRPHY_CLK_DYN_GATING_SEL) |
            P_Fld(0x2, SHU_DCM_CTRL0_APHYPI_CKCGL_CNT) | P_Fld(0x5, SHU_DCM_CTRL0_APHYPI_CKCGH_CNT) |
            P_Fld(0x0, SHU_DCM_CTRL0_FASTWAKE2) | P_Fld(0x1, SHU_DCM_CTRL0_FASTWAKE));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_APHY_TX_PICG_CTRL_0                        ral_reg_DRAMC_blk_SHU_APHY_TX_PICG_CTRL_0                  -     @5683                                                       
      DDRPHY_CLK_EN_COMB_TX_PICG_CNT               uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[3:0]=4'h3 (Mirror: 4'h0)        
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[6:4]=3'h0                       
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[10:8]=3'h3 (Mirror: 3'h0)       
      DPHY_TX_DCM_EXTCNT                           uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[15:12]=4'h2                     
      DDRPHY_CLK_EN_COMB_TX_OPT                    uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[31:31]=1'h1 (Mirror: 1'h0)      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_APHY_TX_PICG_CTRL, P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT) |
            P_Fld(0x0, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1) | P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0) |
            P_Fld(0x2, SHU_APHY_TX_PICG_CTRL_DPHY_TX_DCM_EXTCNT) | P_Fld(0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_APHY_TX_PICG_CTRL_0_0                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_0              -     @5221                                                       
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[2:0]=3'h0                   
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[6:4]=3'h3 (Mirror: 3'h0)    
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL, P_Fld(0x0, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
            P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_APHY_TX_PICG_CTRL_0_1                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_1              -     @5226                                                       
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[2:0]=3'h0                   
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[6:4]=3'h3 (Mirror: 3'h0)    
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x0, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
            P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_NEW_XRW2W_CTRL_0                           ral_reg_DRAMC_blk_SHU_NEW_XRW2W_CTRL_0                     -     @5677                                                       
      TX_PI_UPDCTL_B0                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[18:16]=3'h2 (Mirror: 3'h0)         
      TX_PI_UPDCTL_B1                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[26:24]=3'h2 (Mirror: 3'h0)         
      TXPI_UPD_MODE                                uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[31:31]=1'h0 (Mirror: 1'h1)         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_NEW_XRW2W_CTRL, P_Fld(0x2, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B0) |
            P_Fld(0x2, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B1) | P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TXPI_UPD_MODE));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SELPH_DQS0_0                               ral_reg_DRAMC_blk_SHU_SELPH_DQS0_0                         -     @5576                                                       
      TXDLY_DQS0                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[2:0]=3'h4 (Mirror: 3'h1)               
      TXDLY_DQS1                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[6:4]=3'h4 (Mirror: 3'h1)               
      TXDLY_DQS2                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[10:8]=3'h1                             
      TXDLY_DQS3                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[14:12]=3'h1                            
      TXDLY_OEN_DQS0                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[18:16]=3'h3 (Mirror: 3'h1)             
      TXDLY_OEN_DQS1                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[22:20]=3'h3 (Mirror: 3'h1)             
      TXDLY_OEN_DQS2                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[26:24]=3'h1                            
      TXDLY_OEN_DQS3                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[30:28]=3'h1                            
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS3) | P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS3));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x4, SHU_SELPH_DQS0_TXDLY_DQS0) |
            P_Fld(0x4, SHU_SELPH_DQS0_TXDLY_DQS1) | P_Fld(0x3, SHU_SELPH_DQS0_TXDLY_OEN_DQS0) |
            P_Fld(0x3, SHU_SELPH_DQS0_TXDLY_OEN_DQS1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ0_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_0                      -     @5041                                                       
      TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[2:0]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[6:4]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[10:8]=3'h1                          
      TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[14:12]=3'h1                         
      TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[18:16]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[22:20]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[26:24]=3'h1                         
      TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[30:28]=3'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0, P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ0) |
            P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
            P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ1_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_0                      -     @5063                                                       
      TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[2:0]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[6:4]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[10:8]=3'h1                          
      TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[14:12]=3'h1                         
      TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[18:16]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[22:20]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[26:24]=3'h1                         
      TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[30:28]=3'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1, P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM0) |
            P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
            P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ2_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_0                      -     @5085                                                       
      dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[3:0]=4'h1                           
      dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[7:4]=4'h1                           
      dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[11:8]=4'h1                          
      dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[15:12]=4'h1                         
      dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[19:16]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[23:20]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[27:24]=4'h1                         
      dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[31:28]=4'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2, P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ0) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x2, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
            P_Fld(0x2, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ3_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_0                      -     @5107                                                       
      dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[3:0]=4'h1                           
      dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[7:4]=4'h1                           
      dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[11:8]=4'h1                          
      dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[15:12]=4'h1                         
      dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[19:16]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[23:20]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[27:24]=4'h1                         
      dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[31:28]=4'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3, P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM0) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x2, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
            P_Fld(0x2, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ0_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_1                      -     @5052                                                       
      TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[2:0]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[6:4]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[10:8]=3'h1                          
      TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[14:12]=3'h1                         
      TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[18:16]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[22:20]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[26:24]=3'h1                         
      TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[30:28]=3'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ0) |
            P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
            P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ1_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_1                      -     @5074                                                       
      TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[2:0]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[6:4]=3'h4 (Mirror: 3'h1)            
      TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[10:8]=3'h1                          
      TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[14:12]=3'h1                         
      TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[18:16]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[22:20]=3'h3 (Mirror: 3'h1)          
      TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[26:24]=3'h1                         
      TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[30:28]=3'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM0) |
            P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
            P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ2_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_1                      -     @5096                                                       
      dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[3:0]=4'h1                           
      dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[7:4]=4'h1                           
      dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[11:8]=4'h1                          
      dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[15:12]=4'h1                         
      dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[19:16]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[23:20]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[27:24]=4'h1                         
      dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[31:28]=4'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ0) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x2, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
            P_Fld(0x2, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ3_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_1                      -     @5118                                                       
      dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[3:0]=4'h1                           
      dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[7:4]=4'h1                           
      dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[11:8]=4'h1                          
      dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[15:12]=4'h1                         
      dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[19:16]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[23:20]=4'h2 (Mirror: 4'h1)          
      dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[27:24]=4'h1                         
      dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[31:28]=4'h1                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM0) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x2, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
            P_Fld(0x2, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL1_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_0                    -     @5129                                                       
      BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1, P_Fld(0x018, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL2_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_0                    -     @5139                                                       
      BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2, P_Fld(0x018, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL5_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_0                    -     @5177                                                       
      BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5, P_Fld(0x018, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL1_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_1                    -     @5134                                                       
      BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x018, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL2_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_1                    -     @5144                                                       
      BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x018, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL5_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_1                    -     @5182                                                       
      BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[10:0]=11'h018 (Mirror: 11'h000)   
      BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[26:16]=11'h018 (Mirror: 11'h000)  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x018, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
            P_Fld(0x018, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_PI_0_0                                   ral_reg_DRAMC_blk_SHURK_PI_0_0                             -     @5187                                                       
      RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[5:0]=6'h18 (Mirror: 6'h00)                 
      RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[13:8]=6'h18 (Mirror: 6'h00)                
      RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[21:16]=6'h18 (Mirror: 6'h00)               
      RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[29:24]=6'h18 (Mirror: 6'h00)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_PI, P_Fld(0x18, SHURK_PI_RK0_ARPI_DQ_B1) |
            P_Fld(0x18, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x18, SHURK_PI_RK0_ARPI_DQM_B1) |
            P_Fld(0x18, SHURK_PI_RK0_ARPI_DQM_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_PI_0_1                                   ral_reg_DRAMC_blk_SHURK_PI_0_1                             -     @5194                                                       
      RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[5:0]=6'h18 (Mirror: 6'h00)                 
      RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[13:8]=6'h18 (Mirror: 6'h00)                
      RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[21:16]=6'h18 (Mirror: 6'h00)               
      RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[29:24]=6'h18 (Mirror: 6'h00)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_PI+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x18, SHURK_PI_RK0_ARPI_DQ_B1) |
            P_Fld(0x18, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x18, SHURK_PI_RK0_ARPI_DQM_B1) |
            P_Fld(0x18, SHURK_PI_RK0_ARPI_DQM_B0));

    #if !CODE_SIZE_REDUCE
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY0_0_0                    -     @7826                                                       
      TX_ARDQ0_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[7:0]=8'h30 (Mirror: 8'h00)         
      TX_ARDQ1_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[15:8]=8'h30 (Mirror: 8'h00)        
      TX_ARDQ2_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[23:16]=8'h30 (Mirror: 8'h00)       
      TX_ARDQ3_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[31:24]=8'h30 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY0, P_Fld(0x30, SHU_R0_B0_TXDLY0_TX_ARDQ0_DLY_B0) |
            P_Fld(0x30, SHU_R0_B0_TXDLY0_TX_ARDQ1_DLY_B0) | P_Fld(0x30, SHU_R0_B0_TXDLY0_TX_ARDQ2_DLY_B0) |
            P_Fld(0x30, SHU_R0_B0_TXDLY0_TX_ARDQ3_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY1_0_0                    -     @7840                                                       
      TX_ARDQ4_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[7:0]=8'h30 (Mirror: 8'h00)         
      TX_ARDQ5_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[15:8]=8'h30 (Mirror: 8'h00)        
      TX_ARDQ6_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[23:16]=8'h30 (Mirror: 8'h00)       
      TX_ARDQ7_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[31:24]=8'h30 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY1, P_Fld(0x30, SHU_R0_B0_TXDLY1_TX_ARDQ4_DLY_B0) |
            P_Fld(0x30, SHU_R0_B0_TXDLY1_TX_ARDQ5_DLY_B0) | P_Fld(0x30, SHU_R0_B0_TXDLY1_TX_ARDQ6_DLY_B0) |
            P_Fld(0x30, SHU_R0_B0_TXDLY1_TX_ARDQ7_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY3_0_0                    -     @7868                                                       
      TX_ARDQM0_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[7:0]=8'h30 (Mirror: 8'h00)         
      TX_ARWCK_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[23:16]=8'h00                       
      TX_ARWCKB_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[31:24]=8'h00                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY3, P_Fld(0x30, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0) |
            P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCK_DLY_B0) | P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCKB_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY0_0_0                    -     @9233                                                       
      TX_ARDQ0_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[7:0]=8'h0c (Mirror: 8'h00)         
      TX_ARDQ1_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[15:8]=8'h0c (Mirror: 8'h00)        
      TX_ARDQ2_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[23:16]=8'h0c (Mirror: 8'h00)       
      TX_ARDQ3_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[31:24]=8'h0c (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY0, P_Fld(0x0c, SHU_R0_B1_TXDLY0_TX_ARDQ0_DLY_B1) |
            P_Fld(0x0c, SHU_R0_B1_TXDLY0_TX_ARDQ1_DLY_B1) | P_Fld(0x0c, SHU_R0_B1_TXDLY0_TX_ARDQ2_DLY_B1) |
            P_Fld(0x0c, SHU_R0_B1_TXDLY0_TX_ARDQ3_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY1_0_0                    -     @9247                                                       
      TX_ARDQ4_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[7:0]=8'h0c (Mirror: 8'h00)         
      TX_ARDQ5_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[15:8]=8'h0c (Mirror: 8'h00)        
      TX_ARDQ6_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[23:16]=8'h0c (Mirror: 8'h00)       
      TX_ARDQ7_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[31:24]=8'h0c (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY1, P_Fld(0x0c, SHU_R0_B1_TXDLY1_TX_ARDQ4_DLY_B1) |
            P_Fld(0x0c, SHU_R0_B1_TXDLY1_TX_ARDQ5_DLY_B1) | P_Fld(0x0c, SHU_R0_B1_TXDLY1_TX_ARDQ6_DLY_B1) |
            P_Fld(0x0c, SHU_R0_B1_TXDLY1_TX_ARDQ7_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY3_0_0                    -     @9275                                                       
      TX_ARDQM0_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[7:0]=8'h0c (Mirror: 8'h00)         
      TX_ARWCK_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[23:16]=8'h00                       
      TX_ARWCKB_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[31:24]=8'h00                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY3, P_Fld(0x0c, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1) |
            P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCK_DLY_B1) | P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCKB_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY0_0_1                    -     @7833                                                       
      TX_ARDQ0_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[7:0]=8'h10 (Mirror: 8'h00)         
      TX_ARDQ1_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[15:8]=8'h10 (Mirror: 8'h00)        
      TX_ARDQ2_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[23:16]=8'h10 (Mirror: 8'h00)       
      TX_ARDQ3_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[31:24]=8'h10 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x10, SHU_R0_B0_TXDLY0_TX_ARDQ0_DLY_B0) |
            P_Fld(0x10, SHU_R0_B0_TXDLY0_TX_ARDQ1_DLY_B0) | P_Fld(0x10, SHU_R0_B0_TXDLY0_TX_ARDQ2_DLY_B0) |
            P_Fld(0x10, SHU_R0_B0_TXDLY0_TX_ARDQ3_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY1_0_1                    -     @7847                                                       
      TX_ARDQ4_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[7:0]=8'h10 (Mirror: 8'h00)         
      TX_ARDQ5_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[15:8]=8'h10 (Mirror: 8'h00)        
      TX_ARDQ6_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[23:16]=8'h10 (Mirror: 8'h00)       
      TX_ARDQ7_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[31:24]=8'h10 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x10, SHU_R0_B0_TXDLY1_TX_ARDQ4_DLY_B0) |
            P_Fld(0x10, SHU_R0_B0_TXDLY1_TX_ARDQ5_DLY_B0) | P_Fld(0x10, SHU_R0_B0_TXDLY1_TX_ARDQ6_DLY_B0) |
            P_Fld(0x10, SHU_R0_B0_TXDLY1_TX_ARDQ7_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY3_0_1                    -     @7874                                                       
      TX_ARDQM0_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[7:0]=8'h10 (Mirror: 8'h00)         
      TX_ARWCK_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[23:16]=8'h00                       
      TX_ARWCKB_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[31:24]=8'h00                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x10, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0) |
            P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCK_DLY_B0) | P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCKB_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY0_0_1                    -     @9240                                                       
      TX_ARDQ0_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[7:0]=8'h20 (Mirror: 8'h00)         
      TX_ARDQ1_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[15:8]=8'h20 (Mirror: 8'h00)        
      TX_ARDQ2_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[23:16]=8'h20 (Mirror: 8'h00)       
      TX_ARDQ3_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[31:24]=8'h20 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x20, SHU_R0_B1_TXDLY0_TX_ARDQ0_DLY_B1) |
            P_Fld(0x20, SHU_R0_B1_TXDLY0_TX_ARDQ1_DLY_B1) | P_Fld(0x20, SHU_R0_B1_TXDLY0_TX_ARDQ2_DLY_B1) |
            P_Fld(0x20, SHU_R0_B1_TXDLY0_TX_ARDQ3_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY1_0_1                    -     @9254                                                       
      TX_ARDQ4_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[7:0]=8'h20 (Mirror: 8'h00)         
      TX_ARDQ5_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[15:8]=8'h20 (Mirror: 8'h00)        
      TX_ARDQ6_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[23:16]=8'h20 (Mirror: 8'h00)       
      TX_ARDQ7_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[31:24]=8'h20 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x20, SHU_R0_B1_TXDLY1_TX_ARDQ4_DLY_B1) |
            P_Fld(0x20, SHU_R0_B1_TXDLY1_TX_ARDQ5_DLY_B1) | P_Fld(0x20, SHU_R0_B1_TXDLY1_TX_ARDQ6_DLY_B1) |
            P_Fld(0x20, SHU_R0_B1_TXDLY1_TX_ARDQ7_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY3_0_1                    -     @9281                                                       
      TX_ARDQM0_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[7:0]=8'h20 (Mirror: 8'h00)         
      TX_ARWCK_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[23:16]=8'h00                       
      TX_ARWCKB_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[31:24]=8'h00                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x20, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1) |
            P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCK_DLY_B1) | P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCKB_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_TX_RANKCTL_0                               ral_reg_DRAMC_blk_SHU_TX_RANKCTL_0                         -     @5651                                                       
      TXRANKINCTL_TXDLY                            uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[3:0]=4'h1 (Mirror: 4'h0)               
      TXRANKINCTL                                  uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[7:4]=4'h1 (Mirror: 4'h0)               
      TXRANKINCTL_ROOT                             uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[11:8]=4'h0                             
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_TX_RANKCTL, P_Fld(0x1, SHU_TX_RANKCTL_TXRANKINCTL_TXDLY) |
            P_Fld(0x1, SHU_TX_RANKCTL_TXRANKINCTL) | P_Fld(0x0, SHU_TX_RANKCTL_TXRANKINCTL_ROOT));
    #endif
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Exit:
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Enter:
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING0_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING0_0                       -     @5538                                                       
      ACDERATEEN                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[0:0]=1'h1 (Mirror: 1'h0)             
      TRRD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[18:16]=3'h2 (Mirror: 3'h0)           
      TRCD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[27:24]=4'h4 (Mirror: 4'h0)           
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !(CODE_SIZE_REDUCE && AC_TIMING_DERATE_ENABLE)
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING0, P_Fld(0x1, SHU_AC_DERATING0_ACDERATEEN) |
            P_Fld(0x2, SHU_AC_DERATING0_TRRD_DERATE) | P_Fld(0x4, SHU_AC_DERATING0_TRCD_DERATE));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING1_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING1_0                       -     @5544                                                       
      TRPAB_DERATE                                 uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[3:0]=4'h3 (Mirror: 4'h0)             
      TRP_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[11:8]=4'h2 (Mirror: 4'h0)            
      TRAS_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[21:16]=6'h01 (Mirror: 6'h00)         
      TRC_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[28:24]=5'h00                         
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING1, P_Fld(0x3, SHU_AC_DERATING1_TRPAB_DERATE) |
            P_Fld(0x2, SHU_AC_DERATING1_TRP_DERATE) | P_Fld(0x01, SHU_AC_DERATING1_TRAS_DERATE) |
            P_Fld(0x00, SHU_AC_DERATING1_TRC_DERATE));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SREF_CTRL_0                                ral_reg_DRAMC_blk_SHU_SREF_CTRL_0                          -     @5322                                                       
      CKEHCMD                                      uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[5:4]=2'h3                               
      SREF_CK_DLY                                  uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[29:28]=2'h3 (Mirror: 2'h0)              
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SREF_CTRL, P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD) |
            P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_HMR4_DVFS_CTRL0_0                          ral_reg_DRAMC_blk_SHU_HMR4_DVFS_CTRL0_0                    -     @5341                                                       
      FSPCHG_PRDCNT                                uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[15:8]=8'h32 (Mirror: 8'h00)       
      REFRCNT                                      uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[27:16]=12'h000                    
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_HMR4_DVFS_CTRL0, P_Fld(0x32, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT) |
            P_Fld(0x000, SHU_HMR4_DVFS_CTRL0_REFRCNT));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM_XRT_0                                ral_reg_DRAMC_blk_SHU_ACTIM_XRT_0                          -     @5497                                                       
      XRTR2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[4:0]=5'h05 (Mirror: 5'h01)              
      XRTR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[13:8]=6'h0a (Mirror: 6'h01)             
      XRTW2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[19:16]=4'h6 (Mirror: 4'h1)              
      XRTW2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[28:24]=5'h09 (Mirror: 5'h01)            
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM_XRT, P_Fld(0x05, SHU_ACTIM_XRT_XRTR2R) |
            P_Fld(0x0a, SHU_ACTIM_XRT_XRTR2W) | P_Fld(0x6, SHU_ACTIM_XRT_XRTW2R) |
            P_Fld(0x09, SHU_ACTIM_XRT_XRTW2W));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM0_0                                   ral_reg_DRAMC_blk_SHU_ACTIM0_0                             -     @5443                                                       
      TWTR                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[5:0]=6'h0a (Mirror: 6'h01)                 
      TWR                                          uvm_reg_field                                              ...    RW SHU_ACTIM0_0[15:8]=8'h0c (Mirror: 8'h06)                
      TRRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[18:16]=3'h1 (Mirror: 3'h0)                 
      TRCD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[27:24]=4'h4 (Mirror: 4'h2)                 
      CKELCKCNT                                    uvm_reg_field                                              ...    RW SHU_ACTIM0_0[31:28]=4'h3 (Mirror: 4'h0)                 
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM0, P_Fld(0x0a, SHU_ACTIM0_TWTR) |
            P_Fld(0x0c, SHU_ACTIM0_TWR) | P_Fld(0x1, SHU_ACTIM0_TRRD) |
            P_Fld(0x4, SHU_ACTIM0_TRCD) | P_Fld(0x3, SHU_ACTIM0_CKELCKCNT));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM1_0                                   ral_reg_DRAMC_blk_SHU_ACTIM1_0                             -     @5451                                                       
      TRPAB                                        uvm_reg_field                                              ...    RW SHU_ACTIM1_0[3:0]=4'h3 (Mirror: 4'ha)                   
      TMRWCKEL                                     uvm_reg_field                                              ...    RW SHU_ACTIM1_0[7:4]=4'h7 (Mirror: 4'h8)                   
      TRP                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[11:8]=4'h2                                 
      TRAS                                         uvm_reg_field                                              ...    RW SHU_ACTIM1_0[21:16]=6'h01 (Mirror: 6'h04)               
      TRC                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[28:24]=5'h00 (Mirror: 5'h05)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM1, P_Fld(0x3, SHU_ACTIM1_TRPAB) |
            P_Fld(0x7, SHU_ACTIM1_TMRWCKEL) | P_Fld(0x2, SHU_ACTIM1_TRP) |
            P_Fld(0x01, SHU_ACTIM1_TRAS) | P_Fld(0x00, SHU_ACTIM1_TRC));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM2_0                                   ral_reg_DRAMC_blk_SHU_ACTIM2_0                             -     @5459                                                       
      TXP                                          uvm_reg_field                                              ...    RW SHU_ACTIM2_0[3:0]=4'h0                                  
      TMRRI                                        uvm_reg_field                                              ...    RW SHU_ACTIM2_0[8:4]=5'h07 (Mirror: 5'h0e)                 
      TRTP                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[14:12]=3'h3 (Mirror: 3'h0)                 
      TR2W                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[21:16]=6'h0a (Mirror: 6'h00)               
      TFAW                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[28:24]=5'h00 (Mirror: 5'h05)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM2, P_Fld(0x0, SHU_ACTIM2_TXP) |
            P_Fld(0x07, SHU_ACTIM2_TMRRI) | P_Fld(0x3, SHU_ACTIM2_TRTP) |
            P_Fld(0x0a, SHU_ACTIM2_TR2W) | P_Fld(0x00, SHU_ACTIM2_TFAW));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM3_0                                   ral_reg_DRAMC_blk_SHU_ACTIM3_0                             -     @5467                                                       
      TRFCPB                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[7:0]=8'h1a (Mirror: 8'h00)                 
      MANTMRR                                      uvm_reg_field                                              ...    RW SHU_ACTIM3_0[11:8]=4'h8 (Mirror: 4'h0)                  
      TR2MRR                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[15:12]=4'h8 (Mirror: 4'h0)                 
      TRFC                                         uvm_reg_field                                              ...    RW SHU_ACTIM3_0[23:16]=8'h40 (Mirror: 8'h00)               
      TWTR_L                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[29:24]=6'h25 (Mirror: 6'h00)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x1a, SHU_ACTIM3_TRFCPB) |
            P_Fld(0x8, SHU_ACTIM3_TR2MRR) | P_Fld(0x40, SHU_ACTIM3_TRFC));
    #endif
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x8, SHU_ACTIM3_MANTMRR) |
            P_Fld(0x25, SHU_ACTIM3_TWTR_L));

    #if !CODE_SIZE_REDUCE
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM4_0                                   ral_reg_DRAMC_blk_SHU_ACTIM4_0                             -     @5475                                                       
      TXREFCNT                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[9:0]=10'h04e (Mirror: 10'h028)             
      TMRR2MRW                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[15:10]=6'h0f (Mirror: 6'h00)               
      TMRR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM4_0[21:16]=6'h0c (Mirror: 6'h00)               
      TZQCS                                        uvm_reg_field                                              ...    RW SHU_ACTIM4_0[31:24]=8'h10 (Mirror: 8'h00)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM4, P_Fld(0x04e, SHU_ACTIM4_TXREFCNT) |
            P_Fld(0x0f, SHU_ACTIM4_TMRR2MRW) | P_Fld(0x0c, SHU_ACTIM4_TMRR2W) |
            P_Fld(0x10, SHU_ACTIM4_TZQCS));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM5_0                                   ral_reg_DRAMC_blk_SHU_ACTIM5_0                             -     @5482                                                       
      TR2PD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[6:0]=7'h10 (Mirror: 7'h00)                 
      TWTPD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[14:8]=7'h0f (Mirror: 7'h00)                
      TPBR2PBR                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[23:16]=8'h15 (Mirror: 8'h00)               
      TPBR2ACT                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[29:28]=2'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM5, P_Fld(0x10, SHU_ACTIM5_TR2PD) |
            P_Fld(0x0f, SHU_ACTIM5_TWTPD) | P_Fld(0x15, SHU_ACTIM5_TPBR2PBR) |
            P_Fld(0x0, SHU_ACTIM5_TPBR2ACT));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM6_0                                   ral_reg_DRAMC_blk_SHU_ACTIM6_0                             -     @5489                                                       
      TZQLAT2                                      uvm_reg_field                                              ...    RW SHU_ACTIM6_0[4:0]=5'h06 (Mirror: 5'h1f)                 
      TMRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[11:8]=4'h6 (Mirror: 4'h0)                  
      TMRW                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[15:12]=4'h5 (Mirror: 4'h0)                 
      TW2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[25:20]=6'h0d (Mirror: 6'h00)               
      TR2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[31:26]=6'h11 (Mirror: 6'h13)               
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM6, P_Fld(0x06, SHU_ACTIM6_TZQLAT2) |
            P_Fld(0x6, SHU_ACTIM6_TMRD) | P_Fld(0x5, SHU_ACTIM6_TMRW) |
            P_Fld(0x0d, SHU_ACTIM6_TW2MRW) | P_Fld(0x11, SHU_ACTIM6_TR2MRW));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_CKECTRL_0                                  ral_reg_DRAMC_blk_SHU_CKECTRL_0                            -     @5567                                                       
      TPDE_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[0:0]=1'h0                                 
      TPDX_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[1:1]=1'h0                                 
      TPDE                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[14:12]=3'h3 (Mirror: 3'h1)                
      TPDX                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[18:16]=3'h3 (Mirror: 3'h1)                
      TCKEPRD                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[22:20]=3'h2                               
      TCKESRX                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[25:24]=2'h3 (Mirror: 2'h0)                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_CKECTRL, P_Fld(0x0, SHU_CKECTRL_TPDE_05T) |
            P_Fld(0x0, SHU_CKECTRL_TPDX_05T) | P_Fld(0x3, SHU_CKECTRL_TPDE) |
            P_Fld(0x3, SHU_CKECTRL_TPDX) | P_Fld(0x2, SHU_CKECTRL_TCKEPRD));
    #endif

    vIO32WriteFldAlign(DRAMC_REG_SHU_CKECTRL, 0x3, SHU_CKECTRL_TCKESRX);
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_0                                     ral_reg_DRAMC_blk_SHU_MISC_0                               -     @5671                                                       
      REQQUE_MAXCNT                                uvm_reg_field                                              ...    RW SHU_MISC_0[3:0]=4'h2                                    
      DCMDLYREF                                    uvm_reg_field                                              ...    RW SHU_MISC_0[18:16]=3'h7 (Mirror: 3'h4)                   
      DAREFEN                                      uvm_reg_field                                              ...    RW SHU_MISC_0[30:30]=1'h0                                  
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_MISC, P_Fld(0x7, SHU_MISC_DCMDLYREF) |
    P_Fld(0x0, SHU_MISC_DAREFEN));

	#if !CODE_SIZE_REDUCE
    vIO32WriteFldAlign(DRAMC_REG_SHU_MISC, 0x2, SHU_MISC_REQQUE_MAXCNT);
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Exit
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Enter.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Exit.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ8_0                            -     @8226                                                       
      R_DMRXDVS_UPD_FORCE_CYC_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[14:0]=15'h0031 (Mirror: 15'h0000)          
      R_DMRXDVS_UPD_FORCE_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[15:15]=1'h0                                
      R_DMRANK_RXDLY_PIPE_CG_IG_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[19:19]=1'h0                                
      R_RMRODTEN_CG_IG_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[20:20]=1'h0                                
      R_RMRX_TOPHY_CG_IG_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                 
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[22:22]=1'h0                                
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0            uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[23:23]=1'h0                                
      R_DMRXDLY_CG_IG_B0                           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                 
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[26:26]=1'h0                                
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[27:27]=1'h0                                
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0               uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[28:28]=1'h0                                
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[29:29]=1'h0                                
      R_DMRANK_PIPE_CG_IG_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[30:30]=1'h0                                
      R_DMRANK_CHG_PIPE_CG_IG_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[31:31]=1'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) | P_Fld(0x1, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
            P_Fld(0x1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0));
    #endif
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0031, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_EN_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ8_0                            -     @9633                                                       
      R_DMRXDVS_UPD_FORCE_CYC_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[14:0]=15'h0031 (Mirror: 15'h0000)          
      R_DMRXDVS_UPD_FORCE_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[15:15]=1'h0                                
      R_DMRANK_RXDLY_PIPE_CG_IG_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[19:19]=1'h0                                
      R_RMRODTEN_CG_IG_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[20:20]=1'h0                                
      R_RMRX_TOPHY_CG_IG_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                 
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[22:22]=1'h0                                
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1            uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[23:23]=1'h0                                
      R_DMRXDLY_CG_IG_B1                           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                 
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[26:26]=1'h0                                
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[27:27]=1'h0                                
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1               uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[28:28]=1'h0                                
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[29:29]=1'h0                                
      R_DMRANK_PIPE_CG_IG_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[30:30]=1'h0                                
      R_DMRANK_CHG_PIPE_CG_IG_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[31:31]=1'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0031, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_EN_B1));

	#if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) | P_Fld(0x1, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1) |
            P_Fld(0x1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ5_0                            -     @8126                                                       
      RG_RX_ARDQ_VREF_SEL_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[5:0]=6'h0e                                 
      RG_RX_ARDQ_VREF_BYPASS_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[6:6]=1'h0                                  
      RG_ARPI_FB_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[13:8]=6'h00                                
      RG_RX_ARDQS0_DQSIEN_DLY_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[18:16]=3'h0                                
      RG_RX_ARDQS_DQSIEN_RB_DLY_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[19:19]=1'h0                                
      RG_RX_ARDQS0_DVS_DLY_B0                      uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[23:20]=4'h7 (Mirror: 4'h0)                 
      RG_RX_ARDQ_FIFO_DQSI_DLY_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[31:29]=3'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ5, P_Fld(0x0e, SHU_B0_DQ5_RG_RX_ARDQ_VREF_SEL_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_VREF_BYPASS_B0) | P_Fld(0x00, SHU_B0_DQ5_RG_ARPI_FB_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B0) |
            P_Fld(0x7, SHU_B0_DQ5_RG_RX_ARDQS0_DVS_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ5_0                            -     @9533                                                       
      RG_RX_ARDQ_VREF_SEL_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[5:0]=6'h0e                                 
      RG_RX_ARDQ_VREF_BYPASS_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[6:6]=1'h0                                  
      RG_ARPI_FB_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[13:8]=6'h00                                
      RG_RX_ARDQS0_DQSIEN_DLY_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[18:16]=3'h0                                
      RG_RX_ARDQS_DQSIEN_RB_DLY_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[19:19]=1'h0                                
      RG_RX_ARDQS0_DVS_DLY_B1                      uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[23:20]=4'h7 (Mirror: 4'h0)                 
      RG_RX_ARDQ_FIFO_DQSI_DLY_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[31:29]=3'h0                                
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ5, P_Fld(0x0e, SHU_B1_DQ5_RG_RX_ARDQ_VREF_SEL_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_VREF_BYPASS_B1) | P_Fld(0x00, SHU_B1_DQ5_RG_ARPI_FB_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B1) |
            P_Fld(0x7, SHU_B1_DQ5_RG_RX_ARDQS0_DVS_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_0                    -     @7888                                                       
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x75, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x75, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_0                    -     @7902                                                       
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1, P_Fld(0x75, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x75, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_0                    -     @7916                                                       
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2, P_Fld(0x75, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x75, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_0                    -     @7930                                                       
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3, P_Fld(0x75, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x75, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_0                    -     @7944                                                       
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[15:8]=8'h75 (Mirror: 8'h00)        
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4, P_Fld(0x75, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0x75, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_0                    -     @7954                                                       
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[8:0]=9'h17e (Mirror: 9'h000)       
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[24:16]=9'h17e (Mirror: 9'h000)     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5, P_Fld(0x17e, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x17e, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_1                    -     @7895                                                       
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_1                    -     @7909                                                       
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x74, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_1                    -     @7923                                                       
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x74, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_1                    -     @7937                                                       
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x74, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_1                    -     @7949                                                       
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[15:8]=8'h74 (Mirror: 8'h00)        
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0x74, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_1                    -     @7959                                                       
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[8:0]=9'h17d (Mirror: 9'h000)       
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[24:16]=9'h17d (Mirror: 9'h000)     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x17d, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x17d, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_0                    -     @9295                                                       
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x75, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x75, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_0                    -     @9309                                                       
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1, P_Fld(0x75, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x75, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_0                    -     @9323                                                       
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2, P_Fld(0x75, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x75, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_0                    -     @9337                                                       
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[15:8]=8'h75 (Mirror: 8'h00)        
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[23:16]=8'h75 (Mirror: 8'h00)       
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[31:24]=8'h75 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3, P_Fld(0x75, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x75, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_0                    -     @9351                                                       
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[7:0]=8'h75 (Mirror: 8'h00)         
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[15:8]=8'h75 (Mirror: 8'h00)        
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4, P_Fld(0x75, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x75, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_0                    -     @9361                                                       
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[8:0]=9'h17e (Mirror: 9'h000)       
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[24:16]=9'h17e (Mirror: 9'h000)     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5, P_Fld(0x17e, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x17e, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_1                    -     @9302                                                       
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_1                    -     @9316                                                       
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x74, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_1                    -     @9330                                                       
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x74, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_1                    -     @9344                                                       
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[15:8]=8'h74 (Mirror: 8'h00)        
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[23:16]=8'h74 (Mirror: 8'h00)       
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[31:24]=8'h74 (Mirror: 8'h00)       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x74, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_1                    -     @9356                                                       
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[7:0]=8'h74 (Mirror: 8'h00)         
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[15:8]=8'h74 (Mirror: 8'h00)        
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x74, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x74, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_1                    -     @9366                                                       
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[8:0]=9'h17d (Mirror: 9'h000)       
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[24:16]=9'h17d (Mirror: 9'h000)     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x17d, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x17d, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ9                                         ral_reg_DDRPHY_blk_B0_DQ9                                  -     @7782                                                       
      RG_RX_ARDQ_STBEN_RESETB_B0                   uvm_reg_field                                              ...    RW B0_DQ9[0:0]=1'h1 (Mirror: 1'h0)                         
      RG_RX_ARDQS0_STBEN_RESETB_B0                 uvm_reg_field                                              ...    RW B0_DQ9[4:4]=1'h0                                        
      RG_RX_ARDQS0_DQSIENMODE_B0                   uvm_reg_field                                              ...    RW B0_DQ9[5:5]=1'h0                                        
      R_DMRXDVS_R_F_DLY_RK_OPT_B0                  uvm_reg_field                                              ...    RW B0_DQ9[6:6]=1'h1                                        
      R_DMRXFIFO_STBENCMP_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ9[7:7]=1'h0                                        
      R_IN_GATE_EN_LOW_OPT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[15:8]=8'h00                                      
      R_DMDQSIEN_VALID_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[18:16]=3'h0                                      
      R_DMDQSIEN_RDSEL_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[22:20]=3'h0                                      
      R_DMRXDVS_VALID_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[26:24]=3'h0                                      
      R_DMRXDVS_RDSEL_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[30:28]=3'h0                                      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ9, P_Fld(0x1, B0_DQ9_RG_RX_ARDQ_STBEN_RESETB_B0) |
            P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_DQSIENMODE_B0) |
            P_Fld(0x1, B0_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXFIFO_STBENCMP_EN_B0) |
            P_Fld(0x00, B0_DQ9_R_IN_GATE_EN_LOW_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMDQSIEN_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMDQSIEN_RDSEL_LAT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXDVS_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMRXDVS_RDSEL_LAT_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ9                                         ral_reg_DDRPHY_blk_B1_DQ9                                  -     @9189                                                       
      RG_RX_ARDQ_STBEN_RESETB_B1                   uvm_reg_field                                              ...    RW B1_DQ9[0:0]=1'h1 (Mirror: 1'h0)                         
      RG_RX_ARDQS0_STBEN_RESETB_B1                 uvm_reg_field                                              ...    RW B1_DQ9[4:4]=1'h0                                        
      RG_RX_ARDQS0_DQSIENMODE_B1                   uvm_reg_field                                              ...    RW B1_DQ9[5:5]=1'h0                                        
      R_DMRXDVS_R_F_DLY_RK_OPT_B1                  uvm_reg_field                                              ...    RW B1_DQ9[6:6]=1'h1                                        
      R_DMRXFIFO_STBENCMP_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ9[7:7]=1'h0                                        
      R_IN_GATE_EN_LOW_OPT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[15:8]=8'h00                                      
      R_DMDQSIEN_VALID_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[18:16]=3'h0                                      
      R_DMDQSIEN_RDSEL_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[22:20]=3'h0                                      
      R_DMRXDVS_VALID_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[26:24]=3'h0                                      
      R_DMRXDVS_RDSEL_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[30:28]=3'h0                                      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ9, P_Fld(0x1, B1_DQ9_RG_RX_ARDQ_STBEN_RESETB_B1) |
            P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_DQSIENMODE_B1) |
            P_Fld(0x1, B1_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXFIFO_STBENCMP_EN_B1) |
            P_Fld(0x00, B1_DQ9_R_IN_GATE_EN_LOW_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMDQSIEN_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMDQSIEN_RDSEL_LAT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXDVS_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMRXDVS_RDSEL_LAT_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ4                                         ral_reg_DDRPHY_blk_B0_DQ4                                  -     @7711                                                       
      RG_RX_ARDQS_EYE_R_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[6:0]=7'h03 (Mirror: 7'h00)                       
      RG_RX_ARDQS_EYE_F_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[14:8]=7'h03 (Mirror: 7'h00)                      
      RG_RX_ARDQ_EYE_R_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[21:16]=6'h35 (Mirror: 6'h00)                     
      RG_RX_ARDQ_EYE_F_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[29:24]=6'h35 (Mirror: 6'h00)                     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ4, P_Fld(0x03, B0_DQ4_RG_RX_ARDQS_EYE_R_DLY_B0) |
            P_Fld(0x03, B0_DQ4_RG_RX_ARDQS_EYE_F_DLY_B0) | P_Fld(0x35, B0_DQ4_RG_RX_ARDQ_EYE_R_DLY_B0) |
            P_Fld(0x35, B0_DQ4_RG_RX_ARDQ_EYE_F_DLY_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ4                                         ral_reg_DDRPHY_blk_B1_DQ4                                  -     @9118                                                       
      RG_RX_ARDQS_EYE_R_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[6:0]=7'h03 (Mirror: 7'h00)                       
      RG_RX_ARDQS_EYE_F_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[14:8]=7'h03 (Mirror: 7'h00)                      
      RG_RX_ARDQ_EYE_R_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[21:16]=6'h35 (Mirror: 6'h00)                     
      RG_RX_ARDQ_EYE_F_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[29:24]=6'h35 (Mirror: 6'h00)                     
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ4, P_Fld(0x03, B1_DQ4_RG_RX_ARDQS_EYE_R_DLY_B1) |
            P_Fld(0x03, B1_DQ4_RG_RX_ARDQS_EYE_F_DLY_B1) | P_Fld(0x35, B1_DQ4_RG_RX_ARDQ_EYE_R_DLY_B1) |
            P_Fld(0x35, B1_DQ4_RG_RX_ARDQ_EYE_F_DLY_B1));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ5                                         ral_reg_DDRPHY_blk_B0_DQ5                                  -     @7718                                                       
      RG_RX_ARDQ_EYE_VREF_SEL_B0                   uvm_reg_field                                              ...    RW B0_DQ5[13:8]=6'h0e                                      
      RG_RX_ARDQ_VREF_EN_B0                        uvm_reg_field                                              ...    RW B0_DQ5[16:16]=1'h0                                      
      RG_RX_ARDQ_EYE_VREF_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ5[17:17]=1'h0                                      
      RG_RX_ARDQ_EYE_SEL_B0                        uvm_reg_field                                              ...    RW B0_DQ5[23:20]=4'h0                                      
      RG_RX_ARDQ_EYE_EN_B0                         uvm_reg_field                                              ...    RW B0_DQ5[24:24]=1'h0                                      
      RG_RX_ARDQ_EYE_STBEN_RESETB_B0               uvm_reg_field                                              ...    RW B0_DQ5[25:25]=1'h1 (Mirror: 1'h0)                       
      RG_RX_ARDQS0_DVS_EN_B0                       uvm_reg_field                                              ...    RW B0_DQ5[31:31]=1'h0                                      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ5, P_Fld(0x0e, B0_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B0) |
            P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B0) |
            P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_SEL_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_EN_B0) |
            P_Fld(0x1, B0_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQS0_DVS_EN_B0));
    /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                       
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ5                                         ral_reg_DDRPHY_blk_B1_DQ5                                  -     @9125                                                       
      RG_RX_ARDQ_EYE_VREF_SEL_B1                   uvm_reg_field                                              ...    RW B1_DQ5[13:8]=6'h0e                                      
      RG_RX_ARDQ_VREF_EN_B1                        uvm_reg_field                                              ...    RW B1_DQ5[16:16]=1'h0                                      
      RG_RX_ARDQ_EYE_VREF_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ5[17:17]=1'h0                                      
      RG_RX_ARDQ_EYE_SEL_B1                        uvm_reg_field                                              ...    RW B1_DQ5[23:20]=4'h0                                      
      RG_RX_ARDQ_EYE_EN_B1                         uvm_reg_field                                              ...    RW B1_DQ5[24:24]=1'h0                                      
      RG_RX_ARDQ_EYE_STBEN_RESETB_B1               uvm_reg_field                                              ...    RW B1_DQ5[25:25]=1'h1 (Mirror: 1'h0)                       
      RG_RX_ARDQS0_DVS_EN_B1                       uvm_reg_field                                              ...    RW B1_DQ5[31:31]=1'h0                                      
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ5, P_Fld(0x0e, B1_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B1) |
            P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B1) |
            P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_SEL_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_EN_B1) |
            P_Fld(0x1, B1_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQS0_DVS_EN_B1));
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set EXIT
    //    Exit body
}


void sv_algorithm_assistance_LP4_3733(DRAMC_CTX_T *p)
{
    //    Enter body
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Enter:
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RDSEL_TRACK_0                         ral_reg_DDRPHY_blk_SHU_MISC_RDSEL_TRACK_0                  -     @13206                                                     
      DMDATLAT_i                                   uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[4:0]=5'h0f (Mirror: 5'h00)      
      RDSEL_HWSAVE_MSK                             uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[6:6]=1'h1 (Mirror: 1'h0)        
      RDSEL_TRACK_EN                               uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[7:7]=1'h0                       
      SHU_GW_THRD_NEG                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[19:8]=12'hfd0 (Mirror: 12'h000) 
      SHU_GW_THRD_POS                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[31:20]=12'h030 (Mirror: 12'h000)
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, P_Fld(0x0f, SHU_MISC_RDSEL_TRACK_DMDATLAT_I) |
            P_Fld(0x1, SHU_MISC_RDSEL_TRACK_RDSEL_HWSAVE_MSK) | P_Fld(0x0, SHU_MISC_RDSEL_TRACK_RDSEL_TRACK_EN) |
            P_Fld(0xfd0, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_NEG) | P_Fld(0x030, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_POS));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RDAT_0                                ral_reg_DDRPHY_blk_MISC_SHU_RDAT_0                         -     @13076                                                     
      DATLAT                                       uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[4:0]=5'h0f (Mirror: 5'h00)             
      DATLAT_DSEL                                  uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[12:8]=5'h0f (Mirror: 5'h00)            
      DATLAT_DSEL_PHY                              uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[20:16]=5'h0f (Mirror: 5'h00)           
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RDAT, P_Fld(0x0f, MISC_SHU_RDAT_DATLAT) |
            P_Fld(0x0f, MISC_SHU_RDAT_DATLAT_DSEL) | P_Fld(0x0f, MISC_SHU_RDAT_DATLAT_DSEL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_PHY_RX_CTRL_0                         ral_reg_DDRPHY_blk_MISC_SHU_PHY_RX_CTRL_0                  -     @13012                                                     
      RANK_RXDLY_UPDLAT_EN                         uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[8:8]=1'h1 (Mirror: 1'h0)        
      RANK_RXDLY_UPD_OFFSET                        uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[11:9]=3'h2 (Mirror: 3'h0)       
      RX_IN_GATE_EN_PRE_OFFSET                     uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[15:14]=2'h2 (Mirror: 2'h0)      
      RX_IN_GATE_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[18:16]=3'h1 (Mirror: 3'h0)      
      RX_IN_GATE_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[22:20]=3'h1 (Mirror: 3'h0)      
      RX_IN_BUFF_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[26:24]=3'h2 (Mirror: 3'h0)      
      RX_IN_BUFF_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[30:28]=3'h0                     
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL, P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPDLAT_EN) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPD_OFFSET) | P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD) | P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) | P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_TAIL));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANKCTL_0                             ral_reg_DDRPHY_blk_MISC_SHU_RANKCTL_0                      -     @13002                                                     
      RANKINCTL_RXDLY                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[3:0]=4'h4 (Mirror: 4'h0)            
      RANK_RXDLY_OPT                               uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[4:4]=1'h1                           
      RANKSEL_SELPH_FRUN                           uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[15:15]=1'h1 (Mirror: 1'h0)          
      RANKINCTL_STB                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[19:16]=4'h6 (Mirror: 4'h0)          
      RANKINCTL                                    uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[23:20]=4'h5 (Mirror: 4'h0)          
      RANKINCTL_ROOT1                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[27:24]=4'h5 (Mirror: 4'h0)          
      RANKINCTL_PHY                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[31:28]=4'h8 (Mirror: 4'h0)          
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x4, MISC_SHU_RANKCTL_RANKINCTL_RXDLY) |
            P_Fld(0x1, MISC_SHU_RANKCTL_RANK_RXDLY_OPT) | P_Fld(0x1, MISC_SHU_RANKCTL_RANKSEL_SELPH_FRUN) |
            P_Fld(0x6, MISC_SHU_RANKCTL_RANKINCTL_STB));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x5, MISC_SHU_RANKCTL_RANKINCTL) |
            P_Fld(0x5, MISC_SHU_RANKCTL_RANKINCTL_ROOT1) | P_Fld(0x8, MISC_SHU_RANKCTL_RANKINCTL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANK_SEL_LAT_0                        ral_reg_DDRPHY_blk_MISC_SHU_RANK_SEL_LAT_0                 -     @13229                                                     
      RANK_SEL_LAT_B0                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[3:0]=4'h2 (Mirror: 4'h0)       
      RANK_SEL_LAT_B1                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[7:4]=4'h2 (Mirror: 4'h0)       
      RANK_SEL_LAT_CA                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[11:8]=4'h2 (Mirror: 4'h0)      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANK_SEL_LAT, P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B0) |
            P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B1) | P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_CA));

    #if !CODE_SIZE_REDUCE
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_0                  -     @12823                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_0[3:0]=4'h7 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL, 0x7, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_1                  -     @12827                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_1[3:0]=4'h7 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL+(1*DDRPHY_AO_RANK_OFFSET), 0x7, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0         -     @8022                                                         
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h0                 
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h4 (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY, P_Fld(0x0, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0x4, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_0             -     @8036                                                         
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_0[6:0]=7'h0f (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY, 0x0f, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1         -     @8029                                                         
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h7 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'hb (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0xb, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_1             -     @8040                                                         
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_1[6:0]=7'h1c (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x1c, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0         -     @9429                                                         
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h0                 
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h4 (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY, P_Fld(0x0, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0x4, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_0             -     @9443                                                         
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_0[6:0]=7'h0f (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY, 0x0f, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1         -     @9436                                                         
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h7 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'hb (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x7, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0xb, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_1             -     @9447                                                         
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_1[6:0]=7'h1c (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x1c, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_ODTCTRL_0                             ral_reg_DDRPHY_blk_MISC_SHU_ODTCTRL_0                      -     @13022                                                        
      RODTEN                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[0:0]=1'h1 (Mirror: 1'h0)               
      RODTENSTB_SELPH_CG_IG                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[1:1]=1'h0                              
      RODT_LAT                                     uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[7:4]=4'h7 (Mirror: 4'h0)               
      RODTEN_SELPH_FRUN                            uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[15:15]=1'h0                            
      RODTDLY_LAT_OPT                              uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[25:24]=2'h0                            
      FIXRODT                                      uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[27:27]=1'h0                            
      RODTEN_OPT                                   uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[29:29]=1'h1                            
      RODTE2                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[30:30]=1'h1 (Mirror: 1'h0)             
      RODTE                                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[31:31]=1'h1 (Mirror: 1'h0)             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_ODTCTRL, P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTEN_SELPH_FRUN) | P_Fld(0x0, MISC_SHU_ODTCTRL_RODTDLY_LAT_OPT) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_FIXRODT) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN_OPT) |
            P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE2) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE));
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, 0x7, MISC_SHU_ODTCTRL_RODT_LAT);
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ7_0                            -     @8206                                                         
      R_DMRANKRXDVS_B0                             uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[3:0]=4'h0                                    
      R_DMDQMDBI_EYE_SHU_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[6:6]=1'h0                                    
      R_DMDQMDBI_SHU_B0                            uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[7:7]=1'h0                                    
      R_DMRXDVS_DQM_FLAGSEL_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[11:8]=4'h0                                   
      R_DMRXDVS_PBYTE_FLAG_OPT_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[12:12]=1'h0                                  
      R_DMRXDVS_PBYTE_DQM_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[13:13]=1'h0                                  
      R_DMRXTRACK_DQM_EN_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[14:14]=1'h0                                  
      R_DMRODTEN_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
      R_DMARPI_CG_FB2DLL_DCM_EN_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[16:16]=1'h0                                  
      R_DMTX_ARPI_CG_DQ_NEW_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[17:17]=1'h0                                  
      R_DMTX_ARPI_CG_DQS_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[18:18]=1'h0                                  
      R_DMTX_ARPI_CG_DQM_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[19:19]=1'h0                                  
      R_LP4Y_SDN_MODE_DQS0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[20:20]=1'h0                                  
      R_DMRXRANK_DQ_EN_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQ_LAT_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                   
      R_DMRXRANK_DQS_EN_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQS_LAT_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[31:29]=3'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRANKRXDVS_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_EYE_SHU_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_SHU_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXTRACK_DQM_EN_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRODTEN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_LP4Y_SDN_MODE_DQS0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_EN_B0) | P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_LAT_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQS_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXRANK_DQS_LAT_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ7_0                            -     @9613                                                         
      R_DMRANKRXDVS_B1                             uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[3:0]=4'h0                                    
      R_DMDQMDBI_EYE_SHU_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[6:6]=1'h0                                    
      R_DMDQMDBI_SHU_B1                            uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[7:7]=1'h0                                    
      R_DMRXDVS_DQM_FLAGSEL_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[11:8]=4'h0                                   
      R_DMRXDVS_PBYTE_FLAG_OPT_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[12:12]=1'h0                                  
      R_DMRXDVS_PBYTE_DQM_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[13:13]=1'h0                                  
      R_DMRXTRACK_DQM_EN_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[14:14]=1'h0                                  
      R_DMRODTEN_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
      R_DMARPI_CG_FB2DLL_DCM_EN_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[16:16]=1'h0                                  
      R_DMTX_ARPI_CG_DQ_NEW_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[17:17]=1'h0                                  
      R_DMTX_ARPI_CG_DQS_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[18:18]=1'h0                                  
      R_DMTX_ARPI_CG_DQM_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[19:19]=1'h0                                  
      R_LP4Y_SDN_MODE_DQS1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[20:20]=1'h0                                  
      R_DMRXRANK_DQ_EN_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQ_LAT_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[27:25]=3'h1 (Mirror: 3'h0)                   
      R_DMRXRANK_DQS_EN_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQS_LAT_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[31:29]=3'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRANKRXDVS_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_EYE_SHU_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_SHU_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXTRACK_DQM_EN_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRODTEN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_LP4Y_SDN_MODE_DQS1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_EN_B1) | P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_LAT_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQS_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXRANK_DQS_LAT_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RX_PIPE_CTRL_0                        ral_reg_DDRPHY_blk_SHU_MISC_RX_PIPE_CTRL_0                 -     @13176                                                        
      RX_PIPE_BYPASS_EN                            uvm_reg_field                                              ...    RW SHU_MISC_RX_PIPE_CTRL_0[0:0]=1'h1 (Mirror: 1'h0)          
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_MISC_RX_PIPE_CTRL, 0x1, SHU_MISC_RX_PIPE_CTRL_RX_PIPE_BYPASS_EN);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0         -     @8044                                                         
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h3 (Mirror: 3'h0)  
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h3 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY, P_Fld(0x3, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x3, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1         -     @8051                                                         
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h2 (Mirror: 3'h0)  
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h2 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x2, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0         -     @9451                                                         
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h3 (Mirror: 3'h0)  
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h3 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY, P_Fld(0x3, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x3, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1         -     @9458                                                         
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h2 (Mirror: 3'h0)  
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h2 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x2, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RX_CG_SET0_0                               ral_reg_DRAMC_blk_SHU_RX_CG_SET0_0                         -     @5628                                                         
      DLE_LAST_EXTEND3                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[0:0]=1'h0                                
      READ_START_EXTEND3                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[1:1]=1'h0                                
      DLE_LAST_EXTEND2                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[2:2]=1'h1 (Mirror: 1'h0)                 
      READ_START_EXTEND2                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[3:3]=1'h1 (Mirror: 1'h0)                 
      DLE_LAST_EXTEND1                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[4:4]=1'h1 (Mirror: 1'h0)                 
      READ_START_EXTEND1                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[5:5]=1'h1 (Mirror: 1'h0)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_RX_CG_SET0, P_Fld(0x0, SHU_RX_CG_SET0_DLE_LAST_EXTEND3) |
            P_Fld(0x0, SHU_RX_CG_SET0_READ_START_EXTEND3) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND2) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND2) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND1) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RANK_SEL_STB_0                        ral_reg_DDRPHY_blk_SHU_MISC_RANK_SEL_STB_0                 -     @13192                                                        
      RANK_SEL_STB_EN                              uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[0:0]=1'h1 (Mirror: 1'h0)          
      RANK_SEL_STB_EN_B23                          uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[1:1]=1'h0                         
      RANK_SEL_STB_SERMODE                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[3:2]=2'h0                         
      RANK_SEL_STB_TRACK                           uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[4:4]=1'h1 (Mirror: 1'h0)          
      RANK_SEL_RXDLY_TRACK                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[5:5]=1'h0                         
      RANK_SEL_STB_PHASE_EN                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[7:7]=1'h0                         
      RANK_SEL_PHSINCTL                            uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[11:8]=4'h6 (Mirror: 4'h0)         
      RANK_SEL_STB_UI_PLUS                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[19:16]=4'h0                       
      RANK_SEL_STB_MCK_PLUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[23:20]=4'h0                       
      RANK_SEL_STB_UI_MINUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[27:24]=4'h2 (Mirror: 4'h0)        
      RANK_SEL_STB_MCK_MINUS                       uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[31:28]=4'h0                       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN_B23) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_SERMODE) |
            P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_TRACK) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_RXDLY_TRACK) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_PHASE_EN) | P_Fld(0x6, SHU_MISC_RANK_SEL_STB_RANK_SEL_PHSINCTL) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_PLUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_PLUS) |
            P_Fld(0x2, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_MINUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_MINUS));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_0                  -     @12841                                                        
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[6:0]=7'h60 (Mirror: 7'h00)         
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[7:7]=1'h1 (Mirror: 1'h0)           
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[14:8]=7'h3f (Mirror: 7'h00)        
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[15:15]=1'h1 (Mirror: 1'h0)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL, P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_1                  -     @12848                                                        
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[6:0]=7'h60 (Mirror: 7'h00)         
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[7:7]=1'h1 (Mirror: 1'h0)           
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[14:8]=7'h3f (Mirror: 7'h00)        
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[15:15]=1'h1 (Mirror: 1'h0)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_0                  -     @8000                                                         
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[6:0]=7'h0f (Mirror: 7'h00)         
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[15:8]=8'h10 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI, P_Fld(0x0f, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x10, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_0                  -     @9407                                                         
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[6:0]=7'h0f (Mirror: 7'h00)         
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[15:8]=8'h10 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI, P_Fld(0x0f, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x10, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_1                  -     @8005                                                         
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[6:0]=7'h1c (Mirror: 7'h00)         
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[15:8]=8'h17 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1c, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x17, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_1                  -     @9412                                                         
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[6:0]=7'h1c (Mirror: 7'h00)         
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[15:8]=8'h17 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1c, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x17, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_0             -     @8010                                                         
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[6:0]=7'h0f (Mirror: 7'h00)    
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[15:8]=8'h10 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[31:24]=8'h14 (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI, P_Fld(0x0f, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x10, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x14, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_0             -     @9417                                                         
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[6:0]=7'h0f (Mirror: 7'h00)    
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[15:8]=8'h10 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[31:24]=8'h14 (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI, P_Fld(0x0f, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x10, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x14, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_1             -     @8016                                                         
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[6:0]=7'h1c (Mirror: 7'h00)    
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[15:8]=8'h17 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[31:24]=8'h1b (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1c, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x17, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x1b, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_1             -     @9423                                                         
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[6:0]=7'h1c (Mirror: 7'h00)    
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[15:8]=8'h17 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[31:24]=8'h1b (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x1c, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x17, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x1b, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Exit:
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Enter:
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_CA_CMD0_0_0                             ral_reg_DDRPHY_blk_SHU_R0_CA_CMD0_0_0                      -     @10832                                                        
      RG_RX_ARCLK_R_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[2:0]=3'h0                              
      RG_RX_ARCLK_F_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[6:4]=3'h0                              
      RG_ARPI_CS                                   uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[13:8]=6'h00                            
      RG_ARPI_CMD                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[21:16]=6'h20 (Mirror: 6'h00)           
      RG_ARPI_CLK                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[29:24]=6'h00                           
      DA_ARPI_DDR400_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[30:30]=1'h0                            
      DA_RX_ARDQSIEN_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_0[31:31]=1'h0                            
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0, P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_CA_CMD0_DA_ARPI_DDR400_0D5UI_RK0_CA) | P_Fld(0x0, SHU_R0_CA_CMD0_DA_RX_ARDQSIEN_0D5UI_RK0_CA));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0, P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CS) |
            P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) | P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CLK));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_0                       -     @7980                                                         
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[2:0]=3'h0                               
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[6:4]=3'h0                               
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[13:8]=6'h11 (Mirror: 6'h00)             
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[21:16]=6'h11 (Mirror: 6'h00)            
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x11, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x11, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_0                       -     @9387                                                         
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[2:0]=3'h0                               
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[6:4]=3'h0                               
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[13:8]=6'h12 (Mirror: 6'h00)             
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[21:16]=6'h12 (Mirror: 6'h00)            
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x12, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x12, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_CA_CMD0_0_1                             ral_reg_DDRPHY_blk_SHU_R0_CA_CMD0_0_1                      -     @10842                                                        
      RG_RX_ARCLK_R_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[2:0]=3'h0                              
      RG_RX_ARCLK_F_DLY_DUTY                       uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[6:4]=3'h0                              
      RG_ARPI_CS                                   uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[13:8]=6'h00                            
      RG_ARPI_CMD                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[21:16]=6'h20 (Mirror: 6'h00)           
      RG_ARPI_CLK                                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[29:24]=6'h00                           
      DA_ARPI_DDR400_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[30:30]=1'h0                            
      DA_RX_ARDQSIEN_0D5UI_RK0_CA                  uvm_reg_field                                              ...    RW SHU_R0_CA_CMD0_0_1[31:31]=1'h0                            
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_CA_CMD0_RG_RX_ARCLK_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_CA_CMD0_DA_ARPI_DDR400_0D5UI_RK0_CA) | P_Fld(0x0, SHU_R0_CA_CMD0_DA_RX_ARDQSIEN_0D5UI_RK0_CA));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_CA_CMD0+(1*DDRPHY_AO_RANK_OFFSET),P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CS) |
            P_Fld(0x20, SHU_R0_CA_CMD0_RG_ARPI_CMD) | P_Fld(0x00, SHU_R0_CA_CMD0_RG_ARPI_CLK));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_1                       -     @7990                                                         
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[2:0]=3'h0                               
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[6:4]=3'h0                               
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[13:8]=6'h16 (Mirror: 6'h00)             
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[21:16]=6'h16 (Mirror: 6'h00)            
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x16, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x16, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_1                       -     @9397                                                         
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[2:0]=3'h0                               
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[6:4]=3'h0                               
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[13:8]=6'h21 (Mirror: 6'h00)             
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[21:16]=6'h21 (Mirror: 6'h00)            
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x21, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x21, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_DCM_CTRL0_0                                ral_reg_DRAMC_blk_SHU_DCM_CTRL0_0                          -     @5331                                                         
      DDRPHY_CLK_EN_OPT                            uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[7:7]=1'h1 (Mirror: 1'h0)                  
      DPHY_CMD_CLKEN_EXTCNT                        uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[10:8]=3'h3                                
      DDRPHY_CLK_DYN_GATING_SEL                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[15:12]=4'h5 (Mirror: 4'h0)                
      APHYPI_CKCGL_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[19:16]=4'h2                               
      APHYPI_CKCGH_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[23:20]=4'h4                               
      FASTWAKE2                                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[29:29]=1'h0                               
      FASTWAKE                                     uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[31:31]=1'h1                               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_DCM_CTRL0, P_Fld(0x1, SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT) |
            P_Fld(0x3, SHU_DCM_CTRL0_DPHY_CMD_CLKEN_EXTCNT) | P_Fld(0x5, SHU_DCM_CTRL0_DDRPHY_CLK_DYN_GATING_SEL) |
            P_Fld(0x2, SHU_DCM_CTRL0_APHYPI_CKCGL_CNT) | P_Fld(0x4, SHU_DCM_CTRL0_APHYPI_CKCGH_CNT) |
            P_Fld(0x0, SHU_DCM_CTRL0_FASTWAKE2) | P_Fld(0x1, SHU_DCM_CTRL0_FASTWAKE));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_APHY_TX_PICG_CTRL_0                        ral_reg_DRAMC_blk_SHU_APHY_TX_PICG_CTRL_0                  -     @5683                                                         
      DDRPHY_CLK_EN_COMB_TX_PICG_CNT               uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[3:0]=4'h3 (Mirror: 4'h0)          
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[6:4]=3'h3 (Mirror: 3'h0)          
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[10:8]=3'h2 (Mirror: 3'h0)         
      DPHY_TX_DCM_EXTCNT                           uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[15:12]=4'h2                       
      DDRPHY_CLK_EN_COMB_TX_OPT                    uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[31:31]=1'h1 (Mirror: 1'h0)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_APHY_TX_PICG_CTRL, P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT) |
            P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1) | P_Fld(0x2, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0) |
            P_Fld(0x2, SHU_APHY_TX_PICG_CTRL_DPHY_TX_DCM_EXTCNT) | P_Fld(0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_APHY_TX_PICG_CTRL_0_0                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_0              -     @5221                                                         
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[2:0]=3'h3 (Mirror: 3'h0)      
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_0[6:4]=3'h3 (Mirror: 3'h0)      
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL, P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
            P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_APHY_TX_PICG_CTRL_0_1                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_1              -     @5226                                                         
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[2:0]=3'h3 (Mirror: 3'h0)      
      DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0           uvm_reg_field                                              ...    RW SHURK_APHY_TX_PICG_CTRL_0_1[6:4]=3'h3 (Mirror: 3'h0)      
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_APHY_TX_PICG_CTRL+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P1) |
            P_Fld(0x3, SHURK_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQ_RK_SEL_P0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_NEW_XRW2W_CTRL_0                           ral_reg_DRAMC_blk_SHU_NEW_XRW2W_CTRL_0                     -     @5677                                                         
      TX_PI_UPDCTL_B0                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[18:16]=3'h3 (Mirror: 3'h0)           
      TX_PI_UPDCTL_B1                              uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[26:24]=3'h3 (Mirror: 3'h0)           
      TXPI_UPD_MODE                                uvm_reg_field                                              ...    RW SHU_NEW_XRW2W_CTRL_0[31:31]=1'h0 (Mirror: 1'h1)           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_NEW_XRW2W_CTRL, P_Fld(0x3, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B0) |
            P_Fld(0x3, SHU_NEW_XRW2W_CTRL_TX_PI_UPDCTL_B1) | P_Fld(0x0, SHU_NEW_XRW2W_CTRL_TXPI_UPD_MODE));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SELPH_DQS0_0                               ral_reg_DRAMC_blk_SHU_SELPH_DQS0_0                         -     @5576                                                         
      TXDLY_DQS0                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[2:0]=3'h4 (Mirror: 3'h1)                 
      TXDLY_DQS1                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[6:4]=3'h4 (Mirror: 3'h1)                 
      TXDLY_DQS2                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[10:8]=3'h1                               
      TXDLY_DQS3                                   uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[14:12]=3'h1                              
      TXDLY_OEN_DQS0                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[18:16]=3'h3 (Mirror: 3'h1)               
      TXDLY_OEN_DQS1                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[22:20]=3'h3 (Mirror: 3'h1)               
      TXDLY_OEN_DQS2                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[26:24]=3'h1                              
      TXDLY_OEN_DQS3                               uvm_reg_field                                              ...    RW SHU_SELPH_DQS0_0[30:28]=3'h1                              
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_DQS3) | P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS0_TXDLY_OEN_DQS3));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS0, P_Fld(0x4, SHU_SELPH_DQS0_TXDLY_DQS0) |
            P_Fld(0x4, SHU_SELPH_DQS0_TXDLY_DQS1) | P_Fld(0x3, SHU_SELPH_DQS0_TXDLY_OEN_DQS0) |
            P_Fld(0x3, SHU_SELPH_DQS0_TXDLY_OEN_DQS1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SELPH_DQS1_0                               ral_reg_DRAMC_blk_SHU_SELPH_DQS1_0                         -     @5587                                                         
      dly_DQS0                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[3:0]=4'h1                                
      dly_DQS1                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[7:4]=4'h1                                
      dly_DQS2                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[11:8]=4'h1                               
      dly_DQS3                                     uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[15:12]=4'h1                              
      dly_oen_DQS0                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[19:16]=4'h6 (Mirror: 4'h1)               
      dly_oen_DQS1                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[23:20]=4'h6 (Mirror: 4'h1)               
      dly_oen_DQS2                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[27:24]=4'h1                              
      dly_oen_DQS3                                 uvm_reg_field                                              ...    RW SHU_SELPH_DQS1_0[31:28]=4'h1                              
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS1, P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS3) | P_Fld(0x1, SHU_SELPH_DQS1_DLY_OEN_DQS2) |
            P_Fld(0x1, SHU_SELPH_DQS1_DLY_OEN_DQS3));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_SELPH_DQS1, P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS0) |
            P_Fld(0x1, SHU_SELPH_DQS1_DLY_DQS1) | P_Fld(0x6, SHU_SELPH_DQS1_DLY_OEN_DQS0) |
            P_Fld(0x6, SHU_SELPH_DQS1_DLY_OEN_DQS1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ0_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_0                      -     @5041                                                         
      TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[2:0]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[6:4]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[10:8]=3'h1                            
      TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[14:12]=3'h1                           
      TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[18:16]=3'h3 (Mirror: 3'h1)            
      TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[22:20]=3'h3 (Mirror: 3'h1)            
      TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[26:24]=3'h1                           
      TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_0[30:28]=3'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0, P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ0) |
            P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
            P_Fld(0x3, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ1_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_0                      -     @5063                                                         
      TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[2:0]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[6:4]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[10:8]=3'h1                            
      TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[14:12]=3'h1                           
      TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[18:16]=3'h3 (Mirror: 3'h1)            
      TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[22:20]=3'h3 (Mirror: 3'h1)            
      TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[26:24]=3'h1                           
      TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_0[30:28]=3'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1, P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM0) |
            P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
            P_Fld(0x3, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ2_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_0                      -     @5085                                                         
      dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[3:0]=4'h2 (Mirror: 4'h1)              
      dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[7:4]=4'h2 (Mirror: 4'h1)              
      dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[11:8]=4'h1                            
      dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[15:12]=4'h1                           
      dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[19:16]=4'h7 (Mirror: 4'h1)            
      dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[23:20]=4'h7 (Mirror: 4'h1)            
      dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[27:24]=4'h1                           
      dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_0[31:28]=4'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2, P_Fld(0x2, SHURK_SELPH_DQ2_DLY_DQ0) |
            P_Fld(0x2, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x7, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
            P_Fld(0x7, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ3_0_0                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_0                      -     @5107                                                         
      dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[3:0]=4'h2 (Mirror: 4'h1)              
      dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[7:4]=4'h2 (Mirror: 4'h1)              
      dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[11:8]=4'h1                            
      dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[15:12]=4'h1                           
      dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[19:16]=4'h7 (Mirror: 4'h1)            
      dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[23:20]=4'h7 (Mirror: 4'h1)            
      dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[27:24]=4'h1                           
      dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_0[31:28]=4'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3, P_Fld(0x2, SHURK_SELPH_DQ3_DLY_DQM0) |
            P_Fld(0x2, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x7, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
            P_Fld(0x7, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ0_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ0_0_1                      -     @5052                                                         
      TXDLY_DQ0                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[2:0]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQ1                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[6:4]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQ2                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[10:8]=3'h1                            
      TXDLY_DQ3                                    uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[14:12]=3'h1                           
      TXDLY_OEN_DQ0                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[18:16]=3'h4 (Mirror: 3'h1)            
      TXDLY_OEN_DQ1                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[22:20]=3'h4 (Mirror: 3'h1)            
      TXDLY_OEN_DQ2                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[26:24]=3'h1                           
      TXDLY_OEN_DQ3                                uvm_reg_field                                              ...    RW SHURK_SELPH_DQ0_0_1[30:28]=3'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ0+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ0) |
            P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_DQ3) | P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_OEN_DQ0) |
            P_Fld(0x4, SHURK_SELPH_DQ0_TXDLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ0_TXDLY_OEN_DQ3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ1_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ1_0_1                      -     @5074                                                         
      TXDLY_DQM0                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[2:0]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQM1                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[6:4]=3'h3 (Mirror: 3'h1)              
      TXDLY_DQM2                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[10:8]=3'h1                            
      TXDLY_DQM3                                   uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[14:12]=3'h1                           
      TXDLY_OEN_DQM0                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[18:16]=3'h4 (Mirror: 3'h1)            
      TXDLY_OEN_DQM1                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[22:20]=3'h4 (Mirror: 3'h1)            
      TXDLY_OEN_DQM2                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[26:24]=3'h1                           
      TXDLY_OEN_DQM3                               uvm_reg_field                                              ...    RW SHURK_SELPH_DQ1_0_1[30:28]=3'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM0) |
            P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_DQM3) | P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_OEN_DQM0) |
            P_Fld(0x4, SHURK_SELPH_DQ1_TXDLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ1_TXDLY_OEN_DQM3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ2_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ2_0_1                      -     @5096                                                         
      dly_DQ0                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[3:0]=4'h3 (Mirror: 4'h1)              
      dly_DQ1                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[7:4]=4'h3 (Mirror: 4'h1)              
      dly_DQ2                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[11:8]=4'h1                            
      dly_DQ3                                      uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[15:12]=4'h1                           
      dly_oen_DQ0                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[19:16]=4'h0 (Mirror: 4'h1)            
      dly_oen_DQ1                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[23:20]=4'h0 (Mirror: 4'h1)            
      dly_oen_DQ2                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[27:24]=4'h1                           
      dly_oen_DQ3                                  uvm_reg_field                                              ...    RW SHURK_SELPH_DQ2_0_1[31:28]=4'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x3, SHURK_SELPH_DQ2_DLY_DQ0) |
            P_Fld(0x3, SHURK_SELPH_DQ2_DLY_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_DQ3) | P_Fld(0x0, SHURK_SELPH_DQ2_DLY_OEN_DQ0) |
            P_Fld(0x0, SHURK_SELPH_DQ2_DLY_OEN_DQ1) | P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ2) |
            P_Fld(0x1, SHURK_SELPH_DQ2_DLY_OEN_DQ3));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_SELPH_DQ3_0_1                            ral_reg_DRAMC_blk_SHURK_SELPH_DQ3_0_1                      -     @5118                                                         
      dly_DQM0                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[3:0]=4'h3 (Mirror: 4'h1)              
      dly_DQM1                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[7:4]=4'h3 (Mirror: 4'h1)              
      dly_DQM2                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[11:8]=4'h1                            
      dly_DQM3                                     uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[15:12]=4'h1                           
      dly_oen_DQM0                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[19:16]=4'h0 (Mirror: 4'h1)            
      dly_oen_DQM1                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[23:20]=4'h0 (Mirror: 4'h1)            
      dly_oen_DQM2                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[27:24]=4'h1                           
      dly_oen_DQM3                                 uvm_reg_field                                              ...    RW SHURK_SELPH_DQ3_0_1[31:28]=4'h1                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_SELPH_DQ3+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x3, SHURK_SELPH_DQ3_DLY_DQM0) |
            P_Fld(0x3, SHURK_SELPH_DQ3_DLY_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_DQM3) | P_Fld(0x0, SHURK_SELPH_DQ3_DLY_OEN_DQM0) |
            P_Fld(0x0, SHURK_SELPH_DQ3_DLY_OEN_DQM1) | P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM2) |
            P_Fld(0x1, SHURK_SELPH_DQ3_DLY_OEN_DQM3));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL1_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_0                    -     @5129                                                         
      BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[10:0]=11'h011 (Mirror: 11'h000)     
      BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_0[26:16]=11'h012 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1, P_Fld(0x011, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
            P_Fld(0x012, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL2_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_0                    -     @5139                                                         
      BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[10:0]=11'h011 (Mirror: 11'h000)     
      BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_0[26:16]=11'h012 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2, P_Fld(0x011, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
            P_Fld(0x012, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL5_0_0                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_0                    -     @5177                                                         
      BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[10:0]=11'h011 (Mirror: 11'h000)     
      BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_0[26:16]=11'h012 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5, P_Fld(0x011, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
            P_Fld(0x012, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL1_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL1_0_1                    -     @5134                                                         
      BOOT_ORIG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[10:0]=11'h016 (Mirror: 11'h000)     
      BOOT_ORIG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL1_0_1[26:16]=11'h021 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL1+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x016, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0) |
            P_Fld(0x021, SHURK_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL2_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL2_0_1                    -     @5144                                                         
      BOOT_TARG_UI_RK0_DQ0                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[10:0]=11'h016 (Mirror: 11'h000)     
      BOOT_TARG_UI_RK0_DQ1                         uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL2_0_1[26:16]=11'h021 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL2+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x016, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0) |
            P_Fld(0x021, SHURK_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_DQS2DQ_CAL5_0_1                          ral_reg_DRAMC_blk_SHURK_DQS2DQ_CAL5_0_1                    -     @5182                                                         
      BOOT_TARG_UI_RK0_DQM0                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[10:0]=11'h016 (Mirror: 11'h000)     
      BOOT_TARG_UI_RK0_DQM1                        uvm_reg_field                                              ...    RW SHURK_DQS2DQ_CAL5_0_1[26:16]=11'h021 (Mirror: 11'h000)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_DQS2DQ_CAL5+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x016, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0) |
            P_Fld(0x021, SHURK_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_PI_0_0                                   ral_reg_DRAMC_blk_SHURK_PI_0_0                             -     @5187                                                         
      RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[5:0]=6'h12 (Mirror: 6'h00)                   
      RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_0[13:8]=6'h11 (Mirror: 6'h00)                  
      RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[21:16]=6'h12 (Mirror: 6'h00)                 
      RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_0[29:24]=6'h11 (Mirror: 6'h00)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_PI, P_Fld(0x12, SHURK_PI_RK0_ARPI_DQ_B1) |
            P_Fld(0x11, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x12, SHURK_PI_RK0_ARPI_DQM_B1) |
            P_Fld(0x11, SHURK_PI_RK0_ARPI_DQM_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_PI_0_1                                   ral_reg_DRAMC_blk_SHURK_PI_0_1                             -     @5194                                                         
      RK0_ARPI_DQ_B1                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[5:0]=6'h21 (Mirror: 6'h00)                   
      RK0_ARPI_DQ_B0                               uvm_reg_field                                              ...    RW SHURK_PI_0_1[13:8]=6'h16 (Mirror: 6'h00)                  
      RK0_ARPI_DQM_B1                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[21:16]=6'h21 (Mirror: 6'h00)                 
      RK0_ARPI_DQM_B0                              uvm_reg_field                                              ...    RW SHURK_PI_0_1[29:24]=6'h16 (Mirror: 6'h00)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHURK_PI+(1*DRAMC_REG_AO_RANK_OFFSET), P_Fld(0x21, SHURK_PI_RK0_ARPI_DQ_B1) |
            P_Fld(0x16, SHURK_PI_RK0_ARPI_DQ_B0) | P_Fld(0x21, SHURK_PI_RK0_ARPI_DQM_B1) |
            P_Fld(0x16, SHURK_PI_RK0_ARPI_DQM_B0));

    #if !CODE_SIZE_REDUCE
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY0_0_0                    -     @7826                                                         
      TX_ARDQ0_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARDQ1_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[15:8]=8'h08 (Mirror: 8'h00)          
      TX_ARDQ2_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[23:16]=8'h08 (Mirror: 8'h00)         
      TX_ARDQ3_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_0[31:24]=8'h08 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY0, P_Fld(0x08, SHU_R0_B0_TXDLY0_TX_ARDQ0_DLY_B0) |
            P_Fld(0x08, SHU_R0_B0_TXDLY0_TX_ARDQ1_DLY_B0) | P_Fld(0x08, SHU_R0_B0_TXDLY0_TX_ARDQ2_DLY_B0) |
            P_Fld(0x08, SHU_R0_B0_TXDLY0_TX_ARDQ3_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY1_0_0                    -     @7840                                                         
      TX_ARDQ4_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARDQ5_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[15:8]=8'h08 (Mirror: 8'h00)          
      TX_ARDQ6_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[23:16]=8'h08 (Mirror: 8'h00)         
      TX_ARDQ7_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_0[31:24]=8'h08 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY1, P_Fld(0x08, SHU_R0_B0_TXDLY1_TX_ARDQ4_DLY_B0) |
            P_Fld(0x08, SHU_R0_B0_TXDLY1_TX_ARDQ5_DLY_B0) | P_Fld(0x08, SHU_R0_B0_TXDLY1_TX_ARDQ6_DLY_B0) |
            P_Fld(0x08, SHU_R0_B0_TXDLY1_TX_ARDQ7_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY3_0_0                    -     @7868                                                         
      TX_ARDQM0_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARWCK_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[23:16]=8'h00                         
      TX_ARWCKB_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_0[31:24]=8'h00                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY3, P_Fld(0x08, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0) |
            P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCK_DLY_B0) | P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCKB_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY0_0_0                    -     @9233                                                         
      TX_ARDQ0_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[7:0]=8'h04 (Mirror: 8'h00)           
      TX_ARDQ1_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[15:8]=8'h04 (Mirror: 8'h00)          
      TX_ARDQ2_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[23:16]=8'h04 (Mirror: 8'h00)         
      TX_ARDQ3_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_0[31:24]=8'h04 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY0, P_Fld(0x04, SHU_R0_B1_TXDLY0_TX_ARDQ0_DLY_B1) |
            P_Fld(0x04, SHU_R0_B1_TXDLY0_TX_ARDQ1_DLY_B1) | P_Fld(0x04, SHU_R0_B1_TXDLY0_TX_ARDQ2_DLY_B1) |
            P_Fld(0x04, SHU_R0_B1_TXDLY0_TX_ARDQ3_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY1_0_0                    -     @9247                                                         
      TX_ARDQ4_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[7:0]=8'h04 (Mirror: 8'h00)           
      TX_ARDQ5_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[15:8]=8'h04 (Mirror: 8'h00)          
      TX_ARDQ6_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[23:16]=8'h04 (Mirror: 8'h00)         
      TX_ARDQ7_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_0[31:24]=8'h04 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY1, P_Fld(0x04, SHU_R0_B1_TXDLY1_TX_ARDQ4_DLY_B1) |
            P_Fld(0x04, SHU_R0_B1_TXDLY1_TX_ARDQ5_DLY_B1) | P_Fld(0x04, SHU_R0_B1_TXDLY1_TX_ARDQ6_DLY_B1) |
            P_Fld(0x04, SHU_R0_B1_TXDLY1_TX_ARDQ7_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY3_0_0                    -     @9275                                                         
      TX_ARDQM0_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[7:0]=8'h04 (Mirror: 8'h00)           
      TX_ARWCK_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[23:16]=8'h00                         
      TX_ARWCKB_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_0[31:24]=8'h00                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY3, P_Fld(0x04, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1) |
            P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCK_DLY_B1) | P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCKB_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY0_0_1                    -     @7833                                                         
      TX_ARDQ0_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[7:0]=8'h34 (Mirror: 8'h00)           
      TX_ARDQ1_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[15:8]=8'h34 (Mirror: 8'h00)          
      TX_ARDQ2_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[23:16]=8'h34 (Mirror: 8'h00)         
      TX_ARDQ3_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY0_0_1[31:24]=8'h34 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x34, SHU_R0_B0_TXDLY0_TX_ARDQ0_DLY_B0) |
            P_Fld(0x34, SHU_R0_B0_TXDLY0_TX_ARDQ1_DLY_B0) | P_Fld(0x34, SHU_R0_B0_TXDLY0_TX_ARDQ2_DLY_B0) |
            P_Fld(0x34, SHU_R0_B0_TXDLY0_TX_ARDQ3_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY1_0_1                    -     @7847                                                         
      TX_ARDQ4_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[7:0]=8'h34 (Mirror: 8'h00)           
      TX_ARDQ5_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[15:8]=8'h34 (Mirror: 8'h00)          
      TX_ARDQ6_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[23:16]=8'h34 (Mirror: 8'h00)         
      TX_ARDQ7_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY1_0_1[31:24]=8'h34 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x34, SHU_R0_B0_TXDLY1_TX_ARDQ4_DLY_B0) |
            P_Fld(0x34, SHU_R0_B0_TXDLY1_TX_ARDQ5_DLY_B0) | P_Fld(0x34, SHU_R0_B0_TXDLY1_TX_ARDQ6_DLY_B0) |
            P_Fld(0x34, SHU_R0_B0_TXDLY1_TX_ARDQ7_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_TXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_TXDLY3_0_1                    -     @7874                                                         
      TX_ARDQM0_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[7:0]=8'h34 (Mirror: 8'h00)           
      TX_ARWCK_DLY_B0                              uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[23:16]=8'h00                         
      TX_ARWCKB_DLY_B0                             uvm_reg_field                                              ...    RW SHU_R0_B0_TXDLY3_0_1[31:24]=8'h00                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_TXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x34, SHU_R0_B0_TXDLY3_TX_ARDQM0_DLY_B0) |
            P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCK_DLY_B0) | P_Fld(0x00, SHU_R0_B0_TXDLY3_TX_ARWCKB_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY0_0_1                    -     @9240                                                         
      TX_ARDQ0_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARDQ1_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[15:8]=8'h08 (Mirror: 8'h00)          
      TX_ARDQ2_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[23:16]=8'h08 (Mirror: 8'h00)         
      TX_ARDQ3_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY0_0_1[31:24]=8'h08 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ0_DLY_B1) |
            P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ1_DLY_B1) | P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ2_DLY_B1) |
            P_Fld(0x08, SHU_R0_B1_TXDLY0_TX_ARDQ3_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY1_0_1                    -     @9254                                                         
      TX_ARDQ4_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARDQ5_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[15:8]=8'h08 (Mirror: 8'h00)          
      TX_ARDQ6_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[23:16]=8'h08 (Mirror: 8'h00)         
      TX_ARDQ7_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY1_0_1[31:24]=8'h08 (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ4_DLY_B1) |
            P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ5_DLY_B1) | P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ6_DLY_B1) |
            P_Fld(0x08, SHU_R0_B1_TXDLY1_TX_ARDQ7_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_TXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_TXDLY3_0_1                    -     @9281                                                         
      TX_ARDQM0_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[7:0]=8'h08 (Mirror: 8'h00)           
      TX_ARWCK_DLY_B1                              uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[23:16]=8'h00                         
      TX_ARWCKB_DLY_B1                             uvm_reg_field                                              ...    RW SHU_R0_B1_TXDLY3_0_1[31:24]=8'h00                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_TXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_TXDLY3_TX_ARDQM0_DLY_B1) |
            P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCK_DLY_B1) | P_Fld(0x00, SHU_R0_B1_TXDLY3_TX_ARWCKB_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_TX_RANKCTL_0                               ral_reg_DRAMC_blk_SHU_TX_RANKCTL_0                         -     @5651                                                         
      TXRANKINCTL_TXDLY                            uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[3:0]=4'h2 (Mirror: 4'h0)                 
      TXRANKINCTL                                  uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[7:4]=4'h2 (Mirror: 4'h0)                 
      TXRANKINCTL_ROOT                             uvm_reg_field                                              ...    RW SHU_TX_RANKCTL_0[11:8]=4'h0                               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_TX_RANKCTL, P_Fld(0x2, SHU_TX_RANKCTL_TXRANKINCTL_TXDLY) |
            P_Fld(0x2, SHU_TX_RANKCTL_TXRANKINCTL) | P_Fld(0x0, SHU_TX_RANKCTL_TXRANKINCTL_ROOT));
    #endif
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Exit:
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Enter:
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING0_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING0_0                       -     @5538                                                         
      ACDERATEEN                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[0:0]=1'h0                              
      TRRD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[18:16]=3'h5 (Mirror: 3'h0)             
      TRCD_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING0_0[27:24]=4'h9 (Mirror: 4'h0)             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !(CODE_SIZE_REDUCE && AC_TIMING_DERATE_ENABLE)
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING0, P_Fld(0x0, SHU_AC_DERATING0_ACDERATEEN) |
            P_Fld(0x5, SHU_AC_DERATING0_TRRD_DERATE) | P_Fld(0x9, SHU_AC_DERATING0_TRCD_DERATE));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING1_0                             ral_reg_DRAMC_blk_SHU_AC_DERATING1_0                       -     @5544                                                         
      TRPAB_DERATE                                 uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[3:0]=4'h9 (Mirror: 4'h0)               
      TRP_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[11:8]=4'h8 (Mirror: 4'h0)              
      TRAS_DERATE                                  uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[21:16]=6'h0c (Mirror: 6'h00)           
      TRC_DERATE                                   uvm_reg_field                                              ...    RW SHU_AC_DERATING1_0[28:24]=5'h00                           
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING1, P_Fld(0x9, SHU_AC_DERATING1_TRPAB_DERATE) |
            P_Fld(0x8, SHU_AC_DERATING1_TRP_DERATE) | P_Fld(0x0c, SHU_AC_DERATING1_TRAS_DERATE) |
            P_Fld(0x00, SHU_AC_DERATING1_TRC_DERATE));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_DERATING_05T_0                          ral_reg_DRAMC_blk_SHU_AC_DERATING_05T_0                    -     @5551                                                         
      TRC_05T_DERATE                               uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[0:0]=1'h0                           
      TRCD_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[6:6]=1'h1 (Mirror: 1'h0)            
      TRP_05T_DERATE                               uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[7:7]=1'h0                           
      TRPAB_05T_DERATE                             uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[8:8]=1'h1 (Mirror: 1'h0)            
      TRAS_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[9:9]=1'h0                           
      TRRD_05T_DERATE                              uvm_reg_field                                              ...    RW SHU_AC_DERATING_05T_0[12:12]=1'h0                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_DERATING_05T, P_Fld(0x0, SHU_AC_DERATING_05T_TRC_05T_DERATE) |
            P_Fld(0x1, SHU_AC_DERATING_05T_TRCD_05T_DERATE) | P_Fld(0x0, SHU_AC_DERATING_05T_TRP_05T_DERATE) |
            P_Fld(0x1, SHU_AC_DERATING_05T_TRPAB_05T_DERATE) | P_Fld(0x0, SHU_AC_DERATING_05T_TRAS_05T_DERATE) |
            P_Fld(0x0, SHU_AC_DERATING_05T_TRRD_05T_DERATE));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_SREF_CTRL_0                                ral_reg_DRAMC_blk_SHU_SREF_CTRL_0                          -     @5322                                                         
      CKEHCMD                                      uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[5:4]=2'h3                                 
      SREF_CK_DLY                                  uvm_reg_field                                              ...    RW SHU_SREF_CTRL_0[29:28]=2'h3 (Mirror: 2'h0)                
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_SREF_CTRL, P_Fld(0x3, SHU_SREF_CTRL_CKEHCMD) |
            P_Fld(0x3, SHU_SREF_CTRL_SREF_CK_DLY));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_HMR4_DVFS_CTRL0_0                          ral_reg_DRAMC_blk_SHU_HMR4_DVFS_CTRL0_0                    -     @5341                                                         
      FSPCHG_PRDCNT                                uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[15:8]=8'h75 (Mirror: 8'h00)         
      REFRCNT                                      uvm_reg_field                                              ...    RW SHU_HMR4_DVFS_CTRL0_0[27:16]=12'h000                      
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_HMR4_DVFS_CTRL0, P_Fld(0x75, SHU_HMR4_DVFS_CTRL0_FSPCHG_PRDCNT) |
            P_Fld(0x000, SHU_HMR4_DVFS_CTRL0_REFRCNT));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_AC_TIME_05T_0                              ral_reg_DRAMC_blk_SHU_AC_TIME_05T_0                        -     @5504                                                         
      TRC_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[0:0]=1'h0                               
      TRFCPB_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[1:1]=1'h0                               
      TRFC_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[2:2]=1'h1 (Mirror: 1'h0)                
      TPBR2PBR_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[3:3]=1'h0                               
      TXP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[4:4]=1'h1 (Mirror: 1'h0)                
      TRTP_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[5:5]=1'h0                               
      TRCD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[6:6]=1'h1 (Mirror: 1'h0)                
      TRP_05T                                      uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[7:7]=1'h0                               
      TRPAB_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[8:8]=1'h1 (Mirror: 1'h0)                
      TRAS_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[9:9]=1'h1 (Mirror: 1'h0)                
      TWR_M05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[10:10]=1'h1 (Mirror: 1'h0)              
      TRRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[12:12]=1'h0                             
      TFAW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[13:13]=1'h0                             
      TCKEPRD_05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[14:14]=1'h0                             
      TR2PD_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[15:15]=1'h0                             
      TWTPD_M05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[16:16]=1'h1 (Mirror: 1'h0)              
      TMRRI_05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[17:17]=1'h0                             
      TMRWCKEL_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[18:18]=1'h0                             
      BGTRRD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[19:19]=1'h0                             
      BGTCCD_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[20:20]=1'h0                             
      BGTWTR_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[21:21]=1'h0                             
      TR2W_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[22:22]=1'h0                             
      TWTR_M05T                                    uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[23:23]=1'h0                             
      XRTR2W_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[24:24]=1'h0                             
      TMRD_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[25:25]=1'h1 (Mirror: 1'h0)              
      TMRW_05T                                     uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[26:26]=1'h0                             
      TMRR2MRW_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[27:27]=1'h1 (Mirror: 1'h0)              
      TW2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[28:28]=1'h0                             
      TR2MRW_05T                                   uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[29:29]=1'h1 (Mirror: 1'h0)              
      TPBR2ACT_05T                                 uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[30:30]=1'h1 (Mirror: 1'h0)              
      XRTW2R_M05T                                  uvm_reg_field                                              ...    RW SHU_AC_TIME_05T_0[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T,
            P_Fld(0x0, SHU_AC_TIME_05T_TCKEPRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_BGTRRD_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_BGTCCD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_BGTWTR_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_XRTR2W_05T) | P_Fld(0x0, SHU_AC_TIME_05T_XRTW2R_M05T));

     #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_AC_TIME_05T, P_Fld(0x0, SHU_AC_TIME_05T_TRC_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRFCPB_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TRFC_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TPBR2PBR_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TXP_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRTP_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TRCD_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRP_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TRPAB_05T) |
            P_Fld(0x1, SHU_AC_TIME_05T_TRAS_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWR_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TRRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TFAW_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2PD_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWTPD_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TMRRI_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRWCKEL_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2PD_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TWTPD_M05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TMRRI_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRWCKEL_05T) |
            P_Fld(0x0, SHU_AC_TIME_05T_TR2W_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TWTR_M05T) |
            P_Fld(0x1, SHU_AC_TIME_05T_TMRD_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TMRW_05T) |
            P_Fld(0x1, SHU_AC_TIME_05T_TMRR2MRW_05T) | P_Fld(0x0, SHU_AC_TIME_05T_TW2MRW_05T) |
            P_Fld(0x1, SHU_AC_TIME_05T_TR2MRW_05T) | P_Fld(0x1, SHU_AC_TIME_05T_TPBR2ACT_05T));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM_XRT_0                                ral_reg_DRAMC_blk_SHU_ACTIM_XRT_0                          -     @5497                                                         
      XRTR2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[4:0]=5'h03 (Mirror: 5'h01)                
      XRTR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[13:8]=6'h08 (Mirror: 6'h01)               
      XRTW2R                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[19:16]=4'h1                               
      XRTW2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM_XRT_0[28:24]=5'h05 (Mirror: 5'h01)              
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM_XRT, P_Fld(0x03, SHU_ACTIM_XRT_XRTR2R) |
            P_Fld(0x08, SHU_ACTIM_XRT_XRTR2W) | P_Fld(0x1, SHU_ACTIM_XRT_XRTW2R) |
            P_Fld(0x05, SHU_ACTIM_XRT_XRTW2W));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM0_0                                   ral_reg_DRAMC_blk_SHU_ACTIM0_0                             -     @5443                                                         
      TWTR                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[5:0]=6'h08 (Mirror: 6'h01)                   
      TWR                                          uvm_reg_field                                              ...    RW SHU_ACTIM0_0[15:8]=8'h0d (Mirror: 8'h06)                  
      TRRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[18:16]=3'h4 (Mirror: 3'h0)                   
      TRCD                                         uvm_reg_field                                              ...    RW SHU_ACTIM0_0[27:24]=4'h8 (Mirror: 4'h2)                   
      CKELCKCNT                                    uvm_reg_field                                              ...    RW SHU_ACTIM0_0[31:28]=4'h3 (Mirror: 4'h0)                   
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM0, P_Fld(0x08, SHU_ACTIM0_TWTR) |
            P_Fld(0x0d, SHU_ACTIM0_TWR) | P_Fld(0x4, SHU_ACTIM0_TRRD) |
            P_Fld(0x8, SHU_ACTIM0_TRCD) | P_Fld(0x3, SHU_ACTIM0_CKELCKCNT));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM1_0                                   ral_reg_DRAMC_blk_SHU_ACTIM1_0                             -     @5451                                                         
      TRPAB                                        uvm_reg_field                                              ...    RW SHU_ACTIM1_0[3:0]=4'h8 (Mirror: 4'ha)                     
      TMRWCKEL                                     uvm_reg_field                                              ...    RW SHU_ACTIM1_0[7:4]=4'h8                                    
      TRP                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[11:8]=4'h7 (Mirror: 4'h2)                    
      TRAS                                         uvm_reg_field                                              ...    RW SHU_ACTIM1_0[21:16]=6'h0b (Mirror: 6'h04)                 
      TRC                                          uvm_reg_field                                              ...    RW SHU_ACTIM1_0[28:24]=5'h00 (Mirror: 5'h05)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM1, P_Fld(0x8, SHU_ACTIM1_TRPAB) |
            P_Fld(0x8, SHU_ACTIM1_TMRWCKEL) | P_Fld(0x7, SHU_ACTIM1_TRP) |
            P_Fld(0x0b, SHU_ACTIM1_TRAS) | P_Fld(0x00, SHU_ACTIM1_TRC));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM2_0                                   ral_reg_DRAMC_blk_SHU_ACTIM2_0                             -     @5459                                                         
      TXP                                          uvm_reg_field                                              ...    RW SHU_ACTIM2_0[3:0]=4'h0                                    
      TMRRI                                        uvm_reg_field                                              ...    RW SHU_ACTIM2_0[8:4]=5'h0c (Mirror: 5'h0e)                   
      TRTP                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[14:12]=3'h2 (Mirror: 3'h0)                   
      TR2W                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[21:16]=6'h09 (Mirror: 6'h00)                 
      TFAW                                         uvm_reg_field                                              ...    RW SHU_ACTIM2_0[28:24]=5'h0b (Mirror: 5'h05)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM2, P_Fld(0x0, SHU_ACTIM2_TXP) |
            P_Fld(0x0c, SHU_ACTIM2_TMRRI) | P_Fld(0x2, SHU_ACTIM2_TRTP) |
            P_Fld(0x09, SHU_ACTIM2_TR2W) | P_Fld(0x0b, SHU_ACTIM2_TFAW));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM3_0                                   ral_reg_DRAMC_blk_SHU_ACTIM3_0                             -     @5467                                                         
      TRFCPB                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[7:0]=8'h4d (Mirror: 8'h00)                   
      MANTMRR                                      uvm_reg_field                                              ...    RW SHU_ACTIM3_0[11:8]=4'h4 (Mirror: 4'h0)                    
      TR2MRR                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[15:12]=4'h4 (Mirror: 4'h0)                   
      TRFC                                         uvm_reg_field                                              ...    RW SHU_ACTIM3_0[23:16]=8'ha5 (Mirror: 8'h00)                 
      TWTR_L                                       uvm_reg_field                                              ...    RW SHU_ACTIM3_0[29:24]=6'h00                                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x4d, SHU_ACTIM3_TRFCPB) |
            P_Fld(0x4, SHU_ACTIM3_TR2MRR) | P_Fld(0xa5, SHU_ACTIM3_TRFC));
    #endif

    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM3, P_Fld(0x4, SHU_ACTIM3_MANTMRR) |
            P_Fld(0x00, SHU_ACTIM3_TWTR_L));
    #if !CODE_SIZE_REDUCE
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM4_0                                   ral_reg_DRAMC_blk_SHU_ACTIM4_0                             -     @5475                                                         
      TXREFCNT                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[9:0]=10'h0b5 (Mirror: 10'h028)               
      TMRR2MRW                                     uvm_reg_field                                              ...    RW SHU_ACTIM4_0[15:10]=6'h0d (Mirror: 6'h00)                 
      TMRR2W                                       uvm_reg_field                                              ...    RW SHU_ACTIM4_0[21:16]=6'h0c (Mirror: 6'h00)                 
      TZQCS                                        uvm_reg_field                                              ...    RW SHU_ACTIM4_0[31:24]=8'h28 (Mirror: 8'h00)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM4, P_Fld(0x0b5, SHU_ACTIM4_TXREFCNT) |
            P_Fld(0x0d, SHU_ACTIM4_TMRR2MRW) | P_Fld(0x0c, SHU_ACTIM4_TMRR2W) |
            P_Fld(0x28, SHU_ACTIM4_TZQCS));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM5_0                                   ral_reg_DRAMC_blk_SHU_ACTIM5_0                             -     @5482                                                         
      TR2PD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[6:0]=7'h0e (Mirror: 7'h00)                   
      TWTPD                                        uvm_reg_field                                              ...    RW SHU_ACTIM5_0[14:8]=7'h10 (Mirror: 7'h00)                  
      TPBR2PBR                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[23:16]=8'h23 (Mirror: 8'h00)                 
      TPBR2ACT                                     uvm_reg_field                                              ...    RW SHU_ACTIM5_0[29:28]=2'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM5, P_Fld(0x0e, SHU_ACTIM5_TR2PD) |
            P_Fld(0x10, SHU_ACTIM5_TWTPD) | P_Fld(0x23, SHU_ACTIM5_TPBR2PBR) |
            P_Fld(0x0, SHU_ACTIM5_TPBR2ACT));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_ACTIM6_0                                   ral_reg_DRAMC_blk_SHU_ACTIM6_0                             -     @5489                                                         
      TZQLAT2                                      uvm_reg_field                                              ...    RW SHU_ACTIM6_0[4:0]=5'h0e (Mirror: 5'h1f)                   
      TMRD                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[11:8]=4'h7 (Mirror: 4'h0)                    
      TMRW                                         uvm_reg_field                                              ...    RW SHU_ACTIM6_0[15:12]=4'h5 (Mirror: 4'h0)                   
      TW2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[25:20]=6'h0a (Mirror: 6'h00)                 
      TR2MRW                                       uvm_reg_field                                              ...    RW SHU_ACTIM6_0[31:26]=6'h10 (Mirror: 6'h13)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_ACTIM6, P_Fld(0x0e, SHU_ACTIM6_TZQLAT2) |
            P_Fld(0x7, SHU_ACTIM6_TMRD) | P_Fld(0x5, SHU_ACTIM6_TMRW) |
            P_Fld(0x0a, SHU_ACTIM6_TW2MRW) | P_Fld(0x10, SHU_ACTIM6_TR2MRW));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_CKECTRL_0                                  ral_reg_DRAMC_blk_SHU_CKECTRL_0                            -     @5567                                                         
      TPDE_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[0:0]=1'h1 (Mirror: 1'h0)                    
      TPDX_05T                                     uvm_reg_field                                              ...    RW SHU_CKECTRL_0[1:1]=1'h0                                   
      TPDE                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[14:12]=3'h1                                 
      TPDX                                         uvm_reg_field                                              ...    RW SHU_CKECTRL_0[18:16]=3'h1                                 
      TCKEPRD                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[22:20]=3'h3 (Mirror: 3'h2)                  
      TCKESRX                                      uvm_reg_field                                              ...    RW SHU_CKECTRL_0[25:24]=2'h3 (Mirror: 2'h0)                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_CKECTRL, P_Fld(0x1, SHU_CKECTRL_TPDE_05T) |
            P_Fld(0x0, SHU_CKECTRL_TPDX_05T) | P_Fld(0x1, SHU_CKECTRL_TPDE) |
            P_Fld(0x1, SHU_CKECTRL_TPDX) | P_Fld(0x3, SHU_CKECTRL_TCKEPRD));
    #endif

    vIO32WriteFldAlign(DRAMC_REG_SHU_CKECTRL, 0x3, SHU_CKECTRL_TCKESRX);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_0                                     ral_reg_DRAMC_blk_SHU_MISC_0                               -     @5671                                                         
      REQQUE_MAXCNT                                uvm_reg_field                                              ...    RW SHU_MISC_0[3:0]=4'h2                                      
      DCMDLYREF                                    uvm_reg_field                                              ...    RW SHU_MISC_0[18:16]=3'h7 (Mirror: 3'h4)                     
      DAREFEN                                      uvm_reg_field                                              ...    RW SHU_MISC_0[30:30]=1'h0                                    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_MISC, P_Fld(0x7, SHU_MISC_DCMDLYREF) |
            P_Fld(0x0, SHU_MISC_DAREFEN));

    #if !CODE_SIZE_REDUCE
	vIO32WriteFldAlign(DRAMC_REG_SHU_MISC, 0x2, SHU_MISC_REQQUE_MAXCNT);
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, AC timing Exit
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Enter.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX cross-rank improve setting Exit.
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ8_0                            -     @8226                                                         
      R_DMRXDVS_UPD_FORCE_CYC_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[14:0]=15'h00e7 (Mirror: 15'h0000)            
      R_DMRXDVS_UPD_FORCE_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[15:15]=1'h0                                  
      R_DMRANK_RXDLY_PIPE_CG_IG_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[19:19]=1'h0                                  
      R_RMRODTEN_CG_IG_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[20:20]=1'h0                                  
      R_RMRX_TOPHY_CG_IG_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                   
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[22:22]=1'h0                                  
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0            uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[23:23]=1'h0                                  
      R_DMRXDLY_CG_IG_B0                           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[26:26]=1'h0                                  
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B0                uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[27:27]=1'h0                                  
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0               uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[28:28]=1'h0                                  
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0           uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[29:29]=1'h0                                  
      R_DMRANK_PIPE_CG_IG_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[30:30]=1'h0                                  
      R_DMRANK_CHG_PIPE_CG_IG_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ8_0[31:31]=1'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) | P_Fld(0x1, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
            P_Fld(0x1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) | P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0));
    #endif

    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ8, P_Fld(0x00e7, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B0) |
            P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_UPD_FORCE_EN_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ8_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ8_0                            -     @9633                                                         
      R_DMRXDVS_UPD_FORCE_CYC_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[14:0]=15'h00e7 (Mirror: 15'h0000)            
      R_DMRXDVS_UPD_FORCE_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[15:15]=1'h0                                  
      R_DMRANK_RXDLY_PIPE_CG_IG_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[19:19]=1'h0                                  
      R_RMRODTEN_CG_IG_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[20:20]=1'h0                                  
      R_RMRX_TOPHY_CG_IG_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[21:21]=1'h1 (Mirror: 1'h0)                   
      R_DMRXDVS_RDSEL_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[22:22]=1'h0                                  
      R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1            uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[23:23]=1'h0                                  
      R_DMRXDLY_CG_IG_B1                           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMDQSIEN_FLAG_SYNC_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[26:26]=1'h0                                  
      R_DMDQSIEN_FLAG_PIPE_CG_IG_B1                uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[27:27]=1'h0                                  
      R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1               uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[28:28]=1'h0                                  
      R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1           uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[29:29]=1'h0                                  
      R_DMRANK_PIPE_CG_IG_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[30:30]=1'h0                                  
      R_DMRANK_CHG_PIPE_CG_IG_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ8_0[31:31]=1'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x00e7, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_CYC_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_UPD_FORCE_EN_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ8, P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) | P_Fld(0x1, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1) |
            P_Fld(0x1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) | P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
            P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ5_0                            -     @8126                                                         
      RG_RX_ARDQ_VREF_SEL_B0                       uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[5:0]=6'h0e                                   
      RG_RX_ARDQ_VREF_BYPASS_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[6:6]=1'h0                                    
      RG_ARPI_FB_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[13:8]=6'h00                                  
      RG_RX_ARDQS0_DQSIEN_DLY_B0                   uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[18:16]=3'h0                                  
      RG_RX_ARDQS_DQSIEN_RB_DLY_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[19:19]=1'h0                                  
      RG_RX_ARDQS0_DVS_DLY_B0                      uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[23:20]=4'h4 (Mirror: 4'h0)                   
      RG_RX_ARDQ_FIFO_DQSI_DLY_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ5_0[31:29]=3'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ5, P_Fld(0x0e, SHU_B0_DQ5_RG_RX_ARDQ_VREF_SEL_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_VREF_BYPASS_B0) | P_Fld(0x00, SHU_B0_DQ5_RG_ARPI_FB_B0) |
            P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B0) |
            P_Fld(0x4, SHU_B0_DQ5_RG_RX_ARDQS0_DVS_DLY_B0) | P_Fld(0x0, SHU_B0_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ5_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ5_0                            -     @9533                                                         
      RG_RX_ARDQ_VREF_SEL_B1                       uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[5:0]=6'h0e                                   
      RG_RX_ARDQ_VREF_BYPASS_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[6:6]=1'h0                                    
      RG_ARPI_FB_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[13:8]=6'h00                                  
      RG_RX_ARDQS0_DQSIEN_DLY_B1                   uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[18:16]=3'h0                                  
      RG_RX_ARDQS_DQSIEN_RB_DLY_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[19:19]=1'h0                                  
      RG_RX_ARDQS0_DVS_DLY_B1                      uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[23:20]=4'h4 (Mirror: 4'h0)                   
      RG_RX_ARDQ_FIFO_DQSI_DLY_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ5_0[31:29]=3'h0                                  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ5, P_Fld(0x0e, SHU_B1_DQ5_RG_RX_ARDQ_VREF_SEL_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_VREF_BYPASS_B1) | P_Fld(0x00, SHU_B1_DQ5_RG_ARPI_FB_B1) |
            P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS0_DQSIEN_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQS_DQSIEN_RB_DLY_B1) |
            P_Fld(0x4, SHU_B1_DQ5_RG_RX_ARDQS0_DVS_DLY_B1) | P_Fld(0x0, SHU_B1_DQ5_RG_RX_ARDQ_FIFO_DQSI_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_0                    -     @7888                                                         
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x6d, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0, P_Fld(0x6d, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_0                    -     @7902                                                         
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1, P_Fld(0x6d, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x6d, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_0                    -     @7916                                                         
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2, P_Fld(0x6d, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x6d, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_0                    -     @7930                                                         
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3, P_Fld(0x6d, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x6d, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_0                    -     @7944                                                         
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_0[15:8]=8'h6d (Mirror: 8'h00)          
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4, P_Fld(0x6d, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0x6d, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_0                    -     @7954                                                         
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[8:0]=9'h061 (Mirror: 9'h000)         
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_0[24:16]=9'h061 (Mirror: 9'h000)       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5, P_Fld(0x061, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x061, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY0_0_1                    -     @7895                                                         
      RX_ARDQ0_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ0_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ1_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ1_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY0_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET),
            P_Fld(0x6c, SHU_R0_B0_RXDLY0_RX_ARDQ0_F_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY0_RX_ARDQ1_F_DLY_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B0_RXDLY0_RX_ARDQ0_R_DLY_B0) |
    P_Fld(0x6c, SHU_R0_B0_RXDLY0_RX_ARDQ1_R_DLY_B0));
	#endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY1_0_1                    -     @7909                                                         
      RX_ARDQ2_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ2_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ3_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ3_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY1_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B0_RXDLY1_RX_ARDQ2_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY1_RX_ARDQ2_F_DLY_B0) | P_Fld(0x6c, SHU_R0_B0_RXDLY1_RX_ARDQ3_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY1_RX_ARDQ3_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY2_0_1                    -     @7923                                                         
      RX_ARDQ4_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ4_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ5_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ5_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY2_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B0_RXDLY2_RX_ARDQ4_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY2_RX_ARDQ4_F_DLY_B0) | P_Fld(0x6c, SHU_R0_B0_RXDLY2_RX_ARDQ5_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY2_RX_ARDQ5_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY3_0_1                    -     @7937                                                         
      RX_ARDQ6_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ6_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ7_R_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ7_F_DLY_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY3_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B0_RXDLY3_RX_ARDQ6_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY3_RX_ARDQ6_F_DLY_B0) | P_Fld(0x6c, SHU_R0_B0_RXDLY3_RX_ARDQ7_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY3_RX_ARDQ7_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY4_0_1                    -     @7949                                                         
      RX_ARDQM0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQM0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY4_0_1[15:8]=8'h6c (Mirror: 8'h00)          
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B0_RXDLY4_RX_ARDQM0_R_DLY_B0) |
            P_Fld(0x6c, SHU_R0_B0_RXDLY4_RX_ARDQM0_F_DLY_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B0_RXDLY5_0_1                    -     @7959                                                         
      RX_ARDQS0_R_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[8:0]=9'h060 (Mirror: 9'h000)         
      RX_ARDQS0_F_DLY_B0                           uvm_reg_field                                              ...    RW SHU_R0_B0_RXDLY5_0_1[24:16]=9'h060 (Mirror: 9'h000)       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x060, SHU_R0_B0_RXDLY5_RX_ARDQS0_R_DLY_B0) |
            P_Fld(0x060, SHU_R0_B0_RXDLY5_RX_ARDQS0_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_0                    -     @9295                                                         
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x6d, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));
	
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0, P_Fld(0x6d, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_0                    -     @9309                                                         
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1, P_Fld(0x6d, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x6d, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_0                    -     @9323                                                         
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2, P_Fld(0x6d, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x6d, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_0                    -     @9337                                                         
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[15:8]=8'h6d (Mirror: 8'h00)          
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[23:16]=8'h6d (Mirror: 8'h00)         
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_0[31:24]=8'h6d (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3, P_Fld(0x6d, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x6d, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_0                    -     @9351                                                         
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[7:0]=8'h6d (Mirror: 8'h00)           
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_0[15:8]=8'h6d (Mirror: 8'h00)          
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4, P_Fld(0x6d, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x6d, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_0                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_0                    -     @9361                                                         
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[8:0]=9'h061 (Mirror: 9'h000)         
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_0[24:16]=9'h061 (Mirror: 9'h000)       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5, P_Fld(0x061, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x061, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY0_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY0_0_1                    -     @9302                                                         
      RX_ARDQ0_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ0_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ1_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ1_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY0_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET),
            P_Fld(0x6c, SHU_R0_B1_RXDLY0_RX_ARDQ0_F_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY0_RX_ARDQ1_F_DLY_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B1_RXDLY0_RX_ARDQ0_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY0_RX_ARDQ1_R_DLY_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY1_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY1_0_1                    -     @9316                                                         
      RX_ARDQ2_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ2_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ3_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ3_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY1_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY1+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B1_RXDLY1_RX_ARDQ2_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY1_RX_ARDQ2_F_DLY_B1) | P_Fld(0x6c, SHU_R0_B1_RXDLY1_RX_ARDQ3_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY1_RX_ARDQ3_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY2_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY2_0_1                    -     @9330                                                         
      RX_ARDQ4_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ4_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ5_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ5_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY2_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY2+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B1_RXDLY2_RX_ARDQ4_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY2_RX_ARDQ4_F_DLY_B1) | P_Fld(0x6c, SHU_R0_B1_RXDLY2_RX_ARDQ5_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY2_RX_ARDQ5_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY3_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY3_0_1                    -     @9344                                                         
      RX_ARDQ6_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQ6_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[15:8]=8'h6c (Mirror: 8'h00)          
      RX_ARDQ7_R_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[23:16]=8'h6c (Mirror: 8'h00)         
      RX_ARDQ7_F_DLY_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY3_0_1[31:24]=8'h6c (Mirror: 8'h00)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY3+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B1_RXDLY3_RX_ARDQ6_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY3_RX_ARDQ6_F_DLY_B1) | P_Fld(0x6c, SHU_R0_B1_RXDLY3_RX_ARDQ7_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY3_RX_ARDQ7_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY4_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY4_0_1                    -     @9356                                                         
      RX_ARDQM0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[7:0]=8'h6c (Mirror: 8'h00)           
      RX_ARDQM0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY4_0_1[15:8]=8'h6c (Mirror: 8'h00)          
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY4+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x6c, SHU_R0_B1_RXDLY4_RX_ARDQM0_R_DLY_B1) |
            P_Fld(0x6c, SHU_R0_B1_RXDLY4_RX_ARDQM0_F_DLY_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_RXDLY5_0_1                           ral_reg_DDRPHY_blk_SHU_R0_B1_RXDLY5_0_1                    -     @9366                                                         
      RX_ARDQS0_R_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[8:0]=9'h060 (Mirror: 9'h000)         
      RX_ARDQS0_F_DLY_B1                           uvm_reg_field                                              ...    RW SHU_R0_B1_RXDLY5_0_1[24:16]=9'h060 (Mirror: 9'h000)       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_RXDLY5+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x060, SHU_R0_B1_RXDLY5_RX_ARDQS0_R_DLY_B1) |
            P_Fld(0x060, SHU_R0_B1_RXDLY5_RX_ARDQS0_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ9                                         ral_reg_DDRPHY_blk_B0_DQ9                                  -     @7782                                                         
      RG_RX_ARDQ_STBEN_RESETB_B0                   uvm_reg_field                                              ...    RW B0_DQ9[0:0]=1'h1 (Mirror: 1'h0)                           
      RG_RX_ARDQS0_STBEN_RESETB_B0                 uvm_reg_field                                              ...    RW B0_DQ9[4:4]=1'h0                                          
      RG_RX_ARDQS0_DQSIENMODE_B0                   uvm_reg_field                                              ...    RW B0_DQ9[5:5]=1'h0                                          
      R_DMRXDVS_R_F_DLY_RK_OPT_B0                  uvm_reg_field                                              ...    RW B0_DQ9[6:6]=1'h1                                          
      R_DMRXFIFO_STBENCMP_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ9[7:7]=1'h0                                          
      R_IN_GATE_EN_LOW_OPT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[15:8]=8'h00                                        
      R_DMDQSIEN_VALID_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[18:16]=3'h0                                        
      R_DMDQSIEN_RDSEL_LAT_B0                      uvm_reg_field                                              ...    RW B0_DQ9[22:20]=3'h0                                        
      R_DMRXDVS_VALID_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[26:24]=3'h0                                        
      R_DMRXDVS_RDSEL_LAT_B0                       uvm_reg_field                                              ...    RW B0_DQ9[30:28]=3'h0                                        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ9, P_Fld(0x1, B0_DQ9_RG_RX_ARDQ_STBEN_RESETB_B0) |
            P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ9_RG_RX_ARDQS0_DQSIENMODE_B0) |
            P_Fld(0x1, B0_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXFIFO_STBENCMP_EN_B0) |
            P_Fld(0x00, B0_DQ9_R_IN_GATE_EN_LOW_OPT_B0) | P_Fld(0x0, B0_DQ9_R_DMDQSIEN_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMDQSIEN_RDSEL_LAT_B0) | P_Fld(0x0, B0_DQ9_R_DMRXDVS_VALID_LAT_B0) |
            P_Fld(0x0, B0_DQ9_R_DMRXDVS_RDSEL_LAT_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ9                                         ral_reg_DDRPHY_blk_B1_DQ9                                  -     @9189                                                         
      RG_RX_ARDQ_STBEN_RESETB_B1                   uvm_reg_field                                              ...    RW B1_DQ9[0:0]=1'h1 (Mirror: 1'h0)                           
      RG_RX_ARDQS0_STBEN_RESETB_B1                 uvm_reg_field                                              ...    RW B1_DQ9[4:4]=1'h0                                          
      RG_RX_ARDQS0_DQSIENMODE_B1                   uvm_reg_field                                              ...    RW B1_DQ9[5:5]=1'h0                                          
      R_DMRXDVS_R_F_DLY_RK_OPT_B1                  uvm_reg_field                                              ...    RW B1_DQ9[6:6]=1'h1                                          
      R_DMRXFIFO_STBENCMP_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ9[7:7]=1'h0                                          
      R_IN_GATE_EN_LOW_OPT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[15:8]=8'h00                                        
      R_DMDQSIEN_VALID_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[18:16]=3'h0                                        
      R_DMDQSIEN_RDSEL_LAT_B1                      uvm_reg_field                                              ...    RW B1_DQ9[22:20]=3'h0                                        
      R_DMRXDVS_VALID_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[26:24]=3'h0                                        
      R_DMRXDVS_RDSEL_LAT_B1                       uvm_reg_field                                              ...    RW B1_DQ9[30:28]=3'h0                                        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ9, P_Fld(0x1, B1_DQ9_RG_RX_ARDQ_STBEN_RESETB_B1) |
            P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ9_RG_RX_ARDQS0_DQSIENMODE_B1) |
            P_Fld(0x1, B1_DQ9_R_DMRXDVS_R_F_DLY_RK_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXFIFO_STBENCMP_EN_B1) |
            P_Fld(0x00, B1_DQ9_R_IN_GATE_EN_LOW_OPT_B1) | P_Fld(0x0, B1_DQ9_R_DMDQSIEN_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMDQSIEN_RDSEL_LAT_B1) | P_Fld(0x0, B1_DQ9_R_DMRXDVS_VALID_LAT_B1) |
            P_Fld(0x0, B1_DQ9_R_DMRXDVS_RDSEL_LAT_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ4                                         ral_reg_DDRPHY_blk_B0_DQ4                                  -     @7711                                                         
      RG_RX_ARDQS_EYE_R_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[6:0]=7'h75 (Mirror: 7'h00)                         
      RG_RX_ARDQS_EYE_F_DLY_B0                     uvm_reg_field                                              ...    RW B0_DQ4[14:8]=7'h75 (Mirror: 7'h00)                        
      RG_RX_ARDQ_EYE_R_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[21:16]=6'h2d (Mirror: 6'h00)                       
      RG_RX_ARDQ_EYE_F_DLY_B0                      uvm_reg_field                                              ...    RW B0_DQ4[29:24]=6'h2d (Mirror: 6'h00)                       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ4, P_Fld(0x75, B0_DQ4_RG_RX_ARDQS_EYE_R_DLY_B0) |
            P_Fld(0x75, B0_DQ4_RG_RX_ARDQS_EYE_F_DLY_B0) | P_Fld(0x2d, B0_DQ4_RG_RX_ARDQ_EYE_R_DLY_B0) |
            P_Fld(0x2d, B0_DQ4_RG_RX_ARDQ_EYE_F_DLY_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ4                                         ral_reg_DDRPHY_blk_B1_DQ4                                  -     @9118                                                         
      RG_RX_ARDQS_EYE_R_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[6:0]=7'h75 (Mirror: 7'h00)                         
      RG_RX_ARDQS_EYE_F_DLY_B1                     uvm_reg_field                                              ...    RW B1_DQ4[14:8]=7'h75 (Mirror: 7'h00)                        
      RG_RX_ARDQ_EYE_R_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[21:16]=6'h2d (Mirror: 6'h00)                       
      RG_RX_ARDQ_EYE_F_DLY_B1                      uvm_reg_field                                              ...    RW B1_DQ4[29:24]=6'h2d (Mirror: 6'h00)                       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ4, P_Fld(0x75, B1_DQ4_RG_RX_ARDQS_EYE_R_DLY_B1) |
            P_Fld(0x75, B1_DQ4_RG_RX_ARDQS_EYE_F_DLY_B1) | P_Fld(0x2d, B1_DQ4_RG_RX_ARDQ_EYE_R_DLY_B1) |
            P_Fld(0x2d, B1_DQ4_RG_RX_ARDQ_EYE_F_DLY_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B0_DQ5                                         ral_reg_DDRPHY_blk_B0_DQ5                                  -     @7718                                                         
      RG_RX_ARDQ_EYE_VREF_SEL_B0                   uvm_reg_field                                              ...    RW B0_DQ5[13:8]=6'h0e                                        
      RG_RX_ARDQ_VREF_EN_B0                        uvm_reg_field                                              ...    RW B0_DQ5[16:16]=1'h0                                        
      RG_RX_ARDQ_EYE_VREF_EN_B0                    uvm_reg_field                                              ...    RW B0_DQ5[17:17]=1'h0                                        
      RG_RX_ARDQ_EYE_SEL_B0                        uvm_reg_field                                              ...    RW B0_DQ5[23:20]=4'h0                                        
      RG_RX_ARDQ_EYE_EN_B0                         uvm_reg_field                                              ...    RW B0_DQ5[24:24]=1'h0                                        
      RG_RX_ARDQ_EYE_STBEN_RESETB_B0               uvm_reg_field                                              ...    RW B0_DQ5[25:25]=1'h1 (Mirror: 1'h0)                         
      RG_RX_ARDQS0_DVS_EN_B0                       uvm_reg_field                                              ...    RW B0_DQ5[31:31]=1'h0                                        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B0_DQ5, P_Fld(0x0e, B0_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B0) |
            P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_VREF_EN_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B0) |
            P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_SEL_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQ_EYE_EN_B0) |
            P_Fld(0x1, B0_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B0) | P_Fld(0x0, B0_DQ5_RG_RX_ARDQS0_DVS_EN_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    B1_DQ5                                         ral_reg_DDRPHY_blk_B1_DQ5                                  -     @9125                                                         
      RG_RX_ARDQ_EYE_VREF_SEL_B1                   uvm_reg_field                                              ...    RW B1_DQ5[13:8]=6'h0e                                        
      RG_RX_ARDQ_VREF_EN_B1                        uvm_reg_field                                              ...    RW B1_DQ5[16:16]=1'h0                                        
      RG_RX_ARDQ_EYE_VREF_EN_B1                    uvm_reg_field                                              ...    RW B1_DQ5[17:17]=1'h0                                        
      RG_RX_ARDQ_EYE_SEL_B1                        uvm_reg_field                                              ...    RW B1_DQ5[23:20]=4'h0                                        
      RG_RX_ARDQ_EYE_EN_B1                         uvm_reg_field                                              ...    RW B1_DQ5[24:24]=1'h0                                        
      RG_RX_ARDQ_EYE_STBEN_RESETB_B1               uvm_reg_field                                              ...    RW B1_DQ5[25:25]=1'h1 (Mirror: 1'h0)                         
      RG_RX_ARDQS0_DVS_EN_B1                       uvm_reg_field                                              ...    RW B1_DQ5[31:31]=1'h0                                        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_B1_DQ5, P_Fld(0x0e, B1_DQ5_RG_RX_ARDQ_EYE_VREF_SEL_B1) |
            P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_VREF_EN_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_VREF_EN_B1) |
            P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_SEL_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQ_EYE_EN_B1) |
            P_Fld(0x1, B1_DQ5_RG_RX_ARDQ_EYE_STBEN_RESETB_B1) | P_Fld(0x0, B1_DQ5_RG_RX_ARDQS0_DVS_EN_B1));
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX input delay line set EXIT
    //    Exit body
}


void sv_algorithm_assistance_LP4_4266(DRAMC_CTX_T *p)
{
    //    Enter body
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Enter:
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RDSEL_TRACK_0                         ral_reg_DDRPHY_blk_SHU_MISC_RDSEL_TRACK_0                  -     @13241                                                     
      DMDATLAT_i                                   uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[4:0]=5'h10 (Mirror: 5'h00)      
      RDSEL_HWSAVE_MSK                             uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[6:6]=1'h1 (Mirror: 1'h0)        
      RDSEL_TRACK_EN                               uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[7:7]=1'h0                       
      SHU_GW_THRD_NEG                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[19:8]=12'hfcb (Mirror: 12'h000) 
      SHU_GW_THRD_POS                              uvm_reg_field                                              ...    RW SHU_MISC_RDSEL_TRACK_0[31:20]=12'h035 (Mirror: 12'h000)
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RDSEL_TRACK, P_Fld(0x10, SHU_MISC_RDSEL_TRACK_DMDATLAT_I) |
            P_Fld(0x1, SHU_MISC_RDSEL_TRACK_RDSEL_HWSAVE_MSK) | P_Fld(0x0, SHU_MISC_RDSEL_TRACK_RDSEL_TRACK_EN) |
            P_Fld(0xfcb, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_NEG) | P_Fld(0x035, SHU_MISC_RDSEL_TRACK_SHU_GW_THRD_POS));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RDAT_0                                ral_reg_DDRPHY_blk_MISC_SHU_RDAT_0                         -     @13111                                                     
      DATLAT                                       uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[4:0]=5'h10 (Mirror: 5'h00)             
      DATLAT_DSEL                                  uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[12:8]=5'h0f (Mirror: 5'h00)            
      DATLAT_DSEL_PHY                              uvm_reg_field                                              ...    RW MISC_SHU_RDAT_0[20:16]=5'h0f (Mirror: 5'h00)           
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RDAT, P_Fld(0x10, MISC_SHU_RDAT_DATLAT) |
            P_Fld(0x0f, MISC_SHU_RDAT_DATLAT_DSEL) | P_Fld(0x0f, MISC_SHU_RDAT_DATLAT_DSEL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_PHY_RX_CTRL_0                         ral_reg_DDRPHY_blk_MISC_SHU_PHY_RX_CTRL_0                  -     @13047                                                     
      RANK_RXDLY_UPDLAT_EN                         uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[8:8]=1'h1 (Mirror: 1'h0)        
      RANK_RXDLY_UPD_OFFSET                        uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[11:9]=3'h2 (Mirror: 3'h0)       
      RX_IN_GATE_EN_PRE_OFFSET                     uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[15:14]=2'h2 (Mirror: 2'h0)      
      RX_IN_GATE_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[18:16]=3'h1 (Mirror: 3'h0)      
      RX_IN_GATE_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[22:20]=3'h1 (Mirror: 3'h0)      
      RX_IN_BUFF_EN_HEAD                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[26:24]=3'h2 (Mirror: 3'h0)      
      RX_IN_BUFF_EN_TAIL                           uvm_reg_field                                              ...    RW MISC_SHU_PHY_RX_CTRL_0[30:28]=3'h0                     
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_PHY_RX_CTRL, P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPDLAT_EN) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RANK_RXDLY_UPD_OFFSET) | P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_PRE_OFFSET) |
            P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_HEAD) | P_Fld(0x1, MISC_SHU_PHY_RX_CTRL_RX_IN_GATE_EN_TAIL) |
            P_Fld(0x2, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_HEAD) | P_Fld(0x0, MISC_SHU_PHY_RX_CTRL_RX_IN_BUFF_EN_TAIL));
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANKCTL_0                             ral_reg_DDRPHY_blk_MISC_SHU_RANKCTL_0                      -     @13037                                                     
      RANKINCTL_RXDLY                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[3:0]=4'h4 (Mirror: 4'h0)            
      RANK_RXDLY_OPT                               uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[4:4]=1'h1                           
      RANKSEL_SELPH_FRUN                           uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[15:15]=1'h1 (Mirror: 1'h0)          
      RANKINCTL_STB                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[19:16]=4'h6 (Mirror: 4'h0)          
      RANKINCTL                                    uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[23:20]=4'h5 (Mirror: 4'h0)          
      RANKINCTL_ROOT1                              uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[27:24]=4'h5 (Mirror: 4'h0)          
      RANKINCTL_PHY                                uvm_reg_field                                              ...    RW MISC_SHU_RANKCTL_0[31:28]=4'h8 (Mirror: 4'h0)          
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x4, MISC_SHU_RANKCTL_RANKINCTL_RXDLY) |
            P_Fld(0x1, MISC_SHU_RANKCTL_RANK_RXDLY_OPT) | P_Fld(0x1, MISC_SHU_RANKCTL_RANKSEL_SELPH_FRUN) |
            P_Fld(0x6, MISC_SHU_RANKCTL_RANKINCTL_STB));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANKCTL, P_Fld(0x5, MISC_SHU_RANKCTL_RANKINCTL) |
            P_Fld(0x5, MISC_SHU_RANKCTL_RANKINCTL_ROOT1) | P_Fld(0x8, MISC_SHU_RANKCTL_RANKINCTL_PHY));
    #endif
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RANK_SEL_LAT_0                        ral_reg_DDRPHY_blk_MISC_SHU_RANK_SEL_LAT_0                 -     @13264                                                     
      RANK_SEL_LAT_B0                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[3:0]=4'h2 (Mirror: 4'h0)       
      RANK_SEL_LAT_B1                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[7:4]=4'h2 (Mirror: 4'h0)       
      RANK_SEL_LAT_CA                              uvm_reg_field                                              ...    RW MISC_SHU_RANK_SEL_LAT_0[11:8]=4'h2 (Mirror: 4'h0)      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RANK_SEL_LAT, P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B0) |
            P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_B1) | P_Fld(0x2, MISC_SHU_RANK_SEL_LAT_RANK_SEL_LAT_CA));

    #if !CODE_SIZE_REDUCE
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_0                  -     @12858                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_0[3:0]=4'h7 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL, 0x7, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                      
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCTL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCTL_0_1                  -     @12862                                                     
      DQSINCTL                                     uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCTL_0_1[3:0]=4'h7 (Mirror: 4'h0)        
    ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_RK_DQSCTL+(1*DDRPHY_AO_RANK_OFFSET), 0x7, MISC_SHU_RK_DQSCTL_DQSINCTL);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0         -     @8012                                                         
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h1 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h5 (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY, P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0x5, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_0             -     @8026                                                         
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_0[6:0]=7'h01 (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY, 0x01, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1         -     @8019                                                         
      DQSIEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h9 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'hd (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x9, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B0) |
            P_Fld(0xd, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B0) |
            P_Fld(0x1, SHU_RK_B0_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B0_DQSIEN_PI_DLY_0_1             -     @8030                                                         
      DQSIEN_PI_B0                                 uvm_reg_field                                              ...    RW SHU_RK_B0_DQSIEN_PI_DLY_0_1[6:0]=7'h08 (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B0_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x08, SHU_RK_B0_DQSIEN_PI_DLY_DQSIEN_PI_B0);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0         -     @9435                                                         
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[3:0]=4'h1 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[7:4]=4'h5 (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_0[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY, P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0x5, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_0                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_0             -     @9449                                                         
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_0[6:0]=7'h01 (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY, 0x01, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1         -     @9442                                                         
      DQSIEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[3:0]=4'h9 (Mirror: 4'h0)  
      DQSIEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[7:4]=4'hd (Mirror: 4'h0)  
      DQSIEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[19:16]=4'h1 (Mirror: 4'h0)
      DQSIEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_MCK_UI_DLY_0_1[23:20]=4'h1 (Mirror: 4'h0)
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_DQSIEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x9, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P0_B1) |
            P_Fld(0xd, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P0_B1) |
            P_Fld(0x1, SHU_RK_B1_DQSIEN_MCK_UI_DLY_DQSIEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_DQSIEN_PI_DLY_0_1                    ral_reg_DDRPHY_blk_SHU_RK_B1_DQSIEN_PI_DLY_0_1             -     @9453                                                         
      DQSIEN_PI_B1                                 uvm_reg_field                                              ...    RW SHU_RK_B1_DQSIEN_PI_DLY_0_1[6:0]=7'h08 (Mirror: 7'h00)    
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldAlign(DDRPHY_REG_SHU_RK_B1_DQSIEN_PI_DLY+(1*DDRPHY_AO_RANK_OFFSET), 0x08, SHU_RK_B1_DQSIEN_PI_DLY_DQSIEN_PI_B1);
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_ODTCTRL_0                             ral_reg_DDRPHY_blk_MISC_SHU_ODTCTRL_0                      -     @13057                                                        
      RODTEN                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[0:0]=1'h1 (Mirror: 1'h0)               
      RODTENSTB_SELPH_CG_IG                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[1:1]=1'h0                              
      RODT_LAT                                     uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[7:4]=4'h7 (Mirror: 4'h0)               
      RODTEN_SELPH_FRUN                            uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[15:15]=1'h0                            
      RODTDLY_LAT_OPT                              uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[25:24]=2'h0                            
      FIXRODT                                      uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[27:27]=1'h0                            
      RODTEN_OPT                                   uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[29:29]=1'h1                            
      RODTE2                                       uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[30:30]=1'h1 (Mirror: 1'h0)             
      RODTE                                        uvm_reg_field                                              ...    RW MISC_SHU_ODTCTRL_0[31:31]=1'h1 (Mirror: 1'h0)             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_ODTCTRL, P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG) | P_Fld(0x0, MISC_SHU_ODTCTRL_RODTEN_SELPH_FRUN) |
            P_Fld(0x0, MISC_SHU_ODTCTRL_RODTDLY_LAT_OPT) | P_Fld(0x0, MISC_SHU_ODTCTRL_FIXRODT) |
            P_Fld(0x1, MISC_SHU_ODTCTRL_RODTEN_OPT) | P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE2) |
            P_Fld(0x1, MISC_SHU_ODTCTRL_RODTE));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldAlign(DDRPHY_REG_MISC_SHU_ODTCTRL, 0x7, MISC_SHU_ODTCTRL_RODT_LAT);
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B0_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B0_DQ7_0                            -     @8204                                                         
      R_DMRANKRXDVS_B0                             uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[3:0]=4'h0                                    
      R_DMDQMDBI_EYE_SHU_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[6:6]=1'h0                                    
      R_DMDQMDBI_SHU_B0                            uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[7:7]=1'h0                                    
      R_DMRXDVS_DQM_FLAGSEL_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[11:8]=4'h0                                   
      R_DMRXDVS_PBYTE_FLAG_OPT_B0                  uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[12:12]=1'h0                                  
      R_DMRXDVS_PBYTE_DQM_EN_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[13:13]=1'h0                                  
      R_DMRXTRACK_DQM_EN_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[14:14]=1'h0                                  
      R_DMRODTEN_B0                                uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
      R_DMARPI_CG_FB2DLL_DCM_EN_B0                 uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[16:16]=1'h0                                  
      R_DMTX_ARPI_CG_DQ_NEW_B0                     uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[17:17]=1'h0                                  
      R_DMTX_ARPI_CG_DQS_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[18:18]=1'h0                                  
      R_DMTX_ARPI_CG_DQM_NEW_B0                    uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[19:19]=1'h0                                  
      R_LP4Y_SDN_MODE_DQS0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[20:20]=1'h0                                  
      R_DMRXRANK_DQ_EN_B0                          uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQ_LAT_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[27:25]=3'h2 (Mirror: 3'h0)                   
      R_DMRXRANK_DQS_EN_B0                         uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQS_LAT_B0                        uvm_reg_field                                              ...    RW SHU_B0_DQ7_0[31:29]=3'h1 (Mirror: 3'h0)                   
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B0_DQ7, P_Fld(0x0, SHU_B0_DQ7_R_DMRANKRXDVS_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_EYE_SHU_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMDQMDBI_SHU_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_DQM_FLAGSEL_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMRXTRACK_DQM_EN_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRODTEN_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0) |
            P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0) | P_Fld(0x0, SHU_B0_DQ7_R_LP4Y_SDN_MODE_DQS0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQ_EN_B0) | P_Fld(0x2, SHU_B0_DQ7_R_DMRXRANK_DQ_LAT_B0) |
            P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQS_EN_B0) | P_Fld(0x1, SHU_B0_DQ7_R_DMRXRANK_DQS_LAT_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_B1_DQ7_0                                   ral_reg_DDRPHY_blk_SHU_B1_DQ7_0                            -     @9627                                                         
      R_DMRANKRXDVS_B1                             uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[3:0]=4'h0                                    
      R_DMDQMDBI_EYE_SHU_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[6:6]=1'h0                                    
      R_DMDQMDBI_SHU_B1                            uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[7:7]=1'h0                                    
      R_DMRXDVS_DQM_FLAGSEL_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[11:8]=4'h0                                   
      R_DMRXDVS_PBYTE_FLAG_OPT_B1                  uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[12:12]=1'h0                                  
      R_DMRXDVS_PBYTE_DQM_EN_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[13:13]=1'h0                                  
      R_DMRXTRACK_DQM_EN_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[14:14]=1'h0                                  
      R_DMRODTEN_B1                                uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[15:15]=1'h1 (Mirror: 1'h0)                   
      R_DMARPI_CG_FB2DLL_DCM_EN_B1                 uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[16:16]=1'h0                                  
      R_DMTX_ARPI_CG_DQ_NEW_B1                     uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[17:17]=1'h0                                  
      R_DMTX_ARPI_CG_DQS_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[18:18]=1'h0                                  
      R_DMTX_ARPI_CG_DQM_NEW_B1                    uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[19:19]=1'h0                                  
      R_LP4Y_SDN_MODE_DQS1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[20:20]=1'h0                                  
      R_DMRXRANK_DQ_EN_B1                          uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[24:24]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQ_LAT_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[27:25]=3'h2 (Mirror: 3'h0)                   
      R_DMRXRANK_DQS_EN_B1                         uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[28:28]=1'h1 (Mirror: 1'h0)                   
      R_DMRXRANK_DQS_LAT_B1                        uvm_reg_field                                              ...    RW SHU_B1_DQ7_0[31:29]=3'h1 (Mirror: 3'h0)                   
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_B1_DQ7, P_Fld(0x0, SHU_B1_DQ7_R_DMRANKRXDVS_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_EYE_SHU_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMDQMDBI_SHU_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_DQM_FLAGSEL_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_FLAG_OPT_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMRXDVS_PBYTE_DQM_EN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMRXTRACK_DQM_EN_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRODTEN_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMARPI_CG_FB2DLL_DCM_EN_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1) |
            P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1) | P_Fld(0x0, SHU_B1_DQ7_R_LP4Y_SDN_MODE_DQS1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQ_EN_B1) | P_Fld(0x2, SHU_B1_DQ7_R_DMRXRANK_DQ_LAT_B1) |
            P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQS_EN_B1) | P_Fld(0x1, SHU_B1_DQ7_R_DMRXRANK_DQS_LAT_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0         -     @8034                                                         
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h4 (Mirror: 3'h0)  
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h4 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY, P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1         -     @8041                                                         
      RODTEN_UI_P0_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h4 (Mirror: 3'h0)  
      RODTEN_UI_P1_B0                              uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h4 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P1_B0                             uvm_reg_field                                              ...    RW SHU_RK_B0_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B0_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B0) |
            P_Fld(0x4, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B0) | P_Fld(0x1, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B0) |
            P_Fld(0x0, SHU_RK_B0_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0         -     @9457                                                         
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[2:0]=3'h4 (Mirror: 3'h0)  
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[6:4]=3'h4 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[18:16]=3'h0               
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_0[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY, P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1                ral_reg_DDRPHY_blk_SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1         -     @9464                                                         
      RODTEN_UI_P0_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[2:0]=3'h4 (Mirror: 3'h0)  
      RODTEN_UI_P1_B1                              uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[6:4]=3'h4 (Mirror: 3'h0)  
      RODTEN_MCK_P0_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[18:16]=3'h1 (Mirror: 3'h0)
      RODTEN_MCK_P1_B1                             uvm_reg_field                                              ...    RW SHU_RK_B1_RODTEN_MCK_UI_DLY_0_1[22:20]=3'h0               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_RK_B1_RODTEN_MCK_UI_DLY+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P0_B1) |
            P_Fld(0x4, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_UI_P1_B1) | P_Fld(0x1, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P0_B1) |
            P_Fld(0x0, SHU_RK_B1_RODTEN_MCK_UI_DLY_RODTEN_MCK_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_RX_CG_SET0_0                               ral_reg_DRAMC_blk_SHU_RX_CG_SET0_0                         -     @5361                                                         
      DLE_LAST_EXTEND3                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[0:0]=1'h0                                
      READ_START_EXTEND3                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[1:1]=1'h0                                
      DLE_LAST_EXTEND2                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[2:2]=1'h1 (Mirror: 1'h0)                 
      READ_START_EXTEND2                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[3:3]=1'h1 (Mirror: 1'h0)                 
      DLE_LAST_EXTEND1                             uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[4:4]=1'h1 (Mirror: 1'h0)                 
      READ_START_EXTEND1                           uvm_reg_field                                              ...    RW SHU_RX_CG_SET0_0[5:5]=1'h1 (Mirror: 1'h0)                 
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DRAMC_REG_SHU_RX_CG_SET0, P_Fld(0x0, SHU_RX_CG_SET0_DLE_LAST_EXTEND3) |
            P_Fld(0x0, SHU_RX_CG_SET0_READ_START_EXTEND3) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND2) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND2) | P_Fld(0x1, SHU_RX_CG_SET0_DLE_LAST_EXTEND1) |
            P_Fld(0x1, SHU_RX_CG_SET0_READ_START_EXTEND1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_MISC_RANK_SEL_STB_0                        ral_reg_DDRPHY_blk_SHU_MISC_RANK_SEL_STB_0                 -     @13227                                                        
      RANK_SEL_STB_EN                              uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[0:0]=1'h1 (Mirror: 1'h0)          
      RANK_SEL_STB_EN_B23                          uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[1:1]=1'h0                         
      RANK_SEL_STB_SERMODE                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[3:2]=2'h0                         
      RANK_SEL_STB_TRACK                           uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[4:4]=1'h1 (Mirror: 1'h0)          
      RANK_SEL_RXDLY_TRACK                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[5:5]=1'h0                         
      RANK_SEL_STB_PHASE_EN                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[7:7]=1'h0                         
      RANK_SEL_PHSINCTL                            uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[11:8]=4'h6 (Mirror: 4'h0)         
      RANK_SEL_STB_UI_PLUS                         uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[19:16]=4'h0                       
      RANK_SEL_STB_MCK_PLUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[23:20]=4'h0                       
      RANK_SEL_STB_UI_MINUS                        uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[27:24]=4'h2 (Mirror: 4'h0)        
      RANK_SEL_STB_MCK_MINUS                       uvm_reg_field                                              ...    RW SHU_MISC_RANK_SEL_STB_0[31:28]=4'h0                       
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_MISC_RANK_SEL_STB, P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_EN_B23) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_SERMODE) |
            P_Fld(0x1, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_TRACK) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_RXDLY_TRACK) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_PHASE_EN) | P_Fld(0x6, SHU_MISC_RANK_SEL_STB_RANK_SEL_PHSINCTL) |
            P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_PLUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_PLUS) |
            P_Fld(0x2, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_UI_MINUS) | P_Fld(0x0, SHU_MISC_RANK_SEL_STB_RANK_SEL_STB_MCK_MINUS));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_0                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_0                  -     @12876                                                        
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[6:0]=7'h60 (Mirror: 7'h00)         
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[7:7]=1'h1 (Mirror: 1'h0)           
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[14:8]=7'h3f (Mirror: 7'h00)        
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_0[15:15]=1'h1 (Mirror: 1'h0)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL, P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    MISC_SHU_RK_DQSCAL_0_1                         ral_reg_DDRPHY_blk_MISC_SHU_RK_DQSCAL_0_1                  -     @12883                                                        
      DQSIENLLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[6:0]=7'h60 (Mirror: 7'h00)         
      DQSIENLLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[7:7]=1'h1 (Mirror: 1'h0)           
      DQSIENHLMT                                   uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[14:8]=7'h3f (Mirror: 7'h00)        
      DQSIENHLMTEN                                 uvm_reg_field                                              ...    RW MISC_SHU_RK_DQSCAL_0_1[15:15]=1'h1 (Mirror: 1'h0)         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_MISC_SHU_RK_DQSCAL+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x60, MISC_SHU_RK_DQSCAL_DQSIENLLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENLLMTEN) | P_Fld(0x3f, MISC_SHU_RK_DQSCAL_DQSIENHLMT) |
            P_Fld(0x1, MISC_SHU_RK_DQSCAL_DQSIENHLMTEN));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_0                  -     @7990                                                         
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[6:0]=7'h01 (Mirror: 7'h00)         
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_0[15:8]=8'h11 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI, P_Fld(0x01, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x11, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_0                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_0                  -     @9413                                                         
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[6:0]=7'h01 (Mirror: 7'h00)         
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_0[15:8]=8'h11 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI, P_Fld(0x01, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x11, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B0_INI_UIPI_0_1                  -     @7995                                                         
      CURR_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[6:0]=7'h08 (Mirror: 7'h00)         
      CURR_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_INI_UIPI_0_1[15:8]=8'h19 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B0_INI_UIPI_CURR_INI_PI_B0) |
            P_Fld(0x19, SHU_R0_B0_INI_UIPI_CURR_INI_UI_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_INI_UIPI_0_1                         ral_reg_DDRPHY_blk_SHU_R0_B1_INI_UIPI_0_1                  -     @9418                                                         
      CURR_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[6:0]=7'h08 (Mirror: 7'h00)         
      CURR_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_INI_UIPI_0_1[15:8]=8'h19 (Mirror: 8'h00)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_INI_UIPI_CURR_INI_PI_B1) |
            P_Fld(0x19, SHU_R0_B1_INI_UIPI_CURR_INI_UI_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_0             -     @8000                                                         
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[6:0]=7'h01 (Mirror: 7'h00)    
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[15:8]=8'h11 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_0[31:24]=8'h15 (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI, P_Fld(0x01, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x11, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x15, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_0                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_0             -     @9423                                                         
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[6:0]=7'h01 (Mirror: 7'h00)    
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[15:8]=8'h11 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_0[31:24]=8'h15 (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI, P_Fld(0x01, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x11, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x15, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B0_NEXT_INI_UIPI_0_1             -     @8006                                                         
      NEXT_INI_PI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[6:0]=7'h08 (Mirror: 7'h00)    
      NEXT_INI_UI_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[15:8]=8'h19 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B0                            uvm_reg_field                                              ...    RW SHU_R0_B0_NEXT_INI_UIPI_0_1[31:24]=8'h1d (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_PI_B0) |
            P_Fld(0x19, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_B0) | P_Fld(0x1d, SHU_R0_B0_NEXT_INI_UIPI_NEXT_INI_UI_P1_B0));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_NEXT_INI_UIPI_0_1                    ral_reg_DDRPHY_blk_SHU_R0_B1_NEXT_INI_UIPI_0_1             -     @9429                                                         
      NEXT_INI_PI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[6:0]=7'h08 (Mirror: 7'h00)    
      NEXT_INI_UI_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[15:8]=8'h19 (Mirror: 8'h00)   
      NEXT_INI_UI_P1_B1                            uvm_reg_field                                              ...    RW SHU_R0_B1_NEXT_INI_UIPI_0_1[31:24]=8'h1d (Mirror: 8'h00)  
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_NEXT_INI_UIPI+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x08, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_PI_B1) |
            P_Fld(0x19, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_B1) | P_Fld(0x1d, SHU_R0_B1_NEXT_INI_UIPI_NEXT_INI_UI_P1_B1));
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, RX data path setting Exit:
    //    ========>SHUFFLE GROUP: 0, need_fifo: 0, TX data path setting Enter:
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_0                       -     @7970                                                         
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[2:0]=3'h0                               
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[6:4]=3'h0                               
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[13:8]=6'h13 (Mirror: 6'h00)             
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[21:16]=6'h13 (Mirror: 6'h00)            
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_0[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0, P_Fld(0x13, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x13, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x00, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_0                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_0                       -     @9393                                                         
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[2:0]=3'h0                               
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[6:4]=3'h0                               
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[13:8]=6'h16 (Mirror: 6'h00)             
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[21:16]=6'h16 (Mirror: 6'h00)            
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[29:24]=6'h00                            
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_0[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0, P_Fld(0x16, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x16, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x00, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif

    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B0_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B0_DQ0_0_1                       -     @7980                                                         
      RG_RX_ARDQS0_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[2:0]=3'h0                               
      RG_RX_ARDQS0_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[6:4]=3'h0                               
      SW_ARPI_DQ_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[13:8]=6'h2b (Mirror: 6'h00)             
      SW_ARPI_DQM_B0                               uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[21:16]=6'h2b (Mirror: 6'h00)            
      ARPI_PBYTE_B0                                uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[29:24]=6'h01 (Mirror: 6'h00)            
      DA_ARPI_DDR400_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B0                  uvm_reg_field                                              ...    RW SHU_R0_B0_DQ0_0_1[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_RG_RX_ARDQS0_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B0_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B0) | P_Fld(0x0, SHU_R0_B0_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B0));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B0_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2b, SHU_R0_B0_DQ0_SW_ARPI_DQ_B0) |
            P_Fld(0x2b, SHU_R0_B0_DQ0_SW_ARPI_DQM_B0) | P_Fld(0x01, SHU_R0_B0_DQ0_ARPI_PBYTE_B0));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_R0_B1_DQ0_0_1                              ral_reg_DDRPHY_blk_SHU_R0_B1_DQ0_0_1                       -     @9403                                                         
      RG_RX_ARDQS1_R_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[2:0]=3'h0                               
      RG_RX_ARDQS1_F_DLY_DUTY                      uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[6:4]=3'h0                               
      SW_ARPI_DQ_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[13:8]=6'h2b (Mirror: 6'h00)             
      SW_ARPI_DQM_B1                               uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[21:16]=6'h2b (Mirror: 6'h00)            
      ARPI_PBYTE_B1                                uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[29:24]=6'h01 (Mirror: 6'h00)            
      DA_ARPI_DDR400_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[30:30]=1'h0                             
      DA_RX_ARDQSIEN_0D5UI_RK0_B1                  uvm_reg_field                                              ...    RW SHU_R0_B1_DQ0_0_1[31:31]=1'h0                             
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_R_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_RG_RX_ARDQS1_F_DLY_DUTY) |
            P_Fld(0x0, SHU_R0_B1_DQ0_DA_ARPI_DDR400_0D5UI_RK0_B1) | P_Fld(0x0, SHU_R0_B1_DQ0_DA_RX_ARDQSIEN_0D5UI_RK0_B1));

    #if !CODE_SIZE_REDUCE
    vIO32WriteFldMulti(DDRPHY_REG_SHU_R0_B1_DQ0+(1*DDRPHY_AO_RANK_OFFSET), P_Fld(0x2b, SHU_R0_B1_DQ0_SW_ARPI_DQ_B1) |
            P_Fld(0x2b, SHU_R0_B1_DQ0_SW_ARPI_DQM_B1) | P_Fld(0x01, SHU_R0_B1_DQ0_ARPI_PBYTE_B1));
    #endif
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_DCM_CTRL0_0                                ral_reg_DRAMC_blk_SHU_DCM_CTRL0_0                          -     @5064                                                         
      DDRPHY_CLK_EN_OPT                            uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[7:7]=1'h1 (Mirror: 1'h0)                  
      DPHY_CMD_CLKEN_EXTCNT                        uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[10:8]=3'h3                                
      DDRPHY_CLK_DYN_GATING_SEL                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[15:12]=4'h5 (Mirror: 4'h0)                
      APHYPI_CKCGL_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[19:16]=4'h2                               
      APHYPI_CKCGH_CNT                             uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[23:20]=4'h4                               
      FASTWAKE2                                    uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[29:29]=1'h0                               
      FASTWAKE                                     uvm_reg_field                                              ...    RW SHU_DCM_CTRL0_0[31:31]=1'h1                               
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_DCM_CTRL0, P_Fld(0x1, SHU_DCM_CTRL0_DDRPHY_CLK_EN_OPT) |
            P_Fld(0x3, SHU_DCM_CTRL0_DPHY_CMD_CLKEN_EXTCNT) | P_Fld(0x5, SHU_DCM_CTRL0_DDRPHY_CLK_DYN_GATING_SEL) |
            P_Fld(0x2, SHU_DCM_CTRL0_APHYPI_CKCGL_CNT) | P_Fld(0x4, SHU_DCM_CTRL0_APHYPI_CKCGH_CNT) |
            P_Fld(0x0, SHU_DCM_CTRL0_FASTWAKE2) | P_Fld(0x1, SHU_DCM_CTRL0_FASTWAKE));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHU_APHY_TX_PICG_CTRL_0                        ral_reg_DRAMC_blk_SHU_APHY_TX_PICG_CTRL_0                  -     @5416                                                         
      DDRPHY_CLK_EN_COMB_TX_PICG_CNT               uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[3:0]=4'h3 (Mirror: 4'h0)          
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[6:4]=3'h3 (Mirror: 3'h0)          
      DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0             uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[10:8]=3'h3 (Mirror: 3'h0)         
      DPHY_TX_DCM_EXTCNT                           uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[15:12]=4'h2                       
      DDRPHY_CLK_EN_COMB_TX_OPT                    uvm_reg_field                                              ...    RW SHU_APHY_TX_PICG_CTRL_0[31:31]=1'h1 (Mirror: 1'h0)        
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    */
    vIO32WriteFldMulti(DRAMC_REG_SHU_APHY_TX_PICG_CTRL, P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_PICG_CNT) |
            P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P1) | P_Fld(0x3, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_DQS_SEL_P0) |
            P_Fld(0x2, SHU_APHY_TX_PICG_CTRL_DPHY_TX_DCM_EXTCNT) | P_Fld(0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT));
    /*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    Name                                           Type                                                       Size  Value                                                         
    ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    SHURK_APHY_TX_PICG_CTRL_0_0                    ral_reg_DRAMC_blk_SHURK_APHY_TX_PICG_CTRL_0_0              -     @4954             