//#include <typedefs.h>
//#include <msdc.h>
//#include <partition.h>
//#include <pll.h>
//#include <sec_efuse.h>
#include <pmic.h>
#include <regulator/mtk_regulator.h>
#include <mt6330.h>
#include <pal_log.h>

#define EFUSE_PMIC_CONTROL_ENABLE   1

#define EFUSE_VBAT_LIMIT            3700

////////////////////////////////////////////////////////////////////////////////////
#define EFUSE_BLOW_FSOURCE_UVOL     	1800000 /* 1.8V */
#define EFUSE_BLOW_UVOL             	750000 /* 0.75V */
#define EFUSE_READ_UVOL_HIGH        	750000 /* 0.75V */
#define EFUSE_READ_UVOL_LOW         	750000 /* 0.75V */

#define EFUSE_TEST_VCORE_UVOL_MAX   	1193000 /* 1.193V */
#define EFUSE_TEST_FSOURCE_UVOL_MAX   2000000 /* 2V */

/* WDT */
extern void efuse_wdt_init(void);
extern void efuse_wdt_restart(void);
extern void efuse_wdt_sw_reset(void);
extern void efuse_wdt_hw_reset(void);

/* DDR reserved mode */
extern int efuse_dram_reserved(int enable);

/* PLL */
extern void efuse_pll_set(void);

/* Vbat */
extern int efuse_check_lowbat(void);
//extern int get_bat_sense_volt(int times);

/* Fsource */
extern unsigned int efuse_fsource_set(void);
extern unsigned int efuse_fsource_is_enabled(void);
extern unsigned int efuse_fsource_close(void);
extern unsigned int efuse_fsource_adjust(int fsource_uv);

/* Vcore */
extern unsigned int efuse_vcore_blow(void);
extern unsigned int efuse_vcore_high(void);
extern unsigned int efuse_vcore_low(void);
extern unsigned int efuse_vcore_adjust(int vcore_uv);

/* Others */
extern int efuse_module_reinit(void);
////////////////////////////////////////////////////////////////////////////////////

static const struct mtk_regulator empty_regulator;

/**************************************************************
 * WDT
 **************************************************************/
void efuse_wdt_init(void)
{
	mtk_wdt_init();
}

void efuse_wdt_restart(void)
{
	mtk_wdt_restart();
}

void efuse_wdt_sw_reset(void)
{
	platform_safe_mode(0,0);
	mtk_wdt_sw_reset();
}

void efuse_wdt_hw_reset(void)
{
//	platform_safe_mode(0,0);
	pal_log_info("Trigger HW reset after blow ..\n");
//	pmic_config_interface(PMIC_RG_CRST_ADDR, 1, PMIC_RG_CRST_MASK, PMIC_RG_CRST_SHIFT);
}

/**************************************************************
 * DDR reserved mode
 **************************************************************/
int efuse_dram_reserved(int enable)
{
	/* return 0: success, -1: fail */
	//return drm_dram_reserved(enable);
	pal_log_info("efuse_dram_reserved\n");
	return 0;
}

/**************************************************************
 * PLL
 **************************************************************/
void efuse_pll_set(void)
{
	//mt_set_topck_default();
	pal_log_info("efuse_pll_set\n");
}


/**************************************************************
 * Vbat
 **************************************************************/
int efuse_check_lowbat(void)
{
	int volt;
#if 0
	volt = get_bat_sense_volt(5);
	if (volt < EFUSE_VBAT_LIMIT)
		return 1;
	else
#endif
		return 0;
}

/****************************************************
 * Fsource
 * return 0 : success
 ****************************************************/
unsigned int efuse_fsource_set(void)
{
	unsigned int ret_val = 0;

#if EFUSE_PMIC_CONTROL_ENABLE

	/* 1.8V */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_VEFUSE_VOSEL_ADDR),
			(kal_uint32)(0x4),
			(kal_uint32)(PMIC_RG_VEFUSE_VOSEL_MASK),
			(kal_uint32)(PMIC_RG_VEFUSE_VOSEL_SHIFT)
			);

	/* +0mV */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_VEFUSE_VOCAL_ADDR),
			(kal_uint32)(0x0),
			(kal_uint32)(PMIC_RG_VEFUSE_VOCAL_MASK),
			(kal_uint32)(PMIC_RG_VEFUSE_VOCAL_SHIFT)
			);

	/* Fsource(VEFUSE) enabled */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_ADDR),
			(kal_uint32)(0x1),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_MASK),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_SHIFT)
			);

	mdelay(10);

#endif

	return ret_val;
}

unsigned int efuse_fsource_close(void)
{
	unsigned int ret_val = 0;

#if EFUSE_PMIC_CONTROL_ENABLE

	/* Fsource(VEFUSE) disable */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_ADDR),
			(kal_uint32)(0x0),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_MASK),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_SHIFT)
			);

	mdelay(10);

#endif

	return ret_val;
}

unsigned int efuse_fsource_is_enabled(void)
{
	unsigned int regVal = 0;

#if EFUSE_PMIC_CONTROL_ENABLE

	/*  Check Fsource(VEFUSE) Status */
	pmic_read_interface((kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_ADDR),
			&regVal,
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_MASK),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_SHIFT)
			);

	/* return 1 : fsource enabled
	 * return 0 : fsource disabled */

#endif

	return regVal;
}

unsigned int efuse_fsource_adjust(int fsource_uv)
{
	unsigned int ret_val = 0;

#if EFUSE_PMIC_CONTROL_ENABLE
	struct mtk_regulator reg_fsource = empty_regulator;

	if(fsource_uv == 0) {
			ret_val = efuse_fsource_close();
			return ret_val;
	}

	/* ---------- Control the vefuse ---------- */
	ret_val = mtk_regulator_get("vefuse", &reg_fsource);
	if (ret_val)
		pal_log_info("Err: fsource get\n");

	ret_val |= mtk_regulator_set_voltage(&reg_fsource, fsource_uv, EFUSE_TEST_FSOURCE_UVOL_MAX);
	if (ret_val)
		pal_log_info("Err: fsource set\n");

	mdelay(10);

	pal_log_info("fsource %d, %d\n",
		mtk_regulator_get_voltage(&reg_fsource), mtk_regulator_is_enabled(&reg_fsource));

	/* +0mV */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_VEFUSE_VOCAL_ADDR),
			(kal_uint32)(0x0),
			(kal_uint32)(PMIC_RG_VEFUSE_VOCAL_MASK),
			(kal_uint32)(PMIC_RG_VEFUSE_VOCAL_SHIFT)
			);

	/* Fsource(VEFUSE) enabled */
	ret_val |= pmic_config_interface((kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_ADDR),
			(kal_uint32)(0x1),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_MASK),
			(kal_uint32)(PMIC_RG_LDO_VEFUSE_EN_SHIFT)
			);

	mdelay(10);

#endif
	return ret_val;
}

/**************************************************************
 * Vcore
 **************************************************************/
unsigned int efuse_vcore_blow(void)
{
	int ret = 0;

#if EFUSE_PMIC_CONTROL_ENABLE

	struct mtk_regulator reg_vcore = empty_regulator;

	/* ---------- Control the vsram_others ----- don't need on mt6885 --------- */
	/*struct mtk_regulator reg_vsram_others = empty_regulator;*/
	/* Required to set VSRAM to 0.85V in MT6885 because VSRAM must be 0.1V higher than VCORE */
	/*ret = mtk_regulator_get("vsram_others", &reg_vsram_others);
	if (ret)
		pal_log_info("Err: vg1\n");
	*/
	/*
	 * The function mtk_regulator_set_voltage selects the lowest matching vsram_others
	 * from the given min_uV to max_uV. It is suggested to set max to vsram_others_max_uV.
	 */
	/*ret |= mtk_regulator_set_voltage(&reg_vsram_others, EFUSE_VSRAM_UVOL, EFUSE_VSRAM_UVOL);
	if (ret)
		pal_log_info("Err: vs1\n");

	pal_log_info("vc1 %d, %d\n",
		mtk_regulator_get_voltage(&reg_vsram_others), mtk_regulator_is_enabled(&reg_vsram_others));
	*/

	/* ---------- Control the vcore ---------- */
	ret = mtk_regulator_get("vcore", &reg_vcore);
	if (ret)
		pal_log_info("Err: vg2\n");

	/*
	 * The function mtk_regulator_set_voltage selects the lowest matching VCORE
	 * from the given min_uV to max_uV. It is suggested to set max to vcore_max_uV.
	 */
	ret |= mtk_regulator_set_voltage(&reg_vcore, EFUSE_BLOW_UVOL, EFUSE_BLOW_UVOL);
	if (ret)
		pal_log_info("Err: vs2\n");

	pal_log_info("vc2 %d, %d\n",
		mtk_regulator_get_voltage(&reg_vcore), mtk_regulator_is_enabled(&reg_vcore));

	/*
	 * VCORE and VSRAM are enabled by default.
	 * No need to enable VCORE and VSRAM again.
	 * The system cannot work with VCORE or VSRAM disabled.
	 */

	mdelay(10);

#endif

	return ret;
}

unsigned int efuse_vcore_high(void)
{
	return efuse_vcore_blow();
}

unsigned int efuse_vcore_low(void)
{
	return efuse_vcore_blow();
}

unsigned int efuse_vcore_adjust(int vcore_uv)
{
	int ret = 0;

#if EFUSE_PMIC_CONTROL_ENABLE

	struct mtk_regulator reg_vcore = empty_regulator;

	/* ---------- Control the vcore ---------- */
	ret = mtk_regulator_get("vcore", &reg_vcore);
	if (ret)
		pal_log_info("Err: vg2\n");

	/*
	 * The function mtk_regulator_set_voltage selects the lowest matching VCORE
	 * from the given min_uV to max_uV. It is suggested to set max to vcore_max_uV.
	 */
	ret |= mtk_regulator_set_voltage(&reg_vcore, vcore_uv, EFUSE_TEST_VCORE_UVOL_MAX);
	if (ret)
		pal_log_info("Err: vs2\n");

	mdelay(10);

	pal_log_info("vc2 %d, %d\n",
		mtk_regulator_get_voltage(&reg_vcore), mtk_regulator_is_enabled(&reg_vcore));

	/*
	 * VCORE and VSRAM are enabled by default.
	 * No need to enable VCORE and VSRAM again.
	 * The system cannot work with VCORE or VSRAM disabled.
	 */

#endif

	return ret;
}

/**************************************************************
 * Others
 **************************************************************/
/* re-initial modules after declinie clock */
int efuse_module_reinit(void)
{

	/*
	 * No need to do pwrap_init again because platform_pre_init -> pwrap_init_preloader -> pwrap_init
	 * has already do that!
	 */

	return 0;
}


