/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

//#if defined(__USE_GIC__)

#define 	GICV3
#if defined GICV3

#include "gic.h"

static void inline isb(void) {
    __asm__ volatile("ISB");
}

#define dsb() __asm__ __volatile__ ("dsb" : : : "memory")




/* Our default, arbitrary priority value. Linux only uses one anyway. */
#define DEFAULT_PMR_VALUE	0xf0

/* Low level accessors */
static void gic_write_pmr(unsigned int val)
{
	//asm volatile("msr_s " __stringify(ICC_PMR_EL1) ", %0" : : "r" (val));
	asm volatile("MCR p15, 0, %0, c4, c6, 0" : : "r" (val));
}

static void gic_write_ctlr(unsigned int val)
{
	//asm volatile("msr_s " __stringify(ICC_CTLR_EL1) ", %0" : : "r" (val));
	asm volatile("MCR p15, 0, %0, c12, c12, 4" : : "r" (val));
	isb();
}

static void gic_write_grpen1(unsigned int val)
{
	//asm volatile("msr_s " __stringify(ICC_GRPEN1_EL1) ", %0" : : "r" (val));
	asm volatile("MCR p15, 0, %0, c12, c12, 7" : : "r" (val));
	asm volatile("MCR p15, 0, %0, c12, c12, 6" : : "r" (val));
	isb();
}

static inline void gic_write_eoir(unsigned int irq)
{
	//asm volatile("msr_s " __stringify(ICC_EOIR1_EL1) ", %0" : : "r" (irq));
	asm volatile("MCR p15, 0, %0, c12, c12, 1" : : "r" (irq));
	isb();
}

static inline unsigned int gic_read_iar(void)
{
	unsigned int irqstat;

	//asm volatile("mrs_s %0, " __stringify(ICC_IAR1_EL1) : "=r" (irqstat));
	asm volatile("MRC p15, 0, %0, c12, c12, 0" : "=r" (irqstat));
	
	return irqstat;
}

static void gic_enable_sre(void)
{
	unsigned int val;
	unsigned int val2;

	/* Enable ICC_MSRE */
	asm volatile("cps #22");
    	asm volatile("mrc p15, 6, %0, c12, c12, 5" : "=r" (val));
	val |= (ICC_MSRE_SRE | ICC_MSRE_ENABLE);
    	asm volatile("mcr p15, 6, %0, c12, c12, 5" : : "r" (val));
    	asm volatile("cps #19");
	isb();

	asm volatile("MRC p15, 0, %0, c12, c12, 5" : "=r" (val));
	val |= ICC_SRE_EL1_SRE;
	asm volatile("MCR p15, 0, %0, c12, c12, 5" : : "r" (val));
	isb();

	asm volatile("MRC p15, 0, %0, c12, c12, 5" : "=r" (val2));
	LOGI("/n  go into gic_enable_sre, val2 is 0x%x \n", val2);
	
#if 0
	asm volatile("mrs_s %0, " (ICC_SRE_EL1) : "=r" (val));
	val |= ICC_SRE_EL1_SRE;
	asm volatile("msr_s "(ICC_SRE_EL1) ", %0" : : "r" (val));
	isb();
	
	/*
	 * Need to check that the SRE bit has actually been set. If
	 * not, it means that SRE is disabled at EL2. We're going to
	 * die painfully, and there is nothing we can do about it.
	 *
	 * Kindly inform the luser.
	 */
	asm volatile("mrs_s %0, " __stringify(ICC_SRE_EL1) : "=r" (val));
	if (!(val & ICC_SRE_EL1_SRE))
		pr_err("GIC: unable to set SRE (disabled at EL2), panic ahead\n");
#endif
}

void __bootup_slave_cpu(unsigned int cpu, unsigned int irq)
{
    int satt;
    

    //satt = (irq == CPU_BRINGUP_SGI)? 0: (1 << 15);
    satt = 0 << 15;

    /*
     * Ensure that stores to Normal memory are visible to the
     * other CPUs before issuing the IPI.
     */
         __asm__ __volatile__ ("dsb");
    *(volatile unsigned int *)(GIC_DIST_BASE + 0xf00) = (cpu << 16) | satt | irq;
        __asm__ __volatile__ ("dsb");
}
/************
void
gic_clr_pending (unsigned int irq_num)
{
  unsigned int base;
  unsigned int bit = 1 << (irq_num % 32);

  base = (irq_num / 32) * 4 + GIC_DIST_BASE + GIC_DIST_PENDING_CLEAR;

  WRITE_REG (bit, base);
}
***********/
/*
 * gic_get_irqnr: get interrupt number.
 * Return interrupt number.
 */
 #if 0
static int gic_get_irqnr(void)
{
    unsigned int irq;

    irq = gic_read_iar();

    if (irq >= 1020)
        return -1;

    return irq;
}


/*
 * gic_mask_irq: mask a given IRQ.
 * @irq: IRQ number
 */
static void gic_mask_irq(unsigned int irq)
{
    unsigned int mask = 1 << (irq % 32);

    //*(volatile unsigned int *)(GIC_DIST_BASE + GIC_DIST_ENABLE_CLEAR + (irq / 32) * 4) = mask;

	if (irq < 32)
		*(volatile unsigned int *)(GICR_SGI_BASE + GIC_DIST_ENABLE_CLEAR) = mask;
	else
		*(volatile unsigned int *)(GICD_BASE + GIC_DIST_ENABLE_CLEAR + (irq / 32) * 4) = mask;
}

/*
 * gic_unmask_irq: unmask a given IRQ.
 * @irq: IRQ number
 */
static void gic_unmask_irq(unsigned int irq)
{
    unsigned int mask = 1 << (irq % 32);

    //*(volatile unsigned int *)(GIC_DIST_BASE + GIC_DIST_ENABLE_SET + (irq / 32) * 4) = mask;
	if (irq < 32)
		*(volatile unsigned int *)(GICR_SGI_BASE + GIC_DIST_ENABLE_SET) = mask;
	else
		*(volatile unsigned int *)(GICD_BASE + GIC_DIST_ENABLE_SET + (irq / 32) * 4) = mask;
}

/*
 * gic_ack_irq: Acknowledge a given IRQ.
 * @irq: IRQ number
 */
static void gic_ack_irq(unsigned int irq)
{
    //*(volatile unsigned int *)(GIC_CPU_BASE + GIC_CPU_EOI) = irq;
    gic_write_eoir(irq);
}
#endif


/*
 * gic_init: Do initialization.
 * Return 0 if success; Return negative values if failure.
 */
int gic_init(void)
{
    	unsigned int gic_irqs, i, val;
	unsigned int mpidr, affinity;

//	LOGI("GIC_DIST_BASE is 0x%x, MCUCFG_BASE is 0x%x", GIC_DIST_BASE,MCUCFG_BASE);

	/*
	 * Find out how many interrupts are supported.
	 * The GIC only supports up to 1020 interrupt sources (SGI+PPI+SPI)
	 */
    	gic_irqs = *(volatile unsigned int *)(GICD_BASE + GICD_TYPER) & 0x1f;
	gic_irqs = (gic_irqs + 1) * 32;
	if (gic_irqs > 1020)
		gic_irqs = 1020;

	/* Disable the distributor */
    	*(volatile unsigned int *)(GICD_BASE + GICD_CTLR) = 0;
	
	/* FIXME */
	//gic_dist_wait_for_rwp();

	/*
	 * Set all global interrupts to be level triggered, active low.
	 */
	for (i = 32; i < gic_irqs; i += 16)
		*(volatile unsigned int *)(GICD_BASE + GIC_DIST_CONFIG + i / 4) = 0;

	/*
	 * Set priority on all global interrupts.
	 */
	for (i = 32; i < gic_irqs; i += 4)
        	*(volatile unsigned int *)(GICD_BASE + GIC_DIST_PRI + i) = 0xa0a0a0a0;

	/*
	 * Set all interrupts to G1S.  Leave the PPI and SGIs alone
	 * as they are set by redistributor registers.
	 */
	for (i = 32; i < gic_irqs; i += 32)
        	*(volatile unsigned int *)(GICD_BASE + GICD_IGRPMODR + i / 8) = 0xffffffff;

	/*
	 * Disable all interrupts.  Leave the PPI and SGIs alone
	 * as they are enabled by redistributor registers.
	 */
	for (i = 32; i < gic_irqs; i += 32)
        	*(volatile unsigned int *)(GICD_BASE + GIC_DIST_ENABLE_CLEAR + i / 8) = 0xffffffff;

	/* FIXME */
	//gic_dist_wait_for_rwp();

	/* FIXME */
	/* Enable distributor with ARE, Group1 */
	*(volatile unsigned int *)(GICD_BASE + GIC_DIST_CTRL) = (GICD_CTLR_ARE_NS | GICD_CTLR_ENABLE_G1S | GICD_CTLR_ENABLE_G1NS | GICD_CTLR_ENABLE_G0);

	/*
	 * Set all global interrupts to the boot CPU only. ARE must be
	 * enabled.
	 */
	mpidr = 0x0;
	affinity = mpidr;
	/*
	affinity = (MPIDR_AFFINITY_LEVEL(mpidr, 3) << 32 |
	       	    MPIDR_AFFINITY_LEVEL(mpidr, 2) << 16 |
	            MPIDR_AFFINITY_LEVEL(mpidr, 1) << 8  |
	            MPIDR_AFFINITY_LEVEL(mpidr, 0));
*/
	for (i = 32; i < gic_irqs; i++)
		*(volatile unsigned int *)(GICD_BASE + GICD_IROUTER + i * 8) = affinity;
	
	/* Wake up this CPU redistributor */
    	val = *(volatile unsigned int *)(GICR_BASE + GICR_WAKER);
	val &= ~GICR_WAKER_ProcessorSleep;
	*(volatile unsigned int *)(GICR_BASE + GICR_WAKER) = val;

	while ((*(volatile unsigned int *)(GICR_BASE + GICR_WAKER)) & GICR_WAKER_ChildrenAsleep);
	
	/*
	 * Deal with the banked PPI and SGI interrupts - disable all
	 * PPI interrupts, ensure all SGI interrupts are enabled.
	 */
	*(volatile unsigned int *)(GICR_SGI_BASE + GIC_DIST_ENABLE_CLEAR) = 0xffff0000;
	*(volatile unsigned int *)(GICR_SGI_BASE + GIC_DIST_ENABLE_SET) = 0x0000ffff;

	/*
	 * Set priority on PPI and SGI interrupts
	 */
	for (i = 0; i < 32; i += 4)
		*(volatile unsigned int *)(GICR_SGI_BASE + GIC_DIST_PRI + i) = 0xa0a0a0a0;

	/* FIXME */
	//gic_redist_wait_for_rwp();

	/* Enable system registers */
	gic_enable_sre();

	/* Set priority mask register */
	gic_write_pmr(DEFAULT_PMR_VALUE);

	/* EOI deactivates interrupt too (mode 0) */
	gic_write_ctlr(ICC_CTLR_EL1_EOImode_drop_dir);
	
	/* ... and let's hit the road... */
	gic_write_grpen1(1);

    return 0;
}

void gic_secondary_init(void)
{
    /* initialize the CPU Interface */
    *(volatile unsigned int *)(GIC_CPU_BASE + GIC_CPU_PRIMASK) = 0xf0;
    *(volatile unsigned int *)(GIC_CPU_BASE + GIC_CPU_CTRL) = 0x1;
}

void gic_raise_software_irq(unsigned int map, unsigned int irq)
{
    /*
     * Ensure that stores to Normal memory are visible to the
     * other CPUs before issuing the IPI.
     */
    dsb();
  
    *(volatile unsigned int *)(GIC_DIST_BASE + GIC_DIST_SOFTINT) = map << 16 | irq;
}



#endif

