#ifndef __DRAMC_CH0_NAO_REG_H__
#define __DRAMC_CH0_NAO_REG_H__

/* ----------------- Register Definitions ------------------- */
#define TESTMODE					0x00000000
	#define TESTMODE_TESTM_PAT0			GENMASK(31, 24)
#define LBWDAT0						0x00000004
	#define LBWDAT0_LBWDATA0			GENMASK(31, 0)
#define LBWDAT1						0x00000008
	#define LBWDAT1_LBWDATA1			GENMASK(31, 0)
#define LBWDAT2						0x0000000c
	#define LBWDAT2_LBWDATA2			GENMASK(31, 0)
#define LBWDAT3						0x00000010
	#define LBWDAT3_LBWDATA3			GENMASK(31, 0)
#define CKPHCHK						0x00000020
	#define CKPHCHK_CKPHCHKCYC			GENMASK(15, 0)
	#define CKPHCHK_CKPHCNTEN			BIT(31)
#define DMMONITOR					0x00000024
	#define DMMONITOR_JMTR_EN			BIT(0)
	#define DMMONITOR_MONPAUSE_SW			BIT(2)
	#define DMMONITOR_BUSMONEN_SW			BIT(3)
	#define DMMONITOR_WDQ_MON_OPT			BIT(4)
	#define DMMONITOR_REQQUE_MON_SREF_DIS		BIT(8)
	#define DMMONITOR_REQQUE_MON_SREF_REOR		BIT(9)
	#define DMMONITOR_REQQUE_MON_SREF_LLAT		BIT(10)
	#define DMMONITOR_REQQUE_MON_SREF_HPRI		BIT(11)
	#define DMMONITOR_REQQUE_MON_SREF_RW		BIT(12)
	#define DMMONITOR_JMTRCNT			GENMASK(31, 16)
#define TESTCHIP_DMA1					0x00000030
	#define TESTCHIP_DMA1_DMAEN			BIT(0)
	#define TESTCHIP_DMA1_DMAPUREWREN		BIT(1)
	#define TESTCHIP_DMA1_DMAPURERDEN		BIT(2)
	#define TESTCHIP_DMA1_DMA_MWR			BIT(3)
	#define TESTCHIP_DMA1_DMABURSTLEN		GENMASK(6, 4)
	#define TESTCHIP_DMA1_DMAEN_LOOP		BIT(8)
	#define TESTCHIP_DMA1_DMAFIXPAT			BIT(9)
	#define TESTCHIP_DMA1_DMA_LP4MATAB_OPT		BIT(12)
#define MISC_STATUSA					0x00000080
	#define MISC_STATUSA_WAIT_DLE			BIT(0)
	#define MISC_STATUSA_WRITE_DATA_BUFFER_EMPTY	BIT(1)
	#define MISC_STATUSA_REQQ_EMPTY			BIT(2)
	#define MISC_STATUSA_PG_VLD			BIT(3)
	#define MISC_STATUSA_REQQUE_DEPTH		GENMASK(7, 4)
	#define MISC_STATUSA_REFRESH_RATE		GENMASK(10, 8)
	#define MISC_STATUSA_DRAM_HWCFG			BIT(12)
	#define MISC_STATUSA_CKEO_PRE			BIT(13)
	#define MISC_STATUSA_CKE1O_PRE			BIT(14)
	#define MISC_STATUSA_SREF_STATE			BIT(16)
	#define MISC_STATUSA_SELFREF_SM			GENMASK(19, 17)
	#define MISC_STATUSA_REFRESH_OVER_CNT		GENMASK(23, 20)
	#define MISC_STATUSA_REFRESH_QUEUE_CNT		GENMASK(27, 24)
	#define MISC_STATUSA_REQDEPTH_UPD_DONE		BIT(28)
	#define MISC_STATUSA_MANUTXUPD_DONE		BIT(29)
	#define MISC_STATUSA_DRAMC_IDLE_STATUS		BIT(30)
	#define MISC_STATUSA_DRAMC_IDLE_DCM		BIT(31)
#define SPECIAL_STATUS					0x00000084
	#define SPECIAL_STATUS_SPECIAL_COMMAND_ENABLE	BIT(0)
	#define SPECIAL_STATUS_H_ZQLAT_REQ		BIT(1)
	#define SPECIAL_STATUS_H_ZQLCAL_REQ		BIT(2)
	#define SPECIAL_STATUS_H_DQSOSCEN_REQ		BIT(4)
	#define SPECIAL_STATUS_DQSOSCEN_PERIOD		BIT(5)
	#define SPECIAL_STATUS_H_ZQCS_REQ		BIT(6)
	#define SPECIAL_STATUS_H_REFR_REQ		BIT(7)
	#define SPECIAL_STATUS_STBUPD_STOP		BIT(8)
	#define SPECIAL_STATUS_HW_ZQLAT_REQ		BIT(9)
	#define SPECIAL_STATUS_HW_ZQCAL_REQ		BIT(10)
	#define SPECIAL_STATUS_SPECIAL_STATUS		BIT(11)
	#define SPECIAL_STATUS_SCSM			GENMASK(16, 12)
	#define SPECIAL_STATUS_SCARB_SM			GENMASK(24, 20)
	#define SPECIAL_STATUS_SC_DRAMC_QUEUE_ACK	BIT(28)
	#define SPECIAL_STATUS_SREF_REQ_2Q		BIT(30)
	#define SPECIAL_STATUS_SREF_REQ			BIT(31)
#define SPCMDRESP					0x00000088
	#define SPCMDRESP_MRW_RESPONSE			BIT(0)
	#define SPCMDRESP_MRR_RESPONSE			BIT(1)
	#define SPCMDRESP_PREA_RESPONSE			BIT(2)
	#define SPCMDRESP_AREF_RESPONSE			BIT(3)
	#define SPCMDRESP_ZQC_RESPONSE			BIT(4)
	#define SPCMDRESP_TCMD_RESPONSE			BIT(5)
	#define SPCMDRESP_ZQLAT_RESPONSE		BIT(6)
	#define SPCMDRESP_RDDQC_RESPONSE		BIT(7)
	#define SPCMDRESP_STEST_RESPONSE		BIT(8)
	#define SPCMDRESP_MPCMAN_RESPONSE		BIT(9)
	#define SPCMDRESP_DQSOSCEN_RESPONSE		BIT(10)
	#define SPCMDRESP_DQSOSCDIS_RESPONSE		BIT(11)
	#define SPCMDRESP_ACT_RESPONSE			BIT(12)
	#define SPCMDRESP_MPRW_RESPONSE			BIT(13)
	#define SPCMDRESP_DVFS_RESPONSE			BIT(16)
	#define SPCMDRESP_HW_ZQLAT_POP			BIT(17)
	#define SPCMDRESP_HW_ZQCAL_POP			BIT(18)
	#define SPCMDRESP_RDFIFO_RESPONSE		BIT(30)
	#define SPCMDRESP_WRFIFO_RESPONSE		BIT(31)
#define MRR_STATUS					0x0000008c
	#define MRR_STATUS_MRR_REG			GENMASK(15, 0)
	#define MRR_STATUS_MRR_SW_REG			GENMASK(31, 16)
#define MRR_STATUS2					0x00000090
	#define MRR_STATUS2_MR4_REG			GENMASK(15, 0)
	#define MRR_STATUS2_SHUFFLE_MRW_VRCG_NORMAL_OK	BIT(16)
	#define MRR_STATUS2_TFC_OK			BIT(17)
	#define MRR_STATUS2_TCKFSPX_OK			BIT(18)
	#define MRR_STATUS2_TVRCG_EN_OK			BIT(19)
	#define MRR_STATUS2_TCKFSPE_OK			BIT(20)
	#define MRR_STATUS2_TVRCG_DIS_OK		BIT(21)
	#define MRR_STATUS2_PHY_SHUFFLE_PERIOD_GO_ZERO_OK	BIT(22)
	#define MRR_STATUS2_DVFS_STATE			GENMASK(31, 24)
#define MRRDATA0					0x00000094
	#define MRRDATA0_MRR_DATA0			GENMASK(31, 0)
#define MRRDATA1					0x00000098
	#define MRRDATA1_MRR_DATA1			GENMASK(31, 0)
#define MRRDATA2					0x0000009c
	#define MRRDATA2_MRR_DATA2			GENMASK(31, 0)
#define MRRDATA3					0x000000a0
	#define MRRDATA3_MRR_DATA3			GENMASK(31, 0)
#define DRS_STATUS					0x000000a8
	#define DRS_STATUS_DRS_MONERR_ACK		BIT(8)
	#define DRS_STATUS_DRS_MONERR_REQ		BIT(9)
	#define DRS_STATUS_RK1_DRS_REQ			BIT(16)
	#define DRS_STATUS_RK1_DRS_2Q			BIT(17)
	#define DRS_STATUS_RK1_DRSLY_REQ		BIT(18)
	#define DRS_STATUS_RK1_DRS_RDY			BIT(19)
	#define DRS_STATUS_RK1_DRS_ACK			BIT(20)
	#define DRS_STATUS_RK1_DRS_STATUS		BIT(21)
	#define DRS_STATUS_SELFREF_SM_RK1		GENMASK(26, 24)
#define JMETER_ST					0x000000bc
	#define JMETER_ST_ZEROS_CNT			GENMASK(14, 0)
	#define JMETER_ST_ONES_CNT			GENMASK(30, 16)
	#define JMETER_ST_JMTR_DONE			BIT(31)
#define TCMDO1LAT					0x000000c0
	#define TCMDO1LAT_TCMD_O1_LATCH_DATA0		GENMASK(5, 0)
	#define TCMDO1LAT_TCMD_O1_LATCH_DATA1		GENMASK(13, 8)
	#define TCMDO1LAT_CATRAIN_CMP_ERR0		GENMASK(21, 16)
	#define TCMDO1LAT_CATRAIN_CMP_ERR		GENMASK(29, 24)
	#define TCMDO1LAT_CATRAIN_CMP_CPT		BIT(31)
#define RDQC_CMP					0x000000c4
	#define RDQC_CMP_RDDQC_CMP0_ERR			GENMASK(15, 0)
	#define RDQC_CMP_RDDQC_CMP1_ERR			GENMASK(31, 16)
#define CKPHCHK_STATUS					0x000000c8
	#define CKPHCHK_STATUS_CKPHCHK_STATUS		GENMASK(15, 0)
#define HWMRR_PUSH2POP_CNT				0x0000010c
	#define HWMRR_PUSH2POP_CNT_HWMRR_PUSH2POP_CNT	GENMASK(31, 0)
#define HWMRR_STATUS					0x00000110
	#define HWMRR_STATUS_OV_P2P_CNT			GENMASK(7, 0)
	#define HWMRR_STATUS_MRR_CNT_UNDER_FULL		BIT(30)
	#define HWMRR_STATUS_MRR_CNT_OVER_FULL		BIT(31)
#define HW_REFRATE_MON					0x00000114
	#define HW_REFRATE_MON_REFRESH_RATE_MIN_MON	GENMASK(2, 0)
	#define HW_REFRATE_MON_REFRESH_RATE_MAX_MON	GENMASK(10, 8)
#define TESTRPT						0x00000120
	#define TESTRPT_DM_CMP_CPT_RK0			BIT(0)
	#define TESTRPT_DM_CMP_CPT_RK1			BIT(1)
	#define TESTRPT_DM_CMP_ERR_RK0			BIT(4)
	#define TESTRPT_DM_CMP_ERR_RK1			BIT(5)
	#define TESTRPT_DLE_CNT_OK_RK0			BIT(8)
	#define TESTRPT_DLE_CNT_OK_RK1			BIT(9)
	#define TESTRPT_TESTSTAT			GENMASK(22, 20)
	#define TESTRPT_LB_CMP_FAIL			BIT(24)
	#define TESTRPT_CALI_DONE_MON			BIT(28)
#define CMP_ERR						0x00000124
	#define CMP_ERR_CMP_ERR				GENMASK(31, 0)
#define TEST_ABIT_STATUS1				0x00000128
	#define TEST_ABIT_STATUS1_TEST_ABIT_ERR1	GENMASK(31, 0)
#define TEST_ABIT_STATUS2				0x0000012c
	#define TEST_ABIT_STATUS2_TEST_ABIT_ERR2	GENMASK(31, 0)
#define TEST_ABIT_STATUS3				0x00000130
	#define TEST_ABIT_STATUS3_TEST_ABIT_ERR3	GENMASK(31, 0)
#define TEST_ABIT_STATUS4				0x00000134
	#define TEST_ABIT_STATUS4_TEST_ABIT_ERR4	GENMASK(31, 0)
#define DQSDLY0						0x00000150
	#define DQSDLY0_DEL0DLY				GENMASK(6, 0)
	#define DQSDLY0_DEL1DLY				GENMASK(14, 8)
	#define DQSDLY0_DEL2DLY				GENMASK(22, 16)
	#define DQSDLY0_DEL3DLY				GENMASK(30, 24)
#define DQ_CAL_MAX_0					0x00000154
	#define DQ_CAL_MAX_0_DQ0_0_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_0_DQ0_1_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_0_DQ0_2_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_0_DQ0_3_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_1					0x00000158
	#define DQ_CAL_MAX_1_DQ0_4_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_1_DQ0_5_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_1_DQ0_6_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_1_DQ0_7_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_2					0x0000015c
	#define DQ_CAL_MAX_2_DQ1_0_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_2_DQ1_1_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_2_DQ1_2_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_2_DQ1_3_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_3					0x00000160
	#define DQ_CAL_MAX_3_DQ1_4_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_3_DQ1_5_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_3_DQ1_6_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_3_DQ1_7_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_4					0x00000164
	#define DQ_CAL_MAX_4_DQ2_0_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_4_DQ2_1_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_4_DQ2_2_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_4_DQ2_3_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_5					0x00000168
	#define DQ_CAL_MAX_5_DQ2_4_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_5_DQ2_5_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_5_DQ2_6_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_5_DQ2_7_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_6					0x0000016c
	#define DQ_CAL_MAX_6_DQ3_0_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_6_DQ3_1_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_6_DQ3_2_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_6_DQ3_3_DLY_MAX		GENMASK(31, 24)
#define DQ_CAL_MAX_7					0x00000170
	#define DQ_CAL_MAX_7_DQ3_4_DLY_MAX		GENMASK(7, 0)
	#define DQ_CAL_MAX_7_DQ3_5_DLY_MAX		GENMASK(15, 8)
	#define DQ_CAL_MAX_7_DQ3_6_DLY_MAX		GENMASK(23, 16)
	#define DQ_CAL_MAX_7_DQ3_7_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MIN_0					0x00000174
	#define DQS_CAL_MIN_0_DQS0_0_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_0_DQS0_1_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_0_DQS0_2_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_0_DQS0_3_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_1					0x00000178
	#define DQS_CAL_MIN_1_DQS0_4_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_1_DQS0_5_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_1_DQS0_6_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_1_DQS0_7_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_2					0x0000017c
	#define DQS_CAL_MIN_2_DQS1_0_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_2_DQS1_1_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_2_DQS1_2_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_2_DQS1_3_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_3					0x00000180
	#define DQS_CAL_MIN_3_DQS1_4_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_3_DQS1_5_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_3_DQS1_6_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_3_DQS1_7_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_4					0x00000184
	#define DQS_CAL_MIN_4_DQS2_0_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_4_DQS2_1_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_4_DQS2_2_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_4_DQS2_3_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_5					0x00000188
	#define DQS_CAL_MIN_5_DQS2_4_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_5_DQS2_5_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_5_DQS2_6_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_5_DQS2_7_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_6					0x0000018c
	#define DQS_CAL_MIN_6_DQS3_0_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_6_DQS3_1_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_6_DQS3_2_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_6_DQS3_3_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MIN_7					0x00000190
	#define DQS_CAL_MIN_7_DQS3_4_DLY_MIN		GENMASK(7, 0)
	#define DQS_CAL_MIN_7_DQS3_5_DLY_MIN		GENMASK(15, 8)
	#define DQS_CAL_MIN_7_DQS3_6_DLY_MIN		GENMASK(23, 16)
	#define DQS_CAL_MIN_7_DQS3_7_DLY_MIN		GENMASK(31, 24)
#define DQS_CAL_MAX_0					0x00000194
	#define DQS_CAL_MAX_0_DQS0_0_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_0_DQS0_1_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_0_DQS0_2_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_0_DQS0_3_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_1					0x00000198
	#define DQS_CAL_MAX_1_DQS0_4_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_1_DQS0_5_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_1_DQS0_6_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_1_DQS0_7_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_2					0x0000019c
	#define DQS_CAL_MAX_2_DQS1_0_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_2_DQS1_1_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_2_DQS1_2_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_2_DQS1_3_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_3					0x000001a0
	#define DQS_CAL_MAX_3_DQS1_4_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_3_DQS1_5_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_3_DQS1_6_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_3_DQS1_7_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_4					0x000001a4
	#define DQS_CAL_MAX_4_DQS2_0_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_4_DQS2_1_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_4_DQS2_2_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_4_DQS2_3_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_5					0x000001a8
	#define DQS_CAL_MAX_5_DQS2_4_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_5_DQS2_5_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_5_DQS2_6_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_5_DQS2_7_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_6					0x000001ac
	#define DQS_CAL_MAX_6_DQS3_0_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_6_DQS3_1_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_6_DQS3_2_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_6_DQS3_3_DLY_MAX		GENMASK(31, 24)
#define DQS_CAL_MAX_7					0x000001b0
	#define DQS_CAL_MAX_7_DQS3_4_DLY_MAX		GENMASK(7, 0)
	#define DQS_CAL_MAX_7_DQS3_5_DLY_MAX		GENMASK(15, 8)
	#define DQS_CAL_MAX_7_DQS3_6_DLY_MAX		GENMASK(23, 16)
	#define DQS_CAL_MAX_7_DQS3_7_DLY_MAX		GENMASK(31, 24)
#define DQICAL0						0x000001b4
	#define DQICAL0_DQ0_DLY_MAX			GENMASK(6, 0)
	#define DQICAL0_DQ1_DLY_MAX			GENMASK(14, 8)
	#define DQICAL0_DQ2_DLY_MAX			GENMASK(22, 16)
	#define DQICAL0_DQ3_DLY_MAX			GENMASK(30, 24)
#define DQICAL1						0x000001b8
	#define DQICAL1_DQS0_DLY_MIN			GENMASK(6, 0)
	#define DQICAL1_DQS1_DLY_MIN			GENMASK(14, 8)
	#define DQICAL1_DQS2_DLY_MIN			GENMASK(22, 16)
	#define DQICAL1_DQS3_DLY_MIN			GENMASK(30, 24)
#define DQICAL2						0x000001bc
	#define DQICAL2_DQS0_DLY_MAX			GENMASK(6, 0)
	#define DQICAL2_DQS1_DLY_MAX			GENMASK(14, 8)
	#define DQICAL2_DQS2_DLY_MAX			GENMASK(22, 16)
	#define DQICAL2_DQS3_DLY_MAX			GENMASK(30, 24)
#define DQICAL3						0x000001c0
	#define DQICAL3_DQS0_DLY_AVG			GENMASK(6, 0)
	#define DQICAL3_DQS1_DLY_AVG			GENMASK(14, 8)
	#define DQICAL3_DQS2_DLY_AVG			GENMASK(22, 16)
	#define DQICAL3_DQS3_DLY_AVG			GENMASK(30, 24)
#define TESTCHIP_DMA_STATUS1				0x00000200
	#define TESTCHIP_DMA_STATUS1_DMASTATUS		BIT(0)
	#define TESTCHIP_DMA_STATUS1_DMA_BUF_AVAIL	BIT(2)
	#define TESTCHIP_DMA_STATUS1_DMACMPERR		BIT(3)
	#define TESTCHIP_DMA_STATUS1_DMA_STATE		GENMASK(7, 4)
#define TESTCHIP_DMA_STATUS2				0x00000204
	#define TESTCHIP_DMA_STATUS2_DMACMPERR_BIT	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS3				0x00000208
	#define TESTCHIP_DMA_STATUS3_DMA_DATA_BUFFER0_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS4				0x0000020c
	#define TESTCHIP_DMA_STATUS4_DMA_DATA_BUFFER0_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS5				0x00000210
	#define TESTCHIP_DMA_STATUS5_DMA_DATA_BUFFER0_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS6				0x00000214
	#define TESTCHIP_DMA_STATUS6_DMA_DATA_BUFFER0_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS7				0x00000218
	#define TESTCHIP_DMA_STATUS7_DMA_DATA_BUFFER1_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS8				0x0000021c
	#define TESTCHIP_DMA_STATUS8_DMA_DATA_BUFFER1_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS9				0x00000220
	#define TESTCHIP_DMA_STATUS9_DMA_DATA_BUFFER1_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS10				0x00000224
	#define TESTCHIP_DMA_STATUS10_DMA_DATA_BUFFE1_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS11				0x00000228
	#define TESTCHIP_DMA_STATUS11_DMA_DATA_BUFFER2_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS12				0x0000022c
	#define TESTCHIP_DMA_STATUS12_DMA_DATA_BUFFER2_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS13				0x00000230
	#define TESTCHIP_DMA_STATUS13_DMA_DATA_BUFFER2_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS14				0x00000234
	#define TESTCHIP_DMA_STATUS14_DMA_DATA_BUFFER2_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS15				0x00000238
	#define TESTCHIP_DMA_STATUS15_DMA_DATA_BUFFER3_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS16				0x0000023c
	#define TESTCHIP_DMA_STATUS16_DMA_DATA_BUFFER3_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS17				0x00000240
	#define TESTCHIP_DMA_STATUS17_DMA_DATA_BUFFER3_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS18				0x00000244
	#define TESTCHIP_DMA_STATUS18_DMA_DATA_BUFFER3_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS19				0x00000248
	#define TESTCHIP_DMA_STATUS19_DMA_DATA_BUFFER4_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS20				0x0000024c
	#define TESTCHIP_DMA_STATUS20_DMA_DATA_BUFFER4_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS21				0x00000250
	#define TESTCHIP_DMA_STATUS21_DMA_DATA_BUFFER4_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS22				0x00000254
	#define TESTCHIP_DMA_STATUS22_DMA_DATA_BUFFER4_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS23				0x00000258
	#define TESTCHIP_DMA_STATUS23_DMA_DATA_BUFFER5_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS24				0x0000025c
	#define TESTCHIP_DMA_STATUS24_DMA_DATA_BUFFER5_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS25				0x00000260
	#define TESTCHIP_DMA_STATUS25_DMA_DATA_BUFFER5_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS26				0x00000264
	#define TESTCHIP_DMA_STATUS26_DMA_DATA_BUFFER5_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS27				0x00000268
	#define TESTCHIP_DMA_STATUS27_DMA_DATA_BUFFER6_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS28				0x0000026c
	#define TESTCHIP_DMA_STATUS28_DMA_DATA_BUFFER6_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS29				0x00000270
	#define TESTCHIP_DMA_STATUS29_DMA_DATA_BUFFER6_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS30				0x00000274
	#define TESTCHIP_DMA_STATUS30_DMA_DATA_BUFFER6_127_96_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS31				0x00000278
	#define TESTCHIP_DMA_STATUS31_DMA_DATA_BUFFER7_31_0_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS32				0x0000027c
	#define TESTCHIP_DMA_STATUS32_DMA_DATA_BUFFER7_63_32_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS33				0x00000280
	#define TESTCHIP_DMA_STATUS33_DMA_DATA_BUFFER7_95_64_	GENMASK(31, 0)
#define TESTCHIP_DMA_STATUS34				0x00000284
	#define TESTCHIP_DMA_STATUS34_DMA_DATA_BUFFER7_127_96_	GENMASK(31, 0)
#define REFRESH_POP_COUNTER				0x00000300
	#define REFRESH_POP_COUNTER_REFRESH_POP_COUNTER	GENMASK(31, 0)
#define FREERUN_26M_COUNTER				0x00000304
	#define FREERUN_26M_COUNTER_FREERUN_26M_COUNTER	GENMASK(31, 0)
#define DRAMC_IDLE_COUNTER				0x00000308
	#define DRAMC_IDLE_COUNTER_DRAMC_IDLE_COUNTER	GENMASK(31, 0)
#define R2R_PAGE_HIT_COUNTER				0x0000030c
	#define R2R_PAGE_HIT_COUNTER_R2R_PAGE_HIT_COUNTER	GENMASK(31, 0)
#define R2R_PAGE_MISS_COUNTER				0x00000310
	#define R2R_PAGE_MISS_COUNTER_R2R_PAGE_MISS_COUNTER	GENMASK(31, 0)
#define R2R_INTERBANK_COUNTER				0x00000314
	#define R2R_INTERBANK_COUNTER_R2R_INTERBANK_COUNTER	GENMASK(31, 0)
#define R2W_PAGE_HIT_COUNTER				0x00000318
	#define R2W_PAGE_HIT_COUNTER_R2W_PAGE_HIT_COUNTER	GENMASK(31, 0)
#define R2W_PAGE_MISS_COUNTER				0x0000031c
	#define R2W_PAGE_MISS_COUNTER_R2W_PAGE_MISS_COUNTER	GENMASK(31, 0)
#define R2W_INTERBANK_COUNTER				0x00000320
	#define R2W_INTERBANK_COUNTER_R2W_INTERBANK_COUNTER	GENMASK(31, 0)
#define W2R_PAGE_HIT_COUNTER				0x00000324
	#define W2R_PAGE_HIT_COUNTER_W2R_PAGE_HIT_COUNTER	GENMASK(31, 0)
#define W2R_PAGE_MISS_COUNTER				0x00000328
	#define W2R_PAGE_MISS_COUNTER_W2R_PAGE_MISS_COUNTER	GENMASK(31, 0)
#define W2R_INTERBANK_COUNTER				0x0000032c
	#define W2R_INTERBANK_COUNTER_W2R_INTERBANK_COUNTER	GENMASK(31, 0)
#define W2W_PAGE_HIT_COUNTER				0x00000330
	#define W2W_PAGE_HIT_COUNTER_W2W_PAGE_HIT_COUNTER	GENMASK(31, 0)
#define W2W_PAGE_MISS_COUNTER				0x00000334
	#define W2W_PAGE_MISS_COUNTER_W2W_PAGE_MISS_COUNTER	GENMASK(31, 0)
#define W2W_INTERBANK_COUNTER				0x00000338
	#define W2W_INTERBANK_COUNTER_W2W_INTERBANK_COUNTER	GENMASK(31, 0)
#define RK0_PRE_STANDBY_COUNTER				0x0000033c
	#define RK0_PRE_STANDBY_COUNTER_RK0_PRE_STANDBY_COUNTER	GENMASK(31, 0)
#define RK0_PRE_POWERDOWN_COUNTER			0x00000340
	#define RK0_PRE_POWERDOWN_COUNTER_RK0_PRE_POWERDOWN_COUNTER	GENMASK(31, 0)
#define RK0_ACT_STANDBY_COUNTER				0x00000344
	#define RK0_ACT_STANDBY_COUNTER_RK0_ACT_STANDBY_COUNTER	GENMASK(31, 0)
#define RK0_ACT_POWERDOWN_COUNTER			0x00000348
	#define RK0_ACT_POWERDOWN_COUNTER_RK0_ACT_POWERDOWN_COUNTER	GENMASK(31, 0)
#define RK1_PRE_STANDBY_COUNTER				0x0000034c
	#define RK1_PRE_STANDBY_COUNTER_RK1_PRE_STANDBY_COUNTER	GENMASK(31, 0)
#define RK1_PRE_POWERDOWN_COUNTER			0x00000350
	#define RK1_PRE_POWERDOWN_COUNTER_RK1_PRE_POWERDOWN_COUNTER	GENMASK(31, 0)
#define RK1_ACT_STANDBY_COUNTER				0x00000354
	#define RK1_ACT_STANDBY_COUNTER_RK1_ACT_STANDBY_COUNTER	GENMASK(31, 0)
#define RK1_ACT_POWERDOWN_COUNTER			0x00000358
	#define RK1_ACT_POWERDOWN_COUNTER_RK1_ACT_POWERDOWN_COUNTER	GENMASK(31, 0)
#define RK2_PRE_STANDBY_COUNTER				0x0000035c
	#define RK2_PRE_STANDBY_COUNTER_RK2_PRE_STANDBY_COUNTER	GENMASK(31, 0)
#define RK2_PRE_POWERDOWN_COUNTER			0x00000360
	#define RK2_PRE_POWERDOWN_COUNTER_RK2_PRE_POWERDOWN_COUNTER	GENMASK(31, 0)
#define RK2_ACT_STANDBY_COUNTER				0x00000364
	#define RK2_ACT_STANDBY_COUNTER_RK2_ACT_STANDBY_COUNTER	GENMASK(31, 0)
#define RK2_ACT_POWERDOWN_COUNTER			0x00000368
	#define RK2_ACT_POWERDOWN_COUNTER_RK2_ACT_POWERDOWN_COUNTER	GENMASK(31, 0)
#define DQ0_TOGGLE_COUNTER				0x0000036c
	#define DQ0_TOGGLE_COUNTER_DQ0_TOGGLE_COUNTER	GENMASK(31, 0)
#define DQ1_TOGGLE_COUNTER				0x00000370
	#define DQ1_TOGGLE_COUNTER_DQ1_TOGGLE_COUNTER	GENMASK(31, 0)
#define DQ2_TOGGLE_COUNTER				0x00000374
	#define DQ2_TOGGLE_COUNTER_DQ2_TOGGLE_COUNTER	GENMASK(31, 0)
#define DQ3_TOGGLE_COUNTER				0x00000378
	#define DQ3_TOGGLE_COUNTER_DQ3_TOGGLE_COUNTER	GENMASK(31, 0)
#define DQ0_TOGGLE_COUNTER_R				0x0000037c
	#define DQ0_TOGGLE_COUNTER_R_DQ0_TOGGLE_COUNTER_R	GENMASK(31, 0)
#define DQ1_TOGGLE_COUNTER_R				0x00000380
	#define DQ1_TOGGLE_COUNTER_R_DQ1_TOGGLE_COUNTER_R	GENMASK(31, 0)
#define DQ2_TOGGLE_COUNTER_R				0x00000384
	#define DQ2_TOGGLE_COUNTER_R_DQ2_TOGGLE_COUNTER_R	GENMASK(31, 0)
#define DQ3_TOGGLE_COUNTER_R				0x00000388
	#define DQ3_TOGGLE_COUNTER_R_DQ3_TOGGLE_COUNTER_R	GENMASK(31, 0)
#define READ_BYTES_COUNTER				0x0000038c
	#define READ_BYTES_COUNTER_READ_BYTES_COUNTER	GENMASK(31, 0)
#define WRITE_BYTES_COUNTER				0x00000390
	#define WRITE_BYTES_COUNTER_WRITE_BYTES_COUNTER	GENMASK(31, 0)
#define MAX_SREF_REQ_TO_ACK_LATENCY_COUNTER		0x00000394
	#define MAX_SREF_REQ_TO_ACK_LATENCY_COUNTER_SREF_REQTOACK_MAX_COUNTER	GENMASK(31, 0)
#define MAX_RK1_DRS_LONG_REQ_TO_ACK_LATENCY_COUNTER	0x00000398
	#define MAX_RK1_DRS_LONG_REQ_TO_ACK_LATENCY_COUNTER_DRS_LONG_REQTOACK_MAX_COUNTER	GENMASK(31, 0)
#define MAX_RK1_DRS_REQ_TO_ACK_LATENCY_COUNTER		0x0000039c
	#define MAX_RK1_DRS_REQ_TO_ACK_LATENCY_COUNTER_DRS_REQTOACK_MAX_COUNTER	GENMASK(31, 0)
#define DRAMC_IDLE_DCM_COUNTER				0x000003a0
	#define DRAMC_IDLE_DCM_COUNTER_DRAMC_IDLE_DCM_COUNTER	GENMASK(31, 0)
#define DDRPHY_CLK_EN_COUNTER				0x000003a4
	#define DDRPHY_CLK_EN_COUNTER_DDRPHY_CLK_EN_COUNTER	GENMASK(31, 0)
#define DDRPHY_CLK_EN_COMB_COUNTER			0x000003a8
	#define DDRPHY_CLK_EN_COMB_COUNTER_DDRPHY_CLK_EN_COMB_COUNTER	GENMASK(31, 0)
#define LAT_COUNTER_CMD0				0x000003c0
	#define LAT_COUNTER_CMD0_LAT_CMD0_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD0_LAT_CMD0_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD0_LAT_CMD0_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD0_LAT_CMD0_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD1				0x000003c4
	#define LAT_COUNTER_CMD1_LAT_CMD1_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD1_LAT_CMD1_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD1_LAT_CMD1_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD1_LAT_CMD1_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD2				0x000003c8
	#define LAT_COUNTER_CMD2_LAT_CMD2_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD2_LAT_CMD2_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD2_LAT_CMD2_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD2_LAT_CMD2_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD3				0x000003cc
	#define LAT_COUNTER_CMD3_LAT_CMD3_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD3_LAT_CMD3_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD3_LAT_CMD3_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD3_LAT_CMD3_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD4				0x000003d0
	#define LAT_COUNTER_CMD4_LAT_CMD4_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD4_LAT_CMD4_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD4_LAT_CMD4_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD4_LAT_CMD4_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD5				0x000003d4
	#define LAT_COUNTER_CMD5_LAT_CMD5_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD5_LAT_CMD5_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD5_LAT_CMD5_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD5_LAT_CMD5_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD6				0x000003d8
	#define LAT_COUNTER_CMD6_LAT_CMD6_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD6_LAT_CMD6_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD6_LAT_CMD6_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD6_LAT_CMD6_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_CMD7				0x000003dc
	#define LAT_COUNTER_CMD7_LAT_CMD7_CNT_MAX	GENMASK(15, 0)
	#define LAT_COUNTER_CMD7_LAT_CMD7_CNT_MAX_HPRI	BIT(16)
	#define LAT_COUNTER_CMD7_LAT_CMD7_CNT_MAX_LLAT	BIT(17)
	#define LAT_COUNTER_CMD7_LAT_CMD7_CNT_MAX_REORDER	BIT(18)
#define LAT_COUNTER_AVER				0x000003e0
	#define LAT_COUNTER_AVER_LAT_CMD_AVER_CNT	GENMASK(31, 0)
#define LAT_COUNTER_NUM					0x000003e4
	#define LAT_COUNTER_NUM_LAT_CMD_NUM		GENMASK(15, 0)
#define LAT_COUNTER_BLOCK_ALE				0x000003e8
	#define LAT_COUNTER_BLOCK_ALE_CTO_BLOCK_CNT_MAX	GENMASK(15, 0)
#define DQSSAMPLEV					0x00000400
	#define DQSSAMPLEV_SAMPLE_OUT1_DQS0		BIT(0)
	#define DQSSAMPLEV_SAMPLE_OUT1_DQS1		BIT(1)
	#define DQSSAMPLEV_SAMPLE_OUT1_DQS2		BIT(2)
	#define DQSSAMPLEV_SAMPLE_OUT1_DQS3		BIT(3)
	#define DQSSAMPLEV_PI_OVERFLOW			GENMASK(15, 12)
#define DQSGNWCNT0					0x00000408
	#define DQSGNWCNT0_DQS0F_GATING_COUNTER		GENMASK(7, 0)
	#define DQSGNWCNT0_DQS0R_GATING_COUNTER		GENMASK(15, 8)
	#define DQSGNWCNT0_DQS1F_GATING_COUNTER		GENMASK(23, 16)
	#define DQSGNWCNT0_DQS1R_GATING_COUNTER		GENMASK(31, 24)
#define DQSGNWCNT1					0x0000040c
	#define DQSGNWCNT1_DQS2F_GATING_COUNTER		GENMASK(7, 0)
	#define DQSGNWCNT1_DQS2R_GATING_COUNTER		GENMASK(15, 8)
	#define DQSGNWCNT1_DQS3F_GATING_COUNTER		GENMASK(23, 16)
	#define DQSGNWCNT1_DQS3R_GATING_COUNTER		GENMASK(31, 24)
#define DQSGNWCNT2					0x00000410
	#define DQSGNWCNT2_DQS0F_POS_GATING_COUNTER	GENMASK(7, 0)
	#define DQSGNWCNT2_DQS0R_POS_GATING_COUNTER	GENMASK(15, 8)
	#define DQSGNWCNT2_DQS0F_PRE_GATING_COUNTER	GENMASK(23, 16)
	#define DQSGNWCNT2_DQS0R_PRE_GATING_COUNTER	GENMASK(31, 24)
#define DQSGNWCNT3					0x00000414
	#define DQSGNWCNT3_DQS1F_POS_GATING_COUNTER	GENMASK(7, 0)
	#define DQSGNWCNT3_DQS1R_POS_GATING_COUNTER	GENMASK(15, 8)
	#define DQSGNWCNT3_DQS1F_PRE_GATING_COUNTER	GENMASK(23, 16)
	#define DQSGNWCNT3_DQS1R_PRE_GATING_COUNTER	GENMASK(31, 24)
#define DQSGNWCNT4					0x00000418
	#define DQSGNWCNT4_DQS2F_POS_GATING_COUNTER	GENMASK(7, 0)
	#define DQSGNWCNT4_DQS2R_POS_GATING_COUNTER	GENMASK(15, 8)
	#define DQSGNWCNT4_DQS2F_PRE_GATING_COUNTER	GENMASK(23, 16)
	#define DQSGNWCNT4_DQS2R_PRE_GATING_COUNTER	GENMASK(31, 24)
#define DQSGNWCNT5					0x0000041c
	#define DQSGNWCNT5_DQS3F_POS_GATING_COUNTER	GENMASK(7, 0)
	#define DQSGNWCNT5_DQS3R_POS_GATING_COUNTER	GENMASK(15, 8)
	#define DQSGNWCNT5_DQS3F_PRE_GATING_COUNTER	GENMASK(23, 16)
	#define DQSGNWCNT5_DQS3R_PRE_GATING_COUNTER	GENMASK(31, 24)
#define TOGGLE_CNT					0x00000420
	#define TOGGLE_CNT_TOGGLE_CNT			GENMASK(31, 0)
#define DQS0_ERR_CNT					0x00000424
	#define DQS0_ERR_CNT_DQS0_ERR_CNT		GENMASK(31, 0)
#define DQ_ERR_CNT0					0x00000428
	#define DQ_ERR_CNT0_DQ_ERR_CNT0			GENMASK(31, 0)
#define DQS1_ERR_CNT					0x0000042c
	#define DQS1_ERR_CNT_DQS1_ERR_CNT		GENMASK(31, 0)
#define DQ_ERR_CNT1					0x00000430
	#define DQ_ERR_CNT1_DQ_ERR_CNT1			GENMASK(31, 0)
#define DQS2_ERR_CNT					0x00000434
	#define DQS2_ERR_CNT_DQS2_ERR_CNT		GENMASK(31, 0)
#define DQ_ERR_CNT2					0x00000438
	#define DQ_ERR_CNT2_DQ_ERR_CNT2			GENMASK(31, 0)
#define DQS3_ERR_CNT					0x0000043c
	#define DQS3_ERR_CNT_DQS3_ERR_CNT		GENMASK(31, 0)
#define DQ_ERR_CNT3					0x00000440
	#define DQ_ERR_CNT3_DQ_ERR_CNT3			GENMASK(31, 0)
#define IORGCNT						0x00000450
	#define IORGCNT_IO_RING_COUNTER_K		GENMASK(15, 0)
	#define IORGCNT_IO_RING_COUNTER			GENMASK(31, 16)
#define DQSG_RETRY_STATE				0x00000454
	#define DQSG_RETRY_STATE_DQSG_RETRY_1ST_ST	GENMASK(7, 0)
	#define DQSG_RETRY_STATE_DQSG_RETRY_2ND_ST	GENMASK(15, 8)
	#define DQSG_RETRY_STATE_DQSG_RETRY_3RD_ST	GENMASK(23, 16)
	#define DQSG_RETRY_STATE_DQSG_RETRY_4TH_ST	GENMASK(31, 24)
#define DQSG_RETRY_STATE1				0x00000458
	#define DQSG_RETRY_STATE1_RETRY_DONE_ALL	BIT(0)
	#define DQSG_RETRY_STATE1_SELPH_RODTEN_USABLE	BIT(1)
	#define DQSG_RETRY_STATE1_TDQSCK_DONE		BIT(4)
	#define DQSG_RETRY_STATE1_IMPCAL_N_ERROR	BIT(8)
	#define DQSG_RETRY_STATE1_IMPCAL_P_ERROR	BIT(9)
	#define DQSG_RETRY_STATE1_IMPCAL_DONE		BIT(10)
	#define DQSG_RETRY_STATE1_STB_GATING_ERR	BIT(16)
	#define DQSG_RETRY_STATE1_R_OTHER_SHU_GP_GATING_ERR	GENMASK(18, 17)
	#define DQSG_RETRY_STATE1_R_MPDIV_SHU_GP_GATING_ERR	GENMASK(21, 19)
	#define DQSG_RETRY_STATE1_DQSG_RETRY_5TH_ST	GENMASK(31, 24)
#define IMPCAL_STATUS1					0x00000460
	#define IMPCAL_STATUS1_DRVNDQ_SAVE2		GENMASK(4, 0)
	#define IMPCAL_STATUS1_DRVPDQ_SAVE2		GENMASK(9, 5)
	#define IMPCAL_STATUS1_DRVNDQS_SAVE1		GENMASK(14, 10)
	#define IMPCAL_STATUS1_DRVPDQS_SAVE1		GENMASK(19, 15)
	#define IMPCAL_STATUS1_DRVNDQS_SAVE2		GENMASK(24, 20)
	#define IMPCAL_STATUS1_DRVPDQS_SAVE2		GENMASK(29, 25)
#define IMPCAL_STATUS2					0x00000464
	#define IMPCAL_STATUS2_DRVNCMD_SAVE1		GENMASK(4, 0)
	#define IMPCAL_STATUS2_DRVPCMD_SAVE1		GENMASK(9, 5)
	#define IMPCAL_STATUS2_DRVNCMD_SAVE2		GENMASK(14, 10)
	#define IMPCAL_STATUS2_DRVPCMD_SAVE2		GENMASK(19, 15)
	#define IMPCAL_STATUS2_DRVNDQ_SAVE1		GENMASK(24, 20)
	#define IMPCAL_STATUS2_DRVPDQ_SAVE1		GENMASK(29, 25)
#define DQDRV_STATUS					0x00000468
	#define DQDRV_STATUS_DRVNDQ_2			GENMASK(4, 0)
	#define DQDRV_STATUS_DRVPDQ_2			GENMASK(9, 5)
	#define DQDRV_STATUS_DRVNDQS_1			GENMASK(14, 10)
	#define DQDRV_STATUS_DRVPDQS_1			GENMASK(19, 15)
	#define DQDRV_STATUS_DRVNDQS_2			GENMASK(24, 20)
	#define DQDRV_STATUS_DRVPDQS_2			GENMASK(29, 25)
#define CMDDRV_STATUS					0x0000046c
	#define CMDDRV_STATUS_DRVNCMD_1			GENMASK(4, 0)
	#define CMDDRV_STATUS_DRVPCMD_1			GENMASK(9, 5)
	#define CMDDRV_STATUS_DRVNCMD_2			GENMASK(14, 10)
	#define CMDDRV_STATUS_DRVPCMD_2			GENMASK(19, 15)
	#define CMDDRV_STATUS_DRVNDQ_1			GENMASK(24, 20)
	#define CMDDRV_STATUS_DRVPDQ_1			GENMASK(29, 25)
#define CMDDRV1						0x00000470
	#define CMDDRV1_CMDDRV1				GENMASK(31, 0)
#define CMDDRV2						0x00000474
	#define CMDDRV2_CMDDRV2				GENMASK(31, 0)
#define RK0_DQSOSC_STATUS				0x00000600
	#define RK0_DQSOSC_STATUS_MR18_REG		GENMASK(15, 0)
	#define RK0_DQSOSC_STATUS_MR19_REG		GENMASK(31, 16)
#define RK0_DQSOSC_DELTA				0x00000604
	#define RK0_DQSOSC_DELTA_ABS_RK0_DQSOSC_DELTA	GENMASK(15, 0)
	#define RK0_DQSOSC_DELTA_SIGN_RK0_DQSOSC_DELTA	BIT(16)
	#define RK0_DQSOSC_DELTA_DQSOCSR_RESPONSE	BIT(17)
	#define RK0_DQSOSC_DELTA_H_DQSOSCLSBR_REQ	BIT(18)
	#define RK0_DQSOSC_DELTA_DQSOSC_INT_RK0		BIT(19)
#define RK0_DQSOSC_DELTA2				0x00000608
	#define RK0_DQSOSC_DELTA2_ABS_RK0_DQSOSC_B1_DELTA	GENMASK(15, 0)
	#define RK0_DQSOSC_DELTA2_SIGN_RK0_DQSOSC_B1_DELTA	BIT(16)
#define RK0_CURRENT_TX_SETTING1				0x00000610
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQ0_MOD	GENMASK(2, 0)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQ1_MOD	GENMASK(6, 4)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQ2_MOD	GENMASK(10, 8)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQ3_MOD	GENMASK(14, 12)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQM0_MOD	GENMASK(18, 16)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQM1_MOD	GENMASK(22, 20)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQM2_MOD	GENMASK(26, 24)
	#define RK0_CURRENT_TX_SETTING1_REG_TX_DLY_DQM3_MOD	GENMASK(30, 28)
#define RK0_CURRENT_TX_SETTING2				0x00000614
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQ0_MOD	GENMASK(2, 0)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQ1_MOD	GENMASK(6, 4)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQ2_MOD	GENMASK(10, 8)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQ3_MOD	GENMASK(14, 12)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQM0_MOD	GENMASK(18, 16)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQM1_MOD	GENMASK(22, 20)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQM2_MOD	GENMASK(26, 24)
	#define RK0_CURRENT_TX_SETTING2_REG_DLY_DQM3_MOD	GENMASK(30, 28)
#define RK0_CURRENT_TX_SETTING3				0x00000618
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQ0_MOD	GENMASK(2, 0)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQ1_MOD	GENMASK(6, 4)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQ2_MOD	GENMASK(10, 8)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQ3_MOD	GENMASK(14, 12)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQM0_MOD	GENMASK(18, 16)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQM1_MOD	GENMASK(22, 20)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQM2_MOD	GENMASK(26, 24)
	#define RK0_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_DQM3_MOD	GENMASK(30, 28)
#define RK0_CURRENT_TX_SETTING4				0x0000061c
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQ0_MOD	GENMASK(2, 0)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQ1_MOD	GENMASK(6, 4)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQ2_MOD	GENMASK(10, 8)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQ3_MOD	GENMASK(14, 12)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQM0_MOD	GENMASK(18, 16)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQM1_MOD	GENMASK(22, 20)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQM2_MOD	GENMASK(26, 24)
	#define RK0_CURRENT_TX_SETTING4_REG_DLY_OEN_DQM3_MOD	GENMASK(30, 28)
#define RK0_DUMMY_RD_DATA0				0x00000620
	#define RK0_DUMMY_RD_DATA0_DUMMY_RD_RK0_DATA0	GENMASK(31, 0)
#define RK0_DUMMY_RD_DATA1				0x00000624
	#define RK0_DUMMY_RD_DATA1_DUMMY_RD_RK0_DATA1	GENMASK(31, 0)
#define RK0_DUMMY_RD_DATA2				0x00000628
	#define RK0_DUMMY_RD_DATA2_DUMMY_RD_RK0_DATA2	GENMASK(31, 0)
#define RK0_DUMMY_RD_DATA3				0x0000062c
	#define RK0_DUMMY_RD_DATA3_DUMMY_RD_RK0_DATA3	GENMASK(31, 0)
#define RK0_B0_STB_MAX_MIN_DLY				0x00000630
	#define RK0_B0_STB_MAX_MIN_DLY_RK0_B0_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK0_B0_STB_MAX_MIN_DLY_RK0_B0_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK0_B1_STB_MAX_MIN_DLY				0x00000634
	#define RK0_B1_STB_MAX_MIN_DLY_RK0_B1_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK0_B1_STB_MAX_MIN_DLY_RK0_B1_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK0_B2_STB_MAX_MIN_DLY				0x00000638
	#define RK0_B2_STB_MAX_MIN_DLY_RK0_B2_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK0_B2_STB_MAX_MIN_DLY_RK0_B2_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK0_B3_STB_MAX_MIN_DLY				0x0000063c
	#define RK0_B3_STB_MAX_MIN_DLY_RK0_B3_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK0_B3_STB_MAX_MIN_DLY_RK0_B3_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK0_DQSIENDLY					0x00000640
	#define RK0_DQSIENDLY_R0DQS0IENDLY		GENMASK(6, 0)
	#define RK0_DQSIENDLY_R0DQS1IENDLY		GENMASK(14, 8)
	#define RK0_DQSIENDLY_R0DQS2IENDLY		GENMASK(22, 16)
	#define RK0_DQSIENDLY_R0DQS3IENDLY		GENMASK(30, 24)
#define RK0_DQSIENUIDLY					0x00000644
	#define RK0_DQSIENUIDLY_R0DQS0IENUIDLY		GENMASK(5, 0)
	#define RK0_DQSIENUIDLY_R0DQS1IENUIDLY		GENMASK(13, 8)
	#define RK0_DQSIENUIDLY_R0DQS2IENUIDLY		GENMASK(21, 16)
	#define RK0_DQSIENUIDLY_R0DQS3IENUIDLY		GENMASK(29, 24)
#define RK0_DQSIENUIDLY_P1				0x00000648
	#define RK0_DQSIENUIDLY_P1_R0DQS0IENUIDLY_P1	GENMASK(5, 0)
	#define RK0_DQSIENUIDLY_P1_R0DQS1IENUIDLY_P1	GENMASK(13, 8)
	#define RK0_DQSIENUIDLY_P1_R0DQS2IENUIDLY_P1	GENMASK(21, 16)
	#define RK0_DQSIENUIDLY_P1_R0DQS3IENUIDLY_P1	GENMASK(29, 24)
#define RK0_DQS_STBCALDEC_CNT1				0x00000650
	#define RK0_DQS_STBCALDEC_CNT1_RK0_DQS0_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK0_DQS_STBCALDEC_CNT1_RK0_DQS1_STBCALDEC_CNT	GENMASK(31, 16)
#define RK0_DQS_STBCALDEC_CNT2				0x00000654
	#define RK0_DQS_STBCALDEC_CNT2_RK0_DQS2_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK0_DQS_STBCALDEC_CNT2_RK0_DQS3_STBCALDEC_CNT	GENMASK(31, 16)
#define RK0_DQS_STBCALINC_CNT1				0x00000658
	#define RK0_DQS_STBCALINC_CNT1_RK0_DQS0_STBCALINC_CNT	GENMASK(15, 0)
	#define RK0_DQS_STBCALINC_CNT1_RK0_DQS1_STBCALINC_CNT	GENMASK(31, 16)
#define RK0_DQS_STBCALINC_CNT2				0x0000065c
	#define RK0_DQS_STBCALINC_CNT2_RK0_DQS2_STBCALINC_CNT	GENMASK(15, 0)
	#define RK0_DQS_STBCALINC_CNT2_RK0_DQS3_STBCALINC_CNT	GENMASK(31, 16)
#define RK0_PI_DQ_CAL					0x00000660
	#define RK0_PI_DQ_CAL_RK0_ARPI_DQ_B0_CAL	GENMASK(5, 0)
	#define RK0_PI_DQ_CAL_RK0_ARPI_DQ_B1_CAL	GENMASK(13, 8)
	#define RK0_PI_DQ_CAL_PI_DQ_ADJ_RK0		GENMASK(21, 16)
	#define RK0_PI_DQ_CAL_PI_DQ_ADJ_RK0_OVERFLOW	BIT(22)
	#define RK0_PI_DQ_CAL_RK0_B0_PI_CHANGE_DBG	BIT(23)
	#define RK0_PI_DQ_CAL_PI_DQ_ADJ_RK0_B1		GENMASK(29, 24)
	#define RK0_PI_DQ_CAL_PI_DQ_ADJ_RK0_B1_OVERFLOW	BIT(30)
	#define RK0_PI_DQ_CAL_RK0_B1_PI_CHANGE_DBG	BIT(31)
#define RK0_DQSG_RETRY_FLAG				0x00000664
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_DONE0	BIT(0)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_DONE1	BIT(1)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_DONE2	BIT(2)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_DONE3	BIT(3)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_FAIL0	BIT(16)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_FAIL1	BIT(17)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_FAIL2	BIT(18)
	#define RK0_DQSG_RETRY_FLAG_RK0_RETRY_FAIL3	BIT(19)
#define RK0_PI_DQM_CAL					0x00000668
	#define RK0_PI_DQM_CAL_RK0_ARPI_DQM_B0_CAL	GENMASK(5, 0)
	#define RK0_PI_DQM_CAL_RK0_ARPI_DQM_B1_CAL	GENMASK(13, 8)
#define RK0_DQS0_STBCAL_CNT				0x00000670
	#define RK0_DQS0_STBCAL_CNT_R0_DQS0_STBCAL_CNT	GENMASK(16, 0)
#define RK0_DQS1_STBCAL_CNT				0x00000674
	#define RK0_DQS1_STBCAL_CNT_R0_DQS1_STBCAL_CNT	GENMASK(16, 0)
#define RK0_DQS2_STBCAL_CNT				0x00000678
	#define RK0_DQS2_STBCAL_CNT_R0_DQS2_STBCAL_CNT	GENMASK(16, 0)
#define RK0_DQS3_STBCAL_CNT				0x0000067c
	#define RK0_DQS3_STBCAL_CNT_R0_DQS3_STBCAL_CNT	GENMASK(16, 0)
#define RK0_B01_STB_DBG_INFO_00				0x00000680
	#define RK0_B01_STB_DBG_INFO_00_RK0_B0_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_00_RK0_B1_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_01				0x00000684
	#define RK0_B01_STB_DBG_INFO_01_RK0_B0_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_01_RK0_B1_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_02				0x00000688
	#define RK0_B01_STB_DBG_INFO_02_RK0_B0_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_02_RK0_B1_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_03				0x0000068c
	#define RK0_B01_STB_DBG_INFO_03_RK0_B0_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_03_RK0_B1_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_04				0x00000690
	#define RK0_B01_STB_DBG_INFO_04_RK0_B0_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_04_RK0_B1_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_05				0x00000694
	#define RK0_B01_STB_DBG_INFO_05_RK0_B0_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_05_RK0_B1_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_06				0x00000698
	#define RK0_B01_STB_DBG_INFO_06_RK0_B0_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_06_RK0_B1_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_07				0x0000069c
	#define RK0_B01_STB_DBG_INFO_07_RK0_B0_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_07_RK0_B1_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_08				0x000006a0
	#define RK0_B01_STB_DBG_INFO_08_RK0_B0_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_08_RK0_B1_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_09				0x000006a4
	#define RK0_B01_STB_DBG_INFO_09_RK0_B0_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_09_RK0_B1_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_10				0x000006a8
	#define RK0_B01_STB_DBG_INFO_10_RK0_B0_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_10_RK0_B1_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_11				0x000006ac
	#define RK0_B01_STB_DBG_INFO_11_RK0_B0_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_11_RK0_B1_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_12				0x000006b0
	#define RK0_B01_STB_DBG_INFO_12_RK0_B0_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_12_RK0_B1_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_13				0x000006b4
	#define RK0_B01_STB_DBG_INFO_13_RK0_B0_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_13_RK0_B1_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_14				0x000006b8
	#define RK0_B01_STB_DBG_INFO_14_RK0_B0_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_14_RK0_B1_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK0_B01_STB_DBG_INFO_15				0x000006bc
	#define RK0_B01_STB_DBG_INFO_15_RK0_B0_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK0_B01_STB_DBG_INFO_15_RK0_B1_STB_DBG_INFO_15	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_00				0x000006c0
	#define RK0_B23_STB_DBG_INFO_00_RK0_B2_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_00_RK0_B3_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_01				0x000006c4
	#define RK0_B23_STB_DBG_INFO_01_RK0_B2_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_01_RK0_B3_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_02				0x000006c8
	#define RK0_B23_STB_DBG_INFO_02_RK0_B2_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_02_RK0_B3_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_03				0x000006cc
	#define RK0_B23_STB_DBG_INFO_03_RK0_B2_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_03_RK0_B3_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_04				0x000006d0
	#define RK0_B23_STB_DBG_INFO_04_RK0_B2_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_04_RK0_B3_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_05				0x000006d4
	#define RK0_B23_STB_DBG_INFO_05_RK0_B2_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_05_RK0_B3_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_06				0x000006d8
	#define RK0_B23_STB_DBG_INFO_06_RK0_B2_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_06_RK0_B3_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_07				0x000006dc
	#define RK0_B23_STB_DBG_INFO_07_RK0_B2_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_07_RK0_B3_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_08				0x000006e0
	#define RK0_B23_STB_DBG_INFO_08_RK0_B2_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_08_RK0_B3_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_09				0x000006e4
	#define RK0_B23_STB_DBG_INFO_09_RK0_B2_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_09_RK0_B3_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_10				0x000006e8
	#define RK0_B23_STB_DBG_INFO_10_RK0_B2_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_10_RK0_B3_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_11				0x000006ec
	#define RK0_B23_STB_DBG_INFO_11_RK0_B2_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_11_RK0_B3_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_12				0x000006f0
	#define RK0_B23_STB_DBG_INFO_12_RK0_B2_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_12_RK0_B3_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_13				0x000006f4
	#define RK0_B23_STB_DBG_INFO_13_RK0_B2_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_13_RK0_B3_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_14				0x000006f8
	#define RK0_B23_STB_DBG_INFO_14_RK0_B2_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_14_RK0_B3_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK0_B23_STB_DBG_INFO_15				0x000006fc
	#define RK0_B23_STB_DBG_INFO_15_RK0_B2_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK0_B23_STB_DBG_INFO_15_RK0_B3_STB_DBG_INFO_15	GENMASK(31, 16)
#define RK1_DQSOSC_STATUS				0x00000700
	#define RK1_DQSOSC_STATUS_MR18_REG_RK1		GENMASK(15, 0)
	#define RK1_DQSOSC_STATUS_MR19_REG_RK1		GENMASK(31, 16)
#define RK1_DQSOSC_DELTA				0x00000704
	#define RK1_DQSOSC_DELTA_ABS_RK1_DQSOSC_DELTA	GENMASK(15, 0)
	#define RK1_DQSOSC_DELTA_SIGN_RK1_DQSOSC_DELTA	BIT(16)
	#define RK1_DQSOSC_DELTA_DQSOSCR_RK1_RESPONSE	BIT(17)
	#define RK1_DQSOSC_DELTA_H_DQSOSCLSBR_RK1_REQ	BIT(18)
	#define RK1_DQSOSC_DELTA_DQSOSC_INT_RK1		BIT(19)
#define RK1_DQSOSC_DELTA2				0x00000708
	#define RK1_DQSOSC_DELTA2_ABS_RK1_DQSOSC_B1_DELTA	GENMASK(15, 0)
	#define RK1_DQSOSC_DELTA2_SIGN_RK1_DQSOSC_B1_DELTA	BIT(16)
#define RK1_CURRENT_TX_SETTING1				0x00000710
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQ0_MOD	GENMASK(2, 0)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQ1_MOD	GENMASK(6, 4)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQ2_MOD	GENMASK(10, 8)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQ3_MOD	GENMASK(14, 12)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQM0_MOD	GENMASK(18, 16)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQM1_MOD	GENMASK(22, 20)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQM2_MOD	GENMASK(26, 24)
	#define RK1_CURRENT_TX_SETTING1_REG_TX_DLY_R1DQM3_MOD	GENMASK(30, 28)
#define RK1_CURRENT_TX_SETTING2				0x00000714
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQ0_MOD	GENMASK(2, 0)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQ1_MOD	GENMASK(6, 4)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQ2_MOD	GENMASK(10, 8)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQ3_MOD	GENMASK(14, 12)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQM0_MOD	GENMASK(18, 16)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQM1_MOD	GENMASK(22, 20)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQM2_MOD	GENMASK(26, 24)
	#define RK1_CURRENT_TX_SETTING2_REG_DLY_R1DQM3_MOD	GENMASK(30, 28)
#define RK1_CURRENT_TX_SETTING3				0x00000718
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQ0_MOD	GENMASK(2, 0)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQ1_MOD	GENMASK(6, 4)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQ2_MOD	GENMASK(10, 8)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQ3_MOD	GENMASK(14, 12)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQM0_MOD	GENMASK(18, 16)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQM1_MOD	GENMASK(22, 20)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQM2_MOD	GENMASK(26, 24)
	#define RK1_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R1DQM3_MOD	GENMASK(30, 28)
#define RK1_CURRENT_TX_SETTING4				0x0000071c
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQ0_MOD	GENMASK(2, 0)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQ1_MOD	GENMASK(6, 4)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQ2_MOD	GENMASK(10, 8)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQ3_MOD	GENMASK(14, 12)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQM0_MOD	GENMASK(18, 16)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQM1_MOD	GENMASK(22, 20)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQM2_MOD	GENMASK(26, 24)
	#define RK1_CURRENT_TX_SETTING4_REG_DLY_OEN_R1DQM3_MOD	GENMASK(30, 28)
#define RK1_DUMMY_RD_DATA0				0x00000720
	#define RK1_DUMMY_RD_DATA0_DUMMY_RD_RK1_DATA0	GENMASK(31, 0)
#define RK1_DUMMY_RD_DATA1				0x00000724
	#define RK1_DUMMY_RD_DATA1_DUMMY_RD_RK1_DATA1	GENMASK(31, 0)
#define RK1_DUMMY_RD_DATA2				0x00000728
	#define RK1_DUMMY_RD_DATA2_DUMMY_RD_RK1_DATA2	GENMASK(31, 0)
#define RK1_DUMMY_RD_DATA3				0x0000072c
	#define RK1_DUMMY_RD_DATA3_DUMMY_RD_RK1_DATA3	GENMASK(31, 0)
#define RK1_B0_STB_MAX_MIN_DLY				0x00000730
	#define RK1_B0_STB_MAX_MIN_DLY_RK1_B0_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK1_B0_STB_MAX_MIN_DLY_RK1_B0_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK1_B1_STB_MAX_MIN_DLY				0x00000734
	#define RK1_B1_STB_MAX_MIN_DLY_RK1_B1_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK1_B1_STB_MAX_MIN_DLY_RK1_B1_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK1_B2_STB_MAX_MIN_DLY				0x00000738
	#define RK1_B2_STB_MAX_MIN_DLY_RK1_B2_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK1_B2_STB_MAX_MIN_DLY_RK1_B2_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK1_B3_STB_MAX_MIN_DLY				0x0000073c
	#define RK1_B3_STB_MAX_MIN_DLY_RK1_B3_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK1_B3_STB_MAX_MIN_DLY_RK1_B3_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK1_DQSIENDLY					0x00000740
	#define RK1_DQSIENDLY_R1DQS0IENDLY		GENMASK(6, 0)
	#define RK1_DQSIENDLY_R1DQS1IENDLY		GENMASK(14, 8)
	#define RK1_DQSIENDLY_R1DQS2IENDLY		GENMASK(22, 16)
	#define RK1_DQSIENDLY_R1DQS3IENDLY		GENMASK(30, 24)
#define RK1_DQSIENUIDLY					0x00000744
	#define RK1_DQSIENUIDLY_R1DQS0IENUIDLY		GENMASK(5, 0)
	#define RK1_DQSIENUIDLY_R1DQS1IENUIDLY		GENMASK(13, 8)
	#define RK1_DQSIENUIDLY_R1DQS2IENUIDLY		GENMASK(21, 16)
	#define RK1_DQSIENUIDLY_R1DQS3IENUIDLY		GENMASK(29, 24)
#define RK1_DQSIENUIDLY_P1				0x00000748
	#define RK1_DQSIENUIDLY_P1_R1DQS0IENUIDLY_P1	GENMASK(5, 0)
	#define RK1_DQSIENUIDLY_P1_R1DQS1IENUIDLY_P1	GENMASK(13, 8)
	#define RK1_DQSIENUIDLY_P1_R1DQS2IENUIDLY_P1	GENMASK(21, 16)
	#define RK1_DQSIENUIDLY_P1_R1DQS3IENUIDLY_P1	GENMASK(29, 24)
#define RK1_DQS_STBCALDEC_CNT1				0x00000750
	#define RK1_DQS_STBCALDEC_CNT1_RK1_DQS0_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK1_DQS_STBCALDEC_CNT1_RK1_DQS1_STBCALDEC_CNT	GENMASK(31, 16)
#define RK1_DQS_STBCALDEC_CNT2				0x00000754
	#define RK1_DQS_STBCALDEC_CNT2_RK1_DQS2_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK1_DQS_STBCALDEC_CNT2_RK1_DQS3_STBCALDEC_CNT	GENMASK(31, 16)
#define RK1_DQS_STBCALINC_CNT1				0x00000758
	#define RK1_DQS_STBCALINC_CNT1_RK1_DQS0_STBCALINC_CNT	GENMASK(15, 0)
	#define RK1_DQS_STBCALINC_CNT1_RK1_DQS1_STBCALINC_CNT	GENMASK(31, 16)
#define RK1_DQS_STBCALINC_CNT2				0x0000075c
	#define RK1_DQS_STBCALINC_CNT2_RK1_DQS2_STBCALINC_CNT	GENMASK(15, 0)
	#define RK1_DQS_STBCALINC_CNT2_RK1_DQS3_STBCALINC_CNT	GENMASK(31, 16)
#define RK1_PI_DQ_CAL					0x00000760
	#define RK1_PI_DQ_CAL_RK1_ARPI_DQ_B0_CAL	GENMASK(5, 0)
	#define RK1_PI_DQ_CAL_RK1_ARPI_DQ_B1_CAL	GENMASK(13, 8)
	#define RK1_PI_DQ_CAL_PI_DQ_ADJ_RK1		GENMASK(21, 16)
	#define RK1_PI_DQ_CAL_PI_DQ_ADJ_RK1_FLOW	BIT(22)
	#define RK1_PI_DQ_CAL_RK1_B0_PI_CHANGE_DBG	BIT(23)
	#define RK1_PI_DQ_CAL_PI_DQ_ADJ_RK1_B1		GENMASK(29, 24)
	#define RK1_PI_DQ_CAL_PI_DQ_ADJ_RK1_B1_FLOW	BIT(30)
	#define RK1_PI_DQ_CAL_RK1_B1_PI_CHANGE_DBG	BIT(31)
#define RK1_DQSG_RETRY_FLAG				0x00000764
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_DONE0	BIT(0)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_DONE1	BIT(1)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_DONE2	BIT(2)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_DONE3	BIT(3)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_FAIL0	BIT(16)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_FAIL1	BIT(17)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_FAIL2	BIT(18)
	#define RK1_DQSG_RETRY_FLAG_RK1_RETRY_FAIL3	BIT(19)
#define RK1_PI_DQM_CAL					0x00000768
	#define RK1_PI_DQM_CAL_RK1_ARPI_DQM_B0_CAL	GENMASK(5, 0)
	#define RK1_PI_DQM_CAL_RK1_ARPI_DQM_B1_CAL	GENMASK(13, 8)
#define RK1_DQS0_STBCAL_CNT				0x00000770
	#define RK1_DQS0_STBCAL_CNT_R1_DQS0_STBCAL_CNT	GENMASK(16, 0)
#define RK1_DQS1_STBCAL_CNT				0x00000774
	#define RK1_DQS1_STBCAL_CNT_R1_DQS1_STBCAL_CNT	GENMASK(16, 0)
#define RK1_DQS2_STBCAL_CNT				0x00000778
	#define RK1_DQS2_STBCAL_CNT_R1_DQS2_STBCAL_CNT	GENMASK(16, 0)
#define RK1_DQS3_STBCAL_CNT				0x0000077c
	#define RK1_DQS3_STBCAL_CNT_R1_DQS3_STBCAL_CNT	GENMASK(16, 0)
#define RK1_B01_STB_DBG_INFO_00				0x00000780
	#define RK1_B01_STB_DBG_INFO_00_RK1_B0_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_00_RK1_B1_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_01				0x00000784
	#define RK1_B01_STB_DBG_INFO_01_RK1_B0_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_01_RK1_B1_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_02				0x00000788
	#define RK1_B01_STB_DBG_INFO_02_RK1_B0_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_02_RK1_B1_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_03				0x0000078c
	#define RK1_B01_STB_DBG_INFO_03_RK1_B0_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_03_RK1_B1_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_04				0x00000790
	#define RK1_B01_STB_DBG_INFO_04_RK1_B0_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_04_RK1_B1_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_05				0x00000794
	#define RK1_B01_STB_DBG_INFO_05_RK1_B0_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_05_RK1_B1_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_06				0x00000798
	#define RK1_B01_STB_DBG_INFO_06_RK1_B0_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_06_RK1_B1_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_07				0x0000079c
	#define RK1_B01_STB_DBG_INFO_07_RK1_B0_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_07_RK1_B1_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_08				0x000007a0
	#define RK1_B01_STB_DBG_INFO_08_RK1_B0_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_08_RK1_B1_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_09				0x000007a4
	#define RK1_B01_STB_DBG_INFO_09_RK1_B0_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_09_RK1_B1_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_10				0x000007a8
	#define RK1_B01_STB_DBG_INFO_10_RK1_B0_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_10_RK1_B1_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_11				0x000007ac
	#define RK1_B01_STB_DBG_INFO_11_RK1_B0_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_11_RK1_B1_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_12				0x000007b0
	#define RK1_B01_STB_DBG_INFO_12_RK1_B0_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_12_RK1_B1_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_13				0x000007b4
	#define RK1_B01_STB_DBG_INFO_13_RK1_B0_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_13_RK1_B1_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_14				0x000007b8
	#define RK1_B01_STB_DBG_INFO_14_RK1_B0_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_14_RK1_B1_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK1_B01_STB_DBG_INFO_15				0x000007bc
	#define RK1_B01_STB_DBG_INFO_15_RK1_B0_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK1_B01_STB_DBG_INFO_15_RK1_B1_STB_DBG_INFO_15	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_00				0x000007c0
	#define RK1_B23_STB_DBG_INFO_00_RK1_B2_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_00_RK1_B3_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_01				0x000007c4
	#define RK1_B23_STB_DBG_INFO_01_RK1_B2_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_01_RK1_B3_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_02				0x000007c8
	#define RK1_B23_STB_DBG_INFO_02_RK1_B2_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_02_RK1_B3_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_03				0x000007cc
	#define RK1_B23_STB_DBG_INFO_03_RK1_B2_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_03_RK1_B3_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_04				0x000007d0
	#define RK1_B23_STB_DBG_INFO_04_RK1_B2_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_04_RK1_B3_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_05				0x000007d4
	#define RK1_B23_STB_DBG_INFO_05_RK1_B2_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_05_RK1_B3_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_06				0x000007d8
	#define RK1_B23_STB_DBG_INFO_06_RK1_B2_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_06_RK1_B3_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_07				0x000007dc
	#define RK1_B23_STB_DBG_INFO_07_RK1_B2_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_07_RK1_B3_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_08				0x000007e0
	#define RK1_B23_STB_DBG_INFO_08_RK1_B2_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_08_RK1_B3_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_09				0x000007e4
	#define RK1_B23_STB_DBG_INFO_09_RK1_B2_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_09_RK1_B3_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_10				0x000007e8
	#define RK1_B23_STB_DBG_INFO_10_RK1_B2_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_10_RK1_B3_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_11				0x000007ec
	#define RK1_B23_STB_DBG_INFO_11_RK1_B2_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_11_RK1_B3_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_12				0x000007f0
	#define RK1_B23_STB_DBG_INFO_12_RK1_B2_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_12_RK1_B3_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_13				0x000007f4
	#define RK1_B23_STB_DBG_INFO_13_RK1_B2_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_13_RK1_B3_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_14				0x000007f8
	#define RK1_B23_STB_DBG_INFO_14_RK1_B2_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_14_RK1_B3_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK1_B23_STB_DBG_INFO_15				0x000007fc
	#define RK1_B23_STB_DBG_INFO_15_RK1_B2_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK1_B23_STB_DBG_INFO_15_RK1_B3_STB_DBG_INFO_15	GENMASK(31, 16)
#define RK2_DQSOSC_STATUS				0x00000800
	#define RK2_DQSOSC_STATUS_MR18_REG_RK2		GENMASK(15, 0)
	#define RK2_DQSOSC_STATUS_MR19_REG_RK2		GENMASK(31, 16)
#define RK2_DQSOSC_DELTA				0x00000804
	#define RK2_DQSOSC_DELTA_ABS_RK2_DQSOSC_DELTA	GENMASK(15, 0)
	#define RK2_DQSOSC_DELTA_SIGN_RK2_DQSOSC_DELTA	BIT(16)
	#define RK2_DQSOSC_DELTA_DQSOSCR_RK2_RESPONSE	BIT(17)
	#define RK2_DQSOSC_DELTA_H_DQSOSCLSBR_RK2_REQ	BIT(18)
	#define RK2_DQSOSC_DELTA_DQSOSC_INT_RK2		BIT(19)
#define RK2_DQSOSC_DELTA2				0x00000808
	#define RK2_DQSOSC_DELTA2_ABS_RK2_DQSOSC_B1_DELTA	GENMASK(15, 0)
	#define RK2_DQSOSC_DELTA2_SIGN_RK2_DQSOSC_B1_DELTA	BIT(16)
#define RK2_CURRENT_TX_SETTING1				0x00000810
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQ0_MOD	GENMASK(2, 0)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQ1_MOD	GENMASK(6, 4)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQ2_MOD	GENMASK(10, 8)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQ3_MOD	GENMASK(14, 12)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQM0_MOD	GENMASK(18, 16)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQM1_MOD	GENMASK(22, 20)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQM2_MOD	GENMASK(26, 24)
	#define RK2_CURRENT_TX_SETTING1_REG_TX_DLY_R2DQM3_MOD	GENMASK(30, 28)
#define RK2_CURRENT_TX_SETTING2				0x00000814
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQ0_MOD	GENMASK(2, 0)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQ1_MOD	GENMASK(6, 4)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQ2_MOD	GENMASK(10, 8)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQ3_MOD	GENMASK(14, 12)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQM0_MOD	GENMASK(18, 16)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQM1_MOD	GENMASK(22, 20)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQM2_MOD	GENMASK(26, 24)
	#define RK2_CURRENT_TX_SETTING2_REG_DLY_R2DQM3_MOD	GENMASK(30, 28)
#define RK2_CURRENT_TX_SETTING3				0x00000818
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQ0_MOD	GENMASK(2, 0)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQ1_MOD	GENMASK(6, 4)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQ2_MOD	GENMASK(10, 8)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQ3_MOD	GENMASK(14, 12)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQM0_MOD	GENMASK(18, 16)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQM1_MOD	GENMASK(22, 20)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQM2_MOD	GENMASK(26, 24)
	#define RK2_CURRENT_TX_SETTING3_REG_TX_DLY_OEN_R2DQM3_MOD	GENMASK(30, 28)
#define RK2_CURRENT_TX_SETTING4				0x0000081c
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQ0_MOD	GENMASK(2, 0)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQ1_MOD	GENMASK(6, 4)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQ2_MOD	GENMASK(10, 8)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQ3_MOD	GENMASK(14, 12)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQM0_MOD	GENMASK(18, 16)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQM1_MOD	GENMASK(22, 20)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQM2_MOD	GENMASK(26, 24)
	#define RK2_CURRENT_TX_SETTING4_REG_DLY_OEN_R2DQM3_MOD	GENMASK(30, 28)
#define RK2_DUMMY_RD_DATA0				0x00000820
	#define RK2_DUMMY_RD_DATA0_DUMMY_RD_RK2_DATA0	GENMASK(31, 0)
#define RK2_DUMMY_RD_DATA1				0x00000824
	#define RK2_DUMMY_RD_DATA1_DUMMY_RD_RK2_DATA1	GENMASK(31, 0)
#define RK2_DUMMY_RD_DATA2				0x00000828
	#define RK2_DUMMY_RD_DATA2_DUMMY_RD_RK2_DATA2	GENMASK(31, 0)
#define RK2_DUMMY_RD_DATA3				0x0000082c
	#define RK2_DUMMY_RD_DATA3_DUMMY_RD_RK2_DATA3	GENMASK(31, 0)
#define RK2_B0_STB_MAX_MIN_DLY				0x00000830
	#define RK2_B0_STB_MAX_MIN_DLY_RK2_B0_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK2_B0_STB_MAX_MIN_DLY_RK2_B0_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK2_B1_STB_MAX_MIN_DLY				0x00000834
	#define RK2_B1_STB_MAX_MIN_DLY_RK2_B1_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK2_B1_STB_MAX_MIN_DLY_RK2_B1_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK2_B2_STB_MAX_MIN_DLY				0x00000838
	#define RK2_B2_STB_MAX_MIN_DLY_RK2_B2_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK2_B2_STB_MAX_MIN_DLY_RK2_B2_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK2_B3_STB_MAX_MIN_DLY				0x0000083c
	#define RK2_B3_STB_MAX_MIN_DLY_RK2_B3_STBEN_MIN_DLY	GENMASK(11, 0)
	#define RK2_B3_STB_MAX_MIN_DLY_RK2_B3_STBEN_MAX_DLY	GENMASK(27, 16)
#define RK2_DQSIENDLY					0x00000840
	#define RK2_DQSIENDLY_R2DQS0IENDLY		GENMASK(6, 0)
	#define RK2_DQSIENDLY_R2DQS1IENDLY		GENMASK(14, 8)
	#define RK2_DQSIENDLY_R2DQS2IENDLY		GENMASK(22, 16)
	#define RK2_DQSIENDLY_R2DQS3IENDLY		GENMASK(30, 24)
#define RK2_DQSIENUIDLY					0x00000844
	#define RK2_DQSIENUIDLY_R2DQS0IENUIDLY		GENMASK(5, 0)
	#define RK2_DQSIENUIDLY_R2DQS1IENUIDLY		GENMASK(13, 8)
	#define RK2_DQSIENUIDLY_R2DQS2IENUIDLY		GENMASK(21, 16)
	#define RK2_DQSIENUIDLY_R2DQS3IENUIDLY		GENMASK(29, 24)
#define RK2_DQSIENUIDLY_P1				0x00000848
	#define RK2_DQSIENUIDLY_P1_R2DQS0IENUIDLY_P1	GENMASK(5, 0)
	#define RK2_DQSIENUIDLY_P1_R2DQS1IENUIDLY_P1	GENMASK(13, 8)
	#define RK2_DQSIENUIDLY_P1_R2DQS2IENUIDLY_P1	GENMASK(21, 16)
	#define RK2_DQSIENUIDLY_P1_R2DQS3IENUIDLY_P1	GENMASK(29, 24)
#define RK2_DQS_STBCALDEC_CNT1				0x00000850
	#define RK2_DQS_STBCALDEC_CNT1_RK2_DQS0_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK2_DQS_STBCALDEC_CNT1_RK2_DQS1_STBCALDEC_CNT	GENMASK(31, 16)
#define RK2_DQS_STBCALDEC_CNT2				0x00000854
	#define RK2_DQS_STBCALDEC_CNT2_RK2_DQS2_STBCALDEC_CNT	GENMASK(15, 0)
	#define RK2_DQS_STBCALDEC_CNT2_RK2_DQS3_STBCALDEC_CNT	GENMASK(31, 16)
#define RK2_DQS_STBCALINC_CNT1				0x00000858
	#define RK2_DQS_STBCALINC_CNT1_RK2_DQS0_STBCALINC_CNT	GENMASK(15, 0)
	#define RK2_DQS_STBCALINC_CNT1_RK2_DQS1_STBCALINC_CNT	GENMASK(31, 16)
#define RK2_DQS_STBCALINC_CNT2				0x0000085c
	#define RK2_DQS_STBCALINC_CNT2_RK2_DQS2_STBCALINC_CNT	GENMASK(15, 0)
	#define RK2_DQS_STBCALINC_CNT2_RK2_DQS3_STBCALINC_CNT	GENMASK(31, 16)
#define RK2_PI_DQ_CAL					0x00000860
	#define RK2_PI_DQ_CAL_RK2_ARPI_DQ_B0_CAL	GENMASK(5, 0)
	#define RK2_PI_DQ_CAL_RK2_ARPI_DQ_B1_CAL	GENMASK(13, 8)
	#define RK2_PI_DQ_CAL_PI_DQ_ADJ_RK2		GENMASK(21, 16)
	#define RK2_PI_DQ_CAL_PI_DQ_ADJ_RK2_OVERFLOW	BIT(22)
	#define RK2_PI_DQ_CAL_PI_DQ_ADJ_RK2_B1		GENMASK(29, 24)
	#define RK2_PI_DQ_CAL_PI_DQ_ADJ_RK2_B1_OVERFLOW	BIT(30)
#define RK2_DQSG_RETRY_FLAG				0x00000864
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_DONE0	BIT(0)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_DONE1	BIT(1)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_DONE2	BIT(2)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_DONE3	BIT(3)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_FAIL0	BIT(16)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_FAIL1	BIT(17)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_FAIL2	BIT(18)
	#define RK2_DQSG_RETRY_FLAG_RK2_RETRY_FAIL3	BIT(19)
#define RK2_PI_DQM_CAL					0x00000868
	#define RK2_PI_DQM_CAL_RK2_ARPI_DQM_B0_CAL	GENMASK(5, 0)
	#define RK2_PI_DQM_CAL_RK2_ARPI_DQM_B1_CAL	GENMASK(13, 8)
#define RK2_DQS0_STBCAL_CNT				0x00000870
	#define RK2_DQS0_STBCAL_CNT_R2_DQS0_STBCAL_CNT	GENMASK(16, 0)
#define RK2_DQS1_STBCAL_CNT				0x00000874
	#define RK2_DQS1_STBCAL_CNT_R2_DQS1_STBCAL_CNT	GENMASK(16, 0)
#define RK2_DQS2_STBCAL_CNT				0x00000878
	#define RK2_DQS2_STBCAL_CNT_R2_DQS2_STBCAL_CNT	GENMASK(16, 0)
#define RK2_DQS3_STBCAL_CNT				0x0000087c
	#define RK2_DQS3_STBCAL_CNT_R2_DQS3_STBCAL_CNT	GENMASK(16, 0)
#define RK2_B01_STB_DBG_INFO_00				0x00000880
	#define RK2_B01_STB_DBG_INFO_00_RK2_B0_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_00_RK2_B1_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_01				0x00000884
	#define RK2_B01_STB_DBG_INFO_01_RK2_B0_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_01_RK2_B1_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_02				0x00000888
	#define RK2_B01_STB_DBG_INFO_02_RK2_B0_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_02_RK2_B1_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_03				0x0000088c
	#define RK2_B01_STB_DBG_INFO_03_RK2_B0_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_03_RK2_B1_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_04				0x00000890
	#define RK2_B01_STB_DBG_INFO_04_RK2_B0_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_04_RK2_B1_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_05				0x00000894
	#define RK2_B01_STB_DBG_INFO_05_RK2_B0_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_05_RK2_B1_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_06				0x00000898
	#define RK2_B01_STB_DBG_INFO_06_RK2_B0_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_06_RK2_B1_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_07				0x0000089c
	#define RK2_B01_STB_DBG_INFO_07_RK2_B0_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_07_RK2_B1_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_08				0x000008a0
	#define RK2_B01_STB_DBG_INFO_08_RK2_B0_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_08_RK2_B1_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_09				0x000008a4
	#define RK2_B01_STB_DBG_INFO_09_RK2_B0_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_09_RK2_B1_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_10				0x000008a8
	#define RK2_B01_STB_DBG_INFO_10_RK2_B0_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_10_RK2_B1_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_11				0x000008ac
	#define RK2_B01_STB_DBG_INFO_11_RK2_B0_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_11_RK2_B1_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_12				0x000008b0
	#define RK2_B01_STB_DBG_INFO_12_RK2_B0_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_12_RK2_B1_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_13				0x000008b4
	#define RK2_B01_STB_DBG_INFO_13_RK2_B0_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_13_RK2_B1_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_14				0x000008b8
	#define RK2_B01_STB_DBG_INFO_14_RK2_B0_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_14_RK2_B1_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK2_B01_STB_DBG_INFO_15				0x000008bc
	#define RK2_B01_STB_DBG_INFO_15_RK2_B0_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK2_B01_STB_DBG_INFO_15_RK2_B1_STB_DBG_INFO_15	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_00				0x000008c0
	#define RK2_B23_STB_DBG_INFO_00_RK2_B2_STB_DBG_INFO_00	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_00_RK2_B3_STB_DBG_INFO_00	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_01				0x000008c4
	#define RK2_B23_STB_DBG_INFO_01_RK2_B2_STB_DBG_INFO_01	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_01_RK2_B3_STB_DBG_INFO_01	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_02				0x000008c8
	#define RK2_B23_STB_DBG_INFO_02_RK2_B2_STB_DBG_INFO_02	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_02_RK2_B3_STB_DBG_INFO_02	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_03				0x000008cc
	#define RK2_B23_STB_DBG_INFO_03_RK2_B2_STB_DBG_INFO_03	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_03_RK2_B3_STB_DBG_INFO_03	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_04				0x000008d0
	#define RK2_B23_STB_DBG_INFO_04_RK2_B2_STB_DBG_INFO_04	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_04_RK2_B3_STB_DBG_INFO_04	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_05				0x000008d4
	#define RK2_B23_STB_DBG_INFO_05_RK2_B2_STB_DBG_INFO_05	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_05_RK2_B3_STB_DBG_INFO_05	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_06				0x000008d8
	#define RK2_B23_STB_DBG_INFO_06_RK2_B2_STB_DBG_INFO_06	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_06_RK2_B3_STB_DBG_INFO_06	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_07				0x000008dc
	#define RK2_B23_STB_DBG_INFO_07_RK2_B2_STB_DBG_INFO_07	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_07_RK2_B3_STB_DBG_INFO_07	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_08				0x000008e0
	#define RK2_B23_STB_DBG_INFO_08_RK2_B2_STB_DBG_INFO_08	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_08_RK2_B3_STB_DBG_INFO_08	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_09				0x000008e4
	#define RK2_B23_STB_DBG_INFO_09_RK2_B2_STB_DBG_INFO_09	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_09_RK2_B3_STB_DBG_INFO_09	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_10				0x000008e8
	#define RK2_B23_STB_DBG_INFO_10_RK2_B2_STB_DBG_INFO_10	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_10_RK2_B3_STB_DBG_INFO_10	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_11				0x000008ec
	#define RK2_B23_STB_DBG_INFO_11_RK2_B2_STB_DBG_INFO_11	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_11_RK2_B3_STB_DBG_INFO_11	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_12				0x000008f0
	#define RK2_B23_STB_DBG_INFO_12_RK2_B2_STB_DBG_INFO_12	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_12_RK2_B3_STB_DBG_INFO_12	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_13				0x000008f4
	#define RK2_B23_STB_DBG_INFO_13_RK2_B2_STB_DBG_INFO_13	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_13_RK2_B3_STB_DBG_INFO_13	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_14				0x000008f8
	#define RK2_B23_STB_DBG_INFO_14_RK2_B2_STB_DBG_INFO_14	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_14_RK2_B3_STB_DBG_INFO_14	GENMASK(31, 16)
#define RK2_B23_STB_DBG_INFO_15				0x000008fc
	#define RK2_B23_STB_DBG_INFO_15_RK2_B2_STB_DBG_INFO_15	GENMASK(15, 0)
	#define RK2_B23_STB_DBG_INFO_15_RK2_B3_STB_DBG_INFO_15	GENMASK(31, 16)
#define DVFS_DBG0					0x00000c00
	#define DVFS_DBG0_CUT_PHY_ST_SHU_MASK		GENMASK(18, 0)
#define DVFS_DBG1					0x00000c04
	#define DVFS_DBG1_PLL_SEL_MASK			BIT(0)
	#define DVFS_DBG1_MPDIV_SHU_GP_MASK		GENMASK(6, 4)
	#define DVFS_DBG1_PICG_SHUFFLE_MASK		BIT(8)
	#define DVFS_DBG1_SHUFFLE_PHY_STATE_START_MASK	BIT(9)
	#define DVFS_DBG1_SHUFFLE_PHY_STATE_DONE_MASK	BIT(10)
	#define DVFS_DBG1_SHUFFLE_PERIOD_MASK		BIT(11)

#endif /*__DRAMC_CH0_NAO_REG_H__*/
