#ifndef __DRAMC_CH0_REG_H__
#define __DRAMC_CH0_REG_H__

/* ----------------- Register Definitions ------------------- */
#define DDRCONF0					0x00000000
	#define DDRCONF0_RDATRST			BIT(0)
	#define DDRCONF0_DMSW_RST			BIT(1)
	#define DDRCONF0_WDT_DBG_RST			BIT(2)
	#define DDRCONF0_FIFOLEN			GENMASK(5, 4)
	#define DDRCONF0_DRAMEN				BIT(7)
	#define DDRCONF0_RDQSIEN			BIT(8)
	#define DDRCONF0_DQSGCGM			BIT(9)
	#define DDRCONF0_APBL2				BIT(10)
	#define DDRCONF0_BG4EN				BIT(11)
	#define DDRCONF0_BK8EN				BIT(12)
	#define DDRCONF0_BC4OTF_OPT			BIT(13)
	#define DDRCONF0_AG0MWR				BIT(14)
	#define DDRCONF0_BC4OTF				BIT(15)
	#define DDRCONF0_GDDR3RST			BIT(16)
	#define DDRCONF0_DM16BPHSEL			BIT(17)
	#define DDRCONF0_DM16BITSWAP			BIT(18)
	#define DDRCONF0_DQ4BMUX			BIT(19)
	#define DDRCONF0_DM64BITEN			BIT(20)
	#define DDRCONF0_DM16BITFULL			BIT(21)
	#define DDRCONF0_DM4TO1MODE			BIT(22)
	#define DDRCONF0_GDDR3EN			BIT(23)
	#define DDRCONF0_LPDDR2EN			BIT(24)
	#define DDRCONF0_LPDDR3EN			BIT(25)
	#define DDRCONF0_LPDDR4EN			BIT(26)
	#define DDRCONF0_LPDDR2_NO_INT			BIT(27)
	#define DDRCONF0_DDR2EN				BIT(28)
	#define DDRCONF0_DDR3EN				BIT(29)
	#define DDRCONF0_DDR4EN				BIT(30)
	#define DDRCONF0_DRAMC_SW_RST			BIT(31)
#define DRAMCTRL					0x00000004
	#define DRAMCTRL_CTOREQ_HPRI_OPT		BIT(0)
	#define DRAMCTRL_ADRDECEN_TARKMODE		BIT(1)
	#define DRAMCTRL_ADRDECEN			BIT(2)
	#define DRAMCTRL_ADRBIT3DEC			BIT(3)
	#define DRAMCTRL_TMRR2WDIS			BIT(4)
	#define DRAMCTRL_RANK_ASYM			BIT(7)
	#define DRAMCTRL_WDATRGO			BIT(8)
	#define DRAMCTRL_CLKWITRFC			BIT(9)
	#define DRAMCTRL_CHKFORPRE			BIT(10)
	#define DRAMCTRL_ASYNCEN			BIT(12)
	#define DRAMCTRL_DYNMWREN			BIT(13)
	#define DRAMCTRL_ALEBLOCK			BIT(14)
	#define DRAMCTRL_TMRRICHKDIS			BIT(15)
	#define DRAMCTRL_DMRCDRSV			BIT(16)
	#define DRAMCTRL_TMRRIBYRK_DIS			BIT(17)
	#define DRAMCTRL_ZQCALL				BIT(18)
	#define DRAMCTRL_PREALL_OPTION			BIT(19)
	#define DRAMCTRL_TCMD				GENMASK(22, 20)
	#define DRAMCTRL_MRRIOPT			BIT(23)
	#define DRAMCTRL_FW2R				BIT(24)
	#define DRAMCTRL_REQQUE_DEPTH_UPD		BIT(25)
	#define DRAMCTRL_REQQUE_THD_EN			BIT(26)
	#define DRAMCTRL_REQQUE_MAXCNT_CHG		BIT(27)
	#define DRAMCTRL_PREA_RK			GENMASK(29, 28)
	#define DRAMCTRL_IDLE_COND_OPT			BIT(30)
#define MISCTL0						0x00000008
	#define MISCTL0_R_DMCA_IDLE_EN			BIT(0)
	#define MISCTL0_IDLE_CNT_OPT			BIT(16)
	#define MISCTL0_PAGDIS				BIT(17)
	#define MISCTL0_IDLEDCM_CNT_OPT			BIT(18)
	#define MISCTL0_REFA_ARB_EN2			BIT(19)
	#define MISCTL0_WRBYTE_CNT_OPT			BIT(20)
	#define MISCTL0_REFA_ARB_EN_OPTION		BIT(21)
	#define MISCTL0_REORDER_MASK_E1T		BIT(22)
	#define MISCTL0_PBC_ARB_E1T			BIT(23)
	#define MISCTL0_PBC_ARB_EN			BIT(24)
	#define MISCTL0_REFA_ARB_EN			BIT(25)
	#define MISCTL0_REFP_ARB_EN			BIT(26)
	#define MISCTL0_EMIPREEN			BIT(27)
	#define MISCTL0_REFP_ARB_EN2			BIT(31)
#define PERFCTL0					0x0000000c
	#define PERFCTL0_DUALSCHEN			BIT(0)
	#define PERFCTL0_DISRDPHASE1			BIT(1)
	#define PERFCTL0_XRT_05T_OPT			BIT(2)
	#define PERFCTL0_AIDCHKEN			BIT(3)
	#define PERFCTL0_RWOFOEN			BIT(4)
	#define PERFCTL0_RWOFOWNUM			GENMASK(7, 5)
	#define PERFCTL0_RWHPRIEN			BIT(8)
	#define PERFCTL0_RWLLATEN			BIT(9)
	#define PERFCTL0_RWAGEEN			BIT(10)
	#define PERFCTL0_EMILLATEN			BIT(11)
	#define PERFCTL0_LASTCMDOPT			BIT(12)
	#define PERFCTL0_RWHPRICTL			BIT(13)
	#define PERFCTL0_WFLUSHEN			BIT(14)
	#define PERFCTL0_RWSPLIT			BIT(15)
	#define PERFCTL0_MWHPRIEN			BIT(17)
	#define PERFCTL0_REORDER_MODE			BIT(18)
	#define PERFCTL0_REORDEREN			BIT(19)
	#define PERFCTL0_SBR_MASK_OPT			BIT(20)
	#define PERFCTL0_SBR_MASK_OPT2			BIT(21)
	#define PERFCTL0_MAFIXHIGH			BIT(22)
	#define PERFCTL0_TESTWRHIGH			BIT(23)
	#define PERFCTL0_RECORDER_MASK_OPT		BIT(24)
	#define PERFCTL0_MDMCU_MASK_EN			BIT(25)
	#define PERFCTL0_WRFIFO_OPT			BIT(26)
	#define PERFCTL0_WRFIO_MODE2			BIT(27)
	#define PERFCTL0_RDFIFOEN			BIT(30)
	#define PERFCTL0_WRFIFOEN			BIT(31)
#define ARBCTL						0x00000010
	#define ARBCTL_MAXPENDCNT			GENMASK(7, 0)
	#define ARBCTL_RDATACNTDIS			BIT(8)
	#define ARBCTL_WDATACNTDIS			BIT(9)
	#define ARBCTL_RSV_SA0				BIT(10)
	#define ARBCTL_RSV_SA1				BIT(11)
	#define ARBCTL_RSV_SA2				BIT(12)
	#define ARBCTL_RSV_SA3				BIT(13)
	#define ARBCTL_RSV_DRAM_CBT			BIT(13) //cc add
	#define ARBCTL_RSV_DRAM_TYPE		GENMASK(12, 10)//cc add
	#define ARBCTL_DBIWR_IMP_EN			BIT(14)
	#define ARBCTL_DBIWR_PINMUX_EN			BIT(15)
	#define ARBCTL_DBIWR_OPT_B0			GENMASK(23, 16)
	#define ARBCTL_DBIWR_OPT_bit1_0 	GENMASK(17, 16)//cc add
	#define ARBCTL_DBIWR_OPT_bit7		GENMASK(23, 23)//cc add
	#define ARBCTL_DBIWR_OPT_B1			GENMASK(31, 24)
	#define ARBCTL_DBIWR_OPT_bit9_8		GENMASK(25, 24)//cc add
	#define ARBCTL_DBIWR_OPT_bit15		GENMASK(31, 31)//cc add
#define RSTMASK						0x0000001c
	#define RSTMASK_WDATKEY0			BIT(0)
	#define RSTMASK_WDATKEY1			BIT(1)
	#define RSTMASK_WDATKEY2			BIT(2)
	#define RSTMASK_WDATKEY3			BIT(3)
	#define RSTMASK_WDATKEY4			BIT(4)
	#define RSTMASK_WDATKEY5			BIT(5)
	#define RSTMASK_WDATKEY6			BIT(6)
	#define RSTMASK_WDATKEY7			BIT(7)
	#define RSTMASK_WDATITLV			BIT(8)
	#define RSTMASK_RSV_SA_BU2			GENMASK(15, 12) //cc add
	#define RSTMASK_RSV_DRAM_CBT_MIXED	GENMASK(14, 13) //cc add
	#define RSTMASK_RSV_DRAM_SUPPORT_RANK_NUM	BIT(12) //cc add
	#define RSTMASK_RETRY_DATRST_MASK		BIT(21)
	#define RSTMASK_DVFS_SYNC_MASK_FOR_PHY		BIT(24)
	#define RSTMASK_GT_SYNC_MASK_FOR_PHY		BIT(25)
	#define RSTMASK_DVFS_SYNC_MASK			BIT(26)
	#define RSTMASK_GTDMW_SYNC_MASK			BIT(27)
	#define RSTMASK_GT_SYNC_MASK			BIT(28)
	#define RSTMASK_DAT_SYNC_MASK			BIT(29)
	#define RSTMASK_PHY_SYNC_MASK			BIT(30)
	#define RSTMASK_R_DMSHU_RDATRST_MASK		BIT(31)
#define PADCTRL						0x00000020
	#define PADCTRL_DQIENQKEND			GENMASK(1, 0)
	#define PADCTRL_DQIENLATEBEGIN			BIT(3)
	#define PADCTRL_DISDMOEDIS			BIT(8)
	#define PADCTRL_DRAMOEN				BIT(12)
	#define PADCTRL_FIXDQIEN			GENMASK(19, 16)
	#define PADCTRL_DISDQIEN			GENMASK(23, 20)
	#define PADCTRL_PINMUX				GENMASK(30, 28)
#define CKECTRL						0x00000024
	#define CKECTRL_CKEBYCTL			BIT(0)
	#define CKECTRL_CKE2RANK_OPT3			BIT(1)
	#define CKECTRL_CKE2FIXON			BIT(2)
	#define CKECTRL_CKE2FIXOFF			BIT(3)
	#define CKECTRL_CKE1FIXON			BIT(4)
	#define CKECTRL_CKE1FIXOFF			BIT(5)
	#define CKECTRL_CKEFIXON			BIT(6)
	#define CKECTRL_CKEFIXOFF			BIT(7)
	#define CKECTRL_CKE2RANK_OPT5			BIT(8)
	#define CKECTRL_CKE2RANK_OPT6			BIT(9)
	#define CKECTRL_CKE2RANK_OPT7			BIT(10)
	#define CKECTRL_CKE2RANK_OPT8			BIT(11)
	#define CKECTRL_CKEEXTEND			BIT(12)
	#define CKECTRL_CKETIMER_SEL			BIT(13)
	#define CKECTRL_FASTWAKE_SEL			BIT(14)
	#define CKECTRL_CKEWAKE_SEL			BIT(15)
	#define CKECTRL_CKEWAKE_SEL2			BIT(16)
	#define CKECTRL_CKE2RANK_OPT9			BIT(17)
	#define CKECTRL_CKE2RANK_OPT10			BIT(18)
	#define CKECTRL_CKE2RANK_OPT11			BIT(19)
	#define CKECTRL_CKE2RANK_OPT12			BIT(20)
	#define CKECTRL_CKE2RANK_OPT13			BIT(21)
	#define CKECTRL_CKEPBDIS			BIT(22)
	#define CKECTRL_CKELCKFIX			BIT(23)
	#define CKECTRL_CKELCKCNT			GENMASK(26, 24)
	#define CKECTRL_RUNTIMEMRRCKEFIX		BIT(27)
	#define CKECTRL_RUNTIMEMRRMIODIS		BIT(28)
	#define CKECTRL_CKE_H2L_OPT			BIT(29)
	#define CKECTRL_CKEON				BIT(31)
#define DRSCTRL						0x00000028
	#define DRSCTRL_DRSDIS				BIT(0)
	#define DRSCTRL_DRSBLOCKOPT			BIT(1)
	#define DRSCTRL_DRSPB2AB_OPT			BIT(2)
	#define DRSCTRL_DRSRK1_SW			BIT(3)
	#define DRSCTRL_DRSMON_CLR			BIT(4)
	#define DRSCTRL_DRSCLR_EN			BIT(5)
	#define DRSCTRL_DRSACKWAITREF			BIT(6)
	#define DRSCTRL_DRSCLR_RK0_EN			BIT(7)
	#define DRSCTRL_DRSDLY				GENMASK(11, 8)
	#define DRSCTRL_DRS_CNTX			GENMASK(18, 12)
	#define DRSCTRL_DRS_SELFWAKE_DMYRD_DIS		BIT(19)
	#define DRSCTRL_DRS_DMYRD_MIOCK_OPT		BIT(20)
	#define DRSCTRL_DRSOPT2				BIT(21)
	#define DRSCTRL_DRS_MR4_OPT_B			BIT(24)
	#define DRSCTRL_RK_SCINPUT_OPT			BIT(29)
#define RKCFG						0x00000034
	#define RKCFG_TXRANK				GENMASK(1, 0)
	#define RKCFG_CKE2RANK_OPT2			BIT(2)
	#define RKCFG_TXRANKFIX				BIT(3)
	#define RKCFG_RKMODE				GENMASK(6, 4)
	#define RKCFG_RKSWAP				BIT(7)
	#define RKCFG_DM3RANK				BIT(8)
	#define RKCFG_RANKRDY_OPT			BIT(9)
	#define RKCFG_MRS2RK				BIT(10)
	#define RKCFG_DQSOSC2RK				BIT(11)
	#define RKCFG_CKE2RANK				BIT(12)
	#define RKCFG_CS2RANK				BIT(13)
	#define RKCFG_SHU2RKOPT				BIT(14)
	#define RKCFG_CKE2RANK_OPT			BIT(15)
	#define RKCFG_RKSIZE				GENMASK(18, 16)
	#define RKCFG_DMCKEWAKE				BIT(19)
	#define RKCFG_RK0SRF				BIT(20)
	#define RKCFG_RK1SRF				BIT(21)
	#define RKCFG_RK2SRF				BIT(22)
	#define RKCFG_SRF_ENTER_MASK_OPT		BIT(23)
	#define RKCFG_RK0DPD				BIT(24)
	#define RKCFG_RK1DPD				BIT(25)
	#define RKCFG_RK2DPD				BIT(26)
	#define RKCFG_RK0DPDX				BIT(28)
	#define RKCFG_RK1DPDX				BIT(29)
	#define RKCFG_RK2DPDX				BIT(30)
	#define RKCFG_CS0FORCE				BIT(31)
#define DRAMC_PD_CTRL					0x00000038
	#define DRAMC_PD_CTRL_DCMEN			BIT(0)
	#define DRAMC_PD_CTRL_DCMEN2			BIT(1)
	#define DRAMC_PD_CTRL_DCMENNOTRFC		BIT(2)
	#define DRAMC_PD_CTRL_PHYCLK_REFWKEN		BIT(4)
	#define DRAMC_PD_CTRL_COMBPHY_CLKENSAME		BIT(5)
	#define DRAMC_PD_CTRL_DCMREF_OPT		BIT(8)
	#define DRAMC_PD_CTRL_PG_DCM_OPT		BIT(9)
	#define DRAMC_PD_CTRL_COMB_DCM			BIT(10)
	#define DRAMC_PD_CTRL_RDPERIODON		BIT(19)
	#define DRAMC_PD_CTRL_DQIEN_BUFFEN_OPT		GENMASK(21, 20)
	#define DRAMC_PD_CTRL_MIOCKCTRLOFF		BIT(26)
	#define DRAMC_PD_CTRL_DISSTOP26M		BIT(27)
	#define DRAMC_PD_CTRL_PHYCLKDYNGEN		BIT(30)
	#define DRAMC_PD_CTRL_COMBCLKCTRL		BIT(31)
#define CLKAR						0x0000003c
	#define CLKAR_REQQUE_PACG_DIS			GENMASK(14, 0)
	#define CLKAR_SELPH_CMD_CG_DIS			BIT(15)
	#define CLKAR_RDATCKAR				BIT(16)
	#define CLKAR_SRF_CLKRUN			BIT(17)
	#define CLKAR_IDLE_OPT				BIT(18)
	#define CLKAR_PSELAR				BIT(19)
	#define CLKAR_BCLKAR				BIT(20)
	#define CLKAR_SELPH_4LCG_DIS			BIT(21)
	#define CLKAR_SELPH_CG_DIS			BIT(22)
	#define CLKAR_TESTCLKRUN			BIT(23)
	#define CLKAR_PHYGLUECLKRUN			BIT(24)
	#define CLKAR_DWCLKRUN				BIT(25)
	#define CLKAR_REFCLKRUN				BIT(26)
	#define CLKAR_REQQUECLKRUN			BIT(27)
	#define CLKAR_SEQCLKRUN				BIT(28)
	#define CLKAR_CALCKAR				BIT(29)
	#define CLKAR_CMDCKAR				BIT(30)
	#define CLKAR_RDYCKAR				BIT(31)
#define CLKCTRL						0x00000040
	#define CLKCTRL_PSEL_CNT			GENMASK(5, 0)
	#define CLKCTRL_SEQCLKRUN3			BIT(7)
	#define CLKCTRL_SEQCLKRUN2			BIT(8)
	#define CLKCTRL_CLK_EN_0			BIT(28)
	#define CLKCTRL_CLK_EN_1			BIT(29)
#define SELFREF_HWSAVE_FLAG				0x00000044
	#define SELFREF_HWSAVE_FLAG_SELFREF_HWSAVE_FLAG_FROM_AO	BIT(0)
#define SREFCTRL					0x00000048
	#define SREFCTRL_HMRRSEL_CGAR			BIT(12)
	#define SREFCTRL_RDDQSOSC_CGAR			BIT(13)
	#define SREFCTRL_SCARB_SM_CGAR			BIT(14)
	#define SREFCTRL_SCSM_CGAR			BIT(15)
	#define SREFCTRL_SRFPD_DIS			BIT(16)
	#define SREFCTRL_DQSOSC_THRD_OPT		BIT(17)
	#define SREFCTRL_DQSOSC_C2R_OPT			BIT(18)
	#define SREFCTRL_SREF3_OPTION			BIT(20)
	#define SREFCTRL_SREF3_OPTION1			BIT(21)
	#define SREFCTRL_SREF2_OPTION			BIT(22)
	#define SREFCTRL_SREFDLY			GENMASK(27, 24)
	#define SREFCTRL_SREF_HW_EN			BIT(30)
	#define SREFCTRL_SELFREF			BIT(31)
#define REFCTRL0					0x0000004c
	#define REFCTRL0_DLLFRZ				BIT(0)
	#define REFCTRL0_UPDBYWR			BIT(1)
	#define REFCTRL0_DRVCGWREF			BIT(2)
	#define REFCTRL0_DQDRVSWUPD			BIT(3)
	#define REFCTRL0_RFRINTCTL			BIT(5)
	#define REFCTRL0_RFRINTEN			BIT(6)
	#define REFCTRL0_REFOVERCNT_RST			BIT(7)
	#define REFCTRL0_DMPGVLD_IG			BIT(8)
	#define REFCTRL0_REFMODE_MANUAL			BIT(10)
	#define REFCTRL0_REFMODE_MANUAL_TRIG		BIT(11)
	#define REFCTRL0_DISBYREFNUM			GENMASK(14, 12)
	#define REFCTRL0_PBREF_DISBYREFNUM		BIT(16)
	#define REFCTRL0_PBREF_DISBYRATE		BIT(17)
	#define REFCTRL0_PBREFEN			BIT(18)
	#define REFCTRL0_ADVREF_CNT			GENMASK(23, 20)
	#define REFCTRL0_REF_PREGATE_CNT		GENMASK(27, 24)
	#define REFCTRL0_REFNA_OPT			BIT(28)
	#define REFCTRL0_REFDIS				BIT(29)
	#define REFCTRL0_REFFRERUN			BIT(30)
	#define REFCTRL0_REFBW_FREN			BIT(31)
#define REFCTRL1					0x00000050
	#define REFCTRL1_SLEFREF_AUTOSAVE_EN		BIT(0)
	#define REFCTRL1_SREF_PRD_OPT			BIT(1)
	#define REFCTRL1_PSEL_OPT2			BIT(2)
	#define REFCTRL1_PSEL_OPT3			BIT(3)
	#define REFCTRL1_PRE8REF			BIT(4)
	#define REFCTRL1_REF_QUE_AUTOSAVE_EN		BIT(5)
	#define REFCTRL1_PSEL_OPT1			BIT(6)
	#define REFCTRL1_SREF_CG_OPT			BIT(7)
	#define REFCTRL1_MPENDREF_CNT			GENMASK(10, 8)
	#define REFCTRL1_REFRATE_MON_CLR		BIT(11)
	#define REFCTRL1_REFRATE_MANUAL			GENMASK(30, 28)
	#define REFCTRL1_REFRATE_MANUAL_RATE_TRIG	BIT(31)
#define REFRATRE_FILTER					0x00000054
	#define REFRATRE_FILTER_REFRATE_FIL0		GENMASK(2, 0)
	#define REFRATRE_FILTER_REFRATE_FIL1		GENMASK(6, 4)
	#define REFRATRE_FILTER_REFRATE_FIL2		GENMASK(10, 8)
	#define REFRATRE_FILTER_REFRATE_FIL3		GENMASK(14, 12)
	#define REFRATRE_FILTER_PB2AB_OPT		BIT(15)
	#define REFRATRE_FILTER_REFRATE_FIL4		GENMASK(18, 16)
	#define REFRATRE_FILTER_REFRATE_FIL5		GENMASK(22, 20)
	#define REFRATRE_FILTER_PB2AB_OPT1		BIT(23)
	#define REFRATRE_FILTER_REFRATE_FIL6		GENMASK(26, 24)
	#define REFRATRE_FILTER_REFRATE_FIL7		GENMASK(30, 28)
	#define REFRATRE_FILTER_REFRATE_FILEN		BIT(31)
#define ZQCS						0x00000058
	#define ZQCS_ZQCSOP				GENMASK(7, 0)
	#define ZQCS_ZQCSAD				GENMASK(15, 8)
	#define ZQCS_ZQCS_MASK_SEL			GENMASK(18, 16)
	#define ZQCS_ZQCS_MASK_SEL_CGAR			BIT(19)
	#define ZQCS_ZQMASK_CGAR			BIT(20)
	#define ZQCS_ZQCSMASK_OPT			BIT(21)
	#define ZQCS_ZQ_SRF_OPT				BIT(22)
	#define ZQCS_ZQCSMASK				BIT(30)
	#define ZQCS_ZQCSDUAL				BIT(31)
#define MRS						0x0000005c
	#define MRS_MRSOP				GENMASK(7, 0)
	#define MRS_MRSMA				GENMASK(20, 8)
	#define MRS_MRSBA				GENMASK(23, 21)
	#define MRS_MRSRK				GENMASK(25, 24)
	#define MRS_MRRRK				GENMASK(27, 26)
	#define MRS_MPCRK				GENMASK(29, 28)
	#define MRS_MRSBG				GENMASK(31, 30)
#define SPCMD						0x00000060
	#define SPCMD_MRWEN				BIT(0)
	#define SPCMD_MRREN				BIT(1)
	#define SPCMD_PREAEN				BIT(2)
	#define SPCMD_AREFEN				BIT(3)
	#define SPCMD_ZQCEN				BIT(4)
	#define SPCMD_TCMDEN				BIT(5)
	#define SPCMD_ZQLATEN				BIT(6)
	#define SPCMD_RDDQCEN				BIT(7)
	#define SPCMD_DQSGCNTEN				BIT(8)
	#define SPCMD_DQSGCNTRST			BIT(9)
	#define SPCMD_DQSOSCENEN			BIT(10)
	#define SPCMD_DQSOSCDISEN			BIT(11)
	#define SPCMD_ACTEN				BIT(12)
	#define SPCMD_MPRWEN				BIT(13)
#define SPCMDCTRL					0x00000064
	#define SPCMDCTRL_SC_PG_UPD_OPT			BIT(0)//cc add
	#define SPCMDCTRL_SC_PG_MAN_DIS 		BIT(1)//cc add
	#define SPCMDCTRL_SPREA_EN				BIT(2)//cc add
	#define SPCMDCTRL_SCARB_PRI_OPT			BIT(4)
	#define SPCMDCTRL_MRRSWUPD			BIT(5)
	#define SPCMDCTRL_R_DMDVFSMRW_EN		BIT(6)
	#define SPCMDCTRL_DPDWOSC			BIT(7)
	#define SPCMDCTRL_SC_PG_MPRW_DIS	BIT(10)//cc add
	#define SPCMDCTRL_SC_PG_STCMD_AREF_DIS	BIT(9)//cc add
	#define SPCMDCTRL_SC_PG_OPT2_DIS	BIT(8)//cc add
	#define SPCMDCTRL_RDDQCDIS			BIT(11)
	#define SPCMDCTRL_HMR4_TOG_OPT		BIT(18)//cc add
	#define SPCMDCTRL_SCPRE				BIT(19)
	#define SPCMDCTRL_ZQCS_NONMASK_CLR		BIT(20)
	#define SPCMDCTRL_ZQCS_MASK_FIX			BIT(21)
	#define SPCMDCTRL_ZQCS_MASK_VALUE		BIT(22)
	#define SPCMDCTRL_SRFMR4_CNTKEEP_B		BIT(24)
	#define SPCMDCTRL_MRWWOPRA			BIT(25)
	#define SPCMDCTRL_CLR_EN			BIT(26)
	#define SPCMDCTRL_MRRREFUPD_B			BIT(27)
	#define SPCMDCTRL_REFR_BLOCKEN			BIT(28)
	#define SPCMDCTRL_REFRDIS			BIT(29)
	#define SPCMDCTRL_ZQCALDISB			BIT(30)
	#define SPCMDCTRL_ZQCSDISB			BIT(31)
#define PPR_CTRL					0x00000068
	#define PPR_CTRL_ACTEN_BK			GENMASK(14, 12)
	#define PPR_CTRL_ACTEN_ROW			GENMASK(31, 16)
#define MPC_OPTION					0x0000006c
	#define MPC_OPTION_MPC_BLOCKALE_OPT		BIT(0)
	#define MPC_OPTION_MPC_BLOCKALE_OPT1		BIT(1)
	#define MPC_OPTION_MPC_BLOCKALE_OPT2		BIT(2)
	#define MPC_OPTION_ZQ_BLOCKALE_OPT		BIT(3)
	#define MPC_OPTION_RW2ZQLAT_OPT			BIT(4)
	#define MPC_OPTION_MPCOP			GENMASK(14, 8)
	#define MPC_OPTION_MPCMANEN			BIT(15)
	#define MPC_OPTION_MPCMAN_CAS2EN		BIT(16)
	#define MPC_OPTION_MPCRKEN			BIT(17)
#define REFQUE_CNT					0x00000070
	#define REFQUE_CNT_REFRESH_QUEUE_CNT_FROM_AO	GENMASK(3, 0)
#define HW_MRR_FUN					0x00000074
	#define HW_MRR_FUN_TMRR_ENA			BIT(0)
	#define HW_MRR_FUN_TRCDMRR_EN			BIT(1)
	#define HW_MRR_FUN_TRPMRR_EN			BIT(2)
	#define HW_MRR_FUN_MANTMRR_EN			BIT(3)
	#define HW_MRR_FUN_MANTMRR			GENMASK(7, 4)
	#define HW_MRR_FUN_BUFEN_RFC_OPT		BIT(8)
	#define HW_MRR_FUN_MRR_REQNOPUSH_DIS		BIT(9)
	#define HW_MRR_FUN_MRR_BLOCK_NOR_DIS		BIT(10)
	#define HW_MRR_FUN_MRR_HW_HIPRI			BIT(11)
	#define HW_MRR_FUN_MRR_SPCMD_WAKE_DIS		BIT(12)
	#define HW_MRR_FUN_TMRR_OE_OPT_DIS		BIT(13)
	#define HW_MRR_FUN_MRR_PUSH2POP_ENA		BIT(16)
	#define HW_MRR_FUN_MRR_PUSH2POP_CLR		BIT(17)
	#define HW_MRR_FUN_MRR_PUSH2POP_ST_CLR		BIT(18)
	#define HW_MRR_FUN_MRR_PUSH2POP_SEL		GENMASK(22, 20)
	#define HW_MRR_FUN_MRR_SBR3_BKVA_DIS		BIT(23)
	#define HW_MRR_FUN_MRR_DDRCLKCOMB_DIS		BIT(24)
	#define HW_MRR_FUN_TRPRCD_DIS_OPT1		BIT(25)
	#define HW_MRR_FUN_TRPRCD_OPT2			BIT(26)
	#define HW_MRR_FUN_MRR_SBR2_QHIT_DIS		BIT(27)
	#define HW_MRR_FUN_MRR_INPUT_BANK		GENMASK(30, 28)
	#define HW_MRR_FUN_MRR_TZQCS_DIS		BIT(31)
#define MRR_BIT_MUX1					0x00000078
	#define MRR_BIT_MUX1_MRR_BIT0_SEL		GENMASK(4, 0)
	#define MRR_BIT_MUX1_MRR_BIT1_SEL		GENMASK(12, 8)
	#define MRR_BIT_MUX1_MRR_BIT2_SEL		GENMASK(20, 16)
	#define MRR_BIT_MUX1_MRR_BIT3_SEL		GENMASK(28, 24)
#define MRR_BIT_MUX2					0x0000007c
	#define MRR_BIT_MUX2_MRR_BIT4_SEL		GENMASK(4, 0)
	#define MRR_BIT_MUX2_MRR_BIT5_SEL		GENMASK(12, 8)
	#define MRR_BIT_MUX2_MRR_BIT6_SEL		GENMASK(20, 16)
	#define MRR_BIT_MUX2_MRR_BIT7_SEL		GENMASK(28, 24)
#define MRR_BIT_MUX3					0x00000080
	#define MRR_BIT_MUX3_MRR_BIT8_SEL		GENMASK(4, 0)
	#define MRR_BIT_MUX3_MRR_BIT9_SEL		GENMASK(12, 8)
	#define MRR_BIT_MUX3_MRR_BIT10_SEL		GENMASK(20, 16)
	#define MRR_BIT_MUX3_MRR_BIT11_SEL		GENMASK(28, 24)
#define MRR_BIT_MUX4					0x00000084
	#define MRR_BIT_MUX4_MRR_BIT12_SEL		GENMASK(4, 0)
	#define MRR_BIT_MUX4_MRR_BIT13_SEL		GENMASK(12, 8)
	#define MRR_BIT_MUX4_MRR_BIT14_SEL		GENMASK(20, 16)
	#define MRR_BIT_MUX4_MRR_BIT15_SEL		GENMASK(28, 24)
#define TEST2_5						0x0000008c
	#define TEST2_5_TEST2_BASE_2			GENMASK(31, 4)
#define TEST2_0						0x00000090
	#define TEST2_0_TEST2_PAT1			GENMASK(7, 0)
	#define TEST2_0_TEST2_PAT0			GENMASK(15, 8)
#define TEST2_1						0x00000094
	#define TEST2_1_TEST2_BASE			GENMASK(31, 4)
#define TEST2_2						0x00000098
	#define TEST2_2_TEST2_OFF			GENMASK(31, 4)
#define TEST2_3						0x0000009c
	#define TEST2_3_TESTCNT				GENMASK(3, 0)
	#define TEST2_3_DQSICALEN			BIT(4)
	#define TEST2_3_DQSICALUPD			BIT(5)
	#define TEST2_3_PSTWR2				BIT(6)
	#define TEST2_3_TESTAUDPAT			BIT(7)
	#define TEST2_3_DQSICALSTP			GENMASK(10, 8)
	#define TEST2_3_DQDLYAUTO			BIT(11)
	#define TEST2_3_MANUDLLFRZ			BIT(12)
	#define TEST2_3_MANUDQSUPD			BIT(13)
	#define TEST2_3_DQSUPDMODE			BIT(14)
	#define TEST2_3_DRDELSWEN			BIT(19)
	#define TEST2_3_DRDELSWSEL			GENMASK(22, 20)
	#define TEST2_3_MDQS				BIT(23)
	#define TEST2_3_DMPAT32				BIT(24)
	#define TEST2_3_TESTADR_SHIFT			BIT(25)
	#define TEST2_3_TAHPRI_B			BIT(26)
	#define TEST2_3_TESTLP				BIT(27)
	#define TEST2_3_TEST2WREN2_HW_EN		BIT(28)
	#define TEST2_3_TEST1				BIT(29)
	#define TEST2_3_TEST2R				BIT(30)
	#define TEST2_3_TEST2W				BIT(31)
#define TEST2_4						0x000000a0
	#define TEST2_4_TESTAUDINC			GENMASK(4, 0)
	#define TEST2_4_TEST2DISSCRAM			BIT(5)
	#define TEST2_4_TESTSSOPAT			BIT(6)
	#define TEST2_4_TESTSSOXTALKPAT			BIT(7)
	#define TEST2_4_TESTAUDINIT			GENMASK(12, 8)
	#define TEST2_4_TESTAUDBITINV			BIT(14)
	#define TEST2_4_TESTAUDMODE			BIT(15)
	#define TEST2_4_TESTXTALKPAT			BIT(16)
	#define TEST2_4_TEST_REQ_LEN1			BIT(17)
	#define TEST2_4_DISMASK				BIT(20)
	#define TEST2_4_DQCALDIS			BIT(22)
	#define TEST2_4_NEGDQS				BIT(23)
	#define TEST2_4_TESTAGENTRK			GENMASK(25, 24)
	#define TEST2_4_TESTAGENTRKSEL			GENMASK(30, 28)
#define WDT_DBG_SIGNAL					0x000000a4
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_CPT2_RK0	BIT(0)
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_CPT2_RK1	BIT(1)
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_ERR2_RK0	BIT(2)
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DM_CMP_ERR2_RK1	BIT(3)
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DLE_CNT_OK2_RK0	BIT(4)
	#define WDT_DBG_SIGNAL_LATCH_RD_TEST_DLE_CNT_OK2_RK1	BIT(5)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_CPT2_RK0	BIT(8)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_CPT2_RK1	BIT(9)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_ERR2_RK0	BIT(10)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DM_CMP_ERR2_RK1	BIT(11)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DLE_CNT_OK2_RK0	BIT(12)
	#define WDT_DBG_SIGNAL_LATCH_RDWR_TEST_DLE_CNT_OK2_RK1	BIT(13)
	#define WDT_DBG_SIGNAL_LATCH_DRAMC_GATING_ERROR	BIT(14)
#define LBTEST						0x000000ac
	#define LBTEST_LBTEST_IGB0			BIT(0)
	#define LBTEST_LBTEST_IGB1			BIT(1)
	#define LBTEST_LBTEST_IGB2			BIT(2)
	#define LBTEST_LBTEST_IGB3			BIT(3)
	#define LBTEST_LBTEST				BIT(4)
	#define LBTEST_LBTEST_MODE			BIT(5)
	#define LBTEST_R_EXTLB_DRAMC_CONF_I		GENMASK(12, 8)
	#define LBTEST_OCDPAT				GENMASK(23, 16)
	#define LBTEST_OCDADJ				BIT(24)
	#define LBTEST_RDCOLADR				BIT(29)
	#define LBTEST_RDWRDATA				BIT(30)
	#define LBTEST_RDTGDATA				BIT(31)
#define CATRAINING1					0x000000b0
	#define CATRAINING1_CATRAINEN			BIT(1)
	#define CATRAINING1_CATRAINMRS			BIT(2)
	#define CATRAINING1_TESTCATRAIN			BIT(5)
	#define CATRAINING1_CSTRAIN_OPTION		BIT(6)
	#define CATRAINING1_CATRAINCSEXT		BIT(13)
	#define CATRAINING1_CATRAINLAT			GENMASK(23, 20)
	#define CATRAINING1_CATRAIN_INTV		GENMASK(31, 24)
#define CATRAINING2					0x000000b4
	#define CATRAINING2_CATRAINCA			GENMASK(15, 0)
	#define CATRAINING2_CATRAINCA_Y			GENMASK(31, 16)
#define WRITE_LEV					0x000000bc
	#define WRITE_LEV_WRITE_LEVEL_EN		BIT(0)
	#define WRITE_LEV_DDRPHY_COMB_CG_SEL		BIT(2)
	#define WRITE_LEV_BYTEMODECBTEN			BIT(3)
	#define WRITE_LEV_BTCBTFIXDQSOE			BIT(4)
	#define WRITE_LEV_CBTMASKDQSOE			BIT(5)
	#define WRITE_LEV_DQS_OE_WLEV_OP		BIT(6)
	#define WRITE_LEV_DQS_WLEV			BIT(7)
	#define WRITE_LEV_DQSBX_G			GENMASK(11, 8)
	#define WRITE_LEV_DQSBY_G			GENMASK(15, 12)
	#define WRITE_LEV_DQS_SEL			GENMASK(19, 16)
	#define WRITE_LEV_DMVREFCA			GENMASK(27, 20)
	#define WRITE_LEV_DQS_OE_OP1_DIS		BIT(28)
	#define WRITE_LEV_DQS_OE_OP2_EN			BIT(29)
#define MR_GOLDEN					0x000000c0
	#define MR_GOLDEN_MR20_GOLDEN			GENMASK(7, 0)
	#define MR_GOLDEN_MR15_GOLDEN			GENMASK(15, 8)
	#define MR_GOLDEN_MR40_GOLDEN			GENMASK(23, 16)
	#define MR_GOLDEN_MR32_GOLDEN			GENMASK(31, 24)
#define SLP4_TESTMODE					0x000000c4
	#define SLP4_TESTMODE_CA0_TEST			GENMASK(3, 0)
	#define SLP4_TESTMODE_CA1_TEST			GENMASK(7, 4)
	#define SLP4_TESTMODE_CA2_TEST			GENMASK(11, 8)
	#define SLP4_TESTMODE_CA3_TEST			GENMASK(15, 12)
	#define SLP4_TESTMODE_CA4_TEST			GENMASK(19, 16)
	#define SLP4_TESTMODE_CA5_TEST			GENMASK(23, 20)
	#define SLP4_TESTMODE_STESTEN			BIT(24)
	#define SLP4_TESTMODE_SPEC_MODE			BIT(25)
	#define SLP4_TESTMODE_ARPI_CAL_E2OPT		BIT(26)
	#define SLP4_TESTMODE_TX_DLY_CAL_E2OPT		BIT(27)
#define DQSOSCR						0x000000c8
	#define DQSOSCR_DQSOSC_INTEN			BIT(0)
	#define DQSOSCR_RK2_BYTE_MODE			BIT(1)
	#define DQSOSCR_TXUPD_BLOCK_SEL			GENMASK(3, 2)
	#define DQSOSCR_TXUPD_BLOCK_OPT			BIT(4)
	#define DQSOSCR_TXUPDMODE			BIT(5)
	#define DQSOSCR_MANUTXUPD			BIT(6)
	#define DQSOSCR_ARUIDQ_SW			BIT(7)
	#define DQSOSCR_DQS2DQ_UPD_BLOCK_CNT		GENMASK(12, 8)
	#define DQSOSCR_TDQS2DQ_UPD_BLOCKING		BIT(13)
	#define DQSOSCR_DQS2DQ_UPD_MON_OPT		BIT(14)
	#define DQSOSCR_DQS2DQ_UPD_MON_CNT_SEL		GENMASK(16, 15)
	#define DQSOSCR_TXUPD_IDLE_SEL			GENMASK(18, 17)
	#define DQSOSCR_TXUPD_ABREF_SEL			GENMASK(20, 19)
	#define DQSOSCR_TXUPD_IDLE_OPT			BIT(21)
	#define DQSOSCR_DQS2DQ_SHU_HW_CAL_DIS		BIT(22)
	#define DQSOSCR_SREF_TXUI_RELOAD_OPT		BIT(23)
	#define DQSOSCR_DQSOSCRDIS			BIT(24)
	#define DQSOSCR_RK1_BYTE_MODE			BIT(25)
	#define DQSOSCR_RK0_BYTE_MODE			BIT(26)
	#define DQSOSCR_SREF_TXPI_RELOAD_OPT		BIT(27)
	#define DQSOSCR_EMPTY_WRITE_OPT			BIT(28)
	#define DQSOSCR_TXUPD_ABREF_OPT			BIT(29)
	#define DQSOSCR_DQSOSCLOPAD			BIT(30)
	#define DQSOSCR_DQSOSC_CALEN			BIT(31)
#define DUMMY_RD					0x000000d0
	#define DUMMY_RD_SREF_DMYRD_MASK		BIT(0)
	#define DUMMY_RD_DMYRDOFOEN			BIT(1)
	#define DUMMY_RD_DUMMY_RD_SW			BIT(4)
	#define DUMMY_RD_DMYWR_LPRI_EN			BIT(5)
	#define DUMMY_RD_DMY_WR_DBG			BIT(6)
	#define DUMMY_RD_DMY_RD_DBG			BIT(7)
	#define DUMMY_RD_DUMMY_RD_CNT0			BIT(8)
	#define DUMMY_RD_DUMMY_RD_CNT1			BIT(9)
	#define DUMMY_RD_DUMMY_RD_CNT2			BIT(10)
	#define DUMMY_RD_DUMMY_RD_CNT3			BIT(11)
	#define DUMMY_RD_DUMMY_RD_CNT4			BIT(12)
	#define DUMMY_RD_DUMMY_RD_CNT5			BIT(13)
	#define DUMMY_RD_DUMMY_RD_CNT6			BIT(14)
	#define DUMMY_RD_DUMMY_RD_CNT7			BIT(15)
	#define DUMMY_RD_RANK_NUM			GENMASK(17, 16)
	#define DUMMY_RD_DUMMY_RD_EN			BIT(20)
	#define DUMMY_RD_SREF_DMYRD_EN			BIT(21)
	#define DUMMY_RD_DQSG_DMYRD_EN			BIT(22)
	#define DUMMY_RD_DQSG_DMYWR_EN			BIT(23)
	#define DUMMY_RD_DUMMY_RD_PA_OPT		BIT(24)
	#define DUMMY_RD_DMY_RD_RX_TRACK		BIT(25)
	#define DUMMY_RD_DMYRD_HPRI_DIS			BIT(26)
	#define DUMMY_RD_DMYRD_REORDER_DIS		BIT(27)
#define SHUCTRL						0x000000d4
	#define SHUCTRL_R_SHUFFLE_BLOCK_OPT		GENMASK(1, 0)
	#define SHUCTRL_DVFS_CG_OPT			BIT(2)
	#define SHUCTRL_VRCG_EN				BIT(4)
	#define SHUCTRL_SHU_PHYRST_SEL			BIT(5)
	#define SHUCTRL_R_DVFS_PICG_MARGIN2		GENMASK(7, 6)
	#define SHUCTRL_DMSHU_CNT			GENMASK(13, 8)
	#define SHUCTRL_SHUCTRL_RESERVED		GENMASK(15, 14)
	#define SHUCTRL_LPSM_BYPASS_B			BIT(16)
	#define SHUCTRL_R_DRAMC_CHA			BIT(17)
	#define SHUCTRL_DVFS_CHB_SEL_B			BIT(18)
	#define SHUCTRL_R_NEW_SHU_MUX_SPM		BIT(19)
	#define SHUCTRL_R_MPDIV_SHU_GP			GENMASK(22, 20)
	#define SHUCTRL_R_OTHER_SHU_GP			GENMASK(25, 24)
	#define SHUCTRL_R_DVFS_PICG_MARGIN3		GENMASK(27, 26)
	#define SHUCTRL_DMSHU_LOW			BIT(29)
	#define SHUCTRL_DMSHU_DRAMC			BIT(31)
#define SHUCTRL1					0x000000d8
	#define SHUCTRL1_FC_PRDCNT			GENMASK(7, 0)
	#define SHUCTRL1_CKFSPE_PRDCNT			GENMASK(15, 8)
	#define SHUCTRL1_CKFSPX_PRDCNT			GENMASK(23, 16)
	#define SHUCTRL1_VRCGEN_PRDCNT			GENMASK(31, 24)
#define SHUCTRL2					0x000000dc
	#define SHUCTRL2_R_DLL_IDLE			GENMASK(6, 0)
	#define SHUCTRL2_R_DVFS_FSM_CLR			BIT(7)
	#define SHUCTRL2_R_DVFS_SREF_OPT		BIT(8)
	#define SHUCTRL2_R_DVFS_CDC_OPTION		BIT(9)
	#define SHUCTRL2_R_DVFS_PICG_MARGIN		GENMASK(11, 10)
	#define SHUCTRL2_R_DVFS_DLL_CHA			BIT(12)
	#define SHUCTRL2_R_CDC_MUX_SEL_OPTION		BIT(13)
	#define SHUCTRL2_R_DVFS_PARK_N			BIT(14)
	#define SHUCTRL2_R_DVFS_OPTION			BIT(15)
	#define SHUCTRL2_SHU_PERIOD_GO_ZERO_CNT		GENMASK(23, 16)
	#define SHUCTRL2_HWSET_WLRL			BIT(24)
	#define SHUCTRL2_MR13_SHU_EN			BIT(25)
	#define SHUCTRL2_R_DVFS_RG_CDC_TX_SEL		BIT(26)
	#define SHUCTRL2_R_DVFS_RG_CDC_SYNC_ENABLE	BIT(27)
	#define SHUCTRL2_R_SHU_RESTORE			BIT(28)
	#define SHUCTRL2_SHU_CLK_MASK			BIT(29)
	#define SHUCTRL2_DVFS_CKE_OPT			BIT(30)
	#define SHUCTRL2_SHORTQ_OPT			BIT(31)
#define SHUCTRL3					0x000000e0
	#define SHUCTRL3_VRCGDIS_MRSMA			GENMASK(12, 0)
	#define SHUCTRL3_VRCGDISOP			GENMASK(23, 16)
	#define SHUCTRL3_VRCGDIS_PRDCNT			GENMASK(31, 24)
#define SHUSTATUS					0x000000e4
	#define SHUSTATUS_SHUFFLE_END			BIT(0)
	#define SHUSTATUS_SHUFFLE_START_LOW		BIT(1)
	#define SHUSTATUS_SHUFFLE_START_LOW_THREE	BIT(2)
	#define SHUSTATUS_SHUFFLE_LEVEL			GENMASK(2, 1) //cc add
	#define SHUSTATUS_MPDIV_SHU_GP			GENMASK(6, 4)
#define BYPASS_FSPOP					0x00000100
	#define BYPASS_FSPOP_BPFSP_SHU0			GENMASK(3, 0)
	#define BYPASS_FSPOP_BPFSP_SHU1			GENMASK(7, 4)
	#define BYPASS_FSPOP_BPFSP_SHU2			GENMASK(11, 8)
	#define BYPASS_FSPOP_BPFSP_SHU3			GENMASK(15, 12)
	#define BYPASS_FSPOP_BPFSP_OPT			BIT(16)
#define STBCAL						0x00000200
	#define STBCAL_PIMASK_RKCHG_OPT			BIT(0)
	#define STBCAL_PIMASK_RKCHG_EXT			GENMASK(3, 1)
	#define STBCAL_STBDLELAST_OPT			BIT(4)
	#define STBCAL_DLLFRZIDLE4XUPD			BIT(5)
	#define STBCAL_FASTDQSG2X			BIT(6)
	#define STBCAL_FASTDQSGUPD			BIT(7)
	#define STBCAL_STBDLELAST_PULSE			GENMASK(11, 8)
	#define STBCAL_STBDLELAST_FILTER		BIT(12)
	#define STBCAL_STBUPDSTOP			BIT(13)
	#define STBCAL_CG_RKEN				BIT(14)
	#define STBCAL_STBSTATE_OPT			BIT(15)
	#define STBCAL_PHYVALID_IG			BIT(16)
	#define STBCAL_SREF_DQSGUPD			BIT(17)
	#define STBCAL_STBCNTRST			BIT(18)
	#define STBCAL_RKCHGMASKDIS			BIT(19)
	#define STBCAL_PICGEN				BIT(20)
	#define STBCAL_REFUICHG				BIT(21)
	#define STBCAL_STB_SELPHYCALEN			BIT(22)
	#define STBCAL_STBCAL2R				BIT(23)
	#define STBCAL_STBCALEN				BIT(24)
	#define STBCAL_STBDLYOUT_OPT			BIT(25)
	#define STBCAL_PICHGBLOCK_NORD			BIT(26)
	#define STBCAL_STB_DQIEN_IG			BIT(27)
	#define STBCAL_DQSIENCG_CHG_EN			BIT(28)
	#define STBCAL_DQSIENCG_NORMAL_EN		BIT(29)
	#define STBCAL_DQSIENMODE_SELPH			BIT(30)
	#define STBCAL_DQSIENMODE			BIT(31)
#define STBCAL1						0x00000204
	#define STBCAL1_DIS_PI_TRACK_AS_NOT_RD		BIT(2)
	#define STBCAL1_STBEN_LP3_DIV2_EN		BIT(3)
	#define STBCAL1_STBCNT_MODESEL			BIT(4)
	#define STBCAL1_DQSIEN_7UI_EN			BIT(5)
	#define STBCAL1_STB_SHIFT_DTCOUT_IG		BIT(6)
	#define STBCAL1_INPUTRXTRACK_BLOCK		BIT(7)
	#define STBCAL1_STB_FLAGCLR			BIT(8)
	#define STBCAL1_STB_DLLFRZ_IG			BIT(9)
	#define STBCAL1_STBENCMPEN			BIT(10)
	#define STBCAL1_STBCNT_LATCH_EN			BIT(11)
	#define STBCAL1_DLLFRZ_MON_PBREF_OPT		BIT(12)
	#define STBCAL1_DLLFRZ_BLOCKLONG		BIT(13)
	#define STBCAL1_DQSERRCNT_DIS			BIT(14)
	#define STBCAL1_STBCNT_SW_RST			BIT(15)
	#define STBCAL1_STBCAL_FILTER			GENMASK(31, 16)
#define STBCAL2						0x00000208
	#define STBCAL2_STB_PIDLYCG_IG			BIT(0)
	#define STBCAL2_STB_UIDLYCG_IG			BIT(1)
	#define STBCAL2_STB_DBG_EN			GENMASK(7, 4)
	#define STBCAL2_STB_DBG_EN_B1			BIT(5)//[5:5]
	#define STBCAL2_STB_DBG_EN_B0			BIT(4)//[4:4]
	#define STBCAL2_STB_DBG_CG_AO			BIT(8)
	#define STBCAL2_STB_DBG_UIPI_UPD_OPT		BIT(9)
	#define STBCAL2_DQSGCNT_BYP_REF			BIT(10)
	#define STBCAL2_STB_DRS_MASK_HW_SAVE		BIT(12)
	#define STBCAL2_STB_DRS_RK1_FLAG_SYNC_RK0_EN	BIT(13)
	#define STBCAL2_STB_PICG_EARLY_1T_EN		BIT(16)
	#define STBCAL2_STB_GERRSTOP			BIT(28)
	#define STBCAL2_STB_GERR_RST			BIT(29)
	#define STBCAL2_STB_GERR_B01			BIT(30)
	#define STBCAL2_STB_GERR_B23			BIT(31)
#define EYESCAN						0x0000020c
	#define EYESCAN_REG_SW_RST			BIT(0)
	#define EYESCAN_RG_RX_EYE_SCAN_EN		BIT(1)
	#define EYESCAN_RG_RX_MIOCK_JIT_EN		BIT(2)
	#define EYESCAN_EYESCAN_RD_SEL_OPT		BIT(4)
	#define EYESCAN_EYESCAN_CHK_OPT			BIT(6)
	#define EYESCAN_EYESCAN_TOG_OPT			BIT(7)
	#define EYESCAN_EYESCAN_DQ_SYNC_EN		BIT(8)
	#define EYESCAN_EYESCAN_NEW_DQ_SYNC_EN		BIT(9)
	#define EYESCAN_EYESCAN_DQS_SYNC_EN		BIT(10)
	#define EYESCAN_DCBLNCEN			BIT(12)
	#define EYESCAN_DCBLNCINS			BIT(13)
	#define EYESCAN_RX_DQ_EYE_SEL			GENMASK(19, 16)
	#define EYESCAN_RX_DQ_EYE_SEL_B1		GENMASK(23, 20)
	#define EYESCAN_RX_DQ_EYE_SEL_B2		GENMASK(27, 24)
	#define EYESCAN_RX_DQ_EYE_SEL_B3		GENMASK(31, 28)
#define DVFSDLL						0x00000210
	#define DVFSDLL_DLL_LOCK_SHU_EN			BIT(0)
	#define DVFSDLL_R_BYPASS_1ST_DLL_SHU1		BIT(1)
	#define DVFSDLL_R_BYPASS_1ST_DLL_SHU2		BIT(2)
	#define DVFSDLL_R_BYPASS_1ST_DLL_SHU3		BIT(3)
	#define DVFSDLL_R_BYPASS_1ST_DLL_SHU4		BIT(4)
	#define DVFSDLL_R_DDRPHY_SHUFFLE_DEBUG_ENABLE	BIT(5)
	#define DVFSDLL_R_RETRY_SAV_MSK			BIT(6)
	#define DVFSDLL_RG_DLL_SHUFFLE			BIT(7)
	#define DVFSDLL_DLL_IDLE_SHU2			GENMASK(14, 8)
	#define DVFSDLL_DLL_IDLE_SHU3			GENMASK(22, 16)
	#define DVFSDLL_R_DMSHUFFLE_CHANGE_FREQ_OPT	BIT(24)
	#define DVFSDLL_R_DVFS_DLL_MARGIN		GENMASK(29, 28)
	#define DVFSDLL_R_DVFS_SYNC_MODULE_RST_SEL	BIT(31)
#define PRE_TDQSCK1					0x00000218
	#define PRE_TDQSCK1_FREQ_RATIO_TX_9		GENMASK(4, 0)
	#define PRE_TDQSCK1_FREQ_RATIO_TX_10		GENMASK(9, 5)
	#define PRE_TDQSCK1_FREQ_RATIO_TX_11		GENMASK(14, 10)
	#define PRE_TDQSCK1_TX_TRACKING_OPT		BIT(15)
	#define PRE_TDQSCK1_SW_UP_TX_NOW_CASE		BIT(16)
	#define PRE_TDQSCK1_TXUIPI_CAL_CGAR		BIT(17)
	#define PRE_TDQSCK1_SHU_PRELOAD_TX_START	BIT(18)
	#define PRE_TDQSCK1_SHU_PRELOAD_TX_HW		BIT(19)
	#define PRE_TDQSCK1_APHY_CG_OPT1		BIT(20)
	#define PRE_TDQSCK1_TDQSCK_HW_SW_UP_SEL		BIT(22)
	#define PRE_TDQSCK1_TDQSCK_SW_UP_CASE		BIT(23)
	#define PRE_TDQSCK1_TDQSCK_SW_SAVE		BIT(24)
	#define PRE_TDQSCK1_TDQSCK_REG_DVFS		BIT(25)
	#define PRE_TDQSCK1_TDQSCK_PRECAL_HW		BIT(26)
	#define PRE_TDQSCK1_TDQSCK_PRECAL_START		BIT(27)
	#define PRE_TDQSCK1_R_DQBUG_RANK_SEL		GENMASK(29, 28)
	#define PRE_TDQSCK1_R_DQBUG_BYTE_SEL		GENMASK(31, 30)
#define PRE_TDQSCK2					0x0000021c
	#define PRE_TDQSCK2_TDDQSCK_JUMP_RATIO3		GENMASK(7, 0)
	#define PRE_TDQSCK2_TDDQSCK_JUMP_RATIO2		GENMASK(15, 8)
	#define PRE_TDQSCK2_TDDQSCK_JUMP_RATIO1		GENMASK(23, 16)
	#define PRE_TDQSCK2_TDDQSCK_JUMP_RATIO0		GENMASK(31, 24)
#define PRE_TDQSCK3					0x00000220
	#define PRE_TDQSCK3_TDDQSCK_JUMP_RATIO7		GENMASK(7, 0)
	#define PRE_TDQSCK3_TDDQSCK_JUMP_RATIO6		GENMASK(15, 8)
	#define PRE_TDQSCK3_TDDQSCK_JUMP_RATIO5		GENMASK(23, 16)
	#define PRE_TDQSCK3_TDDQSCK_JUMP_RATIO4		GENMASK(31, 24)
#define PRE_TDQSCK4					0x00000224
	#define PRE_TDQSCK4_TDDQSCK_JUMP_RATIO11	GENMASK(7, 0)
	#define PRE_TDQSCK4_TDDQSCK_JUMP_RATIO10	GENMASK(15, 8)
	#define PRE_TDQSCK4_TDDQSCK_JUMP_RATIO9		GENMASK(23, 16)
	#define PRE_TDQSCK4_TDDQSCK_JUMP_RATIO8		GENMASK(31, 24)
#define IMPCAL						0x0000022c
	#define IMPCAL_DRV_ECO_OPT			BIT(10)
	#define IMPCAL_IMPCAL_CHGDRV_ECO_OPT		BIT(11)
	#define IMPCAL_IMPCAL_SM_ECO_OPT		BIT(12)
	#define IMPCAL_IMPCAL_ECO_OPT			BIT(13)
	#define IMPCAL_DIS_SUS_CH1_DRV			BIT(14)
	#define IMPCAL_DIS_SUS_CH0_DRV			BIT(15)
	#define IMPCAL_DIS_SHU_DRV			BIT(16)
	#define IMPCAL_IMPCAL_DRVUPDOPT			BIT(17)
	#define IMPCAL_IMPCAL_USING_SYNC		BIT(18)
	#define IMPCAL_IMPCAL_BYPASS_UP_CA_DRV		BIT(19)
	#define IMPCAL_IMPCAL_HWSAVE_EN			BIT(20)
	#define IMPCAL_IMPCAL_CALI_ENN			BIT(21)
	#define IMPCAL_IMPCAL_CALI_ENP			BIT(22)
	#define IMPCAL_IMPCAL_CALI_EN			BIT(23)
	#define IMPCAL_IMPCAL_IMPPDN			BIT(24)
	#define IMPCAL_IMPCAL_IMPPDP			BIT(25)
	#define IMPCAL_IMPCAL_NEW_OLD_SL		BIT(26)
	#define IMPCAL_IMPCAL_CMP_DIREC			GENMASK(28, 27)
	#define IMPCAL_IMPCAL_SWVALUE_EN		BIT(29)
	#define IMPCAL_IMPCAL_EN			BIT(30)
	#define IMPCAL_IMPCAL_HW			BIT(31)
#define IMPEDAMCE_CTRL1					0x00000230
	#define IMPEDAMCE_CTRL1_DQS1_OFF		GENMASK(9, 0)
	#define IMPEDAMCE_CTRL1_DOS2_OFF		GENMASK(19, 10)
	#define IMPEDAMCE_CTRL1_DQS1_OFF_SUB		GENMASK(29, 28)
	#define IMPEDAMCE_CTRL1_DQS2_OFF_SUB		GENMASK(31, 30)
#define IMPEDAMCE_CTRL2					0x00000234
	#define IMPEDAMCE_CTRL2_DQ1_OFF			GENMASK(9, 0)
	#define IMPEDAMCE_CTRL2_DQ2_OFF			GENMASK(19, 10)
	#define IMPEDAMCE_CTRL2_DQ1_OFF_SUB		GENMASK(29, 28)
	#define IMPEDAMCE_CTRL2_DQ2_OFF_SUB		GENMASK(31, 30)
#define IMPEDAMCE_CTRL3					0x00000238
	#define IMPEDAMCE_CTRL3_CMD1_OFF		GENMASK(9, 0)
	#define IMPEDAMCE_CTRL3_CMD2_OFF		GENMASK(19, 10)
	#define IMPEDAMCE_CTRL3_CMD1_OFF_SUB		GENMASK(29, 28)
	#define IMPEDAMCE_CTRL3_CMD2_OFF_SUB		GENMASK(31, 30)
#define IMPEDAMCE_CTRL4					0x0000023c
	#define IMPEDAMCE_CTRL4_DQC1_OFF		GENMASK(9, 0)
	#define IMPEDAMCE_CTRL4_DQC2_OFF		GENMASK(19, 10)
	#define IMPEDAMCE_CTRL4_DQC1_OFF_SUB		GENMASK(29, 28)
	#define IMPEDAMCE_CTRL4_DQC2_OFF_SUB		GENMASK(31, 30)
#define DRAMC_DBG_SEL1					0x00000240
	#define DRAMC_DBG_SEL1_DEBUG_SEL_0		GENMASK(15, 0)
	#define DRAMC_DBG_SEL1_DEBUG_SEL_1		GENMASK(31, 16)
#define DRAMC_DBG_SEL2					0x00000244
	#define DRAMC_DBG_SEL2_DEBUG_SEL_2		GENMASK(15, 0)
	#define DRAMC_DBG_SEL2_DEBUG_SEL_3		GENMASK(31, 16)
#define RK0_DQSOSC					0x00000300
	#define RK0_DQSOSC_R_DMDQS2DQ_FILT_OPT		BIT(29)
	#define RK0_DQSOSC_DQSOSCR_RK0EN		BIT(30)
	#define RK0_DQSOSC_DQSOSC_RK0INTCLR		BIT(31)
#define RK0_DUMMY_RD_WDATA0				0x00000318
	#define RK0_DUMMY_RD_WDATA0_DMY_RD_RK0_WDATA0	GENMASK(31, 0)
#define RK0_DUMMY_RD_WDATA1				0x0000031c
	#define RK0_DUMMY_RD_WDATA1_DMY_RD_RK0_WDATA1	GENMASK(31, 0)
#define RK0_DUMMY_RD_WDATA2				0x00000320
	#define RK0_DUMMY_RD_WDATA2_DMY_RD_RK0_WDATA2	GENMASK(31, 0)
#define RK0_DUMMY_RD_WDATA3				0x00000324
	#define RK0_DUMMY_RD_WDATA3_DMY_RD_RK0_WDATA3	GENMASK(31, 0)
#define RK0_DUMMY_RD_ADR				0x00000328
	#define RK0_DUMMY_RD_ADR_DMY_RD_RK0_ROW_ADR	GENMASK(16, 0)
	#define RK0_DUMMY_RD_ADR_DMY_RD_RK0_COL_ADR	GENMASK(27, 17)
	#define RK0_DUMMY_RD_ADR_DMY_RD_RK0_LEN		GENMASK(31, 28)
#define RK0_DUMMY_RD_BK					0x0000032c
	#define RK0_DUMMY_RD_BK_DMY_RD_RK0_BK		GENMASK(2, 0)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT0		BIT(4)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT1		BIT(5)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT2		BIT(6)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT3		BIT(7)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT4		BIT(8)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT5		BIT(9)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT6		BIT(10)
	#define RK0_DUMMY_RD_BK_DUMMY_RD_1_CNT7		BIT(11)
#define RK0_PRE_TDQSCK1					0x00000330
	#define RK0_PRE_TDQSCK1_TDQSCK_UIFREQ1_B0R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK1_TDQSCK_PIFREQ1_B0R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK1_TDQSCK_UIFREQ2_B0R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK1_TDQSCK_PIFREQ2_B0R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK2					0x00000334
	#define RK0_PRE_TDQSCK2_TDQSCK_UIFREQ3_B0R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK2_TDQSCK_PIFREQ3_B0R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK2_TDQSCK_UIFREQ4_B0R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK2_TDQSCK_PIFREQ4_B0R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK3					0x00000338
	#define RK0_PRE_TDQSCK3_TDQSCK_UIFREQ1_P1_B0R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK3_TDQSCK_UIFREQ2_P1_B0R0	GENMASK(11, 6)
	#define RK0_PRE_TDQSCK3_TDQSCK_UIFREQ3_P1_B0R0	GENMASK(17, 12)
	#define RK0_PRE_TDQSCK3_TDQSCK_UIFREQ4_P1_B0R0	GENMASK(23, 18)
#define RK0_PRE_TDQSCK4					0x0000033c
	#define RK0_PRE_TDQSCK4_TDQSCK_UIFREQ1_B1R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK4_TDQSCK_PIFREQ1_B1R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK4_TDQSCK_UIFREQ2_B1R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK4_TDQSCK_PIFREQ2_B1R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK5					0x00000340
	#define RK0_PRE_TDQSCK5_TDQSCK_UIFREQ3_B1R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK5_TDQSCK_PIFREQ3_B1R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK5_TDQSCK_UIFREQ4_B1R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK5_TDQSCK_PIFREQ4_B1R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK6					0x00000344
	#define RK0_PRE_TDQSCK6_TDQSCK_UIFREQ1_P1_B1R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK6_TDQSCK_UIFREQ2_P1_B1R0	GENMASK(11, 6)
	#define RK0_PRE_TDQSCK6_TDQSCK_UIFREQ3_P1_B1R0	GENMASK(17, 12)
	#define RK0_PRE_TDQSCK6_TDQSCK_UIFREQ4_P1_B1R0	GENMASK(23, 18)
#define RK0_PRE_TDQSCK7					0x00000348
	#define RK0_PRE_TDQSCK7_TDQSCK_UIFREQ1_B2R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK7_TDQSCK_PIFREQ1_B2R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK7_TDQSCK_UIFREQ2_B2R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK7_TDQSCK_PIFREQ2_B2R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK8					0x0000034c
	#define RK0_PRE_TDQSCK8_TDQSCK_UIFREQ3_B2R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK8_TDQSCK_PIFREQ3_B2R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK8_TDQSCK_UIFREQ4_B2R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK8_TDQSCK_PIFREQ4_B2R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK9					0x00000350
	#define RK0_PRE_TDQSCK9_TDQSCK_UIFREQ1_P1_B2R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK9_TDQSCK_UIFREQ2_P1_B2R0	GENMASK(11, 6)
	#define RK0_PRE_TDQSCK9_TDQSCK_UIFREQ3_P1_B2R0	GENMASK(17, 12)
	#define RK0_PRE_TDQSCK9_TDQSCK_UIFREQ4_P1_B2R0	GENMASK(23, 18)
#define RK0_PRE_TDQSCK10				0x00000354
	#define RK0_PRE_TDQSCK10_TDQSCK_UIFREQ1_B3R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK10_TDQSCK_PIFREQ1_B3R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK10_TDQSCK_UIFREQ2_B3R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK10_TDQSCK_PIFREQ2_B3R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK11				0x00000358
	#define RK0_PRE_TDQSCK11_TDQSCK_UIFREQ3_B3R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK11_TDQSCK_PIFREQ3_B3R0	GENMASK(12, 6)
	#define RK0_PRE_TDQSCK11_TDQSCK_UIFREQ4_B3R0	GENMASK(18, 13)
	#define RK0_PRE_TDQSCK11_TDQSCK_PIFREQ4_B3R0	GENMASK(25, 19)
#define RK0_PRE_TDQSCK12				0x0000035c
	#define RK0_PRE_TDQSCK12_TDQSCK_UIFREQ1_P1_B3R0	GENMASK(5, 0)
	#define RK0_PRE_TDQSCK12_TDQSCK_UIFREQ2_P1_B3R0	GENMASK(11, 6)
	#define RK0_PRE_TDQSCK12_TDQSCK_UIFREQ3_P1_B3R0	GENMASK(17, 12)
	#define RK0_PRE_TDQSCK12_TDQSCK_UIFREQ4_P1_B3R0	GENMASK(23, 18)
#define RK1_DQSOSC					0x00000400
	#define RK1_DQSOSC_DQSOSCR_RK1EN		BIT(30)
	#define RK1_DQSOSC_DQSOSC_RK1INTCLR		BIT(31)
#define RK1_DUMMY_RD_WDATA0				0x00000418
	#define RK1_DUMMY_RD_WDATA0_DMY_RD_RK1_WDATA0	GENMASK(31, 0)
#define RK1_DUMMY_RD_WDATA1				0x0000041c
	#define RK1_DUMMY_RD_WDATA1_DMY_RD_RK1_WDATA1	GENMASK(31, 0)
#define RK1_DUMMY_RD_WDATA2				0x00000420
	#define RK1_DUMMY_RD_WDATA2_DMY_RD_RK1_WDATA2	GENMASK(31, 0)
#define RK1_DUMMY_RD_WDATA3				0x00000424
	#define RK1_DUMMY_RD_WDATA3_DMY_RD_RK1_WDATA3	GENMASK(31, 0)
#define RK1_DUMMY_RD_ADR				0x00000428
	#define RK1_DUMMY_RD_ADR_DMY_RD_RK1_ROW_ADR	GENMASK(16, 0)
	#define RK1_DUMMY_RD_ADR_DMY_RD_RK1_COL_ADR	GENMASK(27, 17)
	#define RK1_DUMMY_RD_ADR_DMY_RD_RK1_LEN		GENMASK(31, 28)
#define RK1_DUMMY_RD_BK					0x0000042c
	#define RK1_DUMMY_RD_BK_DMY_RD_RK1_BK		GENMASK(2, 0)
#define RK1_PRE_TDQSCK1					0x00000430
	#define RK1_PRE_TDQSCK1_TDQSCK_UIFREQ1_B0R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK1_TDQSCK_PIFREQ1_B0R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK1_TDQSCK_UIFREQ2_B0R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK1_TDQSCK_PIFREQ2_B0R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK2					0x00000434
	#define RK1_PRE_TDQSCK2_TDQSCK_UIFREQ3_B0R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK2_TDQSCK_PIFREQ3_B0R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK2_TDQSCK_UIFREQ4_B0R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK2_TDQSCK_PIFREQ4_B0R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK3					0x00000438
	#define RK1_PRE_TDQSCK3_TDQSCK_UIFREQ1_P1_B0R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK3_TDQSCK_UIFREQ2_P1_B0R1	GENMASK(11, 6)
	#define RK1_PRE_TDQSCK3_TDQSCK_UIFREQ3_P1_B0R1	GENMASK(17, 12)
	#define RK1_PRE_TDQSCK3_TDQSCK_UIFREQ4_P1_B0R1	GENMASK(23, 18)
#define RK1_PRE_TDQSCK4					0x0000043c
	#define RK1_PRE_TDQSCK4_TDQSCK_UIFREQ1_B1R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK4_TDQSCK_PIFREQ1_B1R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK4_TDQSCK_UIFREQ2_B1R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK4_TDQSCK_PIFREQ2_B1R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK5					0x00000440
	#define RK1_PRE_TDQSCK5_TDQSCK_UIFREQ3_B1R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK5_TDQSCK_PIFREQ3_B1R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK5_TDQSCK_UIFREQ4_B1R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK5_TDQSCK_PIFREQ4_B1R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK6					0x00000444
	#define RK1_PRE_TDQSCK6_TDQSCK_UIFREQ1_P1_B1R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK6_TDQSCK_UIFREQ2_P1_B1R1	GENMASK(11, 6)
	#define RK1_PRE_TDQSCK6_TDQSCK_UIFREQ3_P1_B1R1	GENMASK(17, 12)
	#define RK1_PRE_TDQSCK6_TDQSCK_UIFREQ4_P1_B1R1	GENMASK(23, 18)
#define RK1_PRE_TDQSCK7					0x00000448
	#define RK1_PRE_TDQSCK7_TDQSCK_UIFREQ1_B2R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK7_TDQSCK_PIFREQ1_B2R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK7_TDQSCK_UIFREQ2_B2R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK7_TDQSCK_PIFREQ2_B2R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK8					0x0000044c
	#define RK1_PRE_TDQSCK8_TDQSCK_UIFREQ3_B2R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK8_TDQSCK_PIFREQ3_B2R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK8_TDQSCK_UIFREQ4_B2R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK8_TDQSCK_PIFREQ4_B2R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK9					0x00000450
	#define RK1_PRE_TDQSCK9_TDQSCK_UIFREQ1_P1_B2R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK9_TDQSCK_UIFREQ2_P1_B2R1	GENMASK(11, 6)
	#define RK1_PRE_TDQSCK9_TDQSCK_UIFREQ3_P1_B2R1	GENMASK(17, 12)
	#define RK1_PRE_TDQSCK9_TDQSCK_UIFREQ4_P1_B2R1	GENMASK(23, 18)
#define RK1_PRE_TDQSCK10				0x00000454
	#define RK1_PRE_TDQSCK10_TDQSCK_UIFREQ1_B3R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK10_TDQSCK_PIFREQ1_B3R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK10_TDQSCK_UIFREQ2_B3R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK10_TDQSCK_PIFREQ2_B3R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK11				0x00000458
	#define RK1_PRE_TDQSCK11_TDQSCK_UIFREQ3_B3R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK11_TDQSCK_PIFREQ3_B3R1	GENMASK(12, 6)
	#define RK1_PRE_TDQSCK11_TDQSCK_UIFREQ4_B3R1	GENMASK(18, 13)
	#define RK1_PRE_TDQSCK11_TDQSCK_PIFREQ4_B3R1	GENMASK(25, 19)
#define RK1_PRE_TDQSCK12				0x0000045c
	#define RK1_PRE_TDQSCK12_TDQSCK_UIFREQ1_P1_B3R1	GENMASK(5, 0)
	#define RK1_PRE_TDQSCK12_TDQSCK_UIFREQ2_P1_B3R1	GENMASK(11, 6)
	#define RK1_PRE_TDQSCK12_TDQSCK_UIFREQ3_P1_B3R1	GENMASK(17, 12)
	#define RK1_PRE_TDQSCK12_TDQSCK_UIFREQ4_P1_B3R1	GENMASK(23, 18)
#define RK2_DQSOSC					0x00000500
	#define RK2_DQSOSC_FREQ_RATIO_TX_0		GENMASK(4, 0)
	#define RK2_DQSOSC_FREQ_RATIO_TX_1		GENMASK(9, 5)
	#define RK2_DQSOSC_FREQ_RATIO_TX_2		GENMASK(14, 10)
	#define RK2_DQSOSC_FREQ_RATIO_TX_3		GENMASK(19, 15)
	#define RK2_DQSOSC_FREQ_RATIO_TX_4		GENMASK(24, 20)
	#define RK2_DQSOSC_FREQ_RATIO_TX_5		GENMASK(29, 25)
	#define RK2_DQSOSC_DQSOSCR_RK2EN		BIT(30)
	#define RK2_DQSOSC_DQSOSC_RK2INTCLR		BIT(31)
#define RK2_DUMMY_RD_WDATA0				0x00000518
	#define RK2_DUMMY_RD_WDATA0_DMY_RD_RK2_WDATA0	GENMASK(31, 0)
#define RK2_DUMMY_RD_WDATA1				0x0000051c
	#define RK2_DUMMY_RD_WDATA1_DMY_RD_RK2_WDATA1	GENMASK(31, 0)
#define RK2_DUMMY_RD_WDATA2				0x00000520
	#define RK2_DUMMY_RD_WDATA2_DMY_RD_RK2_WDATA2	GENMASK(31, 0)
#define RK2_DUMMY_RD_WDATA3				0x00000524
	#define RK2_DUMMY_RD_WDATA3_DMY_RD_RK2_WDATA3	GENMASK(31, 0)
#define RK2_DUMMY_RD_ADR				0x00000528
	#define RK2_DUMMY_RD_ADR_DMY_RD_RK2_ROW_ADR	GENMASK(16, 0)
	#define RK2_DUMMY_RD_ADR_DMY_RD_RK2_COL_ADR	GENMASK(27, 17)
	#define RK2_DUMMY_RD_ADR_DMY_RD_RK2_LEN		GENMASK(31, 28)
#define RK2_DUMMY_RD_BK					0x0000052c
	#define RK2_DUMMY_RD_BK_DMY_RD_RK2_BK		GENMASK(2, 0)
	#define RK2_DUMMY_RD_BK_FREQ_RATIO_TX_6		GENMASK(7, 3)
	#define RK2_DUMMY_RD_BK_FREQ_RATIO_TX_7		GENMASK(12, 8)
	#define RK2_DUMMY_RD_BK_FREQ_RATIO_TX_8		GENMASK(17, 13)
#define RK2_PRE_TDQSCK1					0x00000530
	#define RK2_PRE_TDQSCK1_TDQSCK_UIFREQ1_B0R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK1_TDQSCK_PIFREQ1_B0R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK1_TDQSCK_UIFREQ2_B0R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK1_TDQSCK_PIFREQ2_B0R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK2					0x00000534
	#define RK2_PRE_TDQSCK2_TDQSCK_UIFREQ3_B0R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK2_TDQSCK_PIFREQ3_B0R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK2_TDQSCK_UIFREQ4_B0R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK2_TDQSCK_PIFREQ4_B0R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK3					0x00000538
	#define RK2_PRE_TDQSCK3_TDQSCK_UIFREQ1_P1_B0R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK3_TDQSCK_UIFREQ2_P1_B0R2	GENMASK(11, 6)
	#define RK2_PRE_TDQSCK3_TDQSCK_UIFREQ3_P1_B0R2	GENMASK(17, 12)
	#define RK2_PRE_TDQSCK3_TDQSCK_UIFREQ4_P1_B0R2	GENMASK(23, 18)
#define RK2_PRE_TDQSCK4					0x0000053c
	#define RK2_PRE_TDQSCK4_TDQSCK_UIFREQ1_B1R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK4_TDQSCK_PIFREQ1_B1R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK4_TDQSCK_UIFREQ2_B1R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK4_TDQSCK_PIFREQ2_B1R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK5					0x00000540
	#define RK2_PRE_TDQSCK5_TDQSCK_UIFREQ3_B1R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK5_TDQSCK_PIFREQ3_B1R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK5_TDQSCK_UIFREQ4_B1R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK5_TDQSCK_PIFREQ4_B1R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK6					0x00000544
	#define RK2_PRE_TDQSCK6_TDQSCK_UIFREQ1_P1_B1R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK6_TDQSCK_UIFREQ2_P1_B1R2	GENMASK(11, 6)
	#define RK2_PRE_TDQSCK6_TDQSCK_UIFREQ3_P1_B1R2	GENMASK(17, 12)
	#define RK2_PRE_TDQSCK6_TDQSCK_UIFREQ4_P1_B1R2	GENMASK(23, 18)
#define RK2_PRE_TDQSCK7					0x00000548
	#define RK2_PRE_TDQSCK7_TDQSCK_UIFREQ1_B2R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK7_TDQSCK_PIFREQ1_B2R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK7_TDQSCK_UIFREQ2_B2R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK7_TDQSCK_PIFREQ2_B2R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK8					0x0000054c
	#define RK2_PRE_TDQSCK8_TDQSCK_UIFREQ3_B2R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK8_TDQSCK_PIFREQ3_B2R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK8_TDQSCK_UIFREQ4_B2R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK8_TDQSCK_PIFREQ4_B2R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK9					0x00000550
	#define RK2_PRE_TDQSCK9_TDQSCK_UIFREQ1_P1_B2R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK9_TDQSCK_UIFREQ2_P1_B2R2	GENMASK(11, 6)
	#define RK2_PRE_TDQSCK9_TDQSCK_UIFREQ3_P1_B2R2	GENMASK(17, 12)
	#define RK2_PRE_TDQSCK9_TDQSCK_UIFREQ4_P1_B2R2	GENMASK(23, 18)
#define RK2_PRE_TDQSCK10				0x00000554
	#define RK2_PRE_TDQSCK10_TDQSCK_UIFREQ1_B3R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK10_TDQSCK_PIFREQ1_B3R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK10_TDQSCK_UIFREQ2_B3R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK10_TDQSCK_PIFREQ2_B3R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK11				0x00000558
	#define RK2_PRE_TDQSCK11_TDQSCK_UIFREQ3_B3R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK11_TDQSCK_PIFREQ3_B3R2	GENMASK(12, 6)
	#define RK2_PRE_TDQSCK11_TDQSCK_UIFREQ4_B3R2	GENMASK(18, 13)
	#define RK2_PRE_TDQSCK11_TDQSCK_PIFREQ4_B3R2	GENMASK(25, 19)
#define RK2_PRE_TDQSCK12				0x0000055c
	#define RK2_PRE_TDQSCK12_TDQSCK_UIFREQ1_P1_B3R2	GENMASK(5, 0)
	#define RK2_PRE_TDQSCK12_TDQSCK_UIFREQ2_P1_B3R2	GENMASK(11, 6)
	#define RK2_PRE_TDQSCK12_TDQSCK_UIFREQ3_P1_B3R2	GENMASK(17, 12)
	#define RK2_PRE_TDQSCK12_TDQSCK_UIFREQ4_P1_B3R2	GENMASK(23, 18)
#define SHU_ACTIM0					0x00000800
	#define SHU_ACTIM0_TWTR				GENMASK(3, 0)
	#define SHU_ACTIM0_TWR				GENMASK(12, 8)
	#define SHU_ACTIM0_TRRD				GENMASK(18, 16)
	#define SHU_ACTIM0_TRCD				GENMASK(27, 24)
#define SHU_ACTIM1					0x00000804
	#define SHU_ACTIM1_TRPAB			GENMASK(2, 0)
	#define SHU_ACTIM1_TRP				GENMASK(11, 8)
	#define SHU_ACTIM1_TRAS				GENMASK(19, 16)
	#define SHU_ACTIM1_TRC				GENMASK(28, 24)
#define SHU_ACTIM2					0x00000808
	#define SHU_ACTIM2_TXP				GENMASK(2, 0)
	#define SHU_ACTIM2_TRTP				GENMASK(10, 8)
	#define SHU_ACTIM2_TR2W				GENMASK(19, 16)
	#define SHU_ACTIM2_TFAW				GENMASK(28, 24)
#define SHU_ACTIM3					0x0000080c
	#define SHU_ACTIM3_TRFCPB			GENMASK(7, 0)
	#define SHU_ACTIM3_TRFC				GENMASK(23, 16)
	#define SHU_ACTIM3_REFCNT			GENMASK(31, 24)
#define SHU_ACTIM4					0x00000810
	#define SHU_ACTIM4_TXREFCNT			GENMASK(9, 0)
	#define SHU_ACTIM4_REFCNT_FR_CLK		GENMASK(23, 16)
	#define SHU_ACTIM4_TZQCS			GENMASK(31, 24)
#define SHU_ACTIM5					0x00000814
	#define SHU_ACTIM5_TR2PD			GENMASK(4, 0)
	#define SHU_ACTIM5_TWTPD			GENMASK(12, 8)
	#define SHU_ACTIM5_TMRR2W			GENMASK(27, 24)
#define SHU_ACTIM6					0x00000818
	#define SHU_ACTIM6_BGTCCD			GENMASK(1, 0)
	#define SHU_ACTIM6_BGTWTR			GENMASK(7, 4)
	#define SHU_ACTIM6_TWRMPR			GENMASK(11, 8)
	#define SHU_ACTIM6_BGTRRD			GENMASK(14, 12)
#define SHU_ACTIM_XRT					0x0000081c
	#define SHU_ACTIM_XRT_XRTR2R			GENMASK(4, 0)
	#define SHU_ACTIM_XRT_XRTR2W			GENMASK(11, 8)
	#define SHU_ACTIM_XRT_XRTW2R			GENMASK(18, 16)
	#define SHU_ACTIM_XRT_XRTW2W			GENMASK(27, 24)
#define SHU_AC_TIME_05T					0x00000820
	#define SHU_AC_TIME_05T_TRC_05T			BIT(0)
	#define SHU_AC_TIME_05T_TRFCPB_05T		BIT(1)
	#define SHU_AC_TIME_05T_TRFC_05T		BIT(2)
	#define SHU_AC_TIME_05T_TXP_05T			BIT(4)
	#define SHU_AC_TIME_05T_TRTP_05T		BIT(5)
	#define SHU_AC_TIME_05T_TRCD_05T		BIT(6)
	#define SHU_AC_TIME_05T_TRP_05T			BIT(7)
	#define SHU_AC_TIME_05T_TRPAB_05T		BIT(8)
	#define SHU_AC_TIME_05T_TRAS_05T		BIT(9)
	#define SHU_AC_TIME_05T_TWR_M05T		BIT(10)
	#define SHU_AC_TIME_05T_TRRD_05T		BIT(12)
	#define SHU_AC_TIME_05T_TFAW_05T		BIT(13)
	#define SHU_AC_TIME_05T_TR2PD_05T		BIT(15)
	#define SHU_AC_TIME_05T_TWTPD_M05T		BIT(16)
	#define SHU_AC_TIME_05T_BGTRRD_05T		BIT(21)
	#define SHU_AC_TIME_05T_BGTCCD_05T		BIT(22)
	#define SHU_AC_TIME_05T_BGTWTR_05T		BIT(23)
	#define SHU_AC_TIME_05T_TR2W_05T		BIT(24)
	#define SHU_AC_TIME_05T_TWTR_M05T		BIT(25)
	#define SHU_AC_TIME_05T_XRTR2W_05T		BIT(26)
	#define SHU_AC_TIME_05T_XRTW2R_M05T		BIT(27)
#define SHU_AC_DERATING0				0x00000824
	#define SHU_AC_DERATING0_ACDERATEEN		BIT(0)
	#define SHU_AC_DERATING0_TRRD_DERATE		GENMASK(18, 16)
	#define SHU_AC_DERATING0_TRCD_DERATE		GENMASK(27, 24)
#define SHU_AC_DERATING1				0x00000828
	#define SHU_AC_DERATING1_TRPAB_DERATE		GENMASK(2, 0)
	#define SHU_AC_DERATING1_TRP_DERATE		GENMASK(11, 8)
	#define SHU_AC_DERATING1_TRAS_DERATE		GENMASK(19, 16)
	#define SHU_AC_DERATING1_TRC_DERATE		GENMASK(28, 24)
#define SHU_AC_DERATING_05T				0x00000830
	#define SHU_AC_DERATING_05T_TRC_05T_DERATE	BIT(0)
	#define SHU_AC_DERATING_05T_TRCD_05T_DERATE	BIT(6)
	#define SHU_AC_DERATING_05T_TRP_05T_DERATE	BIT(7)
	#define SHU_AC_DERATING_05T_TRPAB_05T_DERATE	BIT(8)
	#define SHU_AC_DERATING_05T_TRAS_05T_DERATE	BIT(9)
	#define SHU_AC_DERATING_05T_TRRD_05T_DERATE	BIT(12)
#define SHU_CONF0					0x00000840
	#define SHU_CONF0_DMPGTIM			GENMASK(5, 0)
	#define SHU_CONF0_ADVREFEN			BIT(6)
	#define SHU_CONF0_ADVPREEN			BIT(7)
	#define SHU_CONF0_TRFCPBIG			BIT(9)
	#define SHU_CONF0_REFTHD			GENMASK(15, 12)
	#define SHU_CONF0_REQQUE_DEPTH			GENMASK(19, 16)
	#define SHU_CONF0_FREQDIV4			BIT(24)
	#define SHU_CONF0_FDIV2				BIT(25)
	#define SHU_CONF0_CL2				BIT(27)
	#define SHU_CONF0_BL2				BIT(28)
	#define SHU_CONF0_BL4				BIT(29)
	#define SHU_CONF0_MATYPE			GENMASK(31, 30)
#define SHU_CONF1					0x00000844
	#define SHU_CONF1_DATLAT			GENMASK(4, 0)
	#define SHU_CONF1_DATLAT_DSEL			GENMASK(12, 8)
	#define SHU_CONF1_REFBW_FR			GENMASK(25, 16)
	#define SHU_CONF1_DATLAT_DSEL_PHY		GENMASK(30, 26)
	#define SHU_CONF1_TREFBWIG			BIT(31)
#define SHU_CONF2					0x00000848
	#define SHU_CONF2_TCMDO1LAT			GENMASK(7, 0)
	#define SHU_CONF2_FSPCHG_PRDCNT			GENMASK(15, 8)
	#define SHU_CONF2_DCMDLYREF			GENMASK(18, 16)
	#define SHU_CONF2_DQCMD				BIT(25)
	#define SHU_CONF2_DQ16COM1			BIT(26)
	#define SHU_CONF2_RA15TOCS1			BIT(27)
	#define SHU_CONF2_WPRE2T			BIT(28)
	#define SHU_CONF2_FASTWAKE2			BIT(29)
	#define SHU_CONF2_DAREFEN			BIT(30)
	#define SHU_CONF2_FASTWAKE			BIT(31)
#define SHU_CONF3					0x0000084c
	#define SHU_CONF3_ZQCSCNT			GENMASK(15, 0)
	#define SHU_CONF3_REFRCNT			GENMASK(24, 16)
#define SHU_STBCAL					0x00000850
	#define SHU_STBCAL_DMSTBLAT			GENMASK(1, 0)
	#define SHU_STBCAL_PICGLAT			GENMASK(6, 4)
	#define SHU_STBCAL_DQSG_MODE			BIT(8)
#define SHU_DQSOSCTHRD					0x00000854
	#define SHU_DQSOSCTHRD_DQSOSCTHRD_INC_RK0	GENMASK(11, 0)
	#define SHU_DQSOSCTHRD_DQSOSCTHRD_DEC_RK0	GENMASK(23, 12)
	#define SHU_DQSOSCTHRD_DQSOSCTHRD_INC_RK1_7TO0	GENMASK(31, 24)
#define SHU_RANKCTL					0x00000858
	#define SHU_RANKCTL_RANKINCTL_RXDLY		GENMASK(3, 0)
	#define SHU_RANKCTL_TXRANKINCTL_TXDLY		GENMASK(11, 8)
	#define SHU_RANKCTL_TXRANKINCTL			GENMASK(15, 12)
	#define SHU_RANKCTL_TXRANKINCTL_ROOT		GENMASK(19, 16)
	#define SHU_RANKCTL_RANKINCTL			GENMASK(23, 20)
	#define SHU_RANKCTL_RANKINCTL_ROOT1		GENMASK(27, 24)
	#define SHU_RANKCTL_RANKINCTL_PHY		GENMASK(31, 28)
#define SHU_CKECTRL					0x0000085c
	#define SHU_CKECTRL_CMDCKE			GENMASK(18, 16)
	#define SHU_CKECTRL_CKEPRD			GENMASK(22, 20)
	#define SHU_CKECTRL_TCKESRX			GENMASK(25, 24)
	#define SHU_CKECTRL_SREF_CK_DLY			GENMASK(29, 28)
#define SHU_ODTCTRL					0x00000860
	#define SHU_ODTCTRL_ROEN			BIT(0)
	#define SHU_ODTCTRL_WOEN			BIT(1)
	#define SHU_ODTCTRL_RODTEN_SELPH_CG_IG		BIT(2)
	#define SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG	BIT(3)
	#define SHU_ODTCTRL_RODT			GENMASK(7, 4)
	#define SHU_ODTCTRL_TWODT			GENMASK(22, 16)
	#define SHU_ODTCTRL_FIXRODT			BIT(27)
	#define SHU_ODTCTRL_RODTE2			BIT(30)
	#define SHU_ODTCTRL_RODTE			BIT(31)
#define SHU_IMPCAL1					0x00000864
	#define SHU_IMPCAL1_IMPCAL_CHKCYCLE		GENMASK(2, 0)
	#define SHU_IMPCAL1_IMPDRVP			GENMASK(8, 4)
	#define SHU_IMPCAL1_IMPDRVN			GENMASK(15, 11)
	#define SHU_IMPCAL1_IMPCAL_CALEN_CYCLE		GENMASK(19, 17)
	#define SHU_IMPCAL1_IMPCALCNT			GENMASK(27, 20)
	#define SHU_IMPCAL1_IMPCAL_CALICNT		GENMASK(31, 28)
#define SHU1_DQSOSC_PRD					0x00000868
	#define SHU1_DQSOSC_PRD_DQSOSC_PRDCNT		GENMASK(9, 0)
	#define SHU1_DQSOSC_PRD_DQSOSCTHRD_INC_RK1_11TO8	GENMASK(19, 16)
	#define SHU1_DQSOSC_PRD_DQSOSCTHRD_DEC_RK1	GENMASK(31, 20)
#define SHU_DQSOSCR					0x0000086c
	#define SHU_DQSOSCR_DQSOSCRCNT			GENMASK(7, 0)
	#define SHU_DQSOSCR_DQSOSC_DELTA		GENMASK(31, 16)
#define SHU_DQSOSCR2					0x00000870
	#define SHU_DQSOSCR2_DQSOSCENCNT		GENMASK(15, 0)
	#define SHU_DQSOSCR2_DQSOSC_ADV_SEL		GENMASK(17, 16)
	#define SHU_DQSOSCR2_DQSOSC_DRS_ADV_SEL		GENMASK(19, 18)
#define SHU_RODTENSTB					0x00000874
	#define SHU_RODTENSTB_RODTEN_MCK_MODESEL	BIT(0)
	#define SHU_RODTENSTB_RODTEN_P1_ENABLE		BIT(1)
	#define SHU_RODTENSTB_RODTENSTB_OFFSET		GENMASK(7, 2)
	#define SHU_RODTENSTB_RODTENSTB_EXT		GENMASK(23, 8)
	#define SHU_RODTENSTB_RODTENSTB_4BYTE_EN	BIT(31)
#define SHU_PIPE					0x00000878
	#define SHU_PIPE_PHYRXPIPE1			BIT(0)
	#define SHU_PIPE_PHYRXPIPE2			BIT(1)
	#define SHU_PIPE_PHYRXPIPE3			BIT(2)
	#define SHU_PIPE_PHYRXRDSLPIPE1			BIT(4)
	#define SHU_PIPE_PHYRXRDSLPIPE2			BIT(5)
	#define SHU_PIPE_PHYRXRDSLPIPE3			BIT(6)
	#define SHU_PIPE_PHYPIPE1EN			BIT(8)
	#define SHU_PIPE_PHYPIPE2EN			BIT(9)
	#define SHU_PIPE_PHYPIPE3EN			BIT(10)
	#define SHU_PIPE_DLE_LAST_EXTEND3		BIT(26)
	#define SHU_PIPE_READ_START_EXTEND3		BIT(27)
	#define SHU_PIPE_DLE_LAST_EXTEND2		BIT(28)
	#define SHU_PIPE_READ_START_EXTEND2		BIT(29)
	#define SHU_PIPE_DLE_LAST_EXTEND1		BIT(30)
	#define SHU_PIPE_READ_START_EXTEND1		BIT(31)
#define SHU_TEST1					0x0000087c
	#define SHU_TEST1_LATNORMPOP			GENMASK(12, 8)
	#define SHU_TEST1_DQSICALBLCOK_CNT		GENMASK(22, 20)
	#define SHU_TEST1_DQSICALI_NEW			BIT(23)
#define SHU_SELPH_CA1					0x00000880
	#define SHU_SELPH_CA1_TXDLY_CS			GENMASK(2, 0)
	#define SHU_SELPH_CA1_TXDLY_CKE			GENMASK(6, 4)
	#define SHU_SELPH_CA1_TXDLY_ODT			GENMASK(10, 8)
	#define SHU_SELPH_CA1_TXDLY_RESET		GENMASK(14, 12)
	#define SHU_SELPH_CA1_TXDLY_WE			GENMASK(18, 16)
	#define SHU_SELPH_CA1_TXDLY_CAS			GENMASK(22, 20)
	#define SHU_SELPH_CA1_TXDLY_RAS			GENMASK(26, 24)
	#define SHU_SELPH_CA1_TXDLY_CS1			GENMASK(30, 28)
#define SHU_SELPH_CA2					0x00000884
	#define SHU_SELPH_CA2_TXDLY_BA0			GENMASK(2, 0)
	#define SHU_SELPH_CA2_TXDLY_BA1			GENMASK(6, 4)
	#define SHU_SELPH_CA2_TXDLY_BA2			GENMASK(10, 8)
	#define SHU_SELPH_CA2_TXDLY_CMD			GENMASK(20, 16)
	#define SHU_SELPH_CA2_TXDLY_CKE1		GENMASK(26, 24)
#define SHU_SELPH_CA3					0x00000888
	#define SHU_SELPH_CA3_TXDLY_RA0			GENMASK(2, 0)
	#define SHU_SELPH_CA3_TXDLY_RA1			GENMASK(6, 4)
	#define SHU_SELPH_CA3_TXDLY_RA2			GENMASK(10, 8)
	#define SHU_SELPH_CA3_TXDLY_RA3			GENMASK(14, 12)
	#define SHU_SELPH_CA3_TXDLY_RA4			GENMASK(18, 16)
	#define SHU_SELPH_CA3_TXDLY_RA5			GENMASK(22, 20)
	#define SHU_SELPH_CA3_TXDLY_RA6			GENMASK(26, 24)
	#define SHU_SELPH_CA3_TXDLY_RA7			GENMASK(30, 28)
#define SHU_SELPH_CA4					0x0000088c
	#define SHU_SELPH_CA4_TXDLY_RA8			GENMASK(2, 0)
	#define SHU_SELPH_CA4_TXDLY_RA9			GENMASK(6, 4)
	#define SHU_SELPH_CA4_TXDLY_RA10		GENMASK(10, 8)
	#define SHU_SELPH_CA4_TXDLY_RA11		GENMASK(14, 12)
	#define SHU_SELPH_CA4_TXDLY_RA12		GENMASK(18, 16)
	#define SHU_SELPH_CA4_TXDLY_RA13		GENMASK(22, 20)
	#define SHU_SELPH_CA4_TXDLY_RA14		GENMASK(26, 24)
	#define SHU_SELPH_CA4_TXDLY_RA15		GENMASK(30, 28)
#define SHU_SELPH_CA5					0x00000890
	#define SHU_SELPH_CA5_DLY_CS			GENMASK(2, 0)
	#define SHU_SELPH_CA5_DLY_CKE			GENMASK(6, 4)
	#define SHU_SELPH_CA5_DLY_ODT			GENMASK(10, 8)
	#define SHU_SELPH_CA5_DLY_RESET			GENMASK(14, 12)
	#define SHU_SELPH_CA5_DLY_WE			GENMASK(18, 16)
	#define SHU_SELPH_CA5_DLY_CAS			GENMASK(22, 20)
	#define SHU_SELPH_CA5_DLY_RAS			GENMASK(26, 24)
	#define SHU_SELPH_CA5_DLY_CS1			GENMASK(30, 28)
#define SHU_SELPH_CA6					0x00000894
	#define SHU_SELPH_CA6_DLY_BA0			GENMASK(2, 0)
	#define SHU_SELPH_CA6_DLY_BA1			GENMASK(6, 4)
	#define SHU_SELPH_CA6_DLY_BA2			GENMASK(10, 8)
	#define SHU_SELPH_CA6_DLY_CKE1			GENMASK(26, 24)
#define SHU_SELPH_CA7					0x00000898
	#define SHU_SELPH_CA7_DLY_RA0			GENMASK(2, 0)
	#define SHU_SELPH_CA7_DLY_RA1			GENMASK(6, 4)
	#define SHU_SELPH_CA7_DLY_RA2			GENMASK(10, 8)
	#define SHU_SELPH_CA7_DLY_RA3			GENMASK(14, 12)
	#define SHU_SELPH_CA7_DLY_RA4			GENMASK(18, 16)
	#define SHU_SELPH_CA7_DLY_RA5			GENMASK(22, 20)
	#define SHU_SELPH_CA7_DLY_RA6			GENMASK(26, 24)
	#define SHU_SELPH_CA7_DLY_RA7			GENMASK(30, 28)
#define SHU_SELPH_CA8					0x0000089c
	#define SHU_SELPH_CA8_DLY_RA8			GENMASK(2, 0)
	#define SHU_SELPH_CA8_DLY_RA9			GENMASK(6, 4)
	#define SHU_SELPH_CA8_DLY_RA10			GENMASK(10, 8)
	#define SHU_SELPH_CA8_DLY_RA11			GENMASK(14, 12)
	#define SHU_SELPH_CA8_DLY_RA12			GENMASK(18, 16)
	#define SHU_SELPH_CA8_DLY_RA13			GENMASK(22, 20)
	#define SHU_SELPH_CA8_DLY_RA14			GENMASK(26, 24)
	#define SHU_SELPH_CA8_DLY_RA15			GENMASK(30, 28)
#define SHU_SELPH_DQS0					0x000008a0
	#define SHU_SELPH_DQS0_TXDLY_DQS0		GENMASK(2, 0)
	#define SHU_SELPH_DQS0_TXDLY_DQS1		GENMASK(6, 4)
	#define SHU_SELPH_DQS0_TXDLY_DQS2		GENMASK(10, 8)
	#define SHU_SELPH_DQS0_TXDLY_DQS3		GENMASK(14, 12)
	#define SHU_SELPH_DQS0_TXDLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU_SELPH_DQS0_TXDLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU_SELPH_DQS0_TXDLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU_SELPH_DQS0_TXDLY_OEN_DQS3		GENMASK(30, 28)
#define SHU_SELPH_DQS1					0x000008a4
	#define SHU_SELPH_DQS1_DLY_DQS0			GENMASK(2, 0)
	#define SHU_SELPH_DQS1_DLY_DQS1			GENMASK(6, 4)
	#define SHU_SELPH_DQS1_DLY_DQS2			GENMASK(10, 8)
	#define SHU_SELPH_DQS1_DLY_DQS3			GENMASK(14, 12)
	#define SHU_SELPH_DQS1_DLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU_SELPH_DQS1_DLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU_SELPH_DQS1_DLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU_SELPH_DQS1_DLY_OEN_DQS3		GENMASK(30, 28)
#define SHU1_DRVING1					0x000008a8
	#define SHU1_DRVING1_DQDRVN2			GENMASK(4, 0)
	#define SHU1_DRVING1_DQDRVP2			GENMASK(9, 5)
	#define SHU1_DRVING1_DQSDRVN1			GENMASK(14, 10)
	#define SHU1_DRVING1_DQSDRVP1			GENMASK(19, 15)
	#define SHU1_DRVING1_DQSDRVN2			GENMASK(24, 20)
	#define SHU1_DRVING1_DQSDRVP2			GENMASK(29, 25)
	#define SHU1_DRVING1_DIS_IMP_ODTN_TRACK		BIT(30)
	#define SHU1_DRVING1_DIS_IMPCAL_HW		BIT(31)
#define SHU1_DRVING2					0x000008ac
	#define SHU1_DRVING2_CMDDRVN1			GENMASK(4, 0)
	#define SHU1_DRVING2_CMDDRVP1			GENMASK(9, 5)
	#define SHU1_DRVING2_CMDDRVN2			GENMASK(14, 10)
	#define SHU1_DRVING2_CMDDRVP2			GENMASK(19, 15)
	#define SHU1_DRVING2_DQDRVN1			GENMASK(24, 20)
	#define SHU1_DRVING2_DQDRVP1			GENMASK(29, 25)
	#define SHU1_DRVING2_DIS_IMPCAL_ODT_EN		BIT(31)
#define SHU1_DRVING3					0x000008b0
	#define SHU1_DRVING3_DQODTN2			GENMASK(4, 0)
	#define SHU1_DRVING3_DQODTP2			GENMASK(9, 5)
	#define SHU1_DRVING3_DQSODTN			GENMASK(14, 10)
	#define SHU1_DRVING3_DQSODTP			GENMASK(19, 15)
	#define SHU1_DRVING3_DQSODTN2			GENMASK(24, 20)
	#define SHU1_DRVING3_DQSODTP2			GENMASK(29, 25)
#define SHU1_DRVING4					0x000008b4
	#define SHU1_DRVING4_CMDODTN1			GENMASK(4, 0)
	#define SHU1_DRVING4_CMDODTP1			GENMASK(9, 5)
	#define SHU1_DRVING4_CMDODTN2			GENMASK(14, 10)
	#define SHU1_DRVING4_CMDODTP2			GENMASK(19, 15)
	#define SHU1_DRVING4_DQODTN1			GENMASK(24, 20)
	#define SHU1_DRVING4_DQODTP1			GENMASK(29, 25)
#define SHU1_DRVING5					0x000008b8
	#define SHU1_DRVING5_DQCODTN2			GENMASK(4, 0)
	#define SHU1_DRVING5_DQCODTP2			GENMASK(9, 5)
	#define SHU1_DRVING5_DQCDRVN1			GENMASK(14, 10)
	#define SHU1_DRVING5_DQCDRVP1			GENMASK(19, 15)
	#define SHU1_DRVING5_DQCDRVN2			GENMASK(24, 20)
	#define SHU1_DRVING5_DQCDRVP2			GENMASK(29, 25)
#define SHU1_DRVING6					0x000008bc
	#define SHU1_DRVING6_DQCODTN1			GENMASK(24, 20)
	#define SHU1_DRVING6_DQCODTP1			GENMASK(29, 25)
#define SHU1_WODT					0x000008c0
	#define SHU1_WODT_DISWODT			GENMASK(2, 0)
	#define SHU1_WODT_WODTFIX			BIT(3)
	#define SHU1_WODT_WODTFIXOFF			BIT(4)
	#define SHU1_WODT_DISWODTE			BIT(5)
	#define SHU1_WODT_DISWODTE2			BIT(6)
	#define SHU1_WODT_WODTPDEN			BIT(7)
	#define SHU1_WODT_DQOE_CNT			GENMASK(10, 8)
	#define SHU1_WODT_DQOE_OPT			BIT(11)
	#define SHU1_WODT_TXUPD_SEL			GENMASK(13, 12)
	#define SHU1_WODT_TXUPD_W2R_SEL			GENMASK(16, 14)
	#define SHU1_WODT_DBIWR				BIT(29)
	#define SHU1_WODT_TWPSTEXT			BIT(30)
	#define SHU1_WODT_WPST2T			BIT(31)
#define SHU1_DQSG					0x000008c4
	#define SHU1_DQSG_DLLFRZRFCOPT			GENMASK(1, 0)
	#define SHU1_DQSG_DLLFRZWROPT			GENMASK(5, 4)
	#define SHU1_DQSG_R_RSTBCNT_LATCH_OPT		GENMASK(10, 8)
	#define SHU1_DQSG_STB_UPDMASK_EN		BIT(11)
	#define SHU1_DQSG_STB_UPDMASKCYC		GENMASK(15, 12)
	#define SHU1_DQSG_DQSINCTL_PRE_SEL		BIT(16)
	#define SHU1_DQSG_SCINTV			GENMASK(25, 20)
#define SHU_SCINTV					0x000008c8
	#define SHU_SCINTV_ODTREN			BIT(0)
	#define SHU_SCINTV_TZQLAT			GENMASK(5, 1)
	#define SHU_SCINTV_TZQLAT2			GENMASK(10, 6)
	#define SHU_SCINTV_RDDQC_INTV			GENMASK(12, 11)
	#define SHU_SCINTV_MRW_INTV			GENMASK(17, 13)
	#define SHU_SCINTV_DQS2DQ_SHU_PITHRD		GENMASK(23, 18)
	#define SHU_SCINTV_DQS2DQ_FILT_PITHRD		GENMASK(29, 24)
	#define SHU_SCINTV_DQSOSCENDIS			BIT(30)
#define SHU_MISC					0x000008cc
	#define SHU_MISC_REQQUE_MAXCNT			GENMASK(3, 0)
	#define SHU_MISC_CKEHCMD			GENMASK(5, 4)
	#define SHU_MISC_NORMPOP_LEN			GENMASK(10, 8)
	#define SHU_MISC_PREA_INTV			GENMASK(16, 12)
#define SHU_DQS2DQ_TX					0x000008d0
	#define SHU_DQS2DQ_TX_OE2DQ_OFFSET		GENMASK(4, 0)
#define SHU_HWSET_MR2					0x000008d4
	#define SHU_HWSET_MR2_HWSET_MR2_MRSMA		GENMASK(12, 0)
	#define SHU_HWSET_MR2_HWSET_MR2_OP		GENMASK(23, 16)
#define SHU_HWSET_MR13					0x000008d8
	#define SHU_HWSET_MR13_HWSET_MR13_MRSMA		GENMASK(12, 0)
	#define SHU_HWSET_MR13_HWSET_MR13_OP		GENMASK(23, 16)
#define SHU_HWSET_VRCG					0x000008dc
	#define SHU_HWSET_VRCG_HWSET_VRCG_MRSMA		GENMASK(12, 0)
	#define SHU_HWSET_VRCG_HWSET_VRCG_OP		GENMASK(23, 16)
#define SHU_APHY_TX_PICG_CTRL				0x000008e4
	#define SHU_APHY_TX_PICG_CTRL_APHYPI_CG_CK_SEL	GENMASK(23, 20)
	#define SHU_APHY_TX_PICG_CTRL_APHYPI_CG_CK_OPT	BIT(24)
	#define SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_DYN_GATING_SEL	GENMASK(30, 27)
	#define SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_OPT	BIT(31)
#define SHURK0_DQSCTL					0x00000a00
	#define SHURK0_DQSCTL_DQSINCTL			GENMASK(3, 0)
#define SHURK0_DQSIEN					0x00000a04
	#define SHURK0_DQSIEN_R0DQS0IEN			GENMASK(6, 0)
	#define SHURK0_DQSIEN_R0DQS1IEN			GENMASK(14, 8)
	#define SHURK0_DQSIEN_R0DQS2IEN			GENMASK(22, 16)
	#define SHURK0_DQSIEN_R0DQS3IEN			GENMASK(30, 24)
#define SHURK0_DQSCAL					0x00000a08
	#define SHURK0_DQSCAL_R0DQSIENLLMT		GENMASK(6, 0)
	#define SHURK0_DQSCAL_R0DQSIENLLMTEN		BIT(7)
	#define SHURK0_DQSCAL_R0DQSIENHLMT		GENMASK(14, 8)
	#define SHURK0_DQSCAL_R0DQSIENHLMTEN		BIT(15)
#define SHU1RK0_PI					0x00000a0c
	#define SHU1RK0_PI_RK0_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU1RK0_PI_RK0_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU1RK0_PI_RK0_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU1RK0_PI_RK0_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU1RK0_DQSOSC					0x00000a10
	#define SHU1RK0_DQSOSC_DQSOSC_BASE_RK0		GENMASK(15, 0)
	#define SHU1RK0_DQSOSC_DQSOSC_BASE_RK0_B1	GENMASK(31, 16)
#define SHURK0_SELPH_ODTEN0				0x00000a1c
	#define SHURK0_SELPH_ODTEN0_TXDLY_B0_RODTEN	GENMASK(2, 0)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B1_RODTEN	GENMASK(10, 8)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B2_RODTEN	GENMASK(18, 16)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B3_RODTEN	GENMASK(26, 24)
	#define SHURK0_SELPH_ODTEN0_TXDLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHURK0_SELPH_ODTEN1				0x00000a20
	#define SHURK0_SELPH_ODTEN1_DLY_B0_RODTEN	GENMASK(2, 0)
	#define SHURK0_SELPH_ODTEN1_DLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHURK0_SELPH_ODTEN1_DLY_B1_RODTEN	GENMASK(10, 8)
	#define SHURK0_SELPH_ODTEN1_DLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHURK0_SELPH_ODTEN1_DLY_B2_RODTEN	GENMASK(18, 16)
	#define SHURK0_SELPH_ODTEN1_DLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHURK0_SELPH_ODTEN1_DLY_B3_RODTEN	GENMASK(26, 24)
	#define SHURK0_SELPH_ODTEN1_DLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHURK0_SELPH_DQSG0				0x00000a24
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHURK0_SELPH_DQSG0_TX_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK0_SELPH_DQSG1				0x00000a28
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHURK0_SELPH_DQSG1_REG_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK0_SELPH_DQ0				0x00000a2c
	#define SHURK0_SELPH_DQ0_TXDLY_DQ0		GENMASK(2, 0)
	#define SHURK0_SELPH_DQ0_TXDLY_DQ1		GENMASK(6, 4)
	#define SHURK0_SELPH_DQ0_TXDLY_DQ2		GENMASK(10, 8)
	#define SHURK0_SELPH_DQ0_TXDLY_DQ3		GENMASK(14, 12)
	#define SHURK0_SELPH_DQ0_TXDLY_OEN_DQ0		GENMASK(18, 16)
	#define SHURK0_SELPH_DQ0_TXDLY_OEN_DQ1		GENMASK(22, 20)
	#define SHURK0_SELPH_DQ0_TXDLY_OEN_DQ2		GENMASK(26, 24)
	#define SHURK0_SELPH_DQ0_TXDLY_OEN_DQ3		GENMASK(30, 28)
#define SHURK0_SELPH_DQ1				0x00000a30
	#define SHURK0_SELPH_DQ1_TXDLY_DQM0		GENMASK(2, 0)
	#define SHURK0_SELPH_DQ1_TXDLY_DQM1		GENMASK(6, 4)
	#define SHURK0_SELPH_DQ1_TXDLY_DQM2		GENMASK(10, 8)
	#define SHURK0_SELPH_DQ1_TXDLY_DQM3		GENMASK(14, 12)
	#define SHURK0_SELPH_DQ1_TXDLY_OEN_DQM0		GENMASK(18, 16)
	#define SHURK0_SELPH_DQ1_TXDLY_OEN_DQM1		GENMASK(22, 20)
	#define SHURK0_SELPH_DQ1_TXDLY_OEN_DQM2		GENMASK(26, 24)
	#define SHURK0_SELPH_DQ1_TXDLY_OEN_DQM3		GENMASK(30, 28)
#define SHURK0_SELPH_DQ2				0x00000a34
	#define SHURK0_SELPH_DQ2_DLY_DQ0		GENMASK(2, 0)
	#define SHURK0_SELPH_DQ2_DLY_DQ1		GENMASK(6, 4)
	#define SHURK0_SELPH_DQ2_DLY_DQ2		GENMASK(10, 8)
	#define SHURK0_SELPH_DQ2_DLY_DQ3		GENMASK(14, 12)
	#define SHURK0_SELPH_DQ2_DLY_OEN_DQ0		GENMASK(18, 16)
	#define SHURK0_SELPH_DQ2_DLY_OEN_DQ1		GENMASK(22, 20)
	#define SHURK0_SELPH_DQ2_DLY_OEN_DQ2		GENMASK(26, 24)
	#define SHURK0_SELPH_DQ2_DLY_OEN_DQ3		GENMASK(30, 28)
#define SHURK0_SELPH_DQ3				0x00000a38
	#define SHURK0_SELPH_DQ3_DLY_DQM0		GENMASK(2, 0)
	#define SHURK0_SELPH_DQ3_DLY_DQM1		GENMASK(6, 4)
	#define SHURK0_SELPH_DQ3_DLY_DQM2		GENMASK(10, 8)
	#define SHURK0_SELPH_DQ3_DLY_DQM3		GENMASK(14, 12)
	#define SHURK0_SELPH_DQ3_DLY_OEN_DQM0		GENMASK(18, 16)
	#define SHURK0_SELPH_DQ3_DLY_OEN_DQM1		GENMASK(22, 20)
	#define SHURK0_SELPH_DQ3_DLY_OEN_DQM2		GENMASK(26, 24)
	#define SHURK0_SELPH_DQ3_DLY_OEN_DQM3		GENMASK(30, 28)
#define SHU1RK0_DQS2DQ_CAL1				0x00000a40
	#define SHU1RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU1RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU1RK0_DQS2DQ_CAL2				0x00000a44
	#define SHU1RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU1RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU1RK0_DQS2DQ_CAL3				0x00000a48
	#define SHU1RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0	GENMASK(5, 0)
	#define SHU1RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1	GENMASK(11, 6)
	#define SHU1RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU1RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU1RK0_DQS2DQ_CAL4				0x00000a4c
	#define SHU1RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0	GENMASK(5, 0)
	#define SHU1RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1	GENMASK(11, 6)
	#define SHU1RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU1RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU1RK0_DQS2DQ_CAL5				0x00000a50
	#define SHU1RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0	GENMASK(10, 0)
	#define SHU1RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1	GENMASK(26, 16)
#define SHURK1_DQSCTL					0x00000b00
	#define SHURK1_DQSCTL_R1DQSINCTL		GENMASK(3, 0)
#define SHURK1_DQSIEN					0x00000b04
	#define SHURK1_DQSIEN_R1DQS0IEN			GENMASK(6, 0)
	#define SHURK1_DQSIEN_R1DQS1IEN			GENMASK(14, 8)
	#define SHURK1_DQSIEN_R1DQS2IEN			GENMASK(22, 16)
	#define SHURK1_DQSIEN_R1DQS3IEN			GENMASK(30, 24)
#define SHURK1_DQSCAL					0x00000b08
	#define SHURK1_DQSCAL_R1DQSIENLLMT		GENMASK(6, 0)
	#define SHURK1_DQSCAL_R1DQSIENLLMTEN		BIT(7)
	#define SHURK1_DQSCAL_R1DQSIENHLMT		GENMASK(14, 8)
	#define SHURK1_DQSCAL_R1DQSIENHLMTEN		BIT(15)
#define SHU1RK1_PI					0x00000b0c
	#define SHU1RK1_PI_RK1_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU1RK1_PI_RK1_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU1RK1_PI_RK1_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU1RK1_PI_RK1_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU1RK1_DQSOSC					0x00000b10
	#define SHU1RK1_DQSOSC_DQSOSC_BASE_RK1		GENMASK(15, 0)
	#define SHU1RK1_DQSOSC_DQSOSC_BASE_RK1_B1	GENMASK(31, 16)
#define SHURK1_SELPH_ODTEN0				0x00000b1c
	#define SHURK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHURK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHURK1_SELPH_ODTEN1				0x00000b20
	#define SHURK1_SELPH_ODTEN1_DLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHURK1_SELPH_ODTEN1_DLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHURK1_SELPH_ODTEN1_DLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHURK1_SELPH_ODTEN1_DLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHURK1_SELPH_ODTEN1_DLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHURK1_SELPH_ODTEN1_DLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHURK1_SELPH_ODTEN1_DLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHURK1_SELPH_ODTEN1_DLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHURK1_SELPH_DQSG0				0x00000b24
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHURK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK1_SELPH_DQSG1				0x00000b28
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHURK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK1_SELPH_DQ0				0x00000b2c
	#define SHURK1_SELPH_DQ0_TX_DLY_R1DQ0		GENMASK(2, 0)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1DQ1		GENMASK(6, 4)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1DQ2		GENMASK(10, 8)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1DQ3		GENMASK(14, 12)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1OEN_DQ0	GENMASK(18, 16)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1OEN_DQ1	GENMASK(22, 20)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1OEN_DQ2	GENMASK(26, 24)
	#define SHURK1_SELPH_DQ0_TX_DLY_R1OEN_DQ3	GENMASK(30, 28)
#define SHURK1_SELPH_DQ1				0x00000b30
	#define SHURK1_SELPH_DQ1_TX_DLY_R1DQM0		GENMASK(2, 0)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1DQM1		GENMASK(6, 4)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1DQM2		GENMASK(10, 8)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1DQM3		GENMASK(14, 12)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHURK1_SELPH_DQ1_TX_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHURK1_SELPH_DQ2				0x00000b34
	#define SHURK1_SELPH_DQ2_DLY_R1DQ0		GENMASK(2, 0)
	#define SHURK1_SELPH_DQ2_DLY_R1DQ1		GENMASK(6, 4)
	#define SHURK1_SELPH_DQ2_DLY_R1DQ2		GENMASK(10, 8)
	#define SHURK1_SELPH_DQ2_DLY_R1DQ3		GENMASK(14, 12)
	#define SHURK1_SELPH_DQ2_DLY_R1OEN_DQ0		GENMASK(18, 16)
	#define SHURK1_SELPH_DQ2_DLY_R1OEN_DQ1		GENMASK(22, 20)
	#define SHURK1_SELPH_DQ2_DLY_R1OEN_DQ2		GENMASK(26, 24)
	#define SHURK1_SELPH_DQ2_DLY_R1OEN_DQ3		GENMASK(30, 28)
#define SHURK1_SELPH_DQ3				0x00000b38
	#define SHURK1_SELPH_DQ3_DLY_R1DQM0		GENMASK(2, 0)
	#define SHURK1_SELPH_DQ3_DLY_R1DQM1		GENMASK(6, 4)
	#define SHURK1_SELPH_DQ3_DLY_R1DQM2		GENMASK(10, 8)
	#define SHURK1_SELPH_DQ3_DLY_R1DQM3		GENMASK(14, 12)
	#define SHURK1_SELPH_DQ3_DLY_R1OEN_DQM0		GENMASK(18, 16)
	#define SHURK1_SELPH_DQ3_DLY_R1OEN_DQM1		GENMASK(22, 20)
	#define SHURK1_SELPH_DQ3_DLY_R1OEN_DQM2		GENMASK(26, 24)
	#define SHURK1_SELPH_DQ3_DLY_R1OEN_DQM3		GENMASK(30, 28)
#define SHU1RK1_DQS2DQ_CAL1				0x00000b40
	#define SHU1RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU1RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU1RK1_DQS2DQ_CAL2				0x00000b44
	#define SHU1RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU1RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU1RK1_DQS2DQ_CAL3				0x00000b48
	#define SHU1RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0	GENMASK(5, 0)
	#define SHU1RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1	GENMASK(11, 6)
	#define SHU1RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU1RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU1RK1_DQS2DQ_CAL4				0x00000b4c
	#define SHU1RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0	GENMASK(5, 0)
	#define SHU1RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1	GENMASK(11, 6)
	#define SHU1RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU1RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU1RK1_DQS2DQ_CAL5				0x00000b50
	#define SHU1RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM0	GENMASK(10, 0)
	#define SHU1RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM1	GENMASK(26, 16)
#define SHURK2_DQSCTL					0x00000c00
	#define SHURK2_DQSCTL_R2DQSINCTL		GENMASK(3, 0)
#define SHURK2_DQSIEN					0x00000c04
	#define SHURK2_DQSIEN_R2DQS0IEN			GENMASK(6, 0)
	#define SHURK2_DQSIEN_R2DQS1IEN			GENMASK(14, 8)
	#define SHURK2_DQSIEN_R2DQS2IEN			GENMASK(22, 16)
	#define SHURK2_DQSIEN_R2DQS3IEN			GENMASK(30, 24)
#define SHURK2_DQSCAL					0x00000c08
	#define SHURK2_DQSCAL_R2DQSIENLLMT		GENMASK(6, 0)
	#define SHURK2_DQSCAL_R2DQSIENLLMTEN		BIT(7)
	#define SHURK2_DQSCAL_R2DQSIENHLMT		GENMASK(14, 8)
	#define SHURK2_DQSCAL_R2DQSIENHLMTEN		BIT(15)
#define SHU1RK2_PI					0x00000c0c
	#define SHU1RK2_PI_RK2_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU1RK2_PI_RK2_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU1RK2_PI_RK2_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU1RK2_PI_RK2_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU1RK2_DQSOSC					0x00000c10
	#define SHU1RK2_DQSOSC_DQSOSC_BASE_RK2		GENMASK(15, 0)
	#define SHU1RK2_DQSOSC_DQSOSC_BASE_RK2_B1	GENMASK(31, 16)
#define SHURK2_SELPH_ODTEN0				0x00000c1c
	#define SHURK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHURK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHURK2_SELPH_ODTEN1				0x00000c20
	#define SHURK2_SELPH_ODTEN1_DLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHURK2_SELPH_ODTEN1_DLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHURK2_SELPH_ODTEN1_DLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHURK2_SELPH_ODTEN1_DLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHURK2_SELPH_ODTEN1_DLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHURK2_SELPH_ODTEN1_DLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHURK2_SELPH_ODTEN1_DLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHURK2_SELPH_ODTEN1_DLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHURK2_SELPH_DQSG0				0x00000c24
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHURK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK2_SELPH_DQSG1				0x00000c28
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHURK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHURK2_SELPH_DQ0				0x00000c2c
	#define SHURK2_SELPH_DQ0_TX_DLY_R2DQ0		GENMASK(2, 0)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2DQ1		GENMASK(6, 4)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2DQ2		GENMASK(10, 8)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2DQ3		GENMASK(14, 12)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2OEN_DQ0	GENMASK(18, 16)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2OEN_DQ1	GENMASK(22, 20)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2OEN_DQ2	GENMASK(26, 24)
	#define SHURK2_SELPH_DQ0_TX_DLY_R2OEN_DQ3	GENMASK(30, 28)
#define SHURK2_SELPH_DQ1				0x00000c30
	#define SHURK2_SELPH_DQ1_TX_DLY_R2DQM0		GENMASK(2, 0)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2DQM1		GENMASK(6, 4)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2DQM2		GENMASK(10, 8)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2DQM3		GENMASK(14, 12)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHURK2_SELPH_DQ1_TX_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHURK2_SELPH_DQ2				0x00000c34
	#define SHURK2_SELPH_DQ2_DLY_R2DQ0		GENMASK(2, 0)
	#define SHURK2_SELPH_DQ2_DLY_R2DQ1		GENMASK(6, 4)
	#define SHURK2_SELPH_DQ2_DLY_R2DQ2		GENMASK(10, 8)
	#define SHURK2_SELPH_DQ2_DLY_R2DQ3		GENMASK(14, 12)
	#define SHURK2_SELPH_DQ2_DLY_R2OEN_DQ0		GENMASK(18, 16)
	#define SHURK2_SELPH_DQ2_DLY_R2OEN_DQ1		GENMASK(22, 20)
	#define SHURK2_SELPH_DQ2_DLY_R2OEN_DQ2		GENMASK(26, 24)
	#define SHURK2_SELPH_DQ2_DLY_R2OEN_DQ3		GENMASK(30, 28)
#define SHURK2_SELPH_DQ3				0x00000c38
	#define SHURK2_SELPH_DQ3_DLY_R2DQM0		GENMASK(2, 0)
	#define SHURK2_SELPH_DQ3_DLY_R2DQM1		GENMASK(6, 4)
	#define SHURK2_SELPH_DQ3_DLY_R2DQM2		GENMASK(10, 8)
	#define SHURK2_SELPH_DQ3_DLY_R2DQM3		GENMASK(14, 12)
	#define SHURK2_SELPH_DQ3_DLY_R2OEN_DQM0		GENMASK(18, 16)
	#define SHURK2_SELPH_DQ3_DLY_R2OEN_DQM1		GENMASK(22, 20)
	#define SHURK2_SELPH_DQ3_DLY_R2OEN_DQM2		GENMASK(26, 24)
	#define SHURK2_SELPH_DQ3_DLY_R2OEN_DQM3		GENMASK(30, 28)
#define SHU1RK2_DQS2DQ_CAL1				0x00000c40
	#define SHU1RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU1RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU1RK2_DQS2DQ_CAL2				0x00000c44
	#define SHU1RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU1RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU1RK2_DQS2DQ_CAL3				0x00000c48
	#define SHU1RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ0	GENMASK(5, 0)
	#define SHU1RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ1	GENMASK(11, 6)
#define SHU1RK2_DQS2DQ_CAL4				0x00000c4c
	#define SHU1RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM0	GENMASK(5, 0)
	#define SHU1RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM1	GENMASK(11, 6)
#define SHU1RK2_DQS2DQ_CAL5				0x00000c50
	#define SHU1RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM0	GENMASK(10, 0)
	#define SHU1RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM1	GENMASK(26, 16)
#define SHU_DQSG_RETRY					0x00000c54
	#define SHU_DQSG_RETRY_R_DQSGRETRY_SW_RESET	BIT(0)
	#define SHU_DQSG_RETRY_R_DQSG_RETRY_SW_EN	BIT(1)
	#define SHU_DQSG_RETRY_R_DDR1866_PLUS		BIT(2)
	#define SHU_DQSG_RETRY_R_RETRY_ONCE		BIT(3)
	#define SHU_DQSG_RETRY_R_RETRY_3TIMES		BIT(4)
	#define SHU_DQSG_RETRY_R_RETRY_1RANK		BIT(5)
	#define SHU_DQSG_RETRY_R_RETRY_SAV_MSK		BIT(6)
	#define SHU_DQSG_RETRY_R_DM4BYTE		BIT(7)
	#define SHU_DQSG_RETRY_R_DQSIENLAT		GENMASK(11, 8)
	#define SHU_DQSG_RETRY_R_STBENCMP_ALLBYTE	BIT(12)
	#define SHU_DQSG_RETRY_R_XSR_DQSG_RETRY_EN	BIT(13)
	#define SHU_DQSG_RETRY_R_XSR_RETRY_SPM_MODE	BIT(14)
	#define SHU_DQSG_RETRY_R_RETRY_CMP_DATA		BIT(15)
	#define SHU_DQSG_RETRY_R_RETRY_ALE_BLOCK_MASK	BIT(20)
	#define SHU_DQSG_RETRY_R_RDY_SEL_DLE		BIT(21)
	#define SHU_DQSG_RETRY_R_RETRY_ROUND_NUM	GENMASK(25, 24)
	#define SHU_DQSG_RETRY_R_RETRY_RANKSEL_FROM_PHY	BIT(28)
	#define SHU_DQSG_RETRY_R_RETRY_PA_DSIABLE	BIT(29)
	#define SHU_DQSG_RETRY_R_RETRY_STBEN_RESET_MSK	BIT(30)
	#define SHU_DQSG_RETRY_R_RETRY_USE_BURST_MDOE	BIT(31)
#define SHU2_ACTIM0					0x00000e00
	#define SHU2_ACTIM0_TWTR			GENMASK(3, 0)
	#define SHU2_ACTIM0_TWR				GENMASK(12, 8)
	#define SHU2_ACTIM0_TRRD			GENMASK(18, 16)
	#define SHU2_ACTIM0_TRCD			GENMASK(27, 24)
#define SHU2_ACTIM1					0x00000e04
	#define SHU2_ACTIM1_TRPAB			GENMASK(2, 0)
	#define SHU2_ACTIM1_TRP				GENMASK(11, 8)
	#define SHU2_ACTIM1_TRAS			GENMASK(19, 16)
	#define SHU2_ACTIM1_TRC				GENMASK(28, 24)
#define SHU2_ACTIM2					0x00000e08
	#define SHU2_ACTIM2_TXP				GENMASK(2, 0)
	#define SHU2_ACTIM2_TRTP			GENMASK(10, 8)
	#define SHU2_ACTIM2_TR2W			GENMASK(19, 16)
	#define SHU2_ACTIM2_TFAW			GENMASK(28, 24)
#define SHU2_ACTIM3					0x00000e0c
	#define SHU2_ACTIM3_TRFCPB			GENMASK(7, 0)
	#define SHU2_ACTIM3_TRFC			GENMASK(23, 16)
	#define SHU2_ACTIM3_REFCNT			GENMASK(31, 24)
#define SHU2_ACTIM4					0x00000e10
	#define SHU2_ACTIM4_TXREFCNT			GENMASK(9, 0)
	#define SHU2_ACTIM4_REFCNT_FR_CLK		GENMASK(23, 16)
	#define SHU2_ACTIM4_TZQCS			GENMASK(31, 24)
#define SHU2_ACTIM5					0x00000e14
	#define SHU2_ACTIM5_TR2PD			GENMASK(4, 0)
	#define SHU2_ACTIM5_TWTPD			GENMASK(12, 8)
	#define SHU2_ACTIM5_TMRR2W			GENMASK(27, 24)
#define SHU2_ACTIM6					0x00000e18
	#define SHU2_ACTIM6_BGTCCD			GENMASK(1, 0)
	#define SHU2_ACTIM6_BGTWTR			GENMASK(7, 4)
	#define SHU2_ACTIM6_TWRMPR			GENMASK(11, 8)
	#define SHU2_ACTIM6_BGTRRD			GENMASK(14, 12)
#define SHU2_ACTIM_XRT					0x00000e1c
	#define SHU2_ACTIM_XRT_XRTR2R			GENMASK(4, 0)
	#define SHU2_ACTIM_XRT_XRTR2W			GENMASK(11, 8)
	#define SHU2_ACTIM_XRT_XRTW2R			GENMASK(18, 16)
	#define SHU2_ACTIM_XRT_XRTW2W			GENMASK(27, 24)
#define SHU2_AC_TIME_05T				0x00000e20
	#define SHU2_AC_TIME_05T_TRC_05T		BIT(0)
	#define SHU2_AC_TIME_05T_TRFCPB_05T		BIT(1)
	#define SHU2_AC_TIME_05T_TRFC_05T		BIT(2)
	#define SHU2_AC_TIME_05T_TXP_05T		BIT(4)
	#define SHU2_AC_TIME_05T_TRTP_05T		BIT(5)
	#define SHU2_AC_TIME_05T_TRCD_05T		BIT(6)
	#define SHU2_AC_TIME_05T_TRP_05T		BIT(7)
	#define SHU2_AC_TIME_05T_TRPAB_05T		BIT(8)
	#define SHU2_AC_TIME_05T_TRAS_05T		BIT(9)
	#define SHU2_AC_TIME_05T_TWR_M05T		BIT(10)
	#define SHU2_AC_TIME_05T_TRRD_05T		BIT(12)
	#define SHU2_AC_TIME_05T_TFAW_05T		BIT(13)
	#define SHU2_AC_TIME_05T_TR2PD_05T		BIT(15)
	#define SHU2_AC_TIME_05T_TWTPD_M05T		BIT(16)
	#define SHU2_AC_TIME_05T_BGTRRD_05T		BIT(21)
	#define SHU2_AC_TIME_05T_BGTCCD_05T		BIT(22)
	#define SHU2_AC_TIME_05T_BGTWTR_05T		BIT(23)
	#define SHU2_AC_TIME_05T_TR2W_05T		BIT(24)
	#define SHU2_AC_TIME_05T_TWTR_M05T		BIT(25)
	#define SHU2_AC_TIME_05T_XRTR2W_05T		BIT(26)
	#define SHU2_AC_TIME_05T_XRTW2R_M05T		BIT(27)
#define SHU2_AC_DERATING0				0x00000e24
	#define SHU2_AC_DERATING0_ACDERATEEN		BIT(0)
	#define SHU2_AC_DERATING0_TRRD_DERATE		GENMASK(18, 16)
	#define SHU2_AC_DERATING0_TRCD_DERATE		GENMASK(27, 24)
#define SHU2_AC_DERATING1				0x00000e28
	#define SHU2_AC_DERATING1_TRPAB_DERATE		GENMASK(2, 0)
	#define SHU2_AC_DERATING1_TRP_DERATE		GENMASK(11, 8)
	#define SHU2_AC_DERATING1_TRAS_DERATE		GENMASK(19, 16)
	#define SHU2_AC_DERATING1_TRC_DERATE		GENMASK(28, 24)
#define SHU2_AC_DERATING_05T				0x00000e30
	#define SHU2_AC_DERATING_05T_TRC_05T_DERATE	BIT(0)
	#define SHU2_AC_DERATING_05T_TRCD_05T_DERATE	BIT(6)
	#define SHU2_AC_DERATING_05T_TRP_05T_DERATE	BIT(7)
	#define SHU2_AC_DERATING_05T_TRPAB_05T_DERATE	BIT(8)
	#define SHU2_AC_DERATING_05T_TRAS_05T_DERATE	BIT(9)
	#define SHU2_AC_DERATING_05T_TRRD_05T_DERATE	BIT(12)
#define SHU2_CONF0					0x00000e40
	#define SHU2_CONF0_DMPGTIM			GENMASK(5, 0)
	#define SHU2_CONF0_ADVREFEN			BIT(6)
	#define SHU2_CONF0_ADVPREEN			BIT(7)
	#define SHU2_CONF0_TRFCPBIG			BIT(9)
	#define SHU2_CONF0_REFTHD			GENMASK(15, 12)
	#define SHU2_CONF0_REQQUE_DEPTH			GENMASK(19, 16)
	#define SHU2_CONF0_FREQDIV4			BIT(24)
	#define SHU2_CONF0_FDIV2			BIT(25)
	#define SHU2_CONF0_CL2				BIT(27)
	#define SHU2_CONF0_BL2				BIT(28)
	#define SHU2_CONF0_BL4				BIT(29)
	#define SHU2_CONF0_MATYPE			GENMASK(31, 30)
#define SHU2_CONF1					0x00000e44
	#define SHU2_CONF1_DATLAT			GENMASK(4, 0)
	#define SHU2_CONF1_DATLAT_DSEL			GENMASK(12, 8)
	#define SHU2_CONF1_REFBW_FR			GENMASK(25, 16)
	#define SHU2_CONF1_DATLAT_DSEL_PHY		GENMASK(30, 26)
	#define SHU2_CONF1_TREFBWIG			BIT(31)
#define SHU2_CONF2					0x00000e48
	#define SHU2_CONF2_TCMDO1LAT			GENMASK(7, 0)
	#define SHU2_CONF2_FSPCHG_PRDCNT		GENMASK(15, 8)
	#define SHU2_CONF2_DCMDLYREF			GENMASK(18, 16)
	#define SHU2_CONF2_DQCMD			BIT(25)
	#define SHU2_CONF2_DQ16COM1			BIT(26)
	#define SHU2_CONF2_RA15TOCS1			BIT(27)
	#define SHU2_CONF2_WPRE2T			BIT(28)
	#define SHU2_CONF2_FASTWAKE2			BIT(29)
	#define SHU2_CONF2_DAREFEN			BIT(30)
	#define SHU2_CONF2_FASTWAKE			BIT(31)
#define SHU2_CONF3					0x00000e4c
	#define SHU2_CONF3_ZQCSCNT			GENMASK(15, 0)
	#define SHU2_CONF3_REFRCNT			GENMASK(24, 16)
#define SHU2_STBCAL					0x00000e50
	#define SHU2_STBCAL_DMSTBLAT			GENMASK(1, 0)
	#define SHU2_STBCAL_PICGLAT			GENMASK(6, 4)
	#define SHU2_STBCAL_DQSG_MODE			BIT(8)
#define SHU2_DQSOSCTHRD					0x00000e54
	#define SHU2_DQSOSCTHRD_DQSOSCTHRD_INC_RK0	GENMASK(11, 0)
	#define SHU2_DQSOSCTHRD_DQSOSCTHRD_DEC_RK0	GENMASK(23, 12)
	#define SHU2_DQSOSCTHRD_DQSOSCTHRD_INC_RK1_7TO0	GENMASK(31, 24)
#define SHU2_RANKCTL					0x00000e58
	#define SHU2_RANKCTL_RANKINCTL_RXDLY		GENMASK(3, 0)
	#define SHU2_RANKCTL_TXRANKINCTL_TXDLY		GENMASK(11, 8)
	#define SHU2_RANKCTL_TXRANKINCTL		GENMASK(15, 12)
	#define SHU2_RANKCTL_TXRANKINCTL_ROOT		GENMASK(19, 16)
	#define SHU2_RANKCTL_RANKINCTL			GENMASK(23, 20)
	#define SHU2_RANKCTL_RANKINCTL_ROOT1		GENMASK(27, 24)
	#define SHU2_RANKCTL_RANKINCTL_PHY		GENMASK(31, 28)
#define SHU2_CKECTRL					0x00000e5c
	#define SHU2_CKECTRL_CMDCKE			GENMASK(18, 16)
	#define SHU2_CKECTRL_CKEPRD			GENMASK(22, 20)
	#define SHU2_CKECTRL_TCKESRX			GENMASK(25, 24)
	#define SHU2_CKECTRL_SREF_CK_DLY		GENMASK(29, 28)
#define SHU2_ODTCTRL					0x00000e60
	#define SHU2_ODTCTRL_ROEN			BIT(0)
	#define SHU2_ODTCTRL_WOEN			BIT(1)
	#define SHU2_ODTCTRL_RODTEN_SELPH_CG_IG		BIT(2)
	#define SHU2_ODTCTRL_RODTENSTB_SELPH_CG_IG	BIT(3)
	#define SHU2_ODTCTRL_RODT			GENMASK(7, 4)
	#define SHU2_ODTCTRL_TWODT			GENMASK(22, 16)
	#define SHU2_ODTCTRL_FIXRODT			BIT(27)
	#define SHU2_ODTCTRL_RODTE2			BIT(30)
	#define SHU2_ODTCTRL_RODTE			BIT(31)
#define SHU2_IMPCAL1					0x00000e64
	#define SHU2_IMPCAL1_IMPCAL_CHKCYCLE		GENMASK(2, 0)
	#define SHU2_IMPCAL1_IMPDRVP			GENMASK(8, 4)
	#define SHU2_IMPCAL1_IMPDRVN			GENMASK(15, 11)
	#define SHU2_IMPCAL1_IMPCAL_CALEN_CYCLE		GENMASK(19, 17)
	#define SHU2_IMPCAL1_IMPCALCNT			GENMASK(27, 20)
	#define SHU2_IMPCAL1_IMPCAL_CALICNT		GENMASK(31, 28)
#define SHU2_DQSOSC_PRD					0x00000e68
	#define SHU2_DQSOSC_PRD_DQSOSC_PRDCNT		GENMASK(9, 0)
	#define SHU2_DQSOSC_PRD_DQSOSCTHRD_INC_RK1_11TO8	GENMASK(19, 16)
	#define SHU2_DQSOSC_PRD_DQSOSCTHRD_DEC_RK1	GENMASK(31, 20)
#define SHU2_DQSOSCR					0x00000e6c
	#define SHU2_DQSOSCR_DQSOSCRCNT			GENMASK(7, 0)
	#define SHU2_DQSOSCR_DQSOSC_DELTA		GENMASK(31, 16)
#define SHU2_DQSOSCR2					0x00000e70
	#define SHU2_DQSOSCR2_DQSOSCENCNT		GENMASK(15, 0)
	#define SHU2_DQSOSCR2_DQSOSC_ADV_SEL		GENMASK(17, 16)
	#define SHU2_DQSOSCR2_DQSOSC_DRS_ADV_SEL	GENMASK(19, 18)
#define SHU2_RODTENSTB					0x00000e74
	#define SHU2_RODTENSTB_RODTEN_MCK_MODESEL	BIT(0)
	#define SHU2_RODTENSTB_RODTEN_P1_ENABLE		BIT(1)
	#define SHU2_RODTENSTB_RODTENSTB_OFFSET		GENMASK(7, 2)
	#define SHU2_RODTENSTB_RODTENSTB_EXT		GENMASK(23, 8)
	#define SHU2_RODTENSTB_RODTENSTB_4BYTE_EN	BIT(31)
#define SHU2_PIPE					0x00000e78
	#define SHU2_PIPE_PHYRXPIPE1			BIT(0)
	#define SHU2_PIPE_PHYRXPIPE2			BIT(1)
	#define SHU2_PIPE_PHYRXPIPE3			BIT(2)
	#define SHU2_PIPE_PHYRXRDSLPIPE1		BIT(4)
	#define SHU2_PIPE_PHYRXRDSLPIPE2		BIT(5)
	#define SHU2_PIPE_PHYRXRDSLPIPE3		BIT(6)
	#define SHU2_PIPE_PHYPIPE1EN			BIT(8)
	#define SHU2_PIPE_PHYPIPE2EN			BIT(9)
	#define SHU2_PIPE_PHYPIPE3EN			BIT(10)
	#define SHU2_PIPE_DLE_LAST_EXTEND3		BIT(26)
	#define SHU2_PIPE_READ_START_EXTEND3		BIT(27)
	#define SHU2_PIPE_DLE_LAST_EXTEND2		BIT(28)
	#define SHU2_PIPE_READ_START_EXTEND2		BIT(29)
	#define SHU2_PIPE_DLE_LAST_EXTEND1		BIT(30)
	#define SHU2_PIPE_READ_START_EXTEND1		BIT(31)
#define SHU2_TEST1					0x00000e7c
	#define SHU2_TEST1_LATNORMPOP			GENMASK(12, 8)
	#define SHU2_TEST1_DQSICALBLCOK_CNT		GENMASK(22, 20)
	#define SHU2_TEST1_DQSICALI_NEW			BIT(23)
#define SHU2_SELPH_CA1					0x00000e80
	#define SHU2_SELPH_CA1_TXDLY_CS			GENMASK(2, 0)
	#define SHU2_SELPH_CA1_TXDLY_CKE		GENMASK(6, 4)
	#define SHU2_SELPH_CA1_TXDLY_ODT		GENMASK(10, 8)
	#define SHU2_SELPH_CA1_TXDLY_RESET		GENMASK(14, 12)
	#define SHU2_SELPH_CA1_TXDLY_WE			GENMASK(18, 16)
	#define SHU2_SELPH_CA1_TXDLY_CAS		GENMASK(22, 20)
	#define SHU2_SELPH_CA1_TXDLY_RAS		GENMASK(26, 24)
	#define SHU2_SELPH_CA1_TXDLY_CS1		GENMASK(30, 28)
#define SHU2_SELPH_CA2					0x00000e84
	#define SHU2_SELPH_CA2_TXDLY_BA0		GENMASK(2, 0)
	#define SHU2_SELPH_CA2_TXDLY_BA1		GENMASK(6, 4)
	#define SHU2_SELPH_CA2_TXDLY_BA2		GENMASK(10, 8)
	#define SHU2_SELPH_CA2_TXDLY_CMD		GENMASK(20, 16)
	#define SHU2_SELPH_CA2_TXDLY_CKE1		GENMASK(26, 24)
#define SHU2_SELPH_CA3					0x00000e88
	#define SHU2_SELPH_CA3_TXDLY_RA0		GENMASK(2, 0)
	#define SHU2_SELPH_CA3_TXDLY_RA1		GENMASK(6, 4)
	#define SHU2_SELPH_CA3_TXDLY_RA2		GENMASK(10, 8)
	#define SHU2_SELPH_CA3_TXDLY_RA3		GENMASK(14, 12)
	#define SHU2_SELPH_CA3_TXDLY_RA4		GENMASK(18, 16)
	#define SHU2_SELPH_CA3_TXDLY_RA5		GENMASK(22, 20)
	#define SHU2_SELPH_CA3_TXDLY_RA6		GENMASK(26, 24)
	#define SHU2_SELPH_CA3_TXDLY_RA7		GENMASK(30, 28)
#define SHU2_SELPH_CA4					0x00000e8c
	#define SHU2_SELPH_CA4_TXDLY_RA8		GENMASK(2, 0)
	#define SHU2_SELPH_CA4_TXDLY_RA9		GENMASK(6, 4)
	#define SHU2_SELPH_CA4_TXDLY_RA10		GENMASK(10, 8)
	#define SHU2_SELPH_CA4_TXDLY_RA11		GENMASK(14, 12)
	#define SHU2_SELPH_CA4_TXDLY_RA12		GENMASK(18, 16)
	#define SHU2_SELPH_CA4_TXDLY_RA13		GENMASK(22, 20)
	#define SHU2_SELPH_CA4_TXDLY_RA14		GENMASK(26, 24)
	#define SHU2_SELPH_CA4_TXDLY_RA15		GENMASK(30, 28)
#define SHU2_SELPH_CA5					0x00000e90
	#define SHU2_SELPH_CA5_DLY_CS			GENMASK(2, 0)
	#define SHU2_SELPH_CA5_DLY_CKE			GENMASK(6, 4)
	#define SHU2_SELPH_CA5_DLY_ODT			GENMASK(10, 8)
	#define SHU2_SELPH_CA5_DLY_RESET		GENMASK(14, 12)
	#define SHU2_SELPH_CA5_DLY_WE			GENMASK(18, 16)
	#define SHU2_SELPH_CA5_DLY_CAS			GENMASK(22, 20)
	#define SHU2_SELPH_CA5_DLY_RAS			GENMASK(26, 24)
	#define SHU2_SELPH_CA5_DLY_CS1			GENMASK(30, 28)
#define SHU2_SELPH_CA6					0x00000e94
	#define SHU2_SELPH_CA6_DLY_BA0			GENMASK(2, 0)
	#define SHU2_SELPH_CA6_DLY_BA1			GENMASK(6, 4)
	#define SHU2_SELPH_CA6_DLY_BA2			GENMASK(10, 8)
	#define SHU2_SELPH_CA6_DLY_CKE1			GENMASK(26, 24)
#define SHU2_SELPH_CA7					0x00000e98
	#define SHU2_SELPH_CA7_DLY_RA0			GENMASK(2, 0)
	#define SHU2_SELPH_CA7_DLY_RA1			GENMASK(6, 4)
	#define SHU2_SELPH_CA7_DLY_RA2			GENMASK(10, 8)
	#define SHU2_SELPH_CA7_DLY_RA3			GENMASK(14, 12)
	#define SHU2_SELPH_CA7_DLY_RA4			GENMASK(18, 16)
	#define SHU2_SELPH_CA7_DLY_RA5			GENMASK(22, 20)
	#define SHU2_SELPH_CA7_DLY_RA6			GENMASK(26, 24)
	#define SHU2_SELPH_CA7_DLY_RA7			GENMASK(30, 28)
#define SHU2_SELPH_CA8					0x00000e9c
	#define SHU2_SELPH_CA8_DLY_RA8			GENMASK(2, 0)
	#define SHU2_SELPH_CA8_DLY_RA9			GENMASK(6, 4)
	#define SHU2_SELPH_CA8_DLY_RA10			GENMASK(10, 8)
	#define SHU2_SELPH_CA8_DLY_RA11			GENMASK(14, 12)
	#define SHU2_SELPH_CA8_DLY_RA12			GENMASK(18, 16)
	#define SHU2_SELPH_CA8_DLY_RA13			GENMASK(22, 20)
	#define SHU2_SELPH_CA8_DLY_RA14			GENMASK(26, 24)
	#define SHU2_SELPH_CA8_DLY_RA15			GENMASK(30, 28)
#define SHU2_SELPH_DQS0					0x00000ea0
	#define SHU2_SELPH_DQS0_TXDLY_DQS0		GENMASK(2, 0)
	#define SHU2_SELPH_DQS0_TXDLY_DQS1		GENMASK(6, 4)
	#define SHU2_SELPH_DQS0_TXDLY_DQS2		GENMASK(10, 8)
	#define SHU2_SELPH_DQS0_TXDLY_DQS3		GENMASK(14, 12)
	#define SHU2_SELPH_DQS0_TXDLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU2_SELPH_DQS0_TXDLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU2_SELPH_DQS0_TXDLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU2_SELPH_DQS0_TXDLY_OEN_DQS3		GENMASK(30, 28)
#define SHU2_SELPH_DQS1					0x00000ea4
	#define SHU2_SELPH_DQS1_DLY_DQS0		GENMASK(2, 0)
	#define SHU2_SELPH_DQS1_DLY_DQS1		GENMASK(6, 4)
	#define SHU2_SELPH_DQS1_DLY_DQS2		GENMASK(10, 8)
	#define SHU2_SELPH_DQS1_DLY_DQS3		GENMASK(14, 12)
	#define SHU2_SELPH_DQS1_DLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU2_SELPH_DQS1_DLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU2_SELPH_DQS1_DLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU2_SELPH_DQS1_DLY_OEN_DQS3		GENMASK(30, 28)
#define SHU2_DRVING1					0x00000ea8
	#define SHU2_DRVING1_DQDRVN2			GENMASK(4, 0)
	#define SHU2_DRVING1_DQDRVP2			GENMASK(9, 5)
	#define SHU2_DRVING1_DQSDRVN1			GENMASK(14, 10)
	#define SHU2_DRVING1_DQSDRVP1			GENMASK(19, 15)
	#define SHU2_DRVING1_DQSDRVN2			GENMASK(24, 20)
	#define SHU2_DRVING1_DQSDRVP2			GENMASK(29, 25)
	#define SHU2_DRVING1_DIS_IMP_ODTN_TRACK		BIT(30)
	#define SHU2_DRVING1_DIS_IMPCAL_HW		BIT(31)
#define SHU2_DRVING2					0x00000eac
	#define SHU2_DRVING2_CMDDRVN1			GENMASK(4, 0)
	#define SHU2_DRVING2_CMDDRVP1			GENMASK(9, 5)
	#define SHU2_DRVING2_CMDDRVN2			GENMASK(14, 10)
	#define SHU2_DRVING2_CMDDRVP2			GENMASK(19, 15)
	#define SHU2_DRVING2_DQDRVN1			GENMASK(24, 20)
	#define SHU2_DRVING2_DQDRVP1			GENMASK(29, 25)
	#define SHU2_DRVING2_DIS_IMPCAL_ODT_EN		BIT(31)
#define SHU2_DRVING3					0x00000eb0
	#define SHU2_DRVING3_DQODTN2			GENMASK(4, 0)
	#define SHU2_DRVING3_DQODTP2			GENMASK(9, 5)
	#define SHU2_DRVING3_DQSODTN			GENMASK(14, 10)
	#define SHU2_DRVING3_DQSODTP			GENMASK(19, 15)
	#define SHU2_DRVING3_DQSODTN2			GENMASK(24, 20)
	#define SHU2_DRVING3_DQSODTP2			GENMASK(29, 25)
#define SHU2_DRVING4					0x00000eb4
	#define SHU2_DRVING4_CMDODTN1			GENMASK(4, 0)
	#define SHU2_DRVING4_CMDODTP1			GENMASK(9, 5)
	#define SHU2_DRVING4_CMDODTN2			GENMASK(14, 10)
	#define SHU2_DRVING4_CMDODTP2			GENMASK(19, 15)
	#define SHU2_DRVING4_DQODTN1			GENMASK(24, 20)
	#define SHU2_DRVING4_DQODTP1			GENMASK(29, 25)
#define SHU2_DRVING5					0x00000eb8
	#define SHU2_DRVING5_DQCODTN2			GENMASK(4, 0)
	#define SHU2_DRVING5_DQCODTP2			GENMASK(9, 5)
	#define SHU2_DRVING5_DQCDRVN1			GENMASK(14, 10)
	#define SHU2_DRVING5_DQCDRVP1			GENMASK(19, 15)
	#define SHU2_DRVING5_DQCDRVN2			GENMASK(24, 20)
	#define SHU2_DRVING5_DQCDRVP2			GENMASK(29, 25)
#define SHU2_DRVING6					0x00000ebc
	#define SHU2_DRVING6_DQCODTN1			GENMASK(24, 20)
	#define SHU2_DRVING6_DQCODTP1			GENMASK(29, 25)
#define SHU2_WODT					0x00000ec0
	#define SHU2_WODT_DISWODT			GENMASK(2, 0)
	#define SHU2_WODT_WODTFIX			BIT(3)
	#define SHU2_WODT_WODTFIXOFF			BIT(4)
	#define SHU2_WODT_DISWODTE			BIT(5)
	#define SHU2_WODT_DISWODTE2			BIT(6)
	#define SHU2_WODT_WODTPDEN			BIT(7)
	#define SHU2_WODT_DQOE_CNT			GENMASK(10, 8)
	#define SHU2_WODT_DQOE_OPT			BIT(11)
	#define SHU2_WODT_TXUPD_SEL			GENMASK(13, 12)
	#define SHU2_WODT_TXUPD_W2R_SEL			GENMASK(16, 14)
	#define SHU2_WODT_DBIWR				BIT(29)
	#define SHU2_WODT_TWPSTEXT			BIT(30)
	#define SHU2_WODT_WPST2T			BIT(31)
#define SHU2_DQSG					0x00000ec4
	#define SHU2_DQSG_DLLFRZRFCOPT			GENMASK(1, 0)
	#define SHU2_DQSG_DLLFRZWROPT			GENMASK(5, 4)
	#define SHU2_DQSG_R_RSTBCNT_LATCH_OPT		GENMASK(10, 8)
	#define SHU2_DQSG_STB_UPDMASK_EN		BIT(11)
	#define SHU2_DQSG_STB_UPDMASKCYC		GENMASK(15, 12)
	#define SHU2_DQSG_DQSINCTL_PRE_SEL		BIT(16)
	#define SHU2_DQSG_SCINTV			GENMASK(25, 20)
#define SHU2_SCINTV					0x00000ec8
	#define SHU2_SCINTV_ODTREN			BIT(0)
	#define SHU2_SCINTV_TZQLAT			GENMASK(5, 1)
	#define SHU2_SCINTV_TZQLAT2			GENMASK(10, 6)
	#define SHU2_SCINTV_RDDQC_INTV			GENMASK(12, 11)
	#define SHU2_SCINTV_MRW_INTV			GENMASK(17, 13)
	#define SHU2_SCINTV_DQS2DQ_SHU_PITHRD		GENMASK(23, 18)
	#define SHU2_SCINTV_DQS2DQ_FILT_PITHRD		GENMASK(29, 24)
	#define SHU2_SCINTV_DQSOSCENDIS			BIT(30)
#define SHU2_MISC					0x00000ecc
	#define SHU2_MISC_REQQUE_MAXCNT			GENMASK(3, 0)
	#define SHU2_MISC_CKEHCMD			GENMASK(5, 4)
	#define SHU2_MISC_NORMPOP_LEN			GENMASK(10, 8)
	#define SHU2_MISC_PREA_INTV			GENMASK(16, 12)
#define SHU2_DQS2DQ_TX					0x00000ed0
	#define SHU2_DQS2DQ_TX_OE2DQ_OFFSET		GENMASK(4, 0)
#define SHU2_HWSET_MR2					0x00000ed4
	#define SHU2_HWSET_MR2_HWSET_MR2_MRSMA		GENMASK(12, 0)
	#define SHU2_HWSET_MR2_HWSET_MR2_OP		GENMASK(23, 16)
#define SHU2_HWSET_MR13					0x00000ed8
	#define SHU2_HWSET_MR13_HWSET_MR13_MRSMA	GENMASK(12, 0)
	#define SHU2_HWSET_MR13_HWSET_MR13_OP		GENMASK(23, 16)
#define SHU2_HWSET_VRCG					0x00000edc
	#define SHU2_HWSET_VRCG_HWSET_VRCG_MRSMA	GENMASK(12, 0)
	#define SHU2_HWSET_VRCG_HWSET_VRCG_OP		GENMASK(23, 16)
#define SHU2_APHY_TX_PICG_CTRL				0x00000ee4
	#define SHU2_APHY_TX_PICG_CTRL_APHYPI_CG_CK_SEL	GENMASK(23, 20)
	#define SHU2_APHY_TX_PICG_CTRL_APHYPI_CG_CK_OPT	BIT(24)
	#define SHU2_APHY_TX_PICG_CTRL_DDRPHY_CLK_DYN_GATING_SEL	GENMASK(30, 27)
	#define SHU2_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_OPT	BIT(31)
#define SHU2RK0_DQSCTL					0x00001000
	#define SHU2RK0_DQSCTL_DQSINCTL			GENMASK(3, 0)
#define SHU2RK0_DQSIEN					0x00001004
	#define SHU2RK0_DQSIEN_R0DQS0IEN		GENMASK(6, 0)
	#define SHU2RK0_DQSIEN_R0DQS1IEN		GENMASK(14, 8)
	#define SHU2RK0_DQSIEN_R0DQS2IEN		GENMASK(22, 16)
	#define SHU2RK0_DQSIEN_R0DQS3IEN		GENMASK(30, 24)
#define SHU2RK0_DQSCAL					0x00001008
	#define SHU2RK0_DQSCAL_R0DQSIENLLMT		GENMASK(6, 0)
	#define SHU2RK0_DQSCAL_R0DQSIENLLMTEN		BIT(7)
	#define SHU2RK0_DQSCAL_R0DQSIENHLMT		GENMASK(14, 8)
	#define SHU2RK0_DQSCAL_R0DQSIENHLMTEN		BIT(15)
#define SHU2RK0_PI					0x0000100c
	#define SHU2RK0_PI_RK0_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU2RK0_PI_RK0_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU2RK0_PI_RK0_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU2RK0_PI_RK0_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU2RK0_DQSOSC					0x00001010
	#define SHU2RK0_DQSOSC_DQSOSC_BASE_RK0		GENMASK(15, 0)
	#define SHU2RK0_DQSOSC_DQSOSC_BASE_RK0_B1	GENMASK(31, 16)
#define SHU2RK0_SELPH_ODTEN0				0x0000101c
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU2RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU2RK0_SELPH_ODTEN1				0x00001020
	#define SHU2RK0_SELPH_ODTEN1_DLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU2RK0_SELPH_ODTEN1_DLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU2RK0_SELPH_DQSG0				0x00001024
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK0_SELPH_DQSG1				0x00001028
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK0_SELPH_DQ0				0x0000102c
	#define SHU2RK0_SELPH_DQ0_TXDLY_DQ0		GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQ0_TXDLY_DQ1		GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQ0_TXDLY_DQ2		GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQ0_TXDLY_DQ3		GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQ0_TXDLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQ0_TXDLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQ0_TXDLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQ0_TXDLY_OEN_DQ3		GENMASK(30, 28)
#define SHU2RK0_SELPH_DQ1				0x00001030
	#define SHU2RK0_SELPH_DQ1_TXDLY_DQM0		GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQ1_TXDLY_DQM1		GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQ1_TXDLY_DQM2		GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQ1_TXDLY_DQM3		GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQ1_TXDLY_OEN_DQM0	GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQ1_TXDLY_OEN_DQM1	GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQ1_TXDLY_OEN_DQM2	GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQ1_TXDLY_OEN_DQM3	GENMASK(30, 28)
#define SHU2RK0_SELPH_DQ2				0x00001034
	#define SHU2RK0_SELPH_DQ2_DLY_DQ0		GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQ2_DLY_DQ1		GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQ2_DLY_DQ2		GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQ2_DLY_DQ3		GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQ2_DLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQ2_DLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQ2_DLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQ2_DLY_OEN_DQ3		GENMASK(30, 28)
#define SHU2RK0_SELPH_DQ3				0x00001038
	#define SHU2RK0_SELPH_DQ3_DLY_DQM0		GENMASK(2, 0)
	#define SHU2RK0_SELPH_DQ3_DLY_DQM1		GENMASK(6, 4)
	#define SHU2RK0_SELPH_DQ3_DLY_DQM2		GENMASK(10, 8)
	#define SHU2RK0_SELPH_DQ3_DLY_DQM3		GENMASK(14, 12)
	#define SHU2RK0_SELPH_DQ3_DLY_OEN_DQM0		GENMASK(18, 16)
	#define SHU2RK0_SELPH_DQ3_DLY_OEN_DQM1		GENMASK(22, 20)
	#define SHU2RK0_SELPH_DQ3_DLY_OEN_DQM2		GENMASK(26, 24)
	#define SHU2RK0_SELPH_DQ3_DLY_OEN_DQM3		GENMASK(30, 28)
#define SHU2RK0_DQS2DQ_CAL1				0x00001040
	#define SHU2RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU2RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU2RK0_DQS2DQ_CAL2				0x00001044
	#define SHU2RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU2RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU2RK0_DQS2DQ_CAL3				0x00001048
	#define SHU2RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0	GENMASK(5, 0)
	#define SHU2RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1	GENMASK(11, 6)
	#define SHU2RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU2RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU2RK0_DQS2DQ_CAL4				0x0000104c
	#define SHU2RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0	GENMASK(5, 0)
	#define SHU2RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1	GENMASK(11, 6)
	#define SHU2RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU2RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU2RK0_DQS2DQ_CAL5				0x00001050
	#define SHU2RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0	GENMASK(10, 0)
	#define SHU2RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1	GENMASK(26, 16)
#define SHU2RK1_DQSCTL					0x00001100
	#define SHU2RK1_DQSCTL_R1DQSINCTL		GENMASK(3, 0)
#define SHU2RK1_DQSIEN					0x00001104
	#define SHU2RK1_DQSIEN_R1DQS0IEN		GENMASK(6, 0)
	#define SHU2RK1_DQSIEN_R1DQS1IEN		GENMASK(14, 8)
	#define SHU2RK1_DQSIEN_R1DQS2IEN		GENMASK(22, 16)
	#define SHU2RK1_DQSIEN_R1DQS3IEN		GENMASK(30, 24)
#define SHU2RK1_DQSCAL					0x00001108
	#define SHU2RK1_DQSCAL_R1DQSIENLLMT		GENMASK(6, 0)
	#define SHU2RK1_DQSCAL_R1DQSIENLLMTEN		BIT(7)
	#define SHU2RK1_DQSCAL_R1DQSIENHLMT		GENMASK(14, 8)
	#define SHU2RK1_DQSCAL_R1DQSIENHLMTEN		BIT(15)
#define SHU2RK1_PI					0x0000110c
	#define SHU2RK1_PI_RK1_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU2RK1_PI_RK1_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU2RK1_PI_RK1_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU2RK1_PI_RK1_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU2RK1_DQSOSC					0x00001110
	#define SHU2RK1_DQSOSC_DQSOSC_BASE_RK1		GENMASK(15, 0)
	#define SHU2RK1_DQSOSC_DQSOSC_BASE_RK1_B1	GENMASK(31, 16)
#define SHU2RK1_SELPH_ODTEN0				0x0000111c
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU2RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU2RK1_SELPH_ODTEN1				0x00001120
	#define SHU2RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU2RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU2RK1_SELPH_DQSG0				0x00001124
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK1_SELPH_DQSG1				0x00001128
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK1_SELPH_DQ0				0x0000112c
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ0	GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ2	GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ3	GENMASK(30, 28)
#define SHU2RK1_SELPH_DQ1				0x00001130
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU2RK1_SELPH_DQ2				0x00001134
	#define SHU2RK1_SELPH_DQ2_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQ2_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQ2_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQ2_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQ2_DLY_R1OEN_DQ0		GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQ2_DLY_R1OEN_DQ1		GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQ2_DLY_R1OEN_DQ2		GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQ2_DLY_R1OEN_DQ3		GENMASK(30, 28)
#define SHU2RK1_SELPH_DQ3				0x00001138
	#define SHU2RK1_SELPH_DQ3_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU2RK1_SELPH_DQ3_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU2RK1_SELPH_DQ3_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU2RK1_SELPH_DQ3_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU2RK1_SELPH_DQ3_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU2RK1_SELPH_DQ3_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU2RK1_SELPH_DQ3_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU2RK1_SELPH_DQ3_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU2RK1_DQS2DQ_CAL1				0x00001140
	#define SHU2RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU2RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU2RK1_DQS2DQ_CAL2				0x00001144
	#define SHU2RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU2RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU2RK1_DQS2DQ_CAL3				0x00001148
	#define SHU2RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0	GENMASK(5, 0)
	#define SHU2RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1	GENMASK(11, 6)
	#define SHU2RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU2RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU2RK1_DQS2DQ_CAL4				0x0000114c
	#define SHU2RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0	GENMASK(5, 0)
	#define SHU2RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1	GENMASK(11, 6)
	#define SHU2RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU2RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU2RK1_DQS2DQ_CAL5				0x00001150
	#define SHU2RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM0	GENMASK(10, 0)
	#define SHU2RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM1	GENMASK(26, 16)
#define SHU2RK2_DQSCTL					0x00001200
	#define SHU2RK2_DQSCTL_R2DQSINCTL		GENMASK(3, 0)
#define SHU2RK2_DQSIEN					0x00001204
	#define SHU2RK2_DQSIEN_R2DQS0IEN		GENMASK(6, 0)
	#define SHU2RK2_DQSIEN_R2DQS1IEN		GENMASK(14, 8)
	#define SHU2RK2_DQSIEN_R2DQS2IEN		GENMASK(22, 16)
	#define SHU2RK2_DQSIEN_R2DQS3IEN		GENMASK(30, 24)
#define SHU2RK2_DQSCAL					0x00001208
	#define SHU2RK2_DQSCAL_R2DQSIENLLMT		GENMASK(6, 0)
	#define SHU2RK2_DQSCAL_R2DQSIENLLMTEN		BIT(7)
	#define SHU2RK2_DQSCAL_R2DQSIENHLMT		GENMASK(14, 8)
	#define SHU2RK2_DQSCAL_R2DQSIENHLMTEN		BIT(15)
#define SHU2RK2_PI					0x0000120c
	#define SHU2RK2_PI_RK2_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU2RK2_PI_RK2_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU2RK2_PI_RK2_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU2RK2_PI_RK2_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU2RK2_DQSOSC					0x00001210
	#define SHU2RK2_DQSOSC_DQSOSC_BASE_RK2		GENMASK(15, 0)
	#define SHU2RK2_DQSOSC_DQSOSC_BASE_RK2_B1	GENMASK(31, 16)
#define SHU2RK2_SELPH_ODTEN0				0x0000121c
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU2RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU2RK2_SELPH_ODTEN1				0x00001220
	#define SHU2RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU2RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU2RK2_SELPH_DQSG0				0x00001224
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK2_SELPH_DQSG1				0x00001228
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU2RK2_SELPH_DQ0				0x0000122c
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ0	GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ2	GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ3	GENMASK(30, 28)
#define SHU2RK2_SELPH_DQ1				0x00001230
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU2RK2_SELPH_DQ2				0x00001234
	#define SHU2RK2_SELPH_DQ2_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQ2_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQ2_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQ2_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQ2_DLY_R2OEN_DQ0		GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQ2_DLY_R2OEN_DQ1		GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQ2_DLY_R2OEN_DQ2		GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQ2_DLY_R2OEN_DQ3		GENMASK(30, 28)
#define SHU2RK2_SELPH_DQ3				0x00001238
	#define SHU2RK2_SELPH_DQ3_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU2RK2_SELPH_DQ3_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU2RK2_SELPH_DQ3_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU2RK2_SELPH_DQ3_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU2RK2_SELPH_DQ3_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU2RK2_SELPH_DQ3_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU2RK2_SELPH_DQ3_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU2RK2_SELPH_DQ3_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU2RK2_DQS2DQ_CAL1				0x00001240
	#define SHU2RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU2RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU2RK2_DQS2DQ_CAL2				0x00001244
	#define SHU2RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU2RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU2RK2_DQS2DQ_CAL3				0x00001248
	#define SHU2RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ0	GENMASK(5, 0)
	#define SHU2RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ1	GENMASK(11, 6)
#define SHU2RK2_DQS2DQ_CAL4				0x0000124c
	#define SHU2RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM0	GENMASK(5, 0)
	#define SHU2RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM1	GENMASK(11, 6)
#define SHU2RK2_DQS2DQ_CAL5				0x00001250
	#define SHU2RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM0	GENMASK(10, 0)
	#define SHU2RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM1	GENMASK(26, 16)
#define SHU2_DQSG_RETRY					0x00001254
	#define SHU2_DQSG_RETRY_R_DQSGRETRY_SW_RESET	BIT(0)
	#define SHU2_DQSG_RETRY_R_DQSG_RETRY_SW_EN	BIT(1)
	#define SHU2_DQSG_RETRY_R_DDR1866_PLUS		BIT(2)
	#define SHU2_DQSG_RETRY_R_RETRY_ONCE		BIT(3)
	#define SHU2_DQSG_RETRY_R_RETRY_3TIMES		BIT(4)
	#define SHU2_DQSG_RETRY_R_RETRY_1RANK		BIT(5)
	#define SHU2_DQSG_RETRY_R_RETRY_SAV_MSK		BIT(6)
	#define SHU2_DQSG_RETRY_R_DM4BYTE		BIT(7)
	#define SHU2_DQSG_RETRY_R_DQSIENLAT		GENMASK(11, 8)
	#define SHU2_DQSG_RETRY_R_STBENCMP_ALLBYTE	BIT(12)
	#define SHU2_DQSG_RETRY_R_XSR_DQSG_RETRY_EN	BIT(13)
	#define SHU2_DQSG_RETRY_R_XSR_RETRY_SPM_MODE	BIT(14)
	#define SHU2_DQSG_RETRY_R_RETRY_CMP_DATA	BIT(15)
	#define SHU2_DQSG_RETRY_R_RETRY_ALE_BLOCK_MASK	BIT(20)
	#define SHU2_DQSG_RETRY_R_RDY_SEL_DLE		BIT(21)
	#define SHU2_DQSG_RETRY_R_RETRY_ROUND_NUM	GENMASK(25, 24)
	#define SHU2_DQSG_RETRY_R_RETRY_RANKSEL_FROM_PHY	BIT(28)
	#define SHU2_DQSG_RETRY_R_RETRY_PA_DSIABLE	BIT(29)
	#define SHU2_DQSG_RETRY_R_RETRY_STBEN_RESET_MSK	BIT(30)
	#define SHU2_DQSG_RETRY_R_RETRY_USE_BURST_MDOE	BIT(31)
#define SHU3_ACTIM0					0x00001400
	#define SHU3_ACTIM0_TWTR			GENMASK(3, 0)
	#define SHU3_ACTIM0_TWR				GENMASK(12, 8)
	#define SHU3_ACTIM0_TRRD			GENMASK(18, 16)
	#define SHU3_ACTIM0_TRCD			GENMASK(27, 24)
#define SHU3_ACTIM1					0x00001404
	#define SHU3_ACTIM1_TRPAB			GENMASK(2, 0)
	#define SHU3_ACTIM1_TRP				GENMASK(11, 8)
	#define SHU3_ACTIM1_TRAS			GENMASK(19, 16)
	#define SHU3_ACTIM1_TRC				GENMASK(28, 24)
#define SHU3_ACTIM2					0x00001408
	#define SHU3_ACTIM2_TXP				GENMASK(2, 0)
	#define SHU3_ACTIM2_TRTP			GENMASK(10, 8)
	#define SHU3_ACTIM2_TR2W			GENMASK(19, 16)
	#define SHU3_ACTIM2_TFAW			GENMASK(28, 24)
#define SHU3_ACTIM3					0x0000140c
	#define SHU3_ACTIM3_TRFCPB			GENMASK(7, 0)
	#define SHU3_ACTIM3_TRFC			GENMASK(23, 16)
	#define SHU3_ACTIM3_REFCNT			GENMASK(31, 24)
#define SHU3_ACTIM4					0x00001410
	#define SHU3_ACTIM4_TXREFCNT			GENMASK(9, 0)
	#define SHU3_ACTIM4_REFCNT_FR_CLK		GENMASK(23, 16)
	#define SHU3_ACTIM4_TZQCS			GENMASK(31, 24)
#define SHU3_ACTIM5					0x00001414
	#define SHU3_ACTIM5_TR2PD			GENMASK(4, 0)
	#define SHU3_ACTIM5_TWTPD			GENMASK(12, 8)
	#define SHU3_ACTIM5_TMRR2W			GENMASK(27, 24)
#define SHU3_ACTIM6					0x00001418
	#define SHU3_ACTIM6_BGTCCD			GENMASK(1, 0)
	#define SHU3_ACTIM6_BGTWTR			GENMASK(7, 4)
	#define SHU3_ACTIM6_TWRMPR			GENMASK(11, 8)
	#define SHU3_ACTIM6_BGTRRD			GENMASK(14, 12)
#define SHU3_ACTIM_XRT					0x0000141c
	#define SHU3_ACTIM_XRT_XRTR2R			GENMASK(4, 0)
	#define SHU3_ACTIM_XRT_XRTR2W			GENMASK(11, 8)
	#define SHU3_ACTIM_XRT_XRTW2R			GENMASK(18, 16)
	#define SHU3_ACTIM_XRT_XRTW2W			GENMASK(27, 24)
#define SHU3_AC_TIME_05T				0x00001420
	#define SHU3_AC_TIME_05T_TRC_05T		BIT(0)
	#define SHU3_AC_TIME_05T_TRFCPB_05T		BIT(1)
	#define SHU3_AC_TIME_05T_TRFC_05T		BIT(2)
	#define SHU3_AC_TIME_05T_TXP_05T		BIT(4)
	#define SHU3_AC_TIME_05T_TRTP_05T		BIT(5)
	#define SHU3_AC_TIME_05T_TRCD_05T		BIT(6)
	#define SHU3_AC_TIME_05T_TRP_05T		BIT(7)
	#define SHU3_AC_TIME_05T_TRPAB_05T		BIT(8)
	#define SHU3_AC_TIME_05T_TRAS_05T		BIT(9)
	#define SHU3_AC_TIME_05T_TWR_M05T		BIT(10)
	#define SHU3_AC_TIME_05T_TRRD_05T		BIT(12)
	#define SHU3_AC_TIME_05T_TFAW_05T		BIT(13)
	#define SHU3_AC_TIME_05T_TR2PD_05T		BIT(15)
	#define SHU3_AC_TIME_05T_TWTPD_M05T		BIT(16)
	#define SHU3_AC_TIME_05T_BGTRRD_05T		BIT(21)
	#define SHU3_AC_TIME_05T_BGTCCD_05T		BIT(22)
	#define SHU3_AC_TIME_05T_BGTWTR_05T		BIT(23)
	#define SHU3_AC_TIME_05T_TR2W_05T		BIT(24)
	#define SHU3_AC_TIME_05T_TWTR_M05T		BIT(25)
	#define SHU3_AC_TIME_05T_XRTR2W_05T		BIT(26)
	#define SHU3_AC_TIME_05T_XRTW2R_M05T		BIT(27)
#define SHU3_AC_DERATING0				0x00001424
	#define SHU3_AC_DERATING0_ACDERATEEN		BIT(0)
	#define SHU3_AC_DERATING0_TRRD_DERATE		GENMASK(18, 16)
	#define SHU3_AC_DERATING0_TRCD_DERATE		GENMASK(27, 24)
#define SHU3_AC_DERATING1				0x00001428
	#define SHU3_AC_DERATING1_TRPAB_DERATE		GENMASK(2, 0)
	#define SHU3_AC_DERATING1_TRP_DERATE		GENMASK(11, 8)
	#define SHU3_AC_DERATING1_TRAS_DERATE		GENMASK(19, 16)
	#define SHU3_AC_DERATING1_TRC_DERATE		GENMASK(28, 24)
#define SHU3_AC_DERATING_05T				0x00001430
	#define SHU3_AC_DERATING_05T_TRC_05T_DERATE	BIT(0)
	#define SHU3_AC_DERATING_05T_TRCD_05T_DERATE	BIT(6)
	#define SHU3_AC_DERATING_05T_TRP_05T_DERATE	BIT(7)
	#define SHU3_AC_DERATING_05T_TRPAB_05T_DERATE	BIT(8)
	#define SHU3_AC_DERATING_05T_TRAS_05T_DERATE	BIT(9)
	#define SHU3_AC_DERATING_05T_TRRD_05T_DERATE	BIT(12)
#define SHU3_CONF0					0x00001440
	#define SHU3_CONF0_DMPGTIM			GENMASK(5, 0)
	#define SHU3_CONF0_ADVREFEN			BIT(6)
	#define SHU3_CONF0_ADVPREEN			BIT(7)
	#define SHU3_CONF0_TRFCPBIG			BIT(9)
	#define SHU3_CONF0_REFTHD			GENMASK(15, 12)
	#define SHU3_CONF0_REQQUE_DEPTH			GENMASK(19, 16)
	#define SHU3_CONF0_FREQDIV4			BIT(24)
	#define SHU3_CONF0_FDIV2			BIT(25)
	#define SHU3_CONF0_CL2				BIT(27)
	#define SHU3_CONF0_BL2				BIT(28)
	#define SHU3_CONF0_BL4				BIT(29)
	#define SHU3_CONF0_MATYPE			GENMASK(31, 30)
#define SHU3_CONF1					0x00001444
	#define SHU3_CONF1_DATLAT			GENMASK(4, 0)
	#define SHU3_CONF1_DATLAT_DSEL			GENMASK(12, 8)
	#define SHU3_CONF1_REFBW_FR			GENMASK(25, 16)
	#define SHU3_CONF1_DATLAT_DSEL_PHY		GENMASK(30, 26)
	#define SHU3_CONF1_TREFBWIG			BIT(31)
#define SHU3_CONF2					0x00001448
	#define SHU3_CONF2_TCMDO1LAT			GENMASK(7, 0)
	#define SHU3_CONF2_FSPCHG_PRDCNT		GENMASK(15, 8)
	#define SHU3_CONF2_DCMDLYREF			GENMASK(18, 16)
	#define SHU3_CONF2_DQCMD			BIT(25)
	#define SHU3_CONF2_DQ16COM1			BIT(26)
	#define SHU3_CONF2_RA15TOCS1			BIT(27)
	#define SHU3_CONF2_WPRE2T			BIT(28)
	#define SHU3_CONF2_FASTWAKE2			BIT(29)
	#define SHU3_CONF2_DAREFEN			BIT(30)
	#define SHU3_CONF2_FASTWAKE			BIT(31)
#define SHU3_CONF3					0x0000144c
	#define SHU3_CONF3_ZQCSCNT			GENMASK(15, 0)
	#define SHU3_CONF3_REFRCNT			GENMASK(24, 16)
#define SHU3_STBCAL					0x00001450
	#define SHU3_STBCAL_DMSTBLAT			GENMASK(1, 0)
	#define SHU3_STBCAL_PICGLAT			GENMASK(6, 4)
	#define SHU3_STBCAL_DQSG_MODE			BIT(8)
#define SHU3_DQSOSCTHRD					0x00001454
	#define SHU3_DQSOSCTHRD_DQSOSCTHRD_INC_RK0	GENMASK(11, 0)
	#define SHU3_DQSOSCTHRD_DQSOSCTHRD_DEC_RK0	GENMASK(23, 12)
	#define SHU3_DQSOSCTHRD_DQSOSCTHRD_INC_RK1_7TO0	GENMASK(31, 24)
#define SHU3_RANKCTL					0x00001458
	#define SHU3_RANKCTL_RANKINCTL_RXDLY		GENMASK(3, 0)
	#define SHU3_RANKCTL_TXRANKINCTL_TXDLY		GENMASK(11, 8)
	#define SHU3_RANKCTL_TXRANKINCTL		GENMASK(15, 12)
	#define SHU3_RANKCTL_TXRANKINCTL_ROOT		GENMASK(19, 16)
	#define SHU3_RANKCTL_RANKINCTL			GENMASK(23, 20)
	#define SHU3_RANKCTL_RANKINCTL_ROOT1		GENMASK(27, 24)
	#define SHU3_RANKCTL_RANKINCTL_PHY		GENMASK(31, 28)
#define SHU3_CKECTRL					0x0000145c
	#define SHU3_CKECTRL_CMDCKE			GENMASK(18, 16)
	#define SHU3_CKECTRL_CKEPRD			GENMASK(22, 20)
	#define SHU3_CKECTRL_TCKESRX			GENMASK(25, 24)
	#define SHU3_CKECTRL_SREF_CK_DLY		GENMASK(29, 28)
#define SHU3_ODTCTRL					0x00001460
	#define SHU3_ODTCTRL_ROEN			BIT(0)
	#define SHU3_ODTCTRL_WOEN			BIT(1)
	#define SHU3_ODTCTRL_RODTEN_SELPH_CG_IG		BIT(2)
	#define SHU3_ODTCTRL_RODTENSTB_SELPH_CG_IG	BIT(3)
	#define SHU3_ODTCTRL_RODT			GENMASK(7, 4)
	#define SHU3_ODTCTRL_TWODT			GENMASK(22, 16)
	#define SHU3_ODTCTRL_FIXRODT			BIT(27)
	#define SHU3_ODTCTRL_RODTE2			BIT(30)
	#define SHU3_ODTCTRL_RODTE			BIT(31)
#define SHU3_IMPCAL1					0x00001464
	#define SHU3_IMPCAL1_IMPCAL_CHKCYCLE		GENMASK(2, 0)
	#define SHU3_IMPCAL1_IMPDRVP			GENMASK(8, 4)
	#define SHU3_IMPCAL1_IMPDRVN			GENMASK(15, 11)
	#define SHU3_IMPCAL1_IMPCAL_CALEN_CYCLE		GENMASK(19, 17)
	#define SHU3_IMPCAL1_IMPCALCNT			GENMASK(27, 20)
	#define SHU3_IMPCAL1_IMPCAL_CALICNT		GENMASK(31, 28)
#define SHU3_DQSOSC_PRD					0x00001468
	#define SHU3_DQSOSC_PRD_DQSOSC_PRDCNT		GENMASK(9, 0)
	#define SHU3_DQSOSC_PRD_DQSOSCTHRD_INC_RK1_11TO8	GENMASK(19, 16)
	#define SHU3_DQSOSC_PRD_DQSOSCTHRD_DEC_RK1	GENMASK(31, 20)
#define SHU3_DQSOSCR					0x0000146c
	#define SHU3_DQSOSCR_DQSOSCRCNT			GENMASK(7, 0)
	#define SHU3_DQSOSCR_DQSOSC_DELTA		GENMASK(31, 16)
#define SHU3_DQSOSCR2					0x00001470
	#define SHU3_DQSOSCR2_DQSOSCENCNT		GENMASK(15, 0)
	#define SHU3_DQSOSCR2_DQSOSC_ADV_SEL		GENMASK(17, 16)
	#define SHU3_DQSOSCR2_DQSOSC_DRS_ADV_SEL	GENMASK(19, 18)
#define SHU3_RODTENSTB					0x00001474
	#define SHU3_RODTENSTB_RODTEN_MCK_MODESEL	BIT(0)
	#define SHU3_RODTENSTB_RODTEN_P1_ENABLE		BIT(1)
	#define SHU3_RODTENSTB_RODTENSTB_OFFSET		GENMASK(7, 2)
	#define SHU3_RODTENSTB_RODTENSTB_EXT		GENMASK(23, 8)
	#define SHU3_RODTENSTB_RODTENSTB_4BYTE_EN	BIT(31)
#define SHU3_PIPE					0x00001478
	#define SHU3_PIPE_PHYRXPIPE1			BIT(0)
	#define SHU3_PIPE_PHYRXPIPE2			BIT(1)
	#define SHU3_PIPE_PHYRXPIPE3			BIT(2)
	#define SHU3_PIPE_PHYRXRDSLPIPE1		BIT(4)
	#define SHU3_PIPE_PHYRXRDSLPIPE2		BIT(5)
	#define SHU3_PIPE_PHYRXRDSLPIPE3		BIT(6)
	#define SHU3_PIPE_PHYPIPE1EN			BIT(8)
	#define SHU3_PIPE_PHYPIPE2EN			BIT(9)
	#define SHU3_PIPE_PHYPIPE3EN			BIT(10)
	#define SHU3_PIPE_DLE_LAST_EXTEND3		BIT(26)
	#define SHU3_PIPE_READ_START_EXTEND3		BIT(27)
	#define SHU3_PIPE_DLE_LAST_EXTEND2		BIT(28)
	#define SHU3_PIPE_READ_START_EXTEND2		BIT(29)
	#define SHU3_PIPE_DLE_LAST_EXTEND1		BIT(30)
	#define SHU3_PIPE_READ_START_EXTEND1		BIT(31)
#define SHU3_TEST1					0x0000147c
	#define SHU3_TEST1_LATNORMPOP			GENMASK(12, 8)
	#define SHU3_TEST1_DQSICALBLCOK_CNT		GENMASK(22, 20)
	#define SHU3_TEST1_DQSICALI_NEW			BIT(23)
#define SHU3_SELPH_CA1					0x00001480
	#define SHU3_SELPH_CA1_TXDLY_CS			GENMASK(2, 0)
	#define SHU3_SELPH_CA1_TXDLY_CKE		GENMASK(6, 4)
	#define SHU3_SELPH_CA1_TXDLY_ODT		GENMASK(10, 8)
	#define SHU3_SELPH_CA1_TXDLY_RESET		GENMASK(14, 12)
	#define SHU3_SELPH_CA1_TXDLY_WE			GENMASK(18, 16)
	#define SHU3_SELPH_CA1_TXDLY_CAS		GENMASK(22, 20)
	#define SHU3_SELPH_CA1_TXDLY_RAS		GENMASK(26, 24)
	#define SHU3_SELPH_CA1_TXDLY_CS1		GENMASK(30, 28)
#define SHU3_SELPH_CA2					0x00001484
	#define SHU3_SELPH_CA2_TXDLY_BA0		GENMASK(2, 0)
	#define SHU3_SELPH_CA2_TXDLY_BA1		GENMASK(6, 4)
	#define SHU3_SELPH_CA2_TXDLY_BA2		GENMASK(10, 8)
	#define SHU3_SELPH_CA2_TXDLY_CMD		GENMASK(20, 16)
	#define SHU3_SELPH_CA2_TXDLY_CKE1		GENMASK(26, 24)
#define SHU3_SELPH_CA3					0x00001488
	#define SHU3_SELPH_CA3_TXDLY_RA0		GENMASK(2, 0)
	#define SHU3_SELPH_CA3_TXDLY_RA1		GENMASK(6, 4)
	#define SHU3_SELPH_CA3_TXDLY_RA2		GENMASK(10, 8)
	#define SHU3_SELPH_CA3_TXDLY_RA3		GENMASK(14, 12)
	#define SHU3_SELPH_CA3_TXDLY_RA4		GENMASK(18, 16)
	#define SHU3_SELPH_CA3_TXDLY_RA5		GENMASK(22, 20)
	#define SHU3_SELPH_CA3_TXDLY_RA6		GENMASK(26, 24)
	#define SHU3_SELPH_CA3_TXDLY_RA7		GENMASK(30, 28)
#define SHU3_SELPH_CA4					0x0000148c
	#define SHU3_SELPH_CA4_TXDLY_RA8		GENMASK(2, 0)
	#define SHU3_SELPH_CA4_TXDLY_RA9		GENMASK(6, 4)
	#define SHU3_SELPH_CA4_TXDLY_RA10		GENMASK(10, 8)
	#define SHU3_SELPH_CA4_TXDLY_RA11		GENMASK(14, 12)
	#define SHU3_SELPH_CA4_TXDLY_RA12		GENMASK(18, 16)
	#define SHU3_SELPH_CA4_TXDLY_RA13		GENMASK(22, 20)
	#define SHU3_SELPH_CA4_TXDLY_RA14		GENMASK(26, 24)
	#define SHU3_SELPH_CA4_TXDLY_RA15		GENMASK(30, 28)
#define SHU3_SELPH_CA5					0x00001490
	#define SHU3_SELPH_CA5_DLY_CS			GENMASK(2, 0)
	#define SHU3_SELPH_CA5_DLY_CKE			GENMASK(6, 4)
	#define SHU3_SELPH_CA5_DLY_ODT			GENMASK(10, 8)
	#define SHU3_SELPH_CA5_DLY_RESET		GENMASK(14, 12)
	#define SHU3_SELPH_CA5_DLY_WE			GENMASK(18, 16)
	#define SHU3_SELPH_CA5_DLY_CAS			GENMASK(22, 20)
	#define SHU3_SELPH_CA5_DLY_RAS			GENMASK(26, 24)
	#define SHU3_SELPH_CA5_DLY_CS1			GENMASK(30, 28)
#define SHU3_SELPH_CA6					0x00001494
	#define SHU3_SELPH_CA6_DLY_BA0			GENMASK(2, 0)
	#define SHU3_SELPH_CA6_DLY_BA1			GENMASK(6, 4)
	#define SHU3_SELPH_CA6_DLY_BA2			GENMASK(10, 8)
	#define SHU3_SELPH_CA6_DLY_CKE1			GENMASK(26, 24)
#define SHU3_SELPH_CA7					0x00001498
	#define SHU3_SELPH_CA7_DLY_RA0			GENMASK(2, 0)
	#define SHU3_SELPH_CA7_DLY_RA1			GENMASK(6, 4)
	#define SHU3_SELPH_CA7_DLY_RA2			GENMASK(10, 8)
	#define SHU3_SELPH_CA7_DLY_RA3			GENMASK(14, 12)
	#define SHU3_SELPH_CA7_DLY_RA4			GENMASK(18, 16)
	#define SHU3_SELPH_CA7_DLY_RA5			GENMASK(22, 20)
	#define SHU3_SELPH_CA7_DLY_RA6			GENMASK(26, 24)
	#define SHU3_SELPH_CA7_DLY_RA7			GENMASK(30, 28)
#define SHU3_SELPH_CA8					0x0000149c
	#define SHU3_SELPH_CA8_DLY_RA8			GENMASK(2, 0)
	#define SHU3_SELPH_CA8_DLY_RA9			GENMASK(6, 4)
	#define SHU3_SELPH_CA8_DLY_RA10			GENMASK(10, 8)
	#define SHU3_SELPH_CA8_DLY_RA11			GENMASK(14, 12)
	#define SHU3_SELPH_CA8_DLY_RA12			GENMASK(18, 16)
	#define SHU3_SELPH_CA8_DLY_RA13			GENMASK(22, 20)
	#define SHU3_SELPH_CA8_DLY_RA14			GENMASK(26, 24)
	#define SHU3_SELPH_CA8_DLY_RA15			GENMASK(30, 28)
#define SHU3_SELPH_DQS0					0x000014a0
	#define SHU3_SELPH_DQS0_TXDLY_DQS0		GENMASK(2, 0)
	#define SHU3_SELPH_DQS0_TXDLY_DQS1		GENMASK(6, 4)
	#define SHU3_SELPH_DQS0_TXDLY_DQS2		GENMASK(10, 8)
	#define SHU3_SELPH_DQS0_TXDLY_DQS3		GENMASK(14, 12)
	#define SHU3_SELPH_DQS0_TXDLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU3_SELPH_DQS0_TXDLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU3_SELPH_DQS0_TXDLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU3_SELPH_DQS0_TXDLY_OEN_DQS3		GENMASK(30, 28)
#define SHU3_SELPH_DQS1					0x000014a4
	#define SHU3_SELPH_DQS1_DLY_DQS0		GENMASK(2, 0)
	#define SHU3_SELPH_DQS1_DLY_DQS1		GENMASK(6, 4)
	#define SHU3_SELPH_DQS1_DLY_DQS2		GENMASK(10, 8)
	#define SHU3_SELPH_DQS1_DLY_DQS3		GENMASK(14, 12)
	#define SHU3_SELPH_DQS1_DLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU3_SELPH_DQS1_DLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU3_SELPH_DQS1_DLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU3_SELPH_DQS1_DLY_OEN_DQS3		GENMASK(30, 28)
#define SHU3_DRVING1					0x000014a8
	#define SHU3_DRVING1_DQDRVN2			GENMASK(4, 0)
	#define SHU3_DRVING1_DQDRVP2			GENMASK(9, 5)
	#define SHU3_DRVING1_DQSDRVN1			GENMASK(14, 10)
	#define SHU3_DRVING1_DQSDRVP1			GENMASK(19, 15)
	#define SHU3_DRVING1_DQSDRVN2			GENMASK(24, 20)
	#define SHU3_DRVING1_DQSDRVP2			GENMASK(29, 25)
	#define SHU3_DRVING1_DIS_IMP_ODTN_TRACK		BIT(30)
	#define SHU3_DRVING1_DIS_IMPCAL_HW		BIT(31)
#define SHU3_DRVING2					0x000014ac
	#define SHU3_DRVING2_CMDDRVN1			GENMASK(4, 0)
	#define SHU3_DRVING2_CMDDRVP1			GENMASK(9, 5)
	#define SHU3_DRVING2_CMDDRVN2			GENMASK(14, 10)
	#define SHU3_DRVING2_CMDDRVP2			GENMASK(19, 15)
	#define SHU3_DRVING2_DQDRVN1			GENMASK(24, 20)
	#define SHU3_DRVING2_DQDRVP1			GENMASK(29, 25)
	#define SHU3_DRVING2_DIS_IMPCAL_ODT_EN		BIT(31)
#define SHU3_DRVING3					0x000014b0
	#define SHU3_DRVING3_DQODTN2			GENMASK(4, 0)
	#define SHU3_DRVING3_DQODTP2			GENMASK(9, 5)
	#define SHU3_DRVING3_DQSODTN			GENMASK(14, 10)
	#define SHU3_DRVING3_DQSODTP			GENMASK(19, 15)
	#define SHU3_DRVING3_DQSODTN2			GENMASK(24, 20)
	#define SHU3_DRVING3_DQSODTP2			GENMASK(29, 25)
#define SHU3_DRVING4					0x000014b4
	#define SHU3_DRVING4_CMDODTN1			GENMASK(4, 0)
	#define SHU3_DRVING4_CMDODTP1			GENMASK(9, 5)
	#define SHU3_DRVING4_CMDODTN2			GENMASK(14, 10)
	#define SHU3_DRVING4_CMDODTP2			GENMASK(19, 15)
	#define SHU3_DRVING4_DQODTN1			GENMASK(24, 20)
	#define SHU3_DRVING4_DQODTP1			GENMASK(29, 25)
#define SHU3_DRVING5					0x000014b8
	#define SHU3_DRVING5_DQCODTN2			GENMASK(4, 0)
	#define SHU3_DRVING5_DQCODTP2			GENMASK(9, 5)
	#define SHU3_DRVING5_DQCDRVN1			GENMASK(14, 10)
	#define SHU3_DRVING5_DQCDRVP1			GENMASK(19, 15)
	#define SHU3_DRVING5_DQCDRVN2			GENMASK(24, 20)
	#define SHU3_DRVING5_DQCDRVP2			GENMASK(29, 25)
#define SHU3_DRVING6					0x000014bc
	#define SHU3_DRVING6_DQCODTN1			GENMASK(24, 20)
	#define SHU3_DRVING6_DQCODTP1			GENMASK(29, 25)
#define SHU3_WODT					0x000014c0
	#define SHU3_WODT_DISWODT			GENMASK(2, 0)
	#define SHU3_WODT_WODTFIX			BIT(3)
	#define SHU3_WODT_WODTFIXOFF			BIT(4)
	#define SHU3_WODT_DISWODTE			BIT(5)
	#define SHU3_WODT_DISWODTE2			BIT(6)
	#define SHU3_WODT_WODTPDEN			BIT(7)
	#define SHU3_WODT_DQOE_CNT			GENMASK(10, 8)
	#define SHU3_WODT_DQOE_OPT			BIT(11)
	#define SHU3_WODT_TXUPD_SEL			GENMASK(13, 12)
	#define SHU3_WODT_TXUPD_W2R_SEL			GENMASK(16, 14)
	#define SHU3_WODT_DBIWR				BIT(29)
	#define SHU3_WODT_TWPSTEXT			BIT(30)
	#define SHU3_WODT_WPST2T			BIT(31)
#define SHU3_DQSG					0x000014c4
	#define SHU3_DQSG_DLLFRZRFCOPT			GENMASK(1, 0)
	#define SHU3_DQSG_DLLFRZWROPT			GENMASK(5, 4)
	#define SHU3_DQSG_R_RSTBCNT_LATCH_OPT		GENMASK(10, 8)
	#define SHU3_DQSG_STB_UPDMASK_EN		BIT(11)
	#define SHU3_DQSG_STB_UPDMASKCYC		GENMASK(15, 12)
	#define SHU3_DQSG_DQSINCTL_PRE_SEL		BIT(16)
	#define SHU3_DQSG_SCINTV			GENMASK(25, 20)
#define SHU3_SCINTV					0x000014c8
	#define SHU3_SCINTV_ODTREN			BIT(0)
	#define SHU3_SCINTV_TZQLAT			GENMASK(5, 1)
	#define SHU3_SCINTV_TZQLAT2			GENMASK(10, 6)
	#define SHU3_SCINTV_RDDQC_INTV			GENMASK(12, 11)
	#define SHU3_SCINTV_MRW_INTV			GENMASK(17, 13)
	#define SHU3_SCINTV_DQS2DQ_SHU_PITHRD		GENMASK(23, 18)
	#define SHU3_SCINTV_DQS2DQ_FILT_PITHRD		GENMASK(29, 24)
	#define SHU3_SCINTV_DQSOSCENDIS			BIT(30)
#define SHU3_MISC					0x000014cc
	#define SHU3_MISC_REQQUE_MAXCNT			GENMASK(3, 0)
	#define SHU3_MISC_CKEHCMD			GENMASK(5, 4)
	#define SHU3_MISC_NORMPOP_LEN			GENMASK(10, 8)
	#define SHU3_MISC_PREA_INTV			GENMASK(16, 12)
#define SHU3_DQS2DQ_TX					0x000014d0
	#define SHU3_DQS2DQ_TX_OE2DQ_OFFSET		GENMASK(4, 0)
#define SHU3_HWSET_MR2					0x000014d4
	#define SHU3_HWSET_MR2_HWSET_MR2_MRSMA		GENMASK(12, 0)
	#define SHU3_HWSET_MR2_HWSET_MR2_OP		GENMASK(23, 16)
#define SHU3_HWSET_MR13					0x000014d8
	#define SHU3_HWSET_MR13_HWSET_MR13_MRSMA	GENMASK(12, 0)
	#define SHU3_HWSET_MR13_HWSET_MR13_OP		GENMASK(23, 16)
#define SHU3_HWSET_VRCG					0x000014dc
	#define SHU3_HWSET_VRCG_HWSET_VRCG_MRSMA	GENMASK(12, 0)
	#define SHU3_HWSET_VRCG_HWSET_VRCG_OP		GENMASK(23, 16)
#define SHU3_APHY_TX_PICG_CTRL				0x000014e4
	#define SHU3_APHY_TX_PICG_CTRL_APHYPI_CG_CK_SEL	GENMASK(23, 20)
	#define SHU3_APHY_TX_PICG_CTRL_APHYPI_CG_CK_OPT	BIT(24)
	#define SHU3_APHY_TX_PICG_CTRL_DDRPHY_CLK_DYN_GATING_SEL	GENMASK(30, 27)
	#define SHU3_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_OPT	BIT(31)
#define SHU3RK0_DQSCTL					0x00001600
	#define SHU3RK0_DQSCTL_DQSINCTL			GENMASK(3, 0)
#define SHU3RK0_DQSIEN					0x00001604
	#define SHU3RK0_DQSIEN_R0DQS0IEN		GENMASK(6, 0)
	#define SHU3RK0_DQSIEN_R0DQS1IEN		GENMASK(14, 8)
	#define SHU3RK0_DQSIEN_R0DQS2IEN		GENMASK(22, 16)
	#define SHU3RK0_DQSIEN_R0DQS3IEN		GENMASK(30, 24)
#define SHU3RK0_DQSCAL					0x00001608
	#define SHU3RK0_DQSCAL_R0DQSIENLLMT		GENMASK(6, 0)
	#define SHU3RK0_DQSCAL_R0DQSIENLLMTEN		BIT(7)
	#define SHU3RK0_DQSCAL_R0DQSIENHLMT		GENMASK(14, 8)
	#define SHU3RK0_DQSCAL_R0DQSIENHLMTEN		BIT(15)
#define SHU3RK0_PI					0x0000160c
	#define SHU3RK0_PI_RK0_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU3RK0_PI_RK0_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU3RK0_PI_RK0_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU3RK0_PI_RK0_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU3RK0_DQSOSC					0x00001610
	#define SHU3RK0_DQSOSC_DQSOSC_BASE_RK0		GENMASK(15, 0)
	#define SHU3RK0_DQSOSC_DQSOSC_BASE_RK0_B1	GENMASK(31, 16)
#define SHU3RK0_SELPH_ODTEN0				0x0000161c
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU3RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU3RK0_SELPH_ODTEN1				0x00001620
	#define SHU3RK0_SELPH_ODTEN1_DLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU3RK0_SELPH_ODTEN1_DLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU3RK0_SELPH_DQSG0				0x00001624
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK0_SELPH_DQSG1				0x00001628
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK0_SELPH_DQ0				0x0000162c
	#define SHU3RK0_SELPH_DQ0_TXDLY_DQ0		GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQ0_TXDLY_DQ1		GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQ0_TXDLY_DQ2		GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQ0_TXDLY_DQ3		GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQ0_TXDLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQ0_TXDLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQ0_TXDLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQ0_TXDLY_OEN_DQ3		GENMASK(30, 28)
#define SHU3RK0_SELPH_DQ1				0x00001630
	#define SHU3RK0_SELPH_DQ1_TXDLY_DQM0		GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQ1_TXDLY_DQM1		GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQ1_TXDLY_DQM2		GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQ1_TXDLY_DQM3		GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQ1_TXDLY_OEN_DQM0	GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQ1_TXDLY_OEN_DQM1	GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQ1_TXDLY_OEN_DQM2	GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQ1_TXDLY_OEN_DQM3	GENMASK(30, 28)
#define SHU3RK0_SELPH_DQ2				0x00001634
	#define SHU3RK0_SELPH_DQ2_DLY_DQ0		GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQ2_DLY_DQ1		GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQ2_DLY_DQ2		GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQ2_DLY_DQ3		GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQ2_DLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQ2_DLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQ2_DLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQ2_DLY_OEN_DQ3		GENMASK(30, 28)
#define SHU3RK0_SELPH_DQ3				0x00001638
	#define SHU3RK0_SELPH_DQ3_DLY_DQM0		GENMASK(2, 0)
	#define SHU3RK0_SELPH_DQ3_DLY_DQM1		GENMASK(6, 4)
	#define SHU3RK0_SELPH_DQ3_DLY_DQM2		GENMASK(10, 8)
	#define SHU3RK0_SELPH_DQ3_DLY_DQM3		GENMASK(14, 12)
	#define SHU3RK0_SELPH_DQ3_DLY_OEN_DQM0		GENMASK(18, 16)
	#define SHU3RK0_SELPH_DQ3_DLY_OEN_DQM1		GENMASK(22, 20)
	#define SHU3RK0_SELPH_DQ3_DLY_OEN_DQM2		GENMASK(26, 24)
	#define SHU3RK0_SELPH_DQ3_DLY_OEN_DQM3		GENMASK(30, 28)
#define SHU3RK0_DQS2DQ_CAL1				0x00001640
	#define SHU3RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU3RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU3RK0_DQS2DQ_CAL2				0x00001644
	#define SHU3RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU3RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU3RK0_DQS2DQ_CAL3				0x00001648
	#define SHU3RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0	GENMASK(5, 0)
	#define SHU3RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1	GENMASK(11, 6)
	#define SHU3RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU3RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU3RK0_DQS2DQ_CAL4				0x0000164c
	#define SHU3RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0	GENMASK(5, 0)
	#define SHU3RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1	GENMASK(11, 6)
	#define SHU3RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU3RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU3RK0_DQS2DQ_CAL5				0x00001650
	#define SHU3RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0	GENMASK(10, 0)
	#define SHU3RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1	GENMASK(26, 16)
#define SHU3RK1_DQSCTL					0x00001700
	#define SHU3RK1_DQSCTL_R1DQSINCTL		GENMASK(3, 0)
#define SHU3RK1_DQSIEN					0x00001704
	#define SHU3RK1_DQSIEN_R1DQS0IEN		GENMASK(6, 0)
	#define SHU3RK1_DQSIEN_R1DQS1IEN		GENMASK(14, 8)
	#define SHU3RK1_DQSIEN_R1DQS2IEN		GENMASK(22, 16)
	#define SHU3RK1_DQSIEN_R1DQS3IEN		GENMASK(30, 24)
#define SHU3RK1_DQSCAL					0x00001708
	#define SHU3RK1_DQSCAL_R1DQSIENLLMT		GENMASK(6, 0)
	#define SHU3RK1_DQSCAL_R1DQSIENLLMTEN		BIT(7)
	#define SHU3RK1_DQSCAL_R1DQSIENHLMT		GENMASK(14, 8)
	#define SHU3RK1_DQSCAL_R1DQSIENHLMTEN		BIT(15)
#define SHU3RK1_PI					0x0000170c
	#define SHU3RK1_PI_RK1_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU3RK1_PI_RK1_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU3RK1_PI_RK1_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU3RK1_PI_RK1_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU3RK1_DQSOSC					0x00001710
	#define SHU3RK1_DQSOSC_DQSOSC_BASE_RK1		GENMASK(15, 0)
	#define SHU3RK1_DQSOSC_DQSOSC_BASE_RK1_B1	GENMASK(31, 16)
#define SHU3RK1_SELPH_ODTEN0				0x0000171c
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU3RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU3RK1_SELPH_ODTEN1				0x00001720
	#define SHU3RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU3RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU3RK1_SELPH_DQSG0				0x00001724
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK1_SELPH_DQSG1				0x00001728
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK1_SELPH_DQ0				0x0000172c
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ0	GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ2	GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ3	GENMASK(30, 28)
#define SHU3RK1_SELPH_DQ1				0x00001730
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU3RK1_SELPH_DQ2				0x00001734
	#define SHU3RK1_SELPH_DQ2_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQ2_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQ2_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQ2_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQ2_DLY_R1OEN_DQ0		GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQ2_DLY_R1OEN_DQ1		GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQ2_DLY_R1OEN_DQ2		GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQ2_DLY_R1OEN_DQ3		GENMASK(30, 28)
#define SHU3RK1_SELPH_DQ3				0x00001738
	#define SHU3RK1_SELPH_DQ3_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU3RK1_SELPH_DQ3_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU3RK1_SELPH_DQ3_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU3RK1_SELPH_DQ3_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU3RK1_SELPH_DQ3_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU3RK1_SELPH_DQ3_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU3RK1_SELPH_DQ3_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU3RK1_SELPH_DQ3_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU3RK1_DQS2DQ_CAL1				0x00001740
	#define SHU3RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU3RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU3RK1_DQS2DQ_CAL2				0x00001744
	#define SHU3RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU3RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU3RK1_DQS2DQ_CAL3				0x00001748
	#define SHU3RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0	GENMASK(5, 0)
	#define SHU3RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1	GENMASK(11, 6)
	#define SHU3RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU3RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU3RK1_DQS2DQ_CAL4				0x0000174c
	#define SHU3RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0	GENMASK(5, 0)
	#define SHU3RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1	GENMASK(11, 6)
	#define SHU3RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU3RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU3RK1_DQS2DQ_CAL5				0x00001750
	#define SHU3RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM0	GENMASK(10, 0)
	#define SHU3RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM1	GENMASK(26, 16)
#define SHU3RK2_DQSCTL					0x00001800
	#define SHU3RK2_DQSCTL_R2DQSINCTL		GENMASK(3, 0)
#define SHU3RK2_DQSIEN					0x00001804
	#define SHU3RK2_DQSIEN_R2DQS0IEN		GENMASK(6, 0)
	#define SHU3RK2_DQSIEN_R2DQS1IEN		GENMASK(14, 8)
	#define SHU3RK2_DQSIEN_R2DQS2IEN		GENMASK(22, 16)
	#define SHU3RK2_DQSIEN_R2DQS3IEN		GENMASK(30, 24)
#define SHU3RK2_DQSCAL					0x00001808
	#define SHU3RK2_DQSCAL_R2DQSIENLLMT		GENMASK(6, 0)
	#define SHU3RK2_DQSCAL_R2DQSIENLLMTEN		BIT(7)
	#define SHU3RK2_DQSCAL_R2DQSIENHLMT		GENMASK(14, 8)
	#define SHU3RK2_DQSCAL_R2DQSIENHLMTEN		BIT(15)
#define SHU3RK2_PI					0x0000180c
	#define SHU3RK2_PI_RK2_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU3RK2_PI_RK2_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU3RK2_PI_RK2_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU3RK2_PI_RK2_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU3RK2_DQSOSC					0x00001810
	#define SHU3RK2_DQSOSC_DQSOSC_BASE_RK2		GENMASK(15, 0)
	#define SHU3RK2_DQSOSC_DQSOSC_BASE_RK2_B1	GENMASK(31, 16)
#define SHU3RK2_SELPH_ODTEN0				0x0000181c
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU3RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU3RK2_SELPH_ODTEN1				0x00001820
	#define SHU3RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU3RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU3RK2_SELPH_DQSG0				0x00001824
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK2_SELPH_DQSG1				0x00001828
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU3RK2_SELPH_DQ0				0x0000182c
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ0	GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ2	GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ3	GENMASK(30, 28)
#define SHU3RK2_SELPH_DQ1				0x00001830
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU3RK2_SELPH_DQ2				0x00001834
	#define SHU3RK2_SELPH_DQ2_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQ2_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQ2_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQ2_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQ2_DLY_R2OEN_DQ0		GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQ2_DLY_R2OEN_DQ1		GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQ2_DLY_R2OEN_DQ2		GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQ2_DLY_R2OEN_DQ3		GENMASK(30, 28)
#define SHU3RK2_SELPH_DQ3				0x00001838
	#define SHU3RK2_SELPH_DQ3_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU3RK2_SELPH_DQ3_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU3RK2_SELPH_DQ3_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU3RK2_SELPH_DQ3_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU3RK2_SELPH_DQ3_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU3RK2_SELPH_DQ3_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU3RK2_SELPH_DQ3_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU3RK2_SELPH_DQ3_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU3RK2_DQS2DQ_CAL1				0x00001840
	#define SHU3RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU3RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU3RK2_DQS2DQ_CAL2				0x00001844
	#define SHU3RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU3RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU3RK2_DQS2DQ_CAL3				0x00001848
	#define SHU3RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ0	GENMASK(5, 0)
	#define SHU3RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ1	GENMASK(11, 6)
#define SHU3RK2_DQS2DQ_CAL4				0x0000184c
	#define SHU3RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM0	GENMASK(5, 0)
	#define SHU3RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM1	GENMASK(11, 6)
#define SHU3RK2_DQS2DQ_CAL5				0x00001850
	#define SHU3RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM0	GENMASK(10, 0)
	#define SHU3RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM1	GENMASK(26, 16)
#define SHU3_DQSG_RETRY					0x00001854
	#define SHU3_DQSG_RETRY_R_DQSGRETRY_SW_RESET	BIT(0)
	#define SHU3_DQSG_RETRY_R_DQSG_RETRY_SW_EN	BIT(1)
	#define SHU3_DQSG_RETRY_R_DDR1866_PLUS		BIT(2)
	#define SHU3_DQSG_RETRY_R_RETRY_ONCE		BIT(3)
	#define SHU3_DQSG_RETRY_R_RETRY_3TIMES		BIT(4)
	#define SHU3_DQSG_RETRY_R_RETRY_1RANK		BIT(5)
	#define SHU3_DQSG_RETRY_R_RETRY_SAV_MSK		BIT(6)
	#define SHU3_DQSG_RETRY_R_DM4BYTE		BIT(7)
	#define SHU3_DQSG_RETRY_R_DQSIENLAT		GENMASK(11, 8)
	#define SHU3_DQSG_RETRY_R_STBENCMP_ALLBYTE	BIT(12)
	#define SHU3_DQSG_RETRY_R_XSR_DQSG_RETRY_EN	BIT(13)
	#define SHU3_DQSG_RETRY_R_XSR_RETRY_SPM_MODE	BIT(14)
	#define SHU3_DQSG_RETRY_R_RETRY_CMP_DATA	BIT(15)
	#define SHU3_DQSG_RETRY_R_RETRY_ALE_BLOCK_MASK	BIT(20)
	#define SHU3_DQSG_RETRY_R_RDY_SEL_DLE		BIT(21)
	#define SHU3_DQSG_RETRY_R_RETRY_ROUND_NUM	GENMASK(25, 24)
	#define SHU3_DQSG_RETRY_R_RETRY_RANKSEL_FROM_PHY	BIT(28)
	#define SHU3_DQSG_RETRY_R_RETRY_PA_DSIABLE	BIT(29)
	#define SHU3_DQSG_RETRY_R_RETRY_STBEN_RESET_MSK	BIT(30)
	#define SHU3_DQSG_RETRY_R_RETRY_USE_BURST_MDOE	BIT(31)
#define SHU4_ACTIM0					0x00001a00
	#define SHU4_ACTIM0_TWTR			GENMASK(3, 0)
	#define SHU4_ACTIM0_TWR				GENMASK(12, 8)
	#define SHU4_ACTIM0_TRRD			GENMASK(18, 16)
	#define SHU4_ACTIM0_TRCD			GENMASK(27, 24)
#define SHU4_ACTIM1					0x00001a04
	#define SHU4_ACTIM1_TRPAB			GENMASK(2, 0)
	#define SHU4_ACTIM1_TRP				GENMASK(11, 8)
	#define SHU4_ACTIM1_TRAS			GENMASK(19, 16)
	#define SHU4_ACTIM1_TRC				GENMASK(28, 24)
#define SHU4_ACTIM2					0x00001a08
	#define SHU4_ACTIM2_TXP				GENMASK(2, 0)
	#define SHU4_ACTIM2_TRTP			GENMASK(10, 8)
	#define SHU4_ACTIM2_TR2W			GENMASK(19, 16)
	#define SHU4_ACTIM2_TFAW			GENMASK(28, 24)
#define SHU4_ACTIM3					0x00001a0c
	#define SHU4_ACTIM3_TRFCPB			GENMASK(7, 0)
	#define SHU4_ACTIM3_TRFC			GENMASK(23, 16)
	#define SHU4_ACTIM3_REFCNT			GENMASK(31, 24)
#define SHU4_ACTIM4					0x00001a10
	#define SHU4_ACTIM4_TXREFCNT			GENMASK(9, 0)
	#define SHU4_ACTIM4_REFCNT_FR_CLK		GENMASK(23, 16)
	#define SHU4_ACTIM4_TZQCS			GENMASK(31, 24)
#define SHU4_ACTIM5					0x00001a14
	#define SHU4_ACTIM5_TR2PD			GENMASK(4, 0)
	#define SHU4_ACTIM5_TWTPD			GENMASK(12, 8)
	#define SHU4_ACTIM5_TMRR2W			GENMASK(27, 24)
#define SHU4_ACTIM6					0x00001a18
	#define SHU4_ACTIM6_BGTCCD			GENMASK(1, 0)
	#define SHU4_ACTIM6_BGTWTR			GENMASK(7, 4)
	#define SHU4_ACTIM6_TWRMPR			GENMASK(11, 8)
	#define SHU4_ACTIM6_BGTRRD			GENMASK(14, 12)
#define SHU4_ACTIM_XRT					0x00001a1c
	#define SHU4_ACTIM_XRT_XRTR2R			GENMASK(4, 0)
	#define SHU4_ACTIM_XRT_XRTR2W			GENMASK(11, 8)
	#define SHU4_ACTIM_XRT_XRTW2R			GENMASK(18, 16)
	#define SHU4_ACTIM_XRT_XRTW2W			GENMASK(27, 24)
#define SHU4_AC_TIME_05T				0x00001a20
	#define SHU4_AC_TIME_05T_TRC_05T		BIT(0)
	#define SHU4_AC_TIME_05T_TRFCPB_05T		BIT(1)
	#define SHU4_AC_TIME_05T_TRFC_05T		BIT(2)
	#define SHU4_AC_TIME_05T_TXP_05T		BIT(4)
	#define SHU4_AC_TIME_05T_TRTP_05T		BIT(5)
	#define SHU4_AC_TIME_05T_TRCD_05T		BIT(6)
	#define SHU4_AC_TIME_05T_TRP_05T		BIT(7)
	#define SHU4_AC_TIME_05T_TRPAB_05T		BIT(8)
	#define SHU4_AC_TIME_05T_TRAS_05T		BIT(9)
	#define SHU4_AC_TIME_05T_TWR_M05T		BIT(10)
	#define SHU4_AC_TIME_05T_TRRD_05T		BIT(12)
	#define SHU4_AC_TIME_05T_TFAW_05T		BIT(13)
	#define SHU4_AC_TIME_05T_TR2PD_05T		BIT(15)
	#define SHU4_AC_TIME_05T_TWTPD_M05T		BIT(16)
	#define SHU4_AC_TIME_05T_BGTRRD_05T		BIT(21)
	#define SHU4_AC_TIME_05T_BGTCCD_05T		BIT(22)
	#define SHU4_AC_TIME_05T_BGTWTR_05T		BIT(23)
	#define SHU4_AC_TIME_05T_TR2W_05T		BIT(24)
	#define SHU4_AC_TIME_05T_TWTR_M05T		BIT(25)
	#define SHU4_AC_TIME_05T_XRTR2W_05T		BIT(26)
	#define SHU4_AC_TIME_05T_XRTW2R_M05T		BIT(27)
#define SHU4_AC_DERATING0				0x00001a24
	#define SHU4_AC_DERATING0_ACDERATEEN		BIT(0)
	#define SHU4_AC_DERATING0_TRRD_DERATE		GENMASK(18, 16)
	#define SHU4_AC_DERATING0_TRCD_DERATE		GENMASK(27, 24)
#define SHU4_AC_DERATING1				0x00001a28
	#define SHU4_AC_DERATING1_TRPAB_DERATE		GENMASK(2, 0)
	#define SHU4_AC_DERATING1_TRP_DERATE		GENMASK(11, 8)
	#define SHU4_AC_DERATING1_TRAS_DERATE		GENMASK(19, 16)
	#define SHU4_AC_DERATING1_TRC_DERATE		GENMASK(28, 24)
#define SHU4_AC_DERATING_05T				0x00001a30
	#define SHU4_AC_DERATING_05T_TRC_05T_DERATE	BIT(0)
	#define SHU4_AC_DERATING_05T_TRCD_05T_DERATE	BIT(6)
	#define SHU4_AC_DERATING_05T_TRP_05T_DERATE	BIT(7)
	#define SHU4_AC_DERATING_05T_TRPAB_05T_DERATE	BIT(8)
	#define SHU4_AC_DERATING_05T_TRAS_05T_DERATE	BIT(9)
	#define SHU4_AC_DERATING_05T_TRRD_05T_DERATE	BIT(12)
#define SHU4_CONF0					0x00001a40
	#define SHU4_CONF0_DMPGTIM			GENMASK(5, 0)
	#define SHU4_CONF0_ADVREFEN			BIT(6)
	#define SHU4_CONF0_ADVPREEN			BIT(7)
	#define SHU4_CONF0_TRFCPBIG			BIT(9)
	#define SHU4_CONF0_REFTHD			GENMASK(15, 12)
	#define SHU4_CONF0_REQQUE_DEPTH			GENMASK(19, 16)
	#define SHU4_CONF0_FREQDIV4			BIT(24)
	#define SHU4_CONF0_FDIV2			BIT(25)
	#define SHU4_CONF0_CL2				BIT(27)
	#define SHU4_CONF0_BL2				BIT(28)
	#define SHU4_CONF0_BL4				BIT(29)
	#define SHU4_CONF0_MATYPE			GENMASK(31, 30)
#define SHU4_CONF1					0x00001a44
	#define SHU4_CONF1_DATLAT			GENMASK(4, 0)
	#define SHU4_CONF1_DATLAT_DSEL			GENMASK(12, 8)
	#define SHU4_CONF1_REFBW_FR			GENMASK(25, 16)
	#define SHU4_CONF1_DATLAT_DSEL_PHY		GENMASK(30, 26)
	#define SHU4_CONF1_TREFBWIG			BIT(31)
#define SHU4_CONF2					0x00001a48
	#define SHU4_CONF2_TCMDO1LAT			GENMASK(7, 0)
	#define SHU4_CONF2_FSPCHG_PRDCNT		GENMASK(15, 8)
	#define SHU4_CONF2_DCMDLYREF			GENMASK(18, 16)
	#define SHU4_CONF2_DQCMD			BIT(25)
	#define SHU4_CONF2_DQ16COM1			BIT(26)
	#define SHU4_CONF2_RA15TOCS1			BIT(27)
	#define SHU4_CONF2_WPRE2T			BIT(28)
	#define SHU4_CONF2_FASTWAKE2			BIT(29)
	#define SHU4_CONF2_DAREFEN			BIT(30)
	#define SHU4_CONF2_FASTWAKE			BIT(31)
#define SHU4_CONF3					0x00001a4c
	#define SHU4_CONF3_ZQCSCNT			GENMASK(15, 0)
	#define SHU4_CONF3_REFRCNT			GENMASK(24, 16)
#define SHU4_STBCAL					0x00001a50
	#define SHU4_STBCAL_DMSTBLAT			GENMASK(1, 0)
	#define SHU4_STBCAL_PICGLAT			GENMASK(6, 4)
	#define SHU4_STBCAL_DQSG_MODE			BIT(8)
#define SHU4_DQSOSCTHRD					0x00001a54
	#define SHU4_DQSOSCTHRD_DQSOSCTHRD_INC_RK0	GENMASK(11, 0)
	#define SHU4_DQSOSCTHRD_DQSOSCTHRD_DEC_RK0	GENMASK(23, 12)
	#define SHU4_DQSOSCTHRD_DQSOSCTHRD_INC_RK1_7TO0	GENMASK(31, 24)
#define SHU4_RANKCTL					0x00001a58
	#define SHU4_RANKCTL_RANKINCTL_RXDLY		GENMASK(3, 0)
	#define SHU4_RANKCTL_TXRANKINCTL_TXDLY		GENMASK(11, 8)
	#define SHU4_RANKCTL_TXRANKINCTL		GENMASK(15, 12)
	#define SHU4_RANKCTL_TXRANKINCTL_ROOT		GENMASK(19, 16)
	#define SHU4_RANKCTL_RANKINCTL			GENMASK(23, 20)
	#define SHU4_RANKCTL_RANKINCTL_ROOT1		GENMASK(27, 24)
	#define SHU4_RANKCTL_RANKINCTL_PHY		GENMASK(31, 28)
#define SHU4_CKECTRL					0x00001a5c
	#define SHU4_CKECTRL_CMDCKE			GENMASK(18, 16)
	#define SHU4_CKECTRL_CKEPRD			GENMASK(22, 20)
	#define SHU4_CKECTRL_TCKESRX			GENMASK(25, 24)
	#define SHU4_CKECTRL_SREF_CK_DLY		GENMASK(29, 28)
#define SHU4_ODTCTRL					0x00001a60
	#define SHU4_ODTCTRL_ROEN			BIT(0)
	#define SHU4_ODTCTRL_WOEN			BIT(1)
	#define SHU4_ODTCTRL_RODTEN_SELPH_CG_IG		BIT(2)
	#define SHU4_ODTCTRL_RODTENSTB_SELPH_CG_IG	BIT(3)
	#define SHU4_ODTCTRL_RODT			GENMASK(7, 4)
	#define SHU4_ODTCTRL_TWODT			GENMASK(22, 16)
	#define SHU4_ODTCTRL_FIXRODT			BIT(27)
	#define SHU4_ODTCTRL_RODTE2			BIT(30)
	#define SHU4_ODTCTRL_RODTE			BIT(31)
#define SHU4_IMPCAL1					0x00001a64
	#define SHU4_IMPCAL1_IMPCAL_CHKCYCLE		GENMASK(2, 0)
	#define SHU4_IMPCAL1_IMPDRVP			GENMASK(8, 4)
	#define SHU4_IMPCAL1_IMPDRVN			GENMASK(15, 11)
	#define SHU4_IMPCAL1_IMPCAL_CALEN_CYCLE		GENMASK(19, 17)
	#define SHU4_IMPCAL1_IMPCALCNT			GENMASK(27, 20)
	#define SHU4_IMPCAL1_IMPCAL_CALICNT		GENMASK(31, 28)
#define SHU4_DQSOSC_PRD					0x00001a68
	#define SHU4_DQSOSC_PRD_DQSOSC_PRDCNT		GENMASK(9, 0)
	#define SHU4_DQSOSC_PRD_DQSOSCTHRD_INC_RK1_11TO8	GENMASK(19, 16)
	#define SHU4_DQSOSC_PRD_DQSOSCTHRD_DEC_RK1	GENMASK(31, 20)
#define SHU4_DQSOSCR					0x00001a6c
	#define SHU4_DQSOSCR_DQSOSCRCNT			GENMASK(7, 0)
	#define SHU4_DQSOSCR_DQSOSC_DELTA		GENMASK(31, 16)
#define SHU4_DQSOSCR2					0x00001a70
	#define SHU4_DQSOSCR2_DQSOSCENCNT		GENMASK(15, 0)
	#define SHU4_DQSOSCR2_DQSOSC_ADV_SEL		GENMASK(17, 16)
	#define SHU4_DQSOSCR2_DQSOSC_DRS_ADV_SEL	GENMASK(19, 18)
#define SHU4_RODTENSTB					0x00001a74
	#define SHU4_RODTENSTB_RODTEN_MCK_MODESEL	BIT(0)
	#define SHU4_RODTENSTB_RODTEN_P1_ENABLE		BIT(1)
	#define SHU4_RODTENSTB_RODTENSTB_OFFSET		GENMASK(7, 2)
	#define SHU4_RODTENSTB_RODTENSTB_EXT		GENMASK(23, 8)
	#define SHU4_RODTENSTB_RODTENSTB_4BYTE_EN	BIT(31)
#define SHU4_PIPE					0x00001a78
	#define SHU4_PIPE_PHYRXPIPE1			BIT(0)
	#define SHU4_PIPE_PHYRXPIPE2			BIT(1)
	#define SHU4_PIPE_PHYRXPIPE3			BIT(2)
	#define SHU4_PIPE_PHYRXRDSLPIPE1		BIT(4)
	#define SHU4_PIPE_PHYRXRDSLPIPE2		BIT(5)
	#define SHU4_PIPE_PHYRXRDSLPIPE3		BIT(6)
	#define SHU4_PIPE_PHYPIPE1EN			BIT(8)
	#define SHU4_PIPE_PHYPIPE2EN			BIT(9)
	#define SHU4_PIPE_PHYPIPE3EN			BIT(10)
	#define SHU4_PIPE_DLE_LAST_EXTEND3		BIT(26)
	#define SHU4_PIPE_READ_START_EXTEND3		BIT(27)
	#define SHU4_PIPE_DLE_LAST_EXTEND2		BIT(28)
	#define SHU4_PIPE_READ_START_EXTEND2		BIT(29)
	#define SHU4_PIPE_DLE_LAST_EXTEND1		BIT(30)
	#define SHU4_PIPE_READ_START_EXTEND1		BIT(31)
#define SHU4_TEST1					0x00001a7c
	#define SHU4_TEST1_LATNORMPOP			GENMASK(12, 8)
	#define SHU4_TEST1_DQSICALBLCOK_CNT		GENMASK(22, 20)
	#define SHU4_TEST1_DQSICALI_NEW			BIT(23)
#define SHU4_SELPH_CA1					0x00001a80
	#define SHU4_SELPH_CA1_TXDLY_CS			GENMASK(2, 0)
	#define SHU4_SELPH_CA1_TXDLY_CKE		GENMASK(6, 4)
	#define SHU4_SELPH_CA1_TXDLY_ODT		GENMASK(10, 8)
	#define SHU4_SELPH_CA1_TXDLY_RESET		GENMASK(14, 12)
	#define SHU4_SELPH_CA1_TXDLY_WE			GENMASK(18, 16)
	#define SHU4_SELPH_CA1_TXDLY_CAS		GENMASK(22, 20)
	#define SHU4_SELPH_CA1_TXDLY_RAS		GENMASK(26, 24)
	#define SHU4_SELPH_CA1_TXDLY_CS1		GENMASK(30, 28)
#define SHU4_SELPH_CA2					0x00001a84
	#define SHU4_SELPH_CA2_TXDLY_BA0		GENMASK(2, 0)
	#define SHU4_SELPH_CA2_TXDLY_BA1		GENMASK(6, 4)
	#define SHU4_SELPH_CA2_TXDLY_BA2		GENMASK(10, 8)
	#define SHU4_SELPH_CA2_TXDLY_CMD		GENMASK(20, 16)
	#define SHU4_SELPH_CA2_TXDLY_CKE1		GENMASK(26, 24)
#define SHU4_SELPH_CA3					0x00001a88
	#define SHU4_SELPH_CA3_TXDLY_RA0		GENMASK(2, 0)
	#define SHU4_SELPH_CA3_TXDLY_RA1		GENMASK(6, 4)
	#define SHU4_SELPH_CA3_TXDLY_RA2		GENMASK(10, 8)
	#define SHU4_SELPH_CA3_TXDLY_RA3		GENMASK(14, 12)
	#define SHU4_SELPH_CA3_TXDLY_RA4		GENMASK(18, 16)
	#define SHU4_SELPH_CA3_TXDLY_RA5		GENMASK(22, 20)
	#define SHU4_SELPH_CA3_TXDLY_RA6		GENMASK(26, 24)
	#define SHU4_SELPH_CA3_TXDLY_RA7		GENMASK(30, 28)
#define SHU4_SELPH_CA4					0x00001a8c
	#define SHU4_SELPH_CA4_TXDLY_RA8		GENMASK(2, 0)
	#define SHU4_SELPH_CA4_TXDLY_RA9		GENMASK(6, 4)
	#define SHU4_SELPH_CA4_TXDLY_RA10		GENMASK(10, 8)
	#define SHU4_SELPH_CA4_TXDLY_RA11		GENMASK(14, 12)
	#define SHU4_SELPH_CA4_TXDLY_RA12		GENMASK(18, 16)
	#define SHU4_SELPH_CA4_TXDLY_RA13		GENMASK(22, 20)
	#define SHU4_SELPH_CA4_TXDLY_RA14		GENMASK(26, 24)
	#define SHU4_SELPH_CA4_TXDLY_RA15		GENMASK(30, 28)
#define SHU4_SELPH_CA5					0x00001a90
	#define SHU4_SELPH_CA5_DLY_CS			GENMASK(2, 0)
	#define SHU4_SELPH_CA5_DLY_CKE			GENMASK(6, 4)
	#define SHU4_SELPH_CA5_DLY_ODT			GENMASK(10, 8)
	#define SHU4_SELPH_CA5_DLY_RESET		GENMASK(14, 12)
	#define SHU4_SELPH_CA5_DLY_WE			GENMASK(18, 16)
	#define SHU4_SELPH_CA5_DLY_CAS			GENMASK(22, 20)
	#define SHU4_SELPH_CA5_DLY_RAS			GENMASK(26, 24)
	#define SHU4_SELPH_CA5_DLY_CS1			GENMASK(30, 28)
#define SHU4_SELPH_CA6					0x00001a94
	#define SHU4_SELPH_CA6_DLY_BA0			GENMASK(2, 0)
	#define SHU4_SELPH_CA6_DLY_BA1			GENMASK(6, 4)
	#define SHU4_SELPH_CA6_DLY_BA2			GENMASK(10, 8)
	#define SHU4_SELPH_CA6_DLY_CKE1			GENMASK(26, 24)
#define SHU4_SELPH_CA7					0x00001a98
	#define SHU4_SELPH_CA7_DLY_RA0			GENMASK(2, 0)
	#define SHU4_SELPH_CA7_DLY_RA1			GENMASK(6, 4)
	#define SHU4_SELPH_CA7_DLY_RA2			GENMASK(10, 8)
	#define SHU4_SELPH_CA7_DLY_RA3			GENMASK(14, 12)
	#define SHU4_SELPH_CA7_DLY_RA4			GENMASK(18, 16)
	#define SHU4_SELPH_CA7_DLY_RA5			GENMASK(22, 20)
	#define SHU4_SELPH_CA7_DLY_RA6			GENMASK(26, 24)
	#define SHU4_SELPH_CA7_DLY_RA7			GENMASK(30, 28)
#define SHU4_SELPH_CA8					0x00001a9c
	#define SHU4_SELPH_CA8_DLY_RA8			GENMASK(2, 0)
	#define SHU4_SELPH_CA8_DLY_RA9			GENMASK(6, 4)
	#define SHU4_SELPH_CA8_DLY_RA10			GENMASK(10, 8)
	#define SHU4_SELPH_CA8_DLY_RA11			GENMASK(14, 12)
	#define SHU4_SELPH_CA8_DLY_RA12			GENMASK(18, 16)
	#define SHU4_SELPH_CA8_DLY_RA13			GENMASK(22, 20)
	#define SHU4_SELPH_CA8_DLY_RA14			GENMASK(26, 24)
	#define SHU4_SELPH_CA8_DLY_RA15			GENMASK(30, 28)
#define SHU4_SELPH_DQS0					0x00001aa0
	#define SHU4_SELPH_DQS0_TXDLY_DQS0		GENMASK(2, 0)
	#define SHU4_SELPH_DQS0_TXDLY_DQS1		GENMASK(6, 4)
	#define SHU4_SELPH_DQS0_TXDLY_DQS2		GENMASK(10, 8)
	#define SHU4_SELPH_DQS0_TXDLY_DQS3		GENMASK(14, 12)
	#define SHU4_SELPH_DQS0_TXDLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU4_SELPH_DQS0_TXDLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU4_SELPH_DQS0_TXDLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU4_SELPH_DQS0_TXDLY_OEN_DQS3		GENMASK(30, 28)
#define SHU4_SELPH_DQS1					0x00001aa4
	#define SHU4_SELPH_DQS1_DLY_DQS0		GENMASK(2, 0)
	#define SHU4_SELPH_DQS1_DLY_DQS1		GENMASK(6, 4)
	#define SHU4_SELPH_DQS1_DLY_DQS2		GENMASK(10, 8)
	#define SHU4_SELPH_DQS1_DLY_DQS3		GENMASK(14, 12)
	#define SHU4_SELPH_DQS1_DLY_OEN_DQS0		GENMASK(18, 16)
	#define SHU4_SELPH_DQS1_DLY_OEN_DQS1		GENMASK(22, 20)
	#define SHU4_SELPH_DQS1_DLY_OEN_DQS2		GENMASK(26, 24)
	#define SHU4_SELPH_DQS1_DLY_OEN_DQS3		GENMASK(30, 28)
#define SHU4_DRVING1					0x00001aa8
	#define SHU4_DRVING1_DQDRVN2			GENMASK(4, 0)
	#define SHU4_DRVING1_DQDRVP2			GENMASK(9, 5)
	#define SHU4_DRVING1_DQSDRVN1			GENMASK(14, 10)
	#define SHU4_DRVING1_DQSDRVP1			GENMASK(19, 15)
	#define SHU4_DRVING1_DQSDRVN2			GENMASK(24, 20)
	#define SHU4_DRVING1_DQSDRVP2			GENMASK(29, 25)
	#define SHU4_DRVING1_DIS_IMP_ODTN_TRACK		BIT(30)
	#define SHU4_DRVING1_DIS_IMPCAL_HW		BIT(31)
#define SHU4_DRVING2					0x00001aac
	#define SHU4_DRVING2_CMDDRVN1			GENMASK(4, 0)
	#define SHU4_DRVING2_CMDDRVP1			GENMASK(9, 5)
	#define SHU4_DRVING2_CMDDRVN2			GENMASK(14, 10)
	#define SHU4_DRVING2_CMDDRVP2			GENMASK(19, 15)
	#define SHU4_DRVING2_DQDRVN1			GENMASK(24, 20)
	#define SHU4_DRVING2_DQDRVP1			GENMASK(29, 25)
	#define SHU4_DRVING2_DIS_IMPCAL_ODT_EN		BIT(31)
#define SHU4_DRVING3					0x00001ab0
	#define SHU4_DRVING3_DQODTN2			GENMASK(4, 0)
	#define SHU4_DRVING3_DQODTP2			GENMASK(9, 5)
	#define SHU4_DRVING3_DQSODTN			GENMASK(14, 10)
	#define SHU4_DRVING3_DQSODTP			GENMASK(19, 15)
	#define SHU4_DRVING3_DQSODTN2			GENMASK(24, 20)
	#define SHU4_DRVING3_DQSODTP2			GENMASK(29, 25)
#define SHU4_DRVING4					0x00001ab4
	#define SHU4_DRVING4_CMDODTN1			GENMASK(4, 0)
	#define SHU4_DRVING4_CMDODTP1			GENMASK(9, 5)
	#define SHU4_DRVING4_CMDODTN2			GENMASK(14, 10)
	#define SHU4_DRVING4_CMDODTP2			GENMASK(19, 15)
	#define SHU4_DRVING4_DQODTN1			GENMASK(24, 20)
	#define SHU4_DRVING4_DQODTP1			GENMASK(29, 25)
#define SHU4_DRVING5					0x00001ab8
	#define SHU4_DRVING5_DQCODTN2			GENMASK(4, 0)
	#define SHU4_DRVING5_DQCODTP2			GENMASK(9, 5)
	#define SHU4_DRVING5_DQCDRVN1			GENMASK(14, 10)
	#define SHU4_DRVING5_DQCDRVP1			GENMASK(19, 15)
	#define SHU4_DRVING5_DQCDRVN2			GENMASK(24, 20)
	#define SHU4_DRVING5_DQCDRVP2			GENMASK(29, 25)
#define SHU4_DRVING6					0x00001abc
	#define SHU4_DRVING6_DQCODTN1			GENMASK(24, 20)
	#define SHU4_DRVING6_DQCODTP1			GENMASK(29, 25)
#define SHU4_WODT					0x00001ac0
	#define SHU4_WODT_DISWODT			GENMASK(2, 0)
	#define SHU4_WODT_WODTFIX			BIT(3)
	#define SHU4_WODT_WODTFIXOFF			BIT(4)
	#define SHU4_WODT_DISWODTE			BIT(5)
	#define SHU4_WODT_DISWODTE2			BIT(6)
	#define SHU4_WODT_WODTPDEN			BIT(7)
	#define SHU4_WODT_DQOE_CNT			GENMASK(10, 8)
	#define SHU4_WODT_DQOE_OPT			BIT(11)
	#define SHU4_WODT_TXUPD_SEL			GENMASK(13, 12)
	#define SHU4_WODT_TXUPD_W2R_SEL			GENMASK(16, 14)
	#define SHU4_WODT_DBIWR				BIT(29)
	#define SHU4_WODT_TWPSTEXT			BIT(30)
	#define SHU4_WODT_WPST2T			BIT(31)
#define SHU4_DQSG					0x00001ac4
	#define SHU4_DQSG_DLLFRZRFCOPT			GENMASK(1, 0)
	#define SHU4_DQSG_DLLFRZWROPT			GENMASK(5, 4)
	#define SHU4_DQSG_R_RSTBCNT_LATCH_OPT		GENMASK(10, 8)
	#define SHU4_DQSG_STB_UPDMASK_EN		BIT(11)
	#define SHU4_DQSG_STB_UPDMASKCYC		GENMASK(15, 12)
	#define SHU4_DQSG_DQSINCTL_PRE_SEL		BIT(16)
	#define SHU4_DQSG_SCINTV			GENMASK(25, 20)
#define SHU4_SCINTV					0x00001ac8
	#define SHU4_SCINTV_ODTREN			BIT(0)
	#define SHU4_SCINTV_TZQLAT			GENMASK(5, 1)
	#define SHU4_SCINTV_TZQLAT2			GENMASK(10, 6)
	#define SHU4_SCINTV_RDDQC_INTV			GENMASK(12, 11)
	#define SHU4_SCINTV_MRW_INTV			GENMASK(17, 13)
	#define SHU4_SCINTV_DQS2DQ_SHU_PITHRD		GENMASK(23, 18)
	#define SHU4_SCINTV_DQS2DQ_FILT_PITHRD		GENMASK(29, 24)
	#define SHU4_SCINTV_DQSOSCENDIS			BIT(30)
#define SHU4_MISC					0x00001acc
	#define SHU4_MISC_REQQUE_MAXCNT			GENMASK(3, 0)
	#define SHU4_MISC_CKEHCMD			GENMASK(5, 4)
	#define SHU4_MISC_NORMPOP_LEN			GENMASK(10, 8)
	#define SHU4_MISC_PREA_INTV			GENMASK(16, 12)
#define SHU4_DQS2DQ_TX					0x00001ad0
	#define SHU4_DQS2DQ_TX_OE2DQ_OFFSET		GENMASK(4, 0)
#define SHU4_HWSET_MR2					0x00001ad4
	#define SHU4_HWSET_MR2_HWSET_MR2_MRSMA		GENMASK(12, 0)
	#define SHU4_HWSET_MR2_HWSET_MR2_OP		GENMASK(23, 16)
#define SHU4_HWSET_MR13					0x00001ad8
	#define SHU4_HWSET_MR13_HWSET_MR13_MRSMA	GENMASK(12, 0)
	#define SHU4_HWSET_MR13_HWSET_MR13_OP		GENMASK(23, 16)
#define SHU4_HWSET_VRCG					0x00001adc
	#define SHU4_HWSET_VRCG_HWSET_VRCG_MRSMA	GENMASK(12, 0)
	#define SHU4_HWSET_VRCG_HWSET_VRCG_OP		GENMASK(23, 16)
#define SHU4_APHY_TX_PICG_CTRL				0x00001ae4
	#define SHU4_APHY_TX_PICG_CTRL_APHYPI_CG_CK_SEL	GENMASK(23, 20)
	#define SHU4_APHY_TX_PICG_CTRL_APHYPI_CG_CK_OPT	BIT(24)
	#define SHU4_APHY_TX_PICG_CTRL_DDRPHY_CLK_DYN_GATING_SEL	GENMASK(30, 27)
	#define SHU4_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_OPT	BIT(31)
#define SHU4RK0_DQSCTL					0x00001c00
	#define SHU4RK0_DQSCTL_DQSINCTL			GENMASK(3, 0)
#define SHU4RK0_DQSIEN					0x00001c04
	#define SHU4RK0_DQSIEN_R0DQS0IEN		GENMASK(6, 0)
	#define SHU4RK0_DQSIEN_R0DQS1IEN		GENMASK(14, 8)
	#define SHU4RK0_DQSIEN_R0DQS2IEN		GENMASK(22, 16)
	#define SHU4RK0_DQSIEN_R0DQS3IEN		GENMASK(30, 24)
#define SHU4RK0_DQSCAL					0x00001c08
	#define SHU4RK0_DQSCAL_R0DQSIENLLMT		GENMASK(6, 0)
	#define SHU4RK0_DQSCAL_R0DQSIENLLMTEN		BIT(7)
	#define SHU4RK0_DQSCAL_R0DQSIENHLMT		GENMASK(14, 8)
	#define SHU4RK0_DQSCAL_R0DQSIENHLMTEN		BIT(15)
#define SHU4RK0_PI					0x00001c0c
	#define SHU4RK0_PI_RK0_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU4RK0_PI_RK0_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU4RK0_PI_RK0_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU4RK0_PI_RK0_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU4RK0_DQSOSC					0x00001c10
	#define SHU4RK0_DQSOSC_DQSOSC_BASE_RK0		GENMASK(15, 0)
	#define SHU4RK0_DQSOSC_DQSOSC_BASE_RK0_B1	GENMASK(31, 16)
#define SHU4RK0_SELPH_ODTEN0				0x00001c1c
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU4RK0_SELPH_ODTEN0_TXDLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU4RK0_SELPH_ODTEN1				0x00001c20
	#define SHU4RK0_SELPH_ODTEN1_DLY_B0_RODTEN	GENMASK(2, 0)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B0_RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B1_RODTEN	GENMASK(10, 8)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B1_RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B2_RODTEN	GENMASK(18, 16)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B2_RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B3_RODTEN	GENMASK(26, 24)
	#define SHU4RK0_SELPH_ODTEN1_DLY_B3_RODTEN_P1	GENMASK(30, 28)
#define SHU4RK0_SELPH_DQSG0				0x00001c24
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQSG0_TX_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK0_SELPH_DQSG1				0x00001c28
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQSG1_REG_DLY_DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK0_SELPH_DQ0				0x00001c2c
	#define SHU4RK0_SELPH_DQ0_TXDLY_DQ0		GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQ0_TXDLY_DQ1		GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQ0_TXDLY_DQ2		GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQ0_TXDLY_DQ3		GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQ0_TXDLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQ0_TXDLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQ0_TXDLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQ0_TXDLY_OEN_DQ3		GENMASK(30, 28)
#define SHU4RK0_SELPH_DQ1				0x00001c30
	#define SHU4RK0_SELPH_DQ1_TXDLY_DQM0		GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQ1_TXDLY_DQM1		GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQ1_TXDLY_DQM2		GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQ1_TXDLY_DQM3		GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQ1_TXDLY_OEN_DQM0	GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQ1_TXDLY_OEN_DQM1	GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQ1_TXDLY_OEN_DQM2	GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQ1_TXDLY_OEN_DQM3	GENMASK(30, 28)
#define SHU4RK0_SELPH_DQ2				0x00001c34
	#define SHU4RK0_SELPH_DQ2_DLY_DQ0		GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQ2_DLY_DQ1		GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQ2_DLY_DQ2		GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQ2_DLY_DQ3		GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQ2_DLY_OEN_DQ0		GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQ2_DLY_OEN_DQ1		GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQ2_DLY_OEN_DQ2		GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQ2_DLY_OEN_DQ3		GENMASK(30, 28)
#define SHU4RK0_SELPH_DQ3				0x00001c38
	#define SHU4RK0_SELPH_DQ3_DLY_DQM0		GENMASK(2, 0)
	#define SHU4RK0_SELPH_DQ3_DLY_DQM1		GENMASK(6, 4)
	#define SHU4RK0_SELPH_DQ3_DLY_DQM2		GENMASK(10, 8)
	#define SHU4RK0_SELPH_DQ3_DLY_DQM3		GENMASK(14, 12)
	#define SHU4RK0_SELPH_DQ3_DLY_OEN_DQM0		GENMASK(18, 16)
	#define SHU4RK0_SELPH_DQ3_DLY_OEN_DQM1		GENMASK(22, 20)
	#define SHU4RK0_SELPH_DQ3_DLY_OEN_DQM2		GENMASK(26, 24)
	#define SHU4RK0_SELPH_DQ3_DLY_OEN_DQM3		GENMASK(30, 28)
#define SHU4RK0_DQS2DQ_CAL1				0x00001c40
	#define SHU4RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU4RK0_DQS2DQ_CAL1_BOOT_ORIG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU4RK0_DQS2DQ_CAL2				0x00001c44
	#define SHU4RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ0	GENMASK(10, 0)
	#define SHU4RK0_DQS2DQ_CAL2_BOOT_TARG_UI_RK0_DQ1	GENMASK(26, 16)
#define SHU4RK0_DQS2DQ_CAL3				0x00001c48
	#define SHU4RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0	GENMASK(5, 0)
	#define SHU4RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1	GENMASK(11, 6)
	#define SHU4RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU4RK0_DQS2DQ_CAL3_BOOT_TARG_UI_RK0_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU4RK0_DQS2DQ_CAL4				0x00001c4c
	#define SHU4RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0	GENMASK(5, 0)
	#define SHU4RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1	GENMASK(11, 6)
	#define SHU4RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU4RK0_DQS2DQ_CAL4_BOOT_TARG_UI_RK0_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU4RK0_DQS2DQ_CAL5				0x00001c50
	#define SHU4RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM0	GENMASK(10, 0)
	#define SHU4RK0_DQS2DQ_CAL5_BOOT_TARG_UI_RK0_DQM1	GENMASK(26, 16)
#define SHU4RK1_DQSCTL					0x00001d00
	#define SHU4RK1_DQSCTL_R1DQSINCTL		GENMASK(3, 0)
#define SHU4RK1_DQSIEN					0x00001d04
	#define SHU4RK1_DQSIEN_R1DQS0IEN		GENMASK(6, 0)
	#define SHU4RK1_DQSIEN_R1DQS1IEN		GENMASK(14, 8)
	#define SHU4RK1_DQSIEN_R1DQS2IEN		GENMASK(22, 16)
	#define SHU4RK1_DQSIEN_R1DQS3IEN		GENMASK(30, 24)
#define SHU4RK1_DQSCAL					0x00001d08
	#define SHU4RK1_DQSCAL_R1DQSIENLLMT		GENMASK(6, 0)
	#define SHU4RK1_DQSCAL_R1DQSIENLLMTEN		BIT(7)
	#define SHU4RK1_DQSCAL_R1DQSIENHLMT		GENMASK(14, 8)
	#define SHU4RK1_DQSCAL_R1DQSIENHLMTEN		BIT(15)
#define SHU4RK1_PI					0x00001d0c
	#define SHU4RK1_PI_RK1_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU4RK1_PI_RK1_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU4RK1_PI_RK1_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU4RK1_PI_RK1_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU4RK1_DQSOSC					0x00001d10
	#define SHU4RK1_DQSOSC_DQSOSC_BASE_RK1		GENMASK(15, 0)
	#define SHU4RK1_DQSOSC_DQSOSC_BASE_RK1_B1	GENMASK(31, 16)
#define SHU4RK1_SELPH_ODTEN0				0x00001d1c
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU4RK1_SELPH_ODTEN0_TXDLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU4RK1_SELPH_ODTEN1				0x00001d20
	#define SHU4RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN	GENMASK(2, 0)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B0_R1RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN	GENMASK(10, 8)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B1_R1RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN	GENMASK(18, 16)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B2_R1RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN	GENMASK(26, 24)
	#define SHU4RK1_SELPH_ODTEN1_DLY_B3_R1RODTEN_P1	GENMASK(30, 28)
#define SHU4RK1_SELPH_DQSG0				0x00001d24
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQSG0_TX_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK1_SELPH_DQSG1				0x00001d28
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQSG1_REG_DLY_R1DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK1_SELPH_DQ0				0x00001d2c
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ0	GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ2	GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQ0_TX_DLY_R1OEN_DQ3	GENMASK(30, 28)
#define SHU4RK1_SELPH_DQ1				0x00001d30
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQ1_TX_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU4RK1_SELPH_DQ2				0x00001d34
	#define SHU4RK1_SELPH_DQ2_DLY_R1DQ0		GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQ2_DLY_R1DQ1		GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQ2_DLY_R1DQ2		GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQ2_DLY_R1DQ3		GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQ2_DLY_R1OEN_DQ0		GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQ2_DLY_R1OEN_DQ1		GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQ2_DLY_R1OEN_DQ2		GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQ2_DLY_R1OEN_DQ3		GENMASK(30, 28)
#define SHU4RK1_SELPH_DQ3				0x00001d38
	#define SHU4RK1_SELPH_DQ3_DLY_R1DQM0		GENMASK(2, 0)
	#define SHU4RK1_SELPH_DQ3_DLY_R1DQM1		GENMASK(6, 4)
	#define SHU4RK1_SELPH_DQ3_DLY_R1DQM2		GENMASK(10, 8)
	#define SHU4RK1_SELPH_DQ3_DLY_R1DQM3		GENMASK(14, 12)
	#define SHU4RK1_SELPH_DQ3_DLY_R1OEN_DQM0	GENMASK(18, 16)
	#define SHU4RK1_SELPH_DQ3_DLY_R1OEN_DQM1	GENMASK(22, 20)
	#define SHU4RK1_SELPH_DQ3_DLY_R1OEN_DQM2	GENMASK(26, 24)
	#define SHU4RK1_SELPH_DQ3_DLY_R1OEN_DQM3	GENMASK(30, 28)
#define SHU4RK1_DQS2DQ_CAL1				0x00001d40
	#define SHU4RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU4RK1_DQS2DQ_CAL1_BOOT_ORIG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU4RK1_DQS2DQ_CAL2				0x00001d44
	#define SHU4RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ0	GENMASK(10, 0)
	#define SHU4RK1_DQS2DQ_CAL2_BOOT_TARG_UI_RK1_DQ1	GENMASK(26, 16)
#define SHU4RK1_DQS2DQ_CAL3				0x00001d48
	#define SHU4RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0	GENMASK(5, 0)
	#define SHU4RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1	GENMASK(11, 6)
	#define SHU4RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ0_B4TO0	GENMASK(16, 12)
	#define SHU4RK1_DQS2DQ_CAL3_BOOT_TARG_UI_RK1_OEN_DQ1_B4TO0	GENMASK(21, 17)
#define SHU4RK1_DQS2DQ_CAL4				0x00001d4c
	#define SHU4RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0	GENMASK(5, 0)
	#define SHU4RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1	GENMASK(11, 6)
	#define SHU4RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM0_B4TO0	GENMASK(16, 12)
	#define SHU4RK1_DQS2DQ_CAL4_BOOT_TARG_UI_RK1_OEN_DQM1_B4TO0	GENMASK(21, 17)
#define SHU4RK1_DQS2DQ_CAL5				0x00001d50
	#define SHU4RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM0	GENMASK(10, 0)
	#define SHU4RK1_DQS2DQ_CAL5_BOOT_TARG_UI_RK1_DQM1	GENMASK(26, 16)
#define SHU4RK2_DQSCTL					0x00001e00
	#define SHU4RK2_DQSCTL_R2DQSINCTL		GENMASK(3, 0)
#define SHU4RK2_DQSIEN					0x00001e04
	#define SHU4RK2_DQSIEN_R2DQS0IEN		GENMASK(6, 0)
	#define SHU4RK2_DQSIEN_R2DQS1IEN		GENMASK(14, 8)
	#define SHU4RK2_DQSIEN_R2DQS2IEN		GENMASK(22, 16)
	#define SHU4RK2_DQSIEN_R2DQS3IEN		GENMASK(30, 24)
#define SHU4RK2_DQSCAL					0x00001e08
	#define SHU4RK2_DQSCAL_R2DQSIENLLMT		GENMASK(6, 0)
	#define SHU4RK2_DQSCAL_R2DQSIENLLMTEN		BIT(7)
	#define SHU4RK2_DQSCAL_R2DQSIENHLMT		GENMASK(14, 8)
	#define SHU4RK2_DQSCAL_R2DQSIENHLMTEN		BIT(15)
#define SHU4RK2_PI					0x00001e0c
	#define SHU4RK2_PI_RK2_ARPI_DQ_B1		GENMASK(5, 0)
	#define SHU4RK2_PI_RK2_ARPI_DQ_B0		GENMASK(13, 8)
	#define SHU4RK2_PI_RK2_ARPI_DQM_B1		GENMASK(21, 16)
	#define SHU4RK2_PI_RK2_ARPI_DQM_B0		GENMASK(29, 24)
#define SHU4RK2_DQSOSC					0x00001e10
	#define SHU4RK2_DQSOSC_DQSOSC_BASE_RK2		GENMASK(15, 0)
	#define SHU4RK2_DQSOSC_DQSOSC_BASE_RK2_B1	GENMASK(31, 16)
#define SHU4RK2_SELPH_ODTEN0				0x00001e1c
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU4RK2_SELPH_ODTEN0_TXDLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU4RK2_SELPH_ODTEN1				0x00001e20
	#define SHU4RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN	GENMASK(2, 0)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B0_R2RODTEN_P1	GENMASK(6, 4)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN	GENMASK(10, 8)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B1_R2RODTEN_P1	GENMASK(14, 12)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN	GENMASK(18, 16)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B2_R2RODTEN_P1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN	GENMASK(26, 24)
	#define SHU4RK2_SELPH_ODTEN1_DLY_B3_R2RODTEN_P1	GENMASK(30, 28)
#define SHU4RK2_SELPH_DQSG0				0x00001e24
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQSG0_TX_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK2_SELPH_DQSG1				0x00001e28
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED	GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS0_GATED_P1	GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED	GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS1_GATED_P1	GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED	GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS2_GATED_P1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED	GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQSG1_REG_DLY_R2DQS3_GATED_P1	GENMASK(30, 28)
#define SHU4RK2_SELPH_DQ0				0x00001e2c
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ0	GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ2	GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQ0_TX_DLY_R2OEN_DQ3	GENMASK(30, 28)
#define SHU4RK2_SELPH_DQ1				0x00001e30
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQ1_TX_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU4RK2_SELPH_DQ2				0x00001e34
	#define SHU4RK2_SELPH_DQ2_DLY_R2DQ0		GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQ2_DLY_R2DQ1		GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQ2_DLY_R2DQ2		GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQ2_DLY_R2DQ3		GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQ2_DLY_R2OEN_DQ0		GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQ2_DLY_R2OEN_DQ1		GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQ2_DLY_R2OEN_DQ2		GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQ2_DLY_R2OEN_DQ3		GENMASK(30, 28)
#define SHU4RK2_SELPH_DQ3				0x00001e38
	#define SHU4RK2_SELPH_DQ3_DLY_R2DQM0		GENMASK(2, 0)
	#define SHU4RK2_SELPH_DQ3_DLY_R2DQM1		GENMASK(6, 4)
	#define SHU4RK2_SELPH_DQ3_DLY_R2DQM2		GENMASK(10, 8)
	#define SHU4RK2_SELPH_DQ3_DLY_R2DQM3		GENMASK(14, 12)
	#define SHU4RK2_SELPH_DQ3_DLY_R2OEN_DQM0	GENMASK(18, 16)
	#define SHU4RK2_SELPH_DQ3_DLY_R2OEN_DQM1	GENMASK(22, 20)
	#define SHU4RK2_SELPH_DQ3_DLY_R2OEN_DQM2	GENMASK(26, 24)
	#define SHU4RK2_SELPH_DQ3_DLY_R2OEN_DQM3	GENMASK(30, 28)
#define SHU4RK2_DQS2DQ_CAL1				0x00001e40
	#define SHU4RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU4RK2_DQS2DQ_CAL1_BOOT_ORIG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU4RK2_DQS2DQ_CAL2				0x00001e44
	#define SHU4RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ0	GENMASK(10, 0)
	#define SHU4RK2_DQS2DQ_CAL2_BOOT_TARG_UI_RK2_DQ1	GENMASK(26, 16)
#define SHU4RK2_DQS2DQ_CAL3				0x00001e48
	#define SHU4RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ0	GENMASK(5, 0)
	#define SHU4RK2_DQS2DQ_CAL3_BOOT_TARG_UI_RK2_OEN_DQ1	GENMASK(11, 6)
#define SHU4RK2_DQS2DQ_CAL4				0x00001e4c
	#define SHU4RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM0	GENMASK(5, 0)
	#define SHU4RK2_DQS2DQ_CAL4_BOOT_TARG_UI_RK2_OEN_DQM1	GENMASK(11, 6)
#define SHU4RK2_DQS2DQ_CAL5				0x00001e50
	#define SHU4RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM0	GENMASK(10, 0)
	#define SHU4RK2_DQS2DQ_CAL5_BOOT_TARG_UI_RK2_DQM1	GENMASK(26, 16)
#define SHU4_DQSG_RETRY					0x00001e54
	#define SHU4_DQSG_RETRY_R_DQSGRETRY_SW_RESET	BIT(0)
	#define SHU4_DQSG_RETRY_R_DQSG_RETRY_SW_EN	BIT(1)
	#define SHU4_DQSG_RETRY_R_DDR1866_PLUS		BIT(2)
	#define SHU4_DQSG_RETRY_R_RETRY_ONCE		BIT(3)
	#define SHU4_DQSG_RETRY_R_RETRY_3TIMES		BIT(4)
	#define SHU4_DQSG_RETRY_R_RETRY_1RANK		BIT(5)
	#define SHU4_DQSG_RETRY_R_RETRY_SAV_MSK		BIT(6)
	#define SHU4_DQSG_RETRY_R_DM4BYTE		BIT(7)
	#define SHU4_DQSG_RETRY_R_DQSIENLAT		GENMASK(11, 8)
	#define SHU4_DQSG_RETRY_R_STBENCMP_ALLBYTE	BIT(12)
	#define SHU4_DQSG_RETRY_R_XSR_DQSG_RETRY_EN	BIT(13)
	#define SHU4_DQSG_RETRY_R_XSR_RETRY_SPM_MODE	BIT(14)
	#define SHU4_DQSG_RETRY_R_RETRY_CMP_DATA	BIT(15)
	#define SHU4_DQSG_RETRY_R_RETRY_ALE_BLOCK_MASK	BIT(20)
	#define SHU4_DQSG_RETRY_R_RDY_SEL_DLE		BIT(21)
	#define SHU4_DQSG_RETRY_R_RETRY_ROUND_NUM	GENMASK(25, 24)
	#define SHU4_DQSG_RETRY_R_RETRY_RANKSEL_FROM_PHY	BIT(28)
	#define SHU4_DQSG_RETRY_R_RETRY_PA_DSIABLE	BIT(29)
	#define SHU4_DQSG_RETRY_R_RETRY_STBEN_RESET_MSK	BIT(30)
	#define SHU4_DQSG_RETRY_R_RETRY_USE_BURST_MDOE	BIT(31)

#endif /*__DRAMC_CH0_REG_H__*/
