/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2019. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */
#ifndef __TIA_H__
#define __TIA_H__

/******************* SW ENV define ******************/
#define TIA_SUPPORT
#define TIA_DEBUG_LOG

/******************* SW ENV header define ***********/
#include <typedefs.h>
#include <mt6890.h>
#include <pal_log.h>
#include <upmu_hw.h>

/******************* External API *******************/
extern void tia_init(void);

/******************* Debug Marco ********************/
#define TIATAG		"[TIA] "
#ifdef TIA_DEBUG_LOG
	#define TIA_LOG(fmt, arg...)   pal_log_info(TIATAG fmt, ##arg)
#else
	#define TIA_LOG(fmt, arg...)
#endif
#define TIA_CRI(fmt, arg...)   pal_log_info(TIATAG fmt, ##arg)
#define TIA_ERR(fmt, arg...)   pal_log_err(TIATAG fmt, ##arg)

/******************* TIA2.0 Register ****************/
#define TIA2_MODE_CTRL			(TIA_BASE+0x028)
#define TIA2_MD_RC_CTRL			(TIA_BASE+0x02C)
#define TIA2_GPS_RC_CTRL		(TIA_BASE+0x030)
#define TIA2_AP_RC_CTRL			(TIA_BASE+0x034)
#define TIA2_ADC_INI_DLY		(TIA_BASE+0x038)
#define TIA2_RC_30K_DLY			(TIA_BASE+0x03C)
#define TIA2_RC_100K_DLY		(TIA_BASE+0x040)
#define TIA2_RC_400K_DLY		(TIA_BASE+0x044)
#define TIA2_ADC15_CON_DLY		(TIA_BASE+0x048)
#define TIA2_ADC12_30K_CON_DLY		(TIA_BASE+0x04C)
#define TIA2_ADC12_100K_CON_DLY		(TIA_BASE+0x050)
#define TIA2_ADC12_400K_CON_DLY0	(TIA_BASE+0x054)
#define TIA2_ADC12_400K_CON_DLY1	(TIA_BASE+0x058)
#define TIA2_ADC12_CON_SRCLK		(TIA_BASE+0x05C)
#define TIA2_ADC_SET_ADDR		(TIA_BASE+0x060)
#define TIA2_TSX_30K_CMD		(TIA_BASE+0x064)
#define TIA2_TSX_100K_CMD		(TIA_BASE+0x068)
#define TIA2_TSX_400K_CMD		(TIA_BASE+0x06C)
#define TIA2_ADC15_DCXO_CMD		(TIA_BASE+0x070)
#define TIA2_ADC12_DCXO_CMD		(TIA_BASE+0x074)
#define TIA2_T0_30K_CMD			(TIA_BASE+0x078)
#define TIA2_T1_30K_CMD			(TIA_BASE+0x07C)
#define TIA2_T2_30K_CMD			(TIA_BASE+0x080)
#define TIA2_T3_30K_CMD			(TIA_BASE+0x084)
#define TIA2_T0_100K_CMD		(TIA_BASE+0x088)
#define TIA2_T1_100K_CMD		(TIA_BASE+0x08C)
#define TIA2_T2_100K_CMD		(TIA_BASE+0x090)
#define TIA2_T3_100K_CMD		(TIA_BASE+0x094)
#define TIA2_T0_400K_CMD		(TIA_BASE+0x098)
#define TIA2_T1_400K_CMD		(TIA_BASE+0x09C)
#define TIA2_T2_400K_CMD		(TIA_BASE+0x0A0)
#define TIA2_T3_400K_CMD		(TIA_BASE+0x0A4)
#define TIA2_ADC15_TRIG_ADDR		(TIA_BASE+0x0A8)
#define TIA2_ADC12_TRIG_ADDR		(TIA_BASE+0x0AC)
#define TIA2_ADC15_TRIG_CMD		(TIA_BASE+0x0B0)
#define TIA2_ADC12_TRIG_CMD0		(TIA_BASE+0x0B4)
#define TIA2_ADC12_TRIG_CMD1		(TIA_BASE+0x0B8)
#define TIA2_ADC15_READ_ADDR		(TIA_BASE+0x0BC)
#define TIA2_ADC12_READ_ADDR0		(TIA_BASE+0x0C0)
#define TIA2_ADC12_READ_ADDR1		(TIA_BASE+0x0C4)
#define TIA2_READY_CLR			(TIA_BASE+0x0C8)
#define TIA2_MD_TSX_DATA		(TIA_BASE+0x0CC)
#define TIA2_GPS_TSX_DATA		(TIA_BASE+0x0D0)
#define TIA2_T0_DATA			(TIA_BASE+0x0D4)
#define TIA2_T1_DATA			(TIA_BASE+0x0D8)
#define TIA2_T2_DATA			(TIA_BASE+0x0DC)
#define TIA2_T3_DATA			(TIA_BASE+0x0E0)
#define TIA2_DCXO_DATA			(TIA_BASE+0x0E4)
#define TIA2_SPMI_CMD			(TIA_BASE+0x0E8)
#define TIA2_DEBUG			(TIA_BASE+0x0F0)

#endif /*__TIA_H__*/
