/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 * 
 * MediaTek Inc. (C) 2010. All rights reserved.
 * 
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef __MTK_TIMER_H__
#define __MTK_TIMER_H__

#include <typedefs.h>

#define GPT_IRQEN       ((P_U32)(GPT_BASE))
#define GPT_IRQSTA      ((P_U32)(GPT_BASE+0x04))
#define GPT_IRQACK      ((P_U32)(GPT_BASE+0x08))

#define GPT4_CON            ((P_U32)(GPT_BASE+0x0040))
#define GPT4_CLK            ((P_U32)(GPT_BASE+0x0044))
#define GPT4_DAT            ((P_U32)(GPT_BASE+0x0048))

#define GPT5_CON            ((P_U32)(GPT_BASE+0x50))
#define GPT5_CLK            ((P_U32)(GPT_BASE+0x54))
#define GPT5_COUNT          ((P_U32)(GPT_BASE+0x58))
#define GPT5_COMPARE        ((P_U32)(GPT_BASE+0x5C))

#define GPT_MODE_ONE_SHOT (0x00 << 4)
#define GPT_MODE_REPEAT   (0x01 << 4)
#define GPT_MODE_KEEP_GO  (0x02 << 4)
#define GPT_MODE_FREERUN  (0x03 << 4)

#define GPT_CLEAR       2

#define GPT_ENABLE      1
#define GPT_DISABLE     0

#define GPT_CLK_SYS     (0x0 << 4)
#define GPT_CLK_RTC     (0x1 << 4)

#define GPT_DIV_BY_1        0
#define GPT_DIV_BY_2        1

#define SYSTIMER_CNTWACR            ((P_U32)(SYSTIMER_BASE+0x0010))
#define SYSTIMER_CNTRACR            ((P_U32)(SYSTIMER_BASE+0x0014))

#define GPT_MAX_TICK_CNT   ((U32)0xFFFFFFFF)

#if CFG_FPGA_PLATFORM
// 12MHz setting
#define GPT4_CLK_SETTING    (GPT_CLK_SYS|GPT_DIV_BY_1)
#define GPT4_MAX_US_TIMEOUT ((U32)357770775)    // 0xFFFFFFFF * 83.3ns / 1000
#define GPT4_MAX_MS_TIMEOUT ((U32)357770)       // 0xFFFFFFFF * 83.3ns / 1000000
#define GPT4_1US_TICK       ((U32)12)           //    1000 / 83.3ns = 12.004
#define GPT4_1MS_TICK       ((U32)12004)        // 1000000 / 83.3ns = 12004.801
// 12MHz: 1us = 12.004 ticks
#define TIME_TO_TICK_US(us) ((us)*GPT4_1US_TICK + ((us)*4 + (1000-1))/1000)
// 12MHz: 1ms = 12004.801 ticks
#define TIME_TO_TICK_MS(ms) ((ms)*GPT4_1MS_TICK + ((ms)*801 + (1000-1))/1000)
#else // !CFG_FPGA_PLATFORM
// 13MHz setting
#define GPT4_CLK_SETTING    (GPT_CLK_SYS)
#define GPT4_MAX_US_TIMEOUT ((U32)330382100)    // 0xFFFFFFFF /13d
#define GPT4_MAX_MS_TIMEOUT ((U32)330382)       // 0xFFFFFFFF /13000d

#define GPT4_1US_TICK       ((U32)13)           //    1000 / 76.92ns = 13.000
#define GPT4_1MS_TICK       ((U32)13000)        // 1000000 / 76.92ns = 13000.520
// 13MHz: 1us = 13.000 ticks
#define TIME_TO_TICK_US(us) ((us)*GPT4_1US_TICK + ((us)*0 + (1000-1))/1000)
// 13MHz: 1ms = 13000.520 ticks
#define TIME_TO_TICK_MS(ms) ((ms)*GPT4_1MS_TICK + ((ms)*520 + (1000-1))/1000)

#endif

#define MS_TO_US            1000
#define CFG_HZ              100
#define MAX_REG_MS          GPT4_MAX_MS_TIMEOUT

#define GPT_SET_BITS(BS,REG)       ((*(volatile U32*)(REG)) |= (U32)(BS))
#define GPT_CLR_BITS(BS,REG)       ((*(volatile U32*)(REG)) &= ~((U32)(BS)))


extern void gpt_busy_wait_us(U32 timeout_us);
extern void gpt_busy_wait_ms(U32 timeout_ms);

extern ulong get_timer(ulong base);
extern void mdelay(unsigned long msec);
extern void udelay(unsigned long usec);
extern void mtk_timer_init(void);
extern void mtk_timer_post_init(void);

U32 gpt4_get_current_tick (void);
bool gpt4_timeout_tick (U32 start_tick, U32 timeout_tick);
U32 gpt4_time2tick_us (U32 time_us);
U32 get_time_ms(void);
U32 get_time_us(void);
#endif
