/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include "typedefs.h"
#include "platform.h"

#include "pll.h"
#include "spm_mtcmos.h"

#define CLKMGR_BRINGUP		1
#define FMETER_CHK		0

//test

unsigned int mt_get_abist_freq(unsigned int ID)
{
    int output = 0, i = 0;
    unsigned int temp, clk26cali_0, clk_dbg_cfg, clk_misc_cfg_0, clk26cali_1;

    clk_dbg_cfg = DRV_Reg32(CLK_DBG_CFG);
    DRV_WriteReg32(CLK_DBG_CFG, (clk_dbg_cfg & 0xFFC0FFFC)|(ID << 16)); //sel abist_cksw and enable freq meter sel abist
    clk_misc_cfg_0 = DRV_Reg32(CLK_MISC_CFG_0);
    DRV_WriteReg32(CLK_MISC_CFG_0, (clk_misc_cfg_0 & 0x00FFFFFF) | (3 << 24)); // select divider, div 4
    clk26cali_0 = DRV_Reg32(CLK26CALI_0);
    clk26cali_1 = DRV_Reg32(CLK26CALI_1);
    DRV_WriteReg32(CLK26CALI_0, 0x1000);
    DRV_WriteReg32(CLK26CALI_0, 0x1010);

    /* wait frequency meter finish */
    while (DRV_Reg32(CLK26CALI_0) & 0x10)
    {
        udelay(10);
        i++;
        if(i > 10000)
        	break;
    }

    temp = DRV_Reg32(CLK26CALI_1) & 0xFFFF;

    output = ((temp * 26000) ) / 1024; // Khz

    DRV_WriteReg32(CLK_DBG_CFG, clk_dbg_cfg);
    DRV_WriteReg32(CLK_MISC_CFG_0, clk_misc_cfg_0);
    DRV_WriteReg32(CLK26CALI_0, clk26cali_0);
    DRV_WriteReg32(CLK26CALI_1, clk26cali_1);

    //print("abist meter[%d] = %d Khz\n", ID, output * 4);
    return output * 4;
}

static unsigned int mt_get_ckgen_freq(unsigned int ID)
{
    int output = 0, i = 0;
    unsigned int temp, clk26cali_0, clk_dbg_cfg, clk_misc_cfg_0, clk26cali_1;

    clk_dbg_cfg = DRV_Reg32(CLK_DBG_CFG);
    DRV_WriteReg32(CLK_DBG_CFG, (clk_dbg_cfg & 0xFFFFC0FC)|(ID << 8)|(0x1)); //sel ckgen_cksw[22] and enable freq meter sel ckgen[21:16], 01:hd_faxi_ck

    clk_misc_cfg_0 = DRV_Reg32(CLK_MISC_CFG_0);
    DRV_WriteReg32(CLK_MISC_CFG_0, (clk_misc_cfg_0 & 0x00FFFFFF)); // select divider?dvt set zero
    clk26cali_0 = DRV_Reg32(CLK26CALI_0);
    clk26cali_1 = DRV_Reg32(CLK26CALI_1);
    DRV_WriteReg32(CLK26CALI_0, 0x1000);
    DRV_WriteReg32(CLK26CALI_0, 0x1010);

    /* wait frequency meter finish */
    while (DRV_Reg32(CLK26CALI_0) & 0x10)
    {
        udelay(10);
		i++;
        if(i > 10000)
        	break;
    }

    temp = DRV_Reg32(CLK26CALI_1) & 0xFFFF;

    output = ((temp * 26000) ) / 1024; // Khz

    DRV_WriteReg32(CLK_DBG_CFG, clk_dbg_cfg);
    DRV_WriteReg32(CLK_MISC_CFG_0, clk_misc_cfg_0);
    DRV_WriteReg32(CLK26CALI_0, clk26cali_0);
    DRV_WriteReg32(CLK26CALI_1, clk26cali_1);

    //print("ckgen meter[%d] = %d Khz\n", ID, output);
    return output;

}

#if 0
const int ckgen_needCheck_array[] =
{
/* 00 */	0,
/* 01 - 05*/	1, 1, 1, 1, 1,
/* 06 - 10*/	1, 1, 1, 1, 1,
/* 11 - 15*/	1, 1, 1, 1, 1,
/* 16 - 20*/	1, 1, 1, 1, 1,
/* 21 - 25*/	1, 1, 1, 1, 1,
/* 26 - 30*/	1, 1, 1, 1, 1,
/* 31 - 35*/	1, 1, 1, 1, 1,
/* 36 - 40*/	1, 1, 1, 1, 1,
/* 41 - 45*/	1, 1, 1, 1, 1,
/* 46 - 50*/	1, 1, 1, 1, 1,
/* 51 - 55*/	1, 1, 0, 0, 0,
/* 56 - 60*/	0, 0, 0, 0, 0,
/* 61 - 63*/	0, 0, 0
};

const char *ckgen_golden_array[] =
{
/* 00	  */	0,
/* 01 - 05*/	/*axi */136500,	78000, 156000, 178285.7, /*mfg ref */218400,
/* 06 - 10*/	218400, 52000, 273000, 416000, 208000,
/* 11 - 15*/	54600, 136500, 22579.2, 24576, 180633.6,
/* 16 - 20*/	196608, 26000, 273000, /*pwrmcu */218000, 124800,
/* 21 - 25*/	130000, 124800, 124800, 124800, 136500,
/* 26 - 30*/	/*dpmaif */273000, 78000, 26000 , 26000, 26000,
/* 31 - 35*/	182000, 26000, /*gcpu */273000, /*spi */104000, /*spis */312000,
/* 36 - 40*/	/*ecc */136000, 182000, 124800, /*netsys */78000, /*medsys */78000,
/* 41 - 45*/	26000, 26000, /*eip97 */218000, 312500, 250000,
/* 46 - 50*/	62400, 50000, 500000, /*netsys med*/104000, /*netsys wed*/182000,
/* 51 - 55*/	/*netsys 2x*/124000, 325000, 78000, 0, 0,
/* 56 - 60*/	0, 0, 0, 0, 0,
/* 61 - 63*/	0, 0, 0
};

const int abist_needCheck_array[] =
{
/* 00	  */	0,
/* 01 - 05*/	0, 0, 1, 1, 0,
/* 06 - 10*/	0, 0, 0, 0, 0,
/* 11 - 15*/	1, 1, 1, 1, 1,
/* 16 - 20*/	1, 1, 0, 0, 0,
/* 21 - 25*/	0, 0, 0, 0, 1,
/* 26 - 30*/	0, 1, 1, 0, 1,
/* 31 - 35*/	1, 0, 0, 0, 0,
/* 36 - 40*/	0, 0, 1, 1, 0,
/* 41 - 45*/	0, 0, 0, 0, 0,
/* 46 - 50*/	0, 0, 0, 0, 0,
/* 51 - 55*/	0, 0, 0, 0, 0,
/* 56 - 60*/	0, 0, 0, 0, 0,
/* 61 - 63*/	0, 0, 0,
};

/* if needCheck_array[x]=1 but golden_array[x]=0: means we only want to read the value*/
const int abist_golden_array[] =
{
/* 00     */	0,
/* 01 - 05*/	0, 0, /*apll1 */180600, /*apll2 */196600, 0,
/* 06 - 10*/	0, 0, 0, 0, 0,
/* 11 - 15*/	/*ll */2000000, /*ccci */16000000, /*NET1 */2500000, /*NET2 */800000, /*wedmcu */416000,
/* 16 - 20*/	/*medmcu */580000, /*sgmii */325000, 0, 0, 0,
/* 21 - 25*/	0, 0, 0, 0, /*mainpll */2184000,
/* 26 - 30*/	0, /*mfgpll */1150000, /*mmpll */2550000, 0, /*mpll */208000,
/* 31 - 35*/	/*msdc */416000, 0, 0, 0, 0,
/* 36 - 40*/	0, 0, /*ulpsoc */260000, /*univpll */2496000, 0,
/* 41 - 45*/	0, 0, 0, 0, 0,
/* 46 - 50*/	0, 0, 0, 0, 0,
/* 51 - 55*/	0, 0, 0, 0, 0,
/* 56 - 60*/	0, 0, 0, 0, 0,
/* 61 - 63*/	0, 0, 0,
};


#define _FREQ_SCAN_
#define _RESULT_COMPARE_
#define Range 1000
#define CKGEN_CHANNEL_CNT 64
#define ABIST_CHANNEL_CNT 64
unsigned int ret_feq_store[CKGEN_CHANNEL_CNT+ABIST_CHANNEL_CNT];
unsigned int ret_feq_total=0;
unsigned int pll_chk_is_fail = 0;

void mt_print_pll_chcek_result(void)
{
	unsigned int temp,clk_misc_cfg_0,ret_feq,reg_temp;
	unsigned int isFail = 0;
	unsigned int total = 0;

	#ifdef _FREQ_SCAN_

	print("==============================\n");
	print("==      Parsing Start       ==\n");
	print("==============================\n");
	for(temp=0; temp<CKGEN_CHANNEL_CNT; temp++)
	{
	        print("CKGEN(%d) ", temp);
		if(!ckgen_needCheck_array[temp])
		{
		        print("skip:%d\n",temp);
		 	continue;
		}
		ret_feq = ret_feq_store[total];
		total++;
		print("%d",ret_feq);
#ifdef _RESULT_COMPARE_
		if((ret_feq < (ckgen_golden_array[temp] - Range)) || (ret_feq > (ckgen_golden_array[temp] + Range)))
		{
			print(" : ERROR");
			isFail = 1;
		} else {
			print(" : OK");
		}
#endif
		printf("\n");

	}

	//abist
	for(temp=0; temp<ABIST_CHANNEL_CNT; temp++)
	{
		print("ABIST(%d) ", temp);
		if(!abist_needCheck_array[temp])
		{
		        print("skip:%d\n",temp);
		 	continue;
		}
		ret_feq = ret_feq_store[total];
		total++;
		print("%d", ret_feq);
#ifdef _RESULT_COMPARE_
		if(abist_golden_array[temp] > 0)
		{
			if((ret_feq < (abist_golden_array[temp] - Range)) || (ret_feq > (abist_golden_array[temp] + Range)))
			{
				print(" : ERROR");
				isFail = 1;
			} else {
				print(" : OK");
			}
		}
#endif
		printf("\n");
	}

#ifdef _RESULT_COMPARE_
	if(isFail)
	{
		print("Post Check PLL/CLK Freq Fail..!!!\n");
		//while(1);
	}
	else
	{
		print("Pass\n");
	}
#endif
#endif //_FREQ_SCAN_

}
#endif	/* #if 0 */

void mt_pll_post_init(void)
{
        unsigned int temp,clk_misc_cfg_0,ret_feq,reg_temp;
        unsigned int isFail = 0;

#ifdef _FREQ_SCAN_
        print("Pll post init start...\n");
        print("==============================\n");
        print("==      Parsing Start       ==\n");
        print("==============================\n");
        for(temp=0; temp < CKGEN_CHANNEL_CNT; temp++)
        {
                if(!ckgen_needCheck_array[temp])
                        continue;
                else
                        print("%d:",temp);
                ret_feq = 0;
                ret_feq = mt_get_ckgen_freq(temp);
                ret_feq_store[ret_feq_total] = ret_feq;
                ret_feq_total++;
                print("%s:", ckgen_array[temp]);
                print("%d\n",ret_feq);
        }
        //abist
        for(temp=0; temp < ABIST_CHANNEL_CNT; temp++)
        {
                if(!abist_needCheck_array[temp])
                        continue;
                else
                        print("%d:",temp);
                ret_feq = mt_get_abist_freq(temp);
                ret_feq_store[ret_feq_total] = ret_feq;
                ret_feq_total++;
                print("%s:", abist_array[temp]);
                print("%d\n", ret_feq);
        }

        print("Pll post init Done!\n");
#endif // _FREQ_SCAN_
}

void mt_set_topck_default(void)
{
	DRV_WriteReg32(CLK_CFG_0_CLR, 0xfffffffe);
	DRV_WriteReg32(CLK_CFG_1_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_2_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_3_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_4_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_5_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_6_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_7_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_8_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_9_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_10_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_11_CLR, 0xffffffff);
	DRV_WriteReg32(CLK_CFG_12_CLR, 0xffffffff);
	//DRV_WriteReg32(CLK_CFG_13_CLR, 0xffffffff);
	//DRV_WriteReg32(CLK_CFG_14_CLR, 0xffffffff);
	//DRV_WriteReg32(CLK_CFG_15_CLR, 0xffffffff);
	//DRV_WriteReg32(CLK_CFG_16_CLR, 0xffffffff);

	DRV_WriteReg32(CLK_CFG_UPDATE, 0xFFFFFFFE);	//update all clocks except "axi"
	DRV_WriteReg32(CLK_CFG_UPDATE1, 0xFFFFFFFF);
	//DRV_WriteReg32(CLK_CFG_UPDATE2, 0xFFFFFFFF);
}

void mt_pll_init(void)
{
    int ret = 0;
    unsigned int temp;
    unsigned int temp1; // FIX BY HK
    unsigned int rdata = 0;
    unsigned int wdata = 0;
    int i;

    print("Pll init start...\n");

    //step 1
    DRV_WriteReg32(AP_PLL_CON0,  0x7FD);		// (CLKSQ_EN)

    //step 2
    gpt_busy_wait_us(100);

    //step 3
    temp = DRV_Reg32(AP_PLL_CON0);
    DRV_WriteReg32(AP_PLL_CON0, temp | 0xFFF);	//[1]=1 (CLKSQ_LPF_EN)
/*
    //step 3.1 to reduce PLL current. 07/19
    temp = DRV_Reg32(AP_PLLGP1_CON1);
    DRV_WriteReg32(AP_PLLGP1_CON1, temp & 0xFFF9FFFF);
    temp = DRV_Reg32(AP_PLLGP1_CON1);
    DRV_WriteReg32(AP_PLLGP1_CON1, temp | 0x00020000);

    //step 3.2 to reduce PLL current. 07/19
    temp = DRV_Reg32(AP_PLLGP2_CON1);
    DRV_WriteReg32(AP_PLLGP2_CON1, temp & 0xFFFFF9FF);
    temp = DRV_Reg32(AP_PLLGP2_CON1);
    DRV_WriteReg32(AP_PLLGP2_CON1, temp | 0x00000200);
*/

    //step 4
    temp = DRV_Reg32(MFGPLL_CON4);
    DRV_WriteReg32(MFGPLL_CON4, temp | 0x1);	//[0]=1 (MFGPLL_PWR_ON)

    //step 5
    //temp = DRV_Reg32(MPLL_CON4);
    //DRV_WriteReg32(MPLL_CON4, temp | 0x1);

    //step 6
    temp = DRV_Reg32(MAINPLL_CON4);
    DRV_WriteReg32(MAINPLL_CON4, temp | 0x1);

    //step 7
    temp = DRV_Reg32(UNIVPLL_CON4);
    DRV_WriteReg32(UNIVPLL_CON4, temp | 0x1);

    //step 8
    temp = DRV_Reg32(MSDCPLL_CON3);
    DRV_WriteReg32(MSDCPLL_CON4, temp | 0x1);

    //step 9
    temp = DRV_Reg32(MMPLL_CON3);
    DRV_WriteReg32(MMPLL_CON4, temp | 0x1);

    //step 10
    temp = DRV_Reg32(SGMIIPLL_CON4);
    DRV_WriteReg32(SGMIIPLL_CON4, temp | 0x1);
/*
    //step 11
    temp = DRV_Reg32(ADSPPLL_CON3);
    DRV_WriteReg32(ADSPPLL_CON3, temp | 0x1);
*/
    //step 12
    temp = DRV_Reg32(APLL1_CON5);
    DRV_WriteReg32(APLL1_CON5, temp | 0x1);

    //step 13
    temp = DRV_Reg32(APLL2_CON5);
    DRV_WriteReg32(APLL2_CON5, temp | 0x1);

    //step 14 new
    temp = DRV_Reg32(NET1PLL_CON4);
    DRV_WriteReg32(NET1PLL_CON4, temp | 0x1);

    //step 14 new
    temp = DRV_Reg32(NET2PLL_CON4);
    DRV_WriteReg32(NET2PLL_CON4, temp | 0x1);

    //step 14 New
    temp = DRV_Reg32(WEDMCUPLL_CON4);
    DRV_WriteReg32(WEDMCUPLL_CON4, temp | 0x1);

    //step 14 new
    temp = DRV_Reg32(MEDMCUPLL_CON4);
    DRV_WriteReg32(MEDMCUPLL_CON4, temp | 0x1);

    //step 15
    temp = DRV_Reg32(ARMPLL_LL_CON4);
    DRV_WriteReg32(ARMPLL_LL_CON4, temp | 0x1);
/*
    //step 16
    temp = DRV_Reg32(ARMPLL_BL0_CON3);
    DRV_WriteReg32(ARMPLL_BL0_CON3, temp | 0x1);

    //step 17
    temp = DRV_Reg32(ARMPLL_BL1_CON3);
    DRV_WriteReg32(ARMPLL_BL1_CON3, temp | 0x1);

    //step 18
    temp = DRV_Reg32(ARMPLL_BL2_CON3);
    DRV_WriteReg32(ARMPLL_BL2_CON3, temp | 0x1);

    //step 19
    temp = DRV_Reg32(ARMPLL_BL3_CON3);
    DRV_WriteReg32(ARMPLL_BL3_CON3, temp | 0x1);
*/
    //step 20
    temp = DRV_Reg32(CCIPLL_CON4);
    DRV_WriteReg32(CCIPLL_CON4, temp | 0x1);

    //step 21
    gpt_busy_wait_us(30);

    /******************
     * xPLL ISO Disable
     *******************/
    //step 22
    temp = DRV_Reg32(MFGPLL_CON4);
    DRV_WriteReg32(MFGPLL_CON4, temp & 0xFFFFFFFD);

    //step 23
    //temp = DRV_Reg32(MPLL_CON4);
    //DRV_WriteReg32(MPLL_CON4, temp & 0xFFFFFFFD);

    //step 24
    temp = DRV_Reg32(MAINPLL_CON4);
    DRV_WriteReg32(MAINPLL_CON4, temp & 0xFFFFFFFD);

    //step 25
    temp = DRV_Reg32(UNIVPLL_CON4);
    DRV_WriteReg32(UNIVPLL_CON4, temp & 0xFFFFFFFD);

    //step 26
    temp = DRV_Reg32(MSDCPLL_CON4);
    DRV_WriteReg32(MSDCPLL_CON4, temp & 0xFFFFFFFD);

    //step 27
    temp = DRV_Reg32(MMPLL_CON4);
    DRV_WriteReg32(MMPLL_CON4, temp & 0xFFFFFFFD);

    //step 28
    temp = DRV_Reg32(SGMIIPLL_CON4);
    DRV_WriteReg32(SGMIIPLL_CON4, temp & 0xFFFFFFFD);

    //step 28 new
    temp = DRV_Reg32(NET1PLL_CON4);
    DRV_WriteReg32(NET1PLL_CON4, temp & 0xFFFFFFFD);

    //step 28 new
    temp = DRV_Reg32(NET2PLL_CON4);
    DRV_WriteReg32(NET2PLL_CON4, temp & 0xFFFFFFFD);

    //step 28 New
    temp = DRV_Reg32(WEDMCUPLL_CON4);
    DRV_WriteReg32(WEDMCUPLL_CON4, temp & 0xFFFFFFFD);

    //step 28 new
    temp = DRV_Reg32(MEDMCUPLL_CON4);
    DRV_WriteReg32(MEDMCUPLL_CON4, temp & 0xFFFFFFFD);
/*
    //step 29
    temp = DRV_Reg32(ADSPPLL_CON3);
    DRV_WriteReg32(ADSPPLL_CON3, temp & 0xFFFFFFFD);

    //step 30
    temp = DRV_Reg32(APUPLL_CON3);
    DRV_WriteReg32(APUPLL_CON3, temp & 0xFFFFFFFD);
*/
    //step 31
    temp = DRV_Reg32(APLL1_CON5);
    DRV_WriteReg32(APLL1_CON5, temp & 0xFFFFFFFD);

    //step 32
    temp = DRV_Reg32(APLL2_CON5);
    DRV_WriteReg32(APLL2_CON5, temp & 0xFFFFFFFD);

    //step 33
    temp = DRV_Reg32(ARMPLL_LL_CON4);
    DRV_WriteReg32(ARMPLL_LL_CON4, temp & 0xFFFFFFFD);
/*
    //step 34
    temp = DRV_Reg32(ARMPLL_BL0_CON3);
    DRV_WriteReg32(ARMPLL_BL0_CON3, temp & 0xFFFFFFFD);
    //step 35
    temp = DRV_Reg32(ARMPLL_BL1_CON3);
    DRV_WriteReg32(ARMPLL_BL1_CON3, temp & 0xFFFFFFFD);
    //step 36
    temp = DRV_Reg32(ARMPLL_BL2_CON3);
    DRV_WriteReg32(ARMPLL_BL2_CON3, temp & 0xFFFFFFFD);
    //step 37
    temp = DRV_Reg32(ARMPLL_BL3_CON3);
    DRV_WriteReg32(ARMPLL_BL3_CON3, temp & 0xFFFFFFFD);
*/
    //step 38
    temp = DRV_Reg32(CCIPLL_CON4);
    DRV_WriteReg32(CCIPLL_CON4, temp & 0xFFFFFFFD);

    //step 39
    gpt_busy_wait_us(1);

    //step 40
    temp = DRV_Reg32(APLL1_CON0);
    DRV_WriteReg32(APLL1_CON0, temp | 0x00000000);

    //step 41
    temp = DRV_Reg32(APLL2_CON0);
    DRV_WriteReg32(APLL2_CON0, temp | 0x00000000);

    /********************
     * xPLL Frequency Set
     *********************/
    //step 42
    //DRV_WriteReg32(MFGPLL_CON1, 0x840F6276); //100 Mhz
    //DRV_WriteReg32(MFGPLL_CON1, 0x84140000); //130 Mhz (prevent model report <=125M)
    //DRV_WriteReg32(MFGPLL_CON1, 0x831AEC4E);	//350 Mhz
    DRV_WriteReg32(MFGPLL_CON2, 0x830F6276);	//200 Mhz

    //step 43
    //DRV_WriteReg32(MPLL_CON2, 0x84200000); //208 Mhz

    //step 44
    DRV_WriteReg32(MAINPLL_CON2, 0x80150000); //2184 MHz

    //step 45
    DRV_WriteReg32(UNIVPLL_CON2, 0x80180000); //2496 MHz

    //step 46
    //DRV_WriteReg32(MSDCPLL_CON1, 0x83200000); //416 MHz
    DRV_WriteReg32(MSDCPLL_CON2, 0x831D89D8); //384 MHz

    //step 47
    //DRV_WriteReg32(MMPLL_CON2, 0x801A713B); // 2750 Mhz
    DRV_WriteReg32(MMPLL_CON2, 0x801BB140); // 2880 Mhz

    //step 48
    DRV_WriteReg32(SGMIIPLL_CON2, 0x83190000); //325Mhz

    //step 48 new
    DRV_WriteReg32(NET1PLL_CON2, 0x801809D8);  //2500Mhz

    //step 48 new
    DRV_WriteReg32(NET2PLL_CON2, 0x810F6276);  //800Mhz

    //step 48 New
    DRV_WriteReg32(WEDMCUPLL_CON2, 0x821D3B13);  //760Mhz

    //step 48 new
    DRV_WriteReg32(MEDMCUPLL_CON2, 0x82164EC4);  //580Mhz
/*
    //step 49
    DRV_WriteReg32(ADSPPLL_CON1, 0x821AEC4E); //700 MHz

    //step 50
    //DRV_WriteReg32(APUPLL_CON1, 0x8110589D); //850 MHz
    DRV_WriteReg32(APUPLL_CON1, 0x8010589D); //1700/2 MHz = 850M
*/
    //step 51
    DRV_WriteReg32(APLL1_CON2, 0x84000000); //180.6336MHz
    DRV_WriteReg32(APLL1_CON3, 0x6F28BD4C); //180.6336MHz

    //step 52
    DRV_WriteReg32(APLL2_CON2, 0x84000000); //196.608MHz
    DRV_WriteReg32(APLL2_CON3, 0x78FD5265); //196.608MHz
/*
    //step 53
    DRV_WriteReg32(APLL1_CON0, 0x80000180);

    //step 54
    DRV_WriteReg32(APLL2_CON0, 0x80000180);
*/
    //step 55: CPU SPEED*****
    DRV_WriteReg32(ARMPLL_LL_CON2, 0x81133B13); // 1000 Mhz, need confirm with opp table
    //DRV_WriteReg32(ARMPLL_LL_CON1, 0x81142762); // 1048Mhz
    //DRV_WriteReg32(ARMPLL_LL_CON2, 0x80133B13); // 2000Mhz
/*
    //step 56
    DRV_WriteReg32(ARMPLL_BL0_CON1, 0x821C13B1); // 730M, need confirm with opp table
    //step 57
    DRV_WriteReg32(ARMPLL_BL1_CON1, 0x821C13B1); // 730M, need confirm with opp table
    //step 58
    DRV_WriteReg32(ARMPLL_BL2_CON1, 0x821C13B1); // 730M, need confirm with opp table
    //step 59
    DRV_WriteReg32(ARMPLL_BL3_CON1, 0x821C13B1); // 730M, need confirm with opp table
*/
    //step 60
    //DRV_WriteReg32(CCIPLL_CON2, 0x821EC4EC); // 800MHz, need confirm with opp table
    DRV_WriteReg32(CCIPLL_CON2, 0x821AEC4E); // 700MHz, need confirm with opp table

    /***********************
     * xPLL Frequency Enable
     ************************/
    //step 61
    temp = DRV_Reg32(MFGPLL_CON0);
    DRV_WriteReg32(MFGPLL_CON0, temp | 0x200);

    //step 62
    //temp = DRV_Reg32(MPLL_CON0);
    //DRV_WriteReg32(MPLL_CON0, temp | 0x200);

    //step 63
    temp = DRV_Reg32(MAINPLL_CON0);
    DRV_WriteReg32(MAINPLL_CON0, temp | 0x200);

    //step 64
    temp = DRV_Reg32(UNIVPLL_CON0);
    DRV_WriteReg32(UNIVPLL_CON0, temp | 0x200);

    //step 65
    temp = DRV_Reg32(MSDCPLL_CON0);
    DRV_WriteReg32(MSDCPLL_CON0, temp | 0x200);

    //step 66
    temp = DRV_Reg32(MMPLL_CON0);
    DRV_WriteReg32(MMPLL_CON0, temp | 0x200);

    //step 67
    temp = DRV_Reg32(SGMIIPLL_CON0);
    DRV_WriteReg32(SGMIIPLL_CON0,  temp | 0x200);

    //step 67 new
    temp = DRV_Reg32(NET1PLL_CON0);
    DRV_WriteReg32(NET1PLL_CON0,  temp | 0x200);

    //step 67 new
    temp = DRV_Reg32(NET2PLL_CON0);
    DRV_WriteReg32(NET2PLL_CON0,  temp | 0x200);

    //step 67 New
    temp = DRV_Reg32(WEDMCUPLL_CON0);
    DRV_WriteReg32(WEDMCUPLL_CON0,  temp | 0x200);

    //step 67 new
    temp = DRV_Reg32(MEDMCUPLL_CON0);
    DRV_WriteReg32(MEDMCUPLL_CON0,  temp | 0x200);
/*
    //step 68
    temp = DRV_Reg32(ADSPPLL_CON0);
    DRV_WriteReg32(ADSPPLL_CON0, temp | 0x1);

    //step 69
    temp = DRV_Reg32(APUPLL_CON0);
    DRV_WriteReg32(APUPLL_CON0, temp | 0x1);
*/
    //step 70
    temp = DRV_Reg32(APLL1_CON0);
    DRV_WriteReg32(APLL1_CON0, temp | 0x200);

    //step 71
    temp = DRV_Reg32(APLL2_CON0);
    DRV_WriteReg32(APLL2_CON0, temp | 0x200);

    //step 72
    temp = DRV_Reg32(ARMPLL_LL_CON0);
    DRV_WriteReg32(ARMPLL_LL_CON0, temp | 0x200);
/*
    //step 73
    temp = DRV_Reg32(ARMPLL_BL0_CON0);
    DRV_WriteReg32(ARMPLL_BL0_CON0, temp | 0x1);
    //step 74
    temp = DRV_Reg32(ARMPLL_BL1_CON0);
    DRV_WriteReg32(ARMPLL_BL1_CON0, temp | 0x1);
    //step 75
    temp = DRV_Reg32(ARMPLL_BL2_CON0);
    DRV_WriteReg32(ARMPLL_BL2_CON0, temp | 0x1);
    //step 76
    temp = DRV_Reg32(ARMPLL_BL3_CON0);
    DRV_WriteReg32(ARMPLL_BL3_CON0, temp | 0x1);
*/
    //step 77
    temp = DRV_Reg32(CCIPLL_CON0);
    DRV_WriteReg32(CCIPLL_CON0, temp | 0x200);

    // step 78
    gpt_busy_wait_us(20); // wait for PLL stable (min delay is 20us)

    // step XXX
    temp = DRV_Reg32(MAINPLL_CON0);
    DRV_WriteReg32(MAINPLL_CON0, temp | 0xFF000000); //[31]~[24]=1: Turn on MAINPLL DIV 2/3/4/5/6/7/8/9

    // step XXX
    temp = DRV_Reg32(UNIVPLL_CON0);
    DRV_WriteReg32(UNIVPLL_CON0, temp | 0xFF000000); //[31]~[24]=1: Turn on UNIVPLL DIV 2/3/4/5/6/7/8/9

    // step XXX
    temp = DRV_Reg32(MMPLL_CON0);
    DRV_WriteReg32(MMPLL_CON0, temp | 0xFF000000); //[31]~[24]=1: Turn on MMPLL DIV 2/3/4/5/6/7/8/9

    // step XXX
    gpt_busy_wait_us(20); // wait for PLL stable (min delay is 20us)

    /***************
      * xPLL DIV RSTB
      ****************/
    //step 79
    /*
     * for MT6885, the rstb_en bit of syspll is turned off by BROM force download mode,
     * So we also turn it on back in preloader. (for all plls actually)
     */
    temp = DRV_Reg32(MAINPLL_CON0);
    DRV_WriteReg32(MAINPLL_CON0, temp | 0x00800000);

    //step 80
    temp = DRV_Reg32(UNIVPLL_CON0);
    DRV_WriteReg32(UNIVPLL_CON0, temp | 0x00800000);

    //step 81
    temp = DRV_Reg32(MMPLL_CON0);
    DRV_WriteReg32(MMPLL_CON0, temp | 0x00800000);

    //step 82
    //temp = DRV_Reg32(PLLON_CON1);		/* MT6885: not necessary  */
    //DRV_WriteReg32(PLLON_CON1, temp & 0xffbfffff);

    /*****************
     * xPLL HW Control
     ******************/

    /**************
     * INFRA CPU CLKMUX, CLK Div
     ***************/

    //8: div1, A: div2, B: div4, 1D: div6
    temp = DRV_Reg32(CPU_PLLDIV_CFG0) ;
    DRV_WriteReg32(CPU_PLLDIV_CFG0, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1
/*
    temp = DRV_Reg32(CPU_PLLDIV_CFG1) ;
    DRV_WriteReg32(CPU_PLLDIV_CFG1, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1

    temp = DRV_Reg32(CPU_PLLDIV_CFG2) ;
    DRV_WriteReg32(CPU_PLLDIV_CFG2, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1

    temp = DRV_Reg32(CPU_PLLDIV_CFG3) ;
    DRV_WriteReg32(CPU_PLLDIV_CFG3, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1

    temp = DRV_Reg32(CPU_PLLDIV_CFG4) ;
    DRV_WriteReg32(CPU_PLLDIV_CFG4, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1
*/
    temp = DRV_Reg32(BUS_PLLDIV_CFG) ;
    DRV_WriteReg32(BUS_PLLDIV_CFG, (temp & 0xFFC1FFFF) | (0x08 << 17)); // [21:17] divsel: CPU clock divide by 1

    //0: 26M,  1: armpll, 2:  Mainpll, 3:  Unipll
    temp = DRV_Reg32(CPU_PLLDIV_CFG0);
    DRV_WriteReg32(CPU_PLLDIV_CFG0, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed
/*
    temp = DRV_Reg32(CPU_PLLDIV_CFG1);
    DRV_WriteReg32(CPU_PLLDIV_CFG1, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed

    temp = DRV_Reg32(CPU_PLLDIV_CFG2);
    DRV_WriteReg32(CPU_PLLDIV_CFG2, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed

    temp = DRV_Reg32(CPU_PLLDIV_CFG3);
    DRV_WriteReg32(CPU_PLLDIV_CFG3, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed

    temp = DRV_Reg32(CPU_PLLDIV_CFG4);
    DRV_WriteReg32(CPU_PLLDIV_CFG4, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed
*/
    temp = DRV_Reg32(BUS_PLLDIV_CFG);
    DRV_WriteReg32(BUS_PLLDIV_CFG, (temp & 0xFFFFF9FF) | (0x01 << 9)); // [10:9] muxsel: switch to PLL speed

    /************
     * TOP CLKMUX
     *************/
    /* MT6885. At infra_ao, rg_axi_dcm_dis_en = 1 , rg_pllck_sel_no_spm = 1 ask */
    DRV_WriteReg32(INFRA_BUS_DCM_CTRL, DRV_Reg32(INFRA_BUS_DCM_CTRL) | (1 << 21) | (1 << 22));

    /* For MT6885 SPM request, must be initialized in preloader.  ask */
    temp = DRV_Reg32(CLK_SCP_CFG_0);
    DRV_WriteReg32(CLK_SCP_CFG_0, (temp | 0x3FF));
    temp = DRV_Reg32(CLK_SCP_CFG_1);
#ifdef SLT
    DRV_WriteReg32(CLK_SCP_CFG_1, (temp & 0xFFFFEFF3) | 0x3);
#else
    DRV_WriteReg32(CLK_SCP_CFG_1, (temp & 0xFFFFEFF3) | 0x2003);
#endif

    temp = DRV_Reg32(PLLON_CON0);
    DRV_WriteReg32(PLLON_CON0, (temp & 0xFD7EBF5F)); //bit 5 7 14 16 23 25 set to 0
    temp = DRV_Reg32(PLLON_CON1);
    DRV_WriteReg32(PLLON_CON1, (temp & 0xFD7FFFFF)); //bit 23 25 set to 0
    temp = DRV_Reg32(PLLON_CON2);
    DRV_WriteReg32(PLLON_CON2, (temp & 0xFDFFFFFF)); //bit 25 set to 0

    // config AXI clock first 156M
    DRV_WriteReg32(CLK_CFG_0_CLR, 0x00000003);
    DRV_WriteReg32(CLK_CFG_0_SET, 0x00000002);  // axi
    DRV_WriteReg32(CLK_CFG_UPDATE, 0x00000001); // update AXI clock

    DRV_WriteReg32(CLK_CFG_0_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_0_SET, 0x02010201);  //axi change

    DRV_WriteReg32(CLK_CFG_1_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_1_SET, 0x01010003);

    DRV_WriteReg32(CLK_CFG_2_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_2_SET, 0x03010104);  //msdc change

    DRV_WriteReg32(CLK_CFG_3_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_3_SET, 0x00010103);

    DRV_WriteReg32(CLK_CFG_4_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_4_SET, 0x02010101);  //pwrmcu change

    DRV_WriteReg32(CLK_CFG_5_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_5_SET, 0x01020101);

    DRV_WriteReg32(CLK_CFG_6_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_6_SET, 0x00000103);  //dpmaif change

    DRV_WriteReg32(CLK_CFG_7_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_7_SET, 0x04000200);  //gcpu change

    DRV_WriteReg32(CLK_CFG_8_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_8_SET, 0x06010606);  //spi spis ecc change

    DRV_WriteReg32(CLK_CFG_9_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_9_SET, 0x00040407);  //netsys medsys change, 0712 reversed

    DRV_WriteReg32(CLK_CFG_10_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_10_SET, 0x01010700); //eip97 change

    DRV_WriteReg32(CLK_CFG_11_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_11_SET, 0x04010101); //netsys_med change, 0712 reversed

    DRV_WriteReg32(CLK_CFG_12_CLR, 0xFFFFFFFF);
    DRV_WriteReg32(CLK_CFG_12_SET, 0x01010404); //netsys_wed netsys_2x change, 0712 reversed

    DRV_WriteReg32(CLK_CFG_UPDATE, 0xFFFFFFFE); //update all clocks except "axi"
    DRV_WriteReg32(CLK_CFG_UPDATE1, 0xFFFFFFFF);


#if 1  //ask
    temp = DRV_Reg32(CLK_MISC_CFG_0);
    DRV_WriteReg32(CLK_MISC_CFG_0, (temp | 0x0004000)); // enable [14] dramc_pll104m_ck
#endif

    /************
     * MTCMOS
     *************/

#if CLKMGR_BRINGUP
    /*for CG*/
    DRV_WriteReg32(INFRA_PDN_CLR0, 0x1BFFFFFF);// bit 26 29 30 31 are empty

    DRV_WriteReg32(INFRA_PDN_CLR1, 0xE79DBBD6);// bit 28 27 22 21 17 5 3 0 are empty 10 14 gating, add bit 6
    DRV_WriteReg32(INFRA_PDN_SET1, 0x00004400);// bit 14: auxadc_md_cg clk gating. bit 27, 28: dxcc clk gating. ask
    DRV_WriteReg32(INFRA_PDN_CLR2, 0x8FFFFEFE);// bit 30 29 28 26 25 8 0 is empty, add bit 1
    DRV_WriteReg32(INFRA_PDN_CLR3, 0x3FFFCFDF);// bit 31 30 13 12 5 is empty
#ifdef SLT
    DRV_WriteReg32(INFRA_PDN_CLR4, 0xCFFFFBFF);// bit 29 28 10 is empty 16 15 14 en
#else
    DRV_WriteReg32(INFRA_PDN_CLR4, 0xCFFE3BFF);// bit 29 28 10 is empty 16 15 14 en
#endif

    DRV_WriteReg32(INFRA_PDN_SET4, 0x0001C000);// bit 16 15 14 is en
    print("Pll init Done!!\n");
#endif

#if 1
    print("mtcmos Start..\n");
    spm_mtcmos_ctrl_md1(STA_POWER_ON);
    spm_mtcmos_ctrl_hsmtop(STA_POWER_DOWN);
    //spm_mtcmos_ctrl_dis(STA_POWER_ON);
    //spm_mtcmos_ctrl_mdp(STA_POWER_ON);
    /*spm_mtcmos_ctrl_md1(STA_POWER_ON);
    spm_mtcmos_ctrl_conn(STA_POWER_ON);
    spm_mtcmos_ctrl_mfg0(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_d_2lx1_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_r_2lx1_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_r_1lx2_0p_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_r_1lx2_1p_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_ssusb_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_sgmii_0_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_ifr(STA_POWER_ON);
    spm_mtcmos_ctrl_sgmii_1_phy(STA_POWER_ON);
    spm_mtcmos_ctrl_dpy(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_d_2lx1(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_r_2lx1(STA_POWER_ON);
    spm_mtcmos_ctrl_pextp_r_1lx2(STA_POWER_ON);
    spm_mtcmos_ctrl_eth(STA_POWER_ON);
    spm_mtcmos_ctrl_ssusb(STA_POWER_ON);
    spm_mtcmos_ctrl_sgmii_0_top(STA_POWER_ON);
    spm_mtcmos_ctrl_sgmii_1_top(STA_POWER_ON);
    spm_mtcmos_ctrl_netsys(STA_POWER_ON);
    spm_mtcmos_ctrl_dis(STA_POWER_ON);
    spm_mtcmos_ctrl_audio(STA_POWER_ON);
    spm_mtcmos_ctrl_eip97(STA_POWER_ON);
    spm_mtcmos_ctrl_hsmtop(STA_POWER_ON);
    spm_mtcmos_ctrl_dramc_md32(STA_POWER_ON);
    spm_mtcmos_ctrl_dpy2(STA_POWER_ON);
    spm_mtcmos_ctrl_mcupm(STA_POWER_ON);
    spm_mtcmos_ctrl_msdc(STA_POWER_ON);
    spm_mtcmos_ctrl_peri(STA_POWER_ON);*/
    print("mtcmos Done!\n");

#if defined(_FLASH_MODE_DA_)
    pal_log_err("PLL DA mode\n");
#else
    /*DISP CG Clear and DCM disable*/
    pal_log_err("PLL Preloader mode\n");
    ret = spm_mtcmos_ctrl_dis(STA_POWER_ON);
    pal_log_err("PLL Preloader mode ret %d\n", ret);
	if (ret == 0) {
		DRV_WriteReg32(DISP_CG_CLR0, 0x0003FFFF);
		DRV_WriteReg32(DISP_CG_CLR1, 0x00010001);
		DRV_WriteReg32(DISP_CG_CLR2, 0x1);
	}
#endif

#if CLKMGR_BRINGUP
    // MM CG Clear
    //DRV_WriteReg32(DISP_CG_CLR0, 0x0003FFFF);

#endif

#if CLKMGR_BRINGUP //ask
    /* Enable mipi 26M */
    temp = DRV_Reg32(AP_PLL_CON5);
    DRV_WriteReg32(AP_PLL_CON5, temp | 0x3 << 16); // [17:16] MIPID26M_EN
#endif


#endif
}
