/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <platform.h>
#include <typedefs.h>
#include <timer.h>
#include <irq.h>

#define TIMER_TICK_RATE 32768
#define MT_GPT_IRQ_ID   243

unsigned int mtk_oneshot_timer_get_irq_id()
{
  return MT_GPT_IRQ_ID;
}
void mtk_oneshot_timer_init(int interval) {
  mt_irq_set_sens(MT_GPT_IRQ_ID, MT65xx_LEVEL_SENSITIVE);
  mt_irq_set_polarity(MT_GPT_IRQ_ID, MT65xx_POLARITY_LOW);

  DRV_WriteReg32(GPT5_CON, GPT_CLEAR);
  DRV_WriteReg32(GPT_IRQACK, 0x10);
  DRV_WriteReg32(GPT5_CLK, 0x10);

  DRV_WriteReg32(GPT5_COMPARE, TIMER_TICK_RATE * interval / 1000);
  DRV_WriteReg32(GPT_IRQEN, 0x10);

  mt_irq_unmask(MT_GPT_IRQ_ID);
}

void mtk_oneshot_timer_ack_irq(void) {
    int i = 0;
    //static enum handler_return ret;

    /* ack GPT5 irq */
    /* configure gpt5 to use 13MHZ clock during irq ack.
        * Reason: In 32K domain, the de-assert signal to GIC might delay several clocks. So
        *         there must have delay between ack GTP5 irq and ack GIC irq. Ohterwise the
        *         irq will come twice at one tick point.
        *         Switching to 13M, ack gpt5 irq flow speeds up to avoid problem.
        */
    DRV_WriteReg32(GPT5_CLK , 0x00);
    DRV_WriteReg32(GPT_IRQACK, 0x10);
    DRV_WriteReg32(GPT5_CON, GPT_CLEAR);
    DRV_WriteReg32(GPT5_CON, GPT_DISABLE);
    /* make sure GPT5 irq is de-assert, the max delay should be less than 3T */
    while (i++ < 5 && (DRV_Reg32(GPT_IRQSTA) & 0x10 == 0x10))
        udelay(1);
    DRV_WriteReg32(GPT5_CLK , 0x10);

    /*
     * CAUTION! The de-assert signal to GIC might delay serveral clocks.
     * Here must have enough delay to make sure the GPT signal had arrived GIC.
     */
    /* ack GIC irq */
    mt_irq_ack(MT_GPT_IRQ_ID);
}

void mtk_oneshot_timer_enable(void) {
    DRV_WriteReg32(GPT5_CON, GPT_ENABLE|GPT_MODE_ONE_SHOT);
}
